#!/bin/bash
set -e

echo "🚀 Running semantic-release prepare script..."

# Get the new version from command line argument
NEW_VERSION="$1"

if [ -z "$NEW_VERSION" ]; then
    echo "❌ Error: NEW_VERSION is not provided as first argument. This script should be run by semantic-release."
    exit 1
fi

echo "📝 Updating version to: $NEW_VERSION"

# Update the VERSION file
echo "$NEW_VERSION" > VERSION
echo "✅ Updated VERSION file"

# Update go bindings download tool
sed -i.bak "s/^const Version = \".*\"/const Version = \"$NEW_VERSION\"/" "bindings/go/cmd/libparser-download/main.go"
echo "✅ Updated bindings/go/cmd/libparser-download/main.go"

echo "🎉 All packages updated to $NEW_VERSION!" 
