# Generated by Django 5.2.10 on 2026-01-31 22:14

import django.db.models.deletion
from django.db import migrations, models


def copy_fk_identifiers(apps, schema_editor):
    HiddenPeer = apps.get_model("peeringdb", "HiddenPeer")
    for hidden_peer in HiddenPeer.objects.select_related(
        "peeringdb_network", "peeringdb_ixlan"
    ).all():
        hidden_peer.peeringdb_network_id_copy = hidden_peer.peeringdb_network.pk
        hidden_peer.peeringdb_ixlan_id_copy = hidden_peer.peeringdb_ixlan.pk
        hidden_peer.save(
            update_fields=["peeringdb_network_id_copy", "peeringdb_ixlan_id_copy"]
        )


class Migration(migrations.Migration):
    dependencies = [("peeringdb", "0032_hiddenpeer")]

    operations = [
        migrations.AddField(
            model_name="hiddenpeer",
            name="peeringdb_ixlan_id_copy",
            field=models.PositiveBigIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="hiddenpeer",
            name="peeringdb_network_id_copy",
            field=models.PositiveBigIntegerField(blank=True, null=True),
        ),
        migrations.RunPython(copy_fk_identifiers, migrations.RunPython.noop),
        migrations.AlterField(
            model_name="hiddenpeer",
            name="peeringdb_ixlan",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="hidden_peers",
                to="peeringdb.ixlan",
            ),
        ),
        migrations.AlterField(
            model_name="hiddenpeer",
            name="peeringdb_network",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="hidden_on",
                to="peeringdb.network",
            ),
        ),
        migrations.RemoveConstraint(
            model_name="hiddenpeer", name="network_ixlan_unique_hiddenpeer"
        ),
        migrations.AddConstraint(
            model_name="hiddenpeer",
            constraint=models.UniqueConstraint(
                fields=["peeringdb_network_id_copy", "peeringdb_ixlan_id_copy"],
                name="network_ixlan_unique_hiddenpeer",
            ),
        ),
    ]
