# Generated by Django 4.2.11 on 2024-04-05 21:25

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("core", "0004_datasource_and_datafile"),
        ("peering", "0100_bgp_session_accepted_prefix_count"),
    ]

    operations = [
        migrations.AddField(
            model_name="router",
            name="data_file",
            field=models.ForeignKey(
                blank=True,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="core.datafile",
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="data_path",
            field=models.CharField(
                blank=True,
                help_text="Path to the remote file, relative to its data source root",
                max_length=1000,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="data_pushed",
            field=models.DateTimeField(blank=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name="router",
            name="data_source",
            field=models.ForeignKey(
                blank=True,
                help_text="Remote data source",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="core.datasource",
            ),
        ),
        migrations.AlterModelOptions(
            name="router",
            options={
                "ordering": ["local_autonomous_system", "name"],
                "permissions": [
                    ("view_router_configuration", "Can view router's configuration"),
                    (
                        "deploy_router_configuration",
                        "Can deploy router's configuration",
                    ),
                    (
                        "push_router_configuration_to_data_source",
                        "Can push router's configuration on a data source",
                    ),
                ],
            },
        ),
    ]
