# Generated by Django 3.2.11 on 2022-01-12 20:52

from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [("peering", "0084_move_configuration_to_devices")]

    def cleanup_object_changes(apps, schema_editor):
        ContentType = apps.get_model("contenttypes", "ContentType")
        Configuration = apps.get_model("peering.Configuration")
        ConfigurationType = ContentType.objects.get_for_model(Configuration)
        ObjectChange = apps.get_model("utils.ObjectChange")

        ObjectChange.objects.using(schema_editor.connection.alias).filter(
            changed_object_type=ConfigurationType
        )._raw_delete(schema_editor.connection.alias)

    operations = [
        migrations.RunPython(cleanup_object_changes, migrations.RunPython.noop),
        migrations.RemoveField(model_name="router", name="configuration_template"),
        migrations.DeleteModel(name="Configuration"),
        migrations.RenameField(
            model_name="router",
            old_name="configuration",
            new_name="configuration_template",
        ),
    ]
