# Generated by Django 3.1.6 on 2021-02-12 17:50

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("devices", "0001_initial"),
        ("peering", "0068_router_device_state"),
    ]

    def move_to_platform_objects(apps, schema_editor):
        db_alias = schema_editor.connection.alias
        Platform = apps.get_model("devices.Platform")
        Router = apps.get_model("peering.Router")

        for p in Platform.objects.using(db_alias).all():
            Router.objects.using(db_alias).filter(platform=p.napalm_driver).update(
                platform_fk=p
            )

    operations = [
        migrations.AddField(
            model_name="router",
            name="platform_fk",
            field=models.ForeignKey(
                blank=True,
                help_text="The router platform, used to interact with it",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="devices.platform",
            ),
        ),
        migrations.RunPython(move_to_platform_objects),
        migrations.RemoveField(model_name="router", name="platform"),
        migrations.RenameField(
            model_name="router", old_name="platform_fk", new_name="platform"
        ),
    ]
