# Generated by Django 3.1.5 on 2021-01-12 12:18

from django.conf import settings
from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [("peering", "0066_auto_20201212_2301")]

    def set_local_autonomous_system(apps, schema_editor):
        db_alias = schema_editor.connection.alias

        my_asn = getattr(settings, "MY_ASN", None)
        if my_asn is None:
            # First setup, old MY_ASN setting is not used
            return

        # Get AS or create it with placeholders
        AutonomousSystem = apps.get_model("peering", "AutonomousSystem")
        try:
            my_asn = AutonomousSystem.objects.using(db_alias).get(asn=my_asn)
        except AutonomousSystem.DoesNotExist:
            my_asn = AutonomousSystem.objects.using(db_alias).create(
                asn=my_asn,
                name="[[REPLACE ME]]",
                comments="Auto-generated during multi-AS support migration",
                affiliated=True,
            )

        # Set local AS for direct sessions
        DirectPeeringSession = apps.get_model("peering", "DirectPeeringSession")
        DirectPeeringSession.objects.using(db_alias).filter(
            local_autonomous_system=None
        ).update(local_autonomous_system=my_asn)

        # Same thing for IXPs
        InternetExchange = apps.get_model("peering", "InternetExchange")
        InternetExchange.objects.using(db_alias).filter(
            local_autonomous_system=None
        ).update(local_autonomous_system=my_asn)

        # Same thing for Routers
        Router = apps.get_model("peering", "Router")
        Router.objects.using(db_alias).filter(local_autonomous_system=None).update(
            local_autonomous_system=my_asn
        )

    operations = [migrations.RunPython(set_local_autonomous_system)]
