# Generated by Django 2.2.7 on 2019-11-13 20:51

import django.contrib.postgres.fields
import django.db.models.deletion
import netfields.fields
import taggit.managers
from django.db import migrations, models

import bgp.fields
import peering.fields
import utils.validators


class Migration(migrations.Migration):
    def forward_transition_from_none_to_zero(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": None, "ipv6_max_prefixes": None},
                "updates": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
            },
            "DirectPeeringSession": {
                "filters": {
                    "advertised_prefix_count": None,
                    "received_prefix_count": None,
                },
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": None},
                "updates": {"peeringdb_id": 0},
            },
            "InternetExchangePeeringSession": {
                "filters": {
                    "advertised_prefix_count": None,
                    "received_prefix_count": None,
                },
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models.items():
            model = apps.get_model("peering", key)
            model.objects.using(db_alias).filter(**value["filters"]).update(
                **value["updates"]
            )

    def reverse_transition_from_none_to_zero(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
                "updates": {"ipv4_max_prefixes": None, "ipv6_max_prefixes": None},
            },
            "DirectPeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {
                    "advertised_prefix_count": None,
                    "received_prefix_count": None,
                },
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": 0},
                "updates": {"peeringdb_id": None},
            },
            "InternetExchangePeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {
                    "advertised_prefix_count": None,
                    "received_prefix_count": None,
                },
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models:
            model = apps.get_model("peering", key)
            for field in value:
                model.objects.using(db_alias).filter(**value["filters"]).update(
                    **value["updates"]
                )

    def forward_transition_from_minus_one_to_zero(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": -1, "ipv6_max_prefixes": -1},
                "updates": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
            },
            "DirectPeeringSession": {
                "filters": {"advertised_prefix_count": -1, "received_prefix_count": -1},
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": -1},
                "updates": {"peeringdb_id": 0},
            },
            "InternetExchangePeeringSession": {
                "filters": {"advertised_prefix_count": -1, "received_prefix_count": -1},
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models.items():
            model = apps.get_model("peering", key)
            model.objects.using(db_alias).filter(**value["filters"]).update(
                **value["updates"]
            )

    def reverse_transition_from_minus_one_to_zero(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
                "updates": {"ipv4_max_prefixes": -1, "ipv6_max_prefixes": -1},
            },
            "DirectPeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {"advertised_prefix_count": -1, "received_prefix_count": -1},
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": 0},
                "updates": {"peeringdb_id": -1},
            },
            "InternetExchangePeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {"advertised_prefix_count": -1, "received_prefix_count": -1},
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models:
            model = apps.get_model("peering", key)
            for field in value:
                model.objects.using(db_alias).filter(**value["filters"]).update(
                    **value["updates"]
                )

    def forward_transition_from_none_to_empty_list(apps, schema_editor):
        AutonomousSystem = apps.get_model("peering", "AutonomousSystem")
        db_alias = schema_editor.connection.alias
        AutonomousSystem.objects.using(db_alias).filter(
            potential_internet_exchange_peering_sessions=None
        ).update(potential_internet_exchange_peering_sessions=[])

    def reverse_transition_from_none_to_empty_list(apps, schema_editor):
        AutonomousSystem = apps.get_model("peering", "AutonomousSystem")
        db_alias = schema_editor.connection.alias
        AutonomousSystem.objects.using(db_alias).filter(
            potential_internet_exchange_peering_sessions=[]
        ).update(potential_internet_exchange_peering_sessions=None)

    def add_permissions(apps, schema_editor):
        pass

    def remove_permissions(apps, schema_editor):
        """Reverse the above additions of permissions."""
        ContentType = apps.get_model("contenttypes.ContentType")
        Permission = apps.get_model("auth.Permission")

        try:
            content_type = ContentType.objects.get(
                model="internetexchange", app_label="peering"
            )
            Permission.objects.filter(
                content_type=content_type,
                codename__in=("view_configuration", "deploy_configuration"),
            ).delete()
        except ContentType.DoesNotExist:
            pass

    replaces = [
        ("peering", "0001_initial"),
        ("peering", "0002_auto_20170820_1809"),
        ("peering", "0003_auto_20170903_1235"),
        ("peering", "0004_auto_20171004_2323"),
        ("peering", "0005_auto_20171014_1427"),
        ("peering", "0006_auto_20171017_1917"),
        ("peering", "0007_auto_20171202_1900"),
        ("peering", "0008_auto_20171212_2251"),
        ("peering", "0009_auto_20171226_1550"),
        ("peering", "0010_auto_20171228_0158"),
        ("peering", "0011_auto_20180329_2146"),
        ("peering", "0012_auto_20180502_1733"),
        ("peering", "0013_auto_20180505_1545"),
        ("peering", "0014_auto_20180519_2128"),
        ("peering", "0015_peeringsession_password"),
        ("peering", "0016_auto_20180726_1307"),
        ("peering", "0017_auto_20180802_2309"),
        ("peering", "0018_auto_20181014_1612"),
        ("peering", "0019_router_netbox_device_id"),
        ("peering", "0020_auto_20181105_0850"),
        ("peering", "0021_auto_20181113_2136"),
        ("peering", "0022_auto_20181116_2226"),
        ("peering", "0023_auto_20181208_2202"),
        ("peering", "0024_auto_20181212_2106"),
        ("peering", "0025_auto_20181212_2322"),
        (
            "peering",
            "0026_autonomoussystem_potential_internet_exchange_peering_sessions",
        ),
        ("peering", "0027_auto_20190105_1600"),
        ("peering", "0028_internetexchangepeeringsession_is_router_server"),
        ("peering", "0029_auto_20190114_2141"),
        ("peering", "0030_directpeeringsession_router"),
        ("peering", "0031_auto_20190227_2210"),
        ("peering", "0032_auto_20190302_1415"),
        ("peering", "0033_router_encrypt_passwords"),
        ("peering", "0034_auto_20190308_1954"),
        ("peering", "0035_auto_20190311_2334"),
        ("peering", "0036_auto_20190411_2209"),
        ("peering", "0037_auto_20190412_2102"),
        ("peering", "0038_auto_20190412_2233"),
        ("peering", "0039_routingpolicy_address_family"),
        ("peering", "0040_auto_20190417_1851"),
        ("peering", "0041_auto_20190430_1743"),
        ("peering", "0042_auto_20190509_1439"),
        ("peering", "0043_router_use_netbox"),
        ("peering", "0044_auto_20190513_2153"),
        ("peering", "0045_auto_20190514_2308"),
        ("peering", "0046_auto_20190608_2215"),
        ("peering", "0047_auto_20190619_1434"),
        ("peering", "0048_auto_20190707_1854"),
        ("peering", "0049_auto_20190731_1946"),
        ("peering", "0050_auto_20190806_2159"),
        ("peering", "0051_auto_20190818_1816"),
        ("peering", "0052_auto_20190818_1926"),
        ("peering", "0053_auto_20190921_2000"),
        ("peering", "0054_auto_20191031_2241"),
        ("peering", "0055_auto_20191110_1312"),
    ]

    initial = True

    dependencies = [
        ("taggit", "0003_taggeditem_add_unique_index"),
        ("utils", "0001_v1.0.0"),
    ]

    operations = [
        migrations.CreateModel(
            name="AutonomousSystem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("asn", peering.fields.ASNField(unique=True)),
                ("name", models.CharField(max_length=128)),
                ("comment", models.TextField(blank=True)),
                (
                    "ipv6_max_prefixes",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                (
                    "ipv4_max_prefixes",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("irr_as_set", models.CharField(blank=True, max_length=255, null=True)),
                ("ipv4_max_prefixes_peeringdb_sync", models.BooleanField(default=True)),
                ("ipv6_max_prefixes_peeringdb_sync", models.BooleanField(default=True)),
                ("irr_as_set_peeringdb_sync", models.BooleanField(default=True)),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
            ],
            options={"ordering": ["asn"]},
        ),
        migrations.CreateModel(
            name="ConfigurationTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("template", models.TextField()),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("comment", models.TextField(blank=True)),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
            ],
            options={"ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="Router",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("hostname", models.CharField(max_length=256)),
                (
                    "platform",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("junos", "Juniper JUNOS"),
                            ("iosxr", "Cisco IOS-XR"),
                            ("ios", "Cisco IOS"),
                            ("nxos", "Cisco NX-OS"),
                            ("eos", "Arista EOS"),
                            (None, "Other"),
                        ],
                        help_text="The router platform, used to interact with it",
                        max_length=50,
                    ),
                ),
                ("comment", models.TextField(blank=True)),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "netbox_device_id",
                    models.PositiveIntegerField(blank=True, default=0),
                ),
            ],
            options={"ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="Community",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("value", bgp.fields.CommunityField(max_length=50)),
                ("comment", models.TextField(blank=True)),
                (
                    "type",
                    models.CharField(
                        choices=[("egress", "Egress"), ("ingress", "Ingress")],
                        default="ingress",
                        max_length=50,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={"verbose_name_plural": "communities", "ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="RoutingPolicy",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=128)),
                ("slug", models.SlugField(unique=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("import-policy", "Import"),
                            ("export-policy", "Export"),
                        ],
                        default="import-policy",
                        max_length=50,
                    ),
                ),
                ("comment", models.TextField(blank=True)),
            ],
            options={"verbose_name_plural": "routing policies", "ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="InternetExchange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("slug", models.SlugField(unique=True)),
                ("comment", models.TextField(blank=True)),
                (
                    "configuration_template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="peering.ConfigurationTemplate",
                    ),
                ),
                ("ipv4_address", models.GenericIPAddressField(blank=True, null=True)),
                ("ipv6_address", models.GenericIPAddressField(blank=True, null=True)),
                (
                    "router",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="peering.Router",
                    ),
                ),
                (
                    "communities",
                    models.ManyToManyField(blank=True, to="peering.Community"),
                ),
                ("peeringdb_id", models.PositiveIntegerField(blank=True, null=True)),
                ("check_bgp_session_states", models.BooleanField(default=False)),
                (
                    "bgp_session_states_update",
                    models.DateTimeField(blank=True, null=True),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "export_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_export_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
                (
                    "import_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_import_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
            ],
            options={"ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="DirectPeeringSession",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("ip_address", models.GenericIPAddressField()),
                ("password", models.CharField(blank=True, max_length=255, null=True)),
                ("enabled", models.BooleanField(default=True)),
                (
                    "bgp_state",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("idle", "Idle"),
                            ("connect", "Connect"),
                            ("active", "Active"),
                            ("opensent", "OpenSent"),
                            ("openconfirm", "OpenConfirm"),
                            ("established", "Established"),
                        ],
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "received_prefix_count",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                (
                    "advertised_prefix_count",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("comment", models.TextField(blank=True)),
                ("local_asn", peering.fields.ASNField(default=0)),
                (
                    "relationship",
                    models.CharField(
                        choices=[
                            ("private-peering", "Private Peering"),
                            ("transit-provider", "Transit Provider"),
                            ("customer", "Customer"),
                        ],
                        help_text="Relationship with the remote peer.",
                        max_length=50,
                    ),
                ),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="peering.AutonomousSystem",
                    ),
                ),
                ("last_established_state", models.DateTimeField(blank=True, null=True)),
                (
                    "export_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_export_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
                (
                    "import_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_import_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="InternetExchangePeeringSession",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("ip_address", models.GenericIPAddressField()),
                ("comment", models.TextField(blank=True)),
                (
                    "autonomous_system",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="peering.AutonomousSystem",
                    ),
                ),
                (
                    "internet_exchange",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="peering.InternetExchange",
                    ),
                ),
                ("enabled", models.BooleanField(default=True)),
                (
                    "bgp_state",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("idle", "Idle"),
                            ("connect", "Connect"),
                            ("active", "Active"),
                            ("opensent", "OpenSent"),
                            ("openconfirm", "OpenConfirm"),
                            ("established", "Established"),
                        ],
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "advertised_prefix_count",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                (
                    "received_prefix_count",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("password", models.CharField(blank=True, max_length=255, null=True)),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("last_established_state", models.DateTimeField(blank=True, null=True)),
                (
                    "export_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_export_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
                (
                    "import_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_import_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
            ],
        ),
        migrations.RunPython(
            code=forward_transition_from_none_to_zero,
            reverse_code=reverse_transition_from_none_to_zero,
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="ipv4_max_prefixes",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="ipv6_max_prefixes",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="advertised_prefix_count",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="received_prefix_count",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="peeringdb_id",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="advertised_prefix_count",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="received_prefix_count",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.RunPython(
            code=forward_transition_from_minus_one_to_zero,
            reverse_code=reverse_transition_from_minus_one_to_zero,
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="potential_internet_exchange_peering_sessions",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.GenericIPAddressField(),
                blank=True,
                default=list,
                size=None,
            ),
        ),
        migrations.RunPython(
            code=forward_transition_from_none_to_empty_list,
            reverse_code=reverse_transition_from_none_to_empty_list,
        ),
        migrations.AddField(
            model_name="internetexchangepeeringsession",
            name="is_route_server",
            field=models.BooleanField(blank=True, default=False),
        ),
        migrations.AlterModelOptions(
            name="internetexchange",
            options={
                "ordering": ["name"],
                "permissions": [
                    (
                        "view_configuration",
                        "Can view Internet Exchange's configuration",
                    ),
                    (
                        "deploy_configuration",
                        "Can deploy Internet Exchange's configuration",
                    ),
                ],
            },
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="router",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.Router",
            ),
        ),
        migrations.AlterModelOptions(
            name="directpeeringsession",
            options={"ordering": ["autonomous_system", "ip_address"]},
        ),
        migrations.AlterModelOptions(
            name="internetexchangepeeringsession",
            options={"ordering": ["autonomous_system", "ip_address"]},
        ),
        migrations.AlterField(
            model_name="router",
            name="platform",
            field=models.CharField(
                blank=True,
                choices=[
                    ("junos", "Juniper JUNOS"),
                    ("iosxr", "Cisco IOS-XR"),
                    ("ios", "Cisco IOS"),
                    ("nxos", "Cisco NX-OS"),
                    ("eos", "Arista EOS"),
                    ("", "Other"),
                ],
                help_text="The router platform, used to interact with it",
                max_length=50,
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="encrypt_passwords",
            field=models.BooleanField(
                blank=True,
                default=True,
                help_text="Try to encrypt passwords in router's configuration",
            ),
        ),
        migrations.AlterModelOptions(
            name="routingpolicy",
            options={
                "ordering": ["-weight", "name"],
                "verbose_name_plural": "routing policies",
            },
        ),
        migrations.AddField(
            model_name="routingpolicy",
            name="weight",
            field=models.PositiveSmallIntegerField(
                default=0, help_text="The higher the number, the higher the priority"
            ),
        ),
        migrations.AlterField(
            model_name="routingpolicy",
            name="type",
            field=models.CharField(
                choices=[
                    ("export-policy", "Export"),
                    ("import-policy", "Import"),
                    ("import-export-policy", "Import and Export"),
                ],
                default="import-policy",
                max_length=50,
            ),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="contact_email",
            field=models.EmailField(
                blank=True, max_length=254, verbose_name="Contact E-mail"
            ),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="contact_name",
            field=models.CharField(blank=True, max_length=50),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="contact_phone",
            field=models.CharField(blank=True, max_length=20),
        ),
        migrations.AddField(
            model_name="routingpolicy",
            name="address_family",
            field=models.PositiveSmallIntegerField(
                choices=[(0, "All"), (4, "IPv4"), (6, "IPv6")], default=0
            ),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="potential_internet_exchange_peering_sessions",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=netfields.fields.InetAddressField(max_length=39),
                blank=True,
                default=list,
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="ip_address",
            field=netfields.fields.InetAddressField(max_length=39),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="ipv4_address",
            field=netfields.fields.InetAddressField(
                blank=True,
                max_length=39,
                null=True,
                validators=[utils.validators.AddressFamilyValidator(4)],
            ),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="ipv6_address",
            field=netfields.fields.InetAddressField(
                blank=True,
                max_length=39,
                null=True,
                validators=[utils.validators.AddressFamilyValidator(6)],
            ),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="ip_address",
            field=netfields.fields.InetAddressField(max_length=39),
        ),
        migrations.AlterField(
            model_name="routingpolicy",
            name="type",
            field=models.CharField(
                choices=[
                    ("export-policy", "Export"),
                    ("import-policy", "Import"),
                    ("import-export-policy", "Import+Export"),
                ],
                default="import-policy",
                max_length=50,
            ),
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="multihop_ttl",
            field=peering.fields.TTLField(
                blank=True,
                default=1,
                help_text="Use a value greater than 1 for BGP multihop sessions",
                verbose_name="Multihop TTL",
            ),
        ),
        migrations.AddField(
            model_name="internetexchangepeeringsession",
            name="multihop_ttl",
            field=peering.fields.TTLField(
                blank=True,
                default=1,
                help_text="Use a value greater than 1 for BGP multihop sessions",
                verbose_name="Multihop TTL",
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="use_netbox",
            field=models.BooleanField(
                blank=True,
                default=False,
                help_text="Use NetBox to communicate instead of NAPALM",
            ),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="export_routing_policies",
            field=models.ManyToManyField(
                blank=True,
                related_name="%(class)s_export_routing_policies",
                to="peering.routingpolicy",
            ),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="import_routing_policies",
            field=models.ManyToManyField(
                blank=True,
                related_name="%(class)s_import_routing_policies",
                to="peering.routingpolicy",
            ),
        ),
        migrations.CreateModel(
            name="BGPGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=128)),
                ("slug", models.SlugField(max_length=255, unique=True)),
                ("comments", models.TextField(blank=True)),
                (
                    "communities",
                    models.ManyToManyField(blank=True, to="peering.Community"),
                ),
                (
                    "export_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_export_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
                (
                    "import_routing_policies",
                    models.ManyToManyField(
                        blank=True,
                        related_name="%(class)s_import_routing_policies",
                        to="peering.routingpolicy",
                    ),
                ),
                (
                    "bgp_session_states_update",
                    models.DateTimeField(blank=True, null=True),
                ),
                ("check_bgp_session_states", models.BooleanField(default=False)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="taggit.TaggedItem",
                        to="taggit.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={"verbose_name": "BGP group", "ordering": ["name"]},
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="bgp_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.BGPGroup",
                verbose_name="BGP Group",
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="configuration_template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.ConfigurationTemplate",
            ),
        ),
        migrations.AlterModelOptions(
            name="router",
            options={
                "ordering": ["name"],
                "permissions": [
                    ("view_configuration", "Can view router's configuration"),
                    ("deploy_configuration", "Can deploy router's configuration"),
                ],
            },
        ),
        migrations.AlterField(
            model_name="router",
            name="encrypt_passwords",
            field=models.BooleanField(
                blank=True,
                default=False,
                help_text="Try to encrypt passwords for peering sessions",
            ),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="slug",
            field=models.SlugField(max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="routingpolicy",
            name="slug",
            field=models.SlugField(max_length=255, unique=True),
        ),
        migrations.RenameModel(old_name="ConfigurationTemplate", new_name="Template"),
        migrations.AddField(
            model_name="template",
            name="type",
            field=models.CharField(
                choices=[("configuration", "Configuration"), ("email", "E-mail")],
                default="configuration",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="configuration_template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.Template",
            ),
        ),
        migrations.AlterField(
            model_name="router",
            name="configuration_template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.Template",
            ),
        ),
        migrations.AlterModelOptions(
            name="community",
            options={
                "ordering": ["value", "name"],
                "verbose_name_plural": "communities",
            },
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="local_ip_address",
            field=netfields.fields.InetAddressField(
                blank=True, max_length=39, null=True
            ),
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="community",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="internetexchange",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="internetexchangepeeringsession",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="routingpolicy",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AddField(
            model_name="template",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.RenameField(
            model_name="autonomoussystem", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="community", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="directpeeringsession", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="internetexchange", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="internetexchangepeeringsession",
            old_name="comment",
            new_name="comments",
        ),
        migrations.RenameField(
            model_name="router", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="routingpolicy", old_name="comment", new_name="comments"
        ),
        migrations.RenameField(
            model_name="template", old_name="comment", new_name="comments"
        ),
        migrations.AlterModelOptions(name="internetexchange", options={}),
        migrations.RemoveField(
            model_name="internetexchange", name="configuration_template"
        ),
        migrations.RunPython(code=add_permissions, reverse_code=remove_permissions),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="bgpgroup",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="community",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="internetexchange",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="router",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="routingpolicy",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterField(
            model_name="template",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.AlterModelOptions(
            name="autonomoussystem",
            options={
                "ordering": ["asn"],
                "permissions": [("send_email", "Can send e-mails to AS contact")],
            },
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="encrypted_password",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="internetexchangepeeringsession",
            name="encrypted_password",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
    ]
