# Generated by Django 4.1.8 on 2023-04-30 10:44

from django.db import migrations


def migrate_jobresults(apps, schema_editor):
    """
    Migrate existing JobResults to the new Jobs table before deleting the old
    JobResults table.
    """
    try:
        Job = apps.get_model("core", "Job")
        JobResult = apps.get_model("extras", "JobResult")

        jobs = []
        for job_result in JobResult.objects.order_by("pk").iterator(chunk_size=100):
            jobs.append(
                Job(
                    object_type=job_result.obj_type,
                    name=job_result.name,
                    created=job_result.created,
                    completed=job_result.completed,
                    user=job_result.user,
                    status=job_result.status,
                    data=job_result.data,
                    job_id=job_result.job_id,
                )
            )
            if len(jobs) == 100:
                Job.objects.bulk_create(jobs)
                jobs = []
        if jobs:
            Job.objects.bulk_create(jobs)
    except LookupError:
        pass


class Migration(migrations.Migration):
    dependencies = [("core", "0001_initial")]

    operations = [
        migrations.RunPython(
            code=migrate_jobresults, reverse_code=migrations.RunPython.noop
        ),
    ]
