# Generated by Django 4.1.9 on 2023-06-16 20:35

from django.db import migrations, transaction


class Migration(migrations.Migration):
    dependencies = [("extras", "0010_migrate_tags"), ("utils", "0013_alter_tag_slug")]

    @transaction.atomic()
    def delete_old_tags_changelog(apps, schema_editor):
        try:
            ObjectChange = apps.get_model("extras", "ObjectChange")
        except LookupError:
            ObjectChange = apps.get_model("core", "ObjectChange")

        ObjectChange.objects.using(schema_editor.connection.alias).filter(
            changed_object_type__model="tag"
        ).delete()

    operations = [
        migrations.RunPython(delete_old_tags_changelog),
        migrations.AlterIndexTogether(name="taggeditem", index_together=None),
        migrations.RemoveField(model_name="taggeditem", name="content_type"),
        migrations.RemoveField(model_name="taggeditem", name="tag"),
        migrations.DeleteModel(name="Tag"),
        migrations.DeleteModel(name="TaggedItem"),
    ]
