# Generated by Django 3.2.5 on 2021-07-21 12:15

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("utils", "0009_auto_20210721_1414")]

    def move_from_int_to_char(apps, schema_editor):
        ObjectChange = apps.get_model("utils", "ObjectChange")
        db_alias = schema_editor.connection.alias
        ObjectChange.objects.using(db_alias).filter(old_action=1).update(
            action="create"
        )
        ObjectChange.objects.using(db_alias).filter(old_action=2).update(
            action="update"
        )
        ObjectChange.objects.using(db_alias).filter(old_action=3).update(
            action="delete"
        )

    operations = [
        migrations.RemoveField(model_name="objectchange", name="object_data"),
        migrations.AddField(
            model_name="objectchange",
            name="postchange_data",
            field=models.JSONField(blank=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name="objectchange",
            name="prechange_data",
            field=models.JSONField(blank=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name="objectchange",
            name="action",
            field=models.CharField(
                choices=[
                    ("create", "Created"),
                    ("update", "Updated"),
                    ("delete", "Deleted"),
                ],
                max_length=50,
                default="create",
            ),
        ),
        migrations.AlterField(
            model_name="objectchange",
            name="object_repr",
            field=models.CharField(editable=False, max_length=200),
        ),
        migrations.AlterField(
            model_name="objectchange",
            name="time",
            field=models.DateTimeField(auto_now_add=True, db_index=True),
        ),
        migrations.RunPython(move_from_int_to_char),
    ]
