# Generated by Django 5.2.5 on 2024-11-23 00:00

from django.db import migrations, models


def update_content_types(apps, schema_editor):
    ContentType = apps.get_model("contenttypes", "ContentType")
    ContentType.objects.filter(app_label="bgp", model="community").delete()
    ContentType.objects.filter(app_label="peering", model="community").update(
        app_label="bgp"
    )


class Migration(migrations.Migration):
    dependencies = [
        ("bgp", "0003_move_community"),
        ("peering", "0107_autonomoussystem_bgpq_overrides"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.AlterModelTable(name="Community", table="bgp_community"),
                # PK sequence
                migrations.RunSQL(
                    "ALTER TABLE peering_community_id_seq RENAME TO bgp_community_id_seq"
                ),
                # Indexes (hashes generated by schema_editor._create_index_name)
                migrations.RunSQL(
                    "ALTER INDEX peering_community_pkey RENAME TO bgp_community_pkey"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_community_name_9e062f52_uniq "
                    "RENAME TO bgp_community_name_9e062f52_uniq"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_community_slug_7a8117c2_uniq "
                    "RENAME TO bgp_community_slug_7a8117c2_uniq"
                ),
            ],
            state_operations=[
                migrations.DeleteModel(name="Community"),
                migrations.AlterField(
                    model_name="autonomoussystem",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
                migrations.AlterField(
                    model_name="bgpgroup",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
                migrations.AlterField(
                    model_name="directpeeringsession",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
                migrations.AlterField(
                    model_name="internetexchange",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
                migrations.AlterField(
                    model_name="internetexchangepeeringsession",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
                migrations.AlterField(
                    model_name="routingpolicy",
                    name="communities",
                    field=models.ManyToManyField(blank=True, to="bgp.community"),
                ),
            ],
        ),
        migrations.RunPython(
            code=update_content_types, reverse_code=migrations.RunPython.noop
        ),
    ]
