# Generated by Django 2.1.4 on 2018-12-12 23:22

from django.db import migrations


class Migration(migrations.Migration):
    def forwards_func(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": -1, "ipv6_max_prefixes": -1},
                "updates": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
            },
            "DirectPeeringSession": {
                "filters": {"advertised_prefix_count": -1, "received_prefix_count": -1},
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": -1},
                "updates": {"peeringdb_id": 0},
            },
            "InternetExchangePeeringSession": {
                "filters": {"advertised_prefix_count": -1, "received_prefix_count": -1},
                "updates": {"advertised_prefix_count": 0, "received_prefix_count": 0},
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models.items():
            model = apps.get_model("peering", key)
            model.objects.using(db_alias).filter(**value["filters"]).update(
                **value["updates"]
            )

    def reverse_func(apps, schema_editor):
        models = {
            "AutonomousSystem": {
                "filters": {"ipv4_max_prefixes": 0, "ipv6_max_prefixes": 0},
                "updates": {"ipv4_max_prefixes": -1, "ipv6_max_prefixes": -1},
            },
            "DirectPeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {"advertised_prefix_count": -1, "received_prefix_count": -1},
            },
            "InternetExchange": {
                "filters": {"peeringdb_id": 0},
                "updates": {"peeringdb_id": -1},
            },
            "InternetExchangePeeringSession": {
                "filters": {"advertised_prefix_count": 0, "received_prefix_count": 0},
                "updates": {"advertised_prefix_count": -1, "received_prefix_count": -1},
            },
        }
        db_alias = schema_editor.connection.alias
        for key, value in models:
            model = apps.get_model("peering", key)
            for field in value:
                model.objects.using(db_alias).filter(**value["filters"]).update(
                    **value["updates"]
                )

    dependencies = [("peering", "0024_auto_20181212_2106")]

    operations = [migrations.RunPython(forwards_func, reverse_func)]
