# Generated by Django 4.2.3 on 2023-07-31 13:15

from django.db import migrations, models

import extras.utils


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0014_replace_tag_comments_with_description"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="webhook",
            unique_together=set(),
        ),
        migrations.RenameField(
            model_name="webhook", old_name="url", new_name="payload_url"
        ),
        migrations.AddField(
            model_name="webhook",
            name="additional_headers",
            field=models.TextField(
                blank=True,
                help_text="User-supplied HTTP headers to be sent with the request in addition to the HTTP content type. Headers should be defined in the format <code>Name: Value</code>. Jinja2 template processing is supported with the same context as the request body (below).",
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="body_template",
            field=models.TextField(
                blank=True,
                help_text="Jinja2 template for a custom request body. If blank, a JSON object representing the change will be included. Available context data includes: <code>event</code>, <code>model</code>, <code>timestamp</code>, <code>username</code>, <code>request_id</code>, and <code>data</code>.",
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="conditions",
            field=models.JSONField(
                blank=True,
                help_text="A set of conditions which determine whether the webhook will be generated.",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="content_types",
            field=models.ManyToManyField(
                help_text="The object(s) to which this webhook applies.",
                limit_choices_to=extras.utils.FeatureQuery("webhooks"),
                related_name="webhooks",
                to="contenttypes.contenttype",
                verbose_name="Object types",
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="created",
            field=models.DateTimeField(auto_now_add=True, null=True),
        ),
        migrations.AddField(
            model_name="webhook",
            name="updated",
            field=models.DateTimeField(auto_now=True, null=True),
        ),
        migrations.AlterUniqueTogether(
            name="webhook",
            unique_together={
                ("type_create", "type_update", "type_delete", "payload_url")
            },
        ),
    ]
