# Generated by Django 4.0.6 on 2022-07-09 10:38

import django.db.models.deletion
from django.db import migrations, models

import extras.utils


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0005_configcontext_configcontextassignment"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExportTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100)),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "template",
                    models.TextField(
                        help_text="Jinja2 template code. The list of objects being exported is passed as a context variable named <code>dataset</code>."
                    ),
                ),
                (
                    "jinja2_trim",
                    models.BooleanField(
                        default=False, help_text="Removes new line after tag"
                    ),
                ),
                (
                    "jinja2_lstrip",
                    models.BooleanField(
                        default=False, help_text="Strips whitespaces before block"
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to=extras.utils.FeatureQuery("export-templates"),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={"ordering": ["content_type", "name"]},
        ),
        migrations.AddConstraint(
            model_name="exporttemplate",
            constraint=models.UniqueConstraint(
                fields=("content_type", "name"), name="contenttype_per_name"
            ),
        ),
    ]
