# Generated by Django 5.0.5 on 2024-05-18 13:03

import django
from django.db import migrations, models


def update_content_types(apps, schema_editor):
    ContentType = apps.get_model("contenttypes", "ContentType")

    ContentType.objects.filter(app_label="devices", model="router").delete()
    ContentType.objects.filter(app_label="peering", model="router").update(
        app_label="devices"
    )


class Migration(migrations.Migration):
    dependencies = [
        ("devices", "0007_move_router"),
        ("net", "0010_move_router"),
        ("peering", "0101_router_config_push_data_source"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.AlterModelTable(name="Router", table="devices_router"),
                # Remove use_netbox column
                migrations.RunSQL("ALTER TABLE devices_router DROP COLUMN use_netbox"),
                # PK sequence
                migrations.RunSQL(
                    "ALTER TABLE peering_router_id_seq RENAME TO devices_router_id_seq"
                ),
                # Indexes (hashes generated by schema_editor._create_index_name)
                migrations.RunSQL(
                    "ALTER INDEX peering_router_pkey RENAME TO devices_router_pkey"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_router_configuration_id_03b43e8c "
                    "RENAME TO devices_router_configuration_id_55b09a38"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_router_data_file_id_56f9f429 "
                    "RENAME TO devices_router_data_file_id_0e63d3ae"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_router_data_source_id_34e51541 "
                    "RENAME TO devices_router_data_source_id_89a04d04"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_router_local_autonomous_system_id_e41ced07 "
                    "RENAME TO devices_router_local_autonomous_system_id_ea8a4f0b"
                ),
                migrations.RunSQL(
                    "ALTER INDEX peering_router_platform_id_55d3f646 "
                    "RENAME TO devices_router_platform_id_b503339f"
                ),
                # Constraints
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_napalm_timeout_check "
                    "TO devices_router_napalm_timeout_check"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_netbox_device_id_check "
                    "TO devices_router_netbox_device_id_check"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_configuration_templa_9f0aa63f_fk_devices_c "
                    "TO devices_router_configuration_id_55b09a38"
                    # "TO devices_router_configuration_templa_55b09a38_fk_devices_c"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_data_file_id_56f9f429_fk_core_datafile_id "
                    "TO devices_router_data_file_id_0e63d3ae_fk_core_datafile_id"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_data_source_id_34e51541_fk_core_datasource_id "
                    "TO devices_router_data_source_id_89a04d04_fk_core_datasource_id"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "RENAME CONSTRAINT peering_router_local_autonomous_system_id_e41ced07_fk "
                    "TO devices_router_local_autonomous_system_id_ea8a4f0b_fk"
                ),
                # Depending how fresh the database it, the constraint is named differently
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "DROP CONSTRAINT IF EXISTS peering_router_platform_id_55d3f646_fk_devices_platform_id"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "DROP CONSTRAINT IF EXISTS peering_router_platform_id_55d3f646_fk"
                ),
                migrations.RunSQL(
                    "ALTER TABLE devices_router "
                    "ADD CONSTRAINT devices_router_platform_id_b503339f_fk "
                    "FOREIGN KEY (platform_id) REFERENCES devices_platform(id) "
                    "DEFERRABLE INITIALLY DEFERRED"
                ),
                # References in other tables
                # FIXME: handled when altering fields?
                # migrations.RunSQL(
                #     "ALTER TABLE net_connection "
                #     "DROP CONSTRAINT net_connection_router_id_1a83da1f_fk, "
                #     "ADD FOREIGN KEY (router_id) REFERENCES devices_router(id) DEFERRABLE INITIALLY DEFERRED"
                # ),
                # migrations.RunSQL(
                #     "ALTER TABLE peering_directpeeringsession "
                #     "DROP CONSTRAINT peering_directpeeringsession_router_id_9f88e17e_fk, "
                #     "ADD FOREIGN KEY (router_id) REFERENCES devices_router(id) DEFERRABLE INITIALLY DEFERRED"
                # ),
            ],
            state_operations=[
                migrations.DeleteModel(name="Router"),
                migrations.AlterField(
                    model_name="directpeeringsession",
                    name="router",
                    field=models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="devices.router",
                    ),
                ),
            ],
        ),
        migrations.RunPython(
            code=update_content_types, reverse_code=migrations.RunPython.noop
        ),
    ]
