# Generated by Django 3.2.9 on 2021-11-24 22:48

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("bgp", "0001_initial"), ("peering", "0080_internetexchange_ixapi")]

    def create_existing_relationships(apps, schema_editor):
        db_alias = schema_editor.connection.alias
        Relationship = apps.get_model("bgp.Relationship")
        DirectPeeringSession = apps.get_model("peering.DirectPeeringSession")

        # Create existing relationships
        relationships = [
            Relationship(name=r, slug=r)
            for r in (
                DirectPeeringSession.objects.using(db_alias)
                .all()
                .values_list("relationship", flat=True)
                .distinct()
                .order_by()
            )
        ]
        Relationship.objects.using(db_alias).bulk_create(relationships)

    def move_to_relationship_objects(apps, schema_editor):
        db_alias = schema_editor.connection.alias
        Relationship = apps.get_model("bgp.Relationship")
        DirectPeeringSession = apps.get_model("peering.DirectPeeringSession")

        # Update direct sessions objects
        for r in Relationship.objects.using(db_alias).all():
            DirectPeeringSession.objects.using(db_alias).filter(
                relationship=r.slug
            ).update(relationship_fk=r)

    operations = [
        migrations.RunPython(create_existing_relationships),
        migrations.AddField(
            model_name="directpeeringsession",
            name="relationship_fk",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="bgp.relationship",
            ),
        ),
        migrations.RunPython(move_to_relationship_objects),
        migrations.RemoveField(model_name="directpeeringsession", name="relationship"),
        migrations.RenameField(
            model_name="directpeeringsession",
            old_name="relationship_fk",
            new_name="relationship",
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="relationship",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                to="bgp.relationship",
            ),
        ),
    ]
