# Generated by Django 2.2.4 on 2019-08-18 17:26

from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [("peering", "0051_auto_20190818_1816")]

    def add_permissions(apps, schema_editor):
        pass

    def remove_permissions(apps, schema_editor):
        """Reverse the above additions of permissions."""
        ContentType = apps.get_model("contenttypes.ContentType")
        Permission = apps.get_model("auth.Permission")

        try:
            content_type = ContentType.objects.get(
                model="internetexchange", app_label="peering"
            )
            Permission.objects.filter(
                content_type=content_type,
                codename__in=("view_configuration", "deploy_configuration"),
            ).delete()
        except ContentType.DoesNotExist:
            pass

    operations = [
        migrations.AlterModelOptions(name="internetexchange", options={}),
        migrations.RemoveField(
            model_name="internetexchange", name="configuration_template"
        ),
        migrations.RunPython(remove_permissions, add_permissions),
    ]
