# Generated by Django 5.0.9 on 2024-09-17 20:52

import django.core.validators
import taggit.managers
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("extras", "0019_tagged_item_indexes"), ("net", "0010_move_router")]

    operations = [
        migrations.CreateModel(
            name="BFD",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("local_context_data", models.JSONField(blank=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("slug", models.SlugField(max_length=100, unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "minimum_transmit_interval",
                    models.PositiveIntegerField(
                        default=300,
                        help_text="Minimum transmit interval in milliseconds",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(255000),
                        ],
                    ),
                ),
                (
                    "minimum_receive_interval",
                    models.PositiveIntegerField(
                        default=300,
                        help_text="Minimum receive interval in milliseconds",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(255000),
                        ],
                    ),
                ),
                (
                    "detection_multiplier",
                    models.PositiveSmallIntegerField(
                        default=3,
                        help_text="Number of missed messages before declaring a session down",
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(255),
                        ],
                    ),
                ),
                (
                    "hold_time",
                    models.PositiveIntegerField(
                        default=0,
                        help_text="How long a session must remain up in milliseconds before state change",
                        validators=[django.core.validators.MaxValueValidator(255000)],
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="extras.TaggedItem",
                        to="extras.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={"verbose_name": "BFD configuration"},
        ),
    ]
