# Generated by Django 4.1.9 on 2023-06-16 20:45

from django.db import migrations


def migrate_tags(apps, schema_editor):
    """
    Migrate existing Tags to the new Tags table before deleting the old table.
    """
    try:
        Tag = apps.get_model("extras", "Tag")
        OldTag = apps.get_model("utils", "Tag")

        tags = []
        for tag in OldTag.objects.order_by("pk").iterator(chunk_size=100):
            tags.append(
                Tag(
                    name=tag.name,
                    slug=tag.slug,
                    color=tag.color,
                    comments=tag.comments,
                    created=tag.created,
                    updated=tag.updated,
                )
            )
            if len(tags) == 100:
                Tag.objects.bulk_create(tags)
                tags = []
        if tags:
            Tag.objects.bulk_create(tags)
    except LookupError:
        pass


def migrate_tagged_items(apps, schema_editor):
    """
    Migrate existing TaggedItems to the new TaggedItems table before deleting the old
    table.
    """
    try:
        Tag = apps.get_model("extras", "Tag")
        TaggedItem = apps.get_model("extras", "TaggedItem")
        OldTaggedItem = apps.get_model("utils", "TaggedItem")

        tagged_items = []
        for tagged_item in OldTaggedItem.objects.order_by("pk").iterator(
            chunk_size=100
        ):
            tag = Tag.objects.get(name=tagged_item.tag.name)
            tagged_items.append(
                TaggedItem(
                    object_id=tagged_item.object_id,
                    content_type=tagged_item.content_type,
                    tag=tag,
                )
            )
            if len(tagged_items) == 100:
                TaggedItem.objects.bulk_create(tagged_items)
                tagged_items = []
        if tagged_items:
            TaggedItem.objects.bulk_create(tagged_items)
    except LookupError:
        pass


class Migration(migrations.Migration):
    dependencies = [("extras", "0009_tags")]

    operations = [
        migrations.RunPython(code=migrate_tags, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(
            code=migrate_tagged_items, reverse_code=migrations.RunPython.noop
        ),
    ]
