# Generated by Django 4.0.4 on 2022-06-25 11:41

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0004_ixapi"),
    ]

    operations = [
        migrations.CreateModel(
            name="ConfigContext",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("is_active", models.BooleanField(default=True)),
                ("data", models.JSONField()),
            ],
            options={"ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="ConfigContextAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("object_id", models.PositiveIntegerField()),
                ("weight", models.PositiveSmallIntegerField(default=1000)),
                (
                    "config_context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="assignments",
                        to="extras.configcontext",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={"ordering": ["weight", "config_context"]},
        ),
        migrations.AddConstraint(
            model_name="configcontextassignment",
            constraint=models.UniqueConstraint(
                fields=("content_type", "object_id", "config_context"),
                name="configcontext_per_object",
            ),
        ),
    ]
