# Generated by Django 4.2.10 on 2024-02-16 22:01

import django.core.validators
import django.db.models.deletion
import taggit.managers
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0016_webhook_payload_url"),
        ("core", "0003_job_created_auto_now"),
    ]

    operations = [
        migrations.CreateModel(
            name="DataSource",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("local_context_data", models.JSONField(blank=True, null=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=100, unique=True)),
                ("type", models.CharField(max_length=50)),
                ("source_url", models.CharField(max_length=200, verbose_name="URL")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("new", "New"),
                            ("queued", "Queued"),
                            ("synchronising", "Synchronising"),
                            ("pushing", "Pushing"),
                            ("completed", "Completed"),
                            ("failed", "Failed"),
                        ],
                        default="new",
                        editable=False,
                        max_length=50,
                    ),
                ),
                ("enabled", models.BooleanField(default=True)),
                (
                    "ignore_rules",
                    models.TextField(
                        blank=True,
                        help_text="Patterns (one per line) matching files to ignore when synchronising",
                    ),
                ),
                ("parameters", models.JSONField(blank=True, null=True)),
                (
                    "last_synchronised",
                    models.DateTimeField(blank=True, editable=False, null=True),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="extras.TaggedItem",
                        to="extras.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
                "permissions": [
                    ("synchronise_datasource", "Can synchronise data source")
                ],
            },
        ),
        migrations.CreateModel(
            name="DataFile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(editable=False)),
                (
                    "path",
                    models.CharField(
                        editable=False,
                        help_text="File path relative to the data source's root",
                        max_length=1000,
                    ),
                ),
                ("size", models.PositiveIntegerField(editable=False)),
                (
                    "hash",
                    models.CharField(
                        editable=False,
                        help_text="SHA256 hash of the file data",
                        max_length=64,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="It must be composed of 64 hexadecimal characters.",
                                regex="^[0-9a-f]{64}$",
                            )
                        ],
                    ),
                ),
                ("data", models.BinaryField()),
                (
                    "source",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="datafiles",
                        to="core.datasource",
                    ),
                ),
            ],
            options={"ordering": ["source", "path"]},
        ),
        migrations.CreateModel(
            name="AutoSynchronisationRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveBigIntegerField()),
                (
                    "data_file",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="core.datafile",
                    ),
                ),
                (
                    "object_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="datafile",
            constraint=models.UniqueConstraint(
                fields=("source", "path"), name="core_datafile_unique_source_path"
            ),
        ),
        migrations.AddConstraint(
            model_name="autosynchronisationrecord",
            constraint=models.UniqueConstraint(
                fields=("object_type", "object_id"),
                name="core_autosynchronisationrecord_object",
            ),
        ),
    ]
