# Generated by Django 4.0.8 on 2023-02-06 19:55

import django.db.models.deletion
from django.db import migrations, models

import peeringdb.models


class Migration(migrations.Migration):
    dependencies = [("peeringdb", "0024_facility_status_dashboard_and_more")]

    operations = [
        migrations.CreateModel(
            name="Carrier",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=255, unique=True, verbose_name="Name"),
                ),
                (
                    "aka",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="Also Known As"
                    ),
                ),
                (
                    "name_long",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="Long Name"
                    ),
                ),
                (
                    "website",
                    peeringdb.models.URLField(
                        blank=True, max_length=255, null=True, verbose_name="Website"
                    ),
                ),
                ("notes", models.TextField(blank=True, verbose_name="Notes")),
                (
                    "org",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="carrier_set",
                        to="peeringdb.organization",
                        verbose_name="Organization",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CarrierFacility",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "carrier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="carrierfac_set",
                        to="peeringdb.carrier",
                        verbose_name="Carrier",
                    ),
                ),
                (
                    "fac",
                    models.ForeignKey(
                        default=0,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="carrierfac_set",
                        to="peeringdb.facility",
                        verbose_name="Facility",
                    ),
                ),
            ],
            options={
                "unique_together": {("carrier", "fac")},
            },
        ),
        migrations.AlterField(
            model_name="ixlan",
            name="mtu",
            field=models.PositiveIntegerField(
                blank=True, choices=[(1500, "1500"), (9000, "9000")], null=True
            ),
        ),
        migrations.RenameModel(old_name="Synchronization", new_name="Synchronisation"),
    ]
