# Generated by Django 2.2.7 on 2019-11-13 21:13

import django.db.models.deletion
import netfields.fields
from django.db import migrations, models

import peering.fields
import utils.validators


class Migration(migrations.Migration):
    def forward_transition_from_none_to_zero(apps, schema_editor):
        Network = apps.get_model("peeringdb", "Network")
        db_alias = schema_editor.connection.alias
        Network.objects.using(db_alias).filter(info_prefixes4=None).update(
            info_prefixes4=0
        )
        Network.objects.using(db_alias).filter(info_prefixes6=None).update(
            info_prefixes6=0
        )

    def reverse_transition_from_none_to_zero(apps, schema_editor):
        Network = apps.get_model("peeringdb", "Network")
        db_alias = schema_editor.connection.alias
        Network.objects.using(db_alias).filter(info_prefixes4=0).update(
            info_prefixes4=None
        )
        Network.objects.using(db_alias).filter(info_prefixes6=0).update(
            info_prefixes6=None
        )

    def forward_transition_from_minus_one_to_zero(apps, schema_editor):
        Network = apps.get_model("peeringdb", "Network")
        db_alias = schema_editor.connection.alias
        Network.objects.using(db_alias).filter(info_prefixes4=-1).update(
            info_prefixes4=0
        )
        Network.objects.using(db_alias).filter(info_prefixes6=-1).update(
            info_prefixes6=0
        )

    def reverse_transition_from_minus_one_to_zero(apps, schema_editor):
        Network = apps.get_model("peeringdb", "Network")
        db_alias = schema_editor.connection.alias
        Network.objects.using(db_alias).filter(info_prefixes4=0).update(
            info_prefixes4=-1
        )
        Network.objects.using(db_alias).filter(info_prefixes6=0).update(
            info_prefixes6=-1
        )

    replaces = [
        ("peeringdb", "0001_initial"),
        ("peeringdb", "0002_auto_20180101_0203"),
        ("peeringdb", "0003_networkixlan_name"),
        ("peeringdb", "0004_auto_20180121_2207"),
        ("peeringdb", "0005_auto_20180122_1845"),
        ("peeringdb", "0006_auto_20180213_0031"),
        ("peeringdb", "0007_peerrecord"),
        ("peeringdb", "0008_auto_20181212_2106"),
        ("peeringdb", "0009_auto_20181212_2322"),
        ("peeringdb", "0010_auto_20190417_1851"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Network",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("asn", peering.fields.ASNField(unique=True)),
                ("name", models.CharField(max_length=255)),
                ("irr_as_set", models.CharField(blank=True, max_length=255, null=True)),
                ("info_prefixes6", models.PositiveIntegerField(blank=True, null=True)),
                ("info_prefixes4", models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={"ordering": ["asn"]},
        ),
        migrations.CreateModel(
            name="Synchronization",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("time", models.DateTimeField()),
                ("updated", models.PositiveIntegerField()),
                ("added", models.PositiveIntegerField(default=0)),
                ("deleted", models.PositiveIntegerField(default=0)),
            ],
            options={"ordering": ["-time"]},
        ),
        migrations.CreateModel(
            name="Prefix",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("protocol", models.CharField(max_length=8)),
                ("prefix", models.CharField(max_length=64)),
                ("ixlan_id", models.PositiveIntegerField()),
            ],
            options={
                "verbose_name": "IX Prefix",
                "verbose_name_plural": "IX Prefixes",
                "ordering": ["prefix"],
            },
        ),
        migrations.CreateModel(
            name="NetworkIXLAN",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("asn", peering.fields.ASNField()),
                (
                    "ipaddr6",
                    models.GenericIPAddressField(
                        blank=True, null=True, protocol="IPv6"
                    ),
                ),
                (
                    "ipaddr4",
                    models.GenericIPAddressField(
                        blank=True, null=True, protocol="IPv4"
                    ),
                ),
                ("is_rs_peer", models.BooleanField(default=False)),
                ("ix_id", models.PositiveIntegerField()),
                ("name", models.CharField(default="Unknown", max_length=255)),
                ("ixlan_id", models.PositiveIntegerField(default=0)),
            ],
            options={
                "ordering": ["asn", "ipaddr6", "ipaddr4"],
                "verbose_name": "Network IX LAN",
                "verbose_name_plural": "Network IX LANs",
            },
        ),
        migrations.CreateModel(
            name="PeerRecord",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "network",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="peeringdb.Network",
                    ),
                ),
                (
                    "network_ixlan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="peeringdb.NetworkIXLAN",
                    ),
                ),
            ],
        ),
        migrations.RunPython(
            code=forward_transition_from_none_to_zero,
            reverse_code=reverse_transition_from_none_to_zero,
        ),
        migrations.AlterField(
            model_name="network",
            name="info_prefixes4",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.AlterField(
            model_name="network",
            name="info_prefixes6",
            field=models.PositiveIntegerField(blank=True, default=0),
        ),
        migrations.RunPython(
            code=forward_transition_from_minus_one_to_zero,
            reverse_code=reverse_transition_from_minus_one_to_zero,
        ),
        migrations.AlterField(
            model_name="networkixlan",
            name="ipaddr4",
            field=netfields.fields.InetAddressField(
                blank=True,
                max_length=39,
                null=True,
                validators=[utils.validators.AddressFamilyValidator(4)],
            ),
        ),
        migrations.AlterField(
            model_name="networkixlan",
            name="ipaddr6",
            field=netfields.fields.InetAddressField(
                blank=True,
                max_length=39,
                null=True,
                validators=[utils.validators.AddressFamilyValidator(6)],
            ),
        ),
        migrations.AlterField(
            model_name="prefix",
            name="prefix",
            field=netfields.fields.CidrAddressField(max_length=43),
        ),
    ]
