# Generated by Django 3.2.11 on 2022-01-12 20:32

import django.db.models.deletion
import taggit.managers
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("utils", "0012_tag_ordering"),
        ("devices", "0003_configuration"),
        ("peering", "0083_move_email_to_messaging"),
    ]

    def move_router_configuration_templates(apps, schema_editor):
        db_alias = schema_editor.connection.alias
        Configuration = apps.get_model("peering.Configuration")
        Router = apps.get_model("peering.Router")
        NewConfiguration = apps.get_model("devices.Configuration")

        mapping = {}
        for c in Configuration.objects.using(db_alias).all():
            n = NewConfiguration.objects.using(db_alias).create(
                name=c.name,
                template=c.template,
                jinja2_trim=c.jinja2_trim,
                jinja2_lstrip=c.jinja2_lstrip,
                comments=c.comments,
            )
            mapping[c.pk] = n.pk

        for r in Router.objects.using(db_alias).filter(
            configuration_template__isnull=False
        ):
            r.configuration_id = mapping[r.configuration_template.pk]
            r.save()

    operations = [
        migrations.AddField(
            model_name="router",
            name="configuration",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="devices.configuration",
            ),
        ),
        migrations.AlterField(
            model_name="configuration",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                related_name="old_config_field_tags",
                through="utils.TaggedItem",
                to="utils.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.RunPython(move_router_configuration_templates),
    ]
