# Generated by Django 3.2 on 2021-04-25 11:03

import django.db.models.deletion
import netfields.fields
from django.db import migrations, models

import peering.fields


class Migration(migrations.Migration):
    dependencies = [
        ("net", "0001_initial"),
        ("peering", "0072_auto_20210420_2144"),
    ]

    operations = [
        migrations.AlterField(
            model_name="autonomoussystem",
            name="asn",
            field=peering.fields.ASNField(unique=True, verbose_name="ASN"),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="contact_email",
            field=models.EmailField(
                blank=True, max_length=254, verbose_name="Contact e-mail"
            ),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="ipv4_max_prefixes",
            field=models.PositiveIntegerField(
                blank=True, default=0, verbose_name="IPv4 max prefix"
            ),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="ipv6_max_prefixes",
            field=models.PositiveIntegerField(
                blank=True, default=0, verbose_name="IPv6 max prefix"
            ),
        ),
        migrations.AlterField(
            model_name="autonomoussystem",
            name="irr_as_set",
            field=models.CharField(
                blank=True, max_length=255, null=True, verbose_name="IRR AS-SET"
            ),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="bgp_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.bgpgroup",
                verbose_name="BGP group",
            ),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="ip_address",
            field=netfields.fields.InetAddressField(
                max_length=39, verbose_name="IP address"
            ),
        ),
        migrations.AlterField(
            model_name="directpeeringsession",
            name="local_ip_address",
            field=netfields.fields.InetAddressField(
                blank=True, max_length=39, null=True, verbose_name="Local IP address"
            ),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="ip_address",
            field=netfields.fields.InetAddressField(
                max_length=39, verbose_name="IP address"
            ),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="is_route_server",
            field=models.BooleanField(
                blank=True, default=False, verbose_name="Route server"
            ),
        ),
        migrations.AlterField(
            model_name="internetexchangepeeringsession",
            name="ixp_connection",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="net.connection",
                verbose_name="IXP connection",
            ),
        ),
        migrations.AlterField(
            model_name="router",
            name="netbox_device_id",
            field=models.PositiveIntegerField(
                blank=True, default=0, verbose_name="NetBox device"
            ),
        ),
    ]
