# Generated by Django 3.1.1 on 2020-10-25 21:37

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("peering", "0064_auto_20201016_2113")]

    operations = [
        migrations.AddField(
            model_name="autonomoussystem",
            name="affiliated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="directpeeringsession",
            name="local_autonomous_system",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(class)s_local_autonomous_system",
                to="peering.autonomoussystem",
            ),
        ),
        migrations.AddField(
            model_name="internetexchange",
            name="local_autonomous_system",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="peering.autonomoussystem",
            ),
        ),
        migrations.AddField(
            model_name="router",
            name="local_autonomous_system",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="peering.autonomoussystem",
            ),
        ),
        migrations.AlterModelOptions(
            name="autonomoussystem",
            options={
                "ordering": ["asn", "affiliated"],
                "permissions": [("send_email", "Can send e-mails to AS contact")],
            },
        ),
        migrations.AlterModelOptions(
            name="directpeeringsession",
            options={
                "ordering": [
                    "local_autonomous_system",
                    "autonomous_system",
                    "ip_address",
                ]
            },
        ),
        migrations.AlterModelOptions(
            name="internetexchange",
            options={"ordering": ["local_autonomous_system", "name", "slug"]},
        ),
        migrations.AlterModelOptions(
            name="router",
            options={
                "ordering": ["local_autonomous_system", "name"],
                "permissions": [
                    ("view_router_configuration", "Can view router's configuration"),
                    (
                        "deploy_router_configuration",
                        "Can deploy router's configuration",
                    ),
                ],
            },
        ),
        migrations.RemoveField(
            model_name="directpeeringsession",
            name="local_asn",
        ),
        migrations.RemoveField(
            model_name="autonomoussystem",
            name="potential_internet_exchange_peering_sessions",
        ),
        migrations.AddField(
            model_name="autonomoussystem",
            name="potential_internet_exchange_peering_sessions",
            field=models.JSONField(blank=True, editable=False, null=True),
        ),
    ]
