# Generated by Django 3.1 on 2020-08-07 13:03

import django.db.models.deletion
import taggit.managers
from django.db import migrations, models, transaction


class Migration(migrations.Migration):
    dependencies = [
        ("utils", "0007_auto_20200805_2322"),
        ("peering", "0062_auto_20200805_2322"),
    ]

    @transaction.atomic()
    def split_template_to_config_and_email(apps, schema_editor):
        Configuration = apps.get_model("peering", "Configuration")
        Email = apps.get_model("peering", "Email")
        Template = apps.get_model("peering", "Template")
        ObjectChange = apps.get_model("utils", "ObjectChange")
        db_alias = schema_editor.connection.alias

        # Move configuration template to configuration
        for t in Template.objects.using(db_alias).filter(type="configuration"):
            Configuration.objects.using(db_alias).create(
                id=t.id,
                name=t.name,
                template=t.template,
                comments=t.comments,
                tags=t.tags,
            )
        # Move email template to email
        for t in Template.objects.using(db_alias).filter(type="email"):
            Email.objects.using(db_alias).create(
                id=t.id,
                name=t.name,
                subject=t.name,
                template=t.template,
                comments=t.comments,
                tags=t.tags,
            )
        # Delete changes of old templates
        ObjectChange.objects.using(db_alias).filter(
            changed_object_type__model="template"
        ).delete()

    @transaction.atomic()
    def merge_template_to_config_and_email(apps, schema_editor):
        Configuration = apps.get_model("peering", "Configuration")
        Email = apps.get_model("peering", "Email")
        Template = apps.get_model("peering", "Template")
        db_alias = schema_editor.connection.alias

        for c in Configuration.objects.using(db_alias).all():
            Template.objects.using(db_alias).create(
                id=c.id,
                name=c.name,
                template=c.template,
                comments=c.comments,
                tags=c.tags,
            )
        for e in Email.objects.using(db_alias).all():
            Template.objects.using(db_alias).create(
                id=e.id,
                name=e.name,
                template=e.template,
                comments=e.comments,
                tags=e.tags,
            )

    operations = [
        migrations.CreateModel(
            name="Email",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=128)),
                ("template", models.TextField()),
                ("comments", models.TextField(blank=True)),
                ("subject", models.CharField(max_length=512)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="utils.TaggedItem",
                        to="utils.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={"ordering": ["name"], "abstract": False},
        ),
        migrations.CreateModel(
            name="Configuration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.CharField(max_length=128)),
                ("template", models.TextField()),
                ("comments", models.TextField(blank=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="utils.TaggedItem",
                        to="utils.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
            options={"ordering": ["name"], "abstract": False},
        ),
        migrations.RunPython(
            split_template_to_config_and_email, merge_template_to_config_and_email
        ),
        migrations.AlterField(
            model_name="router",
            name="configuration_template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="peering.configuration",
            ),
        ),
        migrations.AlterModelOptions(
            name="router",
            options={
                "ordering": ["name"],
                "permissions": [
                    ("view_router_configuration", "Can view router's configuration"),
                    (
                        "deploy_router_configuration",
                        "Can deploy router's configuration",
                    ),
                ],
            },
        ),
        migrations.DeleteModel(name="Template"),
    ]
