# Generated by Django 3.2.4 on 2021-06-24 12:16

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("peering", "0075_auto_20210604_1709"), ("net", "0001_initial")]

    def deleted_orphaned_connections(apps, schema_editor):
        Connection = apps.get_model("net.Connection")
        connections = Connection.objects.filter(internet_exchange_point__isnull=True)

        for c in connections:
            print(
                f"Deleting orphaned connection: {c} - {c.ipv4_address}/{c.ipv6_address}"
            )

        connections.delete()

    operations = [
        migrations.AlterField(
            model_name="connection",
            name="internet_exchange_point",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="peering.internetexchange",
            ),
        ),
        migrations.RunPython(deleted_orphaned_connections),
    ]
