# Generated by Django 5.0.8 on 2024-08-24 22:32

from django.db import migrations


def update_content_types(apps, schema_editor):
    ContentType = apps.get_model("contenttypes", "ContentType")

    ContentType.objects.filter(app_label="core", model="objectchange").delete()
    ContentType.objects.filter(app_label="extras", model="objectchange").update(
        app_label="core"
    )


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0017_configcontext_export_data_source_file"),
        ("core", "0005_move_objectchange"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.AlterModelTable(
                    name="ObjectChange", table="core_objectchange"
                ),
                # PK sequence
                migrations.RunSQL(
                    "ALTER TABLE extras_objectchange_id_seq "
                    "RENAME TO core_objectchange_id_seq"
                ),
                # Indexes (hashes generated by schema_editor._create_index_name)
                migrations.RunSQL(
                    "ALTER TABLE extras_objectchange_pkey "
                    "RENAME TO core_objectchange_pkey"
                ),
                migrations.RunSQL(
                    "ALTER INDEX extras_objectchange_changed_object_type_id_b755bb60 "
                    "RENAME TO core_objectchange_changed_object_type_id_2070ade6"
                ),
                migrations.RunSQL(
                    "ALTER INDEX extras_objectchange_related_object_type_id_fe6e521f "
                    "RENAME TO core_objectchange_related_object_type_id_b80958af"
                ),
                migrations.RunSQL(
                    "ALTER INDEX extras_objectchange_time_224380ea "
                    "RENAME TO core_objectchange_time_800f60a5"
                ),
                migrations.RunSQL(
                    "ALTER INDEX extras_objectchange_user_id_7fdf8186 "
                    "RENAME TO core_objectchange_user_id_2b2142be"
                ),
                # Constraints
                migrations.RunSQL(
                    "ALTER TABLE core_objectchange "
                    "RENAME CONSTRAINT extras_objectchange_changed_object_id_check "
                    "TO core_objectchange_changed_object_id_check"
                ),
                migrations.RunSQL(
                    "ALTER TABLE core_objectchange "
                    "RENAME CONSTRAINT extras_objectchange_related_object_id_check "
                    "TO core_objectchange_related_object_id_check"
                ),
                migrations.RunSQL(
                    "ALTER TABLE core_objectchange "
                    "RENAME CONSTRAINT extras_objectchange_changed_object_type__b755bb60_fk_django_co "
                    "TO core_objectchange_changed_object_type_id_2070ade6"
                ),
                migrations.RunSQL(
                    "ALTER TABLE core_objectchange "
                    "RENAME CONSTRAINT extras_objectchange_related_object_type__fe6e521f_fk_django_co "
                    "TO core_objectchange_related_object_type_id_b80958af"
                ),
                migrations.RunSQL(
                    "ALTER TABLE core_objectchange "
                    "RENAME CONSTRAINT extras_objectchange_user_id_7fdf8186_fk_auth_user_id "
                    "TO core_objectchange_user_id_2b2142be"
                ),
            ],
            state_operations=[migrations.DeleteModel(name="ObjectChange")],
        ),
        migrations.RunPython(
            code=update_content_types, reverse_code=migrations.RunPython.noop
        ),
    ]
