# Generated by Django 4.1.9 on 2023-06-17 10:46

from django.db import migrations


def migrate_objectchanges(apps, schema_editor):
    """
    Migrate existing ObjectChanges to the new ObjectChanges table before deleting the old table.
    """
    try:
        ObjectChange = apps.get_model("extras", "ObjectChange")
        OldObjectChange = apps.get_model("utils", "ObjectChange")

        object_changes = []
        for object_change in OldObjectChange.objects.order_by("pk").iterator(
            chunk_size=100
        ):
            object_changes.append(
                ObjectChange(
                    time=object_change.time,
                    user=object_change.user,
                    user_name=object_change.user_name,
                    request_id=object_change.request_id,
                    action=object_change.action,
                    changed_object_type=object_change.changed_object_type,
                    changed_object_id=object_change.changed_object_id,
                    related_object_type=object_change.related_object_type,
                    related_object_id=object_change.related_object_id,
                    object_repr=object_change.object_repr,
                    prechange_data=object_change.prechange_data,
                    postchange_data=object_change.postchange_data,
                )
            )
            if len(object_changes) == 100:
                ObjectChange.objects.bulk_create(object_changes)
                object_changes = []
        if object_changes:
            ObjectChange.objects.bulk_create(object_changes)
    except LookupError:
        pass


class Migration(migrations.Migration):
    dependencies = [("extras", "0011_objectchange")]

    operations = [
        migrations.RunPython(
            code=migrate_objectchanges, reverse_code=migrations.RunPython.noop
        ),
    ]
