# Generated by Django 5.0.5 on 2024-05-18 13:03

import django.db.models.deletion
import taggit.managers
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("core", "0004_datasource_and_datafile"),
        ("devices", "0006_configuration_sync_data"),
        ("extras", "0017_configcontext_export_data_source_file"),
        ("peering", "0101_router_config_push_data_source"),
    ]

    operations = [
        # Table renamed from peering app
        migrations.SeparateDatabaseAndState(
            database_operations=[],
            state_operations=[
                migrations.CreateModel(
                    name="Router",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True,
                                primary_key=True,
                                serialize=False,
                                verbose_name="ID",
                            ),
                        ),
                        ("created", models.DateTimeField(auto_now_add=True, null=True)),
                        ("updated", models.DateTimeField(auto_now=True, null=True)),
                        ("local_context_data", models.JSONField(blank=True, null=True)),
                        (
                            "data_path",
                            models.CharField(
                                blank=True,
                                help_text="Path to the remote file, relative to its data source root",
                                max_length=1000,
                                null=True,
                            ),
                        ),
                        (
                            "data_pushed",
                            models.DateTimeField(blank=True, editable=False, null=True),
                        ),
                        ("description", models.CharField(blank=True, max_length=200)),
                        ("comments", models.TextField(blank=True)),
                        ("name", models.CharField(max_length=128)),
                        ("hostname", models.CharField(max_length=256)),
                        (
                            "status",
                            models.CharField(
                                choices=[
                                    ("enabled", "Enabled"),
                                    ("pre-maintenance", "Pre-maintenance"),
                                    ("maintenance", "Maintenance"),
                                    ("post-maintenance", "Post-maintenance"),
                                    ("disabled", "Disabled"),
                                ],
                                default="enabled",
                                max_length=50,
                            ),
                        ),
                        (
                            "encrypt_passwords",
                            models.BooleanField(
                                blank=True,
                                default=False,
                                help_text="Try to encrypt passwords for peering sessions",
                            ),
                        ),
                        (
                            "poll_bgp_sessions_state",
                            models.BooleanField(
                                blank=True,
                                default=False,
                                help_text="Enable polling of BGP sessions state",
                                verbose_name="Poll BGP sessions state",
                            ),
                        ),
                        (
                            "poll_bgp_sessions_last_updated",
                            models.DateTimeField(blank=True, null=True),
                        ),
                        (
                            "netbox_device_id",
                            models.PositiveIntegerField(
                                blank=True, default=0, verbose_name="NetBox device"
                            ),
                        ),
                        (
                            "napalm_username",
                            models.CharField(blank=True, max_length=256, null=True),
                        ),
                        (
                            "napalm_password",
                            models.CharField(blank=True, max_length=256, null=True),
                        ),
                        (
                            "napalm_timeout",
                            models.PositiveIntegerField(blank=True, default=0),
                        ),
                        ("napalm_args", models.JSONField(blank=True, null=True)),
                        (
                            "configuration_template",
                            models.ForeignKey(
                                blank=True,
                                null=True,
                                on_delete=django.db.models.deletion.SET_NULL,
                                to="devices.configuration",
                            ),
                        ),
                        (
                            "data_file",
                            models.ForeignKey(
                                blank=True,
                                editable=False,
                                null=True,
                                on_delete=django.db.models.deletion.SET_NULL,
                                related_name="+",
                                to="core.datafile",
                            ),
                        ),
                        (
                            "data_source",
                            models.ForeignKey(
                                blank=True,
                                help_text="Remote data source",
                                null=True,
                                on_delete=django.db.models.deletion.PROTECT,
                                related_name="+",
                                to="core.datasource",
                            ),
                        ),
                        (
                            "local_autonomous_system",
                            models.ForeignKey(
                                null=True,
                                on_delete=django.db.models.deletion.CASCADE,
                                to="peering.autonomoussystem",
                            ),
                        ),
                        (
                            "platform",
                            models.ForeignKey(
                                blank=True,
                                help_text="The router platform, used to interact with it",
                                null=True,
                                on_delete=django.db.models.deletion.PROTECT,
                                to="devices.platform",
                            ),
                        ),
                        (
                            "tags",
                            taggit.managers.TaggableManager(
                                help_text="A comma-separated list of tags.",
                                through="extras.TaggedItem",
                                to="extras.Tag",
                                verbose_name="Tags",
                            ),
                        ),
                    ],
                    options={
                        "ordering": ["local_autonomous_system", "name"],
                        "permissions": [
                            (
                                "view_router_configuration",
                                "Can view router's configuration",
                            ),
                            (
                                "deploy_router_configuration",
                                "Can deploy router's configuration",
                            ),
                            (
                                "push_router_configuration_to_data_source",
                                "Can push router's configuration on a data source",
                            ),
                        ],
                    },
                ),
            ],
        )
    ]
