/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.nio.fs.BsdFileStore;
import sun.nio.fs.BsdNativeDispatcher;
import sun.nio.fs.LinuxWatchService;
import sun.nio.fs.PollingWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;

class BsdFileSystem
extends UnixFileSystem {
    BsdFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        if (System.getProperty("sun.nio.fs.watchservice", "").equals("polling")) {
            return new PollingWatchService();
        }
        return new LinuxWatchService(this);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UnixMountEntry> getMountEntries() {
        ArrayList<UnixMountEntry> arrayList = new ArrayList<UnixMountEntry>();
        try {
            long l = BsdNativeDispatcher.getfsstat();
            try {
                UnixMountEntry unixMountEntry;
                int n;
                while ((n = BsdNativeDispatcher.fsstatEntry(l, unixMountEntry = new UnixMountEntry())) >= 0) {
                    arrayList.add(unixMountEntry);
                }
            }
            finally {
                BsdNativeDispatcher.endfsstat(l);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new BsdFileStore(this, unixMountEntry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(UnixFileSystem.standardFileAttributeViews());
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

