/*
 * Decompiled with CFR 0.152.
 */
package build.tools.tzdb;

import build.tools.tzdb.LocalTime;
import build.tools.tzdb.TimeDefinition;
import build.tools.tzdb.ZoneOffset;
import java.util.Objects;

final class ZoneOffsetTransitionRule {
    final int month;
    final byte dom;
    final int dow;
    final LocalTime time;
    final boolean timeEndOfDay;
    final TimeDefinition timeDefinition;
    final ZoneOffset standardOffset;
    final ZoneOffset offsetBefore;
    final ZoneOffset offsetAfter;

    ZoneOffsetTransitionRule(int n, int n2, int n3, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        Objects.requireNonNull(localTime, "time");
        Objects.requireNonNull(timeDefinition, "timeDefnition");
        Objects.requireNonNull(zoneOffset, "standardOffset");
        Objects.requireNonNull(zoneOffset2, "offsetBefore");
        Objects.requireNonNull(zoneOffset3, "offsetAfter");
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("month must be between 1 and 12");
        }
        if (n2 < -28 || n2 > 31 || n2 == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (bl && !localTime.equals(LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
        }
        this.month = n;
        this.dom = (byte)n2;
        this.dow = n3;
        this.time = localTime;
        this.timeEndOfDay = bl;
        this.timeDefinition = timeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransitionRule) {
            ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
            return this.month == zoneOffsetTransitionRule.month && this.dom == zoneOffsetTransitionRule.dom && this.dow == zoneOffsetTransitionRule.dow && this.timeDefinition == zoneOffsetTransitionRule.timeDefinition && this.time.equals(zoneOffsetTransitionRule.time) && this.timeEndOfDay == zoneOffsetTransitionRule.timeEndOfDay && this.standardOffset.equals(zoneOffsetTransitionRule.standardOffset) && this.offsetBefore.equals(zoneOffsetTransitionRule.offsetBefore) && this.offsetAfter.equals(zoneOffsetTransitionRule.offsetAfter);
        }
        return false;
    }

    public int hashCode() {
        int n = (this.time.toSecondOfDay() + (this.timeEndOfDay ? 1 : 0) << 15) + (this.month << 11) + (this.dom + 32 << 5) + ((this.dow == -1 ? 8 : this.dow) << 2) + this.timeDefinition.ordinal();
        return n ^ this.standardOffset.hashCode() ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }
}

