/*
 * Decompiled with CFR 0.152.
 */
package build.tools.tzdb;

import build.tools.tzdb.LocalDate;
import build.tools.tzdb.LocalDateTime;
import build.tools.tzdb.LocalTime;
import build.tools.tzdb.TimeDefinition;
import build.tools.tzdb.Utils;
import build.tools.tzdb.ZoneOffset;
import build.tools.tzdb.ZoneRules;
import build.tools.tzdb.ZoneRulesBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TzdbZoneRulesCompiler {
    private static final Pattern YEAR = Pattern.compile("(?i)(?<min>min)|(?<max>max)|(?<only>only)|(?<year>[0-9]+)");
    private static final Matcher TIME = Pattern.compile("(?<neg>-)?+(?<hour>[0-9]{1,2})(:(?<minute>[0-5][0-9]))?+(:(?<second>[0-5][0-9]))?+").matcher("");
    private final Map<String, List<TZDBRule>> rules = new HashMap<String, List<TZDBRule>>();
    private final Map<String, List<TZDBZone>> zones = new HashMap<String, List<TZDBZone>>();
    private final Map<String, String> links = new HashMap<String, String>();
    private final SortedMap<String, ZoneRules> builtZones = new TreeMap<String, ZoneRules>();
    private boolean verbose;

    public static void main(String[] stringArray) {
        new TzdbZoneRulesCompiler().compile(stringArray);
    }

    private void compile(String[] stringArray) {
        String[] stringArray2;
        int n;
        if (stringArray.length < 2) {
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        Path path = null;
        Path path2 = null;
        String string = null;
        for (n = 0; n < stringArray.length && (stringArray2 = stringArray[n]).startsWith("-"); ++n) {
            if ("-srcdir".equals(stringArray2)) {
                if (path == null && ++n < stringArray.length) {
                    path = Paths.get(stringArray[n], new String[0]);
                    continue;
                }
            } else if ("-dstfile".equals(stringArray2)) {
                if (path2 == null && ++n < stringArray.length) {
                    path2 = Paths.get(stringArray[n], new String[0]);
                    continue;
                }
            } else if ("-verbose".equals(stringArray2)) {
                if (!this.verbose) {
                    this.verbose = true;
                    continue;
                }
            } else if (!"-help".equals(stringArray2)) {
                System.out.println("Unrecognised option: " + (String)stringArray2);
            }
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        if (path == null) {
            System.err.println("Source directory must be specified using -srcdir");
            System.exit(1);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.err.println("Source does not exist or is not a directory: " + path);
            System.exit(1);
        }
        if (n == stringArray.length) {
            n = 0;
            stringArray = new String[]{"africa", "antarctica", "asia", "australasia", "europe", "northamerica", "southamerica", "backward", "etcetera"};
            System.out.println("Source filenames not specified, using default set ( ");
            for (String object : stringArray) {
                System.out.printf(object + " ", new Object[0]);
            }
            System.out.println(")");
        }
        stringArray2 = new ArrayList();
        while (n < stringArray.length) {
            Path path3 = path.resolve(stringArray[n]);
            if (Files.exists(path3, new LinkOption[0])) {
                stringArray2.add(path3);
            } else {
                System.err.println("Source directory does not contain source file: " + stringArray[n]);
                System.exit(1);
            }
            ++n;
        }
        if (path2 == null) {
            path2 = path.resolve("tzdb.dat");
        } else {
            Path path4 = path2.getParent();
            if (path4 != null && !Files.exists(path4, new LinkOption[0])) {
                System.err.println("Destination directory does not exist: " + path4);
                System.exit(1);
            }
        }
        try {
            Matcher matcher = Pattern.compile("tzdata(?<ver>[0-9]{4}[A-z])").matcher(new String(Files.readAllBytes(path.resolve("VERSION")), "ISO-8859-1"));
            if (matcher.find()) {
                string = matcher.group("ver");
            } else {
                System.exit(1);
                System.err.println("Source directory does not contain file: VERSION");
            }
            this.printVerbose("Compiling TZDB version " + string);
            for (Path path3 : stringArray2) {
                this.printVerbose("Parsing file: " + path3);
                this.parseFile(path3);
            }
            this.printVerbose("Building rules");
            this.buildZoneRules();
            this.printVerbose("Outputting tzdb file: " + path2);
            this.outputFile(path2, string, this.builtZones, this.links);
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void outputHelp() {
        System.out.println("Usage: TzdbZoneRulesCompiler <options> <tzdb source filenames>");
        System.out.println("where options include:");
        System.out.println("   -srcdir  <directory>  Where to find tzdb source directory (required)");
        System.out.println("   -dstfile <file>       Where to output generated file (default srcdir/tzdb.dat)");
        System.out.println("   -help                 Print this usage message");
        System.out.println("   -verbose              Output verbose information during compilation");
        System.out.println(" The source directory must contain the unpacked tzdb files, such as asia or europe");
    }

    private void outputFile(Path path, String string, SortedMap<String, ZoneRules> sortedMap, Map<String, String> map) {
        try (DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("TZDB");
            dataOutputStream.writeShort(1);
            dataOutputStream.writeUTF(string);
            String[] stringArray = sortedMap.keySet().toArray(new String[sortedMap.size()]);
            dataOutputStream.writeShort(stringArray.length);
            for (String object : stringArray) {
                dataOutputStream.writeUTF(object);
            }
            ArrayList<ZoneRules> arrayList = new ArrayList<ZoneRules>(new HashSet<ZoneRules>(sortedMap.values()));
            dataOutputStream.writeShort(arrayList.size());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ZoneRules zoneRules = (ZoneRules)iterator.next();
                byteArrayOutputStream.reset();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                zoneRules.writeExternal(dataOutputStream2);
                dataOutputStream2.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.writeShort(byArray.length);
                dataOutputStream.write(byArray);
            }
            dataOutputStream.writeShort(sortedMap.size());
            for (Map.Entry entry : sortedMap.entrySet()) {
                int n = TzdbZoneRulesCompiler.findRegionIndex(stringArray, (String)entry.getKey());
                int n2 = arrayList.indexOf(entry.getValue());
                dataOutputStream.writeShort(n);
                dataOutputStream.writeShort(n2);
            }
            dataOutputStream.writeShort(map.size());
            for (Map.Entry entry : map.entrySet()) {
                int n = TzdbZoneRulesCompiler.findRegionIndex(stringArray, (String)entry.getKey());
                int n3 = TzdbZoneRulesCompiler.findRegionIndex(stringArray, (String)entry.getValue());
                dataOutputStream.writeShort(n);
                dataOutputStream.writeShort(n3);
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static int findRegionIndex(String[] stringArray, String string) {
        int n = Arrays.binarySearch(stringArray, string);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown region: " + string);
        }
        return n;
    }

    private TzdbZoneRulesCompiler() {
    }

    private void parseFile(Path path) throws Exception {
        int n;
        String string = null;
        try {
            List<String> list = Files.readAllLines(path, StandardCharsets.ISO_8859_1);
            ArrayList<TZDBZone> arrayList = null;
            for (n = 1; n < list.size(); ++n) {
                string = list.get(n);
                int n2 = string.indexOf(35);
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                }
                if (string.trim().length() == 0) continue;
                Scanner scanner = new Scanner(string);
                if (arrayList != null && Character.isWhitespace(string.charAt(0)) && scanner.hasNext()) {
                    if (!this.parseZoneLine(scanner, arrayList)) continue;
                    arrayList = null;
                    continue;
                }
                if (!scanner.hasNext()) continue;
                String string2 = scanner.next();
                if (string2.equals("Zone")) {
                    arrayList = new ArrayList<TZDBZone>();
                    try {
                        this.zones.put(scanner.next(), arrayList);
                        if (!this.parseZoneLine(scanner, arrayList)) continue;
                        arrayList = null;
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.printVerbose("Invalid Zone line in file: " + path + ", line: " + string);
                        throw new IllegalArgumentException("Invalid Zone line");
                    }
                }
                arrayList = null;
                if (string2.equals("Rule")) {
                    try {
                        this.parseRuleLine(scanner);
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.printVerbose("Invalid Rule line in file: " + path + ", line: " + string);
                        throw new IllegalArgumentException("Invalid Rule line");
                    }
                }
                if (string2.equals("Link")) {
                    try {
                        String string3 = scanner.next();
                        String string4 = scanner.next();
                        this.links.put(string4, string3);
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.printVerbose("Invalid Link line in file: " + path + ", line: " + string);
                        throw new IllegalArgumentException("Invalid Link line");
                    }
                }
                throw new IllegalArgumentException("Unknown line");
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed while parsing file '" + path + "' on line " + n + " '" + string + "'", exception);
        }
    }

    private void parseRuleLine(Scanner scanner) {
        TZDBRule tZDBRule = new TZDBRule();
        String string = scanner.next();
        if (!this.rules.containsKey(string)) {
            this.rules.put(string, new ArrayList());
        }
        this.rules.get(string).add(tZDBRule);
        tZDBRule.startYear = this.parseYear(scanner, 0);
        tZDBRule.endYear = this.parseYear(scanner, tZDBRule.startYear);
        if (tZDBRule.startYear > tZDBRule.endYear) {
            throw new IllegalArgumentException("Year order invalid: " + tZDBRule.startYear + " > " + tZDBRule.endYear);
        }
        this.parseOptional(scanner.next());
        this.parseMonthDayTime(scanner, tZDBRule);
        tZDBRule.savingsAmount = this.parsePeriod(scanner.next());
        tZDBRule.text = this.parseOptional(scanner.next());
    }

    private boolean parseZoneLine(Scanner scanner, List<TZDBZone> list) {
        TZDBZone tZDBZone = new TZDBZone();
        list.add(tZDBZone);
        tZDBZone.standardOffset = this.parseOffset(scanner.next());
        String string = this.parseOptional(scanner.next());
        if (string == null) {
            tZDBZone.fixedSavingsSecs = 0;
            tZDBZone.savingsRule = null;
        } else {
            try {
                tZDBZone.fixedSavingsSecs = this.parsePeriod(string);
                tZDBZone.savingsRule = null;
            }
            catch (Exception exception) {
                tZDBZone.fixedSavingsSecs = null;
                tZDBZone.savingsRule = string;
            }
        }
        tZDBZone.text = scanner.next();
        if (scanner.hasNext()) {
            tZDBZone.year = Integer.parseInt(scanner.next());
            if (scanner.hasNext()) {
                this.parseMonthDayTime(scanner, tZDBZone);
            }
            return false;
        }
        return true;
    }

    private void parseMonthDayTime(Scanner scanner, TZDBMonthDayTime tZDBMonthDayTime) {
        tZDBMonthDayTime.month = this.parseMonth(scanner);
        if (scanner.hasNext()) {
            String string = scanner.next();
            if (string.startsWith("last")) {
                tZDBMonthDayTime.dayOfMonth = -1;
                tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(4));
                tZDBMonthDayTime.adjustForwards = false;
            } else {
                int n = string.indexOf(">=");
                if (n > 0) {
                    tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                    string = string.substring(n + 2);
                } else {
                    n = string.indexOf("<=");
                    if (n > 0) {
                        tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                        tZDBMonthDayTime.adjustForwards = false;
                        string = string.substring(n + 2);
                    }
                }
                tZDBMonthDayTime.dayOfMonth = Integer.parseInt(string);
            }
            if (scanner.hasNext()) {
                LocalTime localTime;
                String string2 = scanner.next();
                int n = this.parseSecs(string2);
                if (n == 86400) {
                    tZDBMonthDayTime.endOfDay = true;
                    n = 0;
                }
                tZDBMonthDayTime.time = localTime = LocalTime.ofSecondOfDay(n);
                tZDBMonthDayTime.timeDefinition = this.parseTimeDefinition(string2.charAt(string2.length() - 1));
            }
        }
    }

    private int parseYear(Scanner scanner, int n) {
        if (scanner.hasNext(YEAR)) {
            scanner.next(YEAR);
            MatchResult matchResult = scanner.match();
            if (matchResult.group(1) != null) {
                return 1900;
            }
            if (matchResult.group(2) != null) {
                return 999999999;
            }
            if (matchResult.group(3) != null) {
                return n;
            }
            return Integer.parseInt(matchResult.group(4));
        }
        throw new IllegalArgumentException("Unknown year: " + scanner.next());
    }

    private int parseMonth(Scanner scanner) {
        int n;
        String string = scanner.next();
        if (string.regionMatches(true, 0, "January", 0, n = string.length())) {
            return 1;
        }
        if (string.regionMatches(true, 0, "February", 0, n)) {
            return 2;
        }
        if (string.regionMatches(true, 0, "March", 0, n)) {
            return 3;
        }
        if (string.regionMatches(true, 0, "April", 0, n)) {
            return 4;
        }
        if (string.regionMatches(true, 0, "May", 0, n)) {
            return 5;
        }
        if (string.regionMatches(true, 0, "June", 0, n)) {
            return 6;
        }
        if (string.regionMatches(true, 0, "July", 0, n)) {
            return 7;
        }
        if (string.regionMatches(true, 0, "August", 0, n)) {
            return 8;
        }
        if (string.regionMatches(true, 0, "September", 0, n)) {
            return 9;
        }
        if (string.regionMatches(true, 0, "October", 0, n)) {
            return 10;
        }
        if (string.regionMatches(true, 0, "November", 0, n)) {
            return 11;
        }
        if (string.regionMatches(true, 0, "December", 0, n)) {
            return 12;
        }
        throw new IllegalArgumentException("Unknown month: " + string);
    }

    private int parseDayOfWeek(String string) {
        int n = string.length();
        if (string.regionMatches(true, 0, "Monday", 0, n)) {
            return 1;
        }
        if (string.regionMatches(true, 0, "Tuesday", 0, n)) {
            return 2;
        }
        if (string.regionMatches(true, 0, "Wednesday", 0, n)) {
            return 3;
        }
        if (string.regionMatches(true, 0, "Thursday", 0, n)) {
            return 4;
        }
        if (string.regionMatches(true, 0, "Friday", 0, n)) {
            return 5;
        }
        if (string.regionMatches(true, 0, "Saturday", 0, n)) {
            return 6;
        }
        if (string.regionMatches(true, 0, "Sunday", 0, n)) {
            return 7;
        }
        throw new IllegalArgumentException("Unknown day-of-week: " + string);
    }

    private String parseOptional(String string) {
        return string.equals("-") ? null : string;
    }

    private int parseSecs(String string) {
        if (string.equals("-")) {
            return 0;
        }
        try {
            if (TIME.reset(string).find()) {
                int n = Integer.parseInt(TIME.group("hour")) * 60 * 60;
                if (TIME.group("minute") != null) {
                    n += Integer.parseInt(TIME.group("minute")) * 60;
                }
                if (TIME.group("second") != null) {
                    n += Integer.parseInt(TIME.group("second"));
                }
                if (TIME.group("neg") != null) {
                    n = -n;
                }
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(string);
    }

    private ZoneOffset parseOffset(String string) {
        int n = this.parseSecs(string);
        return ZoneOffset.ofTotalSeconds(n);
    }

    private int parsePeriod(String string) {
        return this.parseSecs(string);
    }

    private TimeDefinition parseTimeDefinition(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return TimeDefinition.STANDARD;
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return TimeDefinition.UTC;
            }
        }
        return TimeDefinition.WALL;
    }

    private void buildZoneRules() throws Exception {
        Object object;
        Object object2;
        for (String string : this.zones.keySet()) {
            this.printVerbose("Building zone " + string);
            object2 = this.zones.get(string);
            object = new ZoneRulesBuilder();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                TZDBZone tZDBZone = (TZDBZone)iterator.next();
                object = tZDBZone.addToBuilder((ZoneRulesBuilder)object, this.rules);
            }
            this.builtZones.put(string, ((ZoneRulesBuilder)object).toRules(string));
        }
        for (String string : this.links.keySet()) {
            object2 = this.links.get(string);
            this.printVerbose("Linking alias " + string + " to " + (String)object2);
            object = (ZoneRules)this.builtZones.get(object2);
            if (object == null) {
                object2 = this.links.get(object2);
                this.printVerbose("Relinking alias " + string + " to " + (String)object2);
                object = (ZoneRules)this.builtZones.get(object2);
                if (object == null) {
                    throw new IllegalArgumentException("Alias '" + string + "' links to invalid zone '" + (String)object2);
                }
                this.links.put(string, (String)object2);
            }
            this.builtZones.put(string, (ZoneRules)object);
        }
        this.builtZones.remove("GMT+0");
        this.builtZones.remove("GMT-0");
        this.links.remove("GMT+0");
        this.links.remove("GMT-0");
        this.builtZones.remove("ROC");
        this.links.remove("ROC");
        this.builtZones.remove("EST");
        this.builtZones.remove("HST");
        this.builtZones.remove("MST");
        this.links.remove("EST");
        this.links.remove("HST");
        this.links.remove("MST");
    }

    private void printVerbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    final class TZDBZone
    extends TZDBMonthDayTime {
        ZoneOffset standardOffset;
        Integer fixedSavingsSecs;
        String savingsRule;
        String text;
        int year;

        TZDBZone() {
            this.year = 999999999;
        }

        ZoneRulesBuilder addToBuilder(ZoneRulesBuilder zoneRulesBuilder, Map<String, List<TZDBRule>> map) {
            if (this.year != 999999999) {
                zoneRulesBuilder.addWindow(this.standardOffset, this.toDateTime(this.year), this.timeDefinition);
            } else {
                zoneRulesBuilder.addWindowForever(this.standardOffset);
            }
            if (this.fixedSavingsSecs != null) {
                zoneRulesBuilder.setFixedSavingsToWindow(this.fixedSavingsSecs);
            } else {
                List<TZDBRule> list = map.get(this.savingsRule);
                if (list == null) {
                    throw new IllegalArgumentException("Rule not found: " + this.savingsRule);
                }
                for (TZDBRule tZDBRule : list) {
                    tZDBRule.addToBuilder(zoneRulesBuilder);
                }
            }
            return zoneRulesBuilder;
        }

        private LocalDateTime toDateTime(int n) {
            LocalDate localDate;
            this.adjustToFowards(n);
            if (this.dayOfMonth == -1) {
                this.dayOfMonth = Utils.lengthOfMonth(this.month, Utils.isLeapYear(n));
                localDate = LocalDate.of(n, this.month, this.dayOfMonth);
                if (this.dayOfWeek != -1) {
                    localDate = Utils.previousOrSame(localDate, this.dayOfWeek);
                }
            } else {
                localDate = LocalDate.of(n, this.month, this.dayOfMonth);
                if (this.dayOfWeek != -1) {
                    localDate = Utils.nextOrSame(localDate, this.dayOfWeek);
                }
            }
            LocalDateTime localDateTime = LocalDateTime.of(localDate, this.time);
            if (this.endOfDay) {
                localDateTime = localDateTime.plusDays(1L);
            }
            return localDateTime;
        }
    }

    final class TZDBRule
    extends TZDBMonthDayTime {
        int startYear;
        int endYear;
        int savingsAmount;
        String text;

        TZDBRule() {
        }

        void addToBuilder(ZoneRulesBuilder zoneRulesBuilder) {
            this.adjustToFowards(2004);
            zoneRulesBuilder.addRuleToWindow(this.startYear, this.endYear, this.month, this.dayOfMonth, this.dayOfWeek, this.time, this.endOfDay, this.timeDefinition, this.savingsAmount);
        }
    }

    abstract class TZDBMonthDayTime {
        int month = 1;
        int dayOfMonth = 1;
        boolean adjustForwards = true;
        int dayOfWeek = -1;
        LocalTime time = LocalTime.MIDNIGHT;
        boolean endOfDay;
        TimeDefinition timeDefinition = TimeDefinition.WALL;

        TZDBMonthDayTime() {
        }

        void adjustToFowards(int n) {
            if (!this.adjustForwards && this.dayOfMonth > 0) {
                LocalDate localDate = LocalDate.of(n, this.month, this.dayOfMonth).minusDays(6L);
                this.dayOfMonth = localDate.getDayOfMonth();
                this.month = localDate.getMonth();
                this.adjustForwards = true;
            }
        }
    }
}

