/*
 * Decompiled with CFR 0.152.
 */
package build.tools.tzdb;

import build.tools.tzdb.LocalDate;
import build.tools.tzdb.LocalTime;
import build.tools.tzdb.Utils;
import build.tools.tzdb.ZoneOffset;
import java.util.Objects;

final class LocalDateTime {
    public static final LocalDateTime MIN = LocalDateTime.of(LocalDate.MIN, LocalTime.MIN);
    public static final LocalDateTime MAX = LocalDateTime.of(LocalDate.MAX, LocalTime.MAX);
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(LocalDate localDate, LocalTime localTime) {
        Objects.requireNonNull(localDate, "date");
        Objects.requireNonNull(localTime, "time");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime ofEpochSecond(long l, int n, ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "offset");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        long l3 = Utils.floorDiv(l2, 86400L);
        int n2 = (int)Utils.floorMod(l2, 86400L);
        LocalDate localDate = LocalDate.ofEpochDay(l3);
        LocalTime localTime = LocalTime.ofSecondOfDay(n2);
        return new LocalDateTime(localDate, localTime);
    }

    private LocalDateTime(LocalDate localDate, LocalTime localTime) {
        this.date = localDate;
        this.time = localTime;
    }

    private LocalDateTime with(LocalDate localDate, LocalTime localTime) {
        if (this.date == localDate && this.time == localTime) {
            return this;
        }
        return new LocalDateTime(localDate, localTime);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public LocalTime getTime() {
        return this.time;
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public long toEpochSecond(ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "offset");
        long l = this.getDate().toEpochDay();
        long l2 = l * 86400L + (long)this.getTime().toSecondOfDay();
        return l2 -= (long)zoneOffset.getTotalSeconds();
    }

    public LocalDateTime plusDays(long l) {
        LocalDate localDate = this.date.plusDays(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 1);
    }

    private LocalDateTime plusWithOverflow(LocalDate localDate, long l, long l2, long l3, int n) {
        if ((l | l2 | l3) == 0L) {
            return this.with(localDate, this.time);
        }
        long l4 = l3 / 86400L + l2 / 1440L + l / 24L;
        l4 *= (long)n;
        long l5 = l3 % 86400L + l2 % 1440L * 60L + l % 24L * 3600L;
        long l6 = this.time.toSecondOfDay();
        l5 = l5 * (long)n + l6;
        int n2 = (int)Utils.floorMod(l5, 86400L);
        LocalTime localTime = (long)n2 == l6 ? this.time : LocalTime.ofSecondOfDay(n2);
        return this.with(localDate.plusDays(l4 += Utils.floorDiv(l5, 86400L)), localTime);
    }

    public int compareTo(LocalDateTime localDateTime) {
        int n = this.date.compareTo(localDateTime.getDate());
        if (n == 0) {
            n = this.time.compareTo(localDateTime.getTime());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return this.date.equals(localDateTime.date) && this.time.equals(localDateTime.time);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }
}

