/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0a28\u0a3e\u0a09\u0a30\u0a42";
        final String metaValue_TR = "\u0a24\u0a41\u0a30\u0a15\u0a40";
        final String metaValue_ar = "\u0a05\u0a30\u0a2c\u0a40";
        final String metaValue_hy = "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08";
        final String metaValue_bn = "\u0a2c\u0a70\u0a17\u0a3e\u0a32\u0a40";
        final String metaValue_ccp = "\u0a1a\u0a15\u0a2e\u0a3e";
        final String metaValue_ka = "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06\u0a08";
        final String metaValue_el = "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40";
        final String metaValue_gu = "\u0a17\u0a41\u0a1c\u0a30\u0a3e\u0a24\u0a40";
        final String metaValue_he = "\u0a39\u0a3f\u0a2c\u0a30\u0a42";
        final String metaValue_ja = "\u0a1c\u0a2a\u0a3e\u0a28\u0a40";
        final String metaValue_km = "\u0a16\u0a2e\u0a47\u0a30";
        final String metaValue_kn = "\u0a15\u0a70\u0a28\u0a5c";
        final String metaValue_ko = "\u0a15\u0a4b\u0a30\u0a40\u0a06\u0a08";
        final String metaValue_lo = "\u0a32\u0a3e\u0a13";
        final String metaValue_la = "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40";
        final String metaValue_ml = "\u0a2e\u0a32\u0a3f\u0a06\u0a32\u0a2e";
        final String metaValue_or = "\u0a09\u0a5c\u0a40\u0a06";
        final String metaValue_si = "\u0a38\u0a3f\u0a70\u0a39\u0a3e\u0a32\u0a3e";
        final String metaValue_su = "\u0a38\u0a42\u0a70\u0a21\u0a3e\u0a28\u0a40";
        final String metaValue_syr = "\u0a38\u0a40\u0a30\u0a40\u0a06\u0a08";
        final String metaValue_ta = "\u0a24\u0a2e\u0a3f\u0a32";
        final String metaValue_te = "\u0a24\u0a47\u0a32\u0a17\u0a42";
        final String metaValue_th = "\u0a25\u0a3e\u0a08";
        final String metaValue_bo = "\u0a24\u0a3f\u0a71\u0a2c\u0a24\u0a40";
        final String metaValue_vai = "\u0a35\u0a3e\u0a08";
        final Object[][] data = new Object[][] {
            { "001", "\u0a38\u0a70\u0a38\u0a3e\u0a30" },
            { "002", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "003", "\u0a09\u0a71\u0a24\u0a30 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "005", "\u0a26\u0a71\u0a16\u0a23 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "009", "\u0a13\u0a38\u0a3c\u0a47\u0a28\u0a40\u0a06" },
            { "011", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "013", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "014", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "015", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "017", "\u0a2e\u0a71\u0a27 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "018", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "019", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "021", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "029", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08" },
            { "030", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "034", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "035", "\u0a26\u0a71\u0a16\u0a23-\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "039", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "053", "\u0a06\u0a38\u0a1f\u0a30\u0a47\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "054", "\u0a2e\u0a47\u0a32\u0a3e\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "057", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "061", "\u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "142", "\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "143", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "145", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "150", "\u0a2f\u0a42\u0a30\u0a2a" },
            { "151", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "154", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "155", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "202", "\u0a09\u0a2a-\u0a38\u0a39\u0a3e\u0a30\u0a3e \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "419", "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "AC", "\u0a05\u0a38\u0a48\u0a02\u0a38\u0a3c\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "AD", "\u0a05\u0a70\u0a21\u0a4b\u0a30\u0a3e" },
            { "AE", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a05\u0a30\u0a2c \u0a05\u0a2e\u0a40\u0a30\u0a3e\u0a24" },
            { "AF", "\u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "AG", "\u0a10\u0a02\u0a1f\u0a40\u0a17\u0a41\u0a06 \u0a05\u0a24\u0a47 \u0a2c\u0a3e\u0a30\u0a2c\u0a41\u0a21\u0a3e" },
            { "AI", "\u0a05\u0a70\u0a17\u0a41\u0a07\u0a32\u0a3e" },
            { "AL", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06" },
            { "AM", "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06" },
            { "AO", "\u0a05\u0a70\u0a17\u0a4b\u0a32\u0a3e" },
            { "AQ", "\u0a05\u0a70\u0a1f\u0a3e\u0a30\u0a15\u0a1f\u0a3f\u0a15\u0a3e" },
            { "AR", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a3e" },
            { "AS", "\u0a05\u0a2e\u0a48\u0a30\u0a40\u0a15\u0a28 \u0a38\u0a2e\u0a4b\u0a06" },
            { "AT", "\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06" },
            { "AU", "\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06" },
            { "AW", "\u0a05\u0a30\u0a42\u0a2c\u0a3e" },
            { "AX", "\u0a05\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "AZ", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28" },
            { "BA", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a39\u0a30\u0a1c\u0a3c\u0a47\u0a17\u0a4b\u0a35\u0a40\u0a28\u0a3e" },
            { "BB", "\u0a2c\u0a3e\u0a30\u0a2c\u0a3e\u0a21\u0a4b\u0a38" },
            { "BD", "\u0a2c\u0a70\u0a17\u0a32\u0a3e\u0a26\u0a47\u0a38\u0a3c" },
            { "BE", "\u0a2c\u0a48\u0a32\u0a1c\u0a40\u0a05\u0a2e" },
            { "BF", "\u0a2c\u0a41\u0a30\u0a15\u0a40\u0a28\u0a3e \u0a2b\u0a3c\u0a3e\u0a38\u0a4b" },
            { "BG", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06" },
            { "BH", "\u0a2c\u0a39\u0a3f\u0a30\u0a40\u0a28" },
            { "BI", "\u0a2c\u0a41\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "BJ", "\u0a2c\u0a47\u0a28\u0a3f\u0a28" },
            { "BL", "\u0a38\u0a47\u0a02\u0a1f \u0a2c\u0a3e\u0a30\u0a25\u0a47\u0a32\u0a47\u0a2e\u0a40" },
            { "BM", "\u0a2c\u0a30\u0a2e\u0a42\u0a21\u0a3e" },
            { "BN", "\u0a2c\u0a30\u0a42\u0a28\u0a47\u0a08" },
            { "BO", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06" },
            { "BQ", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08 \u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "BR", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32" },
            { "BS", "\u0a2c\u0a39\u0a3e\u0a2e\u0a3e\u0a38" },
            { "BT", "\u0a2d\u0a42\u0a1f\u0a3e\u0a28" },
            { "BV", "\u0a2c\u0a4c\u0a35\u0a47\u0a1f \u0a1f\u0a3e\u0a2a\u0a42" },
            { "BW", "\u0a2c\u0a4b\u0a24\u0a38\u0a35\u0a3e\u0a28\u0a3e" },
            { "BY", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38" },
            { "BZ", "\u0a2c\u0a47\u0a32\u0a40\u0a1c\u0a3c" },
            { "CA", "\u0a15\u0a48\u0a28\u0a47\u0a21\u0a3e" },
            { "CC", "\u0a15\u0a4b\u0a15\u0a4b\u0a38 (\u0a15\u0a40\u0a32\u0a3f\u0a70\u0a17) \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a15\u0a3f\u0a70\u0a38\u0a3c\u0a3e\u0a38\u0a3e" },
            { "CF", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "CG", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a3e\u0a35\u0a3f\u0a32\u0a47" },
            { "CH", "\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "CI", "\u0a15\u0a4b\u0a1f \u0a21\u0a40\u0a35\u0a4b\u0a06\u0a30" },
            { "CK", "\u0a15\u0a41\u0a71\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CL", "\u0a1a\u0a3f\u0a32\u0a40" },
            { "CM", "\u0a15\u0a48\u0a2e\u0a30\u0a42\u0a28" },
            { "CN", "\u0a1a\u0a40\u0a28" },
            { "CO", "\u0a15\u0a4b\u0a32\u0a70\u0a2c\u0a40\u0a06" },
            { "CP", "\u0a15\u0a32\u0a3f\u0a71\u0a2a\u0a30\u0a1f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CR", "\u0a15\u0a4b\u0a38\u0a1f\u0a3e \u0a30\u0a40\u0a15\u0a3e" },
            { "CU", "\u0a15\u0a3f\u0a0a\u0a2c\u0a3e" },
            { "CV", "\u0a15\u0a47\u0a2a \u0a35\u0a30\u0a21\u0a47" },
            { "CW", "\u0a15\u0a41\u0a30\u0a3e\u0a15\u0a3e\u0a13" },
            { "CX", "\u0a15\u0a4d\u0a30\u0a3f\u0a38\u0a2e\u0a3f\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CY", "\u0a38\u0a3e\u0a07\u0a2a\u0a4d\u0a30\u0a38" },
            { "CZ", "\u0a1a\u0a48\u0a15\u0a40\u0a06" },
            { "DE", "\u0a1c\u0a30\u0a2e\u0a28\u0a40" },
            { "DG", "\u0a21\u0a40\u0a07\u0a17\u0a4b \u0a17\u0a3e\u0a30\u0a38\u0a40\u0a06" },
            { "DJ", "\u0a1c\u0a3c\u0a40\u0a2c\u0a42\u0a24\u0a40" },
            { "DK", "\u0a21\u0a48\u0a28\u0a2e\u0a3e\u0a30\u0a15" },
            { "DM", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e" },
            { "DO", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e\u0a08 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "DZ", "\u0a05\u0a32\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "EA", "\u0a38\u0a3f\u0a13\u0a1f\u0a3e \u0a05\u0a24\u0a47 \u0a2e\u0a47\u0a32\u0a3f\u0a71\u0a32\u0a3e" },
            { "EC", "\u0a07\u0a15\u0a35\u0a47\u0a21\u0a4b\u0a30" },
            { "EE", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06" },
            { "EG", "\u0a2e\u0a3f\u0a38\u0a30" },
            { "EH", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a38\u0a39\u0a3e\u0a30\u0a3e" },
            { "ER", "\u0a07\u0a30\u0a40\u0a1f\u0a4d\u0a30\u0a3f\u0a06" },
            { "ES", "\u0a38\u0a2a\u0a47\u0a28" },
            { "ET", "\u0a07\u0a25\u0a4b\u0a2a\u0a40\u0a06" },
            { "EU", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a38\u0a70\u0a18" },
            { "EZ", "\u0a2f\u0a42\u0a30\u0a4b\u0a1c\u0a3c\u0a4b\u0a28" },
            { "FI", "\u0a2b\u0a3f\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "FJ", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a40" },
            { "FK", "\u0a2b\u0a3c\u0a3e\u0a15\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "FM", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "FO", "\u0a2b\u0a48\u0a30\u0a4b \u0a1f\u0a3e\u0a2a\u0a42" },
            { "FR", "\u0a2b\u0a3c\u0a30\u0a3e\u0a02\u0a38" },
            { "GA", "\u0a17\u0a2c\u0a4b\u0a28" },
            { "GB", "\u0a2f\u0a42\u0a28\u0a3e\u0a08\u0a1f\u0a21 \u0a15\u0a3f\u0a70\u0a17\u0a21\u0a2e" },
            { "GD", "\u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a3e" },
            { "GE", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06" },
            { "GF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a17\u0a41\u0a07\u0a06\u0a28\u0a3e" },
            { "GG", "\u0a17\u0a30\u0a28\u0a1c\u0a40" },
            { "GH", "\u0a18\u0a3e\u0a28\u0a3e" },
            { "GI", "\u0a1c\u0a3f\u0a2c\u0a30\u0a3e\u0a32\u0a1f\u0a30" },
            { "GL", "\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "GM", "\u0a17\u0a48\u0a02\u0a2c\u0a40\u0a06" },
            { "GN", "\u0a17\u0a3f\u0a28\u0a40" },
            { "GP", "\u0a17\u0a41\u0a06\u0a21\u0a47\u0a32\u0a4b\u0a2a" },
            { "GQ", "\u0a2d\u0a42-\u0a16\u0a70\u0a21\u0a40 \u0a17\u0a3f\u0a28\u0a40" },
            { "GR", "\u0a17\u0a4d\u0a30\u0a40\u0a38" },
            { "GS", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a48\u0a02\u0a21\u0a35\u0a3f\u0a1a \u0a1f\u0a3e\u0a2a\u0a42" },
            { "GT", "\u0a17\u0a41\u0a06\u0a1f\u0a47\u0a2e\u0a3e\u0a32\u0a3e" },
            { "GU", "\u0a17\u0a41\u0a06\u0a2e" },
            { "GW", "\u0a17\u0a3f\u0a28\u0a40-\u0a2c\u0a3f\u0a38\u0a3e\u0a09" },
            { "GY", "\u0a17\u0a41\u0a2f\u0a3e\u0a28\u0a3e" },
            { "HK", "\u0a39\u0a3e\u0a02\u0a17 \u0a15\u0a3e\u0a02\u0a17 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "HM", "\u0a39\u0a30\u0a21 \u0a24\u0a47 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a3e\u0a32\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "HN", "\u0a39\u0a4b\u0a02\u0a21\u0a41\u0a30\u0a38" },
            { "HR", "\u0a15\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "HT", "\u0a39\u0a48\u0a24\u0a40" },
            { "HU", "\u0a39\u0a70\u0a17\u0a30\u0a40" },
            { "IC", "\u0a15\u0a47\u0a28\u0a3e\u0a30\u0a40 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "ID", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "IE", "\u0a06\u0a07\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "IL", "\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32" },
            { "IM", "\u0a06\u0a07\u0a32 \u0a06\u0a2b \u0a2e\u0a48\u0a28" },
            { "IN", "\u0a2d\u0a3e\u0a30\u0a24" },
            { "IO", "\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40 \u0a39\u0a3f\u0a70\u0a26 \u0a2e\u0a39\u0a3e\u0a02\u0a38\u0a3e\u0a17\u0a30 \u0a16\u0a3f\u0a71\u0a24\u0a3e" },
            { "IQ", "\u0a07\u0a30\u0a3e\u0a15" },
            { "IR", "\u0a08\u0a30\u0a3e\u0a28" },
            { "IS", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21" },
            { "IT", "\u0a07\u0a1f\u0a32\u0a40" },
            { "JE", "\u0a1c\u0a30\u0a38\u0a40" },
            { "JM", "\u0a1c\u0a2e\u0a3e\u0a07\u0a15\u0a3e" },
            { "JO", "\u0a1c\u0a3e\u0a30\u0a21\u0a28" },
            { "JP", "\u0a1c\u0a2a\u0a3e\u0a28" },
            { "KE", "\u0a15\u0a40\u0a28\u0a40\u0a06" },
            { "KG", "\u0a15\u0a3f\u0a30\u0a17\u0a3f\u0a1c\u0a3c\u0a38\u0a24\u0a3e\u0a28" },
            { "KH", "\u0a15\u0a70\u0a2c\u0a4b\u0a21\u0a40\u0a06" },
            { "KI", "\u0a15\u0a3f\u0a30\u0a2c\u0a3e\u0a24\u0a40" },
            { "KM", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a4b\u0a38" },
            { "KN", "\u0a38\u0a47\u0a02\u0a1f \u0a15\u0a3f\u0a1f\u0a38 \u0a10\u0a02\u0a21 \u0a28\u0a47\u0a35\u0a3f\u0a38" },
            { "KP", "\u0a09\u0a71\u0a24\u0a30 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "KR", "\u0a26\u0a71\u0a16\u0a23 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "KW", "\u0a15\u0a41\u0a35\u0a48\u0a24" },
            { "KY", "\u0a15\u0a47\u0a2e\u0a48\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "KZ", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a38\u0a24\u0a3e\u0a28" },
            { "LA", "\u0a32\u0a3e\u0a13\u0a38" },
            { "LB", "\u0a32\u0a48\u0a2c\u0a28\u0a3e\u0a28" },
            { "LC", "\u0a38\u0a47\u0a02\u0a1f \u0a32\u0a42\u0a38\u0a40\u0a06" },
            { "LI", "\u0a32\u0a3f\u0a1a\u0a47\u0a02\u0a38\u0a1f\u0a3e\u0a07\u0a28" },
            { "LK", "\u0a38\u0a4d\u0a30\u0a40 \u0a32\u0a70\u0a15\u0a3e" },
            { "LR", "\u0a32\u0a3e\u0a08\u0a2c\u0a40\u0a30\u0a40\u0a06" },
            { "LS", "\u0a32\u0a47\u0a38\u0a4b\u0a25\u0a4b" },
            { "LT", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a06" },
            { "LU", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17" },
            { "LV", "\u0a32\u0a3e\u0a24\u0a35\u0a40\u0a06" },
            { "LY", "\u0a32\u0a40\u0a2c\u0a40\u0a06" },
            { "MA", "\u0a2e\u0a4b\u0a30\u0a71\u0a15\u0a4b" },
            { "MC", "\u0a2e\u0a4b\u0a28\u0a3e\u0a15\u0a4b" },
            { "MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a4b\u0a35\u0a3e" },
            { "ME", "\u0a2e\u0a4b\u0a02\u0a1f\u0a47\u0a28\u0a47\u0a17\u0a30\u0a4b" },
            { "MF", "\u0a38\u0a47\u0a02\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a3f\u0a28" },
            { "MG", "\u0a2e\u0a48\u0a21\u0a3e\u0a17\u0a3e\u0a38\u0a15\u0a30" },
            { "MH", "\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "MK", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "ML", "\u0a2e\u0a3e\u0a32\u0a40" },
            { "MM", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 (\u0a2c\u0a30\u0a2e\u0a3e)" },
            { "MN", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a06" },
            { "MO", "\u0a2e\u0a15\u0a3e\u0a09 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "MP", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a3e\u0a30\u0a40\u0a06\u0a28\u0a3e \u0a1f\u0a3e\u0a2a\u0a42" },
            { "MQ", "\u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28\u0a3f\u0a15" },
            { "MR", "\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06" },
            { "MS", "\u0a2e\u0a4b\u0a02\u0a1f\u0a38\u0a47\u0a30\u0a3e\u0a24" },
            { "MT", "\u0a2e\u0a3e\u0a32\u0a1f\u0a3e" },
            { "MU", "\u0a2e\u0a4c\u0a30\u0a40\u0a38\u0a3c\u0a38" },
            { "MV", "\u0a2e\u0a3e\u0a32\u0a26\u0a40\u0a35" },
            { "MW", "\u0a2e\u0a32\u0a3e\u0a35\u0a40" },
            { "MX", "\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a4b" },
            { "MY", "\u0a2e\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "MZ", "\u0a2e\u0a4b\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a15" },
            { "NA", "\u0a28\u0a3e\u0a2e\u0a40\u0a2c\u0a40\u0a06" },
            { "NC", "\u0a28\u0a3f\u0a0a \u0a15\u0a48\u0a32\u0a47\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "NE", "\u0a28\u0a3e\u0a08\u0a1c\u0a30" },
            { "NF", "\u0a28\u0a4b\u0a30\u0a2b\u0a4c\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "NG", "\u0a28\u0a3e\u0a08\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "NI", "\u0a28\u0a3f\u0a15\u0a3e\u0a30\u0a3e\u0a17\u0a41\u0a06" },
            { "NL", "\u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "NO", "\u0a28\u0a3e\u0a30\u0a35\u0a47" },
            { "NP", "\u0a28\u0a47\u0a2a\u0a3e\u0a32" },
            { "NR", metaValue_NR },
            { "NU", "\u0a28\u0a3f\u0a2f\u0a42" },
            { "NZ", "\u0a28\u0a3f\u0a0a\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21" },
            { "OM", "\u0a13\u0a2e\u0a3e\u0a28" },
            { "PA", "\u0a2a\u0a28\u0a3e\u0a2e\u0a3e" },
            { "PE", "\u0a2a\u0a47\u0a30\u0a42" },
            { "PF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "PG", "\u0a2a\u0a3e\u0a2a\u0a42\u0a06 \u0a28\u0a3f\u0a0a \u0a17\u0a3f\u0a28\u0a40" },
            { "PH", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a40\u0a28\u0a1c" },
            { "PK", "\u0a2a\u0a3e\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "PL", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21" },
            { "PM", "\u0a38\u0a47\u0a02\u0a1f \u0a2a\u0a40\u0a05\u0a30\u0a47 \u0a10\u0a02\u0a21 \u0a2e\u0a3f\u0a15\u0a47\u0a32\u0a28" },
            { "PN", "\u0a2a\u0a3f\u0a1f\u0a15\u0a47\u0a30\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "PR", "\u0a2a\u0a3f\u0a0a\u0a30\u0a1f\u0a4b \u0a30\u0a3f\u0a15\u0a4b" },
            { "PS", "\u0a2b\u0a3f\u0a32\u0a40\u0a38\u0a24\u0a40\u0a28\u0a40 \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "PT", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32" },
            { "PW", "\u0a2a\u0a32\u0a3e\u0a09" },
            { "PY", "\u0a2a\u0a48\u0a30\u0a3e\u0a17\u0a35\u0a47" },
            { "QA", "\u0a15\u0a24\u0a30" },
            { "QO", "\u0a06\u0a0a\u0a1f\u0a32\u0a3e\u0a07\u0a70\u0a17 \u0a13\u0a38\u0a3c\u0a40\u0a28\u0a40\u0a06" },
            { "RE", "\u0a30\u0a3f\u0a2f\u0a42\u0a28\u0a40\u0a05\u0a28" },
            { "RO", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06" },
            { "RS", "\u0a38\u0a30\u0a2c\u0a40\u0a06" },
            { "RU", "\u0a30\u0a42\u0a38" },
            { "RW", "\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "SA", "\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c" },
            { "SB", "\u0a38\u0a4b\u0a32\u0a4b\u0a2e\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "SC", "\u0a38\u0a47\u0a38\u0a3c\u0a32\u0a38" },
            { "SD", "\u0a38\u0a42\u0a21\u0a3e\u0a28" },
            { "SE", "\u0a38\u0a35\u0a40\u0a21\u0a28" },
            { "SG", "\u0a38\u0a3f\u0a70\u0a17\u0a3e\u0a2a\u0a41\u0a30" },
            { "SH", "\u0a38\u0a47\u0a02\u0a1f \u0a39\u0a47\u0a32\u0a47\u0a28\u0a3e" },
            { "SI", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06" },
            { "SJ", "\u0a38\u0a35\u0a3e\u0a32\u0a2c\u0a30\u0a21 \u0a05\u0a24\u0a47 \u0a1c\u0a3e\u0a28 \u0a2e\u0a3e\u0a2f\u0a47\u0a28" },
            { "SK", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15\u0a40\u0a06" },
            { "SL", "\u0a38\u0a3f\u0a0f\u0a30\u0a3e \u0a32\u0a3f\u0a13\u0a28" },
            { "SM", "\u0a38\u0a48\u0a28 \u0a2e\u0a30\u0a40\u0a28\u0a4b" },
            { "SN", "\u0a38\u0a47\u0a28\u0a47\u0a17\u0a32" },
            { "SO", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40\u0a06" },
            { "SR", "\u0a38\u0a42\u0a30\u0a40\u0a28\u0a3e\u0a2e" },
            { "SS", "\u0a26\u0a71\u0a16\u0a23 \u0a38\u0a41\u0a21\u0a3e\u0a28" },
            { "ST", "\u0a38\u0a3e\u0a13 \u0a1f\u0a4b\u0a2e \u0a05\u0a24\u0a47 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a40\u0a2a\u0a47" },
            { "SV", "\u0a05\u0a32 \u0a38\u0a32\u0a35\u0a3e\u0a21\u0a4b\u0a30" },
            { "SX", "\u0a38\u0a3f\u0a70\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28" },
            { "SY", "\u0a38\u0a40\u0a30\u0a40\u0a06" },
            { "SZ", "\u0a07\u0a38\u0a35\u0a3e\u0a24\u0a40\u0a28\u0a40" },
            { "TA", "\u0a1f\u0a4d\u0a30\u0a3f\u0a38\u0a1f\u0a3e\u0a28 \u0a26\u0a3e \u0a15\u0a41\u0a70\u0a39\u0a3e" },
            { "TC", "\u0a1f\u0a41\u0a30\u0a15\u0a38 \u0a05\u0a24\u0a47 \u0a15\u0a48\u0a15\u0a4b\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "TD", "\u0a1a\u0a3e\u0a21" },
            { "TF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2a\u0a4d\u0a30\u0a26\u0a47\u0a38\u0a3c" },
            { "TG", "\u0a1f\u0a4b\u0a17\u0a4b" },
            { "TH", "\u0a25\u0a3e\u0a08\u0a32\u0a48\u0a02\u0a21" },
            { "TJ", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "TK", "\u0a1f\u0a4b\u0a15\u0a47\u0a32\u0a3e\u0a09" },
            { "TL", "\u0a24\u0a3f\u0a2e\u0a4b\u0a30-\u0a32\u0a47\u0a38\u0a24\u0a47" },
            { "TM", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "TN", "\u0a1f\u0a3f\u0a0a\u0a28\u0a40\u0a38\u0a3c\u0a40\u0a06" },
            { "TO", "\u0a1f\u0a4c\u0a02\u0a17\u0a3e" },
            { "TR", metaValue_TR },
            { "TT", "\u0a1f\u0a4d\u0a30\u0a3f\u0a28\u0a40\u0a21\u0a3e\u0a21 \u0a05\u0a24\u0a47 \u0a1f\u0a4b\u0a2c\u0a3e\u0a17\u0a4b" },
            { "TV", "\u0a1f\u0a41\u0a35\u0a3e\u0a32\u0a42" },
            { "TW", "\u0a24\u0a3e\u0a07\u0a35\u0a3e\u0a28" },
            { "TZ", "\u0a24\u0a28\u0a1c\u0a3c\u0a3e\u0a28\u0a40\u0a06" },
            { "UA", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28" },
            { "UG", "\u0a2f\u0a42\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "UM", "\u0a2f\u0a42.\u0a10\u0a71\u0a38. \u0a26\u0a42\u0a30-\u0a26\u0a41\u0a30\u0a3e\u0a21\u0a47 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "UN", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a30\u0a3e\u0a38\u0a3c\u0a1f\u0a30" },
            { "US", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a30\u0a3e\u0a1c" },
            { "UY", "\u0a09\u0a30\u0a42\u0a17\u0a35\u0a47" },
            { "UZ", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "VA", "\u0a35\u0a48\u0a1f\u0a40\u0a15\u0a28 \u0a38\u0a3f\u0a1f\u0a40" },
            { "VC", "\u0a38\u0a47\u0a02\u0a1f \u0a35\u0a3f\u0a28\u0a38\u0a48\u0a02\u0a1f \u0a10\u0a02\u0a21 \u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a40\u0a28\u0a38" },
            { "VE", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a3e" },
            { "VG", "\u0a2c\u0a4d\u0a30\u0a3f\u0a1f\u0a3f\u0a38\u0a3c \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "VI", "\u0a2f\u0a42 \u0a10\u0a71\u0a38 \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "VN", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e" },
            { "VU", "\u0a35\u0a3e\u0a28\u0a42\u0a06\u0a1f\u0a42" },
            { "WF", "\u0a35\u0a3e\u0a32\u0a3f\u0a38 \u0a05\u0a24\u0a47 \u0a2b\u0a42\u0a1f\u0a42\u0a28\u0a3e" },
            { "WS", "\u0a38\u0a3e\u0a2e\u0a4b\u0a06" },
            { "XA", "\u0a17\u0a32\u0a24-\u0a09\u0a1a\u0a3e\u0a30\u0a28" },
            { "XB", "\u0a32\u0a3f\u0a16\u0a24 \u0a26\u0a40 \u0a17\u0a32\u0a24 \u0a26\u0a3f\u0a38\u0a3c\u0a3e" },
            { "XK", "\u0a15\u0a4b\u0a38\u0a4b\u0a35\u0a4b" },
            { "YE", "\u0a2f\u0a2e\u0a28" },
            { "YT", "\u0a2e\u0a3e\u0a2f\u0a4b\u0a1f\u0a40" },
            { "ZA", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a30\u0a40\u0a15\u0a3e" },
            { "ZM", "\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a06" },
            { "ZW", "\u0a1c\u0a3c\u0a3f\u0a70\u0a2c\u0a3e\u0a2c\u0a35\u0a47" },
            { "ZZ", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a3e \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "aa", "\u0a05\u0a2b\u0a3c\u0a3e\u0a30" },
            { "ab", "\u0a05\u0a2c\u0a16\u0a3e\u0a1c\u0a3c\u0a40\u0a05\u0a28" },
            { "af", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40" },
            { "ak", "\u0a05\u0a15\u0a3e\u0a28" },
            { "am", "\u0a05\u0a2e\u0a39\u0a3e\u0a30\u0a3f\u0a15" },
            { "an", "\u0a05\u0a30\u0a3e\u0a17\u0a4b\u0a28\u0a40" },
            { "ar", metaValue_ar },
            { "as", "\u0a05\u0a38\u0a3e\u0a2e\u0a40" },
            { "av", "\u0a05\u0a35\u0a3e\u0a30\u0a3f\u0a15" },
            { "ay", "\u0a05\u0a08\u0a2e\u0a3e\u0a30\u0a3e" },
            { "az", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28\u0a40" },
            { "ba", "\u0a2c\u0a38\u0a3c\u0a15\u0a40\u0a30" },
            { "be", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38\u0a40" },
            { "bg", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06\u0a08" },
            { "bi", "\u0a2c\u0a3f\u0a38\u0a32\u0a3e\u0a2e\u0a3e" },
            { "bm", "\u0a2c\u0a70\u0a2c\u0a3e\u0a30\u0a3e" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u0a2c\u0a30\u0a47\u0a1f\u0a28" },
            { "bs", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06\u0a08" },
            { "ca", "\u0a15\u0a48\u0a1f\u0a3e\u0a32\u0a3e\u0a28" },
            { "ce", "\u0a1a\u0a47\u0a1a\u0a28" },
            { "ch", "\u0a1a\u0a2e\u0a4b\u0a30\u0a4b" },
            { "co", "\u0a15\u0a4b\u0a30\u0a38\u0a40\u0a15\u0a28" },
            { "cs", "\u0a1a\u0a48\u0a71\u0a15" },
            { "cu", "\u0a1a\u0a30\u0a1a \u0a38\u0a32\u0a3e\u0a35\u0a40" },
            { "cv", "\u0a1a\u0a41\u0a35\u0a3e\u0a38\u0a3c" },
            { "cy", "\u0a35\u0a48\u0a32\u0a38\u0a3c" },
            { "da", "\u0a21\u0a48\u0a28\u0a3f\u0a38\u0a3c" },
            { "de", "\u0a1c\u0a30\u0a2e\u0a28" },
            { "dv", "\u0a26\u0a3f\u0a35\u0a47\u0a39\u0a40" },
            { "dz", "\u0a1c\u0a3c\u0a4b\u0a02\u0a17\u0a16\u0a3e" },
            { "ee", "\u0a08\u0a35\u0a08" },
            { "el", metaValue_el },
            { "en", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "eo", "\u0a07\u0a38\u0a2a\u0a47\u0a30\u0a3e\u0a02\u0a1f\u0a4b" },
            { "es", "\u0a38\u0a2a\u0a47\u0a28\u0a40" },
            { "et", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "eu", "\u0a2c\u0a3e\u0a38\u0a15" },
            { "fa", "\u0a2b\u0a3c\u0a3e\u0a30\u0a38\u0a40" },
            { "ff", "\u0a2b\u0a41\u0a32\u0a3e\u0a39" },
            { "fi", "\u0a2b\u0a3f\u0a28\u0a3f\u0a38\u0a3c" },
            { "fj", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a3c\u0a40" },
            { "fo", "\u0a2b\u0a3c\u0a47\u0a30\u0a4b\u0a38\u0a47" },
            { "fr", "\u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40" },
            { "fy", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2b\u0a4d\u0a30\u0a3f\u0a38\u0a40\u0a05\u0a28" },
            { "ga", "\u0a06\u0a07\u0a30\u0a38\u0a3c" },
            { "gd", "\u0a38\u0a15\u0a3e\u0a1f\u0a3f\u0a38\u0a3c \u0a17\u0a47\u0a32\u0a3f\u0a15" },
            { "gl", "\u0a17\u0a48\u0a32\u0a3f\u0a38\u0a3c\u0a3f\u0a05\u0a28" },
            { "gn", "\u0a17\u0a41\u0a06\u0a30\u0a3e\u0a28\u0a40" },
            { "gu", metaValue_gu },
            { "gv", "\u0a2e\u0a48\u0a02\u0a15\u0a38" },
            { "ha", "\u0a39\u0a4c\u0a38\u0a3e" },
            { "he", metaValue_he },
            { "hi", "\u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "hr", "\u0a15\u0a4d\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a3f\u0a06\u0a08" },
            { "ht", "\u0a39\u0a48\u0a24\u0a40\u0a06\u0a08" },
            { "hu", "\u0a39\u0a70\u0a17\u0a30\u0a40\u0a06\u0a08" },
            { "hy", metaValue_hy },
            { "hz", "\u0a39\u0a30\u0a47\u0a30\u0a4b" },
            { "ia", "\u0a07\u0a70\u0a1f\u0a30\u0a32\u0a3f\u0a70\u0a17\u0a41\u0a06" },
            { "id", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08" },
            { "ig", "\u0a07\u0a17\u0a2c\u0a4b" },
            { "ii", "\u0a38\u0a3f\u0a1a\u0a41\u0a06\u0a28 \u0a2f\u0a40" },
            { "io", "\u0a07\u0a21\u0a42" },
            { "is", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21\u0a3f\u0a15" },
            { "it", "\u0a07\u0a24\u0a3e\u0a32\u0a35\u0a40" },
            { "iu", "\u0a07\u0a70\u0a15\u0a1f\u0a40\u0a1f\u0a42\u0a24" },
            { "ja", metaValue_ja },
            { "jv", "\u0a1c\u0a3e\u0a35\u0a3e\u0a28\u0a40\u0a1c\u0a3c" },
            { "ka", metaValue_ka },
            { "ki", "\u0a15\u0a3f\u0a15\u0a42\u0a2f\u0a42" },
            { "kj", "\u0a15\u0a41\u0a06\u0a28\u0a2f\u0a3e\u0a2e\u0a3e" },
            { "kk", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a3c" },
            { "kl", "\u0a15\u0a32\u0a3e\u0a05\u0a71\u0a32\u0a40\u0a38\u0a41\u0a1f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0a15\u0a28\u0a42\u0a30\u0a40" },
            { "ks", "\u0a15\u0a38\u0a3c\u0a2e\u0a40\u0a30\u0a40" },
            { "ku", "\u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "kv", "\u0a15\u0a4b\u0a2e\u0a40" },
            { "kw", "\u0a15\u0a4b\u0a30\u0a28\u0a3f\u0a38\u0a3c" },
            { "ky", "\u0a15\u0a3f\u0a30\u0a17\u0a40\u0a1c\u0a3c" },
            { "la", metaValue_la },
            { "lb", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17\u0a3f\u0a38\u0a3c" },
            { "lg", "\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "li", "\u0a32\u0a3f\u0a2e\u0a2c\u0a41\u0a30\u0a17\u0a40" },
            { "ln", "\u0a32\u0a3f\u0a70\u0a17\u0a3e\u0a32\u0a3e" },
            { "lo", metaValue_lo },
            { "lt", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a05\u0a28" },
            { "lu", "\u0a32\u0a42\u0a2c\u0a3e-\u0a15\u0a3e\u0a1f\u0a3e\u0a02\u0a17\u0a3e" },
            { "lv", "\u0a32\u0a3e\u0a24\u0a40\u0a35\u0a40" },
            { "mg", "\u0a2e\u0a3e\u0a32\u0a3e\u0a17\u0a48\u0a38\u0a40" },
            { "mh", "\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32\u0a40\u0a1c\u0a3c" },
            { "mi", "\u0a2e\u0a3e\u0a09\u0a30\u0a40" },
            { "mk", "\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "ml", metaValue_ml },
            { "mn", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40" },
            { "mr", "\u0a2e\u0a30\u0a3e\u0a20\u0a40" },
            { "ms", "\u0a2e\u0a32\u0a2f" },
            { "mt", "\u0a2e\u0a3e\u0a32\u0a1f\u0a40\u0a1c\u0a3c" },
            { "my", "\u0a2c\u0a30\u0a2e\u0a40" },
            { "na", metaValue_NR },
            { "nb", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a2c\u0a4b\u0a15\u0a2e\u0a32" },
            { "nd", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a28\u0a21\u0a47\u0a2c\u0a47\u0a32\u0a47" },
            { "ne", "\u0a28\u0a47\u0a2a\u0a3e\u0a32\u0a40" },
            { "ng", "\u0a10\u0a02\u0a21\u0a4b\u0a02\u0a17\u0a3e" },
            { "nl", "\u0a21\u0a71\u0a1a" },
            { "nn", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a28\u0a3f\u0a13\u0a28\u0a4c\u0a30\u0a38\u0a15" },
            { "no", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08" },
            { "nr", "\u0a38\u0a3e\u0a0a\u0a25 \u0a28\u0a21\u0a47\u0a2c\u0a47\u0a32\u0a47" },
            { "nv", "\u0a28\u0a35\u0a3e\u0a1c\u0a4b" },
            { "ny", "\u0a28\u0a2f\u0a3e\u0a02\u0a1c\u0a3e" },
            { "oc", "\u0a13\u0a15\u0a38\u0a40\u0a1f\u0a3e\u0a28" },
            { "om", "\u0a13\u0a30\u0a4b\u0a2e\u0a4b" },
            { "or", metaValue_or },
            { "os", "\u0a13\u0a38\u0a48\u0a1f\u0a3f\u0a15" },
            { "pa", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40" },
            { "pi", "\u0a2a\u0a3e\u0a32\u0a40" },
            { "pl", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21\u0a40" },
            { "ps", "\u0a2a\u0a38\u0a3c\u0a24\u0a4b" },
            { "pt", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40" },
            { "qu", "\u0a15\u0a15\u0a47\u0a38\u0a3c\u0a41\u0a06" },
            { "rm", "\u0a30\u0a4b\u0a2e\u0a3e\u0a02\u0a38\u0a3c" },
            { "rn", "\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "ro", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "ru", "\u0a30\u0a42\u0a38\u0a40" },
            { "rw", "\u0a15\u0a3f\u0a28\u0a3f\u0a06\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "sa", "\u0a38\u0a70\u0a38\u0a15\u0a4d\u0a30\u0a3f\u0a24" },
            { "sc", "\u0a38\u0a3e\u0a30\u0a21\u0a40\u0a28\u0a40\u0a06\u0a08" },
            { "sd", "\u0a38\u0a3f\u0a70\u0a27\u0a40" },
            { "se", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "sg", "\u0a38\u0a3e\u0a02\u0a17\u0a4b" },
            { "si", metaValue_si },
            { "sk", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15" },
            { "sl", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "sm", "\u0a38\u0a3e\u0a2e\u0a4b\u0a28" },
            { "sn", "\u0a38\u0a3c\u0a4b\u0a28\u0a3e" },
            { "so", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40" },
            { "sq", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "sr", "\u0a38\u0a30\u0a2c\u0a40\u0a06\u0a08" },
            { "ss", "\u0a38\u0a35\u0a3e\u0a24\u0a40" },
            { "st", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a4b\u0a25\u0a4b" },
            { "su", metaValue_su },
            { "sv", "\u0a38\u0a35\u0a40\u0a21\u0a3f\u0a38\u0a3c" },
            { "sw", "\u0a38\u0a35\u0a3e\u0a39\u0a3f\u0a32\u0a40" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15" },
            { "th", metaValue_th },
            { "ti", "\u0a24\u0a3f\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a3f\u0a06" },
            { "tk", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28" },
            { "tn", "\u0a24\u0a38\u0a35\u0a3e\u0a28\u0a3e" },
            { "to", "\u0a1f\u0a4c\u0a02\u0a17\u0a28" },
            { "tr", metaValue_TR },
            { "ts", "\u0a38\u0a4b\u0a02\u0a17\u0a3e" },
            { "tt", "\u0a24\u0a24\u0a3e\u0a30" },
            { "tw", "\u0a24\u0a4d\u0a35\u0a3f" },
            { "ty", "\u0a24\u0a3e\u0a39\u0a40\u0a1f\u0a40" },
            { "ug", "\u0a09\u0a07\u0a17\u0a41\u0a30" },
            { "uk", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "ur", "\u0a09\u0a30\u0a26\u0a42" },
            { "uz", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15" },
            { "ve", "\u0a35\u0a47\u0a02\u0a21\u0a3e" },
            { "vi", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40" },
            { "vo", "\u0a35\u0a4b\u0a32\u0a3e\u0a2a\u0a42\u0a15" },
            { "wa", "\u0a35\u0a32\u0a42\u0a28" },
            { "wo", "\u0a35\u0a4b\u0a32\u0a4b\u0a2b" },
            { "xh", "\u0a16\u0a4b\u0a38\u0a3e" },
            { "yi", "\u0a2f\u0a3f\u0a26\u0a3f\u0a38\u0a3c" },
            { "yo", "\u0a2f\u0a4b\u0a30\u0a42\u0a2c\u0a3e" },
            { "zh", "\u0a1a\u0a40\u0a28\u0a40" },
            { "zu", "\u0a1c\u0a3c\u0a41\u0a32\u0a42" },
            { "ace", "\u0a05\u0a1a\u0a40\u0a28\u0a40" },
            { "ach", "\u0a05\u0a15\u0a4b\u0a32\u0a40" },
            { "ada", "\u0a05\u0a21\u0a3e\u0a02\u0a17\u0a2e\u0a47" },
            { "ady", "\u0a05\u0a21\u0a3f\u0a17\u0a47" },
            { "agq", "\u0a05\u0a17\u0a47\u0a2e" },
            { "ain", "\u0a06\u0a07\u0a28\u0a42" },
            { "ale", "\u0a05\u0a32\u0a47\u0a09\u0a1f" },
            { "alt", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a32\u0a24\u0a3e\u0a08" },
            { "ang", "\u0a2a\u0a41\u0a30\u0a3e\u0a23\u0a40 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "ann", "\u0a13\u0a2c\u0a4b\u0a32\u0a4b" },
            { "anp", "\u0a05\u0a70\u0a17\u0a3f\u0a15\u0a3e" },
            { "arn", "\u0a2e\u0a3e\u0a2a\u0a41\u0a1a\u0a47" },
            { "arp", "\u0a05\u0a30\u0a3e\u0a2b\u0a3e\u0a13" },
            { "ars", "\u0a28\u0a3e\u0a1c\u0a26\u0a40 \u0a05\u0a30\u0a2c\u0a40" },
            { "asa", "\u0a05\u0a38\u0a42" },
            { "ast", "\u0a05\u0a38\u0a24\u0a42\u0a30\u0a40" },
            { "atj", "\u0a05\u0a24\u0a3f\u0a15\u0a3e\u0a2e\u0a47\u0a15\u0a35" },
            { "awa", "\u0a05\u0a35\u0a27\u0a40" },
            { "ban", "\u0a2c\u0a3e\u0a32\u0a40\u0a28\u0a40\u0a1c\u0a3c" },
            { "bas", "\u0a2c\u0a3e\u0a38\u0a3e" },
            { "bem", "\u0a2c\u0a47\u0a02\u0a2c\u0a3e" },
            { "bez", "\u0a2c\u0a47\u0a28\u0a3e" },
            { "bgn", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2c\u0a32\u0a42\u0a1a\u0a40" },
            { "bho", "\u0a2d\u0a4b\u0a1c\u0a2a\u0a41\u0a30\u0a40" },
            { "bin", "\u0a2c\u0a3f\u0a28\u0a40" },
            { "bla", "\u0a38\u0a3f\u0a15\u0a38\u0a3f\u0a15\u0a3e" },
            { "brx", "\u0a2c\u0a4b\u0a21\u0a4b" },
            { "bug", "\u0a2c\u0a17\u0a28\u0a40\u0a1c\u0a3c" },
            { "byn", "\u0a2c\u0a32\u0a3f\u0a28" },
            { "cay", "\u0a15\u0a3e\u0a2f\u0a41\u0a17\u0a3e" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0a38\u0a40\u0a2c\u0a42\u0a06\u0a28\u0a4b" },
            { "cgg", "\u0a1a\u0a40\u0a17\u0a3e" },
            { "chk", "\u0a1a\u0a42\u0a15\u0a40\u0a38" },
            { "chm", "\u0a2e\u0a3e\u0a30\u0a40" },
            { "cho", "\u0a1a\u0a4c\u0a15\u0a1f\u0a4b" },
            { "chp", "\u0a1a\u0a3f\u0a2a\u0a35\u0a3f\u0a06\u0a28" },
            { "chr", "\u0a1a\u0a47\u0a30\u0a4b\u0a15\u0a40" },
            { "chy", "\u0a1b\u0a3e\u0a07\u0a06\u0a28" },
            { "ckb", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "clc", "\u0a1a\u0a3f\u0a32\u0a15\u0a4b\u0a1f\u0a3f\u0a28" },
            { "crg", "\u0a2e\u0a3f\u0a1a\u0a3f\u0a2b\u0a4b" },
            { "crj", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a15\u0a4d\u0a30\u0a40" },
            { "crk", "\u0a2a\u0a32\u0a47\u0a28\u0a38 \u0a15\u0a4d\u0a30\u0a40" },
            { "crl", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a15\u0a4d\u0a30\u0a40" },
            { "crm", "\u0a2e\u0a42\u0a1c\u0a3c \u0a15\u0a4d\u0a30\u0a40" },
            { "crr", "\u0a15\u0a48\u0a30\u0a4b\u0a32\u0a40\u0a28\u0a3e \u0a10\u0a32\u0a17\u0a4b\u0a02\u0a15\u0a35\u0a3f\u0a05\u0a28" },
            { "crs", "\u0a38\u0a47\u0a38\u0a47\u0a32\u0a35\u0a3e \u0a15\u0a4d\u0a30\u0a3f\u0a13\u0a32 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a1a" },
            { "csw", "\u0a38\u0a35\u0a48\u0a02\u0a2a\u0a40 \u0a15\u0a4d\u0a30\u0a40" },
            { "dak", "\u0a21\u0a15\u0a4b\u0a1f\u0a3e" },
            { "dar", "\u0a26\u0a3e\u0a30\u0a17\u0a35\u0a3e" },
            { "dav", "\u0a1f\u0a47\u0a1f\u0a3e" },
            { "dgr", "\u0a21\u0a4b\u0a17\u0a30\u0a3f\u0a71\u0a2c" },
            { "dje", "\u0a1c\u0a3c\u0a3e\u0a30\u0a2e\u0a3e" },
            { "doi", "\u0a21\u0a4b\u0a17\u0a30\u0a40" },
            { "dsb", "\u0a32\u0a4b\u0a05\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "dua", "\u0a21\u0a42\u0a06\u0a32\u0a3e" },
            { "dyo", "\u0a1c\u0a4b\u0a32\u0a3e-\u0a2b\u0a4b\u0a07\u0a28\u0a40" },
            { "dzg", "\u0a21\u0a1c\u0a3c\u0a3e\u0a17\u0a3e" },
            { "ebu", "\u0a07\u0a70\u0a2c\u0a42" },
            { "efi", "\u0a10\u0a2b\u0a3f\u0a15" },
            { "egy", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2e\u0a3f\u0a38\u0a30\u0a40" },
            { "eka", "\u0a0f\u0a15\u0a3e\u0a1c\u0a41\u0a15" },
            { "ewo", "\u0a07\u0a35\u0a4b\u0a02\u0a21\u0a4b" },
            { "fil", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a3f\u0a28\u0a4b" },
            { "fon", "\u0a2b\u0a4c\u0a28" },
            { "frc", "\u0a15\u0a47\u0a1c\u0a41\u0a28 \u0a2b\u0a3c\u0a4d\u0a30\u0a48\u0a02\u0a1a" },
            { "frr", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2b\u0a4d\u0a30\u0a40\u0a1c\u0a3c\u0a40\u0a05\u0a28" },
            { "fur", "\u0a2b\u0a30\u0a40\u0a09\u0a32\u0a40\u0a05\u0a28" },
            { "gaa", "\u0a17\u0a3e" },
            { "gag", "\u0a17\u0a3e\u0a17\u0a4c\u0a1c\u0a3c" },
            { "gan", "\u0a1a\u0a40\u0a28\u0a40 \u0a17\u0a3e\u0a28" },
            { "gez", "\u0a1c\u0a40\u0a1c\u0a3c" },
            { "gil", "\u0a17\u0a3f\u0a32\u0a2c\u0a30\u0a24\u0a40\u0a1c\u0a3c" },
            { "gor", "\u0a17\u0a4b\u0a30\u0a4b\u0a02\u0a24\u0a3e\u0a32\u0a4b" },
            { "grc", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40" },
            { "gsw", "\u0a1c\u0a30\u0a2e\u0a28 (\u0a38\u0a35\u0a3f\u0a38)" },
            { "guz", "\u0a17\u0a41\u0a38\u0a40" },
            { "gwi", "\u0a17\u0a35\u0a3f\u0a1a\u2019\u0a07\u0a28" },
            { "hai", "\u0a39\u0a3e\u0a07\u0a21\u0a3e" },
            { "hak", "\u0a1a\u0a40\u0a28\u0a40 \u0a39\u0a3e\u0a15\u0a3e" },
            { "haw", "\u0a39\u0a35\u0a3e\u0a08" },
            { "hax", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a39\u0a3e\u0a07\u0a21\u0a3e" },
            { "hif", "\u0a2b\u0a3f\u0a1c\u0a40 \u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "hil", "\u0a39\u0a3f\u0a32\u0a40\u0a17\u0a47\u0a28\u0a28" },
            { "hmn", "\u0a39\u0a2e\u0a4b\u0a02\u0a17" },
            { "hsb", "\u0a05\u0a71\u0a2a\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "hsn", "\u0a1a\u0a40\u0a28\u0a40 \u0a1c\u0a3c\u0a3f\u0a06\u0a02\u0a17" },
            { "hup", "\u0a39\u0a42\u0a2a\u0a3e" },
            { "hur", "\u0a39\u0a3e\u0a32\u0a15\u0a4b\u0a2e\u0a47\u0a32\u0a2e" },
            { "iba", "\u0a07\u0a2c\u0a3e\u0a28" },
            { "ibb", "\u0a07\u0a2c\u0a40\u0a2c\u0a40\u0a13" },
            { "ikt", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28 \u0a07\u0a28\u0a42\u0a15\u0a1f\u0a40\u0a1f\u0a42\u0a1f" },
            { "ilo", "\u0a07\u0a32\u0a4b\u0a15\u0a4b" },
            { "inh", "\u0a07\u0a70\u0a17\u0a41\u0a38\u0a3c" },
            { "jbo", "\u0a32\u0a4b\u0a1c\u0a2c\u0a3e\u0a28" },
            { "jgo", "\u0a28\u0a17\u0a4b\u0a02\u0a2c\u0a3e" },
            { "jmc", "\u0a2e\u0a1a\u0a3e\u0a2e\u0a47" },
            { "kab", "\u0a15\u0a2c\u0a3e\u0a07\u0a32" },
            { "kac", "\u0a15\u0a3e\u0a1a\u0a3f\u0a28" },
            { "kaj", "\u0a1c\u0a1c\u0a42" },
            { "kam", "\u0a15\u0a70\u0a2c\u0a3e" },
            { "kbd", "\u0a15\u0a2c\u0a3e\u0a30\u0a26\u0a40" },
            { "kcg", "\u0a1f\u0a3e\u0a07\u0a2a" },
            { "kde", "\u0a2e\u0a15\u0a4b\u0a02\u0a21" },
            { "kea", "\u0a15\u0a3e\u0a2c\u0a41\u0a35\u0a47\u0a30\u0a26\u0a3f\u0a06\u0a28\u0a42" },
            { "kfo", "\u0a15\u0a4b\u0a30\u0a4b" },
            { "kgp", "\u0a15\u0a48\u0a28\u0a17\u0a3e\u0a02\u0a17\u0a4b" },
            { "kha", "\u0a16\u0a3e\u0a38\u0a40" },
            { "khq", "\u0a15\u0a4b\u0a2f\u0a30\u0a3e \u0a1a\u0a40\u0a28\u0a40" },
            { "kkj", "\u0a15\u0a3e\u0a15\u0a4b" },
            { "kln", "\u0a15\u0a32\u0a47\u0a1c\u0a3f\u0a28" },
            { "kmb", "\u0a15\u0a3f\u0a2e\u0a2c\u0a41\u0a70\u0a26\u0a42" },
            { "koi", "\u0a15\u0a4b\u0a2e\u0a40-\u0a2a\u0a47\u0a30\u0a2e\u0a3f\u0a06\u0a15" },
            { "kok", "\u0a15\u0a4b\u0a02\u0a15\u0a23\u0a40" },
            { "kpe", "\u0a15\u0a2a\u0a47\u0a32" },
            { "krc", "\u0a15\u0a30\u0a3e\u0a1a\u0a47 \u0a2c\u0a32\u0a15\u0a3e\u0a30" },
            { "krl", "\u0a15\u0a30\u0a40\u0a32\u0a40\u0a05\u0a28" },
            { "kru", "\u0a15\u0a41\u0a30\u0a41\u0a16" },
            { "ksb", "\u0a38\u0a3c\u0a70\u0a2c\u0a3e\u0a32\u0a3e" },
            { "ksf", "\u0a2c\u0a2b\u0a3c\u0a40\u0a06" },
            { "ksh", "\u0a15\u0a32\u0a4b\u0a28\u0a40\u0a05\u0a28" },
            { "kum", "\u0a15\u0a41\u0a2e\u0a40\u0a15" },
            { "kwk", "\u0a15\u0a35\u0a3e\u0a15\u2019\u0a35\u0a3e\u0a32\u0a3e" },
            { "lad", "\u0a32\u0a48\u0a21\u0a40\u0a28\u0a4b" },
            { "lag", "\u0a32\u0a70\u0a17\u0a3e\u0a08" },
            { "lez", "\u0a32\u0a48\u0a1c\u0a3c\u0a17\u0a40" },
            { "lil", "\u0a32\u0a3f\u0a32\u0a42\u0a0f\u0a1f" },
            { "lkt", "\u0a32\u0a15\u0a4b\u0a1f\u0a3e" },
            { "lou", "\u0a32\u0a47\u0a09" },
            { "loz", "\u0a32\u0a4b\u0a1c\u0a3c\u0a40" },
            { "lrc", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a32\u0a41\u0a30\u0a40" },
            { "lsm", "\u0a38\u0a3e\u0a2e\u0a40\u0a06" },
            { "lua", "\u0a32\u0a3f\u0a0a\u0a2c\u0a3e-\u0a32\u0a3f\u0a0a\u0a32\u0a3f\u0a06" },
            { "lun", "\u0a32\u0a41\u0a70\u0a21\u0a3e" },
            { "luo", "\u0a32\u0a42\u0a13" },
            { "lus", "\u0a2e\u0a3f\u0a1c\u0a3c\u0a4b" },
            { "luy", "\u0a32\u0a42\u0a08\u0a06" },
            { "mad", "\u0a2e\u0a3e\u0a21\u0a42\u0a30\u0a40\u0a38" },
            { "mag", "\u0a2e\u0a17\u0a3e\u0a39\u0a40" },
            { "mai", "\u0a2e\u0a48\u0a25\u0a32\u0a40" },
            { "mak", "\u0a2e\u0a15\u0a3e\u0a38\u0a30" },
            { "mas", "\u0a2e\u0a38\u0a3e\u0a08" },
            { "mdf", "\u0a2e\u0a4b\u0a15\u0a38\u0a3c\u0a3e" },
            { "men", "\u0a2e\u0a47\u0a02\u0a21\u0a47" },
            { "mer", "\u0a2e\u0a47\u0a30\u0a42" },
            { "mfe", "\u0a2e\u0a4b\u0a30\u0a40\u0a38\u0a3f\u0a05\u0a28" },
            { "mgh", "\u0a2e\u0a16\u0a4b\u0a35\u0a3e-\u0a2e\u0a3f\u0a71\u0a1f\u0a4b" },
            { "mgo", "\u0a2e\u0a47\u0a1f\u0a3e" },
            { "mic", "\u0a2e\u0a3e\u0a07\u0a2e\u0a48\u0a15" },
            { "min", "\u0a2e\u0a3f\u0a28\u0a3e\u0a02\u0a17\u0a15\u0a3e\u0a2c\u0a3e\u0a13" },
            { "mni", "\u0a2e\u0a28\u0a40\u0a2a\u0a41\u0a30\u0a40" },
            { "moe", "\u0a07\u0a28\u0a42\u0a70-\u0a0f\u0a2e\u0a41\u0a28" },
            { "moh", "\u0a2e\u0a4b\u0a39\u0a06\u0a15" },
            { "mos", "\u0a2e\u0a4b\u0a38\u0a40" },
            { "mua", "\u0a2e\u0a41\u0a70\u0a21\u0a47\u0a02\u0a17" },
            { "mul", "\u0a2c\u0a39\u0a41\u0a24\u0a40\u0a06\u0a02 \u0a2c\u0a4b\u0a32\u0a40\u0a06\u0a02" },
            { "mus", "\u0a15\u0a4d\u0a30\u0a40\u0a15" },
            { "mwl", "\u0a2e\u0a3f\u0a30\u0a3e\u0a02\u0a21\u0a40" },
            { "myv", "\u0a07\u0a30\u0a1c\u0a3c\u0a40\u0a06" },
            { "mzn", "\u0a2e\u0a47\u0a1c\u0a3c\u0a48\u0a02\u0a21\u0a30\u0a3e\u0a28\u0a40" },
            { "nan", "\u0a1a\u0a40\u0a28\u0a40 \u0a2e\u0a3f\u0a28 \u0a28\u0a3e\u0a28" },
            { "nap", "\u0a28\u0a3f\u0a06\u0a2a\u0a4b\u0a32\u0a40\u0a1f\u0a28" },
            { "naq", "\u0a28\u0a3e\u0a2e\u0a3e" },
            { "nds", "\u0a32\u0a4b \u0a1c\u0a30\u0a2e\u0a28" },
            { "new", "\u0a28\u0a47\u0a35\u0a3e\u0a30\u0a40" },
            { "nia", "\u0a28\u0a3f\u0a06\u0a38" },
            { "niu", "\u0a28\u0a3f\u0a0a\u0a0f\u0a08" },
            { "nmg", "\u0a15\u0a35\u0a3e\u0a38\u0a3f\u0a13" },
            { "nnh", "\u0a28\u0a3f\u0a13\u0a2e\u0a2c\u0a42\u0a28" },
            { "nog", "\u0a28\u0a4b\u0a17\u0a3e\u0a08" },
            { "nqo", "\u0a10\u0a02\u0a15\u0a4b" },
            { "nso", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a38\u0a4b\u0a25\u0a4b" },
            { "nus", "\u0a28\u0a41\u0a0f\u0a30" },
            { "nyn", "\u0a28\u0a3f\u0a06\u0a02\u0a15\u0a4b\u0a32\u0a47" },
            { "ojb", "\u0a09\u0a71\u0a24\u0a30-\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a14\u0a1c\u0a3f\u0a2c\u0a35\u0a3e" },
            { "ojc", "\u0a38\u0a48\u0a02\u0a1f\u0a30\u0a32 \u0a14\u0a1c\u0a3f\u0a2c\u0a35\u0a3e" },
            { "ojs", "\u0a13\u0a1c\u0a40-\u0a15\u0a4d\u0a30\u0a40" },
            { "ojw", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a13\u0a1c\u0a3f\u0a2c\u0a35\u0a3e" },
            { "oka", "\u0a13\u0a15\u0a3e\u0a28\u0a3e\u0a17\u0a28" },
            { "pag", "\u0a2a\u0a70\u0a17\u0a3e\u0a38\u0a40\u0a28\u0a3e\u0a28" },
            { "pam", "\u0a2a\u0a48\u0a02\u0a2a\u0a3e\u0a02\u0a17\u0a3e" },
            { "pap", "\u0a2a\u0a3e\u0a2a\u0a3f\u0a06\u0a2e\u0a48\u0a02\u0a1f\u0a4b" },
            { "pau", "\u0a2a\u0a32\u0a3e\u0a0a\u0a35\u0a40" },
            { "pcm", "\u0a28\u0a3e\u0a07\u0a1c\u0a40\u0a30\u0a40\u0a06\u0a08 \u0a2a\u0a3f\u0a21\u0a17\u0a3f\u0a28" },
            { "pis", "\u0a2a\u0a3f\u0a1c\u0a3f\u0a28" },
            { "pqm", "\u0a2e\u0a3e\u0a32\u0a40\u0a38\u0a47\u0a1f-\u0a2a\u0a3e\u0a38\u0a3e\u0a2e\u0a3e\u0a15\u0a35\u0a4b\u0a21\u0a40" },
            { "prg", "\u0a2a\u0a30\u0a42\u0a38\u0a3c\u0a40\u0a06" },
            { "quc", "\u0a15\u0a47\u0a38\u0a3c" },
            { "raj", "\u0a30\u0a3e\u0a1c\u0a38\u0a25\u0a3e\u0a28\u0a40" },
            { "rap", "\u0a30\u0a3e\u0a2a\u0a3e\u0a28\u0a41\u0a08" },
            { "rar", "\u0a30\u0a3e\u0a30\u0a4b\u0a24\u0a4b\u0a02\u0a17\u0a28" },
            { "rhg", "\u0a30\u0a4b\u0a39\u0a3f\u0a70\u0a17\u0a3f\u0a06" },
            { "rof", "\u0a30\u0a4b\u0a2e\u0a2c\u0a4b" },
            { "rup", "\u0a05\u0a30\u0a4b\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08" },
            { "rwk", "\u0a30\u0a35\u0a3e" },
            { "sad", "\u0a38\u0a3e\u0a02\u0a21\u0a4b" },
            { "sah", "\u0a38\u0a3e\u0a16\u0a3e" },
            { "saq", "\u0a38\u0a2e\u0a2c\u0a41\u0a30\u0a42" },
            { "sat", "\u0a38\u0a70\u0a25\u0a3e\u0a32\u0a40" },
            { "sba", "\u0a28\u0a17\u0a3e\u0a02\u0a2c\u0a47" },
            { "sbp", "\u0a38\u0a47\u0a02\u0a17\u0a4b" },
            { "scn", "\u0a38\u0a3f\u0a38\u0a40\u0a32\u0a40\u0a05\u0a28" },
            { "sco", "\u0a38\u0a15\u0a3e\u0a1f\u0a38" },
            { "sdh", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "seh", "\u0a38\u0a47\u0a28\u0a3e" },
            { "ses", "\u0a15\u0a4b\u0a07\u0a30\u0a3e\u0a2c\u0a4b\u0a30\u0a4b \u0a38\u0a47\u0a02\u0a28\u0a40" },
            { "shi", "\u0a1f\u0a1a\u0a47\u0a32\u0a39\u0a3f\u0a1f" },
            { "shn", "\u0a38\u0a3c\u0a3e\u0a28" },
            { "slh", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a32\u0a41\u0a38\u0a3c\u0a42\u0a1f\u0a38\u0a40\u0a21" },
            { "sma", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "smj", "\u0a32\u0a3f\u0a0a\u0a32 \u0a38\u0a3e\u0a2e\u0a40" },
            { "smn", "\u0a07\u0a28\u0a3e\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "sms", "\u0a38\u0a15\u0a4c\u0a32\u0a1f \u0a38\u0a3e\u0a2e\u0a40" },
            { "snk", "\u0a38\u0a4b\u0a28\u0a3f\u0a70\u0a15\u0a47" },
            { "srn", "\u0a38\u0a4d\u0a30\u0a3e\u0a28\u0a3e\u0a28 \u0a1f\u0a4b\u0a02\u0a17\u0a4b" },
            { "ssy", "\u0a38\u0a3e\u0a39\u0a4b" },
            { "str", "\u0a38\u0a1f\u0a30\u0a47\u0a1f\u0a38 \u0a38\u0a48\u0a32\u0a3f\u0a38\u0a3c" },
            { "suk", "\u0a38\u0a41\u0a15\u0a41\u0a2e\u0a3e" },
            { "swb", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a40\u0a05\u0a28" },
            { "syr", metaValue_syr },
            { "tce", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a1f\u0a1a\u0a4b\u0a28" },
            { "tem", "\u0a1f\u0a3f\u0a2e\u0a28\u0a47" },
            { "teo", "\u0a1f\u0a47\u0a38\u0a4b" },
            { "tet", "\u0a1f\u0a47\u0a1f\u0a2e" },
            { "tgx", "\u0a1f\u0a48\u0a17\u0a3f\u0a38\u0a3c" },
            { "tht", "\u0a24\u0a39\u0a3f\u0a32\u0a1f\u0a28" },
            { "tig", "\u0a1f\u0a3f\u0a17\u0a30\u0a3e" },
            { "tlh", "\u0a15\u0a32\u0a3f\u0a70\u0a17\u0a28" },
            { "tli", "\u0a1f\u0a32\u0a3f\u0a70\u0a17\u0a3f\u0a1f" },
            { "tok", "\u0a24\u0a4b\u0a15\u0a40 \u0a2a\u0a4b\u0a28\u0a3e" },
            { "tpi", "\u0a1f\u0a4b\u0a15 \u0a2a\u0a3f\u0a38\u0a3f\u0a28" },
            { "trv", "\u0a1f\u0a3e\u0a30\u0a4b\u0a15\u0a4b" },
            { "ttm", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a1f\u0a1a\u0a4b\u0a28" },
            { "tum", "\u0a24\u0a41\u0a70\u0a2c\u0a41\u0a15\u0a3e" },
            { "tvl", "\u0a1f\u0a3f\u0a0a\u0a35\u0a3e\u0a32\u0a42" },
            { "twq", "\u0a24\u0a3e\u0a38\u0a3e\u0a35\u0a3f\u0a15" },
            { "tyv", "\u0a24\u0a41\u0a35\u0a40\u0a28\u0a40\u0a05\u0a28" },
            { "tzm", "\u0a2e\u0a71\u0a27 \u0a10\u0a1f\u0a32\u0a38 \u0a24\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a24" },
            { "udm", "\u0a09\u0a26\u0a2e\u0a41\u0a30\u0a24" },
            { "umb", "\u0a09\u0a2e\u0a2c\u0a41\u0a70\u0a21\u0a42" },
            { "und", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a40 \u0a2c\u0a4b\u0a32\u0a40" },
            { "vai", metaValue_vai },
            { "vun", "\u0a35\u0a42\u0a70\u0a1c\u0a4b" },
            { "wae", "\u0a35\u0a3e\u0a32\u0a38\u0a30" },
            { "wal", "\u0a35\u0a4b\u0a32\u0a3e\u0a0f\u0a1f\u0a3e" },
            { "war", "\u0a35\u0a48\u0a30\u0a47" },
            { "wbp", "\u0a35\u0a3e\u0a32\u0a2a\u0a41\u0a30\u0a40" },
            { "wuu", "\u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a42" },
            { "xal", "\u0a15\u0a3e\u0a32\u0a2e\u0a3f\u0a15" },
            { "xog", "\u0a38\u0a4b\u0a17\u0a3e" },
            { "yav", "\u0a2f\u0a3e\u0a02\u0a17\u0a2c\u0a47\u0a28" },
            { "ybb", "\u0a2f\u0a47\u0a02\u0a2c\u0a3e" },
            { "yrl", "\u0a28\u0a39\u0a40\u0a02\u0a17\u0a3e\u0a24\u0a42" },
            { "yue", "\u0a15\u0a48\u0a02\u0a1f\u0a4b\u0a28\u0a40\u0a1c\u0a3c" },
            { "zgh", "\u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a2e\u0a4b\u0a30\u0a4b\u0a15\u0a47\u0a28 \u0a1f\u0a3e\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a15" },
            { "zun", "\u0a1c\u0a3c\u0a42\u0a28\u0a40" },
            { "zxx", "\u0a2c\u0a4b\u0a32\u0a40 \u0a38\u0a70\u0a2c\u0a70\u0a27\u0a40 \u0a15\u0a4b\u0a08 \u0a38\u0a2e\u0a71\u0a17\u0a30\u0a40 \u0a28\u0a39\u0a40\u0a02" },
            { "zza", "\u0a1c\u0a3c\u0a3e\u0a1c\u0a3c\u0a3e" },
            { "Adlm", "\u0a05\u0a26\u0a32\u0a3e\u0a2e" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0a28\u0a38\u0a24\u0a3e\u0a32\u0a40\u0a15" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "\u0a2c\u0a4b\u0a2a\u0a4b\u0a2e\u0a4b\u0a2b\u0a4b" },
            { "Brai", "\u0a2c\u0a30\u0a47\u0a32" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u0a2f\u0a42\u0a28\u0a40\u0a2b\u0a3e\u0a08\u0a21 \u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28 \u0a10\u0a2c\u0a4b\u0a30\u0a3f\u0a1c\u0a3f\u0a28\u0a32 \u0a38\u0a3f\u0a32\u0a47\u0a2c\u0a3f\u0a15\u0a38" },
            { "Cher", "\u0a1a\u0a48\u0a30\u0a4b\u0a15\u0a40" },
            { "Cyrl", "\u0a38\u0a3f\u0a30\u0a3f\u0a32\u0a3f\u0a15" },
            { "Deva", "\u0a26\u0a47\u0a35\u0a28\u0a3e\u0a17\u0a30\u0a40" },
            { "Ethi", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0a17\u0a41\u0a30\u0a2e\u0a41\u0a16\u0a40" },
            { "Hanb", "\u0a39\u0a3e\u0a02\u0a2c" },
            { "Hang", "\u0a39\u0a70\u0a17\u0a41\u0a32" },
            { "Hani", "\u0a39\u0a3e\u0a28" },
            { "Hans", "\u0a38\u0a30\u0a32" },
            { "Hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0a39\u0a3f\u0a30\u0a3e\u0a17\u0a3e\u0a28\u0a3e" },
            { "Hrkt", "\u0a1c\u0a3e\u0a2a\u0a3e\u0a28\u0a40 \u0a38\u0a3f\u0a32\u0a47\u0a2c\u0a30\u0a40\u0a1c\u0a3c" },
            { "Jamo", "\u0a1c\u0a3e\u0a2e\u0a4b" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u0a15\u0a3e\u0a1f\u0a3e\u0a15\u0a3e\u0a28\u0a3e" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a05\u0a28" },
            { "Mtei", "\u0a2e\u0a3f\u0a24\u0a47\u0a08 \u0a2e\u0a3e\u0a0f\u0a15" },
            { "Mymr", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30" },
            { "Nkoo", "\u0a10\u0a28\u2019\u0a15\u0a4b" },
            { "Olck", "\u0a13\u0a32 \u0a1a\u0a40\u0a15\u0a40" },
            { "Orya", metaValue_or },
            { "Rohg", "\u0a39\u0a28\u0a40\u0a2b\u0a40" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u0a1f\u0a3f\u0a2b\u0a40\u0a28\u0a3e\u0a18" },
            { "Thaa", "\u0a25\u0a3e\u0a28\u0a3e" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "\u0a2f\u0a40" },
            { "Zmth", "\u0a17\u0a23\u0a3f\u0a24 \u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39-\u0a32\u0a3f\u0a2a\u0a40" },
            { "Zsye", "\u0a07\u0a2e\u0a4b\u0a1c\u0a40" },
            { "Zsym", "\u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39" },
            { "Zxxx", "\u0a05\u0a32\u0a3f\u0a16\u0a24" },
            { "Zyyy", "\u0a38\u0a27\u0a3e\u0a30\u0a28" },
            { "Zzzz", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a40 \u0a32\u0a3f\u0a2a\u0a40" },
            { "de_AT", "\u0a1c\u0a30\u0a2e\u0a28 (\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06\u0a08)" },
            { "de_CH", "\u0a39\u0a3e\u0a08 \u0a1c\u0a30\u0a2e\u0a28 (\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21)" },
            { "en_GB", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40 (\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40)" },
            { "en_US", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40 (\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40)" },
            { "es_ES", "\u0a38\u0a2a\u0a47\u0a28\u0a40 (\u0a2f\u0a42\u0a30\u0a2a\u0a40)" },
            { "fa_AF", "\u0a26\u0a3e\u0a30\u0a40" },
            { "fr_CA", "\u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40 (\u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28)" },
            { "nl_BE", "\u0a2b\u0a32\u0a48\u0a2e\u0a3f\u0a38\u0a3c" },
            { "pt_BR", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40 (\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40)" },
            { "pt_PT", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40 (\u0a2f\u0a42\u0a30\u0a2a\u0a40)" },
            { "ro_MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a3e\u0a35\u0a40\u0a06\u0a08" },
            { "sw_CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b \u0a38\u0a35\u0a3e\u0a07\u0a32\u0a40" },
            { "ar_001", "\u0a06\u0a27\u0a41\u0a28\u0a3f\u0a15 \u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a05\u0a30\u0a2c\u0a40" },
            { "es_419", "\u0a38\u0a2a\u0a47\u0a28\u0a40 (\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40)" },
            { "key.ca", "\u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "key.cf", "\u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "key.co", "\u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "key.cu", "\u0a2e\u0a41\u0a26\u0a30\u0a3e" },
            { "key.hc", "\u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a3e \u0a1a\u0a71\u0a15\u0a30 (12 \u0a2c\u0a28\u0a3e\u0a2e 24)" },
            { "key.lb", "\u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "key.ms", "\u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "key.nu", "\u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "nds_NL", "\u0a32\u0a4b \u0a38\u0a48\u0a15\u0a38\u0a28" },
            { "type.ca.roc", "\u0a2e\u0a3f\u0a70\u0a17\u0a42\u0a13 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.hc.h11", "12 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (0\u201311)" },
            { "type.hc.h12", "12 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (1\u201312)" },
            { "type.hc.h23", "24 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (0\u201323)" },
            { "type.hc.h24", "24 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (1\u201324)" },
            { "type.nu.arab", "\u0a05\u0a30\u0a2c\u0a40-\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.armn", "\u0a06\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a05\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.beng", "\u0a2c\u0a70\u0a17\u0a3e\u0a32\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.brah", "\u0a2c\u0a30\u0a3e\u0a39\u0a2e\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.cakm", "\u0a1a\u0a15\u0a2e\u0a3e \u0a05\u0a70\u0a15" },
            { "type.nu.deva", "\u0a26\u0a47\u0a35\u0a28\u0a3e\u0a17\u0a30\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.ethi", "\u0a10\u0a25\u0a3f\u0a13\u0a2a\u0a3f\u0a15 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.geor", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a05\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.grek", "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.gujr", "\u0a17\u0a41\u0a1c\u0a30\u0a3e\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.guru", "\u0a17\u0a41\u0a30\u0a2e\u0a41\u0a16\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.hans", "\u0a38\u0a30\u0a32 \u0a1a\u0a40\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a1a\u0a40\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hebr", "\u0a39\u0a3f\u0a2c\u0a30\u0a42 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.java", "\u0a1c\u0a3e\u0a35\u0a3e\u0a28\u0a40\u0a1c\u0a3c \u0a05\u0a70\u0a15" },
            { "type.nu.jpan", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.khmr", "\u0a16\u0a2e\u0a47\u0a30 \u0a05\u0a70\u0a15" },
            { "type.nu.knda", "\u0a15\u0a70\u0a28\u0a5c \u0a05\u0a70\u0a15" },
            { "type.nu.laoo", "\u0a32\u0a3e\u0a13 \u0a05\u0a70\u0a15" },
            { "type.nu.latn", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.mlym", "\u0a2e\u0a32\u0a3f\u0a06\u0a32\u0a2e \u0a05\u0a70\u0a15" },
            { "type.nu.mong", "\u0a2e\u0a70\u0a17\u0a4b\u0a32 \u0a05\u0a70\u0a15" },
            { "type.nu.mtei", "\u0a2e\u0a3f\u0a24\u0a47\u0a08 \u0a2e\u0a3e\u0a0f\u0a15 \u0a05\u0a70\u0a15" },
            { "type.nu.mymr", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 \u0a05\u0a70\u0a15" },
            { "type.nu.olck", "\u0a13\u0a32 \u0a1a\u0a40\u0a15\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.orya", "\u0a09\u0a5c\u0a40\u0a06 \u0a05\u0a70\u0a15" },
            { "type.nu.taml", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a24\u0a2e\u0a3f\u0a32 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.telu", "\u0a24\u0a47\u0a32\u0a17\u0a42 \u0a05\u0a70\u0a15" },
            { "type.nu.thai", "\u0a25\u0a3e\u0a08 \u0a05\u0a70\u0a15" },
            { "type.nu.tibt", "\u0a24\u0a3f\u0a71\u0a2c\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.vaii", "\u0a35\u0a3e\u0a08 \u0a05\u0a70\u0a15" },
            { "type.ca.dangi", "\u0a21\u0a3e\u0a02\u0a17\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.co.ducet", "\u0a2e\u0a42\u0a32 \u0a2f\u0a42\u0a28\u0a40\u0a15\u0a4b\u0a21 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "type.lb.loose", "\u0a16\u0a41\u0a71\u0a32\u0a4d\u0a39\u0a40 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "type.nu.roman", "\u0a30\u0a4b\u0a2e\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.ca.coptic", "\u0a15\u0a4b\u0a2a\u0a1f\u0a3f\u0a15 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.hebrew", "\u0a39\u0a3f\u0a2c\u0a30\u0a42 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.indian", "\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a15\u0a4c\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.co.compat", "\u0a2a\u0a3f\u0a1b\u0a32\u0a3e \u0a24\u0a30\u0a24\u0a40\u0a2c \u0a35\u0a3e\u0a30 \u0a15\u0a4d\u0a30\u0a2e, \u0a05\u0a28\u0a41\u0a30\u0a42\u0a2a\u0a24\u0a3e \u0a32\u0a08" },
            { "type.co.search", "\u0a06\u0a2e-\u0a2e\u0a70\u0a24\u0a35 \u0a16\u0a4b\u0a1c" },
            { "type.lb.normal", "\u0a38\u0a27\u0a3e\u0a30\u0a28 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "type.lb.strict", "\u0a2a\u0a71\u0a15\u0a40 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "type.ms.metric", "\u0a2e\u0a40\u0a1f\u0a30\u0a3f\u0a15 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "type.ca.chinese", "\u0a1a\u0a40\u0a28\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.islamic", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.iso8601", "(ISO-8601) \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.persian", "\u0a2b\u0a3c\u0a3e\u0a30\u0a38\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.cf.account", "\u0a32\u0a47\u0a16\u0a3e \u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "type.nu.arabext", "\u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30\u0a3f\u0a24 \u0a05\u0a30\u0a2c\u0a40-\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "type.nu.armnlow", "\u0a06\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a05\u0a28 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.greklow", "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hanidec", "\u0a1a\u0a40\u0a28\u0a40 \u0a26\u0a38\u0a3c\u0a2e\u0a32\u0a35 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hansfin", "\u0a38\u0a30\u0a32 \u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hantfin", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.jpanfin", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.tamldec", "\u0a24\u0a2e\u0a3f\u0a32 \u0a05\u0a70\u0a15" },
            { "type.ca.buddhist", "\u0a2c\u0a4b\u0a27\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.ethiopic", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.ca.japanese", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.cf.standard", "\u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "type.co.standard", "\u0a38\u0a27\u0a3e\u0a30\u0a28 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "type.ms.uksystem", "\u0a07\u0a70\u0a2a\u0a40\u0a30\u0a40\u0a05\u0a32 \u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "type.ms.ussystem", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40 \u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "type.nu.fullwide", "\u0a2a\u0a42\u0a30\u0a28 \u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30 \u0a05\u0a70\u0a15" },
            { "type.nu.romanlow", "\u0a30\u0a4b\u0a2e\u0a28 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.ca.gregorian", "\u0a17\u0a30\u0a47\u0a17\u0a4b\u0a30\u0a40\u0a05\u0a28 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.co.dictionary", "\u0a38\u0a3c\u0a2c\u0a26-\u0a15\u0a4b\u0a38\u0a3c \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "type.co.traditional", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "type.ca.islamic-rgsa", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c, \u0a1a\u0a70\u0a28 \u0a26\u0a3f\u0a16\u0a23\u0a3e)" },
            { "type.ca.islamic-tbla", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a1f\u0a47\u0a2c\u0a32\u0a30, \u0a16\u0a17\u0a4b\u0a32\u0a40 \u0a2f\u0a41\u0a71\u0a17)" },
            { "type.ca.islamic-civil", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a38\u0a3e\u0a30\u0a28\u0a40\u0a2c\u0a71\u0a27, \u0a38\u0a2e\u0a3e\u0a1c\u0a3f\u0a15 \u0a2f\u0a41\u0a71\u0a17)" },
            { "type.ca.islamic-umalqura", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a05\u0a2e \u0a05\u0a32-\u0a15\u0a41\u0a30\u0a3e)" },
            { "type.ca.ethiopic-amete-alem", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15-\u0a05\u0a2e\u0a40\u0a1f-\u0a06\u0a32\u0a2e" },
        };
        return data;
    }
}
