/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "isi-Arabic";
        final String metaValue_el = "isi-Greek";
        final String metaValue_gu = "isi-Gujarati";
        final String metaValue_he = "isi-Hebrew";
        final String metaValue_ja = "isi-Japanese";
        final String metaValue_jv = "isi-Javanese";
        final String metaValue_ka = "isi-Georgian";
        final String metaValue_km = "isi-Khmer";
        final String metaValue_kn = "isi-Kannada";
        final String metaValue_ko = "isi-Korean";
        final String metaValue_la = "isi-Latin";
        final String metaValue_lo = "isi-Lao";
        final String metaValue_ml = "isi-Malayalam";
        final String metaValue_mn = "isi-Mongolian";
        final String metaValue_or = "isi-Odia";
        final String metaValue_si = "isi-Sinhala";
        final String metaValue_su = "isi-Sundanese";
        final String metaValue_ta = "isi-Tamil";
        final String metaValue_te = "isi-Telugu";
        final String metaValue_th = "isi-Thai";
        final String metaValue_ban = "isi-Balinese";
        final String metaValue_bug = "isi-Buginese";
        final String metaValue_chr = "isi-Cherokee";
        final String metaValue_nqo = "isi-N\u2019Ko";
        final String metaValue_syr = "isi-Syriac";
        final String metaValue_vai = "isi-Vai";
        final String metaValue_type_nu_taml = "izinombolo zesi-Tamil";
        final Object[][] data = new Object[][] {
            { "ksh", "isi-Colognian" },
            { "Ogam", "i-Ogham" },
            { "mwl", "isi-Mirandese" },
            { "Zsym", "amasimbuli" },
            { "type.nu.lanatham", "Izinombolo ze-Tai Tham Tham" },
            { "Tagb", "i-Tagbanwa" },
            { "Zsye", "i-Emoji" },
            { "%%NJIVA", "Ulwimi lwesi-Gniva/Njiva" },
            { "ccp", "i-Chakma" },
            { "Phag", "i-Phags-pa" },
            { "tem", "isi-Timne" },
            { "Medf", "i-Medefaidrin" },
            { "type.nu.sind", "Izinombolo ze-Khudawadi" },
            { "teo", "isi-Teso" },
            { "rap", "isi-Rapanui" },
            { "AC", "i-Ascension Island" },
            { "rar", "isi-Rarotongan" },
            { "tet", "isi-Tetum" },
            { "%%BARLA", "Iqembu lolwomi lwesi-Barlavento lwe-Kabuverdianu" },
            { "type.nu.sinh", "Izinombolo ze-Sinhala Lith" },
            { "AD", "i-Andorra" },
            { "AE", "i-United Arab Emirates" },
            { "nl_BE", "isi-Flemish" },
            { "AF", "i-Afghanistan" },
            { "AG", "i-Antigua ne-Barbuda" },
            { "type.nu.mroo", "Izinombolo ze-Mro" },
            { "type.ca.ethiopic", "Ikhalenda lesi-Ethiopic" },
            { "AI", "i-Anguilla" },
            { "key.tz", "Isikhathi Sendawo" },
            { "AL", "i-Albania" },
            { "AM", "i-Armenia" },
            { "AO", "i-Angola" },
            { "AQ", "i-Antarctica" },
            { "AR", "i-Argentina" },
            { "Prti", "i-Inscriptional Parthian" },
            { "AS", "i-American Samoa" },
            { "AT", "i-Austria" },
            { "AU", "i-Australia" },
            { "AW", "i-Aruba" },
            { "en_US", "i-American English" },
            { "AX", "i-\u00c5land Islands" },
            { "AZ", "i-Azerbaijan" },
            { "BA", "i-Bosnia ne-Herzegovina" },
            { "BB", "i-Barbados" },
            { "ceb", "isi-Cebuano" },
            { "BD", "i-Bangladesh" },
            { "kum", "isi-Kumyk" },
            { "BE", "i-Belgium" },
            { "Sogo", "i-Old Sogdian" },
            { "BF", "i-Burkina Faso" },
            { "BG", "i-Bulgaria" },
            { "BH", "i-Bahrain" },
            { "BI", "i-Burundi" },
            { "BJ", "i-Benin" },
            { "BL", "i-Saint Barth\u00e9lemy" },
            { "BM", "i-Bermuda" },
            { "myv", "isi-Erzya" },
            { "BN", "i-Brunei" },
            { "BO", "i-Bolivia" },
            { "BQ", "i-Caribbean Netherlands" },
            { "BR", "i-Brazil" },
            { "BS", "i-Bahamas" },
            { "xog", "isi-Soga" },
            { "BT", "i-Bhutan" },
            { "BV", "i-Bouvet Island" },
            { "BW", "iBotswana" },
            { "BY", "i-Belarus" },
            { "BZ", "i-Belize" },
            { "type.ca.persian", "Ikhalenda lesi-Persian" },
            { "%%CREISS", "i-CREISS" },
            { "type.nu.hebr", "izinombolo zesi-Hebrew" },
            { "CA", "i-Canada" },
            { "Kits", "i-Khitan small script" },
            { "CC", "i-Cocos (Keeling) Islands" },
            { "mzn", "isi-Mazanderani" },
            { "CD", "i-Congo - Kinshasa" },
            { "CF", "i-Central African Republic" },
            { "CG", "i-Congo - Brazzaville" },
            { "CH", "i-Switzerland" },
            { "CI", "i-C\u00f4te d\u2019Ivoire" },
            { "CK", "i-Cook Islands" },
            { "CL", "i-Chile" },
            { "Kthi", "isi-Kaithi" },
            { "CM", "i-Cameroon" },
            { "CN", "i-China" },
            { "CO", "i-Colombia" },
            { "CP", "i-Clipperton Island" },
            { "CR", "i-Costa Rica" },
            { "CU", "i-Cuba" },
            { "CV", "i-Cape Verde" },
            { "CW", "i-Cura\u00e7ao" },
            { "CX", "i-Christmas Island" },
            { "CY", "i-Cyprus" },
            { "type.nu.bali", "Izinombolo ze-Balinese" },
            { "CZ", "i-Czechia" },
            { "eka", "isi-Ekajuk" },
            { "Ahom", "isi-Ahom" },
            { "Pauc", "i-Pau Cin Hau" },
            { "%%RIGIK", "I-Volap\u00fck Yakudala" },
            { "Sogd", "i-Sogdian" },
            { "DE", "i-Germany" },
            { "ace", "isi-Achinese" },
            { "cgg", "isi-Chiga" },
            { "DG", "i-Diego Garcia" },
            { "type.nu.deva", "izinombolo zesi-Devanagari" },
            { "DJ", "i-Djibouti" },
            { "DK", "i-Denmark" },
            { "ach", "isi-Acoli" },
            { "Brai", "i-Braille" },
            { "Brah", "isi-Brahmi" },
            { "DM", "i-Dominica" },
            { "type.nu.armnlow", "izinombolo ezincane zesi-Armenian" },
            { "DO", "i-Dominican Republic" },
            { "gor", "isi-Gorontalo" },
            { "Mtei", "isi-Meitei Mayek" },
            { "zun", "isi-Zuni" },
            { "tig", "isi-Tigre" },
            { "Takr", "i-Takri" },
            { "DZ", "i-Algeria" },
            { "pag", "isi-Pangasinan" },
            { "type.d0.hwidth", "Ubude obuhhafu" },
            { "EA", "i-Cueta ne-Melilla" },
            { "pam", "isi-Pampanga" },
            { "EC", "i-Ecuador" },
            { "pap", "isi-Papiamento" },
            { "ada", "isi-Adangme" },
            { "EE", "i-Estonia" },
            { "EG", "i-Egypt" },
            { "EH", "i-Western Sahara" },
            { "pau", "isi-Palauan" },
            { "chk", "isi-Chuukese" },
            { "chm", "isi-Mari" },
            { "cho", "isi-Choctaw" },
            { "type.nu.mathbold", "Izinombolo ze-Mathematical Bold" },
            { "chr", metaValue_chr },
            { "ER", "i-Eritrea" },
            { "ES", "i-Spain" },
            { "ET", "i-Ethiopia" },
            { "EU", "i-European Union" },
            { "type.ca.gregorian", "ikhalenda lesi-Gregorian" },
            { "EZ", "I-Eurozone" },
            { "chy", "isi-Cheyenne" },
            { "type.nu.gujr", "amadijithi esi-Gujarati" },
            { "ady", "isi-Adyghe" },
            { "FI", "i-Finland" },
            { "FJ", "i-Fiji" },
            { "FK", "i-Falkland Islands" },
            { "FM", "i-Micronesia" },
            { "key.va", "Okokwehlukanisa Kwasendaweni" },
            { "FO", "i-Faroe Islands" },
            { "Taml", metaValue_ta },
            { "FR", "i-France" },
            { "%%SIMPLE", "OKULULA" },
            { "%%DAJNKO", "Uhlamvu lwe-Dajnko" },
            { "type.ca.indian", "i-Indian National Calender" },
            { "GA", "i-Gabon" },
            { "GB", "i-United Kingdom" },
            { "pcm", "isi-Nigerian Pidgin" },
            { "GD", "i-Grenada" },
            { "GE", "i-Georgia" },
            { "GF", "i-French Guiana" },
            { "GG", "i-Guernsey" },
            { "GH", "i-Ghana" },
            { "Tale", "isi-Tai Le" },
            { "GI", "i-Gibraltar" },
            { "GL", "i-Greenland" },
            { "GM", "i-Gambia" },
            { "GN", "i-Guinea" },
            { "GP", "i-Guadeloupe" },
            { "GQ", "i-Equatorial Guinea" },
            { "GR", "i-Greece" },
            { "GS", "i-South Georgia ne-South Sandwich Islands" },
            { "GT", "i-Guatemala" },
            { "GU", "i-Guam" },
            { "type.nu.mathmono", "Izinombolo ze-Mathematical Monospace" },
            { "GW", "i-Guinea-Bissau" },
            { "rhg", "Rohingya" },
            { "tlh", "isi-Klingon" },
            { "Talu", "isi-New Tai Lue" },
            { "GY", "i-Guyana" },
            { "ckb", "isi-Central Kurdish" },
            { "zxx", "akukho okuqukethwe kolimi" },
            { "%%VIVARAUP", "i-VIVARAUP" },
            { "de_AT", "isi-Austrian German" },
            { "Vaii", metaValue_vai },
            { "HK", "i-Hong Kong SAR China" },
            { "HM", "I-Heard & McDonald Island" },
            { "HN", "i-Honduras" },
            { "HR", "i-Croatia" },
            { "agq", "isi-Aghem" },
            { "gsw", "isi-Swiss German" },
            { "type.ca.islamic-umalqura", "Ikhalenda yesi-Islamic (Umm al-Qura)" },
            { "HT", "i-Haiti" },
            { "HU", "i-Hungary" },
            { "IC", "i-Canary Islands" },
            { "nan", "isi-Min Nan Chinese" },
            { "ID", "i-Indonesia" },
            { "Adlm", "isi-Adlam" },
            { "type.nu.kali", "Izinombolo ze-Kayah Li" },
            { "IE", "i-Ireland" },
            { "nap", "isi-Neapolitan" },
            { "%%NDYUKA", "Ulwimi lwesi-Ndyuka" },
            { "naq", "isi-Nama" },
            { "type.nu.sora", "Izinombolo ze-Sora Sompeng" },
            { "zza", "isi-Zaza" },
            { "Tang", "i-Tangut" },
            { "IL", "kwa-Israel" },
            { "Nbat", "i-Nabataean" },
            { "IM", "i-Isle of Man" },
            { "IN", "i-India" },
            { "type.co.eor", "Imithetho Yokuhlunga ye-European" },
            { "IO", "i-British Indian Ocean Territory" },
            { "IQ", "i-Iraq" },
            { "IR", "i-Iran" },
            { "IS", "i-Iceland" },
            { "IT", "i-Italy" },
            { "Zmth", "i-Mathematical Notation" },
            { "type.nu.thai", "amadijithi esi-Thai" },
            { "%%POSIX", "Ikhompyutha" },
            { "type.nu.beng", "izinombolo zesi-Bengali" },
            { "type.nu.cyrl", "Izinombolo ze-Cyrillic" },
            { "JE", "i-Jersey" },
            { "type.ca.islamic", "Ikhalenda lesi-Islamic" },
            { "JM", "i-Jamaica" },
            { "Beng", "isi-Bangla" },
            { "%%EKAVSK", "isi-Serbian esinokuphimisa kwe-Ekavian" },
            { "JO", "i-Jordan" },
            { "JP", "i-Japan" },
            { "%%1606NICT", "Isi-French esimaphakathi kuya ku-1606" },
            { "ain", "isi-Ainu" },
            { "%%KOCIEWIE", "i-KOCIEWIE" },
            { "Mend", "i-Mende" },
            { "guz", "isi-Gusli" },
            { "type.nu.knda", "amadijithi esi-Kannada" },
            { "Kali", "isi-Kayah Li" },
            { "Sidd", "i-Siddham" },
            { "de_CH", "Isi-Swiss High German" },
            { "type.co.phonetic", "Hlela Ngokwefonetiki" },
            { "type.ca.buddhist", "ikhalenda lesi-Buddhist" },
            { "KE", "i-Kenya" },
            { "419", "i-Latin America" },
            { "KG", "i-Kyrgyzstan" },
            { "KH", "i-Cambodia" },
            { "KI", "i-Kiribati" },
            { "KM", "i-Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "i-Saint Kitts ne-Nevis" },
            { "Zinh", "Okuthethwe" },
            { "fr_CA", "isi-Canadian French" },
            { "KP", "i-North Korea" },
            { "KR", "i-South Korea" },
            { "Plrd", "isi-Pollard Phonetic" },
            { "fr_CH", "isi-Swiss French" },
            { "KW", "i-Kuwait" },
            { "tpi", "isi-Tok Pisin" },
            { "KY", "i-Cayman Islands" },
            { "KZ", "i-Kazakhstan" },
            { "Cyrl", "isi-Cyrillic" },
            { "LA", "i-Laos" },
            { "LB", "i-Lebanon" },
            { "LC", "i-Saint Lucia" },
            { "gwi", "isi-Gwich\u02bcin" },
            { "%%LUNA1918", "i-LUNA1918" },
            { "nds", "isi-Low German" },
            { "LI", "i-Liechtenstein" },
            { "LK", "i-Sri Lanka" },
            { "Hmnp", "i-Nyiakeng Puachue Hmong" },
            { "LR", "i-Liberia" },
            { "LS", "iLesotho" },
            { "LT", "i-Lithuania" },
            { "LU", "i-Luxembourg" },
            { "LV", "i-Latvia" },
            { "Kana", "isi-Katakana" },
            { "Sora", "i-Sora Sompeng" },
            { "LY", "i-Libya" },
            { "lad", "isi-Ladino" },
            { "vun", "isiVunjo" },
            { "%%LAUKIKA", "i-LAUKIKA" },
            { "Mahj", "i-Mahajani" },
            { "lag", "isi-Langi" },
            { "Thaa", "isi-Thaana" },
            { "MA", "i-Morocco" },
            { "MC", "i-Monaco" },
            { "MD", "i-Moldova" },
            { "Nshu", "i-N\u00fcshu" },
            { "ME", "i-Montenegro" },
            { "MF", "i-Saint Martin" },
            { "MG", "i-Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "i-Marshall Islands" },
            { "ale", "isi-Aleut" },
            { "type.nu.vaii", "Izinhlazu Zezinombolo ze-Vai" },
            { "MK", "i-North Macedonia" },
            { "type.nu.mathdbl", "Izinombolo ze-Mathematical Double-Struck" },
            { "ML", "iMali" },
            { "MM", "i-Myanmar (Burma)" },
            { "MN", "i-Mongolia" },
            { "new", "isi-Newari" },
            { "MO", "i-Macau SAR China" },
            { "MP", "i-Northern Mariana Islands" },
            { "MQ", "i-Martinique" },
            { "MR", "i-Mauritania" },
            { "MS", "i-Montserrat" },
            { "Chrs", "isi-Chorasmian" },
            { "MT", "i-Malta" },
            { "type.m0.ungegn", "I-UNGEGN" },
            { "MU", "i-Mauritius" },
            { "alt", "isi-Southern Altai" },
            { "MV", "i-Maldives" },
            { "MW", "iMalawi" },
            { "MX", "i-Mexico" },
            { "type.ca.japanese", "Ikhalenda lesi-Japanese" },
            { "MY", "i-Malaysia" },
            { "MZ", "i-Mozambique" },
            { "Phli", "i-Inscriptional Pahlavi" },
            { "NA", "i-Namibia" },
            { "%%ARANES", "i-ARANES" },
            { "202", "Sub-Saharan Africa" },
            { "type.ca.hebrew", "Ikhalenda lesi-Hebrew" },
            { "type.co.dictionary", "Uhlelo Lokuhlunga Lesichazamazwi" },
            { "NC", "i-New Caledonia" },
            { "%%WADEGILE", "i-Wade-Giles Romanization" },
            { "%%UCRCOR", "Ubhalomagama Olubuyekeziwe Oluhlanganisiwe" },
            { "NE", "i-Niger" },
            { "NF", "i-Norfolk Island" },
            { "NG", "i-Nigeria" },
            { "trv", "isi-Taroko" },
            { "Phlp", "i-Psalter Pahlavi" },
            { "NI", "i-Nicaragua" },
            { "Hmng", "isi-Pahawh Hmong" },
            { "NL", "i-Netherlands" },
            { "NO", "i-Norway" },
            { "NP", "i-Nepal" },
            { "NR", "i-Nauru" },
            { "NU", "i-Niue" },
            { "Phnx", "i-Phoenician" },
            { "rof", "isi-Rombo" },
            { "NZ", "i-New Zealand" },
            { "Merc", "i-Meroitic Cursive" },
            { "%%COLB1945", "Ubhalomagama lwe-Portuguese-Brazilian lwango-1945" },
            { "Mero", "i-Meroitic" },
            { "%%GRMISTR", "i-GRMISTR" },
            { "OM", "i-Oman" },
            { "%%PETR1708", "i-PETR1708" },
            { "anp", "isi-Angika" },
            { "crs", "i-Seselwa Creole French" },
            { "type.nu.hmnp", "Izinombolo ze-Nyiakeng Puachue Hmong" },
            { "Xpeo", "i-Old Persian" },
            { "type.nu.hmng", "Izinombolo ze-Pahawh Hmong" },
            { "PA", "i-Panama" },
            { "type.ca.islamic-civil", "i-Islamic-Civil Calendar" },
            { "en_GB", "i-British English" },
            { "PE", "i-Peru" },
            { "PF", "i-French Polynesia" },
            { "PG", "i-Papua New Guinea" },
            { "PH", "i-Philippines" },
            { "PK", "i-Pakistan" },
            { "%%NICARD", "i-NICARD" },
            { "PL", "i-Poland" },
            { "ewo", "isi-Ewondo" },
            { "PM", "i-Saint Pierre kanye ne-Miquelon" },
            { "PN", "i-Pitcairn Islands" },
            { "PR", "i-Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "i-Palestinian Territories" },
            { "PT", "i-Portugal" },
            { "PW", "i-Palau" },
            { "nia", "isi-Nias" },
            { "type.nu.greklow", "izinombolo ezincane zesi-Greek" },
            { "PY", "i-Paraguay" },
            { "tum", "isi-Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "i-Qatar" },
            { "%%SCOTLAND", "i-English Esezingeni ye-Scotish" },
            { "niu", "isi-Niuean" },
            { "QO", "i-Outlying Oceania" },
            { "lez", "isi-Lezghian" },
            { "type.nu.ahom", "Izinombolo ze-Ahom" },
            { "%%FONUPA", "Ifonotiki ye-UPA" },
            { "type.nu.takr", "Izinombolo ze-Takri" },
            { "tvl", "isi-Tuvalu" },
            { "Tavt", "isi-Tai Viet" },
            { "%%SOTAV", "Iqembu lolwimi lwesi-Sotavento lwe-Kabuverdianu" },
            { "Maka", "i-Makasar" },
            { "001", "umhlaba" },
            { "002", "i-Africa" },
            { "003", "i-North America" },
            { "RE", "i-R\u00e9union" },
            { "005", "i-South America" },
            { "jbo", "isi-Lojban" },
            { "Rjng", "i-Rejang" },
            { "009", "i-Oceania" },
            { "Elym", "isi-Elymaic" },
            { "%%SURSILV", "i-SURSILV" },
            { "RO", "i-Romania" },
            { "RS", "i-Serbia" },
            { "Mroo", "i-Mro" },
            { "RU", "i-Russia" },
            { "RW", "i-Rwanda" },
            { "type.nu.talu", "Izinombolo ze-New Tai Lue" },
            { "%%METELKO", "Uhlambu lwe-Metelko" },
            { "Mani", "i-Manichaean" },
            { "Ugar", "i-Ugaritic" },
            { "Khar", "isi-Kharoshthi" },
            { "SA", "i-Saudi Arabia" },
            { "Mand", "isi-Mandaean" },
            { "SB", "i-Solomon Islands" },
            { "twq", "isi-Tasawaq" },
            { "011", "i-Western Africa" },
            { "SC", "i-Seychelles" },
            { "SD", "i-Sudan" },
            { "013", "i-Central America" },
            { "SE", "i-Sweden" },
            { "014", "i-Eastern Africa" },
            { "015", "i-Northern Africa" },
            { "SG", "i-Singapore" },
            { "SH", "i-St. Helena" },
            { "type.lb.strict", "i-Line Break Style enomthetho oqinile" },
            { "017", "i-Middle Africa" },
            { "SI", "i-Slovenia" },
            { "type.nu.mymrtlng", "Izinombolo ze-Myanmar Tai Laing" },
            { "018", "i-Southern Africa" },
            { "SJ", "i-Svalbard ne-Jan Mayen" },
            { "019", "i-Americas" },
            { "SK", "i-Slovakia" },
            { "Bamu", "isi-Bamum" },
            { "SL", "i-Sierra Leone" },
            { "SM", "i-San Marino" },
            { "SN", "i-Senegal" },
            { "SO", "i-Somalia" },
            { "arn", "isi-Mapuche" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "isi-Arapaho" },
            { "SR", "i-Suriname" },
            { "SS", "i-South Sudan" },
            { "ST", "i-S\u00e3o Tom\u00e9 kanye ne-Pr\u00edncipe" },
            { "SV", "i-El Salvador" },
            { "SX", "i-Sint Maarten" },
            { "SY", "i-Syria" },
            { "SZ", "i-Swaziland" },
            { "TA", "i-Tristan da Cunha" },
            { "asa", "isi-Asu" },
            { "type.ms.ussystem", "isistimu yokulinganisa yase-US" },
            { "021", "i-Northern America" },
            { "TC", "i-Turks ne-Caicos Islands" },
            { "yav", "isi-Yangben" },
            { "TD", "i-Chad" },
            { "Qaag", "i-Zawgyi" },
            { "TF", "i-French Southern Territories" },
            { "TG", "i-Togo" },
            { "TH", "i-Thailand" },
            { "TJ", "i-Tajikistan" },
            { "029", "i-Caribbean" },
            { "TK", "i-Tokelau" },
            { "TL", "i-Timor-Leste" },
            { "ybb", "isi-Yemba" },
            { "type.co.searchjl", "Sesha nge-Hangul Ongwaqa Basekuqaleni" },
            { "TM", "i-Turkmenistan" },
            { "%%BOONT", "i-Boontling" },
            { "TN", "i-Tunisia" },
            { "TO", "i-Tonga" },
            { "%%NULIK", "i-Volap\u00fck yesimanje" },
            { "TR", "i-Turkey" },
            { "TT", "i-Trinidad ne-Tobago" },
            { "TV", "i-Tuvalu" },
            { "TW", "i-Taiwan" },
            { "ast", "isi-Asturian" },
            { "Orkh", "i-Orkhon" },
            { "TZ", "i-Tanzania" },
            { "nmg", "isi-Kwasio" },
            { "Zzzz", "iskripthi esingaziwa" },
            { "Sind", "i-Khudawadi" },
            { "UA", "i-Ukraine" },
            { "rup", "isi-Aromanian" },
            { "030", "i-Eastern Asia" },
            { "tyv", "isi-Tuvinian" },
            { "sw_CD", "isi-Congo Swahili" },
            { "034", "i-Southern Asia" },
            { "035", "i-South-Eastern Asia" },
            { "UG", "i-Uganda" },
            { "hak", "isi-Hakka Chinese" },
            { "type.co.pinyin", "Ukuhlunga nge-Pinyin" },
            { "039", "i-Southern Europe" },
            { "Sinh", metaValue_si },
            { "UM", "I-U.S. Outlying Islands" },
            { "UN", "I-United Nations" },
            { "US", "i-United States" },
            { "haw", "isi-Hawaiian" },
            { "%%1959ACAD", "Okwemfundo" },
            { "%%IVANCHOV", "i-IVANCHOV" },
            { "type.co.gb2312han", "Ukuhlunga kwe-Simplified Chinese - GB2312" },
            { "UY", "i-Uruguay" },
            { "prg", "isi-Prussian" },
            { "UZ", "i-Uzbekistan" },
            { "tzm", "isi-Central Atlas Tamazight" },
            { "type.co.stroke", "Ukuhlunga kwe-Stroke" },
            { "nnh", "isi-Ngiemboon" },
            { "VA", "i-Vatican City" },
            { "VC", "i-Saint Vincent ne-Grenadines" },
            { "%%HSISTEMO", "i-HSISTEMO" },
            { "VE", "i-Venezuela" },
            { "VG", "i-British Virgin Islands" },
            { "VI", "i-U.S. Virgin Islands" },
            { "%%LEMOSIN", "i-LEMOSIN" },
            { "Soyo", "i-Soyombo" },
            { "VN", "i-Vietnam" },
            { "VU", "i-Vanuatu" },
            { "Marc", "i-Marchen" },
            { "nog", "isi-Nogai" },
            { "rwk", "isi-Rwa" },
            { "053", "i-Australasia" },
            { "054", "i-Melanesia" },
            { "WF", "i-Wallis ne-Futuna" },
            { "type.co.traditional", "Ukuhlunga ngokisiko" },
            { "057", "i-Micronesian Region" },
            { "jgo", "isi-Ngomba" },
            { "lkt", "isi-Lakota" },
            { "type.nu.finance", "Izinombolo Zezomnotho" },
            { "%%HEPBURN", "i-Hepburn romanization" },
            { "type.co.compat", "Ukuhlunga Kwangaphambilini, ngokusebenzisana" },
            { "wae", "isi-Walser" },
            { "WS", "i-Samoa" },
            { "Bass", "isi-Bassa Vah" },
            { "type.nu.mtei", "Izinombolo ze-Meetei Mayek" },
            { "wal", "isi-Wolaytta" },
            { "XA", "Pseudo-Accents" },
            { "war", "isi-Waray" },
            { "XB", "Pseudo-Bidi" },
            { "awa", "isi-Awadhi" },
            { "061", "i-Polynesia" },
            { "%%KSCOR", "Ubhalomagama olusezingeni" },
            { "XK", "i-Kosovo" },
            { "type.nu.brah", "Izinombolo ze-Brahmi" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "okungabhaliwe" },
            { "Olck", "isi-Ol Chiki" },
            { "wbp", "isi-Warlpiri" },
            { "Batk", "isi-Batak" },
            { "YE", "i-Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "I-oda yokuhlunga ejwayelekile" },
            { "Zanb", "i-Zanabazar Square" },
            { "%%BALANKA", "Ulwimi lwe-Balank lwe-Anii" },
            { "%%ROZAJ", "i-Resian" },
            { "%%SUTSILV", "i-SUTSILV" },
            { "Sgnw", "i-SignWriting" },
            { "YT", "i-Mayotte" },
            { "type.nu.cham", "Izinombolo ze-Cham" },
            { "%%NEWFOUND", "i-NEWFOUND" },
            { "ZA", "iNingizimu Afrika" },
            { "type.nu.sund", "Izinombolo ze-Sundanese" },
            { "type.lb.loose", "i-Line Break Style exegayo" },
            { "Deva", "isi-Devanagari" },
            { "type.nu.geor", "izinombolo zesi-Georgian" },
            { "type.co.zhuyin", "Ukuhlunga kwe-Zhuyin" },
            { "Hira", "isi-Hiragana" },
            { "ZM", "i-Zambia" },
            { "%%PINYIN", "i-Pinyin Romanization" },
            { "ZW", "iZimbabwe" },
            { "ZZ", "iSifunda esingaziwa" },
            { "Runr", "i-Runic" },
            { "type.ms.metric", "isistimu ye-Metric" },
            { "type.ca.iso8601", "Ikhalenda le-ISO-8601" },
            { "nso", "isi-Northern Sotho" },
            { "type.nu.telu", "amadijithi esi-Telegu" },
            { "lou", "isi-Louisiana Creole" },
            { "loz", "isi-Lozi" },
            { "%%FONKIRSH", "i-FONKIRSH" },
            { "%%ASANTE", "i-ASANTE" },
            { "%%AUVERN", "i-AUVERN" },
            { "jmc", "isi-Machame" },
            { "type.nu.hansfin", "izinombolo ezicacile zezezimali zesi-Chinese" },
            { "hil", "isi-Hiligaynon" },
            { "type.nu.arabext", "amadijithi esi-Arabic-Indic eluliwe" },
            { "nus", "isi-Nuer" },
            { "dak", "isi-Dakota" },
            { "type.nu.fullwide", "ububanzi obugcwele bamadijithi" },
            { "dar", "isi-Dargwa" },
            { "dav", "isi-Taita" },
            { "lrc", "isi-Northern Luri" },
            { "type.co.emoji", "Uhlelo Lokuhlunga le-Emoji" },
            { "Copt", "isi-Coptic" },
            { "udm", "isi-Udmurt" },
            { "Khmr", metaValue_km },
            { "%%FONNAPA", "i-FONNAPA" },
            { "type.ca.islamic-rgsa", "Ikhalenda yesi-Islamic (Saudi Arabia, sighting)" },
            { "Limb", "isi-Limbu" },
            { "sad", "isi-Sandawe" },
            { "type.nu.roman", "izinombolo zesi-Roman" },
            { "sah", "i-Sakha" },
            { "type.nu.shrd", "Izinombolo ze-Sharada" },
            { "Aghb", "isi-Caucasian Albanian" },
            { "%%SCOUSE", "i-Scouse" },
            { "saq", "isi-Samburu" },
            { "sat", "isi-Santali" },
            { "Tfng", "isi-Tifinagh" },
            { "type.d0.npinyin", "Okwezinombolo" },
            { "type.nu.native", "Izinkinobho Zasendaweni" },
            { "sba", "isi-Ngambay" },
            { "Guru", "isi-Gurmukhi" },
            { "%%ALUKU", "Ulwimi lwesi-Aluku" },
            { "type.nu.diak", "Izinombolo ze-Dives Akuru" },
            { "lua", "isi-Luba-Lulua" },
            { "%%BISCAYAN", "i-BISCAYAN" },
            { "type.nu.tirh", "Izinombolo ze-Tirhuta" },
            { "type.d0.fwidth", "i-Fullwidth" },
            { "sbp", "isi-Sangu" },
            { "%%GRITAL", "i-GRITAL" },
            { "nyn", "isi-Nyankole" },
            { "lun", "isi-Lunda" },
            { "luo", "isi-Luo" },
            { "fil", "isi-Filipino" },
            { "hmn", "isi-Hmong" },
            { "lus", "isi-Mizo" },
            { "ban", metaValue_ban },
            { "type.nu.wara", "Izinombolo ze-Warang Citi" },
            { "luy", "isi-Luyia" },
            { "bas", "isi-Basaa" },
            { "%%ABL1943", "Ukwakhiwa kobhalomagama kwango-1943" },
            { "es_ES", "isi-European Spanish" },
            { "sco", "isi-Scots" },
            { "scn", "isi-Sicilian" },
            { "aa", "isi-Afar" },
            { "ab", "isi-Abkhazian" },
            { "Aran", "i-Nastaliq" },
            { "af", "i-Afrikaans" },
            { "ak", "isi-Akan" },
            { "type.nu.cakm", "Izinombolo ze-Chakma" },
            { "am", "isi-Amharic" },
            { "Arab", metaValue_ar },
            { "an", "isi-Aragonese" },
            { "%%SOLBA", "Ulwimi lwesi-Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "i-Japanese syllabaries" },
            { "as", "isi-Assamese" },
            { "Lina", "i-Linear A" },
            { "av", "isi-Avaric" },
            { "Linb", "i-Linear B" },
            { "sdh", "i-Southern Kurdish" },
            { "ay", "isi-Aymara" },
            { "az", "isi-Azerbaijani" },
            { "Rohg", "isi-Hanifi Rohingya" },
            { "Khoj", "isi-Khojki" },
            { "%%CISAUP", "i-CISAUP" },
            { "%%OSOJS", "Ulwimi lwesi-Oseacco/Osojane" },
            { "%%UNIFON", "Uhlamvu lwefonotiki lwe-Unifon" },
            { "ba", "isi-Bashkir" },
            { "type.co.unihan", "Ukuhlunga kwe-Radical-Stroke" },
            { "be", "isi-Belarusian" },
            { "bg", "isi-Bulgari" },
            { "bi", "isi-Bislama" },
            { "type.nu.java", "Izinombolo ze-Javanese" },
            { "bm", "isi-Bambara" },
            { "bn", "isi-Bengali" },
            { "bo", "isi-Tibetan" },
            { "dgr", "isi-Dogrib" },
            { "br", "isi-Breton" },
            { "bs", "isi-Bosnian" },
            { "Bhks", "isi-Bhaiksuki" },
            { "Mymr", "isi-Myanmar" },
            { "type.nu.laoo", "amadijithi esi-Lao" },
            { "seh", "isi-Sena" },
            { "Nkoo", metaValue_nqo },
            { "ca", "isi-Catalan" },
            { "ses", "isi-Koyraboro Senni" },
            { "ce", "isi-Chechen" },
            { "ch", "isi-Chamorro" },
            { "%%REVISED", "Ubhalomagama Olubuyekeziwe" },
            { "co", "isi-Corsican" },
            { "Orya", metaValue_or },
            { "cs", "isi-Czech" },
            { "cu", "isi-Church Slavic" },
            { "cv", "isi-Chuvash" },
            { "cy", "isi-Welsh" },
            { "type.nu.ethi", "izinombolo zesi-Ethiopic" },
            { "Yiii", "isi-Yi" },
            { "da", "isi-Danish" },
            { "pt_PT", "isi-European Portuguese" },
            { "de", "isi-German" },
            { "type.cf.standard", "Ifomethi yemali ejwayelekile" },
            { "Bugi", metaValue_bug },
            { "bem", "isi-Bemba" },
            { "type.nu.mong", "i-Mongolian Digits" },
            { "dv", "isi-Divehi" },
            { "es_419", "isi-Latin American Spanish" },
            { "dz", "isi-Dzongkha" },
            { "bez", "isi-Bena" },
            { "type.ca.chinese", "Ikhalenda lesi-Chinese" },
            { "Lisu", "isi-Fraser" },
            { "dje", "isi-Zarma" },
            { "type.nu.grek", "izinombolo zesi-Greek" },
            { "ee", "isi-Ewe" },
            { "type.lb.normal", "i-Line Break Style ekahle" },
            { "ro_MD", "isi-Moldavian" },
            { "el", metaValue_el },
            { "en", "i-English" },
            { "eo", "isi-Esperanto" },
            { "type.co.big5han", "Ukuhlunga kwe-Traditional Chinese - Big5" },
            { "es", "isi-Spanish" },
            { "et", "isi-Estonia" },
            { "Hanb", "isi-Hanb" },
            { "eu", "isi-Basque" },
            { "Buhd", "isi-Buhid" },
            { "Hang", "isi-Hangul" },
            { "Samr", "i-Samaritan" },
            { "shi", "isi-Tachelhit" },
            { "hsb", "isi-Upper Sorbian" },
            { "Hani", "isi-Han" },
            { "%%ULSTER", "i-ULSTER" },
            { "shn", "isi-Shan" },
            { "Hano", "isi-Hanunoo" },
            { "fa", "isi-Persian" },
            { "Hans", "enziwe lula" },
            { "type.nu.latn", "amadijithi ase-Western" },
            { "Hant", "okosiko" },
            { "ff", "isi-Fulah" },
            { "hsn", "isi-Xiang Chinese" },
            { "fi", "isi-Finnish" },
            { "fj", "isi-Fijian" },
            { "fon", "isi-Fon" },
            { "bgn", "isi-Western Balochi" },
            { "yue", "isi-Cantonese" },
            { "fo", "isi-Faroese" },
            { "type.m0.bgn", "I-BGN" },
            { "umb", "isi-Umbundu" },
            { "fr", "isi-French" },
            { "%%AKUAPEM", "i-AKUAPEM" },
            { "fy", "isi-Western Frisian" },
            { "ga", "isi-Irish" },
            { "Wcho", "isi-Wancho" },
            { "gd", "isi-Scottish Gaelic" },
            { "Gong", "isi-Gunjala Gondi" },
            { "gl", "isi-Galicia" },
            { "Gonm", "isi-Masaram Gondi" },
            { "gn", "isi-Guarani" },
            { "bho", "isi-Bhojpuri" },
            { "und", "ulimi olungaziwa" },
            { "type.ca.ethiopic-amete-alem", "i-Ethiopic Amete Alem Calender" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Ikhalenda yesi-Islamic (tabular, astronomical epoch)" },
            { "gv", "isi-Manx" },
            { "type.nu.osma", "Izinombolo ze-Osmanya" },
            { "ha", "isi-Hausa" },
            { "he", metaValue_he },
            { "hi", "isi-Hindi" },
            { "hup", "isi-Hupa" },
            { "bin", "isi-Bini" },
            { "hr", "isi-Croatian" },
            { "ht", "isi-Haitian" },
            { "hu", "isi-Hungarian" },
            { "hy", "isi-Armenia" },
            { "hz", "isi-Herero" },
            { "frc", "isi-Cajun French" },
            { "%%FONIPA", "Ifonotiki ye-IPA" },
            { "ia", "izilimi ezihlangene" },
            { "Jamo", "isi-Jamo" },
            { "id", "isi-Indonesian" },
            { "type.nu.tibt", "amadijithi esi-Tibetan" },
            { "ie", "izimili" },
            { "%%GASCON", "i-GASCON" },
            { "ig", "isi-Igbo" },
            { "ii", "isi-Sichuan Yi" },
            { "%%RUMGR", "i-RUMGR" },
            { "%%AO1990", "Isivumelwano Sobhalomagama Lolwimi lesi-Portuguese sango-1990" },
            { "io", "isi-Ido" },
            { "is", "isi-Icelandic" },
            { "it", "isi-Italian" },
            { "iu", "isi-Inuktitut" },
            { "%%CORNU", "i-CORNU" },
            { "%%HOGNORSK", "i-HOGNORSK" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "i-Old South Arabian" },
            { "doi", "isi-Dogri" },
            { "type.nu.lepc", "Izinombolo ze-Lepcha" },
            { "sma", "isi-Southern Sami" },
            { "jv", metaValue_jv },
            { "Shaw", "i-Shavian" },
            { "%%BAUDDHA", "i-BAUDDHA" },
            { "mad", "isi-Madurese" },
            { "smj", "isi-Lule Sami" },
            { "mag", "isi-Magahi" },
            { "mai", "isi-Maithili" },
            { "smn", "isi-Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "isi-Siksika" },
            { "mak", "isi-Makasar" },
            { "wuu", "isi-Wu Chinese" },
            { "sms", "isi-Skolt Sami" },
            { "kg", "isi-Kongo" },
            { "Goth", "isi-Gothic" },
            { "ki", "isi-Kikuyu" },
            { "mas", "isi-Masai" },
            { "kj", "isi-Kuanyama" },
            { "kk", "isi-Kazakh" },
            { "kl", "isi-Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "isi-Kanuri" },
            { "ks", "isi-Kashmiri" },
            { "Lepc", "isi-Lepcha" },
            { "Avst", "isi-Avestan" },
            { "ku", "isi-Kurdish" },
            { "kv", "isi-Komi" },
            { "kw", "isi-Cornish" },
            { "ky", "isi-Kyrgyz" },
            { "snk", "isi-Soninke" },
            { "Mult", "i-Multani" },
            { "la", metaValue_la },
            { "Hatr", "isi-Hatran" },
            { "lb", "isi-Luxembourgish" },
            { "type.nu.mlym", "amadijithi esi-Malayalam" },
            { "lg", "isi-Ganda" },
            { "li", "isi-Limburgish" },
            { "Tibt", "i-Tibetan" },
            { "ln", "isi-Lingala" },
            { "fur", "isi-Friulian" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "isistimu yokulinganisa ebusayo" },
            { "type.nu.lana", "Izinombolo ze-Tai Tham Hora" },
            { "lt", "isi-Lithuanian" },
            { "lu", "isi-Luba-Katanga" },
            { "lv", "isi-Latvian" },
            { "mg", "isi-Malagasy" },
            { "mh", "isi-Marshallese" },
            { "type.co.ducet", "Ukuhlunga okuzenzakalelayo kwe-Unicode" },
            { "mi", "isi-Maori" },
            { "mk", "isi-Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "isi-Marathi" },
            { "ms", "isi-Malay" },
            { "mt", "isi-Maltese" },
            { "my", "isi-Burmese" },
            { "Saur", "isi-Saurashtra" },
            { "Armn", "isi-Armenian" },
            { "mdf", "isi-Moksha" },
            { "dsb", "isi-Lower Sorbian" },
            { "Armi", "isi-Imperial Aramaic" },
            { "na", "isi-Nauru" },
            { "type.co.search", "Usesho olujwayelekile" },
            { "nb", "isi-Norwegian Bokm\u00e5l" },
            { "nd", "isi-North Ndebele" },
            { "ne", "isi-Nepali" },
            { "ng", "isi-Ndonga" },
            { "nl", "isi-Dutch" },
            { "nn", "isi-Norwegian Nynorsk" },
            { "no", "isi-Norwegian" },
            { "%%PROVENC", "i-PROVENC" },
            { "nr", "isi-South Ndebele" },
            { "type.nu.modi", "Izinombolo ze-Modi" },
            { "Osge", "isi-Osage" },
            { "nv", "isi-Navajo" },
            { "ny", "isi-Nyanja" },
            { "kac", "isi-Kachin" },
            { "kab", "isi-Kabyle" },
            { "%%POLYTON", "i-Polytonic" },
            { "oc", "isi-Occitan" },
            { "kaj", "isi-Jju" },
            { "kam", "isi-Kamba" },
            { "men", "isi-Mende" },
            { "%%EMODENG", "i-English Yesimanje" },
            { "mer", "isi-Meru" },
            { "type.nu.armn", "izinombolo zesi-Armenian" },
            { "om", "isi-Oromo" },
            { "or", metaValue_or },
            { "Modi", "i-Modi" },
            { "os", "isi-Ossetic" },
            { "%%ALALC97", "i-ALA-LC Romanization, i-edishini yango-1997" },
            { "kbd", "isi-Kabardian" },
            { "mfe", "isi-Morisyen" },
            { "srn", "isi-Sranan Tongo" },
            { "pa", "isi-Punjabi" },
            { "dua", "isi-Duala" },
            { "%%LIPAW", "Ulwimi lwesi-Lipovaz lase-Resian" },
            { "pl", "isi-Polish" },
            { "type.nu.saur", "Izinombolo ze-Saurashtra" },
            { "type.ca.dangi", "Ikhalenda lesi-Dangi" },
            { "%%VALLADER", "i-VALLADER" },
            { "ps", "isi-Pashto" },
            { "pt", "isi-Portuguese" },
            { "key.co", "Uhlelo lokuhlunga" },
            { "pt_BR", "isi-Brazillian Portuguese" },
            { "%%BOHORIC", "Uhlambu lwe-Bohori\u010d" },
            { "kcg", "isi-Tyap" },
            { "mgh", "isi-Makhuwa-Meetto" },
            { "key.cf", "Ifomethi yemali" },
            { "type.nu.nkoo", "Izinombolo ze-N\u2019Ko" },
            { "key.ca", "Ikhalenda" },
            { "%%JAUER", "i-JAUER" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "i-SURMIRAN" },
            { "mgo", "isi-Meta\u2019" },
            { "type.hc.h23", "isistimu yamahora angu-24 (0-23)" },
            { "type.hc.h24", "isistimu yamahora angu-24 (1-24)" },
            { "ssy", "isi-Saho" },
            { "type.nu.mymr", "amadijithi esi-Maynmar" },
            { "qu", "isi-Quechua" },
            { "brx", "isi-Bodo" },
            { "Lana", "isi-Lanna" },
            { "kde", "isi-Makonde" },
            { "%%VAIDIKA", "i-VAIDIKA" },
            { "Ethi", "isi-Ethiopic" },
            { "%%JYUTPING", "i-JYUTPING" },
            { "type.hc.h12", "isistimu yamahora angu-12 (1-12)" },
            { "type.hc.h11", "isistimu yamahora angu-12 (0-11)" },
            { "rm", "isi-Romansh" },
            { "rn", "isi-Rundi" },
            { "key.cu", "Imali" },
            { "ro", "isi-Romanian" },
            { "%%SAAHO", "i-Saho" },
            { "type.nu.orya", "Amadijithi ase-Odia" },
            { "type.nu.hanidec", "izinombolo zezinombolo zesi-Chinese" },
            { "ru", "isi-Russian" },
            { "rw", "isi-Kinyarwanda" },
            { "kea", "isi-Kabuverdianu" },
            { "mic", "isi-Micmac" },
            { "suk", "isi-Sukuma" },
            { "en_AU", "i-Australian English" },
            { "Dupl", "isi-Duployan shorthand" },
            { "sa", "isi-Sanskrit" },
            { "%%UCCOR", "Ubhalomagama Oluhlanganisiwe" },
            { "sc", "isi-Sardinian" },
            { "sd", "isi-Sindhi" },
            { "se", "isi-Northern Sami" },
            { "min", "isi-Minangkabau" },
            { "sg", "isi-Sango" },
            { "sh", "isi-Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "isi-Slovak" },
            { "sl", "isi-Slovenian" },
            { "Gran", "isi-Grantha" },
            { "sm", "isi-Samoan" },
            { "%%BASICENG", "i-BASICENG" },
            { "sn", "isiShona" },
            { "so", "isi-Somali" },
            { "type.nu.arab", "amadijithi esi-Arabic-Indic" },
            { "sq", "isi-Albania" },
            { "sr", "isi-Serbian" },
            { "ss", "isiSwati" },
            { "type.cf.account", "Ifomethi yemali ye-Accounting" },
            { "Java", metaValue_jv },
            { "st", "isi-Southern Sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Ulwimi lwesi-Natisone" },
            { "sv", "isi-Swedish" },
            { "sw", "isiSwahili" },
            { "type.nu.wcho", "Izinombolo ze-Wancho" },
            { "type.nu.hantfin", "izinombolo zosiko zezezimali zesi-Chinese" },
            { "ibb", "isi-Ibibio" },
            { "iba", "isi-Iban" },
            { "ta", metaValue_ta },
            { "142", "i-Asia" },
            { "143", "i-Central Asia" },
            { "te", metaValue_te },
            { "145", "i-Western Asia" },
            { "tg", "isi-Tajik" },
            { "th", metaValue_th },
            { "%%SPANGLIS", "i-SPANGLIS" },
            { "bug", metaValue_bug },
            { "ti", "isi-Tigrinya" },
            { "kfo", "isi-Koro" },
            { "en_CA", "i-Canadian English" },
            { "tk", "isi-Turkmen" },
            { "tn", "isi-Tswana" },
            { "to", "isi-Tongan" },
            { "dyo", "isi-Jola-Fonyi" },
            { "type.nu.jpan", "izinombolo zesi-Japanese" },
            { "tr", "isi-Turkish" },
            { "ts", "isi-Tsonga" },
            { "swb", "isi-Comorian" },
            { "Cakm", "isi-Chakma" },
            { "tt", "isi-Tatar" },
            { "%%XSISTEMO", "i-XSISTEMO" },
            { "tw", "isi-Twi" },
            { "ty", "isi-Tahitian" },
            { "%%BISKE", "Ulwimi lwe-San Giorgio/Bila" },
            { "150", "i-Europe" },
            { "151", "i-Eastern Europe" },
            { "type.nu.rohg", "Izinombolo ze-Hanifi Rohingya" },
            { "type.nu.mathsanb", "Izinombolo ze-Mathematical Sans-Serif Bold" },
            { "154", "i-Northern Europe" },
            { "dzg", "isi-Dazaga" },
            { "155", "i-Western Europe" },
            { "ug", "isi-Uighur" },
            { "Kore", metaValue_ko },
            { "Ital", "i-Old Italic" },
            { "Zyyy", "jwayelekile" },
            { "uk", "isi-Ukrainian" },
            { "type.ca.coptic", "i-Coptic Calender" },
            { "ur", "isi-Urdu" },
            { "%%1994", "Ubhalomagama lwase-Russia olusezingeni" },
            { "xal", "isi-Kalmyk" },
            { "uz", "isi-Uzbek" },
            { "kha", "isi-Khasi" },
            { "%%1996", "Ubhalomagama lwase-German lwango-1996" },
            { "nds_NL", "isi-Low Saxon" },
            { "Sylo", "isi-Syloti Nagri" },
            { "ve", "isi-Venda" },
            { "Wara", "i-Varang Kshiti" },
            { "type.ca.roc", "Ikhalenda lesi-Minguo" },
            { "vi", "isi-Vietnamese" },
            { "khq", "isi-Koyra Chiini" },
            { "key.hc", "Umjikelezo wehora (12 vs 24" },
            { "%%TARASK", "Ubhalomagama lwesi-Taraskievica" },
            { "vo", "isi-Volap\u00fck" },
            { "type.nu.mathsans", "Izinombolo ze-Mathematical Sans-Serif" },
            { "Osma", "i-Osmanya" },
            { "quc", "isi-K\u02bciche\u02bc" },
            { "type.nu.gonm", "Izinombolo ze-Masaram Gondi" },
            { "gaa", "isi-Ga" },
            { "wa", "isi-Walloon" },
            { "gag", "isi-Gagauz" },
            { "syr", metaValue_syr },
            { "type.nu.gong", "Izinombolo ze-Gunjala Gondi" },
            { "Grek", metaValue_el },
            { "gan", "isi-Gan Chinese" },
            { "Lydi", "i-Lydian" },
            { "Xsux", "i-Sumero-Akkadian Cuneiform" },
            { "wo", "isi-Wolof" },
            { "zgh", "isi-Moroccan Tamazight esivamile" },
            { "ar_001", "isi-Arabic esivamile sesimanje" },
            { "Cans", "i-Unified Canadian Aboriginal Syllabics" },
            { "%%FONXSAMP", "i-FONXSAMP" },
            { "Mong", metaValue_mn },
            { "Hluw", "isi-Anatolian Hieroglyphs" },
            { "mni", "isi-Manipuri" },
            { "Latn", metaValue_la },
            { "Nand", "i-Nandinagari" },
            { "type.nu.hans", "izinombolo ezicacile zesi-Chinese" },
            { "type.nu.hant", "izinombolo zosiko zesi-Chinese" },
            { "xh", "isiXhosa" },
            { "type.nu.romanlow", metaValue_type_nu_taml },
            { "byn", "isi-Blin" },
            { "Dogr", "isi-Dogra" },
            { "%%PAMAKA", "ulwimi lwesi-Pamaka" },
            { "Lyci", "i-Lycian" },
            { "moh", "isi-Mohawk" },
            { "kkj", "isi-Kako" },
            { "%%1694ACAD", "isi-French Samanje" },
            { "Syrc", metaValue_syr },
            { "yi", "isi-Yiddish" },
            { "mos", "isi-Mossi" },
            { "Dsrt", "isi-Deseret" },
            { "yo", "isi-Yoruba" },
            { "type.nu.traditional", "Izinombolo Ezijwayelekile" },
            { "es_MX", "isi-Mexican Spanish" },
            { "vai", metaValue_vai },
            { "Cari", "isi-Carian" },
            { "kln", "isi-Kalenjin" },
            { "zh", "isi-Chinese" },
            { "Bopo", "isi-Bopomofo" },
            { "Perm", "i-Old Permic" },
            { "key.lb", "I-Line Break Style" },
            { "zu", "isiZulu" },
            { "type.co.phonebook", "Ukuhlunga kwebhuku lefoni" },
            { "%%MONOTON", "i-Monotonic" },
            { "Geor", metaValue_ka },
            { "Shrd", "i-Sharada" },
            { "%%LENGADOC", "i-LENGADOC" },
            { "kmb", "isi-Kimbundu" },
            { "type.nu.jpanfin", "izinombolo zezezimali zesi-Japanese" },
            { "Cham", "isi-Cham" },
            { "gez", "isi-Geez" },
            { "type.nu.mymrshan", "Izinombolo ze-Myanmar Shan" },
            { "Elba", "isi-Elbasan" },
            { "Narb", "i-Old North Arabian" },
            { "type.nu.olck", "Izinombolo ze-Ol Chiki" },
            { "type.co.reformed", "Ukuhlunga okwenziwe kabusha" },
            { "Tglg", "i-Tagalog" },
            { "Yezi", "i-Yezidi" },
            { "%%ITIHASA", "i-ITIHASA" },
            { "Palm", "i-Palmyrene" },
            { "ebu", "isi-Embu" },
            { "Egyp", "i-Egyptian hieroglyphs" },
            { "zh_Hans", "isi-Chinese (esenziwe-lula)" },
            { "koi", "isi-Komi-Permyak" },
            { "Hung", "isi-Old Hungarian" },
            { "kok", "isi-Konkani" },
            { "%%1901", "Ubhalomagama lwase-German losiko" },
            { "%%PAHAWH2", "i-PAHAWH2" },
            { "%%PAHAWH3", "i-PAHAWH3" },
            { "%%PAHAWH4", "i-PAHAWH4" },
            { "type.nu.limb", "Izinombolo ze-Limbu" },
            { "zh_Hant", "isi-Chinese (Sasendulo)" },
            { "Sund", metaValue_su },
            { "kpe", "isi-Kpelle" },
            { "%%GRCLASS", "i-GRCLASS" },
            { "type.nu.khmr", "amadijithi esi-Khmer" },
            { "Tirh", "i-Tirhuta" },
            { "ilo", "isi-Iloko" },
            { "%%VALENCIA", "i-Valencian" },
            { "Cprt", "isi-Cypriot" },
            { "Diak", "isi-Dives Akuru" },
            { "%%BAKU1926", "Uhlamvu lwesi-Turkic Latin oluhlanganisiwe" },
            { "%%IJEKAVSK", "Isi-Serbian esinokuphimisa kwe-Ijekavian" },
            { "mua", "isi-Mundang" },
            { "type.nu.guru", "amadijithi esi-Gurmukhi" },
            { "%%BORNHOLM", "i-BORNHOLM" },
            { "mul", "izilimi ezehlukene" },
            { "%%PUTER", "i-PUTER" },
            { "key.ms", "Isistimu yokulinganisa" },
            { "mus", "isi-Creek" },
            { "Glag", "isi-Glagolitic" },
            { "gil", "isi-Gilbertese" },
            { "%%KKCOR", "Ubhalomagama oluvamile" },
            { "Cher", metaValue_chr },
            { "type.nu.tamldec", "amadijithi esi-Tamil" },
            { "krc", "isi-Karachay-Balkar" },
            { "inh", "isi-Ingush" },
            { "fa_AF", "isi-Dari" },
            { "krl", "isi-Karelian" },
            { "%%OXENDICT", "Ukupela Kwesichazamazwi se-Oxford EnglishOxford English Dictionary spelling" },
            { "efi", "isi-Efik" },
            { "key.nu", "Izinombolo" },
            { "kru", "isi-Kurukh" },
            { "ksb", "isiShambala" },
            { "Telu", metaValue_te },
            { "ksf", "isi-Bafia" },
        };
        return data;
    }
}
