/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sq extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bo = "tibetisht";
        final String metaValue_lo = "laosisht";
        final String metaValue_mn = "mongolisht";
        final String metaValue_mak = "makasarisht";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00eblnisht" },
            { "Ogam", "ogamisht" },
            { "mwl", "mirandisht" },
            { "Zsym", "me simbole" },
            { "Tagb", "tagbanvaisht" },
            { "Zsye", "emoji" },
            { "ccp", "\u00e7akmaisht" },
            { "Phag", "fagspaisht" },
            { "tem", "timneisht" },
            { "Medf", "medefaidrinisht" },
            { "teo", "tesoisht" },
            { "rap", "rapanuisht" },
            { "AC", "Ishulli Asenshion" },
            { "rar", "rarontonganisht" },
            { "tet", "tetumisht" },
            { "AD", "Andorr\u00eb" },
            { "AE", "Emiratet e Bashkuara Arabe" },
            { "nl_BE", "flamandisht" },
            { "AF", "Afganistan" },
            { "AG", "Antigua e Barbuda" },
            { "type.ca.ethiopic", "kalendar etiopian" },
            { "AI", "Anguil\u00eb" },
            { "AL", "Shqip\u00ebri" },
            { "AM", "Armeni" },
            { "AO", "Angol\u00eb" },
            { "AQ", "Antarktik\u00eb" },
            { "AR", "Argjentin\u00eb" },
            { "Prti", "persishte mbishkrimesh" },
            { "AS", "Samoa Amerikane" },
            { "AT", "Austri" },
            { "AU", "Australi" },
            { "AW", "Arub\u00eb" },
            { "en_US", "anglishte amerikane" },
            { "AX", "Ishujt Aland\u00eb" },
            { "AZ", "Azerbajxhan" },
            { "BA", "Bosnj\u00eb-Hercegovin\u00eb" },
            { "BB", "Barbados" },
            { "ceb", "sebuanisht" },
            { "BD", "Bangladesh" },
            { "kum", "kumikisht" },
            { "BE", "Belgjik\u00eb" },
            { "Sogo", "sogdianishte e vjet\u00ebr" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bullgari" },
            { "BH", "Bahrejn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermude" },
            { "myv", "erzjaisht" },
            { "BN", "Brunei" },
            { "BO", "Bolivi" },
            { "BQ", "Karaibet holandeze" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "xog", "sogisht" },
            { "BT", "Butan" },
            { "BV", "Ishulli Bove" },
            { "BW", "Botsvan\u00eb" },
            { "BY", "Bjellorusi" },
            { "BZ", "Beliz\u00eb" },
            { "type.ca.persian", "kalendar persian" },
            { "type.nu.hebr", "numra hebraik\u00eb" },
            { "CA", "Kanada" },
            { "Kits", "shkrim i vog\u00ebl kitan" },
            { "CC", "Ishujt Kokos" },
            { "mzn", "mazanderanisht" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Republika e Afrik\u00ebs Qendrore" },
            { "CG", "Kongo-Brazavil\u00eb" },
            { "CH", "Zvic\u00ebr" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Ishujt Kuk" },
            { "CL", "Kili" },
            { "Kthi", "kaitisht" },
            { "CM", "Kamerun" },
            { "CN", "Kin\u00eb" },
            { "CO", "Kolumbi" },
            { "CP", "Ishulli Klip\u00ebrton" },
            { "CR", "Kosta-Rik\u00eb" },
            { "CU", "Kub\u00eb" },
            { "CV", "Kepi i Gjelb\u00ebr" },
            { "CW", "Kurasao" },
            { "CX", "Ishulli i Krishtlindjes" },
            { "CY", "Qipro" },
            { "CZ", "\u00c7eki" },
            { "eka", "ekajukisht" },
            { "Ahom", "ahomisht" },
            { "Pauc", "pausinhauisht" },
            { "Sogd", "sogdianisht" },
            { "DE", "Gjermani" },
            { "ace", "akinezisht" },
            { "cgg", "\u00e7igisht" },
            { "DG", "Diego-Garsia" },
            { "type.nu.deva", "shifra devanagari" },
            { "DJ", "Xhibuti" },
            { "DK", "Danimark\u00eb" },
            { "Brai", "brailisht" },
            { "Brah", "brahmisht" },
            { "DM", "Dominik\u00eb" },
            { "type.nu.armnlow", "numra armen\u00eb t\u00eb vegj\u00ebl" },
            { "DO", "Republika Dominikane" },
            { "gor", "gorontaloisht" },
            { "zun", "zunisht" },
            { "tig", "tigreisht" },
            { "DZ", "Algjeri" },
            { "pag", "pangasinanisht" },
            { "EA", "Theuta e Melila" },
            { "pam", "pampangaisht" },
            { "EC", "Ekuador" },
            { "pap", "papiamentisht" },
            { "ada", "andangmeisht" },
            { "EE", "Estoni" },
            { "EG", "Egjipt" },
            { "EH", "Saharaja Per\u00ebndimore" },
            { "pau", "paluanisht" },
            { "chk", "\u00e7ukezisht" },
            { "chm", "marisht" },
            { "cho", "\u00e7oktauisht" },
            { "chr", "\u00e7erokisht" },
            { "ER", "Eritre" },
            { "ES", "Spanj\u00eb" },
            { "ET", "Etiopi" },
            { "EU", "Bashkimi Evropian" },
            { "type.ca.gregorian", "kalendar gregorian" },
            { "EZ", "Zona euro" },
            { "chy", "\u00e7ejenisht" },
            { "type.nu.gujr", "shifra guxharati" },
            { "ady", "adigisht" },
            { "FI", "Finland\u00eb" },
            { "FJ", "Fixhi" },
            { "FK", "Ishujt Falkland" },
            { "FM", "Mikronezi" },
            { "FO", "Ishujt Faroe" },
            { "Taml", "tamil" },
            { "FR", "Franc\u00eb" },
            { "type.ca.indian", "Kalendari Komb\u00ebtar Indian" },
            { "GA", "Gabon" },
            { "GB", "Mbret\u00ebria e Bashkuar" },
            { "pcm", "pixhinishte nigeriane" },
            { "GD", "Granad\u00eb" },
            { "GE", "Gjeorgji" },
            { "GF", "Guajana Franceze" },
            { "GG", "Gernsej" },
            { "GH", "Gan\u00eb" },
            { "GI", "Gjibraltar" },
            { "GL", "Gr\u00ebnland\u00eb" },
            { "GM", "Gambi" },
            { "GN", "Guine" },
            { "GP", "Guadelup\u00eb" },
            { "GQ", "Guineja Ekuatoriale" },
            { "GR", "Greqi" },
            { "GS", "Xhorxha Jugore dhe Ishujt Sendui\u00e7\u00eb t\u00eb Jugut" },
            { "GT", "Guatemal\u00eb" },
            { "GU", "Guam" },
            { "GW", "Guine-Bisau" },
            { "rhg", "rohingiaisht" },
            { "tlh", "klingonisht" },
            { "GY", "Guajan\u00eb" },
            { "ckb", "kurdishte qendrore" },
            { "zxx", "nuk ka p\u00ebrmbajtje gjuh\u00ebsore" },
            { "de_AT", "gjermanishte austriake" },
            { "HK", "RPA i Hong-Kongut" },
            { "HM", "Ishujt H\u00ebrd e Mekdonald" },
            { "HN", "Honduras" },
            { "HR", "Kroaci" },
            { "agq", "agemisht" },
            { "gsw", "gjermanishte zvicerane" },
            { "type.ca.islamic-umalqura", "Kalendari Islamik (Um al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Hungari" },
            { "IC", "Ishujt Kanarie" },
            { "ID", "Indonezi" },
            { "IE", "Irland\u00eb" },
            { "nap", "napoletanisht" },
            { "naq", "namaisht" },
            { "zza", "zazaisht" },
            { "IL", "Izrael" },
            { "Nbat", "nabateanisht" },
            { "IM", "Ishulli i Manit" },
            { "IN", "Indi" },
            { "IO", "Territori Britanik i Oqeanit Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island\u00eb" },
            { "IT", "Itali" },
            { "Zmth", "simbole matematikore" },
            { "type.nu.thai", "shifra tajlandeze" },
            { "type.nu.beng", "shifra bengali" },
            { "JE", "Xhersej" },
            { "type.ca.islamic", "kalendar islamik" },
            { "JM", "Xhamajk\u00eb" },
            { "Beng", "bengal" },
            { "JO", "Jordani" },
            { "JP", "Japoni" },
            { "ain", "ajnuisht" },
            { "Mend", "mendeisht" },
            { "guz", "gusisht" },
            { "type.nu.knda", "shifra kanade" },
            { "Sidd", "sidamisht" },
            { "de_CH", "gjermanishte zvicerane (dialekti i Alpeve)" },
            { "type.ca.buddhist", "kalendar budist" },
            { "KE", "Kenia" },
            { "419", "Amerika Latine" },
            { "KG", "Kirgizi" },
            { "KH", "Kamboxhia" },
            { "KI", "Kiribati" },
            { "KM", "Komore" },
            { "KN", "Sh\u00ebn-Kits dhe Nevis" },
            { "Knda", "kanad" },
            { "fr_CA", "fr\u00ebngjishte kanadeze" },
            { "KP", "Kore e Veriut" },
            { "KR", "Kore e Jugut" },
            { "fr_CH", "fr\u00ebngjishte zvicerane" },
            { "KW", "Kuvajt" },
            { "tpi", "pisinishte toku" },
            { "KY", "Ishujt Kajman" },
            { "KZ", "Kazakistan" },
            { "Cyrl", "cirilik" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sh\u00ebn-Lu\u00e7ia" },
            { "gwi", "gui\u00e7inisht" },
            { "nds", "gjermanishte e vendeve t\u00eb ul\u00ebta" },
            { "LI", "Lihtenshtajn" },
            { "LK", "Sri-Lank\u00eb" },
            { "LR", "Liberi" },
            { "LS", "Lesoto" },
            { "LT", "Lituani" },
            { "LU", "Luksemburg" },
            { "LV", "Letoni" },
            { "Kana", "katakan" },
            { "Sora", "sorasompengisht" },
            { "LY", "Libi" },
            { "lad", "ladinoisht" },
            { "vun", "vunxhoisht" },
            { "Mahj", "mahaxhanisht" },
            { "lag", "langisht" },
            { "Thaa", "tanisht" },
            { "MA", "Marok" },
            { "MC", "Monako" },
            { "MD", "Moldavi" },
            { "Nshu", "nyshuisht" },
            { "ME", "Mal i Zi" },
            { "MF", "Sen-Marten" },
            { "MG", "Madagaskar" },
            { "MH", "Ishujt Marshall" },
            { "ale", "aleutisht" },
            { "Thai", "tajlandez" },
            { "MK", "Maqedonia e Veriut" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Burm\u00eb)" },
            { "MN", "Mongoli" },
            { "new", "neuarisht" },
            { "MO", "RPA i Makaos" },
            { "MP", "Ishujt e Marian\u00ebs Veriore" },
            { "MQ", "Martinik\u00eb" },
            { "MR", "Mauritani" },
            { "MS", "Montserat" },
            { "Chrs", "korasmianisht" },
            { "MT", "Malt\u00eb" },
            { "MU", "Mauritius" },
            { "alt", "altaishte jugore" },
            { "MV", "Maldive" },
            { "MW", "Malavi" },
            { "MX", "Meksik\u00eb" },
            { "type.ca.japanese", "kalendar japonez" },
            { "MY", "Malajzi" },
            { "MZ", "Mozambik" },
            { "Phli", "palavishte mbishkrimesh" },
            { "NA", "Namibi" },
            { "202", "Afrika Subsahariane" },
            { "type.ca.hebrew", "kalendar hebraik" },
            { "type.co.dictionary", "Radhitje fjalori" },
            { "NC", "Kaledoni e Re" },
            { "NE", "Niger" },
            { "NF", "Ishulli Norfolk" },
            { "NG", "Nigeri" },
            { "trv", "torokoisht" },
            { "Phlp", "palavishte psalteri" },
            { "NI", "Nikaragua" },
            { "Hmng", "pahauhmonisht" },
            { "NL", "Holand\u00eb" },
            { "NO", "Norvegji" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "fenikisht" },
            { "rof", "romboisht" },
            { "NZ", "Zeland\u00eb e Re" },
            { "Merc", "meroitik kursiv" },
            { "Mero", "meroitik" },
            { "OM", "Oman" },
            { "anp", "angikisht" },
            { "crs", "fr\u00ebngjishte kreole seselve" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalendari Islamik (tabelor, periudha civile)" },
            { "en_GB", "anglishte britanike" },
            { "PE", "Peru" },
            { "PF", "Polinezia Franceze" },
            { "PG", "Guineja e Re-Papua" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Poloni" },
            { "ewo", "euondoisht" },
            { "PM", "Sh\u00ebn-Pier dhe Mikelon" },
            { "PN", "Ishujt Pitkern" },
            { "PR", "Porto-Riko" },
            { "PS", "Territoret Palestineze" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "nia", "niasisht" },
            { "type.nu.greklow", "numra grek\u00eb t\u00eb vegj\u00ebl" },
            { "PY", "Paraguai" },
            { "tum", "tumbukaisht" },
            { "Hebr", "hebraik" },
            { "QA", "Katar" },
            { "niu", "niueanisht" },
            { "QO", "Oqeania e Larg\u00ebt (Lindja e Larg\u00ebt)" },
            { "lez", "lezgianisht" },
            { "tvl", "tuvaluisht" },
            { "Maka", metaValue_mak },
            { "001", "Bota" },
            { "002", "Afrik\u00eb" },
            { "003", "Amerika e Veriut" },
            { "RE", "Reunion" },
            { "005", "Amerika e Jugut" },
            { "jbo", "lojbanisht" },
            { "Rjng", "rexhangisht" },
            { "009", "Oqeani" },
            { "Elym", "elimaisht" },
            { "RO", "Rumani" },
            { "RS", "Serbi" },
            { "Mroo", "mroisht" },
            { "RU", "Rusi" },
            { "RW", "Ruand\u00eb" },
            { "Mani", "manikeanisht" },
            { "Khar", "karoshtisht" },
            { "SA", "Arabi Saudite" },
            { "SB", "Ishujt Solomon" },
            { "twq", "tasavakisht" },
            { "011", "Afrika Per\u00ebndimore" },
            { "SC", "Sejshelle" },
            { "SD", "Sudan" },
            { "013", "Amerika Qendrore" },
            { "SE", "Suedi" },
            { "014", "Afrika Lindore" },
            { "015", "Afrika Veriore" },
            { "SG", "Singapor" },
            { "SH", "Sh\u00ebn-Elen\u00eb" },
            { "type.lb.strict", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - i ngushtuar" },
            { "017", "Afrika e Mesme" },
            { "SI", "Slloveni" },
            { "018", "Afrika Jugore" },
            { "SJ", "Svalbard e Jan-Majen" },
            { "019", "Amerik\u00eb" },
            { "SK", "Sllovaki" },
            { "SL", "Sierra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "arn", "mapu\u00e7isht" },
            { "arp", "arapahoisht" },
            { "type.nu.taml", "numra tamil\u00eb tradicional\u00eb" },
            { "SR", "Surinami" },
            { "SS", "Sudani i Jugut" },
            { "ST", "Sao-Tome e Principe" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Siri" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan-da-Kuna" },
            { "asa", "asuisht" },
            { "type.ms.ussystem", "sistem amerikan i nj\u00ebsive mat\u00ebse" },
            { "021", "Amerika Veriore" },
            { "TC", "Ishujt Turks dhe Kaikos" },
            { "yav", "jangbenisht" },
            { "TD", "\u00c7ad" },
            { "TF", "Territoret Jugore Franceze" },
            { "TG", "Togo" },
            { "TH", "Tajland\u00eb" },
            { "TJ", "Taxhikistan" },
            { "029", "Karaibe" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "jembaisht" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizi" },
            { "TO", "Tonga" },
            { "TR", "Turqi" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "ast", "asturisht" },
            { "Orkh", "orkonisht" },
            { "TZ", "Tanzani" },
            { "nmg", "kuasisht" },
            { "Zzzz", "i panjohur" },
            { "Sind", "kudavadisht" },
            { "UA", "Ukrain\u00eb" },
            { "lij", "ligurianisht" },
            { "rup", "vllahisht" },
            { "030", "Azia Lindore" },
            { "tyv", "tuvinianisht" },
            { "sw_CD", "suahilishte kongoleze" },
            { "034", "Azia Jugore" },
            { "035", "Azia Juglindore" },
            { "UG", "Ugand\u00eb" },
            { "type.co.pinyin", "Radhitje pinini" },
            { "039", "Evropa Jugore" },
            { "Sinh", "sinhal" },
            { "UM", "Ishujt Periferik\u00eb t\u00eb SHBA-s\u00eb" },
            { "UN", "Organizata e Kombeve t\u00eb Bashkuara" },
            { "US", "SHBA" },
            { "haw", "havaisht" },
            { "type.co.gb2312han", "Radhitje e kinezishtes s\u00eb thjesht\u00ebsuar - GB2312" },
            { "UY", "Uruguai" },
            { "prg", "prusisht" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tamazajtisht e Atlasit Qendror" },
            { "nnh", "ngiembunisht" },
            { "VA", "Vatikan" },
            { "VC", "Sh\u00ebn-Vincent dhe Grenadine" },
            { "VE", "Venezuel\u00eb" },
            { "VG", "Ishujt e Virgj\u00ebr Britanik\u00eb" },
            { "VI", "Ishujt e Virgj\u00ebr t\u00eb SHBA-s\u00eb" },
            { "Soyo", "sojomboisht" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "markenisht" },
            { "nog", "nogajisht" },
            { "rwk", "ruaisht" },
            { "053", "Australazia" },
            { "054", "Melanezia" },
            { "WF", "Uollis e Futuna" },
            { "057", "Rajoni Mikronezian" },
            { "jgo", "ngombisht" },
            { "lkt", "lakotisht" },
            { "wae", "ualserisht" },
            { "WS", "Samoa" },
            { "Bass", "basavahisht" },
            { "wal", "ulajtaisht" },
            { "XA", "Pseudo-thekse" },
            { "war", "uarajisht" },
            { "XB", "Pseudo-bidi" },
            { "awa", "auadhisht" },
            { "061", "Polinezia" },
            { "XK", "Kosov\u00eb" },
            { "Gujr", "guxharat" },
            { "Zxxx", "i pashkruar" },
            { "wbp", "uarlpirisht" },
            { "YE", "Jemen" },
            { "nqo", "nkoisht" },
            { "type.co.standard", "radhitje standarde" },
            { "Sgnw", "shkrim sing" },
            { "YT", "Majot\u00eb" },
            { "ZA", "Afrika e Jugut" },
            { "type.lb.loose", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - i larguar" },
            { "Deva", "devanagar" },
            { "type.nu.geor", "numra gjeorgjian\u00eb" },
            { "Hira", "hiragan" },
            { "ZM", "Zambi" },
            { "ZW", "Zimbabve" },
            { "ZZ", "I panjohur" },
            { "Runr", "runike" },
            { "type.ms.metric", "sistem metrik" },
            { "type.ca.iso8601", "kalendar ISO-8601" },
            { "nso", "sotoishte veriore" },
            { "type.nu.telu", "shifra teluguje" },
            { "lou", "kreole e Luizian\u00ebs" },
            { "loz", "lozisht" },
            { "jmc", "ma\u00e7amisht" },
            { "type.nu.hansfin", "numra financiar\u00eb t\u00eb kinezishtes s\u00eb thjeshtuar" },
            { "hil", "hiligajnonisht" },
            { "type.nu.arabext", "shifra indo-arabe t\u00eb zgjatura" },
            { "nus", "nuerisht" },
            { "dak", "dakotisht" },
            { "type.nu.fullwide", "shifra me larg\u00ebsi t\u00eb brendshme" },
            { "dar", "darguaisht" },
            { "dav", "tajtaisht" },
            { "lrc", "lurishte veriore" },
            { "Copt", "koptisht" },
            { "udm", "udmurtisht" },
            { "Khmr", "kmer" },
            { "sad", "sandauisht" },
            { "type.nu.roman", "numra romak\u00eb" },
            { "sah", "sakaisht" },
            { "Aghb", "albanishte e Kaukazit" },
            { "saq", "samburisht" },
            { "sat", "santalisht" },
            { "sba", "ngambajisht" },
            { "Guru", "gurmuk" },
            { "lua", "luba-luluaisht" },
            { "sbp", "sanguisht" },
            { "nyn", "niankolisht" },
            { "lun", "lundaisht" },
            { "luo", "luoisht" },
            { "fil", "filipinisht" },
            { "hmn", "hmongisht" },
            { "lus", "mizoisht" },
            { "ban", "balinezisht" },
            { "luy", "lujaisht" },
            { "bas", "basaisht" },
            { "es_ES", "spanjishte evropiane" },
            { "sco", "skotisht" },
            { "scn", "si\u00e7ilianisht" },
            { "aa", "afarisht" },
            { "ab", "abkazisht" },
            { "af", "afrikanisht" },
            { "ak", "akanisht" },
            { "am", "amarisht" },
            { "an", "aragonezisht" },
            { "Arab", "arabik" },
            { "Jpan", "japonez" },
            { "ar", "arabisht" },
            { "Hrkt", "alfabet rrokjesor japonez" },
            { "as", "asamezisht" },
            { "Lina", "Linear A" },
            { "av", "avarikisht" },
            { "Linb", "Linear B" },
            { "sdh", "kurdishte jugore" },
            { "ay", "ajmarisht" },
            { "az", "azerbajxhanisht" },
            { "Khoj", "koxhkisht" },
            { "ba", "bashkirisht" },
            { "be", "bjellorusisht" },
            { "bg", "bullgarisht" },
            { "bi", "bislamisht" },
            { "bm", "bambarisht" },
            { "bn", "bengalisht" },
            { "bo", metaValue_bo },
            { "dgr", "dogribisht" },
            { "br", "bretonisht" },
            { "bs", "boshnjakisht" },
            { "Bhks", "baiksukisht" },
            { "Mymr", "birman" },
            { "type.nu.laoo", "shifra lao" },
            { "seh", "senaisht" },
            { "ca", "katalonisht" },
            { "ses", "senishte kojrabore" },
            { "ce", "\u00e7e\u00e7enisht" },
            { "ch", "kamoroisht" },
            { "co", "korsikisht" },
            { "Orya", "orija" },
            { "cs", "\u00e7ekisht" },
            { "cu", "sllavishte kishtare" },
            { "cv", "\u00e7uvashisht" },
            { "cy", "uellsisht" },
            { "type.nu.ethi", "numra etiopian\u00eb" },
            { "da", "danisht" },
            { "pt_PT", "portugalishte evropiane" },
            { "de", "gjermanisht" },
            { "type.cf.standard", "format valutor standard" },
            { "Bugi", "buginisht" },
            { "bem", "bembaisht" },
            { "dv", "divehisht" },
            { "es_419", "spanjishte amerikano-latine" },
            { "dz", "xhongaisht" },
            { "bez", "benaisht" },
            { "type.ca.chinese", "kalendar kinez" },
            { "dje", "zarmaisht" },
            { "type.nu.grek", "numra grek\u00eb" },
            { "ee", "eveisht" },
            { "type.lb.normal", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - normal" },
            { "ro_MD", "moldavisht" },
            { "el", "greqisht" },
            { "en", "anglisht" },
            { "eo", "esperanto" },
            { "type.co.big5han", "Radhitje e kinezishtes tradicionale - Big5" },
            { "es", "spanjisht" },
            { "et", "estonisht" },
            { "Hanb", "hanbik" },
            { "eu", "baskisht" },
            { "Buhd", "buhidisht" },
            { "Hang", "hangul" },
            { "Samr", "samaritanisht" },
            { "shi", "ta\u00e7elitisht" },
            { "hsb", "sorbishte e sip\u00ebrme" },
            { "Hani", "han" },
            { "shn", "shanisht" },
            { "Hano", "hanunoisht" },
            { "fa", "persisht" },
            { "Hans", "i thjeshtuar" },
            { "type.nu.latn", "shifra latino-per\u00ebndimore" },
            { "Hant", "tradicional" },
            { "ff", "fulaisht" },
            { "fi", "finlandisht" },
            { "fj", "fixhianisht" },
            { "fon", "fonisht" },
            { "bgn", "balokishte per\u00ebndimore" },
            { "yue", "kantonezisht" },
            { "fo", "faroisht" },
            { "umb", "umbunduisht" },
            { "fr", "fr\u00ebngjisht" },
            { "fy", "frizianishte per\u00ebndimore" },
            { "ga", "irlandisht" },
            { "gd", "galishte skoceze" },
            { "gl", "galicisht" },
            { "Gonm", "masaramgondisht" },
            { "gn", "guaranisht" },
            { "bho", "boxhpurisht" },
            { "und", "E panjohur" },
            { "type.ca.ethiopic-amete-alem", "Kalendari Etiopas Amete Alem" },
            { "gu", "guxharatisht" },
            { "type.ca.islamic-tbla", "Kalendari Islamik (tabelor, epoka austromikale)" },
            { "gv", "manksisht" },
            { "ha", "hausisht" },
            { "he", "hebraisht" },
            { "hi", "indisht" },
            { "hup", "hupaisht" },
            { "bin", "binisht" },
            { "hr", "kroatisht" },
            { "ht", "haitisht" },
            { "hu", "hungarisht" },
            { "hy", "armenisht" },
            { "hz", "hereroisht" },
            { "frc", "fr\u00ebngjishte kajune" },
            { "ia", "interlingua" },
            { "Jamo", "jamosisht" },
            { "id", "indonezisht" },
            { "type.nu.tibt", "shifra tibetiane" },
            { "ie", "gjuha oksidentale" },
            { "ig", "igboisht" },
            { "ii", "sishuanisht" },
            { "io", "idoisht" },
            { "is", "islandisht" },
            { "it", "italisht" },
            { "iu", "inuktitutisht" },
            { "ja", "japonisht" },
            { "Mlym", "malajalam" },
            { "Sarb", "arabishte jugore e vjet\u00ebr" },
            { "doi", "dogrisht" },
            { "sma", "samishte jugore" },
            { "jv", "javanisht" },
            { "Shaw", "shavianisht" },
            { "mad", "madurezisht" },
            { "smj", "samishte lule" },
            { "mag", "magaisht" },
            { "mai", "maitilisht" },
            { "Ougr", "ujgurishte e vjet\u00ebr" },
            { "smn", "samishte inari" },
            { "mak", metaValue_mak },
            { "ka", "gjeorgjisht" },
            { "bla", "siksikaisht" },
            { "sms", "samishte skolti" },
            { "Goth", "gotik" },
            { "ki", "kikujuisht" },
            { "mas", "masaisht" },
            { "kj", "kuanjamaisht" },
            { "kk", "kazakisht" },
            { "kl", "kalalisutisht" },
            { "km", "kmerisht" },
            { "kn", "kanadisht" },
            { "ko", "koreanisht" },
            { "kr", "kanurisht" },
            { "ks", "kashmirisht" },
            { "Avst", "avestanisht" },
            { "ku", "kurdisht" },
            { "kv", "komisht" },
            { "kw", "kornisht" },
            { "ky", "kirgizisht" },
            { "snk", "soninkisht" },
            { "Mult", "multanisht" },
            { "la", "latinisht" },
            { "Hatr", "hatranisht" },
            { "lb", "luksemburgisht" },
            { "type.nu.mlym", "shifra malajalame" },
            { "lg", "gandaisht" },
            { "li", "limburgisht" },
            { "Tibt", metaValue_bo },
            { "ln", "lingalisht" },
            { "fur", "friulianisht" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "sistem imperial (britanik) i nj\u00ebsive mat\u00ebse" },
            { "lt", "lituanisht" },
            { "lu", "luba-katangaisht" },
            { "lv", "letonisht" },
            { "mg", "madagaskarisht" },
            { "mh", "marshallisht" },
            { "type.co.ducet", "radhitje unikode e parazgjedhur" },
            { "mi", "maorisht" },
            { "mk", "maqedonisht" },
            { "ml", "malajalamisht" },
            { "mn", metaValue_mn },
            { "mr", "maratisht" },
            { "ms", "malajisht" },
            { "mt", "maltisht" },
            { "my", "birmanisht" },
            { "Armn", "armen" },
            { "mdf", "mokshaisht" },
            { "dsb", "sorbishte e poshtme" },
            { "Armi", "aramaishte perandorake" },
            { "na", "nauruisht" },
            { "type.co.search", "k\u00ebrkim i p\u00ebrgjithsh\u00ebm" },
            { "nb", "norvegjishte letrare" },
            { "nd", "ndebelishte veriore" },
            { "ne", "nepalisht" },
            { "ng", "ndongaisht" },
            { "nl", "holandisht" },
            { "nn", "norvegjishte nynorsk" },
            { "no", "norvegjisht" },
            { "nr", "ndebelishte jugore" },
            { "nv", "navahoisht" },
            { "ny", "nianjisht" },
            { "kac", "ka\u00e7inisht" },
            { "kab", "kabilisht" },
            { "oc", "oksitanisht" },
            { "kaj", "kajeisht" },
            { "kam", "kambaisht" },
            { "men", "mendisht" },
            { "mer", "meruisht" },
            { "type.nu.armn", "numra armen\u00eb" },
            { "om", "oromoisht" },
            { "or", "odisht" },
            { "Modi", "modisht" },
            { "os", "osetisht" },
            { "kbd", "kabardianisht" },
            { "mfe", "morisjenisht" },
            { "srn", "srananisht (sranantongoisht)" },
            { "pa", "punxhabisht" },
            { "dua", "dualaisht" },
            { "pl", "polonisht" },
            { "type.ca.dangi", "kalendar dangi" },
            { "ps", "pashtoisht" },
            { "pt", "portugalisht" },
            { "key.co", "Radhitja" },
            { "pt_BR", "portugalishte braziliane" },
            { "kcg", "tjapisht" },
            { "mgh", "makua-mitoisht" },
            { "key.cf", "Formati valutor" },
            { "key.ca", "Kalendari" },
            { "Laoo", metaValue_lo },
            { "mgo", "metaisht" },
            { "type.hc.h23", "sistem 24-or\u00ebsh (0 - 23)" },
            { "type.hc.h24", "sistem 24-or\u00ebsh (1 - 24)" },
            { "ssy", "sahoisht" },
            { "type.nu.mymr", "shifra mianmari" },
            { "qu", "ke\u00e7uaisht" },
            { "brx", "bodoisht" },
            { "kde", "makondisht" },
            { "Ethi", "etiopik" },
            { "type.hc.h12", "sistem 12-or\u00ebsh (1 - 12)" },
            { "type.hc.h11", "sistem 12-or\u00ebsh (0 - 11)" },
            { "rm", "retoromanisht" },
            { "rn", "rundisht" },
            { "key.cu", "Valuta" },
            { "ro", "rumanisht" },
            { "type.nu.orya", "shifra orije" },
            { "type.nu.hanidec", "numra dhjetor\u00eb kinez\u00eb" },
            { "ru", "rusisht" },
            { "rw", "kiniaruandisht" },
            { "kea", "kreolishte e Kepit t\u00eb Gjelb\u00ebr" },
            { "mic", "mikmakisht" },
            { "suk", "sukumaisht" },
            { "en_AU", "anglishte australiane" },
            { "Dupl", "duplojanisht - form\u00eb e shkurt\u00ebr" },
            { "sa", "sanskritisht" },
            { "sc", "sardenjisht" },
            { "sd", "sindisht" },
            { "se", "samishte veriore" },
            { "min", "minangkabauisht" },
            { "sg", "sangoisht" },
            { "sh", "serbo-kroatisht" },
            { "si", "sinhalisht" },
            { "sk", "sllovakisht" },
            { "sl", "sllovenisht" },
            { "Gran", "grantaisht" },
            { "sm", "samoanisht" },
            { "sn", "shonisht" },
            { "so", "somalisht" },
            { "type.nu.arab", "shifra indo-arabe" },
            { "sq", "shqip" },
            { "sr", "serbisht" },
            { "ss", "suatisht" },
            { "type.cf.account", "format valutor llogarit\u00ebs" },
            { "st", "sotoishte jugore" },
            { "su", "sundanisht" },
            { "sv", "suedisht" },
            { "sw", "suahilisht" },
            { "type.nu.hantfin", "numra financiar\u00eb t\u00eb kinezishtes tradicionale" },
            { "ibb", "ibibioisht" },
            { "iba", "ibanisht" },
            { "ta", "tamilisht" },
            { "142", "Azi" },
            { "143", "Azia Qendrore" },
            { "te", "teluguisht" },
            { "145", "Azia Per\u00ebndimore" },
            { "tg", "taxhikisht" },
            { "th", "tajlandisht" },
            { "ti", "tigrinjaisht" },
            { "bug", "buginezisht" },
            { "kfo", "koroisht" },
            { "en_CA", "anglishte kanadeze" },
            { "tk", "turkmenisht" },
            { "tn", "cuanaisht" },
            { "to", "tonganisht" },
            { "dyo", "xhulafonjisht" },
            { "type.nu.jpan", "numra japonez\u00eb" },
            { "tr", "turqisht" },
            { "ts", "congaisht" },
            { "swb", "kamorianisht" },
            { "tt", "tatarisht" },
            { "tw", "tuisht" },
            { "ty", "tahitisht" },
            { "150", "Evrop\u00eb" },
            { "151", "Evropa Lindore" },
            { "154", "Evropa Veriore" },
            { "dzg", "dazagauisht" },
            { "155", "Evropa Per\u00ebndimore" },
            { "ug", "ujgurisht" },
            { "Ital", "italishte e vjet\u00ebr" },
            { "Kore", "korean" },
            { "kgp", "kaingangisht" },
            { "Zyyy", "i zakonsh\u00ebm" },
            { "uk", "ukrainisht" },
            { "type.ca.coptic", "Kalendari Koptik" },
            { "ur", "urduisht" },
            { "xal", "kalmikisht" },
            { "uz", "uzbekisht" },
            { "kha", "kasisht" },
            { "nds_NL", "gjermanishte saksone e vendeve t\u00eb ul\u00ebta" },
            { "ve", "vendaisht" },
            { "type.ca.roc", "kalendar minguo" },
            { "vi", "vietnamisht" },
            { "khq", "kojra\u00e7inisht" },
            { "key.hc", "Cikli orar (12 - 24)" },
            { "vo", "volapykisht" },
            { "Osma", "osmaniaisht" },
            { "quc", "ki\u00e7eisht" },
            { "gaa", "gaisht" },
            { "wa", "ualunisht" },
            { "gag", "gagauzisht" },
            { "syr", "siriakisht" },
            { "Cpmn", "minoishte e Qipros" },
            { "Grek", "grek" },
            { "Lydi", "lidianisht" },
            { "wo", "uolofisht" },
            { "zgh", "tamaziatishte standarde marokene" },
            { "ar_001", "arabishte standarde moderne" },
            { "Mong", metaValue_mn },
            { "Hluw", "hieroglife anatoliane" },
            { "mni", "manipurisht" },
            { "Latn", "latin" },
            { "Nand", "nandigarisht" },
            { "type.nu.hans", "numra t\u00eb kinezishtes s\u00eb thjeshtuar" },
            { "type.nu.hant", "numra t\u00eb kinezishtes tradicionale" },
            { "xh", "xhosaisht" },
            { "type.nu.romanlow", "numra romak\u00eb t\u00eb vegj\u00ebl" },
            { "byn", "blinisht" },
            { "Dogr", "dograisht" },
            { "Lyci", "licianisht" },
            { "moh", "mohokisht" },
            { "kkj", "kakoisht" },
            { "yi", "jidisht" },
            { "mos", "mosisht" },
            { "Dsrt", "deseretisht" },
            { "yo", "jorubaisht" },
            { "es_MX", "spanjishte meksikane" },
            { "vai", "vaisht" },
            { "Cari", "karianisht" },
            { "kln", "kalenxhinisht" },
            { "zh", "kinezisht" },
            { "Bopo", "bopomof" },
            { "Perm", "permike e vjet\u00ebr" },
            { "key.lb", "Stili i gjer\u00ebsis\u00eb s\u00eb rreshtave" },
            { "zu", "zuluisht" },
            { "type.co.phonebook", "Radhitje libri telefonik" },
            { "Geor", "gjeorgjian" },
            { "Shrd", "sharadisht" },
            { "kmb", "kimbunduisht" },
            { "type.nu.jpanfin", "numra financiar\u00eb japonez\u00eb" },
            { "gez", "gizisht" },
            { "Elba", "shkrim i Elbasanit" },
            { "Narb", "arabishte veriore e vjet\u00ebr" },
            { "type.co.reformed", "Radhitje e reformuar" },
            { "Palm", "palmirenisht" },
            { "ebu", "embuisht" },
            { "Egyp", "hieroglife egjiptiane" },
            { "zh_Hans", "kinezishte e thjeshtuar" },
            { "koi", "komi-parmjakisht" },
            { "Hung", "hungarishte e vjet\u00ebr" },
            { "kok", "konkanisht" },
            { "zh_Hant", "kinezishte tradicionale" },
            { "kpe", "kpeleisht" },
            { "type.nu.khmr", "shifra kmere" },
            { "ilo", "ilokoisht" },
            { "Cprt", "qipriotisht" },
            { "Diak", "divesakuruisht" },
            { "mua", "mundangisht" },
            { "type.nu.guru", "shifra gurmuki" },
            { "mul", "gjuh\u00eb t\u00eb shum\u00ebfishta" },
            { "key.ms", "Sistemi i nj\u00ebsive mat\u00ebse" },
            { "mus", "krikisht" },
            { "Glag", "glagolitikisht" },
            { "gil", "gilbertazisht" },
            { "type.nu.tamldec", "shifra tamile" },
            { "krc", "kara\u00e7aj-balkarisht" },
            { "inh", "ingushisht" },
            { "fa_AF", "darisht" },
            { "krl", "karelianisht" },
            { "efi", "efikisht" },
            { "key.nu", "Numrat/shifrat" },
            { "kru", "kurukisht" },
            { "ksb", "shambalisht" },
            { "Telu", "telug" },
            { "ksf", "bafianisht" },
        };
        return data;
    }
}
