/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Tiamana";
        final String metaValue_FR = "W\u012bw\u012b";
        final Object[][] data = new Object[][] {
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "de_AT", "Tiamana Atiria" },
            { "zh_Hans", "Hainamana M\u0101m\u0101" },
            { "pt", "P\u014dtuk\u012bhi" },
            { "Zzzz", "Momotuhi T\u0113 M\u014dhiotia" },
            { "pt_BR", "P\u014dtuk\u012bhi Parahi" },
            { "type.co.standard", "Raupapa K\u014dmaka Arowh\u0101nui" },
            { "es_419", "Paniora Amerika ki te Tonga" },
            { "es_MX", "Paniora M\u0113hikana" },
            { "es_ES", "Paniora Uropi" },
            { "mi", "te reo M\u0101ori" },
            { "zh_Hant", "Hainamana Tukuiho" },
            { "MK", "Maker\u014dnia ki te Raki" },
            { "US", "Hononga o Amerika" },
            { "IN", "Inia" },
            { "en", "Ingarihi" },
            { "IT", "It\u0101ria" },
            { "it", "\u012atariana" },
            { "Arab", "Arapika" },
            { "es", "Paniora" },
            { "zh", "Hainamana" },
            { "type.ca.gregorian", "Maramataka P\u0101keh\u0101" },
            { "en_US", "Ingarihi Amerikana" },
            { "ja", "Hapanihi" },
            { "Hans", "M\u0101m\u0101" },
            { "type.nu.latn", "Ng\u0101 Mati P\u0101keh\u0101" },
            { "Hant", "Tukuiho" },
            { "ZZ", "Rohe T\u0113 M\u014dhiotia" },
            { "RU", "R\u016bhia" },
            { "ru", "Ruhiana" },
            { "JP", "Hapani" },
            { "en_AU", "Ingarihi Ahitereiriana" },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "NZ", "Aotearoa" },
            { "BR", "Parahi" },
            { "de_CH", "Tiamana \u014ckawa Huiterangi" },
            { "GB", "Hononga o Piritene" },
            { "fr_CA", "W\u012bw\u012b K\u0101nata" },
            { "und", "Reo T\u0113 M\u014dhiotia" },
            { "fr_CH", "W\u012bw\u012b Huiterangi" },
            { "CN", "Haina" },
            { "Latn", "R\u0101tina" },
            { "Cyrl", "H\u012bririki" },
            { "en_GB", "Ingarihi Piritene" },
            { "Zxxx", "Tuhikore" },
            { "en_CA", "Ingarihi K\u0101nata" },
            { "pt_PT", "P\u014dtuk\u012bhi Uropi" },
        };
        return data;
    }
}
