/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ckb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0641\u06cc\u062c\u06cc";
        final String metaValue_MM = "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631";
        final String metaValue_NR = "\u0646\u0627\u0626\u0648\u0631\u0648\u0648";
        final String metaValue_TV = "\u062a\u0648\u0648\u06a4\u0627\u0644\u0648\u0648";
        final String metaValue_ar = "\u0639\u06d5\u0631\u06d5\u0628\u06cc";
        final String metaValue_bo = "\u062a\u06d5\u0628\u06d5\u062a\u06cc";
        final String metaValue_el = "\u06cc\u06c6\u0646\u0627\u0646\u06cc";
        final String metaValue_he = "\u0639\u06cc\u0628\u0631\u06cc";
        final String metaValue_hy = "\u0626\u06d5\u0631\u0645\u06d5\u0646\u06cc";
        final String metaValue_ja = "\u0698\u0627\u067e\u06c6\u0646\u06cc";
        final String metaValue_km = "\u062e\u0645\u06ce\u0631";
        final String metaValue_kn = "\u06a9\u0627\u0646\u0646\u0627\u062f\u0627";
        final String metaValue_la = "\u0644\u0627\u062a\u06cc\u0646\u06cc";
        final String metaValue_ml = "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645";
        final String metaValue_mn = "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc";
        final String metaValue_or = "\u0626\u06c6\u062f\u06cc\u0627";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644\u06cc";
        final String metaValue_te = "\u062a\u06ce\u0644\u0648\u0648\u06af\u0648\u0648";
        final String metaValue_th = "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f\u06cc";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0648" },
            { "ksh", "\u06a9\u06c6\u0644\u06c6\u0646\u06cc" },
            { "nyn", "\u0646\u06cc\u0627\u0646\u06a9\u06c6\u0644\u06ce" },
            { "mwl", "\u0645\u06cc\u0631\u0627\u0646\u062f\u06cc" },
            { "lun", "\u0644\u0648\u0648\u0646\u062f\u0627" },
            { "luo", "\u0644\u0648\u0648\u0626\u06c6" },
            { "Zsym", "\u0647\u06ce\u0645\u0627\u06a9\u0627\u0646" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u06cc" },
            { "hmn", "\u0647\u0645\u06c6\u0646\u06af" },
            { "lus", "\u0645\u06cc\u0632\u06c6" },
            { "ban", "\u0628\u0627\u0644\u06cc" },
            { "Zsye", "\u0626\u06cc\u0645\u06c6\u062c\u06cc" },
            { "luy", "\u0644\u0648\u0648\u06cc\u0627" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "tem", "\u062a\u06cc\u0645\u0646\u06ce" },
            { "sco", "\u0633\u06a9\u06c6\u062a\u0633" },
            { "scn", "\u0633\u06cc\u0633\u06cc\u0644\u06cc" },
            { "teo", "\u062a\u06ce\u0633\u0648\u0648" },
            { "aa", "\u0626\u06d5\u0641\u0627\u0631" },
            { "rap", "\u0695\u0627\u067e\u0627\u0646\u0648\u0648\u06cc\u06cc" },
            { "ab", "\u0626\u06d5\u0628\u062e\u0627\u0632\u06cc" },
            { "AC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0626\u0627\u0633\u06cc\u0646\u0633\u06cc\u06c6\u0646" },
            { "rar", "\u0695\u0627\u0695\u06c6\u062a\u06c6\u0646\u06af\u0627\u0646" },
            { "tet", "\u062a\u06ce\u062a\u0648\u0648\u0645" },
            { "AD", "\u0626\u0627\u0646\u062f\u06c6\u0631\u0627" },
            { "AE", "\u0645\u06cc\u0631\u0646\u0634\u06cc\u0646\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5 \u0639\u06d5\u0631\u06d5\u0628\u06cc\u06cc\u06d5\u06a9\u0627\u0646" },
            { "nl_BE", "\u0641\u0644\u06ce\u0645\u06cc" },
            { "AF", "\u0626\u06d5\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "af", "\u0626\u06d5\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "AG", "\u0626\u0627\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0626\u0627\u0646\u06af\u0648\u06cc\u0644\u0627" },
            { "ak", "\u0626\u0627\u06a9\u0627\u0646" },
            { "AL", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc\u0627" },
            { "AM", "\u0626\u06d5\u0631\u0645\u06d5\u0646\u0633\u062a\u0627\u0646" },
            { "am", "\u0626\u06d5\u0645\u06be\u06d5\u0631\u06cc" },
            { "Arab", metaValue_ar },
            { "an", "\u0626\u0627\u0631\u0627\u06af\u06c6\u0646\u06cc" },
            { "AO", "\u0626\u06d5\u0646\u06af\u06c6\u0644\u0627" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0626\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "ar", metaValue_ar },
            { "AR", "\u0626\u06d5\u0631\u0698\u06d5\u0646\u062a\u06cc\u0646" },
            { "Hrkt", "\u0698\u0627\u067e\u06c6\u0646\u06cc\u06cc \u0628\u0695\u06af\u06d5\u06cc\u06cc" },
            { "AS", "\u0633\u0627\u0645\u0648\u0627\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "as", "\u0626\u0627\u0633\u0627\u0645\u06cc" },
            { "AT", "\u0646\u06d5\u0645\u0633\u0627" },
            { "AU", "\u0626\u0648\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "av", "\u0626\u06d5\u06a4\u0627\u0631\u06cc" },
            { "AW", "\u0626\u0627\u0631\u0648\u0648\u0628\u0627" },
            { "sdh", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "en_US", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "AX", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0626\u0627\u0644\u0627\u0646\u062f" },
            { "ay", "\u0626\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "AZ", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646" },
            { "az", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc" },
            { "BA", "\u0628\u06c6\u0633\u0646\u06cc\u0627 \u0648 \u06be\u06d5\u0631\u0632\u06d5\u06af\u06c6\u06a4\u06cc\u0646\u0627" },
            { "ba", "\u0628\u0627\u0634\u06a9\u06cc\u06d5\u0631" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u06c6\u0633" },
            { "ceb", "\u0633\u06ce\u0628\u0648\u0627\u0646\u06c6" },
            { "BD", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06cc\u0634" },
            { "kum", "\u06a9\u0648\u0648\u0645\u06cc\u06a9" },
            { "BE", "\u0628\u06d5\u0644\u0698\u06cc\u06a9" },
            { "be", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633\u06cc" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627\u0641\u0627\u0633\u06c6" },
            { "BG", "\u0628\u0648\u0644\u06af\u0627\u0631\u06cc\u0627" },
            { "bg", "\u0628\u06c6\u0644\u06af\u0627\u0631\u06cc" },
            { "BH", "\u0628\u06d5\u062d\u0631\u06d5\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "bi", "\u0628\u06cc\u0633\u0644\u0627\u0645\u0627" },
            { "BJ", "\u0628\u06ce\u0646\u06cc\u0646" },
            { "BL", "\u0633\u06d5\u0646 \u0628\u0627\u0631\u062a\u06ce\u0644\u06ce\u0645\u06cc" },
            { "BM", "\u0628\u06ce\u0631\u0645\u0648\u0648\u062f\u0627" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627" },
            { "myv", "\u0626\u06ce\u0631\u0632\u06cc\u0627" },
            { "BN", "\u0628\u0631\u0648\u0648\u0646\u0627\u06cc" },
            { "bn", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06ce\u0634\u06cc" },
            { "bo", metaValue_bo },
            { "BO", "\u0628\u06c6\u0644\u06cc\u06a4\u06cc\u0627" },
            { "dgr", "\u062f\u06c6\u06af\u0631\u06cc\u0628" },
            { "BQ", "\u062f\u0648\u0648\u0631\u06af\u06d5 \u06a9\u0627\u0631\u06cc\u0628\u06cc\u06d5\u06a9\u0627\u0646\u06cc \u0647\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "br", "\u0628\u0631\u06ce\u062a\u0648\u0646\u06cc" },
            { "BS", "\u0628\u06d5\u06be\u0627\u0645\u0627" },
            { "bs", "\u0628\u06c6\u0633\u0646\u06cc" },
            { "xog", "\u0633\u06c6\u06af\u0627" },
            { "BT", "\u0628\u0648\u0648\u062a\u0627\u0646" },
            { "BV", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0628\u0648\u0648\u06a4\u06ce" },
            { "Mymr", metaValue_MM },
            { "BW", "\u0628\u06c6\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633" },
            { "seh", "\u0633\u06ce\u0646\u0627" },
            { "BZ", "\u0628\u06d5\u0644\u06cc\u0632" },
            { "CA", "\u06a9\u06d5\u0646\u06d5\u062f\u0627" },
            { "ca", "\u0643\u0627\u062a\u0627\u0644\u06c6\u0646\u06cc" },
            { "CC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06cc\u0644\u06cc\u0646\u06af" },
            { "mzn", "\u0645\u0627\u0632\u06d5\u0646\u062f\u06d5\u0631\u0627\u0646\u06cc" },
            { "ses", "\u06a9\u06c6\u06cc\u0631\u0627\u0628\u06c6\u0631\u06c6 \u0633\u06ce\u0646\u06cc" },
            { "CD", "\u06a9\u06c6\u0646\u06af\u06c6 \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "ce", "\u0686\u06cc\u0686\u0627\u0646\u06cc" },
            { "CF", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "CG", "\u06a9\u06c6\u0646\u06af\u06c6 \u0628\u0631\u0627\u0632\u0627\u06a4\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u0633\u0695\u0627" },
            { "ch", "\u0686\u0627\u0645\u06c6\u0631\u06c6" },
            { "CI", "\u06a9\u06c6\u062a\u062f\u06cc\u06a4\u0648\u0627\u0631" },
            { "CK", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u0648\u06a9" },
            { "CL", "\u0686\u06cc\u0644\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u06cc\u0631\u06c6\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u06c6\u0644\u06c6\u0645\u0628\u06cc\u0627" },
            { "co", "\u06a9\u06c6\u0631\u0633\u06cc\u06a9\u06cc" },
            { "CP", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u06a9\u0644\u06cc\u067e\u06ce\u0631\u062a\u06c6\u0646" },
            { "Orya", metaValue_or },
            { "CR", "\u06a9\u06c6\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "cs", "\u0686\u06ce\u06a9\u06cc" },
            { "CU", "\u06a9\u0648\u0648\u0628\u0627" },
            { "cu", "\u0633\u0644\u0627\u0648\u06cc\u06cc \u06a9\u0644\u06cc\u0633\u06d5\u06cc\u06cc" },
            { "CV", "\u06a9\u06d5\u06cc\u067e\u06a4\u06d5\u0631\u062f" },
            { "cv", "\u0686\u0648\u0648\u06a4\u0627\u0634\u06cc" },
            { "CW", "\u06a9\u0648\u0631\u0627\u0686\u0627\u0648" },
            { "CX", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u06a9\u0631\u06cc\u0633\u0645\u0633" },
            { "CY", "\u0642\u06cc\u0628\u0631\u0633" },
            { "cy", "\u0648\u06ce\u0644\u0632\u06cc" },
            { "CZ", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0686\u06cc\u06a9" },
            { "eka", "\u0626\u06ce\u06a9\u0627\u062c\u0648\u0648\u06a9" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u0643\u06cc" },
            { "DE", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc\u0627" },
            { "de", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc" },
            { "ace", "\u0626\u0627\u0686\u06d5\u06cc\u06cc" },
            { "cgg", "\u06a9\u06cc\u06af\u0627" },
            { "DG", "\u062f\u06cc\u06d5\u06af\u06c6 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u0648\u062a\u06cc" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "Brai", "\u0628\u0631\u06d5\u06cc\u0644" },
            { "DM", "\u062f\u06c6\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u062f\u06c6\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "bem", "\u0628\u06ce\u0645\u0628\u0627" },
            { "gor", "\u06af\u06c6\u0631\u06c6\u0646\u062a\u0627\u0644\u06cc" },
            { "dv", "\u062f\u06cc\u06a4\u06ce\u0647\u06cc" },
            { "zun", "\u0632\u0648\u0648\u0646\u06cc" },
            { "tig", "\u062a\u06cc\u06af\u0631\u06ce" },
            { "DZ", "\u062c\u06d5\u0632\u0627\u06cc\u0631" },
            { "dz", "\u062f\u0632\u0648\u0648\u0646\u06af\u062e\u0627" },
            { "bez", "\u0628\u06ce\u0646\u0627" },
            { "pag", "\u067e\u0627\u0646\u06af\u0627\u0633\u06cc\u0646\u0627\u0646" },
            { "EA", "\u0633\u06ce\u0626\u0648\u0648\u062a\u0627 \u0648 \u0645\u06ce\u0644\u06cc\u06cc\u0627" },
            { "pam", "\u067e\u0627\u0645\u067e\u0627\u0646\u06af\u0627" },
            { "EC", "\u0626\u06cc\u06a9\u0648\u0627\u062f\u06c6\u0631" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627" },
            { "pap", "\u067e\u0627\u067e\u06cc\u0627\u0645\u06ce\u0646\u062a\u06c6" },
            { "ada", "\u062f\u0627\u0646\u06af\u0645\u06ce" },
            { "EE", "\u0626\u06cc\u0633\u062a\u06c6\u0646\u06cc\u0627" },
            { "ee", "\u0626\u06ce\u0648\u06ce\u06cc\u06cc" },
            { "EG", "\u0645\u06cc\u0633\u0631" },
            { "EH", "\u0633\u06d5\u062d\u0631\u0627\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "ro_MD", "\u0645\u06c6\u06b5\u062f\u0627\u06a4\u06cc" },
            { "pau", "\u067e\u0627\u0644\u0627\u0626\u0648\u0648\u06cc\u06cc" },
            { "el", metaValue_el },
            { "chk", "\u0686\u0648\u0648\u06a9\u06cc" },
            { "en", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc" },
            { "chm", "\u0645\u0627\u0631\u06cc" },
            { "eo", "\u0626\u06ce\u0633\u067e\u06cc\u0631\u0627\u0646\u062a\u06c6" },
            { "cho", "\u0686\u06c6\u06a9\u062a\u0627\u0648" },
            { "chr", "\u0686\u06ce\u0631\u06c6\u06a9\u06cc" },
            { "ER", "\u0626\u06d5\u0631\u06cc\u062a\u0631\u06cc\u0627" },
            { "ES", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "es", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc" },
            { "ET", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u0627" },
            { "et", "\u0626\u06cc\u0633\u062a\u06c6\u0646\u06cc" },
            { "Hanb", "\u0647\u0627\u0646 \u0644\u06d5\u06af\u06d5\u06b5 \u0628\u06c6\u067e\u06c6\u0645\u06c6\u0641\u06c6" },
            { "EU", "\u06cc\u06d5\u06a9\u06ce\u062a\u06cc\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Hang", "\u06be\u0627\u0646\u06af\u0648\u0644" },
            { "EZ", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u06cc\u06c6\u0631\u06c6" },
            { "chy", "\u0634\u0627\u06cc\u0627\u0646" },
            { "shi", "\u0634\u06cc\u0644\u0647\u0627" },
            { "hsb", "\u0633\u0631\u0628\u06cc\u06cc \u0633\u06d5\u0631\u0648\u0648" },
            { "Hani", "\u06be\u0627\u0646" },
            { "ady", "\u0626\u0627\u062f\u06cc\u06af\u06cc" },
            { "shn", "\u0634\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0626\u0627\u0633\u0627\u0646\u06a9\u0631\u0627\u0648" },
            { "Hant", "\u062f\u06ce\u0631\u06cc\u0646" },
            { "az_Arab", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "ff", "\u0641\u0648\u0648\u0644\u0627\u06cc\u06cc" },
            { "FI", "\u0641\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "fi", "\u0641\u06cc\u0646\u0644\u06d5\u0646\u062f\u06cc" },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "fon", "\u0641\u06c6\u0646\u06cc" },
            { "FK", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0644\u06a4\u06cc\u0646\u0627\u0633 (\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0641\u0627\u06b5\u06a9\u0644\u0627\u0646\u062f)" },
            { "FM", "\u0645\u0627\u06cc\u06a9\u0631\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "yue", "\u06a9\u0627\u0646\u062a\u06c6\u0646\u06cc" },
            { "FO", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0641\u0627\u0631\u06d5\u0648" },
            { "fo", "\u0641\u06d5\u0631\u06c6\u06cc\u06cc" },
            { "Taml", metaValue_ta },
            { "umb", "\u0626\u0648\u0645\u0628\u0648\u0648\u0646\u062f\u0648\u0648" },
            { "FR", "\u0641\u06d5\u0695\u06d5\u0646\u0633\u0627" },
            { "fr", "\u0641\u06d5\u0631\u06d5\u0646\u0633\u06cc" },
            { "fy", "\u0641\u0631\u06cc\u0633\u06cc\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "GA", "\u06af\u0627\u0628\u06c6\u0646" },
            { "ga", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f\u06cc" },
            { "GB", "\u0634\u0627\u0646\u0634\u06cc\u0646\u06cc \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648" },
            { "pcm", "\u067e\u06cc\u062c\u06cc\u0646\u06cc \u0646\u06cc\u062c\u0631\u06cc\u0627" },
            { "GD", "\u06af\u0631\u06cc\u0646\u0627\u062f\u0627" },
            { "gd", "\u06af\u0647\u200c\u0644\u06cc\u0643\u06cc \u0633\u0643\u06c6\u062a\u0644\u0647\u200c\u0646\u062f\u06cc" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u06af\u06cc\u0627\u0646\u0627\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "GG", "\u06af\u06ce\u0631\u0646\u0632\u06cc" },
            { "GH", "\u063a\u06d5\u0646\u0627" },
            { "GI", "\u06af\u06cc\u0628\u0631\u0627\u0644\u062a\u0627\u0631" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0633\u06cc" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u06ce" },
            { "gn", "\u06af\u0648\u0648\u0627\u0631\u0627\u0646\u06cc" },
            { "bho", "\u0628\u0648\u062c\u067e\u0648\u0648\u0631\u06cc" },
            { "GP", "\u06af\u0648\u0627\u062f\u06ce\u0644\u06c6\u067e" },
            { "GQ", "\u06af\u06cc\u0646\u06ce\u06cc \u0626\u06cc\u0633\u062a\u0648\u0627\u06cc\u06cc" },
            { "und", "\u0632\u0645\u0627\u0646\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "GR", "\u06cc\u06c6\u0646\u0627\u0646" },
            { "GS", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062c\u06c6\u0631\u062c\u06cc\u0627 \u0648 \u0633\u0627\u0646\u062f\u0648\u06cc\u0686\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "GT", "\u06af\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "gu", "\u06af\u0648\u062c\u0627\u0631\u0627\u062a\u06cc" },
            { "gv", "\u0645\u0627\u0646\u06a9\u06cc" },
            { "GW", "\u06af\u06cc\u0646\u06ce \u0628\u06cc\u0633\u0627\u0648" },
            { "tlh", "\u0643\u0644\u06cc\u0646\u06af\u06c6\u0646" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646\u0627" },
            { "ha", "\u0647\u0627\u0626\u0648\u0648\u0633\u0627" },
            { "ckb", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0646\u0627\u0648\u06d5\u0646\u062f\u06cc" },
            { "zxx", "\u0647\u06cc\u0686 \u0646\u0627\u0648\u06d5\u0631\u06c6\u06a9\u06cc \u0632\u0645\u0627\u0646\u06cc \u0646\u06cc\u06d5" },
            { "he", metaValue_he },
            { "hi", "\u0647\u06cc\u0646\u062f\u06cc" },
            { "hup", "\u0647\u0648\u0648\u067e\u0627" },
            { "HK", "\u0647\u06c6\u0646\u06af \u06a9\u06c6\u0646\u06af" },
            { "HM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0647\u06ce\u0631\u062f \u0648 \u0645\u06d5\u06a9\u062f\u0627\u0646\u06b5\u062f" },
            { "HN", "\u06be\u06c6\u0646\u062f\u0648\u0648\u0631\u0627\u0633" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "HR", "\u06a9\u0631\u06c6\u0648\u0627\u062a\u06cc\u0627" },
            { "hr", "\u0643\u0631\u0648\u0627\u062a\u06cc" },
            { "agq", "\u0626\u0627\u06af\u06ce\u0645" },
            { "gsw", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc\u06cc \u0633\u0648\u06cc\u0633\u0695\u0627" },
            { "HT", "\u06be\u0627\u06cc\u062a\u06cc" },
            { "ht", "\u06a9\u0631\u06cc\u0648\u0644\u06cc \u0647\u0627\u0626\u06cc\u062a\u06cc" },
            { "HU", "\u0647\u06d5\u0646\u06af\u0627\u0631\u06cc\u0627" },
            { "hu", "\u0647\u06d5\u0646\u06af\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "hz", "\u0647\u06ce\u0631\u06ce\u0631\u06c6" },
            { "ia", "\u0626\u06cc\u0646\u062a\u0631\u0644\u06cc\u0646\u06af\u0648\u0648\u0627" },
            { "IC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06d5\u0646\u0627\u0631\u06cc" },
            { "Jamo", "\u062c\u0627\u0645\u06c6" },
            { "ID", "\u0626\u06cc\u0646\u062f\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "id", "\u0626\u06cc\u0646\u062f\u06c6\u0646\u06cc\u0632\u06cc" },
            { "IE", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f" },
            { "nap", "\u0646\u0627\u067e\u06c6\u0644\u06cc" },
            { "ig", "\u0626\u06cc\u06af\u0628\u06c6" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "ii", "\u0633\u06cc\u0686\u0648\u0627\u0646 \u06cc\u06cc" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0626\u06cc\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "IM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0645\u0627\u0646" },
            { "IN", "\u06be\u06cc\u0646\u062f\u0633\u062a\u0627\u0646" },
            { "IO", "\u06be\u06d5\u0631\u06ce\u0645\u06cc \u0628\u06d5\u0631\u06cc\u062a\u0627\u0646\u06cc \u0644\u06d5 \u0626\u06c6\u0642\u06cc\u0627\u0646\u0648\u0648\u0633\u06cc \u06be\u06cc\u0646\u062f" },
            { "io", "\u0626\u06cc\u062f\u06c6" },
            { "IQ", "\u0639\u06ce\u0631\u0627\u0642" },
            { "IR", "\u0626\u06ce\u0631\u0627\u0646" },
            { "IS", "\u0626\u0627\u06cc\u0633\u0644\u06d5\u0646\u062f" },
            { "is", "\u0626\u06cc\u0633\u0644\u06d5\u0646\u062f\u06cc" },
            { "IT", "\u0626\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "it", "\u0626\u06cc\u062a\u0627\u0644\u06cc" },
            { "iu", "\u0626\u06cc\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "Zmth", "\u0646\u06cc\u0634\u0627\u0646\u06d5\u06cc \u0628\u06cc\u0631\u06a9\u0627\u0631\u06cc" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "\u062c\u06ce\u0631\u0633\u06cc" },
            { "JM", "\u062c\u0627\u0645\u0627\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u06d5\u0646\u06af\u0627\u0644\u06cc" },
            { "JO", "\u0626\u0648\u0631\u062f\u0646" },
            { "JP", "\u0698\u0627\u067e\u06c6\u0646" },
            { "sma", "\u0633\u0627\u0645\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "ain", "\u0626\u0627\u06cc\u0646\u0648\u0648" },
            { "jv", "\u062c\u0627\u06a4\u0627\u06cc\u06cc" },
            { "guz", "\u06af\u0648\u0648\u0633\u06cc" },
            { "mad", "\u0645\u0627\u062f\u0648\u0648\u0631\u06cc" },
            { "smj", "\u0644\u0648\u0648\u0644\u06ce \u0633\u0627\u0645\u06cc" },
            { "mag", "\u0645\u0627\u06af\u0627\u0647\u06cc" },
            { "mai", "\u0645\u0627\u0626\u06cc\u062a\u06cc\u0644\u06cc" },
            { "smn", "\u0626\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "ka", "\u06af\u06c6\u0631\u062c\u0633\u062a\u0627\u0646\u06cc" },
            { "bla", "\u0633\u06cc\u06a9\u0633\u06cc\u06a9\u0627" },
            { "mak", "\u0645\u0627\u06a9\u0627\u0633\u0627\u0631" },
            { "sms", "\u0633\u0627\u0645\u06cc\u06cc \u0633\u06a9\u06c6\u06b5\u062a" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "419", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0644\u0627\u062a\u06cc\u0646" },
            { "KG", "\u06a9\u0631\u06af\u06cc\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u06d5\u0645\u0628\u06c6\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u0633" },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u0648\u06cc\u0648\u0648" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "kj", "\u06a9\u0648\u0627\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u06a9\u0627\u0632\u0627\u062e\u06cc" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0644\u06cc\u0633\u0648\u0648\u062a" },
            { "km", metaValue_km },
            { "KM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06c6\u0645\u06c6\u0631" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0633\u06d5\u0646 \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u06cc\u06a4\u06cc\u0633" },
            { "ko", "\u0643\u06c6\u0631\u06cc" },
            { "KP", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "KR", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "kr", "\u06a9\u0627\u0646\u0648\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u06d5\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc" },
            { "kv", "\u06a9\u06c6\u0645\u06cc" },
            { "KW", "\u06a9\u0648\u06d5\u06cc\u062a" },
            { "kw", "\u06a9\u06c6\u0695\u0646\u06cc" },
            { "tpi", "\u062a\u06c6\u06a9\u067e\u06cc\u0633\u06cc\u0646" },
            { "KY", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u0627\u06cc\u0645\u0627\u0646" },
            { "ky", "\u0643\u0631\u06af\u06cc\u0632\u06cc" },
            { "KZ", "\u06a9\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u0631\u06cc\u0644\u06cc\u06a9" },
            { "snk", "\u0633\u06c6\u0646\u06cc\u0646\u06a9\u06ce" },
            { "la", metaValue_la },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0648\u0628\u0646\u0627\u0646" },
            { "lb", "\u0644\u0648\u06a9\u0633\u06d5\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "LC", "\u0633\u06d5\u0646 \u0644\u0648\u0648\u0633\u06cc\u0627" },
            { "gwi", "\u06af\u0648\u06cc\u0686\u06cc\u0646" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646\u0634\u062a\u0627\u06cc\u0646" },
            { "li", "\u0644\u06cc\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "LK", "\u0633\u0631\u06cc\u0644\u0627\u0646\u06a9\u0627" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u064a\u0646\u06af\u0627\u0644\u0627" },
            { "fur", "\u0641\u0631\u06cc\u0626\u0648\u0648\u0644\u06cc" },
            { "lo", "\u0644\u0627\u0626\u06c6\u06cc\u06cc" },
            { "LR", "\u0644\u06cc\u0628\u06d5\u0631\u06cc\u0627" },
            { "LS", "\u0644\u06d5\u0633\u06c6\u062a\u06c6" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u0627\u06cc\u0627" },
            { "lt", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc" },
            { "LU", "\u0644\u0648\u06a9\u0633\u06d5\u0645\u0628\u0648\u0631\u06af" },
            { "lu", "\u0644\u0648\u0648\u0628\u0627 \u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "LV", "\u0644\u0627\u062a\u06a4\u06cc\u0627" },
            { "lv", "\u0644\u06ce\u062a\u06c6\u0646\u06cc" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "lad", "\u0644\u0627\u062f\u06cc\u0646\u06c6" },
            { "vun", "\u06a4\u0648\u0648\u0646\u062c\u0648\u0648" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "Thaa", "\u062a\u0627\u0646\u0627" },
            { "MA", "\u0645\u06d5\u063a\u0631\u06cc\u0628" },
            { "MC", "\u0645\u06c6\u0646\u0627\u06a9\u06c6" },
            { "MD", "\u0645\u06c6\u0644\u062f\u06c6\u06a4\u0627" },
            { "ME", "\u0645\u06c6\u0646\u062a\u06cc\u0646\u06cc\u06af\u0631\u06c6" },
            { "MF", "\u0633\u06d5\u0646 \u0645\u0627\u0631\u062a\u06cc\u0646" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "Thai", metaValue_th },
            { "MH", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0631\u0634\u0627\u06b5" },
            { "mh", "\u0645\u0627\u0631\u0634\u0627\u06b5\u06cc" },
            { "ale", "\u0626\u0627\u0644\u06cc\u0648\u062a" },
            { "mi", "\u0645\u0627\u0626\u06c6\u0631\u06cc" },
            { "MK", "\u0645\u06d5\u06a9\u062f\u06c6\u0646\u06cc\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "mk", "\u0645\u0627\u0643\u06ce\u062f\u06c6\u0646\u06cc" },
            { "ml", metaValue_ml },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", metaValue_MM },
            { "mn", metaValue_mn },
            { "MN", "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc\u0627" },
            { "new", "\u0646\u06ce\u0648\u0627\u0631\u06cc" },
            { "MO", "\u0645\u0627\u06a9\u0627\u0626\u06c6" },
            { "MP", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "MQ", "\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u06c6\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u06cc" },
            { "MS", "\u0645\u06c6\u0646\u062a\u0633\u06ce\u0631\u0627\u062a" },
            { "ms", "\u0645\u0627\u0644\u06cc\u0632\u06cc" },
            { "MT", "\u0645\u0627\u06b5\u062a\u0627" },
            { "mt", "\u0645\u0627\u06b5\u062a\u06cc" },
            { "MU", "\u0645\u0648\u0648\u0631\u06cc\u062a\u06cc\u0648\u0648\u0633" },
            { "alt", "\u0626\u0627\u06b5\u062a\u0627\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u06a4" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06d5\u06a9\u0633\u06cc\u06a9" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "my", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631\u06cc" },
            { "Armn", metaValue_hy },
            { "MZ", "\u0645\u06c6\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "mdf", "\u0645\u06c6\u06a9\u0634\u0627" },
            { "dsb", "\u0633\u0631\u0628\u06cc\u06cc \u062e\u0648\u0627\u0631\u06cc\u0646" },
            { "na", metaValue_NR },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "202", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0698\u06ce\u0631 \u0633\u06d5\u062d\u0631\u0627" },
            { "nb", "\u0646\u06d5\u0631\u0648\u06cc\u0698\u06cc\u06cc \u0628\u06c6\u06a9\u0645\u0627\u0644" },
            { "NC", "\u0646\u06cc\u0648\u0648\u06a9\u0627\u0644\u06ce\u062f\u06c6\u0646\u06cc\u0627" },
            { "nd", "\u0626\u0646\u062f\u06ce\u0628\u06ce\u0644\u06ce\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "NE", "\u0646\u06cc\u062c\u06d5\u0631" },
            { "ne", "\u0646\u06cc\u067e\u0627\u0644\u06cc" },
            { "NF", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0646\u06c6\u0631\u0641\u06c6\u06b5\u06a9" },
            { "NG", "\u0646\u06cc\u062c\u0631\u06cc\u0627" },
            { "ng", "\u0646\u062f\u06c6\u0646\u06af\u0627" },
            { "trv", "\u062a\u0627\u0631\u06c6\u06a9\u06c6" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0627" },
            { "NL", "\u06be\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "nl", "\u0647\u06c6\u06b5\u06d5\u0646\u062f\u06cc" },
            { "nn", "\u0646\u06d5\u0631\u0648\u06cc\u0698\u06cc\u06cc \u0646\u06cc\u0646\u06c6\u0631\u0633\u06a9" },
            { "NO", "\u0646\u06c6\u0631\u0648\u06cc\u0698" },
            { "no", "\u0646\u06c6\u0631\u0648\u06ce\u0698\u06cc" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", metaValue_NR },
            { "nr", "\u0626\u0646\u062f\u06ce\u0628\u06ce\u0644\u06ce\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "NU", "\u0646\u06cc\u0648\u0648\u0626\u06cc" },
            { "nv", "\u0646\u0627\u06a4\u0627\u062c\u06c6" },
            { "rof", "\u0695\u06c6\u0645\u0628\u06c6" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646" },
            { "kab", "\u06a9\u0628\u0627\u0626\u06cc\u0644\u06cc" },
            { "oc", "\u0626\u06c6\u06a9\u0633\u06cc\u062a\u0627\u0646\u06cc" },
            { "kaj", "\u06a9\u06cc\u062c\u0648\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "men", "\u0645\u06ce\u0646\u062f\u06ce" },
            { "mer", "\u0645\u06ce\u0631\u0648\u0648" },
            { "OM", "\u0639\u0648\u0645\u0627\u0646" },
            { "om", "\u0626\u06c6\u0631\u06c6\u0645\u06c6" },
            { "anp", "\u0626\u06d5\u0646\u06af\u06cc\u06a9\u0627" },
            { "or", metaValue_or },
            { "os", "\u0626\u06c6\u0633\u06ce\u062a\u06cc" },
            { "crs", "\u0641\u06d5\u0631\u06d5\u0646\u0633\u06cc\u06cc \u0633\u06cc\u0634\u06ce\u0644\u06cc" },
            { "kbd", "\u06a9\u0627\u0628\u0627\u0631\u062f\u06cc" },
            { "mfe", "\u0645\u06c6\u0631\u06cc\u0633\u06cc" },
            { "srn", "\u0633\u0631\u0627\u0646\u0627\u0646 \u062a\u06c6\u0646\u06af\u06c6" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "pa", "\u067e\u06d5\u0646\u062c\u0627\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0648\u0627\u0644\u0627" },
            { "en_GB", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "PE", "\u067e\u06ce\u0631\u0648\u0648" },
            { "PF", "\u067e\u06c6\u0644\u06cc\u0646\u06cc\u0633\u06cc\u0627\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u06ce\u06cc \u0646\u0648\u06ce" },
            { "PH", "\u0641\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "pl", "\u067e\u06c6\u06b5\u06d5\u0646\u062f\u06cc" },
            { "ewo", "\u0626\u06ce\u0648\u06c6\u0646\u062f\u06c6" },
            { "PM", "\u0633\u06d5\u0646 \u067e\u06cc\u06ce\u0631 \u0648 \u0645\u06cc\u06a9\u06ce\u0644\u06c6\u0646" },
            { "PN", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u067e\u06cc\u062a\u06a9\u06d5\u0631\u0646" },
            { "PR", "\u067e\u06c6\u0631\u062a\u06c6\u0695\u06cc\u06a9\u06c6" },
            { "PS", "\u0646\u0627\u0648\u0686\u06d5 \u0641\u06d5\u0644\u06d5\u0633\u062a\u06cc\u0646\u06cc\u06d5\u06a9\u0627\u0646" },
            { "ps", "\u067e\u06d5\u0634\u062a\u0648\u0648" },
            { "PT", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644" },
            { "pt", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644\u06cc" },
            { "PW", "\u067e\u0627\u0644\u0627\u0648" },
            { "nia", "\u0646\u06cc\u0627\u0633" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0627\u06cc" },
            { "tum", "\u062a\u0648\u0645\u0628\u0648\u0648\u06a9\u0627" },
            { "kcg", "\u062a\u06cc\u0627\u067e" },
            { "Hebr", metaValue_he },
            { "mgh", "\u0645\u0627\u062e\u0648\u0627\u0645\u06cc\u062a\u06c6" },
            { "QA", "\u0642\u06d5\u062a\u06d5\u0631" },
            { "Laoo", "\u0644\u0627\u0626\u06c6" },
            { "mgo", "\u0645\u06ce\u062a\u06d5" },
            { "ssy", "\u0633\u0627\u0647\u06c6" },
            { "niu", "\u0646\u06cc\u0626\u0648\u0648\u06cc\u06cc" },
            { "QO", "\u062f\u06d5\u0631\u06d5\u0648\u06d5\u06cc \u0626\u06c6\u0642\u06cc\u0627\u0646\u0648\u0648\u0633\u06cc\u0627" },
            { "lez", "\u0644\u06d5\u0632\u06af\u06cc" },
            { "qu", "\u06a9\u06ce\u0686\u0648\u0627" },
            { "brx", "\u0628\u06c6\u062f\u06c6" },
            { "tvl", metaValue_TV },
            { "kde", "\u0645\u0627\u06a9\u06c6\u0646\u062f\u06d5" },
            { "001", "\u062c\u06cc\u0647\u0627\u0646" },
            { "Ethi", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u06a9" },
            { "002", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "RE", "\u0695\u06cc\u06cc\u0648\u0648\u0646\u06cc\u06d5\u0646" },
            { "005", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "jbo", "\u0644\u06c6\u0698\u0628\u0627\u0646" },
            { "009", "\u0626\u06c6\u0642\u06cc\u0627\u0646\u0648\u0648\u0633\u06cc\u0627" },
            { "rm", "\u0695\u06c6\u0645\u0627\u0646\u0634" },
            { "rn", "\u0695\u0648\u0648\u0646\u062f\u06cc" },
            { "RO", "\u0695\u06c6\u0645\u0627\u0646\u06cc\u0627" },
            { "ro", "\u0695\u06c6\u0645\u0627\u0646\u06cc" },
            { "RS", "\u0633\u0631\u0628\u06cc\u0627" },
            { "RU", "\u0695\u0648\u0648\u0633\u06cc\u0627" },
            { "ru", "\u0695\u0648\u0648\u0633\u06cc" },
            { "RW", "\u0695\u0648\u0627\u0646\u062f\u0627" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u06a4\u06ce\u0631\u062f\u06cc\u0627\u0646\u06c6" },
            { "mic", "\u0645\u06cc\u06a9\u0645\u0627\u06a9" },
            { "suk", "\u0633\u0648\u0648\u06a9\u0648\u0648\u0645\u0627" },
            { "en_AU", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06c6\u0633\u062a\u0631\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "SA", "\u0639\u06d5\u0631\u06d5\u0628\u0633\u062a\u0627\u0646\u06cc \u0633\u06d5\u0639\u0648\u0648\u062f\u06cc" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u064a\u062a" },
            { "SB", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0633\u0644\u06ce\u0645\u0627\u0646" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u06a9" },
            { "011", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "SC", "\u0633\u06cc\u0634\u06ce\u0644" },
            { "sc", "\u0633\u0627\u0631\u062f\u06cc\u0646\u06cc" },
            { "SD", "\u0633\u0648\u0648\u062f\u0627\u0646" },
            { "sd", "\u0633\u064a\u0646\u062f\u06cc" },
            { "013", "\u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "SE", "\u0633\u0648\u06cc\u062f" },
            { "se", "\u0633\u0627\u0645\u06cc\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "014", "\u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "min", "\u0645\u06cc\u0646\u0627\u0646\u06a9\u0627\u0628\u0627\u0648" },
            { "015", "\u0628\u0627\u06a9\u0648\u0648\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "SG", "\u0633\u06cc\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "sg", "\u0633\u0627\u0646\u06af\u06c6" },
            { "SH", "\u0633\u06d5\u0646 \u0647\u06ce\u0644\u06ce\u0646\u0627" },
            { "017", "\u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "SI", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc\u0627" },
            { "si", "\u0633\u06cc\u0646\u0647\u0627\u0644\u06cc" },
            { "018", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "SJ", "\u0633\u06a4\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u06cc\u0627\u0646 \u0645\u0627\u06cc\u06d5\u0646" },
            { "019", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631 \u0648 \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "SK", "\u0633\u0644\u06c6\u06a4\u0627\u06a9\u06cc\u0627" },
            { "sk", "\u0633\u0644\u06c6\u06a4\u0627\u0643\u06cc" },
            { "SL", "\u0633\u06cc\u06d5\u0631\u0627\u0644\u06cc\u06c6\u0646" },
            { "sl", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u06c6" },
            { "sm", "\u0633\u0627\u0645\u06c6\u06cc\u06cc" },
            { "SN", "\u0633\u06ce\u0646\u06ce\u06af\u0627\u06b5" },
            { "sn", "\u0634\u06c6\u0646\u0627" },
            { "SO", "\u0633\u06c6\u0645\u0627\u0644\u06cc\u0627" },
            { "so", "\u0633\u06c6\u0645\u0627\u0644\u06cc" },
            { "arn", "\u0645\u0627\u067e\u0648\u0648\u0686\u06d5" },
            { "sq", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc" },
            { "arp", "\u0626\u0627\u0631\u0627\u067e\u0627\u0647\u06c6" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "sr", "\u0633\u0631\u0628\u06cc" },
            { "SS", "\u0633\u0648\u0648\u062f\u0627\u0646\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "ST", "\u0633\u0627\u0648\u062a\u06c6\u0645\u06ce \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e\u06cc" },
            { "st", "\u0633\u06c6\u062a\u06c6\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "su", "\u0633\u0648\u0646\u062f\u0627\u0646\u06cc" },
            { "SV", "\u0626\u06ce\u0644\u0633\u0627\u0644\u06a4\u0627\u062f\u06c6\u0631" },
            { "sv", "\u0633\u0648\u06cc\u062f\u06cc" },
            { "sw", "\u0633\u0648\u0627\u0647\u06cc\u0644\u06cc" },
            { "SX", "\u0633\u06cc\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0648\u0631\u06cc\u0627" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "ibb", "\u0626\u06cc\u0628\u06cc\u0628\u06c6" },
            { "iba", "\u0626\u06cc\u0628\u0627\u0646" },
            { "ta", metaValue_ta },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u06ce\u0646 \u062f\u0627 \u06a9\u0648\u0648\u0646\u0627" },
            { "asa", "\u0626\u0627\u0633\u0648\u0648" },
            { "021", "\u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "142", "\u0626\u0627\u0633\u06cc\u0627" },
            { "TC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062a\u0648\u0631\u06a9\u0633 \u0648 \u06a9\u0627\u06cc\u06a9\u06c6\u0633" },
            { "yav", "\u06cc\u0627\u0646\u06af\u0628\u06ce\u0646" },
            { "143", "\u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "TD", "\u0686\u0627\u062f" },
            { "te", metaValue_te },
            { "145", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "TF", "\u0647\u06d5\u0631\u06ce\u0645\u06d5 \u0628\u0627\u0634\u0648\u0648\u0631\u06cc\u06d5\u06a9\u0627\u0646\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "TG", "\u062a\u06c6\u06af\u06c6" },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", metaValue_th },
            { "TH", "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f" },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627" },
            { "bug", "\u0628\u0648\u0648\u06af\u06cc" },
            { "kfo", "\u06a9\u06c6\u0631\u06c6" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646" },
            { "en_CA", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u06a9\u06d5\u0646\u06d5\u062f\u0627\u06cc\u06cc" },
            { "029", "\u06a9\u0627\u0631\u06cc\u0628\u06cc" },
            { "TK", "\u062a\u06c6\u06a9\u06ce\u0644\u0627\u0648" },
            { "tk", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u06cc" },
            { "TL", "\u062a\u06cc\u0645\u06c6\u0631\u06cc \u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a" },
            { "ybb", "\u06cc\u06ce\u0645\u0628\u0627" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0648\u0646\u0633" },
            { "tn", "\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "TO", "\u062a\u06c6\u0646\u06af\u0627" },
            { "to", "\u062a\u06c6\u0646\u06af\u0627\u0646" },
            { "dyo", "\u062c\u06c6\u0644\u0627\u0641\u06c6\u0646\u06cc" },
            { "TR", "\u062a\u0648\u0631\u06a9\u06cc\u0627" },
            { "tr", "\u062a\u0648\u0631\u06a9\u06cc" },
            { "ts", "\u062a\u0633\u06c6\u0646\u06af\u0627" },
            { "swb", "\u06a9\u06c6\u0645\u06c6\u0631\u06cc" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u06c6\u0628\u0627\u06af\u0648" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u06cc" },
            { "TV", metaValue_TV },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "ast", "\u0626\u0627\u0633\u062a\u06c6\u0631\u06cc" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u06cc" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "nmg", "\u06a9\u0648\u0627\u0633\u06cc\u06c6" },
            { "Zzzz", "\u062e\u06d5\u062a\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "150", "\u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "UA", "\u0626\u06c6\u06a9\u0631\u0627\u0646\u06cc\u0627" },
            { "rup", "\u0626\u0627\u0631\u0645\u06c6\u0645\u0627\u0646\u06cc" },
            { "030", "\u0695\u06c6\u0698\u0647\u06d5\u06b5\u0627\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "151", "\u0695\u06c6\u0698\u0647\u06d5\u06b5\u0627\u062a\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "154", "\u0628\u0627\u06a9\u0648\u0648\u0631\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "dzg", "\u062f\u0627\u0632\u0627" },
            { "tyv", "\u062a\u0648\u0648\u06a4\u06cc\u0646\u06cc" },
            { "sw_CD", "\u0633\u0648\u0627\u0647\u06cc\u0644\u06cc\u06cc \u06a9\u06c6\u0646\u06af\u06c6" },
            { "034", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "155", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "035", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "UG", "\u0626\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "ug", "\u0626\u06c6\u06cc\u062e\u06c6\u0631\u06cc" },
            { "Kore", "\u06a9\u06c6\u0631\u06cc" },
            { "Zyyy", "\u0628\u0627\u0648" },
            { "039", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "uk", "\u0626\u06c6\u0643\u0631\u0627\u06cc\u0646\u06cc" },
            { "Sinh", "\u0633\u06cc\u0646\u06be\u0627\u0644\u0627" },
            { "UM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062f\u06d5\u0631\u06d5\u0648\u06d5\u06cc \u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627" },
            { "UN", "\u0646\u06d5\u062a\u06d5\u0648\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5\u06a9\u0627\u0646" },
            { "ur", "\u0626\u06c6\u0631\u062f\u0648\u0648" },
            { "US", "\u0648\u06cc\u0644\u0627\u06cc\u06d5\u062a\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5\u06a9\u0627\u0646" },
            { "haw", "\u0647\u0627\u0648\u0627\u06cc\u06cc" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06cc\u06a9" },
            { "UY", "\u0626\u0648\u0631\u0648\u06af\u0648\u0627\u06cc" },
            { "prg", "\u067e\u0695\u0648\u0648\u0633\u06cc" },
            { "UZ", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u0633\u062a\u0627\u0646" },
            { "uz", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u06cc" },
            { "kha", "\u06a9\u0647\u0627\u0633\u06cc" },
            { "tzm", "\u0626\u06d5\u0645\u0627\u0632\u06cc\u063a\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "nnh", "\u0646\u06af\u06cc\u0645\u0628\u0648\u0648\u0646" },
            { "VA", "\u06a4\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "VC", "\u0633\u06d5\u06cc\u0646\u062a \u06a4\u06cc\u0646\u0633\u06d5\u0646\u062a \u0648 \u06af\u0631\u06cc\u0646\u0627\u062f\u06cc\u0646\u0632" },
            { "VE", "\u06a4\u06d5\u0646\u0632\u0648\u06ce\u0644\u0627" },
            { "ve", "\u06a4\u06ce\u0646\u062f\u0627" },
            { "VG", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a4\u06cc\u0631\u062c\u0646\u06cc \u0628\u06d5\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "VI", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a4\u06cc\u0631\u062c\u0646\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627" },
            { "vi", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645\u06cc" },
            { "khq", "\u06a9\u06c6\u06cc\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "VN", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645" },
            { "vo", "\u06a4\u06c6\u0644\u0627\u067e\u0648\u0648\u06a9" },
            { "quc", "\u06a9\u06cc\u0686\u06d5\u06cc\u06cc" },
            { "VU", "\u06a4\u0627\u0646\u0648\u0648\u0627\u062a\u0648\u0648" },
            { "gaa", "\u06af\u0627\u06cc\u06cc" },
            { "nog", "\u0646\u06c6\u06af\u0627\u06cc" },
            { "rwk", "\u0695\u0648\u0627" },
            { "wa", "\u0648\u0627\u0644\u0648\u0648\u0646" },
            { "syr", "\u0633\u0631\u06cc\u0627\u0646\u06cc" },
            { "053", "\u0626\u06c6\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "054", "\u0645\u06cc\u0644\u0627\u0646\u06ce\u0632\u06cc\u0627" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "Grek", metaValue_el },
            { "057", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u0645\u0627\u06cc\u06a9\u0631\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "jgo", "\u0646\u06af\u06c6\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u06a9\u06c6\u062a\u0627" },
            { "wo", "\u0648\u06c6\u0644\u06c6\u0641" },
            { "wae", "\u0648\u0627\u0644\u0633\u06ce\u0631" },
            { "zgh", "\u0626\u06d5\u0645\u0627\u0632\u06cc\u063a\u06cc\u06cc \u0645\u06d5\u063a\u0631\u06cc\u0628" },
            { "ar_001", "\u0639\u06d5\u0631\u06d5\u0628\u06cc\u06cc \u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "Mong", metaValue_mn },
            { "wal", "\u0648\u06c6\u0644\u0627\u06cc\u062a\u0627" },
            { "mni", "\u0645\u0627\u0646\u06cc\u067e\u0648\u0648\u0631\u06cc" },
            { "war", "\u0648\u0627\u0631\u0627\u06cc" },
            { "awa", "\u0626\u0627\u0648\u0627\u062f\u0647\u06cc" },
            { "Latn", metaValue_la },
            { "061", "\u067e\u06c6\u0644\u06cc\u0646\u06cc\u0632\u06cc\u0627" },
            { "xh", "\u0633\u0633\u0648\u0633\u0627" },
            { "XK", "\u06a9\u06c6\u0633\u06c6\u06a4\u06c6" },
            { "Gujr", "\u06af\u0648\u062c\u06d5\u0631\u0627\u062a\u06cc" },
            { "Zxxx", "\u0646\u06d5\u0646\u0648\u0648\u0633\u0631\u0627\u0648" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "moh", "\u0645\u06c6\u0647\u0627\u0648\u06a9" },
            { "kkj", "\u06a9\u0627\u06a9\u06c6" },
            { "YE", "\u06cc\u06d5\u0645\u06d5\u0646" },
            { "nqo", "\u0646\u06a9\u06c6" },
            { "yi", "\u06cc\u06cc\u062f\u06cc\u0634" },
            { "mos", "\u0645\u06c6\u0633\u06cc" },
            { "yo", "\u06cc\u06c6\u0631\u0648\u0648\u0628\u0627" },
            { "YT", "\u0645\u0627\u06cc\u06c6\u062a" },
            { "vai", "\u06a4\u0627\u06cc\u06cc" },
            { "ZA", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "kln", "\u06a9\u0627\u0644\u06ce\u0646\u062c\u06cc\u0646" },
            { "Deva", "\u062f\u06d5\u06a4\u06d5\u0646\u0627\u06af\u06d5\u0631\u06cc" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "Hira", "\u06be\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "Bopo", "\u0628\u06c6\u067e\u06c6\u0645\u06c6\u0641\u06c6" },
            { "zu", "\u0632\u0648\u0648\u0644\u0648\u0648" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "ZZ", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "Geor", "\u06af\u0648\u0631\u062c\u06cc" },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0648\u0646\u062f\u0648\u0648" },
            { "nso", "\u0633\u06c6\u062a\u06c6\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "loz", "\u0644\u06c6\u0632\u06cc" },
            { "gez", "\u06af\u06cc\u0632\u06cc" },
            { "ebu", "\u0626\u06ce\u0645\u0628\u0648\u0648" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u06ce" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc (\u0686\u06cc\u0646\u06cc\u06cc \u0626\u0627\u0633\u0627\u0646\u06a9\u0631\u0627\u0648)" },
            { "kok", "\u06a9\u06c6\u0646\u06a9\u0627\u0646\u06cc" },
            { "hil", "\u0647\u06cc\u0644\u06cc\u06af\u0627\u06cc\u0646\u06c6\u0646" },
            { "nus", "\u0646\u0648\u06ce\u0631" },
            { "dak", "\u062f\u0627\u06a9\u06c6\u062a\u0627\u06cc\u06cc" },
            { "dar", "\u062f\u0627\u0631\u06af\u06cc\u0646\u06cc" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "lrc", "\u0644\u0648\u0695\u06cc\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "zh_Hant", "\u0686\u06cc\u0646\u06cc (\u0686\u06cc\u0646\u06cc\u06cc \u062f\u06ce\u0631\u06cc\u0646)" },
            { "kpe", "\u06a9\u067e\u06ce\u0644\u06ce" },
            { "ilo", "\u0626\u06cc\u0644\u06c6\u06a9\u06c6" },
            { "mua", "\u0645\u0648\u0646\u062f\u0627\u0646\u06af" },
            { "udm", "\u0626\u0648\u0648\u062f\u0645\u0648\u0648\u0631\u062a" },
            { "Khmr", metaValue_km },
            { "mul", "\u0686\u06d5\u0646\u062f \u0632\u0645\u0627\u0646" },
            { "mus", "\u06a9\u0631\u06cc\u06a9" },
            { "gil", "\u06af\u06cc\u0644\u0628\u06ce\u0631\u062a\u06cc" },
            { "sad", "\u0633\u0627\u0646\u062f\u0627\u0648\u06ce" },
            { "sah", "\u0633\u0627\u062e\u0627" },
            { "krc", "\u06a9\u0627\u0631\u0627\u0686\u0627\u06cc \u0628\u0627\u0644\u06a9\u0627\u0631" },
            { "inh", "\u0626\u06cc\u0646\u06af\u0648\u0648\u0634" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0648\u0631\u0648\u0648" },
            { "krl", "\u06a9\u0627\u0631\u06ce\u0644\u06cc" },
            { "sat", "\u0633\u0627\u0646\u062a\u0627\u0644\u06cc" },
            { "efi", "\u0626\u06ce\u0641\u06cc\u06a9" },
            { "kru", "\u06a9\u0648\u0648\u0631\u0648\u0648\u062e" },
            { "sba", "\u0646\u06af\u0627\u0645\u0628\u0627\u06cc" },
            { "Guru", "\u06af\u0648\u0631\u0645\u0648\u06a9\u06be\u06cc" },
            { "lua", "\u0644\u0648\u0648\u0628\u0627 \u0644\u0648\u0648\u0644\u0648\u0648\u0627" },
            { "ksb", "\u0634\u0627\u0645\u0627\u0628\u0627\u0644\u0627" },
            { "Telu", metaValue_te },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627" },
        };
        return data;
    }
}
