"""Dictionary object to store Protocol information."""

# pylint: disable=too-many-lines
from typing import Any, Dict

PROTOCOLS: Dict[str, Any] = {
    "tcpmux": {"port_number": 1, "protocols": ["tcp", "udp"]},
    "rje": {"port_number": 5, "protocols": ["tcp", "udp"]},
    "echo": {"port_number": 7, "protocols": ["tcp", "udp"]},
    "discard": {"port_number": 9, "protocols": ["tcp", "udp", "sctp", "dccp"]},
    "systat": {"port_number": 11, "protocols": ["tcp", "udp"]},
    "daytime": {"port_number": 13, "protocols": ["tcp", "udp"]},
    "qotd": {"port_number": 17, "protocols": ["tcp", "udp"]},
    "msp": {"port_number": 18, "protocols": ["tcp", "udp"]},
    "chargen": {"port_number": 19, "protocols": ["tcp", "udp"]},
    "ftp-data": {"port_number": 20, "protocols": ["tcp", "udp", "sctp"]},
    "ftp": {"port_number": 21, "protocols": ["tcp", "udp", "sctp"]},
    "ssh": {"port_number": 22, "protocols": ["tcp", "udp", "sctp"]},
    "telnet": {"port_number": 23, "protocols": ["tcp", "udp"]},
    "smtp": {"port_number": 25, "protocols": ["tcp", "udp"]},
    "nsw-fe": {"port_number": 27, "protocols": ["tcp", "udp"]},
    "msg-icp": {"port_number": 29, "protocols": ["tcp", "udp"]},
    "msg-auth": {"port_number": 31, "protocols": ["tcp", "udp"]},
    "dsp": {"port_number": 33, "protocols": ["tcp", "udp"]},
    "time": {"port_number": 37, "protocols": ["tcp", "udp"]},
    "rap": {"port_number": 38, "protocols": ["tcp", "udp"]},
    "rlp": {"port_number": 39, "protocols": ["tcp", "udp"]},
    "graphics": {"port_number": 41, "protocols": ["tcp", "udp"]},
    "name": {"port_number": 42, "protocols": ["tcp", "udp"]},
    "nameserver": {"port_number": 42, "protocols": ["tcp", "udp"]},
    "nicname": {"port_number": 43, "protocols": ["tcp", "udp"]},
    "mpm-flags": {"port_number": 44, "protocols": ["tcp", "udp"]},
    "mpm": {"port_number": 45, "protocols": ["tcp", "udp"]},
    "mpm-snd": {"port_number": 46, "protocols": ["tcp", "udp"]},
    "auditd": {"port_number": 48, "protocols": ["tcp", "udp"]},
    "tacacs": {"port_number": 49, "protocols": ["tcp", "udp"]},
    "re-mail-ck": {"port_number": 50, "protocols": ["tcp", "udp"]},
    "xns-time": {"port_number": 52, "protocols": ["tcp", "udp"]},
    "domain": {"port_number": 53, "protocols": ["tcp", "udp"]},
    "xns-ch": {"port_number": 54, "protocols": ["tcp", "udp"]},
    "isi-gl": {"port_number": 55, "protocols": ["tcp", "udp"]},
    "xns-auth": {"port_number": 56, "protocols": ["tcp", "udp"]},
    "xns-mail": {"port_number": 58, "protocols": ["tcp", "udp"]},
    "acas": {"port_number": 62, "protocols": ["tcp", "udp"]},
    "whoispp": {"port_number": 63, "protocols": ["tcp", "udp"]},
    "whois++": {"port_number": 63, "protocols": ["tcp", "udp"]},
    "covia": {"port_number": 64, "protocols": ["tcp", "udp"]},
    "tacacs-ds": {"port_number": 65, "protocols": ["tcp", "udp"]},
    "sql-net": {"port_number": 66, "protocols": ["tcp", "udp"]},
    "sql*net": {"port_number": 66, "protocols": ["tcp", "udp"]},
    "bootps": {"port_number": 67, "protocols": ["tcp", "udp"]},
    "bootpc": {"port_number": 68, "protocols": ["tcp", "udp"]},
    "tftp": {"port_number": 69, "protocols": ["tcp", "udp"]},
    "gopher": {"port_number": 70, "protocols": ["tcp", "udp"]},
    "netrjs-1": {"port_number": 71, "protocols": ["tcp", "udp"]},
    "netrjs-2": {"port_number": 72, "protocols": ["tcp", "udp"]},
    "netrjs-3": {"port_number": 73, "protocols": ["tcp", "udp"]},
    "netrjs-4": {"port_number": 74, "protocols": ["tcp", "udp"]},
    "deos": {"port_number": 76, "protocols": ["tcp", "udp"]},
    "vettcp": {"port_number": 78, "protocols": ["tcp", "udp"]},
    "finger": {"port_number": 79, "protocols": ["tcp", "udp"]},
    "http": {"port_number": 80, "protocols": ["tcp", "udp", "sctp"]},
    "www": {"port_number": 80, "protocols": ["tcp", "udp"]},
    "www-http": {"port_number": 80, "protocols": ["tcp", "udp"]},
    "xfer": {"port_number": 82, "protocols": ["tcp", "udp"]},
    "mit-ml-dev": {"port_number": 83, "protocols": ["tcp", "udp"]},
    "ctf": {"port_number": 84, "protocols": ["tcp", "udp"]},
    "mit-ml-dev-secondary": {"port_number": 85, "protocols": ["tcp", "udp"]},
    "mfcobol": {"port_number": 86, "protocols": ["tcp", "udp"]},
    "kerberos": {"port_number": 88, "protocols": ["tcp", "udp"]},
    "su-mit-tg": {"port_number": 89, "protocols": ["tcp", "udp"]},
    "dnsix": {"port_number": 90, "protocols": ["tcp", "udp"]},
    "mit-dov": {"port_number": 91, "protocols": ["tcp", "udp"]},
    "npp": {"port_number": 92, "protocols": ["tcp", "udp"]},
    "dcp": {"port_number": 93, "protocols": ["tcp", "udp"]},
    "objcall": {"port_number": 94, "protocols": ["tcp", "udp"]},
    "supdup": {"port_number": 95, "protocols": ["tcp", "udp"]},
    "dixie": {"port_number": 96, "protocols": ["tcp", "udp"]},
    "swift-rvf": {"port_number": 97, "protocols": ["tcp", "udp"]},
    "tacnews": {"port_number": 98, "protocols": ["tcp", "udp"]},
    "metagram": {"port_number": 99, "protocols": ["tcp", "udp"]},
    "hostname": {"port_number": 101, "protocols": ["tcp", "udp"]},
    "iso-tsap": {"port_number": 102, "protocols": ["tcp", "udp"]},
    "gppitnp": {"port_number": 103, "protocols": ["tcp", "udp"]},
    "acr-nema": {"port_number": 104, "protocols": ["tcp", "udp"]},
    "cso": {"port_number": 105, "protocols": ["tcp", "udp"]},
    "csnet-ns": {"port_number": 105, "protocols": ["tcp", "udp"]},
    "3com-tsmux": {"port_number": 106, "protocols": ["tcp", "udp"]},
    "rtelnet": {"port_number": 107, "protocols": ["tcp", "udp"]},
    "snagas": {"port_number": 108, "protocols": ["tcp", "udp"]},
    "pop2": {"port_number": 109, "protocols": ["tcp", "udp"]},
    "pop3": {"port_number": 110, "protocols": ["tcp", "udp"]},
    "sunrpc": {"port_number": 111, "protocols": ["tcp", "udp"]},
    "mcidas": {"port_number": 112, "protocols": ["tcp", "udp"]},
    "ident": {"port_number": 113, "protocols": ["tcp"]},
    "auth": {"port_number": 113, "protocols": ["tcp", "udp"]},
    "sftp": {"port_number": 115, "protocols": ["tcp", "udp"]},
    "ansanotify": {"port_number": 116, "protocols": ["tcp", "udp"]},
    "uucp-path": {"port_number": 117, "protocols": ["tcp", "udp"]},
    "sqlserv": {"port_number": 118, "protocols": ["tcp", "udp"]},
    "nntp": {"port_number": 119, "protocols": ["tcp", "udp"]},
    "cfdptkt": {"port_number": 120, "protocols": ["tcp", "udp"]},
    "erpc": {"port_number": 121, "protocols": ["tcp", "udp"]},
    "smakynet": {"port_number": 122, "protocols": ["tcp", "udp"]},
    "ntp": {"port_number": 123, "protocols": ["tcp", "udp"]},
    "ansatrader": {"port_number": 124, "protocols": ["tcp", "udp"]},
    "locus-map": {"port_number": 125, "protocols": ["tcp", "udp"]},
    "nxedit": {"port_number": 126, "protocols": ["tcp", "udp"]},
    "locus-con": {"port_number": 127, "protocols": ["tcp", "udp"]},
    "gss-xlicen": {"port_number": 128, "protocols": ["tcp", "udp"]},
    "pwdgen": {"port_number": 129, "protocols": ["tcp", "udp"]},
    "cisco-fna": {"port_number": 130, "protocols": ["tcp", "udp"]},
    "cisco-tna": {"port_number": 131, "protocols": ["tcp", "udp"]},
    "cisco-sys": {"port_number": 132, "protocols": ["tcp", "udp"]},
    "statsrv": {"port_number": 133, "protocols": ["tcp", "udp"]},
    "ingres-net": {"port_number": 134, "protocols": ["tcp", "udp"]},
    "epmap": {"port_number": 135, "protocols": ["tcp", "udp"]},
    "profile": {"port_number": 136, "protocols": ["tcp", "udp"]},
    "netbios-ns": {"port_number": 137, "protocols": ["tcp", "udp"]},
    "netbios-dgm": {"port_number": 138, "protocols": ["tcp", "udp"]},
    "netbios-ssn": {"port_number": 139, "protocols": ["tcp", "udp"]},
    "emfis-data": {"port_number": 140, "protocols": ["tcp", "udp"]},
    "emfis-cntl": {"port_number": 141, "protocols": ["tcp", "udp"]},
    "bl-idm": {"port_number": 142, "protocols": ["tcp", "udp"]},
    "imap": {"port_number": 143, "protocols": ["tcp"]},
    "uma": {"port_number": 144, "protocols": ["tcp", "udp"]},
    "uaac": {"port_number": 145, "protocols": ["tcp", "udp"]},
    "iso-tp0": {"port_number": 146, "protocols": ["tcp", "udp"]},
    "iso-ip": {"port_number": 147, "protocols": ["tcp", "udp"]},
    "jargon": {"port_number": 148, "protocols": ["tcp", "udp"]},
    "aed-512": {"port_number": 149, "protocols": ["tcp", "udp"]},
    "sql-net-secondary": {"port_number": 150, "protocols": ["tcp", "udp"]},
    "hems": {"port_number": 151, "protocols": ["tcp", "udp"]},
    "bftp": {"port_number": 152, "protocols": ["tcp", "udp"]},
    "sgmp": {"port_number": 153, "protocols": ["tcp", "udp"]},
    "netsc-prod": {"port_number": 154, "protocols": ["tcp", "udp"]},
    "netsc-dev": {"port_number": 155, "protocols": ["tcp", "udp"]},
    "sqlsrv": {"port_number": 156, "protocols": ["tcp", "udp"]},
    "knet-cmp": {"port_number": 157, "protocols": ["tcp", "udp"]},
    "pcmail-srv": {"port_number": 158, "protocols": ["tcp", "udp"]},
    "nss-routing": {"port_number": 159, "protocols": ["tcp", "udp"]},
    "sgmp-traps": {"port_number": 160, "protocols": ["tcp", "udp"]},
    "snmp": {"port_number": 161, "protocols": ["tcp", "udp"]},
    "snmptrap": {"port_number": 162, "protocols": ["tcp", "udp"]},
    "cmip-man": {"port_number": 163, "protocols": ["tcp", "udp"]},
    "cmip-agent": {"port_number": 164, "protocols": ["tcp", "udp"]},
    "xns-courier": {"port_number": 165, "protocols": ["tcp", "udp"]},
    "s-net": {"port_number": 166, "protocols": ["tcp", "udp"]},
    "namp": {"port_number": 167, "protocols": ["tcp", "udp"]},
    "rsvd": {"port_number": 168, "protocols": ["tcp", "udp"]},
    "send": {"port_number": 169, "protocols": ["tcp", "udp"]},
    "print-srv": {"port_number": 170, "protocols": ["tcp", "udp"]},
    "multiplex": {"port_number": 171, "protocols": ["tcp", "udp"]},
    "cl-1": {"port_number": 172, "protocols": ["tcp", "udp"]},
    "cl/1": {"port_number": 172, "protocols": ["tcp", "udp"]},
    "xyplex-mux": {"port_number": 173, "protocols": ["tcp", "udp"]},
    "mailq": {"port_number": 174, "protocols": ["tcp", "udp"]},
    "vmnet": {"port_number": 175, "protocols": ["tcp", "udp"]},
    "genrad-mux": {"port_number": 176, "protocols": ["tcp", "udp"]},
    "xdmcp": {"port_number": 177, "protocols": ["tcp", "udp"]},
    "nextstep": {"port_number": 178, "protocols": ["tcp", "udp"]},
    "bgp": {"port_number": 179, "protocols": ["tcp", "udp", "sctp"]},
    "ris": {"port_number": 180, "protocols": ["tcp", "udp"]},
    "unify": {"port_number": 181, "protocols": ["tcp", "udp"]},
    "audit": {"port_number": 182, "protocols": ["tcp", "udp"]},
    "ocbinder": {"port_number": 183, "protocols": ["tcp", "udp"]},
    "ocserver": {"port_number": 184, "protocols": ["tcp", "udp"]},
    "remote-kis": {"port_number": 185, "protocols": ["tcp", "udp"]},
    "kis": {"port_number": 186, "protocols": ["tcp", "udp"]},
    "aci": {"port_number": 187, "protocols": ["tcp", "udp"]},
    "mumps": {"port_number": 188, "protocols": ["tcp", "udp"]},
    "qft": {"port_number": 189, "protocols": ["tcp", "udp"]},
    "gacp": {"port_number": 190, "protocols": ["tcp", "udp"]},
    "prospero": {"port_number": 191, "protocols": ["tcp", "udp"]},
    "osu-nms": {"port_number": 192, "protocols": ["tcp", "udp"]},
    "srmp": {"port_number": 193, "protocols": ["tcp", "udp"]},
    "irc": {"port_number": 194, "protocols": ["tcp", "udp"]},
    "dn6-nlm-aud": {"port_number": 195, "protocols": ["tcp", "udp"]},
    "dn6-smm-red": {"port_number": 196, "protocols": ["tcp", "udp"]},
    "dls": {"port_number": 197, "protocols": ["tcp", "udp"]},
    "dls-mon": {"port_number": 198, "protocols": ["tcp", "udp"]},
    "smux": {"port_number": 199, "protocols": ["tcp", "udp"]},
    "src": {"port_number": 200, "protocols": ["tcp", "udp"]},
    "at-rtmp": {"port_number": 201, "protocols": ["tcp", "udp"]},
    "at-nbp": {"port_number": 202, "protocols": ["tcp", "udp"]},
    "at-3": {"port_number": 203, "protocols": ["tcp", "udp"]},
    "at-echo": {"port_number": 204, "protocols": ["tcp", "udp"]},
    "at-5": {"port_number": 205, "protocols": ["tcp", "udp"]},
    "at-zis": {"port_number": 206, "protocols": ["tcp", "udp"]},
    "at-7": {"port_number": 207, "protocols": ["tcp", "udp"]},
    "at-8": {"port_number": 208, "protocols": ["tcp", "udp"]},
    "qmtp": {"port_number": 209, "protocols": ["tcp", "udp"]},
    "z39-50": {"port_number": 210, "protocols": ["tcp", "udp"]},
    "z39.50": {"port_number": 210, "protocols": ["tcp", "udp"]},
    "914c-g": {"port_number": 211, "protocols": ["tcp", "udp"]},
    "914c/g": {"port_number": 211, "protocols": ["tcp", "udp"]},
    "anet": {"port_number": 212, "protocols": ["tcp", "udp"]},
    "ipx": {"port_number": 213, "protocols": ["tcp", "udp"]},
    "vmpwscs": {"port_number": 214, "protocols": ["tcp", "udp"]},
    "softpc": {"port_number": 215, "protocols": ["tcp", "udp"]},
    "CAIlic": {"port_number": 216, "protocols": ["tcp", "udp"]},
    "dbase": {"port_number": 217, "protocols": ["tcp", "udp"]},
    "mpp": {"port_number": 218, "protocols": ["tcp", "udp"]},
    "uarps": {"port_number": 219, "protocols": ["tcp", "udp"]},
    "imap3": {"port_number": 220, "protocols": ["tcp", "udp"]},
    "fln-spx": {"port_number": 221, "protocols": ["tcp", "udp"]},
    "rsh-spx": {"port_number": 222, "protocols": ["tcp", "udp"]},
    "cdc": {"port_number": 223, "protocols": ["tcp", "udp"]},
    "masqdialer": {"port_number": 224, "protocols": ["tcp", "udp"]},
    "direct": {"port_number": 242, "protocols": ["tcp", "udp"]},
    "sur-meas": {"port_number": 243, "protocols": ["tcp", "udp"]},
    "inbusiness": {"port_number": 244, "protocols": ["tcp", "udp"]},
    "link": {"port_number": 245, "protocols": ["tcp", "udp"]},
    "dsp3270": {"port_number": 246, "protocols": ["tcp", "udp"]},
    "subntbcst-tftp": {"port_number": 247, "protocols": ["tcp", "udp"]},
    "subntbcst_tftp": {"port_number": 247, "protocols": ["tcp", "udp"]},
    "bhfhs": {"port_number": 248, "protocols": ["tcp", "udp"]},
    "rap-secondary": {"port_number": 256, "protocols": ["tcp", "udp"]},
    "set": {"port_number": 257, "protocols": ["tcp", "udp"]},
    "esro-gen": {"port_number": 259, "protocols": ["tcp", "udp"]},
    "openport": {"port_number": 260, "protocols": ["tcp", "udp"]},
    "nsiiops": {"port_number": 261, "protocols": ["tcp", "udp"]},
    "arcisdms": {"port_number": 262, "protocols": ["tcp", "udp"]},
    "hdap": {"port_number": 263, "protocols": ["tcp", "udp"]},
    "bgmp": {"port_number": 264, "protocols": ["tcp", "udp"]},
    "x-bone-ctl": {"port_number": 265, "protocols": ["tcp", "udp"]},
    "sst": {"port_number": 266, "protocols": ["tcp", "udp"]},
    "td-service": {"port_number": 267, "protocols": ["tcp", "udp"]},
    "td-replica": {"port_number": 268, "protocols": ["tcp", "udp"]},
    "manet": {"port_number": 269, "protocols": ["tcp", "udp"]},
    "gist": {"port_number": 270, "protocols": ["udp"]},
    "pt-tls": {"port_number": 271, "protocols": ["tcp"]},
    "http-mgmt": {"port_number": 280, "protocols": ["tcp", "udp"]},
    "personal-link": {"port_number": 281, "protocols": ["tcp", "udp"]},
    "cableport-ax": {"port_number": 282, "protocols": ["tcp", "udp"]},
    "rescap": {"port_number": 283, "protocols": ["tcp", "udp"]},
    "corerjd": {"port_number": 284, "protocols": ["tcp", "udp"]},
    "fxp": {"port_number": 286, "protocols": ["tcp", "udp"]},
    "k-block": {"port_number": 287, "protocols": ["tcp", "udp"]},
    "tacacss": {"port_number": 300, "protocols": ["tcp"]},
    "novastorbakcup": {"port_number": 308, "protocols": ["tcp", "udp"]},
    "entrusttime": {"port_number": 309, "protocols": ["tcp", "udp"]},
    "bhmds": {"port_number": 310, "protocols": ["tcp", "udp"]},
    "asip-webadmin": {"port_number": 311, "protocols": ["tcp", "udp"]},
    "vslmp": {"port_number": 312, "protocols": ["tcp", "udp"]},
    "magenta-logic": {"port_number": 313, "protocols": ["tcp", "udp"]},
    "opalis-robot": {"port_number": 314, "protocols": ["tcp", "udp"]},
    "dpsi": {"port_number": 315, "protocols": ["tcp", "udp"]},
    "decauth": {"port_number": 316, "protocols": ["tcp", "udp"]},
    "zannet": {"port_number": 317, "protocols": ["tcp", "udp"]},
    "pkix-timestamp": {"port_number": 318, "protocols": ["tcp", "udp"]},
    "ptp-event": {"port_number": 319, "protocols": ["tcp", "udp"]},
    "ptp-general": {"port_number": 320, "protocols": ["tcp", "udp"]},
    "pip": {"port_number": 321, "protocols": ["tcp", "udp"]},
    "rtsps": {"port_number": 322, "protocols": ["tcp", "udp"]},
    "rpki-rtr": {"port_number": 323, "protocols": ["tcp"]},
    "rpki-rtr-tls": {"port_number": 324, "protocols": ["tcp"]},
    "texar": {"port_number": 333, "protocols": ["tcp", "udp"]},
    "pdap": {"port_number": 344, "protocols": ["tcp", "udp"]},
    "pawserv": {"port_number": 345, "protocols": ["tcp", "udp"]},
    "zserv": {"port_number": 346, "protocols": ["tcp", "udp"]},
    "fatserv": {"port_number": 347, "protocols": ["tcp", "udp"]},
    "csi-sgwp": {"port_number": 348, "protocols": ["tcp", "udp"]},
    "mftp": {"port_number": 349, "protocols": ["tcp", "udp"]},
    "matip-type-a": {"port_number": 350, "protocols": ["tcp", "udp"]},
    "matip-type-b": {"port_number": 351, "protocols": ["tcp", "udp"]},
    "bhoetty": {"port_number": 351, "protocols": ["tcp", "udp"]},
    "dtag-ste-sb": {"port_number": 352, "protocols": ["tcp", "udp"]},
    "bhoedap4": {"port_number": 352, "protocols": ["tcp", "udp"]},
    "ndsauth": {"port_number": 353, "protocols": ["tcp", "udp"]},
    "bh611": {"port_number": 354, "protocols": ["tcp", "udp"]},
    "datex-asn": {"port_number": 355, "protocols": ["tcp", "udp"]},
    "cloanto-net-1": {"port_number": 356, "protocols": ["tcp", "udp"]},
    "bhevent": {"port_number": 357, "protocols": ["tcp", "udp"]},
    "shrinkwrap": {"port_number": 358, "protocols": ["tcp", "udp"]},
    "scoi2odialog": {"port_number": 360, "protocols": ["tcp", "udp"]},
    "semantix": {"port_number": 361, "protocols": ["tcp", "udp"]},
    "srssend": {"port_number": 362, "protocols": ["tcp", "udp"]},
    "rsvp-tunnel": {"port_number": 363, "protocols": ["tcp", "udp"]},
    "rsvp_tunnel": {"port_number": 363, "protocols": ["tcp", "udp"]},
    "aurora-cmgr": {"port_number": 364, "protocols": ["tcp", "udp"]},
    "dtk": {"port_number": 365, "protocols": ["tcp", "udp"]},
    "odmr": {"port_number": 366, "protocols": ["tcp", "udp"]},
    "mortgageware": {"port_number": 367, "protocols": ["tcp", "udp"]},
    "qbikgdp": {"port_number": 368, "protocols": ["tcp", "udp"]},
    "rpc2portmap": {"port_number": 369, "protocols": ["tcp", "udp"]},
    "codaauth2": {"port_number": 370, "protocols": ["tcp", "udp"]},
    "clearcase": {"port_number": 371, "protocols": ["tcp", "udp"]},
    "ulistproc": {"port_number": 372, "protocols": ["tcp", "udp"]},
    "legent-1": {"port_number": 373, "protocols": ["tcp", "udp"]},
    "legent-2": {"port_number": 374, "protocols": ["tcp", "udp"]},
    "hassle": {"port_number": 375, "protocols": ["tcp", "udp"]},
    "nip": {"port_number": 376, "protocols": ["tcp", "udp"]},
    "tnETOS": {"port_number": 377, "protocols": ["tcp", "udp"]},
    "dsETOS": {"port_number": 378, "protocols": ["tcp", "udp"]},
    "is99c": {"port_number": 379, "protocols": ["tcp", "udp"]},
    "is99s": {"port_number": 380, "protocols": ["tcp", "udp"]},
    "hp-collector": {"port_number": 381, "protocols": ["tcp", "udp"]},
    "hp-managed-node": {"port_number": 382, "protocols": ["tcp", "udp"]},
    "hp-alarm-mgr": {"port_number": 383, "protocols": ["tcp", "udp"]},
    "arns": {"port_number": 384, "protocols": ["tcp", "udp"]},
    "ibm-app": {"port_number": 385, "protocols": ["tcp", "udp"]},
    "asa": {"port_number": 386, "protocols": ["tcp", "udp"]},
    "aurp": {"port_number": 387, "protocols": ["tcp", "udp"]},
    "unidata-ldm": {"port_number": 388, "protocols": ["tcp", "udp"]},
    "ldap": {"port_number": 389, "protocols": ["tcp", "udp"]},
    "uis": {"port_number": 390, "protocols": ["tcp", "udp"]},
    "synotics-relay": {"port_number": 391, "protocols": ["tcp", "udp"]},
    "synotics-broker": {"port_number": 392, "protocols": ["tcp", "udp"]},
    "meta5": {"port_number": 393, "protocols": ["tcp", "udp"]},
    "embl-ndt": {"port_number": 394, "protocols": ["tcp", "udp"]},
    "netcp": {"port_number": 395, "protocols": ["tcp", "udp"]},
    "netware-ip": {"port_number": 396, "protocols": ["tcp", "udp"]},
    "mptn": {"port_number": 397, "protocols": ["tcp", "udp"]},
    "kryptolan": {"port_number": 398, "protocols": ["tcp", "udp"]},
    "iso-tsap-c2": {"port_number": 399, "protocols": ["tcp", "udp"]},
    "osb-sd": {"port_number": 400, "protocols": ["tcp", "udp"]},
    "ups": {"port_number": 401, "protocols": ["tcp", "udp"]},
    "genie": {"port_number": 402, "protocols": ["tcp", "udp"]},
    "decap": {"port_number": 403, "protocols": ["tcp", "udp"]},
    "nced": {"port_number": 404, "protocols": ["tcp", "udp"]},
    "ncld": {"port_number": 405, "protocols": ["tcp", "udp"]},
    "imsp": {"port_number": 406, "protocols": ["tcp", "udp"]},
    "timbuktu": {"port_number": 407, "protocols": ["tcp", "udp"]},
    "prm-sm": {"port_number": 408, "protocols": ["tcp", "udp"]},
    "prm-nm": {"port_number": 409, "protocols": ["tcp", "udp"]},
    "decladebug": {"port_number": 410, "protocols": ["tcp", "udp"]},
    "rmt": {"port_number": 411, "protocols": ["tcp", "udp"]},
    "synoptics-trap": {"port_number": 412, "protocols": ["tcp", "udp"]},
    "smsp": {"port_number": 413, "protocols": ["tcp", "udp"]},
    "infoseek": {"port_number": 414, "protocols": ["tcp", "udp"]},
    "bnet": {"port_number": 415, "protocols": ["tcp", "udp"]},
    "silverplatter": {"port_number": 416, "protocols": ["tcp", "udp"]},
    "onmux": {"port_number": 417, "protocols": ["tcp", "udp"]},
    "hyper-g": {"port_number": 418, "protocols": ["tcp", "udp"]},
    "ariel1": {"port_number": 419, "protocols": ["tcp", "udp"]},
    "smpte": {"port_number": 420, "protocols": ["tcp", "udp"]},
    "ariel2": {"port_number": 421, "protocols": ["tcp", "udp"]},
    "ariel3": {"port_number": 422, "protocols": ["tcp", "udp"]},
    "opc-job-start": {"port_number": 423, "protocols": ["tcp", "udp"]},
    "opc-job-track": {"port_number": 424, "protocols": ["tcp", "udp"]},
    "icad-el": {"port_number": 425, "protocols": ["tcp", "udp"]},
    "smartsdp": {"port_number": 426, "protocols": ["tcp", "udp"]},
    "svrloc": {"port_number": 427, "protocols": ["tcp", "udp"]},
    "ocs-cmu": {"port_number": 428, "protocols": ["tcp", "udp"]},
    "ocs_cmu": {"port_number": 428, "protocols": ["tcp", "udp"]},
    "ocs-amu": {"port_number": 429, "protocols": ["tcp", "udp"]},
    "ocs_amu": {"port_number": 429, "protocols": ["tcp", "udp"]},
    "utmpsd": {"port_number": 430, "protocols": ["tcp", "udp"]},
    "utmpcd": {"port_number": 431, "protocols": ["tcp", "udp"]},
    "iasd": {"port_number": 432, "protocols": ["tcp", "udp"]},
    "nnsp": {"port_number": 433, "protocols": ["tcp", "udp"]},
    "mobileip-agent": {"port_number": 434, "protocols": ["tcp", "udp"]},
    "mobilip-mn": {"port_number": 435, "protocols": ["tcp", "udp"]},
    "dna-cml": {"port_number": 436, "protocols": ["tcp", "udp"]},
    "comscm": {"port_number": 437, "protocols": ["tcp", "udp"]},
    "dsfgw": {"port_number": 438, "protocols": ["tcp", "udp"]},
    "dasp": {"port_number": 439, "protocols": ["tcp", "udp"]},
    "sgcp": {"port_number": 440, "protocols": ["tcp", "udp"]},
    "decvms-sysmgt": {"port_number": 441, "protocols": ["tcp", "udp"]},
    "cvc-hostd": {"port_number": 442, "protocols": ["tcp", "udp"]},
    "cvc_hostd": {"port_number": 442, "protocols": ["tcp", "udp"]},
    "https": {"port_number": 443, "protocols": ["tcp", "udp", "sctp"]},
    "snpp": {"port_number": 444, "protocols": ["tcp", "udp"]},
    "microsoft-ds": {"port_number": 445, "protocols": ["tcp", "udp"]},
    "ddm-rdb": {"port_number": 446, "protocols": ["tcp", "udp"]},
    "ddm-dfm": {"port_number": 447, "protocols": ["tcp", "udp"]},
    "ddm-ssl": {"port_number": 448, "protocols": ["tcp", "udp"]},
    "as-servermap": {"port_number": 449, "protocols": ["tcp", "udp"]},
    "tserver": {"port_number": 450, "protocols": ["tcp", "udp"]},
    "sfs-smp-net": {"port_number": 451, "protocols": ["tcp", "udp"]},
    "sfs-config": {"port_number": 452, "protocols": ["tcp", "udp"]},
    "creativeserver": {"port_number": 453, "protocols": ["tcp", "udp"]},
    "contentserver": {"port_number": 454, "protocols": ["tcp", "udp"]},
    "creativepartnr": {"port_number": 455, "protocols": ["tcp", "udp"]},
    "macon-tcp": {"port_number": 456, "protocols": ["tcp"]},
    "macon-udp": {"port_number": 456, "protocols": ["udp"]},
    "scohelp": {"port_number": 457, "protocols": ["tcp", "udp"]},
    "appleqtc": {"port_number": 458, "protocols": ["tcp", "udp"]},
    "ampr-rcmd": {"port_number": 459, "protocols": ["tcp", "udp"]},
    "skronk": {"port_number": 460, "protocols": ["tcp", "udp"]},
    "datasurfsrv": {"port_number": 461, "protocols": ["tcp", "udp"]},
    "datasurfsrvsec": {"port_number": 462, "protocols": ["tcp", "udp"]},
    "alpes": {"port_number": 463, "protocols": ["tcp", "udp"]},
    "kpasswd": {"port_number": 464, "protocols": ["tcp", "udp"]},
    "urd": {"port_number": 465, "protocols": ["tcp"]},
    "submissions": {"port_number": 465, "protocols": ["tcp"]},
    "igmpv3lite": {"port_number": 465, "protocols": ["udp"]},
    "digital-vrc": {"port_number": 466, "protocols": ["tcp", "udp"]},
    "mylex-mapd": {"port_number": 467, "protocols": ["tcp", "udp"]},
    "photuris": {"port_number": 468, "protocols": ["tcp", "udp"]},
    "rcp": {"port_number": 469, "protocols": ["tcp", "udp"]},
    "scx-proxy": {"port_number": 470, "protocols": ["tcp", "udp"]},
    "mondex": {"port_number": 471, "protocols": ["tcp", "udp"]},
    "ljk-login": {"port_number": 472, "protocols": ["tcp", "udp"]},
    "hybrid-pop": {"port_number": 473, "protocols": ["tcp", "udp"]},
    "tn-tl-w1": {"port_number": 474, "protocols": ["tcp"]},
    "tn-tl-w2": {"port_number": 474, "protocols": ["udp"]},
    "tcpnethaspsrv": {"port_number": 475, "protocols": ["tcp", "udp"]},
    "tn-tl-fd1": {"port_number": 476, "protocols": ["tcp", "udp"]},
    "ss7ns": {"port_number": 477, "protocols": ["tcp", "udp"]},
    "spsc": {"port_number": 478, "protocols": ["tcp", "udp"]},
    "iafserver": {"port_number": 479, "protocols": ["tcp", "udp"]},
    "iafdbase": {"port_number": 480, "protocols": ["tcp", "udp"]},
    "ph": {"port_number": 481, "protocols": ["tcp", "udp"]},
    "bgs-nsi": {"port_number": 482, "protocols": ["tcp", "udp"]},
    "ulpnet": {"port_number": 483, "protocols": ["tcp", "udp"]},
    "integra-sme": {"port_number": 484, "protocols": ["tcp", "udp"]},
    "powerburst": {"port_number": 485, "protocols": ["tcp", "udp"]},
    "avian": {"port_number": 486, "protocols": ["tcp", "udp"]},
    "saft": {"port_number": 487, "protocols": ["tcp", "udp"]},
    "gss-http": {"port_number": 488, "protocols": ["tcp", "udp"]},
    "nest-protocol": {"port_number": 489, "protocols": ["tcp", "udp"]},
    "micom-pfs": {"port_number": 490, "protocols": ["tcp", "udp"]},
    "go-login": {"port_number": 491, "protocols": ["tcp", "udp"]},
    "ticf-1": {"port_number": 492, "protocols": ["tcp", "udp"]},
    "ticf-2": {"port_number": 493, "protocols": ["tcp", "udp"]},
    "pov-ray": {"port_number": 494, "protocols": ["tcp", "udp"]},
    "intecourier": {"port_number": 495, "protocols": ["tcp", "udp"]},
    "pim-rp-disc": {"port_number": 496, "protocols": ["tcp", "udp"]},
    "retrospect": {"port_number": 497, "protocols": ["tcp", "udp"]},
    "siam": {"port_number": 498, "protocols": ["tcp", "udp"]},
    "iso-ill": {"port_number": 499, "protocols": ["tcp", "udp"]},
    "isakmp": {"port_number": 500, "protocols": ["tcp", "udp"]},
    "stmf": {"port_number": 501, "protocols": ["tcp", "udp"]},
    "mbap": {"port_number": 502, "protocols": ["tcp", "udp"]},
    "intrinsa": {"port_number": 503, "protocols": ["tcp", "udp"]},
    "citadel": {"port_number": 504, "protocols": ["tcp", "udp"]},
    "mailbox-lm": {"port_number": 505, "protocols": ["tcp", "udp"]},
    "ohimsrv": {"port_number": 506, "protocols": ["tcp", "udp"]},
    "crs": {"port_number": 507, "protocols": ["tcp", "udp"]},
    "xvttp": {"port_number": 508, "protocols": ["tcp", "udp"]},
    "snare": {"port_number": 509, "protocols": ["tcp", "udp"]},
    "fcp": {"port_number": 510, "protocols": ["tcp", "udp"]},
    "passgo": {"port_number": 511, "protocols": ["tcp", "udp"]},
    "exec": {"port_number": 512, "protocols": ["tcp"]},
    "comsat": {"port_number": 512, "protocols": ["udp"]},
    "biff": {"port_number": 512, "protocols": ["udp"]},
    "login": {"port_number": 513, "protocols": ["tcp"]},
    "who": {"port_number": 513, "protocols": ["udp"]},
    "shell": {"port_number": 514, "protocols": ["tcp"]},
    "syslog": {"port_number": 514, "protocols": ["udp"]},
    "printer": {"port_number": 515, "protocols": ["tcp", "udp"]},
    "videotex": {"port_number": 516, "protocols": ["tcp", "udp"]},
    "talk": {"port_number": 517, "protocols": ["tcp", "udp"]},
    "ntalk": {"port_number": 518, "protocols": ["tcp", "udp"]},
    "utime": {"port_number": 519, "protocols": ["tcp", "udp"]},
    "efs": {"port_number": 520, "protocols": ["tcp"]},
    "router": {"port_number": 520, "protocols": ["udp"]},
    "ripng": {"port_number": 521, "protocols": ["tcp", "udp"]},
    "ulp": {"port_number": 522, "protocols": ["tcp", "udp"]},
    "ibm-db2": {"port_number": 523, "protocols": ["tcp", "udp"]},
    "ncp": {"port_number": 524, "protocols": ["tcp", "udp"]},
    "timed": {"port_number": 525, "protocols": ["tcp", "udp"]},
    "tempo": {"port_number": 526, "protocols": ["tcp", "udp"]},
    "stx": {"port_number": 527, "protocols": ["tcp", "udp"]},
    "custix": {"port_number": 528, "protocols": ["tcp", "udp"]},
    "irc-serv": {"port_number": 529, "protocols": ["tcp", "udp"]},
    "courier": {"port_number": 530, "protocols": ["tcp", "udp"]},
    "conference": {"port_number": 531, "protocols": ["tcp", "udp"]},
    "netnews": {"port_number": 532, "protocols": ["tcp", "udp"]},
    "netwall": {"port_number": 533, "protocols": ["tcp", "udp"]},
    "windream": {"port_number": 534, "protocols": ["tcp", "udp"]},
    "iiop": {"port_number": 535, "protocols": ["tcp", "udp"]},
    "opalis-rdv": {"port_number": 536, "protocols": ["tcp", "udp"]},
    "nmsp": {"port_number": 537, "protocols": ["tcp", "udp"]},
    "gdomap": {"port_number": 538, "protocols": ["tcp", "udp"]},
    "apertus-ldp": {"port_number": 539, "protocols": ["tcp", "udp"]},
    "uucp": {"port_number": 540, "protocols": ["tcp", "udp"]},
    "uucp-rlogin": {"port_number": 541, "protocols": ["tcp", "udp"]},
    "commerce": {"port_number": 542, "protocols": ["tcp", "udp"]},
    "klogin": {"port_number": 543, "protocols": ["tcp", "udp"]},
    "kshell": {"port_number": 544, "protocols": ["tcp", "udp"]},
    "appleqtcsrvr": {"port_number": 545, "protocols": ["tcp", "udp"]},
    "dhcpv6-client": {"port_number": 546, "protocols": ["tcp", "udp"]},
    "dhcpv6-server": {"port_number": 547, "protocols": ["tcp", "udp"]},
    "afpovertcp": {"port_number": 548, "protocols": ["tcp", "udp"]},
    "idfp": {"port_number": 549, "protocols": ["tcp", "udp"]},
    "new-rwho": {"port_number": 550, "protocols": ["tcp", "udp"]},
    "cybercash": {"port_number": 551, "protocols": ["tcp", "udp"]},
    "devshr-nts": {"port_number": 552, "protocols": ["tcp", "udp"]},
    "pirp": {"port_number": 553, "protocols": ["tcp", "udp"]},
    "rtsp": {"port_number": 554, "protocols": ["tcp", "udp"]},
    "dsf": {"port_number": 555, "protocols": ["tcp", "udp"]},
    "remotefs": {"port_number": 556, "protocols": ["tcp", "udp"]},
    "openvms-sysipc": {"port_number": 557, "protocols": ["tcp", "udp"]},
    "sdnskmp": {"port_number": 558, "protocols": ["tcp", "udp"]},
    "teedtap": {"port_number": 559, "protocols": ["tcp", "udp"]},
    "rmonitor": {"port_number": 560, "protocols": ["tcp", "udp"]},
    "monitor": {"port_number": 561, "protocols": ["tcp", "udp"]},
    "chshell": {"port_number": 562, "protocols": ["tcp", "udp"]},
    "nntps": {"port_number": 563, "protocols": ["tcp", "udp"]},
    "9pfs": {"port_number": 564, "protocols": ["tcp", "udp"]},
    "whoami": {"port_number": 565, "protocols": ["tcp", "udp"]},
    "streettalk": {"port_number": 566, "protocols": ["tcp", "udp"]},
    "banyan-rpc": {"port_number": 567, "protocols": ["tcp", "udp"]},
    "ms-shuttle": {"port_number": 568, "protocols": ["tcp", "udp"]},
    "ms-rome": {"port_number": 569, "protocols": ["tcp", "udp"]},
    "meter": {"port_number": 570, "protocols": ["tcp", "udp"]},
    "meter-secondary": {"port_number": 571, "protocols": ["tcp", "udp"]},
    "sonar": {"port_number": 572, "protocols": ["tcp", "udp"]},
    "banyan-vip": {"port_number": 573, "protocols": ["tcp", "udp"]},
    "ftp-agent": {"port_number": 574, "protocols": ["tcp", "udp"]},
    "vemmi": {"port_number": 575, "protocols": ["tcp", "udp"]},
    "ipcd": {"port_number": 576, "protocols": ["tcp", "udp"]},
    "vnas": {"port_number": 577, "protocols": ["tcp", "udp"]},
    "ipdd": {"port_number": 578, "protocols": ["tcp", "udp"]},
    "decbsrv": {"port_number": 579, "protocols": ["tcp", "udp"]},
    "sntp-heartbeat": {"port_number": 580, "protocols": ["tcp", "udp"]},
    "bdp": {"port_number": 581, "protocols": ["tcp", "udp"]},
    "scc-security": {"port_number": 582, "protocols": ["tcp", "udp"]},
    "philips-vc": {"port_number": 583, "protocols": ["tcp", "udp"]},
    "keyserver": {"port_number": 584, "protocols": ["tcp", "udp"]},
    "password-chg": {"port_number": 586, "protocols": ["tcp", "udp"]},
    "submission": {"port_number": 587, "protocols": ["tcp", "udp"]},
    "cal": {"port_number": 588, "protocols": ["tcp", "udp"]},
    "eyelink": {"port_number": 589, "protocols": ["tcp", "udp"]},
    "tns-cml": {"port_number": 590, "protocols": ["tcp", "udp"]},
    "http-alt": {"port_number": 591, "protocols": ["tcp", "udp"]},
    "eudora-set": {"port_number": 592, "protocols": ["tcp", "udp"]},
    "http-rpc-epmap": {"port_number": 593, "protocols": ["tcp", "udp"]},
    "tpip": {"port_number": 594, "protocols": ["tcp", "udp"]},
    "cab-protocol": {"port_number": 595, "protocols": ["tcp", "udp"]},
    "smsd": {"port_number": 596, "protocols": ["tcp", "udp"]},
    "ptcnameservice": {"port_number": 597, "protocols": ["tcp", "udp"]},
    "sco-websrvrmg3": {"port_number": 598, "protocols": ["tcp", "udp"]},
    "acp": {"port_number": 599, "protocols": ["tcp", "udp"]},
    "ipcserver": {"port_number": 600, "protocols": ["tcp", "udp"]},
    "syslog-conn": {"port_number": 601, "protocols": ["tcp", "udp"]},
    "xmlrpc-beep": {"port_number": 602, "protocols": ["tcp", "udp"]},
    "idxp": {"port_number": 603, "protocols": ["tcp", "udp"]},
    "tunnel": {"port_number": 604, "protocols": ["tcp", "udp"]},
    "soap-beep": {"port_number": 605, "protocols": ["tcp", "udp"]},
    "urm": {"port_number": 606, "protocols": ["tcp", "udp"]},
    "nqs": {"port_number": 607, "protocols": ["tcp", "udp"]},
    "sift-uft": {"port_number": 608, "protocols": ["tcp", "udp"]},
    "npmp-trap": {"port_number": 609, "protocols": ["tcp", "udp"]},
    "npmp-local": {"port_number": 610, "protocols": ["tcp", "udp"]},
    "npmp-gui": {"port_number": 611, "protocols": ["tcp", "udp"]},
    "hmmp-ind": {"port_number": 612, "protocols": ["tcp", "udp"]},
    "hmmp-op": {"port_number": 613, "protocols": ["tcp", "udp"]},
    "sshell": {"port_number": 614, "protocols": ["tcp", "udp"]},
    "sco-inetmgr": {"port_number": 615, "protocols": ["tcp", "udp"]},
    "sco-sysmgr": {"port_number": 616, "protocols": ["tcp", "udp"]},
    "sco-dtmgr": {"port_number": 617, "protocols": ["tcp", "udp"]},
    "dei-icda": {"port_number": 618, "protocols": ["tcp", "udp"]},
    "compaq-evm": {"port_number": 619, "protocols": ["tcp", "udp"]},
    "sco-websrvrmgr": {"port_number": 620, "protocols": ["tcp", "udp"]},
    "escp-ip": {"port_number": 621, "protocols": ["tcp", "udp"]},
    "collaborator": {"port_number": 622, "protocols": ["tcp", "udp"]},
    "oob-ws-http": {"port_number": 623, "protocols": ["tcp"]},
    "asf-rmcp": {"port_number": 623, "protocols": ["udp"]},
    "cryptoadmin": {"port_number": 624, "protocols": ["tcp", "udp"]},
    "dec-dlm": {"port_number": 625, "protocols": ["tcp", "udp"]},
    "dec_dlm": {"port_number": 625, "protocols": ["tcp", "udp"]},
    "asia": {"port_number": 626, "protocols": ["tcp", "udp"]},
    "passgo-tivoli": {"port_number": 627, "protocols": ["tcp", "udp"]},
    "qmqp": {"port_number": 628, "protocols": ["tcp", "udp"]},
    "3com-amp3": {"port_number": 629, "protocols": ["tcp", "udp"]},
    "rda": {"port_number": 630, "protocols": ["tcp", "udp"]},
    "ipp": {"port_number": 631, "protocols": ["tcp", "udp"]},
    "ipps": {"port_number": 631, "protocols": ["tcp"]},
    "bmpp": {"port_number": 632, "protocols": ["tcp", "udp"]},
    "servstat": {"port_number": 633, "protocols": ["tcp", "udp"]},
    "ginad": {"port_number": 634, "protocols": ["tcp", "udp"]},
    "rlzdbase": {"port_number": 635, "protocols": ["tcp", "udp"]},
    "ldaps": {"port_number": 636, "protocols": ["tcp", "udp"]},
    "lanserver": {"port_number": 637, "protocols": ["tcp", "udp"]},
    "mcns-sec": {"port_number": 638, "protocols": ["tcp", "udp"]},
    "msdp": {"port_number": 639, "protocols": ["tcp", "udp"]},
    "entrust-sps": {"port_number": 640, "protocols": ["tcp", "udp"]},
    "repcmd": {"port_number": 641, "protocols": ["tcp", "udp"]},
    "esro-emsdp": {"port_number": 642, "protocols": ["tcp", "udp"]},
    "sanity": {"port_number": 643, "protocols": ["tcp", "udp"]},
    "dwr": {"port_number": 644, "protocols": ["tcp", "udp"]},
    "pssc": {"port_number": 645, "protocols": ["tcp", "udp"]},
    "ldp": {"port_number": 646, "protocols": ["tcp", "udp"]},
    "dhcp-failover": {"port_number": 647, "protocols": ["tcp", "udp"]},
    "rrp": {"port_number": 648, "protocols": ["tcp", "udp"]},
    "cadview-3d": {"port_number": 649, "protocols": ["tcp", "udp"]},
    "obex": {"port_number": 650, "protocols": ["tcp", "udp"]},
    "ieee-mms": {"port_number": 651, "protocols": ["tcp", "udp"]},
    "hello-port": {"port_number": 652, "protocols": ["tcp", "udp"]},
    "repscmd": {"port_number": 653, "protocols": ["tcp", "udp"]},
    "aodv": {"port_number": 654, "protocols": ["tcp", "udp"]},
    "tinc": {"port_number": 655, "protocols": ["tcp", "udp"]},
    "spmp": {"port_number": 656, "protocols": ["tcp", "udp"]},
    "rmc": {"port_number": 657, "protocols": ["tcp", "udp"]},
    "tenfold": {"port_number": 658, "protocols": ["tcp", "udp"]},
    "mac-srvr-admin": {"port_number": 660, "protocols": ["tcp", "udp"]},
    "hap": {"port_number": 661, "protocols": ["tcp", "udp"]},
    "pftp": {"port_number": 662, "protocols": ["tcp", "udp"]},
    "purenoise": {"port_number": 663, "protocols": ["tcp", "udp"]},
    "oob-ws-https": {"port_number": 664, "protocols": ["tcp"]},
    "asf-secure-rmcp": {"port_number": 664, "protocols": ["udp"]},
    "sun-dr": {"port_number": 665, "protocols": ["tcp", "udp"]},
    "mdqs": {"port_number": 666, "protocols": ["tcp", "udp"]},
    "doom": {"port_number": 666, "protocols": ["tcp", "udp"]},
    "disclose": {"port_number": 667, "protocols": ["tcp", "udp"]},
    "mecomm": {"port_number": 668, "protocols": ["tcp", "udp"]},
    "meregister": {"port_number": 669, "protocols": ["tcp", "udp"]},
    "vacdsm-sws": {"port_number": 670, "protocols": ["tcp", "udp"]},
    "vacdsm-app": {"port_number": 671, "protocols": ["tcp", "udp"]},
    "vpps-qua": {"port_number": 672, "protocols": ["tcp", "udp"]},
    "cimplex": {"port_number": 673, "protocols": ["tcp", "udp"]},
    "acap": {"port_number": 674, "protocols": ["tcp", "udp"]},
    "dctp": {"port_number": 675, "protocols": ["tcp", "udp"]},
    "vpps-via": {"port_number": 676, "protocols": ["tcp", "udp"]},
    "vpp": {"port_number": 677, "protocols": ["tcp", "udp"]},
    "ggf-ncp": {"port_number": 678, "protocols": ["tcp", "udp"]},
    "mrm": {"port_number": 679, "protocols": ["tcp", "udp"]},
    "entrust-aaas": {"port_number": 680, "protocols": ["tcp", "udp"]},
    "entrust-aams": {"port_number": 681, "protocols": ["tcp", "udp"]},
    "xfr": {"port_number": 682, "protocols": ["tcp", "udp"]},
    "corba-iiop": {"port_number": 683, "protocols": ["tcp", "udp"]},
    "corba-iiop-ssl": {"port_number": 684, "protocols": ["tcp", "udp"]},
    "mdc-portmapper": {"port_number": 685, "protocols": ["tcp", "udp"]},
    "hcp-wismar": {"port_number": 686, "protocols": ["tcp", "udp"]},
    "asipregistry": {"port_number": 687, "protocols": ["tcp", "udp"]},
    "realm-rusd": {"port_number": 688, "protocols": ["tcp", "udp"]},
    "nmap": {"port_number": 689, "protocols": ["tcp", "udp"]},
    "vatp": {"port_number": 690, "protocols": ["tcp", "udp"]},
    "msexch-routing": {"port_number": 691, "protocols": ["tcp", "udp"]},
    "hyperwave-isp": {"port_number": 692, "protocols": ["tcp", "udp"]},
    "connendp": {"port_number": 693, "protocols": ["tcp", "udp"]},
    "ha-cluster": {"port_number": 694, "protocols": ["tcp", "udp"]},
    "ieee-mms-ssl": {"port_number": 695, "protocols": ["tcp", "udp"]},
    "rushd": {"port_number": 696, "protocols": ["tcp", "udp"]},
    "uuidgen": {"port_number": 697, "protocols": ["tcp", "udp"]},
    "olsr": {"port_number": 698, "protocols": ["tcp", "udp"]},
    "accessnetwork": {"port_number": 699, "protocols": ["tcp", "udp"]},
    "epp": {"port_number": 700, "protocols": ["tcp", "udp"]},
    "lmp": {"port_number": 701, "protocols": ["tcp", "udp"]},
    "iris-beep": {"port_number": 702, "protocols": ["tcp", "udp"]},
    "elcsd": {"port_number": 704, "protocols": ["tcp", "udp"]},
    "agentx": {"port_number": 705, "protocols": ["tcp", "udp"]},
    "silc": {"port_number": 706, "protocols": ["tcp", "udp"]},
    "borland-dsj": {"port_number": 707, "protocols": ["tcp", "udp"]},
    "entrust-kmsh": {"port_number": 709, "protocols": ["tcp", "udp"]},
    "entrust-ash": {"port_number": 710, "protocols": ["tcp", "udp"]},
    "cisco-tdp": {"port_number": 711, "protocols": ["tcp", "udp"]},
    "tbrpf": {"port_number": 712, "protocols": ["tcp", "udp"]},
    "iris-xpc": {"port_number": 713, "protocols": ["tcp", "udp"]},
    "iris-xpcs": {"port_number": 714, "protocols": ["tcp", "udp"]},
    "iris-lwz": {"port_number": 715, "protocols": ["tcp", "udp"]},
    "pana": {"port_number": 716, "protocols": ["udp"]},
    "netviewdm1": {"port_number": 729, "protocols": ["tcp", "udp"]},
    "netviewdm2": {"port_number": 730, "protocols": ["tcp", "udp"]},
    "netviewdm3": {"port_number": 731, "protocols": ["tcp", "udp"]},
    "netgw": {"port_number": 741, "protocols": ["tcp", "udp"]},
    "netrcs": {"port_number": 742, "protocols": ["tcp", "udp"]},
    "flexlm": {"port_number": 744, "protocols": ["tcp", "udp"]},
    "fujitsu-dev": {"port_number": 747, "protocols": ["tcp", "udp"]},
    "ris-cm": {"port_number": 748, "protocols": ["tcp", "udp"]},
    "kerberos-adm": {"port_number": 749, "protocols": ["tcp", "udp"]},
    "rfile": {"port_number": 750, "protocols": ["tcp"]},
    "loadav": {"port_number": 750, "protocols": ["udp"]},
    "kerberos-iv": {"port_number": 750, "protocols": ["udp"]},
    "pump": {"port_number": 751, "protocols": ["tcp", "udp"]},
    "qrh": {"port_number": 752, "protocols": ["tcp", "udp"]},
    "rrh": {"port_number": 753, "protocols": ["tcp", "udp"]},
    "tell": {"port_number": 754, "protocols": ["tcp", "udp"]},
    "nlogin": {"port_number": 758, "protocols": ["tcp", "udp"]},
    "con": {"port_number": 759, "protocols": ["tcp", "udp"]},
    "ns": {"port_number": 760, "protocols": ["tcp", "udp"]},
    "rxe": {"port_number": 761, "protocols": ["tcp", "udp"]},
    "quotad": {"port_number": 762, "protocols": ["tcp", "udp"]},
    "cycleserv": {"port_number": 763, "protocols": ["tcp", "udp"]},
    "omserv": {"port_number": 764, "protocols": ["tcp", "udp"]},
    "webster": {"port_number": 765, "protocols": ["tcp", "udp"]},
    "phonebook": {"port_number": 767, "protocols": ["tcp", "udp"]},
    "vid": {"port_number": 769, "protocols": ["tcp", "udp"]},
    "cadlock": {"port_number": 770, "protocols": ["tcp", "udp"]},
    "rtip": {"port_number": 771, "protocols": ["tcp", "udp"]},
    "cycleserv2": {"port_number": 772, "protocols": ["tcp", "udp"]},
    "submit": {"port_number": 773, "protocols": ["tcp"]},
    "notify": {"port_number": 773, "protocols": ["udp"]},
    "rpasswd": {"port_number": 774, "protocols": ["tcp"]},
    "acmaint-dbd": {"port_number": 774, "protocols": ["udp"]},
    "acmaint_dbd": {"port_number": 774, "protocols": ["udp"]},
    "entomb": {"port_number": 775, "protocols": ["tcp"]},
    "acmaint-transd": {"port_number": 775, "protocols": ["udp"]},
    "acmaint_transd": {"port_number": 775, "protocols": ["udp"]},
    "wpages": {"port_number": 776, "protocols": ["tcp", "udp"]},
    "multiling-http": {"port_number": 777, "protocols": ["tcp", "udp"]},
    "wpgs": {"port_number": 780, "protocols": ["tcp", "udp"]},
    "mdbs-daemon": {"port_number": 800, "protocols": ["tcp", "udp"]},
    "mdbs_daemon": {"port_number": 800, "protocols": ["tcp", "udp"]},
    "device": {"port_number": 801, "protocols": ["tcp", "udp"]},
    "mbap-s": {"port_number": 802, "protocols": ["tcp", "udp"]},
    "fcp-udp": {"port_number": 810, "protocols": ["tcp", "udp"]},
    "itm-mcell-s": {"port_number": 828, "protocols": ["tcp", "udp"]},
    "pkix-3-ca-ra": {"port_number": 829, "protocols": ["tcp", "udp"]},
    "netconf-ssh": {"port_number": 830, "protocols": ["tcp", "udp"]},
    "netconf-beep": {"port_number": 831, "protocols": ["tcp", "udp"]},
    "netconfsoaphttp": {"port_number": 832, "protocols": ["tcp", "udp"]},
    "netconfsoapbeep": {"port_number": 833, "protocols": ["tcp", "udp"]},
    "dhcp-failover2": {"port_number": 847, "protocols": ["tcp", "udp"]},
    "gdoi": {"port_number": 848, "protocols": ["tcp", "udp"]},
    "domain-s": {"port_number": 853, "protocols": ["tcp", "udp"]},
    "dlep": {"port_number": 854, "protocols": ["tcp", "udp"]},
    "iscsi": {"port_number": 860, "protocols": ["tcp", "udp"]},
    "owamp-control": {"port_number": 861, "protocols": ["tcp"]},
    "owamp-test": {"port_number": 861, "protocols": ["udp"]},
    "twamp-control": {"port_number": 862, "protocols": ["tcp"]},
    "twamp-test": {"port_number": 862, "protocols": ["udp"]},
    "rsync": {"port_number": 873, "protocols": ["tcp", "udp"]},
    "iclcnet-locate": {"port_number": 886, "protocols": ["tcp", "udp"]},
    "iclcnet-svinfo": {"port_number": 887, "protocols": ["tcp", "udp"]},
    "iclcnet_svinfo": {"port_number": 887, "protocols": ["tcp", "udp"]},
    "accessbuilder": {"port_number": 888, "protocols": ["tcp", "udp"]},
    "cddbp": {"port_number": 888, "protocols": ["tcp"]},
    "omginitialrefs": {"port_number": 900, "protocols": ["tcp", "udp"]},
    "smpnameres": {"port_number": 901, "protocols": ["tcp", "udp"]},
    "ideafarm-door": {"port_number": 902, "protocols": ["tcp", "udp"]},
    "ideafarm-panic": {"port_number": 903, "protocols": ["tcp", "udp"]},
    "kink": {"port_number": 910, "protocols": ["tcp", "udp"]},
    "xact-backup": {"port_number": 911, "protocols": ["tcp", "udp"]},
    "apex-mesh": {"port_number": 912, "protocols": ["tcp", "udp"]},
    "apex-edge": {"port_number": 913, "protocols": ["tcp", "udp"]},
    "rift-lies": {"port_number": 914, "protocols": ["udp"]},
    "rift-ties": {"port_number": 915, "protocols": ["udp"]},
    "rndc": {"port_number": 953, "protocols": ["tcp"]},
    "ftps-data": {"port_number": 989, "protocols": ["tcp", "udp"]},
    "ftps": {"port_number": 990, "protocols": ["tcp", "udp"]},
    "nas": {"port_number": 991, "protocols": ["tcp", "udp"]},
    "telnets": {"port_number": 992, "protocols": ["tcp", "udp"]},
    "imaps": {"port_number": 993, "protocols": ["tcp"]},
    "pop3s": {"port_number": 995, "protocols": ["tcp", "udp"]},
    "vsinet": {"port_number": 996, "protocols": ["tcp", "udp"]},
    "maitrd": {"port_number": 997, "protocols": ["tcp", "udp"]},
    "busboy": {"port_number": 998, "protocols": ["tcp"]},
    "puparp": {"port_number": 998, "protocols": ["udp"]},
    "garcon": {"port_number": 999, "protocols": ["tcp"]},
    "applix": {"port_number": 999, "protocols": ["udp"]},
    "puprouter": {"port_number": 999, "protocols": ["tcp", "udp"]},
    "cadlock2": {"port_number": 1000, "protocols": ["tcp", "udp"]},
    "webpush": {"port_number": 1001, "protocols": ["tcp"]},
    "surf": {"port_number": 1010, "protocols": ["tcp", "udp"]},
    "exp1": {"port_number": 1021, "protocols": ["tcp", "udp", "sctp", "dccp"]},
    "exp2": {"port_number": 1022, "protocols": ["tcp", "udp", "sctp", "dccp"]},
    "blackjack": {"port_number": 1025, "protocols": ["tcp", "udp"]},
    "cap": {"port_number": 1026, "protocols": ["tcp", "udp"]},
    "6a44": {"port_number": 1027, "protocols": ["udp"]},
    "solid-mux": {"port_number": 1029, "protocols": ["tcp", "udp"]},
    "netinfo-local": {"port_number": 1033, "protocols": ["tcp", "udp"]},
    "activesync": {"port_number": 1034, "protocols": ["tcp", "udp"]},
    "mxxrlogin": {"port_number": 1035, "protocols": ["tcp", "udp"]},
    "nsstp": {"port_number": 1036, "protocols": ["tcp", "udp"]},
    "ams": {"port_number": 1037, "protocols": ["tcp", "udp"]},
    "mtqp": {"port_number": 1038, "protocols": ["tcp", "udp"]},
    "sbl": {"port_number": 1039, "protocols": ["tcp", "udp"]},
    "netarx": {"port_number": 1040, "protocols": ["tcp", "udp"]},
    "danf-ak2": {"port_number": 1041, "protocols": ["tcp", "udp"]},
    "afrog": {"port_number": 1042, "protocols": ["tcp", "udp"]},
    "boinc-client": {"port_number": 1043, "protocols": ["tcp", "udp"]},
    "dcutility": {"port_number": 1044, "protocols": ["tcp", "udp"]},
    "fpitp": {"port_number": 1045, "protocols": ["tcp", "udp"]},
    "wfremotertm": {"port_number": 1046, "protocols": ["tcp", "udp"]},
    "neod1": {"port_number": 1047, "protocols": ["tcp", "udp"]},
    "neod2": {"port_number": 1048, "protocols": ["tcp", "udp"]},
    "td-postman": {"port_number": 1049, "protocols": ["tcp", "udp"]},
    "cma": {"port_number": 1050, "protocols": ["tcp", "udp"]},
    "optima-vnet": {"port_number": 1051, "protocols": ["tcp", "udp"]},
    "ddt": {"port_number": 1052, "protocols": ["tcp", "udp"]},
    "remote-as": {"port_number": 1053, "protocols": ["tcp", "udp"]},
    "brvread": {"port_number": 1054, "protocols": ["tcp", "udp"]},
    "ansyslmd": {"port_number": 1055, "protocols": ["tcp", "udp"]},
    "vfo": {"port_number": 1056, "protocols": ["tcp", "udp"]},
    "startron": {"port_number": 1057, "protocols": ["tcp", "udp"]},
    "nim": {"port_number": 1058, "protocols": ["tcp", "udp"]},
    "nimreg": {"port_number": 1059, "protocols": ["tcp", "udp"]},
    "polestar": {"port_number": 1060, "protocols": ["tcp", "udp"]},
    "kiosk": {"port_number": 1061, "protocols": ["tcp", "udp"]},
    "veracity": {"port_number": 1062, "protocols": ["tcp", "udp"]},
    "kyoceranetdev": {"port_number": 1063, "protocols": ["tcp", "udp"]},
    "jstel": {"port_number": 1064, "protocols": ["tcp", "udp"]},
    "syscomlan": {"port_number": 1065, "protocols": ["tcp", "udp"]},
    "fpo-fns": {"port_number": 1066, "protocols": ["tcp", "udp"]},
    "instl-boots": {"port_number": 1067, "protocols": ["tcp", "udp"]},
    "instl_boots": {"port_number": 1067, "protocols": ["tcp", "udp"]},
    "instl-bootc": {"port_number": 1068, "protocols": ["tcp", "udp"]},
    "instl_bootc": {"port_number": 1068, "protocols": ["tcp", "udp"]},
    "cognex-insight": {"port_number": 1069, "protocols": ["tcp", "udp"]},
    "gmrupdateserv": {"port_number": 1070, "protocols": ["tcp", "udp"]},
    "bsquare-voip": {"port_number": 1071, "protocols": ["tcp", "udp"]},
    "cardax": {"port_number": 1072, "protocols": ["tcp", "udp"]},
    "bridgecontrol": {"port_number": 1073, "protocols": ["tcp", "udp"]},
    "warmspotMgmt": {"port_number": 1074, "protocols": ["tcp", "udp"]},
    "rdrmshc": {"port_number": 1075, "protocols": ["tcp", "udp"]},
    "dab-sti-c": {"port_number": 1076, "protocols": ["tcp", "udp"]},
    "imgames": {"port_number": 1077, "protocols": ["tcp", "udp"]},
    "avocent-proxy": {"port_number": 1078, "protocols": ["tcp", "udp"]},
    "asprovatalk": {"port_number": 1079, "protocols": ["tcp", "udp"]},
    "socks": {"port_number": 1080, "protocols": ["tcp", "udp"]},
    "pvuniwien": {"port_number": 1081, "protocols": ["tcp", "udp"]},
    "amt-esd-prot": {"port_number": 1082, "protocols": ["tcp", "udp"]},
    "ansoft-lm-1": {"port_number": 1083, "protocols": ["tcp", "udp"]},
    "ansoft-lm-2": {"port_number": 1084, "protocols": ["tcp", "udp"]},
    "webobjects": {"port_number": 1085, "protocols": ["tcp", "udp"]},
    "cplscrambler-lg": {"port_number": 1086, "protocols": ["tcp", "udp"]},
    "cplscrambler-in": {"port_number": 1087, "protocols": ["tcp", "udp"]},
    "cplscrambler-al": {"port_number": 1088, "protocols": ["tcp", "udp"]},
    "ff-annunc": {"port_number": 1089, "protocols": ["tcp", "udp"]},
    "ff-fms": {"port_number": 1090, "protocols": ["tcp", "udp"]},
    "ff-sm": {"port_number": 1091, "protocols": ["tcp", "udp"]},
    "obrpd": {"port_number": 1092, "protocols": ["tcp", "udp"]},
    "proofd": {"port_number": 1093, "protocols": ["tcp", "udp"]},
    "rootd": {"port_number": 1094, "protocols": ["tcp", "udp"]},
    "nicelink": {"port_number": 1095, "protocols": ["tcp", "udp"]},
    "cnrprotocol": {"port_number": 1096, "protocols": ["tcp", "udp"]},
    "sunclustermgr": {"port_number": 1097, "protocols": ["tcp", "udp"]},
    "rmiactivation": {"port_number": 1098, "protocols": ["tcp", "udp"]},
    "rmiregistry": {"port_number": 1099, "protocols": ["tcp", "udp"]},
    "mctp": {"port_number": 1100, "protocols": ["tcp", "udp"]},
    "pt2-discover": {"port_number": 1101, "protocols": ["tcp", "udp"]},
    "adobeserver-1": {"port_number": 1102, "protocols": ["tcp", "udp"]},
    "adobeserver-2": {"port_number": 1103, "protocols": ["tcp", "udp"]},
    "xrl": {"port_number": 1104, "protocols": ["tcp", "udp"]},
    "ftranhc": {"port_number": 1105, "protocols": ["tcp", "udp"]},
    "isoipsigport-1": {"port_number": 1106, "protocols": ["tcp", "udp"]},
    "isoipsigport-2": {"port_number": 1107, "protocols": ["tcp", "udp"]},
    "ratio-adp": {"port_number": 1108, "protocols": ["tcp", "udp"]},
    "webadmstart": {"port_number": 1110, "protocols": ["tcp"]},
    "nfsd-keepalive": {"port_number": 1110, "protocols": ["udp"]},
    "lmsocialserver": {"port_number": 1111, "protocols": ["tcp", "udp"]},
    "icp": {"port_number": 1112, "protocols": ["tcp", "udp"]},
    "ltp-deepspace": {"port_number": 1113, "protocols": ["tcp", "udp", "dccp"]},
    "mini-sql": {"port_number": 1114, "protocols": ["tcp", "udp"]},
    "ardus-trns": {"port_number": 1115, "protocols": ["tcp", "udp"]},
    "ardus-cntl": {"port_number": 1116, "protocols": ["tcp", "udp"]},
    "ardus-mtrns": {"port_number": 1117, "protocols": ["tcp", "udp"]},
    "sacred": {"port_number": 1118, "protocols": ["tcp", "udp"]},
    "bnetgame": {"port_number": 1119, "protocols": ["tcp", "udp"]},
    "bnetfile": {"port_number": 1120, "protocols": ["tcp", "udp"]},
    "rmpp": {"port_number": 1121, "protocols": ["tcp", "udp"]},
    "availant-mgr": {"port_number": 1122, "protocols": ["tcp", "udp"]},
    "murray": {"port_number": 1123, "protocols": ["tcp", "udp"]},
    "hpvmmcontrol": {"port_number": 1124, "protocols": ["tcp", "udp"]},
    "hpvmmagent": {"port_number": 1125, "protocols": ["tcp", "udp"]},
    "hpvmmdata": {"port_number": 1126, "protocols": ["tcp", "udp"]},
    "kwdb-commn": {"port_number": 1127, "protocols": ["tcp", "udp"]},
    "saphostctrl": {"port_number": 1128, "protocols": ["tcp", "udp"]},
    "saphostctrls": {"port_number": 1129, "protocols": ["tcp", "udp"]},
    "casp": {"port_number": 1130, "protocols": ["tcp", "udp"]},
    "caspssl": {"port_number": 1131, "protocols": ["tcp", "udp"]},
    "kvm-via-ip": {"port_number": 1132, "protocols": ["tcp", "udp"]},
    "dfn": {"port_number": 1133, "protocols": ["tcp", "udp"]},
    "aplx": {"port_number": 1134, "protocols": ["tcp", "udp"]},
    "omnivision": {"port_number": 1135, "protocols": ["tcp", "udp"]},
    "hhb-gateway": {"port_number": 1136, "protocols": ["tcp", "udp"]},
    "trim": {"port_number": 1137, "protocols": ["tcp", "udp"]},
    "encrypted-admin": {"port_number": 1138, "protocols": ["tcp", "udp"]},
    "encrypted_admin": {"port_number": 1138, "protocols": ["tcp", "udp"]},
    "evm": {"port_number": 1139, "protocols": ["tcp", "udp"]},
    "autonoc": {"port_number": 1140, "protocols": ["tcp", "udp"]},
    "mxomss": {"port_number": 1141, "protocols": ["tcp", "udp"]},
    "edtools": {"port_number": 1142, "protocols": ["tcp", "udp"]},
    "imyx": {"port_number": 1143, "protocols": ["tcp", "udp"]},
    "fuscript": {"port_number": 1144, "protocols": ["tcp", "udp"]},
    "x9-icue": {"port_number": 1145, "protocols": ["tcp", "udp"]},
    "audit-transfer": {"port_number": 1146, "protocols": ["tcp", "udp"]},
    "capioverlan": {"port_number": 1147, "protocols": ["tcp", "udp"]},
    "elfiq-repl": {"port_number": 1148, "protocols": ["tcp", "udp"]},
    "bvtsonar": {"port_number": 1149, "protocols": ["tcp", "udp"]},
    "blaze": {"port_number": 1150, "protocols": ["tcp", "udp"]},
    "unizensus": {"port_number": 1151, "protocols": ["tcp", "udp"]},
    "winpoplanmess": {"port_number": 1152, "protocols": ["tcp", "udp"]},
    "c1222-acse": {"port_number": 1153, "protocols": ["tcp", "udp"]},
    "resacommunity": {"port_number": 1154, "protocols": ["tcp", "udp"]},
    "nfa": {"port_number": 1155, "protocols": ["tcp", "udp"]},
    "iascontrol-oms": {"port_number": 1156, "protocols": ["tcp", "udp"]},
    "iascontrol": {"port_number": 1157, "protocols": ["tcp", "udp"]},
    "dbcontrol-oms": {"port_number": 1158, "protocols": ["tcp", "udp"]},
    "oracle-oms": {"port_number": 1159, "protocols": ["tcp", "udp"]},
    "olsv": {"port_number": 1160, "protocols": ["tcp", "udp"]},
    "health-polling": {"port_number": 1161, "protocols": ["tcp", "udp"]},
    "health-trap": {"port_number": 1162, "protocols": ["tcp", "udp"]},
    "sddp": {"port_number": 1163, "protocols": ["tcp", "udp"]},
    "qsm-proxy": {"port_number": 1164, "protocols": ["tcp", "udp"]},
    "qsm-gui": {"port_number": 1165, "protocols": ["tcp", "udp"]},
    "qsm-remote": {"port_number": 1166, "protocols": ["tcp", "udp"]},
    "cisco-ipsla": {"port_number": 1167, "protocols": ["tcp", "udp", "sctp"]},
    "vchat": {"port_number": 1168, "protocols": ["tcp", "udp"]},
    "tripwire": {"port_number": 1169, "protocols": ["tcp", "udp"]},
    "atc-lm": {"port_number": 1170, "protocols": ["tcp", "udp"]},
    "atc-appserver": {"port_number": 1171, "protocols": ["tcp", "udp"]},
    "dnap": {"port_number": 1172, "protocols": ["tcp", "udp"]},
    "d-cinema-rrp": {"port_number": 1173, "protocols": ["tcp", "udp"]},
    "fnet-remote-ui": {"port_number": 1174, "protocols": ["tcp", "udp"]},
    "dossier": {"port_number": 1175, "protocols": ["tcp", "udp"]},
    "indigo-server": {"port_number": 1176, "protocols": ["tcp", "udp"]},
    "dkmessenger": {"port_number": 1177, "protocols": ["tcp", "udp"]},
    "sgi-storman": {"port_number": 1178, "protocols": ["tcp", "udp"]},
    "b2n": {"port_number": 1179, "protocols": ["tcp", "udp"]},
    "mc-client": {"port_number": 1180, "protocols": ["tcp", "udp"]},
    "3comnetman": {"port_number": 1181, "protocols": ["tcp", "udp"]},
    "accelenet": {"port_number": 1182, "protocols": ["tcp"]},
    "accelenet-data": {"port_number": 1182, "protocols": ["udp"]},
    "llsurfup-http": {"port_number": 1183, "protocols": ["tcp", "udp"]},
    "llsurfup-https": {"port_number": 1184, "protocols": ["tcp", "udp"]},
    "catchpole": {"port_number": 1185, "protocols": ["tcp", "udp"]},
    "mysql-cluster": {"port_number": 1186, "protocols": ["tcp", "udp"]},
    "alias": {"port_number": 1187, "protocols": ["tcp", "udp"]},
    "hp-webadmin": {"port_number": 1188, "protocols": ["tcp", "udp"]},
    "unet": {"port_number": 1189, "protocols": ["tcp", "udp"]},
    "commlinx-avl": {"port_number": 1190, "protocols": ["tcp", "udp"]},
    "gpfs": {"port_number": 1191, "protocols": ["tcp", "udp"]},
    "caids-sensor": {"port_number": 1192, "protocols": ["tcp", "udp"]},
    "fiveacross": {"port_number": 1193, "protocols": ["tcp", "udp"]},
    "openvpn": {"port_number": 1194, "protocols": ["tcp", "udp"]},
    "rsf-1": {"port_number": 1195, "protocols": ["tcp", "udp"]},
    "netmagic": {"port_number": 1196, "protocols": ["tcp", "udp"]},
    "carrius-rshell": {"port_number": 1197, "protocols": ["tcp", "udp"]},
    "cajo-discovery": {"port_number": 1198, "protocols": ["tcp", "udp"]},
    "dmidi": {"port_number": 1199, "protocols": ["tcp", "udp"]},
    "scol": {"port_number": 1200, "protocols": ["tcp", "udp"]},
    "nucleus-sand": {"port_number": 1201, "protocols": ["tcp", "udp"]},
    "caiccipc": {"port_number": 1202, "protocols": ["tcp", "udp"]},
    "ssslic-mgr": {"port_number": 1203, "protocols": ["tcp", "udp"]},
    "ssslog-mgr": {"port_number": 1204, "protocols": ["tcp", "udp"]},
    "accord-mgc": {"port_number": 1205, "protocols": ["tcp", "udp"]},
    "anthony-data": {"port_number": 1206, "protocols": ["tcp", "udp"]},
    "metasage": {"port_number": 1207, "protocols": ["tcp", "udp"]},
    "seagull-ais": {"port_number": 1208, "protocols": ["tcp", "udp"]},
    "ipcd3": {"port_number": 1209, "protocols": ["tcp", "udp"]},
    "eoss": {"port_number": 1210, "protocols": ["tcp", "udp"]},
    "groove-dpp": {"port_number": 1211, "protocols": ["tcp", "udp"]},
    "lupa": {"port_number": 1212, "protocols": ["tcp", "udp"]},
    "mpc-lifenet": {"port_number": 1213, "protocols": ["tcp", "udp"]},
    "kazaa": {"port_number": 1214, "protocols": ["tcp", "udp"]},
    "scanstat-1": {"port_number": 1215, "protocols": ["tcp", "udp"]},
    "etebac5": {"port_number": 1216, "protocols": ["tcp", "udp"]},
    "hpss-ndapi": {"port_number": 1217, "protocols": ["tcp", "udp"]},
    "aeroflight-ads": {"port_number": 1218, "protocols": ["tcp", "udp"]},
    "aeroflight-ret": {"port_number": 1219, "protocols": ["tcp", "udp"]},
    "qt-serveradmin": {"port_number": 1220, "protocols": ["tcp", "udp"]},
    "sweetware-apps": {"port_number": 1221, "protocols": ["tcp", "udp"]},
    "nerv": {"port_number": 1222, "protocols": ["tcp", "udp"]},
    "tgp": {"port_number": 1223, "protocols": ["tcp", "udp"]},
    "vpnz": {"port_number": 1224, "protocols": ["tcp", "udp"]},
    "slinkysearch": {"port_number": 1225, "protocols": ["tcp", "udp"]},
    "stgxfws": {"port_number": 1226, "protocols": ["tcp", "udp"]},
    "dns2go": {"port_number": 1227, "protocols": ["tcp", "udp"]},
    "florence": {"port_number": 1228, "protocols": ["tcp", "udp"]},
    "zented": {"port_number": 1229, "protocols": ["tcp", "udp"]},
    "periscope": {"port_number": 1230, "protocols": ["tcp", "udp"]},
    "menandmice-lpm": {"port_number": 1231, "protocols": ["tcp", "udp"]},
    "first-defense": {"port_number": 1232, "protocols": ["tcp", "udp"]},
    "univ-appserver": {"port_number": 1233, "protocols": ["tcp", "udp"]},
    "search-agent": {"port_number": 1234, "protocols": ["tcp", "udp"]},
    "mosaicsyssvc1": {"port_number": 1235, "protocols": ["tcp", "udp"]},
    "bvcontrol": {"port_number": 1236, "protocols": ["tcp", "udp"]},
    "tsdos390": {"port_number": 1237, "protocols": ["tcp", "udp"]},
    "hacl-qs": {"port_number": 1238, "protocols": ["tcp", "udp"]},
    "nmsd": {"port_number": 1239, "protocols": ["tcp", "udp"]},
    "instantia": {"port_number": 1240, "protocols": ["tcp", "udp"]},
    "nessus": {"port_number": 1241, "protocols": ["tcp", "udp"]},
    "nmasoverip": {"port_number": 1242, "protocols": ["tcp", "udp"]},
    "serialgateway": {"port_number": 1243, "protocols": ["tcp", "udp"]},
    "isbconference1": {"port_number": 1244, "protocols": ["tcp", "udp"]},
    "isbconference2": {"port_number": 1245, "protocols": ["tcp", "udp"]},
    "payrouter": {"port_number": 1246, "protocols": ["tcp", "udp"]},
    "visionpyramid": {"port_number": 1247, "protocols": ["tcp", "udp"]},
    "hermes": {"port_number": 1248, "protocols": ["tcp", "udp"]},
    "mesavistaco": {"port_number": 1249, "protocols": ["tcp", "udp"]},
    "swldy-sias": {"port_number": 1250, "protocols": ["tcp", "udp"]},
    "servergraph": {"port_number": 1251, "protocols": ["tcp", "udp"]},
    "bspne-pcc": {"port_number": 1252, "protocols": ["tcp", "udp"]},
    "q55-pcc": {"port_number": 1253, "protocols": ["tcp", "udp"]},
    "de-noc": {"port_number": 1254, "protocols": ["tcp", "udp"]},
    "de-cache-query": {"port_number": 1255, "protocols": ["tcp", "udp"]},
    "de-server": {"port_number": 1256, "protocols": ["tcp", "udp"]},
    "shockwave2": {"port_number": 1257, "protocols": ["tcp", "udp"]},
    "opennl": {"port_number": 1258, "protocols": ["tcp", "udp"]},
    "opennl-voice": {"port_number": 1259, "protocols": ["tcp", "udp"]},
    "ibm-ssd": {"port_number": 1260, "protocols": ["tcp", "udp"]},
    "mpshrsv": {"port_number": 1261, "protocols": ["tcp", "udp"]},
    "qnts-orb": {"port_number": 1262, "protocols": ["tcp", "udp"]},
    "dka": {"port_number": 1263, "protocols": ["tcp", "udp"]},
    "prat": {"port_number": 1264, "protocols": ["tcp", "udp"]},
    "dssiapi": {"port_number": 1265, "protocols": ["tcp", "udp"]},
    "dellpwrappks": {"port_number": 1266, "protocols": ["tcp", "udp"]},
    "epc": {"port_number": 1267, "protocols": ["tcp", "udp"]},
    "propel-msgsys": {"port_number": 1268, "protocols": ["tcp", "udp"]},
    "watilapp": {"port_number": 1269, "protocols": ["tcp", "udp"]},
    "opsmgr": {"port_number": 1270, "protocols": ["tcp", "udp"]},
    "excw": {"port_number": 1271, "protocols": ["tcp", "udp"]},
    "cspmlockmgr": {"port_number": 1272, "protocols": ["tcp", "udp"]},
    "emc-gateway": {"port_number": 1273, "protocols": ["tcp", "udp"]},
    "t1distproc": {"port_number": 1274, "protocols": ["tcp", "udp"]},
    "ivcollector": {"port_number": 1275, "protocols": ["tcp", "udp"]},
    "miva-mqs": {"port_number": 1277, "protocols": ["tcp", "udp"]},
    "dellwebadmin-1": {"port_number": 1278, "protocols": ["tcp", "udp"]},
    "dellwebadmin-2": {"port_number": 1279, "protocols": ["tcp", "udp"]},
    "pictrography": {"port_number": 1280, "protocols": ["tcp", "udp"]},
    "healthd": {"port_number": 1281, "protocols": ["tcp", "udp"]},
    "emperion": {"port_number": 1282, "protocols": ["tcp", "udp"]},
    "productinfo": {"port_number": 1283, "protocols": ["tcp", "udp"]},
    "iee-qfx": {"port_number": 1284, "protocols": ["tcp", "udp"]},
    "neoiface": {"port_number": 1285, "protocols": ["tcp", "udp"]},
    "netuitive": {"port_number": 1286, "protocols": ["tcp", "udp"]},
    "routematch": {"port_number": 1287, "protocols": ["tcp", "udp"]},
    "navbuddy": {"port_number": 1288, "protocols": ["tcp", "udp"]},
    "jwalkserver": {"port_number": 1289, "protocols": ["tcp", "udp"]},
    "winjaserver": {"port_number": 1290, "protocols": ["tcp", "udp"]},
    "seagulllms": {"port_number": 1291, "protocols": ["tcp", "udp"]},
    "dsdn": {"port_number": 1292, "protocols": ["tcp", "udp"]},
    "pkt-krb-ipsec": {"port_number": 1293, "protocols": ["tcp", "udp"]},
    "cmmdriver": {"port_number": 1294, "protocols": ["tcp", "udp"]},
    "ehtp": {"port_number": 1295, "protocols": ["tcp", "udp"]},
    "dproxy": {"port_number": 1296, "protocols": ["tcp", "udp"]},
    "sdproxy": {"port_number": 1297, "protocols": ["tcp", "udp"]},
    "lpcp": {"port_number": 1298, "protocols": ["tcp", "udp"]},
    "hp-sci": {"port_number": 1299, "protocols": ["tcp", "udp"]},
    "h323hostcallsc": {"port_number": 1300, "protocols": ["tcp", "udp"]},
    "sftsrv": {"port_number": 1303, "protocols": ["tcp", "udp"]},
    "boomerang": {"port_number": 1304, "protocols": ["tcp", "udp"]},
    "pe-mike": {"port_number": 1305, "protocols": ["tcp", "udp"]},
    "re-conn-proto": {"port_number": 1306, "protocols": ["tcp", "udp"]},
    "pacmand": {"port_number": 1307, "protocols": ["tcp", "udp"]},
    "odsi": {"port_number": 1308, "protocols": ["tcp", "udp"]},
    "jtag-server": {"port_number": 1309, "protocols": ["tcp", "udp"]},
    "husky": {"port_number": 1310, "protocols": ["tcp", "udp"]},
    "rxmon": {"port_number": 1311, "protocols": ["tcp", "udp"]},
    "sti-envision": {"port_number": 1312, "protocols": ["tcp", "udp"]},
    "bmc-patroldb": {"port_number": 1313, "protocols": ["tcp", "udp"]},
    "bmc_patroldb": {"port_number": 1313, "protocols": ["tcp", "udp"]},
    "pdps": {"port_number": 1314, "protocols": ["tcp", "udp"]},
    "els": {"port_number": 1315, "protocols": ["tcp", "udp"]},
    "exbit-escp": {"port_number": 1316, "protocols": ["tcp", "udp"]},
    "vrts-ipcserver": {"port_number": 1317, "protocols": ["tcp", "udp"]},
    "krb5gatekeeper": {"port_number": 1318, "protocols": ["tcp", "udp"]},
    "amx-icsp": {"port_number": 1319, "protocols": ["tcp", "udp"]},
    "amx-axbnet": {"port_number": 1320, "protocols": ["tcp", "udp"]},
    "pip-secondary": {"port_number": 1321, "protocols": ["tcp", "udp"]},
    "novation": {"port_number": 1322, "protocols": ["tcp", "udp"]},
    "brcd": {"port_number": 1323, "protocols": ["tcp", "udp"]},
    "delta-mcp": {"port_number": 1324, "protocols": ["tcp", "udp"]},
    "dx-instrument": {"port_number": 1325, "protocols": ["tcp", "udp"]},
    "wimsic": {"port_number": 1326, "protocols": ["tcp", "udp"]},
    "ultrex": {"port_number": 1327, "protocols": ["tcp", "udp"]},
    "ewall": {"port_number": 1328, "protocols": ["tcp", "udp"]},
    "netdb-export": {"port_number": 1329, "protocols": ["tcp", "udp"]},
    "streetperfect": {"port_number": 1330, "protocols": ["tcp", "udp"]},
    "intersan": {"port_number": 1331, "protocols": ["tcp", "udp"]},
    "pcia-rxp-b": {"port_number": 1332, "protocols": ["tcp", "udp"]},
    "passwrd-policy": {"port_number": 1333, "protocols": ["tcp", "udp"]},
    "writesrv": {"port_number": 1334, "protocols": ["tcp", "udp"]},
    "digital-notary": {"port_number": 1335, "protocols": ["tcp", "udp"]},
    "ischat": {"port_number": 1336, "protocols": ["tcp", "udp"]},
    "menandmice-dns": {"port_number": 1337, "protocols": ["tcp", "udp"]},
    "wmc-log-svc": {"port_number": 1338, "protocols": ["tcp", "udp"]},
    "kjtsiteserver": {"port_number": 1339, "protocols": ["tcp", "udp"]},
    "naap": {"port_number": 1340, "protocols": ["tcp", "udp"]},
    "qubes": {"port_number": 1341, "protocols": ["tcp", "udp"]},
    "esbroker": {"port_number": 1342, "protocols": ["tcp", "udp"]},
    "re101": {"port_number": 1343, "protocols": ["tcp", "udp"]},
    "icap": {"port_number": 1344, "protocols": ["tcp", "udp"]},
    "vpjp": {"port_number": 1345, "protocols": ["tcp", "udp"]},
    "alta-ana-lm": {"port_number": 1346, "protocols": ["tcp", "udp"]},
    "bbn-mmc": {"port_number": 1347, "protocols": ["tcp", "udp"]},
    "bbn-mmx": {"port_number": 1348, "protocols": ["tcp", "udp"]},
    "sbook": {"port_number": 1349, "protocols": ["tcp", "udp"]},
    "editbench": {"port_number": 1350, "protocols": ["tcp", "udp"]},
    "equationbuilder": {"port_number": 1351, "protocols": ["tcp", "udp"]},
    "lotusnote": {"port_number": 1352, "protocols": ["tcp", "udp"]},
    "relief": {"port_number": 1353, "protocols": ["tcp", "udp"]},
    "XSIP-network": {"port_number": 1354, "protocols": ["tcp", "udp"]},
    "intuitive-edge": {"port_number": 1355, "protocols": ["tcp", "udp"]},
    "cuillamartin": {"port_number": 1356, "protocols": ["tcp", "udp"]},
    "pegboard": {"port_number": 1357, "protocols": ["tcp", "udp"]},
    "connlcli": {"port_number": 1358, "protocols": ["tcp", "udp"]},
    "ftsrv": {"port_number": 1359, "protocols": ["tcp", "udp"]},
    "mimer": {"port_number": 1360, "protocols": ["tcp", "udp"]},
    "linx": {"port_number": 1361, "protocols": ["tcp", "udp"]},
    "timeflies": {"port_number": 1362, "protocols": ["tcp", "udp"]},
    "ndm-requester": {"port_number": 1363, "protocols": ["tcp", "udp"]},
    "ndm-server": {"port_number": 1364, "protocols": ["tcp", "udp"]},
    "adapt-sna": {"port_number": 1365, "protocols": ["tcp", "udp"]},
    "netware-csp": {"port_number": 1366, "protocols": ["tcp", "udp"]},
    "dcs": {"port_number": 1367, "protocols": ["tcp", "udp"]},
    "screencast": {"port_number": 1368, "protocols": ["tcp", "udp"]},
    "gv-us": {"port_number": 1369, "protocols": ["tcp", "udp"]},
    "us-gv": {"port_number": 1370, "protocols": ["tcp", "udp"]},
    "fc-cli": {"port_number": 1371, "protocols": ["tcp", "udp"]},
    "fc-ser": {"port_number": 1372, "protocols": ["tcp", "udp"]},
    "chromagrafx": {"port_number": 1373, "protocols": ["tcp", "udp"]},
    "molly": {"port_number": 1374, "protocols": ["tcp", "udp"]},
    "bytex": {"port_number": 1375, "protocols": ["tcp", "udp"]},
    "ibm-pps": {"port_number": 1376, "protocols": ["tcp", "udp"]},
    "cichlid": {"port_number": 1377, "protocols": ["tcp", "udp"]},
    "elan": {"port_number": 1378, "protocols": ["tcp", "udp"]},
    "dbreporter": {"port_number": 1379, "protocols": ["tcp", "udp"]},
    "telesis-licman": {"port_number": 1380, "protocols": ["tcp", "udp"]},
    "apple-licman": {"port_number": 1381, "protocols": ["tcp", "udp"]},
    "udt-os": {"port_number": 1382, "protocols": ["tcp", "udp"]},
    "udt_os": {"port_number": 1382, "protocols": ["tcp", "udp"]},
    "gwha": {"port_number": 1383, "protocols": ["tcp", "udp"]},
    "os-licman": {"port_number": 1384, "protocols": ["tcp", "udp"]},
    "atex-elmd": {"port_number": 1385, "protocols": ["tcp", "udp"]},
    "atex_elmd": {"port_number": 1385, "protocols": ["tcp", "udp"]},
    "checksum": {"port_number": 1386, "protocols": ["tcp", "udp"]},
    "cadsi-lm": {"port_number": 1387, "protocols": ["tcp", "udp"]},
    "objective-dbc": {"port_number": 1388, "protocols": ["tcp", "udp"]},
    "iclpv-dm": {"port_number": 1389, "protocols": ["tcp", "udp"]},
    "iclpv-sc": {"port_number": 1390, "protocols": ["tcp", "udp"]},
    "iclpv-sas": {"port_number": 1391, "protocols": ["tcp", "udp"]},
    "iclpv-pm": {"port_number": 1392, "protocols": ["tcp", "udp"]},
    "iclpv-nls": {"port_number": 1393, "protocols": ["tcp", "udp"]},
    "iclpv-nlc": {"port_number": 1394, "protocols": ["tcp", "udp"]},
    "iclpv-wsm": {"port_number": 1395, "protocols": ["tcp", "udp"]},
    "dvl-activemail": {"port_number": 1396, "protocols": ["tcp", "udp"]},
    "audio-activmail": {"port_number": 1397, "protocols": ["tcp", "udp"]},
    "video-activmail": {"port_number": 1398, "protocols": ["tcp", "udp"]},
    "cadkey-licman": {"port_number": 1399, "protocols": ["tcp", "udp"]},
    "cadkey-tablet": {"port_number": 1400, "protocols": ["tcp", "udp"]},
    "goldleaf-licman": {"port_number": 1401, "protocols": ["tcp", "udp"]},
    "prm-sm-np": {"port_number": 1402, "protocols": ["tcp", "udp"]},
    "prm-nm-np": {"port_number": 1403, "protocols": ["tcp", "udp"]},
    "igi-lm": {"port_number": 1404, "protocols": ["tcp", "udp"]},
    "ibm-res": {"port_number": 1405, "protocols": ["tcp", "udp"]},
    "netlabs-lm": {"port_number": 1406, "protocols": ["tcp", "udp"]},
    "tibet-server": {"port_number": 1407, "protocols": ["tcp"]},
    "sophia-lm": {"port_number": 1408, "protocols": ["tcp", "udp"]},
    "here-lm": {"port_number": 1409, "protocols": ["tcp", "udp"]},
    "hiq": {"port_number": 1410, "protocols": ["tcp", "udp"]},
    "af": {"port_number": 1411, "protocols": ["tcp", "udp"]},
    "innosys": {"port_number": 1412, "protocols": ["tcp", "udp"]},
    "innosys-acl": {"port_number": 1413, "protocols": ["tcp", "udp"]},
    "ibm-mqseries": {"port_number": 1414, "protocols": ["tcp", "udp"]},
    "dbstar": {"port_number": 1415, "protocols": ["tcp", "udp"]},
    "novell-lu6-2": {"port_number": 1416, "protocols": ["tcp", "udp"]},
    "novell-lu6.2": {"port_number": 1416, "protocols": ["tcp", "udp"]},
    "timbuktu-srv1": {"port_number": 1417, "protocols": ["tcp", "udp"]},
    "timbuktu-srv2": {"port_number": 1418, "protocols": ["tcp", "udp"]},
    "timbuktu-srv3": {"port_number": 1419, "protocols": ["tcp", "udp"]},
    "timbuktu-srv4": {"port_number": 1420, "protocols": ["tcp", "udp"]},
    "gandalf-lm": {"port_number": 1421, "protocols": ["tcp", "udp"]},
    "autodesk-lm": {"port_number": 1422, "protocols": ["tcp", "udp"]},
    "essbase": {"port_number": 1423, "protocols": ["tcp", "udp"]},
    "hybrid": {"port_number": 1424, "protocols": ["tcp", "udp"]},
    "zion-lm": {"port_number": 1425, "protocols": ["tcp", "udp"]},
    "sais": {"port_number": 1426, "protocols": ["tcp", "udp"]},
    "mloadd": {"port_number": 1427, "protocols": ["tcp", "udp"]},
    "informatik-lm": {"port_number": 1428, "protocols": ["tcp", "udp"]},
    "nms": {"port_number": 1429, "protocols": ["tcp", "udp"]},
    "tpdu": {"port_number": 1430, "protocols": ["tcp", "udp"]},
    "rgtp": {"port_number": 1431, "protocols": ["tcp", "udp"]},
    "blueberry-lm": {"port_number": 1432, "protocols": ["tcp", "udp"]},
    "ms-sql-s": {"port_number": 1433, "protocols": ["tcp", "udp"]},
    "ms-sql-m": {"port_number": 1434, "protocols": ["tcp", "udp"]},
    "ibm-cics": {"port_number": 1435, "protocols": ["tcp", "udp"]},
    "saism": {"port_number": 1436, "protocols": ["tcp", "udp"]},
    "tabula": {"port_number": 1437, "protocols": ["tcp", "udp"]},
    "eicon-server": {"port_number": 1438, "protocols": ["tcp", "udp"]},
    "eicon-x25": {"port_number": 1439, "protocols": ["tcp", "udp"]},
    "eicon-slp": {"port_number": 1440, "protocols": ["tcp", "udp"]},
    "cadis-1": {"port_number": 1441, "protocols": ["tcp", "udp"]},
    "cadis-2": {"port_number": 1442, "protocols": ["tcp", "udp"]},
    "ies-lm": {"port_number": 1443, "protocols": ["tcp", "udp"]},
    "marcam-lm": {"port_number": 1444, "protocols": ["tcp", "udp"]},
    "proxima-lm": {"port_number": 1445, "protocols": ["tcp", "udp"]},
    "ora-lm": {"port_number": 1446, "protocols": ["tcp", "udp"]},
    "apri-lm": {"port_number": 1447, "protocols": ["tcp", "udp"]},
    "oc-lm": {"port_number": 1448, "protocols": ["tcp", "udp"]},
    "peport": {"port_number": 1449, "protocols": ["tcp", "udp"]},
    "dwf": {"port_number": 1450, "protocols": ["tcp", "udp"]},
    "infoman": {"port_number": 1451, "protocols": ["tcp", "udp"]},
    "gtegsc-lm": {"port_number": 1452, "protocols": ["tcp", "udp"]},
    "genie-lm": {"port_number": 1453, "protocols": ["tcp", "udp"]},
    "interhdl-elmd": {"port_number": 1454, "protocols": ["tcp", "udp"]},
    "interhdl_elmd": {"port_number": 1454, "protocols": ["tcp", "udp"]},
    "esl-lm": {"port_number": 1455, "protocols": ["tcp", "udp"]},
    "dca": {"port_number": 1456, "protocols": ["tcp", "udp"]},
    "valisys-lm": {"port_number": 1457, "protocols": ["tcp", "udp"]},
    "nrcabq-lm": {"port_number": 1458, "protocols": ["tcp", "udp"]},
    "proshare1": {"port_number": 1459, "protocols": ["tcp", "udp"]},
    "proshare2": {"port_number": 1460, "protocols": ["tcp", "udp"]},
    "ibm-wrless-lan": {"port_number": 1461, "protocols": ["tcp", "udp"]},
    "ibm_wrless_lan": {"port_number": 1461, "protocols": ["tcp", "udp"]},
    "world-lm": {"port_number": 1462, "protocols": ["tcp", "udp"]},
    "nucleus": {"port_number": 1463, "protocols": ["tcp", "udp"]},
    "msl-lmd": {"port_number": 1464, "protocols": ["tcp", "udp"]},
    "msl_lmd": {"port_number": 1464, "protocols": ["tcp", "udp"]},
    "pipes": {"port_number": 1465, "protocols": ["tcp", "udp"]},
    "oceansoft-lm": {"port_number": 1466, "protocols": ["tcp", "udp"]},
    "csdmbase": {"port_number": 1467, "protocols": ["tcp", "udp"]},
    "csdm": {"port_number": 1468, "protocols": ["tcp", "udp"]},
    "aal-lm": {"port_number": 1469, "protocols": ["tcp", "udp"]},
    "uaiact": {"port_number": 1470, "protocols": ["tcp", "udp"]},
    "csdmbase-secondary": {"port_number": 1471, "protocols": ["tcp", "udp"]},
    "csdm-secondary": {"port_number": 1472, "protocols": ["tcp", "udp"]},
    "openmath": {"port_number": 1473, "protocols": ["tcp", "udp"]},
    "telefinder": {"port_number": 1474, "protocols": ["tcp", "udp"]},
    "taligent-lm": {"port_number": 1475, "protocols": ["tcp", "udp"]},
    "clvm-cfg": {"port_number": 1476, "protocols": ["tcp", "udp"]},
    "ms-sna-server": {"port_number": 1477, "protocols": ["tcp", "udp"]},
    "ms-sna-base": {"port_number": 1478, "protocols": ["tcp", "udp"]},
    "dberegister": {"port_number": 1479, "protocols": ["tcp", "udp"]},
    "pacerforum": {"port_number": 1480, "protocols": ["tcp", "udp"]},
    "airs": {"port_number": 1481, "protocols": ["tcp", "udp"]},
    "miteksys-lm": {"port_number": 1482, "protocols": ["tcp", "udp"]},
    "afs": {"port_number": 1483, "protocols": ["tcp", "udp"]},
    "confluent": {"port_number": 1484, "protocols": ["tcp", "udp"]},
    "lansource": {"port_number": 1485, "protocols": ["tcp", "udp"]},
    "nms-topo-serv": {"port_number": 1486, "protocols": ["tcp", "udp"]},
    "nms_topo_serv": {"port_number": 1486, "protocols": ["tcp", "udp"]},
    "localinfosrvr": {"port_number": 1487, "protocols": ["tcp", "udp"]},
    "docstor": {"port_number": 1488, "protocols": ["tcp", "udp"]},
    "dmdocbroker": {"port_number": 1489, "protocols": ["tcp", "udp"]},
    "insitu-conf": {"port_number": 1490, "protocols": ["tcp", "udp"]},
    "stone-design-1": {"port_number": 1492, "protocols": ["tcp", "udp"]},
    "netmap-lm": {"port_number": 1493, "protocols": ["tcp", "udp"]},
    "netmap_lm": {"port_number": 1493, "protocols": ["tcp", "udp"]},
    "ica": {"port_number": 1494, "protocols": ["tcp", "udp"]},
    "cvc": {"port_number": 1495, "protocols": ["tcp", "udp"]},
    "liberty-lm": {"port_number": 1496, "protocols": ["tcp", "udp"]},
    "rfx-lm": {"port_number": 1497, "protocols": ["tcp", "udp"]},
    "sybase-sqlany": {"port_number": 1498, "protocols": ["tcp", "udp"]},
    "fhc": {"port_number": 1499, "protocols": ["tcp", "udp"]},
    "vlsi-lm": {"port_number": 1500, "protocols": ["tcp", "udp"]},
    "saiscm": {"port_number": 1501, "protocols": ["tcp", "udp"]},
    "shivadiscovery": {"port_number": 1502, "protocols": ["tcp", "udp"]},
    "imtc-mcs": {"port_number": 1503, "protocols": ["tcp", "udp"]},
    "evb-elm": {"port_number": 1504, "protocols": ["tcp", "udp"]},
    "funkproxy": {"port_number": 1505, "protocols": ["tcp", "udp"]},
    "utcd": {"port_number": 1506, "protocols": ["tcp", "udp"]},
    "symplex": {"port_number": 1507, "protocols": ["tcp", "udp"]},
    "diagmond": {"port_number": 1508, "protocols": ["tcp", "udp"]},
    "robcad-lm": {"port_number": 1509, "protocols": ["tcp", "udp"]},
    "mvx-lm": {"port_number": 1510, "protocols": ["tcp", "udp"]},
    "3l-l1": {"port_number": 1511, "protocols": ["tcp", "udp"]},
    "wins": {"port_number": 1512, "protocols": ["tcp", "udp"]},
    "fujitsu-dtc": {"port_number": 1513, "protocols": ["tcp", "udp"]},
    "fujitsu-dtcns": {"port_number": 1514, "protocols": ["tcp", "udp"]},
    "ifor-protocol": {"port_number": 1515, "protocols": ["tcp", "udp"]},
    "vpad": {"port_number": 1516, "protocols": ["tcp", "udp"]},
    "vpac": {"port_number": 1517, "protocols": ["tcp", "udp"]},
    "vpvd": {"port_number": 1518, "protocols": ["tcp", "udp"]},
    "vpvc": {"port_number": 1519, "protocols": ["tcp", "udp"]},
    "atm-zip-office": {"port_number": 1520, "protocols": ["tcp", "udp"]},
    "ncube-lm": {"port_number": 1521, "protocols": ["tcp", "udp"]},
    "ricardo-lm": {"port_number": 1522, "protocols": ["tcp", "udp"]},
    "cichild-lm": {"port_number": 1523, "protocols": ["tcp", "udp"]},
    "ingreslock": {"port_number": 1524, "protocols": ["tcp", "udp"]},
    "orasrv": {"port_number": 1525, "protocols": ["tcp", "udp"]},
    "prospero-np": {"port_number": 1525, "protocols": ["tcp", "udp"]},
    "pdap-np": {"port_number": 1526, "protocols": ["tcp", "udp"]},
    "tlisrv": {"port_number": 1527, "protocols": ["tcp", "udp"]},
    "norp": {"port_number": 1528, "protocols": ["tcp", "udp", "sctp"]},
    "coauthor": {"port_number": 1529, "protocols": ["tcp", "udp"]},
    "rap-service": {"port_number": 1530, "protocols": ["tcp", "udp"]},
    "rap-listen": {"port_number": 1531, "protocols": ["tcp", "udp"]},
    "miroconnect": {"port_number": 1532, "protocols": ["tcp", "udp"]},
    "virtual-places": {"port_number": 1533, "protocols": ["tcp", "udp"]},
    "micromuse-lm": {"port_number": 1534, "protocols": ["tcp", "udp"]},
    "ampr-info": {"port_number": 1535, "protocols": ["tcp", "udp"]},
    "ampr-inter": {"port_number": 1536, "protocols": ["tcp", "udp"]},
    "sdsc-lm": {"port_number": 1537, "protocols": ["tcp", "udp"]},
    "3ds-lm": {"port_number": 1538, "protocols": ["tcp", "udp"]},
    "intellistor-lm": {"port_number": 1539, "protocols": ["tcp", "udp"]},
    "rds": {"port_number": 1540, "protocols": ["tcp", "udp"]},
    "rds2": {"port_number": 1541, "protocols": ["tcp", "udp"]},
    "gridgen-elmd": {"port_number": 1542, "protocols": ["tcp", "udp"]},
    "simba-cs": {"port_number": 1543, "protocols": ["tcp", "udp"]},
    "aspeclmd": {"port_number": 1544, "protocols": ["tcp", "udp"]},
    "vistium-share": {"port_number": 1545, "protocols": ["tcp", "udp"]},
    "abbaccuray": {"port_number": 1546, "protocols": ["tcp", "udp"]},
    "laplink": {"port_number": 1547, "protocols": ["tcp", "udp"]},
    "axon-lm": {"port_number": 1548, "protocols": ["tcp", "udp"]},
    "shivahose": {"port_number": 1549, "protocols": ["tcp"]},
    "shivasound": {"port_number": 1549, "protocols": ["udp"]},
    "3m-image-lm": {"port_number": 1550, "protocols": ["tcp", "udp"]},
    "hecmtl-db": {"port_number": 1551, "protocols": ["tcp", "udp"]},
    "pciarray": {"port_number": 1552, "protocols": ["tcp", "udp"]},
    "sna-cs": {"port_number": 1553, "protocols": ["tcp", "udp"]},
    "caci-lm": {"port_number": 1554, "protocols": ["tcp", "udp"]},
    "livelan": {"port_number": 1555, "protocols": ["tcp", "udp"]},
    "veritas-pbx": {"port_number": 1556, "protocols": ["tcp", "udp"]},
    "veritas_pbx": {"port_number": 1556, "protocols": ["tcp", "udp"]},
    "arbortext-lm": {"port_number": 1557, "protocols": ["tcp", "udp"]},
    "xingmpeg": {"port_number": 1558, "protocols": ["tcp", "udp"]},
    "web2host": {"port_number": 1559, "protocols": ["tcp", "udp"]},
    "asci-val": {"port_number": 1560, "protocols": ["tcp", "udp"]},
    "facilityview": {"port_number": 1561, "protocols": ["tcp", "udp"]},
    "pconnectmgr": {"port_number": 1562, "protocols": ["tcp", "udp"]},
    "cadabra-lm": {"port_number": 1563, "protocols": ["tcp", "udp"]},
    "pay-per-view": {"port_number": 1564, "protocols": ["tcp", "udp"]},
    "winddlb": {"port_number": 1565, "protocols": ["tcp", "udp"]},
    "corelvideo": {"port_number": 1566, "protocols": ["tcp", "udp"]},
    "jlicelmd": {"port_number": 1567, "protocols": ["tcp", "udp"]},
    "tsspmap": {"port_number": 1568, "protocols": ["tcp", "udp"]},
    "ets": {"port_number": 1569, "protocols": ["tcp", "udp"]},
    "orbixd": {"port_number": 1570, "protocols": ["tcp", "udp"]},
    "rdb-dbs-disp": {"port_number": 1571, "protocols": ["tcp", "udp"]},
    "chip-lm": {"port_number": 1572, "protocols": ["tcp", "udp"]},
    "itscomm-ns": {"port_number": 1573, "protocols": ["tcp", "udp"]},
    "mvel-lm": {"port_number": 1574, "protocols": ["tcp", "udp"]},
    "oraclenames": {"port_number": 1575, "protocols": ["tcp", "udp"]},
    "moldflow-lm": {"port_number": 1576, "protocols": ["tcp", "udp"]},
    "hypercube-lm": {"port_number": 1577, "protocols": ["tcp", "udp"]},
    "jacobus-lm": {"port_number": 1578, "protocols": ["tcp", "udp"]},
    "ioc-sea-lm": {"port_number": 1579, "protocols": ["tcp", "udp"]},
    "tn-tl-r1": {"port_number": 1580, "protocols": ["tcp"]},
    "tn-tl-r2": {"port_number": 1580, "protocols": ["udp"]},
    "mil-2045-47001": {"port_number": 1581, "protocols": ["tcp", "udp"]},
    "msims": {"port_number": 1582, "protocols": ["tcp", "udp"]},
    "simbaexpress": {"port_number": 1583, "protocols": ["tcp", "udp"]},
    "tn-tl-fd2": {"port_number": 1584, "protocols": ["tcp", "udp"]},
    "intv": {"port_number": 1585, "protocols": ["tcp", "udp"]},
    "ibm-abtact": {"port_number": 1586, "protocols": ["tcp", "udp"]},
    "pra-elmd": {"port_number": 1587, "protocols": ["tcp", "udp"]},
    "pra_elmd": {"port_number": 1587, "protocols": ["tcp", "udp"]},
    "triquest-lm": {"port_number": 1588, "protocols": ["tcp", "udp"]},
    "vqp": {"port_number": 1589, "protocols": ["tcp", "udp"]},
    "gemini-lm": {"port_number": 1590, "protocols": ["tcp", "udp"]},
    "ncpm-pm": {"port_number": 1591, "protocols": ["tcp", "udp"]},
    "commonspace": {"port_number": 1592, "protocols": ["tcp", "udp"]},
    "mainsoft-lm": {"port_number": 1593, "protocols": ["tcp", "udp"]},
    "sixtrak": {"port_number": 1594, "protocols": ["tcp", "udp"]},
    "radio": {"port_number": 1595, "protocols": ["tcp", "udp"]},
    "radio-sm": {"port_number": 1596, "protocols": ["tcp"]},
    "radio-bc": {"port_number": 1596, "protocols": ["udp"]},
    "orbplus-iiop": {"port_number": 1597, "protocols": ["tcp", "udp"]},
    "picknfs": {"port_number": 1598, "protocols": ["tcp", "udp"]},
    "simbaservices": {"port_number": 1599, "protocols": ["tcp", "udp"]},
    "issd": {"port_number": 1600, "protocols": ["tcp", "udp"]},
    "aas": {"port_number": 1601, "protocols": ["tcp", "udp"]},
    "inspect": {"port_number": 1602, "protocols": ["tcp", "udp"]},
    "picodbc": {"port_number": 1603, "protocols": ["tcp", "udp"]},
    "icabrowser": {"port_number": 1604, "protocols": ["tcp", "udp"]},
    "slp": {"port_number": 1605, "protocols": ["tcp", "udp"]},
    "slm-api": {"port_number": 1606, "protocols": ["tcp", "udp"]},
    "stt": {"port_number": 1607, "protocols": ["tcp", "udp"]},
    "smart-lm": {"port_number": 1608, "protocols": ["tcp", "udp"]},
    "isysg-lm": {"port_number": 1609, "protocols": ["tcp", "udp"]},
    "taurus-wh": {"port_number": 1610, "protocols": ["tcp", "udp"]},
    "ill": {"port_number": 1611, "protocols": ["tcp", "udp"]},
    "netbill-trans": {"port_number": 1612, "protocols": ["tcp", "udp"]},
    "netbill-keyrep": {"port_number": 1613, "protocols": ["tcp", "udp"]},
    "netbill-cred": {"port_number": 1614, "protocols": ["tcp", "udp"]},
    "netbill-auth": {"port_number": 1615, "protocols": ["tcp", "udp"]},
    "netbill-prod": {"port_number": 1616, "protocols": ["tcp", "udp"]},
    "nimrod-agent": {"port_number": 1617, "protocols": ["tcp", "udp"]},
    "skytelnet": {"port_number": 1618, "protocols": ["tcp", "udp"]},
    "xs-openstorage": {"port_number": 1619, "protocols": ["tcp", "udp"]},
    "faxportwinport": {"port_number": 1620, "protocols": ["tcp", "udp"]},
    "softdataphone": {"port_number": 1621, "protocols": ["tcp", "udp"]},
    "ontime": {"port_number": 1622, "protocols": ["tcp", "udp"]},
    "jaleosnd": {"port_number": 1623, "protocols": ["tcp", "udp"]},
    "udp-sr-port": {"port_number": 1624, "protocols": ["tcp", "udp"]},
    "svs-omagent": {"port_number": 1625, "protocols": ["tcp", "udp"]},
    "shockwave": {"port_number": 1626, "protocols": ["tcp", "udp"]},
    "t128-gateway": {"port_number": 1627, "protocols": ["tcp", "udp"]},
    "lontalk-norm": {"port_number": 1628, "protocols": ["tcp", "udp"]},
    "lontalk-urgnt": {"port_number": 1629, "protocols": ["tcp", "udp"]},
    "oraclenet8cman": {"port_number": 1630, "protocols": ["tcp", "udp"]},
    "visitview": {"port_number": 1631, "protocols": ["tcp", "udp"]},
    "pammratc": {"port_number": 1632, "protocols": ["tcp", "udp"]},
    "pammrpc": {"port_number": 1633, "protocols": ["tcp", "udp"]},
    "loaprobe": {"port_number": 1634, "protocols": ["tcp", "udp"]},
    "edb-server1": {"port_number": 1635, "protocols": ["tcp", "udp"]},
    "isdc": {"port_number": 1636, "protocols": ["tcp", "udp"]},
    "islc": {"port_number": 1637, "protocols": ["tcp", "udp"]},
    "ismc": {"port_number": 1638, "protocols": ["tcp", "udp"]},
    "cert-initiator": {"port_number": 1639, "protocols": ["tcp", "udp"]},
    "cert-responder": {"port_number": 1640, "protocols": ["tcp", "udp"]},
    "invision": {"port_number": 1641, "protocols": ["tcp", "udp"]},
    "isis-am": {"port_number": 1642, "protocols": ["tcp", "udp"]},
    "isis-ambc": {"port_number": 1643, "protocols": ["tcp", "udp"]},
    "saiseh": {"port_number": 1644, "protocols": ["tcp", "udp"]},
    "sightline": {"port_number": 1645, "protocols": ["tcp", "udp"]},
    "sa-msg-port": {"port_number": 1646, "protocols": ["tcp", "udp"]},
    "rsap": {"port_number": 1647, "protocols": ["tcp", "udp"]},
    "concurrent-lm": {"port_number": 1648, "protocols": ["tcp", "udp"]},
    "kermit": {"port_number": 1649, "protocols": ["tcp", "udp"]},
    "nkd": {"port_number": 1650, "protocols": ["tcp", "udp"]},
    "shiva-confsrvr": {"port_number": 1651, "protocols": ["tcp", "udp"]},
    "shiva_confsrvr": {"port_number": 1651, "protocols": ["tcp", "udp"]},
    "xnmp": {"port_number": 1652, "protocols": ["tcp", "udp"]},
    "alphatech-lm": {"port_number": 1653, "protocols": ["tcp", "udp"]},
    "stargatealerts": {"port_number": 1654, "protocols": ["tcp", "udp"]},
    "dec-mbadmin": {"port_number": 1655, "protocols": ["tcp", "udp"]},
    "dec-mbadmin-h": {"port_number": 1656, "protocols": ["tcp", "udp"]},
    "fujitsu-mmpdc": {"port_number": 1657, "protocols": ["tcp", "udp"]},
    "sixnetudr": {"port_number": 1658, "protocols": ["tcp", "udp"]},
    "sg-lm": {"port_number": 1659, "protocols": ["tcp", "udp"]},
    "skip-mc-gikreq": {"port_number": 1660, "protocols": ["tcp", "udp"]},
    "netview-aix-1": {"port_number": 1661, "protocols": ["tcp", "udp"]},
    "netview-aix-2": {"port_number": 1662, "protocols": ["tcp", "udp"]},
    "netview-aix-3": {"port_number": 1663, "protocols": ["tcp", "udp"]},
    "netview-aix-4": {"port_number": 1664, "protocols": ["tcp", "udp"]},
    "netview-aix-5": {"port_number": 1665, "protocols": ["tcp", "udp"]},
    "netview-aix-6": {"port_number": 1666, "protocols": ["tcp", "udp"]},
    "netview-aix-7": {"port_number": 1667, "protocols": ["tcp", "udp"]},
    "netview-aix-8": {"port_number": 1668, "protocols": ["tcp", "udp"]},
    "netview-aix-9": {"port_number": 1669, "protocols": ["tcp", "udp"]},
    "netview-aix-10": {"port_number": 1670, "protocols": ["tcp", "udp"]},
    "netview-aix-11": {"port_number": 1671, "protocols": ["tcp", "udp"]},
    "netview-aix-12": {"port_number": 1672, "protocols": ["tcp", "udp"]},
    "proshare-mc-1": {"port_number": 1673, "protocols": ["tcp", "udp"]},
    "proshare-mc-2": {"port_number": 1674, "protocols": ["tcp", "udp"]},
    "pdp": {"port_number": 1675, "protocols": ["tcp", "udp"]},
    "netcomm1": {"port_number": 1676, "protocols": ["tcp"]},
    "netcomm2": {"port_number": 1676, "protocols": ["udp"]},
    "groupwise": {"port_number": 1677, "protocols": ["tcp", "udp"]},
    "prolink": {"port_number": 1678, "protocols": ["tcp", "udp"]},
    "darcorp-lm": {"port_number": 1679, "protocols": ["tcp", "udp"]},
    "microcom-sbp": {"port_number": 1680, "protocols": ["tcp", "udp"]},
    "sd-elmd": {"port_number": 1681, "protocols": ["tcp", "udp"]},
    "lanyon-lantern": {"port_number": 1682, "protocols": ["tcp", "udp"]},
    "ncpm-hip": {"port_number": 1683, "protocols": ["tcp", "udp"]},
    "snaresecure": {"port_number": 1684, "protocols": ["tcp", "udp"]},
    "n2nremote": {"port_number": 1685, "protocols": ["tcp", "udp"]},
    "cvmon": {"port_number": 1686, "protocols": ["tcp", "udp"]},
    "nsjtp-ctrl": {"port_number": 1687, "protocols": ["tcp", "udp"]},
    "nsjtp-data": {"port_number": 1688, "protocols": ["tcp", "udp"]},
    "firefox": {"port_number": 1689, "protocols": ["tcp", "udp"]},
    "ng-umds": {"port_number": 1690, "protocols": ["tcp", "udp"]},
    "empire-empuma": {"port_number": 1691, "protocols": ["tcp", "udp"]},
    "sstsys-lm": {"port_number": 1692, "protocols": ["tcp", "udp"]},
    "rrirtr": {"port_number": 1693, "protocols": ["tcp", "udp"]},
    "rrimwm": {"port_number": 1694, "protocols": ["tcp", "udp"]},
    "rrilwm": {"port_number": 1695, "protocols": ["tcp", "udp"]},
    "rrifmm": {"port_number": 1696, "protocols": ["tcp", "udp"]},
    "rrisat": {"port_number": 1697, "protocols": ["tcp", "udp"]},
    "rsvp-encap-1": {"port_number": 1698, "protocols": ["tcp", "udp"]},
    "rsvp-encap-2": {"port_number": 1699, "protocols": ["tcp", "udp"]},
    "mps-raft": {"port_number": 1700, "protocols": ["tcp", "udp"]},
    "l2f": {"port_number": 1701, "protocols": ["tcp", "udp"]},
    "l2tp": {"port_number": 1701, "protocols": ["tcp", "udp"]},
    "deskshare": {"port_number": 1702, "protocols": ["tcp", "udp"]},
    "hb-engine": {"port_number": 1703, "protocols": ["tcp", "udp"]},
    "bcs-broker": {"port_number": 1704, "protocols": ["tcp", "udp"]},
    "slingshot": {"port_number": 1705, "protocols": ["tcp", "udp"]},
    "jetform": {"port_number": 1706, "protocols": ["tcp", "udp"]},
    "vdmplay": {"port_number": 1707, "protocols": ["tcp", "udp"]},
    "gat-lmd": {"port_number": 1708, "protocols": ["tcp", "udp"]},
    "centra": {"port_number": 1709, "protocols": ["tcp", "udp"]},
    "impera": {"port_number": 1710, "protocols": ["tcp", "udp"]},
    "pptconference": {"port_number": 1711, "protocols": ["tcp", "udp"]},
    "registrar": {"port_number": 1712, "protocols": ["tcp", "udp"]},
    "conferencetalk": {"port_number": 1713, "protocols": ["tcp", "udp"]},
    "sesi-lm": {"port_number": 1714, "protocols": ["tcp", "udp"]},
    "houdini-lm": {"port_number": 1715, "protocols": ["tcp", "udp"]},
    "xmsg": {"port_number": 1716, "protocols": ["tcp", "udp"]},
    "fj-hdnet": {"port_number": 1717, "protocols": ["tcp", "udp"]},
    "h323gatedisc": {"port_number": 1718, "protocols": ["tcp", "udp"]},
    "h323gatestat": {"port_number": 1719, "protocols": ["tcp", "udp"]},
    "h323hostcall": {"port_number": 1720, "protocols": ["tcp", "udp", "sctp"]},
    "caicci": {"port_number": 1721, "protocols": ["tcp", "udp"]},
    "hks-lm": {"port_number": 1722, "protocols": ["tcp", "udp"]},
    "pptp": {"port_number": 1723, "protocols": ["tcp", "udp"]},
    "csbphonemaster": {"port_number": 1724, "protocols": ["tcp", "udp"]},
    "iden-ralp": {"port_number": 1725, "protocols": ["tcp", "udp"]},
    "iberiagames": {"port_number": 1726, "protocols": ["tcp", "udp"]},
    "winddx": {"port_number": 1727, "protocols": ["tcp", "udp"]},
    "telindus": {"port_number": 1728, "protocols": ["tcp", "udp"]},
    "citynl": {"port_number": 1729, "protocols": ["tcp", "udp"]},
    "roketz": {"port_number": 1730, "protocols": ["tcp", "udp"]},
    "msiccp": {"port_number": 1731, "protocols": ["tcp", "udp"]},
    "proxim": {"port_number": 1732, "protocols": ["tcp", "udp"]},
    "siipat": {"port_number": 1733, "protocols": ["tcp", "udp"]},
    "cambertx-lm": {"port_number": 1734, "protocols": ["tcp", "udp"]},
    "privatechat": {"port_number": 1735, "protocols": ["tcp", "udp"]},
    "street-stream": {"port_number": 1736, "protocols": ["tcp", "udp"]},
    "ultimad": {"port_number": 1737, "protocols": ["tcp", "udp"]},
    "gamegen1": {"port_number": 1738, "protocols": ["tcp", "udp"]},
    "webaccess": {"port_number": 1739, "protocols": ["tcp", "udp"]},
    "encore": {"port_number": 1740, "protocols": ["tcp", "udp"]},
    "cisco-net-mgmt": {"port_number": 1741, "protocols": ["tcp", "udp"]},
    "3Com-nsd": {"port_number": 1742, "protocols": ["tcp", "udp"]},
    "cinegrfx-lm": {"port_number": 1743, "protocols": ["tcp", "udp"]},
    "ncpm-ft": {"port_number": 1744, "protocols": ["tcp", "udp"]},
    "remote-winsock": {"port_number": 1745, "protocols": ["tcp", "udp"]},
    "ftrapid-1": {"port_number": 1746, "protocols": ["tcp", "udp"]},
    "ftrapid-2": {"port_number": 1747, "protocols": ["tcp", "udp"]},
    "oracle-em1": {"port_number": 1748, "protocols": ["tcp", "udp"]},
    "aspen-services": {"port_number": 1749, "protocols": ["tcp", "udp"]},
    "sslp": {"port_number": 1750, "protocols": ["tcp", "udp"]},
    "swiftnet": {"port_number": 1751, "protocols": ["tcp", "udp"]},
    "lofr-lm": {"port_number": 1752, "protocols": ["tcp", "udp"]},
    "predatar-comms": {"port_number": 1753, "protocols": ["tcp"]},
    "oracle-em2": {"port_number": 1754, "protocols": ["tcp", "udp"]},
    "ms-streaming": {"port_number": 1755, "protocols": ["tcp", "udp"]},
    "capfast-lmd": {"port_number": 1756, "protocols": ["tcp", "udp"]},
    "cnhrp": {"port_number": 1757, "protocols": ["tcp", "udp"]},
    "tftp-mcast": {"port_number": 1758, "protocols": ["tcp", "udp"]},
    "spss-lm": {"port_number": 1759, "protocols": ["tcp", "udp"]},
    "www-ldap-gw": {"port_number": 1760, "protocols": ["tcp", "udp"]},
    "cft-0": {"port_number": 1761, "protocols": ["tcp", "udp"]},
    "cft-1": {"port_number": 1762, "protocols": ["tcp", "udp"]},
    "cft-2": {"port_number": 1763, "protocols": ["tcp", "udp"]},
    "cft-3": {"port_number": 1764, "protocols": ["tcp", "udp"]},
    "cft-4": {"port_number": 1765, "protocols": ["tcp", "udp"]},
    "cft-5": {"port_number": 1766, "protocols": ["tcp", "udp"]},
    "cft-6": {"port_number": 1767, "protocols": ["tcp", "udp"]},
    "cft-7": {"port_number": 1768, "protocols": ["tcp", "udp"]},
    "bmc-net-adm": {"port_number": 1769, "protocols": ["tcp", "udp"]},
    "bmc-net-svc": {"port_number": 1770, "protocols": ["tcp", "udp"]},
    "vaultbase": {"port_number": 1771, "protocols": ["tcp", "udp"]},
    "essweb-gw": {"port_number": 1772, "protocols": ["tcp", "udp"]},
    "kmscontrol": {"port_number": 1773, "protocols": ["tcp", "udp"]},
    "global-dtserv": {"port_number": 1774, "protocols": ["tcp", "udp"]},
    "vdab": {"port_number": 1775, "protocols": ["tcp"]},
    "femis": {"port_number": 1776, "protocols": ["tcp", "udp"]},
    "powerguardian": {"port_number": 1777, "protocols": ["tcp", "udp"]},
    "prodigy-intrnet": {"port_number": 1778, "protocols": ["tcp", "udp"]},
    "pharmasoft": {"port_number": 1779, "protocols": ["tcp", "udp"]},
    "dpkeyserv": {"port_number": 1780, "protocols": ["tcp", "udp"]},
    "answersoft-lm": {"port_number": 1781, "protocols": ["tcp", "udp"]},
    "hp-hcip": {"port_number": 1782, "protocols": ["tcp", "udp"]},
    "finle-lm": {"port_number": 1784, "protocols": ["tcp", "udp"]},
    "windlm": {"port_number": 1785, "protocols": ["tcp", "udp"]},
    "funk-logger": {"port_number": 1786, "protocols": ["tcp", "udp"]},
    "funk-license": {"port_number": 1787, "protocols": ["tcp", "udp"]},
    "psmond": {"port_number": 1788, "protocols": ["tcp", "udp"]},
    "hello": {"port_number": 1789, "protocols": ["tcp", "udp"]},
    "nmsp-secondary": {"port_number": 1790, "protocols": ["tcp", "udp"]},
    "ea1": {"port_number": 1791, "protocols": ["tcp", "udp"]},
    "ibm-dt-2": {"port_number": 1792, "protocols": ["tcp", "udp"]},
    "rsc-robot": {"port_number": 1793, "protocols": ["tcp", "udp"]},
    "cera-bcm": {"port_number": 1794, "protocols": ["tcp", "udp"]},
    "dpi-proxy": {"port_number": 1795, "protocols": ["tcp", "udp"]},
    "vocaltec-admin": {"port_number": 1796, "protocols": ["tcp", "udp"]},
    "uma-secondary": {"port_number": 1797, "protocols": ["tcp", "udp"]},
    "etp": {"port_number": 1798, "protocols": ["tcp", "udp"]},
    "netrisk": {"port_number": 1799, "protocols": ["tcp", "udp"]},
    "ansys-lm": {"port_number": 1800, "protocols": ["tcp", "udp"]},
    "msmq": {"port_number": 1801, "protocols": ["tcp", "udp"]},
    "concomp1": {"port_number": 1802, "protocols": ["tcp", "udp"]},
    "hp-hcip-gwy": {"port_number": 1803, "protocols": ["tcp", "udp"]},
    "enl": {"port_number": 1804, "protocols": ["tcp", "udp"]},
    "enl-name": {"port_number": 1805, "protocols": ["tcp", "udp"]},
    "musiconline": {"port_number": 1806, "protocols": ["tcp", "udp"]},
    "fhsp": {"port_number": 1807, "protocols": ["tcp", "udp"]},
    "oracle-vp2": {"port_number": 1808, "protocols": ["tcp", "udp"]},
    "oracle-vp1": {"port_number": 1809, "protocols": ["tcp", "udp"]},
    "jerand-lm": {"port_number": 1810, "protocols": ["tcp", "udp"]},
    "scientia-sdb": {"port_number": 1811, "protocols": ["tcp", "udp"]},
    "radius": {"port_number": 1812, "protocols": ["tcp", "udp"]},
    "radius-acct": {"port_number": 1813, "protocols": ["tcp", "udp"]},
    "tdp-suite": {"port_number": 1814, "protocols": ["tcp", "udp"]},
    "mmpft": {"port_number": 1815, "protocols": ["tcp", "udp"]},
    "harp": {"port_number": 1816, "protocols": ["tcp", "udp"]},
    "rkb-oscs": {"port_number": 1817, "protocols": ["tcp", "udp"]},
    "etftp": {"port_number": 1818, "protocols": ["tcp", "udp"]},
    "plato-lm": {"port_number": 1819, "protocols": ["tcp", "udp"]},
    "mcagent": {"port_number": 1820, "protocols": ["tcp", "udp"]},
    "donnyworld": {"port_number": 1821, "protocols": ["tcp", "udp"]},
    "es-elmd": {"port_number": 1822, "protocols": ["tcp", "udp"]},
    "unisys-lm": {"port_number": 1823, "protocols": ["tcp", "udp"]},
    "metrics-pas": {"port_number": 1824, "protocols": ["tcp", "udp"]},
    "direcpc-video": {"port_number": 1825, "protocols": ["tcp", "udp"]},
    "ardt": {"port_number": 1826, "protocols": ["tcp", "udp"]},
    "asi": {"port_number": 1827, "protocols": ["tcp", "udp"]},
    "itm-mcell-u": {"port_number": 1828, "protocols": ["tcp", "udp"]},
    "optika-emedia": {"port_number": 1829, "protocols": ["tcp", "udp"]},
    "net8-cman": {"port_number": 1830, "protocols": ["tcp", "udp"]},
    "myrtle": {"port_number": 1831, "protocols": ["tcp", "udp"]},
    "tht-treasure": {"port_number": 1832, "protocols": ["tcp", "udp"]},
    "udpradio": {"port_number": 1833, "protocols": ["tcp", "udp"]},
    "ardusuni": {"port_number": 1834, "protocols": ["tcp", "udp"]},
    "ardusmul": {"port_number": 1835, "protocols": ["tcp", "udp"]},
    "ste-smsc": {"port_number": 1836, "protocols": ["tcp", "udp"]},
    "csoft1": {"port_number": 1837, "protocols": ["tcp", "udp"]},
    "talnet": {"port_number": 1838, "protocols": ["tcp", "udp"]},
    "netopia-vo1": {"port_number": 1839, "protocols": ["tcp", "udp"]},
    "netopia-vo2": {"port_number": 1840, "protocols": ["tcp", "udp"]},
    "netopia-vo3": {"port_number": 1841, "protocols": ["tcp", "udp"]},
    "netopia-vo4": {"port_number": 1842, "protocols": ["tcp", "udp"]},
    "netopia-vo5": {"port_number": 1843, "protocols": ["tcp", "udp"]},
    "direcpc-dll": {"port_number": 1844, "protocols": ["tcp", "udp"]},
    "altalink": {"port_number": 1845, "protocols": ["tcp", "udp"]},
    "tunstall-pnc": {"port_number": 1846, "protocols": ["tcp", "udp"]},
    "slp-notify": {"port_number": 1847, "protocols": ["tcp", "udp"]},
    "fjdocdist": {"port_number": 1848, "protocols": ["tcp", "udp"]},
    "alpha-sms": {"port_number": 1849, "protocols": ["tcp", "udp"]},
    "gsi": {"port_number": 1850, "protocols": ["tcp", "udp"]},
    "ctcd": {"port_number": 1851, "protocols": ["tcp", "udp"]},
    "virtual-time": {"port_number": 1852, "protocols": ["tcp", "udp"]},
    "vids-avtp": {"port_number": 1853, "protocols": ["tcp", "udp"]},
    "buddy-draw": {"port_number": 1854, "protocols": ["tcp", "udp"]},
    "fiorano-rtrsvc": {"port_number": 1855, "protocols": ["tcp", "udp"]},
    "fiorano-msgsvc": {"port_number": 1856, "protocols": ["tcp", "udp"]},
    "datacaptor": {"port_number": 1857, "protocols": ["tcp", "udp"]},
    "privateark": {"port_number": 1858, "protocols": ["tcp", "udp"]},
    "gammafetchsvr": {"port_number": 1859, "protocols": ["tcp", "udp"]},
    "sunscalar-svc": {"port_number": 1860, "protocols": ["tcp", "udp"]},
    "lecroy-vicp": {"port_number": 1861, "protocols": ["tcp", "udp"]},
    "mysql-cm-agent": {"port_number": 1862, "protocols": ["tcp", "udp"]},
    "msnp": {"port_number": 1863, "protocols": ["tcp", "udp"]},
    "paradym-31port": {"port_number": 1864, "protocols": ["tcp", "udp"]},
    "entp": {"port_number": 1865, "protocols": ["tcp", "udp"]},
    "swrmi": {"port_number": 1866, "protocols": ["tcp", "udp"]},
    "udrive": {"port_number": 1867, "protocols": ["tcp", "udp"]},
    "viziblebrowser": {"port_number": 1868, "protocols": ["tcp", "udp"]},
    "transact": {"port_number": 1869, "protocols": ["tcp", "udp"]},
    "sunscalar-dns": {"port_number": 1870, "protocols": ["tcp", "udp"]},
    "canocentral0": {"port_number": 1871, "protocols": ["tcp", "udp"]},
    "canocentral1": {"port_number": 1872, "protocols": ["tcp", "udp"]},
    "fjmpjps": {"port_number": 1873, "protocols": ["tcp", "udp"]},
    "fjswapsnp": {"port_number": 1874, "protocols": ["tcp", "udp"]},
    "westell-stats": {"port_number": 1875, "protocols": ["tcp", "udp"]},
    "ewcappsrv": {"port_number": 1876, "protocols": ["tcp", "udp"]},
    "hp-webqosdb": {"port_number": 1877, "protocols": ["tcp", "udp"]},
    "drmsmc": {"port_number": 1878, "protocols": ["tcp", "udp"]},
    "nettgain-nms": {"port_number": 1879, "protocols": ["tcp", "udp"]},
    "vsat-control": {"port_number": 1880, "protocols": ["tcp", "udp"]},
    "ibm-mqseries2": {"port_number": 1881, "protocols": ["tcp", "udp"]},
    "ecsqdmn": {"port_number": 1882, "protocols": ["tcp", "udp"]},
    "mqtt": {"port_number": 1883, "protocols": ["tcp", "udp"]},
    "idmaps": {"port_number": 1884, "protocols": ["tcp", "udp"]},
    "vrtstrapserver": {"port_number": 1885, "protocols": ["tcp", "udp"]},
    "leoip": {"port_number": 1886, "protocols": ["tcp", "udp"]},
    "filex-lport": {"port_number": 1887, "protocols": ["tcp", "udp"]},
    "ncconfig": {"port_number": 1888, "protocols": ["tcp", "udp"]},
    "unify-adapter": {"port_number": 1889, "protocols": ["tcp", "udp"]},
    "wilkenlistener": {"port_number": 1890, "protocols": ["tcp", "udp"]},
    "childkey-notif": {"port_number": 1891, "protocols": ["tcp", "udp"]},
    "childkey-ctrl": {"port_number": 1892, "protocols": ["tcp", "udp"]},
    "elad": {"port_number": 1893, "protocols": ["tcp", "udp"]},
    "o2server-port": {"port_number": 1894, "protocols": ["tcp", "udp"]},
    "b-novative-ls": {"port_number": 1896, "protocols": ["tcp", "udp"]},
    "metaagent": {"port_number": 1897, "protocols": ["tcp", "udp"]},
    "cymtec-port": {"port_number": 1898, "protocols": ["tcp", "udp"]},
    "mc2studios": {"port_number": 1899, "protocols": ["tcp", "udp"]},
    "ssdp": {"port_number": 1900, "protocols": ["tcp", "udp"]},
    "fjicl-tep-a": {"port_number": 1901, "protocols": ["tcp", "udp"]},
    "fjicl-tep-b": {"port_number": 1902, "protocols": ["tcp", "udp"]},
    "linkname": {"port_number": 1903, "protocols": ["tcp", "udp"]},
    "fjicl-tep-c": {"port_number": 1904, "protocols": ["tcp", "udp"]},
    "sugp": {"port_number": 1905, "protocols": ["tcp", "udp"]},
    "tpmd": {"port_number": 1906, "protocols": ["tcp", "udp"]},
    "intrastar": {"port_number": 1907, "protocols": ["tcp", "udp"]},
    "dawn": {"port_number": 1908, "protocols": ["tcp", "udp"]},
    "global-wlink": {"port_number": 1909, "protocols": ["tcp", "udp"]},
    "ultrabac": {"port_number": 1910, "protocols": ["tcp", "udp"]},
    "mtp": {"port_number": 1911, "protocols": ["tcp", "udp"]},
    "rhp-iibp": {"port_number": 1912, "protocols": ["tcp", "udp"]},
    "armadp": {"port_number": 1913, "protocols": ["tcp", "udp"]},
    "elm-momentum": {"port_number": 1914, "protocols": ["tcp", "udp"]},
    "facelink": {"port_number": 1915, "protocols": ["tcp", "udp"]},
    "persona": {"port_number": 1916, "protocols": ["tcp", "udp"]},
    "noagent": {"port_number": 1917, "protocols": ["tcp", "udp"]},
    "can-nds": {"port_number": 1918, "protocols": ["tcp", "udp"]},
    "can-dch": {"port_number": 1919, "protocols": ["tcp", "udp"]},
    "can-ferret": {"port_number": 1920, "protocols": ["tcp", "udp"]},
    "noadmin": {"port_number": 1921, "protocols": ["tcp", "udp"]},
    "tapestry": {"port_number": 1922, "protocols": ["tcp", "udp"]},
    "spice": {"port_number": 1923, "protocols": ["tcp", "udp"]},
    "xiip": {"port_number": 1924, "protocols": ["tcp", "udp"]},
    "discovery-port": {"port_number": 1925, "protocols": ["tcp", "udp"]},
    "egs": {"port_number": 1926, "protocols": ["tcp", "udp"]},
    "videte-cipc": {"port_number": 1927, "protocols": ["tcp", "udp"]},
    "emsd-port": {"port_number": 1928, "protocols": ["tcp", "udp"]},
    "bandwiz-system": {"port_number": 1929, "protocols": ["tcp", "udp"]},
    "driveappserver": {"port_number": 1930, "protocols": ["tcp", "udp"]},
    "amdsched": {"port_number": 1931, "protocols": ["tcp", "udp"]},
    "ctt-broker": {"port_number": 1932, "protocols": ["tcp", "udp"]},
    "xmapi": {"port_number": 1933, "protocols": ["tcp", "udp"]},
    "xaapi": {"port_number": 1934, "protocols": ["tcp", "udp"]},
    "macromedia-fcs": {"port_number": 1935, "protocols": ["tcp", "udp"]},
    "jetcmeserver": {"port_number": 1936, "protocols": ["tcp", "udp"]},
    "jwserver": {"port_number": 1937, "protocols": ["tcp", "udp"]},
    "jwclient": {"port_number": 1938, "protocols": ["tcp", "udp"]},
    "jvserver": {"port_number": 1939, "protocols": ["tcp", "udp"]},
    "jvclient": {"port_number": 1940, "protocols": ["tcp", "udp"]},
    "dic-aida": {"port_number": 1941, "protocols": ["tcp", "udp"]},
    "res": {"port_number": 1942, "protocols": ["tcp", "udp"]},
    "beeyond-media": {"port_number": 1943, "protocols": ["tcp", "udp"]},
    "close-combat": {"port_number": 1944, "protocols": ["tcp", "udp"]},
    "dialogic-elmd": {"port_number": 1945, "protocols": ["tcp", "udp"]},
    "tekpls": {"port_number": 1946, "protocols": ["tcp", "udp"]},
    "sentinelsrm": {"port_number": 1947, "protocols": ["tcp", "udp"]},
    "eye2eye": {"port_number": 1948, "protocols": ["tcp", "udp"]},
    "ismaeasdaqlive": {"port_number": 1949, "protocols": ["tcp", "udp"]},
    "ismaeasdaqtest": {"port_number": 1950, "protocols": ["tcp", "udp"]},
    "bcs-lmserver": {"port_number": 1951, "protocols": ["tcp", "udp"]},
    "mpnjsc": {"port_number": 1952, "protocols": ["tcp", "udp"]},
    "rapidbase": {"port_number": 1953, "protocols": ["tcp", "udp"]},
    "abr-api": {"port_number": 1954, "protocols": ["tcp", "udp"]},
    "abr-secure": {"port_number": 1955, "protocols": ["tcp", "udp"]},
    "vrtl-vmf-ds": {"port_number": 1956, "protocols": ["tcp", "udp"]},
    "unix-status": {"port_number": 1957, "protocols": ["tcp", "udp"]},
    "dxadmind": {"port_number": 1958, "protocols": ["tcp", "udp"]},
    "simp-all": {"port_number": 1959, "protocols": ["tcp", "udp"]},
    "nasmanager": {"port_number": 1960, "protocols": ["tcp", "udp"]},
    "bts-appserver": {"port_number": 1961, "protocols": ["tcp", "udp"]},
    "biap-mp": {"port_number": 1962, "protocols": ["tcp", "udp"]},
    "webmachine": {"port_number": 1963, "protocols": ["tcp", "udp"]},
    "solid-e-engine": {"port_number": 1964, "protocols": ["tcp", "udp"]},
    "tivoli-npm": {"port_number": 1965, "protocols": ["tcp", "udp"]},
    "slush": {"port_number": 1966, "protocols": ["tcp", "udp"]},
    "sns-quote": {"port_number": 1967, "protocols": ["tcp", "udp"]},
    "lipsinc": {"port_number": 1968, "protocols": ["tcp", "udp"]},
    "lipsinc1": {"port_number": 1969, "protocols": ["tcp", "udp"]},
    "netop-rc": {"port_number": 1970, "protocols": ["tcp", "udp"]},
    "netop-school": {"port_number": 1971, "protocols": ["tcp", "udp"]},
    "intersys-cache": {"port_number": 1972, "protocols": ["tcp", "udp"]},
    "dlsrap": {"port_number": 1973, "protocols": ["tcp", "udp"]},
    "drp": {"port_number": 1974, "protocols": ["tcp", "udp"]},
    "tcoflashagent": {"port_number": 1975, "protocols": ["tcp", "udp"]},
    "tcoregagent": {"port_number": 1976, "protocols": ["tcp", "udp"]},
    "tcoaddressbook": {"port_number": 1977, "protocols": ["tcp", "udp"]},
    "unisql": {"port_number": 1978, "protocols": ["tcp", "udp"]},
    "unisql-java": {"port_number": 1979, "protocols": ["tcp", "udp"]},
    "pearldoc-xact": {"port_number": 1980, "protocols": ["tcp", "udp"]},
    "p2pq": {"port_number": 1981, "protocols": ["tcp", "udp"]},
    "estamp": {"port_number": 1982, "protocols": ["tcp", "udp"]},
    "lhtp": {"port_number": 1983, "protocols": ["tcp", "udp"]},
    "bb": {"port_number": 1984, "protocols": ["tcp", "udp"]},
    "hsrp": {"port_number": 1985, "protocols": ["tcp", "udp"]},
    "licensedaemon": {"port_number": 1986, "protocols": ["tcp", "udp"]},
    "tr-rsrb-p1": {"port_number": 1987, "protocols": ["tcp", "udp"]},
    "tr-rsrb-p2": {"port_number": 1988, "protocols": ["tcp", "udp"]},
    "tr-rsrb-p3": {"port_number": 1989, "protocols": ["tcp", "udp"]},
    "mshnet": {"port_number": 1989, "protocols": ["tcp", "udp"]},
    "stun-p1": {"port_number": 1990, "protocols": ["tcp", "udp"]},
    "stun-p2": {"port_number": 1991, "protocols": ["tcp", "udp"]},
    "stun-p3": {"port_number": 1992, "protocols": ["tcp", "udp"]},
    "ipsendmsg": {"port_number": 1992, "protocols": ["tcp", "udp"]},
    "snmp-tcp-port": {"port_number": 1993, "protocols": ["tcp", "udp"]},
    "stun-port": {"port_number": 1994, "protocols": ["tcp", "udp"]},
    "perf-port": {"port_number": 1995, "protocols": ["tcp", "udp"]},
    "tr-rsrb-port": {"port_number": 1996, "protocols": ["tcp", "udp"]},
    "gdp-port": {"port_number": 1997, "protocols": ["tcp", "udp"]},
    "x25-svc-port": {"port_number": 1998, "protocols": ["tcp", "udp"]},
    "tcp-id-port": {"port_number": 1999, "protocols": ["tcp", "udp"]},
    "cisco-sccp": {"port_number": 2000, "protocols": ["tcp", "udp"]},
    "dc": {"port_number": 2001, "protocols": ["tcp"]},
    "wizard": {"port_number": 2001, "protocols": ["udp"]},
    "globe": {"port_number": 2002, "protocols": ["tcp", "udp"]},
    "brutus": {"port_number": 2003, "protocols": ["tcp", "udp"]},
    "mailbox": {"port_number": 2004, "protocols": ["tcp"]},
    "emce": {"port_number": 2004, "protocols": ["udp"]},
    "berknet": {"port_number": 2005, "protocols": ["tcp"]},
    "oracle": {"port_number": 2005, "protocols": ["udp"]},
    "invokator": {"port_number": 2006, "protocols": ["tcp"]},
    "raid-cd": {"port_number": 2006, "protocols": ["udp"]},
    "dectalk": {"port_number": 2007, "protocols": ["tcp"]},
    "raid-am": {"port_number": 2007, "protocols": ["udp"]},
    "conf": {"port_number": 2008, "protocols": ["tcp"]},
    "terminaldb": {"port_number": 2008, "protocols": ["udp"]},
    "news": {"port_number": 2009, "protocols": ["tcp"]},
    "whosockami": {"port_number": 2009, "protocols": ["udp"]},
    "search": {"port_number": 2010, "protocols": ["tcp"]},
    "pipe-server": {"port_number": 2010, "protocols": ["udp"]},
    "pipe_server": {"port_number": 2010, "protocols": ["udp"]},
    "raid-cc": {"port_number": 2011, "protocols": ["tcp"]},
    "servserv": {"port_number": 2011, "protocols": ["udp"]},
    "ttyinfo": {"port_number": 2012, "protocols": ["tcp"]},
    "raid-ac": {"port_number": 2012, "protocols": ["udp"]},
    "raid-am-secondary": {"port_number": 2013, "protocols": ["tcp"]},
    "raid-cd-secondary": {"port_number": 2013, "protocols": ["udp"]},
    "troff": {"port_number": 2014, "protocols": ["tcp"]},
    "raid-sf": {"port_number": 2014, "protocols": ["udp"]},
    "cypress": {"port_number": 2015, "protocols": ["tcp"]},
    "raid-cs": {"port_number": 2015, "protocols": ["udp"]},
    "bootserver": {"port_number": 2016, "protocols": ["tcp", "udp"]},
    "cypress-stat": {"port_number": 2017, "protocols": ["tcp"]},
    "bootclient": {"port_number": 2017, "protocols": ["udp"]},
    "terminaldb-secondary": {"port_number": 2018, "protocols": ["tcp"]},
    "rellpack": {"port_number": 2018, "protocols": ["udp"]},
    "whosockami-secondary": {"port_number": 2019, "protocols": ["tcp"]},
    "about": {"port_number": 2019, "protocols": ["udp"]},
    "xinupageserver": {"port_number": 2020, "protocols": ["tcp", "udp"]},
    "servexec": {"port_number": 2021, "protocols": ["tcp"]},
    "xinuexpansion1": {"port_number": 2021, "protocols": ["udp"]},
    "down": {"port_number": 2022, "protocols": ["tcp"]},
    "xinuexpansion2": {"port_number": 2022, "protocols": ["udp"]},
    "xinuexpansion3": {"port_number": 2023, "protocols": ["tcp", "udp"]},
    "xinuexpansion4": {"port_number": 2024, "protocols": ["tcp", "udp"]},
    "ellpack": {"port_number": 2025, "protocols": ["tcp"]},
    "xribs": {"port_number": 2025, "protocols": ["udp"]},
    "scrabble": {"port_number": 2026, "protocols": ["tcp", "udp"]},
    "shadowserver": {"port_number": 2027, "protocols": ["tcp", "udp"]},
    "submitserver": {"port_number": 2028, "protocols": ["tcp", "udp"]},
    "hsrpv6": {"port_number": 2029, "protocols": ["tcp", "udp"]},
    "device2": {"port_number": 2030, "protocols": ["tcp", "udp"]},
    "mobrien-chat": {"port_number": 2031, "protocols": ["tcp", "udp"]},
    "blackboard": {"port_number": 2032, "protocols": ["tcp", "udp"]},
    "glogger": {"port_number": 2033, "protocols": ["tcp", "udp"]},
    "scoremgr": {"port_number": 2034, "protocols": ["tcp", "udp"]},
    "imsldoc": {"port_number": 2035, "protocols": ["tcp", "udp"]},
    "e-dpnet": {"port_number": 2036, "protocols": ["tcp", "udp"]},
    "applus": {"port_number": 2037, "protocols": ["tcp", "udp"]},
    "objectmanager": {"port_number": 2038, "protocols": ["tcp", "udp"]},
    "prizma": {"port_number": 2039, "protocols": ["tcp", "udp"]},
    "lam": {"port_number": 2040, "protocols": ["tcp", "udp"]},
    "interbase": {"port_number": 2041, "protocols": ["tcp", "udp"]},
    "isis": {"port_number": 2042, "protocols": ["tcp", "udp"]},
    "isis-bcast": {"port_number": 2043, "protocols": ["tcp", "udp"]},
    "rimsl": {"port_number": 2044, "protocols": ["tcp", "udp"]},
    "cdfunc": {"port_number": 2045, "protocols": ["tcp", "udp"]},
    "sdfunc": {"port_number": 2046, "protocols": ["tcp", "udp"]},
    "dls-secondary": {"port_number": 2047, "protocols": ["tcp", "udp"]},
    "dls-monitor": {"port_number": 2048, "protocols": ["tcp", "udp"]},
    "shilp": {"port_number": 2049, "protocols": ["tcp", "udp"]},
    "nfs": {"port_number": 2049, "protocols": ["tcp", "udp", "sctp"]},
    "av-emb-config": {"port_number": 2050, "protocols": ["tcp", "udp"]},
    "epnsdp": {"port_number": 2051, "protocols": ["tcp", "udp"]},
    "clearvisn": {"port_number": 2052, "protocols": ["tcp", "udp"]},
    "lot105-ds-upd": {"port_number": 2053, "protocols": ["tcp", "udp"]},
    "weblogin": {"port_number": 2054, "protocols": ["tcp", "udp"]},
    "iop": {"port_number": 2055, "protocols": ["tcp", "udp"]},
    "omnisky": {"port_number": 2056, "protocols": ["tcp", "udp"]},
    "rich-cp": {"port_number": 2057, "protocols": ["tcp", "udp"]},
    "newwavesearch": {"port_number": 2058, "protocols": ["tcp", "udp"]},
    "bmc-messaging": {"port_number": 2059, "protocols": ["tcp", "udp"]},
    "teleniumdaemon": {"port_number": 2060, "protocols": ["tcp", "udp"]},
    "netmount": {"port_number": 2061, "protocols": ["tcp", "udp"]},
    "icg-swp": {"port_number": 2062, "protocols": ["tcp", "udp"]},
    "icg-bridge": {"port_number": 2063, "protocols": ["tcp", "udp"]},
    "icg-iprelay": {"port_number": 2064, "protocols": ["tcp", "udp"]},
    "dlsrpn": {"port_number": 2065, "protocols": ["tcp", "udp"]},
    "aura": {"port_number": 2066, "protocols": ["tcp", "udp"]},
    "dlswpn": {"port_number": 2067, "protocols": ["tcp", "udp"]},
    "avauthsrvprtcl": {"port_number": 2068, "protocols": ["tcp", "udp"]},
    "event-port": {"port_number": 2069, "protocols": ["tcp", "udp"]},
    "ah-esp-encap": {"port_number": 2070, "protocols": ["tcp", "udp"]},
    "acp-port": {"port_number": 2071, "protocols": ["tcp", "udp"]},
    "msync": {"port_number": 2072, "protocols": ["tcp", "udp"]},
    "gxs-data-port": {"port_number": 2073, "protocols": ["tcp", "udp"]},
    "vrtl-vmf-sa": {"port_number": 2074, "protocols": ["tcp", "udp"]},
    "newlixengine": {"port_number": 2075, "protocols": ["tcp", "udp"]},
    "newlixconfig": {"port_number": 2076, "protocols": ["tcp", "udp"]},
    "tsrmagt": {"port_number": 2077, "protocols": ["tcp", "udp"]},
    "tpcsrvr": {"port_number": 2078, "protocols": ["tcp", "udp"]},
    "idware-router": {"port_number": 2079, "protocols": ["tcp", "udp"]},
    "autodesk-nlm": {"port_number": 2080, "protocols": ["tcp", "udp"]},
    "kme-trap-port": {"port_number": 2081, "protocols": ["tcp", "udp"]},
    "infowave": {"port_number": 2082, "protocols": ["tcp", "udp"]},
    "radsec": {"port_number": 2083, "protocols": ["tcp", "udp"]},
    "sunclustergeo": {"port_number": 2084, "protocols": ["tcp", "udp"]},
    "ada-cip": {"port_number": 2085, "protocols": ["tcp", "udp"]},
    "gnunet": {"port_number": 2086, "protocols": ["tcp", "udp"]},
    "eli": {"port_number": 2087, "protocols": ["tcp", "udp"]},
    "ip-blf": {"port_number": 2088, "protocols": ["tcp", "udp"]},
    "sep": {"port_number": 2089, "protocols": ["tcp", "udp"]},
    "lrp": {"port_number": 2090, "protocols": ["tcp", "udp"]},
    "prp": {"port_number": 2091, "protocols": ["tcp", "udp"]},
    "descent3": {"port_number": 2092, "protocols": ["tcp", "udp"]},
    "nbx-cc": {"port_number": 2093, "protocols": ["tcp", "udp"]},
    "nbx-au": {"port_number": 2094, "protocols": ["tcp", "udp"]},
    "nbx-ser": {"port_number": 2095, "protocols": ["tcp", "udp"]},
    "nbx-dir": {"port_number": 2096, "protocols": ["tcp", "udp"]},
    "jetformpreview": {"port_number": 2097, "protocols": ["tcp", "udp"]},
    "dialog-port": {"port_number": 2098, "protocols": ["tcp", "udp"]},
    "h2250-annex-g": {"port_number": 2099, "protocols": ["tcp", "udp"]},
    "amiganetfs": {"port_number": 2100, "protocols": ["tcp", "udp"]},
    "rtcm-sc104": {"port_number": 2101, "protocols": ["tcp", "udp"]},
    "zephyr-srv": {"port_number": 2102, "protocols": ["tcp", "udp"]},
    "zephyr-clt": {"port_number": 2103, "protocols": ["tcp", "udp"]},
    "zephyr-hm": {"port_number": 2104, "protocols": ["tcp", "udp"]},
    "minipay": {"port_number": 2105, "protocols": ["tcp", "udp"]},
    "mzap": {"port_number": 2106, "protocols": ["tcp", "udp"]},
    "bintec-admin": {"port_number": 2107, "protocols": ["tcp", "udp"]},
    "comcam": {"port_number": 2108, "protocols": ["tcp", "udp"]},
    "ergolight": {"port_number": 2109, "protocols": ["tcp", "udp"]},
    "umsp": {"port_number": 2110, "protocols": ["tcp", "udp"]},
    "dsatp": {"port_number": 2111, "protocols": ["tcp", "udp"]},
    "idonix-metanet": {"port_number": 2112, "protocols": ["tcp", "udp"]},
    "hsl-storm": {"port_number": 2113, "protocols": ["tcp", "udp"]},
    "ariascribe": {"port_number": 2114, "protocols": ["tcp", "udp"]},
    "kdm": {"port_number": 2115, "protocols": ["tcp", "udp"]},
    "ccowcmr": {"port_number": 2116, "protocols": ["tcp", "udp"]},
    "mentaclient": {"port_number": 2117, "protocols": ["tcp", "udp"]},
    "mentaserver": {"port_number": 2118, "protocols": ["tcp", "udp"]},
    "gsigatekeeper": {"port_number": 2119, "protocols": ["tcp", "udp"]},
    "qencp": {"port_number": 2120, "protocols": ["tcp", "udp"]},
    "scientia-ssdb": {"port_number": 2121, "protocols": ["tcp", "udp"]},
    "caupc-remote": {"port_number": 2122, "protocols": ["tcp", "udp"]},
    "gtp-control": {"port_number": 2123, "protocols": ["tcp", "udp"]},
    "elatelink": {"port_number": 2124, "protocols": ["tcp", "udp"]},
    "lockstep": {"port_number": 2125, "protocols": ["tcp", "udp"]},
    "pktcable-cops": {"port_number": 2126, "protocols": ["tcp", "udp"]},
    "index-pc-wb": {"port_number": 2127, "protocols": ["tcp", "udp"]},
    "net-steward": {"port_number": 2128, "protocols": ["tcp", "udp"]},
    "cs-live": {"port_number": 2129, "protocols": ["tcp", "udp"]},
    "xds": {"port_number": 2130, "protocols": ["tcp", "udp"]},
    "avantageb2b": {"port_number": 2131, "protocols": ["tcp", "udp"]},
    "solera-epmap": {"port_number": 2132, "protocols": ["tcp", "udp"]},
    "zymed-zpp": {"port_number": 2133, "protocols": ["tcp", "udp"]},
    "avenue": {"port_number": 2134, "protocols": ["tcp", "udp"]},
    "gris": {"port_number": 2135, "protocols": ["tcp", "udp"]},
    "appworxsrv": {"port_number": 2136, "protocols": ["tcp", "udp"]},
    "connect": {"port_number": 2137, "protocols": ["tcp", "udp"]},
    "unbind-cluster": {"port_number": 2138, "protocols": ["tcp", "udp"]},
    "ias-auth": {"port_number": 2139, "protocols": ["tcp", "udp"]},
    "ias-reg": {"port_number": 2140, "protocols": ["tcp", "udp"]},
    "ias-admind": {"port_number": 2141, "protocols": ["tcp", "udp"]},
    "tdmoip": {"port_number": 2142, "protocols": ["tcp", "udp"]},
    "lv-jc": {"port_number": 2143, "protocols": ["tcp", "udp"]},
    "lv-ffx": {"port_number": 2144, "protocols": ["tcp", "udp"]},
    "lv-pici": {"port_number": 2145, "protocols": ["tcp", "udp"]},
    "lv-not": {"port_number": 2146, "protocols": ["tcp", "udp"]},
    "lv-auth": {"port_number": 2147, "protocols": ["tcp", "udp"]},
    "veritas-ucl": {"port_number": 2148, "protocols": ["tcp", "udp"]},
    "acptsys": {"port_number": 2149, "protocols": ["tcp", "udp"]},
    "dynamic3d": {"port_number": 2150, "protocols": ["tcp", "udp"]},
    "docent": {"port_number": 2151, "protocols": ["tcp", "udp"]},
    "gtp-user": {"port_number": 2152, "protocols": ["tcp", "udp"]},
    "ctlptc": {"port_number": 2153, "protocols": ["tcp", "udp"]},
    "stdptc": {"port_number": 2154, "protocols": ["tcp", "udp"]},
    "brdptc": {"port_number": 2155, "protocols": ["tcp", "udp"]},
    "trp": {"port_number": 2156, "protocols": ["tcp", "udp"]},
    "xnds": {"port_number": 2157, "protocols": ["tcp", "udp"]},
    "touchnetplus": {"port_number": 2158, "protocols": ["tcp", "udp"]},
    "gdbremote": {"port_number": 2159, "protocols": ["tcp", "udp"]},
    "apc-2160": {"port_number": 2160, "protocols": ["tcp", "udp"]},
    "apc-2161": {"port_number": 2161, "protocols": ["tcp", "udp"]},
    "navisphere": {"port_number": 2162, "protocols": ["tcp", "udp"]},
    "navisphere-sec": {"port_number": 2163, "protocols": ["tcp", "udp"]},
    "ddns-v3": {"port_number": 2164, "protocols": ["tcp", "udp"]},
    "x-bone-api": {"port_number": 2165, "protocols": ["tcp", "udp"]},
    "iwserver": {"port_number": 2166, "protocols": ["tcp", "udp"]},
    "raw-serial": {"port_number": 2167, "protocols": ["tcp", "udp"]},
    "easy-soft-mux": {"port_number": 2168, "protocols": ["tcp", "udp"]},
    "brain": {"port_number": 2169, "protocols": ["tcp", "udp"]},
    "eyetv": {"port_number": 2170, "protocols": ["tcp", "udp"]},
    "msfw-storage": {"port_number": 2171, "protocols": ["tcp", "udp"]},
    "msfw-s-storage": {"port_number": 2172, "protocols": ["tcp", "udp"]},
    "msfw-replica": {"port_number": 2173, "protocols": ["tcp", "udp"]},
    "msfw-array": {"port_number": 2174, "protocols": ["tcp", "udp"]},
    "airsync": {"port_number": 2175, "protocols": ["tcp", "udp"]},
    "rapi": {"port_number": 2176, "protocols": ["tcp", "udp"]},
    "qwave": {"port_number": 2177, "protocols": ["tcp", "udp"]},
    "bitspeer": {"port_number": 2178, "protocols": ["tcp", "udp"]},
    "vmrdp": {"port_number": 2179, "protocols": ["tcp", "udp"]},
    "mc-gt-srv": {"port_number": 2180, "protocols": ["tcp", "udp"]},
    "eforward": {"port_number": 2181, "protocols": ["tcp", "udp"]},
    "cgn-stat": {"port_number": 2182, "protocols": ["tcp", "udp"]},
    "cgn-config": {"port_number": 2183, "protocols": ["tcp", "udp"]},
    "nvd": {"port_number": 2184, "protocols": ["tcp", "udp"]},
    "onbase-dds": {"port_number": 2185, "protocols": ["tcp", "udp"]},
    "gtaua": {"port_number": 2186, "protocols": ["tcp", "udp"]},
    "ssmc": {"port_number": 2187, "protocols": ["tcp"]},
    "ssmd": {"port_number": 2187, "protocols": ["udp"]},
    "radware-rpm": {"port_number": 2188, "protocols": ["tcp"]},
    "radware-rpm-s": {"port_number": 2189, "protocols": ["tcp"]},
    "tivoconnect": {"port_number": 2190, "protocols": ["tcp", "udp"]},
    "tvbus": {"port_number": 2191, "protocols": ["tcp", "udp"]},
    "asdis": {"port_number": 2192, "protocols": ["tcp", "udp"]},
    "drwcs": {"port_number": 2193, "protocols": ["tcp", "udp"]},
    "mnp-exchange": {"port_number": 2197, "protocols": ["tcp", "udp"]},
    "onehome-remote": {"port_number": 2198, "protocols": ["tcp", "udp"]},
    "onehome-help": {"port_number": 2199, "protocols": ["tcp", "udp"]},
    "ats": {"port_number": 2201, "protocols": ["tcp", "udp"]},
    "imtc-map": {"port_number": 2202, "protocols": ["tcp", "udp"]},
    "b2-runtime": {"port_number": 2203, "protocols": ["tcp", "udp"]},
    "b2-license": {"port_number": 2204, "protocols": ["tcp", "udp"]},
    "jps": {"port_number": 2205, "protocols": ["tcp", "udp"]},
    "hpocbus": {"port_number": 2206, "protocols": ["tcp", "udp"]},
    "hpssd": {"port_number": 2207, "protocols": ["tcp", "udp"]},
    "hpiod": {"port_number": 2208, "protocols": ["tcp", "udp"]},
    "rimf-ps": {"port_number": 2209, "protocols": ["tcp", "udp"]},
    "noaaport": {"port_number": 2210, "protocols": ["tcp", "udp"]},
    "emwin": {"port_number": 2211, "protocols": ["tcp", "udp"]},
    "leecoposserver": {"port_number": 2212, "protocols": ["tcp", "udp"]},
    "kali": {"port_number": 2213, "protocols": ["tcp", "udp"]},
    "rpi": {"port_number": 2214, "protocols": ["tcp", "udp"]},
    "ipcore": {"port_number": 2215, "protocols": ["tcp", "udp"]},
    "vtu-comms": {"port_number": 2216, "protocols": ["tcp", "udp"]},
    "gotodevice": {"port_number": 2217, "protocols": ["tcp", "udp"]},
    "bounzza": {"port_number": 2218, "protocols": ["tcp", "udp"]},
    "netiq-ncap": {"port_number": 2219, "protocols": ["tcp", "udp"]},
    "netiq": {"port_number": 2220, "protocols": ["tcp", "udp"]},
    "ethernet-ip-s": {"port_number": 2221, "protocols": ["tcp", "udp"]},
    "EtherNet-IP-1": {"port_number": 2222, "protocols": ["tcp", "udp"]},
    "EtherNet/IP-1": {"port_number": 2222, "protocols": ["tcp", "udp"]},
    "rockwell-csp2": {"port_number": 2223, "protocols": ["tcp", "udp"]},
    "efi-mg": {"port_number": 2224, "protocols": ["tcp", "udp"]},
    "rcip-itu": {"port_number": 2225, "protocols": ["tcp", "sctp"]},
    "di-drm": {"port_number": 2226, "protocols": ["tcp", "udp"]},
    "di-msg": {"port_number": 2227, "protocols": ["tcp", "udp"]},
    "ehome-ms": {"port_number": 2228, "protocols": ["tcp", "udp"]},
    "datalens": {"port_number": 2229, "protocols": ["tcp", "udp"]},
    "queueadm": {"port_number": 2230, "protocols": ["tcp", "udp"]},
    "wimaxasncp": {"port_number": 2231, "protocols": ["tcp", "udp"]},
    "ivs-video": {"port_number": 2232, "protocols": ["tcp", "udp"]},
    "infocrypt": {"port_number": 2233, "protocols": ["tcp", "udp"]},
    "directplay": {"port_number": 2234, "protocols": ["tcp", "udp"]},
    "sercomm-wlink": {"port_number": 2235, "protocols": ["tcp", "udp"]},
    "nani": {"port_number": 2236, "protocols": ["tcp", "udp"]},
    "optech-port1-lm": {"port_number": 2237, "protocols": ["tcp", "udp"]},
    "aviva-sna": {"port_number": 2238, "protocols": ["tcp", "udp"]},
    "imagequery": {"port_number": 2239, "protocols": ["tcp", "udp"]},
    "recipe": {"port_number": 2240, "protocols": ["tcp", "udp"]},
    "ivsd": {"port_number": 2241, "protocols": ["tcp", "udp"]},
    "foliocorp": {"port_number": 2242, "protocols": ["tcp", "udp"]},
    "magicom": {"port_number": 2243, "protocols": ["tcp", "udp"]},
    "nmsserver": {"port_number": 2244, "protocols": ["tcp", "udp"]},
    "hao": {"port_number": 2245, "protocols": ["tcp", "udp"]},
    "pc-mta-addrmap": {"port_number": 2246, "protocols": ["tcp", "udp"]},
    "antidotemgrsvr": {"port_number": 2247, "protocols": ["tcp", "udp"]},
    "ums": {"port_number": 2248, "protocols": ["tcp", "udp"]},
    "rfmp": {"port_number": 2249, "protocols": ["tcp", "udp"]},
    "remote-collab": {"port_number": 2250, "protocols": ["tcp", "udp"]},
    "dif-port": {"port_number": 2251, "protocols": ["tcp", "udp"]},
    "njenet-ssl": {"port_number": 2252, "protocols": ["tcp", "udp"]},
    "dtv-chan-req": {"port_number": 2253, "protocols": ["tcp", "udp"]},
    "seispoc": {"port_number": 2254, "protocols": ["tcp", "udp"]},
    "vrtp": {"port_number": 2255, "protocols": ["tcp", "udp"]},
    "pcc-mfp": {"port_number": 2256, "protocols": ["tcp", "udp"]},
    "simple-tx-rx": {"port_number": 2257, "protocols": ["tcp", "udp"]},
    "rcts": {"port_number": 2258, "protocols": ["tcp", "udp"]},
    "bid-serv": {"port_number": 2259, "protocols": ["tcp", "udp"]},
    "apc-2260": {"port_number": 2260, "protocols": ["tcp", "udp"]},
    "comotionmaster": {"port_number": 2261, "protocols": ["tcp", "udp"]},
    "comotionback": {"port_number": 2262, "protocols": ["tcp", "udp"]},
    "ecwcfg": {"port_number": 2263, "protocols": ["tcp", "udp"]},
    "apx500api-1": {"port_number": 2264, "protocols": ["tcp", "udp"]},
    "apx500api-2": {"port_number": 2265, "protocols": ["tcp", "udp"]},
    "mfserver": {"port_number": 2266, "protocols": ["tcp", "udp"]},
    "ontobroker": {"port_number": 2267, "protocols": ["tcp", "udp"]},
    "amt": {"port_number": 2268, "protocols": ["tcp", "udp"]},
    "mikey": {"port_number": 2269, "protocols": ["tcp", "udp"]},
    "starschool": {"port_number": 2270, "protocols": ["tcp", "udp"]},
    "mmcals": {"port_number": 2271, "protocols": ["tcp", "udp"]},
    "mmcal": {"port_number": 2272, "protocols": ["tcp", "udp"]},
    "mysql-im": {"port_number": 2273, "protocols": ["tcp", "udp"]},
    "pcttunnell": {"port_number": 2274, "protocols": ["tcp", "udp"]},
    "ibridge-data": {"port_number": 2275, "protocols": ["tcp", "udp"]},
    "ibridge-mgmt": {"port_number": 2276, "protocols": ["tcp", "udp"]},
    "bluectrlproxy": {"port_number": 2277, "protocols": ["tcp", "udp"]},
    "s3db": {"port_number": 2278, "protocols": ["tcp", "udp"]},
    "xmquery": {"port_number": 2279, "protocols": ["tcp", "udp"]},
    "lnvpoller": {"port_number": 2280, "protocols": ["tcp", "udp"]},
    "lnvconsole": {"port_number": 2281, "protocols": ["tcp", "udp"]},
    "lnvalarm": {"port_number": 2282, "protocols": ["tcp", "udp"]},
    "lnvstatus": {"port_number": 2283, "protocols": ["tcp", "udp"]},
    "lnvmaps": {"port_number": 2284, "protocols": ["tcp", "udp"]},
    "lnvmailmon": {"port_number": 2285, "protocols": ["tcp", "udp"]},
    "nas-metering": {"port_number": 2286, "protocols": ["tcp", "udp"]},
    "dna": {"port_number": 2287, "protocols": ["tcp", "udp"]},
    "netml": {"port_number": 2288, "protocols": ["tcp", "udp"]},
    "dict-lookup": {"port_number": 2289, "protocols": ["tcp", "udp"]},
    "sonus-logging": {"port_number": 2290, "protocols": ["tcp", "udp"]},
    "eapsp": {"port_number": 2291, "protocols": ["tcp", "udp"]},
    "mib-streaming": {"port_number": 2292, "protocols": ["tcp", "udp"]},
    "npdbgmngr": {"port_number": 2293, "protocols": ["tcp", "udp"]},
    "konshus-lm": {"port_number": 2294, "protocols": ["tcp", "udp"]},
    "advant-lm": {"port_number": 2295, "protocols": ["tcp", "udp"]},
    "theta-lm": {"port_number": 2296, "protocols": ["tcp", "udp"]},
    "d2k-datamover1": {"port_number": 2297, "protocols": ["tcp", "udp"]},
    "d2k-datamover2": {"port_number": 2298, "protocols": ["tcp", "udp"]},
    "pc-telecommute": {"port_number": 2299, "protocols": ["tcp", "udp"]},
    "cvmmon": {"port_number": 2300, "protocols": ["tcp", "udp"]},
    "cpq-wbem": {"port_number": 2301, "protocols": ["tcp", "udp"]},
    "binderysupport": {"port_number": 2302, "protocols": ["tcp", "udp"]},
    "proxy-gateway": {"port_number": 2303, "protocols": ["tcp", "udp"]},
    "attachmate-uts": {"port_number": 2304, "protocols": ["tcp", "udp"]},
    "mt-scaleserver": {"port_number": 2305, "protocols": ["tcp", "udp"]},
    "tappi-boxnet": {"port_number": 2306, "protocols": ["tcp", "udp"]},
    "pehelp": {"port_number": 2307, "protocols": ["tcp", "udp"]},
    "sdhelp": {"port_number": 2308, "protocols": ["tcp", "udp"]},
    "sdserver": {"port_number": 2309, "protocols": ["tcp", "udp"]},
    "sdclient": {"port_number": 2310, "protocols": ["tcp", "udp"]},
    "messageservice": {"port_number": 2311, "protocols": ["tcp", "udp"]},
    "wanscaler": {"port_number": 2312, "protocols": ["tcp", "udp"]},
    "iapp": {"port_number": 2313, "protocols": ["tcp", "udp"]},
    "cr-websystems": {"port_number": 2314, "protocols": ["tcp", "udp"]},
    "precise-sft": {"port_number": 2315, "protocols": ["tcp", "udp"]},
    "sent-lm": {"port_number": 2316, "protocols": ["tcp", "udp"]},
    "attachmate-g32": {"port_number": 2317, "protocols": ["tcp", "udp"]},
    "cadencecontrol": {"port_number": 2318, "protocols": ["tcp", "udp"]},
    "infolibria": {"port_number": 2319, "protocols": ["tcp", "udp"]},
    "siebel-ns": {"port_number": 2320, "protocols": ["tcp", "udp"]},
    "rdlap": {"port_number": 2321, "protocols": ["tcp", "udp"]},
    "ofsd": {"port_number": 2322, "protocols": ["tcp", "udp"]},
    "3d-nfsd": {"port_number": 2323, "protocols": ["tcp", "udp"]},
    "cosmocall": {"port_number": 2324, "protocols": ["tcp", "udp"]},
    "ansysli": {"port_number": 2325, "protocols": ["tcp", "udp"]},
    "idcp": {"port_number": 2326, "protocols": ["tcp", "udp"]},
    "xingcsm": {"port_number": 2327, "protocols": ["tcp", "udp"]},
    "netrix-sftm": {"port_number": 2328, "protocols": ["tcp", "udp"]},
    "nvd-secondary": {"port_number": 2329, "protocols": ["tcp", "udp"]},
    "tscchat": {"port_number": 2330, "protocols": ["tcp", "udp"]},
    "agentview": {"port_number": 2331, "protocols": ["tcp", "udp"]},
    "rcc-host": {"port_number": 2332, "protocols": ["tcp", "udp"]},
    "snapp": {"port_number": 2333, "protocols": ["tcp", "udp"]},
    "ace-client": {"port_number": 2334, "protocols": ["tcp", "udp"]},
    "ace-proxy": {"port_number": 2335, "protocols": ["tcp", "udp"]},
    "appleugcontrol": {"port_number": 2336, "protocols": ["tcp", "udp"]},
    "ideesrv": {"port_number": 2337, "protocols": ["tcp", "udp"]},
    "norton-lambert": {"port_number": 2338, "protocols": ["tcp", "udp"]},
    "3com-webview": {"port_number": 2339, "protocols": ["tcp", "udp"]},
    "wrs-registry": {"port_number": 2340, "protocols": ["tcp", "udp"]},
    "wrs_registry": {"port_number": 2340, "protocols": ["tcp", "udp"]},
    "xiostatus": {"port_number": 2341, "protocols": ["tcp", "udp"]},
    "manage-exec": {"port_number": 2342, "protocols": ["tcp", "udp"]},
    "nati-logos": {"port_number": 2343, "protocols": ["tcp", "udp"]},
    "fcmsys": {"port_number": 2344, "protocols": ["tcp", "udp"]},
    "dbm": {"port_number": 2345, "protocols": ["tcp", "udp"]},
    "redstorm-join": {"port_number": 2346, "protocols": ["tcp", "udp"]},
    "redstorm_join": {"port_number": 2346, "protocols": ["tcp", "udp"]},
    "redstorm-find": {"port_number": 2347, "protocols": ["tcp", "udp"]},
    "redstorm_find": {"port_number": 2347, "protocols": ["tcp", "udp"]},
    "redstorm-info": {"port_number": 2348, "protocols": ["tcp", "udp"]},
    "redstorm_info": {"port_number": 2348, "protocols": ["tcp", "udp"]},
    "redstorm-diag": {"port_number": 2349, "protocols": ["tcp", "udp"]},
    "redstorm_diag": {"port_number": 2349, "protocols": ["tcp", "udp"]},
    "psbserver": {"port_number": 2350, "protocols": ["tcp", "udp"]},
    "psrserver": {"port_number": 2351, "protocols": ["tcp", "udp"]},
    "pslserver": {"port_number": 2352, "protocols": ["tcp", "udp"]},
    "pspserver": {"port_number": 2353, "protocols": ["tcp", "udp"]},
    "psprserver": {"port_number": 2354, "protocols": ["tcp", "udp"]},
    "psdbserver": {"port_number": 2355, "protocols": ["tcp", "udp"]},
    "gxtelmd": {"port_number": 2356, "protocols": ["tcp", "udp"]},
    "unihub-server": {"port_number": 2357, "protocols": ["tcp", "udp"]},
    "futrix": {"port_number": 2358, "protocols": ["tcp", "udp"]},
    "flukeserver": {"port_number": 2359, "protocols": ["tcp", "udp"]},
    "nexstorindltd": {"port_number": 2360, "protocols": ["tcp", "udp"]},
    "tl1": {"port_number": 2361, "protocols": ["tcp", "udp"]},
    "digiman": {"port_number": 2362, "protocols": ["tcp", "udp"]},
    "mediacntrlnfsd": {"port_number": 2363, "protocols": ["tcp", "udp"]},
    "oi-2000": {"port_number": 2364, "protocols": ["tcp", "udp"]},
    "dbref": {"port_number": 2365, "protocols": ["tcp", "udp"]},
    "qip-login": {"port_number": 2366, "protocols": ["tcp", "udp"]},
    "service-ctrl": {"port_number": 2367, "protocols": ["tcp", "udp"]},
    "opentable": {"port_number": 2368, "protocols": ["tcp", "udp"]},
    "bif-p2p": {"port_number": 2369, "protocols": ["tcp", "udp"]},
    "l3-hbmon": {"port_number": 2370, "protocols": ["tcp", "udp"]},
    "rda-secondary": {"port_number": 2371, "protocols": ["tcp"]},
    "lanmessenger": {"port_number": 2372, "protocols": ["tcp", "udp"]},
    "remographlm": {"port_number": 2373, "protocols": ["tcp"]},
    "hydra": {"port_number": 2374, "protocols": ["tcp"]},
    "docker": {"port_number": 2375, "protocols": ["tcp"]},
    "docker-s": {"port_number": 2376, "protocols": ["tcp"]},
    "swarm": {"port_number": 2377, "protocols": ["tcp"]},
    "dali": {"port_number": 2378, "protocols": ["udp"]},
    "etcd-client": {"port_number": 2379, "protocols": ["tcp"]},
    "etcd-server": {"port_number": 2380, "protocols": ["tcp"]},
    "compaq-https": {"port_number": 2381, "protocols": ["tcp", "udp"]},
    "ms-olap3": {"port_number": 2382, "protocols": ["tcp", "udp"]},
    "ms-olap4": {"port_number": 2383, "protocols": ["tcp", "udp"]},
    "sd-request": {"port_number": 2384, "protocols": ["tcp"]},
    "sd-capacity": {"port_number": 2384, "protocols": ["udp"]},
    "sd-data": {"port_number": 2385, "protocols": ["tcp", "udp"]},
    "virtualtape": {"port_number": 2386, "protocols": ["tcp", "udp"]},
    "vsamredirector": {"port_number": 2387, "protocols": ["tcp", "udp"]},
    "mynahautostart": {"port_number": 2388, "protocols": ["tcp", "udp"]},
    "ovsessionmgr": {"port_number": 2389, "protocols": ["tcp", "udp"]},
    "rsmtp": {"port_number": 2390, "protocols": ["tcp", "udp"]},
    "3com-net-mgmt": {"port_number": 2391, "protocols": ["tcp", "udp"]},
    "tacticalauth": {"port_number": 2392, "protocols": ["tcp", "udp"]},
    "ms-olap1": {"port_number": 2393, "protocols": ["tcp", "udp"]},
    "ms-olap2": {"port_number": 2394, "protocols": ["tcp", "udp"]},
    "lan900-remote": {"port_number": 2395, "protocols": ["tcp", "udp"]},
    "lan900_remote": {"port_number": 2395, "protocols": ["tcp", "udp"]},
    "wusage": {"port_number": 2396, "protocols": ["tcp", "udp"]},
    "ncl": {"port_number": 2397, "protocols": ["tcp", "udp"]},
    "orbiter": {"port_number": 2398, "protocols": ["tcp", "udp"]},
    "fmpro-fdal": {"port_number": 2399, "protocols": ["tcp", "udp"]},
    "opequus-server": {"port_number": 2400, "protocols": ["tcp", "udp"]},
    "cvspserver": {"port_number": 2401, "protocols": ["tcp", "udp"]},
    "taskmaster2000": {"port_number": 2402, "protocols": ["tcp", "udp"]},
    "taskmaster2000-secondary": {"port_number": 2403, "protocols": ["tcp", "udp"]},
    "iec-104": {"port_number": 2404, "protocols": ["tcp", "udp"]},
    "trc-netpoll": {"port_number": 2405, "protocols": ["tcp", "udp"]},
    "jediserver": {"port_number": 2406, "protocols": ["tcp", "udp"]},
    "orion": {"port_number": 2407, "protocols": ["tcp", "udp"]},
    "railgun-webaccl": {"port_number": 2408, "protocols": ["tcp"]},
    "sns-protocol": {"port_number": 2409, "protocols": ["tcp", "udp"]},
    "vrts-registry": {"port_number": 2410, "protocols": ["tcp", "udp"]},
    "netwave-ap-mgmt": {"port_number": 2411, "protocols": ["tcp", "udp"]},
    "cdn": {"port_number": 2412, "protocols": ["tcp", "udp"]},
    "orion-rmi-reg": {"port_number": 2413, "protocols": ["tcp", "udp"]},
    "beeyond": {"port_number": 2414, "protocols": ["tcp", "udp"]},
    "codima-rtp": {"port_number": 2415, "protocols": ["tcp", "udp"]},
    "rmtserver": {"port_number": 2416, "protocols": ["tcp", "udp"]},
    "composit-server": {"port_number": 2417, "protocols": ["tcp", "udp"]},
    "cas": {"port_number": 2418, "protocols": ["tcp", "udp"]},
    "attachmate-s2s": {"port_number": 2419, "protocols": ["tcp", "udp"]},
    "dslremote-mgmt": {"port_number": 2420, "protocols": ["tcp", "udp"]},
    "g-talk": {"port_number": 2421, "protocols": ["tcp", "udp"]},
    "crmsbits": {"port_number": 2422, "protocols": ["tcp", "udp"]},
    "rnrp": {"port_number": 2423, "protocols": ["tcp", "udp"]},
    "kofax-svr": {"port_number": 2424, "protocols": ["tcp", "udp"]},
    "fjitsuappmgr": {"port_number": 2425, "protocols": ["tcp", "udp"]},
    "vcmp": {"port_number": 2426, "protocols": ["tcp", "udp"]},
    "mgcp-gateway": {"port_number": 2427, "protocols": ["tcp", "udp"]},
    "ott": {"port_number": 2428, "protocols": ["tcp", "udp"]},
    "ft-role": {"port_number": 2429, "protocols": ["tcp", "udp"]},
    "venus": {"port_number": 2430, "protocols": ["tcp", "udp"]},
    "venus-se": {"port_number": 2431, "protocols": ["tcp", "udp"]},
    "codasrv": {"port_number": 2432, "protocols": ["tcp", "udp"]},
    "codasrv-se": {"port_number": 2433, "protocols": ["tcp", "udp"]},
    "pxc-epmap": {"port_number": 2434, "protocols": ["tcp", "udp"]},
    "optilogic": {"port_number": 2435, "protocols": ["tcp", "udp"]},
    "topx": {"port_number": 2436, "protocols": ["tcp", "udp"]},
    "unicontrol": {"port_number": 2437, "protocols": ["tcp", "udp"]},
    "msp-secondary": {"port_number": 2438, "protocols": ["tcp", "udp"]},
    "sybasedbsynch": {"port_number": 2439, "protocols": ["tcp", "udp"]},
    "spearway": {"port_number": 2440, "protocols": ["tcp", "udp"]},
    "pvsw-inet": {"port_number": 2441, "protocols": ["tcp", "udp"]},
    "netangel": {"port_number": 2442, "protocols": ["tcp", "udp"]},
    "powerclientcsf": {"port_number": 2443, "protocols": ["tcp", "udp"]},
    "btpp2sectrans": {"port_number": 2444, "protocols": ["tcp", "udp"]},
    "dtn1": {"port_number": 2445, "protocols": ["tcp", "udp"]},
    "bues-service": {"port_number": 2446, "protocols": ["tcp", "udp"]},
    "bues_service": {"port_number": 2446, "protocols": ["tcp", "udp"]},
    "ovwdb": {"port_number": 2447, "protocols": ["tcp", "udp"]},
    "hpppssvr": {"port_number": 2448, "protocols": ["tcp", "udp"]},
    "ratl": {"port_number": 2449, "protocols": ["tcp", "udp"]},
    "netadmin": {"port_number": 2450, "protocols": ["tcp", "udp"]},
    "netchat": {"port_number": 2451, "protocols": ["tcp", "udp"]},
    "snifferclient": {"port_number": 2452, "protocols": ["tcp", "udp"]},
    "madge-ltd": {"port_number": 2453, "protocols": ["tcp", "udp"]},
    "indx-dds": {"port_number": 2454, "protocols": ["tcp", "udp"]},
    "wago-io-system": {"port_number": 2455, "protocols": ["tcp", "udp"]},
    "altav-remmgt": {"port_number": 2456, "protocols": ["tcp", "udp"]},
    "rapido-ip": {"port_number": 2457, "protocols": ["tcp", "udp"]},
    "griffin": {"port_number": 2458, "protocols": ["tcp", "udp"]},
    "xrpl": {"port_number": 2459, "protocols": ["tcp", "udp"]},
    "ms-theater": {"port_number": 2460, "protocols": ["tcp", "udp"]},
    "qadmifoper": {"port_number": 2461, "protocols": ["tcp", "udp"]},
    "qadmifevent": {"port_number": 2462, "protocols": ["tcp", "udp"]},
    "lsi-raid-mgmt": {"port_number": 2463, "protocols": ["tcp", "udp"]},
    "direcpc-si": {"port_number": 2464, "protocols": ["tcp", "udp"]},
    "lbm": {"port_number": 2465, "protocols": ["tcp", "udp"]},
    "lbf": {"port_number": 2466, "protocols": ["tcp", "udp"]},
    "high-criteria": {"port_number": 2467, "protocols": ["tcp", "udp"]},
    "qip-msgd": {"port_number": 2468, "protocols": ["tcp", "udp"]},
    "mti-tcs-comm": {"port_number": 2469, "protocols": ["tcp", "udp"]},
    "taskman-port": {"port_number": 2470, "protocols": ["tcp", "udp"]},
    "seaodbc": {"port_number": 2471, "protocols": ["tcp", "udp"]},
    "c3": {"port_number": 2472, "protocols": ["tcp", "udp"]},
    "aker-cdp": {"port_number": 2473, "protocols": ["tcp", "udp"]},
    "vitalanalysis": {"port_number": 2474, "protocols": ["tcp", "udp"]},
    "ace-server": {"port_number": 2475, "protocols": ["tcp", "udp"]},
    "ace-svr-prop": {"port_number": 2476, "protocols": ["tcp", "udp"]},
    "ssm-cvs": {"port_number": 2477, "protocols": ["tcp", "udp"]},
    "ssm-cssps": {"port_number": 2478, "protocols": ["tcp", "udp"]},
    "ssm-els": {"port_number": 2479, "protocols": ["tcp", "udp"]},
    "powerexchange": {"port_number": 2480, "protocols": ["tcp", "udp"]},
    "giop": {"port_number": 2481, "protocols": ["tcp", "udp"]},
    "giop-ssl": {"port_number": 2482, "protocols": ["tcp", "udp"]},
    "ttc": {"port_number": 2483, "protocols": ["tcp", "udp"]},
    "ttc-ssl": {"port_number": 2484, "protocols": ["tcp", "udp"]},
    "netobjects1": {"port_number": 2485, "protocols": ["tcp", "udp"]},
    "netobjects2": {"port_number": 2486, "protocols": ["tcp", "udp"]},
    "pns": {"port_number": 2487, "protocols": ["tcp", "udp"]},
    "moy-corp": {"port_number": 2488, "protocols": ["tcp", "udp"]},
    "tsilb": {"port_number": 2489, "protocols": ["tcp", "udp"]},
    "qip-qdhcp": {"port_number": 2490, "protocols": ["tcp", "udp"]},
    "conclave-cpp": {"port_number": 2491, "protocols": ["tcp", "udp"]},
    "groove": {"port_number": 2492, "protocols": ["tcp", "udp"]},
    "talarian-mqs": {"port_number": 2493, "protocols": ["tcp", "udp"]},
    "bmc-ar": {"port_number": 2494, "protocols": ["tcp", "udp"]},
    "fast-rem-serv": {"port_number": 2495, "protocols": ["tcp", "udp"]},
    "dirgis": {"port_number": 2496, "protocols": ["tcp", "udp"]},
    "quaddb": {"port_number": 2497, "protocols": ["tcp", "udp"]},
    "odn-castraq": {"port_number": 2498, "protocols": ["tcp", "udp"]},
    "unicontrol-secondary": {"port_number": 2499, "protocols": ["tcp", "udp"]},
    "rtsserv": {"port_number": 2500, "protocols": ["tcp", "udp"]},
    "rtsclient": {"port_number": 2501, "protocols": ["tcp", "udp"]},
    "kentrox-prot": {"port_number": 2502, "protocols": ["tcp", "udp"]},
    "nms-dpnss": {"port_number": 2503, "protocols": ["tcp", "udp"]},
    "wlbs": {"port_number": 2504, "protocols": ["tcp", "udp"]},
    "ppcontrol": {"port_number": 2505, "protocols": ["tcp", "udp"]},
    "jbroker": {"port_number": 2506, "protocols": ["tcp", "udp"]},
    "spock": {"port_number": 2507, "protocols": ["tcp", "udp"]},
    "jdatastore": {"port_number": 2508, "protocols": ["tcp", "udp"]},
    "fjmpss": {"port_number": 2509, "protocols": ["tcp", "udp"]},
    "fjappmgrbulk": {"port_number": 2510, "protocols": ["tcp", "udp"]},
    "metastorm": {"port_number": 2511, "protocols": ["tcp", "udp"]},
    "citrixima": {"port_number": 2512, "protocols": ["tcp", "udp"]},
    "citrixadmin": {"port_number": 2513, "protocols": ["tcp", "udp"]},
    "facsys-ntp": {"port_number": 2514, "protocols": ["tcp", "udp"]},
    "facsys-router": {"port_number": 2515, "protocols": ["tcp", "udp"]},
    "maincontrol": {"port_number": 2516, "protocols": ["tcp", "udp"]},
    "call-sig-trans": {"port_number": 2517, "protocols": ["tcp", "udp"]},
    "willy": {"port_number": 2518, "protocols": ["tcp", "udp"]},
    "globmsgsvc": {"port_number": 2519, "protocols": ["tcp", "udp"]},
    "pvsw": {"port_number": 2520, "protocols": ["tcp", "udp"]},
    "adaptecmgr": {"port_number": 2521, "protocols": ["tcp", "udp"]},
    "windb": {"port_number": 2522, "protocols": ["tcp", "udp"]},
    "qke-llc-v3": {"port_number": 2523, "protocols": ["tcp", "udp"]},
    "optiwave-lm": {"port_number": 2524, "protocols": ["tcp", "udp"]},
    "ms-v-worlds": {"port_number": 2525, "protocols": ["tcp", "udp"]},
    "ema-sent-lm": {"port_number": 2526, "protocols": ["tcp", "udp"]},
    "iqserver": {"port_number": 2527, "protocols": ["tcp", "udp"]},
    "ncr-ccl": {"port_number": 2528, "protocols": ["tcp", "udp"]},
    "ncr_ccl": {"port_number": 2528, "protocols": ["tcp", "udp"]},
    "utsftp": {"port_number": 2529, "protocols": ["tcp", "udp"]},
    "vrcommerce": {"port_number": 2530, "protocols": ["tcp", "udp"]},
    "ito-e-gui": {"port_number": 2531, "protocols": ["tcp", "udp"]},
    "ovtopmd": {"port_number": 2532, "protocols": ["tcp", "udp"]},
    "snifferserver": {"port_number": 2533, "protocols": ["tcp", "udp"]},
    "combox-web-acc": {"port_number": 2534, "protocols": ["tcp", "udp"]},
    "madcap": {"port_number": 2535, "protocols": ["tcp", "udp"]},
    "btpp2audctr1": {"port_number": 2536, "protocols": ["tcp", "udp"]},
    "upgrade": {"port_number": 2537, "protocols": ["tcp", "udp"]},
    "vnwk-prapi": {"port_number": 2538, "protocols": ["tcp", "udp"]},
    "vsiadmin": {"port_number": 2539, "protocols": ["tcp", "udp"]},
    "lonworks": {"port_number": 2540, "protocols": ["tcp", "udp"]},
    "lonworks2": {"port_number": 2541, "protocols": ["tcp", "udp"]},
    "udrawgraph": {"port_number": 2542, "protocols": ["tcp", "udp"]},
    "reftek": {"port_number": 2543, "protocols": ["tcp", "udp"]},
    "novell-zen": {"port_number": 2544, "protocols": ["tcp", "udp"]},
    "sis-emt": {"port_number": 2545, "protocols": ["tcp", "udp"]},
    "vytalvaultbrtp": {"port_number": 2546, "protocols": ["tcp", "udp"]},
    "vytalvaultvsmp": {"port_number": 2547, "protocols": ["tcp", "udp"]},
    "vytalvaultpipe": {"port_number": 2548, "protocols": ["tcp", "udp"]},
    "ipass": {"port_number": 2549, "protocols": ["tcp", "udp"]},
    "ads": {"port_number": 2550, "protocols": ["tcp", "udp"]},
    "isg-uda-server": {"port_number": 2551, "protocols": ["tcp", "udp"]},
    "call-logging": {"port_number": 2552, "protocols": ["tcp", "udp"]},
    "efidiningport": {"port_number": 2553, "protocols": ["tcp", "udp"]},
    "vcnet-link-v10": {"port_number": 2554, "protocols": ["tcp", "udp"]},
    "compaq-wcp": {"port_number": 2555, "protocols": ["tcp", "udp"]},
    "nicetec-nmsvc": {"port_number": 2556, "protocols": ["tcp", "udp"]},
    "nicetec-mgmt": {"port_number": 2557, "protocols": ["tcp", "udp"]},
    "pclemultimedia": {"port_number": 2558, "protocols": ["tcp", "udp"]},
    "lstp": {"port_number": 2559, "protocols": ["tcp", "udp"]},
    "labrat": {"port_number": 2560, "protocols": ["tcp", "udp"]},
    "mosaixcc": {"port_number": 2561, "protocols": ["tcp", "udp"]},
    "delibo": {"port_number": 2562, "protocols": ["tcp", "udp"]},
    "cti-redwood": {"port_number": 2563, "protocols": ["tcp", "udp"]},
    "hp-3000-telnet": {"port_number": 2564, "protocols": ["tcp", "udp"]},
    "coord-svr": {"port_number": 2565, "protocols": ["tcp", "udp"]},
    "pcs-pcw": {"port_number": 2566, "protocols": ["tcp", "udp"]},
    "clp": {"port_number": 2567, "protocols": ["tcp", "udp"]},
    "spamtrap": {"port_number": 2568, "protocols": ["tcp", "udp"]},
    "sonuscallsig": {"port_number": 2569, "protocols": ["tcp", "udp"]},
    "hs-port": {"port_number": 2570, "protocols": ["tcp", "udp"]},
    "cecsvc": {"port_number": 2571, "protocols": ["tcp", "udp"]},
    "ibp": {"port_number": 2572, "protocols": ["tcp", "udp"]},
    "trustestablish": {"port_number": 2573, "protocols": ["tcp", "udp"]},
    "blockade-bpsp": {"port_number": 2574, "protocols": ["tcp", "udp"]},
    "hl7": {"port_number": 2575, "protocols": ["tcp", "udp"]},
    "tclprodebugger": {"port_number": 2576, "protocols": ["tcp", "udp"]},
    "scipticslsrvr": {"port_number": 2577, "protocols": ["tcp", "udp"]},
    "rvs-isdn-dcp": {"port_number": 2578, "protocols": ["tcp", "udp"]},
    "mpfoncl": {"port_number": 2579, "protocols": ["tcp", "udp"]},
    "tributary": {"port_number": 2580, "protocols": ["tcp", "udp"]},
    "argis-te": {"port_number": 2581, "protocols": ["tcp", "udp"]},
    "argis-ds": {"port_number": 2582, "protocols": ["tcp", "udp"]},
    "mon": {"port_number": 2583, "protocols": ["tcp", "udp"]},
    "cyaserv": {"port_number": 2584, "protocols": ["tcp", "udp"]},
    "netx-server": {"port_number": 2585, "protocols": ["tcp", "udp"]},
    "netx-agent": {"port_number": 2586, "protocols": ["tcp", "udp"]},
    "masc": {"port_number": 2587, "protocols": ["tcp", "udp"]},
    "privilege": {"port_number": 2588, "protocols": ["tcp", "udp"]},
    "quartus-tcl": {"port_number": 2589, "protocols": ["tcp", "udp"]},
    "idotdist": {"port_number": 2590, "protocols": ["tcp", "udp"]},
    "maytagshuffle": {"port_number": 2591, "protocols": ["tcp", "udp"]},
    "netrek": {"port_number": 2592, "protocols": ["tcp", "udp"]},
    "mns-mail": {"port_number": 2593, "protocols": ["tcp", "udp"]},
    "dts": {"port_number": 2594, "protocols": ["tcp", "udp"]},
    "worldfusion1": {"port_number": 2595, "protocols": ["tcp", "udp"]},
    "worldfusion2": {"port_number": 2596, "protocols": ["tcp", "udp"]},
    "homesteadglory": {"port_number": 2597, "protocols": ["tcp", "udp"]},
    "citriximaclient": {"port_number": 2598, "protocols": ["tcp", "udp"]},
    "snapd": {"port_number": 2599, "protocols": ["tcp", "udp"]},
    "hpstgmgr": {"port_number": 2600, "protocols": ["tcp", "udp"]},
    "discp-client": {"port_number": 2601, "protocols": ["tcp", "udp"]},
    "discp-server": {"port_number": 2602, "protocols": ["tcp", "udp"]},
    "servicemeter": {"port_number": 2603, "protocols": ["tcp", "udp"]},
    "nsc-ccs": {"port_number": 2604, "protocols": ["tcp", "udp"]},
    "nsc-posa": {"port_number": 2605, "protocols": ["tcp", "udp"]},
    "netmon": {"port_number": 2606, "protocols": ["tcp", "udp"]},
    "connection": {"port_number": 2607, "protocols": ["tcp", "udp"]},
    "wag-service": {"port_number": 2608, "protocols": ["tcp", "udp"]},
    "system-monitor": {"port_number": 2609, "protocols": ["tcp", "udp"]},
    "versa-tek": {"port_number": 2610, "protocols": ["tcp", "udp"]},
    "lionhead": {"port_number": 2611, "protocols": ["tcp", "udp"]},
    "qpasa-agent": {"port_number": 2612, "protocols": ["tcp", "udp"]},
    "smntubootstrap": {"port_number": 2613, "protocols": ["tcp", "udp"]},
    "neveroffline": {"port_number": 2614, "protocols": ["tcp", "udp"]},
    "firepower": {"port_number": 2615, "protocols": ["tcp", "udp"]},
    "appswitch-emp": {"port_number": 2616, "protocols": ["tcp", "udp"]},
    "cmadmin": {"port_number": 2617, "protocols": ["tcp", "udp"]},
    "priority-e-com": {"port_number": 2618, "protocols": ["tcp", "udp"]},
    "bruce": {"port_number": 2619, "protocols": ["tcp", "udp"]},
    "lpsrecommender": {"port_number": 2620, "protocols": ["tcp", "udp"]},
    "miles-apart": {"port_number": 2621, "protocols": ["tcp", "udp"]},
    "metricadbc": {"port_number": 2622, "protocols": ["tcp", "udp"]},
    "lmdp": {"port_number": 2623, "protocols": ["tcp", "udp"]},
    "aria": {"port_number": 2624, "protocols": ["tcp", "udp"]},
    "blwnkl-port": {"port_number": 2625, "protocols": ["tcp", "udp"]},
    "gbjd816": {"port_number": 2626, "protocols": ["tcp", "udp"]},
    "moshebeeri": {"port_number": 2627, "protocols": ["tcp", "udp"]},
    "dict": {"port_number": 2628, "protocols": ["tcp", "udp"]},
    "sitaraserver": {"port_number": 2629, "protocols": ["tcp", "udp"]},
    "sitaramgmt": {"port_number": 2630, "protocols": ["tcp", "udp"]},
    "sitaradir": {"port_number": 2631, "protocols": ["tcp", "udp"]},
    "irdg-post": {"port_number": 2632, "protocols": ["tcp", "udp"]},
    "interintelli": {"port_number": 2633, "protocols": ["tcp", "udp"]},
    "pk-electronics": {"port_number": 2634, "protocols": ["tcp", "udp"]},
    "backburner": {"port_number": 2635, "protocols": ["tcp", "udp"]},
    "solve": {"port_number": 2636, "protocols": ["tcp", "udp"]},
    "imdocsvc": {"port_number": 2637, "protocols": ["tcp", "udp"]},
    "sybaseanywhere": {"port_number": 2638, "protocols": ["tcp", "udp"]},
    "aminet": {"port_number": 2639, "protocols": ["tcp", "udp"]},
    "ami-control": {"port_number": 2640, "protocols": ["tcp", "udp"]},
    "hdl-srv": {"port_number": 2641, "protocols": ["tcp", "udp"]},
    "tragic": {"port_number": 2642, "protocols": ["tcp", "udp"]},
    "gte-samp": {"port_number": 2643, "protocols": ["tcp", "udp"]},
    "travsoft-ipx-t": {"port_number": 2644, "protocols": ["tcp", "udp"]},
    "novell-ipx-cmd": {"port_number": 2645, "protocols": ["tcp", "udp"]},
    "and-lm": {"port_number": 2646, "protocols": ["tcp", "udp"]},
    "syncserver": {"port_number": 2647, "protocols": ["tcp", "udp"]},
    "upsnotifyprot": {"port_number": 2648, "protocols": ["tcp", "udp"]},
    "vpsipport": {"port_number": 2649, "protocols": ["tcp", "udp"]},
    "eristwoguns": {"port_number": 2650, "protocols": ["tcp", "udp"]},
    "ebinsite": {"port_number": 2651, "protocols": ["tcp", "udp"]},
    "interpathpanel": {"port_number": 2652, "protocols": ["tcp", "udp"]},
    "sonus": {"port_number": 2653, "protocols": ["tcp", "udp"]},
    "corel-vncadmin": {"port_number": 2654, "protocols": ["tcp", "udp"]},
    "corel_vncadmin": {"port_number": 2654, "protocols": ["tcp", "udp"]},
    "unglue": {"port_number": 2655, "protocols": ["tcp", "udp"]},
    "kana": {"port_number": 2656, "protocols": ["tcp", "udp"]},
    "sns-dispatcher": {"port_number": 2657, "protocols": ["tcp", "udp"]},
    "sns-admin": {"port_number": 2658, "protocols": ["tcp", "udp"]},
    "sns-query": {"port_number": 2659, "protocols": ["tcp", "udp"]},
    "gcmonitor": {"port_number": 2660, "protocols": ["tcp", "udp"]},
    "olhost": {"port_number": 2661, "protocols": ["tcp", "udp"]},
    "bintec-capi": {"port_number": 2662, "protocols": ["tcp", "udp"]},
    "bintec-tapi": {"port_number": 2663, "protocols": ["tcp", "udp"]},
    "patrol-mq-gm": {"port_number": 2664, "protocols": ["tcp", "udp"]},
    "patrol-mq-nm": {"port_number": 2665, "protocols": ["tcp", "udp"]},
    "extensis": {"port_number": 2666, "protocols": ["tcp", "udp"]},
    "alarm-clock-s": {"port_number": 2667, "protocols": ["tcp", "udp"]},
    "alarm-clock-c": {"port_number": 2668, "protocols": ["tcp", "udp"]},
    "toad": {"port_number": 2669, "protocols": ["tcp", "udp"]},
    "tve-announce": {"port_number": 2670, "protocols": ["tcp", "udp"]},
    "newlixreg": {"port_number": 2671, "protocols": ["tcp", "udp"]},
    "nhserver": {"port_number": 2672, "protocols": ["tcp", "udp"]},
    "firstcall42": {"port_number": 2673, "protocols": ["tcp", "udp"]},
    "ewnn": {"port_number": 2674, "protocols": ["tcp", "udp"]},
    "ttc-etap": {"port_number": 2675, "protocols": ["tcp", "udp"]},
    "simslink": {"port_number": 2676, "protocols": ["tcp", "udp"]},
    "gadgetgate1way": {"port_number": 2677, "protocols": ["tcp", "udp"]},
    "gadgetgate2way": {"port_number": 2678, "protocols": ["tcp", "udp"]},
    "syncserverssl": {"port_number": 2679, "protocols": ["tcp", "udp"]},
    "pxc-sapxom": {"port_number": 2680, "protocols": ["tcp", "udp"]},
    "mpnjsomb": {"port_number": 2681, "protocols": ["tcp", "udp"]},
    "ncdloadbalance": {"port_number": 2683, "protocols": ["tcp", "udp"]},
    "mpnjsosv": {"port_number": 2684, "protocols": ["tcp", "udp"]},
    "mpnjsocl": {"port_number": 2685, "protocols": ["tcp", "udp"]},
    "mpnjsomg": {"port_number": 2686, "protocols": ["tcp", "udp"]},
    "pq-lic-mgmt": {"port_number": 2687, "protocols": ["tcp", "udp"]},
    "md-cg-http": {"port_number": 2688, "protocols": ["tcp", "udp"]},
    "fastlynx": {"port_number": 2689, "protocols": ["tcp", "udp"]},
    "hp-nnm-data": {"port_number": 2690, "protocols": ["tcp", "udp"]},
    "itinternet": {"port_number": 2691, "protocols": ["tcp", "udp"]},
    "admins-lms": {"port_number": 2692, "protocols": ["tcp", "udp"]},
    "pwrsevent": {"port_number": 2694, "protocols": ["tcp", "udp"]},
    "vspread": {"port_number": 2695, "protocols": ["tcp", "udp"]},
    "unifyadmin": {"port_number": 2696, "protocols": ["tcp", "udp"]},
    "oce-snmp-trap": {"port_number": 2697, "protocols": ["tcp", "udp"]},
    "mck-ivpip": {"port_number": 2698, "protocols": ["tcp", "udp"]},
    "csoft-plusclnt": {"port_number": 2699, "protocols": ["tcp", "udp"]},
    "tqdata": {"port_number": 2700, "protocols": ["tcp", "udp"]},
    "sms-rcinfo": {"port_number": 2701, "protocols": ["tcp", "udp"]},
    "sms-xfer": {"port_number": 2702, "protocols": ["tcp", "udp"]},
    "sms-chat": {"port_number": 2703, "protocols": ["tcp", "udp"]},
    "sms-remctrl": {"port_number": 2704, "protocols": ["tcp", "udp"]},
    "sds-admin": {"port_number": 2705, "protocols": ["tcp", "udp"]},
    "ncdmirroring": {"port_number": 2706, "protocols": ["tcp", "udp"]},
    "emcsymapiport": {"port_number": 2707, "protocols": ["tcp", "udp"]},
    "banyan-net": {"port_number": 2708, "protocols": ["tcp", "udp"]},
    "supermon": {"port_number": 2709, "protocols": ["tcp", "udp"]},
    "sso-service": {"port_number": 2710, "protocols": ["tcp", "udp"]},
    "sso-control": {"port_number": 2711, "protocols": ["tcp", "udp"]},
    "aocp": {"port_number": 2712, "protocols": ["tcp", "udp"]},
    "raventbs": {"port_number": 2713, "protocols": ["tcp", "udp"]},
    "raventdm": {"port_number": 2714, "protocols": ["tcp", "udp"]},
    "hpstgmgr2": {"port_number": 2715, "protocols": ["tcp", "udp"]},
    "inova-ip-disco": {"port_number": 2716, "protocols": ["tcp", "udp"]},
    "pn-requester": {"port_number": 2717, "protocols": ["tcp", "udp"]},
    "pn-requester2": {"port_number": 2718, "protocols": ["tcp", "udp"]},
    "scan-change": {"port_number": 2719, "protocols": ["tcp", "udp"]},
    "wkars": {"port_number": 2720, "protocols": ["tcp", "udp"]},
    "smart-diagnose": {"port_number": 2721, "protocols": ["tcp", "udp"]},
    "proactivesrvr": {"port_number": 2722, "protocols": ["tcp", "udp"]},
    "watchdog-nt": {"port_number": 2723, "protocols": ["tcp", "udp"]},
    "qotps": {"port_number": 2724, "protocols": ["tcp", "udp"]},
    "msolap-ptp2": {"port_number": 2725, "protocols": ["tcp", "udp"]},
    "tams": {"port_number": 2726, "protocols": ["tcp", "udp"]},
    "mgcp-callagent": {"port_number": 2727, "protocols": ["tcp", "udp"]},
    "sqdr": {"port_number": 2728, "protocols": ["tcp", "udp"]},
    "tcim-control": {"port_number": 2729, "protocols": ["tcp", "udp"]},
    "nec-raidplus": {"port_number": 2730, "protocols": ["tcp", "udp"]},
    "fyre-messanger": {"port_number": 2731, "protocols": ["tcp", "udp"]},
    "g5m": {"port_number": 2732, "protocols": ["tcp", "udp"]},
    "signet-ctf": {"port_number": 2733, "protocols": ["tcp", "udp"]},
    "ccs-software": {"port_number": 2734, "protocols": ["tcp", "udp"]},
    "netiq-mc": {"port_number": 2735, "protocols": ["tcp", "udp"]},
    "radwiz-nms-srv": {"port_number": 2736, "protocols": ["tcp", "udp"]},
    "srp-feedback": {"port_number": 2737, "protocols": ["tcp", "udp"]},
    "ndl-tcp-ois-gw": {"port_number": 2738, "protocols": ["tcp", "udp"]},
    "tn-timing": {"port_number": 2739, "protocols": ["tcp", "udp"]},
    "alarm": {"port_number": 2740, "protocols": ["tcp", "udp"]},
    "tsb": {"port_number": 2741, "protocols": ["tcp", "udp"]},
    "tsb2": {"port_number": 2742, "protocols": ["tcp", "udp"]},
    "murx": {"port_number": 2743, "protocols": ["tcp", "udp"]},
    "honyaku": {"port_number": 2744, "protocols": ["tcp", "udp"]},
    "urbisnet": {"port_number": 2745, "protocols": ["tcp", "udp"]},
    "cpudpencap": {"port_number": 2746, "protocols": ["tcp", "udp"]},
    "fjippol-swrly": {"port_number": 2747, "protocols": ["tcp", "udp"]},
    "fjippol-polsvr": {"port_number": 2748, "protocols": ["tcp", "udp"]},
    "fjippol-cnsl": {"port_number": 2749, "protocols": ["tcp", "udp"]},
    "fjippol-port1": {"port_number": 2750, "protocols": ["tcp", "udp"]},
    "fjippol-port2": {"port_number": 2751, "protocols": ["tcp", "udp"]},
    "rsisysaccess": {"port_number": 2752, "protocols": ["tcp", "udp"]},
    "de-spot": {"port_number": 2753, "protocols": ["tcp", "udp"]},
    "apollo-cc": {"port_number": 2754, "protocols": ["tcp", "udp"]},
    "expresspay": {"port_number": 2755, "protocols": ["tcp", "udp"]},
    "simplement-tie": {"port_number": 2756, "protocols": ["tcp", "udp"]},
    "cnrp": {"port_number": 2757, "protocols": ["tcp", "udp"]},
    "apollo-status": {"port_number": 2758, "protocols": ["tcp", "udp"]},
    "apollo-gms": {"port_number": 2759, "protocols": ["tcp", "udp"]},
    "sabams": {"port_number": 2760, "protocols": ["tcp", "udp"]},
    "dicom-iscl": {"port_number": 2761, "protocols": ["tcp", "udp"]},
    "dicom-tls": {"port_number": 2762, "protocols": ["tcp", "udp"]},
    "desktop-dna": {"port_number": 2763, "protocols": ["tcp", "udp"]},
    "data-insurance": {"port_number": 2764, "protocols": ["tcp", "udp"]},
    "qip-audup": {"port_number": 2765, "protocols": ["tcp", "udp"]},
    "compaq-scp": {"port_number": 2766, "protocols": ["tcp", "udp"]},
    "uadtc": {"port_number": 2767, "protocols": ["tcp", "udp"]},
    "uacs": {"port_number": 2768, "protocols": ["tcp", "udp"]},
    "exce": {"port_number": 2769, "protocols": ["tcp", "udp"]},
    "veronica": {"port_number": 2770, "protocols": ["tcp", "udp"]},
    "vergencecm": {"port_number": 2771, "protocols": ["tcp", "udp"]},
    "auris": {"port_number": 2772, "protocols": ["tcp", "udp"]},
    "rbakcup1": {"port_number": 2773, "protocols": ["tcp", "udp"]},
    "rbakcup2": {"port_number": 2774, "protocols": ["tcp", "udp"]},
    "smpp": {"port_number": 2775, "protocols": ["tcp", "udp"]},
    "ridgeway1": {"port_number": 2776, "protocols": ["tcp", "udp"]},
    "ridgeway2": {"port_number": 2777, "protocols": ["tcp", "udp"]},
    "gwen-sonya": {"port_number": 2778, "protocols": ["tcp", "udp"]},
    "lbc-sync": {"port_number": 2779, "protocols": ["tcp", "udp"]},
    "lbc-control": {"port_number": 2780, "protocols": ["tcp", "udp"]},
    "whosells": {"port_number": 2781, "protocols": ["tcp", "udp"]},
    "everydayrc": {"port_number": 2782, "protocols": ["tcp", "udp"]},
    "aises": {"port_number": 2783, "protocols": ["tcp", "udp"]},
    "www-dev": {"port_number": 2784, "protocols": ["tcp", "udp"]},
    "aic-np": {"port_number": 2785, "protocols": ["tcp", "udp"]},
    "aic-oncrpc": {"port_number": 2786, "protocols": ["tcp", "udp"]},
    "piccolo": {"port_number": 2787, "protocols": ["tcp", "udp"]},
    "fryeserv": {"port_number": 2788, "protocols": ["tcp", "udp"]},
    "media-agent": {"port_number": 2789, "protocols": ["tcp", "udp"]},
    "plgproxy": {"port_number": 2790, "protocols": ["tcp", "udp"]},
    "mtport-regist": {"port_number": 2791, "protocols": ["tcp", "udp"]},
    "f5-globalsite": {"port_number": 2792, "protocols": ["tcp", "udp"]},
    "initlsmsad": {"port_number": 2793, "protocols": ["tcp", "udp"]},
    "urp": {"port_number": 2794, "protocols": ["tcp", "udp"]},
    "livestats": {"port_number": 2795, "protocols": ["tcp", "udp"]},
    "ac-tech": {"port_number": 2796, "protocols": ["tcp", "udp"]},
    "esp-encap": {"port_number": 2797, "protocols": ["tcp", "udp"]},
    "tmesis-upshot": {"port_number": 2798, "protocols": ["tcp", "udp"]},
    "icon-discover": {"port_number": 2799, "protocols": ["tcp", "udp"]},
    "acc-raid": {"port_number": 2800, "protocols": ["tcp", "udp"]},
    "igcp": {"port_number": 2801, "protocols": ["tcp", "udp"]},
    "veritas-tcp1": {"port_number": 2802, "protocols": ["tcp"]},
    "veritas-udp1": {"port_number": 2802, "protocols": ["udp"]},
    "btprjctrl": {"port_number": 2803, "protocols": ["tcp", "udp"]},
    "dvr-esm": {"port_number": 2804, "protocols": ["tcp", "udp"]},
    "wta-wsp-s": {"port_number": 2805, "protocols": ["tcp", "udp"]},
    "cspuni": {"port_number": 2806, "protocols": ["tcp", "udp"]},
    "cspmulti": {"port_number": 2807, "protocols": ["tcp", "udp"]},
    "j-lan-p": {"port_number": 2808, "protocols": ["tcp", "udp"]},
    "corbaloc": {"port_number": 2809, "protocols": ["tcp", "udp"]},
    "netsteward": {"port_number": 2810, "protocols": ["tcp", "udp"]},
    "gsiftp": {"port_number": 2811, "protocols": ["tcp", "udp"]},
    "atmtcp": {"port_number": 2812, "protocols": ["tcp", "udp"]},
    "llm-pass": {"port_number": 2813, "protocols": ["tcp", "udp"]},
    "llm-csv": {"port_number": 2814, "protocols": ["tcp", "udp"]},
    "lbc-measure": {"port_number": 2815, "protocols": ["tcp", "udp"]},
    "lbc-watchdog": {"port_number": 2816, "protocols": ["tcp", "udp"]},
    "nmsigport": {"port_number": 2817, "protocols": ["tcp", "udp"]},
    "rmlnk": {"port_number": 2818, "protocols": ["tcp", "udp"]},
    "fc-faultnotify": {"port_number": 2819, "protocols": ["tcp", "udp"]},
    "univision": {"port_number": 2820, "protocols": ["tcp", "udp"]},
    "vrts-at-port": {"port_number": 2821, "protocols": ["tcp", "udp"]},
    "ka0wuc": {"port_number": 2822, "protocols": ["tcp", "udp"]},
    "cqg-netlan": {"port_number": 2823, "protocols": ["tcp", "udp"]},
    "cqg-netlan-1": {"port_number": 2824, "protocols": ["tcp", "udp"]},
    "slc-systemlog": {"port_number": 2826, "protocols": ["tcp", "udp"]},
    "slc-ctrlrloops": {"port_number": 2827, "protocols": ["tcp", "udp"]},
    "itm-lm": {"port_number": 2828, "protocols": ["tcp", "udp"]},
    "silkp1": {"port_number": 2829, "protocols": ["tcp", "udp"]},
    "silkp2": {"port_number": 2830, "protocols": ["tcp", "udp"]},
    "silkp3": {"port_number": 2831, "protocols": ["tcp", "udp"]},
    "silkp4": {"port_number": 2832, "protocols": ["tcp", "udp"]},
    "glishd": {"port_number": 2833, "protocols": ["tcp", "udp"]},
    "evtp": {"port_number": 2834, "protocols": ["tcp", "udp"]},
    "evtp-data": {"port_number": 2835, "protocols": ["tcp", "udp"]},
    "catalyst": {"port_number": 2836, "protocols": ["tcp", "udp"]},
    "repliweb": {"port_number": 2837, "protocols": ["tcp", "udp"]},
    "starbot": {"port_number": 2838, "protocols": ["tcp", "udp"]},
    "nmsigport-secondary": {"port_number": 2839, "protocols": ["tcp", "udp"]},
    "l3-exprt": {"port_number": 2840, "protocols": ["tcp", "udp"]},
    "l3-ranger": {"port_number": 2841, "protocols": ["tcp", "udp"]},
    "l3-hawk": {"port_number": 2842, "protocols": ["tcp", "udp"]},
    "pdnet": {"port_number": 2843, "protocols": ["tcp", "udp"]},
    "bpcp-poll": {"port_number": 2844, "protocols": ["tcp", "udp"]},
    "bpcp-trap": {"port_number": 2845, "protocols": ["tcp", "udp"]},
    "aimpp-hello": {"port_number": 2846, "protocols": ["tcp", "udp"]},
    "aimpp-port-req": {"port_number": 2847, "protocols": ["tcp", "udp"]},
    "amt-blc-port": {"port_number": 2848, "protocols": ["tcp", "udp"]},
    "fxp-secondary": {"port_number": 2849, "protocols": ["tcp", "udp"]},
    "metaconsole": {"port_number": 2850, "protocols": ["tcp", "udp"]},
    "webemshttp": {"port_number": 2851, "protocols": ["tcp", "udp"]},
    "bears-01": {"port_number": 2852, "protocols": ["tcp", "udp"]},
    "ispipes": {"port_number": 2853, "protocols": ["tcp", "udp"]},
    "infomover": {"port_number": 2854, "protocols": ["tcp", "udp"]},
    "msrp": {"port_number": 2855, "protocols": ["tcp"]},
    "cesdinv": {"port_number": 2856, "protocols": ["tcp", "udp"]},
    "simctlp": {"port_number": 2857, "protocols": ["tcp", "udp"]},
    "ecnp": {"port_number": 2858, "protocols": ["tcp", "udp"]},
    "activememory": {"port_number": 2859, "protocols": ["tcp", "udp"]},
    "dialpad-voice1": {"port_number": 2860, "protocols": ["tcp", "udp"]},
    "dialpad-voice2": {"port_number": 2861, "protocols": ["tcp", "udp"]},
    "ttg-protocol": {"port_number": 2862, "protocols": ["tcp", "udp"]},
    "sonardata": {"port_number": 2863, "protocols": ["tcp", "udp"]},
    "astronova-main": {"port_number": 2864, "protocols": ["tcp", "udp"]},
    "pit-vpn": {"port_number": 2865, "protocols": ["tcp", "udp"]},
    "iwlistener": {"port_number": 2866, "protocols": ["tcp", "udp"]},
    "esps-portal": {"port_number": 2867, "protocols": ["tcp", "udp"]},
    "npep-messaging": {"port_number": 2868, "protocols": ["tcp", "udp"]},
    "icslap": {"port_number": 2869, "protocols": ["tcp", "udp"]},
    "daishi": {"port_number": 2870, "protocols": ["tcp", "udp"]},
    "msi-selectplay": {"port_number": 2871, "protocols": ["tcp", "udp"]},
    "radix": {"port_number": 2872, "protocols": ["tcp", "udp"]},
    "psrt": {"port_number": 2873, "protocols": ["tcp", "udp"]},
    "dxmessagebase1": {"port_number": 2874, "protocols": ["tcp", "udp"]},
    "dxmessagebase2": {"port_number": 2875, "protocols": ["tcp", "udp"]},
    "sps-tunnel": {"port_number": 2876, "protocols": ["tcp", "udp"]},
    "bluelance": {"port_number": 2877, "protocols": ["tcp", "udp"]},
    "aap": {"port_number": 2878, "protocols": ["tcp", "udp"]},
    "ucentric-ds": {"port_number": 2879, "protocols": ["tcp", "udp"]},
    "synapse": {"port_number": 2880, "protocols": ["tcp", "udp"]},
    "ndsp": {"port_number": 2881, "protocols": ["tcp", "udp"]},
    "ndtp": {"port_number": 2882, "protocols": ["tcp", "udp"]},
    "ndnp": {"port_number": 2883, "protocols": ["tcp", "udp"]},
    "flashmsg": {"port_number": 2884, "protocols": ["tcp", "udp"]},
    "topflow": {"port_number": 2885, "protocols": ["tcp", "udp"]},
    "responselogic": {"port_number": 2886, "protocols": ["tcp", "udp"]},
    "aironetddp": {"port_number": 2887, "protocols": ["tcp", "udp"]},
    "spcsdlobby": {"port_number": 2888, "protocols": ["tcp", "udp"]},
    "rsom": {"port_number": 2889, "protocols": ["tcp", "udp"]},
    "cspclmulti": {"port_number": 2890, "protocols": ["tcp", "udp"]},
    "cinegrfx-elmd": {"port_number": 2891, "protocols": ["tcp", "udp"]},
    "snifferdata": {"port_number": 2892, "protocols": ["tcp", "udp"]},
    "vseconnector": {"port_number": 2893, "protocols": ["tcp", "udp"]},
    "abacus-remote": {"port_number": 2894, "protocols": ["tcp", "udp"]},
    "natuslink": {"port_number": 2895, "protocols": ["tcp", "udp"]},
    "ecovisiong6-1": {"port_number": 2896, "protocols": ["tcp", "udp"]},
    "citrix-rtmp": {"port_number": 2897, "protocols": ["tcp", "udp"]},
    "appliance-cfg": {"port_number": 2898, "protocols": ["tcp", "udp"]},
    "powergemplus": {"port_number": 2899, "protocols": ["tcp", "udp"]},
    "quicksuite": {"port_number": 2900, "protocols": ["tcp", "udp"]},
    "allstorcns": {"port_number": 2901, "protocols": ["tcp", "udp"]},
    "netaspi": {"port_number": 2902, "protocols": ["tcp", "udp"]},
    "suitcase": {"port_number": 2903, "protocols": ["tcp", "udp"]},
    "m2ua": {"port_number": 2904, "protocols": ["tcp", "udp", "sctp"]},
    "m3ua": {"port_number": 2905, "protocols": ["tcp", "sctp"]},
    "caller9": {"port_number": 2906, "protocols": ["tcp", "udp"]},
    "webmethods-b2b": {"port_number": 2907, "protocols": ["tcp", "udp"]},
    "mao": {"port_number": 2908, "protocols": ["tcp", "udp"]},
    "funk-dialout": {"port_number": 2909, "protocols": ["tcp", "udp"]},
    "tdaccess": {"port_number": 2910, "protocols": ["tcp", "udp"]},
    "blockade": {"port_number": 2911, "protocols": ["tcp", "udp"]},
    "epicon": {"port_number": 2912, "protocols": ["tcp", "udp"]},
    "boosterware": {"port_number": 2913, "protocols": ["tcp", "udp"]},
    "gamelobby": {"port_number": 2914, "protocols": ["tcp", "udp"]},
    "tksocket": {"port_number": 2915, "protocols": ["tcp", "udp"]},
    "elvin-server": {"port_number": 2916, "protocols": ["tcp", "udp"]},
    "elvin_server": {"port_number": 2916, "protocols": ["tcp", "udp"]},
    "elvin-client": {"port_number": 2917, "protocols": ["tcp", "udp"]},
    "elvin_client": {"port_number": 2917, "protocols": ["tcp", "udp"]},
    "kastenchasepad": {"port_number": 2918, "protocols": ["tcp", "udp"]},
    "roboer": {"port_number": 2919, "protocols": ["tcp", "udp"]},
    "roboeda": {"port_number": 2920, "protocols": ["tcp", "udp"]},
    "cesdcdman": {"port_number": 2921, "protocols": ["tcp", "udp"]},
    "cesdcdtrn": {"port_number": 2922, "protocols": ["tcp", "udp"]},
    "wta-wsp-wtp-s": {"port_number": 2923, "protocols": ["tcp", "udp"]},
    "precise-vip": {"port_number": 2924, "protocols": ["tcp", "udp"]},
    "mobile-file-dl": {"port_number": 2926, "protocols": ["tcp", "udp"]},
    "unimobilectrl": {"port_number": 2927, "protocols": ["tcp", "udp"]},
    "redstone-cpss": {"port_number": 2928, "protocols": ["tcp", "udp"]},
    "amx-webadmin": {"port_number": 2929, "protocols": ["tcp", "udp"]},
    "amx-weblinx": {"port_number": 2930, "protocols": ["tcp", "udp"]},
    "circle-x": {"port_number": 2931, "protocols": ["tcp", "udp"]},
    "incp": {"port_number": 2932, "protocols": ["tcp", "udp"]},
    "4-tieropmgw": {"port_number": 2933, "protocols": ["tcp", "udp"]},
    "4-tieropmcli": {"port_number": 2934, "protocols": ["tcp", "udp"]},
    "qtp": {"port_number": 2935, "protocols": ["tcp", "udp"]},
    "otpatch": {"port_number": 2936, "protocols": ["tcp", "udp"]},
    "pnaconsult-lm": {"port_number": 2937, "protocols": ["tcp", "udp"]},
    "sm-pas-1": {"port_number": 2938, "protocols": ["tcp", "udp"]},
    "sm-pas-2": {"port_number": 2939, "protocols": ["tcp", "udp"]},
    "sm-pas-3": {"port_number": 2940, "protocols": ["tcp", "udp"]},
    "sm-pas-4": {"port_number": 2941, "protocols": ["tcp", "udp"]},
    "sm-pas-5": {"port_number": 2942, "protocols": ["tcp", "udp"]},
    "ttnrepository": {"port_number": 2943, "protocols": ["tcp", "udp"]},
    "megaco-h248": {"port_number": 2944, "protocols": ["tcp", "udp", "sctp"]},
    "h248-binary": {"port_number": 2945, "protocols": ["tcp", "udp", "sctp"]},
    "fjsvmpor": {"port_number": 2946, "protocols": ["tcp", "udp"]},
    "gpsd": {"port_number": 2947, "protocols": ["tcp", "udp"]},
    "wap-push": {"port_number": 2948, "protocols": ["tcp", "udp"]},
    "wap-pushsecure": {"port_number": 2949, "protocols": ["tcp", "udp"]},
    "esip": {"port_number": 2950, "protocols": ["tcp", "udp"]},
    "ottp": {"port_number": 2951, "protocols": ["tcp", "udp"]},
    "mpfwsas": {"port_number": 2952, "protocols": ["tcp", "udp"]},
    "ovalarmsrv": {"port_number": 2953, "protocols": ["tcp", "udp"]},
    "ovalarmsrv-cmd": {"port_number": 2954, "protocols": ["tcp", "udp"]},
    "csnotify": {"port_number": 2955, "protocols": ["tcp", "udp"]},
    "ovrimosdbman": {"port_number": 2956, "protocols": ["tcp", "udp"]},
    "jmact5": {"port_number": 2957, "protocols": ["tcp", "udp"]},
    "jmact6": {"port_number": 2958, "protocols": ["tcp", "udp"]},
    "rmopagt": {"port_number": 2959, "protocols": ["tcp", "udp"]},
    "dfoxserver": {"port_number": 2960, "protocols": ["tcp", "udp"]},
    "boldsoft-lm": {"port_number": 2961, "protocols": ["tcp", "udp"]},
    "iph-policy-cli": {"port_number": 2962, "protocols": ["tcp", "udp"]},
    "iph-policy-adm": {"port_number": 2963, "protocols": ["tcp", "udp"]},
    "bullant-srap": {"port_number": 2964, "protocols": ["tcp", "udp"]},
    "bullant-rap": {"port_number": 2965, "protocols": ["tcp", "udp"]},
    "idp-infotrieve": {"port_number": 2966, "protocols": ["tcp", "udp"]},
    "ssc-agent": {"port_number": 2967, "protocols": ["tcp", "udp"]},
    "enpp": {"port_number": 2968, "protocols": ["tcp", "udp"]},
    "essp": {"port_number": 2969, "protocols": ["tcp", "udp"]},
    "index-net": {"port_number": 2970, "protocols": ["tcp", "udp"]},
    "netclip": {"port_number": 2971, "protocols": ["tcp", "udp"]},
    "pmsm-webrctl": {"port_number": 2972, "protocols": ["tcp", "udp"]},
    "svnetworks": {"port_number": 2973, "protocols": ["tcp", "udp"]},
    "signal": {"port_number": 2974, "protocols": ["tcp", "udp"]},
    "fjmpcm": {"port_number": 2975, "protocols": ["tcp", "udp"]},
    "cns-srv-port": {"port_number": 2976, "protocols": ["tcp", "udp"]},
    "ttc-etap-ns": {"port_number": 2977, "protocols": ["tcp", "udp"]},
    "ttc-etap-ds": {"port_number": 2978, "protocols": ["tcp", "udp"]},
    "h263-video": {"port_number": 2979, "protocols": ["tcp", "udp"]},
    "wimd": {"port_number": 2980, "protocols": ["tcp", "udp"]},
    "mylxamport": {"port_number": 2981, "protocols": ["tcp", "udp"]},
    "iwb-whiteboard": {"port_number": 2982, "protocols": ["tcp", "udp"]},
    "netplan": {"port_number": 2983, "protocols": ["tcp", "udp"]},
    "hpidsadmin": {"port_number": 2984, "protocols": ["tcp", "udp"]},
    "hpidsagent": {"port_number": 2985, "protocols": ["tcp", "udp"]},
    "stonefalls": {"port_number": 2986, "protocols": ["tcp", "udp"]},
    "identify": {"port_number": 2987, "protocols": ["tcp", "udp"]},
    "hippad": {"port_number": 2988, "protocols": ["tcp", "udp"]},
    "zarkov": {"port_number": 2989, "protocols": ["tcp", "udp"]},
    "boscap": {"port_number": 2990, "protocols": ["tcp", "udp"]},
    "wkstn-mon": {"port_number": 2991, "protocols": ["tcp", "udp"]},
    "avenyo": {"port_number": 2992, "protocols": ["tcp", "udp"]},
    "veritas-vis1": {"port_number": 2993, "protocols": ["tcp", "udp"]},
    "veritas-vis2": {"port_number": 2994, "protocols": ["tcp", "udp"]},
    "idrs": {"port_number": 2995, "protocols": ["tcp", "udp"]},
    "vsixml": {"port_number": 2996, "protocols": ["tcp", "udp"]},
    "rebol": {"port_number": 2997, "protocols": ["tcp", "udp"]},
    "realsecure": {"port_number": 2998, "protocols": ["tcp", "udp"]},
    "remoteware-un": {"port_number": 2999, "protocols": ["tcp", "udp"]},
    "hbci": {"port_number": 3000, "protocols": ["tcp", "udp"]},
    "remoteware-cl": {"port_number": 3000, "protocols": ["tcp", "udp"]},
    "origo-native": {"port_number": 3001, "protocols": ["tcp"]},
    "exlm-agent": {"port_number": 3002, "protocols": ["tcp", "udp"]},
    "remoteware-srv": {"port_number": 3002, "protocols": ["tcp", "udp"]},
    "cgms": {"port_number": 3003, "protocols": ["tcp", "udp"]},
    "csoftragent": {"port_number": 3004, "protocols": ["tcp", "udp"]},
    "geniuslm": {"port_number": 3005, "protocols": ["tcp", "udp"]},
    "ii-admin": {"port_number": 3006, "protocols": ["tcp", "udp"]},
    "lotusmtap": {"port_number": 3007, "protocols": ["tcp", "udp"]},
    "midnight-tech": {"port_number": 3008, "protocols": ["tcp", "udp"]},
    "pxc-ntfy": {"port_number": 3009, "protocols": ["tcp", "udp"]},
    "gw": {"port_number": 3010, "protocols": ["tcp"]},
    "ping-pong": {"port_number": 3010, "protocols": ["udp"]},
    "trusted-web": {"port_number": 3011, "protocols": ["tcp", "udp"]},
    "twsdss": {"port_number": 3012, "protocols": ["tcp", "udp"]},
    "gilatskysurfer": {"port_number": 3013, "protocols": ["tcp", "udp"]},
    "broker-service": {"port_number": 3014, "protocols": ["tcp", "udp"]},
    "broker_service": {"port_number": 3014, "protocols": ["tcp", "udp"]},
    "nati-dstp": {"port_number": 3015, "protocols": ["tcp", "udp"]},
    "notify-srvr": {"port_number": 3016, "protocols": ["tcp", "udp"]},
    "notify_srvr": {"port_number": 3016, "protocols": ["tcp", "udp"]},
    "event-listener": {"port_number": 3017, "protocols": ["tcp", "udp"]},
    "event_listener": {"port_number": 3017, "protocols": ["tcp", "udp"]},
    "srvc-registry": {"port_number": 3018, "protocols": ["tcp", "udp"]},
    "srvc_registry": {"port_number": 3018, "protocols": ["tcp", "udp"]},
    "resource-mgr": {"port_number": 3019, "protocols": ["tcp", "udp"]},
    "resource_mgr": {"port_number": 3019, "protocols": ["tcp", "udp"]},
    "cifs": {"port_number": 3020, "protocols": ["tcp", "udp"]},
    "agriserver": {"port_number": 3021, "protocols": ["tcp", "udp"]},
    "csregagent": {"port_number": 3022, "protocols": ["tcp", "udp"]},
    "magicnotes": {"port_number": 3023, "protocols": ["tcp", "udp"]},
    "nds-sso": {"port_number": 3024, "protocols": ["tcp", "udp"]},
    "nds_sso": {"port_number": 3024, "protocols": ["tcp", "udp"]},
    "arepa-raft": {"port_number": 3025, "protocols": ["tcp", "udp"]},
    "agri-gateway": {"port_number": 3026, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt-C": {"port_number": 3027, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt_C": {"port_number": 3027, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt-DM": {"port_number": 3028, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt_DM": {"port_number": 3028, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt-A": {"port_number": 3029, "protocols": ["tcp", "udp"]},
    "LiebDevMgmt_A": {"port_number": 3029, "protocols": ["tcp", "udp"]},
    "arepa-cas": {"port_number": 3030, "protocols": ["tcp", "udp"]},
    "eppc": {"port_number": 3031, "protocols": ["tcp", "udp"]},
    "redwood-chat": {"port_number": 3032, "protocols": ["tcp", "udp"]},
    "pdb": {"port_number": 3033, "protocols": ["tcp", "udp"]},
    "osmosis-aeea": {"port_number": 3034, "protocols": ["tcp", "udp"]},
    "fjsv-gssagt": {"port_number": 3035, "protocols": ["tcp", "udp"]},
    "hagel-dump": {"port_number": 3036, "protocols": ["tcp", "udp"]},
    "hp-san-mgmt": {"port_number": 3037, "protocols": ["tcp", "udp"]},
    "santak-ups": {"port_number": 3038, "protocols": ["tcp", "udp"]},
    "cogitate": {"port_number": 3039, "protocols": ["tcp", "udp"]},
    "tomato-springs": {"port_number": 3040, "protocols": ["tcp", "udp"]},
    "di-traceware": {"port_number": 3041, "protocols": ["tcp", "udp"]},
    "journee": {"port_number": 3042, "protocols": ["tcp", "udp"]},
    "brp": {"port_number": 3043, "protocols": ["tcp", "udp"]},
    "epp-secondary": {"port_number": 3044, "protocols": ["tcp", "udp"]},
    "responsenet": {"port_number": 3045, "protocols": ["tcp", "udp"]},
    "di-ase": {"port_number": 3046, "protocols": ["tcp", "udp"]},
    "hlserver": {"port_number": 3047, "protocols": ["tcp", "udp"]},
    "pctrader": {"port_number": 3048, "protocols": ["tcp", "udp"]},
    "nsws": {"port_number": 3049, "protocols": ["tcp", "udp"]},
    "gds-db": {"port_number": 3050, "protocols": ["tcp", "udp"]},
    "gds_db": {"port_number": 3050, "protocols": ["tcp", "udp"]},
    "galaxy-server": {"port_number": 3051, "protocols": ["tcp", "udp"]},
    "apc-3052": {"port_number": 3052, "protocols": ["tcp", "udp"]},
    "dsom-server": {"port_number": 3053, "protocols": ["tcp", "udp"]},
    "amt-cnf-prot": {"port_number": 3054, "protocols": ["tcp", "udp"]},
    "policyserver": {"port_number": 3055, "protocols": ["tcp", "udp"]},
    "cdl-server": {"port_number": 3056, "protocols": ["tcp", "udp"]},
    "goahead-fldup": {"port_number": 3057, "protocols": ["tcp", "udp"]},
    "videobeans": {"port_number": 3058, "protocols": ["tcp", "udp"]},
    "qsoft": {"port_number": 3059, "protocols": ["tcp", "udp"]},
    "interserver": {"port_number": 3060, "protocols": ["tcp", "udp"]},
    "cautcpd": {"port_number": 3061, "protocols": ["tcp", "udp"]},
    "ncacn-ip-tcp": {"port_number": 3062, "protocols": ["tcp", "udp"]},
    "ncadg-ip-udp": {"port_number": 3063, "protocols": ["tcp", "udp"]},
    "rprt": {"port_number": 3064, "protocols": ["tcp", "udp"]},
    "slinterbase": {"port_number": 3065, "protocols": ["tcp", "udp"]},
    "netattachsdmp": {"port_number": 3066, "protocols": ["tcp", "udp"]},
    "fjhpjp": {"port_number": 3067, "protocols": ["tcp", "udp"]},
    "ls3bcast": {"port_number": 3068, "protocols": ["tcp", "udp"]},
    "ls3": {"port_number": 3069, "protocols": ["tcp", "udp"]},
    "mgxswitch": {"port_number": 3070, "protocols": ["tcp", "udp"]},
    "xplat-replicate": {"port_number": 3071, "protocols": ["tcp"]},
    "csd-monitor": {"port_number": 3072, "protocols": ["tcp", "udp"]},
    "vcrp": {"port_number": 3073, "protocols": ["tcp", "udp"]},
    "xbox": {"port_number": 3074, "protocols": ["tcp", "udp"]},
    "orbix-locator": {"port_number": 3075, "protocols": ["tcp", "udp"]},
    "orbix-config": {"port_number": 3076, "protocols": ["tcp", "udp"]},
    "orbix-loc-ssl": {"port_number": 3077, "protocols": ["tcp", "udp"]},
    "orbix-cfg-ssl": {"port_number": 3078, "protocols": ["tcp", "udp"]},
    "lv-frontpanel": {"port_number": 3079, "protocols": ["tcp", "udp"]},
    "stm-pproc": {"port_number": 3080, "protocols": ["tcp", "udp"]},
    "stm_pproc": {"port_number": 3080, "protocols": ["tcp", "udp"]},
    "tl1-lv": {"port_number": 3081, "protocols": ["tcp", "udp"]},
    "tl1-raw": {"port_number": 3082, "protocols": ["tcp", "udp"]},
    "tl1-telnet": {"port_number": 3083, "protocols": ["tcp", "udp"]},
    "itm-mccs": {"port_number": 3084, "protocols": ["tcp", "udp"]},
    "pcihreq": {"port_number": 3085, "protocols": ["tcp", "udp"]},
    "jdl-dbkitchen": {"port_number": 3086, "protocols": ["tcp", "udp"]},
    "asoki-sma": {"port_number": 3087, "protocols": ["tcp", "udp"]},
    "xdtp": {"port_number": 3088, "protocols": ["tcp", "udp"]},
    "ptk-alink": {"port_number": 3089, "protocols": ["tcp", "udp"]},
    "stss": {"port_number": 3090, "protocols": ["tcp", "udp"]},
    "1ci-smcs": {"port_number": 3091, "protocols": ["tcp", "udp"]},
    "rapidmq-center": {"port_number": 3093, "protocols": ["tcp", "udp"]},
    "rapidmq-reg": {"port_number": 3094, "protocols": ["tcp", "udp"]},
    "panasas": {"port_number": 3095, "protocols": ["tcp", "udp"]},
    "ndl-aps": {"port_number": 3096, "protocols": ["tcp", "udp"]},
    "itu-bicc-stc": {"port_number": 3097, "protocols": ["sctp"]},
    "umm-port": {"port_number": 3098, "protocols": ["tcp", "udp"]},
    "chmd": {"port_number": 3099, "protocols": ["tcp", "udp"]},
    "opcon-xps": {"port_number": 3100, "protocols": ["tcp", "udp"]},
    "hp-pxpib": {"port_number": 3101, "protocols": ["tcp", "udp"]},
    "slslavemon": {"port_number": 3102, "protocols": ["tcp", "udp"]},
    "autocuesmi": {"port_number": 3103, "protocols": ["tcp", "udp"]},
    "autocuelog": {"port_number": 3104, "protocols": ["tcp"]},
    "autocuetime": {"port_number": 3104, "protocols": ["udp"]},
    "cardbox": {"port_number": 3105, "protocols": ["tcp", "udp"]},
    "cardbox-http": {"port_number": 3106, "protocols": ["tcp", "udp"]},
    "business": {"port_number": 3107, "protocols": ["tcp", "udp"]},
    "geolocate": {"port_number": 3108, "protocols": ["tcp", "udp"]},
    "personnel": {"port_number": 3109, "protocols": ["tcp", "udp"]},
    "sim-control": {"port_number": 3110, "protocols": ["tcp", "udp"]},
    "wsynch": {"port_number": 3111, "protocols": ["tcp", "udp"]},
    "ksysguard": {"port_number": 3112, "protocols": ["tcp", "udp"]},
    "cs-auth-svr": {"port_number": 3113, "protocols": ["tcp", "udp"]},
    "ccmad": {"port_number": 3114, "protocols": ["tcp", "udp"]},
    "mctet-master": {"port_number": 3115, "protocols": ["tcp", "udp"]},
    "mctet-gateway": {"port_number": 3116, "protocols": ["tcp", "udp"]},
    "mctet-jserv": {"port_number": 3117, "protocols": ["tcp", "udp"]},
    "pkagent": {"port_number": 3118, "protocols": ["tcp", "udp"]},
    "d2000kernel": {"port_number": 3119, "protocols": ["tcp", "udp"]},
    "d2000webserver": {"port_number": 3120, "protocols": ["tcp", "udp"]},
    "pcmk-remote": {"port_number": 3121, "protocols": ["tcp"]},
    "vtr-emulator": {"port_number": 3122, "protocols": ["tcp", "udp"]},
    "edix": {"port_number": 3123, "protocols": ["tcp", "udp"]},
    "beacon-port": {"port_number": 3124, "protocols": ["tcp", "udp"]},
    "a13-an": {"port_number": 3125, "protocols": ["tcp", "udp"]},
    "ctx-bridge": {"port_number": 3127, "protocols": ["tcp", "udp"]},
    "ndl-aas": {"port_number": 3128, "protocols": ["tcp", "udp"]},
    "netport-id": {"port_number": 3129, "protocols": ["tcp", "udp"]},
    "icpv2": {"port_number": 3130, "protocols": ["tcp", "udp"]},
    "netbookmark": {"port_number": 3131, "protocols": ["tcp", "udp"]},
    "ms-rule-engine": {"port_number": 3132, "protocols": ["tcp", "udp"]},
    "prism-deploy": {"port_number": 3133, "protocols": ["tcp", "udp"]},
    "ecp": {"port_number": 3134, "protocols": ["tcp", "udp"]},
    "peerbook-port": {"port_number": 3135, "protocols": ["tcp", "udp"]},
    "grubd": {"port_number": 3136, "protocols": ["tcp", "udp"]},
    "rtnt-1": {"port_number": 3137, "protocols": ["tcp", "udp"]},
    "rtnt-2": {"port_number": 3138, "protocols": ["tcp", "udp"]},
    "incognitorv": {"port_number": 3139, "protocols": ["tcp", "udp"]},
    "ariliamulti": {"port_number": 3140, "protocols": ["tcp", "udp"]},
    "vmodem": {"port_number": 3141, "protocols": ["tcp", "udp"]},
    "rdc-wh-eos": {"port_number": 3142, "protocols": ["tcp", "udp"]},
    "seaview": {"port_number": 3143, "protocols": ["tcp", "udp"]},
    "tarantella": {"port_number": 3144, "protocols": ["tcp", "udp"]},
    "csi-lfap": {"port_number": 3145, "protocols": ["tcp", "udp"]},
    "bears-02": {"port_number": 3146, "protocols": ["tcp", "udp"]},
    "rfio": {"port_number": 3147, "protocols": ["tcp", "udp"]},
    "nm-game-admin": {"port_number": 3148, "protocols": ["tcp", "udp"]},
    "nm-game-server": {"port_number": 3149, "protocols": ["tcp", "udp"]},
    "nm-asses-admin": {"port_number": 3150, "protocols": ["tcp", "udp"]},
    "nm-assessor": {"port_number": 3151, "protocols": ["tcp", "udp"]},
    "feitianrockey": {"port_number": 3152, "protocols": ["tcp", "udp"]},
    "s8-client-port": {"port_number": 3153, "protocols": ["tcp", "udp"]},
    "ccmrmi": {"port_number": 3154, "protocols": ["tcp", "udp"]},
    "jpegmpeg": {"port_number": 3155, "protocols": ["tcp", "udp"]},
    "indura": {"port_number": 3156, "protocols": ["tcp", "udp"]},
    "lsa-comm": {"port_number": 3157, "protocols": ["tcp", "udp"]},
    "stvp": {"port_number": 3158, "protocols": ["tcp", "udp"]},
    "navegaweb-port": {"port_number": 3159, "protocols": ["tcp", "udp"]},
    "tip-app-server": {"port_number": 3160, "protocols": ["tcp", "udp"]},
    "doc1lm": {"port_number": 3161, "protocols": ["tcp", "udp"]},
    "sflm": {"port_number": 3162, "protocols": ["tcp", "udp"]},
    "res-sap": {"port_number": 3163, "protocols": ["tcp", "udp"]},
    "imprs": {"port_number": 3164, "protocols": ["tcp", "udp"]},
    "newgenpay": {"port_number": 3165, "protocols": ["tcp", "udp"]},
    "sossecollector": {"port_number": 3166, "protocols": ["tcp", "udp"]},
    "nowcontact": {"port_number": 3167, "protocols": ["tcp", "udp"]},
    "poweronnud": {"port_number": 3168, "protocols": ["tcp", "udp"]},
    "serverview-as": {"port_number": 3169, "protocols": ["tcp", "udp"]},
    "serverview-asn": {"port_number": 3170, "protocols": ["tcp", "udp"]},
    "serverview-gf": {"port_number": 3171, "protocols": ["tcp", "udp"]},
    "serverview-rm": {"port_number": 3172, "protocols": ["tcp", "udp"]},
    "serverview-icc": {"port_number": 3173, "protocols": ["tcp", "udp"]},
    "armi-server": {"port_number": 3174, "protocols": ["tcp", "udp"]},
    "t1-e1-over-ip": {"port_number": 3175, "protocols": ["tcp", "udp"]},
    "ars-master": {"port_number": 3176, "protocols": ["tcp", "udp"]},
    "phonex-port": {"port_number": 3177, "protocols": ["tcp", "udp"]},
    "radclientport": {"port_number": 3178, "protocols": ["tcp", "udp"]},
    "h2gf-w-2m": {"port_number": 3179, "protocols": ["tcp", "udp"]},
    "mc-brk-srv": {"port_number": 3180, "protocols": ["tcp", "udp"]},
    "bmcpatrolagent": {"port_number": 3181, "protocols": ["tcp", "udp"]},
    "bmcpatrolrnvu": {"port_number": 3182, "protocols": ["tcp", "udp"]},
    "cops-tls": {"port_number": 3183, "protocols": ["tcp", "udp"]},
    "apogeex-port": {"port_number": 3184, "protocols": ["tcp", "udp"]},
    "smpppd": {"port_number": 3185, "protocols": ["tcp", "udp"]},
    "iiw-port": {"port_number": 3186, "protocols": ["tcp", "udp"]},
    "odi-port": {"port_number": 3187, "protocols": ["tcp", "udp"]},
    "brcm-comm-port": {"port_number": 3188, "protocols": ["tcp", "udp"]},
    "pcle-infex": {"port_number": 3189, "protocols": ["tcp", "udp"]},
    "csvr-proxy": {"port_number": 3190, "protocols": ["tcp", "udp"]},
    "csvr-sslproxy": {"port_number": 3191, "protocols": ["tcp", "udp"]},
    "firemonrcc": {"port_number": 3192, "protocols": ["tcp", "udp"]},
    "spandataport": {"port_number": 3193, "protocols": ["tcp", "udp"]},
    "magbind": {"port_number": 3194, "protocols": ["tcp", "udp"]},
    "ncu-1": {"port_number": 3195, "protocols": ["tcp", "udp"]},
    "ncu-2": {"port_number": 3196, "protocols": ["tcp", "udp"]},
    "embrace-dp-s": {"port_number": 3197, "protocols": ["tcp", "udp"]},
    "embrace-dp-c": {"port_number": 3198, "protocols": ["tcp", "udp"]},
    "dmod-workspace": {"port_number": 3199, "protocols": ["tcp", "udp"]},
    "tick-port": {"port_number": 3200, "protocols": ["tcp", "udp"]},
    "cpq-tasksmart": {"port_number": 3201, "protocols": ["tcp", "udp"]},
    "intraintra": {"port_number": 3202, "protocols": ["tcp", "udp"]},
    "netwatcher-mon": {"port_number": 3203, "protocols": ["tcp", "udp"]},
    "netwatcher-db": {"port_number": 3204, "protocols": ["tcp", "udp"]},
    "isns": {"port_number": 3205, "protocols": ["tcp", "udp"]},
    "ironmail": {"port_number": 3206, "protocols": ["tcp", "udp"]},
    "vx-auth-port": {"port_number": 3207, "protocols": ["tcp", "udp"]},
    "pfu-prcallback": {"port_number": 3208, "protocols": ["tcp", "udp"]},
    "netwkpathengine": {"port_number": 3209, "protocols": ["tcp", "udp"]},
    "flamenco-proxy": {"port_number": 3210, "protocols": ["tcp", "udp"]},
    "avsecuremgmt": {"port_number": 3211, "protocols": ["tcp", "udp"]},
    "surveyinst": {"port_number": 3212, "protocols": ["tcp", "udp"]},
    "neon24x7": {"port_number": 3213, "protocols": ["tcp", "udp"]},
    "jmq-daemon-1": {"port_number": 3214, "protocols": ["tcp", "udp"]},
    "jmq-daemon-2": {"port_number": 3215, "protocols": ["tcp", "udp"]},
    "ferrari-foam": {"port_number": 3216, "protocols": ["tcp", "udp"]},
    "unite": {"port_number": 3217, "protocols": ["tcp", "udp"]},
    "smartpackets": {"port_number": 3218, "protocols": ["tcp", "udp"]},
    "wms-messenger": {"port_number": 3219, "protocols": ["tcp", "udp"]},
    "xnm-ssl": {"port_number": 3220, "protocols": ["tcp", "udp"]},
    "xnm-clear-text": {"port_number": 3221, "protocols": ["tcp", "udp"]},
    "glbp": {"port_number": 3222, "protocols": ["tcp", "udp"]},
    "digivote": {"port_number": 3223, "protocols": ["tcp", "udp"]},
    "aes-discovery": {"port_number": 3224, "protocols": ["tcp", "udp"]},
    "fcip-port": {"port_number": 3225, "protocols": ["tcp", "udp"]},
    "isi-irp": {"port_number": 3226, "protocols": ["tcp", "udp"]},
    "dwnmshttp": {"port_number": 3227, "protocols": ["tcp", "udp"]},
    "dwmsgserver": {"port_number": 3228, "protocols": ["tcp", "udp"]},
    "global-cd-port": {"port_number": 3229, "protocols": ["tcp", "udp"]},
    "sftdst-port": {"port_number": 3230, "protocols": ["tcp", "udp"]},
    "vidigo": {"port_number": 3231, "protocols": ["tcp", "udp"]},
    "mdtp": {"port_number": 3232, "protocols": ["tcp", "udp"]},
    "whisker": {"port_number": 3233, "protocols": ["tcp", "udp"]},
    "alchemy": {"port_number": 3234, "protocols": ["tcp", "udp"]},
    "mdap-port": {"port_number": 3235, "protocols": ["tcp", "udp"]},
    "apparenet-ts": {"port_number": 3236, "protocols": ["tcp", "udp"]},
    "apparenet-tps": {"port_number": 3237, "protocols": ["tcp", "udp"]},
    "apparenet-as": {"port_number": 3238, "protocols": ["tcp", "udp"]},
    "apparenet-ui": {"port_number": 3239, "protocols": ["tcp", "udp"]},
    "triomotion": {"port_number": 3240, "protocols": ["tcp", "udp"]},
    "sysorb": {"port_number": 3241, "protocols": ["tcp", "udp"]},
    "sdp-id-port": {"port_number": 3242, "protocols": ["tcp", "udp"]},
    "timelot": {"port_number": 3243, "protocols": ["tcp", "udp"]},
    "onesaf": {"port_number": 3244, "protocols": ["tcp", "udp"]},
    "vieo-fe": {"port_number": 3245, "protocols": ["tcp", "udp"]},
    "dvt-system": {"port_number": 3246, "protocols": ["tcp", "udp"]},
    "dvt-data": {"port_number": 3247, "protocols": ["tcp", "udp"]},
    "procos-lm": {"port_number": 3248, "protocols": ["tcp", "udp"]},
    "ssp": {"port_number": 3249, "protocols": ["tcp", "udp"]},
    "hicp": {"port_number": 3250, "protocols": ["tcp", "udp"]},
    "sysscanner": {"port_number": 3251, "protocols": ["tcp", "udp"]},
    "dhe": {"port_number": 3252, "protocols": ["tcp", "udp"]},
    "pda-data": {"port_number": 3253, "protocols": ["tcp", "udp"]},
    "pda-sys": {"port_number": 3254, "protocols": ["tcp", "udp"]},
    "semaphore": {"port_number": 3255, "protocols": ["tcp", "udp"]},
    "cpqrpm-agent": {"port_number": 3256, "protocols": ["tcp", "udp"]},
    "cpqrpm-server": {"port_number": 3257, "protocols": ["tcp", "udp"]},
    "ivecon-port": {"port_number": 3258, "protocols": ["tcp", "udp"]},
    "epncdp2": {"port_number": 3259, "protocols": ["tcp", "udp"]},
    "iscsi-target": {"port_number": 3260, "protocols": ["tcp", "udp"]},
    "winshadow": {"port_number": 3261, "protocols": ["tcp", "udp"]},
    "necp": {"port_number": 3262, "protocols": ["tcp", "udp"]},
    "ecolor-imager": {"port_number": 3263, "protocols": ["tcp", "udp"]},
    "ccmail": {"port_number": 3264, "protocols": ["tcp", "udp"]},
    "altav-tunnel": {"port_number": 3265, "protocols": ["tcp", "udp"]},
    "ns-cfg-server": {"port_number": 3266, "protocols": ["tcp", "udp"]},
    "ibm-dial-out": {"port_number": 3267, "protocols": ["tcp", "udp"]},
    "msft-gc": {"port_number": 3268, "protocols": ["tcp", "udp"]},
    "msft-gc-ssl": {"port_number": 3269, "protocols": ["tcp", "udp"]},
    "verismart": {"port_number": 3270, "protocols": ["tcp", "udp"]},
    "csoft-prev": {"port_number": 3271, "protocols": ["tcp", "udp"]},
    "user-manager": {"port_number": 3272, "protocols": ["tcp", "udp"]},
    "sxmp": {"port_number": 3273, "protocols": ["tcp", "udp"]},
    "ordinox-server": {"port_number": 3274, "protocols": ["tcp", "udp"]},
    "samd": {"port_number": 3275, "protocols": ["tcp", "udp"]},
    "maxim-asics": {"port_number": 3276, "protocols": ["tcp", "udp"]},
    "awg-proxy": {"port_number": 3277, "protocols": ["tcp", "udp"]},
    "lkcmserver": {"port_number": 3278, "protocols": ["tcp", "udp"]},
    "admind": {"port_number": 3279, "protocols": ["tcp", "udp"]},
    "vs-server": {"port_number": 3280, "protocols": ["tcp", "udp"]},
    "sysopt": {"port_number": 3281, "protocols": ["tcp", "udp"]},
    "datusorb": {"port_number": 3282, "protocols": ["tcp", "udp"]},
    "net-assistant": {"port_number": 3283, "protocols": ["tcp", "udp"]},
    "4talk": {"port_number": 3284, "protocols": ["tcp", "udp"]},
    "plato": {"port_number": 3285, "protocols": ["tcp", "udp"]},
    "e-net": {"port_number": 3286, "protocols": ["tcp", "udp"]},
    "directvdata": {"port_number": 3287, "protocols": ["tcp", "udp"]},
    "cops": {"port_number": 3288, "protocols": ["tcp", "udp"]},
    "enpc": {"port_number": 3289, "protocols": ["tcp", "udp"]},
    "caps-lm": {"port_number": 3290, "protocols": ["tcp", "udp"]},
    "sah-lm": {"port_number": 3291, "protocols": ["tcp", "udp"]},
    "cart-o-rama": {"port_number": 3292, "protocols": ["tcp", "udp"]},
    "fg-fps": {"port_number": 3293, "protocols": ["tcp", "udp"]},
    "fg-gip": {"port_number": 3294, "protocols": ["tcp", "udp"]},
    "dyniplookup": {"port_number": 3295, "protocols": ["tcp", "udp"]},
    "rib-slm": {"port_number": 3296, "protocols": ["tcp", "udp"]},
    "cytel-lm": {"port_number": 3297, "protocols": ["tcp", "udp"]},
    "deskview": {"port_number": 3298, "protocols": ["tcp", "udp"]},
    "pdrncs": {"port_number": 3299, "protocols": ["tcp", "udp"]},
    "ceph": {"port_number": 3300, "protocols": ["tcp"]},
    "tarantool": {"port_number": 3301, "protocols": ["tcp", "udp"]},
    "mcs-fastmail": {"port_number": 3302, "protocols": ["tcp", "udp"]},
    "opsession-clnt": {"port_number": 3303, "protocols": ["tcp", "udp"]},
    "opsession-srvr": {"port_number": 3304, "protocols": ["tcp", "udp"]},
    "odette-ftp": {"port_number": 3305, "protocols": ["tcp", "udp"]},
    "mysql": {"port_number": 3306, "protocols": ["tcp", "udp"]},
    "opsession-prxy": {"port_number": 3307, "protocols": ["tcp", "udp"]},
    "tns-server": {"port_number": 3308, "protocols": ["tcp", "udp"]},
    "tns-adv": {"port_number": 3309, "protocols": ["tcp", "udp"]},
    "dyna-access": {"port_number": 3310, "protocols": ["tcp", "udp"]},
    "mcns-tel-ret": {"port_number": 3311, "protocols": ["tcp", "udp"]},
    "appman-server": {"port_number": 3312, "protocols": ["tcp", "udp"]},
    "uorb": {"port_number": 3313, "protocols": ["tcp", "udp"]},
    "uohost": {"port_number": 3314, "protocols": ["tcp", "udp"]},
    "cdid": {"port_number": 3315, "protocols": ["tcp", "udp"]},
    "aicc-cmi": {"port_number": 3316, "protocols": ["tcp", "udp"]},
    "vsaiport": {"port_number": 3317, "protocols": ["tcp", "udp"]},
    "ssrip": {"port_number": 3318, "protocols": ["tcp", "udp"]},
    "sdt-lmd": {"port_number": 3319, "protocols": ["tcp", "udp"]},
    "officelink2000": {"port_number": 3320, "protocols": ["tcp", "udp"]},
    "vnsstr": {"port_number": 3321, "protocols": ["tcp", "udp"]},
    "sftu": {"port_number": 3326, "protocols": ["tcp", "udp"]},
    "bbars": {"port_number": 3327, "protocols": ["tcp", "udp"]},
    "egptlm": {"port_number": 3328, "protocols": ["tcp", "udp"]},
    "hp-device-disc": {"port_number": 3329, "protocols": ["tcp", "udp"]},
    "mcs-calypsoicf": {"port_number": 3330, "protocols": ["tcp", "udp"]},
    "mcs-messaging": {"port_number": 3331, "protocols": ["tcp", "udp"]},
    "mcs-mailsvr": {"port_number": 3332, "protocols": ["tcp", "udp"]},
    "dec-notes": {"port_number": 3333, "protocols": ["tcp", "udp"]},
    "directv-web": {"port_number": 3334, "protocols": ["tcp", "udp"]},
    "directv-soft": {"port_number": 3335, "protocols": ["tcp", "udp"]},
    "directv-tick": {"port_number": 3336, "protocols": ["tcp", "udp"]},
    "directv-catlg": {"port_number": 3337, "protocols": ["tcp", "udp"]},
    "anet-b": {"port_number": 3338, "protocols": ["tcp", "udp"]},
    "anet-l": {"port_number": 3339, "protocols": ["tcp", "udp"]},
    "anet-m": {"port_number": 3340, "protocols": ["tcp", "udp"]},
    "anet-h": {"port_number": 3341, "protocols": ["tcp", "udp"]},
    "webtie": {"port_number": 3342, "protocols": ["tcp", "udp"]},
    "ms-cluster-net": {"port_number": 3343, "protocols": ["tcp", "udp"]},
    "bnt-manager": {"port_number": 3344, "protocols": ["tcp", "udp"]},
    "influence": {"port_number": 3345, "protocols": ["tcp", "udp"]},
    "trnsprntproxy": {"port_number": 3346, "protocols": ["tcp", "udp"]},
    "phoenix-rpc": {"port_number": 3347, "protocols": ["tcp", "udp"]},
    "pangolin-laser": {"port_number": 3348, "protocols": ["tcp", "udp"]},
    "chevinservices": {"port_number": 3349, "protocols": ["tcp", "udp"]},
    "findviatv": {"port_number": 3350, "protocols": ["tcp", "udp"]},
    "btrieve": {"port_number": 3351, "protocols": ["tcp", "udp"]},
    "ssql": {"port_number": 3352, "protocols": ["tcp", "udp"]},
    "fatpipe": {"port_number": 3353, "protocols": ["tcp", "udp"]},
    "suitjd": {"port_number": 3354, "protocols": ["tcp", "udp"]},
    "ordinox-dbase": {"port_number": 3355, "protocols": ["tcp", "udp"]},
    "upnotifyps": {"port_number": 3356, "protocols": ["tcp", "udp"]},
    "adtech-test": {"port_number": 3357, "protocols": ["tcp", "udp"]},
    "mpsysrmsvr": {"port_number": 3358, "protocols": ["tcp", "udp"]},
    "wg-netforce": {"port_number": 3359, "protocols": ["tcp", "udp"]},
    "kv-server": {"port_number": 3360, "protocols": ["tcp", "udp"]},
    "kv-agent": {"port_number": 3361, "protocols": ["tcp", "udp"]},
    "dj-ilm": {"port_number": 3362, "protocols": ["tcp", "udp"]},
    "nati-vi-server": {"port_number": 3363, "protocols": ["tcp", "udp"]},
    "creativeserver-secondary": {"port_number": 3364, "protocols": ["tcp", "udp"]},
    "contentserver-secondary": {"port_number": 3365, "protocols": ["tcp", "udp"]},
    "creativepartnr-secondary": {"port_number": 3366, "protocols": ["tcp", "udp"]},
    "tip2": {"port_number": 3372, "protocols": ["tcp", "udp"]},
    "lavenir-lm": {"port_number": 3373, "protocols": ["tcp", "udp"]},
    "cluster-disc": {"port_number": 3374, "protocols": ["tcp", "udp"]},
    "vsnm-agent": {"port_number": 3375, "protocols": ["tcp", "udp"]},
    "cdbroker": {"port_number": 3376, "protocols": ["tcp", "udp"]},
    "cogsys-lm": {"port_number": 3377, "protocols": ["tcp", "udp"]},
    "wsicopy": {"port_number": 3378, "protocols": ["tcp", "udp"]},
    "socorfs": {"port_number": 3379, "protocols": ["tcp", "udp"]},
    "sns-channels": {"port_number": 3380, "protocols": ["tcp", "udp"]},
    "geneous": {"port_number": 3381, "protocols": ["tcp", "udp"]},
    "fujitsu-neat": {"port_number": 3382, "protocols": ["tcp", "udp"]},
    "esp-lm": {"port_number": 3383, "protocols": ["tcp", "udp"]},
    "hp-clic": {"port_number": 3384, "protocols": ["tcp", "udp"]},
    "qnxnetman": {"port_number": 3385, "protocols": ["tcp", "udp"]},
    "gprs-data": {"port_number": 3386, "protocols": ["tcp"]},
    "gprs-sig": {"port_number": 3386, "protocols": ["udp"]},
    "backroomnet": {"port_number": 3387, "protocols": ["tcp", "udp"]},
    "cbserver": {"port_number": 3388, "protocols": ["tcp", "udp"]},
    "ms-wbt-server": {"port_number": 3389, "protocols": ["tcp", "udp"]},
    "dsc": {"port_number": 3390, "protocols": ["tcp", "udp"]},
    "savant": {"port_number": 3391, "protocols": ["tcp", "udp"]},
    "efi-lm": {"port_number": 3392, "protocols": ["tcp", "udp"]},
    "d2k-tapestry1": {"port_number": 3393, "protocols": ["tcp", "udp"]},
    "d2k-tapestry2": {"port_number": 3394, "protocols": ["tcp", "udp"]},
    "dyna-lm": {"port_number": 3395, "protocols": ["tcp", "udp"]},
    "printer-agent": {"port_number": 3396, "protocols": ["tcp", "udp"]},
    "printer_agent": {"port_number": 3396, "protocols": ["tcp", "udp"]},
    "cloanto-lm": {"port_number": 3397, "protocols": ["tcp", "udp"]},
    "mercantile": {"port_number": 3398, "protocols": ["tcp", "udp"]},
    "csms": {"port_number": 3399, "protocols": ["tcp", "udp"]},
    "csms2": {"port_number": 3400, "protocols": ["tcp", "udp"]},
    "filecast": {"port_number": 3401, "protocols": ["tcp", "udp"]},
    "fxaengine-net": {"port_number": 3402, "protocols": ["tcp", "udp"]},
    "nokia-ann-ch1": {"port_number": 3405, "protocols": ["tcp", "udp"]},
    "nokia-ann-ch2": {"port_number": 3406, "protocols": ["tcp", "udp"]},
    "ldap-admin": {"port_number": 3407, "protocols": ["tcp", "udp"]},
    "BESApi": {"port_number": 3408, "protocols": ["tcp", "udp"]},
    "networklens": {"port_number": 3409, "protocols": ["tcp", "udp"]},
    "networklenss": {"port_number": 3410, "protocols": ["tcp", "udp"]},
    "biolink-auth": {"port_number": 3411, "protocols": ["tcp", "udp"]},
    "xmlblaster": {"port_number": 3412, "protocols": ["tcp", "udp"]},
    "svnet": {"port_number": 3413, "protocols": ["tcp", "udp"]},
    "wip-port": {"port_number": 3414, "protocols": ["tcp", "udp"]},
    "bcinameservice": {"port_number": 3415, "protocols": ["tcp", "udp"]},
    "commandport": {"port_number": 3416, "protocols": ["tcp", "udp"]},
    "csvr": {"port_number": 3417, "protocols": ["tcp", "udp"]},
    "rnmap": {"port_number": 3418, "protocols": ["tcp", "udp"]},
    "softaudit": {"port_number": 3419, "protocols": ["tcp", "udp"]},
    "ifcp-port": {"port_number": 3420, "protocols": ["tcp", "udp"]},
    "bmap": {"port_number": 3421, "protocols": ["tcp", "udp"]},
    "rusb-sys-port": {"port_number": 3422, "protocols": ["tcp", "udp"]},
    "xtrm": {"port_number": 3423, "protocols": ["tcp", "udp"]},
    "xtrms": {"port_number": 3424, "protocols": ["tcp", "udp"]},
    "agps-port": {"port_number": 3425, "protocols": ["tcp", "udp"]},
    "arkivio": {"port_number": 3426, "protocols": ["tcp", "udp"]},
    "websphere-snmp": {"port_number": 3427, "protocols": ["tcp", "udp"]},
    "twcss": {"port_number": 3428, "protocols": ["tcp", "udp"]},
    "gcsp": {"port_number": 3429, "protocols": ["tcp", "udp"]},
    "ssdispatch": {"port_number": 3430, "protocols": ["tcp", "udp"]},
    "ndl-als": {"port_number": 3431, "protocols": ["tcp", "udp"]},
    "osdcp": {"port_number": 3432, "protocols": ["tcp", "udp"]},
    "opnet-smp": {"port_number": 3433, "protocols": ["tcp", "udp"]},
    "opencm": {"port_number": 3434, "protocols": ["tcp", "udp"]},
    "pacom": {"port_number": 3435, "protocols": ["tcp", "udp"]},
    "gc-config": {"port_number": 3436, "protocols": ["tcp", "udp"]},
    "autocueds": {"port_number": 3437, "protocols": ["tcp", "udp"]},
    "spiral-admin": {"port_number": 3438, "protocols": ["tcp", "udp"]},
    "hri-port": {"port_number": 3439, "protocols": ["tcp", "udp"]},
    "ans-console": {"port_number": 3440, "protocols": ["tcp", "udp"]},
    "connect-client": {"port_number": 3441, "protocols": ["tcp", "udp"]},
    "connect-server": {"port_number": 3442, "protocols": ["tcp", "udp"]},
    "ov-nnm-websrv": {"port_number": 3443, "protocols": ["tcp", "udp"]},
    "denali-server": {"port_number": 3444, "protocols": ["tcp", "udp"]},
    "monp": {"port_number": 3445, "protocols": ["tcp", "udp"]},
    "3comfaxrpc": {"port_number": 3446, "protocols": ["tcp", "udp"]},
    "directnet": {"port_number": 3447, "protocols": ["tcp", "udp"]},
    "dnc-port": {"port_number": 3448, "protocols": ["tcp", "udp"]},
    "hotu-chat": {"port_number": 3449, "protocols": ["tcp", "udp"]},
    "castorproxy": {"port_number": 3450, "protocols": ["tcp", "udp"]},
    "asam": {"port_number": 3451, "protocols": ["tcp", "udp"]},
    "sabp-signal": {"port_number": 3452, "protocols": ["tcp", "udp"]},
    "pscupd": {"port_number": 3453, "protocols": ["tcp", "udp"]},
    "mira": {"port_number": 3454, "protocols": ["tcp", "udp"]},
    "prsvp": {"port_number": 3455, "protocols": ["tcp", "udp"]},
    "vat": {"port_number": 3456, "protocols": ["tcp", "udp"]},
    "vat-control": {"port_number": 3457, "protocols": ["tcp", "udp"]},
    "d3winosfi": {"port_number": 3458, "protocols": ["tcp", "udp"]},
    "integral": {"port_number": 3459, "protocols": ["tcp", "udp"]},
    "edm-manager": {"port_number": 3460, "protocols": ["tcp", "udp"]},
    "edm-stager": {"port_number": 3461, "protocols": ["tcp", "udp"]},
    "edm-std-notify": {"port_number": 3462, "protocols": ["tcp", "udp"]},
    "edm-adm-notify": {"port_number": 3463, "protocols": ["tcp", "udp"]},
    "edm-mgr-sync": {"port_number": 3464, "protocols": ["tcp", "udp"]},
    "edm-mgr-cntrl": {"port_number": 3465, "protocols": ["tcp", "udp"]},
    "workflow": {"port_number": 3466, "protocols": ["tcp", "udp"]},
    "rcst": {"port_number": 3467, "protocols": ["tcp", "udp"]},
    "ttcmremotectrl": {"port_number": 3468, "protocols": ["tcp", "udp"]},
    "pluribus": {"port_number": 3469, "protocols": ["tcp", "udp"]},
    "jt400": {"port_number": 3470, "protocols": ["tcp", "udp"]},
    "jt400-ssl": {"port_number": 3471, "protocols": ["tcp", "udp"]},
    "jaugsremotec-1": {"port_number": 3472, "protocols": ["tcp", "udp"]},
    "jaugsremotec-2": {"port_number": 3473, "protocols": ["tcp", "udp"]},
    "ttntspauto": {"port_number": 3474, "protocols": ["tcp", "udp"]},
    "genisar-port": {"port_number": 3475, "protocols": ["tcp", "udp"]},
    "nppmp": {"port_number": 3476, "protocols": ["tcp", "udp"]},
    "ecomm": {"port_number": 3477, "protocols": ["tcp", "udp"]},
    "stun": {"port_number": 3478, "protocols": ["tcp", "udp"]},
    "turn": {"port_number": 3478, "protocols": ["tcp", "udp"]},
    "stun-behavior": {"port_number": 3478, "protocols": ["tcp", "udp"]},
    "twrpc": {"port_number": 3479, "protocols": ["tcp", "udp"]},
    "plethora": {"port_number": 3480, "protocols": ["tcp", "udp"]},
    "cleanerliverc": {"port_number": 3481, "protocols": ["tcp", "udp"]},
    "vulture": {"port_number": 3482, "protocols": ["tcp", "udp"]},
    "slim-devices": {"port_number": 3483, "protocols": ["tcp", "udp"]},
    "gbs-stp": {"port_number": 3484, "protocols": ["tcp", "udp"]},
    "celatalk": {"port_number": 3485, "protocols": ["tcp", "udp"]},
    "ifsf-hb-port": {"port_number": 3486, "protocols": ["tcp", "udp"]},
    "ltctcp": {"port_number": 3487, "protocols": ["tcp"]},
    "ltcudp": {"port_number": 3487, "protocols": ["udp"]},
    "fs-rh-srv": {"port_number": 3488, "protocols": ["tcp", "udp"]},
    "dtp-dia": {"port_number": 3489, "protocols": ["tcp", "udp"]},
    "colubris": {"port_number": 3490, "protocols": ["tcp", "udp"]},
    "swr-port": {"port_number": 3491, "protocols": ["tcp", "udp"]},
    "tvdumtray-port": {"port_number": 3492, "protocols": ["tcp", "udp"]},
    "nut": {"port_number": 3493, "protocols": ["tcp", "udp"]},
    "ibm3494": {"port_number": 3494, "protocols": ["tcp", "udp"]},
    "seclayer-tcp": {"port_number": 3495, "protocols": ["tcp", "udp"]},
    "seclayer-tls": {"port_number": 3496, "protocols": ["tcp", "udp"]},
    "ipether232port": {"port_number": 3497, "protocols": ["tcp", "udp"]},
    "dashpas-port": {"port_number": 3498, "protocols": ["tcp", "udp"]},
    "sccip-media": {"port_number": 3499, "protocols": ["tcp", "udp"]},
    "rtmp-port": {"port_number": 3500, "protocols": ["tcp", "udp"]},
    "isoft-p2p": {"port_number": 3501, "protocols": ["tcp", "udp"]},
    "avinstalldisc": {"port_number": 3502, "protocols": ["tcp", "udp"]},
    "lsp-ping": {"port_number": 3503, "protocols": ["tcp", "udp"]},
    "ironstorm": {"port_number": 3504, "protocols": ["tcp", "udp"]},
    "ccmcomm": {"port_number": 3505, "protocols": ["tcp", "udp"]},
    "apc-3506": {"port_number": 3506, "protocols": ["tcp", "udp"]},
    "nesh-broker": {"port_number": 3507, "protocols": ["tcp", "udp"]},
    "interactionweb": {"port_number": 3508, "protocols": ["tcp", "udp"]},
    "vt-ssl": {"port_number": 3509, "protocols": ["tcp", "udp"]},
    "xss-port": {"port_number": 3510, "protocols": ["tcp", "udp"]},
    "webmail-2": {"port_number": 3511, "protocols": ["tcp", "udp"]},
    "aztec": {"port_number": 3512, "protocols": ["tcp", "udp"]},
    "arcpd": {"port_number": 3513, "protocols": ["tcp", "udp"]},
    "must-p2p": {"port_number": 3514, "protocols": ["tcp", "udp"]},
    "must-backplane": {"port_number": 3515, "protocols": ["tcp", "udp"]},
    "smartcard-port": {"port_number": 3516, "protocols": ["tcp", "udp"]},
    "802-11-iapp": {"port_number": 3517, "protocols": ["tcp", "udp"]},
    "artifact-msg": {"port_number": 3518, "protocols": ["tcp", "udp"]},
    "nvmsgd": {"port_number": 3519, "protocols": ["tcp"]},
    "galileo": {"port_number": 3519, "protocols": ["udp"]},
    "galileolog": {"port_number": 3520, "protocols": ["tcp", "udp"]},
    "mc3ss": {"port_number": 3521, "protocols": ["tcp", "udp"]},
    "nssocketport": {"port_number": 3522, "protocols": ["tcp", "udp"]},
    "odeumservlink": {"port_number": 3523, "protocols": ["tcp", "udp"]},
    "ecmport": {"port_number": 3524, "protocols": ["tcp", "udp"]},
    "eisport": {"port_number": 3525, "protocols": ["tcp", "udp"]},
    "starquiz-port": {"port_number": 3526, "protocols": ["tcp", "udp"]},
    "beserver-msg-q": {"port_number": 3527, "protocols": ["tcp", "udp"]},
    "jboss-iiop": {"port_number": 3528, "protocols": ["tcp", "udp"]},
    "jboss-iiop-ssl": {"port_number": 3529, "protocols": ["tcp", "udp"]},
    "gf": {"port_number": 3530, "protocols": ["tcp", "udp"]},
    "joltid": {"port_number": 3531, "protocols": ["tcp", "udp"]},
    "raven-rmp": {"port_number": 3532, "protocols": ["tcp", "udp"]},
    "raven-rdp": {"port_number": 3533, "protocols": ["tcp", "udp"]},
    "urld-port": {"port_number": 3534, "protocols": ["tcp", "udp"]},
    "ms-la": {"port_number": 3535, "protocols": ["tcp", "udp"]},
    "snac": {"port_number": 3536, "protocols": ["tcp", "udp"]},
    "ni-visa-remote": {"port_number": 3537, "protocols": ["tcp", "udp"]},
    "ibm-diradm": {"port_number": 3538, "protocols": ["tcp", "udp"]},
    "ibm-diradm-ssl": {"port_number": 3539, "protocols": ["tcp", "udp"]},
    "pnrp-port": {"port_number": 3540, "protocols": ["tcp", "udp"]},
    "voispeed-port": {"port_number": 3541, "protocols": ["tcp", "udp"]},
    "hacl-monitor": {"port_number": 3542, "protocols": ["tcp", "udp"]},
    "qftest-lookup": {"port_number": 3543, "protocols": ["tcp", "udp"]},
    "teredo": {"port_number": 3544, "protocols": ["tcp", "udp"]},
    "camac": {"port_number": 3545, "protocols": ["tcp", "udp"]},
    "symantec-sim": {"port_number": 3547, "protocols": ["tcp", "udp"]},
    "interworld": {"port_number": 3548, "protocols": ["tcp", "udp"]},
    "tellumat-nms": {"port_number": 3549, "protocols": ["tcp", "udp"]},
    "ssmpp": {"port_number": 3550, "protocols": ["tcp", "udp"]},
    "apcupsd": {"port_number": 3551, "protocols": ["tcp", "udp"]},
    "taserver": {"port_number": 3552, "protocols": ["tcp", "udp"]},
    "rbr-discovery": {"port_number": 3553, "protocols": ["tcp", "udp"]},
    "questnotify": {"port_number": 3554, "protocols": ["tcp", "udp"]},
    "razor": {"port_number": 3555, "protocols": ["tcp", "udp"]},
    "sky-transport": {"port_number": 3556, "protocols": ["tcp", "udp"]},
    "personalos-001": {"port_number": 3557, "protocols": ["tcp", "udp"]},
    "mcp-port": {"port_number": 3558, "protocols": ["tcp", "udp"]},
    "cctv-port": {"port_number": 3559, "protocols": ["tcp", "udp"]},
    "iniserve-port": {"port_number": 3560, "protocols": ["tcp", "udp"]},
    "bmc-onekey": {"port_number": 3561, "protocols": ["tcp", "udp"]},
    "sdbproxy": {"port_number": 3562, "protocols": ["tcp", "udp"]},
    "watcomdebug": {"port_number": 3563, "protocols": ["tcp", "udp"]},
    "esimport": {"port_number": 3564, "protocols": ["tcp", "udp"]},
    "m2pa": {"port_number": 3565, "protocols": ["tcp", "sctp"]},
    "quest-data-hub": {"port_number": 3566, "protocols": ["tcp"]},
    "dof-eps": {"port_number": 3567, "protocols": ["tcp", "udp"]},
    "dof-tunnel-sec": {"port_number": 3568, "protocols": ["tcp", "udp"]},
    "mbg-ctrl": {"port_number": 3569, "protocols": ["tcp", "udp"]},
    "mccwebsvr-port": {"port_number": 3570, "protocols": ["tcp", "udp"]},
    "megardsvr-port": {"port_number": 3571, "protocols": ["tcp", "udp"]},
    "megaregsvrport": {"port_number": 3572, "protocols": ["tcp", "udp"]},
    "tag-ups-1": {"port_number": 3573, "protocols": ["tcp", "udp"]},
    "dmaf-server": {"port_number": 3574, "protocols": ["tcp"]},
    "dmaf-caster": {"port_number": 3574, "protocols": ["udp"]},
    "ccm-port": {"port_number": 3575, "protocols": ["tcp", "udp"]},
    "cmc-port": {"port_number": 3576, "protocols": ["tcp", "udp"]},
    "config-port": {"port_number": 3577, "protocols": ["tcp", "udp"]},
    "data-port": {"port_number": 3578, "protocols": ["tcp", "udp"]},
    "ttat3lb": {"port_number": 3579, "protocols": ["tcp", "udp"]},
    "nati-svrloc": {"port_number": 3580, "protocols": ["tcp", "udp"]},
    "kfxaclicensing": {"port_number": 3581, "protocols": ["tcp", "udp"]},
    "press": {"port_number": 3582, "protocols": ["tcp", "udp"]},
    "canex-watch": {"port_number": 3583, "protocols": ["tcp", "udp"]},
    "u-dbap": {"port_number": 3584, "protocols": ["tcp", "udp"]},
    "emprise-lls": {"port_number": 3585, "protocols": ["tcp", "udp"]},
    "emprise-lsc": {"port_number": 3586, "protocols": ["tcp", "udp"]},
    "p2pgroup": {"port_number": 3587, "protocols": ["tcp", "udp"]},
    "sentinel": {"port_number": 3588, "protocols": ["tcp", "udp"]},
    "isomair": {"port_number": 3589, "protocols": ["tcp", "udp"]},
    "wv-csp-sms": {"port_number": 3590, "protocols": ["tcp", "udp"]},
    "gtrack-server": {"port_number": 3591, "protocols": ["tcp", "udp"]},
    "gtrack-ne": {"port_number": 3592, "protocols": ["tcp", "udp"]},
    "bpmd": {"port_number": 3593, "protocols": ["tcp", "udp"]},
    "mediaspace": {"port_number": 3594, "protocols": ["tcp", "udp"]},
    "shareapp": {"port_number": 3595, "protocols": ["tcp", "udp"]},
    "iw-mmogame": {"port_number": 3596, "protocols": ["tcp", "udp"]},
    "a14": {"port_number": 3597, "protocols": ["tcp", "udp"]},
    "a15": {"port_number": 3598, "protocols": ["tcp", "udp"]},
    "quasar-server": {"port_number": 3599, "protocols": ["tcp", "udp"]},
    "trap-daemon": {"port_number": 3600, "protocols": ["tcp", "udp"]},
    "visinet-gui": {"port_number": 3601, "protocols": ["tcp", "udp"]},
    "infiniswitchcl": {"port_number": 3602, "protocols": ["tcp", "udp"]},
    "int-rcv-cntrl": {"port_number": 3603, "protocols": ["tcp", "udp"]},
    "bmc-jmx-port": {"port_number": 3604, "protocols": ["tcp", "udp"]},
    "comcam-io": {"port_number": 3605, "protocols": ["tcp", "udp"]},
    "splitlock": {"port_number": 3606, "protocols": ["tcp", "udp"]},
    "precise-i3": {"port_number": 3607, "protocols": ["tcp", "udp"]},
    "trendchip-dcp": {"port_number": 3608, "protocols": ["tcp", "udp"]},
    "cpdi-pidas-cm": {"port_number": 3609, "protocols": ["tcp", "udp"]},
    "echonet": {"port_number": 3610, "protocols": ["tcp", "udp"]},
    "six-degrees": {"port_number": 3611, "protocols": ["tcp", "udp"]},
    "dataprotector": {"port_number": 3612, "protocols": ["tcp", "udp"]},
    "alaris-disc": {"port_number": 3613, "protocols": ["tcp", "udp"]},
    "sigma-port": {"port_number": 3614, "protocols": ["tcp", "udp"]},
    "start-network": {"port_number": 3615, "protocols": ["tcp", "udp"]},
    "cd3o-protocol": {"port_number": 3616, "protocols": ["tcp", "udp"]},
    "sharp-server": {"port_number": 3617, "protocols": ["tcp", "udp"]},
    "aairnet-1": {"port_number": 3618, "protocols": ["tcp", "udp"]},
    "aairnet-2": {"port_number": 3619, "protocols": ["tcp", "udp"]},
    "ep-pcp": {"port_number": 3620, "protocols": ["tcp", "udp"]},
    "ep-nsp": {"port_number": 3621, "protocols": ["tcp", "udp"]},
    "ff-lr-port": {"port_number": 3622, "protocols": ["tcp", "udp"]},
    "haipe-discover": {"port_number": 3623, "protocols": ["tcp", "udp"]},
    "dist-upgrade": {"port_number": 3624, "protocols": ["tcp", "udp"]},
    "volley": {"port_number": 3625, "protocols": ["tcp", "udp"]},
    "bvcdaemon-port": {"port_number": 3626, "protocols": ["tcp", "udp"]},
    "jamserverport": {"port_number": 3627, "protocols": ["tcp", "udp"]},
    "ept-machine": {"port_number": 3628, "protocols": ["tcp", "udp"]},
    "escvpnet": {"port_number": 3629, "protocols": ["tcp", "udp"]},
    "cs-remote-db": {"port_number": 3630, "protocols": ["tcp", "udp"]},
    "cs-services": {"port_number": 3631, "protocols": ["tcp", "udp"]},
    "distcc": {"port_number": 3632, "protocols": ["tcp", "udp"]},
    "wacp": {"port_number": 3633, "protocols": ["tcp", "udp"]},
    "hlibmgr": {"port_number": 3634, "protocols": ["tcp", "udp"]},
    "sdo": {"port_number": 3635, "protocols": ["tcp", "udp"]},
    "servistaitsm": {"port_number": 3636, "protocols": ["tcp", "udp"]},
    "scservp": {"port_number": 3637, "protocols": ["tcp", "udp"]},
    "ehp-backup": {"port_number": 3638, "protocols": ["tcp", "udp"]},
    "xap-ha": {"port_number": 3639, "protocols": ["tcp", "udp"]},
    "netplay-port1": {"port_number": 3640, "protocols": ["tcp", "udp"]},
    "netplay-port2": {"port_number": 3641, "protocols": ["tcp", "udp"]},
    "juxml-port": {"port_number": 3642, "protocols": ["tcp", "udp"]},
    "audiojuggler": {"port_number": 3643, "protocols": ["tcp", "udp"]},
    "ssowatch": {"port_number": 3644, "protocols": ["tcp", "udp"]},
    "cyc": {"port_number": 3645, "protocols": ["tcp", "udp"]},
    "xss-srv-port": {"port_number": 3646, "protocols": ["tcp", "udp"]},
    "splitlock-gw": {"port_number": 3647, "protocols": ["tcp", "udp"]},
    "fjcp": {"port_number": 3648, "protocols": ["tcp", "udp"]},
    "nmmp": {"port_number": 3649, "protocols": ["tcp", "udp"]},
    "prismiq-plugin": {"port_number": 3650, "protocols": ["tcp", "udp"]},
    "xrpc-registry": {"port_number": 3651, "protocols": ["tcp", "udp"]},
    "vxcrnbuport": {"port_number": 3652, "protocols": ["tcp", "udp"]},
    "tsp": {"port_number": 3653, "protocols": ["tcp", "udp"]},
    "vaprtm": {"port_number": 3654, "protocols": ["tcp", "udp"]},
    "abatemgr": {"port_number": 3655, "protocols": ["tcp", "udp"]},
    "abatjss": {"port_number": 3656, "protocols": ["tcp", "udp"]},
    "immedianet-bcn": {"port_number": 3657, "protocols": ["tcp", "udp"]},
    "ps-ams": {"port_number": 3658, "protocols": ["tcp", "udp"]},
    "apple-sasl": {"port_number": 3659, "protocols": ["tcp", "udp"]},
    "can-nds-ssl": {"port_number": 3660, "protocols": ["tcp", "udp"]},
    "can-ferret-ssl": {"port_number": 3661, "protocols": ["tcp", "udp"]},
    "pserver": {"port_number": 3662, "protocols": ["tcp", "udp"]},
    "dtp": {"port_number": 3663, "protocols": ["tcp", "udp"]},
    "ups-engine": {"port_number": 3664, "protocols": ["tcp", "udp"]},
    "ent-engine": {"port_number": 3665, "protocols": ["tcp", "udp"]},
    "eserver-pap": {"port_number": 3666, "protocols": ["tcp", "udp"]},
    "infoexch": {"port_number": 3667, "protocols": ["tcp", "udp"]},
    "dell-rm-port": {"port_number": 3668, "protocols": ["tcp", "udp"]},
    "casanswmgmt": {"port_number": 3669, "protocols": ["tcp", "udp"]},
    "smile": {"port_number": 3670, "protocols": ["tcp", "udp"]},
    "efcp": {"port_number": 3671, "protocols": ["tcp", "udp"]},
    "lispworks-orb": {"port_number": 3672, "protocols": ["tcp", "udp"]},
    "mediavault-gui": {"port_number": 3673, "protocols": ["tcp", "udp"]},
    "wininstall-ipc": {"port_number": 3674, "protocols": ["tcp", "udp"]},
    "calltrax": {"port_number": 3675, "protocols": ["tcp", "udp"]},
    "va-pacbase": {"port_number": 3676, "protocols": ["tcp", "udp"]},
    "roverlog": {"port_number": 3677, "protocols": ["tcp", "udp"]},
    "ipr-dglt": {"port_number": 3678, "protocols": ["tcp", "udp"]},
    "newton-dock": {"port_number": 3679, "protocols": ["tcp", "udp"]},
    "npds-tracker": {"port_number": 3680, "protocols": ["tcp", "udp"]},
    "bts-x73": {"port_number": 3681, "protocols": ["tcp", "udp"]},
    "cas-mapi": {"port_number": 3682, "protocols": ["tcp", "udp"]},
    "bmc-ea": {"port_number": 3683, "protocols": ["tcp", "udp"]},
    "faxstfx-port": {"port_number": 3684, "protocols": ["tcp", "udp"]},
    "dsx-agent": {"port_number": 3685, "protocols": ["tcp", "udp"]},
    "tnmpv2": {"port_number": 3686, "protocols": ["tcp", "udp"]},
    "simple-push": {"port_number": 3687, "protocols": ["tcp", "udp"]},
    "simple-push-s": {"port_number": 3688, "protocols": ["tcp", "udp"]},
    "daap": {"port_number": 3689, "protocols": ["tcp", "udp"]},
    "svn": {"port_number": 3690, "protocols": ["tcp", "udp"]},
    "magaya-network": {"port_number": 3691, "protocols": ["tcp", "udp"]},
    "intelsync": {"port_number": 3692, "protocols": ["tcp", "udp"]},
    "easl": {"port_number": 3693, "protocols": ["tcp"]},
    "bmc-data-coll": {"port_number": 3695, "protocols": ["tcp", "udp"]},
    "telnetcpcd": {"port_number": 3696, "protocols": ["tcp", "udp"]},
    "nw-license": {"port_number": 3697, "protocols": ["tcp", "udp"]},
    "sagectlpanel": {"port_number": 3698, "protocols": ["tcp", "udp"]},
    "kpn-icw": {"port_number": 3699, "protocols": ["tcp", "udp"]},
    "lrs-paging": {"port_number": 3700, "protocols": ["tcp", "udp"]},
    "netcelera": {"port_number": 3701, "protocols": ["tcp", "udp"]},
    "ws-discovery": {"port_number": 3702, "protocols": ["tcp", "udp"]},
    "adobeserver-3": {"port_number": 3703, "protocols": ["tcp", "udp"]},
    "adobeserver-4": {"port_number": 3704, "protocols": ["tcp", "udp"]},
    "adobeserver-5": {"port_number": 3705, "protocols": ["tcp", "udp"]},
    "rt-event": {"port_number": 3706, "protocols": ["tcp", "udp"]},
    "rt-event-s": {"port_number": 3707, "protocols": ["tcp", "udp"]},
    "sun-as-iiops": {"port_number": 3708, "protocols": ["tcp", "udp"]},
    "ca-idms": {"port_number": 3709, "protocols": ["tcp", "udp"]},
    "portgate-auth": {"port_number": 3710, "protocols": ["tcp", "udp"]},
    "edb-server2": {"port_number": 3711, "protocols": ["tcp", "udp"]},
    "sentinel-ent": {"port_number": 3712, "protocols": ["tcp", "udp"]},
    "tftps": {"port_number": 3713, "protocols": ["tcp", "udp"]},
    "delos-dms": {"port_number": 3714, "protocols": ["tcp", "udp"]},
    "anoto-rendezv": {"port_number": 3715, "protocols": ["tcp", "udp"]},
    "wv-csp-sms-cir": {"port_number": 3716, "protocols": ["tcp", "udp"]},
    "wv-csp-udp-cir": {"port_number": 3717, "protocols": ["tcp", "udp"]},
    "opus-services": {"port_number": 3718, "protocols": ["tcp", "udp"]},
    "itelserverport": {"port_number": 3719, "protocols": ["tcp", "udp"]},
    "ufastro-instr": {"port_number": 3720, "protocols": ["tcp", "udp"]},
    "xsync": {"port_number": 3721, "protocols": ["tcp", "udp"]},
    "xserveraid": {"port_number": 3722, "protocols": ["tcp", "udp"]},
    "sychrond": {"port_number": 3723, "protocols": ["tcp", "udp"]},
    "blizwow": {"port_number": 3724, "protocols": ["tcp", "udp"]},
    "na-er-tip": {"port_number": 3725, "protocols": ["tcp", "udp"]},
    "array-manager": {"port_number": 3726, "protocols": ["tcp", "udp"]},
    "e-mdu": {"port_number": 3727, "protocols": ["tcp", "udp"]},
    "e-woa": {"port_number": 3728, "protocols": ["tcp", "udp"]},
    "fksp-audit": {"port_number": 3729, "protocols": ["tcp", "udp"]},
    "client-ctrl": {"port_number": 3730, "protocols": ["tcp", "udp"]},
    "smap": {"port_number": 3731, "protocols": ["tcp", "udp"]},
    "m-wnn": {"port_number": 3732, "protocols": ["tcp", "udp"]},
    "multip-msg": {"port_number": 3733, "protocols": ["tcp", "udp"]},
    "synel-data": {"port_number": 3734, "protocols": ["tcp", "udp"]},
    "pwdis": {"port_number": 3735, "protocols": ["tcp", "udp"]},
    "rs-rmi": {"port_number": 3736, "protocols": ["tcp", "udp"]},
    "xpanel": {"port_number": 3737, "protocols": ["tcp"]},
    "versatalk": {"port_number": 3738, "protocols": ["tcp", "udp"]},
    "launchbird-lm": {"port_number": 3739, "protocols": ["tcp", "udp"]},
    "heartbeat": {"port_number": 3740, "protocols": ["tcp", "udp"]},
    "wysdma": {"port_number": 3741, "protocols": ["tcp", "udp"]},
    "cst-port": {"port_number": 3742, "protocols": ["tcp", "udp"]},
    "ipcs-command": {"port_number": 3743, "protocols": ["tcp", "udp"]},
    "sasg": {"port_number": 3744, "protocols": ["tcp", "udp"]},
    "gw-call-port": {"port_number": 3745, "protocols": ["tcp", "udp"]},
    "linktest": {"port_number": 3746, "protocols": ["tcp", "udp"]},
    "linktest-s": {"port_number": 3747, "protocols": ["tcp", "udp"]},
    "webdata": {"port_number": 3748, "protocols": ["tcp", "udp"]},
    "cimtrak": {"port_number": 3749, "protocols": ["tcp", "udp"]},
    "cbos-ip-port": {"port_number": 3750, "protocols": ["tcp", "udp"]},
    "gprs-cube": {"port_number": 3751, "protocols": ["tcp", "udp"]},
    "vipremoteagent": {"port_number": 3752, "protocols": ["tcp", "udp"]},
    "nattyserver": {"port_number": 3753, "protocols": ["tcp", "udp"]},
    "timestenbroker": {"port_number": 3754, "protocols": ["tcp", "udp"]},
    "sas-remote-hlp": {"port_number": 3755, "protocols": ["tcp", "udp"]},
    "canon-capt": {"port_number": 3756, "protocols": ["tcp", "udp"]},
    "grf-port": {"port_number": 3757, "protocols": ["tcp", "udp"]},
    "apw-registry": {"port_number": 3758, "protocols": ["tcp", "udp"]},
    "exapt-lmgr": {"port_number": 3759, "protocols": ["tcp", "udp"]},
    "adtempusclient": {"port_number": 3760, "protocols": ["tcp", "udp"]},
    "gsakmp": {"port_number": 3761, "protocols": ["tcp", "udp"]},
    "gbs-smp": {"port_number": 3762, "protocols": ["tcp", "udp"]},
    "xo-wave": {"port_number": 3763, "protocols": ["tcp", "udp"]},
    "mni-prot-rout": {"port_number": 3764, "protocols": ["tcp", "udp"]},
    "rtraceroute": {"port_number": 3765, "protocols": ["tcp", "udp"]},
    "sitewatch-s": {"port_number": 3766, "protocols": ["tcp"]},
    "listmgr-port": {"port_number": 3767, "protocols": ["tcp", "udp"]},
    "rblcheckd": {"port_number": 3768, "protocols": ["tcp", "udp"]},
    "haipe-otnk": {"port_number": 3769, "protocols": ["tcp", "udp"]},
    "cindycollab": {"port_number": 3770, "protocols": ["tcp", "udp"]},
    "paging-port": {"port_number": 3771, "protocols": ["tcp", "udp"]},
    "ctp": {"port_number": 3772, "protocols": ["tcp", "udp"]},
    "ctdhercules": {"port_number": 3773, "protocols": ["tcp", "udp"]},
    "zicom": {"port_number": 3774, "protocols": ["tcp", "udp"]},
    "ispmmgr": {"port_number": 3775, "protocols": ["tcp", "udp"]},
    "dvcprov-port": {"port_number": 3776, "protocols": ["tcp", "udp"]},
    "jibe-eb": {"port_number": 3777, "protocols": ["tcp", "udp"]},
    "c-h-it-port": {"port_number": 3778, "protocols": ["tcp", "udp"]},
    "cognima": {"port_number": 3779, "protocols": ["tcp", "udp"]},
    "nnp": {"port_number": 3780, "protocols": ["tcp", "udp"]},
    "abcvoice-port": {"port_number": 3781, "protocols": ["tcp", "udp"]},
    "iso-tp0s": {"port_number": 3782, "protocols": ["tcp", "udp"]},
    "bim-pem": {"port_number": 3783, "protocols": ["tcp", "udp"]},
    "bfd-control": {"port_number": 3784, "protocols": ["tcp", "udp"]},
    "bfd-echo": {"port_number": 3785, "protocols": ["tcp", "udp"]},
    "upstriggervsw": {"port_number": 3786, "protocols": ["tcp", "udp"]},
    "fintrx": {"port_number": 3787, "protocols": ["tcp", "udp"]},
    "isrp-port": {"port_number": 3788, "protocols": ["tcp", "udp"]},
    "remotedeploy": {"port_number": 3789, "protocols": ["tcp", "udp"]},
    "quickbooksrds": {"port_number": 3790, "protocols": ["tcp", "udp"]},
    "tvnetworkvideo": {"port_number": 3791, "protocols": ["tcp", "udp"]},
    "sitewatch": {"port_number": 3792, "protocols": ["tcp", "udp"]},
    "dcsoftware": {"port_number": 3793, "protocols": ["tcp", "udp"]},
    "jaus": {"port_number": 3794, "protocols": ["tcp", "udp"]},
    "myblast": {"port_number": 3795, "protocols": ["tcp", "udp"]},
    "spw-dialer": {"port_number": 3796, "protocols": ["tcp", "udp"]},
    "idps": {"port_number": 3797, "protocols": ["tcp", "udp"]},
    "minilock": {"port_number": 3798, "protocols": ["tcp", "udp"]},
    "radius-dynauth": {"port_number": 3799, "protocols": ["tcp", "udp"]},
    "pwgpsi": {"port_number": 3800, "protocols": ["tcp", "udp"]},
    "ibm-mgr": {"port_number": 3801, "protocols": ["tcp", "udp"]},
    "vhd": {"port_number": 3802, "protocols": ["tcp", "udp"]},
    "soniqsync": {"port_number": 3803, "protocols": ["tcp", "udp"]},
    "iqnet-port": {"port_number": 3804, "protocols": ["tcp", "udp"]},
    "tcpdataserver": {"port_number": 3805, "protocols": ["tcp", "udp"]},
    "wsmlb": {"port_number": 3806, "protocols": ["tcp", "udp"]},
    "spugna": {"port_number": 3807, "protocols": ["tcp", "udp"]},
    "sun-as-iiops-ca": {"port_number": 3808, "protocols": ["tcp", "udp"]},
    "apocd": {"port_number": 3809, "protocols": ["tcp", "udp"]},
    "wlanauth": {"port_number": 3810, "protocols": ["tcp", "udp"]},
    "amp": {"port_number": 3811, "protocols": ["tcp", "udp"]},
    "neto-wol-server": {"port_number": 3812, "protocols": ["tcp", "udp"]},
    "rap-ip": {"port_number": 3813, "protocols": ["tcp", "udp"]},
    "neto-dcs": {"port_number": 3814, "protocols": ["tcp", "udp"]},
    "lansurveyorxml": {"port_number": 3815, "protocols": ["tcp", "udp"]},
    "sunlps-http": {"port_number": 3816, "protocols": ["tcp", "udp"]},
    "tapeware": {"port_number": 3817, "protocols": ["tcp", "udp"]},
    "crinis-hb": {"port_number": 3818, "protocols": ["tcp", "udp"]},
    "epl-slp": {"port_number": 3819, "protocols": ["tcp", "udp"]},
    "scp": {"port_number": 3820, "protocols": ["tcp", "udp"]},
    "pmcp": {"port_number": 3821, "protocols": ["tcp", "udp"]},
    "acp-discovery": {"port_number": 3822, "protocols": ["tcp", "udp"]},
    "acp-conduit": {"port_number": 3823, "protocols": ["tcp", "udp"]},
    "acp-policy": {"port_number": 3824, "protocols": ["tcp", "udp"]},
    "ffserver": {"port_number": 3825, "protocols": ["tcp", "udp"]},
    "warmux": {"port_number": 3826, "protocols": ["tcp", "udp"]},
    "netmpi": {"port_number": 3827, "protocols": ["tcp", "udp"]},
    "neteh": {"port_number": 3828, "protocols": ["tcp", "udp"]},
    "neteh-ext": {"port_number": 3829, "protocols": ["tcp", "udp"]},
    "cernsysmgmtagt": {"port_number": 3830, "protocols": ["tcp", "udp"]},
    "dvapps": {"port_number": 3831, "protocols": ["tcp", "udp"]},
    "xxnetserver": {"port_number": 3832, "protocols": ["tcp", "udp"]},
    "aipn-auth": {"port_number": 3833, "protocols": ["tcp", "udp"]},
    "spectardata": {"port_number": 3834, "protocols": ["tcp", "udp"]},
    "spectardb": {"port_number": 3835, "protocols": ["tcp", "udp"]},
    "markem-dcp": {"port_number": 3836, "protocols": ["tcp", "udp"]},
    "mkm-discovery": {"port_number": 3837, "protocols": ["tcp", "udp"]},
    "sos": {"port_number": 3838, "protocols": ["tcp", "udp"]},
    "amx-rms": {"port_number": 3839, "protocols": ["tcp", "udp"]},
    "flirtmitmir": {"port_number": 3840, "protocols": ["tcp", "udp"]},
    "shiprush-db-svr": {"port_number": 3841, "protocols": ["tcp"]},
    "nhci": {"port_number": 3842, "protocols": ["tcp", "udp"]},
    "quest-agent": {"port_number": 3843, "protocols": ["tcp", "udp"]},
    "rnm": {"port_number": 3844, "protocols": ["tcp", "udp"]},
    "v-one-spp": {"port_number": 3845, "protocols": ["tcp", "udp"]},
    "an-pcp": {"port_number": 3846, "protocols": ["tcp", "udp"]},
    "msfw-control": {"port_number": 3847, "protocols": ["tcp", "udp"]},
    "item": {"port_number": 3848, "protocols": ["tcp", "udp"]},
    "spw-dnspreload": {"port_number": 3849, "protocols": ["tcp", "udp"]},
    "qtms-bootstrap": {"port_number": 3850, "protocols": ["tcp", "udp"]},
    "spectraport": {"port_number": 3851, "protocols": ["tcp", "udp"]},
    "sse-app-config": {"port_number": 3852, "protocols": ["tcp", "udp"]},
    "sscan": {"port_number": 3853, "protocols": ["tcp", "udp"]},
    "stryker-com": {"port_number": 3854, "protocols": ["tcp", "udp"]},
    "opentrac": {"port_number": 3855, "protocols": ["tcp", "udp"]},
    "informer": {"port_number": 3856, "protocols": ["tcp", "udp"]},
    "trap-port": {"port_number": 3857, "protocols": ["tcp", "udp"]},
    "trap-port-mom": {"port_number": 3858, "protocols": ["tcp", "udp"]},
    "nav-port": {"port_number": 3859, "protocols": ["tcp", "udp"]},
    "sasp": {"port_number": 3860, "protocols": ["tcp", "udp"]},
    "winshadow-hd": {"port_number": 3861, "protocols": ["tcp", "udp"]},
    "giga-pocket": {"port_number": 3862, "protocols": ["tcp", "udp"]},
    "asap-tcp": {"port_number": 3863, "protocols": ["tcp"]},
    "asap-udp": {"port_number": 3863, "protocols": ["udp"]},
    "asap-sctp": {"port_number": 3863, "protocols": ["sctp"]},
    "asap-tcp-tls": {"port_number": 3864, "protocols": ["tcp"]},
    "asap-sctp-tls": {"port_number": 3864, "protocols": ["sctp"]},
    "xpl": {"port_number": 3865, "protocols": ["tcp", "udp"]},
    "dzdaemon": {"port_number": 3866, "protocols": ["tcp", "udp"]},
    "dzoglserver": {"port_number": 3867, "protocols": ["tcp", "udp"]},
    "diameter": {"port_number": 3868, "protocols": ["tcp", "sctp"]},
    "ovsam-mgmt": {"port_number": 3869, "protocols": ["tcp", "udp"]},
    "ovsam-d-agent": {"port_number": 3870, "protocols": ["tcp", "udp"]},
    "avocent-adsap": {"port_number": 3871, "protocols": ["tcp", "udp"]},
    "oem-agent": {"port_number": 3872, "protocols": ["tcp", "udp"]},
    "fagordnc": {"port_number": 3873, "protocols": ["tcp", "udp"]},
    "sixxsconfig": {"port_number": 3874, "protocols": ["tcp", "udp"]},
    "pnbscada": {"port_number": 3875, "protocols": ["tcp", "udp"]},
    "dl-agent": {"port_number": 3876, "protocols": ["tcp", "udp"]},
    "dl_agent": {"port_number": 3876, "protocols": ["tcp", "udp"]},
    "xmpcr-interface": {"port_number": 3877, "protocols": ["tcp", "udp"]},
    "fotogcad": {"port_number": 3878, "protocols": ["tcp", "udp"]},
    "appss-lm": {"port_number": 3879, "protocols": ["tcp", "udp"]},
    "igrs": {"port_number": 3880, "protocols": ["tcp", "udp"]},
    "idac": {"port_number": 3881, "protocols": ["tcp", "udp"]},
    "msdts1": {"port_number": 3882, "protocols": ["tcp", "udp"]},
    "vrpn": {"port_number": 3883, "protocols": ["tcp", "udp"]},
    "softrack-meter": {"port_number": 3884, "protocols": ["tcp", "udp"]},
    "topflow-ssl": {"port_number": 3885, "protocols": ["tcp", "udp"]},
    "nei-management": {"port_number": 3886, "protocols": ["tcp", "udp"]},
    "ciphire-data": {"port_number": 3887, "protocols": ["tcp", "udp"]},
    "ciphire-serv": {"port_number": 3888, "protocols": ["tcp", "udp"]},
    "dandv-tester": {"port_number": 3889, "protocols": ["tcp", "udp"]},
    "ndsconnect": {"port_number": 3890, "protocols": ["tcp", "udp"]},
    "rtc-pm-port": {"port_number": 3891, "protocols": ["tcp", "udp"]},
    "pcc-image-port": {"port_number": 3892, "protocols": ["tcp", "udp"]},
    "cgi-starapi": {"port_number": 3893, "protocols": ["tcp", "udp"]},
    "syam-agent": {"port_number": 3894, "protocols": ["tcp", "udp"]},
    "syam-smc": {"port_number": 3895, "protocols": ["tcp", "udp"]},
    "sdo-tls": {"port_number": 3896, "protocols": ["tcp", "udp"]},
    "sdo-ssh": {"port_number": 3897, "protocols": ["tcp", "udp"]},
    "senip": {"port_number": 3898, "protocols": ["tcp", "udp"]},
    "itv-control": {"port_number": 3899, "protocols": ["tcp", "udp"]},
    "udt-os-secondary": {"port_number": 3900, "protocols": ["tcp", "udp"]},
    "udt_os-secondary": {"port_number": 3900, "protocols": ["tcp", "udp"]},
    "nimsh": {"port_number": 3901, "protocols": ["tcp", "udp"]},
    "nimaux": {"port_number": 3902, "protocols": ["tcp", "udp"]},
    "charsetmgr": {"port_number": 3903, "protocols": ["tcp", "udp"]},
    "omnilink-port": {"port_number": 3904, "protocols": ["tcp", "udp"]},
    "mupdate": {"port_number": 3905, "protocols": ["tcp", "udp"]},
    "topovista-data": {"port_number": 3906, "protocols": ["tcp", "udp"]},
    "imoguia-port": {"port_number": 3907, "protocols": ["tcp", "udp"]},
    "hppronetman": {"port_number": 3908, "protocols": ["tcp", "udp"]},
    "surfcontrolcpa": {"port_number": 3909, "protocols": ["tcp", "udp"]},
    "prnrequest": {"port_number": 3910, "protocols": ["tcp", "udp"]},
    "prnstatus": {"port_number": 3911, "protocols": ["tcp", "udp"]},
    "gbmt-stars": {"port_number": 3912, "protocols": ["tcp", "udp"]},
    "listcrt-port": {"port_number": 3913, "protocols": ["tcp", "udp"]},
    "listcrt-port-2": {"port_number": 3914, "protocols": ["tcp", "udp"]},
    "agcat": {"port_number": 3915, "protocols": ["tcp", "udp"]},
    "wysdmc": {"port_number": 3916, "protocols": ["tcp", "udp"]},
    "aftmux": {"port_number": 3917, "protocols": ["tcp", "udp"]},
    "pktcablemmcops": {"port_number": 3918, "protocols": ["tcp", "udp"]},
    "hyperip": {"port_number": 3919, "protocols": ["tcp", "udp"]},
    "exasoftport1": {"port_number": 3920, "protocols": ["tcp", "udp"]},
    "herodotus-net": {"port_number": 3921, "protocols": ["tcp", "udp"]},
    "sor-update": {"port_number": 3922, "protocols": ["tcp", "udp"]},
    "symb-sb-port": {"port_number": 3923, "protocols": ["tcp", "udp"]},
    "mpl-gprs-port": {"port_number": 3924, "protocols": ["tcp", "udp"]},
    "zmp": {"port_number": 3925, "protocols": ["tcp", "udp"]},
    "winport": {"port_number": 3926, "protocols": ["tcp", "udp"]},
    "natdataservice": {"port_number": 3927, "protocols": ["tcp", "udp"]},
    "netboot-pxe": {"port_number": 3928, "protocols": ["tcp", "udp"]},
    "smauth-port": {"port_number": 3929, "protocols": ["tcp", "udp"]},
    "syam-webserver": {"port_number": 3930, "protocols": ["tcp", "udp"]},
    "msr-plugin-port": {"port_number": 3931, "protocols": ["tcp", "udp"]},
    "dyn-site": {"port_number": 3932, "protocols": ["tcp", "udp"]},
    "plbserve-port": {"port_number": 3933, "protocols": ["tcp", "udp"]},
    "sunfm-port": {"port_number": 3934, "protocols": ["tcp", "udp"]},
    "sdp-portmapper": {"port_number": 3935, "protocols": ["tcp", "udp"]},
    "mailprox": {"port_number": 3936, "protocols": ["tcp", "udp"]},
    "dvbservdsc": {"port_number": 3937, "protocols": ["tcp", "udp"]},
    "dbcontrol-agent": {"port_number": 3938, "protocols": ["tcp", "udp"]},
    "dbcontrol_agent": {"port_number": 3938, "protocols": ["tcp", "udp"]},
    "aamp": {"port_number": 3939, "protocols": ["tcp", "udp"]},
    "xecp-node": {"port_number": 3940, "protocols": ["tcp", "udp"]},
    "homeportal-web": {"port_number": 3941, "protocols": ["tcp", "udp"]},
    "srdp": {"port_number": 3942, "protocols": ["tcp", "udp"]},
    "tig": {"port_number": 3943, "protocols": ["tcp", "udp"]},
    "sops": {"port_number": 3944, "protocols": ["tcp", "udp"]},
    "emcads": {"port_number": 3945, "protocols": ["tcp", "udp"]},
    "backupedge": {"port_number": 3946, "protocols": ["tcp", "udp"]},
    "ccp": {"port_number": 3947, "protocols": ["tcp", "udp"]},
    "apdap": {"port_number": 3948, "protocols": ["tcp", "udp"]},
    "drip": {"port_number": 3949, "protocols": ["tcp", "udp"]},
    "namemunge": {"port_number": 3950, "protocols": ["tcp", "udp"]},
    "pwgippfax": {"port_number": 3951, "protocols": ["tcp", "udp"]},
    "i3-sessionmgr": {"port_number": 3952, "protocols": ["tcp", "udp"]},
    "xmlink-connect": {"port_number": 3953, "protocols": ["tcp", "udp"]},
    "adrep": {"port_number": 3954, "protocols": ["tcp", "udp"]},
    "p2pcommunity": {"port_number": 3955, "protocols": ["tcp", "udp"]},
    "gvcp": {"port_number": 3956, "protocols": ["tcp", "udp"]},
    "mqe-broker": {"port_number": 3957, "protocols": ["tcp", "udp"]},
    "mqe-agent": {"port_number": 3958, "protocols": ["tcp", "udp"]},
    "treehopper": {"port_number": 3959, "protocols": ["tcp", "udp"]},
    "bess": {"port_number": 3960, "protocols": ["tcp", "udp"]},
    "proaxess": {"port_number": 3961, "protocols": ["tcp", "udp"]},
    "sbi-agent": {"port_number": 3962, "protocols": ["tcp", "udp"]},
    "thrp": {"port_number": 3963, "protocols": ["tcp", "udp"]},
    "sasggprs": {"port_number": 3964, "protocols": ["tcp", "udp"]},
    "ati-ip-to-ncpe": {"port_number": 3965, "protocols": ["tcp", "udp"]},
    "bflckmgr": {"port_number": 3966, "protocols": ["tcp", "udp"]},
    "ppsms": {"port_number": 3967, "protocols": ["tcp", "udp"]},
    "ianywhere-dbns": {"port_number": 3968, "protocols": ["tcp", "udp"]},
    "landmarks": {"port_number": 3969, "protocols": ["tcp", "udp"]},
    "lanrevagent": {"port_number": 3970, "protocols": ["tcp", "udp"]},
    "lanrevserver": {"port_number": 3971, "protocols": ["tcp", "udp"]},
    "iconp": {"port_number": 3972, "protocols": ["tcp", "udp"]},
    "progistics": {"port_number": 3973, "protocols": ["tcp", "udp"]},
    "xk22": {"port_number": 3974, "protocols": ["tcp", "udp"]},
    "airshot": {"port_number": 3975, "protocols": ["tcp", "udp"]},
    "opswagent": {"port_number": 3976, "protocols": ["tcp", "udp"]},
    "opswmanager": {"port_number": 3977, "protocols": ["tcp", "udp"]},
    "secure-cfg-svr": {"port_number": 3978, "protocols": ["tcp", "udp"]},
    "smwan": {"port_number": 3979, "protocols": ["tcp", "udp"]},
    "starfish": {"port_number": 3981, "protocols": ["tcp", "udp"]},
    "eis": {"port_number": 3982, "protocols": ["tcp", "udp"]},
    "eisp": {"port_number": 3983, "protocols": ["tcp", "udp"]},
    "mapper-nodemgr": {"port_number": 3984, "protocols": ["tcp", "udp"]},
    "mapper-mapethd": {"port_number": 3985, "protocols": ["tcp", "udp"]},
    "mapper-ws-ethd": {"port_number": 3986, "protocols": ["tcp", "udp"]},
    "mapper-ws_ethd": {"port_number": 3986, "protocols": ["tcp", "udp"]},
    "centerline": {"port_number": 3987, "protocols": ["tcp", "udp"]},
    "dcs-config": {"port_number": 3988, "protocols": ["tcp", "udp"]},
    "bv-queryengine": {"port_number": 3989, "protocols": ["tcp", "udp"]},
    "bv-is": {"port_number": 3990, "protocols": ["tcp", "udp"]},
    "bv-smcsrv": {"port_number": 3991, "protocols": ["tcp", "udp"]},
    "bv-ds": {"port_number": 3992, "protocols": ["tcp", "udp"]},
    "bv-agent": {"port_number": 3993, "protocols": ["tcp", "udp"]},
    "iss-mgmt-ssl": {"port_number": 3995, "protocols": ["tcp", "udp"]},
    "abcsoftware": {"port_number": 3996, "protocols": ["tcp", "udp"]},
    "agentsease-db": {"port_number": 3997, "protocols": ["tcp", "udp"]},
    "dnx": {"port_number": 3998, "protocols": ["tcp", "udp"]},
    "nvcnet": {"port_number": 3999, "protocols": ["tcp", "udp"]},
    "terabase": {"port_number": 4000, "protocols": ["tcp", "udp"]},
    "newoak": {"port_number": 4001, "protocols": ["tcp", "udp"]},
    "pxc-spvr-ft": {"port_number": 4002, "protocols": ["tcp", "udp"]},
    "pxc-splr-ft": {"port_number": 4003, "protocols": ["tcp", "udp"]},
    "pxc-roid": {"port_number": 4004, "protocols": ["tcp", "udp"]},
    "pxc-pin": {"port_number": 4005, "protocols": ["tcp", "udp"]},
    "pxc-spvr": {"port_number": 4006, "protocols": ["tcp", "udp"]},
    "pxc-splr": {"port_number": 4007, "protocols": ["tcp", "udp"]},
    "netcheque": {"port_number": 4008, "protocols": ["tcp", "udp"]},
    "chimera-hwm": {"port_number": 4009, "protocols": ["tcp", "udp"]},
    "samsung-unidex": {"port_number": 4010, "protocols": ["tcp", "udp"]},
    "altserviceboot": {"port_number": 4011, "protocols": ["tcp", "udp"]},
    "pda-gate": {"port_number": 4012, "protocols": ["tcp", "udp"]},
    "acl-manager": {"port_number": 4013, "protocols": ["tcp", "udp"]},
    "taiclock": {"port_number": 4014, "protocols": ["tcp", "udp"]},
    "talarian-mcast1": {"port_number": 4015, "protocols": ["tcp", "udp"]},
    "talarian-mcast2": {"port_number": 4016, "protocols": ["tcp", "udp"]},
    "talarian-mcast3": {"port_number": 4017, "protocols": ["tcp", "udp"]},
    "talarian-mcast4": {"port_number": 4018, "protocols": ["tcp", "udp"]},
    "talarian-mcast5": {"port_number": 4019, "protocols": ["tcp", "udp"]},
    "trap": {"port_number": 4020, "protocols": ["tcp", "udp"]},
    "nexus-portal": {"port_number": 4021, "protocols": ["tcp", "udp"]},
    "dnox": {"port_number": 4022, "protocols": ["tcp", "udp"]},
    "esnm-zoning": {"port_number": 4023, "protocols": ["tcp", "udp"]},
    "tnp1-port": {"port_number": 4024, "protocols": ["tcp", "udp"]},
    "partimage": {"port_number": 4025, "protocols": ["tcp", "udp"]},
    "as-debug": {"port_number": 4026, "protocols": ["tcp", "udp"]},
    "bxp": {"port_number": 4027, "protocols": ["tcp", "udp"]},
    "dtserver-port": {"port_number": 4028, "protocols": ["tcp", "udp"]},
    "ip-qsig": {"port_number": 4029, "protocols": ["tcp", "udp"]},
    "jdmn-port": {"port_number": 4030, "protocols": ["tcp", "udp"]},
    "suucp": {"port_number": 4031, "protocols": ["tcp", "udp"]},
    "vrts-auth-port": {"port_number": 4032, "protocols": ["tcp", "udp"]},
    "sanavigator": {"port_number": 4033, "protocols": ["tcp", "udp"]},
    "ubxd": {"port_number": 4034, "protocols": ["tcp", "udp"]},
    "wap-push-http": {"port_number": 4035, "protocols": ["tcp", "udp"]},
    "wap-push-https": {"port_number": 4036, "protocols": ["tcp", "udp"]},
    "ravehd": {"port_number": 4037, "protocols": ["tcp", "udp"]},
    "fazzt-ptp": {"port_number": 4038, "protocols": ["tcp", "udp"]},
    "fazzt-admin": {"port_number": 4039, "protocols": ["tcp", "udp"]},
    "yo-main": {"port_number": 4040, "protocols": ["tcp", "udp"]},
    "houston": {"port_number": 4041, "protocols": ["tcp", "udp"]},
    "ldxp": {"port_number": 4042, "protocols": ["tcp", "udp"]},
    "nirp": {"port_number": 4043, "protocols": ["tcp", "udp"]},
    "ltp": {"port_number": 4044, "protocols": ["tcp", "udp"]},
    "npp-secondary": {"port_number": 4045, "protocols": ["tcp", "udp"]},
    "acp-proto": {"port_number": 4046, "protocols": ["tcp", "udp"]},
    "ctp-state": {"port_number": 4047, "protocols": ["tcp", "udp"]},
    "wafs": {"port_number": 4049, "protocols": ["tcp", "udp"]},
    "cisco-wafs": {"port_number": 4050, "protocols": ["tcp", "udp"]},
    "cppdp": {"port_number": 4051, "protocols": ["tcp", "udp"]},
    "interact": {"port_number": 4052, "protocols": ["tcp", "udp"]},
    "ccu-comm-1": {"port_number": 4053, "protocols": ["tcp", "udp"]},
    "ccu-comm-2": {"port_number": 4054, "protocols": ["tcp", "udp"]},
    "ccu-comm-3": {"port_number": 4055, "protocols": ["tcp", "udp"]},
    "lms": {"port_number": 4056, "protocols": ["tcp", "udp"]},
    "wfm": {"port_number": 4057, "protocols": ["tcp", "udp"]},
    "kingfisher": {"port_number": 4058, "protocols": ["tcp", "udp"]},
    "dlms-cosem": {"port_number": 4059, "protocols": ["tcp", "udp"]},
    "dsmeter-iatc": {"port_number": 4060, "protocols": ["tcp", "udp"]},
    "dsmeter_iatc": {"port_number": 4060, "protocols": ["tcp", "udp"]},
    "ice-location": {"port_number": 4061, "protocols": ["tcp", "udp"]},
    "ice-slocation": {"port_number": 4062, "protocols": ["tcp", "udp"]},
    "ice-router": {"port_number": 4063, "protocols": ["tcp", "udp"]},
    "ice-srouter": {"port_number": 4064, "protocols": ["tcp", "udp"]},
    "avanti-cdp": {"port_number": 4065, "protocols": ["tcp", "udp"]},
    "avanti_cdp": {"port_number": 4065, "protocols": ["tcp", "udp"]},
    "pmas": {"port_number": 4066, "protocols": ["tcp", "udp"]},
    "idp": {"port_number": 4067, "protocols": ["tcp", "udp"]},
    "ipfltbcst": {"port_number": 4068, "protocols": ["tcp", "udp"]},
    "minger": {"port_number": 4069, "protocols": ["tcp", "udp"]},
    "tripe": {"port_number": 4070, "protocols": ["tcp", "udp"]},
    "aibkup": {"port_number": 4071, "protocols": ["tcp", "udp"]},
    "zieto-sock": {"port_number": 4072, "protocols": ["tcp", "udp"]},
    "iRAPP": {"port_number": 4073, "protocols": ["tcp", "udp"]},
    "cequint-cityid": {"port_number": 4074, "protocols": ["tcp", "udp"]},
    "perimlan": {"port_number": 4075, "protocols": ["tcp", "udp"]},
    "seraph": {"port_number": 4076, "protocols": ["tcp", "udp"]},
    "ascomalarm": {"port_number": 4077, "protocols": ["udp"]},
    "cssp": {"port_number": 4078, "protocols": ["tcp"]},
    "santools": {"port_number": 4079, "protocols": ["tcp", "udp"]},
    "lorica-in": {"port_number": 4080, "protocols": ["tcp", "udp"]},
    "lorica-in-sec": {"port_number": 4081, "protocols": ["tcp", "udp"]},
    "lorica-out": {"port_number": 4082, "protocols": ["tcp", "udp"]},
    "lorica-out-sec": {"port_number": 4083, "protocols": ["tcp", "udp"]},
    "fortisphere-vm": {"port_number": 4084, "protocols": ["udp"]},
    "ezmessagesrv": {"port_number": 4085, "protocols": ["tcp"]},
    "ftsync": {"port_number": 4086, "protocols": ["udp"]},
    "applusservice": {"port_number": 4087, "protocols": ["tcp"]},
    "npsp": {"port_number": 4088, "protocols": ["tcp"]},
    "opencore": {"port_number": 4089, "protocols": ["tcp", "udp"]},
    "omasgport": {"port_number": 4090, "protocols": ["tcp", "udp"]},
    "ewinstaller": {"port_number": 4091, "protocols": ["tcp", "udp"]},
    "ewdgs": {"port_number": 4092, "protocols": ["tcp", "udp"]},
    "pvxpluscs": {"port_number": 4093, "protocols": ["tcp", "udp"]},
    "sysrqd": {"port_number": 4094, "protocols": ["tcp", "udp"]},
    "xtgui": {"port_number": 4095, "protocols": ["tcp", "udp"]},
    "bre": {"port_number": 4096, "protocols": ["tcp", "udp"]},
    "patrolview": {"port_number": 4097, "protocols": ["tcp", "udp"]},
    "drmsfsd": {"port_number": 4098, "protocols": ["tcp", "udp"]},
    "dpcp": {"port_number": 4099, "protocols": ["tcp", "udp"]},
    "igo-incognito": {"port_number": 4100, "protocols": ["tcp", "udp"]},
    "brlp-0": {"port_number": 4101, "protocols": ["tcp", "udp"]},
    "brlp-1": {"port_number": 4102, "protocols": ["tcp", "udp"]},
    "brlp-2": {"port_number": 4103, "protocols": ["tcp", "udp"]},
    "brlp-3": {"port_number": 4104, "protocols": ["tcp", "udp"]},
    "shofar": {"port_number": 4105, "protocols": ["tcp", "udp"]},
    "synchronite": {"port_number": 4106, "protocols": ["tcp", "udp"]},
    "j-ac": {"port_number": 4107, "protocols": ["tcp", "udp"]},
    "accel": {"port_number": 4108, "protocols": ["tcp", "udp"]},
    "izm": {"port_number": 4109, "protocols": ["tcp", "udp"]},
    "g2tag": {"port_number": 4110, "protocols": ["tcp", "udp"]},
    "xgrid": {"port_number": 4111, "protocols": ["tcp", "udp"]},
    "apple-vpns-rp": {"port_number": 4112, "protocols": ["tcp", "udp"]},
    "aipn-reg": {"port_number": 4113, "protocols": ["tcp", "udp"]},
    "jomamqmonitor": {"port_number": 4114, "protocols": ["tcp", "udp"]},
    "cds": {"port_number": 4115, "protocols": ["tcp", "udp"]},
    "smartcard-tls": {"port_number": 4116, "protocols": ["tcp", "udp"]},
    "hillrserv": {"port_number": 4117, "protocols": ["tcp", "udp"]},
    "netscript": {"port_number": 4118, "protocols": ["tcp", "udp"]},
    "assuria-slm": {"port_number": 4119, "protocols": ["tcp", "udp"]},
    "minirem": {"port_number": 4120, "protocols": ["tcp"]},
    "e-builder": {"port_number": 4121, "protocols": ["tcp", "udp"]},
    "fprams": {"port_number": 4122, "protocols": ["tcp", "udp"]},
    "z-wave": {"port_number": 4123, "protocols": ["tcp", "udp"]},
    "tigv2": {"port_number": 4124, "protocols": ["tcp", "udp"]},
    "opsview-envoy": {"port_number": 4125, "protocols": ["tcp", "udp"]},
    "ddrepl": {"port_number": 4126, "protocols": ["tcp", "udp"]},
    "unikeypro": {"port_number": 4127, "protocols": ["tcp", "udp"]},
    "nufw": {"port_number": 4128, "protocols": ["tcp", "udp"]},
    "nuauth": {"port_number": 4129, "protocols": ["tcp", "udp"]},
    "fronet": {"port_number": 4130, "protocols": ["tcp", "udp"]},
    "stars": {"port_number": 4131, "protocols": ["tcp", "udp"]},
    "nuts-dem": {"port_number": 4132, "protocols": ["tcp", "udp"]},
    "nuts_dem": {"port_number": 4132, "protocols": ["tcp", "udp"]},
    "nuts-bootp": {"port_number": 4133, "protocols": ["tcp", "udp"]},
    "nuts_bootp": {"port_number": 4133, "protocols": ["tcp", "udp"]},
    "nifty-hmi": {"port_number": 4134, "protocols": ["tcp", "udp"]},
    "cl-db-attach": {"port_number": 4135, "protocols": ["tcp", "udp"]},
    "cl-db-request": {"port_number": 4136, "protocols": ["tcp", "udp"]},
    "cl-db-remote": {"port_number": 4137, "protocols": ["tcp", "udp"]},
    "nettest": {"port_number": 4138, "protocols": ["tcp", "udp"]},
    "thrtx": {"port_number": 4139, "protocols": ["tcp", "udp"]},
    "cedros-fds": {"port_number": 4140, "protocols": ["tcp", "udp"]},
    "cedros_fds": {"port_number": 4140, "protocols": ["tcp", "udp"]},
    "oirtgsvc": {"port_number": 4141, "protocols": ["tcp", "udp"]},
    "oidocsvc": {"port_number": 4142, "protocols": ["tcp", "udp"]},
    "oidsr": {"port_number": 4143, "protocols": ["tcp", "udp"]},
    "vvr-control": {"port_number": 4145, "protocols": ["tcp", "udp"]},
    "tgcconnect": {"port_number": 4146, "protocols": ["tcp", "udp"]},
    "vrxpservman": {"port_number": 4147, "protocols": ["tcp", "udp"]},
    "hhb-handheld": {"port_number": 4148, "protocols": ["tcp", "udp"]},
    "agslb": {"port_number": 4149, "protocols": ["tcp", "udp"]},
    "PowerAlert-nsa": {"port_number": 4150, "protocols": ["tcp", "udp"]},
    "menandmice-noh": {"port_number": 4151, "protocols": ["tcp", "udp"]},
    "menandmice_noh": {"port_number": 4151, "protocols": ["tcp", "udp"]},
    "idig-mux": {"port_number": 4152, "protocols": ["tcp", "udp"]},
    "idig_mux": {"port_number": 4152, "protocols": ["tcp", "udp"]},
    "mbl-battd": {"port_number": 4153, "protocols": ["tcp", "udp"]},
    "atlinks": {"port_number": 4154, "protocols": ["tcp", "udp"]},
    "bzr": {"port_number": 4155, "protocols": ["tcp", "udp"]},
    "stat-results": {"port_number": 4156, "protocols": ["tcp", "udp"]},
    "stat-scanner": {"port_number": 4157, "protocols": ["tcp", "udp"]},
    "stat-cc": {"port_number": 4158, "protocols": ["tcp", "udp"]},
    "nss": {"port_number": 4159, "protocols": ["tcp", "udp"]},
    "jini-discovery": {"port_number": 4160, "protocols": ["tcp", "udp"]},
    "omscontact": {"port_number": 4161, "protocols": ["tcp", "udp"]},
    "omstopology": {"port_number": 4162, "protocols": ["tcp", "udp"]},
    "silverpeakpeer": {"port_number": 4163, "protocols": ["tcp", "udp"]},
    "silverpeakcomm": {"port_number": 4164, "protocols": ["tcp", "udp"]},
    "altcp": {"port_number": 4165, "protocols": ["tcp", "udp"]},
    "joost": {"port_number": 4166, "protocols": ["tcp", "udp"]},
    "ddgn": {"port_number": 4167, "protocols": ["tcp", "udp"]},
    "pslicser": {"port_number": 4168, "protocols": ["tcp", "udp"]},
    "iadt": {"port_number": 4169, "protocols": ["tcp"]},
    "iadt-disc": {"port_number": 4169, "protocols": ["udp"]},
    "d-cinema-csp": {"port_number": 4170, "protocols": ["tcp"]},
    "ml-svnet": {"port_number": 4171, "protocols": ["tcp"]},
    "pcoip": {"port_number": 4172, "protocols": ["tcp", "udp"]},
    "mma-discovery": {"port_number": 4173, "protocols": ["udp"]},
    "smcluster": {"port_number": 4174, "protocols": ["tcp"]},
    "sm-disc": {"port_number": 4174, "protocols": ["udp"]},
    "bccp": {"port_number": 4175, "protocols": ["tcp"]},
    "tl-ipcproxy": {"port_number": 4176, "protocols": ["tcp"]},
    "wello": {"port_number": 4177, "protocols": ["tcp", "udp"]},
    "storman": {"port_number": 4178, "protocols": ["tcp", "udp"]},
    "MaxumSP": {"port_number": 4179, "protocols": ["tcp", "udp"]},
    "httpx": {"port_number": 4180, "protocols": ["tcp", "udp"]},
    "macbak": {"port_number": 4181, "protocols": ["tcp", "udp"]},
    "pcptcpservice": {"port_number": 4182, "protocols": ["tcp", "udp"]},
    "cyborgnet": {"port_number": 4183, "protocols": ["tcp", "udp"]},
    "universe-suite": {"port_number": 4184, "protocols": ["tcp", "udp"]},
    "universe_suite": {"port_number": 4184, "protocols": ["tcp", "udp"]},
    "wcpp": {"port_number": 4185, "protocols": ["tcp", "udp"]},
    "boxbackupstore": {"port_number": 4186, "protocols": ["tcp"]},
    "csc-proxy": {"port_number": 4187, "protocols": ["tcp"]},
    "csc_proxy": {"port_number": 4187, "protocols": ["tcp"]},
    "vatata": {"port_number": 4188, "protocols": ["tcp", "udp"]},
    "pcep": {"port_number": 4189, "protocols": ["tcp"]},
    "sieve": {"port_number": 4190, "protocols": ["tcp"]},
    "dsmipv6": {"port_number": 4191, "protocols": ["udp"]},
    "azeti": {"port_number": 4192, "protocols": ["tcp"]},
    "azeti-bd": {"port_number": 4192, "protocols": ["udp"]},
    "pvxplusio": {"port_number": 4193, "protocols": ["tcp"]},
    "spdm": {"port_number": 4194, "protocols": ["tcp"]},
    "aws-wsp": {"port_number": 4195, "protocols": ["tcp", "udp", "sctp", "dccp"]},
    "hctl": {"port_number": 4197, "protocols": ["tcp", "udp"]},
    "eims-admin": {"port_number": 4199, "protocols": ["tcp", "udp"]},
    "corelccam": {"port_number": 4300, "protocols": ["tcp", "udp"]},
    "d-data": {"port_number": 4301, "protocols": ["tcp", "udp"]},
    "d-data-control": {"port_number": 4302, "protocols": ["tcp", "udp"]},
    "srcp": {"port_number": 4303, "protocols": ["tcp", "udp"]},
    "owserver": {"port_number": 4304, "protocols": ["tcp", "udp"]},
    "batman": {"port_number": 4305, "protocols": ["tcp", "udp"]},
    "pinghgl": {"port_number": 4306, "protocols": ["tcp", "udp"]},
    "trueconf": {"port_number": 4307, "protocols": ["tcp", "udp"]},
    "compx-lockview": {"port_number": 4308, "protocols": ["tcp", "udp"]},
    "dserver": {"port_number": 4309, "protocols": ["tcp", "udp"]},
    "mirrtex": {"port_number": 4310, "protocols": ["tcp", "udp"]},
    "p6ssmc": {"port_number": 4311, "protocols": ["tcp"]},
    "pscl-mgt": {"port_number": 4312, "protocols": ["tcp"]},
    "perrla": {"port_number": 4313, "protocols": ["tcp"]},
    "choiceview-agt": {"port_number": 4314, "protocols": ["tcp"]},
    "choiceview-clt": {"port_number": 4316, "protocols": ["tcp"]},
    "opentelemetry": {"port_number": 4317, "protocols": ["tcp"]},
    "fox-skytale": {"port_number": 4319, "protocols": ["tcp", "udp"]},
    "fdt-rcatp": {"port_number": 4320, "protocols": ["tcp", "udp"]},
    "rwhois": {"port_number": 4321, "protocols": ["tcp", "udp"]},
    "trim-event": {"port_number": 4322, "protocols": ["tcp", "udp"]},
    "trim-ice": {"port_number": 4323, "protocols": ["tcp", "udp"]},
    "geognosisadmin": {"port_number": 4325, "protocols": ["tcp"]},
    "geognosisman": {"port_number": 4325, "protocols": ["udp"]},
    "geognosis": {"port_number": 4326, "protocols": ["tcp", "udp"]},
    "jaxer-web": {"port_number": 4327, "protocols": ["tcp", "udp"]},
    "jaxer-manager": {"port_number": 4328, "protocols": ["tcp", "udp"]},
    "publiqare-sync": {"port_number": 4329, "protocols": ["tcp"]},
    "dey-sapi": {"port_number": 4330, "protocols": ["tcp"]},
    "ktickets-rest": {"port_number": 4331, "protocols": ["tcp"]},
    "getty-focus": {"port_number": 4332, "protocols": ["tcp"]},
    "ahsp": {"port_number": 4333, "protocols": ["tcp", "udp", "sctp"]},
    "netconf-ch-ssh": {"port_number": 4334, "protocols": ["tcp"]},
    "netconf-ch-tls": {"port_number": 4335, "protocols": ["tcp"]},
    "restconf-ch-tls": {"port_number": 4336, "protocols": ["tcp"]},
    "gaia": {"port_number": 4340, "protocols": ["tcp", "udp"]},
    "lisp-data": {"port_number": 4341, "protocols": ["udp"]},
    "lisp-control": {"port_number": 4342, "protocols": ["udp"]},
    "unicall": {"port_number": 4343, "protocols": ["tcp", "udp"]},
    "vinainstall": {"port_number": 4344, "protocols": ["tcp", "udp"]},
    "m4-network-as": {"port_number": 4345, "protocols": ["tcp", "udp"]},
    "elanlm": {"port_number": 4346, "protocols": ["tcp", "udp"]},
    "lansurveyor": {"port_number": 4347, "protocols": ["tcp", "udp"]},
    "itose": {"port_number": 4348, "protocols": ["tcp", "udp"]},
    "fsportmap": {"port_number": 4349, "protocols": ["tcp", "udp"]},
    "net-device": {"port_number": 4350, "protocols": ["tcp", "udp"]},
    "plcy-net-svcs": {"port_number": 4351, "protocols": ["tcp", "udp"]},
    "pjlink": {"port_number": 4352, "protocols": ["tcp", "udp"]},
    "f5-iquery": {"port_number": 4353, "protocols": ["tcp", "udp"]},
    "qsnet-trans": {"port_number": 4354, "protocols": ["tcp", "udp"]},
    "qsnet-workst": {"port_number": 4355, "protocols": ["tcp", "udp"]},
    "qsnet-assist": {"port_number": 4356, "protocols": ["tcp", "udp"]},
    "qsnet-cond": {"port_number": 4357, "protocols": ["tcp", "udp"]},
    "qsnet-nucl": {"port_number": 4358, "protocols": ["tcp", "udp"]},
    "omabcastltkm": {"port_number": 4359, "protocols": ["tcp", "udp"]},
    "matrix-vnet": {"port_number": 4360, "protocols": ["tcp"]},
    "matrix_vnet": {"port_number": 4360, "protocols": ["tcp"]},
    "nacnl": {"port_number": 4361, "protocols": ["udp"]},
    "afore-vdp-disc": {"port_number": 4362, "protocols": ["udp"]},
    "shadowstream": {"port_number": 4366, "protocols": ["udp"]},
    "wxbrief": {"port_number": 4368, "protocols": ["tcp", "udp"]},
    "epmd": {"port_number": 4369, "protocols": ["tcp", "udp"]},
    "elpro-tunnel": {"port_number": 4370, "protocols": ["tcp", "udp"]},
    "elpro_tunnel": {"port_number": 4370, "protocols": ["tcp", "udp"]},
    "l2c-control": {"port_number": 4371, "protocols": ["tcp"]},
    "l2c-disc": {"port_number": 4371, "protocols": ["udp"]},
    "l2c-data": {"port_number": 4372, "protocols": ["tcp", "udp"]},
    "remctl": {"port_number": 4373, "protocols": ["tcp", "udp"]},
    "psi-ptt": {"port_number": 4374, "protocols": ["tcp"]},
    "tolteces": {"port_number": 4375, "protocols": ["tcp", "udp"]},
    "bip": {"port_number": 4376, "protocols": ["tcp", "udp"]},
    "cp-spxsvr": {"port_number": 4377, "protocols": ["tcp", "udp"]},
    "cp-spxdpy": {"port_number": 4378, "protocols": ["tcp", "udp"]},
    "ctdb": {"port_number": 4379, "protocols": ["tcp", "udp"]},
    "xandros-cms": {"port_number": 4389, "protocols": ["tcp", "udp"]},
    "wiegand": {"port_number": 4390, "protocols": ["tcp", "udp"]},
    "apwi-imserver": {"port_number": 4391, "protocols": ["tcp"]},
    "apwi-rxserver": {"port_number": 4392, "protocols": ["tcp"]},
    "apwi-rxspooler": {"port_number": 4393, "protocols": ["tcp"]},
    "apwi-disc": {"port_number": 4394, "protocols": ["udp"]},
    "omnivisionesx": {"port_number": 4395, "protocols": ["tcp", "udp"]},
    "fly": {"port_number": 4396, "protocols": ["tcp"]},
    "ds-srv": {"port_number": 4400, "protocols": ["tcp", "udp"]},
    "ds-srvr": {"port_number": 4401, "protocols": ["tcp", "udp"]},
    "ds-clnt": {"port_number": 4402, "protocols": ["tcp", "udp"]},
    "ds-user": {"port_number": 4403, "protocols": ["tcp", "udp"]},
    "ds-admin": {"port_number": 4404, "protocols": ["tcp", "udp"]},
    "ds-mail": {"port_number": 4405, "protocols": ["tcp", "udp"]},
    "ds-slp": {"port_number": 4406, "protocols": ["tcp", "udp"]},
    "nacagent": {"port_number": 4407, "protocols": ["tcp"]},
    "slscc": {"port_number": 4408, "protocols": ["tcp"]},
    "netcabinet-com": {"port_number": 4409, "protocols": ["tcp"]},
    "itwo-server": {"port_number": 4410, "protocols": ["tcp"]},
    "found": {"port_number": 4411, "protocols": ["tcp"]},
    "smallchat": {"port_number": 4412, "protocols": ["udp"]},
    "avi-nms": {"port_number": 4413, "protocols": ["tcp"]},
    "avi-nms-disc": {"port_number": 4413, "protocols": ["udp"]},
    "updog": {"port_number": 4414, "protocols": ["tcp"]},
    "brcd-vr-req": {"port_number": 4415, "protocols": ["tcp"]},
    "pjj-player": {"port_number": 4416, "protocols": ["tcp"]},
    "pjj-player-disc": {"port_number": 4416, "protocols": ["udp"]},
    "workflowdir": {"port_number": 4417, "protocols": ["tcp"]},
    "axysbridge": {"port_number": 4418, "protocols": ["udp"]},
    "cbp": {"port_number": 4419, "protocols": ["tcp"]},
    "nvme": {"port_number": 4420, "protocols": ["tcp", "udp"]},
    "scaleft": {"port_number": 4421, "protocols": ["tcp"]},
    "tsepisp": {"port_number": 4422, "protocols": ["tcp"]},
    "thingkit": {"port_number": 4423, "protocols": ["tcp"]},
    "netrockey6": {"port_number": 4425, "protocols": ["tcp", "udp"]},
    "beacon-port-2": {"port_number": 4426, "protocols": ["tcp", "udp"]},
    "drizzle": {"port_number": 4427, "protocols": ["tcp"]},
    "omviserver": {"port_number": 4428, "protocols": ["tcp"]},
    "omviagent": {"port_number": 4429, "protocols": ["tcp"]},
    "rsqlserver": {"port_number": 4430, "protocols": ["tcp", "udp"]},
    "wspipe": {"port_number": 4431, "protocols": ["tcp"]},
    "l-acoustics": {"port_number": 4432, "protocols": ["tcp", "udp"]},
    "vop": {"port_number": 4433, "protocols": ["tcp"]},
    "netblox": {"port_number": 4441, "protocols": ["udp"]},
    "saris": {"port_number": 4442, "protocols": ["tcp", "udp"]},
    "pharos": {"port_number": 4443, "protocols": ["tcp", "udp"]},
    "krb524": {"port_number": 4444, "protocols": ["tcp", "udp"]},
    "nv-video": {"port_number": 4444, "protocols": ["tcp", "udp"]},
    "upnotifyp": {"port_number": 4445, "protocols": ["tcp", "udp"]},
    "n1-fwp": {"port_number": 4446, "protocols": ["tcp", "udp"]},
    "n1-rmgmt": {"port_number": 4447, "protocols": ["tcp", "udp"]},
    "asc-slmd": {"port_number": 4448, "protocols": ["tcp", "udp"]},
    "privatewire": {"port_number": 4449, "protocols": ["tcp", "udp"]},
    "camp": {"port_number": 4450, "protocols": ["tcp", "udp"]},
    "ctisystemmsg": {"port_number": 4451, "protocols": ["tcp", "udp"]},
    "ctiprogramload": {"port_number": 4452, "protocols": ["tcp", "udp"]},
    "nssalertmgr": {"port_number": 4453, "protocols": ["tcp", "udp"]},
    "nssagentmgr": {"port_number": 4454, "protocols": ["tcp", "udp"]},
    "prchat-user": {"port_number": 4455, "protocols": ["tcp", "udp"]},
    "prchat-server": {"port_number": 4456, "protocols": ["tcp", "udp"]},
    "prRegister": {"port_number": 4457, "protocols": ["tcp", "udp"]},
    "mcp": {"port_number": 4458, "protocols": ["tcp", "udp"]},
    "ntske": {"port_number": 4460, "protocols": ["tcp"]},
    "hpssmgmt": {"port_number": 4484, "protocols": ["tcp", "udp"]},
    "assyst-dr": {"port_number": 4485, "protocols": ["tcp"]},
    "icms": {"port_number": 4486, "protocols": ["tcp", "udp"]},
    "prex-tcp": {"port_number": 4487, "protocols": ["tcp"]},
    "awacs-ice": {"port_number": 4488, "protocols": ["tcp", "udp"]},
    "ipsec-nat-t": {"port_number": 4500, "protocols": ["tcp", "udp"]},
    "a25-fap-fgw": {"port_number": 4502, "protocols": ["sctp"]},
    "m-bus-oms": {"port_number": 4503, "protocols": ["udp"]},
    "armagetronad": {"port_number": 4534, "protocols": ["udp"]},
    "ehs": {"port_number": 4535, "protocols": ["tcp", "udp"]},
    "ehs-ssl": {"port_number": 4536, "protocols": ["tcp", "udp"]},
    "wssauthsvc": {"port_number": 4537, "protocols": ["tcp", "udp"]},
    "swx-gate": {"port_number": 4538, "protocols": ["tcp", "udp"]},
    "worldscores": {"port_number": 4545, "protocols": ["tcp", "udp"]},
    "sf-lm": {"port_number": 4546, "protocols": ["tcp", "udp"]},
    "lanner-lm": {"port_number": 4547, "protocols": ["tcp", "udp"]},
    "synchromesh": {"port_number": 4548, "protocols": ["tcp", "udp"]},
    "aegate": {"port_number": 4549, "protocols": ["tcp", "udp"]},
    "gds-adppiw-db": {"port_number": 4550, "protocols": ["tcp", "udp"]},
    "ieee-mih": {"port_number": 4551, "protocols": ["tcp", "udp"]},
    "menandmice-mon": {"port_number": 4552, "protocols": ["tcp", "udp"]},
    "icshostsvc": {"port_number": 4553, "protocols": ["tcp"]},
    "msfrs": {"port_number": 4554, "protocols": ["tcp", "udp"]},
    "rsip": {"port_number": 4555, "protocols": ["tcp", "udp"]},
    "dtn-bundle": {"port_number": 4556, "protocols": ["tcp", "udp", "dccp"]},
    "mtcevrunqss": {"port_number": 4557, "protocols": ["udp"]},
    "mtcevrunqman": {"port_number": 4558, "protocols": ["udp"]},
    "hylafax": {"port_number": 4559, "protocols": ["tcp", "udp"]},
    "amahi-anywhere": {"port_number": 4563, "protocols": ["tcp"]},
    "kwtc": {"port_number": 4566, "protocols": ["tcp", "udp"]},
    "tram": {"port_number": 4567, "protocols": ["tcp", "udp"]},
    "bmc-reporting": {"port_number": 4568, "protocols": ["tcp", "udp"]},
    "iax": {"port_number": 4569, "protocols": ["tcp", "udp"]},
    "deploymentmap": {"port_number": 4570, "protocols": ["tcp"]},
    "cardifftec-back": {"port_number": 4573, "protocols": ["tcp"]},
    "rid": {"port_number": 4590, "protocols": ["tcp"]},
    "l3t-at-an": {"port_number": 4591, "protocols": ["tcp", "udp"]},
    "hrpd-ith-at-an": {"port_number": 4592, "protocols": ["udp"]},
    "ipt-anri-anri": {"port_number": 4593, "protocols": ["tcp", "udp"]},
    "ias-session": {"port_number": 4594, "protocols": ["tcp", "udp"]},
    "ias-paging": {"port_number": 4595, "protocols": ["tcp", "udp"]},
    "ias-neighbor": {"port_number": 4596, "protocols": ["tcp", "udp"]},
    "a21-an-1xbs": {"port_number": 4597, "protocols": ["tcp", "udp"]},
    "a16-an-an": {"port_number": 4598, "protocols": ["tcp", "udp"]},
    "a17-an-an": {"port_number": 4599, "protocols": ["tcp", "udp"]},
    "piranha1": {"port_number": 4600, "protocols": ["tcp", "udp"]},
    "piranha2": {"port_number": 4601, "protocols": ["tcp", "udp"]},
    "mtsserver": {"port_number": 4602, "protocols": ["tcp"]},
    "menandmice-upg": {"port_number": 4603, "protocols": ["tcp"]},
    "irp": {"port_number": 4604, "protocols": ["tcp"]},
    "sixchat": {"port_number": 4605, "protocols": ["tcp"]},
    "sixid": {"port_number": 4606, "protocols": ["tcp"]},
    "ventoso": {"port_number": 4621, "protocols": ["udp"]},
    "dots-signal": {"port_number": 4646, "protocols": ["tcp", "udp"]},
    "playsta2-app": {"port_number": 4658, "protocols": ["tcp", "udp"]},
    "playsta2-lob": {"port_number": 4659, "protocols": ["tcp", "udp"]},
    "smaclmgr": {"port_number": 4660, "protocols": ["tcp", "udp"]},
    "kar2ouche": {"port_number": 4661, "protocols": ["tcp", "udp"]},
    "oms": {"port_number": 4662, "protocols": ["tcp", "udp"]},
    "noteit": {"port_number": 4663, "protocols": ["tcp", "udp"]},
    "ems": {"port_number": 4664, "protocols": ["tcp", "udp"]},
    "contclientms": {"port_number": 4665, "protocols": ["tcp", "udp"]},
    "eportcomm": {"port_number": 4666, "protocols": ["tcp", "udp"]},
    "mmacomm": {"port_number": 4667, "protocols": ["tcp", "udp"]},
    "mmaeds": {"port_number": 4668, "protocols": ["tcp", "udp"]},
    "eportcommdata": {"port_number": 4669, "protocols": ["tcp", "udp"]},
    "light": {"port_number": 4670, "protocols": ["tcp", "udp"]},
    "acter": {"port_number": 4671, "protocols": ["tcp", "udp"]},
    "rfa": {"port_number": 4672, "protocols": ["tcp", "udp"]},
    "cxws": {"port_number": 4673, "protocols": ["tcp", "udp"]},
    "appiq-mgmt": {"port_number": 4674, "protocols": ["tcp", "udp"]},
    "dhct-status": {"port_number": 4675, "protocols": ["tcp", "udp"]},
    "dhct-alerts": {"port_number": 4676, "protocols": ["tcp", "udp"]},
    "bcs": {"port_number": 4677, "protocols": ["tcp", "udp"]},
    "traversal": {"port_number": 4678, "protocols": ["tcp", "udp"]},
    "mgesupervision": {"port_number": 4679, "protocols": ["tcp", "udp"]},
    "mgemanagement": {"port_number": 4680, "protocols": ["tcp", "udp"]},
    "parliant": {"port_number": 4681, "protocols": ["tcp", "udp"]},
    "finisar": {"port_number": 4682, "protocols": ["tcp", "udp"]},
    "spike": {"port_number": 4683, "protocols": ["tcp", "udp"]},
    "rfid-rp1": {"port_number": 4684, "protocols": ["tcp", "udp"]},
    "autopac": {"port_number": 4685, "protocols": ["tcp", "udp"]},
    "msp-os": {"port_number": 4686, "protocols": ["tcp", "udp"]},
    "nst": {"port_number": 4687, "protocols": ["tcp", "udp"]},
    "mobile-p2p": {"port_number": 4688, "protocols": ["tcp", "udp"]},
    "altovacentral": {"port_number": 4689, "protocols": ["tcp", "udp"]},
    "prelude": {"port_number": 4690, "protocols": ["tcp", "udp"]},
    "mtn": {"port_number": 4691, "protocols": ["tcp", "udp"]},
    "conspiracy": {"port_number": 4692, "protocols": ["tcp", "udp"]},
    "netxms-agent": {"port_number": 4700, "protocols": ["tcp", "udp"]},
    "netxms-mgmt": {"port_number": 4701, "protocols": ["tcp", "udp"]},
    "netxms-sync": {"port_number": 4702, "protocols": ["tcp", "udp"]},
    "npqes-test": {"port_number": 4703, "protocols": ["tcp"]},
    "assuria-ins": {"port_number": 4704, "protocols": ["tcp"]},
    "trinity-dist": {"port_number": 4711, "protocols": ["tcp", "udp", "sctp"]},
    "truckstar": {"port_number": 4725, "protocols": ["tcp", "udp"]},
    "a26-fap-fgw": {"port_number": 4726, "protocols": ["udp"]},
    "fcis": {"port_number": 4727, "protocols": ["tcp"]},
    "fcis-disc": {"port_number": 4727, "protocols": ["udp"]},
    "capmux": {"port_number": 4728, "protocols": ["tcp", "udp"]},
    "gsmtap": {"port_number": 4729, "protocols": ["udp"]},
    "gearman": {"port_number": 4730, "protocols": ["tcp", "udp"]},
    "remcap": {"port_number": 4731, "protocols": ["tcp"]},
    "ohmtrigger": {"port_number": 4732, "protocols": ["udp"]},
    "resorcs": {"port_number": 4733, "protocols": ["tcp"]},
    "ipdr-sp": {"port_number": 4737, "protocols": ["tcp", "udp"]},
    "solera-lpn": {"port_number": 4738, "protocols": ["tcp", "udp"]},
    "ipfix": {"port_number": 4739, "protocols": ["tcp", "udp", "sctp"]},
    "ipfixs": {"port_number": 4740, "protocols": ["tcp", "sctp", "udp"]},
    "lumimgrd": {"port_number": 4741, "protocols": ["tcp", "udp"]},
    "sicct": {"port_number": 4742, "protocols": ["tcp"]},
    "sicct-sdp": {"port_number": 4742, "protocols": ["udp"]},
    "openhpid": {"port_number": 4743, "protocols": ["tcp", "udp"]},
    "ifsp": {"port_number": 4744, "protocols": ["tcp", "udp"]},
    "fmp": {"port_number": 4745, "protocols": ["tcp", "udp"]},
    "intelliadm-disc": {"port_number": 4746, "protocols": ["udp"]},
    "buschtrommel": {"port_number": 4747, "protocols": ["udp"]},
    "profilemac": {"port_number": 4749, "protocols": ["tcp", "udp"]},
    "ssad": {"port_number": 4750, "protocols": ["tcp", "udp"]},
    "spocp": {"port_number": 4751, "protocols": ["tcp", "udp"]},
    "snap": {"port_number": 4752, "protocols": ["tcp", "udp"]},
    "simon": {"port_number": 4753, "protocols": ["tcp"]},
    "simon-disc": {"port_number": 4753, "protocols": ["udp"]},
    "gre-in-udp": {"port_number": 4754, "protocols": ["udp"]},
    "gre-udp-dtls": {"port_number": 4755, "protocols": ["udp"]},
    "RDCenter": {"port_number": 4756, "protocols": ["tcp"]},
    "converge": {"port_number": 4774, "protocols": ["tcp"]},
    "bfd-multi-ctl": {"port_number": 4784, "protocols": ["tcp", "udp"]},
    "cncp": {"port_number": 4785, "protocols": ["udp"]},
    "smart-install": {"port_number": 4786, "protocols": ["tcp"]},
    "sia-ctrl-plane": {"port_number": 4787, "protocols": ["tcp"]},
    "xmcp": {"port_number": 4788, "protocols": ["tcp"]},
    "vxlan": {"port_number": 4789, "protocols": ["udp"]},
    "vxlan-gpe": {"port_number": 4790, "protocols": ["udp"]},
    "roce": {"port_number": 4791, "protocols": ["udp"]},
    "unified-bus": {"port_number": 4792, "protocols": ["tcp", "udp"]},
    "uet": {"port_number": 4793, "protocols": ["udp"]},
    "iims": {"port_number": 4800, "protocols": ["tcp", "udp"]},
    "iwec": {"port_number": 4801, "protocols": ["tcp", "udp"]},
    "ilss": {"port_number": 4802, "protocols": ["tcp", "udp"]},
    "notateit": {"port_number": 4803, "protocols": ["tcp"]},
    "notateit-disc": {"port_number": 4803, "protocols": ["udp"]},
    "aja-ntv4-disc": {"port_number": 4804, "protocols": ["udp"]},
    "htcp": {"port_number": 4827, "protocols": ["tcp", "udp"]},
    "varadero-0": {"port_number": 4837, "protocols": ["tcp", "udp"]},
    "varadero-1": {"port_number": 4838, "protocols": ["tcp", "udp"]},
    "varadero-2": {"port_number": 4839, "protocols": ["tcp", "udp"]},
    "opcua-tcp": {"port_number": 4840, "protocols": ["tcp"]},
    "opcua-udp": {"port_number": 4840, "protocols": ["udp"]},
    "quosa": {"port_number": 4841, "protocols": ["tcp", "udp"]},
    "gw-asv": {"port_number": 4842, "protocols": ["tcp", "udp"]},
    "opcua-tls": {"port_number": 4843, "protocols": ["tcp", "udp"]},
    "gw-log": {"port_number": 4844, "protocols": ["tcp", "udp"]},
    "wcr-remlib": {"port_number": 4845, "protocols": ["tcp", "udp"]},
    "contamac-icm": {"port_number": 4846, "protocols": ["tcp", "udp"]},
    "contamac_icm": {"port_number": 4846, "protocols": ["tcp", "udp"]},
    "wfc": {"port_number": 4847, "protocols": ["tcp", "udp"]},
    "appserv-http": {"port_number": 4848, "protocols": ["tcp", "udp"]},
    "appserv-https": {"port_number": 4849, "protocols": ["tcp", "udp"]},
    "sun-as-nodeagt": {"port_number": 4850, "protocols": ["tcp", "udp"]},
    "derby-repli": {"port_number": 4851, "protocols": ["tcp", "udp"]},
    "unify-debug": {"port_number": 4867, "protocols": ["tcp", "udp"]},
    "phrelay": {"port_number": 4868, "protocols": ["tcp", "udp"]},
    "phrelaydbg": {"port_number": 4869, "protocols": ["tcp", "udp"]},
    "cc-tracking": {"port_number": 4870, "protocols": ["tcp", "udp"]},
    "wired": {"port_number": 4871, "protocols": ["tcp", "udp"]},
    "tritium-can": {"port_number": 4876, "protocols": ["tcp", "udp"]},
    "lmcs": {"port_number": 4877, "protocols": ["tcp", "udp"]},
    "inst-discovery": {"port_number": 4878, "protocols": ["udp"]},
    "wsdl-event": {"port_number": 4879, "protocols": ["tcp"]},
    "hislip": {"port_number": 4880, "protocols": ["tcp"]},
    "socp-t": {"port_number": 4881, "protocols": ["udp"]},
    "socp-c": {"port_number": 4882, "protocols": ["udp"]},
    "wmlserver": {"port_number": 4883, "protocols": ["tcp"]},
    "hivestor": {"port_number": 4884, "protocols": ["tcp", "udp"]},
    "abbs": {"port_number": 4885, "protocols": ["tcp", "udp"]},
    "xcap-portal": {"port_number": 4888, "protocols": ["tcp"]},
    "xcap-control": {"port_number": 4889, "protocols": ["tcp"]},
    "lyskom": {"port_number": 4894, "protocols": ["tcp", "udp"]},
    "radmin-port": {"port_number": 4899, "protocols": ["tcp", "udp"]},
    "hfcs": {"port_number": 4900, "protocols": ["tcp", "udp"]},
    "flr-agent": {"port_number": 4901, "protocols": ["tcp"]},
    "flr_agent": {"port_number": 4901, "protocols": ["tcp"]},
    "magiccontrol": {"port_number": 4902, "protocols": ["tcp"]},
    "lutap": {"port_number": 4912, "protocols": ["tcp"]},
    "lutcp": {"port_number": 4913, "protocols": ["tcp"]},
    "bones": {"port_number": 4914, "protocols": ["tcp", "udp"]},
    "frcs": {"port_number": 4915, "protocols": ["tcp"]},
    "an-signaling": {"port_number": 4936, "protocols": ["udp"]},
    "atsc-mh-ssc": {"port_number": 4937, "protocols": ["udp"]},
    "eq-office-4940": {"port_number": 4940, "protocols": ["tcp", "udp"]},
    "eq-office-4941": {"port_number": 4941, "protocols": ["tcp", "udp"]},
    "eq-office-4942": {"port_number": 4942, "protocols": ["tcp", "udp"]},
    "munin": {"port_number": 4949, "protocols": ["tcp", "udp"]},
    "sybasesrvmon": {"port_number": 4950, "protocols": ["tcp", "udp"]},
    "pwgwims": {"port_number": 4951, "protocols": ["tcp", "udp"]},
    "sagxtsds": {"port_number": 4952, "protocols": ["tcp", "udp"]},
    "dbsyncarbiter": {"port_number": 4953, "protocols": ["tcp"]},
    "ccss-qmm": {"port_number": 4969, "protocols": ["tcp", "udp"]},
    "ccss-qsm": {"port_number": 4970, "protocols": ["tcp", "udp"]},
    "burp": {"port_number": 4971, "protocols": ["tcp"]},
    "ctxs-vpp": {"port_number": 4980, "protocols": ["udp"]},
    "webyast": {"port_number": 4984, "protocols": ["tcp"]},
    "gerhcs": {"port_number": 4985, "protocols": ["tcp"]},
    "mrip": {"port_number": 4986, "protocols": ["tcp", "udp"]},
    "smar-se-port1": {"port_number": 4987, "protocols": ["tcp", "udp"]},
    "smar-se-port2": {"port_number": 4988, "protocols": ["tcp", "udp"]},
    "parallel": {"port_number": 4989, "protocols": ["tcp", "udp"]},
    "busycal": {"port_number": 4990, "protocols": ["tcp", "udp"]},
    "vrt": {"port_number": 4991, "protocols": ["tcp", "udp"]},
    "hfcs-manager": {"port_number": 4999, "protocols": ["tcp", "udp"]},
    "commplex-main": {"port_number": 5000, "protocols": ["tcp", "udp"]},
    "commplex-link": {"port_number": 5001, "protocols": ["tcp", "udp"]},
    "rfe": {"port_number": 5002, "protocols": ["tcp", "udp"]},
    "fmpro-internal": {"port_number": 5003, "protocols": ["tcp", "udp"]},
    "avt-profile-1": {"port_number": 5004, "protocols": ["tcp", "udp", "dccp"]},
    "avt-profile-2": {"port_number": 5005, "protocols": ["tcp", "udp", "dccp"]},
    "wsm-server": {"port_number": 5006, "protocols": ["tcp", "udp"]},
    "wsm-server-ssl": {"port_number": 5007, "protocols": ["tcp", "udp"]},
    "synapsis-edge": {"port_number": 5008, "protocols": ["tcp", "udp"]},
    "winfs": {"port_number": 5009, "protocols": ["tcp", "udp"]},
    "telelpathstart": {"port_number": 5010, "protocols": ["tcp", "udp"]},
    "telelpathattack": {"port_number": 5011, "protocols": ["tcp", "udp"]},
    "nsp": {"port_number": 5012, "protocols": ["tcp", "udp"]},
    "fmpro-v6": {"port_number": 5013, "protocols": ["tcp", "udp"]},
    "onpsocket": {"port_number": 5014, "protocols": ["udp"]},
    "fmwp": {"port_number": 5015, "protocols": ["tcp"]},
    "zenginkyo-1": {"port_number": 5020, "protocols": ["tcp", "udp"]},
    "zenginkyo-2": {"port_number": 5021, "protocols": ["tcp", "udp"]},
    "mice": {"port_number": 5022, "protocols": ["tcp", "udp"]},
    "htuilsrv": {"port_number": 5023, "protocols": ["tcp", "udp"]},
    "scpi-telnet": {"port_number": 5024, "protocols": ["tcp", "udp"]},
    "scpi-raw": {"port_number": 5025, "protocols": ["tcp", "udp"]},
    "strexec-d": {"port_number": 5026, "protocols": ["tcp", "udp"]},
    "strexec-s": {"port_number": 5027, "protocols": ["tcp", "udp"]},
    "qvr": {"port_number": 5028, "protocols": ["tcp"]},
    "infobright": {"port_number": 5029, "protocols": ["tcp", "udp"]},
    "dmp": {"port_number": 5031, "protocols": ["udp"]},
    "signacert-agent": {"port_number": 5032, "protocols": ["tcp"]},
    "jtnetd-server": {"port_number": 5033, "protocols": ["tcp"]},
    "jtnetd-status": {"port_number": 5034, "protocols": ["tcp"]},
    "asnaacceler8db": {"port_number": 5042, "protocols": ["tcp", "udp"]},
    "swxadmin": {"port_number": 5043, "protocols": ["tcp", "udp"]},
    "lxi-evntsvc": {"port_number": 5044, "protocols": ["tcp", "udp"]},
    "osp": {"port_number": 5045, "protocols": ["tcp"]},
    "vpm-udp": {"port_number": 5046, "protocols": ["udp"]},
    "iscape": {"port_number": 5047, "protocols": ["udp"]},
    "texai": {"port_number": 5048, "protocols": ["tcp"]},
    "ivocalize": {"port_number": 5049, "protocols": ["tcp", "udp"]},
    "mmcc": {"port_number": 5050, "protocols": ["tcp", "udp"]},
    "ita-agent": {"port_number": 5051, "protocols": ["tcp", "udp"]},
    "ita-manager": {"port_number": 5052, "protocols": ["tcp", "udp"]},
    "rlm": {"port_number": 5053, "protocols": ["tcp"]},
    "rlm-disc": {"port_number": 5053, "protocols": ["udp"]},
    "rlm-admin": {"port_number": 5054, "protocols": ["tcp"]},
    "unot": {"port_number": 5055, "protocols": ["tcp", "udp"]},
    "intecom-ps1": {"port_number": 5056, "protocols": ["tcp", "udp"]},
    "intecom-ps2": {"port_number": 5057, "protocols": ["tcp", "udp"]},
    "locus-disc": {"port_number": 5058, "protocols": ["udp"]},
    "sds": {"port_number": 5059, "protocols": ["tcp", "udp"]},
    "sip": {"port_number": 5060, "protocols": ["tcp", "udp", "sctp"]},
    "sips": {"port_number": 5061, "protocols": ["tcp", "udp", "sctp"]},
    "na-localise": {"port_number": 5062, "protocols": ["tcp", "udp"]},
    "csrpc": {"port_number": 5063, "protocols": ["tcp"]},
    "ca-1": {"port_number": 5064, "protocols": ["tcp", "udp"]},
    "ca-2": {"port_number": 5065, "protocols": ["tcp", "udp"]},
    "stanag-5066": {"port_number": 5066, "protocols": ["tcp", "udp"]},
    "authentx": {"port_number": 5067, "protocols": ["tcp", "udp"]},
    "bitforestsrv": {"port_number": 5068, "protocols": ["tcp"]},
    "i-net-2000-npr": {"port_number": 5069, "protocols": ["tcp", "udp"]},
    "vtsas": {"port_number": 5070, "protocols": ["tcp", "udp"]},
    "powerschool": {"port_number": 5071, "protocols": ["tcp", "udp"]},
    "ayiya": {"port_number": 5072, "protocols": ["tcp", "udp"]},
    "tag-pm": {"port_number": 5073, "protocols": ["tcp", "udp"]},
    "alesquery": {"port_number": 5074, "protocols": ["tcp", "udp"]},
    "pvaccess": {"port_number": 5075, "protocols": ["tcp"]},
    "pixelpusher": {"port_number": 5078, "protocols": ["udp"]},
    "cp-spxrpts": {"port_number": 5079, "protocols": ["udp"]},
    "onscreen": {"port_number": 5080, "protocols": ["tcp", "udp"]},
    "sdl-ets": {"port_number": 5081, "protocols": ["tcp", "udp"]},
    "qcp": {"port_number": 5082, "protocols": ["tcp", "udp"]},
    "qfp": {"port_number": 5083, "protocols": ["tcp", "udp"]},
    "llrp": {"port_number": 5084, "protocols": ["tcp", "udp"]},
    "encrypted-llrp": {"port_number": 5085, "protocols": ["tcp", "udp"]},
    "aprigo-cs": {"port_number": 5086, "protocols": ["tcp"]},
    "biotic": {"port_number": 5087, "protocols": ["tcp"]},
    "car": {"port_number": 5090, "protocols": ["sctp"]},
    "cxtp": {"port_number": 5091, "protocols": ["sctp"]},
    "magpie": {"port_number": 5092, "protocols": ["udp"]},
    "sentinel-lm": {"port_number": 5093, "protocols": ["tcp", "udp"]},
    "hart-ip": {"port_number": 5094, "protocols": ["tcp", "udp"]},
    "sentlm-srv2srv": {"port_number": 5099, "protocols": ["tcp", "udp"]},
    "socalia": {"port_number": 5100, "protocols": ["tcp", "udp"]},
    "talarian-tcp": {"port_number": 5101, "protocols": ["tcp"]},
    "talarian-udp": {"port_number": 5101, "protocols": ["udp"]},
    "oms-nonsecure": {"port_number": 5102, "protocols": ["tcp", "udp"]},
    "actifio-c2c": {"port_number": 5103, "protocols": ["tcp"]},
    "tinymessage": {"port_number": 5104, "protocols": ["udp"]},
    "hughes-ap": {"port_number": 5105, "protocols": ["udp"]},
    "actifioudsagent": {"port_number": 5106, "protocols": ["tcp"]},
    "actifioreplic": {"port_number": 5107, "protocols": ["tcp"]},
    "taep-as-svc": {"port_number": 5111, "protocols": ["tcp", "udp"]},
    "pm-cmdsvr": {"port_number": 5112, "protocols": ["tcp", "udp"]},
    "ev-services": {"port_number": 5114, "protocols": ["tcp"]},
    "autobuild": {"port_number": 5115, "protocols": ["tcp"]},
    "emb-proj-cmd": {"port_number": 5116, "protocols": ["udp"]},
    "gradecam": {"port_number": 5117, "protocols": ["tcp"]},
    "barracuda-bbs": {"port_number": 5120, "protocols": ["tcp", "udp"]},
    "nbt-pc": {"port_number": 5133, "protocols": ["tcp", "udp"]},
    "ppactivation": {"port_number": 5134, "protocols": ["tcp"]},
    "erp-scale": {"port_number": 5135, "protocols": ["tcp"]},
    "minotaur-sa": {"port_number": 5136, "protocols": ["udp"]},
    "ctsd": {"port_number": 5137, "protocols": ["tcp", "udp"]},
    "rmonitor-secure": {"port_number": 5145, "protocols": ["tcp", "udp"]},
    "rmonitor_secure": {"port_number": 5145, "protocols": ["tcp", "udp"]},
    "social-alarm": {"port_number": 5146, "protocols": ["tcp"]},
    "atmp": {"port_number": 5150, "protocols": ["tcp", "udp"]},
    "esri-sde": {"port_number": 5151, "protocols": ["tcp", "udp"]},
    "esri_sde": {"port_number": 5151, "protocols": ["tcp", "udp"]},
    "sde-discovery": {"port_number": 5152, "protocols": ["tcp", "udp"]},
    "bzflag": {"port_number": 5154, "protocols": ["tcp", "udp"]},
    "asctrl-agent": {"port_number": 5155, "protocols": ["tcp", "udp"]},
    "rugameonline": {"port_number": 5156, "protocols": ["tcp"]},
    "mediat": {"port_number": 5157, "protocols": ["tcp"]},
    "snmpssh": {"port_number": 5161, "protocols": ["tcp"]},
    "snmpssh-trap": {"port_number": 5162, "protocols": ["tcp"]},
    "sbackup": {"port_number": 5163, "protocols": ["tcp"]},
    "vpa": {"port_number": 5164, "protocols": ["tcp"]},
    "vpa-disc": {"port_number": 5164, "protocols": ["udp"]},
    "ife-icorp": {"port_number": 5165, "protocols": ["tcp", "udp"]},
    "ife_icorp": {"port_number": 5165, "protocols": ["tcp", "udp"]},
    "winpcs": {"port_number": 5166, "protocols": ["tcp", "udp"]},
    "scte104": {"port_number": 5167, "protocols": ["tcp", "udp"]},
    "scte30": {"port_number": 5168, "protocols": ["tcp", "udp"]},
    "pcoip-mgmt": {"port_number": 5172, "protocols": ["tcp"]},
    "aol": {"port_number": 5190, "protocols": ["tcp", "udp"]},
    "aol-1": {"port_number": 5191, "protocols": ["tcp", "udp"]},
    "aol-2": {"port_number": 5192, "protocols": ["tcp", "udp"]},
    "aol-3": {"port_number": 5193, "protocols": ["tcp", "udp"]},
    "cpscomm": {"port_number": 5194, "protocols": ["tcp"]},
    "ampl-lic": {"port_number": 5195, "protocols": ["tcp"]},
    "ampl-tableproxy": {"port_number": 5196, "protocols": ["tcp"]},
    "tunstall-lwp": {"port_number": 5197, "protocols": ["tcp"]},
    "targus-getdata": {"port_number": 5200, "protocols": ["tcp", "udp"]},
    "targus-getdata1": {"port_number": 5201, "protocols": ["tcp", "udp"]},
    "targus-getdata2": {"port_number": 5202, "protocols": ["tcp", "udp"]},
    "targus-getdata3": {"port_number": 5203, "protocols": ["tcp", "udp"]},
    "nomad": {"port_number": 5209, "protocols": ["tcp"]},
    "noteza": {"port_number": 5215, "protocols": ["tcp", "sctp"]},
    "3exmp": {"port_number": 5221, "protocols": ["tcp"]},
    "xmpp-client": {"port_number": 5222, "protocols": ["tcp"]},
    "hpvirtgrp": {"port_number": 5223, "protocols": ["tcp", "udp"]},
    "hpvirtctrl": {"port_number": 5224, "protocols": ["tcp", "udp"]},
    "hp-server": {"port_number": 5225, "protocols": ["tcp", "udp"]},
    "hp-status": {"port_number": 5226, "protocols": ["tcp", "udp"]},
    "perfd": {"port_number": 5227, "protocols": ["tcp", "udp"]},
    "hpvroom": {"port_number": 5228, "protocols": ["tcp"]},
    "jaxflow": {"port_number": 5229, "protocols": ["tcp"]},
    "jaxflow-data": {"port_number": 5230, "protocols": ["tcp"]},
    "crusecontrol": {"port_number": 5231, "protocols": ["tcp"]},
    "csedaemon": {"port_number": 5232, "protocols": ["tcp"]},
    "enfs": {"port_number": 5233, "protocols": ["tcp"]},
    "eenet": {"port_number": 5234, "protocols": ["tcp", "udp"]},
    "galaxy-network": {"port_number": 5235, "protocols": ["tcp", "udp"]},
    "padl2sim": {"port_number": 5236, "protocols": ["tcp", "udp"]},
    "mnet-discovery": {"port_number": 5237, "protocols": ["tcp", "udp"]},
    "attune": {"port_number": 5242, "protocols": ["tcp"]},
    "xycstatus": {"port_number": 5243, "protocols": ["tcp"]},
    "downtools": {"port_number": 5245, "protocols": ["tcp"]},
    "downtools-disc": {"port_number": 5245, "protocols": ["udp"]},
    "capwap-control": {"port_number": 5246, "protocols": ["udp"]},
    "capwap-data": {"port_number": 5247, "protocols": ["udp"]},
    "caacws": {"port_number": 5248, "protocols": ["tcp", "udp"]},
    "caaclang2": {"port_number": 5249, "protocols": ["tcp", "udp"]},
    "soagateway": {"port_number": 5250, "protocols": ["tcp", "udp"]},
    "caevms": {"port_number": 5251, "protocols": ["tcp", "udp"]},
    "movaz-ssc": {"port_number": 5252, "protocols": ["tcp", "udp"]},
    "kpdp": {"port_number": 5253, "protocols": ["tcp"]},
    "logcabin": {"port_number": 5254, "protocols": ["tcp"]},
    "3com-njack-1": {"port_number": 5264, "protocols": ["tcp", "udp"]},
    "3com-njack-2": {"port_number": 5265, "protocols": ["tcp", "udp"]},
    "xmpp-server": {"port_number": 5269, "protocols": ["tcp"]},
    "cartographerxmp": {"port_number": 5270, "protocols": ["tcp", "udp"]},
    "cuelink": {"port_number": 5271, "protocols": ["tcp"]},
    "cuelink-disc": {"port_number": 5271, "protocols": ["udp"]},
    "pk": {"port_number": 5272, "protocols": ["tcp", "udp"]},
    "xmpp-bosh": {"port_number": 5280, "protocols": ["tcp"]},
    "undo-lm": {"port_number": 5281, "protocols": ["tcp"]},
    "transmit-port": {"port_number": 5282, "protocols": ["tcp", "udp"]},
    "presence": {"port_number": 5298, "protocols": ["tcp", "udp"]},
    "nlg-data": {"port_number": 5299, "protocols": ["tcp", "udp"]},
    "hacl-hb": {"port_number": 5300, "protocols": ["tcp", "udp"]},
    "hacl-gs": {"port_number": 5301, "protocols": ["tcp", "udp"]},
    "hacl-cfg": {"port_number": 5302, "protocols": ["tcp", "udp"]},
    "hacl-probe": {"port_number": 5303, "protocols": ["tcp", "udp"]},
    "hacl-local": {"port_number": 5304, "protocols": ["tcp", "udp"]},
    "hacl-test": {"port_number": 5305, "protocols": ["tcp", "udp"]},
    "sun-mc-grp": {"port_number": 5306, "protocols": ["tcp", "udp"]},
    "sco-aip": {"port_number": 5307, "protocols": ["tcp", "udp"]},
    "cfengine": {"port_number": 5308, "protocols": ["tcp", "udp"]},
    "jprinter": {"port_number": 5309, "protocols": ["tcp", "udp"]},
    "outlaws": {"port_number": 5310, "protocols": ["tcp", "udp"]},
    "permabit-cs": {"port_number": 5312, "protocols": ["tcp", "udp"]},
    "rrdp": {"port_number": 5313, "protocols": ["tcp", "udp"]},
    "opalis-rbt-ipc": {"port_number": 5314, "protocols": ["tcp", "udp"]},
    "hacl-poll": {"port_number": 5315, "protocols": ["tcp", "udp"]},
    "hpbladems": {"port_number": 5316, "protocols": ["tcp"]},
    "hpdevms": {"port_number": 5317, "protocols": ["tcp"]},
    "pkix-cmc": {"port_number": 5318, "protocols": ["tcp"]},
    "bsfserver-zn": {"port_number": 5320, "protocols": ["tcp"]},
    "bsfsvr-zn-ssl": {"port_number": 5321, "protocols": ["tcp"]},
    "kfserver": {"port_number": 5343, "protocols": ["tcp", "udp"]},
    "xkotodrcp": {"port_number": 5344, "protocols": ["tcp", "udp"]},
    "stuns": {"port_number": 5349, "protocols": ["tcp", "udp"]},
    "turns": {"port_number": 5349, "protocols": ["tcp", "udp"]},
    "stun-behaviors": {"port_number": 5349, "protocols": ["tcp", "udp"]},
    "pcp-multicast": {"port_number": 5350, "protocols": ["udp"]},
    "pcp": {"port_number": 5351, "protocols": ["udp"]},
    "dns-llq": {"port_number": 5352, "protocols": ["tcp", "udp"]},
    "mdns": {"port_number": 5353, "protocols": ["tcp", "udp"]},
    "mdnsresponder": {"port_number": 5354, "protocols": ["tcp", "udp"]},
    "llmnr": {"port_number": 5355, "protocols": ["tcp", "udp"]},
    "ms-smlbiz": {"port_number": 5356, "protocols": ["tcp", "udp"]},
    "wsdapi": {"port_number": 5357, "protocols": ["tcp", "udp"]},
    "wsdapi-s": {"port_number": 5358, "protocols": ["tcp", "udp"]},
    "ms-alerter": {"port_number": 5359, "protocols": ["tcp", "udp"]},
    "ms-sideshow": {"port_number": 5360, "protocols": ["tcp", "udp"]},
    "ms-s-sideshow": {"port_number": 5361, "protocols": ["tcp", "udp"]},
    "serverwsd2": {"port_number": 5362, "protocols": ["tcp", "udp"]},
    "net-projection": {"port_number": 5363, "protocols": ["tcp", "udp"]},
    "kdnet": {"port_number": 5364, "protocols": ["udp"]},
    "stresstester": {"port_number": 5397, "protocols": ["tcp", "udp"]},
    "elektron-admin": {"port_number": 5398, "protocols": ["tcp", "udp"]},
    "securitychase": {"port_number": 5399, "protocols": ["tcp", "udp"]},
    "excerpt": {"port_number": 5400, "protocols": ["tcp", "udp"]},
    "excerpts": {"port_number": 5401, "protocols": ["tcp", "udp"]},
    "mftp-secondary": {"port_number": 5402, "protocols": ["tcp", "udp"]},
    "hpoms-ci-lstn": {"port_number": 5403, "protocols": ["tcp", "udp"]},
    "hpoms-dps-lstn": {"port_number": 5404, "protocols": ["tcp", "udp"]},
    "netsupport": {"port_number": 5405, "protocols": ["tcp", "udp"]},
    "systemics-sox": {"port_number": 5406, "protocols": ["tcp", "udp"]},
    "foresyte-clear": {"port_number": 5407, "protocols": ["tcp", "udp"]},
    "foresyte-sec": {"port_number": 5408, "protocols": ["tcp", "udp"]},
    "salient-dtasrv": {"port_number": 5409, "protocols": ["tcp", "udp"]},
    "salient-usrmgr": {"port_number": 5410, "protocols": ["tcp", "udp"]},
    "actnet": {"port_number": 5411, "protocols": ["tcp", "udp"]},
    "continuus": {"port_number": 5412, "protocols": ["tcp", "udp"]},
    "wwiotalk": {"port_number": 5413, "protocols": ["tcp", "udp"]},
    "statusd": {"port_number": 5414, "protocols": ["tcp", "udp"]},
    "ns-server": {"port_number": 5415, "protocols": ["tcp", "udp"]},
    "sns-gateway": {"port_number": 5416, "protocols": ["tcp", "udp"]},
    "sns-agent": {"port_number": 5417, "protocols": ["tcp", "udp"]},
    "mcntp": {"port_number": 5418, "protocols": ["tcp", "udp"]},
    "dj-ice": {"port_number": 5419, "protocols": ["tcp", "udp"]},
    "cylink-c": {"port_number": 5420, "protocols": ["tcp", "udp"]},
    "netsupport2": {"port_number": 5421, "protocols": ["tcp", "udp"]},
    "salient-mux": {"port_number": 5422, "protocols": ["tcp", "udp"]},
    "virtualuser": {"port_number": 5423, "protocols": ["tcp", "udp"]},
    "beyond-remote": {"port_number": 5424, "protocols": ["tcp", "udp"]},
    "br-channel": {"port_number": 5425, "protocols": ["tcp", "udp"]},
    "devbasic": {"port_number": 5426, "protocols": ["tcp", "udp"]},
    "sco-peer-tta": {"port_number": 5427, "protocols": ["tcp", "udp"]},
    "telaconsole": {"port_number": 5428, "protocols": ["tcp", "udp"]},
    "base": {"port_number": 5429, "protocols": ["tcp", "udp"]},
    "radec-corp": {"port_number": 5430, "protocols": ["tcp", "udp"]},
    "park-agent": {"port_number": 5431, "protocols": ["tcp", "udp"]},
    "postgresql": {"port_number": 5432, "protocols": ["tcp", "udp"]},
    "pyrrho": {"port_number": 5433, "protocols": ["tcp", "udp"]},
    "sgi-arrayd": {"port_number": 5434, "protocols": ["tcp", "udp"]},
    "sceanics": {"port_number": 5435, "protocols": ["tcp", "udp"]},
    "pmip6-cntl": {"port_number": 5436, "protocols": ["udp"]},
    "pmip6-data": {"port_number": 5437, "protocols": ["udp"]},
    "spss": {"port_number": 5443, "protocols": ["tcp", "udp"]},
    "smbdirect": {"port_number": 5445, "protocols": ["tcp", "sctp"]},
    "tiepie": {"port_number": 5450, "protocols": ["tcp"]},
    "tiepie-disc": {"port_number": 5450, "protocols": ["udp"]},
    "surebox": {"port_number": 5453, "protocols": ["tcp", "udp"]},
    "apc-5454": {"port_number": 5454, "protocols": ["tcp", "udp"]},
    "apc-5455": {"port_number": 5455, "protocols": ["tcp", "udp"]},
    "apc-5456": {"port_number": 5456, "protocols": ["tcp", "udp"]},
    "silkmeter": {"port_number": 5461, "protocols": ["tcp", "udp"]},
    "ttl-publisher": {"port_number": 5462, "protocols": ["tcp", "udp"]},
    "ttlpriceproxy": {"port_number": 5463, "protocols": ["tcp", "udp"]},
    "quailnet": {"port_number": 5464, "protocols": ["tcp", "udp"]},
    "netops-broker": {"port_number": 5465, "protocols": ["tcp", "udp"]},
    "apsolab-col": {"port_number": 5470, "protocols": ["tcp"]},
    "apsolab-cols": {"port_number": 5471, "protocols": ["tcp"]},
    "apsolab-tag": {"port_number": 5472, "protocols": ["tcp"]},
    "apsolab-tags": {"port_number": 5473, "protocols": ["tcp"]},
    "apsolab-rpc": {"port_number": 5474, "protocols": ["udp"]},
    "apsolab-data": {"port_number": 5475, "protocols": ["tcp"]},
    "fcp-addr-srvr1": {"port_number": 5500, "protocols": ["tcp", "udp"]},
    "fcp-addr-srvr2": {"port_number": 5501, "protocols": ["tcp", "udp"]},
    "fcp-srvr-inst1": {"port_number": 5502, "protocols": ["tcp", "udp"]},
    "fcp-srvr-inst2": {"port_number": 5503, "protocols": ["tcp", "udp"]},
    "fcp-cics-gw1": {"port_number": 5504, "protocols": ["tcp", "udp"]},
    "checkoutdb": {"port_number": 5505, "protocols": ["tcp", "udp"]},
    "amc": {"port_number": 5506, "protocols": ["tcp", "udp"]},
    "psl-management": {"port_number": 5507, "protocols": ["tcp"]},
    "matter": {"port_number": 5540, "protocols": ["tcp", "udp"]},
    "qftest-licserve": {"port_number": 5543, "protocols": ["tcp"]},
    "cbus": {"port_number": 5550, "protocols": ["tcp"]},
    "sgi-eventmond": {"port_number": 5553, "protocols": ["tcp", "udp"]},
    "sgi-esphttp": {"port_number": 5554, "protocols": ["tcp", "udp"]},
    "personal-agent": {"port_number": 5555, "protocols": ["tcp", "udp"]},
    "freeciv": {"port_number": 5556, "protocols": ["tcp", "udp"]},
    "farenet": {"port_number": 5557, "protocols": ["tcp"]},
    "dp-bura": {"port_number": 5565, "protocols": ["tcp"]},
    "westec-connect": {"port_number": 5566, "protocols": ["tcp"]},
    "dof-dps-mc-sec": {"port_number": 5567, "protocols": ["tcp", "udp"]},
    "sdt": {"port_number": 5568, "protocols": ["tcp", "udp"]},
    "rdmnet-ctrl": {"port_number": 5569, "protocols": ["tcp"]},
    "rdmnet-device": {"port_number": 5569, "protocols": ["udp"]},
    "sdmmp": {"port_number": 5573, "protocols": ["tcp", "udp"]},
    "lsi-bobcat": {"port_number": 5574, "protocols": ["tcp"]},
    "ora-oap": {"port_number": 5575, "protocols": ["tcp"]},
    "fdtracks": {"port_number": 5579, "protocols": ["tcp"]},
    "tmosms0": {"port_number": 5580, "protocols": ["tcp", "udp"]},
    "tmosms1": {"port_number": 5581, "protocols": ["tcp", "udp"]},
    "fac-restore": {"port_number": 5582, "protocols": ["tcp", "udp"]},
    "tmo-icon-sync": {"port_number": 5583, "protocols": ["tcp", "udp"]},
    "bis-web": {"port_number": 5584, "protocols": ["tcp", "udp"]},
    "bis-sync": {"port_number": 5585, "protocols": ["tcp", "udp"]},
    "att-mt-sms": {"port_number": 5586, "protocols": ["tcp"]},
    "ininmessaging": {"port_number": 5597, "protocols": ["tcp", "udp"]},
    "mctfeed": {"port_number": 5598, "protocols": ["tcp", "udp"]},
    "esinstall": {"port_number": 5599, "protocols": ["tcp", "udp"]},
    "esmmanager": {"port_number": 5600, "protocols": ["tcp", "udp"]},
    "esmagent": {"port_number": 5601, "protocols": ["tcp", "udp"]},
    "a1-msc": {"port_number": 5602, "protocols": ["tcp", "udp"]},
    "a1-bs": {"port_number": 5603, "protocols": ["tcp", "udp"]},
    "a3-sdunode": {"port_number": 5604, "protocols": ["tcp", "udp"]},
    "a4-sdunode": {"port_number": 5605, "protocols": ["tcp", "udp"]},
    "efr": {"port_number": 5618, "protocols": ["tcp"]},
    "ninaf": {"port_number": 5627, "protocols": ["tcp", "udp"]},
    "htrust": {"port_number": 5628, "protocols": ["tcp", "udp"]},
    "symantec-sfdb": {"port_number": 5629, "protocols": ["tcp", "udp"]},
    "precise-comm": {"port_number": 5630, "protocols": ["tcp", "udp"]},
    "pcanywheredata": {"port_number": 5631, "protocols": ["tcp", "udp"]},
    "pcanywherestat": {"port_number": 5632, "protocols": ["tcp", "udp"]},
    "beorl": {"port_number": 5633, "protocols": ["tcp", "udp"]},
    "xprtld": {"port_number": 5634, "protocols": ["tcp", "udp"]},
    "sfmsso": {"port_number": 5635, "protocols": ["tcp"]},
    "sfm-db-server": {"port_number": 5636, "protocols": ["tcp"]},
    "cssc": {"port_number": 5637, "protocols": ["tcp"]},
    "flcrs": {"port_number": 5638, "protocols": ["tcp"]},
    "ics": {"port_number": 5639, "protocols": ["tcp"]},
    "vfmobile": {"port_number": 5646, "protocols": ["tcp"]},
    "nrpe": {"port_number": 5666, "protocols": ["tcp"]},
    "filemq": {"port_number": 5670, "protocols": ["tcp"]},
    "zre-disc": {"port_number": 5670, "protocols": ["udp"]},
    "amqps": {"port_number": 5671, "protocols": ["tcp", "udp"]},
    "amqp": {"port_number": 5672, "protocols": ["tcp", "udp", "sctp"]},
    "jms": {"port_number": 5673, "protocols": ["tcp", "udp"]},
    "hyperscsi-port": {"port_number": 5674, "protocols": ["tcp", "udp"]},
    "v5ua": {"port_number": 5675, "protocols": ["tcp", "udp", "sctp"]},
    "raadmin": {"port_number": 5676, "protocols": ["tcp", "udp"]},
    "questdb2-lnchr": {"port_number": 5677, "protocols": ["tcp", "udp"]},
    "rrac": {"port_number": 5678, "protocols": ["tcp", "udp"]},
    "dccm": {"port_number": 5679, "protocols": ["tcp", "udp"]},
    "auriga-router": {"port_number": 5680, "protocols": ["tcp", "udp"]},
    "ncxcp": {"port_number": 5681, "protocols": ["tcp", "udp"]},
    "brightcore": {"port_number": 5682, "protocols": ["udp"]},
    "coap": {"port_number": 5683, "protocols": ["tcp", "udp"]},
    "coaps": {"port_number": 5684, "protocols": ["tcp", "udp"]},
    "gog-multiplayer": {"port_number": 5687, "protocols": ["udp"]},
    "ggz": {"port_number": 5688, "protocols": ["tcp", "udp"]},
    "qmvideo": {"port_number": 5689, "protocols": ["tcp", "udp"]},
    "rbsystem": {"port_number": 5693, "protocols": ["tcp"]},
    "kmip": {"port_number": 5696, "protocols": ["tcp"]},
    "supportassist": {"port_number": 5700, "protocols": ["tcp"]},
    "storageos": {"port_number": 5705, "protocols": ["tcp"]},
    "proshareaudio": {"port_number": 5713, "protocols": ["tcp", "udp"]},
    "prosharevideo": {"port_number": 5714, "protocols": ["tcp", "udp"]},
    "prosharedata": {"port_number": 5715, "protocols": ["tcp", "udp"]},
    "prosharerequest": {"port_number": 5716, "protocols": ["tcp", "udp"]},
    "prosharenotify": {"port_number": 5717, "protocols": ["tcp", "udp"]},
    "dpm": {"port_number": 5718, "protocols": ["tcp", "udp"]},
    "dpm-agent": {"port_number": 5719, "protocols": ["tcp", "udp"]},
    "ms-licensing": {"port_number": 5720, "protocols": ["tcp", "udp"]},
    "dtpt": {"port_number": 5721, "protocols": ["tcp", "udp"]},
    "msdfsr": {"port_number": 5722, "protocols": ["tcp", "udp"]},
    "omhs": {"port_number": 5723, "protocols": ["tcp", "udp"]},
    "omsdk": {"port_number": 5724, "protocols": ["tcp", "udp"]},
    "ms-ilm": {"port_number": 5725, "protocols": ["tcp"]},
    "ms-ilm-sts": {"port_number": 5726, "protocols": ["tcp"]},
    "asgenf": {"port_number": 5727, "protocols": ["tcp"]},
    "io-dist-data": {"port_number": 5728, "protocols": ["tcp"]},
    "io-dist-group": {"port_number": 5728, "protocols": ["udp"]},
    "openmail": {"port_number": 5729, "protocols": ["tcp", "udp"]},
    "unieng": {"port_number": 5730, "protocols": ["tcp", "udp"]},
    "ida-discover1": {"port_number": 5741, "protocols": ["tcp", "udp"]},
    "ida-discover2": {"port_number": 5742, "protocols": ["tcp", "udp"]},
    "watchdoc-pod": {"port_number": 5743, "protocols": ["tcp", "udp"]},
    "watchdoc": {"port_number": 5744, "protocols": ["tcp", "udp"]},
    "fcopy-server": {"port_number": 5745, "protocols": ["tcp", "udp"]},
    "fcopys-server": {"port_number": 5746, "protocols": ["tcp", "udp"]},
    "tunatic": {"port_number": 5747, "protocols": ["tcp", "udp"]},
    "tunalyzer": {"port_number": 5748, "protocols": ["tcp", "udp"]},
    "rscd": {"port_number": 5750, "protocols": ["tcp", "udp"]},
    "openmailg": {"port_number": 5755, "protocols": ["tcp", "udp"]},
    "x500ms": {"port_number": 5757, "protocols": ["tcp", "udp"]},
    "openmailns": {"port_number": 5766, "protocols": ["tcp", "udp"]},
    "s-openmail": {"port_number": 5767, "protocols": ["tcp", "udp"]},
    "openmailpxy": {"port_number": 5768, "protocols": ["tcp", "udp"]},
    "spramsca": {"port_number": 5769, "protocols": ["tcp", "udp"]},
    "spramsd": {"port_number": 5770, "protocols": ["tcp", "udp"]},
    "netagent": {"port_number": 5771, "protocols": ["tcp", "udp"]},
    "starfield-io": {"port_number": 5777, "protocols": ["tcp", "udp"]},
    "vts-rpc": {"port_number": 5780, "protocols": ["tcp"]},
    "3par-evts": {"port_number": 5781, "protocols": ["tcp", "udp"]},
    "3par-mgmt": {"port_number": 5782, "protocols": ["tcp", "udp"]},
    "3par-mgmt-ssl": {"port_number": 5783, "protocols": ["tcp", "udp"]},
    "ibar": {"port_number": 5784, "protocols": ["udp"]},
    "3par-rcopy": {"port_number": 5785, "protocols": ["tcp", "udp"]},
    "cisco-redu": {"port_number": 5786, "protocols": ["udp"]},
    "waascluster": {"port_number": 5787, "protocols": ["udp"]},
    "xtreamx": {"port_number": 5793, "protocols": ["tcp", "udp"]},
    "spdp": {"port_number": 5794, "protocols": ["udp"]},
    "enlabel-dpl": {"port_number": 5798, "protocols": ["tcp"]},
    "icmpd": {"port_number": 5813, "protocols": ["tcp", "udp"]},
    "spt-automation": {"port_number": 5814, "protocols": ["tcp", "udp"]},
    "autopassdaemon": {"port_number": 5820, "protocols": ["tcp"]},
    "shiprush-d-ch": {"port_number": 5841, "protocols": ["tcp"]},
    "reversion": {"port_number": 5842, "protocols": ["tcp"]},
    "wherehoo": {"port_number": 5859, "protocols": ["tcp", "udp"]},
    "ppsuitemsg": {"port_number": 5863, "protocols": ["tcp", "udp"]},
    "diameters": {"port_number": 5868, "protocols": ["tcp", "sctp"]},
    "jute": {"port_number": 5883, "protocols": ["tcp"]},
    "rfb": {"port_number": 5900, "protocols": ["tcp", "udp"]},
    "ff-ice": {"port_number": 5903, "protocols": ["tcp", "udp", "sctp"]},
    "ag-swim": {"port_number": 5904, "protocols": ["tcp", "udp", "sctp"]},
    "asmgcs": {"port_number": 5905, "protocols": ["tcp", "udp", "sctp"]},
    "rpas-c2": {"port_number": 5906, "protocols": ["tcp", "udp", "sctp"]},
    "dsd": {"port_number": 5907, "protocols": ["tcp", "udp", "sctp"]},
    "ipsma": {"port_number": 5908, "protocols": ["tcp", "udp", "sctp"]},
    "agma": {"port_number": 5909, "protocols": ["tcp", "udp", "sctp"]},
    "ats-atn": {"port_number": 5910, "protocols": ["tcp", "udp"]},
    "cm": {"port_number": 5910, "protocols": ["sctp"]},
    "ats-acars": {"port_number": 5911, "protocols": ["tcp", "udp"]},
    "cpdlc": {"port_number": 5911, "protocols": ["sctp"]},
    "ais-met": {"port_number": 5912, "protocols": ["tcp", "udp"]},
    "fis": {"port_number": 5912, "protocols": ["sctp"]},
    "aoc-acars": {"port_number": 5913, "protocols": ["tcp", "udp"]},
    "ads-c": {"port_number": 5913, "protocols": ["sctp"]},
    "ipsdtls": {"port_number": 5914, "protocols": ["tcp", "udp", "sctp"]},
    "indy": {"port_number": 5963, "protocols": ["tcp", "udp"]},
    "mppolicy-v5": {"port_number": 5968, "protocols": ["tcp", "udp"]},
    "mppolicy-mgr": {"port_number": 5969, "protocols": ["tcp", "udp"]},
    "couchdb": {"port_number": 5984, "protocols": ["tcp", "udp"]},
    "wsman": {"port_number": 5985, "protocols": ["tcp", "udp"]},
    "wsmans": {"port_number": 5986, "protocols": ["tcp", "udp"]},
    "wbem-rmi": {"port_number": 5987, "protocols": ["tcp", "udp"]},
    "wbem-http": {"port_number": 5988, "protocols": ["tcp", "udp"]},
    "wbem-https": {"port_number": 5989, "protocols": ["tcp", "udp"]},
    "wbem-exp-https": {"port_number": 5990, "protocols": ["tcp", "udp"]},
    "nuxsl": {"port_number": 5991, "protocols": ["tcp", "udp"]},
    "consul-insight": {"port_number": 5992, "protocols": ["tcp", "udp"]},
    "cim-rs": {"port_number": 5993, "protocols": ["tcp"]},
    "rms-agent": {"port_number": 5994, "protocols": ["tcp"]},
    "cvsup": {"port_number": 5999, "protocols": ["tcp", "udp"]},
    "ndl-ahp-svc": {"port_number": 6064, "protocols": ["tcp", "udp"]},
    "winpharaoh": {"port_number": 6065, "protocols": ["tcp", "udp"]},
    "ewctsp": {"port_number": 6066, "protocols": ["tcp", "udp"]},
    "gsmp-ancp": {"port_number": 6068, "protocols": ["tcp"]},
    "trip": {"port_number": 6069, "protocols": ["tcp", "udp"]},
    "messageasap": {"port_number": 6070, "protocols": ["tcp", "udp"]},
    "ssdtp": {"port_number": 6071, "protocols": ["tcp", "udp"]},
    "diagnose-proc": {"port_number": 6072, "protocols": ["tcp", "udp"]},
    "directplay8": {"port_number": 6073, "protocols": ["tcp", "udp"]},
    "max": {"port_number": 6074, "protocols": ["tcp", "udp"]},
    "dpm-acm": {"port_number": 6075, "protocols": ["tcp"]},
    "msft-dpm-cert": {"port_number": 6076, "protocols": ["tcp"]},
    "iconstructsrv": {"port_number": 6077, "protocols": ["tcp"]},
    "gue": {"port_number": 6080, "protocols": ["udp"]},
    "geneve": {"port_number": 6081, "protocols": ["udp"]},
    "p25cai": {"port_number": 6082, "protocols": ["udp"]},
    "miami-bcast": {"port_number": 6083, "protocols": ["udp"]},
    "reload-config": {"port_number": 6084, "protocols": ["tcp"]},
    "konspire2b": {"port_number": 6085, "protocols": ["tcp", "udp"]},
    "pdtp": {"port_number": 6086, "protocols": ["tcp", "udp"]},
    "ldss": {"port_number": 6087, "protocols": ["tcp", "udp"]},
    "doglms": {"port_number": 6088, "protocols": ["tcp"]},
    "doglms-notify": {"port_number": 6088, "protocols": ["udp"]},
    "raxa-mgmt": {"port_number": 6099, "protocols": ["tcp"]},
    "synchronet-db": {"port_number": 6100, "protocols": ["tcp", "udp"]},
    "synchronet-rtc": {"port_number": 6101, "protocols": ["tcp", "udp"]},
    "synchronet-upd": {"port_number": 6102, "protocols": ["tcp", "udp"]},
    "rets": {"port_number": 6103, "protocols": ["tcp", "udp"]},
    "dbdb": {"port_number": 6104, "protocols": ["tcp", "udp"]},
    "primaserver": {"port_number": 6105, "protocols": ["tcp", "udp"]},
    "mpsserver": {"port_number": 6106, "protocols": ["tcp", "udp"]},
    "etc-control": {"port_number": 6107, "protocols": ["tcp", "udp"]},
    "sercomm-scadmin": {"port_number": 6108, "protocols": ["tcp", "udp"]},
    "globecast-id": {"port_number": 6109, "protocols": ["tcp", "udp"]},
    "softcm": {"port_number": 6110, "protocols": ["tcp", "udp"]},
    "spc": {"port_number": 6111, "protocols": ["tcp", "udp"]},
    "dtspcd": {"port_number": 6112, "protocols": ["tcp", "udp"]},
    "dayliteserver": {"port_number": 6113, "protocols": ["tcp"]},
    "wrspice": {"port_number": 6114, "protocols": ["tcp"]},
    "xic": {"port_number": 6115, "protocols": ["tcp"]},
    "xtlserv": {"port_number": 6116, "protocols": ["tcp"]},
    "daylitetouch": {"port_number": 6117, "protocols": ["tcp"]},
    "tipc": {"port_number": 6118, "protocols": ["udp"]},
    "spdy": {"port_number": 6121, "protocols": ["tcp"]},
    "bex-webadmin": {"port_number": 6122, "protocols": ["tcp", "udp"]},
    "backup-express": {"port_number": 6123, "protocols": ["tcp", "udp"]},
    "pnbs": {"port_number": 6124, "protocols": ["tcp", "udp"]},
    "damewaremobgtwy": {"port_number": 6130, "protocols": ["tcp"]},
    "nbt-wol": {"port_number": 6133, "protocols": ["tcp", "udp"]},
    "pulsonixnls": {"port_number": 6140, "protocols": ["tcp", "udp"]},
    "meta-corp": {"port_number": 6141, "protocols": ["tcp", "udp"]},
    "aspentec-lm": {"port_number": 6142, "protocols": ["tcp", "udp"]},
    "watershed-lm": {"port_number": 6143, "protocols": ["tcp", "udp"]},
    "statsci1-lm": {"port_number": 6144, "protocols": ["tcp", "udp"]},
    "statsci2-lm": {"port_number": 6145, "protocols": ["tcp", "udp"]},
    "lonewolf-lm": {"port_number": 6146, "protocols": ["tcp", "udp"]},
    "montage-lm": {"port_number": 6147, "protocols": ["tcp", "udp"]},
    "ricardo-lm-secondary": {"port_number": 6148, "protocols": ["tcp", "udp"]},
    "tal-pod": {"port_number": 6149, "protocols": ["tcp", "udp"]},
    "efb-aci": {"port_number": 6159, "protocols": ["tcp"]},
    "ecmp": {"port_number": 6160, "protocols": ["tcp"]},
    "ecmp-data": {"port_number": 6160, "protocols": ["udp"]},
    "patrol-ism": {"port_number": 6161, "protocols": ["tcp", "udp"]},
    "patrol-coll": {"port_number": 6162, "protocols": ["tcp", "udp"]},
    "pscribe": {"port_number": 6163, "protocols": ["tcp", "udp"]},
    "lm-x": {"port_number": 6200, "protocols": ["tcp", "udp"]},
    "thermo-calc": {"port_number": 6201, "protocols": ["udp"]},
    "qmtps": {"port_number": 6209, "protocols": ["tcp", "udp"]},
    "radmind": {"port_number": 6222, "protocols": ["tcp", "udp"]},
    "jeol-nsdtp-1": {"port_number": 6241, "protocols": ["tcp"]},
    "jeol-nsddp-1": {"port_number": 6241, "protocols": ["udp"]},
    "jeol-nsdtp-2": {"port_number": 6242, "protocols": ["tcp"]},
    "jeol-nsddp-2": {"port_number": 6242, "protocols": ["udp"]},
    "jeol-nsdtp-3": {"port_number": 6243, "protocols": ["tcp"]},
    "jeol-nsddp-3": {"port_number": 6243, "protocols": ["udp"]},
    "jeol-nsdtp-4": {"port_number": 6244, "protocols": ["tcp"]},
    "jeol-nsddp-4": {"port_number": 6244, "protocols": ["udp"]},
    "tl1-raw-ssl": {"port_number": 6251, "protocols": ["tcp", "udp"]},
    "tl1-ssh": {"port_number": 6252, "protocols": ["tcp", "udp"]},
    "crip": {"port_number": 6253, "protocols": ["tcp", "udp"]},
    "gld": {"port_number": 6267, "protocols": ["tcp"]},
    "grid": {"port_number": 6268, "protocols": ["tcp", "udp"]},
    "grid-alt": {"port_number": 6269, "protocols": ["tcp", "udp"]},
    "bmc-grx": {"port_number": 6300, "protocols": ["tcp", "udp"]},
    "bmc-ctd-ldap": {"port_number": 6301, "protocols": ["tcp", "udp"]},
    "bmc_ctd_ldap": {"port_number": 6301, "protocols": ["tcp", "udp"]},
    "ufmp": {"port_number": 6306, "protocols": ["tcp", "udp"]},
    "scup": {"port_number": 6315, "protocols": ["tcp"]},
    "scup-disc": {"port_number": 6315, "protocols": ["udp"]},
    "abb-escp": {"port_number": 6316, "protocols": ["tcp", "udp"]},
    "nav-data-cmd": {"port_number": 6317, "protocols": ["tcp"]},
    "nav-data": {"port_number": 6317, "protocols": ["udp"]},
    "iona-data": {"port_number": 6318, "protocols": ["tcp"]},
    "repsvc": {"port_number": 6320, "protocols": ["tcp", "udp"]},
    "emp-server1": {"port_number": 6321, "protocols": ["tcp", "udp"]},
    "emp-server2": {"port_number": 6322, "protocols": ["tcp", "udp"]},
    "hrd-ncs": {"port_number": 6324, "protocols": ["tcp"]},
    "hrd-ns-disc": {"port_number": 6324, "protocols": ["udp"]},
    "dt-mgmtsvc": {"port_number": 6325, "protocols": ["tcp"]},
    "dt-vra": {"port_number": 6326, "protocols": ["tcp"]},
    "sflow": {"port_number": 6343, "protocols": ["tcp", "udp"]},
    "streletz": {"port_number": 6344, "protocols": ["tcp"]},
    "gnutella-svc": {"port_number": 6346, "protocols": ["tcp", "udp"]},
    "gnutella-rtr": {"port_number": 6347, "protocols": ["tcp", "udp"]},
    "adap": {"port_number": 6350, "protocols": ["tcp", "udp"]},
    "pmcs": {"port_number": 6355, "protocols": ["tcp", "udp"]},
    "metaedit-mu": {"port_number": 6360, "protocols": ["tcp", "udp"]},
    "ndn": {"port_number": 6363, "protocols": ["udp"]},
    "metaedit-se": {"port_number": 6370, "protocols": ["tcp", "udp"]},
    "redis": {"port_number": 6379, "protocols": ["tcp"]},
    "metatude-mds": {"port_number": 6382, "protocols": ["tcp", "udp"]},
    "clariion-evr01": {"port_number": 6389, "protocols": ["tcp", "udp"]},
    "metaedit-ws": {"port_number": 6390, "protocols": ["tcp", "udp"]},
    "faxcomservice": {"port_number": 6417, "protocols": ["tcp", "udp"]},
    "syserverremote": {"port_number": 6418, "protocols": ["tcp"]},
    "svdrp": {"port_number": 6419, "protocols": ["tcp"]},
    "svdrp-disc": {"port_number": 6419, "protocols": ["udp"]},
    "nim-vdrshell": {"port_number": 6420, "protocols": ["tcp", "udp"]},
    "nim-wan": {"port_number": 6421, "protocols": ["tcp", "udp"]},
    "pgbouncer": {"port_number": 6432, "protocols": ["tcp"]},
    "heliosd": {"port_number": 6440, "protocols": ["tcp"]},
    "tarp": {"port_number": 6442, "protocols": ["tcp"]},
    "sun-sr-https": {"port_number": 6443, "protocols": ["tcp", "udp"]},
    "sge-qmaster": {"port_number": 6444, "protocols": ["tcp", "udp"]},
    "sge_qmaster": {"port_number": 6444, "protocols": ["tcp", "udp"]},
    "sge-execd": {"port_number": 6445, "protocols": ["tcp", "udp"]},
    "sge_execd": {"port_number": 6445, "protocols": ["tcp", "udp"]},
    "mysql-proxy": {"port_number": 6446, "protocols": ["tcp", "udp"]},
    "skip-cert-recv": {"port_number": 6455, "protocols": ["tcp", "udp"]},
    "skip-cert-send": {"port_number": 6456, "protocols": ["tcp", "udp"]},
    "ieee11073-20701": {"port_number": 6464, "protocols": ["tcp", "udp"]},
    "lvision-lm": {"port_number": 6471, "protocols": ["tcp", "udp"]},
    "sun-sr-http": {"port_number": 6480, "protocols": ["tcp", "udp"]},
    "servicetags": {"port_number": 6481, "protocols": ["tcp", "udp"]},
    "ldoms-mgmt": {"port_number": 6482, "protocols": ["tcp", "udp"]},
    "SunVTS-RMI": {"port_number": 6483, "protocols": ["tcp", "udp"]},
    "sun-sr-jms": {"port_number": 6484, "protocols": ["tcp", "udp"]},
    "sun-sr-iiop": {"port_number": 6485, "protocols": ["tcp", "udp"]},
    "sun-sr-iiops": {"port_number": 6486, "protocols": ["tcp", "udp"]},
    "sun-sr-iiop-aut": {"port_number": 6487, "protocols": ["tcp", "udp"]},
    "sun-sr-jmx": {"port_number": 6488, "protocols": ["tcp", "udp"]},
    "sun-sr-admin": {"port_number": 6489, "protocols": ["tcp", "udp"]},
    "boks": {"port_number": 6500, "protocols": ["tcp", "udp"]},
    "boks-servc": {"port_number": 6501, "protocols": ["tcp", "udp"]},
    "boks_servc": {"port_number": 6501, "protocols": ["tcp", "udp"]},
    "boks-servm": {"port_number": 6502, "protocols": ["tcp", "udp"]},
    "boks_servm": {"port_number": 6502, "protocols": ["tcp", "udp"]},
    "boks-clntd": {"port_number": 6503, "protocols": ["tcp", "udp"]},
    "boks_clntd": {"port_number": 6503, "protocols": ["tcp", "udp"]},
    "badm-priv": {"port_number": 6505, "protocols": ["tcp", "udp"]},
    "badm_priv": {"port_number": 6505, "protocols": ["tcp", "udp"]},
    "badm-pub": {"port_number": 6506, "protocols": ["tcp", "udp"]},
    "badm_pub": {"port_number": 6506, "protocols": ["tcp", "udp"]},
    "bdir-priv": {"port_number": 6507, "protocols": ["tcp", "udp"]},
    "bdir_priv": {"port_number": 6507, "protocols": ["tcp", "udp"]},
    "bdir-pub": {"port_number": 6508, "protocols": ["tcp", "udp"]},
    "bdir_pub": {"port_number": 6508, "protocols": ["tcp", "udp"]},
    "mgcs-mfp-port": {"port_number": 6509, "protocols": ["tcp", "udp"]},
    "mcer-port": {"port_number": 6510, "protocols": ["tcp", "udp"]},
    "dccp-udp": {"port_number": 6511, "protocols": ["udp"]},
    "netconf-tls": {"port_number": 6513, "protocols": ["tcp"]},
    "syslog-tls": {"port_number": 6514, "protocols": ["tcp", "udp", "dccp"]},
    "elipse-rec": {"port_number": 6515, "protocols": ["tcp", "udp"]},
    "lds-distrib": {"port_number": 6543, "protocols": ["tcp", "udp"]},
    "lds-dump": {"port_number": 6544, "protocols": ["tcp", "udp"]},
    "apc-6547": {"port_number": 6547, "protocols": ["tcp", "udp"]},
    "apc-6548": {"port_number": 6548, "protocols": ["tcp", "udp"]},
    "apc-6549": {"port_number": 6549, "protocols": ["tcp", "udp"]},
    "fg-sysupdate": {"port_number": 6550, "protocols": ["tcp", "udp"]},
    "sum": {"port_number": 6551, "protocols": ["tcp", "udp"]},
    "checkmk-agent": {"port_number": 6556, "protocols": ["tcp"]},
    "xdsxdm": {"port_number": 6558, "protocols": ["tcp", "udp"]},
    "sane-port": {"port_number": 6566, "protocols": ["tcp", "udp"]},
    "canit-store": {"port_number": 6568, "protocols": ["tcp"]},
    "canit_store": {"port_number": 6568, "protocols": ["tcp"]},
    "rp-reputation": {"port_number": 6568, "protocols": ["udp"]},
    "affiliate": {"port_number": 6579, "protocols": ["tcp", "udp"]},
    "parsec-master": {"port_number": 6580, "protocols": ["tcp", "udp"]},
    "parsec-peer": {"port_number": 6581, "protocols": ["tcp", "udp"]},
    "parsec-game": {"port_number": 6582, "protocols": ["tcp", "udp"]},
    "joaJewelSuite": {"port_number": 6583, "protocols": ["tcp", "udp"]},
    "mshvlm": {"port_number": 6600, "protocols": ["tcp"]},
    "mstmg-sstp": {"port_number": 6601, "protocols": ["tcp"]},
    "wsscomfrmwk": {"port_number": 6602, "protocols": ["tcp"]},
    "odette-ftps": {"port_number": 6619, "protocols": ["tcp", "udp"]},
    "kftp-data": {"port_number": 6620, "protocols": ["tcp", "udp"]},
    "kftp": {"port_number": 6621, "protocols": ["tcp", "udp"]},
    "mcftp": {"port_number": 6622, "protocols": ["tcp", "udp"]},
    "ktelnet": {"port_number": 6623, "protocols": ["tcp", "udp"]},
    "datascaler-db": {"port_number": 6624, "protocols": ["tcp"]},
    "datascaler-ctl": {"port_number": 6625, "protocols": ["tcp"]},
    "wago-service": {"port_number": 6626, "protocols": ["tcp", "udp"]},
    "nexgen": {"port_number": 6627, "protocols": ["tcp", "udp"]},
    "afesc-mc": {"port_number": 6628, "protocols": ["tcp", "udp"]},
    "nexgen-aux": {"port_number": 6629, "protocols": ["tcp", "udp"]},
    "mxodbc-connect": {"port_number": 6632, "protocols": ["tcp"]},
    "cisco-vpath-tun": {"port_number": 6633, "protocols": ["udp"]},
    "mpls-pm": {"port_number": 6634, "protocols": ["udp"]},
    "mpls-udp": {"port_number": 6635, "protocols": ["udp"]},
    "mpls-udp-dtls": {"port_number": 6636, "protocols": ["udp"]},
    "ovsdb": {"port_number": 6640, "protocols": ["tcp"]},
    "openflow": {"port_number": 6653, "protocols": ["tcp", "udp"]},
    "pcs-sf-ui-man": {"port_number": 6655, "protocols": ["tcp"]},
    "emgmsg": {"port_number": 6656, "protocols": ["tcp"]},
    "palcom-disc": {"port_number": 6657, "protocols": ["udp"]},
    "vocaltec-gold": {"port_number": 6670, "protocols": ["tcp", "udp"]},
    "p4p-portal": {"port_number": 6671, "protocols": ["tcp", "udp"]},
    "vision-server": {"port_number": 6672, "protocols": ["tcp", "udp"]},
    "vision_server": {"port_number": 6672, "protocols": ["tcp", "udp"]},
    "vision-elmd": {"port_number": 6673, "protocols": ["tcp", "udp"]},
    "vision_elmd": {"port_number": 6673, "protocols": ["tcp", "udp"]},
    "vfbp": {"port_number": 6678, "protocols": ["tcp"]},
    "vfbp-disc": {"port_number": 6678, "protocols": ["udp"]},
    "osaut": {"port_number": 6679, "protocols": ["tcp", "udp"]},
    "clever-ctrace": {"port_number": 6687, "protocols": ["tcp"]},
    "clever-tcpip": {"port_number": 6688, "protocols": ["tcp"]},
    "tsa": {"port_number": 6689, "protocols": ["tcp", "udp"]},
    "cleverdetect": {"port_number": 6690, "protocols": ["tcp"]},
    "babel": {"port_number": 6696, "protocols": ["udp"]},
    "ircs-u": {"port_number": 6697, "protocols": ["tcp"]},
    "babel-dtls": {"port_number": 6699, "protocols": ["udp"]},
    "kti-icad-srvr": {"port_number": 6701, "protocols": ["tcp", "udp"]},
    "e-design-net": {"port_number": 6702, "protocols": ["tcp", "udp"]},
    "e-design-web": {"port_number": 6703, "protocols": ["tcp", "udp"]},
    "frc-hp": {"port_number": 6704, "protocols": ["sctp"]},
    "frc-mp": {"port_number": 6705, "protocols": ["sctp"]},
    "frc-lp": {"port_number": 6706, "protocols": ["sctp"]},
    "ibprotocol": {"port_number": 6714, "protocols": ["tcp", "udp"]},
    "fibotrader-com": {"port_number": 6715, "protocols": ["tcp", "udp"]},
    "princity-agent": {"port_number": 6716, "protocols": ["tcp"]},
    "bmc-perf-agent": {"port_number": 6767, "protocols": ["tcp", "udp"]},
    "bmc-perf-mgrd": {"port_number": 6768, "protocols": ["tcp", "udp"]},
    "adi-gxp-srvprt": {"port_number": 6769, "protocols": ["tcp", "udp"]},
    "plysrv-http": {"port_number": 6770, "protocols": ["tcp", "udp"]},
    "plysrv-https": {"port_number": 6771, "protocols": ["tcp", "udp"]},
    "ntz-tracker": {"port_number": 6777, "protocols": ["tcp"]},
    "ntz-p2p-storage": {"port_number": 6778, "protocols": ["tcp"]},
    "bfd-lag": {"port_number": 6784, "protocols": ["udp"]},
    "dgpf-exchg": {"port_number": 6785, "protocols": ["tcp", "udp"]},
    "smc-jmx": {"port_number": 6786, "protocols": ["tcp", "udp"]},
    "smc-admin": {"port_number": 6787, "protocols": ["tcp", "udp"]},
    "smc-http": {"port_number": 6788, "protocols": ["tcp", "udp"]},
    "radg": {"port_number": 6789, "protocols": ["tcp"]},
    "hnmp": {"port_number": 6790, "protocols": ["tcp", "udp"]},
    "hnm": {"port_number": 6791, "protocols": ["tcp", "udp"]},
    "acnet": {"port_number": 6801, "protocols": ["tcp", "udp"]},
    "pentbox-sim": {"port_number": 6817, "protocols": ["tcp"]},
    "ambit-lm": {"port_number": 6831, "protocols": ["tcp", "udp"]},
    "netmo-default": {"port_number": 6841, "protocols": ["tcp", "udp"]},
    "netmo-http": {"port_number": 6842, "protocols": ["tcp", "udp"]},
    "iccrushmore": {"port_number": 6850, "protocols": ["tcp", "udp"]},
    "acctopus-cc": {"port_number": 6868, "protocols": ["tcp"]},
    "acctopus-st": {"port_number": 6868, "protocols": ["udp"]},
    "muse": {"port_number": 6888, "protocols": ["tcp", "udp"]},
    "rtimeviewer": {"port_number": 6900, "protocols": ["tcp"]},
    "jetstream": {"port_number": 6901, "protocols": ["tcp"]},
    "split-ping": {"port_number": 6924, "protocols": ["tcp", "udp"]},
    "ethoscan": {"port_number": 6935, "protocols": ["tcp", "udp"]},
    "xsmsvc": {"port_number": 6936, "protocols": ["tcp", "udp"]},
    "bioserver": {"port_number": 6946, "protocols": ["tcp", "udp"]},
    "otlp": {"port_number": 6951, "protocols": ["tcp", "udp"]},
    "jmact3": {"port_number": 6961, "protocols": ["tcp", "udp"]},
    "jmevt2": {"port_number": 6962, "protocols": ["tcp", "udp"]},
    "swismgr1": {"port_number": 6963, "protocols": ["tcp", "udp"]},
    "swismgr2": {"port_number": 6964, "protocols": ["tcp", "udp"]},
    "swistrap": {"port_number": 6965, "protocols": ["tcp", "udp"]},
    "swispol": {"port_number": 6966, "protocols": ["tcp", "udp"]},
    "acmsoda": {"port_number": 6969, "protocols": ["tcp", "udp"]},
    "conductor": {"port_number": 6970, "protocols": ["tcp"]},
    "conductor-mpx": {"port_number": 6970, "protocols": ["sctp"]},
    "qolyester": {"port_number": 6980, "protocols": ["udp"]},
    "MobilitySrv": {"port_number": 6997, "protocols": ["tcp", "udp"]},
    "iatp-highpri": {"port_number": 6998, "protocols": ["tcp", "udp"]},
    "iatp-normalpri": {"port_number": 6999, "protocols": ["tcp", "udp"]},
    "afs3-fileserver": {"port_number": 7000, "protocols": ["tcp", "udp"]},
    "afs3-callback": {"port_number": 7001, "protocols": ["tcp", "udp"]},
    "afs3-prserver": {"port_number": 7002, "protocols": ["tcp", "udp"]},
    "afs3-vlserver": {"port_number": 7003, "protocols": ["tcp", "udp"]},
    "afs3-kaserver": {"port_number": 7004, "protocols": ["tcp", "udp"]},
    "afs3-volser": {"port_number": 7005, "protocols": ["tcp", "udp"]},
    "afs3-errors": {"port_number": 7006, "protocols": ["tcp", "udp"]},
    "afs3-bos": {"port_number": 7007, "protocols": ["tcp", "udp"]},
    "afs3-update": {"port_number": 7008, "protocols": ["tcp", "udp"]},
    "afs3-rmtsys": {"port_number": 7009, "protocols": ["tcp", "udp"]},
    "ups-onlinet": {"port_number": 7010, "protocols": ["tcp", "udp"]},
    "talon-disc": {"port_number": 7011, "protocols": ["tcp", "udp"]},
    "talon-engine": {"port_number": 7012, "protocols": ["tcp", "udp"]},
    "microtalon-dis": {"port_number": 7013, "protocols": ["tcp", "udp"]},
    "microtalon-com": {"port_number": 7014, "protocols": ["tcp", "udp"]},
    "talon-webserver": {"port_number": 7015, "protocols": ["tcp", "udp"]},
    "spg": {"port_number": 7016, "protocols": ["tcp", "udp"]},
    "grasp": {"port_number": 7017, "protocols": ["tcp", "udp"]},
    "fisa-svc": {"port_number": 7018, "protocols": ["tcp"]},
    "doceri-ctl": {"port_number": 7019, "protocols": ["tcp"]},
    "doceri-view": {"port_number": 7019, "protocols": ["udp"]},
    "dpserve": {"port_number": 7020, "protocols": ["tcp", "udp"]},
    "dpserveadmin": {"port_number": 7021, "protocols": ["tcp", "udp"]},
    "ctdp": {"port_number": 7022, "protocols": ["tcp", "udp"]},
    "ct2nmcs": {"port_number": 7023, "protocols": ["tcp", "udp"]},
    "vmsvc": {"port_number": 7024, "protocols": ["tcp", "udp"]},
    "vmsvc-2": {"port_number": 7025, "protocols": ["tcp", "udp"]},
    "loreji-panel": {"port_number": 7026, "protocols": ["tcp"]},
    "op-probe": {"port_number": 7030, "protocols": ["tcp", "udp"]},
    "iposplanet": {"port_number": 7031, "protocols": ["tcp"]},
    "quest-disc": {"port_number": 7040, "protocols": ["udp"]},
    "arcp": {"port_number": 7070, "protocols": ["tcp", "udp"]},
    "iwg1": {"port_number": 7071, "protocols": ["tcp", "udp"]},
    "iba-cfg": {"port_number": 7072, "protocols": ["tcp"]},
    "iba-cfg-disc": {"port_number": 7072, "protocols": ["udp"]},
    "martalk": {"port_number": 7073, "protocols": ["tcp"]},
    "empowerid": {"port_number": 7080, "protocols": ["tcp", "udp"]},
    "zixi-transport": {"port_number": 7088, "protocols": ["udp"]},
    "jdp-disc": {"port_number": 7095, "protocols": ["udp"]},
    "lazy-ptop": {"port_number": 7099, "protocols": ["tcp", "udp"]},
    "font-service": {"port_number": 7100, "protocols": ["tcp", "udp"]},
    "elcn": {"port_number": 7101, "protocols": ["tcp", "udp"]},
    "aes-x170": {"port_number": 7107, "protocols": ["udp"]},
    "rothaga": {"port_number": 7117, "protocols": ["tcp"]},
    "virprot-lm": {"port_number": 7121, "protocols": ["tcp", "udp"]},
    "snif": {"port_number": 7123, "protocols": ["tcp"]},
    "scenidm": {"port_number": 7128, "protocols": ["tcp", "udp"]},
    "scenccs": {"port_number": 7129, "protocols": ["tcp", "udp"]},
    "cabsm-comm": {"port_number": 7161, "protocols": ["tcp", "udp"]},
    "caistoragemgr": {"port_number": 7162, "protocols": ["tcp", "udp"]},
    "cacsambroker": {"port_number": 7163, "protocols": ["tcp", "udp"]},
    "fsr": {"port_number": 7164, "protocols": ["tcp", "udp"]},
    "doc-server": {"port_number": 7165, "protocols": ["tcp", "udp"]},
    "aruba-server": {"port_number": 7166, "protocols": ["tcp", "udp"]},
    "casrmagent": {"port_number": 7167, "protocols": ["tcp"]},
    "cnckadserver": {"port_number": 7168, "protocols": ["tcp"]},
    "ccag-pib": {"port_number": 7169, "protocols": ["tcp", "udp"]},
    "nsrp": {"port_number": 7170, "protocols": ["tcp", "udp"]},
    "drm-production": {"port_number": 7171, "protocols": ["tcp", "udp"]},
    "metalbend": {"port_number": 7172, "protocols": ["tcp"]},
    "zsecure": {"port_number": 7173, "protocols": ["tcp"]},
    "clutild": {"port_number": 7174, "protocols": ["tcp", "udp"]},
    "janus-disc": {"port_number": 7181, "protocols": ["udp"]},
    "fodms": {"port_number": 7200, "protocols": ["tcp", "udp"]},
    "dlip": {"port_number": 7201, "protocols": ["tcp", "udp"]},
    "pon-ictp": {"port_number": 7202, "protocols": ["tcp"]},
    "PS-Server": {"port_number": 7215, "protocols": ["tcp"]},
    "PS-Capture-Pro": {"port_number": 7216, "protocols": ["tcp"]},
    "ramp": {"port_number": 7227, "protocols": ["tcp", "udp"]},
    "citrixupp": {"port_number": 7228, "protocols": ["tcp"]},
    "citrixuppg": {"port_number": 7229, "protocols": ["tcp"]},
    "asa-gateways": {"port_number": 7234, "protocols": ["tcp"]},
    "aspcoordination": {"port_number": 7235, "protocols": ["udp"]},
    "display": {"port_number": 7236, "protocols": ["tcp"]},
    "pads": {"port_number": 7237, "protocols": ["tcp"]},
    "frc-hicp": {"port_number": 7244, "protocols": ["tcp"]},
    "frc-hicp-disc": {"port_number": 7244, "protocols": ["udp"]},
    "cnap": {"port_number": 7262, "protocols": ["tcp", "udp"]},
    "watchme-7272": {"port_number": 7272, "protocols": ["tcp", "udp"]},
    "oma-rlp": {"port_number": 7273, "protocols": ["tcp", "udp"]},
    "oma-rlp-s": {"port_number": 7274, "protocols": ["tcp", "udp"]},
    "oma-ulp": {"port_number": 7275, "protocols": ["tcp", "udp"]},
    "oma-ilp": {"port_number": 7276, "protocols": ["tcp", "udp"]},
    "oma-ilp-s": {"port_number": 7277, "protocols": ["tcp", "udp"]},
    "oma-dcdocbs": {"port_number": 7278, "protocols": ["tcp", "udp"]},
    "ctxlic": {"port_number": 7279, "protocols": ["tcp", "udp"]},
    "itactionserver1": {"port_number": 7280, "protocols": ["tcp", "udp"]},
    "itactionserver2": {"port_number": 7281, "protocols": ["tcp", "udp"]},
    "mzca-action": {"port_number": 7282, "protocols": ["tcp"]},
    "mzca-alert": {"port_number": 7282, "protocols": ["udp"]},
    "genstat": {"port_number": 7283, "protocols": ["tcp"]},
    "lcm-server": {"port_number": 7365, "protocols": ["tcp", "udp"]},
    "mindfilesys": {"port_number": 7391, "protocols": ["tcp", "udp"]},
    "mrssrendezvous": {"port_number": 7392, "protocols": ["tcp", "udp"]},
    "nfoldman": {"port_number": 7393, "protocols": ["tcp", "udp"]},
    "fse": {"port_number": 7394, "protocols": ["tcp", "udp"]},
    "winqedit": {"port_number": 7395, "protocols": ["tcp", "udp"]},
    "hexarc": {"port_number": 7397, "protocols": ["tcp", "udp"]},
    "rtps-discovery": {"port_number": 7400, "protocols": ["tcp", "udp"]},
    "rtps-dd-ut": {"port_number": 7401, "protocols": ["tcp", "udp"]},
    "rtps-dd-mt": {"port_number": 7402, "protocols": ["tcp", "udp"]},
    "ionixnetmon": {"port_number": 7410, "protocols": ["tcp", "udp"]},
    "daqstream": {"port_number": 7411, "protocols": ["tcp", "udp"]},
    "ipluminary": {"port_number": 7420, "protocols": ["udp"]},
    "mtportmon": {"port_number": 7421, "protocols": ["tcp", "udp"]},
    "pmdmgr": {"port_number": 7426, "protocols": ["tcp", "udp"]},
    "oveadmgr": {"port_number": 7427, "protocols": ["tcp", "udp"]},
    "ovladmgr": {"port_number": 7428, "protocols": ["tcp", "udp"]},
    "opi-sock": {"port_number": 7429, "protocols": ["tcp", "udp"]},
    "xmpv7": {"port_number": 7430, "protocols": ["tcp", "udp"]},
    "pmd": {"port_number": 7431, "protocols": ["tcp", "udp"]},
    "faximum": {"port_number": 7437, "protocols": ["tcp", "udp"]},
    "oracleas-https": {"port_number": 7443, "protocols": ["tcp", "udp"]},
    "sttunnel": {"port_number": 7471, "protocols": ["tcp"]},
    "rise": {"port_number": 7473, "protocols": ["tcp", "udp"]},
    "neo4j": {"port_number": 7474, "protocols": ["tcp"]},
    "openit": {"port_number": 7478, "protocols": ["tcp"]},
    "telops-lmd": {"port_number": 7491, "protocols": ["tcp", "udp"]},
    "silhouette": {"port_number": 7500, "protocols": ["tcp", "udp"]},
    "ovbus": {"port_number": 7501, "protocols": ["tcp", "udp"]},
    "adcp": {"port_number": 7508, "protocols": ["tcp"]},
    "acplt": {"port_number": 7509, "protocols": ["tcp"]},
    "ovhpas": {"port_number": 7510, "protocols": ["tcp", "udp"]},
    "pafec-lm": {"port_number": 7511, "protocols": ["tcp", "udp"]},
    "saratoga": {"port_number": 7542, "protocols": ["tcp", "udp"]},
    "atul": {"port_number": 7543, "protocols": ["tcp", "udp"]},
    "nta-ds": {"port_number": 7544, "protocols": ["tcp", "udp"]},
    "nta-us": {"port_number": 7545, "protocols": ["tcp", "udp"]},
    "cfs": {"port_number": 7546, "protocols": ["tcp", "udp"]},
    "cwmp": {"port_number": 7547, "protocols": ["tcp", "udp"]},
    "tidp": {"port_number": 7548, "protocols": ["tcp", "udp"]},
    "nls-tl": {"port_number": 7549, "protocols": ["tcp", "udp"]},
    "cloudsignaling": {"port_number": 7550, "protocols": ["udp"]},
    "controlone-con": {"port_number": 7551, "protocols": ["tcp"]},
    "sncp": {"port_number": 7560, "protocols": ["tcp", "udp"]},
    "cfw": {"port_number": 7563, "protocols": ["tcp"]},
    "vsi-omega": {"port_number": 7566, "protocols": ["tcp", "udp"]},
    "dell-eql-asm": {"port_number": 7569, "protocols": ["tcp"]},
    "aries-kfinder": {"port_number": 7570, "protocols": ["tcp", "udp"]},
    "coherence": {"port_number": 7574, "protocols": ["tcp"]},
    "coherence-disc": {"port_number": 7574, "protocols": ["udp"]},
    "wtmi-panel": {"port_number": 7575, "protocols": ["tcp"]},
    "sun-lm": {"port_number": 7588, "protocols": ["tcp", "udp"]},
    "mipi-debug": {"port_number": 7606, "protocols": ["tcp", "udp"]},
    "indi": {"port_number": 7624, "protocols": ["tcp", "udp"]},
    "simco": {"port_number": 7626, "protocols": ["tcp", "sctp"]},
    "soap-http": {"port_number": 7627, "protocols": ["tcp", "udp"]},
    "zen-pawn": {"port_number": 7628, "protocols": ["tcp", "udp"]},
    "xdas": {"port_number": 7629, "protocols": ["tcp", "udp"]},
    "hawk": {"port_number": 7630, "protocols": ["tcp"]},
    "tesla-sys-msg": {"port_number": 7631, "protocols": ["tcp"]},
    "pmdfmgt": {"port_number": 7633, "protocols": ["tcp", "udp"]},
    "cuseeme": {"port_number": 7648, "protocols": ["tcp", "udp"]},
    "rome": {"port_number": 7663, "protocols": ["tcp", "udp"]},
    "authoritygate": {"port_number": 7668, "protocols": ["tcp"]},
    "imqstomp": {"port_number": 7672, "protocols": ["tcp"]},
    "imqstomps": {"port_number": 7673, "protocols": ["tcp"]},
    "imqtunnels": {"port_number": 7674, "protocols": ["tcp", "udp"]},
    "imqtunnel": {"port_number": 7675, "protocols": ["tcp", "udp"]},
    "imqbrokerd": {"port_number": 7676, "protocols": ["tcp", "udp"]},
    "sun-user-https": {"port_number": 7677, "protocols": ["tcp", "udp"]},
    "ms-do": {"port_number": 7680, "protocols": ["tcp", "udp"]},
    "dmt": {"port_number": 7683, "protocols": ["tcp"]},
    "bolt": {"port_number": 7687, "protocols": ["tcp"]},
    "collaber": {"port_number": 7689, "protocols": ["tcp", "udp"]},
    "sovd": {"port_number": 7690, "protocols": ["tcp"]},
    "klio": {"port_number": 7697, "protocols": ["tcp", "udp"]},
    "em7-secom": {"port_number": 7700, "protocols": ["tcp"]},
    "nfapi": {"port_number": 7701, "protocols": ["sctp"]},
    "sync-em7": {"port_number": 7707, "protocols": ["tcp", "udp"]},
    "scinet": {"port_number": 7708, "protocols": ["tcp", "udp"]},
    "medimageportal": {"port_number": 7720, "protocols": ["tcp", "udp"]},
    "nsdeepfreezectl": {"port_number": 7724, "protocols": ["tcp", "udp"]},
    "nitrogen": {"port_number": 7725, "protocols": ["tcp", "udp"]},
    "freezexservice": {"port_number": 7726, "protocols": ["tcp", "udp"]},
    "trident-data": {"port_number": 7727, "protocols": ["tcp", "udp"]},
    "osvr": {"port_number": 7728, "protocols": ["tcp", "udp", "sctp"]},
    "smip": {"port_number": 7734, "protocols": ["tcp", "udp"]},
    "aiagent": {"port_number": 7738, "protocols": ["tcp", "udp"]},
    "scriptview": {"port_number": 7741, "protocols": ["tcp", "udp"]},
    "msss": {"port_number": 7742, "protocols": ["tcp"]},
    "sstp-1": {"port_number": 7743, "protocols": ["tcp", "udp"]},
    "raqmon-pdu": {"port_number": 7744, "protocols": ["tcp", "udp"]},
    "prgp": {"port_number": 7747, "protocols": ["tcp", "udp"]},
    "inetfs": {"port_number": 7775, "protocols": ["tcp"]},
    "cbt": {"port_number": 7777, "protocols": ["tcp", "udp"]},
    "interwise": {"port_number": 7778, "protocols": ["tcp", "udp"]},
    "vstat": {"port_number": 7779, "protocols": ["tcp", "udp"]},
    "accu-lmgr": {"port_number": 7781, "protocols": ["tcp", "udp"]},
    "s-bfd": {"port_number": 7784, "protocols": ["udp"]},
    "minivend": {"port_number": 7786, "protocols": ["tcp", "udp"]},
    "popup-reminders": {"port_number": 7787, "protocols": ["tcp", "udp"]},
    "office-tools": {"port_number": 7789, "protocols": ["tcp", "udp"]},
    "q3ade": {"port_number": 7794, "protocols": ["tcp", "udp"]},
    "pnet-conn": {"port_number": 7797, "protocols": ["tcp", "udp"]},
    "pnet-enc": {"port_number": 7798, "protocols": ["tcp", "udp"]},
    "altbsdp": {"port_number": 7799, "protocols": ["tcp", "udp"]},
    "asr": {"port_number": 7800, "protocols": ["tcp", "udp"]},
    "ssp-client": {"port_number": 7801, "protocols": ["tcp", "udp"]},
    "vns-tp": {"port_number": 7802, "protocols": ["udp"]},
    "rbt-wanopt": {"port_number": 7810, "protocols": ["tcp", "udp"]},
    "apc-7845": {"port_number": 7845, "protocols": ["tcp", "udp"]},
    "apc-7846": {"port_number": 7846, "protocols": ["tcp", "udp"]},
    "csoauth": {"port_number": 7847, "protocols": ["tcp"]},
    "mobileanalyzer": {"port_number": 7869, "protocols": ["tcp"]},
    "rbt-smc": {"port_number": 7870, "protocols": ["tcp"]},
    "mdm": {"port_number": 7871, "protocols": ["tcp"]},
    "mipv6tls": {"port_number": 7872, "protocols": ["udp"]},
    "owms": {"port_number": 7878, "protocols": ["tcp"]},
    "pss": {"port_number": 7880, "protocols": ["tcp", "udp"]},
    "ubroker": {"port_number": 7887, "protocols": ["tcp", "udp"]},
    "mevent": {"port_number": 7900, "protocols": ["tcp", "udp"]},
    "tnos-sp": {"port_number": 7901, "protocols": ["tcp", "udp"]},
    "tnos-dp": {"port_number": 7902, "protocols": ["tcp", "udp"]},
    "tnos-dps": {"port_number": 7903, "protocols": ["tcp", "udp"]},
    "qo-secure": {"port_number": 7913, "protocols": ["tcp", "udp"]},
    "t2-drm": {"port_number": 7932, "protocols": ["tcp", "udp"]},
    "t2-brm": {"port_number": 7933, "protocols": ["tcp", "udp"]},
    "generalsync": {"port_number": 7962, "protocols": ["tcp", "udp"]},
    "supercell": {"port_number": 7967, "protocols": ["tcp", "udp"]},
    "micromuse-ncps": {"port_number": 7979, "protocols": ["tcp", "udp"]},
    "quest-vista": {"port_number": 7980, "protocols": ["tcp", "udp"]},
    "sossd-collect": {"port_number": 7981, "protocols": ["tcp"]},
    "sossd-agent": {"port_number": 7982, "protocols": ["tcp"]},
    "sossd-disc": {"port_number": 7982, "protocols": ["udp"]},
    "pushns": {"port_number": 7997, "protocols": ["tcp"]},
    "usicontentpush": {"port_number": 7998, "protocols": ["udp"]},
    "irdmi2": {"port_number": 7999, "protocols": ["tcp", "udp"]},
    "irdmi": {"port_number": 8000, "protocols": ["tcp", "udp"]},
    "vcom-tunnel": {"port_number": 8001, "protocols": ["tcp", "udp"]},
    "teradataordbms": {"port_number": 8002, "protocols": ["tcp", "udp"]},
    "mcreport": {"port_number": 8003, "protocols": ["tcp", "udp"]},
    "p2pevolvenet": {"port_number": 8004, "protocols": ["tcp"]},
    "mxi": {"port_number": 8005, "protocols": ["tcp", "udp"]},
    "wpl-analytics": {"port_number": 8006, "protocols": ["tcp"]},
    "wpl-disc": {"port_number": 8006, "protocols": ["udp"]},
    "warppipe": {"port_number": 8007, "protocols": ["tcp", "udp"]},
    "http-alt-secondary": {"port_number": 8008, "protocols": ["tcp", "udp", "tcp", "udp"]},
    "nvme-disc": {"port_number": 8009, "protocols": ["tcp"]},
    "cfg-cloud": {"port_number": 8015, "protocols": ["tcp"]},
    "ads-s": {"port_number": 8016, "protocols": ["tcp"]},
    "cisco-cloudsec": {"port_number": 8017, "protocols": ["udp"]},
    "qbdb": {"port_number": 8019, "protocols": ["tcp", "udp"]},
    "intu-ec-svcdisc": {"port_number": 8020, "protocols": ["tcp", "udp"]},
    "intu-ec-client": {"port_number": 8021, "protocols": ["tcp", "udp"]},
    "oa-system": {"port_number": 8022, "protocols": ["tcp", "udp"]},
    "arca-api": {"port_number": 8023, "protocols": ["tcp", "udp"]},
    "ca-audit-da": {"port_number": 8025, "protocols": ["tcp", "udp"]},
    "ca-audit-ds": {"port_number": 8026, "protocols": ["tcp", "udp"]},
    "papachi-p2p-srv": {"port_number": 8027, "protocols": ["tcp", "udp"]},
    "pro-ed": {"port_number": 8032, "protocols": ["tcp", "udp"]},
    "mindprint": {"port_number": 8033, "protocols": ["tcp", "udp"]},
    "vantronix-mgmt": {"port_number": 8034, "protocols": ["tcp", "udp"]},
    "ampify": {"port_number": 8040, "protocols": ["tcp", "udp"]},
    "enguity-xccetp": {"port_number": 8041, "protocols": ["tcp", "udp"]},
    "fs-agent": {"port_number": 8042, "protocols": ["tcp"]},
    "fs-server": {"port_number": 8043, "protocols": ["tcp"]},
    "fs-mgmt": {"port_number": 8044, "protocols": ["tcp"]},
    "rocrail": {"port_number": 8051, "protocols": ["tcp"]},
    "senomix01": {"port_number": 8052, "protocols": ["tcp", "udp"]},
    "senomix02": {"port_number": 8053, "protocols": ["tcp", "udp"]},
    "senomix03": {"port_number": 8054, "protocols": ["tcp", "udp"]},
    "senomix04": {"port_number": 8055, "protocols": ["tcp", "udp"]},
    "senomix05": {"port_number": 8056, "protocols": ["tcp", "udp"]},
    "senomix06": {"port_number": 8057, "protocols": ["tcp", "udp"]},
    "senomix07": {"port_number": 8058, "protocols": ["tcp", "udp"]},
    "senomix08": {"port_number": 8059, "protocols": ["tcp", "udp"]},
    "aero": {"port_number": 8060, "protocols": ["udp"]},
    "nikatron-dev": {"port_number": 8061, "protocols": ["tcp"]},
    "toad-bi-appsrvr": {"port_number": 8066, "protocols": ["tcp"]},
    "infi-async": {"port_number": 8067, "protocols": ["tcp"]},
    "ucs-isc": {"port_number": 8070, "protocols": ["tcp"]},
    "gadugadu": {"port_number": 8074, "protocols": ["tcp", "udp"]},
    "sunproxyadmin": {"port_number": 8081, "protocols": ["tcp", "udp"]},
    "us-cli": {"port_number": 8082, "protocols": ["tcp", "udp"]},
    "us-srv": {"port_number": 8083, "protocols": ["tcp", "udp"]},
    "websnp": {"port_number": 8084, "protocols": ["tcp"]},
    "d-s-n": {"port_number": 8086, "protocols": ["tcp", "udp"]},
    "simplifymedia": {"port_number": 8087, "protocols": ["tcp", "udp"]},
    "radan-http": {"port_number": 8088, "protocols": ["tcp", "udp"]},
    "opsmessaging": {"port_number": 8090, "protocols": ["tcp"]},
    "jamlink": {"port_number": 8091, "protocols": ["tcp"]},
    "sac": {"port_number": 8097, "protocols": ["tcp", "udp"]},
    "xprint-server": {"port_number": 8100, "protocols": ["tcp", "udp"]},
    "ldoms-migr": {"port_number": 8101, "protocols": ["tcp"]},
    "kz-migr": {"port_number": 8102, "protocols": ["tcp"]},
    "skynetflow": {"port_number": 8111, "protocols": ["udp"]},
    "mtl8000-matrix": {"port_number": 8115, "protocols": ["tcp", "udp"]},
    "cp-cluster": {"port_number": 8116, "protocols": ["tcp", "udp"]},
    "purityrpc": {"port_number": 8117, "protocols": ["tcp"]},
    "privoxy": {"port_number": 8118, "protocols": ["tcp", "udp"]},
    "apollo-data": {"port_number": 8121, "protocols": ["tcp", "udp"]},
    "apollo-admin": {"port_number": 8122, "protocols": ["tcp", "udp"]},
    "paycash-online": {"port_number": 8128, "protocols": ["tcp", "udp"]},
    "paycash-wbp": {"port_number": 8129, "protocols": ["tcp", "udp"]},
    "indigo-vrmi": {"port_number": 8130, "protocols": ["tcp", "udp"]},
    "indigo-vbcp": {"port_number": 8131, "protocols": ["tcp", "udp"]},
    "dbabble": {"port_number": 8132, "protocols": ["tcp", "udp"]},
    "puppet": {"port_number": 8140, "protocols": ["tcp"]},
    "isdd": {"port_number": 8148, "protocols": ["tcp", "udp"]},
    "eor-game": {"port_number": 8149, "protocols": ["udp"]},
    "quantastor": {"port_number": 8153, "protocols": ["tcp"]},
    "patrol": {"port_number": 8160, "protocols": ["tcp", "udp"]},
    "patrol-snmp": {"port_number": 8161, "protocols": ["tcp", "udp"]},
    "lpar2rrd": {"port_number": 8162, "protocols": ["tcp"]},
    "intermapper": {"port_number": 8181, "protocols": ["tcp"]},
    "vmware-fdm": {"port_number": 8182, "protocols": ["tcp", "udp"]},
    "proremote": {"port_number": 8183, "protocols": ["tcp"]},
    "itach": {"port_number": 8184, "protocols": ["tcp", "udp"]},
    "gcp-rphy": {"port_number": 8190, "protocols": ["tcp"]},
    "limnerpressure": {"port_number": 8191, "protocols": ["tcp"]},
    "spytechphone": {"port_number": 8192, "protocols": ["tcp", "udp"]},
    "blp1": {"port_number": 8194, "protocols": ["tcp", "udp"]},
    "blp2": {"port_number": 8195, "protocols": ["tcp", "udp"]},
    "vvr-data": {"port_number": 8199, "protocols": ["tcp", "udp"]},
    "trivnet1": {"port_number": 8200, "protocols": ["tcp", "udp"]},
    "trivnet2": {"port_number": 8201, "protocols": ["tcp", "udp"]},
    "aesop": {"port_number": 8202, "protocols": ["udp"]},
    "lm-perfworks": {"port_number": 8204, "protocols": ["tcp", "udp"]},
    "lm-instmgr": {"port_number": 8205, "protocols": ["tcp", "udp"]},
    "lm-dta": {"port_number": 8206, "protocols": ["tcp", "udp"]},
    "lm-sserver": {"port_number": 8207, "protocols": ["tcp", "udp"]},
    "lm-webwatcher": {"port_number": 8208, "protocols": ["tcp", "udp"]},
    "aruba-papi": {"port_number": 8211, "protocols": ["udp"]},
    "rexecj": {"port_number": 8230, "protocols": ["tcp", "udp"]},
    "hncp-udp-port": {"port_number": 8231, "protocols": ["udp"]},
    "hncp-dtls-port": {"port_number": 8232, "protocols": ["udp"]},
    "synapse-nhttps": {"port_number": 8243, "protocols": ["tcp", "udp"]},
    "espeasy-p2p": {"port_number": 8266, "protocols": ["udp"]},
    "robot-remote": {"port_number": 8270, "protocols": ["tcp"]},
    "ms-mcc": {"port_number": 8276, "protocols": ["tcp", "udp"]},
    "synapse-nhttp": {"port_number": 8280, "protocols": ["tcp", "udp"]},
    "libelle": {"port_number": 8282, "protocols": ["tcp"]},
    "libelle-disc": {"port_number": 8282, "protocols": ["udp"]},
    "blp3": {"port_number": 8292, "protocols": ["tcp", "udp"]},
    "hiperscan-id": {"port_number": 8293, "protocols": ["tcp"]},
    "blp4": {"port_number": 8294, "protocols": ["tcp", "udp"]},
    "tmi": {"port_number": 8300, "protocols": ["tcp", "udp"]},
    "amberon": {"port_number": 8301, "protocols": ["tcp", "udp"]},
    "hub-open-net": {"port_number": 8313, "protocols": ["tcp"]},
    "tnp-discover": {"port_number": 8320, "protocols": ["tcp", "udp"]},
    "tnp": {"port_number": 8321, "protocols": ["tcp", "udp"]},
    "garmin-marine": {"port_number": 8322, "protocols": ["tcp", "udp"]},
    "server-find": {"port_number": 8351, "protocols": ["tcp", "udp"]},
    "cruise-enum": {"port_number": 8376, "protocols": ["tcp", "udp"]},
    "cruise-swroute": {"port_number": 8377, "protocols": ["tcp", "udp"]},
    "cruise-config": {"port_number": 8378, "protocols": ["tcp", "udp"]},
    "cruise-diags": {"port_number": 8379, "protocols": ["tcp", "udp"]},
    "cruise-update": {"port_number": 8380, "protocols": ["tcp", "udp"]},
    "m2mservices": {"port_number": 8383, "protocols": ["tcp", "udp"]},
    "marathontp": {"port_number": 8384, "protocols": ["udp"]},
    "cvd": {"port_number": 8400, "protocols": ["tcp", "udp"]},
    "sabarsd": {"port_number": 8401, "protocols": ["tcp", "udp"]},
    "abarsd": {"port_number": 8402, "protocols": ["tcp", "udp"]},
    "admind-secondary": {"port_number": 8403, "protocols": ["tcp", "udp"]},
    "svcloud": {"port_number": 8404, "protocols": ["tcp"]},
    "svbackup": {"port_number": 8405, "protocols": ["tcp"]},
    "dlpx-sp": {"port_number": 8415, "protocols": ["tcp"]},
    "espeech": {"port_number": 8416, "protocols": ["tcp", "udp"]},
    "espeech-rtp": {"port_number": 8417, "protocols": ["tcp", "udp"]},
    "aritts": {"port_number": 8423, "protocols": ["tcp"]},
    "pgbackrest": {"port_number": 8432, "protocols": ["tcp"]},
    "aws-as2": {"port_number": 8433, "protocols": ["udp"]},
    "cybro-a-bus": {"port_number": 8442, "protocols": ["tcp", "udp"]},
    "pcsync-https": {"port_number": 8443, "protocols": ["tcp", "udp"]},
    "pcsync-http": {"port_number": 8444, "protocols": ["tcp", "udp"]},
    "copy": {"port_number": 8445, "protocols": ["tcp"]},
    "copy-disc": {"port_number": 8445, "protocols": ["udp"]},
    "matrix-fed": {"port_number": 8448, "protocols": ["tcp"]},
    "npmp": {"port_number": 8450, "protocols": ["tcp", "udp"]},
    "nexentamv": {"port_number": 8457, "protocols": ["tcp"]},
    "cisco-avp": {"port_number": 8470, "protocols": ["tcp"]},
    "pim-port": {"port_number": 8471, "protocols": ["tcp", "sctp"]},
    "otv": {"port_number": 8472, "protocols": ["tcp", "udp"]},
    "vp2p": {"port_number": 8473, "protocols": ["tcp", "udp"]},
    "noteshare": {"port_number": 8474, "protocols": ["tcp", "udp"]},
    "fmtp": {"port_number": 8500, "protocols": ["tcp", "udp"]},
    "cmtp-mgt": {"port_number": 8501, "protocols": ["tcp"]},
    "cmtp-av": {"port_number": 8501, "protocols": ["udp"]},
    "ftnmtp": {"port_number": 8502, "protocols": ["tcp"]},
    "lsp-self-ping": {"port_number": 8503, "protocols": ["udp"]},
    "rtsp-alt": {"port_number": 8554, "protocols": ["tcp", "udp"]},
    "d-fence": {"port_number": 8555, "protocols": ["tcp", "udp"]},
    "dof-tunnel": {"port_number": 8567, "protocols": ["tcp", "udp"]},
    "asterix": {"port_number": 8600, "protocols": ["tcp", "udp"]},
    "canon-cpp-disc": {"port_number": 8609, "protocols": ["udp"]},
    "canon-mfnp": {"port_number": 8610, "protocols": ["tcp", "udp"]},
    "canon-bjnp1": {"port_number": 8611, "protocols": ["tcp", "udp"]},
    "canon-bjnp2": {"port_number": 8612, "protocols": ["tcp", "udp"]},
    "canon-bjnp3": {"port_number": 8613, "protocols": ["tcp", "udp"]},
    "canon-bjnp4": {"port_number": 8614, "protocols": ["tcp", "udp"]},
    "imink": {"port_number": 8615, "protocols": ["tcp"]},
    "monetra": {"port_number": 8665, "protocols": ["tcp"]},
    "monetra-admin": {"port_number": 8666, "protocols": ["tcp"]},
    "spartan": {"port_number": 8668, "protocols": ["tcp"]},
    "msi-cps-rm": {"port_number": 8675, "protocols": ["tcp"]},
    "msi-cps-rm-disc": {"port_number": 8675, "protocols": ["udp"]},
    "sun-as-jmxrmi": {"port_number": 8686, "protocols": ["tcp", "udp"]},
    "openremote-ctrl": {"port_number": 8688, "protocols": ["tcp"]},
    "vnyx": {"port_number": 8699, "protocols": ["tcp"]},
    "semi-grpc": {"port_number": 8710, "protocols": ["tcp"]},
    "nvc": {"port_number": 8711, "protocols": ["tcp"]},
    "dtp-net": {"port_number": 8732, "protocols": ["udp"]},
    "ibus": {"port_number": 8733, "protocols": ["tcp", "udp"]},
    "dey-keyneg": {"port_number": 8750, "protocols": ["tcp"]},
    "mc-appserver": {"port_number": 8763, "protocols": ["tcp", "udp"]},
    "openqueue": {"port_number": 8764, "protocols": ["tcp", "udp"]},
    "ultraseek-http": {"port_number": 8765, "protocols": ["tcp", "udp"]},
    "amcs": {"port_number": 8766, "protocols": ["tcp", "udp"]},
    "core-of-source": {"port_number": 8767, "protocols": ["tcp"]},
    "sandpolis": {"port_number": 8768, "protocols": ["tcp"]},
    "oktaauthenticat": {"port_number": 8769, "protocols": ["tcp"]},
    "dpap": {"port_number": 8770, "protocols": ["tcp", "udp"]},
    "uec": {"port_number": 8778, "protocols": ["tcp"]},
    "msgclnt": {"port_number": 8786, "protocols": ["tcp", "udp"]},
    "msgsrvr": {"port_number": 8787, "protocols": ["tcp", "udp"]},
    "acd-pm": {"port_number": 8793, "protocols": ["tcp", "udp"]},
    "sunwebadmin": {"port_number": 8800, "protocols": ["tcp", "udp"]},
    "truecm": {"port_number": 8804, "protocols": ["tcp", "udp"]},
    "pfcp": {"port_number": 8805, "protocols": ["udp"]},
    "hes-clip": {"port_number": 8807, "protocols": ["udp"]},
    "ssports-bcast": {"port_number": 8808, "protocols": ["udp"]},
    "3gpp-monp": {"port_number": 8809, "protocols": ["udp"]},
    "dxspider": {"port_number": 8873, "protocols": ["tcp", "udp"]},
    "cddbp-alt": {"port_number": 8880, "protocols": ["tcp", "udp"]},
    "galaxy4d": {"port_number": 8881, "protocols": ["tcp"]},
    "secure-mqtt": {"port_number": 8883, "protocols": ["tcp", "udp"]},
    "ddi-tcp-1": {"port_number": 8888, "protocols": ["tcp"]},
    "ddi-udp-1": {"port_number": 8888, "protocols": ["udp"]},
    "ddi-tcp-2": {"port_number": 8889, "protocols": ["tcp"]},
    "ddi-udp-2": {"port_number": 8889, "protocols": ["udp"]},
    "ddi-tcp-3": {"port_number": 8890, "protocols": ["tcp"]},
    "ddi-udp-3": {"port_number": 8890, "protocols": ["udp"]},
    "ddi-tcp-4": {"port_number": 8891, "protocols": ["tcp"]},
    "ddi-udp-4": {"port_number": 8891, "protocols": ["udp"]},
    "ddi-tcp-5": {"port_number": 8892, "protocols": ["tcp"]},
    "ddi-udp-5": {"port_number": 8892, "protocols": ["udp"]},
    "ddi-tcp-6": {"port_number": 8893, "protocols": ["tcp"]},
    "ddi-udp-6": {"port_number": 8893, "protocols": ["udp"]},
    "ddi-tcp-7": {"port_number": 8894, "protocols": ["tcp"]},
    "ddi-udp-7": {"port_number": 8894, "protocols": ["udp"]},
    "ospf-lite": {"port_number": 8899, "protocols": ["tcp", "udp"]},
    "jmb-cds1": {"port_number": 8900, "protocols": ["tcp", "udp"]},
    "jmb-cds2": {"port_number": 8901, "protocols": ["tcp", "udp"]},
    "dpp": {"port_number": 8908, "protocols": ["tcp"]},
    "manyone-http": {"port_number": 8910, "protocols": ["tcp", "udp"]},
    "manyone-xml": {"port_number": 8911, "protocols": ["tcp", "udp"]},
    "wcbackup": {"port_number": 8912, "protocols": ["tcp", "udp"]},
    "dragonfly": {"port_number": 8913, "protocols": ["tcp", "udp"]},
    "twds": {"port_number": 8937, "protocols": ["tcp"]},
    "ub-dns-control": {"port_number": 8953, "protocols": ["tcp"]},
    "cumulus-admin": {"port_number": 8954, "protocols": ["tcp", "udp"]},
    "nod-provider": {"port_number": 8980, "protocols": ["tcp", "udp"]},
    "nod-client": {"port_number": 8981, "protocols": ["udp"]},
    "sunwebadmins": {"port_number": 8989, "protocols": ["tcp", "udp"]},
    "http-wmap": {"port_number": 8990, "protocols": ["tcp", "udp"]},
    "https-wmap": {"port_number": 8991, "protocols": ["tcp", "udp"]},
    "oracle-ms-ens": {"port_number": 8997, "protocols": ["tcp"]},
    "canto-roboflow": {"port_number": 8998, "protocols": ["tcp"]},
    "bctp": {"port_number": 8999, "protocols": ["tcp", "udp"]},
    "cslistener": {"port_number": 9000, "protocols": ["tcp", "udp"]},
    "etlservicemgr": {"port_number": 9001, "protocols": ["tcp", "udp"]},
    "dynamid": {"port_number": 9002, "protocols": ["tcp", "udp"]},
    "golem": {"port_number": 9005, "protocols": ["tcp"]},
    "ogs-client": {"port_number": 9007, "protocols": ["udp"]},
    "ogs-server": {"port_number": 9008, "protocols": ["tcp"]},
    "pichat": {"port_number": 9009, "protocols": ["tcp", "udp"]},
    "sdr": {"port_number": 9010, "protocols": ["tcp"]},
    "d-star": {"port_number": 9011, "protocols": ["udp"]},
    "tambora": {"port_number": 9020, "protocols": ["tcp", "udp"]},
    "panagolin-ident": {"port_number": 9021, "protocols": ["tcp", "udp"]},
    "paragent": {"port_number": 9022, "protocols": ["tcp", "udp"]},
    "swa-1": {"port_number": 9023, "protocols": ["tcp", "udp"]},
    "swa-2": {"port_number": 9024, "protocols": ["tcp", "udp"]},
    "swa-3": {"port_number": 9025, "protocols": ["tcp", "udp"]},
    "swa-4": {"port_number": 9026, "protocols": ["tcp", "udp"]},
    "versiera": {"port_number": 9050, "protocols": ["tcp"]},
    "fio-cmgmt": {"port_number": 9051, "protocols": ["tcp"]},
    "CardWeb-IO": {"port_number": 9060, "protocols": ["tcp"]},
    "CardWeb-RT": {"port_number": 9060, "protocols": ["udp"]},
    "glrpc": {"port_number": 9080, "protocols": ["tcp", "udp"]},
    "cisco-aqos": {"port_number": 9081, "protocols": ["udp"]},
    "lcs-ap": {"port_number": 9082, "protocols": ["sctp"]},
    "emc-pp-mgmtsvc": {"port_number": 9083, "protocols": ["tcp"]},
    "aurora": {"port_number": 9084, "protocols": ["tcp", "udp", "sctp"]},
    "ibm-rsyscon": {"port_number": 9085, "protocols": ["tcp", "udp"]},
    "net2display": {"port_number": 9086, "protocols": ["tcp", "udp"]},
    "classic": {"port_number": 9087, "protocols": ["tcp", "udp"]},
    "sqlexec": {"port_number": 9088, "protocols": ["tcp", "udp"]},
    "sqlexec-ssl": {"port_number": 9089, "protocols": ["tcp", "udp"]},
    "websm": {"port_number": 9090, "protocols": ["tcp", "udp"]},
    "xmltec-xmlmail": {"port_number": 9091, "protocols": ["tcp", "udp"]},
    "XmlIpcRegSvc": {"port_number": 9092, "protocols": ["tcp", "udp"]},
    "copycat": {"port_number": 9093, "protocols": ["tcp"]},
    "hp-pdl-datastr": {"port_number": 9100, "protocols": ["tcp", "udp"]},
    "pdl-datastream": {"port_number": 9100, "protocols": ["tcp", "udp"]},
    "bacula-dir": {"port_number": 9101, "protocols": ["tcp", "udp"]},
    "bacula-fd": {"port_number": 9102, "protocols": ["tcp", "udp"]},
    "bacula-sd": {"port_number": 9103, "protocols": ["tcp", "udp"]},
    "peerwire": {"port_number": 9104, "protocols": ["tcp", "udp"]},
    "xadmin": {"port_number": 9105, "protocols": ["tcp", "udp"]},
    "astergate": {"port_number": 9106, "protocols": ["tcp"]},
    "astergate-disc": {"port_number": 9106, "protocols": ["udp"]},
    "astergatefax": {"port_number": 9107, "protocols": ["tcp"]},
    "hexxorecore": {"port_number": 9111, "protocols": ["tcp", "udp"]},
    "mxit": {"port_number": 9119, "protocols": ["tcp", "udp"]},
    "grcmp": {"port_number": 9122, "protocols": ["tcp"]},
    "grcp": {"port_number": 9123, "protocols": ["tcp"]},
    "dddp": {"port_number": 9131, "protocols": ["tcp", "udp"]},
    "apani1": {"port_number": 9160, "protocols": ["tcp", "udp"]},
    "apani2": {"port_number": 9161, "protocols": ["tcp", "udp"]},
    "apani3": {"port_number": 9162, "protocols": ["tcp", "udp"]},
    "apani4": {"port_number": 9163, "protocols": ["tcp", "udp"]},
    "apani5": {"port_number": 9164, "protocols": ["tcp", "udp"]},
    "sun-as-jpda": {"port_number": 9191, "protocols": ["tcp", "udp"]},
    "wap-wsp": {"port_number": 9200, "protocols": ["tcp", "udp"]},
    "wap-wsp-wtp": {"port_number": 9201, "protocols": ["tcp", "udp"]},
    "wap-wsp-s": {"port_number": 9202, "protocols": ["tcp", "udp"]},
    "wap-wsp-wtp-s": {"port_number": 9203, "protocols": ["tcp", "udp"]},
    "wap-vcard": {"port_number": 9204, "protocols": ["tcp", "udp"]},
    "wap-vcal": {"port_number": 9205, "protocols": ["tcp", "udp"]},
    "wap-vcard-s": {"port_number": 9206, "protocols": ["tcp", "udp"]},
    "wap-vcal-s": {"port_number": 9207, "protocols": ["tcp", "udp"]},
    "rjcdb-vcards": {"port_number": 9208, "protocols": ["tcp", "udp"]},
    "almobile-system": {"port_number": 9209, "protocols": ["tcp", "udp"]},
    "oma-mlp": {"port_number": 9210, "protocols": ["tcp", "udp"]},
    "oma-mlp-s": {"port_number": 9211, "protocols": ["tcp", "udp"]},
    "serverviewdbms": {"port_number": 9212, "protocols": ["tcp", "udp"]},
    "serverstart": {"port_number": 9213, "protocols": ["tcp", "udp"]},
    "ipdcesgbs": {"port_number": 9214, "protocols": ["tcp", "udp"]},
    "insis": {"port_number": 9215, "protocols": ["tcp", "udp"]},
    "acme": {"port_number": 9216, "protocols": ["tcp", "udp"]},
    "fsc-port": {"port_number": 9217, "protocols": ["tcp", "udp"]},
    "teamcoherence": {"port_number": 9222, "protocols": ["tcp", "udp"]},
    "mon-secondary": {"port_number": 9255, "protocols": ["tcp", "udp"]},
    "traingpsdata": {"port_number": 9277, "protocols": ["udp"]},
    "pegasus": {"port_number": 9278, "protocols": ["tcp", "udp"]},
    "pegasus-ctl": {"port_number": 9279, "protocols": ["tcp", "udp"]},
    "pgps": {"port_number": 9280, "protocols": ["tcp", "udp"]},
    "swtp-port1": {"port_number": 9281, "protocols": ["tcp", "udp"]},
    "swtp-port2": {"port_number": 9282, "protocols": ["tcp", "udp"]},
    "callwaveiam": {"port_number": 9283, "protocols": ["tcp", "udp"]},
    "visd": {"port_number": 9284, "protocols": ["tcp", "udp"]},
    "n2h2server": {"port_number": 9285, "protocols": ["tcp", "udp"]},
    "n2receive": {"port_number": 9286, "protocols": ["udp"]},
    "cumulus": {"port_number": 9287, "protocols": ["tcp", "udp"]},
    "armtechdaemon": {"port_number": 9292, "protocols": ["tcp", "udp"]},
    "storview": {"port_number": 9293, "protocols": ["tcp", "udp"]},
    "armcenterhttp": {"port_number": 9294, "protocols": ["tcp", "udp"]},
    "armcenterhttps": {"port_number": 9295, "protocols": ["tcp", "udp"]},
    "vrace": {"port_number": 9300, "protocols": ["tcp", "udp"]},
    "sphinxql": {"port_number": 9306, "protocols": ["tcp"]},
    "sapms": {"port_number": 9310, "protocols": ["tcp"]},
    "sphinxapi": {"port_number": 9312, "protocols": ["tcp"]},
    "secure-ts": {"port_number": 9318, "protocols": ["tcp", "udp"]},
    "guibase": {"port_number": 9321, "protocols": ["tcp", "udp"]},
    "gnmi-gnoi": {"port_number": 9339, "protocols": ["tcp"]},
    "gribi": {"port_number": 9340, "protocols": ["tcp"]},
    "mpidcmgr": {"port_number": 9343, "protocols": ["tcp", "udp"]},
    "mphlpdmc": {"port_number": 9344, "protocols": ["tcp", "udp"]},
    "rancher": {"port_number": 9345, "protocols": ["tcp"]},
    "ctechlicensing": {"port_number": 9346, "protocols": ["tcp", "udp"]},
    "fjdmimgr": {"port_number": 9374, "protocols": ["tcp", "udp"]},
    "boxp": {"port_number": 9380, "protocols": ["tcp", "udp"]},
    "d2dconfig": {"port_number": 9387, "protocols": ["tcp"]},
    "d2ddatatrans": {"port_number": 9388, "protocols": ["tcp"]},
    "adws": {"port_number": 9389, "protocols": ["tcp"]},
    "otp": {"port_number": 9390, "protocols": ["tcp"]},
    "fjinvmgr": {"port_number": 9396, "protocols": ["tcp", "udp"]},
    "mpidcagt": {"port_number": 9397, "protocols": ["tcp", "udp"]},
    "sec-t4net-srv": {"port_number": 9400, "protocols": ["tcp", "udp"]},
    "sec-t4net-clt": {"port_number": 9401, "protocols": ["tcp", "udp"]},
    "sec-pc2fax-srv": {"port_number": 9402, "protocols": ["tcp", "udp"]},
    "git": {"port_number": 9418, "protocols": ["tcp", "udp"]},
    "tungsten-https": {"port_number": 9443, "protocols": ["tcp", "udp"]},
    "wso2esb-console": {"port_number": 9444, "protocols": ["tcp", "udp"]},
    "mindarray-ca": {"port_number": 9445, "protocols": ["tcp"]},
    "sntlkeyssrvr": {"port_number": 9450, "protocols": ["tcp", "udp"]},
    "ismserver": {"port_number": 9500, "protocols": ["tcp", "udp"]},
    "sma-spw": {"port_number": 9522, "protocols": ["udp"]},
    "mngsuite": {"port_number": 9535, "protocols": ["tcp", "udp"]},
    "laes-bf": {"port_number": 9536, "protocols": ["tcp", "udp"]},
    "trispen-sra": {"port_number": 9555, "protocols": ["tcp", "udp"]},
    "p4runtime": {"port_number": 9559, "protocols": ["tcp"]},
    "ldgateway": {"port_number": 9592, "protocols": ["tcp", "udp"]},
    "cba8": {"port_number": 9593, "protocols": ["tcp", "udp"]},
    "msgsys": {"port_number": 9594, "protocols": ["tcp", "udp"]},
    "pds": {"port_number": 9595, "protocols": ["tcp", "udp"]},
    "mercury-disc": {"port_number": 9596, "protocols": ["tcp", "udp"]},
    "pd-admin": {"port_number": 9597, "protocols": ["tcp", "udp"]},
    "vscp": {"port_number": 9598, "protocols": ["tcp", "udp"]},
    "robix": {"port_number": 9599, "protocols": ["tcp", "udp"]},
    "micromuse-ncpw": {"port_number": 9600, "protocols": ["tcp", "udp"]},
    "streamcomm-ds": {"port_number": 9612, "protocols": ["tcp", "udp"]},
    "iadt-tls": {"port_number": 9614, "protocols": ["tcp"]},
    "erunbook-agent": {"port_number": 9616, "protocols": ["tcp"]},
    "erunbook_agent": {"port_number": 9616, "protocols": ["tcp"]},
    "erunbook-server": {"port_number": 9617, "protocols": ["tcp"]},
    "erunbook_server": {"port_number": 9617, "protocols": ["tcp"]},
    "condor": {"port_number": 9618, "protocols": ["tcp", "udp"]},
    "odbcpathway": {"port_number": 9628, "protocols": ["tcp", "udp"]},
    "uniport": {"port_number": 9629, "protocols": ["tcp", "udp"]},
    "peoctlr": {"port_number": 9630, "protocols": ["tcp"]},
    "peocoll": {"port_number": 9631, "protocols": ["tcp"]},
    "mc-comm": {"port_number": 9632, "protocols": ["udp"]},
    "pqsflows": {"port_number": 9640, "protocols": ["tcp"]},
    "zoomcp": {"port_number": 9666, "protocols": ["tcp"]},
    "xmms2": {"port_number": 9667, "protocols": ["tcp", "udp"]},
    "tec5-sdctp": {"port_number": 9668, "protocols": ["tcp", "udp"]},
    "client-wakeup": {"port_number": 9694, "protocols": ["tcp", "udp"]},
    "ccnx": {"port_number": 9695, "protocols": ["tcp", "udp"]},
    "board-roar": {"port_number": 9700, "protocols": ["tcp", "udp"]},
    "l5nas-parchan": {"port_number": 9747, "protocols": ["tcp", "udp"]},
    "board-voip": {"port_number": 9750, "protocols": ["tcp", "udp"]},
    "rasadv": {"port_number": 9753, "protocols": ["tcp", "udp"]},
    "tungsten-http": {"port_number": 9762, "protocols": ["tcp", "udp"]},
    "davsrc": {"port_number": 9800, "protocols": ["tcp", "udp"]},
    "sstp-2": {"port_number": 9801, "protocols": ["tcp", "udp"]},
    "davsrcs": {"port_number": 9802, "protocols": ["tcp", "udp"]},
    "sapv1": {"port_number": 9875, "protocols": ["tcp", "udp"]},
    "sd": {"port_number": 9876, "protocols": ["tcp"]},
    "x510": {"port_number": 9877, "protocols": ["tcp"]},
    "kca-service": {"port_number": 9878, "protocols": ["udp"]},
    "cyborg-systems": {"port_number": 9888, "protocols": ["tcp", "udp"]},
    "gt-proxy": {"port_number": 9889, "protocols": ["tcp", "udp"]},
    "monkeycom": {"port_number": 9898, "protocols": ["tcp", "udp"]},
    "sctp-tunneling": {"port_number": 9899, "protocols": ["udp"]},
    "iua": {"port_number": 9900, "protocols": ["tcp", "udp", "sctp"]},
    "enrp": {"port_number": 9901, "protocols": ["udp"]},
    "enrp-sctp": {"port_number": 9901, "protocols": ["sctp"]},
    "enrp-sctp-tls": {"port_number": 9902, "protocols": ["sctp"]},
    "multicast-ping": {"port_number": 9903, "protocols": ["udp"]},
    "domaintime": {"port_number": 9909, "protocols": ["tcp", "udp"]},
    "sype-transport": {"port_number": 9911, "protocols": ["tcp", "udp"]},
    "xybrid-cloud": {"port_number": 9925, "protocols": ["tcp"]},
    "apc-9950": {"port_number": 9950, "protocols": ["tcp", "udp"]},
    "apc-9951": {"port_number": 9951, "protocols": ["tcp", "udp"]},
    "apc-9952": {"port_number": 9952, "protocols": ["tcp", "udp"]},
    "acis": {"port_number": 9953, "protocols": ["tcp", "udp"]},
    "hinp": {"port_number": 9954, "protocols": ["tcp"]},
    "alljoyn-stm": {"port_number": 9955, "protocols": ["tcp"]},
    "alljoyn-mcm": {"port_number": 9955, "protocols": ["udp"]},
    "alljoyn": {"port_number": 9956, "protocols": ["udp"]},
    "odnsp": {"port_number": 9966, "protocols": ["tcp", "udp"]},
    "xybrid-rt": {"port_number": 9978, "protocols": ["tcp"]},
    "visweather": {"port_number": 9979, "protocols": ["tcp"]},
    "pumpkindb": {"port_number": 9981, "protocols": ["tcp"]},
    "dsm-scm-target": {"port_number": 9987, "protocols": ["tcp", "udp"]},
    "nsesrvr": {"port_number": 9988, "protocols": ["tcp"]},
    "osm-appsrvr": {"port_number": 9990, "protocols": ["tcp", "udp"]},
    "osm-oev": {"port_number": 9991, "protocols": ["tcp", "udp"]},
    "palace-1": {"port_number": 9992, "protocols": ["tcp", "udp"]},
    "palace-2": {"port_number": 9993, "protocols": ["tcp", "udp"]},
    "palace-3": {"port_number": 9994, "protocols": ["tcp", "udp"]},
    "palace-4": {"port_number": 9995, "protocols": ["tcp", "udp"]},
    "palace-5": {"port_number": 9996, "protocols": ["tcp", "udp"]},
    "palace-6": {"port_number": 9997, "protocols": ["tcp", "udp"]},
    "distinct32": {"port_number": 9998, "protocols": ["tcp", "udp"]},
    "distinct": {"port_number": 9999, "protocols": ["tcp", "udp"]},
    "ndmp": {"port_number": 10000, "protocols": ["tcp", "udp"]},
    "scp-config": {"port_number": 10001, "protocols": ["tcp", "udp"]},
    "documentum": {"port_number": 10002, "protocols": ["tcp", "udp"]},
    "documentum-s": {"port_number": 10003, "protocols": ["tcp", "udp"]},
    "documentum_s": {"port_number": 10003, "protocols": ["tcp", "udp"]},
    "emcrmirccd": {"port_number": 10004, "protocols": ["tcp"]},
    "emcrmird": {"port_number": 10005, "protocols": ["tcp"]},
    "netapp-sync": {"port_number": 10006, "protocols": ["tcp"]},
    "mvs-capacity": {"port_number": 10007, "protocols": ["tcp", "udp"]},
    "octopus": {"port_number": 10008, "protocols": ["tcp", "udp"]},
    "swdtp-sv": {"port_number": 10009, "protocols": ["tcp", "udp"]},
    "rxapi": {"port_number": 10010, "protocols": ["tcp"]},
    "abb-hw": {"port_number": 10020, "protocols": ["tcp"]},
    "cefd-vmp": {"port_number": 10023, "protocols": ["udp"]},
    "zabbix-agent": {"port_number": 10050, "protocols": ["tcp", "udp"]},
    "zabbix-trapper": {"port_number": 10051, "protocols": ["tcp", "udp"]},
    "qptlmd": {"port_number": 10055, "protocols": ["tcp"]},
    "amanda": {"port_number": 10080, "protocols": ["tcp", "udp"]},
    "famdc": {"port_number": 10081, "protocols": ["tcp", "udp"]},
    "itap-ddtp": {"port_number": 10100, "protocols": ["tcp", "udp"]},
    "ezmeeting-2": {"port_number": 10101, "protocols": ["tcp", "udp"]},
    "ezproxy-2": {"port_number": 10102, "protocols": ["tcp", "udp"]},
    "ezrelay": {"port_number": 10103, "protocols": ["tcp", "udp"]},
    "swdtp": {"port_number": 10104, "protocols": ["tcp", "udp"]},
    "bctp-server": {"port_number": 10107, "protocols": ["tcp", "udp"]},
    "nmea-0183": {"port_number": 10110, "protocols": ["tcp", "udp"]},
    "nmea-onenet": {"port_number": 10111, "protocols": ["udp"]},
    "netiq-endpoint": {"port_number": 10113, "protocols": ["tcp", "udp"]},
    "netiq-qcheck": {"port_number": 10114, "protocols": ["tcp", "udp"]},
    "netiq-endpt": {"port_number": 10115, "protocols": ["tcp", "udp"]},
    "netiq-voipa": {"port_number": 10116, "protocols": ["tcp", "udp"]},
    "iqrm": {"port_number": 10117, "protocols": ["tcp", "udp"]},
    "cimple": {"port_number": 10125, "protocols": ["tcp"]},
    "bmc-perf-sd": {"port_number": 10128, "protocols": ["tcp", "udp"]},
    "bmc-gms": {"port_number": 10129, "protocols": ["tcp"]},
    "qb-db-server": {"port_number": 10160, "protocols": ["tcp", "udp"]},
    "snmptls": {"port_number": 10161, "protocols": ["tcp"]},
    "snmpdtls": {"port_number": 10161, "protocols": ["udp"]},
    "snmptls-trap": {"port_number": 10162, "protocols": ["tcp"]},
    "snmpdtls-trap": {"port_number": 10162, "protocols": ["udp"]},
    "trisoap": {"port_number": 10200, "protocols": ["tcp", "udp"]},
    "rsms": {"port_number": 10201, "protocols": ["tcp"]},
    "rscs": {"port_number": 10201, "protocols": ["udp"]},
    "apollo-relay": {"port_number": 10252, "protocols": ["tcp", "udp"]},
    "eapol-relay": {"port_number": 10253, "protocols": ["udp"]},
    "axis-wimp-port": {"port_number": 10260, "protocols": ["tcp", "udp"]},
    "tile-ml": {"port_number": 10261, "protocols": ["tcp"]},
    "blocks": {"port_number": 10288, "protocols": ["tcp", "udp"]},
    "bngsync": {"port_number": 10439, "protocols": ["udp"]},
    "cirrossp": {"port_number": 10443, "protocols": ["tcp"]},
    "hip-nat-t": {"port_number": 10500, "protocols": ["udp"]},
    "MOS-lower": {"port_number": 10540, "protocols": ["tcp", "udp"]},
    "MOS-upper": {"port_number": 10541, "protocols": ["tcp", "udp"]},
    "MOS-aux": {"port_number": 10542, "protocols": ["tcp", "udp"]},
    "MOS-soap": {"port_number": 10543, "protocols": ["tcp", "udp"]},
    "MOS-soap-opt": {"port_number": 10544, "protocols": ["tcp", "udp"]},
    "serverdocs": {"port_number": 10548, "protocols": ["tcp"]},
    "printopia": {"port_number": 10631, "protocols": ["tcp"]},
    "gap": {"port_number": 10800, "protocols": ["tcp", "udp"]},
    "lpdg": {"port_number": 10805, "protocols": ["tcp", "udp"]},
    "nbd": {"port_number": 10809, "protocols": ["tcp"]},
    "nmc-disc": {"port_number": 10810, "protocols": ["udp"]},
    "helix": {"port_number": 10860, "protocols": ["tcp", "udp"]},
    "bveapi": {"port_number": 10880, "protocols": ["tcp", "udp"]},
    "octopustentacle": {"port_number": 10933, "protocols": ["tcp"]},
    "rmiaux": {"port_number": 10990, "protocols": ["tcp", "udp"]},
    "irisa": {"port_number": 11000, "protocols": ["tcp", "udp"]},
    "metasys": {"port_number": 11001, "protocols": ["tcp", "udp"]},
    "weave": {"port_number": 11095, "protocols": ["tcp", "udp"]},
    "origo-sync": {"port_number": 11103, "protocols": ["tcp"]},
    "netapp-icmgmt": {"port_number": 11104, "protocols": ["tcp"]},
    "netapp-icdata": {"port_number": 11105, "protocols": ["tcp"]},
    "sgi-lk": {"port_number": 11106, "protocols": ["tcp", "udp"]},
    "myq-termlink": {"port_number": 11108, "protocols": ["udp"]},
    "sgi-dmfmgr": {"port_number": 11109, "protocols": ["tcp"]},
    "sgi-soap": {"port_number": 11110, "protocols": ["tcp"]},
    "vce": {"port_number": 11111, "protocols": ["tcp", "udp"]},
    "dicom": {"port_number": 11112, "protocols": ["tcp", "udp"]},
    "suncacao-snmp": {"port_number": 11161, "protocols": ["tcp", "udp"]},
    "suncacao-jmxmp": {"port_number": 11162, "protocols": ["tcp", "udp"]},
    "suncacao-rmi": {"port_number": 11163, "protocols": ["tcp", "udp"]},
    "suncacao-csa": {"port_number": 11164, "protocols": ["tcp", "udp"]},
    "suncacao-websvc": {"port_number": 11165, "protocols": ["tcp", "udp"]},
    "snss": {"port_number": 11171, "protocols": ["udp"]},
    "oemcacao-jmxmp": {"port_number": 11172, "protocols": ["tcp"]},
    "t5-straton": {"port_number": 11173, "protocols": ["tcp"]},
    "oemcacao-rmi": {"port_number": 11174, "protocols": ["tcp"]},
    "oemcacao-websvc": {"port_number": 11175, "protocols": ["tcp"]},
    "smsqp": {"port_number": 11201, "protocols": ["tcp", "udp"]},
    "dcsl-backup": {"port_number": 11202, "protocols": ["tcp"]},
    "wifree": {"port_number": 11208, "protocols": ["tcp", "udp"]},
    "memcache": {"port_number": 11211, "protocols": ["tcp", "udp"]},
    "xcompute": {"port_number": 11235, "protocols": ["tcp", "sctp"]},
    "imip": {"port_number": 11319, "protocols": ["tcp", "udp"]},
    "imip-channels": {"port_number": 11320, "protocols": ["tcp", "udp"]},
    "arena-server": {"port_number": 11321, "protocols": ["tcp", "udp"]},
    "atm-uhas": {"port_number": 11367, "protocols": ["tcp", "udp"]},
    "hkp": {"port_number": 11371, "protocols": ["tcp", "udp"]},
    "lsdp": {"port_number": 11430, "protocols": ["udp"]},
    "asgcypresstcps": {"port_number": 11489, "protocols": ["tcp"]},
    "tempest-port": {"port_number": 11600, "protocols": ["tcp", "udp"]},
    "emc-xsw-dconfig": {"port_number": 11623, "protocols": ["tcp"]},
    "h323callsigalt": {"port_number": 11720, "protocols": ["tcp", "udp"]},
    "emc-xsw-dcache": {"port_number": 11723, "protocols": ["tcp", "udp"]},
    "intrepid-ssl": {"port_number": 11751, "protocols": ["tcp", "udp"]},
    "lanschool": {"port_number": 11796, "protocols": ["tcp"]},
    "lanschool-mpt": {"port_number": 11796, "protocols": ["udp"]},
    "xoraya": {"port_number": 11876, "protocols": ["tcp", "udp"]},
    "x2e-disc": {"port_number": 11877, "protocols": ["udp"]},
    "sysinfo-sp": {"port_number": 11967, "protocols": ["tcp", "udp"]},
    "tibsd": {"port_number": 11971, "protocols": ["tcp"]},
    "wmereceiving": {"port_number": 11997, "protocols": ["sctp"]},
    "wmedistribution": {"port_number": 11998, "protocols": ["sctp"]},
    "wmereporting": {"port_number": 11999, "protocols": ["sctp"]},
    "entextxid": {"port_number": 12000, "protocols": ["tcp", "udp"]},
    "entextnetwk": {"port_number": 12001, "protocols": ["tcp", "udp"]},
    "entexthigh": {"port_number": 12002, "protocols": ["tcp", "udp"]},
    "entextmed": {"port_number": 12003, "protocols": ["tcp", "udp"]},
    "entextlow": {"port_number": 12004, "protocols": ["tcp", "udp"]},
    "dbisamserver1": {"port_number": 12005, "protocols": ["tcp", "udp"]},
    "dbisamserver2": {"port_number": 12006, "protocols": ["tcp", "udp"]},
    "accuracer": {"port_number": 12007, "protocols": ["tcp", "udp"]},
    "accuracer-dbms": {"port_number": 12008, "protocols": ["tcp", "udp"]},
    "ghvpn": {"port_number": 12009, "protocols": ["udp"]},
    "edbsrvr": {"port_number": 12010, "protocols": ["tcp"]},
    "vipera": {"port_number": 12012, "protocols": ["tcp", "udp"]},
    "vipera-ssl": {"port_number": 12013, "protocols": ["tcp", "udp"]},
    "rets-ssl": {"port_number": 12109, "protocols": ["tcp", "udp"]},
    "nupaper-ss": {"port_number": 12121, "protocols": ["tcp", "udp"]},
    "cawas": {"port_number": 12168, "protocols": ["tcp", "udp"]},
    "hivep": {"port_number": 12172, "protocols": ["tcp", "udp"]},
    "linogridengine": {"port_number": 12300, "protocols": ["tcp", "udp"]},
    "rads": {"port_number": 12302, "protocols": ["tcp"]},
    "warehouse-sss": {"port_number": 12321, "protocols": ["tcp", "udp"]},
    "warehouse": {"port_number": 12322, "protocols": ["tcp", "udp"]},
    "italk": {"port_number": 12345, "protocols": ["tcp", "udp"]},
    "carb-repl-ctrl": {"port_number": 12546, "protocols": ["tcp"]},
    "tsaf": {"port_number": 12753, "protocols": ["tcp", "udp"]},
    "netperf": {"port_number": 12865, "protocols": ["tcp"]},
    "i-zipqd": {"port_number": 13160, "protocols": ["tcp", "udp"]},
    "bcslogc": {"port_number": 13216, "protocols": ["tcp", "udp"]},
    "rs-pias": {"port_number": 13217, "protocols": ["tcp", "udp"]},
    "emc-vcas-tcp": {"port_number": 13218, "protocols": ["tcp"]},
    "emc-vcas-udp": {"port_number": 13218, "protocols": ["udp"]},
    "powwow-client": {"port_number": 13223, "protocols": ["tcp", "udp"]},
    "powwow-server": {"port_number": 13224, "protocols": ["tcp", "udp"]},
    "doip-data": {"port_number": 13400, "protocols": ["tcp"]},
    "doip-disc": {"port_number": 13400, "protocols": ["udp"]},
    "bprd": {"port_number": 13720, "protocols": ["tcp", "udp"]},
    "bpdbm": {"port_number": 13721, "protocols": ["tcp", "udp"]},
    "bpjava-msvc": {"port_number": 13722, "protocols": ["tcp", "udp"]},
    "vnetd": {"port_number": 13724, "protocols": ["tcp", "udp"]},
    "bpcd": {"port_number": 13782, "protocols": ["tcp", "udp"]},
    "vopied": {"port_number": 13783, "protocols": ["tcp", "udp"]},
    "nbdb": {"port_number": 13785, "protocols": ["tcp", "udp"]},
    "nomdb": {"port_number": 13786, "protocols": ["tcp", "udp"]},
    "dsmcc-config": {"port_number": 13818, "protocols": ["tcp", "udp"]},
    "dsmcc-session": {"port_number": 13819, "protocols": ["tcp", "udp"]},
    "dsmcc-passthru": {"port_number": 13820, "protocols": ["tcp", "udp"]},
    "dsmcc-download": {"port_number": 13821, "protocols": ["tcp", "udp"]},
    "dsmcc-ccp": {"port_number": 13822, "protocols": ["tcp", "udp"]},
    "bmdss": {"port_number": 13823, "protocols": ["tcp"]},
    "a-trust-rpc": {"port_number": 13832, "protocols": ["tcp"]},
    "ucontrol": {"port_number": 13894, "protocols": ["tcp", "udp"]},
    "dta-systems": {"port_number": 13929, "protocols": ["tcp", "udp"]},
    "medevolve": {"port_number": 13930, "protocols": ["tcp"]},
    "scotty-ft": {"port_number": 14000, "protocols": ["tcp", "udp"]},
    "sua": {"port_number": 14001, "protocols": ["tcp", "udp", "sctp"]},
    "scotty-disc": {"port_number": 14002, "protocols": ["udp"]},
    "sage-best-com1": {"port_number": 14033, "protocols": ["tcp", "udp"]},
    "sage-best-com2": {"port_number": 14034, "protocols": ["tcp", "udp"]},
    "vcs-app": {"port_number": 14141, "protocols": ["tcp", "udp"]},
    "icpp": {"port_number": 14142, "protocols": ["tcp", "udp"]},
    "icpps": {"port_number": 14143, "protocols": ["tcp"]},
    "gcm-app": {"port_number": 14145, "protocols": ["tcp", "udp"]},
    "vrts-tdd": {"port_number": 14149, "protocols": ["tcp", "udp"]},
    "vcscmd": {"port_number": 14150, "protocols": ["tcp"]},
    "vad": {"port_number": 14154, "protocols": ["tcp", "udp"]},
    "cps": {"port_number": 14250, "protocols": ["tcp", "udp"]},
    "ca-web-update": {"port_number": 14414, "protocols": ["tcp", "udp"]},
    "xpra": {"port_number": 14500, "protocols": ["tcp"]},
    "hde-lcesrvr-1": {"port_number": 14936, "protocols": ["tcp", "udp"]},
    "hde-lcesrvr-2": {"port_number": 14937, "protocols": ["tcp", "udp"]},
    "hydap": {"port_number": 15000, "protocols": ["tcp", "udp"]},
    "onep-tls": {"port_number": 15002, "protocols": ["tcp"]},
    "v2g-secc": {"port_number": 15118, "protocols": ["udp"]},
    "xpilot": {"port_number": 15345, "protocols": ["tcp", "udp"]},
    "3link": {"port_number": 15363, "protocols": ["tcp", "udp"]},
    "cisco-snat": {"port_number": 15555, "protocols": ["tcp", "udp"]},
    "bex-xr": {"port_number": 15660, "protocols": ["tcp", "udp"]},
    "ptp": {"port_number": 15740, "protocols": ["tcp", "udp"]},
    "2ping": {"port_number": 15998, "protocols": ["udp"]},
    "programmar": {"port_number": 15999, "protocols": ["tcp"]},
    "fmsas": {"port_number": 16000, "protocols": ["tcp"]},
    "fmsascon": {"port_number": 16001, "protocols": ["tcp"]},
    "gsms": {"port_number": 16002, "protocols": ["tcp"]},
    "alfin": {"port_number": 16003, "protocols": ["udp"]},
    "jwpc": {"port_number": 16020, "protocols": ["tcp"]},
    "jwpc-bin": {"port_number": 16021, "protocols": ["tcp"]},
    "sun-sea-port": {"port_number": 16161, "protocols": ["tcp", "udp"]},
    "solaris-audit": {"port_number": 16162, "protocols": ["tcp"]},
    "etb4j": {"port_number": 16309, "protocols": ["tcp", "udp"]},
    "pduncs": {"port_number": 16310, "protocols": ["tcp", "udp"]},
    "pdefmns": {"port_number": 16311, "protocols": ["tcp", "udp"]},
    "netserialext1": {"port_number": 16360, "protocols": ["tcp", "udp"]},
    "netserialext2": {"port_number": 16361, "protocols": ["tcp", "udp"]},
    "netserialext3": {"port_number": 16367, "protocols": ["tcp", "udp"]},
    "netserialext4": {"port_number": 16368, "protocols": ["tcp", "udp"]},
    "connected": {"port_number": 16384, "protocols": ["tcp", "udp"]},
    "rdgs": {"port_number": 16385, "protocols": ["tcp"]},
    "xoms": {"port_number": 16619, "protocols": ["tcp"]},
    "axon-tunnel": {"port_number": 16665, "protocols": ["tcp"]},
    "vtp": {"port_number": 16666, "protocols": ["udp"]},
    "cadsisvr": {"port_number": 16789, "protocols": ["tcp"]},
    "newbay-snc-mc": {"port_number": 16900, "protocols": ["tcp", "udp"]},
    "sgcip": {"port_number": 16950, "protocols": ["tcp", "udp"]},
    "intel-rci-mp": {"port_number": 16991, "protocols": ["tcp", "udp"]},
    "amt-soap-http": {"port_number": 16992, "protocols": ["tcp", "udp"]},
    "amt-soap-https": {"port_number": 16993, "protocols": ["tcp", "udp"]},
    "amt-redir-tcp": {"port_number": 16994, "protocols": ["tcp", "udp"]},
    "amt-redir-tls": {"port_number": 16995, "protocols": ["tcp", "udp"]},
    "isode-dua": {"port_number": 17007, "protocols": ["tcp", "udp"]},
    "ncpu": {"port_number": 17010, "protocols": ["tcp"]},
    "vestasdlp": {"port_number": 17184, "protocols": ["tcp"]},
    "soundsvirtual": {"port_number": 17185, "protocols": ["tcp", "udp"]},
    "chipper": {"port_number": 17219, "protocols": ["tcp", "udp"]},
    "avtp": {"port_number": 17220, "protocols": ["tcp", "udp"]},
    "avdecc": {"port_number": 17221, "protocols": ["tcp", "udp"]},
    "cpsp": {"port_number": 17222, "protocols": ["udp"]},
    "isa100-gci": {"port_number": 17223, "protocols": ["tcp"]},
    "trdp-pd": {"port_number": 17224, "protocols": ["udp"]},
    "trdp-md": {"port_number": 17225, "protocols": ["tcp", "udp"]},
    "integrius-stp": {"port_number": 17234, "protocols": ["tcp", "udp"]},
    "ssh-mgmt": {"port_number": 17235, "protocols": ["tcp", "udp"]},
    "db-lsp": {"port_number": 17500, "protocols": ["tcp"]},
    "db-lsp-disc": {"port_number": 17500, "protocols": ["udp"]},
    "ailith": {"port_number": 17555, "protocols": ["tcp"]},
    "ea": {"port_number": 17729, "protocols": ["tcp", "udp"]},
    "zep": {"port_number": 17754, "protocols": ["tcp", "udp"]},
    "zigbee-ip": {"port_number": 17755, "protocols": ["tcp", "udp"]},
    "zigbee-ips": {"port_number": 17756, "protocols": ["tcp", "udp"]},
    "sw-orion": {"port_number": 17777, "protocols": ["tcp"]},
    "biimenu": {"port_number": 18000, "protocols": ["tcp", "udp"]},
    "radpdf": {"port_number": 18104, "protocols": ["tcp"]},
    "racf": {"port_number": 18136, "protocols": ["tcp"]},
    "opsec-cvp": {"port_number": 18181, "protocols": ["tcp", "udp"]},
    "opsec-ufp": {"port_number": 18182, "protocols": ["tcp", "udp"]},
    "opsec-sam": {"port_number": 18183, "protocols": ["tcp", "udp"]},
    "opsec-lea": {"port_number": 18184, "protocols": ["tcp", "udp"]},
    "opsec-omi": {"port_number": 18185, "protocols": ["tcp", "udp"]},
    "ohsc": {"port_number": 18186, "protocols": ["tcp", "udp"]},
    "opsec-ela": {"port_number": 18187, "protocols": ["tcp", "udp"]},
    "checkpoint-rtm": {"port_number": 18241, "protocols": ["tcp", "udp"]},
    "iclid": {"port_number": 18242, "protocols": ["tcp"]},
    "clusterxl": {"port_number": 18243, "protocols": ["tcp"]},
    "gv-pf": {"port_number": 18262, "protocols": ["tcp", "udp"]},
    "ac-cluster": {"port_number": 18463, "protocols": ["tcp", "udp"]},
    "heythings": {"port_number": 18516, "protocols": ["udp"]},
    "rds-ib": {"port_number": 18634, "protocols": ["tcp", "udp"]},
    "rds-ip": {"port_number": 18635, "protocols": ["tcp", "udp"]},
    "vdmmesh": {"port_number": 18668, "protocols": ["tcp"]},
    "vdmmesh-disc": {"port_number": 18668, "protocols": ["udp"]},
    "ique": {"port_number": 18769, "protocols": ["tcp", "udp"]},
    "infotos": {"port_number": 18881, "protocols": ["tcp", "udp"]},
    "apc-necmp": {"port_number": 18888, "protocols": ["tcp", "udp"]},
    "igrid": {"port_number": 19000, "protocols": ["tcp", "udp"]},
    "scintilla": {"port_number": 19007, "protocols": ["tcp", "udp"]},
    "j-link": {"port_number": 19020, "protocols": ["tcp"]},
    "opsec-uaa": {"port_number": 19191, "protocols": ["tcp", "udp"]},
    "ua-secureagent": {"port_number": 19194, "protocols": ["tcp", "udp"]},
    "cora": {"port_number": 19220, "protocols": ["tcp"]},
    "cora-disc": {"port_number": 19220, "protocols": ["udp"]},
    "keysrvr": {"port_number": 19283, "protocols": ["tcp", "udp"]},
    "keyshadow": {"port_number": 19315, "protocols": ["tcp", "udp"]},
    "mtrgtrans": {"port_number": 19398, "protocols": ["tcp", "udp"]},
    "hp-sco": {"port_number": 19410, "protocols": ["tcp", "udp"]},
    "hp-sca": {"port_number": 19411, "protocols": ["tcp", "udp"]},
    "hp-sessmon": {"port_number": 19412, "protocols": ["tcp", "udp"]},
    "fxuptp": {"port_number": 19539, "protocols": ["tcp", "udp"]},
    "sxuptp": {"port_number": 19540, "protocols": ["tcp", "udp"]},
    "jcp": {"port_number": 19541, "protocols": ["tcp", "udp"]},
    "mle": {"port_number": 19788, "protocols": ["udp"]},
    "faircom-db": {"port_number": 19790, "protocols": ["tcp"]},
    "iec-104-sec": {"port_number": 19998, "protocols": ["tcp"]},
    "dnp-sec": {"port_number": 19999, "protocols": ["tcp", "udp", "sctp"]},
    "dnp": {"port_number": 20000, "protocols": ["tcp", "udp", "sctp"]},
    "microsan": {"port_number": 20001, "protocols": ["tcp", "udp"]},
    "commtact-http": {"port_number": 20002, "protocols": ["tcp", "udp"]},
    "commtact-https": {"port_number": 20003, "protocols": ["tcp", "udp"]},
    "openwebnet": {"port_number": 20005, "protocols": ["tcp", "udp"]},
    "ss-idi-disc": {"port_number": 20012, "protocols": ["udp"]},
    "ss-idi": {"port_number": 20013, "protocols": ["tcp"]},
    "opendeploy": {"port_number": 20014, "protocols": ["tcp", "udp"]},
    "nburn-id": {"port_number": 20034, "protocols": ["tcp", "udp"]},
    "nburn_id": {"port_number": 20034, "protocols": ["tcp", "udp"]},
    "tmophl7mts": {"port_number": 20046, "protocols": ["tcp", "udp"]},
    "mountd": {"port_number": 20048, "protocols": ["tcp", "udp"]},
    "nfsrdma": {"port_number": 20049, "protocols": ["tcp", "udp", "sctp"]},
    "avesterra": {"port_number": 20057, "protocols": ["tcp"]},
    "tolfab": {"port_number": 20167, "protocols": ["tcp", "udp"]},
    "ipdtp-port": {"port_number": 20202, "protocols": ["tcp", "udp"]},
    "ipulse-ics": {"port_number": 20222, "protocols": ["tcp", "udp"]},
    "emwavemsg": {"port_number": 20480, "protocols": ["tcp", "udp"]},
    "track": {"port_number": 20670, "protocols": ["tcp", "udp"]},
    "crtech-nlm": {"port_number": 20810, "protocols": ["tcp"]},
    "athand-mmp": {"port_number": 20999, "protocols": ["tcp", "udp"]},
    "irtrans": {"port_number": 21000, "protocols": ["tcp", "udp"]},
    "notezilla-lan": {"port_number": 21010, "protocols": ["tcp"]},
    "trinket-agent": {"port_number": 21212, "protocols": ["tcp"]},
    "cohesity-agent": {"port_number": 21213, "protocols": ["tcp"]},
    "aigairserver": {"port_number": 21221, "protocols": ["tcp"]},
    "rdm-tfs": {"port_number": 21553, "protocols": ["tcp"]},
    "dfserver": {"port_number": 21554, "protocols": ["tcp", "udp"]},
    "vofr-gateway": {"port_number": 21590, "protocols": ["tcp", "udp"]},
    "tvpm": {"port_number": 21800, "protocols": ["tcp", "udp"]},
    "sal": {"port_number": 21801, "protocols": ["tcp"]},
    "webphone": {"port_number": 21845, "protocols": ["tcp", "udp"]},
    "netspeak-is": {"port_number": 21846, "protocols": ["tcp", "udp"]},
    "netspeak-cs": {"port_number": 21847, "protocols": ["tcp", "udp"]},
    "netspeak-acd": {"port_number": 21848, "protocols": ["tcp", "udp"]},
    "netspeak-cps": {"port_number": 21849, "protocols": ["tcp", "udp"]},
    "snapenetio": {"port_number": 22000, "protocols": ["tcp", "udp"]},
    "optocontrol": {"port_number": 22001, "protocols": ["tcp", "udp"]},
    "optohost002": {"port_number": 22002, "protocols": ["tcp", "udp"]},
    "optohost003": {"port_number": 22003, "protocols": ["tcp", "udp"]},
    "optohost004": {"port_number": 22004, "protocols": ["tcp", "udp"]},
    "optohost004-secondary": {"port_number": 22005, "protocols": ["tcp", "udp"]},
    "dcap": {"port_number": 22125, "protocols": ["tcp"]},
    "gsidcap": {"port_number": 22128, "protocols": ["tcp"]},
    "easyengine": {"port_number": 22222, "protocols": ["tcp"]},
    "wnn6": {"port_number": 22273, "protocols": ["tcp", "udp"]},
    "cis": {"port_number": 22305, "protocols": ["tcp", "udp"]},
    "showcockpit-net": {"port_number": 22333, "protocols": ["tcp", "udp"]},
    "shrewd-control": {"port_number": 22335, "protocols": ["tcp"]},
    "shrewd-stream": {"port_number": 22335, "protocols": ["udp"]},
    "cis-secure": {"port_number": 22343, "protocols": ["tcp", "udp"]},
    "wibukey": {"port_number": 22347, "protocols": ["tcp", "udp"]},
    "codemeter": {"port_number": 22350, "protocols": ["tcp", "udp"]},
    "codemeter-cmwan": {"port_number": 22351, "protocols": ["tcp"]},
    "caldsoft-backup": {"port_number": 22537, "protocols": ["tcp"]},
    "vocaltec-wconf": {"port_number": 22555, "protocols": ["tcp"]},
    "vocaltec-phone": {"port_number": 22555, "protocols": ["udp"]},
    "talikaserver": {"port_number": 22763, "protocols": ["tcp", "udp"]},
    "aws-brf": {"port_number": 22800, "protocols": ["tcp", "udp"]},
    "brf-gw": {"port_number": 22951, "protocols": ["tcp", "udp"]},
    "inovaport1": {"port_number": 23000, "protocols": ["tcp", "udp"]},
    "inovaport2": {"port_number": 23001, "protocols": ["tcp", "udp"]},
    "inovaport3": {"port_number": 23002, "protocols": ["tcp", "udp"]},
    "inovaport4": {"port_number": 23003, "protocols": ["tcp", "udp"]},
    "inovaport5": {"port_number": 23004, "protocols": ["tcp", "udp"]},
    "inovaport6": {"port_number": 23005, "protocols": ["tcp", "udp"]},
    "gntp": {"port_number": 23053, "protocols": ["tcp"]},
    "s102": {"port_number": 23272, "protocols": ["udp"]},
    "5afe-dir": {"port_number": 23294, "protocols": ["tcp"]},
    "5afe-disc": {"port_number": 23294, "protocols": ["udp"]},
    "elxmgmt": {"port_number": 23333, "protocols": ["tcp", "udp"]},
    "novar-dbase": {"port_number": 23400, "protocols": ["tcp", "udp"]},
    "novar-alarm": {"port_number": 23401, "protocols": ["tcp", "udp"]},
    "novar-global": {"port_number": 23402, "protocols": ["tcp", "udp"]},
    "aequus": {"port_number": 23456, "protocols": ["tcp"]},
    "aequus-alt": {"port_number": 23457, "protocols": ["tcp"]},
    "areaguard-neo": {"port_number": 23546, "protocols": ["tcp"]},
    "med-ltp": {"port_number": 24000, "protocols": ["tcp", "udp"]},
    "med-fsp-rx": {"port_number": 24001, "protocols": ["tcp", "udp"]},
    "med-fsp-tx": {"port_number": 24002, "protocols": ["tcp", "udp"]},
    "med-supp": {"port_number": 24003, "protocols": ["tcp", "udp"]},
    "med-ovw": {"port_number": 24004, "protocols": ["tcp", "udp"]},
    "med-ci": {"port_number": 24005, "protocols": ["tcp", "udp"]},
    "med-net-svc": {"port_number": 24006, "protocols": ["tcp", "udp"]},
    "filesphere": {"port_number": 24242, "protocols": ["tcp", "udp"]},
    "vista-4gl": {"port_number": 24249, "protocols": ["tcp", "udp"]},
    "ild": {"port_number": 24321, "protocols": ["tcp", "udp"]},
    "hid": {"port_number": 24322, "protocols": ["udp"]},
    "vrmg-ip": {"port_number": 24323, "protocols": ["tcp"]},
    "intel-rci": {"port_number": 24386, "protocols": ["tcp", "udp"]},
    "intel_rci": {"port_number": 24386, "protocols": ["tcp", "udp"]},
    "tonidods": {"port_number": 24465, "protocols": ["tcp", "udp"]},
    "binkp": {"port_number": 24554, "protocols": ["tcp", "udp"]},
    "bilobit": {"port_number": 24577, "protocols": ["tcp"]},
    "bilobit-update": {"port_number": 24577, "protocols": ["udp"]},
    "sdtvwcam": {"port_number": 24666, "protocols": ["tcp"]},
    "canditv": {"port_number": 24676, "protocols": ["tcp", "udp"]},
    "flashfiler": {"port_number": 24677, "protocols": ["tcp", "udp"]},
    "proactivate": {"port_number": 24678, "protocols": ["tcp", "udp"]},
    "tcc-http": {"port_number": 24680, "protocols": ["tcp", "udp"]},
    "cslg": {"port_number": 24754, "protocols": ["tcp"]},
    "assoc-disc": {"port_number": 24850, "protocols": ["udp"]},
    "find": {"port_number": 24922, "protocols": ["tcp", "udp"]},
    "icl-twobase1": {"port_number": 25000, "protocols": ["tcp", "udp"]},
    "icl-twobase2": {"port_number": 25001, "protocols": ["tcp", "udp"]},
    "icl-twobase3": {"port_number": 25002, "protocols": ["tcp", "udp"]},
    "icl-twobase4": {"port_number": 25003, "protocols": ["tcp", "udp"]},
    "icl-twobase5": {"port_number": 25004, "protocols": ["tcp", "udp"]},
    "icl-twobase6": {"port_number": 25005, "protocols": ["tcp", "udp"]},
    "icl-twobase7": {"port_number": 25006, "protocols": ["tcp", "udp"]},
    "icl-twobase8": {"port_number": 25007, "protocols": ["tcp", "udp"]},
    "icl-twobase9": {"port_number": 25008, "protocols": ["tcp", "udp"]},
    "icl-twobase10": {"port_number": 25009, "protocols": ["tcp", "udp"]},
    "db2c-tls": {"port_number": 25100, "protocols": ["tcp"]},
    "rna": {"port_number": 25471, "protocols": ["sctp"]},
    "sauterdongle": {"port_number": 25576, "protocols": ["tcp"]},
    "idtp": {"port_number": 25604, "protocols": ["tcp"]},
    "vocaltec-hos": {"port_number": 25793, "protocols": ["tcp", "udp"]},
    "tasp-net": {"port_number": 25900, "protocols": ["tcp", "udp"]},
    "niobserver": {"port_number": 25901, "protocols": ["tcp", "udp"]},
    "nilinkanalyst": {"port_number": 25902, "protocols": ["tcp", "udp"]},
    "niprobe": {"port_number": 25903, "protocols": ["tcp", "udp"]},
    "bf-game": {"port_number": 25954, "protocols": ["udp"]},
    "bf-master": {"port_number": 25955, "protocols": ["udp"]},
    "quake": {"port_number": 26000, "protocols": ["tcp", "udp"]},
    "scscp": {"port_number": 26133, "protocols": ["tcp", "udp"]},
    "wnn6-ds": {"port_number": 26208, "protocols": ["tcp", "udp"]},
    "cockroach": {"port_number": 26257, "protocols": ["tcp"]},
    "ezproxy": {"port_number": 26260, "protocols": ["tcp", "udp"]},
    "ezmeeting": {"port_number": 26261, "protocols": ["tcp", "udp"]},
    "k3software-svr": {"port_number": 26262, "protocols": ["tcp", "udp"]},
    "k3software-cli": {"port_number": 26263, "protocols": ["tcp", "udp"]},
    "exoline-tcp": {"port_number": 26486, "protocols": ["tcp"]},
    "exoline-udp": {"port_number": 26486, "protocols": ["udp"]},
    "exoconfig": {"port_number": 26487, "protocols": ["tcp", "udp"]},
    "exonet": {"port_number": 26489, "protocols": ["tcp", "udp"]},
    "flex-lmadmin": {"port_number": 27010, "protocols": ["tcp"]},
    "chlenix": {"port_number": 27016, "protocols": ["tcp"]},
    "mongodb": {"port_number": 27017, "protocols": ["tcp"]},
    "imagepump": {"port_number": 27345, "protocols": ["tcp", "udp"]},
    "jesmsjc": {"port_number": 27442, "protocols": ["tcp", "udp"]},
    "kopek-httphead": {"port_number": 27504, "protocols": ["tcp", "udp"]},
    "ars-vista": {"port_number": 27782, "protocols": ["tcp", "udp"]},
    "astrolink": {"port_number": 27876, "protocols": ["tcp"]},
    "tw-auth-key": {"port_number": 27999, "protocols": ["tcp", "udp"]},
    "nxlmd": {"port_number": 28000, "protocols": ["tcp", "udp"]},
    "pqsp": {"port_number": 28001, "protocols": ["tcp"]},
    "gruber-cashreg": {"port_number": 28010, "protocols": ["tcp"]},
    "thor-engine": {"port_number": 28080, "protocols": ["tcp"]},
    "a27-ran-ran": {"port_number": 28119, "protocols": ["udp"]},
    "voxelstorm": {"port_number": 28200, "protocols": ["tcp", "udp"]},
    "siemensgsm": {"port_number": 28240, "protocols": ["tcp", "udp"]},
    "bosswave": {"port_number": 28589, "protocols": ["tcp"]},
    "saltd-licensing": {"port_number": 29000, "protocols": ["tcp"]},
    "sgsap": {"port_number": 29118, "protocols": ["sctp"]},
    "otmp": {"port_number": 29167, "protocols": ["tcp", "udp"]},
    "sbcap": {"port_number": 29168, "protocols": ["sctp"]},
    "iuhsctpassoc": {"port_number": 29169, "protocols": ["sctp"]},
    "bingbang": {"port_number": 29999, "protocols": ["tcp"]},
    "ndmps": {"port_number": 30000, "protocols": ["tcp"]},
    "pago-services1": {"port_number": 30001, "protocols": ["tcp", "udp"]},
    "pago-services2": {"port_number": 30002, "protocols": ["tcp", "udp"]},
    "amicon-fpsu-ra": {"port_number": 30003, "protocols": ["tcp", "udp"]},
    "amicon-fpsu-s": {"port_number": 30004, "protocols": ["udp"]},
    "rwp": {"port_number": 30100, "protocols": ["tcp", "sctp"]},
    "kingdomsonline": {"port_number": 30260, "protocols": ["tcp", "udp"]},
    "gs-realtime": {"port_number": 30400, "protocols": ["tcp"]},
    "samsung-disc": {"port_number": 30832, "protocols": ["udp"]},
    "ovobs": {"port_number": 30999, "protocols": ["tcp", "udp"]},
    "ka-sddp": {"port_number": 31016, "protocols": ["tcp"]},
    "ka-kdp": {"port_number": 31016, "protocols": ["udp"]},
    "autotrac-acp": {"port_number": 31020, "protocols": ["tcp"]},
    "yawn": {"port_number": 31029, "protocols": ["udp"]},
    "eldim": {"port_number": 31337, "protocols": ["tcp", "udp"]},
    "pace-licensed": {"port_number": 31400, "protocols": ["tcp"]},
    "xqosd": {"port_number": 31416, "protocols": ["tcp", "udp"]},
    "tetrinet": {"port_number": 31457, "protocols": ["tcp", "udp"]},
    "lm-mon": {"port_number": 31620, "protocols": ["tcp", "udp"]},
    "dsx-monitor": {"port_number": 31685, "protocols": ["tcp"]},
    "dsx_monitor": {"port_number": 31685, "protocols": ["tcp"]},
    "gamesmith-port": {"port_number": 31765, "protocols": ["tcp", "udp"]},
    "iceedcp-tx": {"port_number": 31948, "protocols": ["tcp", "udp"]},
    "iceedcp_tx": {"port_number": 31948, "protocols": ["tcp", "udp"]},
    "iceedcp-rx": {"port_number": 31949, "protocols": ["tcp", "udp"]},
    "iceedcp_rx": {"port_number": 31949, "protocols": ["tcp", "udp"]},
    "iracinghelper": {"port_number": 32034, "protocols": ["tcp", "udp"]},
    "t1distproc60": {"port_number": 32249, "protocols": ["tcp", "udp"]},
    "plex": {"port_number": 32400, "protocols": ["tcp"]},
    "apm-link": {"port_number": 32483, "protocols": ["tcp", "udp"]},
    "sec-ntb-clnt": {"port_number": 32635, "protocols": ["tcp", "udp"]},
    "DMExpress": {"port_number": 32636, "protocols": ["tcp", "udp"]},
    "filenet-powsrm": {"port_number": 32767, "protocols": ["tcp", "udp"]},
    "filenet-tms": {"port_number": 32768, "protocols": ["tcp", "udp"]},
    "filenet-rpc": {"port_number": 32769, "protocols": ["tcp", "udp"]},
    "filenet-nch": {"port_number": 32770, "protocols": ["tcp", "udp"]},
    "filenet-rmi": {"port_number": 32771, "protocols": ["tcp", "udp"]},
    "filenet-pa": {"port_number": 32772, "protocols": ["tcp", "udp"]},
    "filenet-cm": {"port_number": 32773, "protocols": ["tcp", "udp"]},
    "filenet-re": {"port_number": 32774, "protocols": ["tcp", "udp"]},
    "filenet-pch": {"port_number": 32775, "protocols": ["tcp", "udp"]},
    "filenet-peior": {"port_number": 32776, "protocols": ["tcp", "udp"]},
    "filenet-obrok": {"port_number": 32777, "protocols": ["tcp", "udp"]},
    "mlsn": {"port_number": 32801, "protocols": ["tcp", "udp"]},
    "retp": {"port_number": 32811, "protocols": ["tcp"]},
    "idmgratm": {"port_number": 32896, "protocols": ["tcp", "udp"]},
    "wg-endpt-comms": {"port_number": 33000, "protocols": ["tcp"]},
    "mysqlx": {"port_number": 33060, "protocols": ["tcp"]},
    "aurora-balaena": {"port_number": 33123, "protocols": ["tcp", "udp"]},
    "diamondport": {"port_number": 33331, "protocols": ["tcp", "udp"]},
    "dgi-serv": {"port_number": 33333, "protocols": ["tcp"]},
    "speedtrace": {"port_number": 33334, "protocols": ["tcp"]},
    "speedtrace-disc": {"port_number": 33334, "protocols": ["udp"]},
    "traceroute": {"port_number": 33434, "protocols": ["tcp", "udp"]},
    "mtrace": {"port_number": 33435, "protocols": ["udp"]},
    "snip-slave": {"port_number": 33656, "protocols": ["tcp", "udp"]},
    "digilent-adept": {"port_number": 33890, "protocols": ["tcp"]},
    "turbonote-2": {"port_number": 34249, "protocols": ["tcp", "udp"]},
    "p-net-local": {"port_number": 34378, "protocols": ["tcp", "udp"]},
    "p-net-remote": {"port_number": 34379, "protocols": ["tcp", "udp"]},
    "dhanalakshmi": {"port_number": 34567, "protocols": ["tcp"]},
    "edi_service": {"port_number": 34567, "protocols": ["udp"]},
    "profinet-rt": {"port_number": 34962, "protocols": ["tcp", "udp"]},
    "profinet-rtm": {"port_number": 34963, "protocols": ["tcp", "udp"]},
    "profinet-cm": {"port_number": 34964, "protocols": ["tcp", "udp"]},
    "ethercat": {"port_number": 34980, "protocols": ["tcp", "udp"]},
    "heathview": {"port_number": 35000, "protocols": ["tcp"]},
    "rt-viewer": {"port_number": 35001, "protocols": ["tcp", "udp"]},
    "rt-sound": {"port_number": 35002, "protocols": ["tcp"]},
    "rt-devicemapper": {"port_number": 35003, "protocols": ["tcp"]},
    "rt-classmanager": {"port_number": 35004, "protocols": ["tcp", "udp"]},
    "rt-labtracker": {"port_number": 35005, "protocols": ["tcp"]},
    "rt-helper": {"port_number": 35006, "protocols": ["tcp"]},
    "axio-disc": {"port_number": 35100, "protocols": ["tcp", "udp"]},
    "kitim": {"port_number": 35354, "protocols": ["tcp"]},
    "altova-lm": {"port_number": 35355, "protocols": ["tcp"]},
    "altova-lm-disc": {"port_number": 35355, "protocols": ["udp"]},
    "guttersnex": {"port_number": 35356, "protocols": ["tcp"]},
    "openstack-id": {"port_number": 35357, "protocols": ["tcp"]},
    "allpeers": {"port_number": 36001, "protocols": ["tcp", "udp"]},
    "wlcp": {"port_number": 36411, "protocols": ["udp"]},
    "s1-control": {"port_number": 36412, "protocols": ["sctp"]},
    "x2-control": {"port_number": 36422, "protocols": ["sctp"]},
    "slmap": {"port_number": 36423, "protocols": ["sctp"]},
    "nq-ap": {"port_number": 36424, "protocols": ["sctp"]},
    "m2ap": {"port_number": 36443, "protocols": ["sctp"]},
    "m3ap": {"port_number": 36444, "protocols": ["sctp"]},
    "xw-control": {"port_number": 36462, "protocols": ["sctp"]},
    "febooti-aw": {"port_number": 36524, "protocols": ["tcp"]},
    "observium-agent": {"port_number": 36602, "protocols": ["tcp"]},
    "mapx": {"port_number": 36700, "protocols": ["tcp"]},
    "kastenxpipe": {"port_number": 36865, "protocols": ["tcp", "udp"]},
    "3gpp-w1ap": {"port_number": 37472, "protocols": ["sctp"]},
    "neckar": {"port_number": 37475, "protocols": ["tcp", "udp"]},
    "gdrive-sync": {"port_number": 37483, "protocols": ["tcp"]},
    "eftp": {"port_number": 37601, "protocols": ["tcp"]},
    "unisys-eportal": {"port_number": 37654, "protocols": ["tcp", "udp"]},
    "ivs-database": {"port_number": 38000, "protocols": ["tcp"]},
    "ivs-insertion": {"port_number": 38001, "protocols": ["tcp"]},
    "cresco-control": {"port_number": 38002, "protocols": ["tcp"]},
    "crescoctrl-disc": {"port_number": 38002, "protocols": ["udp"]},
    "galaxy7-data": {"port_number": 38201, "protocols": ["tcp", "udp"]},
    "fairview": {"port_number": 38202, "protocols": ["tcp", "udp"]},
    "agpolicy": {"port_number": 38203, "protocols": ["tcp", "udp"]},
    "ng-control": {"port_number": 38412, "protocols": ["sctp"]},
    "xn-control": {"port_number": 38422, "protocols": ["sctp"]},
    "e1-interface": {"port_number": 38462, "protocols": ["sctp"]},
    "f1-control": {"port_number": 38472, "protocols": ["sctp"]},
    "psqlmws": {"port_number": 38638, "protocols": ["tcp"]},
    "sruth": {"port_number": 38800, "protocols": ["tcp"]},
    "secrmmsafecopya": {"port_number": 38865, "protocols": ["tcp"]},
    "vroa": {"port_number": 39063, "protocols": ["tcp"]},
    "turbonote-1": {"port_number": 39681, "protocols": ["tcp", "udp"]},
    "safetynetp": {"port_number": 40000, "protocols": ["tcp", "udp"]},
    "k-patentssensor": {"port_number": 40023, "protocols": ["udp"]},
    "sptx": {"port_number": 40404, "protocols": ["tcp"]},
    "cscp": {"port_number": 40841, "protocols": ["tcp", "udp"]},
    "csccredir": {"port_number": 40842, "protocols": ["tcp", "udp"]},
    "csccfirewall": {"port_number": 40843, "protocols": ["tcp", "udp"]},
    "ortec-disc": {"port_number": 40853, "protocols": ["udp"]},
    "fs-qos": {"port_number": 41111, "protocols": ["tcp", "udp"]},
    "tentacle": {"port_number": 41121, "protocols": ["tcp"]},
    "z-wave-s": {"port_number": 41230, "protocols": ["tcp", "udp"]},
    "crestron-cip": {"port_number": 41794, "protocols": ["tcp", "udp"]},
    "crestron-ctp": {"port_number": 41795, "protocols": ["tcp", "udp"]},
    "crestron-cips": {"port_number": 41796, "protocols": ["tcp"]},
    "crestron-ctps": {"port_number": 41797, "protocols": ["tcp"]},
    "candp": {"port_number": 42508, "protocols": ["tcp", "udp"]},
    "candrp": {"port_number": 42509, "protocols": ["tcp", "udp"]},
    "caerpc": {"port_number": 42510, "protocols": ["tcp", "udp"]},
    "curiosity": {"port_number": 42999, "protocols": ["tcp"]},
    "recvr-rc": {"port_number": 43000, "protocols": ["tcp"]},
    "recvr-rc-disc": {"port_number": 43000, "protocols": ["udp"]},
    "reachout": {"port_number": 43188, "protocols": ["tcp", "udp"]},
    "ndm-agent-port": {"port_number": 43189, "protocols": ["tcp", "udp"]},
    "ip-provision": {"port_number": 43190, "protocols": ["tcp", "udp"]},
    "noit-transport": {"port_number": 43191, "protocols": ["tcp"]},
    "shaperai": {"port_number": 43210, "protocols": ["tcp"]},
    "shaperai-disc": {"port_number": 43210, "protocols": ["udp"]},
    "hmip-routing": {"port_number": 43438, "protocols": ["udp"]},
    "eq3-update": {"port_number": 43439, "protocols": ["tcp"]},
    "eq3-config": {"port_number": 43439, "protocols": ["udp"]},
    "ew-mgmt": {"port_number": 43440, "protocols": ["tcp"]},
    "ew-disc-cmd": {"port_number": 43440, "protocols": ["udp"]},
    "ciscocsdb": {"port_number": 43441, "protocols": ["tcp", "udp"]},
    "z-wave-tunnel": {"port_number": 44123, "protocols": ["tcp"]},
    "pmcd": {"port_number": 44321, "protocols": ["tcp", "udp"]},
    "pmcdproxy": {"port_number": 44322, "protocols": ["tcp", "udp"]},
    "pmwebapi": {"port_number": 44323, "protocols": ["tcp"]},
    "cognex-dataman": {"port_number": 44444, "protocols": ["tcp"]},
    "acronis-backup": {"port_number": 44445, "protocols": ["tcp"]},
    "domiq": {"port_number": 44544, "protocols": ["udp"]},
    "rbr-debug": {"port_number": 44553, "protocols": ["tcp", "udp"]},
    "asihpi": {"port_number": 44600, "protocols": ["udp"]},
    "EtherNet-IP-2": {"port_number": 44818, "protocols": ["tcp", "udp"]},
    "EtherNet/IP-2": {"port_number": 44818, "protocols": ["tcp", "udp"]},
    "m3da": {"port_number": 44900, "protocols": ["tcp"]},
    "m3da-disc": {"port_number": 44900, "protocols": ["udp"]},
    "asmp": {"port_number": 45000, "protocols": ["tcp"]},
    "asmp-mon": {"port_number": 45000, "protocols": ["udp"]},
    "asmps": {"port_number": 45001, "protocols": ["tcp"]},
    "rs-status": {"port_number": 45002, "protocols": ["tcp"]},
    "synctest": {"port_number": 45045, "protocols": ["tcp"]},
    "invision-ag": {"port_number": 45054, "protocols": ["tcp", "udp"]},
    "witsnet": {"port_number": 45185, "protocols": ["tcp", "udp"]},
    "cloudcheck": {"port_number": 45514, "protocols": ["tcp"]},
    "cloudcheck-ping": {"port_number": 45514, "protocols": ["udp"]},
    "eba": {"port_number": 45678, "protocols": ["tcp", "udp"]},
    "dai-shell": {"port_number": 45824, "protocols": ["tcp"]},
    "qdb2service": {"port_number": 45825, "protocols": ["tcp", "udp"]},
    "ssr-servermgr": {"port_number": 45966, "protocols": ["tcp", "udp"]},
    "inedo": {"port_number": 46336, "protocols": ["tcp"]},
    "spremotetablet": {"port_number": 46998, "protocols": ["tcp"]},
    "mediabox": {"port_number": 46999, "protocols": ["tcp", "udp"]},
    "mbus": {"port_number": 47000, "protocols": ["tcp", "udp"]},
    "winrm": {"port_number": 47001, "protocols": ["tcp"]},
    "jvl-mactalk": {"port_number": 47100, "protocols": ["udp"]},
    "dbbrowse": {"port_number": 47557, "protocols": ["tcp", "udp"]},
    "directplaysrvr": {"port_number": 47624, "protocols": ["tcp", "udp"]},
    "ap": {"port_number": 47806, "protocols": ["tcp", "udp"]},
    "bacnet": {"port_number": 47808, "protocols": ["tcp", "udp"]},
    "presonus-ucnet": {"port_number": 47809, "protocols": ["udp"]},
    "nimcontroller": {"port_number": 48000, "protocols": ["tcp", "udp"]},
    "nimspooler": {"port_number": 48001, "protocols": ["tcp", "udp"]},
    "nimhub": {"port_number": 48002, "protocols": ["tcp", "udp"]},
    "nimgtw": {"port_number": 48003, "protocols": ["tcp", "udp"]},
    "nimbusdb": {"port_number": 48004, "protocols": ["tcp"]},
    "nimbusdbctrl": {"port_number": 48005, "protocols": ["tcp"]},
    "juka": {"port_number": 48048, "protocols": ["tcp"]},
    "3gpp-cbsp": {"port_number": 48049, "protocols": ["tcp"]},
    "weandsf": {"port_number": 48050, "protocols": ["tcp"]},
    "isnetserv": {"port_number": 48128, "protocols": ["tcp", "udp"]},
    "blp5": {"port_number": 48129, "protocols": ["tcp", "udp"]},
    "com-bardac-dw": {"port_number": 48556, "protocols": ["tcp", "udp"]},
    "iqobject": {"port_number": 48619, "protocols": ["tcp", "udp"]},
    "robotraconteur": {"port_number": 48653, "protocols": ["tcp", "udp"]},
    "matahari": {"port_number": 49000, "protocols": ["tcp"]},
    "nusrp": {"port_number": 49001, "protocols": ["tcp"]},
    "nusdp-disc": {"port_number": 49001, "protocols": ["udp"]},
    "inspider": {"port_number": 49150, "protocols": ["tcp"]},
}
