# Generated by Django 5.0.9 on 2024-10-11 19:45

import django.core.validators
import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('extras', '0121_customfield_related_object_filter'),
        ('ipam', '0073_charfield_null_choices'),
    ]

    operations = [
        migrations.CreateModel(
            name='VLANTranslationPolicy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('comments', models.TextField(blank=True)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'VLAN translation policy',
                'verbose_name_plural': 'VLAN translation policies',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='VLANTranslationRule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                (
                    'local_vid',
                    models.PositiveSmallIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(4094),
                        ]
                    ),
                ),
                (
                    'remote_vid',
                    models.PositiveSmallIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(4094),
                        ]
                    ),
                ),
                (
                    'policy',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='rules',
                        to='ipam.vlantranslationpolicy',
                    ),
                ),
                ('description', models.CharField(blank=True, max_length=200)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'VLAN translation rule',
                'ordering': (
                    'policy',
                    'local_vid',
                ),
            },
        ),
        migrations.AddConstraint(
            model_name='vlantranslationrule',
            constraint=models.UniqueConstraint(
                fields=('policy', 'local_vid'), name='ipam_vlantranslationrule_unique_policy_local_vid'
            ),
        ),
        migrations.AddConstraint(
            model_name='vlantranslationrule',
            constraint=models.UniqueConstraint(
                fields=('policy', 'remote_vid'), name='ipam_vlantranslationrule_unique_policy_remote_vid'
            ),
        ),
    ]
