# Generated by Django 5.2.4 on 2025-08-08 16:40

import django.db.models.deletion
import netbox.models.deletion
import taggit.managers
import utilities.json
import utilities.jsonschema
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0018_concrete_objecttype'),
        ('extras', '0131_concrete_objecttype'),
    ]

    operations = [
        migrations.CreateModel(
            name='ConfigContextProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                (
                    'custom_field_data',
                    models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder),
                ),
                ('data_path', models.CharField(blank=True, editable=False, max_length=1000)),
                ('auto_sync_enabled', models.BooleanField(default=False)),
                ('data_synced', models.DateTimeField(blank=True, editable=False, null=True)),
                ('comments', models.TextField(blank=True)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('schema', models.JSONField(blank=True, null=True, validators=[utilities.jsonschema.validate_schema])),
                (
                    'data_file',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='+',
                        to='core.datafile',
                    ),
                ),
                (
                    'data_source',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='+',
                        to='core.datasource',
                    ),
                ),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'config context profile',
                'verbose_name_plural': 'config context profiles',
                'ordering': ('name',),
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='profile',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name='config_contexts',
                to='extras.configcontextprofile',
            ),
        ),
    ]
