# LOCODE identifiers defined the UNECE
# Source: https://unece.org/trade/cefact/unlocode-code-list-country-and-territory
UN_LOCODE = (
    ('AD-ALV', 'AD-ALV (Andorra la Vella, Andorra)'),
    ('AD-CAN', 'AD-CAN (Canillo, Andorra)'),
    ('AD-ENC', 'AD-ENC (Encamp, Andorra)'),
    ('AD-ESC', 'AD-ESC (Escaldes-Engordany, Andorra)'),
    ('AD-EAC', 'AD-EAC (Escàs, Andorra)'),
    ('AD-FMO', 'AD-FMO (La Farga de Moles, Andorra)'),
    ('AD-LMA', 'AD-LMA (La Massana, Andorra)'),
    ('AD-ORD', 'AD-ORD (Ordino, Andorra)'),
    ('AD-PAS', 'AD-PAS (Pas de la Casa, Andorra)'),
    ('AD-SJL', 'AD-SJL (Sant Julià de Lòria, Andorra)'),
    ('AD-SCO', 'AD-SCO (Santa Coloma, Andorra)'),
    ('AE-ABU', 'AE-ABU (Abu al Bukhoosh, United Arab Emirates)'),
    ('AE-AUH', 'AE-AUH (Abu Dhabi, United Arab Emirates)'),
    ('AE-AMU', 'AE-AMU (Abu Musa, United Arab Emirates)'),
    ('AE-ARP', 'AE-ARP (Ahmed Bin Rashid Port, United Arab Emirates)'),
    ('AE-AJM', 'AE-AJM (Ajman, United Arab Emirates)'),
    ('AE-AAN', 'AE-AAN (Al Ain, United Arab Emirates)'),
    ('AE-ALB', 'AE-ALB (Al Barsha, United Arab Emirates)'),
    ('AE-DHF', 'AE-DHF (Al Dhafra, United Arab Emirates)'),
    ('AE-FJR', 'AE-FJR (Al Fujayrah, United Arab Emirates)'),
    ('AE-HAM', 'AE-HAM (Al Hamriyah, United Arab Emirates)'),
    ('AE-JAZ', 'AE-JAZ (Al Jazeera Port, United Arab Emirates)'),
    ('AE-AJP', 'AE-AJP (Al Jeer Port, United Arab Emirates)'),
    ('AE-DBI', 'AE-DBI (Al Mafraq, United Arab Emirates)'),
    ('AE-ALQ', 'AE-ALQ (Al Quoz, United Arab Emirates)'),
    ('AE-ALS', 'AE-ALS (Al Sufouh, United Arab Emirates)'),
    ('AE-RUW', 'AE-RUW (Ar Ruways, United Arab Emirates)'),
    ('AE-ARZ', 'AE-ARZ (Arzanah Island, United Arab Emirates)'),
    ('AE-DAS', 'AE-DAS (Das Island, United Arab Emirates)'),
    ('AE-DER', 'AE-DER (Deira, United Arab Emirates)'),
    ('AE-DBP', 'AE-DBP (Dibba, United Arab Emirates)'),
    ('AE-DXB', 'AE-DXB (Dubai, United Arab Emirates)'),
    ('AE-DWC', 'AE-DWC (Dubai World Central Apt, United Arab Emirates)'),
    ('AE-END', 'AE-END (Esnnad, United Arab Emirates)'),
    ('AE-FAT', 'AE-FAT (Fateh Terminal, United Arab Emirates)'),
    ('AE-FRP', 'AE-FRP (Free Port, United Arab Emirates)'),
    ('AE-HAB', 'AE-HAB (Habshan, United Arab Emirates)'),
    ('AE-HIL', 'AE-HIL (Hail, United Arab Emirates)'),
    ('AE-HZP', 'AE-HZP (Hamriya Free Zone Port, United Arab Emirates)'),
    ('AE-HSN', 'AE-HSN (Hassyan, United Arab Emirates)'),
    ('AE-HAT', 'AE-HAT (Hatta, United Arab Emirates)'),
    ('AE-HTL', 'AE-HTL (Hulaylah Terminal, United Arab Emirates)'),
    ('AE-IND', 'AE-IND (Indooroodilly, United Arab Emirates)'),
    ('AE-JEA', 'AE-JEA (Jebel Ali, United Arab Emirates)'),
    ('AE-QWE', 'AE-QWE (Jebel Ali Free Zone, United Arab Emirates)'),
    ('AE-JED', 'AE-JED (Jebel Dhanna, United Arab Emirates)'),
    ('AE-JYH', 'AE-JYH (Jumayrah, United Arab Emirates)'),
    ('AE-KLB', 'AE-KLB (Kalba, United Arab Emirates)'),
    ('AE-KHA', 'AE-KHA (Khalidia, United Arab Emirates)'),
    ('AE-KLF', 'AE-KLF (Khor al Fakkan, United Arab Emirates)'),
    ('AE-MAS', 'AE-MAS (Masfut, United Arab Emirates)'),
    ('AE-MKH', 'AE-MKH (Mina Khalid, United Arab Emirates)'),
    ('AE-KHL', 'AE-KHL (Mina Khalifa/Abu Dhabi, United Arab Emirates)'),
    ('AE-MRP', 'AE-MRP (Mina Rashid Port, United Arab Emirates)'),
    ('AE-MSA', 'AE-MSA (Mina Saqr, United Arab Emirates)'),
    ('AE-MZD', 'AE-MZD (Mina Zayed/Abu Dhabi, United Arab Emirates)'),
    ('AE-NHD', 'AE-NHD (Minhad, United Arab Emirates)'),
    ('AE-RFA', 'AE-RFA (Mirfa, United Arab Emirates)'),
    ('AE-MUB', 'AE-MUB (Mubarek Terminal, United Arab Emirates)'),
    ('AE-MBS', 'AE-MBS (Mubarras Island, United Arab Emirates)'),
    ('AE-FMZ', 'AE-FMZ (Musafa, United Arab Emirates)'),
    ('AE-AMF', 'AE-AMF (Mussafah, United Arab Emirates)'),
    ('AE-OFJ', 'AE-OFJ (Offshore Fujairah, United Arab Emirates)'),
    ('AE-PRA', 'AE-PRA (Port Rashid, United Arab Emirates)'),
    ('AE-RKP', 'AE-RKP (Rak Khor Port, United Arab Emirates)'),
    ('AE-RMC', 'AE-RMC (Rak Maritime City, United Arab Emirates)'),
    ('AE-RKT', 'AE-RKT (Ras al Khaimah, United Arab Emirates)'),
    ('AE-RAK', 'AE-RAK (Ras Al Khor, United Arab Emirates)'),
    ('AE-DUY', 'AE-DUY (Ras Zubbaya (Ras Dubayyah), United Arab Emirates)'),
    ('AE-REI', 'AE-REI (Reem Island, United Arab Emirates)'),
    ('AE-RWP', 'AE-RWP (Ruwais Port, United Arab Emirates)'),
    ('AE-SID', 'AE-SID (Sadiyat Island, United Arab Emirates)'),
    ('AE-SHJ', 'AE-SHJ (Sharjah, United Arab Emirates)'),
    ('AE-SIL', 'AE-SIL (Sila, United Arab Emirates)'),
    ('AE-SRT', 'AE-SRT (Steven Rock Terminal, United Arab Emirates)'),
    ('AE-SWE', 'AE-SWE (Swaihan, United Arab Emirates)'),
    ('AE-DUJ', 'AE-DUJ (The Palm Jumeirah, United Arab Emirates)'),
    ('AE-ULR', 'AE-ULR (Umm Al Nar, United Arab Emirates)'),
    ('AE-QIW', 'AE-QIW (Umm al Qaiwain, United Arab Emirates)'),
    ('AE-VHT', 'AE-VHT (Vopak Horizion Terminal, United Arab Emirates)'),
    ('AE-YAS', 'AE-YAS (Yas Island, United Arab Emirates)'),
    ('AE-ZUR', 'AE-ZUR (Zirku Island, United Arab Emirates)'),
    ('AF-ASH', 'AF-ASH (Ali Shirzayi, Urūzgān, Afghanistan)'),
    ('AF-BAG', 'AF-BAG (Bagram, Parwān, Afghanistan)'),
    ('AF-BIN', 'AF-BIN (Bagram, Parwān, Afghanistan)'),
    ('AF-BEP', 'AF-BEP (Bazar-E-Panjwai, Kandahār, Afghanistan)'),
    ('AF-BST', 'AF-BST (Bazar-E-Panjwai, Kandahār, Afghanistan)'),
    ('AF-CBN', 'AF-CBN (Camp Bastion, Helmand, Afghanistan)'),
    ('AF-CDW', 'AF-CDW (Camp Dwyer, Helmand, Afghanistan)'),
    ('AF-CLN', 'AF-CLN (Camp Leatherneck, Helmand, Afghanistan)'),
    ('AF-CSO', 'AF-CSO (Camp Salerno, Khōst, Afghanistan)'),
    ('AF-CWO', 'AF-CWO (Camp Wolverine, Zābul, Afghanistan)'),
    ('AF-CCN', 'AF-CCN (Camp Wolverine, Zābul, Afghanistan)'),
    ('AF-DAZ', 'AF-DAZ (Camp Wolverine, Zābul, Afghanistan)'),
    ('AF-DHD', 'AF-DHD (Dehdadi, Balkh, Afghanistan)'),
    ('AF-ISQ', 'AF-ISQ (Dehdadi, Balkh, Afghanistan)'),
    ('AF-FBD', 'AF-FBD (Dehdadi, Balkh, Afghanistan)'),
    ('AF-FAH', 'AF-FAH (Dehdadi, Balkh, Afghanistan)'),
    ('AF-FRO', 'AF-FRO (FOB Frontenac, Kandahār, Afghanistan)'),
    ('AF-RMD', 'AF-RMD (FOB Ramrod, Kandahār, Afghanistan)'),
    ('AF-SHK', 'AF-SHK (FOB Shank, Lōgar, Afghanistan)'),
    ('AF-GRG', 'AF-GRG (FOB Shank, Lōgar, Afghanistan)'),
    ('AF-GAR', 'AF-GAR (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-GZI', 'AF-GZI (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-HRT', 'AF-HRT (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-HEA', 'AF-HEA (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-JAA', 'AF-JAA (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-KBL', 'AF-KBL (Gardiz, Paktiyā, Afghanistan)'),
    ('AF-KMU', 'AF-KMU (Kamu, Kunaṟ, Afghanistan)'),
    ('AF-KDH', 'AF-KDH (Kamu, Kunaṟ, Afghanistan)'),
    ('AF-KHT', 'AF-KHT (Kamu, Kunaṟ, Afghanistan)'),
    ('AF-KHO', 'AF-KHO (Khowst, Kunaṟ, Afghanistan)'),
    ('AF-KWT', 'AF-KWT (Khowst, Paktiyā, Afghanistan)'),
    ('AF-KWH', 'AF-KWH (Khowst, Paktiyā, Afghanistan)'),
    ('AF-UND', 'AF-UND (Khowst, Paktiyā, Afghanistan)'),
    ('AF-KUR', 'AF-KUR (Khowst, Paktiyā, Afghanistan)'),
    ('AF-LAG', 'AF-LAG (Lashkar Gah, Helmand, Afghanistan)'),
    ('AF-MMZ', 'AF-MMZ (Lashkar Gah, Helmand, Afghanistan)'),
    ('AF-MWD', 'AF-MWD (Maiwand, Kandahār, Afghanistan)'),
    ('AF-MAS', 'AF-MAS (Maiwand, Kandahār, Afghanistan)'),
    ('AF-MZR', 'AF-MZR (Maiwand, Kandahār, Afghanistan)'),
    ('AF-MEH', 'AF-MEH (Mehtar Lam, Laghmān, Afghanistan)'),
    ('AF-MEY', 'AF-MEY (Meydan, Balkh, Afghanistan)'),
    ('AF-IMZ', 'AF-IMZ (Meydan, Balkh, Afghanistan)'),
    ('AF-ORG', 'AF-ORG (Orgun-E Kalan, Paktīkā, Afghanistan)'),
    ('AF-PSD', 'AF-PSD (Pasaband, Ghōr, Afghanistan)'),
    ('AF-PEC', 'AF-PEC (Pol-e Charkhi, Kābul, Afghanistan)'),
    ('AF-QYN', "AF-QYN (Qal'Eh-Ye Now, Bādghīs, Afghanistan)"),
    ('AF-LQN', "AF-LQN (Qal'Eh-Ye Now, Bādghīs, Afghanistan)"),
    ('AF-QLT', "AF-QLT (Qal'Eh-Ye Now, Bādghīs, Afghanistan)"),
    ('AF-QAM', "AF-QAM (Qal'Eh-Ye Now, Bādghīs, Afghanistan)"),
    ('AF-SBF', "AF-SBF (Qal'Eh-Ye Now, Bādghīs, Afghanistan)"),
    ('AF-SRO', 'AF-SRO (Sharona, Paktīkā, Afghanistan)'),
    ('AF-SGA', 'AF-SGA (Sharona, Paktīkā, Afghanistan)'),
    ('AF-SHE', 'AF-SHE (Sharona, Paktīkā, Afghanistan)'),
    ('AF-SDD', 'AF-SDD (Shindand, Herāt, Afghanistan)'),
    ('AF-SBK', 'AF-SBK (Spin Boldak, Kandahār, Afghanistan)'),
    ('AF-TQN', 'AF-TQN (Spin Boldak, Kandahār, Afghanistan)'),
    ('AF-TKO', 'AF-TKO (Tarin Kowt, Urūzgān, Afghanistan)'),
    ('AF-TII', 'AF-TII (Tarin Kowt, Urūzgān, Afghanistan)'),
    ('AF-TGH', 'AF-TGH (Tarin Kowt, Urūzgān, Afghanistan)'),
    ('AF-RKH', 'AF-RKH (Torkham, Nangarhār, Afghanistan)'),
    ('AF-TOW', 'AF-TOW (Towraghondi, Herāt, Afghanistan)'),
    ('AF-URN', 'AF-URN (Towraghondi, Herāt, Afghanistan)'),
    ('AF-URZ', 'AF-URZ (Towraghondi, Herāt, Afghanistan)'),
    ('AF-ZAJ', 'AF-ZAJ (Towraghondi, Herāt, Afghanistan)'),
    ('AF-ZHA', 'AF-ZHA (Zhari Dasht, Kandahār, Afghanistan)'),
    ('AG-ANU', 'AG-ANU (Antigua, Antigua and Barbuda)'),
    ('AG-BBQ', 'AG-BBQ (Barbuda, Antigua and Barbuda)'),
    ('AG-FAM', 'AG-FAM (Falmouth, Antigua and Barbuda)'),
    ('AG-PHM', 'AG-PHM (Parham, Antigua and Barbuda)'),
    ('AG-SJO', "AG-SJO (Saint John's, Antigua and Barbuda)"),
    ('AI-AXA', 'AI-AXA (Anguilla, Anguilla)'),
    ('AI-BLP', 'AI-BLP (Blowing Point, Anguilla)'),
    ('AI-CRH', 'AI-CRH (Crocus Hill, Anguilla)'),
    ('AI-MBB', 'AI-MBB (Meads Bay Beach, Anguilla)'),
    ('AI-RBY', 'AI-RBY (Road Bay, Anguilla)'),
    ('AI-SOM', 'AI-SOM (Sombrero, Anguilla)'),
    ('AI-FOR', 'AI-FOR (The Forest, Anguilla)'),
    ('AI-ROA', 'AI-ROA (The Road, Anguilla)'),
    ('AI-VAL', 'AI-VAL (The Valley, Anguilla)'),
    ('AI-WLL', 'AI-WLL (Wall Blake, Anguilla)'),
    ('AL-ARG', 'AL-ARG (Argyrokastro, Albania)'),
    ('AL-BRT', 'AL-BRT (Berat, Albania)'),
    ('AL-BQE', 'AL-BQE (Bulqizë, Albania)'),
    ('AL-BUT', 'AL-BUT (Butrint, Albania)'),
    ('AL-DRZ', 'AL-DRZ (Durrës, Albania)'),
    ('AL-NPP', 'AL-NPP (Elbasan, Albania)'),
    ('AL-FIE', 'AL-FIE (Fier, Albania)'),
    ('AL-FUS', 'AL-FUS (Fushe Arrez, Albania)'),
    ('AL-GOK', 'AL-GOK (Gjirokastër, Albania)'),
    ('AL-HMR', 'AL-HMR (Himare, Albania)'),
    ('AL-KRC', 'AL-KRC (Korçë, Albania)'),
    ('AL-KKU', 'AL-KKU (Kukës, Albania)'),
    ('AL-LZE', 'AL-LZE (Lezhe, Albania)'),
    ('AL-LUS', 'AL-LUS (Lushnjë, Albania)'),
    ('AL-MBR', 'AL-MBR (Mbreshtan, Albania)'),
    ('AL-MIL', 'AL-MIL (Milot, Albania)'),
    ('AL-ROM', 'AL-ROM (Romano Port, Albania)'),
    ('AL-SAR', 'AL-SAR (Sarandë, Albania)'),
    ('AL-SHK', 'AL-SHK (Shkoder, Albania)'),
    ('AL-SHZ', 'AL-SHZ (Shkozet, Albania)'),
    ('AL-SHG', 'AL-SHG (Shëngjin, Albania)'),
    ('AL-TEN', 'AL-TEN (Tenes, Albania)'),
    ('AL-TIA', 'AL-TIA (Tirana, Albania)'),
    ('AL-VOA', 'AL-VOA (Vlorë, Albania)'),
    ('AL-VOR', 'AL-VOR (Vore, Albania)'),
    ('AM-ABO', 'AM-ABO (Abovyan, Armenia)'),
    ('AM-AHU', 'AM-AHU (Akhuryan, Armenia)'),
    ('AM-A3A', 'AM-A3A (Aparan, Armenia)'),
    ('AM-ARG', 'AM-ARG (Aragatsotn, Armenia)'),
    ('AM-ARA', 'AM-ARA (Ararat, Armenia)'),
    ('AM-ARV', 'AM-ARV (Armavir, Armenia)'),
    ('AM-ASH', 'AM-ASH (Ashtarak, Armenia)'),
    ('AM-BRD', 'AM-BRD (Berd, Armenia)'),
    ('AM-BYU', 'AM-BYU (Byureghavan, Armenia)'),
    ('AM-DIL', 'AM-DIL (Dilijan, Armenia)'),
    ('AM-EZN', 'AM-EZN (Ecmiadzin, Armenia)'),
    ('AM-GRS', 'AM-GRS (Goris, Armenia)'),
    ('AM-LWN', 'AM-LWN (Gyumri, Armenia)'),
    ('AM-JER', 'AM-JER (Jermuk, Armenia)'),
    ('AM-KJN', 'AM-KJN (Kajaran, Armenia)'),
    ('AM-KPN', 'AM-KPN (Kapan, Armenia)'),
    ('AM-ARM', 'AM-ARM (Masis, Armenia)'),
    ('AM-MMA', 'AM-MMA (Mets Masrik, Armenia)'),
    ('AM-MTR', 'AM-MTR (Metsamor, Armenia)'),
    ('AM-RN4', 'AM-RN4 (Rind, Armenia)'),
    ('AM-SPI', 'AM-SPI (Spitak, Armenia)'),
    ('AM-VZR', 'AM-VZR (Vanadzor, Armenia)'),
    ('AM-VED', 'AM-VED (Vedi, Armenia)'),
    ('AM-EVN', 'AM-EVN (Yerevan, Armenia)'),
    ('AO-AZZ', 'AO-AZZ (Yerevan, Armenia)'),
    ('AO-ANL', 'AO-ANL (Yerevan, Armenia)'),
    ('AO-ARO', 'AO-ARO (Armada Olombendo FPSO, Zaire, Angola)'),
    ('AO-BAB', 'AO-BAB (Armada Olombendo FPSO, Zaire, Angola)'),
    ('AO-BDD', 'AO-BDD (Armada Olombendo FPSO, Zaire, Angola)'),
    ('AO-BDT', 'AO-BDT (Armada Olombendo FPSO, Zaire, Angola)'),
    ('AO-BEL', 'AO-BEL (Belas, Luanda, Angola)'),
    ('AO-BUG', 'AO-BUG (Belas, Luanda, Angola)'),
    ('AO-CAB', 'AO-CAB (Belas, Luanda, Angola)'),
    ('AO-CFF', 'AO-CFF (Belas, Luanda, Angola)'),
    ('AO-CNZ', 'AO-CNZ (Belas, Luanda, Angola)'),
    ('AO-KNP', 'AO-KNP (Belas, Luanda, Angola)'),
    ('AO-CPO', 'AO-CPO (Belas, Luanda, Angola)'),
    ('AO-CBT', 'AO-CBT (Belas, Luanda, Angola)'),
    ('AO-CAV', 'AO-CAV (Belas, Luanda, Angola)'),
    ('AO-PGI', 'AO-PGI (Belas, Luanda, Angola)'),
    ('AO-CLV', 'AO-CLV (Belas, Luanda, Angola)'),
    ('AO-CUI', 'AO-CUI (Belas, Luanda, Angola)'),
    ('AO-CTI', 'AO-CTI (Belas, Luanda, Angola)'),
    ('AO-DAL', 'AO-DAL (Belas, Luanda, Angola)'),
    ('AO-DRC', 'AO-DRC (Belas, Luanda, Angola)'),
    ('AO-DGR', 'AO-DGR (Belas, Luanda, Angola)'),
    ('AO-DUE', 'AO-DUE (Belas, Luanda, Angola)'),
    ('AO-ETN', 'AO-ETN (Belas, Luanda, Angola)'),
    ('AO-FBY', 'AO-FBY (Belas, Luanda, Angola)'),
    ('AO-FLT', 'AO-FLT (Belas, Luanda, Angola)'),
    ('AO-GIM', 'AO-GIM (Belas, Luanda, Angola)'),
    ('AO-GIR', 'AO-GIR (Belas, Luanda, Angola)'),
    ('AO-GPO', 'AO-GPO (Belas, Luanda, Angola)'),
    ('AO-NOV', 'AO-NOV (Belas, Luanda, Angola)'),
    ('AO-JMB', 'AO-JMB (Belas, Luanda, Angola)'),
    ('AO-KTI', 'AO-KTI (Belas, Luanda, Angola)'),
    ('AO-SVP', 'AO-SVP (Belas, Luanda, Angola)'),
    ('AO-KOT', 'AO-KOT (Belas, Luanda, Angola)'),
    ('AO-LAA', 'AO-LAA (Belas, Luanda, Angola)'),
    ('AO-LIE', 'AO-LIE (Belas, Luanda, Angola)'),
    ('AO-LOB', 'AO-LOB (Belas, Luanda, Angola)'),
    ('AO-LBT', 'AO-LBT (Belas, Luanda, Angola)'),
    ('AO-LAD', 'AO-LAD (Belas, Luanda, Angola)'),
    ('AO-UAL', 'AO-UAL (Belas, Luanda, Angola)'),
    ('AO-SDD', 'AO-SDD (Belas, Luanda, Angola)'),
    ('AO-LUC', 'AO-LUC (Belas, Luanda, Angola)'),
    ('AO-LUO', 'AO-LUO (Belas, Luanda, Angola)'),
    ('AO-LBZ', 'AO-LBZ (Belas, Luanda, Angola)'),
    ('AO-GGC', 'AO-GGC (Belas, Luanda, Angola)'),
    ('AO-LZM', 'AO-LZM (Belas, Luanda, Angola)'),
    ('AO-SSY', 'AO-SSY (Belas, Luanda, Angola)'),
    ('AO-MEG', 'AO-MEG (Belas, Luanda, Angola)'),
    ('AO-MLO', 'AO-MLO (Belas, Luanda, Angola)'),
    ('AO-MAL', 'AO-MAL (Belas, Luanda, Angola)'),
    ('AO-MDZ', 'AO-MDZ (Maquela Do Zombo, Uíge, Angola)'),
    ('AO-MTL', 'AO-MTL (Matala, Huíla, Angola)'),
    ('AO-SPP', 'AO-SPP (Matala, Huíla, Angola)'),
    ('AO-MOS', 'AO-MOS (Matala, Huíla, Angola)'),
    ('AO-NDF', "AO-NDF (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-NRQ', "AO-NRQ (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-ARZ', "AO-ARZ (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-NTO', "AO-NTO (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-MSZ', "AO-MSZ (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-GXG', "AO-GXG (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-NZA', "AO-NZA (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-NQI', "AO-NQI (N'dalatando, Cuanza‐Norte, Angola)"),
    ('AO-NGV', 'AO-NGV (Ondjiva, Cunene, Angola)'),
    ('AO-VPE', 'AO-VPE (Ondjiva, Cunene, Angola)'),
    ('AO-PAT', 'AO-PAT (Ondjiva, Cunene, Angola)'),
    ('AO-PAZ', 'AO-PAZ (Ondjiva, Cunene, Angola)'),
    ('AO-PLE', 'AO-PLE (Ondjiva, Cunene, Angola)'),
    ('AO-PBN', 'AO-PBN (Ondjiva, Cunene, Angola)'),
    ('AO-PSA', 'AO-PSA (Ondjiva, Cunene, Angola)'),
    ('AO-RSN', 'AO-RSN (Ondjiva, Cunene, Angola)'),
    ('AO-STC', 'AO-STC (Santa Clara, Uíge, Angola)'),
    ('AO-VHC', 'AO-VHC (Santa Clara, Uíge, Angola)'),
    ('AO-SBT', 'AO-SBT (Santa Clara, Uíge, Angola)'),
    ('AO-STL', 'AO-STL (Santa Clara, Uíge, Angola)'),
    ('AO-SZA', 'AO-SZA (Santa Clara, Uíge, Angola)'),
    ('AO-SOQ', 'AO-SOQ (Santa Clara, Uíge, Angola)'),
    ('AO-NDD', 'AO-NDD (Santa Clara, Uíge, Angola)'),
    ('AO-TAK', 'AO-TAK (Santa Clara, Uíge, Angola)'),
    ('AO-UGO', 'AO-UGO (Santa Clara, Uíge, Angola)'),
    ('AO-VNA', 'AO-VNA (Viana, Luanda, Angola)'),
    ('AO-CEO', 'AO-CEO (Viana, Luanda, Angola)'),
    ('AO-XGN', 'AO-XGN (Viana, Luanda, Angola)'),
    ('AQ-ABA', 'AQ-ABA (Aboa, Antarctica)'),
    ('AQ-AMS', 'AQ-AMS (Amundsen-Scott, Antarctica)'),
    ('AQ-ARC', 'AQ-ARC (Arctowski, Antarctica)'),
    ('AQ-ART', 'AQ-ART (Artigas, Antarctica)'),
    ('AQ-APT', 'AQ-APT (Arturo Prat, Antarctica)'),
    ('AQ-BEL', 'AQ-BEL (Belgrano II, Antarctica)'),
    ('AQ-BHN', 'AQ-BHN (Bellingshausen, Antarctica)'),
    ('AQ-CAS', 'AQ-CAS (Casey Station, Antarctica)'),
    ('AQ-CFZ', 'AQ-CFZ (Comandante Ferraz, Antarctica)'),
    ('AQ-CON', 'AQ-CON (Concordia, Antarctica)'),
    ('AQ-DAV', 'AQ-DAV (Davis Station, Antarctica)'),
    ('AQ-DMF', 'AQ-DMF (Dome Fuji, Antarctica)'),
    ('AQ-DRZ', 'AQ-DRZ (Druzhnaya 4, Antarctica)'),
    ('AQ-DDU', "AQ-DDU (Dumont d'Urville Station, Antarctica)"),
    ('AQ-ESC', 'AQ-ESC (Escudero, Antarctica)'),
    ('AQ-ESP', 'AQ-ESP (Esperanza, Antarctica)'),
    ('AQ-GDC', 'AQ-GDC (Gabriel de Castilla, Antarctica)'),
    ('AQ-OHG', "AQ-OHG (General Bernardo O'higgins, Antarctica)"),
    ('AQ-GWL', 'AQ-GWL (Great Wall, Antarctica)'),
    ('AQ-HLY', 'AQ-HLY (Halley, Antarctica)'),
    ('AQ-JBS', 'AQ-JBS (Jang Bogo Station, Antarctica)'),
    ('AQ-JCP', 'AQ-JCP (Juan Carlos Primero, Antarctica)'),
    ('AQ-JUB', 'AQ-JUB (Jubany, Antarctica)'),
    ('AQ-KSG', 'AQ-KSG (King Sejong, Antarctica)'),
    ('AQ-KHN', 'AQ-KHN (Kohnen, Antarctica)'),
    ('AQ-LAW', 'AQ-LAW (Law Base, Antarctica)'),
    ('AQ-MTR', 'AQ-MTR (Maitri, Antarctica)'),
    ('AQ-MRB', 'AQ-MRB (Marambio, Antarctica)'),
    ('AQ-MZU', 'AQ-MZU (Mario Zucchelli, Antarctica)'),
    ('AQ-MAW', 'AQ-MAW (Mawson Station, Antarctica)'),
    ('AQ-MCM', 'AQ-MCM (McMurdo, Antarctica)'),
    ('AQ-MIR', 'AQ-MIR (Mirny, Antarctica)'),
    ('AQ-NEU', 'AQ-NEU (Neumayer, Antarctica)'),
    ('AQ-NOV', 'AQ-NOV (Novolazarevskaya, Antarctica)'),
    ('AQ-ORC', 'AQ-ORC (Orcadas, Antarctica)'),
    ('AQ-PLM', 'AQ-PLM (Palmer, Antarctica)'),
    ('AQ-PFS', 'AQ-PFS (Port Foster, Antarctica)'),
    ('AQ-PRO', 'AQ-PRO (Progress, Antarctica)'),
    ('AQ-ROT', 'AQ-ROT (Rothera, Antarctica)'),
    ('AQ-SMT', 'AQ-SMT (San Martín, Antarctica)'),
    ('AQ-SNA', 'AQ-SNA (SANAE IV, Antarctica)'),
    ('AQ-SBA', 'AQ-SBA (Scott Base, Antarctica)'),
    ('AQ-SGN', 'AQ-SGN (Signy, Antarctica)'),
    ('AQ-SYW', 'AQ-SYW (Syowa, Antarctica)'),
    ('AQ-TNM', 'AQ-TNM (Teniente R. Marsh, Antarctica)'),
    ('AQ-TOR', 'AQ-TOR (Tor, Antarctica)'),
    ('AQ-TRL', 'AQ-TRL (Troll, Antarctica)'),
    ('AQ-VKY', 'AQ-VKY (Vernadsky, Antarctica)'),
    ('AQ-VOS', 'AQ-VOS (Vostok, Antarctica)'),
    ('AQ-WSA', 'AQ-WSA (Wasa, Antarctica)'),
    ('AQ-ZGN', 'AQ-ZGN (Zhongshan, Antarctica)'),
    ('AR-ABA', 'AR-ABA (Zhongshan, Antarctica)'),
    ('AR-ACA', 'AR-ACA (Acaraguá, Misiones, Argentina)'),
    ('AR-ACS', 'AR-ACS (Acassuso, Buenos Aires, Argentina)'),
    ('AR-AVD', 'AR-AVD (Acevedo, Buenos Aires, Argentina)'),
    ('AR-AC5', 'AR-AC5 (Acheral, Tucumán, Argentina)'),
    ('AR-AMA', 'AR-AMA (Adelia María, Córdoba, Argentina)'),
    ('AR-GEO', 'AR-GEO (Agrelo, Mendoza, Argentina)'),
    ('AR-AGS', 'AR-AGS (Aguilares, Tucumán, Argentina)'),
    ('AR-AIM', 'AR-AIM (Aimogasta, La Rioja, Argentina)'),
    ('AR-ALN', 'AR-ALN (Albardón, San Juan, Argentina)'),
    ('AR-ALI', 'AR-ALI (Alberti, Buenos Aires, Argentina)'),
    ('AR-AEA', 'AR-AEA (Aldea Escolar, Chubut, Argentina)'),
    ('AR-ADS', 'AR-ADS (Alderetes, Tucumán, Argentina)'),
    ('AR-ALL', 'AR-ALL (Allen, Río Negro, Argentina)'),
    ('AR-ALE', 'AR-ALE (Almafuerte, Córdoba, Argentina)'),
    ('AR-ALS', 'AR-ALS (Almafuerte, Córdoba, Argentina)'),
    ('AR-ASL', 'AR-ASL (Alto de Sierra, San Juan, Argentina)'),
    ('AR-ARR', 'AR-ARR (Alto Río Senguerr, Chubut, Argentina)'),
    ('AR-LTV', 'AR-LTV (Alto Verde, Mendoza, Argentina)'),
    ('AR-ALZ', 'AR-ALZ (Alvarez, Santa Fe, Argentina)'),
    ('AR-AVR', 'AR-AVR (Alvear, Santa Fe, Argentina)'),
    ('AR-ANC', 'AR-ANC (Ancón, Buenos Aires, Argentina)'),
    ('AR-ADC', 'AR-ADC (Andacollo, Neuquén, Argentina)'),
    ('AR-AND', 'AR-AND (Andalgalá, Catamarca, Argentina)'),
    ('AR-ANO', 'AR-ANO (Angaco, San Juan, Argentina)'),
    ('AR-ASA', 'AR-ASA (Apolinario Saravia, Salta, Argentina)'),
    ('AR-APO', 'AR-APO (Apostoles, Misiones, Argentina)'),
    ('AR-ARN', 'AR-ARN (Aranguren, Entre Ríos, Argentina)'),
    ('AR-ARI', 'AR-ARI (Arias, Córdoba, Argentina)'),
    ('AR-AVO', 'AR-AVO (Aristóbulo del Valle, Misiones, Argentina)'),
    ('AR-ARG', 'AR-ARG (Armstrong, Santa Fe, Argentina)'),
    ('AR-ACF', 'AR-ACF (Arrecifes, Buenos Aires, Argentina)'),
    ('AR-AYO', 'AR-AYO (Arroyito, Córdoba, Argentina)'),
    ('AR-ASO', 'AR-ASO (Arroyito, Córdoba, Argentina)'),
    ('AR-AST', 'AR-AST (Arroyito, Córdoba, Argentina)'),
    ('AR-ATU', 'AR-ATU (Atucha, Buenos Aires, Argentina)'),
    ('AR-AVE', 'AR-AVE (Atucha, Buenos Aires, Argentina)'),
    ('AR-AVS', 'AR-AVS (Avellaneda, Santa Fe, Argentina)'),
    ('AR-AZU', 'AR-AZU (Azul, Buenos Aires, Argentina)'),
    ('AR-ANA', 'AR-ANA (Añatuya, Santiago del Estero, Argentina)'),
    ('AR-ALO', 'AR-ALO (Añelo, Neuquén, Argentina)'),
    ('AR-BSB', 'AR-BSB (Bahia San Blas, Buenos Aires, Argentina)'),
    ('AR-BHI', 'AR-BHI (Bahía Blanca, Buenos Aires, Argentina)'),
    ('AR-BAJ', 'AR-BAJ (Bajo Grande, La Rioja, Argentina)'),
    ('AR-BHO', 'AR-BHO (Bajo Hondo, Buenos Aires, Argentina)'),
    ('AR-BCA', 'AR-BCA (Balcarce, Buenos Aires, Argentina)'),
    ('AR-BES', 'AR-BES (Ballesteros, Córdoba, Argentina)'),
    ('AR-BDR', 'AR-BDR (Banda del Río Salí, Tucumán, Argentina)'),
    ('AR-BAD', 'AR-BAD (Banfield, Buenos Aires, Argentina)'),
    ('AR-BAR', 'AR-BAR (Baradero, Buenos Aires, Argentina)'),
    ('AR-BAS', 'AR-BAS (Barrancas, Mendoza, Argentina)'),
    ('AR-BQS', 'AR-BQS (Barranqueras, Chaco, Argentina)'),
    ('AR-BAL', 'AR-BAL (Barreal, San Juan, Argentina)'),
    ('AR-BTN', 'AR-BTN (Barrio Batan, Buenos Aires, Argentina)'),
    ('AR-BMS', 'AR-BMS (Barrio Marquez de Sobremonte, Córdoba, Argentina)'),
    ('AR-BEC', 'AR-BEC (Beccar, Buenos Aires, Argentina)'),
    ('AR-BVL', 'AR-BVL (Bell Ville, Córdoba, Argentina)'),
    ('AR-BEL', 'AR-BEL (Bella Vista, Buenos Aires, Argentina)'),
    ('AR-BVA', 'AR-BVA (Bella Vista, Tucumán, Argentina)'),
    ('AR-BVC', 'AR-BVC (Bella Vista, Corrientes, Argentina)'),
    ('AR-BDE', 'AR-BDE (Belén de Escobar, Buenos Aires, Argentina)'),
    ('AR-BVZ', 'AR-BVZ (Benavidez, Buenos Aires, Argentina)'),
    ('AR-BEA', 'AR-BEA (Bengolea, Córdoba, Argentina)'),
    ('AR-BJR', 'AR-BJR (Benito Juarez, Buenos Aires, Argentina)'),
    ('AR-BER', 'AR-BER (Berazategui, Buenos Aires, Argentina)'),
    ('AR-BRN', 'AR-BRN (Bernal, Buenos Aires, Argentina)'),
    ('AR-BOL', 'AR-BOL (Bombal, Santa Fe, Argentina)'),
    ('AR-BOU', 'AR-BOU (Boulogne, Buenos Aires, Argentina)'),
    ('AR-BON', 'AR-BON (Bowen, Mendoza, Argentina)'),
    ('AR-BGO', 'AR-BGO (Bragado, Buenos Aires, Argentina)'),
    ('AR-BRD', 'AR-BRD (Brandsen, Buenos Aires, Argentina)'),
    ('AR-BUE', 'AR-BUE (Brandsen, Buenos Aires, Argentina)'),
    ('AR-BUU', 'AR-BUU (Burruyacú, Tucumán, Argentina)'),
    ('AR-BUR', 'AR-BUR (Burzaco, Buenos Aires, Argentina)'),
    ('AR-CAB', 'AR-CAB (Caballito, Buenos Aires, Argentina)'),
    ('AR-CSA', 'AR-CSA (Caballito, Buenos Aires, Argentina)'),
    ('AR-CFY', 'AR-CFY (Cafayate, Salta, Argentina)'),
    ('AR-CAS', 'AR-CAS (Calabacillas, Entre Ríos, Argentina)'),
    ('AR-CLC', 'AR-CLC (Caleta Córdoba, Córdoba, Argentina)'),
    ('AR-CVI', 'AR-CVI (Caleta Olivia, Santa Cruz, Argentina)'),
    ('AR-CMP', 'AR-CMP (Campana, Buenos Aires, Argentina)'),
    ('AR-CGO', 'AR-CGO (Campo Grande, Misiones, Argentina)'),
    ('AR-CLO', 'AR-CLO (Campo Largo, Chaco, Argentina)'),
    ('AR-CQO', 'AR-CQO (Campo Quijano, Salta, Argentina)'),
    ('AR-CRO', 'AR-CRO (Campo Ramón, Misiones, Argentina)'),
    ('AR-MPO', 'AR-MPO (Campo Salto, Salta, Argentina)'),
    ('AR-CSO', 'AR-CSO (Campo Santo, Salta, Argentina)'),
    ('AR-CVO', 'AR-CVO (Campo Viera, Misiones, Argentina)'),
    ('AR-CRL', 'AR-CRL (Canada Rosquin, Santa Fe, Argentina)'),
    ('AR-CNL', 'AR-CNL (Canals, Córdoba, Argentina)'),
    ('AR-CDL', 'AR-CDL (Candelaria, Misiones, Argentina)'),
    ('AR-CNN', 'AR-CNN (Canning, Buenos Aires, Argentina)'),
    ('AR-CAE', 'AR-CAE (Canuelas, Buenos Aires, Argentina)'),
    ('AR-CDS', 'AR-CDS (Capilla del Señor, Buenos Aires, Argentina)'),
    ('AR-CBZ', 'AR-CBZ (Capilla del Señor, Buenos Aires, Argentina)'),
    ('AR-CSN', 'AR-CSN (Capitán Sarmiento, Buenos Aires, Argentina)'),
    ('AR-CAA', 'AR-CAA (Carcaraña, Santa Fe, Argentina)'),
    ('AR-CCB', 'AR-CCB (Carlos Casares, Buenos Aires, Argentina)'),
    ('AR-CAN', 'AR-CAN (Carmen de Areco, Buenos Aires, Argentina)'),
    ('AR-CPG', 'AR-CPG (Carmen de Patagones, Buenos Aires, Argentina)'),
    ('AR-CDN', 'AR-CDN (Carmen Del Sauce, Santa Fe, Argentina)'),
    ('AR-CAO', 'AR-CAO (Carnerillo, Córdoba, Argentina)'),
    ('AR-ORE', 'AR-ORE (Caseros, Buenos Aires, Argentina)'),
    ('AR-CSL', 'AR-CSL (Casilda, Santa Fe, Argentina)'),
    ('AR-CTL', 'AR-CTL (Castelar, Buenos Aires, Argentina)'),
    ('AR-CTC', 'AR-CTC (Catamarca, Catamarca, Argentina)'),
    ('AR-CAT', 'AR-CAT (Catinzaco, La Rioja, Argentina)'),
    ('AR-CTO', 'AR-CTO (Catrilo, La Pampa, Argentina)'),
    ('AR-CUE', 'AR-CUE (Caucete, San Juan, Argentina)'),
    ('AR-CVH', 'AR-CVH (Caviahue, Neuquén, Argentina)'),
    ('AR-CGA', 'AR-CGA (Cañada de Gómez, Santa Fe, Argentina)'),
    ('AR-CEN', 'AR-CEN (Centenario, Buenos Aires, Argentina)'),
    ('AR-CRR', 'AR-CRR (Ceres, Santa Fe, Argentina)'),
    ('AR-CAL', 'AR-CAL (Cerro Azul, Misiones, Argentina)'),
    ('AR-CVP', 'AR-CVP (Cevil Pozo, Tucumán, Argentina)'),
    ('AR-CRA', 'AR-CRA (Cevil Redondo, Tucumán, Argentina)'),
    ('AR-CSS', 'AR-CSS (Chabás, Santa Fe, Argentina)'),
    ('AR-CCO', 'AR-CCO (Chacabuco, Buenos Aires, Argentina)'),
    ('AR-CDC', 'AR-CDC (Chacras De Coria, Mendoza, Argentina)'),
    ('AR-CHA', 'AR-CHA (Chajarí, Entre Ríos, Argentina)'),
    ('AR-CNT', 'AR-CNT (Charata, Chaco, Argentina)'),
    ('AR-CHS', 'AR-CHS (Chascomus, Buenos Aires, Argentina)'),
    ('AR-CHO', 'AR-CHO (Chilecito, La Rioja, Argentina)'),
    ('AR-CBS', 'AR-CBS (Chimbas, San Juan, Argentina)'),
    ('AR-CPY', 'AR-CPY (Chimpay, Río Negro, Argentina)'),
    ('AR-CVY', 'AR-CVY (Chivilcoy, Buenos Aires, Argentina)'),
    ('AR-CHL', 'AR-CHL (Choele Choel, Río Negro, Argentina)'),
    ('AR-HOS', 'AR-HOS (Chos Malal, Neuquén, Argentina)'),
    ('AR-CST', 'AR-CST (Cinco Saltos, Río Negro, Argentina)'),
    ('AR-CPA', 'AR-CPA (Cipoletti, Río Negro, Argentina)'),
    ('AR-CYB', 'AR-CYB (City Bell, Buenos Aires, Argentina)'),
    ('AR-EVA', 'AR-EVA (Ciudad Evita, Buenos Aires, Argentina)'),
    ('AR-CIU', 'AR-CIU (Ciudadela, Buenos Aires, Argentina)'),
    ('AR-CLN', 'AR-CLN (Classon, Santa Fe, Argentina)'),
    ('AR-CLX', 'AR-CLX (Clorinda, La Rioja, Argentina)'),
    ('AR-CZO', 'AR-CZO (Colazo, Córdoba, Argentina)'),
    ('AR-CRY', 'AR-CRY (Colonia Caroya, Córdoba, Argentina)'),
    ('AR-CCT', 'AR-CCT (Colonia Catriel, Río Negro, Argentina)'),
    ('AR-OLN', 'AR-OLN (Colonia Sarmiento, Chubut, Argentina)'),
    ('AR-COL', 'AR-COL (Colón, Entre Ríos, Argentina)'),
    ('AR-COO', 'AR-COO (Colón, Entre Ríos, Argentina)'),
    ('AR-CRD', 'AR-CRD (Comodoro Rivadavia, Chubut, Argentina)'),
    ('AR-COS', 'AR-COS (Concepcion de la Sierra, Misiones, Argentina)'),
    ('AR-CON', 'AR-CON (Concepción, Corrientes, Argentina)'),
    ('AR-COU', 'AR-COU (Concepción del Uruguay, Entre Ríos, Argentina)'),
    ('AR-CCP', 'AR-CCP (Conceptión, Tucumán, Argentina)'),
    ('AR-COC', 'AR-COC (Concordia, Entre Ríos, Argentina)'),
    ('AR-CMG', 'AR-CMG (Contralmirante Martín Guerrico, Río Negro, Argentina)'),
    ('AR-IQO', 'AR-IQO (Coquimbito, Mendoza, Argentina)'),
    ('AR-COA', 'AR-COA (Coronda, Santa Fe, Argentina)'),
    ('AR-CSZ', 'AR-CSZ (Coronel Suarez, Buenos Aires, Argentina)'),
    ('AR-CNQ', 'AR-CNQ (Corrientes, Corrientes, Argentina)'),
    ('AR-CDA', 'AR-CDA (Costa de Araujo, Mendoza, Argentina)'),
    ('AR-CEO', 'AR-CEO (Crespo, Entre Ríos, Argentina)'),
    ('AR-CAZ', 'AR-CAZ (Cruz Alta, Córdoba, Argentina)'),
    ('AR-CDP', 'AR-CDP (Cruz De Piedra, Mendoza, Argentina)'),
    ('AR-CDE', 'AR-CDE (Cruz del Eje, Córdoba, Argentina)'),
    ('AR-CNO', 'AR-CNO (Cuadro Nacional, Mendoza, Argentina)'),
    ('AR-CUA', 'AR-CUA (Cuatreros/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-UZU', 'AR-UZU (Curuzú Cuatiá, Corrientes, Argentina)'),
    ('AR-CUT', 'AR-CUT (Cutral-Có, Neuquén, Argentina)'),
    ('AR-COR', 'AR-COR (Córdoba, Córdoba, Argentina)'),
    ('AR-DIX', 'AR-DIX (Daireaux, Buenos Aires, Argentina)'),
    ('AR-DGU', 'AR-DGU (Del Guazu, Entre Ríos, Argentina)'),
    ('AR-ADV', 'AR-ADV (Del Viso, Buenos Aires, Argentina)'),
    ('AR-DME', 'AR-DME (Diamante, Río Negro, Argentina)'),
    ('AR-DKS', 'AR-DKS (Diamante, Río Negro, Argentina)'),
    ('AR-DSU', 'AR-DSU (Dock Sur, Buenos Aires, Argentina)'),
    ('AR-DCU', 'AR-DCU (Don Torcuato, Buenos Aires, Argentina)'),
    ('AR-DOR', 'AR-DOR (Dorrego, Mendoza, Argentina)'),
    ('AR-EHL', 'AR-EHL (El Bolsón, Río Negro, Argentina)'),
    ('AR-ELB', 'AR-ELB (El Bolsón, Catamarca, Argentina)'),
    ('AR-EBO', 'AR-EBO (El Bordo, Salta, Argentina)'),
    ('AR-FTE', 'AR-FTE (El Calafate, Santa Cruz, Argentina)'),
    ('AR-JEC', 'AR-JEC (El Carril, Salta, Argentina)'),
    ('AR-EMX', 'AR-EMX (El Maitén, Chubut, Argentina)'),
    ('AR-EPA', 'AR-EPA (El Palomar, Buenos Aires, Argentina)'),
    ('AR-ELP', 'AR-ELP (El Plumerillo, Mendoza, Argentina)'),
    ('AR-ETP', 'AR-ETP (El Talar de Pacheco, Buenos Aires, Argentina)'),
    ('AR-ETL', 'AR-ETL (El Trébol, Santa Fe, Argentina)'),
    ('AR-ELO', 'AR-ELO (Eldorado, Misiones, Argentina)'),
    ('AR-ZAI', 'AR-ZAI (Embarcacíon, Salta, Argentina)'),
    ('AR-EEA', 'AR-EEA (Ensenada, Buenos Aires, Argentina)'),
    ('AR-EPL', 'AR-EPL (Espeleta, Buenos Aires, Argentina)'),
    ('AR-ESP', 'AR-ESP (Esperanza, Santa Fe, Argentina)'),
    ('AR-EQS', 'AR-EQS (Esquel, Chubut, Argentina)'),
    ('AR-ESE', 'AR-ESE (Esteban Echeverría, Buenos Aires, Argentina)'),
    ('AR-JTR', 'AR-JTR (Etruria, Córdoba, Argentina)'),
    ('AR-EBA', 'AR-EBA (Eugenio Bustos, Mendoza, Argentina)'),
    ('AR-EZA', 'AR-EZA (Ezeiza, Buenos Aires, Argentina)'),
    ('AR-FAM', 'AR-FAM (Famaillá, Tucumán, Argentina)'),
    ('AR-FEN', 'AR-FEN (Federación, Entre Ríos, Argentina)'),
    ('AR-FER', 'AR-FER (Fernández, Santiago del Estero, Argentina)'),
    ('AR-FRR', 'AR-FRR (Ferreyra, Córdoba, Argentina)'),
    ('AR-FVB', 'AR-FVB (Florencio Varela, Buenos Aires, Argentina)'),
    ('AR-FLO', 'AR-FLO (Florida, Buenos Aires, Argentina)'),
    ('AR-FMA', 'AR-FMA (Formosa, Formosa, Argentina)'),
    ('AR-FRK', 'AR-FRK (Franck, Santa Fe, Argentina)'),
    ('AR-FLB', 'AR-FLB (Fray Luis A. Beltrán, Santa Fe, Argentina)'),
    ('AR-FBE', 'AR-FBE (Fray Luis Beltran, Mendoza, Argentina)'),
    ('AR-FRY', 'AR-FRY (Freyre, Córdoba, Argentina)'),
    ('AR-FRT', 'AR-FRT (Frontera, Córdoba, Argentina)'),
    ('AR-XLM', 'AR-XLM (Fuentes, Santa Fe, Argentina)'),
    ('AR-FNS', 'AR-FNS (Funes, Santa Fe, Argentina)'),
    ('AR-GRU', 'AR-GRU (Garupá, Misiones, Argentina)'),
    ('AR-GAR', 'AR-GAR (Garín, Buenos Aires, Argentina)'),
    ('AR-GVA', 'AR-GVA (General Alvear, Mendoza, Argentina)'),
    ('AR-GBE', 'AR-GBE (General Belgrano, Buenos Aires, Argentina)'),
    ('AR-GCA', 'AR-GCA (General Cabrera, Córdoba, Argentina)'),
    ('AR-GDL', 'AR-GDL (General Deheza, Córdoba, Argentina)'),
    ('AR-XSA', 'AR-XSA (General Enrique Godoy, Río Negro, Argentina)'),
    ('AR-NES', 'AR-NES (General Enrique Mosconi, Salta, Argentina)'),
    ('AR-GDG', 'AR-GDG (General Gutiérrez, Mendoza, Argentina)'),
    ('AR-GGL', 'AR-GGL (General Güemes, Salta, Argentina)'),
    ('AR-GLS', 'AR-GLS (General Lagos, Santa Fe, Argentina)'),
    ('AR-GLV', 'AR-GLV (General Lavalle, Buenos Aires, Argentina)'),
    ('AR-GMA', 'AR-GMA (General Madariaga, Buenos Aires, Argentina)'),
    ('AR-GPC', 'AR-GPC (General Pacheco, Buenos Aires, Argentina)'),
    ('AR-GPO', 'AR-GPO (General Pico, La Pampa, Argentina)'),
    ('AR-GRM', 'AR-GRM (General Ramírez, Entre Ríos, Argentina)'),
    ('AR-GNR', 'AR-GNR (General Roca, Río Negro, Argentina)'),
    ('AR-GRD', 'AR-GRD (General Rodríguez, Buenos Aires, Argentina)'),
    ('AR-VGS', 'AR-VGS (General Villegas, Buenos Aires, Argentina)'),
    ('AR-JGR', 'AR-JGR (Gerli, Buenos Aires, Argentina)'),
    ('AR-GOB', 'AR-GOB (Gobernador Benegas, Mendoza, Argentina)'),
    ('AR-VLV', 'AR-VLV (Gobernador Crespo, Santa Fe, Argentina)'),
    ('AR-GGS', 'AR-GGS (Gobernador Gregores, Santa Cruz, Argentina)'),
    ('AR-GRC', 'AR-GRC (Gobernador Roca, Misiones, Argentina)'),
    ('AR-GCR', 'AR-GCR (Godoy Cruz, Mendoza, Argentina)'),
    ('AR-GOC', 'AR-GOC (González Catán, Buenos Aires, Argentina)'),
    ('AR-GOD', 'AR-GOD (Gowland, Buenos Aires, Argentina)'),
    ('AR-OYA', 'AR-OYA (Goya, Corrientes, Argentina)'),
    ('AR-GRB', 'AR-GRB (Granadero Baigorria, Santa Fe, Argentina)'),
    ('AR-GBG', 'AR-GBG (Grand Bourg, Buenos Aires, Argentina)'),
    ('AR-GUY', 'AR-GUY (Gualeguay, Entre Ríos, Argentina)'),
    ('AR-GHU', 'AR-GHU (Gualeguaychú, Entre Ríos, Argentina)'),
    ('AR-GYM', 'AR-GYM (Guaymallén, Mendoza, Argentina)'),
    ('AR-GUR', 'AR-GUR (Guerrico, Buenos Aires, Argentina)'),
    ('AR-GVL', 'AR-GVL (Gálvez, Santa Fe, Argentina)'),
    ('AR-GUM', 'AR-GUM (Güemes, Tucumán, Argentina)'),
    ('AR-HAE', 'AR-HAE (Haedo, Buenos Aires, Argentina)'),
    ('AR-HER', 'AR-HER (Hernando, Córdoba, Argentina)'),
    ('AR-HVB', 'AR-HVB (Herrera Vegas, Buenos Aires, Argentina)'),
    ('AR-HIC', 'AR-HIC (Hickmann, Salta, Argentina)'),
    ('AR-HUG', 'AR-HUG (Hughes, Santa Fe, Argentina)'),
    ('AR-HUM', 'AR-HUM (Humboldt, Santa Fe, Argentina)'),
    ('AR-HUR', 'AR-HUR (Hurlingham, Buenos Aires, Argentina)'),
    ('AR-IBY', 'AR-IBY (Ibicuy, Entre Ríos, Argentina)'),
    ('AR-IGR', 'AR-IGR (Iguazú, Misiones, Argentina)'),
    ('AR-IAL', 'AR-IAL (Ingeniero Allan, Buenos Aires, Argentina)'),
    ('AR-BUI', 'AR-BUI (Ingeniero Buitrago, Buenos Aires, Argentina)'),
    ('AR-IGI', 'AR-IGI (Ingeniero Giagnoni, Mendoza, Argentina)'),
    ('AR-JJL', 'AR-JJL (Ingeniero J. Allan, Buenos Aires, Argentina)'),
    ('AR-IGB', 'AR-IGB (Ingeniero Jacobacci, Río Negro, Argentina)'),
    ('AR-ILH', 'AR-ILH (Ingeniero Luis A. Huergo, Río Negro, Argentina)'),
    ('AR-IMZ', 'AR-IMZ (Ingeniero Maschwitz, Buenos Aires, Argentina)'),
    ('AR-INW', 'AR-INW (Ingeniero White/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-ICA', 'AR-ICA (Ireneo Portela, Buenos Aires, Argentina)'),
    ('AR-ICV', 'AR-ICV (Isidro Casanova, Catamarca, Argentina)'),
    ('AR-ITZ', 'AR-ITZ (Ituzaingo, Buenos Aires, Argentina)'),
    ('AR-WNL', 'AR-WNL (Jauregui, Buenos Aires, Argentina)'),
    ('AR-AEP', 'AR-AEP (Jorge Newbury Apt/Buenos Aires, Buenos Aires, Argentina)'),
    ('AR-JLS', 'AR-JLS (Jose Leon Suarez, Buenos Aires, Argentina)'),
    ('AR-JPZ', 'AR-JPZ (José C. Paz, Buenos Aires, Argentina)'),
    ('AR-JSM', 'AR-JSM (José de San Martín, Chubut, Argentina)'),
    ('AR-JUJ', 'AR-JUJ (Jujuy, Jujuy, Argentina)'),
    ('AR-NIN', 'AR-NIN (Junin, Mendoza, Argentina)'),
    ('AR-JNI', 'AR-JNI (Junín, Buenos Aires, Argentina)'),
    ('AR-JUN', 'AR-JUN (Junín de Los Andes, Neuquén, Argentina)'),
    ('AR-JPX', 'AR-JPX (Justiniano Posse, Córdoba, Argentina)'),
    ('AR-JUA', 'AR-JUA (Juárez Celman, Córdoba, Argentina)'),
    ('AR-LCR', 'AR-LCR (La Calera, Córdoba, Argentina)'),
    ('AR-LCT', 'AR-LCT (La Carlota, Córdoba, Argentina)'),
    ('AR-LLM', 'AR-LLM (La Consulta, Mendoza, Argentina)'),
    ('AR-LCM', 'AR-LCM (La Cumbre, Córdoba, Argentina)'),
    ('AR-LES', 'AR-LES (La Escondida, Chaco, Argentina)'),
    ('AR-LFL', 'AR-LFL (La Falda, Córdoba, Argentina)'),
    ('AR-LPA', 'AR-LPA (La Paz, Entre Ríos, Argentina)'),
    ('AR-LPM', 'AR-LPM (La Paz, Mendoza, Argentina)'),
    ('AR-LPG', 'AR-LPG (La Plata, Buenos Aires, Argentina)'),
    ('AR-LQU', 'AR-LQU (La Quiaca, Jujuy, Argentina)'),
    ('AR-LAR', 'AR-LAR (La Reja, Buenos Aires, Argentina)'),
    ('AR-IRJ', 'AR-IRJ (La Rioja, La Rioja, Argentina)'),
    ('AR-LAT', 'AR-LAT (La Tablada, Santiago del Estero, Argentina)'),
    ('AR-LTA', 'AR-LTA (La Toma, San Luis, Argentina)'),
    ('AR-LFR', 'AR-LFR (Laferrere, Buenos Aires, Argentina)'),
    ('AR-ING', 'AR-ING (Lago Argentino, Santa Cruz, Argentina)'),
    ('AR-LNS', 'AR-LNS (Lanús, Buenos Aires, Argentina)'),
    ('AR-VDY', 'AR-VDY (Larroque, Entre Ríos, Argentina)'),
    ('AR-LCS', 'AR-LCS (Las Catitas, Mendoza, Argentina)'),
    ('AR-COM', 'AR-COM (Las Compuertas, Mendoza, Argentina)'),
    ('AR-LHE', 'AR-LHE (Las Heras, Mendoza, Argentina)'),
    ('AR-LHS', 'AR-LHS (Las Heras, Santa Cruz, Argentina)'),
    ('AR-LHG', 'AR-LHG (Las Higueras, Córdoba, Argentina)'),
    ('AR-LLS', 'AR-LLS (Las Lomitas, Formosa, Argentina)'),
    ('AR-LPS', 'AR-LPS (Las Palmas, Buenos Aires, Argentina)'),
    ('AR-LPD', 'AR-LPD (Las Paredes, Mendoza, Argentina)'),
    ('AR-LAP', 'AR-LAP (Las Parejas, Santa Fe, Argentina)'),
    ('AR-LVL', 'AR-LVL (Las Varillas, Córdoba, Argentina)'),
    ('AR-LAV', 'AR-LAV (Lavalle, Catamarca, Argentina)'),
    ('AR-LNO', 'AR-LNO (Leandro N. Alem, Misiones, Argentina)'),
    ('AR-XMX', 'AR-XMX (Ledesma, Jujuy, Argentina)'),
    ('AR-LMC', 'AR-LMC (Lezama (Manuel J. Cobo), Buenos Aires, Argentina)'),
    ('AR-LRS', 'AR-LRS (León Rouges, Tucumán, Argentina)'),
    ('AR-LIM', 'AR-LIM (Lima, Buenos Aires, Argentina)'),
    ('AR-LLO', 'AR-LLO (Llavallol, Buenos Aires, Argentina)'),
    ('AR-LBA', 'AR-LBA (Loberia, Buenos Aires, Argentina)'),
    ('AR-LHR', 'AR-LHR (Loma Hermosa, Buenos Aires, Argentina)'),
    ('AR-LMZ', 'AR-LMZ (Lomas de Zamora, Buenos Aires, Argentina)'),
    ('AR-LDM', 'AR-LDM (Lomas del Mirador, Buenos Aires, Argentina)'),
    ('AR-LCP', 'AR-LCP (Loncopué, Neuquén, Argentina)'),
    ('AR-LBL', 'AR-LBL (Los Boulevares, Córdoba, Argentina)'),
    ('AR-LCH', 'AR-LCH (Los Charrúas, Entre Ríos, Argentina)'),
    ('AR-LMD', 'AR-LMD (Los Menucos, Río Negro, Argentina)'),
    ('AR-JLF', 'AR-JLF (Los Polvorines, Buenos Aires, Argentina)'),
    ('AR-LGN', 'AR-LGN (Luis Guillon, Buenos Aires, Argentina)'),
    ('AR-LCU', 'AR-LCU (Lujan de Cuyo, Mendoza, Argentina)'),
    ('AR-LUJ', 'AR-LUJ (Luján, Buenos Aires, Argentina)'),
    ('AR-LUL', 'AR-LUL (Lules, Tucumán, Argentina)'),
    ('AR-VLU', 'AR-VLU (Luque, Córdoba, Argentina)'),
    ('AR-LZG', 'AR-LZG (Luzuriaga, Mendoza, Argentina)'),
    ('AR-MAC', 'AR-MAC (Macachin, La Pampa, Argentina)'),
    ('AR-MGD', 'AR-MGD (Magdalena, Buenos Aires, Argentina)'),
    ('AR-MAQ', 'AR-MAQ (Mainque, Río Negro, Argentina)'),
    ('AR-MPU', 'AR-MPU (Maipú, Mendoza, Argentina)'),
    ('AR-LGS', 'AR-LGS (Malargüe, Mendoza, Argentina)'),
    ('AR-JMG', 'AR-JMG (Manuel B. Gonnet, Buenos Aires, Argentina)'),
    ('AR-MQD', 'AR-MQD (Maquinchao, Río Negro, Argentina)'),
    ('AR-MDQ', 'AR-MDQ (Mar del Plata, Buenos Aires, Argentina)'),
    ('AR-JMJ', 'AR-JMJ (Marcos Juarez, Córdoba, Argentina)'),
    ('AR-MGA', 'AR-MGA (Maria Grande, Entre Ríos, Argentina)'),
    ('AR-MJH', 'AR-MJH (Mariano J. Haedo, Buenos Aires, Argentina)'),
    ('AR-MRT', 'AR-MRT (Martin Coronado, Buenos Aires, Argentina)'),
    ('AR-MAR', 'AR-MAR (Martínez, Buenos Aires, Argentina)'),
    ('AR-MDE', 'AR-MDE (Mataderos, Buenos Aires, Argentina)'),
    ('AR-MTH', 'AR-MTH (Matheu, Buenos Aires, Argentina)'),
    ('AR-MYR', 'AR-MYR (Mayor Drummond, Mendoza, Argentina)'),
    ('AR-MED', 'AR-MED (Medanitos, Catamarca, Argentina)'),
    ('AR-MRO', 'AR-MRO (Melchor Romero, Buenos Aires, Argentina)'),
    ('AR-MDZ', 'AR-MDZ (Mendoza, Mendoza, Argentina)'),
    ('AR-MDX', 'AR-MDX (Mercedes, Corrientes, Argentina)'),
    ('AR-RLO', 'AR-RLO (Merlo, San Luis, Argentina)'),
    ('AR-MIL', 'AR-MIL (Milagro, La Rioja, Argentina)'),
    ('AR-EZE', 'AR-EZE (Ministro Pistarini Apt/Buenos Aires, Buenos Aires, Argentina)'),
    ('AR-MJR', 'AR-MJR (Miramar, Buenos Aires, Argentina)'),
    ('AR-MOC', 'AR-MOC (Mocoretá, Corrientes, Argentina)'),
    ('AR-NOS', 'AR-NOS (Mocoretá, Corrientes, Argentina)'),
    ('AR-MCS', 'AR-MCS (Monte Caseros, Corrientes, Argentina)'),
    ('AR-MNT', 'AR-MNT (Monte Chingolo, Buenos Aires, Argentina)'),
    ('AR-MCR', 'AR-MCR (Monte Cristo, Córdoba, Argentina)'),
    ('AR-AMG', 'AR-AMG (Monte Grand, Buenos Aires, Argentina)'),
    ('AR-MML', 'AR-MML (Monte Maíz, Córdoba, Argentina)'),
    ('AR-MQO', 'AR-MQO (Monte Quemado, Santiago del Estero, Argentina)'),
    ('AR-MTC', 'AR-MTC (Montecarlo, Misiones, Argentina)'),
    ('AR-MOQ', 'AR-MOQ (Moquehuá, Buenos Aires, Argentina)'),
    ('AR-MOR', 'AR-MOR (Moreno, Buenos Aires, Argentina)'),
    ('AR-MRN', 'AR-MRN (Moreno, Buenos Aires, Argentina)'),
    ('AR-XOS', 'AR-XOS (Mosconi, Salta, Argentina)'),
    ('AR-MUN', 'AR-MUN (Munro, Buenos Aires, Argentina)'),
    ('AR-NCL', 'AR-NCL (Naschel, San Luis, Argentina)'),
    ('AR-JNR', 'AR-JNR (Navarro, Buenos Aires, Argentina)'),
    ('AR-NEC', 'AR-NEC (Necochea, Buenos Aires, Argentina)'),
    ('AR-NQN', 'AR-NQN (Neuquén, Neuquén, Argentina)'),
    ('AR-NOG', 'AR-NOG (Nogoyá, Entre Ríos, Argentina)'),
    ('AR-NNA', 'AR-NNA (Nonogasta, La Rioja, Argentina)'),
    ('AR-EJO', 'AR-EJO (Nueve de Julio, Buenos Aires, Argentina)'),
    ('AR-OBA', 'AR-OBA (Oberá, Misiones, Argentina)'),
    ('AR-OVI', 'AR-OVI (Olavarría, Buenos Aires, Argentina)'),
    ('AR-QLV', 'AR-QLV (Olivos, Buenos Aires, Argentina)'),
    ('AR-OCT', 'AR-OCT (Oncativo, Córdoba, Argentina)'),
    ('AR-ODR', 'AR-ODR (Open Door, Buenos Aires, Argentina)'),
    ('AR-ORA', 'AR-ORA (Oran, Salta, Argentina)'),
    ('AR-PP9', 'AR-PP9 (Pablo Podestá, Buenos Aires, Argentina)'),
    ('AR-PMA', 'AR-PMA (Pablo Podestá, Buenos Aires, Argentina)'),
    ('AR-PPL', 'AR-PPL (Palpala, Jujuy, Argentina)'),
    ('AR-PDC', 'AR-PDC (Pampa del Castillo, Chubut, Argentina)'),
    ('AR-PRA', 'AR-PRA (Paraná, Entre Ríos, Argentina)'),
    ('AR-PAS', 'AR-PAS (Pasco, Córdoba, Argentina)'),
    ('AR-AOL', 'AR-AOL (Paso de los Libres, Corrientes, Argentina)'),
    ('AR-PLU', 'AR-PLU (Pedro Luro, Buenos Aires, Argentina)'),
    ('AR-PEH', 'AR-PEH (Pehuajó, Buenos Aires, Argentina)'),
    ('AR-PED', 'AR-PED (Perdriel, Mendoza, Argentina)'),
    ('AR-PRZ', 'AR-PRZ (Perez, Santa Fe, Argentina)'),
    ('AR-PGO', 'AR-PGO (Pergamino, Buenos Aires, Argentina)'),
    ('AR-PMQ', 'AR-PMQ (Perito Moreno, Santa Cruz, Argentina)'),
    ('AR-XMV', 'AR-XMV (Pichanal, Salta, Argentina)'),
    ('AR-JPT', 'AR-JPT (Pico Truncado, Santa Cruz, Argentina)'),
    ('AR-PDT', 'AR-PDT (Piedritas, Buenos Aires, Argentina)'),
    ('AR-PGU', 'AR-PGU (Pigue, Buenos Aires, Argentina)'),
    ('AR-PLR', 'AR-PLR (Pilar, Buenos Aires, Argentina)'),
    ('AR-PCY', 'AR-PCY (Pilcomayo, Formosa, Argentina)'),
    ('AR-QPQ', 'AR-QPQ (Pinamar, Buenos Aires, Argentina)'),
    ('AR-PTN', 'AR-PTN (Platanos, Buenos Aires, Argentina)'),
    ('AR-PLT', 'AR-PLT (Plottier, Neuquén, Argentina)'),
    ('AR-POC', 'AR-POC (Pocitos, Salta, Argentina)'),
    ('AR-POM', 'AR-POM (Poman, Catamarca, Argentina)'),
    ('AR-PSS', 'AR-PSS (Posadas, Misiones, Argentina)'),
    ('AR-PDM', 'AR-PDM (Pozo del Molle, Córdoba, Argentina)'),
    ('AR-PRQ', 'AR-PRQ (Presidente Roque Sáenz Peña, Chaco, Argentina)'),
    ('AR-PAL', 'AR-PAL (Puerto Alumbrera, Santa Fe, Argentina)'),
    ('AR-PBG', 'AR-PBG (Puerto Belgrano/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-PUB', 'AR-PUB (Puerto Belgrano/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-PUD', 'AR-PUD (Puerto Deseado, Santa Cruz, Argentina)'),
    ('AR-PEL', 'AR-PEL (Puerto Eldorado, Misiones, Argentina)'),
    ('AR-PGV', 'AR-PGV (Puerto Galvan/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-ROC', 'AR-ROC (Puerto Ingeniero M. Rocca, Buenos Aires, Argentina)'),
    ('AR-PLA', 'AR-PLA (Puerto Lavalle, Corrientes, Argentina)'),
    ('AR-PMO', 'AR-PMO (Puerto Madero, Buenos Aires, Argentina)'),
    ('AR-PMY', 'AR-PMY (Puerto Madryn, Chubut, Argentina)'),
    ('AR-PMN', 'AR-PMN (Puerto Mineral, Misiones, Argentina)'),
    ('AR-PNL', 'AR-PNL (Puerto Nacional/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-PUR', 'AR-PUR (Puerto Rico, Misiones, Argentina)'),
    ('AR-PRS', 'AR-PRS (Puerto Rosales/Bahia Blanca, Buenos Aires, Argentina)'),
    ('AR-SJL', 'AR-SJL (Puerto San Julian, Santa Cruz, Argentina)'),
    ('AR-PTC', 'AR-PTC (Puerto Tirol, Chaco, Argentina)'),
    ('AR-PWA', 'AR-PWA (Puerto Wanda, Misiones, Argentina)'),
    ('AR-PCO', 'AR-PCO (Punta Colorada, Río Negro, Argentina)'),
    ('AR-PVA', 'AR-PVA (Punta de Vacas, Mendoza, Argentina)'),
    ('AR-PLO', 'AR-PLO (Punta de Vacas, Mendoza, Argentina)'),
    ('AR-PME', 'AR-PME (Punta Medanos, Buenos Aires, Argentina)'),
    ('AR-PQU', 'AR-PQU (Punta Medanos, Buenos Aires, Argentina)'),
    ('AR-PML', 'AR-PML (Pérez Millán, Buenos Aires, Argentina)'),
    ('AR-QBR', 'AR-QBR (Quebracho/San Lorenzo, Santa Fe, Argentina)'),
    ('AR-QQN', 'AR-QQN (Quequén, Buenos Aires, Argentina)'),
    ('AR-QUI', 'AR-QUI (Quilmes, Buenos Aires, Argentina)'),
    ('AR-RAF', 'AR-RAF (Rafaela, Santa Fe, Argentina)'),
    ('AR-RAM', 'AR-RAM (Ramallo, Buenos Aires, Argentina)'),
    ('AR-RMJ', 'AR-RMJ (Ramos Mejia, Buenos Aires, Argentina)'),
    ('AR-TPV', 'AR-TPV (Ranelagh, Buenos Aires, Argentina)'),
    ('AR-RWO', 'AR-RWO (Rawson, Chubut, Argentina)'),
    ('AR-RLA', 'AR-RLA (Recalde, Buenos Aires, Argentina)'),
    ('AR-RCQ', 'AR-RCQ (Reconquista, Santa Fe, Argentina)'),
    ('AR-RDE', 'AR-RDE (Remedios de Escalada, Buenos Aires, Argentina)'),
    ('AR-RSF', 'AR-RSF (Resinfor, Santa Fe, Argentina)'),
    ('AR-RES', 'AR-RES (Resistencia, Chaco, Argentina)'),
    ('AR-RDS', 'AR-RDS (Rincón de los Sauces, Neuquén, Argentina)'),
    ('AR-RNG', 'AR-RNG (Ringuelet, Buenos Aires, Argentina)'),
    ('AR-JRC', 'AR-JRC (Rio Colorado, Río Negro, Argentina)'),
    ('AR-RIC', 'AR-RIC (Rio Colorado, Río Negro, Argentina)'),
    ('AR-RSG', 'AR-RSG (Rio Segundo, Córdoba, Argentina)'),
    ('AR-RIV', 'AR-RIV (Rivadavia, Mendoza, Argentina)'),
    ('AR-RDC', 'AR-RDC (Rodeo de la Cruz, Mendoza, Argentina)'),
    ('AR-RDR', 'AR-RDR (Rodeo del Medio, Mendoza, Argentina)'),
    ('AR-ROJ', 'AR-ROJ (Rojas, Buenos Aires, Argentina)'),
    ('AR-ROL', 'AR-ROL (Roldán, Santa Fe, Argentina)'),
    ('AR-ROS', 'AR-ROS (Rosario, Santa Fe, Argentina)'),
    ('AR-RFO', 'AR-RFO (Rosario de la Frontera, Salta, Argentina)'),
    ('AR-RDL', 'AR-RDL (Rosario de Lerma, Salta, Argentina)'),
    ('AR-RFN', 'AR-RFN (Rufino, Santa Fe, Argentina)'),
    ('AR-RDM', 'AR-RDM (Ruiz de Montoya, Misiones, Argentina)'),
    ('AR-RCU', 'AR-RCU (Río Cuarto, Córdoba, Argentina)'),
    ('AR-RGL', 'AR-RGL (Río Gallegos, Santa Cruz, Argentina)'),
    ('AR-RGA', 'AR-RGA (Río Grande, Tierra del Fuego, Argentina)'),
    ('AR-RHD', 'AR-RHD (Río Hondo, Santiago del Estero, Argentina)'),
    ('AR-ROY', 'AR-ROY (Río Mayo, Chubut, Argentina)'),
    ('AR-RTO', 'AR-RTO (Río Tercero, Córdoba, Argentina)'),
    ('AR-RYO', 'AR-RYO (Río Turbio, Santa Cruz, Argentina)'),
    ('AR-SLL', 'AR-SLL (Saladillo, Buenos Aires, Argentina)'),
    ('AR-SLA', 'AR-SLA (Salta, Salta, Argentina)'),
    ('AR-SAL', 'AR-SAL (Salto, Buenos Aires, Argentina)'),
    ('AR-SDR', 'AR-SDR (Salto de las Rosas, Mendoza, Argentina)'),
    ('AR-SNG', 'AR-SNG (San Agustin, Córdoba, Argentina)'),
    ('AR-SNN', 'AR-SNN (San Andres, Buenos Aires, Argentina)'),
    ('AR-SAG', 'AR-SAG (San Andrés de Giles, Buenos Aires, Argentina)'),
    ('AR-SAO', 'AR-SAO (San Antonio de Areco, Buenos Aires, Argentina)'),
    ('AR-SAA', 'AR-SAA (San Antonio de Arredondo, Córdoba, Argentina)'),
    ('AR-SAP', 'AR-SAP (San Antonio de Padua, Buenos Aires, Argentina)'),
    ('AR-SAE', 'AR-SAE (San Antonio Este, Río Negro, Argentina)'),
    ('AR-OES', 'AR-OES (San Antonio Oeste, Río Negro, Argentina)'),
    ('AR-SCA', 'AR-SCA (San Carlos, Mendoza, Argentina)'),
    ('AR-RXV', 'AR-RXV (San Carlos Centro, Santa Fe, Argentina)'),
    ('AR-BRC', 'AR-BRC (San Carlos de Bariloche, Río Negro, Argentina)'),
    ('AR-SFE', 'AR-SFE (San Fernando, Buenos Aires, Argentina)'),
    ('AR-SFV', 'AR-SFV (San Fernando del Valle de Catamarca, Catamarca, Argentina)'),
    ('AR-SFO', 'AR-SFO (San Francisco, Córdoba, Argentina)'),
    ('AR-SFS', 'AR-SFS (San Francisco Solano, Buenos Aires, Argentina)'),
    ('AR-SIG', 'AR-SIG (San Ignacio, Misiones, Argentina)'),
    ('AR-SIS', 'AR-SIS (San Isidro, Buenos Aires, Argentina)'),
    ('AR-SJR', 'AR-SJR (San Javier, Santa Fe, Argentina)'),
    ('AR-SJV', 'AR-SJV (San Javier, Misiones, Argentina)'),
    ('AR-SJG', 'AR-SJG (San Jorge, Santa Fe, Argentina)'),
    ('AR-SAJ', 'AR-SAJ (San Jose, Entre Ríos, Argentina)'),
    ('AR-SJM', 'AR-SJM (San José de Metán, Salta, Argentina)'),
    ('AR-UAQ', 'AR-UAQ (San Juan, San Juan, Argentina)'),
    ('AR-ULA', 'AR-ULA (San Julian, Santa Cruz, Argentina)'),
    ('AR-SJO', 'AR-SJO (San Justo, Buenos Aires, Argentina)'),
    ('AR-SLO', 'AR-SLO (San Lorenzo, La Pampa, Argentina)'),
    ('AR-LUQ', 'AR-LUQ (San Luis, San Luis, Argentina)'),
    ('AR-SAT', 'AR-SAT (San Martin, Buenos Aires, Argentina)'),
    ('AR-SMA', 'AR-SMA (San Martin, Santa Fe, Argentina)'),
    ('AR-SMR', 'AR-SMR (San Martin, Mendoza, Argentina)'),
    ('AR-CPC', 'AR-CPC (San Martín de los Andes, Neuquén, Argentina)'),
    ('AR-SMT', 'AR-SMT (San Mateo, Santiago del Estero, Argentina)'),
    ('AR-SMG', 'AR-SMG (San Miguel, Buenos Aires, Argentina)'),
    ('AR-SMC', 'AR-SMC (San Miguel de Tucumán, Tucumán, Argentina)'),
    ('AR-SMM', 'AR-SMM (San Miguel del Monte, Buenos Aires, Argentina)'),
    ('AR-SNS', 'AR-SNS (San Nicolás de los Arroyos, Buenos Aires, Argentina)'),
    ('AR-SNP', 'AR-SNP (San Pedro, Buenos Aires, Argentina)'),
    ('AR-SPD', 'AR-SPD (San Pedro, Entre Ríos, Argentina)'),
    ('AR-XPD', 'AR-XPD (San Pedro, Jujuy, Argentina)'),
    ('AR-AFA', 'AR-AFA (San Rafael, Mendoza, Argentina)'),
    ('AR-SSA', 'AR-SSA (San Salvador, Entre Ríos, Argentina)'),
    ('AR-SSJ', 'AR-SSJ (San Salvador de Jujuy, Jujuy, Argentina)'),
    ('AR-SSN', 'AR-SSN (San Sebastián, Tierra del Fuego, Argentina)'),
    ('AR-SVE', 'AR-SVE (San Vicente, Misiones, Argentina)'),
    ('AR-SAN', 'AR-SAN (Santa Ana, Misiones, Argentina)'),
    ('AR-RZA', 'AR-RZA (Santa Cruz, Santa Cruz, Argentina)'),
    ('AR-SFN', 'AR-SFN (Santa Fe, Santa Fe, Argentina)'),
    ('AR-SIA', 'AR-SIA (Santa Isabel, Santa Fe, Argentina)'),
    ('AR-STL', 'AR-STL (Santa Lucia, San Juan, Argentina)'),
    ('AR-RSA', 'AR-RSA (Santa Rosa, La Pampa, Argentina)'),
    ('AR-STA', 'AR-STA (Santa Rosa, Mendoza, Argentina)'),
    ('AR-SST', 'AR-SST (Santa Teresita, Buenos Aires, Argentina)'),
    ('AR-SDE', 'AR-SDE (Santiago del Estero, Santiago del Estero, Argentina)'),
    ('AR-SA2', 'AR-SA2 (Santo Tome, Santa Fe, Argentina)'),
    ('AR-SAR', 'AR-SAR (Sarandi, Buenos Aires, Argentina)'),
    ('AR-RRS', 'AR-RRS (Sauce Viejo, Santa Fe, Argentina)'),
    ('AR-SGV', 'AR-SGV (Sierra Grande, Río Negro, Argentina)'),
    ('AR-ODN', 'AR-ODN (Soldini, Santa Fe, Argentina)'),
    ('AR-SLU', 'AR-SLU (Sta. Lucía, San Juan, Argentina)'),
    ('AR-SUI', 'AR-SUI (Suipacha, Buenos Aires, Argentina)'),
    ('AR-SUS', 'AR-SUS (Sunchales, Santa Fe, Argentina)'),
    ('AR-SZQ', 'AR-SZQ (Sáenz Peña, Buenos Aires, Argentina)'),
    ('AR-CTA', 'AR-CTA (Tabay, Corrientes, Argentina)'),
    ('AR-TAB', 'AR-TAB (Tablada, Buenos Aires, Argentina)'),
    ('AR-TVJ', 'AR-TVJ (Tafi Viejo, Tucumán, Argentina)'),
    ('AR-TDL', 'AR-TDL (Tandil, Buenos Aires, Argentina)'),
    ('AR-UKD', 'AR-UKD (Tapalque, Buenos Aires, Argentina)'),
    ('AR-TPL', 'AR-TPL (Tapiales, Buenos Aires, Argentina)'),
    ('AR-TTG', 'AR-TTG (Tartagal, Salta, Argentina)'),
    ('AR-TEM', 'AR-TEM (Temperley, Buenos Aires, Argentina)'),
    ('AR-TEO', 'AR-TEO (Teodelina, Santa Fe, Argentina)'),
    ('AR-TIC', 'AR-TIC (Ticino, Córdoba, Argentina)'),
    ('AR-TGR', 'AR-TGR (Tigre, Buenos Aires, Argentina)'),
    ('AR-TOR', 'AR-TOR (Tornquist, Buenos Aires, Argentina)'),
    ('AR-TOT', 'AR-TOT (Tortuguitas, Buenos Aires, Argentina)'),
    ('AR-TTD', 'AR-TTD (Tostado, Santa Fe, Argentina)'),
    ('AR-REL', 'AR-REL (Trelew, Chubut, Argentina)'),
    ('AR-OYO', 'AR-OYO (Tres Arroyos, Buenos Aires, Argentina)'),
    ('AR-TRS', 'AR-TRS (Tristan Suarez, Buenos Aires, Argentina)'),
    ('AR-TUC', 'AR-TUC (Tucumán, Tucumán, Argentina)'),
    ('AR-TUN', 'AR-TUN (Tunuyan, Mendoza, Argentina)'),
    ('AR-URH', 'AR-URH (Ugarteche, Mendoza, Argentina)'),
    ('AR-URA', 'AR-URA (Uranga, Santa Fe, Argentina)'),
    ('AR-URD', 'AR-URD (Uranga, Santa Fe, Argentina)'),
    ('AR-ULP', 'AR-ULP (Uriburu, La Pampa, Argentina)'),
    ('AR-USH', 'AR-USH (Ushuaia, Tierra del Fuego, Argentina)'),
    ('AR-USA', 'AR-USA (Uspallata, Mendoza, Argentina)'),
    ('AR-VCF', 'AR-VCF (Valcheta, Río Negro, Argentina)'),
    ('AR-VAA', 'AR-VAA (Valentin Alsina, Buenos Aires, Argentina)'),
    ('AR-VED', 'AR-VED (Vedia, Buenos Aires, Argentina)'),
    ('AR-VNT', 'AR-VNT (Venado Tuerto, Santa Fe, Argentina)'),
    ('AR-VIL', 'AR-VIL (Viale, Entre Ríos, Argentina)'),
    ('AR-VLO', 'AR-VLO (Vicente López, Buenos Aires, Argentina)'),
    ('AR-VCH', 'AR-VCH (Vichigasta, La Rioja, Argentina)'),
    ('AR-VIA', 'AR-VIA (Victoria, Buenos Aires, Argentina)'),
    ('AR-VDM', 'AR-VDM (Viedma, Río Negro, Argentina)'),
    ('AR-VAD', 'AR-VAD (Villa Adelina, Buenos Aires, Argentina)'),
    ('AR-VLL', 'AR-VLL (Villa Allende, Córdoba, Argentina)'),
    ('AR-VBA', 'AR-VBA (Villa Ballester, Buenos Aires, Argentina)'),
    ('AR-VBS', 'AR-VBS (Villa Bosch, Buenos Aires, Argentina)'),
    ('AR-VCA', 'AR-VCA (Villa Canas, Santa Fe, Argentina)'),
    ('AR-VCP', 'AR-VCP (Villa Carlos Paz, Córdoba, Argentina)'),
    ('AR-VCL', 'AR-VCL (Villa Celina, Buenos Aires, Argentina)'),
    ('AR-VCN', 'AR-VCN (Villa Constitución, Santa Fe, Argentina)'),
    ('AR-VRS', 'AR-VRS (Villa del Rosario, Córdoba, Argentina)'),
    ('AR-VTT', 'AR-VTT (Villa del Totoral, Córdoba, Argentina)'),
    ('AR-VDR', 'AR-VDR (Villa Dolores, Córdoba, Argentina)'),
    ('AR-VLD', 'AR-VLD (Villa Dominico, Buenos Aires, Argentina)'),
    ('AR-VEL', 'AR-VEL (Villa Elisa, Entre Ríos, Argentina)'),
    ('AR-VGB', 'AR-VGB (Villa Galicia, Buenos Aires, Argentina)'),
    ('AR-VLG', 'AR-VLG (Villa Gesell, Buenos Aires, Argentina)'),
    ('AR-VGG', 'AR-VGG (Villa Gobernador Galvez, Santa Fe, Argentina)'),
    ('AR-VHE', 'AR-VHE (Villa Hernandarias, Entre Ríos, Argentina)'),
    ('AR-VIN', 'AR-VIN (Villa Insuperable, Buenos Aires, Argentina)'),
    ('AR-VLI', 'AR-VLI (Villa la Angostura, Neuquén, Argentina)'),
    ('AR-VLZ', 'AR-VLZ (Villa Luzuriaga, Buenos Aires, Argentina)'),
    ('AR-VLY', 'AR-VLY (Villa Lynch, Buenos Aires, Argentina)'),
    ('AR-VIM', 'AR-VIM (Villa Madero, Buenos Aires, Argentina)'),
    ('AR-VMP', 'AR-VMP (Villa Maipu, Buenos Aires, Argentina)'),
    ('AR-VMZ', 'AR-VMZ (Villa Manzano, Río Negro, Argentina)'),
    ('AR-VMR', 'AR-VMR (Villa María, Córdoba, Argentina)'),
    ('AR-VMD', 'AR-VMD (Villa Mercedes, San Juan, Argentina)'),
    ('AR-VME', 'AR-VME (Villa Mercedes, San Luis, Argentina)'),
    ('AR-VNA', 'AR-VNA (Villa Nueva, Córdoba, Argentina)'),
    ('AR-VLP', 'AR-VLP (Villa Paez, Córdoba, Argentina)'),
    ('AR-VRE', 'AR-VRE (Villa Regina, Río Negro, Argentina)'),
    ('AR-VLR', 'AR-VLR (Villa Rosa, Buenos Aires, Argentina)'),
    ('AR-VTS', 'AR-VTS (Villa Tesei, Buenos Aires, Argentina)'),
    ('AR-ZAG', 'AR-ZAG (Villa Zagala, Buenos Aires, Argentina)'),
    ('AR-VLA', 'AR-VLA (Villalonga, Buenos Aires, Argentina)'),
    ('AR-VDP', 'AR-VDP (Virrey del Pino, Buenos Aires, Argentina)'),
    ('AR-VAL', 'AR-VAL (Vista Alegre, Neuquén, Argentina)'),
    ('AR-VFL', 'AR-VFL (Vista Alegre, Neuquén, Argentina)'),
    ('AR-VST', 'AR-VST (Vistalba, Mendoza, Argentina)'),
    ('AR-WIL', 'AR-WIL (Wilde, Buenos Aires, Argentina)'),
    ('AR-CYA', 'AR-CYA (Yeruá, Entre Ríos, Argentina)'),
    ('AR-APZ', 'AR-APZ (Zapala, Neuquén, Argentina)'),
    ('AR-ZON', 'AR-ZON (Zonda, San Juan, Argentina)'),
    ('AR-ZAE', 'AR-ZAE (Zárate, Buenos Aires, Argentina)'),
    ('AS-API', 'AS-API (Apia, American Samoa)'),
    ('AS-FTI', 'AS-FTI (Fitiuta, American Samoa)'),
    ('AS-OFU', 'AS-OFU (Ofu, American Samoa)'),
    ('AS-PPG', 'AS-PPG (Pago Pago, American Samoa)'),
    ('AS-TAV', 'AS-TAV (Tau, American Samoa)'),
    ('AT-MDF', 'AT-MDF (Mollersdorf, Tull an der Donau, Austria)'),
    ('AT-MLD', 'AT-MLD (Mollersdorf, Baden, Austria)'),
    ('AT-ABC', 'AT-ABC (Abfaltersbach, Austria)'),
    ('AT-ABS', 'AT-ABS (Absam, Austria)'),
    ('AT-ABT', 'AT-ABT (Abtenau, Austria)'),
    ('AT-AWD', 'AT-AWD (Abwinden, Austria)'),
    ('AT-FG7', 'AT-FG7 (Achau, Austria)'),
    ('AT-ACK', 'AT-ACK (Achenkirch, Austria)'),
    ('AT-AND', 'AT-AND (Aderklaa, Austria)'),
    ('AT-AWG', 'AT-AWG (Adlwang, Austria)'),
    ('AT-ADO', 'AT-ADO (Admont, Austria)'),
    ('AT-SAD', 'AT-SAD (Adnet, Austria)'),
    ('AT-AFR', 'AT-AFR (Afritz, Austria)'),
    ('AT-AGG', 'AT-AGG (Aggsbach Dorf, Austria)'),
    ('AT-AGM', 'AT-AGM (Aggsbach Markt, Austria)'),
    ('AT-ACH', 'AT-ACH (Aich, Austria)'),
    ('AT-AIN', 'AT-AIN (Aigen, Austria)'),
    ('AT-AIG', 'AT-AIG (Aigen im Mühlkreis, Austria)'),
    ('AT-ARO', 'AT-ARO (Albersdorf, Austria)'),
    ('AT-AKV', 'AT-AKV (Alkoven, Austria)'),
    ('AT-ALE', 'AT-ALE (Allentsteig, Austria)'),
    ('AT-ALH', 'AT-ALH (Allerheiligen, Austria)'),
    ('AT-ALL', 'AT-ALL (Allhaming, Austria)'),
    ('AT-NAL', 'AT-NAL (Allhartsberg, Austria)'),
    ('AT-AL9', 'AT-AL9 (Alpbach, Austria)'),
    ('AT-ATH', 'AT-ATH (Altach, Austria)'),
    ('AT-ATS', 'AT-ATS (Altaussee, Austria)'),
    ('AT-AL4', 'AT-AL4 (Altenberg, Austria)'),
    ('AT-AGZ', 'AT-AGZ (Altenberg bei Linz, Austria)'),
    ('AT-RUG', 'AT-RUG (Altenburg, Austria)'),
    ('AT-AMK', 'AT-AMK (Altenmarkt, Austria)'),
    ('AT-ALK', 'AT-ALK (Altenmarkt im Pongau, Austria)'),
    ('AT-AWH', 'AT-AWH (Altenwörth, Austria)'),
    ('AT-AHI', 'AT-AHI (Altheim, Austria)'),
    ('AT-AHO', 'AT-AHO (Althofen, Austria)'),
    ('AT-ALT', 'AT-ALT (Althofen, Austria)'),
    ('AT-ATG', 'AT-ATG (Altlengbach, Austria)'),
    ('AT-AMU', 'AT-AMU (Altmuenster, Austria)'),
    ('AT-AMS', 'AT-AMS (Ameis, Austria)'),
    ('AT-ZAD', 'AT-ZAD (Ampflwang im Hausruckwald, Austria)'),
    ('AT-ATT', 'AT-ATT (Amstetten, Austria)'),
    ('AT-ADU', 'AT-ADU (Andau, Austria)'),
    ('AT-ABU', 'AT-ABU (Andelsbuch, Austria)'),
    ('AT-RCH', 'AT-RCH (Andrichsfurt, Austria)'),
    ('AT-ANR', 'AT-ANR (Anger, Austria)'),
    ('AT-ERG', 'AT-ERG (Angerberg, Austria)'),
    ('AT-ANF', 'AT-ANF (Anif, Austria)'),
    ('AT-ANS', 'AT-ANS (Ansfelden, Austria)'),
    ('AT-TNU', 'AT-TNU (Antau, Austria)'),
    ('AT-ARG', 'AT-ARG (Anthering, Austria)'),
    ('AT-AHN', 'AT-AHN (Antiesenhofen, Austria)'),
    ('AT-APT', 'AT-APT (Apetlon, Austria)'),
    ('AT-ARB', 'AT-ARB (Arbesthal, Austria)'),
    ('AT-ARI', 'AT-ARI (Arbing, Austria)'),
    ('AT-ADG', 'AT-ADG (Ardagger, Austria)'),
    ('AT-AOT', 'AT-AOT (Arnoldstein, Austria)'),
    ('AT-ASC', 'AT-ASC (Aschach an der Donau, Austria)'),
    ('AT-ADS', 'AT-ADS (Aschach an der Steyr, Austria)'),
    ('AT-ABM', 'AT-ABM (Aschbach Markt, Austria)'),
    ('AT-APG', 'AT-APG (Aspang, Austria)'),
    ('AT-ASP', 'AT-ASP (Aspern, Austria)'),
    ('AT-ATN', 'AT-ATN (Asten, Austria)'),
    ('AT-ATP', 'AT-ATP (Attnang-Puchheim, Austria)'),
    ('AT-ATB', 'AT-ATB (Atzbach, Austria)'),
    ('AT-ATZ', 'AT-ATZ (Atzenbrugg, Austria)'),
    ('AT-ADD', 'AT-ADD (Au an der Donau, Austria)'),
    ('AT-ARN', 'AT-ARN (Auern, Austria)'),
    ('AT-UER', 'AT-UER (Auersthal, Austria)'),
    ('AT-ABK', 'AT-ABK (Aurach Bei Kitzbuhel, Austria)'),
    ('AT-ALZ', 'AT-ALZ (Aurolzmünster, Austria)'),
    ('AT-AUE', 'AT-AUE (Bad Aussee, Austria)'),
    ('AT-BDG', 'AT-BDG (Bad Deutsch-Altenburg, Austria)'),
    ('AT-BRH', 'AT-BRH (Bad Erlach, Austria)'),
    ('AT-BFI', 'AT-BFI (Bad Fischau, Austria)'),
    ('AT-BGC', 'AT-BGC (Bad Gleichenberg, Austria)'),
    ('AT-BGM', 'AT-BGM (Bad Goisern, Austria)'),
    ('AT-BHL', 'AT-BHL (Bad Hall, Austria)'),
    ('AT-ICH', 'AT-ICH (Bad Ischl, Austria)'),
    ('AT-BKZ', 'AT-BKZ (Bad Kreuzen, Austria)'),
    ('AT-BFL', 'AT-BFL (Bad Leonfelden, Austria)'),
    ('AT-BMF', 'AT-BMF (Bad Mitterndorf, Austria)'),
    ('AT-BKB', 'AT-BKB (Bad Radkersburg, Austria)'),
    ('AT-BSL', 'AT-BSL (Bad Sankt Leonhard im Lavanttal, Austria)'),
    ('AT-BSB', 'AT-BSB (Bad Sauerbrunn, Austria)'),
    ('AT-BSH', 'AT-BSH (Bad Schallerbach, Austria)'),
    ('AT-BVU', 'AT-BVU (Bad Vigaun, Austria)'),
    ('AT-BVL', 'AT-BVL (Bad Vöslau, Austria)'),
    ('AT-BWN', 'AT-BWN (Bad Wimsbach-Neydharting, Austria)'),
    ('AT-BDN', 'AT-BDN (Baden, Austria)'),
    ('AT-6KS', 'AT-6KS (Badendorf, Austria)'),
    ('AT-BDS', 'AT-BDS (Badersdorf, Austria)'),
    ('AT-BGA', 'AT-BGA (Badgastein, Austria)'),
    ('AT-BDA', 'AT-BDA (Baierdorf bei Anger, Austria)'),
    ('AT-BTE', 'AT-BTE (Baumgarten am Tullnerfeld, Austria)'),
    ('AT-BIB', 'AT-BIB (Baumgarten Im Burgenland, Austria)'),
    ('AT-BGT', 'AT-BGT (Baumgartenberg, Austria)'),
    ('AT-BMB', 'AT-BMB (Behamberg, Austria)'),
    ('AT-BGH', 'AT-BGH (Berghausen, Austria)'),
    ('AT-BES', 'AT-BES (Bergheim/Salzburg, Austria)'),
    ('AT-BNF', 'AT-BNF (Berndorf, Austria)'),
    ('AT-SXA', 'AT-SXA (Bernhardsthal, Austria)'),
    ('AT-VOR', 'AT-VOR (Bezau, Austria)'),
    ('AT-BIE', 'AT-BIE (Biedermannsdorf, Austria)'),
    ('AT-BKD', 'AT-BKD (Birkfeld, Austria)'),
    ('AT-BIS', 'AT-BIS (Bisamberg/Wien, Austria)'),
    ('AT-BFS', 'AT-BFS (Bischofshofen, Austria)'),
    ('AT-BKA', 'AT-BKA (Bleiberg-Kreuth, Austria)'),
    ('AT-BBG', 'AT-BBG (Bleiburg, Austria)'),
    ('AT-BNT', 'AT-BNT (Blindenmarkt, Austria)'),
    ('AT-BLU', 'AT-BLU (Bludenz, Austria)'),
    ('AT-BND', 'AT-BND (Brand, Austria)'),
    ('AT-BRD', 'AT-BRD (Brand, Austria)'),
    ('AT-BRA', 'AT-BRA (Braunau am Inn, Austria)'),
    ('AT-BRZ', 'AT-BRZ (Bregenz, Austria)'),
    ('AT-BTH', 'AT-BTH (Breitenaich, Austria)'),
    ('AT-BTU', 'AT-BTU (Breitenau, Austria)'),
    ('AT-ZAE', 'AT-ZAE (Breitenau am Hochlantsch, Austria)'),
    ('AT-BBN', 'AT-BBN (Breitenbrunn, Austria)'),
    ('AT-BFW', 'AT-BFW (Breitenfurt bei Wien, Austria)'),
    ('AT-BSZ', 'AT-BSZ (Breitenschützing, Austria)'),
    ('AT-BWA', 'AT-BWA (Breitenwaida, Austria)'),
    ('AT-BXT', 'AT-BXT (Brixen im Thale, Austria)'),
    ('AT-BXG', 'AT-BXG (Brixlegg, Austria)'),
    ('AT-BRG', 'AT-BRG (Bruck an der Glocknerstrasse, Austria)'),
    ('AT-BKL', 'AT-BKL (Bruck an der Leitha, Austria)'),
    ('AT-BRU', 'AT-BRU (Bruck an der Mur, Austria)'),
    ('AT-6TA', 'AT-6TA (Bruckbach, Austria)'),
    ('AT-BRN', 'AT-BRN (Brunn, Austria)'),
    ('AT-BAG', 'AT-BAG (Brunn am Gebirge, Austria)'),
    ('AT-BWD', 'AT-BWD (Brunn an der Wild, Austria)'),
    ('AT-NNE', 'AT-NNE (Brunnenthal, Austria)'),
    ('AT-BRL', 'AT-BRL (Brückl, Austria)'),
    ('AT-BUC', 'AT-BUC (Buch, Austria)'),
    ('AT-BHK', 'AT-BHK (Buchkirchen, Austria)'),
    ('AT-BB9', 'AT-BB9 (Burg, Austria)'),
    ('AT-BGK', 'AT-BGK (Burgkirchen, Austria)'),
    ('AT-BRB', 'AT-BRB (Bärenbach, Austria)'),
    ('AT-BBH', 'AT-BBH (Bärnbach, Austria)'),
    ('AT-ZAC', 'AT-ZAC (Böheimkirchen, Austria)'),
    ('AT-BOE', 'AT-BOE (Böhlerwenk, Austria)'),
    ('AT-URS', 'AT-URS (Bürs, Austria)'),
    ('AT-DAM', 'AT-DAM (Damüls, Austria)'),
    ('AT-DDT', 'AT-DDT (Dellach im Drautal, Austria)'),
    ('AT-DSU', 'AT-DSU (Desselbrunn, Austria)'),
    ('AT-DSZ', 'AT-DSZ (Deutsch Schutzen, Austria)'),
    ('AT-DWA', 'AT-DWA (Deutsch Wagram, Austria)'),
    ('AT-DKZ', 'AT-DKZ (Deutschkreutz, Austria)'),
    ('AT-DEU', 'AT-DEU (Deutschlandsberg, Austria)'),
    ('AT-DIA', 'AT-DIA (Dietach, Austria)'),
    ('AT-DTD', 'AT-DTD (Dietachdorf, Austria)'),
    ('AT-ERR', 'AT-ERR (Dobermannsdorf, Austria)'),
    ('AT-D2L', 'AT-D2L (Dobl, Austria)'),
    ('AT-DBL', 'AT-DBL (Dobl, Austria)'),
    ('AT-NNN', 'AT-NNN (Donnerskirchen, Austria)'),
    ('AT-DRF', 'AT-DRF (Dorf, Austria)'),
    ('AT-DFF', 'AT-DFF (Dorf an der Pram, Austria)'),
    ('AT-DFL', 'AT-DFL (Dorfla, Austria)'),
    ('AT-DOR', 'AT-DOR (Dornbirn, Austria)'),
    ('AT-DRA', 'AT-DRA (Drasenhofen, Austria)'),
    ('AT-DRO', 'AT-DRO (Dross, Austria)'),
    ('AT-DUR', 'AT-DUR (Dürnkrut, Austria)'),
    ('AT-DUE', 'AT-DUE (Dürnstein, Austria)'),
    ('AT-EBB', 'AT-EBB (Ebbs, Austria)'),
    ('AT-EBN', 'AT-EBN (Eben, Austria)'),
    ('AT-ESG', 'AT-ESG (Ebenau, Austria)'),
    ('AT-EFH', 'AT-EFH (Ebenfurth, Austria)'),
    ('AT-EBS', 'AT-EBS (Ebensee, Austria)'),
    ('AT-ETL', 'AT-ETL (Ebenthal, Austria)'),
    ('AT-EBE', 'AT-EBE (Ebergassing, Austria)'),
    ('AT-ERF', 'AT-ERF (Eberndorf, Austria)'),
    ('AT-NEB', 'AT-NEB (Ebersbrunn, Austria)'),
    ('AT-ESW', 'AT-ESW (Eberschwang, Austria)'),
    ('AT-EBD', 'AT-EBD (Ebersdorf, Austria)'),
    ('AT-EBZ', 'AT-EBZ (Eberstalzell, Austria)'),
    ('AT-ETN', 'AT-ETN (Eberstein, Austria)'),
    ('AT-EBR', 'AT-EBR (Ebreichsdorf, Austria)'),
    ('AT-ELL', 'AT-ELL (Edelstal, Austria)'),
    ('AT-EDZ', 'AT-EDZ (Edlitz, Austria)'),
    ('AT-EFR', 'AT-EFR (Eferding, Austria)'),
    ('AT-EGG', 'AT-EGG (Egg, Austria)'),
    ('AT-EGB', 'AT-EGB (Eggelsberg, Austria)'),
    ('AT-EBU', 'AT-EBU (Eggenburg, Austria)'),
    ('AT-PP3', 'AT-PP3 (Eggendorf, Austria)'),
    ('AT-EGT', 'AT-EGT (Eggendorf im Traunkreis, Austria)'),
    ('AT-GEI', 'AT-GEI (Eggerding, Austria)'),
    ('AT-EHR', 'AT-EHR (Ehrenhausen, Austria)'),
    ('AT-EH7', 'AT-EH7 (Ehrwald, Austria)'),
    ('AT-EWD', 'AT-EWD (Eibiswald, Austria)'),
    ('AT-EEZ', 'AT-EEZ (Eisenerz, Austria)'),
    ('AT-EKV', 'AT-EKV (Eisenkappel-Vellach, Austria)'),
    ('AT-EIT', 'AT-EIT (Eisenstadt, Austria)'),
    ('AT-ELI', 'AT-ELI (Elixhausen, Austria)'),
    ('AT-EAJ', 'AT-EAJ (Elsarn am Jauerling, Austria)'),
    ('AT-EGL', 'AT-EGL (Elsbethen Glasenbach, Austria)'),
    ('AT-EMM', 'AT-EMM (Emmersdorf an der Donau, Austria)'),
    ('AT-BRI', 'AT-BRI (Engabrunn, Austria)'),
    ('AT-AHZ', 'AT-AHZ (Engelhartszell, Austria)'),
    ('AT-ERO', 'AT-ERO (Engelmannsbrunn, Austria)'),
    ('AT-DFC', 'AT-DFC (Engerwitzdorf, Austria)'),
    ('AT-ENA', 'AT-ENA (Enns, Austria)'),
    ('AT-ENO', 'AT-ENO (Ennsdorf, Austria)'),
    ('AT-ENZ', 'AT-ENZ (Enzersdorf an der Fischa, Austria)'),
    ('AT-ETH', 'AT-ETH (Enzersdorf im Thale, Austria)'),
    ('AT-EZF', 'AT-EZF (Enzesfeld, Austria)'),
    ('AT-ESN', 'AT-ESN (Eppenstein, Austria)'),
    ('AT-ERL', 'AT-ERL (Erl, Austria)'),
    ('AT-EHN', 'AT-EHN (Ernsthofen, Austria)'),
    ('AT-EPD', 'AT-EPD (Erpersdorf, Austria)'),
    ('AT-ERP', 'AT-ERP (Erpfendorf, Austria)'),
    ('AT-ESB', 'AT-ESB (Esternberg, Austria)'),
    ('AT-EAK', 'AT-EAK (Etsdorf am Kamp, Austria)'),
    ('AT-EUG', 'AT-EUG (Eugendorf, Austria)'),
    ('AT-EUH', 'AT-EUH (Eurenhausen, Austria)'),
    ('AT-FSU', 'AT-FSU (Faistenau, Austria)'),
    ('AT-LKN', 'AT-LKN (Falkenstein, Austria)'),
    ('AT-FHR', 'AT-FHR (Fehring, Austria)'),
    ('AT-FST', 'AT-FST (Feistritz, Austria)'),
    ('AT-FDU', 'AT-FDU (Feistritz an der Drau, Austria)'),
    ('AT-FIT', 'AT-FIT (Feistritz im Rosental, Austria)'),
    ('AT-FED', 'AT-FED (Feldbach, Austria)'),
    ('AT-FKT', 'AT-FKT (Feldkirch, Austria)'),
    ('AT-FEK', 'AT-FEK (Feldkirchen an der Donau, Austria)'),
    ('AT-FKC', 'AT-FKC (Feldkirchen bei Graz, Austria)'),
    ('AT-FKI', 'AT-FKI (Feldkirchen im Kärnten, Austria)'),
    ('AT-FXO', 'AT-FXO (Felixdorf, Austria)'),
    ('AT-FWG', 'AT-FWG (Fels am Wagram, Austria)'),
    ('AT-FLH', 'AT-FLH (Ferlach, Austria)'),
    ('AT-FEO', 'AT-FEO (Ferndorf, Austria)'),
    ('AT-FNZ', 'AT-FNZ (Fernitz, Austria)'),
    ('AT-FBN', 'AT-FBN (Feuersbrunn, Austria)'),
    ('AT-FBB', 'AT-FBB (Fieberbrunn, Austria)'),
    ('AT-FIS', 'AT-FIS (Fischamend Dorf, Austria)'),
    ('AT-FSB', 'AT-FSB (Fischbach, Austria)'),
    ('AT-FSC', 'AT-FSC (Fisching, Austria)'),
    ('AT-FLA', 'AT-FLA (Flachau, Austria)'),
    ('AT-FLO', 'AT-FLO (Floridsdorf, Austria)'),
    ('AT-FOH', 'AT-FOH (Fohnsdorf, Austria)'),
    ('AT-FOR', 'AT-FOR (Fornach, Austria)'),
    ('AT-FAU', 'AT-FAU (Forstau, Austria)'),
    ('AT-FBG', 'AT-FBG (Frankenburg, Austria)'),
    ('AT-FRN', 'AT-FRN (Frankenmarkt, Austria)'),
    ('AT-FRT', 'AT-FRT (Frastanz, Austria)'),
    ('AT-FRA', 'AT-FRA (Frauendorf, Austria)'),
    ('AT-FAA', 'AT-FAA (Frauendorf An Der Au, Austria)'),
    ('AT-FKN', 'AT-FKN (Frauenkirchen, Austria)'),
    ('AT-FTL', 'AT-FTL (Frauental an der Lassnitz, Austria)'),
    ('AT-FRB', 'AT-FRB (Freinberg, Austria)'),
    ('AT-FSD', 'AT-FSD (Freistadt, Austria)'),
    ('AT-FRE', 'AT-FRE (Fresing, Austria)'),
    ('AT-FNA', 'AT-FNA (Freudenau, Austria)'),
    ('AT-FDG', 'AT-FDG (Friedburg, Austria)'),
    ('AT-FRH', 'AT-FRH (Friesach, Austria)'),
    ('AT-FRI', 'AT-FRI (Fritzens, Austria)'),
    ('AT-FLT', 'AT-FLT (Frohnleiten, Austria)'),
    ('AT-FHK', 'AT-FHK (Frojach-Katsch, Austria)'),
    ('AT-FPS', 'AT-FPS (Fulpmes, Austria)'),
    ('AT-FTH', 'AT-FTH (Furth bei Göttweig, Austria)'),
    ('AT-FAS', 'AT-FAS (Fuschl am See, Austria)'),
    ('AT-FSA', 'AT-FSA (Fussach, Austria)'),
    ('AT-FGN', 'AT-FGN (Fügen, Austria)'),
    ('AT-FUR', 'AT-FUR (Fürnitz, Austria)'),
    ('AT-FUF', 'AT-FUF (Fürstenfeld, Austria)'),
    ('AT-GAA', 'AT-GAA (Gaaden, Austria)'),
    ('AT-GBD', 'AT-GBD (Gabersdorf, Austria)'),
    ('AT-GAB', 'AT-GAB (Gablitz, Austria)'),
    ('AT-GFZ', 'AT-GFZ (Gaflenz, Austria)'),
    ('AT-GHR', 'AT-GHR (Gaishorn am See, Austria)'),
    ('AT-RTV', 'AT-RTV (Gallbrunn, Austria)'),
    ('AT-6NR', 'AT-6NR (Gallneukirchen, Austria)'),
    ('AT-GAL', 'AT-GAL (Galtür, Austria)'),
    ('AT-GMI', 'AT-GMI (Gaming, Austria)'),
    ('AT-GA6', 'AT-GA6 (Gamlitz, Austria)'),
    ('AT-GPN', 'AT-GPN (Gampern, Austria)'),
    ('AT-GAK', 'AT-GAK (Gars am Kamp, Austria)'),
    ('AT-GAN', 'AT-GAN (Garsten, Austria)'),
    ('AT-GSF', 'AT-GSF (Gaspoltshofen, Austria)'),
    ('AT-GAS', 'AT-GAS (Gastern, Austria)'),
    ('AT-GTD', 'AT-GTD (Gattendorf, Austria)'),
    ('AT-DER', 'AT-DER (Gedersdorf, Austria)'),
    ('AT-GNR', 'AT-GNR (Geinberg, Austria)'),
    ('AT-GRS', 'AT-GRS (Geras, Austria)'),
    ('AT-GDF', 'AT-GDF (Gerasdorf bei Wien, Austria)'),
    ('AT-GER', 'AT-GER (Gerersdorf bei Güssing, Austria)'),
    ('AT-GTR', 'AT-GTR (Geretsberg, Austria)'),
    ('AT-GET', 'AT-GET (Getzersdorf, Austria)'),
    ('AT-UBL', 'AT-UBL (Giesshübl, Austria)'),
    ('AT-GLA', 'AT-GLA (Glanegg, Austria)'),
    ('AT-GLZ', 'AT-GLZ (Glanz, Austria)'),
    ('AT-GST', 'AT-GST (Gleinstätten, Austria)'),
    ('AT-GSD', 'AT-GSD (Gleisdorf, Austria)'),
    ('AT-GLD', 'AT-GLD (Glinzendorf, Austria)'),
    ('AT-GLI', 'AT-GLI (Glinzing, Austria)'),
    ('AT-GGZ', 'AT-GGZ (Gloggnitz, Austria)'),
    ('AT-GDN', 'AT-GDN (Gmunden, Austria)'),
    ('AT-GMU', 'AT-GMU (Gmünd, Austria)'),
    ('AT-GMK', 'AT-GMK (Gmünd In Kärnten, Austria)'),
    ('AT-GNA', 'AT-GNA (Gnas, Austria)'),
    ('AT-GNS', 'AT-GNS (Gnesau, Austria)'),
    ('AT-GS2', 'AT-GS2 (Gofis, Austria)'),
    ('AT-GOW', 'AT-GOW (Goldwörth, Austria)'),
    ('AT-GAE', 'AT-GAE (Golling an der Erlauf, Austria)'),
    ('AT-GGS', 'AT-GGS (Golling an der Salzach, Austria)'),
    ('AT-GOL', 'AT-GOL (Gols, Austria)'),
    ('AT-GRF', 'AT-GRF (Gosdorf, Austria)'),
    ('AT-GSB', 'AT-GSB (Gottlesbrunn, Austria)'),
    ('AT-GOT', 'AT-GOT (Gotzendorf, Austria)'),
    ('AT-GC5', 'AT-GC5 (Grafenbach, Austria)'),
    ('AT-GRA', 'AT-GRA (Grafenstein, Austria)'),
    ('AT-GFW', 'AT-GFW (Grafenworth, Austria)'),
    ('AT-GRT', 'AT-GRT (Gramastetten, Austria)'),
    ('AT-GRL', 'AT-GRL (Gramatneusiedl, Austria)'),
    ('AT-B9G', 'AT-B9G (Grambach, Austria)'),
    ('AT-GNZ', 'AT-GNZ (Granz, Austria)'),
    ('AT-GKN', 'AT-GKN (Gratkorn, Austria)'),
    ('AT-GTW', 'AT-GTW (Gratwein, Austria)'),
    ('AT-GRZ', 'AT-GRZ (Graz, Austria)'),
    ('AT-GFS', 'AT-GFS (Greifenstein, Austria)'),
    ('AT-GRN', 'AT-GRN (Grein, Austria)'),
    ('AT-GFT', 'AT-GFT (Greinsfurth, Austria)'),
    ('AT-GTN', 'AT-GTN (Gresten, Austria)'),
    ('AT-GMB', 'AT-GMB (Gries am Brenner, Austria)'),
    ('AT-GIE', 'AT-GIE (Grieskirchen, Austria)'),
    ('AT-GRI', 'AT-GRI (Griffen, Austria)'),
    ('AT-GZS', 'AT-GZS (Grinzens, Austria)'),
    ('AT-GRR', 'AT-GRR (Grobssklein, Austria)'),
    ('AT-GZR', 'AT-GZR (Gross Gerungs, Austria)'),
    ('AT-GRU', 'AT-GRU (Gross Sankt Florian, Austria)'),
    ('AT-SWH', 'AT-SWH (Gross-Schweinbarth, Austria)'),
    ('AT-GSH', 'AT-GSH (Gross-Siegharts, Austria)'),
    ('AT-GBF', 'AT-GBF (Grossebersdorf, Austria)'),
    ('AT-GRO', 'AT-GRO (Grossenzersdorf/Wien, Austria)'),
    ('AT-GHF', 'AT-GHF (Grosshöflein, Austria)'),
    ('AT-GLG', 'AT-GLG (Grosslobming, Austria)'),
    ('AT-GPF', 'AT-GPF (Grosspetersdorf, Austria)'),
    ('AT-GRM', 'AT-GRM (Grossraming, Austria)'),
    ('AT-GTL', 'AT-GTL (Grossriedenthal, Austria)'),
    ('AT-GSU', 'AT-GSU (Grossschönau, Austria)'),
    ('AT-GWF', 'AT-GWF (Grossweikersdorf, Austria)'),
    ('AT-GWD', 'AT-GWD (Grosswiesendorf, Austria)'),
    ('AT-GND', 'AT-GND (Grunddorf, Austria)'),
    ('AT-GBG', 'AT-GBG (Gröbming, Austria)'),
    ('AT-GRG', 'AT-GRG (Grödig, Austria)'),
    ('AT-GMM', 'AT-GMM (Gummern, Austria)'),
    ('AT-GPK', 'AT-GPK (Gumpoldskirchen, Austria)'),
    ('AT-GUK', 'AT-GUK (Gunskirchen, Austria)'),
    ('AT-GUN', 'AT-GUN (Guntramsdorf, Austria)'),
    ('AT-GUT', 'AT-GUT (Gurten, Austria)'),
    ('AT-GSN', 'AT-GSN (Gutenstein, Austria)'),
    ('AT-GNF', 'AT-GNF (Gänserndorf, Austria)'),
    ('AT-ORF', 'AT-ORF (Gödersdorf, Austria)'),
    ('AT-GSG', 'AT-GSG (Gösing, Austria)'),
    ('AT-GOF', 'AT-GOF (Gössendorf, Austria)'),
    ('AT-GMA', 'AT-GMA (Göttlesbrunn-Arbesthal, Austria)'),
    ('AT-GOE', 'AT-GOE (Götzis, Austria)'),
    ('AT-GLO', 'AT-GLO (Günselsdorf, Austria)'),
    ('AT-GSS', 'AT-GSS (Güssing, Austria)'),
    ('AT-HAG', 'AT-HAG (Haag, Austria)'),
    ('AT-HAH', 'AT-HAH (Haag am Hausruck, Austria)'),
    ('AT-DOF', 'AT-DOF (Hadersdorf, Austria)'),
    ('AT-HKM', 'AT-HKM (Hadersdorf-Kammern, Austria)'),
    ('AT-HRS', 'AT-HRS (Hadres, Austria)'),
    ('AT-HGB', 'AT-HGB (Hagenbrunn, Austria)'),
    ('AT-HAB', 'AT-HAB (Haibach, Austria)'),
    ('AT-HAD', 'AT-HAD (Haid, Austria)'),
    ('AT-HHN', 'AT-HHN (Haidershofen, Austria)'),
    ('AT-HIA', 'AT-HIA (Hainburg, Austria)'),
    ('AT-LTX', 'AT-LTX (Hainfeld, Austria)'),
    ('AT-HZD', 'AT-HZD (Haitzendorf, Austria)'),
    ('AT-ALB', 'AT-ALB (Halbturn, Austria)'),
    ('AT-HAL', 'AT-HAL (Hall, Austria)'),
    ('AT-HIT', 'AT-HIT (Hall in Tirol, Austria)'),
    ('AT-HLL', 'AT-HLL (Hallein, Austria)'),
    ('AT-HLT', 'AT-HLT (Hallstatt, Austria)'),
    ('AT-HLG', 'AT-HLG (Hallwang, Austria)'),
    ('AT-HBG', 'AT-HBG (Handenberg, Austria)'),
    ('AT-HSN', 'AT-HSN (Hansenhütte, Austria)'),
    ('AT-HRD', 'AT-HRD (Hard, Austria)'),
    ('AT-BDH', 'AT-BDH (Haring, Austria)'),
    ('AT-HAE', 'AT-HAE (Haringsee, Austria)'),
    ('AT-HAR', 'AT-HAR (Harmannsdorf, Austria)'),
    ('AT-HTA', 'AT-HTA (Hartberg, Austria)'),
    ('AT-HKN', 'AT-HKN (Hartkirchen, Austria)'),
    ('AT-HRT', 'AT-HRT (Hartl, Austria)'),
    ('AT-HCH', 'AT-HCH (Haslach, Austria)'),
    ('AT-HLM', 'AT-HLM (Haslach an der Mühl, Austria)'),
    ('AT-HAC', 'AT-HAC (Haugschlag, Austria)'),
    ('AT-GHH', 'AT-GHH (Haugsdorf, Austria)'),
    ('AT-ITN', 'AT-ITN (Hausleiten, Austria)'),
    ('AT-TEN', 'AT-TEN (Hausmannstatten, Austria)'),
    ('AT-HMN', 'AT-HMN (Hausmannstätten, Austria)'),
    ('AT-HME', 'AT-HME (Hausmenning, Austria)'),
    ('AT-HEC', 'AT-HEC (Heidenreichstein, Austria)'),
    ('AT-HEI', 'AT-HEI (Heiligenkreuz, Austria)'),
    ('AT-HKR', 'AT-HKR (Heiligenkreuz, Austria)'),
    ('AT-HKZ', 'AT-HKZ (Heiligenkreuz, Austria)'),
    ('AT-HZL', 'AT-HZL (Heiligenkreuz im Lafnitztal, Austria)'),
    ('AT-HFS', 'AT-HFS (Heinfels, Austria)'),
    ('AT-HEL', 'AT-HEL (Helfenberg, Austria)'),
    ('AT-HEO', 'AT-HEO (Henndorf am Wallersee, Austria)'),
    ('AT-HNN', 'AT-HNN (Hennersdorf, Austria)'),
    ('AT-HMG', 'AT-HMG (Hermagor, Austria)'),
    ('AT-HER', 'AT-HER (Herzogenburg, Austria)'),
    ('AT-HED', 'AT-HED (Herzogsdorf, Austria)'),
    ('AT-HMD', 'AT-HMD (Hetzmannsdorf, Austria)'),
    ('AT-HFL', 'AT-HFL (Hieflau, Austria)'),
    ('AT-HIM', 'AT-HIM (Hilm, Austria)'),
    ('AT-ABG', 'AT-ABG (Himberg, Austria)'),
    ('AT-HBL', 'AT-HBL (Hinterbrühl, Austria)'),
    ('AT-HRM', 'AT-HRM (Hirm, Austria)'),
    ('AT-SH5', 'AT-SH5 (Hirnsdorf, Austria)'),
    ('AT-HHG', 'AT-HHG (Hirschegg, Austria)'),
    ('AT-HIR', 'AT-HIR (Hirschegg Rein, Austria)'),
    ('AT-HIG', 'AT-HIG (Hirschwang, Austria)'),
    ('AT-HTE', 'AT-HTE (Hirtenberg, Austria)'),
    ('AT-HTZ', 'AT-HTZ (Hitzendorf, Austria)'),
    ('AT-HBH', 'AT-HBH (Hobenbach, Austria)'),
    ('AT-BNN', 'AT-BNN (Hobersbrunn, Austria)'),
    ('AT-HOC', 'AT-HOC (Hochfilzen, Austria)'),
    ('AT-BE8', 'AT-BE8 (Hof bei salzburg, Austria)'),
    ('AT-HFN', 'AT-HFN (Hofen, Austria)'),
    ('AT-HDT', 'AT-HDT (Hofkirchen an der Trattnach, Austria)'),
    ('AT-HOM', 'AT-HOM (Hofkirchen im Mühlkreis, Austria)'),
    ('AT-HNT', 'AT-HNT (Hofkirchen im Traunkreis, Austria)'),
    ('AT-EIN', 'AT-EIN (Hoflein, Austria)'),
    ('AT-HDR', 'AT-HDR (Hofstatten An Der Raab, Austria)'),
    ('AT-HAU', 'AT-HAU (Hohenau an der March, Austria)'),
    ('AT-HIH', 'AT-HIH (Hoheneich, Austria)'),
    ('AT-HOH', 'AT-HOH (Hohenems, Austria)'),
    ('AT-HON', 'AT-HON (Hohenruppersdorf, Austria)'),
    ('AT-H3H', 'AT-H3H (Hohenwarth, Austria)'),
    ('AT-OHO', 'AT-OHO (Hohenzell, Austria)'),
    ('AT-HOL', 'AT-HOL (Hollabrunn, Austria)'),
    ('AT-LLG', 'AT-LLG (Hollenburg, Austria)'),
    ('AT-HLB', 'AT-HLB (Hollersbach, Austria)'),
    ('AT-HLZ', 'AT-HLZ (Holzberg, Austria)'),
    ('AT-OCH', 'AT-OCH (Holzhausen, Austria)'),
    ('AT-HOF', 'AT-HOF (Hopfgarten, Austria)'),
    ('AT-HOP', 'AT-HOP (Hopfgarten im Brixental, Austria)'),
    ('AT-HOT', 'AT-HOT (Horitschon, Austria)'),
    ('AT-HOR', 'AT-HOR (Horn, Austria)'),
    ('AT-HSE', 'AT-HSE (Hornstein, Austria)'),
    ('AT-HUT', 'AT-HUT (Huttau, Austria)'),
    ('AT-HST', 'AT-HST (Höchst, Austria)'),
    ('AT-HBR', 'AT-HBR (Höhenberg, Austria)'),
    ('AT-HOG', 'AT-HOG (Hönigsberg, Austria)'),
    ('AT-HBZ', 'AT-HBZ (Hörbranz, Austria)'),
    ('AT-HRH', 'AT-HRH (Hörsching, Austria)'),
    ('AT-HZF', 'AT-HZF (Hötzelsdorf, Austria)'),
    ('AT-ILL', 'AT-ILL (Illmitz, Austria)'),
    ('AT-ILZ', 'AT-ILZ (Ilz, Austria)'),
    ('AT-IMS', 'AT-IMS (Imst, Austria)'),
    ('AT-IZG', 'AT-IZG (Innermanzing, Austria)'),
    ('AT-INN', 'AT-INN (Innsbruck, Austria)'),
    ('AT-ZIN', 'AT-ZIN (Inzersdorf an der Traisen, Austria)'),
    ('AT-IIK', 'AT-IIK (Inzersdorf Im Kremstal, Austria)'),
    ('AT-INZ', 'AT-INZ (Inzing, Austria)'),
    ('AT-AZX', 'AT-AZX (Irdning, Austria)'),
    ('AT-ITR', 'AT-ITR (Itter, Austria)'),
    ('AT-ITT', 'AT-ITT (Itterdörfl, Austria)'),
    ('AT-JGE', 'AT-JGE (Jagerberg, Austria)'),
    ('AT-JPS', 'AT-JPS (Japons, Austria)'),
    ('AT-JEG', 'AT-JEG (Jeging, Austria)'),
    ('AT-JEN', 'AT-JEN (Jenbach, Austria)'),
    ('AT-JDF', 'AT-JDF (Jennersdorf, Austria)'),
    ('AT-JZS', 'AT-JZS (Jerzens, Austria)'),
    ('AT-ZLF', 'AT-ZLF (Jetzelsdorf, Austria)'),
    ('AT-JOC', 'AT-JOC (Joching, Austria)'),
    ('AT-JOS', 'AT-JOS (Jois, Austria)'),
    ('AT-JDB', 'AT-JDB (Judenberg, Austria)'),
    ('AT-JDN', 'AT-JDN (Judenburg, Austria)'),
    ('AT-JDD', 'AT-JDD (Judendorf, Austria)'),
    ('AT-JUN', 'AT-JUN (Jungholz, Austria)'),
    ('AT-JSS', 'AT-JSS (Jöss, Austria)'),
    ('AT-KAL', 'AT-KAL (Kallham, Austria)'),
    ('AT-KDF', 'AT-KDF (Kalsdorf, Austria)'),
    ('AT-KAB', 'AT-KAB (Kaltenbach, Austria)'),
    ('AT-KAM', 'AT-KAM (Kammern im Liesingtal, Austria)'),
    ('AT-KDO', 'AT-KDO (Kammersdorf, Austria)'),
    ('AT-KFB', 'AT-KFB (Kapfenberg, Austria)'),
    ('AT-SKS', 'AT-SKS (Kapfenstein, Austria)'),
    ('AT-KPL', 'AT-KPL (Kappl, Austria)'),
    ('AT-KAP', 'AT-KAP (Kaprun, Austria)'),
    ('AT-KAR', 'AT-KAR (Karlsdorf, Austria)'),
    ('AT-K2R', 'AT-K2R (Karlstetten, Austria)'),
    ('AT-KAF', 'AT-KAF (Katzelsdorf, Austria)'),
    ('AT-KFM', 'AT-KFM (Kefermarkt, Austria)'),
    ('AT-KMK', 'AT-KMK (Kematen an der Krems, Austria)'),
    ('AT-KTT', 'AT-KTT (Kematen in Tirol, Austria)'),
    ('AT-KYB', 'AT-KYB (Kematen Ybbs, Austria)'),
    ('AT-KMG', 'AT-KMG (Kemating, Austria)'),
    ('AT-KME', 'AT-KME (Kemeten, Austria)'),
    ('AT-KNB', 'AT-KNB (Kennelbach, Austria)'),
    ('AT-ZRF', 'AT-ZRF (Ketzelsdorf, Austria)'),
    ('AT-KIE', 'AT-KIE (Kienberg, Austria)'),
    ('AT-KIN', 'AT-KIN (Kindberg, Austria)'),
    ('AT-KBA', 'AT-KBA (Kirchbach, Austria)'),
    ('AT-KBW', 'AT-KBW (Kirchberg am Wagram, Austria)'),
    ('AT-KIR', 'AT-KIR (Kirchberg am Walde, Austria)'),
    ('AT-KAD', 'AT-KAD (Kirchberg an der Raab, Austria)'),
    ('AT-KRL', 'AT-KRL (Kirchbichl, Austria)'),
    ('AT-KKM', 'AT-KKM (Kirchdorf an der Krems, Austria)'),
    ('AT-KFT', 'AT-KFT (Kirchdorf in Tirol, Austria)'),
    ('AT-KHH', 'AT-KHH (Kirchham, Austria)'),
    ('AT-KII', 'AT-KII (Kirchheim im Innkreis, Austria)'),
    ('AT-KLZ', 'AT-KLZ (Kirchschlag bei Linz, Austria)'),
    ('AT-BGW', 'AT-BGW (Kirchschlag in der Buckligen Welt, Austria)'),
    ('AT-KTE', 'AT-KTE (Kirchstetten, Austria)'),
    ('AT-KSE', 'AT-KSE (Kittsee, Austria)'),
    ('AT-KIT', 'AT-KIT (Kitzbuhel, Austria)'),
    ('AT-KSS', 'AT-KSS (Kitzeck im Sausal, Austria)'),
    ('AT-KHO', 'AT-KHO (Klaffer, Austria)'),
    ('AT-KLU', 'AT-KLU (Klagenfurt, Austria)'),
    ('AT-KLA', 'AT-KLA (Klaus, Austria)'),
    ('AT-KSP', 'AT-KSP (Klein Sankt Paul, Austria)'),
    ('AT-KHS', 'AT-KHS (Kleinharras, Austria)'),
    ('AT-K8B', 'AT-K8B (Kleinhoflein, Austria)'),
    ('AT-BGN', 'AT-BGN (Kleinmutschen, Austria)'),
    ('AT-KNS', 'AT-KNS (Kleinneusiedl, Austria)'),
    ('AT-KPO', 'AT-KPO (Kleinpöchlarn, Austria)'),
    ('AT-KRM', 'AT-KRM (Kleinraming, Austria)'),
    ('AT-KLH', 'AT-KLH (Kleinreichenbach, Austria)'),
    ('AT-KDT', 'AT-KDT (Kleinriedenthal, Austria)'),
    ('AT-KIF', 'AT-KIF (Kleinwiesendorf, Austria)'),
    ('AT-KZL', 'AT-KZL (Kleinzell, Austria)'),
    ('AT-KTU', 'AT-KTU (Klosterneuburg, Austria)'),
    ('AT-KCH', 'AT-KCH (Klöch, Austria)'),
    ('AT-KFD', 'AT-KFD (Knittelfeld, Austria)'),
    ('AT-KBF', 'AT-KBF (Kobersdorf, Austria)'),
    ('AT-KOB', 'AT-KOB (Koblach, Austria)'),
    ('AT-KOG', 'AT-KOG (Koglhof, Austria)'),
    ('AT-KOH', 'AT-KOH (Kohfidisch, Austria)'),
    ('AT-KBZ', 'AT-KBZ (Kolbnitz, Austria)'),
    ('AT-KL4', 'AT-KL4 (Kollerschlag, Austria)'),
    ('AT-KOL', 'AT-KOL (Kolsass, Austria)'),
    ('AT-KGI', 'AT-KGI (Kopfing im Innkreis, Austria)'),
    ('AT-KOP', 'AT-KOP (Koppl, Austria)'),
    ('AT-KBG', 'AT-KBG (Korneuburg, Austria)'),
    ('AT-KOT', 'AT-KOT (Kottes, Austria)'),
    ('AT-KNR', 'AT-KNR (Kottingbrunn, Austria)'),
    ('AT-KRS', 'AT-KRS (Kramsach, Austria)'),
    ('AT-KDM', 'AT-KDM (Kraubath an der Mur, Austria)'),
    ('AT-KRE', 'AT-KRE (Krems, Austria)'),
    ('AT-KAN', 'AT-KAN (Krems an der Donau, Austria)'),
    ('AT-KMN', 'AT-KMN (Krems in Kärnten, Austria)'),
    ('AT-KMS', 'AT-KMS (Kremsmünster, Austria)'),
    ('AT-KGA', 'AT-KGA (Krenglbach, Austria)'),
    ('AT-KRI', 'AT-KRI (Krieglach, Austria)'),
    ('AT-KRZ', 'AT-KRZ (Kritzendorf, Austria)'),
    ('AT-KRO', 'AT-KRO (Krobotek, Austria)'),
    ('AT-KST', 'AT-KST (Kronstorf, Austria)'),
    ('AT-KTF', 'AT-KTF (Krottendorf, Austria)'),
    ('AT-KUB', 'AT-KUB (Krumbach Markt, Austria)'),
    ('AT-KMB', 'AT-KMB (Krummnussbaum, Austria)'),
    ('AT-GHJ', 'AT-GHJ (Krustetten, Austria)'),
    ('AT-KLD', 'AT-KLD (Kröllendorf, Austria)'),
    ('AT-KUC', 'AT-KUC (Kuchl, Austria)'),
    ('AT-KFS', 'AT-KFS (Kufstein, Austria)'),
    ('AT-KMR', 'AT-KMR (Kumberg, Austria)'),
    ('AT-KUN', 'AT-KUN (Kundl, Austria)'),
    ('AT-KFH', 'AT-KFH (Köflach, Austria)'),
    ('AT-KAW', 'AT-KAW (Königsbrunn am Wagram, Austria)'),
    ('AT-KTN', 'AT-KTN (Königstetten, Austria)'),
    ('AT-KOS', 'AT-KOS (Kössen, Austria)'),
    ('AT-KOE', 'AT-KOE (Köstendorf, Austria)'),
    ('AT-KEU', 'AT-KEU (Kötschach-Mauthen, Austria)'),
    ('AT-KUD', 'AT-KUD (Kühnsdorf, Austria)'),
    ('AT-LAA', 'AT-LAA (Laa an der Thaya, Austria)'),
    ('AT-LKI', 'AT-LKI (Laakirchen, Austria)'),
    ('AT-LCK', 'AT-LCK (Lackenbach, Austria)'),
    ('AT-LDO', 'AT-LDO (Ladendorf, Austria)'),
    ('AT-LMB', 'AT-LMB (Lambach, Austria)'),
    ('AT-LAB', 'AT-LAB (Lambrechten, Austria)'),
    ('AT-LPS', 'AT-LPS (Lamprechtshausen, Austria)'),
    ('AT-LAN', 'AT-LAN (Landeck, Austria)'),
    ('AT-LGE', 'AT-LGE (Langenlebarn, Austria)'),
    ('AT-LAG', 'AT-LAG (Langenlois, Austria)'),
    ('AT-LGR', 'AT-LGR (Langenrohr, Austria)'),
    ('AT-LSN', 'AT-LSN (Langenstein, Austria)'),
    ('AT-LGW', 'AT-LGW (Langenwang, Austria)'),
    ('AT-LZD', 'AT-LZD (Langenzersdorf, Austria)'),
    ('AT-LTF', 'AT-LTF (Langkampfen, Austria)'),
    ('AT-LWN', 'AT-LWN (Langwiesen, Austria)'),
    ('AT-LNH', 'AT-LNH (Lannach, Austria)'),
    ('AT-LZF', 'AT-LZF (Lanzendorf, Austria)'),
    ('AT-NLA', 'AT-NLA (Lanzenkirchen, Austria)'),
    ('AT-LAS', 'AT-LAS (Lassing, Austria)'),
    ('AT-LAU', 'AT-LAU (Launsdorf, Austria)'),
    ('AT-LUT', 'AT-LUT (Lauterach, Austria)'),
    ('AT-LNT', 'AT-LNT (Lavant, Austria)'),
    ('AT-LXE', 'AT-LXE (Laxenburg, Austria)'),
    ('AT-LEB', 'AT-LEB (Lebring, Austria)'),
    ('AT-LEC', 'AT-LEC (Lech, Austria)'),
    ('AT-ECU', 'AT-ECU (Lechaschau, Austria)'),
    ('AT-LBE', 'AT-LBE (Leiben, Austria)'),
    ('AT-LEI', 'AT-LEI (Leibnitz, Austria)'),
    ('AT-LP4', 'AT-LP4 (Leithaprodersdorf, Austria)'),
    ('AT-LUA', 'AT-LUA (Lembach, Austria)'),
    ('AT-LEN', 'AT-LEN (Lend, Austria)'),
    ('AT-LGU', 'AT-LGU (Lengau, Austria)'),
    ('AT-LGN', 'AT-LGN (Lengenfeld, Austria)'),
    ('AT-LZG', 'AT-LZG (Lenzing, Austria)'),
    ('AT-LBN', 'AT-LBN (Leoben, Austria)'),
    ('AT-LEO', 'AT-LEO (Leobendorf, Austria)'),
    ('AT-LBD', 'AT-LBD (Leobersdorf, Austria)'),
    ('AT-LDG', 'AT-LDG (Leonding, Austria)'),
    ('AT-LPO', 'AT-LPO (Leopoldsdorf (Wien), Austria)'),
    ('AT-LTH', 'AT-LTH (Leutasch, Austria)'),
    ('AT-LTS', 'AT-LTS (Leutschach, Austria)'),
    ('AT-LTD', 'AT-LTD (Leutzmannsdorf, Austria)'),
    ('AT-LIW', 'AT-LIW (Lichtenau im Waldviertel, Austria)'),
    ('AT-LTG', 'AT-LTG (Lichtenberg, Austria)'),
    ('AT-NWR', 'AT-NWR (Lichtenworth, Austria)'),
    ('AT-LIB', 'AT-LIB (Lieboch, Austria)'),
    ('AT-LEZ', 'AT-LEZ (Lienz, Austria)'),
    ('AT-LRR', 'AT-LRR (Lieserbruecke, Austria)'),
    ('AT-LZN', 'AT-LZN (Liezen, Austria)'),
    ('AT-LLF', 'AT-LLF (Lilienfeld, Austria)'),
    ('AT-IEG', 'AT-IEG (Limberg, Austria)'),
    ('AT-LBU', 'AT-LBU (Lindabrunn, Austria)'),
    ('AT-LNZ', 'AT-LNZ (Linz, Austria)'),
    ('AT-LSH', 'AT-LSH (Litschau, Austria)'),
    ('AT-BUG', 'AT-BUG (Litzelsdorf, Austria)'),
    ('AT-LOE', 'AT-LOE (Lobendorf, Austria)'),
    ('AT-LCU', 'AT-LCU (Lochau, Austria)'),
    ('AT-LCH', 'AT-LCH (Lochen, Austria)'),
    ('AT-LOF', 'AT-LOF (Lofer, Austria)'),
    ('AT-LOB', 'AT-LOB (Lohnsburg, Austria)'),
    ('AT-LDS', 'AT-LDS (Loidesthal, Austria)'),
    ('AT-LOI', 'AT-LOI (Loimersdorf, Austria)'),
    ('AT-LPB', 'AT-LPB (Loipersbach, Austria)'),
    ('AT-LPD', 'AT-LPD (Loipersdorf, Austria)'),
    ('AT-LSD', 'AT-LSD (Loosdorf, Austria)'),
    ('AT-LOS', 'AT-LOS (Losenstein, Austria)'),
    ('AT-LUW', 'AT-LUW (Ludersdorf-Wilfersdorf, Austria)'),
    ('AT-DSH', 'AT-DSH (Ludesch, Austria)'),
    ('AT-LTN', 'AT-LTN (Lustenau, Austria)'),
    ('AT-LTZ', 'AT-LTZ (Lutzmannsburg, Austria)'),
    ('AT-LFD', 'AT-LFD (Längenfeld, Austria)'),
    ('AT-MDS', 'AT-MDS (Madstein, Austria)'),
    ('AT-MLB', 'AT-MLB (Mailberg, Austria)'),
    ('AT-MSN', 'AT-MSN (Maishofen, Austria)'),
    ('AT-MLH', 'AT-MLH (Mallersbach, Austria)'),
    ('AT-MNG', 'AT-MNG (Mandling, Austria)'),
    ('AT-MAL', 'AT-MAL (Mannersdorf am Leithagebirge, Austria)'),
    ('AT-MNN', 'AT-MNN (Mannersdorf an der March, Austria)'),
    ('AT-MAN', 'AT-MAN (Manning, Austria)'),
    ('AT-MW3', 'AT-MW3 (Mannswörth, Austria)'),
    ('AT-MAB', 'AT-MAB (Marbach an der Donau, Austria)'),
    ('AT-GGM', 'AT-GGM (Marchegg, Austria)'),
    ('AT-MRC', 'AT-MRC (Marchtrenk, Austria)'),
    ('AT-MAM', 'AT-MAM (Margarethen am Moos, Austria)'),
    ('AT-MA5', 'AT-MA5 (Maria Alm am Steinernen Meer, Austria)'),
    ('AT-MEN', 'AT-MEN (Maria Enzersdorf, Austria)'),
    ('AT-MLJ', 'AT-MLJ (Maria Laach am Jauerling, Austria)'),
    ('AT-ZEN', 'AT-ZEN (Maria Lanzendorf, Austria)'),
    ('AT-MR2', 'AT-MR2 (Maria Rain, Austria)'),
    ('AT-MAS', 'AT-MAS (Maria Saal, Austria)'),
    ('AT-MDO', 'AT-MDO (Mariasdorf, Austria)'),
    ('AT-MZL', 'AT-MZL (Mariazell, Austria)'),
    ('AT-MGL', 'AT-MGL (Markgrafneusiedl, Austria)'),
    ('AT-MKA', 'AT-MKA (Markt Allhau, Austria)'),
    ('AT-MPI', 'AT-MPI (Markt Piesting, Austria)'),
    ('AT-MAR', 'AT-MAR (Marktl, Austria)'),
    ('AT-MSF', 'AT-MSF (Martinsdorf, Austria)'),
    ('AT-MRZ', 'AT-MRZ (Marz, Austria)'),
    ('AT-MBR', 'AT-MBR (Matrei am Brenner, Austria)'),
    ('AT-MAT', 'AT-MAT (Mattersburg, Austria)'),
    ('AT-MTH', 'AT-MTH (Mattighofen, Austria)'),
    ('AT-MTS', 'AT-MTS (Mattsee, Austria)'),
    ('AT-MTZ', 'AT-MTZ (Matzen, Austria)'),
    ('AT-MBH', 'AT-MBH (Mauerbach, Austria)'),
    ('AT-MHK', 'AT-MHK (Mauerkirchen, Austria)'),
    ('AT-MTN', 'AT-MTN (Mautern, Austria)'),
    ('AT-MUD', 'AT-MUD (Mautern an der Donau, Austria)'),
    ('AT-MTK', 'AT-MTK (Mautern in Steiermark, Austria)'),
    ('AT-MTF', 'AT-MTF (Mauterndorf, Austria)'),
    ('AT-MAU', 'AT-MAU (Mauthausen, Austria)'),
    ('AT-MRH', 'AT-MRH (Mayrhofen, Austria)'),
    ('AT-MGN', 'AT-MGN (Meggenhofen, Austria)'),
    ('AT-MEE', 'AT-MEE (Mehrnbach, Austria)'),
    ('AT-VNG', 'AT-VNG (Meiningen, Austria)'),
    ('AT-MEI', 'AT-MEI (Meiselding, Austria)'),
    ('AT-MEL', 'AT-MEL (Melk, Austria)'),
    ('AT-MLA', 'AT-MLA (Mellau, Austria)'),
    ('AT-MER', 'AT-MER (Merchtrenk, Austria)'),
    ('AT-MSD', 'AT-MSD (Messendorf, Austria)'),
    ('AT-MSB', 'AT-MSB (Mettersdorf Am Sassbach, Austria)'),
    ('AT-ZZG', 'AT-ZZG (Michaelbeuern, Austria)'),
    ('AT-MIC', 'AT-MIC (Michelbach, Austria)'),
    ('AT-MCF', 'AT-MCF (Micheldorf, Austria)'),
    ('AT-MAK', 'AT-MAK (Micheldorf am Kienberge, Austria)'),
    ('AT-MIF', 'AT-MIF (Micheldorf in Kärnten, Austria)'),
    ('AT-MCD', 'AT-MCD (Micheldorf in Oberösterreich, Austria)'),
    ('AT-MLN', 'AT-MLN (Michelhausen, Austria)'),
    ('AT-MEM', 'AT-MEM (Mieming, Austria)'),
    ('AT-MIK', 'AT-MIK (Miklauzhof, Austria)'),
    ('AT-MST', 'AT-MST (Millstatt, Austria)'),
    ('AT-MIL', 'AT-MIL (Mils, Austria)'),
    ('AT-MSS', 'AT-MSS (Missingdorf, Austria)'),
    ('AT-MIS', 'AT-MIS (Mistelbach, Austria)'),
    ('AT-MIT', 'AT-MIT (Mittelberg, Austria)'),
    ('AT-MTB', 'AT-MTB (Mitterberghutten, Austria)'),
    ('AT-MML', 'AT-MML (Mitterdorf im Murztal, Austria)'),
    ('AT-MKC', 'AT-MKC (Mitterkirchen, Austria)'),
    ('AT-MLS', 'AT-MLS (Mittersill, Austria)'),
    ('AT-MIX', 'AT-MIX (Mixnitz, Austria)'),
    ('AT-MLL', 'AT-MLL (Mollands, Austria)'),
    ('AT-MBK', 'AT-MBK (Mollbrucke, Austria)'),
    ('AT-OLL', 'AT-OLL (Molln, Austria)'),
    ('AT-MON', 'AT-MON (Mondsee, Austria)'),
    ('AT-MOO', 'AT-MOO (Moosbrunn, Austria)'),
    ('AT-OBM', 'AT-OBM (Moosdorf, Austria)'),
    ('AT-MBS', 'AT-MBS (Morbisch am See, Austria)'),
    ('AT-HLD', 'AT-HLD (Muhldorf, Austria)'),
    ('AT-MDG', 'AT-MDG (Munderfing, Austria)'),
    ('AT-MUR', 'AT-MUR (Murau, Austria)'),
    ('AT-MUC', 'AT-MUC (Mureck, Austria)'),
    ('AT-MUQ', 'AT-MUQ (Murstetten, Austria)'),
    ('AT-NT9', 'AT-NT9 (Muthmannsdorf, Austria)'),
    ('AT-MDR', 'AT-MDR (Mäder, Austria)'),
    ('AT-MBG', 'AT-MBG (Möderbrugg, Austria)'),
    ('AT-MOE', 'AT-MOE (Mödling, Austria)'),
    ('AT-MHF', 'AT-MHF (Mönchhof, Austria)'),
    ('AT-MAI', 'AT-MAI (Mühlheim, Austria)'),
    ('AT-MNO', 'AT-MNO (Müllendorf, Austria)'),
    ('AT-MUE', 'AT-MUE (Münchendorf, Austria)'),
    ('AT-MHE', 'AT-MHE (Münichreith, Austria)'),
    ('AT-MZH', 'AT-MZH (Münzbach, Austria)'),
    ('AT-MUN', 'AT-MUN (Münzkirchen, Austria)'),
    ('AT-MOF', 'AT-MOF (Mürzhofen, Austria)'),
    ('AT-MZZ', 'AT-MZZ (Mürzzuschlag, Austria)'),
    ('AT-NAA', 'AT-NAA (Naarn, Austria)'),
    ('AT-NDS', 'AT-NDS (Nauders, Austria)'),
    ('AT-NEC', 'AT-NEC (Neckenmarkt, Austria)'),
    ('AT-NEI', 'AT-NEI (Neidling, Austria)'),
    ('AT-NEZ', 'AT-NEZ (Nenzing, Austria)'),
    ('AT-NGZ', 'AT-NGZ (Nestelbach bei Graz, Austria)'),
    ('AT-NET', 'AT-NET (Nettingsdorf, Austria)'),
    ('AT-ANI', 'AT-ANI (Neu-Anif, Austria)'),
    ('AT-NEU', 'AT-NEU (Neubau, Austria)'),
    ('AT-NUA', 'AT-NUA (Neudau, Austria)'),
    ('AT-NGG', 'AT-NGG (Neudegg, Austria)'),
    ('AT-NBI', 'AT-NBI (Neudorf bei Ilz, Austria)'),
    ('AT-NEL', 'AT-NEL (Neudörfl, Austria)'),
    ('AT-NUF', 'AT-NUF (Neufeld an der Leitha, Austria)'),
    ('AT-NFN', 'AT-NFN (Neufelden, Austria)'),
    ('AT-NKB', 'AT-NKB (Neuhaus am Klausenbach, Austria)'),
    ('AT-NEK', 'AT-NEK (Neuhofen an der Krems, Austria)'),
    ('AT-NAD', 'AT-NAD (Neuhofen an der Ybbs, Austria)'),
    ('AT-NII', 'AT-NII (Neuhofen im Innkreis, Austria)'),
    ('AT-NVC', 'AT-NVC (Neukirchen an der Vöckla, Austria)'),
    ('AT-NEH', 'AT-NEH (Neulengbach, Austria)'),
    ('AT-NWS', 'AT-NWS (Neumarkt am Wallersee, Austria)'),
    ('AT-NYB', 'AT-NYB (Neumarkt and der Ybbs, Austria)'),
    ('AT-NHR', 'AT-NHR (Neumarkt im Hausruckkreis, Austria)'),
    ('AT-NMK', 'AT-NMK (Neumarkt im Mühlkreis, Austria)'),
    ('AT-NKN', 'AT-NKN (Neunkirchen, Austria)'),
    ('AT-NPK', 'AT-NPK (Neupirka, Austria)'),
    ('AT-NES', 'AT-NES (Neusiedl, Austria)'),
    ('AT-NAS', 'AT-NAS (Neusiedl am See, Austria)'),
    ('AT-NAZ', 'AT-NAZ (Neusiedl an der Zaya, Austria)'),
    ('AT-NSM', 'AT-NSM (Neustadtl Markt, Austria)'),
    ('AT-NDL', 'AT-NDL (Neustift an der Lafnitz, Austria)'),
    ('AT-NEM', 'AT-NEM (Neustift im Mühlkreis, Austria)'),
    ('AT-TR7', 'AT-TR7 (Neustift im Stubaital, Austria)'),
    ('AT-NTA', 'AT-NTA (Neutal, Austria)'),
    ('AT-NZG', 'AT-NZG (Neuzeug, Austria)'),
    ('AT-ND2', 'AT-ND2 (Nickelsdorf, Austria)'),
    ('AT-N9F', 'AT-N9F (Niederabsdorf, Austria)'),
    ('AT-NHN', 'AT-NHN (Niederhollabrunn, Austria)'),
    ('AT-NIK', 'AT-NIK (Niederkappel, Austria)'),
    ('AT-NID', 'AT-NID (Niederleis, Austria)'),
    ('AT-NDF', 'AT-NDF (Niederndorf, Austria)'),
    ('AT-NSL', 'AT-NSL (Niedernsill, Austria)'),
    ('AT-NIE', 'AT-NIE (Niederottnang, Austria)'),
    ('AT-NMN', 'AT-NMN (Niederranna, Austria)'),
    ('AT-NRR', 'AT-NRR (Niederrussbach, Austria)'),
    ('AT-NWK', 'AT-NWK (Niederwaldkirchen, Austria)'),
    ('AT-NIW', 'AT-NIW (Niederwölz, Austria)'),
    ('AT-NKD', 'AT-NKD (Niklasdorf, Austria)'),
    ('AT-NBA', 'AT-NBA (Nussbach, Austria)'),
    ('AT-NSD', 'AT-NSD (Nussdorf, Austria)'),
    ('AT-NAH', 'AT-NAH (Nussdorf am Haunsberg, Austria)'),
    ('AT-NAT', 'AT-NAT (Nussdorf an der Traisen, Austria)'),
    ('AT-NUZ', 'AT-NUZ (Nüziders, Austria)'),
    ('AT-OHD', 'AT-OHD (Obdach, Austria)'),
    ('AT-ORH', 'AT-ORH (Oberaich, Austria)'),
    ('AT-OMB', 'AT-OMB (Oberalm, Austria)'),
    ('AT-OFC', 'AT-OFC (Obere Fellach, Austria)'),
    ('AT-OBG', 'AT-OBG (Obergrafendorf, Austria)'),
    ('AT-OHI', 'AT-OHI (Oberhofen am Irrsee, Austria)'),
    ('AT-LAM', 'AT-LAM (Oberlamm, Austria)'),
    ('AT-NE2', 'AT-NE2 (Obermarkersdorf, Austria)'),
    ('AT-OAM', 'AT-OAM (Oberndorf an der Melk, Austria)'),
    ('AT-OBR', 'AT-OBR (Oberndorf bei Salzburg, Austria)'),
    ('AT-ODT', 'AT-ODT (Oberndorf in Tirol, Austria)'),
    ('AT-OBU', 'AT-OBU (Oberneukirchen, Austria)'),
    ('AT-OBE', 'AT-OBE (Oberpullendorf, Austria)'),
    ('AT-ORB', 'AT-ORB (Oberrohrbach, Austria)'),
    ('AT-OSZ', 'AT-OSZ (Oberschützen, Austria)'),
    ('AT-OSK', 'AT-OSK (Oberstinkenbrunn, Austria)'),
    ('AT-OBH', 'AT-OBH (Oberstrahlbach, Austria)'),
    ('AT-OTN', 'AT-OTN (Obertraun, Austria)'),
    ('AT-VTD', 'AT-VTD (Obertrum am See, Austria)'),
    ('AT-OWG', 'AT-OWG (Oberwagram, Austria)'),
    ('AT-OWD', 'AT-OWD (Oberwaltersdorf, Austria)'),
    ('AT-OWN', 'AT-OWN (Oberwang, Austria)'),
    ('AT-OWT', 'AT-OWT (Oberwart, Austria)'),
    ('AT-OBW', 'AT-OBW (Oberweis, Austria)'),
    ('AT-OED', 'AT-OED (Oed, Austria)'),
    ('AT-XAE', 'AT-XAE (Oehling, Austria)'),
    ('AT-OOT', 'AT-OOT (Oepping, Austria)'),
    ('AT-ORI', 'AT-ORI (Oftering, Austria)'),
    ('AT-GGU', 'AT-GGU (Oggau, Austria)'),
    ('AT-OLS', 'AT-OLS (Ohlsdorf, Austria)'),
    ('AT-OSF', 'AT-OSF (Ollersdorf, Austria)'),
    ('AT-OAL', 'AT-OAL (Oneal, Austria)'),
    ('AT-OIN', 'AT-OIN (Ort im Innkreis, Austria)'),
    ('AT-OAD', 'AT-OAD (Orth an der Donau, Austria)'),
    ('AT-ORT', 'AT-ORT (Ortmann, Austria)'),
    ('AT-TMH', 'AT-TMH (Ostermiething, Austria)'),
    ('AT-OSH', 'AT-OSH (Ottensheim, Austria)'),
    ('AT-OAH', 'AT-OAH (Ottnang am Hausruck, Austria)'),
    ('AT-OYH', 'AT-OYH (Oyenhausen, Austria)'),
    ('AT-PAL', 'AT-PAL (Paldau, Austria)'),
    ('AT-PAT', 'AT-PAT (Palt, Austria)'),
    ('AT-PTG', 'AT-PTG (Palting, Austria)'),
    ('AT-PAM', 'AT-PAM (Pamhagen, Austria)'),
    ('AT-PDF', 'AT-PDF (Parndorf, Austria)'),
    ('AT-PHG', 'AT-PHG (Pasching, Austria)'),
    ('AT-PSS', 'AT-PSS (Passail, Austria)'),
    ('AT-ATK', 'AT-ATK (Paternion, Austria)'),
    ('AT-PZF', 'AT-PZF (Patzmannsdorf, Austria)'),
    ('AT-PEG', 'AT-PEG (Peggau, Austria)'),
    ('AT-PO4', 'AT-PO4 (Pennewang, Austria)'),
    ('AT-PTF', 'AT-PTF (Perchtoldsdorf, Austria)'),
    ('AT-PER', 'AT-PER (Perg, Austria)'),
    ('AT-PGM', 'AT-PGM (Pernegg an der Mur, Austria)'),
    ('AT-PRD', 'AT-PRD (Pernersdorf, Austria)'),
    ('AT-PRH', 'AT-PRH (Pernhofen, Austria)'),
    ('AT-PNT', 'AT-PNT (Pernitz, Austria)'),
    ('AT-PBU', 'AT-PBU (Persenbeug, Austria)'),
    ('AT-PWG', 'AT-PWG (Perwang, Austria)'),
    ('AT-PTH', 'AT-PTH (Perwarth, Austria)'),
    ('AT-PSB', 'AT-PSB (Pessaberg, Austria)'),
    ('AT-PEC', 'AT-PEC (Petronell-Carnuntum, Austria)'),
    ('AT-PEB', 'AT-PEB (Pettenbach, Austria)'),
    ('AT-7TA', 'AT-7TA (Pettnau, Austria)'),
    ('AT-PET', 'AT-PET (Petzenkirchen, Austria)'),
    ('AT-PRB', 'AT-PRB (Peuerbach, Austria)'),
    ('AT-PFF', 'AT-PFF (Pfaffenhofen, Austria)'),
    ('AT-PFA', 'AT-PFA (Pfaffstätten, Austria)'),
    ('AT-SSP', 'AT-SSP (Pfarrwerfen, Austria)'),
    ('AT-PWE', 'AT-PWE (Pichl bei Wels, Austria)'),
    ('AT-PND', 'AT-PND (Piesendorf, Austria)'),
    ('AT-PLL', 'AT-PLL (Pill, Austria)'),
    ('AT-PLH', 'AT-PLH (Pillichsdorf, Austria)'),
    ('AT-PGG', 'AT-PGG (Pinggau, Austria)'),
    ('AT-PFD', 'AT-PFD (Pinkafeld, Austria)'),
    ('AT-POF', 'AT-POF (Pinsdorf, Austria)'),
    ('AT-PIS', 'AT-PIS (Pischeldorf, Austria)'),
    ('AT-PRF', 'AT-PRF (Pischelsdorf, Austria)'),
    ('AT-PSM', 'AT-PSM (Pischelsdorf In Der Steiermark, Austria)'),
    ('AT-PK6', 'AT-PK6 (Pischelsdorf in Steiermark, Austria)'),
    ('AT-PST', 'AT-PST (Pistorf, Austria)'),
    ('AT-PIT', 'AT-PIT (Pitten, Austria)'),
    ('AT-PID', 'AT-PID (Plainfeld, Austria)'),
    ('AT-PLA', 'AT-PLA (Platt, Austria)'),
    ('AT-PAS', 'AT-PAS (Podersdorf am See, Austria)'),
    ('AT-PGO', 'AT-PGO (Poggersdorf, Austria)'),
    ('AT-LL6', 'AT-LL6 (Pollau, Austria)'),
    ('AT-PO2', 'AT-PO2 (Pollauberg, Austria)'),
    ('AT-POL', 'AT-POL (Polten, Austria)'),
    ('AT-PTT', 'AT-PTT (Pottendorf, Austria)'),
    ('AT-OTT', 'AT-OTT (Pottsching, Austria)'),
    ('AT-POB', 'AT-POB (Poysbrunn, Austria)'),
    ('AT-POY', 'AT-POY (Poysdorf, Austria)'),
    ('AT-PRM', 'AT-PRM (Pram, Austria)'),
    ('AT-PBK', 'AT-PBK (Prambachkirchen, Austria)'),
    ('AT-PRA', 'AT-PRA (Pramet, Austria)'),
    ('AT-PDG', 'AT-PDG (Preding, Austria)'),
    ('AT-PGN', 'AT-PGN (Pregarten, Austria)'),
    ('AT-PRT', 'AT-PRT (Preitenegg, Austria)'),
    ('AT-PBM', 'AT-PBM (Pressbaum, Austria)'),
    ('AT-PFZ', 'AT-PFZ (Prinzendorf an der Zaya, Austria)'),
    ('AT-7PZ', 'AT-7PZ (Prinzersdorf, Austria)'),
    ('AT-PRL', 'AT-PRL (Proleb, Austria)'),
    ('AT-POT', 'AT-POT (Prottes, Austria)'),
    ('AT-PUC', 'AT-PUC (Puch, Austria)'),
    ('AT-PUU', 'AT-PUU (Puchenau, Austria)'),
    ('AT-PKG', 'AT-PKG (Pucking, Austria)'),
    ('AT-PKU', 'AT-PKU (Pulkau, Austria)'),
    ('AT-PTZ', 'AT-PTZ (Punitz, Austria)'),
    ('AT-PUP', 'AT-PUP (Pupping, Austria)'),
    ('AT-PUH', 'AT-PUH (Purbach, Austria)'),
    ('AT-PBN', 'AT-PBN (Purbach am Neusiedlersee, Austria)'),
    ('AT-PUR', 'AT-PUR (Purgstall, Austria)'),
    ('AT-PLE', 'AT-PLE (Purgstall an der Erlauf, Austria)'),
    ('AT-PUF', 'AT-PUF (Purkersdorf, Austria)'),
    ('AT-D4S', 'AT-D4S (Putzleinsdorf, Austria)'),
    ('AT-POE', 'AT-POE (Pöchlarn, Austria)'),
    ('AT-POG', 'AT-POG (Pöggstall, Austria)'),
    ('AT-PLS', 'AT-PLS (Pöls, Austria)'),
    ('AT-PNF', 'AT-PNF (Pöndorf, Austria)'),
    ('AT-PDO', 'AT-PDO (Pöttelsdorf, Austria)'),
    ('AT-RAB', 'AT-RAB (Raab, Austria)'),
    ('AT-RBA', 'AT-RBA (Raaba, Austria)'),
    ('AT-RAA', 'AT-RAA (Raasdorf, Austria)'),
    ('AT-RDN', 'AT-RDN (Radenthein, Austria)'),
    ('AT-RFD', 'AT-RFD (Radfeld, Austria)'),
    ('AT-RAD', 'AT-RAD (Radstadt, Austria)'),
    ('AT-RGF', 'AT-RGF (Raggendorf, Austria)'),
    ('AT-RIM', 'AT-RIM (Rainbach im Mühlkreis, Austria)'),
    ('AT-RAM', 'AT-RAM (Ramingstein, Austria)'),
    ('AT-RMU', 'AT-RMU (Ramsau, Austria)'),
    ('AT-RUZ', 'AT-RUZ (Ramsau im Zillertal, Austria)'),
    ('AT-RXG', 'AT-RXG (Randegg, Austria)'),
    ('AT-RKL', 'AT-RKL (Rankweil, Austria)'),
    ('AT-RAN', 'AT-RAN (Rannersdorf, Austria)'),
    ('AT-RHN', 'AT-RHN (Ranshofen, Austria)'),
    ('AT-RAS', 'AT-RAS (Rastenfeld, Austria)'),
    ('AT-RDW', 'AT-RDW (Ratsch an der Weinstrasse, Austria)'),
    ('AT-RTB', 'AT-RTB (Rattenberg, Austria)'),
    ('AT-RAU', 'AT-RAU (Rauris, Austria)'),
    ('AT-RXF', 'AT-RXF (Raxendorf, Austria)'),
    ('AT-RNZ', 'AT-RNZ (Rechnitz, Austria)'),
    ('AT-RED', 'AT-RED (Redlham, Austria)'),
    ('AT-REG', 'AT-REG (Regau, Austria)'),
    ('AT-RCA', 'AT-RCA (Reichenau, Austria)'),
    ('AT-RTL', 'AT-RTL (Reichenthal, Austria)'),
    ('AT-REI', 'AT-REI (Reichersberg, Austria)'),
    ('AT-RSD', 'AT-RSD (Reichersdorf, Austria)'),
    ('AT-RRM', 'AT-RRM (Reichraming, Austria)'),
    ('AT-RSB', 'AT-RSB (Reinsberg, Austria)'),
    ('AT-RN3', 'AT-RN3 (Reisenberg, Austria)'),
    ('AT-RWL', 'AT-RWL (Rekawinkel, Austria)'),
    ('AT-RTZ', 'AT-RTZ (Retz, Austria)'),
    ('AT-REU', 'AT-REU (Reuthe, Austria)'),
    ('AT-REE', 'AT-REE (Reuthe/Vorarlberg, Austria)'),
    ('AT-RTE', 'AT-RTE (Reutte, Austria)'),
    ('AT-RIE', 'AT-RIE (Ried, Austria)'),
    ('AT-RIK', 'AT-RIK (Ried im Innkreis, Austria)'),
    ('AT-RIT', 'AT-RIT (Ried Im Traunkreis, Austria)'),
    ('AT-RLD', 'AT-RLD (Riedlingsdorf, Austria)'),
    ('AT-RBG', 'AT-RBG (Riegersburg, Austria)'),
    ('AT-KAT', 'AT-KAT (Riegersdorf, Austria)'),
    ('AT-ETZ', 'AT-ETZ (Rietz, Austria)'),
    ('AT-RIZ', 'AT-RIZ (Rietz, Austria)'),
    ('AT-RZL', 'AT-RZL (Riezlern, Austria)'),
    ('AT-XXX', 'AT-XXX (RIS Inland waterways, Austria)'),
    ('AT-RHR', 'AT-RHR (Rohrau, Austria)'),
    ('AT-ROH', 'AT-ROH (Rohrbach, Austria)'),
    ('AT-R8N', 'AT-R8N (Rohrbach An Der Golsen, Austria)'),
    ('AT-RBM', 'AT-RBM (Rohrbach bei Mattersburg, Austria)'),
    ('AT-RDF', 'AT-RDF (Rohrendorf bei Krems, Austria)'),
    ('AT-ROI', 'AT-ROI (Roitham, Austria)'),
    ('AT-RNA', 'AT-RNA (Rosenau, Austria)'),
    ('AT-ROS', 'AT-ROS (Rosenbach, Austria)'),
    ('AT-RSU', 'AT-RSU (Rosenburg, Austria)'),
    ('AT-RAH', 'AT-RAH (Rosental an der Kainach, Austria)'),
    ('AT-ROA', 'AT-ROA (Rossatz, Austria)'),
    ('AT-RSL', 'AT-RSL (Rossleithen, Austria)'),
    ('AT-RTM', 'AT-RTM (Rotenturm an der Pinka, Austria)'),
    ('AT-RTH', 'AT-RTH (Rothis, Austria)'),
    ('AT-RTT', 'AT-RTT (Rottenmann, Austria)'),
    ('AT-RUN', 'AT-RUN (Ruden, Austria)'),
    ('AT-RUD', 'AT-RUD (Rudersdorf, Austria)'),
    ('AT-RRF', 'AT-RRF (Ruhrsdorf, Austria)'),
    ('AT-RUM', 'AT-RUM (Rum, Austria)'),
    ('AT-RUP', 'AT-RUP (Ruprechtshofen, Austria)'),
    ('AT-RUS', 'AT-RUS (Rust, Austria)'),
    ('AT-RZM', 'AT-RZM (Rutzenmoos, Austria)'),
    ('AT-RST', 'AT-RST (Röschitz, Austria)'),
    ('AT-SLB', 'AT-SLB (Saalbach, Austria)'),
    ('AT-SSM', 'AT-SSM (Saalfelden am Steinernen Meer, Austria)'),
    ('AT-SAC', 'AT-SAC (Sachsenburg, Austria)'),
    ('AT-SA7', 'AT-SA7 (Sachsendorf, Austria)'),
    ('AT-SM4', 'AT-SM4 (Salla, Austria)'),
    ('AT-SZG', 'AT-SZG (Salzburg, Austria)'),
    ('AT-SAK', 'AT-SAK (Sankt Aegidi, Austria)'),
    ('AT-AED', 'AT-AED (Sankt Aegyd am Neuwalde, Austria)'),
    ('AT-SAA', 'AT-SAA (Sankt Andra am Zicksee, Austria)'),
    ('AT-ARV', 'AT-ARV (Sankt Andrä, Austria)'),
    ('AT-SAN', 'AT-SAN (Sankt Andrä, Austria)'),
    ('AT-SAW', 'AT-SAW (Sankt Andrä-Wördern, Austria)'),
    ('AT-ANT', 'AT-ANT (Sankt Anton, Austria)'),
    ('AT-SFL', 'AT-SFL (Sankt Florian, Austria)'),
    ('AT-SFI', 'AT-SFI (Sankt Florian am Inn, Austria)'),
    ('AT-SKG', 'AT-SKG (Sankt Gallen, Austria)'),
    ('AT-SGG', 'AT-SGG (Sankt Georgen, Austria)'),
    ('AT-SGF', 'AT-SGF (Sankt Georgen am Steinfelden, Austria)'),
    ('AT-SGY', 'AT-SGY (Sankt Georgen am Ybbsfelde, Austria)'),
    ('AT-SG4', 'AT-SG4 (Sankt Georgen an der Gusen, Austria)'),
    ('AT-SGT', 'AT-SGT (Sankt Georgen an der Stiefing, Austria)'),
    ('AT-SGS', 'AT-SGS (Sankt Georgen bei Salzburg, Austria)'),
    ('AT-SGA', 'AT-SGA (Sankt Georgen im Attergau, Austria)'),
    ('AT-STG', 'AT-STG (Sankt Gertraud, Austria)'),
    ('AT-SJB', 'AT-SJB (Sankt Jakob Breitenau, Austria)'),
    ('AT-SJK', 'AT-SJK (Sankt Jakob im Rosental, Austria)'),
    ('AT-SJD', 'AT-SJD (Sankt Jakob in Defereggen, Austria)'),
    ('AT-JOA', 'AT-JOA (Sankt Johann im Pongau, Austria)'),
    ('AT-JOH', 'AT-JOH (Sankt Johann in Tirol, Austria)'),
    ('AT-STK', 'AT-STK (Sankt Josef (Weststeiermark), Austria)'),
    ('AT-SKK', 'AT-SKK (Sankt Kanzian am Klopeiner See, Austria)'),
    ('AT-KLG', 'AT-KLG (Sankt Katharein an der Laming, Austria)'),
    ('AT-SBL', 'AT-SBL (Sankt Lambrecht, Austria)'),
    ('AT-LFT', 'AT-LFT (Sankt Leonhard am Forst, Austria)'),
    ('AT-KN8', 'AT-KN8 (Sankt Lorenzen bei Knittelfeld, Austria)'),
    ('AT-LMU', 'AT-LMU (Sankt Lorenzen im Mürztal, Austria)'),
    ('AT-MMZ', 'AT-MMZ (Sankt Marein im Mürztal, Austria)'),
    ('AT-S7B', 'AT-S7B (Sankt Margarethen, Austria)'),
    ('AT-SMR', 'AT-SMR (Sankt Margarethen an der Raab, Austria)'),
    ('AT-SK3', 'AT-SK3 (Sankt Margrethen, Austria)'),
    ('AT-SMA', 'AT-SMA (Sankt Marien, Austria)'),
    ('AT-SKH', 'AT-SKH (Sankt Marienkirchen am Hausruck, Austria)'),
    ('AT-SNP', 'AT-SNP (Sankt Marienkirchen an der Polsenz, Austria)'),
    ('AT-SMN', 'AT-SMN (Sankt Martin bei Linz, Austria)'),
    ('AT-MTI', 'AT-MTI (Sankt Martin im Innkreis, Austria)'),
    ('AT-SMM', 'AT-SMM (Sankt Martin im Mühlkreis, Austria)'),
    ('AT-SKM', 'AT-SKM (Sankt Michael, Austria)'),
    ('AT-SEL', 'AT-SEL (Sankt Michael im Lungau, Austria)'),
    ('AT-SMI', 'AT-SMI (Sankt Michael in Obersteiermark, Austria)'),
    ('AT-SML', 'AT-SML (Sankt Michael ob Bleiburg, Austria)'),
    ('AT-SNI', 'AT-SNI (Sankt Nikola an der Donau, Austria)'),
    ('AT-SOP', 'AT-SOP (Sankt Oswald Bei Plankenwarth, Austria)'),
    ('AT-SPA', 'AT-SPA (Sankt Pantaleon, Austria)'),
    ('AT-SVT', 'AT-SVT (Sankt Paul, Austria)'),
    ('AT-SLV', 'AT-SLV (Sankt Paul im Lavanttal, Austria)'),
    ('AT-KTP', 'AT-KTP (Sankt Peter, Austria)'),
    ('AT-SAO', 'AT-SAO (Sankt Peter am Ottersbach, Austria)'),
    ('AT-SPR', 'AT-SPR (Sankt Peter im Sulmtal, Austria)'),
    ('AT-SPD', 'AT-SPD (Sankt Peter in der au Dorf, Austria)'),
    ('AT-S6P', 'AT-S6P (Sankt Peter-Freienstein, Austria)'),
    ('AT-STP', 'AT-STP (Sankt Pölten, Austria)'),
    ('AT-RRA', 'AT-RRA (Sankt Ruprecht an der Raab, Austria)'),
    ('AT-STS', 'AT-STS (Sankt Stefan, Austria)'),
    ('AT-SFS', 'AT-SFS (Sankt Stefan im Lavanttal, Austria)'),
    ('AT-SSR', 'AT-SSR (Sankt Stefan im Rosental, Austria)'),
    ('AT-SSO', 'AT-SSO (Sankt Stefan ob Leoben, Austria)'),
    ('AT-FBZ', 'AT-FBZ (Sankt Stefan ob Stainz, Austria)'),
    ('AT-TBL', 'AT-TBL (Sankt Thomas am Blasenstein, Austria)'),
    ('AT-SUH', 'AT-SUH (Sankt Ulrich, Austria)'),
    ('AT-SAP', 'AT-SAP (Sankt Ulrich Am Pillersee, Austria)'),
    ('AT-STV', 'AT-STV (Sankt Valentin, Austria)'),
    ('AT-SVV', 'AT-SVV (Sankt Veit am Vogau, Austria)'),
    ('AT-SVG', 'AT-SVG (Sankt Veit an der Glan, Austria)'),
    ('AT-SVO', 'AT-SVO (Sankt Veit an der Gölsen, Austria)'),
    ('AT-SVM', 'AT-SVM (Sankt Veit im Mühlkreis, Austria)'),
    ('AT-SAM', 'AT-SAM (Sarmingstein, Austria)'),
    ('AT-IST', 'AT-IST (Satteins, Austria)'),
    ('AT-SUN', 'AT-SUN (Sattledt, Austria)'),
    ('AT-SCC', 'AT-SCC (Schalchen, Austria)'),
    ('AT-4ST', 'AT-4ST (Scharitz, Austria)'),
    ('AT-SSI', 'AT-SSI (Scharnstein, Austria)'),
    ('AT-SBB', 'AT-SBB (Scheibbs, Austria)'),
    ('AT-SMU', 'AT-SMU (Scheifling, Austria)'),
    ('AT-SDB', 'AT-SDB (Schiedlberg, Austria)'),
    ('AT-SLD', 'AT-SLD (Schladming, Austria)'),
    ('AT-SCS', 'AT-SCS (Schlins, Austria)'),
    ('AT-7ST', 'AT-7ST (Schlitters, Austria)'),
    ('AT-SGL', 'AT-SGL (Schlägl, Austria)'),
    ('AT-SGN', 'AT-SGN (Schneegattern, Austria)'),
    ('AT-GF2', 'AT-GF2 (Schnifis, Austria)'),
    ('AT-SCG', 'AT-SCG (Schrattenberg, Austria)'),
    ('AT-TTL', 'AT-TTL (Schrattenthal, Austria)'),
    ('AT-SRM', 'AT-SRM (Schrems, Austria)'),
    ('AT-SHS', 'AT-SHS (Schruns, Austria)'),
    ('AT-ST8', 'AT-ST8 (Schutzen, Austria)'),
    ('AT-SAG', 'AT-SAG (Schutzen am Gebirge, Austria)'),
    ('AT-SWB', 'AT-SWB (Schwanberg, Austria)'),
    ('AT-SST', 'AT-SST (Schwanenstadt, Austria)'),
    ('AT-SCW', 'AT-SCW (Schwarzach, Austria)'),
    ('AT-SIP', 'AT-SIP (Schwarzach im Pongau, Austria)'),
    ('AT-SIG', 'AT-SIG (Schwarzau im Gebirge, Austria)'),
    ('AT-S7N', 'AT-S7N (Schwarzenau, Austria)'),
    ('AT-SCZ', 'AT-SCZ (Schwaz, Austria)'),
    ('AT-SHT', 'AT-SHT (Schwechat, Austria)'),
    ('AT-SHE', 'AT-SHE (Schweiggers, Austria)'),
    ('AT-SWT', 'AT-SWT (Schwendt, Austria)'),
    ('AT-SCH', 'AT-SCH (Schwertberg, Austria)'),
    ('AT-SWG', 'AT-SWG (Schwerting, Austria)'),
    ('AT-SWO', 'AT-SWO (Schwoich, Austria)'),
    ('AT-SDG', 'AT-SDG (Schärding, Austria)'),
    ('AT-SAT', 'AT-SAT (Schönau an der Triesting, Austria)'),
    ('AT-SMK', 'AT-SMK (Schönau im Mühlkreis, Austria)'),
    ('AT-SBH', 'AT-SBH (Schönbach, Austria)'),
    ('AT-SHB', 'AT-SHB (Schönberg, Austria)'),
    ('AT-SHG', 'AT-SHG (Schönegg, Austria)'),
    ('AT-SRD', 'AT-SRD (Schönkirchen-Reyersdorf, Austria)'),
    ('AT-SFA', 'AT-SFA (Schörfling am Attersee, Austria)'),
    ('AT-B7B', 'AT-B7B (Sebersdorf, Austria)'),
    ('AT-SEB', 'AT-SEB (Seeboden, Austria)'),
    ('AT-SEE', 'AT-SEE (Seefeld in Tirol, Austria)'),
    ('AT-SEF', 'AT-SEF (Seefeld-Kadolz, Austria)'),
    ('AT-SEH', 'AT-SEH (Seeham, Austria)'),
    ('AT-SHA', 'AT-SHA (Seehaus, Austria)'),
    ('AT-SIR', 'AT-SIR (Seekirchen, Austria)'),
    ('AT-SWA', 'AT-SWA (Seewalchen am Attersee, Austria)'),
    ('AT-SEI', 'AT-SEI (Seibersdorf, Austria)'),
    ('AT-SSB', 'AT-SSB (Seiersberg, Austria)'),
    ('AT-STN', 'AT-STN (Seitenstetten, Austria)'),
    ('AT-SET', 'AT-SET (Seitenstetten Markt, Austria)'),
    ('AT-SZA', 'AT-SZA (Selzthal, Austria)'),
    ('AT-SFT', 'AT-SFT (Senftenberg, Austria)'),
    ('AT-NT3', 'AT-NT3 (Seyring, Austria)'),
    ('AT-SIF', 'AT-SIF (Siegendorf, Austria)'),
    ('AT-SGR', 'AT-SGR (Sieggraben, Austria)'),
    ('AT-SII', 'AT-SII (Sierninghofen, Austria)'),
    ('AT-ZNH', 'AT-ZNH (Siezenheim, Austria)'),
    ('AT-SIS', 'AT-SIS (Sigless, Austria)'),
    ('AT-SIN', 'AT-SIN (Sillian, Austria)'),
    ('AT-SLZ', 'AT-SLZ (Silz, Austria)'),
    ('AT-SKN', 'AT-SKN (Sinabelkirchen, Austria)'),
    ('AT-ST2', 'AT-ST2 (Sistrans, Austria)'),
    ('AT-SIT', 'AT-SIT (Sittersdorf, Austria)'),
    ('AT-SLL', 'AT-SLL (Sollenau, Austria)'),
    ('AT-SNT', 'AT-SNT (Sonntag, Austria)'),
    ('AT-SOG', 'AT-SOG (Sonntagberg, Austria)'),
    ('AT-SOS', 'AT-SOS (Sooss, Austria)'),
    ('AT-SPG', 'AT-SPG (Spannberg, Austria)'),
    ('AT-SBK', 'AT-SBK (Spielberg bei Knittelfeld, Austria)'),
    ('AT-SFD', 'AT-SFD (Spielfeld, Austria)'),
    ('AT-SPN', 'AT-SPN (Spillern, Austria)'),
    ('AT-SPY', 'AT-SPY (Spital am Pyhrn, Austria)'),
    ('AT-SPS', 'AT-SPS (Spital am Semmering, Austria)'),
    ('AT-SPI', 'AT-SPI (Spittal an der Drau, Austria)'),
    ('AT-SPZ', 'AT-SPZ (Spitz, Austria)'),
    ('AT-SGZ', 'AT-SGZ (Sprögnitz, Austria)'),
    ('AT-SBA', 'AT-SBA (St. Bartholoma, Austria)'),
    ('AT-SPU', 'AT-SPU (Stadl Paura, Austria)'),
    ('AT-STA', 'AT-STA (Stainach, Austria)'),
    ('AT-STZ', 'AT-STZ (Stainz, Austria)'),
    ('AT-STM', 'AT-STM (Stams, Austria)'),
    ('AT-ANG', 'AT-ANG (Stang, Austria)'),
    ('AT-SAS', 'AT-SAS (Stans, Austria)'),
    ('AT-STD', 'AT-STD (Steeg, Austria)'),
    ('AT-STB', 'AT-STB (Stegersbach, Austria)'),
    ('AT-SDD', 'AT-SDD (Stein An Der Donau, Austria)'),
    ('AT-SEN', 'AT-SEN (Steinabrunn, Austria)'),
    ('AT-SBC', 'AT-SBC (Steinabrückl, Austria)'),
    ('AT-STH', 'AT-STH (Steinach, Austria)'),
    ('AT-SSS', 'AT-SSS (Steinberg, Austria)'),
    ('AT-SUP', 'AT-SUP (Steinbrunn, Austria)'),
    ('AT-STF', 'AT-STF (Steindorf, Austria)'),
    ('AT-STE', 'AT-STE (Steinfeld, Austria)'),
    ('AT-SUS', 'AT-SUS (Steinhaus, Austria)'),
    ('AT-ETE', 'AT-ETE (Stetten, Austria)'),
    ('AT-SER', 'AT-SER (Steyr, Austria)'),
    ('AT-SYG', 'AT-SYG (Steyregg, Austria)'),
    ('AT-SYM', 'AT-SYM (Steyrermühl, Austria)'),
    ('AT-SAR', 'AT-SAR (Stift Ardagger, Austria)'),
    ('AT-SND', 'AT-SND (Stixneusiedl, Austria)'),
    ('AT-SKB', 'AT-SKB (Stockenboi, Austria)'),
    ('AT-STC', 'AT-STC (Stockerau, Austria)'),
    ('AT-STO', 'AT-STO (Stoob, Austria)'),
    ('AT-STR', 'AT-STR (Stottera, Austria)'),
    ('AT-ST6', 'AT-ST6 (Straden, Austria)'),
    ('AT-SRB', 'AT-SRB (Strass im Strassertale, Austria)'),
    ('AT-SHF', 'AT-SHF (Strasshof an der Nordbahn, Austria)'),
    ('AT-SWN', 'AT-SWN (Strasswalchen, Austria)'),
    ('AT-SZI', 'AT-SZI (Stratzing, Austria)'),
    ('AT-SBG', 'AT-SBG (Strengberg, Austria)'),
    ('AT-STL', 'AT-STL (Strobl, Austria)'),
    ('AT-NIS', 'AT-NIS (Stronsdorf, Austria)'),
    ('AT-SZ5', 'AT-SZ5 (Stuhlfelden, Austria)'),
    ('AT-SUB', 'AT-SUB (Suben, Austria)'),
    ('AT-SUL', 'AT-SUL (Sulz, Austria)'),
    ('AT-SNG', 'AT-SNG (Söding, Austria)'),
    ('AT-SDN', 'AT-SDN (Sölden, Austria)'),
    ('AT-SOL', 'AT-SOL (Söll, Austria)'),
    ('AT-TKI', 'AT-TKI (Taiskirchen im Innskreis, Austria)'),
    ('AT-TAM', 'AT-TAM (Tamsweg, Austria)'),
    ('AT-TAT', 'AT-TAT (Tattendorf, Austria)'),
    ('AT-TKP', 'AT-TKP (Taufkirchen an der Pram, Austria)'),
    ('AT-TEF', 'AT-TEF (Teesdorf, Austria)'),
    ('AT-TEL', 'AT-TEL (Telfs, Austria)'),
    ('AT-TEC', 'AT-TEC (Tenneck, Austria)'),
    ('AT-TFS', 'AT-TFS (Terfens, Austria)'),
    ('AT-TNG', 'AT-TNG (Ternberg, Austria)'),
    ('AT-TNZ', 'AT-TNZ (Ternitz, Austria)'),
    ('AT-TEU', 'AT-TEU (Teufenbach, Austria)'),
    ('AT-TEX', 'AT-TEX (Texing, Austria)'),
    ('AT-TGU', 'AT-TGU (Thalgau, Austria)'),
    ('AT-THM', 'AT-THM (Thalheim, Austria)'),
    ('AT-TBW', 'AT-TBW (Thalheim bei Wels, Austria)'),
    ('AT-THR', 'AT-THR (Thaur, Austria)'),
    ('AT-THY', 'AT-THY (Thaya, Austria)'),
    ('AT-THS', 'AT-THS (Theiss, Austria)'),
    ('AT-THG', 'AT-THG (Thening, Austria)'),
    ('AT-THF', 'AT-THF (Theresienfeld, Austria)'),
    ('AT-TYN', 'AT-TYN (Theyern, Austria)'),
    ('AT-TSN', 'AT-TSN (Thomasberg, Austria)'),
    ('AT-TOL', 'AT-TOL (Thörl, Austria)'),
    ('AT-THN', 'AT-THN (Thüringen, Austria)'),
    ('AT-TLL', 'AT-TLL (Tillmitsch, Austria)'),
    ('AT-TMA', 'AT-TMA (Timelkam, Austria)'),
    ('AT-TIR', 'AT-TIR (Tirol, Austria)'),
    ('AT-TBG', 'AT-TBG (Traberg, Austria)'),
    ('AT-TRH', 'AT-TRH (Traboch, Austria)'),
    ('AT-TRA', 'AT-TRA (Tragwein, Austria)'),
    ('AT-TIS', 'AT-TIS (Traisen, Austria)'),
    ('AT-TSK', 'AT-TSK (Traiskirchen, Austria)'),
    ('AT-TMR', 'AT-TMR (Traismauer, Austria)'),
    ('AT-TNQ', 'AT-TNQ (Traun, Austria)'),
    ('AT-TDW', 'AT-TDW (Trausdorf an der Wulka, Austria)'),
    ('AT-TK2', 'AT-TK2 (Treffelsdorf, Austria)'),
    ('AT-TFN', 'AT-TFN (Treffen, Austria)'),
    ('AT-TBH', 'AT-TBH (Treibach, Austria)'),
    ('AT-TPV', 'AT-TPV (Treibach Althofen, Austria)'),
    ('AT-TDF', 'AT-TDF (Tresdorf, Austria)'),
    ('AT-TRW', 'AT-TRW (Tribuswinkel, Austria)'),
    ('AT-TBE', 'AT-TBE (Trieben, Austria)'),
    ('AT-CH8', 'AT-CH8 (Trofaiach, Austria)'),
    ('AT-TRU', 'AT-TRU (Trumau, Austria)'),
    ('AT-TUL', 'AT-TUL (Tulbing, Austria)'),
    ('AT-TLN', 'AT-TLN (Tulln, Austria)'),
    ('AT-TLH', 'AT-TLH (Tumeltsham, Austria)'),
    ('AT-TWG', 'AT-TWG (Twimberg, Austria)'),
    ('AT-TUE', 'AT-TUE (Türnitz, Austria)'),
    ('AT-UBA', 'AT-UBA (Ubelbach, Austria)'),
    ('AT-UDE', 'AT-UDE (Uderns, Austria)'),
    ('AT-ULF', 'AT-ULF (Ulmerfeld, Austria)'),
    ('AT-UGN', 'AT-UGN (Ungenach, Austria)'),
    ('AT-UNG', 'AT-UNG (Ungerdorf, Austria)'),
    ('AT-UNK', 'AT-UNK (Unken, Austria)'),
    ('AT-UNA', 'AT-UNA (Unterach, Austria)'),
    ('AT-UBE', 'AT-UBE (Unterbergen, Austria)'),
    ('AT-UFN', 'AT-UFN (Unterfladnitz, Austria)'),
    ('AT-ULB', 'AT-ULB (Unterloiben, Austria)'),
    ('AT-UTK', 'AT-UTK (Untermarkersdorf, Austria)'),
    ('AT-UBG', 'AT-UBG (Unternberg, Austria)'),
    ('AT-UPS', 'AT-UPS (Unterpremstätten, Austria)'),
    ('AT-URB', 'AT-URB (Unterradlberg, Austria)'),
    ('AT-UTB', 'AT-UTB (Unterretzbach, Austria)'),
    ('AT-UNN', 'AT-UNN (Untersiebenbrunn, Austria)'),
    ('AT-UWF', 'AT-UWF (Unterweitersdorf, Austria)'),
    ('AT-UNZ', 'AT-UNZ (Unzmarkt, Austria)'),
    ('AT-URF', 'AT-URF (Urfahr, Austria)'),
    ('AT-UTD', 'AT-UTD (Uttendorf, Austria)'),
    ('AT-UTZ', 'AT-UTZ (Utzenaich, Austria)'),
    ('AT-VAS', 'AT-VAS (Vasoldsberg, Austria)'),
    ('AT-VTH', 'AT-VTH (Veitsch, Austria)'),
    ('AT-VEL', 'AT-VEL (Velden, Austria)'),
    ('AT-VLM', 'AT-VLM (Velm, Austria)'),
    ('AT-VIC', 'AT-VIC (Vichtenstein, Austria)'),
    ('AT-VEH', 'AT-VEH (Viehdorf, Austria)'),
    ('AT-VDD', 'AT-VDD (Vienna Danubepier Hov, Austria)'),
    ('AT-VLH', 'AT-VLH (Villach, Austria)'),
    ('AT-VTS', 'AT-VTS (Vitis, Austria)'),
    ('AT-VTB', 'AT-VTB (Voitsberg, Austria)'),
    ('AT-VMP', 'AT-VMP (Vomp, Austria)'),
    ('AT-VCO', 'AT-VCO (Vorchdorf, Austria)'),
    ('AT-ERM', 'AT-ERM (Vordernberg, Austria)'),
    ('AT-VDS', 'AT-VDS (Vosendorf Sud, Austria)'),
    ('AT-VOC', 'AT-VOC (Vöcklabruck, Austria)'),
    ('AT-VOK', 'AT-VOK (Vöcklamarkt, Austria)'),
    ('AT-VOT', 'AT-VOT (Völkermarkt, Austria)'),
    ('AT-VOE', 'AT-VOE (Völs, Austria)'),
    ('AT-VOF', 'AT-VOF (Vösendorf, Austria)'),
    ('AT-WON', 'AT-WON (Wagna, Austria)'),
    ('AT-WAI', 'AT-WAI (Waidhofen an der Thaya, Austria)'),
    ('AT-WAF', 'AT-WAF (Waidhofen an der Ybbs, Austria)'),
    ('AT-WZK', 'AT-WZK (Waizenkirchen, Austria)'),
    ('AT-WCE', 'AT-WCE (Walchsee, Austria)'),
    ('AT-WCH', 'AT-WCH (Waldbach, Austria)'),
    ('AT-WBF', 'AT-WBF (Waldburg bei Freistadt, Austria)'),
    ('AT-WDG', 'AT-WDG (Waldegg, Austria)'),
    ('AT-WAK', 'AT-WAK (Waldkirchen am Wesen, Austria)'),
    ('AT-WKH', 'AT-WKH (Waldneukirchen, Austria)'),
    ('AT-WO4', 'AT-WO4 (Waldzell, Austria)'),
    ('AT-WIN', 'AT-WIN (Walkenstein, Austria)'),
    ('AT-WTH', 'AT-WTH (Wallern an der Trattnach, Austria)'),
    ('AT-WSE', 'AT-WSE (Wallsee, Austria)'),
    ('AT-WDR', 'AT-WDR (Walpersdorf, Austria)'),
    ('AT-WAL', 'AT-WAL (Wals, Austria)'),
    ('AT-WLS', 'AT-WLS (Wals-Siezenheim, Austria)'),
    ('AT-WPD', 'AT-WPD (Wampersdorf, Austria)'),
    ('AT-WNG', 'AT-WNG (Wang, Austria)'),
    ('AT-WAN', 'AT-WAN (Wannersdorf, Austria)'),
    ('AT-WRT', 'AT-WRT (Wartberg, Austria)'),
    ('AT-WAR', 'AT-WAR (Warth, Austria)'),
    ('AT-WTN', 'AT-WTN (Wattens, Austria)'),
    ('AT-WEB', 'AT-WEB (Webersdorf, Austria)'),
    ('AT-TWR', 'AT-TWR (Weer, Austria)'),
    ('AT-WEG', 'AT-WEG (Weigelsdorf, Austria)'),
    ('AT-WGR', 'AT-WGR (Weigersdorf, Austria)'),
    ('AT-WAS', 'AT-WAS (Weikersdorf am Steinfelde, Austria)'),
    ('AT-WBH', 'AT-WBH (Weilbach, Austria)'),
    ('AT-WLR', 'AT-WLR (Weiler, Austria)'),
    ('AT-WEU', 'AT-WEU (Weinburg, Austria)'),
    ('AT-WES', 'AT-WES (Weins, Austria)'),
    ('AT-WBA', 'AT-WBA (Weissenbach, Austria)'),
    ('AT-WEI', 'AT-WEI (Weissenbach, Austria)'),
    ('AT-WEE', 'AT-WEE (Weissenbach an der Triesting, Austria)'),
    ('AT-WNK', 'AT-WNK (Weissenkirchen im Attergau, Austria)'),
    ('AT-WKD', 'AT-WKD (Weissenkirchen in der Wachau, Austria)'),
    ('AT-WSS', 'AT-WSS (Weissenstein, Austria)'),
    ('AT-WDD', 'AT-WDD (Weissenstein ob der Drau, Austria)'),
    ('AT-WKI', 'AT-WKI (Weisskirchen, Austria)'),
    ('AT-WSK', 'AT-WSK (Weisskirchen an der Traun, Austria)'),
    ('AT-WST', 'AT-WST (Weistrach, Austria)'),
    ('AT-WET', 'AT-WET (Weiten, Austria)'),
    ('AT-WDF', 'AT-WDF (Weitendorf, Austria)'),
    ('AT-WTG', 'AT-WTG (Weitenegg, Austria)'),
    ('AT-WEA', 'AT-WEA (Weitra, Austria)'),
    ('AT-WEZ', 'AT-WEZ (Weiz, Austria)'),
    ('AT-W8B', 'AT-W8B (Welgersdorf, Austria)'),
    ('AT-WSL', 'AT-WSL (Wels, Austria)'),
    ('AT-WLG', 'AT-WLG (Wendling, Austria)'),
    ('AT-WGI', 'AT-WGI (Weng im Innkreis, Austria)'),
    ('AT-WFN', 'AT-WFN (Werfen, Austria)'),
    ('AT-WEN', 'AT-WEN (Wernberg, Austria)'),
    ('AT-WER', 'AT-WER (Werndorf, Austria)'),
    ('AT-WNO', 'AT-WNO (Wernersdorf, Austria)'),
    ('AT-WUF', 'AT-WUF (Wesenufer, Austria)'),
    ('AT-WTD', 'AT-WTD (Westendorf, Austria)'),
    ('AT-WYR', 'AT-WYR (Weyer, Austria)'),
    ('AT-WE3', 'AT-WE3 (Wiedendorf, Austria)'),
    ('AT-WIE', 'AT-WIE (Wielandsthal, Austria)'),
    ('AT-VIE', 'AT-VIE (Wien, Austria)'),
    ('AT-WNF', 'AT-WNF (Wiener Neudorf, Austria)'),
    ('AT-WNR', 'AT-WNR (Wiener Neustadt, Austria)'),
    ('AT-WS6', 'AT-WS6 (Wies, Austria)'),
    ('AT-WBG', 'AT-WBG (Wieselburg, Austria)'),
    ('AT-WSG', 'AT-WSG (Wiesing, Austria)'),
    ('AT-WLP', 'AT-WLP (Wildalpen, Austria)'),
    ('AT-WDB', 'AT-WDB (Wildendürnbach, Austria)'),
    ('AT-WDO', 'AT-WDO (Wildon, Austria)'),
    ('AT-WID', 'AT-WID (Wildschonau, Austria)'),
    ('AT-WIH', 'AT-WIH (Wildshut, Austria)'),
    ('AT-WIL', 'AT-WIL (Wildungsmauer, Austria)'),
    ('AT-SDO', 'AT-SDO (Wilfersdorf, Austria)'),
    ('AT-WBU', 'AT-WBU (Wilhelmsburg, Austria)'),
    ('AT-WHE', 'AT-WHE (Wilhering, Austria)'),
    ('AT-WIF', 'AT-WIF (Willendorf, Austria)'),
    ('AT-WMP', 'AT-WMP (Wimpassing, Austria)'),
    ('AT-ZAB', 'AT-ZAB (Wimpassing an der Laitha, Austria)'),
    ('AT-WSH', 'AT-WSH (Wimpassing im Schwarzatale, Austria)'),
    ('AT-WB2', 'AT-WB2 (Windhaag Bei Freistadt, Austria)'),
    ('AT-OCW', 'AT-OCW (Winkel, Austria)'),
    ('AT-WPH', 'AT-WPH (Wippenham, Austria)'),
    ('AT-WLN', 'AT-WLN (Wolfern, Austria)'),
    ('AT-WOL', 'AT-WOL (Wolfpassing, Austria)'),
    ('AT-8HN', 'AT-8HN (Wolfsbach, Austria)'),
    ('AT-WOF', 'AT-WOF (Wolfsberg (Kärnten), Austria)'),
    ('AT-WIS', 'AT-WIS (Wolfsberg im Schwarzautal, Austria)'),
    ('AT-WFG', 'AT-WFG (Wolfsegg am Hausruck, Austria)'),
    ('AT-WFT', 'AT-WFT (Wolfurt, Austria)'),
    ('AT-WWT', 'AT-WWT (Wolkersdorf, Austria)'),
    ('AT-WTB', 'AT-WTB (Worterberg, Austria)'),
    ('AT-WUL', 'AT-WUL (Wulkaprodersdorf, Austria)'),
    ('AT-NRF', 'AT-NRF (Wultendorf, Austria)'),
    ('AT-WLZ', 'AT-WLZ (Wulzeshofen, Austria)'),
    ('AT-WDU', 'AT-WDU (Wundschuh, Austria)'),
    ('AT-WUP', 'AT-WUP (Wurzenpass, Austria)'),
    ('AT-WSD', 'AT-WSD (Wöllersdorf, Austria)'),
    ('AT-WLL', 'AT-WLL (Wöllersdorf-Steinabrückl, Austria)'),
    ('AT-QXZ', 'AT-QXZ (Wörgl, Austria)'),
    ('AT-WOS', 'AT-WOS (Wösendorf, Austria)'),
    ('AT-WUR', 'AT-WUR (Würflach, Austria)'),
    ('AT-YBB', 'AT-YBB (Ybbs an der Donau, Austria)'),
    ('AT-YBS', 'AT-YBS (Ybbsitz, Austria)'),
    ('AT-ZAM', 'AT-ZAM (Zams, Austria)'),
    ('AT-A9Z', 'AT-A9Z (Zaussenberg, Austria)'),
    ('AT-ZER', 'AT-ZER (Zeiselmauer, Austria)'),
    ('AT-ZMO', 'AT-ZMO (Zell am Moos, Austria)'),
    ('AT-ZPE', 'AT-ZPE (Zell am Pettenfirst, Austria)'),
    ('AT-ZAS', 'AT-ZAS (Zell am See, Austria)'),
    ('AT-ZEZ', 'AT-ZEZ (Zell am Ziller, Austria)'),
    ('AT-ZTW', 'AT-ZTW (Zeltweg, Austria)'),
    ('AT-ZMD', 'AT-ZMD (Zemendorf-Stöttera, Austria)'),
    ('AT-ZTG', 'AT-ZTG (Zettling, Austria)'),
    ('AT-ZIE', 'AT-ZIE (Ziersdorf, Austria)'),
    ('AT-ZIP', 'AT-ZIP (Zipf, Austria)'),
    ('AT-ZIR', 'AT-ZIR (Zirl, Austria)'),
    ('AT-ZIS', 'AT-ZIS (Zistersdorf, Austria)'),
    ('AT-ZNG', 'AT-ZNG (Zobing, Austria)'),
    ('AT-ZUR', 'AT-ZUR (Zurndorf, Austria)'),
    ('AT-ZWD', 'AT-ZWD (Zwentendorf, Austria)'),
    ('AT-ZDD', 'AT-ZDD (Zwentendorf an der Donau, Austria)'),
    ('AT-ZWT', 'AT-ZWT (Zwettl, Austria)'),
    ('AT-QWE', 'AT-QWE (Zwölfaxing, Austria)'),
    ('AT-ZRS', 'AT-ZRS (Zürs, Austria)'),
    ('AT-OZB', 'AT-OZB (Ötztal-Bahnhof, Austria)'),
    ('AU-ABP', 'AU-ABP (Abbot Point, Queensland, Australia)'),
    ('AU-ABA', 'AU-ABA (Abbotsford, Victoria, Australia)'),
    ('AU-ALP', 'AU-ALP (Abell Point, Queensland, Australia)'),
    ('AU-ABD', 'AU-ABD (Aberdeen, New South Wales, Australia)'),
    ('AU-S4A', 'AU-S4A (Aberfoyle Park, South Australia, Australia)'),
    ('AU-ABG', 'AU-ABG (Abingdon, Queensland, Australia)'),
    ('AU-ACA', 'AU-ACA (Acacia Ridge, Queensland, Australia)'),
    ('AU-MST', 'AU-MST (Adamstown, New South Wales, Australia)'),
    ('AU-ADL', 'AU-ADL (Adelaide, South Australia, Australia)'),
    ('AU-ADA', 'AU-ADA (Adelaide Apt, South Australia, Australia)'),
    ('AU-ALO', 'AU-ALO (Adelong, New South Wales, Australia)'),
    ('AU-ANB', 'AU-ANB (Agnes Bank, New South Wales, Australia)'),
    ('AU-AGW', 'AU-AGW (Agnew, Queensland, Australia)'),
    ('AU-WSY', 'AU-WSY (Airlie Beach, Queensland, Australia)'),
    ('AU-AIR', 'AU-AIR (Airlie Terminal, Western Australia, Australia)'),
    ('AU-APW', 'AU-APW (Airport West, Victoria, Australia)'),
    ('AU-ALH', 'AU-ALH (Albany, Western Australia, Australia)'),
    ('AU-ACK', 'AU-ACK (Albany Creek, Queensland, Australia)'),
    ('AU-ABO', 'AU-ABO (Alberton, Queensland, Australia)'),
    ('AU-APK', 'AU-APK (Albion Park, New South Wales, Australia)'),
    ('AU-ABX', 'AU-ABX (Albury, New South Wales, Australia)'),
    ('AU-ALD', 'AU-ALD (Aldgate, South Australia, Australia)'),
    ('AU-ADG', 'AU-ADG (Aldinga, South Australia, Australia)'),
    ('AU-AVA', 'AU-AVA (Alexandra, Victoria, Australia)'),
    ('AU-ALX', 'AU-ALX (Alexandria, New South Wales, Australia)'),
    ('AU-AXL', 'AU-AXL (Alexandria, New South Wales, Australia)'),
    ('AU-ASP', 'AU-ASP (Alexandria, New South Wales, Australia)'),
    ('AU-ALB', 'AU-ALB (Allambie Heights, New South Wales, Australia)'),
    ('AU-AFD', 'AU-AFD (Allansford, Victoria, Australia)'),
    ('AU-ABH', 'AU-ABH (Alpha, Queensland, Australia)'),
    ('AU-APT', 'AU-APT (Alphington, Victoria, Australia)'),
    ('AU-ALN', 'AU-ALN (Alpine, New South Wales, Australia)'),
    ('AU-AYD', 'AU-AYD (Alpine, New South Wales, Australia)'),
    ('AU-AVI', 'AU-AVI (Alstonville, New South Wales, Australia)'),
    ('AU-AWN', 'AU-AWN (Alton Downs, South Australia, Australia)'),
    ('AU-ALT', 'AU-ALT (Altona, Victoria, Australia)'),
    ('AU-ATO', 'AU-ATO (Altona North, Victoria, Australia)'),
    ('AU-ALV', 'AU-ALV (Alvie, Victoria, Australia)'),
    ('AU-AYG', 'AU-AYG (Alvie, Victoria, Australia)'),
    ('AU-AMT', 'AU-AMT (Alvie, Victoria, Australia)'),
    ('AU-ABL', 'AU-ABL (Amberley, Queensland, Australia)'),
    ('AU-RCN', 'AU-RCN (American River, South Australia, Australia)'),
    ('AU-AMX', 'AU-AMX (American River, South Australia, Australia)'),
    ('AU-AMR', 'AU-AMR (Amrun, Queensland, Australia)'),
    ('AU-ADO', 'AU-ADO (Andamooka, South Australia, Australia)'),
    ('AU-AND', 'AU-AND (Andrews, Queensland, Australia)'),
    ('AU-ZCB', 'AU-ZCB (Angas Plains, South Australia, Australia)'),
    ('AU-ANG', 'AU-ANG (Angaston, South Australia, Australia)'),
    ('AU-AVE', 'AU-AVE (Angle Vale, South Australia, Australia)'),
    ('AU-ASE', 'AU-ASE (Anglesea, Victoria, Australia)'),
    ('AU-ANZ', 'AU-ANZ (Anglesea, Victoria, Australia)'),
    ('AU-ANN', 'AU-ANN (Annandale, New South Wales, Australia)'),
    ('AU-ANL', 'AU-ANL (Annerley, Queensland, Australia)'),
    ('AU-AYL', 'AU-AYL (Annerley, Queensland, Australia)'),
    ('AU-APP', 'AU-APP (Applecross, Western Australia, Australia)'),
    ('AU-AXC', 'AU-AXC (Aramac, Queensland, Australia)'),
    ('AU-AHS', 'AU-AHS (Arana Hills, Queensland, Australia)'),
    ('AU-ARY', 'AU-ARY (Ararat, Victoria, Australia)'),
    ('AU-R5T', 'AU-R5T (Arawata, Victoria, Australia)'),
    ('AU-ACD', 'AU-ACD (Arcadia, New South Wales, Australia)'),
    ('AU-AFL', 'AU-AFL (Archerfield, Queensland, Australia)'),
    ('AU-ATA', 'AU-ATA (Ardlethan, New South Wales, Australia)'),
    ('AU-AHK', 'AU-AHK (Ardross, Western Australia, Australia)'),
    ('AU-ARD', 'AU-ARD (Ardrossan, South Australia, Australia)'),
    ('AU-GYL', 'AU-GYL (Argyle, Western Australia, Australia)'),
    ('AU-AGY', 'AU-AGY (Argyle Downs, Western Australia, Australia)'),
    ('AU-AMD', 'AU-AMD (Armadale, Victoria, Australia)'),
    ('AU-AUA', 'AU-AUA (Armadale, Western Australia, Australia)'),
    ('AU-ARM', 'AU-ARM (Armidale, New South Wales, Australia)'),
    ('AU-ARC', 'AU-ARC (Arncliffe, New South Wales, Australia)'),
    ('AU-DLP', 'AU-DLP (Arndell Park, New South Wales, Australia)'),
    ('AU-AAB', 'AU-AAB (Arrabury, Queensland, Australia)'),
    ('AU-ART', 'AU-ART (Artarmon, New South Wales, Australia)'),
    ('AU-T6C', 'AU-T6C (Arthurs Creek, Victoria, Australia)'),
    ('AU-AMN', 'AU-AMN (Arthurs Creek, Victoria, Australia)'),
    ('AU-ARL', 'AU-ARL (Arundel, Queensland, Australia)'),
    ('AU-ACO', 'AU-ACO (Ascot, Western Australia, Australia)'),
    ('AU-ASF', 'AU-ASF (Ashfield, Western Australia, Australia)'),
    ('AU-FFH', 'AU-FFH (Ashfield, New South Wales, Australia)'),
    ('AU-ASC', 'AU-ASC (Ashgrove/Brisbane, Queensland, Australia)'),
    ('AU-ASH', 'AU-ASH (Ashton, South Australia, Australia)'),
    ('AU-AWD', 'AU-AWD (Ashwood, Victoria, Australia)'),
    ('AU-P6D', 'AU-P6D (Aspendale, Victoria, Australia)'),
    ('AU-APY', 'AU-APY (Aspley, Queensland, Australia)'),
    ('AU-ASQ', 'AU-ASQ (Asquith, New South Wales, Australia)'),
    ('AU-ATH', 'AU-ATH (Athelstone, South Australia, Australia)'),
    ('AU-ATN', 'AU-ATN (Atherton, Queensland, Australia)'),
    ('AU-APR', 'AU-APR (Athol Park, South Australia, Australia)'),
    ('AU-ATT', 'AU-ATT (Attadale, Western Australia, Australia)'),
    ('AU-RSE', 'AU-RSE (Au-Rose Bay, New South Wales, Australia)'),
    ('AU-WWG', 'AU-WWG (Aubin Grove, Western Australia, Australia)'),
    ('AU-ABN', 'AU-ABN (Auburn, South Australia, Australia)'),
    ('AU-AUB', 'AU-AUB (Auburn, New South Wales, Australia)'),
    ('AU-AGS', 'AU-AGS (Augusta, Western Australia, Australia)'),
    ('AU-AUD', 'AU-AUD (Augustus Downs, Queensland, Australia)'),
    ('AU-ALA', 'AU-ALA (Auldana, South Australia, Australia)'),
    ('AU-A7A', 'AU-A7A (Aura, Victoria, Australia)'),
    ('AU-AUU', 'AU-AUU (Aurukun Mission, Queensland, Australia)'),
    ('AU-AWP', 'AU-AWP (Aurukun Mission, Queensland, Australia)'),
    ('AU-ALI', 'AU-ALI (Australind, Western Australia, Australia)'),
    ('AU-AVG', 'AU-AVG (Australind, Western Australia, Australia)'),
    ('AU-AVV', 'AU-AVV (Avalon, Victoria, Australia)'),
    ('AU-AYQ', 'AU-AYQ (Avalon, Victoria, Australia)'),
    ('AU-AYR', 'AU-AYR (Ayr, Queensland, Australia)'),
    ('AU-BMS', 'AU-BMS (Bacchus Marsh, Victoria, Australia)'),
    ('AU-BCE', 'AU-BCE (Badger Creek, Victoria, Australia)'),
    ('AU-BDD', 'AU-BDD (Badu Island, Queensland, Australia)'),
    ('AU-BAE', 'AU-BAE (Baerami, New South Wales, Australia)'),
    ('AU-BSJ', 'AU-BSJ (Bairnsdale, Victoria, Australia)'),
    ('AU-BAK', 'AU-BAK (Bakers Creek, Queensland, Australia)'),
    ('AU-BLK', 'AU-BLK (Balaklava, South Australia, Australia)'),
    ('AU-LCN', 'AU-LCN (Balcanoona, South Australia, Australia)'),
    ('AU-BTT', 'AU-BTT (Balcatta, Western Australia, Australia)'),
    ('AU-A6L', 'AU-A6L (Balcombe, Victoria, Australia)'),
    ('AU-BQW', 'AU-BQW (Balgo Hills, Western Australia, Australia)'),
    ('AU-BWL', 'AU-BWL (Balgowlah, New South Wales, Australia)'),
    ('AU-BEG', 'AU-BEG (Balgowlah Heights, New South Wales, Australia)'),
    ('AU-BAA', 'AU-BAA (Balhannah, South Australia, Australia)'),
    ('AU-LLD', 'AU-LLD (Ballandean, Queensland, Australia)'),
    ('AU-BQA', 'AU-BQA (Ballarat, Victoria, Australia)'),
    ('AU-BAH', 'AU-BAH (Ballast Head, South Australia, Australia)'),
    ('AU-BNK', 'AU-BNK (Ballina, New South Wales, Australia)'),
    ('AU-BLM', 'AU-BLM (Balmain, New South Wales, Australia)'),
    ('AU-BAL', 'AU-BAL (Balnarring, Victoria, Australia)'),
    ('AU-R4A', 'AU-R4A (Balnarring Beach, Victoria, Australia)'),
    ('AU-BZD', 'AU-BZD (Balranald, New South Wales, Australia)'),
    ('AU-BWN', 'AU-BWN (Balwyn, Victoria, Australia)'),
    ('AU-ABM', 'AU-ABM (Bamaga, Queensland, Australia)'),
    ('AU-BAN', 'AU-BAN (Bandiana, Victoria, Australia)'),
    ('AU-BGW', 'AU-BGW (Bangalow, New South Wales, Australia)'),
    ('AU-LME', 'AU-LME (Bangholme, Victoria, Australia)'),
    ('AU-GBH', 'AU-GBH (Bangor, New South Wales, Australia)'),
    ('AU-BYX', 'AU-BYX (Bangor, New South Wales, Australia)'),
    ('AU-BMO', 'AU-BMO (Banksmeadow, New South Wales, Australia)'),
    ('AU-BWU', 'AU-BWU (Bankstown, New South Wales, Australia)'),
    ('AU-BNN', 'AU-BNN (Bannockburn, Victoria, Australia)'),
    ('AU-BYD', 'AU-BYD (Banyo, Queensland, Australia)'),
    ('AU-BCI', 'AU-BCI (Barcaldine, Queensland, Australia)'),
    ('AU-BRL', 'AU-BRL (Barellan, New South Wales, Australia)'),
    ('AU-BKP', 'AU-BKP (Barkly Downs, Queensland, Australia)'),
    ('AU-BRE', 'AU-BRE (Barmera, South Australia, Australia)'),
    ('AU-BNW', 'AU-BNW (Barnawartha, Victoria, Australia)'),
    ('AU-BPT', 'AU-BPT (Barney Point, Queensland, Australia)'),
    ('AU-RNG', 'AU-RNG (Barongarook, Victoria, Australia)'),
    ('AU-RTA', 'AU-RTA (Baroota, South Australia, Australia)'),
    ('AU-BWB', 'AU-BWB (Barrow Island, Western Australia, Australia)'),
    ('AU-BAR', 'AU-BAR (Barry Beach, Victoria, Australia)'),
    ('AU-RBG', 'AU-RBG (Barunga, South Australia, Australia)'),
    ('AU-BRH', 'AU-BRH (Barwon Heads, Victoria, Australia)'),
    ('AU-BR7', 'AU-BR7 (Basket Range, South Australia, Australia)'),
    ('AU-BSH', 'AU-BSH (Bass Hill, New South Wales, Australia)'),
    ('AU-BAS', 'AU-BAS (Bassendean, Western Australia, Australia)'),
    ('AU-BVW', 'AU-BVW (Batavia Downs, Queensland, Australia)'),
    ('AU-BUB', 'AU-BUB (Bateau Bay, New South Wales, Australia)'),
    ('AU-QBW', 'AU-QBW (Batemans Bay, New South Wales, Australia)'),
    ('AU-BHS', 'AU-BHS (Bathurst, New South Wales, Australia)'),
    ('AU-BRT', 'AU-BRT (Bathurst, New South Wales, Australia)'),
    ('AU-BTO', 'AU-BTO (Batlow, New South Wales, Australia)'),
    ('AU-BKH', 'AU-BKH (Baulkham Hills, New South Wales, Australia)'),
    ('AU-BXT', 'AU-BXT (Baxter, Victoria, Australia)'),
    ('AU-BDN', 'AU-BDN (Bayindeen, Victoria, Australia)'),
    ('AU-BYN', 'AU-BYN (Baynton, Western Australia, Australia)'),
    ('AU-BYS', 'AU-BYS (Bayswater, Victoria, Australia)'),
    ('AU-BYW', 'AU-BYW (Bayswater, Western Australia, Australia)'),
    ('AU-BYV', 'AU-BYV (Bayview, South Australia, Australia)'),
    ('AU-BCH', 'AU-BCH (Beachport, South Australia, Australia)'),
    ('AU-BOH', 'AU-BOH (Beacon Hill, New South Wales, Australia)'),
    ('AU-BEA', 'AU-BEA (Beaconsfield, Tasmania, Australia)'),
    ('AU-BPR', 'AU-BPR (Beaconsfield Upper, Victoria, Australia)'),
    ('AU-BEE', 'AU-BEE (Beagle Bay, Western Australia, Australia)'),
    ('AU-BDS', 'AU-BDS (Beaudesert, Queensland, Australia)'),
    ('AU-BUT', 'AU-BUT (Beaumont, South Australia, Australia)'),
    ('AU-BYP', 'AU-BYP (Beauty Point, Tasmania, Australia)'),
    ('AU-BEC', 'AU-BEC (Beckenham, Western Australia, Australia)'),
    ('AU-BKO', 'AU-BKO (Beckom, New South Wales, Australia)'),
    ('AU-BDW', 'AU-BDW (Bedford Downs, Western Australia, Australia)'),
    ('AU-BDF', 'AU-BDF (Bedford Park, South Australia, Australia)'),
    ('AU-BEU', 'AU-BEU (Bedourie, Queensland, Australia)'),
    ('AU-BHH', 'AU-BHH (Beechworth, Victoria, Australia)'),
    ('AU-BBL', 'AU-BBL (Beelbangera, New South Wales, Australia)'),
    ('AU-BLG', 'AU-BLG (Beenleigh, Queensland, Australia)'),
    ('AU-BEW', 'AU-BEW (Beerwah, Queensland, Australia)'),
    ('AU-QBE', 'AU-QBE (Bega, New South Wales, Australia)'),
    ('AU-BLC', 'AU-BLC (Bega, New South Wales, Australia)'),
    ('AU-LFD', 'AU-LFD (Belford, New South Wales, Australia)'),
    ('AU-L7E', 'AU-L7E (Belgrave, Victoria, Australia)'),
    ('AU-R5H', 'AU-R5H (Belgrave Heights, Victoria, Australia)'),
    ('AU-A5T', 'AU-A5T (Belgrave South, Victoria, Australia)'),
    ('AU-BEL', 'AU-BEL (Bell Bay, Tasmania, Australia)'),
    ('AU-BLV', 'AU-BLV (Bella Vista, New South Wales, Australia)'),
    ('AU-BEX', 'AU-BEX (Bellevue, Western Australia, Australia)'),
    ('AU-IUH', 'AU-IUH (Bellevue Hill, New South Wales, Australia)'),
    ('AU-NS3', 'AU-NS3 (Bellingen, New South Wales, Australia)'),
    ('AU-BEO', 'AU-BEO (Belmont, New South Wales, Australia)'),
    ('AU-BET', 'AU-BET (Belmont, Western Australia, Australia)'),
    ('AU-BQ9', 'AU-BQ9 (Belmont, Queensland, Australia)'),
    ('AU-BEM', 'AU-BEM (Belmore, New South Wales, Australia)'),
    ('AU-BE9', 'AU-BE9 (Belrose, New South Wales, Australia)'),
    ('AU-BVD', 'AU-BVD (Belvidere, South Australia, Australia)'),
    ('AU-BMK', 'AU-BMK (Bemboka, New South Wales, Australia)'),
    ('AU-BLN', 'AU-BLN (Benalla, Victoria, Australia)'),
    ('AU-BCB', 'AU-BCB (Bencubbin, Western Australia, Australia)'),
    ('AU-BM5', 'AU-BM5 (Bendemeer, New South Wales, Australia)'),
    ('AU-BMU', 'AU-BMU (Bendick Murrell, New South Wales, Australia)'),
    ('AU-BDG', 'AU-BDG (Bendigo, Victoria, Australia)'),
    ('AU-BGN', 'AU-BGN (Bennetts Green, New South Wales, Australia)'),
    ('AU-OWA', 'AU-OWA (Benowa, Queensland, Australia)'),
    ('AU-BEY', 'AU-BEY (Bentley, New South Wales, Australia)'),
    ('AU-BEN', 'AU-BEN (Bentliegh Vic, Victoria, Australia)'),
    ('AU-WRG', 'AU-WRG (Berambing, New South Wales, Australia)'),
    ('AU-BFD', 'AU-BFD (Beresfield, New South Wales, Australia)'),
    ('AU-BKE', 'AU-BKE (Berkeley Vale, New South Wales, Australia)'),
    ('AU-ZAA', 'AU-ZAA (Berowra, New South Wales, Australia)'),
    ('AU-BER', 'AU-BER (Berri, South Australia, Australia)'),
    ('AU-BRD', 'AU-BRD (Berridale, New South Wales, Australia)'),
    ('AU-TTM', 'AU-TTM (Berriedale, Tasmania, Australia)'),
    ('AU-BRG', 'AU-BRG (Berrigan, New South Wales, Australia)'),
    ('AU-VRB', 'AU-VRB (Berrima, New South Wales, Australia)'),
    ('AU-BRM', 'AU-BRM (Berrima, New South Wales, Australia)'),
    ('AU-BIB', 'AU-BIB (Berrinba, Queensland, Australia)'),
    ('AU-BRR', 'AU-BRR (Berrys Creek, Victoria, Australia)'),
    ('AU-WV5', 'AU-WV5 (Berwick, Victoria, Australia)'),
    ('AU-BTX', 'AU-BTX (Betoota, Queensland, Australia)'),
    ('AU-ABC', 'AU-ABC (Beulah, Victoria, Australia)'),
    ('AU-BVV', 'AU-BVV (Beverford, Victoria, Australia)'),
    ('AU-BVS', 'AU-BVS (Beverley, South Australia, Australia)'),
    ('AU-BVY', 'AU-BVY (Beverley, Western Australia, Australia)'),
    ('AU-BVZ', 'AU-BVZ (Beverley Springs, Western Australia, Australia)'),
    ('AU-XBY', 'AU-XBY (Bexley, New South Wales, Australia)'),
    ('AU-BBU', 'AU-BBU (Bibbenluke, New South Wales, Australia)'),
    ('AU-BLA', 'AU-BLA (Bibra Lake, Western Australia, Australia)'),
    ('AU-BIC', 'AU-BIC (Bicheno, Tasmania, Australia)'),
    ('AU-BCZ', 'AU-BCZ (Bicheno, Tasmania, Australia)'),
    ('AU-BNT', 'AU-BNT (Bicton, Western Australia, Australia)'),
    ('AU-BBE', 'AU-BBE (Big Bell, Western Australia, Australia)'),
    ('AU-BGG', 'AU-BGG (Biggera Waters, Queensland, Australia)'),
    ('AU-BIG', 'AU-BIG (Bilinga, Queensland, Australia)'),
    ('AU-BIW', 'AU-BIW (Billiluna, Western Australia, Australia)'),
    ('AU-BIL', 'AU-BIL (Billinudgel, New South Wales, Australia)'),
    ('AU-BLO', 'AU-BLO (Biloela, Queensland, Australia)'),
    ('AU-BNG', 'AU-BNG (Binalong, New South Wales, Australia)'),
    ('AU-BBG', 'AU-BBG (Binalong, New South Wales, Australia)'),
    ('AU-BBR', 'AU-BBR (Binna Burra, New South Wales, Australia)'),
    ('AU-BIN', 'AU-BIN (Binningup, Western Australia, Australia)'),
    ('AU-BNM', 'AU-BNM (Binnum, South Australia, Australia)'),
    ('AU-BYA', 'AU-BYA (Binya, New South Wales, Australia)'),
    ('AU-BVI', 'AU-BVI (Birdsville, Queensland, Australia)'),
    ('AU-VRR', 'AU-VRR (Birdwood, South Australia, Australia)'),
    ('AU-BKD', 'AU-BKD (Birkdale, Queensland, Australia)'),
    ('AU-BIR', 'AU-BIR (Birkenhead, South Australia, Australia)'),
    ('AU-T6T', 'AU-T6T (Bittern, Victoria, Australia)'),
    ('AU-BZP', 'AU-BZP (Bizant, Queensland, Australia)'),
    ('AU-BLP', 'AU-BLP (Bizant, Queensland, Australia)'),
    ('AU-BKQ', 'AU-BKQ (Blackall, Queensland, Australia)'),
    ('AU-BBT', 'AU-BBT (Blackbutt, Queensland, Australia)'),
    ('AU-TTS', 'AU-TTS (Blackmans Bay, Tasmania, Australia)'),
    ('AU-BOV', 'AU-BOV (Blackmans Bay, Tasmania, Australia)'),
    ('AU-BCO', 'AU-BCO (Blacktown, New South Wales, Australia)'),
    ('AU-BLT', 'AU-BLT (Blackwater, Queensland, Australia)'),
    ('AU-BWD', 'AU-BWD (Blackwater, Queensland, Australia)'),
    ('AU-BGE', 'AU-BGE (Blairgowrie, Victoria, Australia)'),
    ('AU-ZZK', 'AU-ZZK (Blakehurst, New South Wales, Australia)'),
    ('AU-BW5', 'AU-BW5 (Blanche Town, South Australia, Australia)'),
    ('AU-BNY', 'AU-BNY (Blayney, New South Wales, Australia)'),
    ('AU-BLI', 'AU-BLI (Blenheim, Queensland, Australia)'),
    ('AU-BWS', 'AU-BWS (Blewitts Springs, South Australia, Australia)'),
    ('AU-BGY', 'AU-BGY (Blighty, New South Wales, Australia)'),
    ('AU-BFC', 'AU-BFC (Bloomfield, Queensland, Australia)'),
    ('AU-BOB', 'AU-BOB (Bobin, New South Wales, Australia)'),
    ('AU-BLE', 'AU-BLE (Bohle, Queensland, Australia)'),
    ('AU-GIC', 'AU-GIC (Boigu Island, Queensland, Australia)'),
    ('AU-BLS', 'AU-BLS (Bollon, Queensland, Australia)'),
    ('AU-BCK', 'AU-BCK (Bolwarra, Queensland, Australia)'),
    ('AU-BDY', 'AU-BDY (Bomaderry, New South Wales, Australia)'),
    ('AU-BMA', 'AU-BMA (Bombala, New South Wales, Australia)'),
    ('AU-7BM', 'AU-7BM (Bomen, New South Wales, Australia)'),
    ('AU-B3B', 'AU-B3B (Bonbeach, Victoria, Australia)'),
    ('AU-BBC', 'AU-BBC (Bondi Beach, New South Wales, Australia)'),
    ('AU-BJT', 'AU-BJT (Bondi Junction, New South Wales, Australia)'),
    ('AU-BLB', 'AU-BLB (Bonnells Bay, New South Wales, Australia)'),
    ('AU-BQY', 'AU-BQY (Bonnet Bay, New South Wales, Australia)'),
    ('AU-BEV', 'AU-BEV (Bonnie Vale, Western Australia, Australia)'),
    ('AU-BOO', 'AU-BOO (Booby Island, Queensland, Australia)'),
    ('AU-BOD', 'AU-BOD (Boondall, Queensland, Australia)'),
    ('AU-BGO', 'AU-BGO (Booragoon, Western Australia, Australia)'),
    ('AU-BOT', 'AU-BOT (Boort, Victoria, Australia)'),
    ('AU-VIB', 'AU-VIB (Boronia, Victoria, Australia)'),
    ('AU-BOX', 'AU-BOX (Boronia, Victoria, Australia)'),
    ('AU-B2P', 'AU-B2P (Bossley Park, New South Wales, Australia)'),
    ('AU-BTB', 'AU-BTB (Botany Bay, New South Wales, Australia)'),
    ('AU-BLD', 'AU-BLD (Boulder, Western Australia, Australia)'),
    ('AU-BQL', 'AU-BQL (Boulia, Queensland, Australia)'),
    ('AU-BOU', 'AU-BOU (Boundary Bend, New South Wales, Australia)'),
    ('AU-BRK', 'AU-BRK (Bourke, New South Wales, Australia)'),
    ('AU-ZBO', 'AU-ZBO (Bowen, Queensland, Australia)'),
    ('AU-BWW', 'AU-BWW (Bowen Hills, Queensland, Australia)'),
    ('AU-BWV', 'AU-BWV (Bowenville, Queensland, Australia)'),
    ('AU-BWG', 'AU-BWG (Bowning, New South Wales, Australia)'),
    ('AU-BWA', 'AU-BWA (Bowral, New South Wales, Australia)'),
    ('AU-BXH', 'AU-BXH (Box Hill, Victoria, Australia)'),
    ('AU-BXI', 'AU-BXI (Box Hill, New South Wales, Australia)'),
    ('AU-AYB', 'AU-AYB (Boya, Western Australia, Australia)'),
    ('AU-BYU', 'AU-BYU (Boyanup, Western Australia, Australia)'),
    ('AU-BOY', 'AU-BOY (Boyer, Tasmania, Australia)'),
    ('AU-BOI', 'AU-BOI (Boyne Island, Queensland, Australia)'),
    ('AU-BYB', 'AU-BYB (Boyup Brook, Western Australia, Australia)'),
    ('AU-BCR', 'AU-BCR (Bracken Ridge, Queensland, Australia)'),
    ('AU-BMR', 'AU-BMR (Braemar, New South Wales, Australia)'),
    ('AU-BRS', 'AU-BRS (Braeside, Victoria, Australia)'),
    ('AU-BMP', 'AU-BMP (Brampton, Queensland, Australia)'),
    ('AU-TXB', 'AU-TXB (Branxton, New South Wales, Australia)'),
    ('AU-BRB', 'AU-BRB (Braybrook, Victoria, Australia)'),
    ('AU-BBY', 'AU-BBY (Bremer Bay, Western Australia, Australia)'),
    ('AU-BDE', 'AU-BDE (Brendale, Queensland, Australia)'),
    ('AU-BWQ', 'AU-BWQ (Brewarrina, New South Wales, Australia)'),
    ('AU-BGT', 'AU-BGT (Bridgetown, Western Australia, Australia)'),
    ('AU-BGR', 'AU-BGR (Bridgewater, Tasmania, Australia)'),
    ('AU-BOL', 'AU-BOL (Bridgewater-on-Loddon, Victoria, Australia)'),
    ('AU-BPO', 'AU-BPO (Bridport, Tasmania, Australia)'),
    ('AU-BRI', 'AU-BRI (Brigalow, New South Wales, Australia)'),
    ('AU-BRW', 'AU-BRW (Brigalow, Queensland, Australia)'),
    ('AU-BRJ', 'AU-BRJ (Bright, Victoria, Australia)'),
    ('AU-BRO', 'AU-BRO (Brighton, South Australia, Australia)'),
    ('AU-BTV', 'AU-BTV (Brighton, Victoria, Australia)'),
    ('AU-BHT', 'AU-BHT (Brighton Downs, Queensland, Australia)'),
    ('AU-BSA', 'AU-BSA (Brighton-Le-Sands, New South Wales, Australia)'),
    ('AU-BIY', 'AU-BIY (Bringelly, New South Wales, Australia)'),
    ('AU-BNE', 'AU-BNE (Brisbane, Queensland, Australia)'),
    ('AU-BRA', 'AU-BRA (Brisbane Apt, Queensland, Australia)'),
    ('AU-WTB', 'AU-WTB (Brisbane West Wellcamp Airport, Queensland, Australia)'),
    ('AU-BBA', 'AU-BBA (Broadbeach, Queensland, Australia)'),
    ('AU-BFR', 'AU-BFR (Broadford, Victoria, Australia)'),
    ('AU-BMD', 'AU-BMD (Broadmeadows, New South Wales, Australia)'),
    ('AU-BMW', 'AU-BMW (Broadmeadows, Victoria, Australia)'),
    ('AU-BOW', 'AU-BOW (Broadwood, Western Australia, Australia)'),
    ('AU-NSB', 'AU-NSB (Broke, New South Wales, Australia)'),
    ('AU-BHQ', 'AU-BHQ (Broken Hill, New South Wales, Australia)'),
    ('AU-2WS', 'AU-2WS (Brooklyn, New South Wales, Australia)'),
    ('AU-BKL', 'AU-BKL (Brooklyn, Victoria, Australia)'),
    ('AU-BPK', 'AU-BPK (Brooklyn Park, South Australia, Australia)'),
    ('AU-BKT', 'AU-BKT (Brookton, Western Australia, Australia)'),
    ('AU-BVE', 'AU-BVE (Brookvale/Sidney, New South Wales, Australia)'),
    ('AU-BVL', 'AU-BVL (Brookville, Victoria, Australia)'),
    ('AU-BME', 'AU-BME (Broome, Western Australia, Australia)'),
    ('AU-BRQ', 'AU-BRQ (Brooweena, Queensland, Australia)'),
    ('AU-BTD', 'AU-BTD (Brooweena, Queensland, Australia)'),
    ('AU-BRU', 'AU-BRU (Brunswich, Victoria, Australia)'),
    ('AU-BWK', 'AU-BWK (Brunswick, Victoria, Australia)'),
    ('AU-UBD', 'AU-UBD (Buderim, Queensland, Australia)'),
    ('AU-BUV', 'AU-BUV (Buderim, Queensland, Australia)'),
    ('AU-BDA', 'AU-BDA (Bulahdelah, New South Wales, Australia)'),
    ('AU-BIP', 'AU-BIP (Bulimba, Queensland, Australia)'),
    ('AU-BNX', 'AU-BNX (Bulleen, Victoria, Australia)'),
    ('AU-BUL', 'AU-BUL (Bulli, New South Wales, Australia)'),
    ('AU-BLL', 'AU-BLL (Bullsbrook, Western Australia, Australia)'),
    ('AU-BWI', 'AU-BWI (Bulwer, Queensland, Australia)'),
    ('AU-AUC', 'AU-AUC (Bunbartha, Victoria, Australia)'),
    ('AU-BUY', 'AU-BUY (Bunbury, Western Australia, Australia)'),
    ('AU-BDB', 'AU-BDB (Bundaberg, Queensland, Australia)'),
    ('AU-BND', 'AU-BND (Bundall, Queensland, Australia)'),
    ('AU-BDM', 'AU-BDM (Bundamba, Queensland, Australia)'),
    ('AU-BXA', 'AU-BXA (Bundeena, New South Wales, Australia)'),
    ('AU-BUN', 'AU-BUN (Bundoora, Victoria, Australia)'),
    ('AU-BLW', 'AU-BLW (Bungalow, Queensland, Australia)'),
    ('AU-EGO', 'AU-EGO (Bungendore, New South Wales, Australia)'),
    ('AU-BGA', 'AU-BGA (Bungwahl, New South Wales, Australia)'),
    ('AU-VBY', 'AU-VBY (Buninyong, Victoria, Australia)'),
    ('AU-AMK', 'AU-AMK (Bunyip, Victoria, Australia)'),
    ('AU-BUC', 'AU-BUC (Burketown, Queensland, Australia)'),
    ('AU-BLH', 'AU-BLH (Burleigh Heads, Queensland, Australia)'),
    ('AU-BWT', 'AU-BWT (Burnie, Tasmania, Australia)'),
    ('AU-BLY', 'AU-BLY (Burnley, Victoria, Australia)'),
    ('AU-BRN', 'AU-BRN (Burnside, South Australia, Australia)'),
    ('AU-BUA', 'AU-BUA (Buronga, New South Wales, Australia)'),
    ('AU-BPG', 'AU-BPG (Burpengary, Queensland, Australia)'),
    ('AU-BR2', 'AU-BR2 (Burra, South Australia, Australia)'),
    ('AU-BZU', 'AU-BZU (Burraneer, New South Wales, Australia)'),
    ('AU-BJU', 'AU-BJU (Burren Junction, New South Wales, Australia)'),
    ('AU-BGB', 'AU-BGB (Burringbar, New South Wales, Australia)'),
    ('AU-BRP', 'AU-BRP (Burrup, Western Australia, Australia)'),
    ('AU-BWO', 'AU-BWO (Burswood, Western Australia, Australia)'),
    ('AU-BUO', 'AU-BUO (Burton, South Australia, Australia)'),
    ('AU-BBW', 'AU-BBW (Burwood, New South Wales, Australia)'),
    ('AU-BUW', 'AU-BUW (Burwood, Victoria, Australia)'),
    ('AU-BWE', 'AU-BWE (Burwood East, Victoria, Australia)'),
    ('AU-BYY', 'AU-BYY (Bushy Park, Victoria, Australia)'),
    ('AU-BUS', 'AU-BUS (Busselton, Western Australia, Australia)'),
    ('AU-UQF', 'AU-UQF (Bute, South Australia, Australia)'),
    ('AU-BYF', 'AU-BYF (Byford, Western Australia, Australia)'),
    ('AU-S2E', 'AU-S2E (Bylands, Victoria, Australia)'),
    ('AU-BAY', 'AU-BAY (Byron Bay, New South Wales, Australia)'),
    ('AU-CAB', 'AU-CAB (Caboolture, Queensland, Australia)'),
    ('AU-CGE', 'AU-CGE (Cadgee, South Australia, Australia)'),
    ('AU-CDX', 'AU-CDX (Cadoux, Western Australia, Australia)'),
    ('AU-CGV', 'AU-CGV (Caiguna, Western Australia, Australia)'),
    ('AU-CNS', 'AU-CNS (Cairns, Queensland, Australia)'),
    ('AU-CUD', 'AU-CUD (Caloundra, Queensland, Australia)'),
    ('AU-CAL', 'AU-CAL (Caloundra Head, Queensland, Australia)'),
    ('AU-CAM', 'AU-CAM (Camberwell, Victoria, Australia)'),
    ('AU-CMB', 'AU-CMB (Cambridge, Tasmania, Australia)'),
    ('AU-CDU', 'AU-CDU (Camden, New South Wales, Australia)'),
    ('AU-CIA', 'AU-CIA (Camellia, New South Wales, Australia)'),
    ('AU-CFI', 'AU-CFI (Camellia, New South Wales, Australia)'),
    ('AU-CML', 'AU-CML (Camooweal, Queensland, Australia)'),
    ('AU-CPA', 'AU-CPA (Campania, Tasmania, Australia)'),
    ('AU-CPB', 'AU-CPB (Campania, Tasmania, Australia)'),
    ('AU-CFL', 'AU-CFL (Campbellfield, Victoria, Australia)'),
    ('AU-CPC', 'AU-CPC (Campbells Creek, Victoria, Australia)'),
    ('AU-CBN', 'AU-CBN (Campbelltown, New South Wales, Australia)'),
    ('AU-CMT', 'AU-CMT (Campbelltown, South Australia, Australia)'),
    ('AU-CMP', 'AU-CMP (Camperdown, New South Wales, Australia)'),
    ('AU-CPW', 'AU-CPW (Camperdown, Victoria, Australia)'),
    ('AU-CBR', 'AU-CBR (Camperdown, Victoria, Australia)'),
    ('AU-CNN', 'AU-CNN (Canning Vale/Perth, Western Australia, Australia)'),
    ('AU-CNT', 'AU-CNT (Cannington, Western Australia, Australia)'),
    ('AU-CAH', 'AU-CAH (Cannon Hill, Queensland, Australia)'),
    ('AU-CBY', 'AU-CBY (Canobie, Queensland, Australia)'),
    ('AU-CDS', 'AU-CDS (Canoelands, New South Wales, Australia)'),
    ('AU-JWI', 'AU-JWI (Canowindra, New South Wales, Australia)'),
    ('AU-NCT', 'AU-NCT (Canterbury, New South Wales, Australia)'),
    ('AU-VRY', 'AU-VRY (Canterbury, Victoria, Australia)'),
    ('AU-NBC', 'AU-NBC (Canungra, Queensland, Australia)'),
    ('AU-CAP', 'AU-CAP (Capalaba, Queensland, Australia)'),
    ('AU-CBI', 'AU-CBI (Cape Barren Island, Tasmania, Australia)'),
    ('AU-CCU', 'AU-CCU (Cape Cuvier, Western Australia, Australia)'),
    ('AU-DON', 'AU-DON (Cape Cuvier, Western Australia, Australia)'),
    ('AU-CQP', 'AU-CQP (Cape Flattery, Queensland, Australia)'),
    ('AU-CLT', 'AU-CLT (Cape Lambert, Western Australia, Australia)'),
    ('AU-CLN', 'AU-CLN (Cape Leeuwin, Western Australia, Australia)'),
    ('AU-CPN', 'AU-CPN (Cape Preston, Western Australia, Australia)'),
    ('AU-CPL', 'AU-CPL (Capel, Western Australia, Australia)'),
    ('AU-CBD', 'AU-CBD (Carabooda, Western Australia, Australia)'),
    ('AU-CBO', 'AU-CBO (Carboor, Victoria, Australia)'),
    ('AU-CRK', 'AU-CRK (Carbrook, Queensland, Australia)'),
    ('AU-UUP', 'AU-UUP (Carbunup, Western Australia, Australia)'),
    ('AU-CDF', 'AU-CDF (Cardiff, New South Wales, Australia)'),
    ('AU-CGL', 'AU-CGL (Carey Gully, South Australia, Australia)'),
    ('AU-CG4', 'AU-CG4 (Cargo, New South Wales, Australia)'),
    ('AU-CAR', 'AU-CAR (Carina Heights, Queensland, Australia)'),
    ('AU-CDL', 'AU-CDL (Carindale, Queensland, Australia)'),
    ('AU-CNE', 'AU-CNE (Carine, Western Australia, Australia)'),
    ('AU-CRG', 'AU-CRG (Caringbah, New South Wales, Australia)'),
    ('AU-CLF', 'AU-CLF (Carlingford, New South Wales, Australia)'),
    ('AU-CRT', 'AU-CRT (Carlton, Victoria, Australia)'),
    ('AU-CRY', 'AU-CRY (Carlton Hill, Western Australia, Australia)'),
    ('AU-CR2', 'AU-CR2 (Carlton River, Tasmania, Australia)'),
    ('AU-CVQ', 'AU-CVQ (Carnarvon, Western Australia, Australia)'),
    ('AU-UCG', 'AU-UCG (Carnegie, Victoria, Australia)'),
    ('AU-CRP', 'AU-CRP (Carole Park, Queensland, Australia)'),
    ('AU-SRS', 'AU-SRS (Caroline Springs, Victoria, Australia)'),
    ('AU-CFP', 'AU-CFP (Carpentaria Downs, Queensland, Australia)'),
    ('AU-CRA', 'AU-CRA (Carrara, Queensland, Australia)'),
    ('AU-CRR', 'AU-CRR (Carrington, New South Wales, Australia)'),
    ('AU-CAD', 'AU-CAD (Carrum Downs, Victoria, Australia)'),
    ('AU-CSI', 'AU-CSI (Casino, New South Wales, Australia)'),
    ('AU-CTC', 'AU-CTC (Castle Cove, New South Wales, Australia)'),
    ('AU-CHI', 'AU-CHI (Castle Hill, New South Wales, Australia)'),
    ('AU-CSX', 'AU-CSX (Castlecrag, New South Wales, Australia)'),
    ('AU-CSM', 'AU-CSM (Castlemaine, Victoria, Australia)'),
    ('AU-CAS', 'AU-CAS (Castlereagh, New South Wales, Australia)'),
    ('AU-CZA', 'AU-CZA (Casuarina, New South Wales, Australia)'),
    ('AU-S9S', 'AU-S9S (Casula, New South Wales, Australia)'),
    ('AU-CTB', 'AU-CTB (Cataby, Western Australia, Australia)'),
    ('AU-CHB', 'AU-CHB (Catherine Hill Bay, New South Wales, Australia)'),
    ('AU-CTR', 'AU-CTR (Catherine Hill Bay, New South Wales, Australia)'),
    ('AU-CUN', 'AU-CUN (Caufield North, Victoria, Australia)'),
    ('AU-CLD', 'AU-CLD (Caulfield, Victoria, Australia)'),
    ('AU-CAV', 'AU-CAV (Cavan, South Australia, Australia)'),
    ('AU-CVS', 'AU-CVS (Caversham, Western Australia, Australia)'),
    ('AU-C8M', 'AU-C8M (Caves Beach, New South Wales, Australia)'),
    ('AU-CED', 'AU-CED (Ceduna, South Australia, Australia)'),
    ('AU-CES', 'AU-CES (Cessnock, New South Wales, Australia)'),
    ('AU-CHD', 'AU-CHD (Chadstone/Melbourne, Victoria, Australia)'),
    ('AU-CWK', 'AU-CWK (Chadwick, Western Australia, Australia)'),
    ('AU-CHV', 'AU-CHV (Chadwick, Western Australia, Australia)'),
    ('AU-DLH', 'AU-DLH (Chadwick, Western Australia, Australia)'),
    ('AU-CTL', 'AU-CTL (Charleville, Queensland, Australia)'),
    ('AU-HOC', 'AU-HOC (Charlton, Victoria, Australia)'),
    ('AU-CXT', 'AU-CXT (Charters Towers, Queensland, Australia)'),
    ('AU-CHA', 'AU-CHA (Chatswood, New South Wales, Australia)'),
    ('AU-CWI', 'AU-CWI (Chatsworth Island, New South Wales, Australia)'),
    ('AU-S2R', 'AU-S2R (Chelsea, Victoria, Australia)'),
    ('AU-CHL', 'AU-CHL (Cheltenham/Melbourne, Victoria, Australia)'),
    ('AU-CHE', 'AU-CHE (Chermside, Queensland, Australia)'),
    ('AU-CBC', 'AU-CBC (Cherrabun, Western Australia, Australia)'),
    ('AU-CRH', 'AU-CRH (Cherribah, Queensland, Australia)'),
    ('AU-YRN', 'AU-YRN (Cherry Gardens, South Australia, Australia)'),
    ('AU-CYB', 'AU-CYB (Cherrybook, New South Wales, Australia)'),
    ('AU-UTH', 'AU-UTH (Cheshunt, Victoria, Australia)'),
    ('AU-ATL', 'AU-ATL (Chester Hill, New South Wales, Australia)'),
    ('AU-CHF', 'AU-CHF (Chifley, New South Wales, Australia)'),
    ('AU-CHS', 'AU-CHS (Childers, Queensland, Australia)'),
    ('AU-LLG', 'AU-LLG (Chillagoe, Queensland, Australia)'),
    ('AU-CCL', 'AU-CCL (Chinchilla, Queensland, Australia)'),
    ('AU-CN6', 'AU-CN6 (Chinderah, New South Wales, Australia)'),
    ('AU-DPP', 'AU-DPP (Chippendale, New South Wales, Australia)'),
    ('AU-CHN', 'AU-CHN (Chipping Norton, New South Wales, Australia)'),
    ('AU-CHT', 'AU-CHT (Chittering, Western Australia, Australia)'),
    ('AU-CXQ', 'AU-CXQ (Christmas Creek, Western Australia, Australia)'),
    ('AU-CHU', 'AU-CHU (Chullora, New South Wales, Australia)'),
    ('AU-CCH', 'AU-CCH (Churchill, Victoria, Australia)'),
    ('AU-TYC', 'AU-TYC (City Beach, Western Australia, Australia)'),
    ('AU-CPH', 'AU-CPH (Clapham, South Australia, Australia)'),
    ('AU-SCL', 'AU-SCL (Clare, South Australia, Australia)'),
    ('AU-CLM', 'AU-CLM (Claremont, Western Australia, Australia)'),
    ('AU-CLR', 'AU-CLR (Clarence River, New South Wales, Australia)'),
    ('AU-CDN', 'AU-CDN (Clarendon, South Australia, Australia)'),
    ('AU-V5V', 'AU-V5V (Clareville, New South Wales, Australia)'),
    ('AU-SNN', 'AU-SNN (Clarkson, Western Australia, Australia)'),
    ('AU-CAY', 'AU-CAY (Clayton, Queensland, Australia)'),
    ('AU-CLY', 'AU-CLY (Clayton/Melbourne, Victoria, Australia)'),
    ('AU-CMQ', 'AU-CMQ (Clermont, Queensland, Australia)'),
    ('AU-CVC', 'AU-CVC (Cleve, South Australia, Australia)'),
    ('AU-CVN', 'AU-CVN (Cleveland, Queensland, Australia)'),
    ('AU-CFT', 'AU-CFT (Clifton, Queensland, Australia)'),
    ('AU-CFH', 'AU-CFH (Clifton Hills, South Australia, Australia)'),
    ('AU-CNJ', 'AU-CNJ (Cloncurry, Queensland, Australia)'),
    ('AU-CLO', 'AU-CLO (Clontarf, Queensland, Australia)'),
    ('AU-CTF', 'AU-CTF (Clontarf, New South Wales, Australia)'),
    ('AU-CVL', 'AU-CVL (Clovelly, New South Wales, Australia)'),
    ('AU-CLP', 'AU-CLP (Clovelly Park, South Australia, Australia)'),
    ('AU-CLU', 'AU-CLU (Clunes, New South Wales, Australia)'),
    ('AU-CZY', 'AU-CZY (Cluny, Queensland, Australia)'),
    ('AU-CYD', 'AU-CYD (Clyde, New South Wales, Australia)'),
    ('AU-S2A', 'AU-S2A (Clyde, Victoria, Australia)'),
    ('AU-CAZ', 'AU-CAZ (Cobar, New South Wales, Australia)'),
    ('AU-OBR', 'AU-OBR (Cobram, Victoria, Australia)'),
    ('AU-CBG', 'AU-CBG (Coburg, Victoria, Australia)'),
    ('AU-CTI', 'AU-CTI (Cockatoo Island, Western Australia, Australia)'),
    ('AU-CNC', 'AU-CNC (Coconut Island, Queensland, Australia)'),
    ('AU-DGQ', 'AU-DGQ (Codrington, Victoria, Australia)'),
    ('AU-CUQ', 'AU-CUQ (Coen, Queensland, Australia)'),
    ('AU-CFS', 'AU-CFS (Coffs Harbour, New South Wales, Australia)'),
    ('AU-GIR', 'AU-GIR (Coghills Creek, Victoria, Australia)'),
    ('AU-XCO', 'AU-XCO (Colac, Victoria, Australia)'),
    ('AU-CON', 'AU-CON (Colbinabbin, Victoria, Australia)'),
    ('AU-CST', 'AU-CST (Coldstream, Victoria, Australia)'),
    ('AU-IGA', 'AU-IGA (Colignan, Victoria, Australia)'),
    ('AU-CLL', 'AU-CLL (Collan Islands, Western Australia, Australia)'),
    ('AU-CRB', 'AU-CRB (Collarenebri, New South Wales, Australia)'),
    ('AU-OYL', 'AU-OYL (Collaroy, New South Wales, Australia)'),
    ('AU-LTE', 'AU-LTE (Collector, New South Wales, Australia)'),
    ('AU-CIE', 'AU-CIE (Collie, Western Australia, Australia)'),
    ('AU-OOC', 'AU-OOC (Collingwood, Victoria, Australia)'),
    ('AU-KCE', 'AU-KCE (Collinsville, Queensland, Australia)'),
    ('AU-IWS', 'AU-IWS (Collinswood, South Australia, Australia)'),
    ('AU-CUL', 'AU-CUL (Columboola, Queensland, Australia)'),
    ('AU-CMO', 'AU-CMO (Como, New South Wales, Australia)'),
    ('AU-ORN', 'AU-ORN (Concord, New South Wales, Australia)'),
    ('AU-HDC', 'AU-HDC (Condah, Victoria, Australia)'),
    ('AU-CDE', 'AU-CDE (Condamine, Queensland, Australia)'),
    ('AU-CBX', 'AU-CBX (Condobolin, New South Wales, Australia)'),
    ('AU-CVP', 'AU-CVP (Connells Point, New South Wales, Australia)'),
    ('AU-CO2', 'AU-CO2 (Connewarre, Victoria, Australia)'),
    ('AU-CPD', 'AU-CPD (Coober Pedy, South Australia, Australia)'),
    ('AU-CEI', 'AU-CEI (Coode Island, Victoria, Australia)'),
    ('AU-CEE', 'AU-CEE (Cooee, Tasmania, Australia)'),
    ('AU-CXE', 'AU-CXE (Coogee, New South Wales, Australia)'),
    ('AU-CDA', 'AU-CDA (Coogee, New South Wales, Australia)'),
    ('AU-CTN', 'AU-CTN (Cooktown, Queensland, Australia)'),
    ('AU-CLB', 'AU-CLB (Coolabah, New South Wales, Australia)'),
    ('AU-CLH', 'AU-CLH (Coolah, New South Wales, Australia)'),
    ('AU-CLA', 'AU-CLA (Coolamon, New South Wales, Australia)'),
    ('AU-COL', 'AU-COL (Coolaroo, Victoria, Australia)'),
    ('AU-COY', 'AU-COY (Coolawanyah, Western Australia, Australia)'),
    ('AU-CGA', 'AU-CGA (Coolgardie, Western Australia, Australia)'),
    ('AU-COB', 'AU-COB (Coolgardie, Western Australia, Australia)'),
    ('AU-COU', 'AU-COU (Coolum, Queensland, Australia)'),
    ('AU-COM', 'AU-COM (Cooma, New South Wales, Australia)'),
    ('AU-CKM', 'AU-CKM (Coomba Park, New South Wales, Australia)'),
    ('AU-COO', 'AU-COO (Coomera, Queensland, Australia)'),
    ('AU-YMN', 'AU-YMN (Coominya, Queensland, Australia)'),
    ('AU-COJ', 'AU-COJ (Coonabarabran, New South Wales, Australia)'),
    ('AU-CNB', 'AU-CNB (Coonamble, New South Wales, Australia)'),
    ('AU-CNW', 'AU-CNW (Coonawarra, South Australia, Australia)'),
    ('AU-CPS', 'AU-CPS (Coopers Plains, Queensland, Australia)'),
    ('AU-CRJ', 'AU-CRJ (Coorabie, South Australia, Australia)'),
    ('AU-COG', 'AU-COG (Cooranbong, New South Wales, Australia)'),
    ('AU-CPR', 'AU-CPR (Coorparoo, Queensland, Australia)'),
    ('AU-CMD', 'AU-CMD (Cootamundra, New South Wales, Australia)'),
    ('AU-CRL', 'AU-CRL (Coral Bay, Western Australia, Australia)'),
    ('AU-CRS', 'AU-CRS (Coral Bay, Western Australia, Australia)'),
    ('AU-CDR', 'AU-CDR (Cordalba, Queensland, Australia)'),
    ('AU-ODL', 'AU-ODL (Cordillo Downs, South Australia, Australia)'),
    ('AU-CBA', 'AU-CBA (Corio Bay, Victoria, Australia)'),
    ('AU-CRV', 'AU-CRV (Coromandel Valley, South Australia, Australia)'),
    ('AU-CWW', 'AU-CWW (Corowa, New South Wales, Australia)'),
    ('AU-CYG', 'AU-CYG (Corryong, Victoria, Australia)'),
    ('AU-COP', 'AU-COP (Cossack Pioneer (oil terminal), Western Australia, Australia)'),
    ('AU-CTE', 'AU-CTE (Cottesloe, Western Australia, Australia)'),
    ('AU-CTT', 'AU-CTT (Cottles Bridge, Victoria, Australia)'),
    ('AU-DIL', 'AU-DIL (Cowandilla, South Australia, Australia)'),
    ('AU-COW', 'AU-COW (Cowandilla, South Australia, Australia)'),
    ('AU-CWR', 'AU-CWR (Cowarie, South Australia, Australia)'),
    ('AU-CCW', 'AU-CCW (Cowell, South Australia, Australia)'),
    ('AU-ESS', 'AU-ESS (Cowes, South Australia, Australia)'),
    ('AU-CWT', 'AU-CWT (Cowra, New South Wales, Australia)'),
    ('AU-DOC', 'AU-DOC (Cradoc, Tasmania, Australia)'),
    ('AU-CRF', 'AU-CRF (Crafers, South Australia, Australia)'),
    ('AU-CVA', 'AU-CVA (Craigieburn, Victoria, Australia)'),
    ('AU-KRR', 'AU-KRR (Cranbrook, Western Australia, Australia)'),
    ('AU-RRK', 'AU-RRK (Cranbrook, Tasmania, Australia)'),
    ('AU-CBK', 'AU-CBK (Cranebrook, New South Wales, Australia)'),
    ('AU-CRW', 'AU-CRW (Crawley, Western Australia, Australia)'),
    ('AU-CMN', 'AU-CMN (Cremorne, New South Wales, Australia)'),
    ('AU-CMR', 'AU-CMR (Cremorne, Victoria, Australia)'),
    ('AU-CSD', 'AU-CSD (Cremorne, Victoria, Australia)'),
    ('AU-TAS', 'AU-TAS (Cressy, Tasmania, Australia)'),
    ('AU-CRE', 'AU-CRE (Crestmead, Queensland, Australia)'),
    ('AU-EKW', 'AU-EKW (Creswick, Victoria, Australia)'),
    ('AU-CPT', 'AU-CPT (Crib Point, Victoria, Australia)'),
    ('AU-CRI', 'AU-CRI (Cringila, New South Wales, Australia)'),
    ('AU-CKI', 'AU-CKI (Cringila, New South Wales, Australia)'),
    ('AU-C8R', 'AU-C8R (Cromer, South Australia, Australia)'),
    ('AU-CER', 'AU-CER (Cromer, New South Wales, Australia)'),
    ('AU-CRU', 'AU-CRU (Cronulla, New South Wales, Australia)'),
    ('AU-CWN', 'AU-CWN (Crows Nest, New South Wales, Australia)'),
    ('AU-CRO', 'AU-CRO (Croxton, Victoria, Australia)'),
    ('AU-CDO', 'AU-CDO (Croydon, South Australia, Australia)'),
    ('AU-CDQ', 'AU-CDQ (Croydon, Queensland, Australia)'),
    ('AU-CRX', 'AU-CRX (Croydon, Victoria, Australia)'),
    ('AU-WYC', 'AU-WYC (Croydon, New South Wales, Australia)'),
    ('AU-OLL', 'AU-OLL (Croydon Hills, Victoria, Australia)'),
    ('AU-CUG', 'AU-CUG (Cudal, New South Wales, Australia)'),
    ('AU-CCS', 'AU-CCS (Cudlee Creek, South Australia, Australia)'),
    ('AU-CUY', 'AU-CUY (Cue, Western Australia, Australia)'),
    ('AU-CLC', 'AU-CLC (Culcairn, New South Wales, Australia)'),
    ('AU-CBU', 'AU-CBU (Cullen Bullen, New South Wales, Australia)'),
    ('AU-CDI', 'AU-CDI (Cunderdin, Western Australia, Australia)'),
    ('AU-CMA', 'AU-CMA (Cunnamulla, Queensland, Australia)'),
    ('AU-CC2', 'AU-CC2 (Curl Curl, New South Wales, Australia)'),
    ('AU-RLW', 'AU-RLW (Curlewis, Victoria, Australia)'),
    ('AU-CCR', 'AU-CCR (Currency Creek, South Australia, Australia)'),
    ('AU-CUR', 'AU-CUR (Currumbin Waters, Queensland, Australia)'),
    ('AU-CUI', 'AU-CUI (Curtis Island, Queensland, Australia)'),
    ('AU-DAG', "AU-DAG (D'Aguilar, Queensland, Australia)"),
    ('AU-DCV', 'AU-DCV (Daceyville, New South Wales, Australia)'),
    ('AU-DHL', 'AU-DHL (Daisy Hill, Queensland, Australia)'),
    ('AU-DJR', 'AU-DJR (Dajarra, Queensland, Australia)'),
    ('AU-DBY', 'AU-DBY (Dalby, Queensland, Australia)'),
    ('AU-KLT', 'AU-KLT (Dalkeith, Western Australia, Australia)'),
    ('AU-DMO', 'AU-DMO (Dalmore, Victoria, Australia)'),
    ('AU-DIT', 'AU-DIT (Dalmore, Victoria, Australia)'),
    ('AU-DAL', 'AU-DAL (Dalton, New South Wales, Australia)'),
    ('AU-DVR', 'AU-DVR (Dalton, New South Wales, Australia)'),
    ('AU-DYW', 'AU-DYW (Dalton, New South Wales, Australia)'),
    ('AU-DAM', 'AU-DAM (Dampier, Western Australia, Australia)'),
    ('AU-DND', 'AU-DND (Dandenong, Victoria, Australia)'),
    ('AU-VDS', 'AU-VDS (Dandenong South, Victoria, Australia)'),
    ('AU-DTO', 'AU-DTO (Dapto, New South Wales, Australia)'),
    ('AU-DAR', 'AU-DAR (Dardanup, Western Australia, Australia)'),
    ('AU-DOW', 'AU-DOW (Darling Downs, Western Australia, Australia)'),
    ('AU-DOI', 'AU-DOI (Darling Point, New South Wales, Australia)'),
    ('AU-GHU', 'AU-GHU (Darlinghurst, New South Wales, Australia)'),
    ('AU-DLT', 'AU-DLT (Darlington, Western Australia, Australia)'),
    ('AU-DTP', 'AU-DTP (Darlington Point, New South Wales, Australia)'),
    ('AU-NLF', 'AU-NLF (Darnley Island, Queensland, Australia)'),
    ('AU-DAA', 'AU-DAA (Darra, Queensland, Australia)'),
    ('AU-DRW', 'AU-DRW (Darra, Queensland, Australia)'),
    ('AU-DAJ', 'AU-DAJ (Dauan Island, Queensland, Australia)'),
    ('AU-DVP', 'AU-DVP (Davenport Downs, Queensland, Australia)'),
    ('AU-DVS', 'AU-DVS (Davidson, New South Wales, Australia)'),
    ('AU-BOA', 'AU-BOA (Dayboro, Queensland, Australia)'),
    ('AU-DDI', 'AU-DDI (Daydream Is, Queensland, Australia)'),
    ('AU-DEB', 'AU-DEB (Deception Bay, Queensland, Australia)'),
    ('AU-DPW', 'AU-DPW (Deepwater, New South Wales, Australia)'),
    ('AU-DPK', 'AU-DPK (Deer Park, Victoria, Australia)'),
    ('AU-DWH', 'AU-DWH (Deewhy, New South Wales, Australia)'),
    ('AU-DLV', 'AU-DLV (Deewhy, New South Wales, Australia)'),
    ('AU-WQ8', 'AU-WQ8 (Deloraine, Tasmania, Australia)'),
    ('AU-DDN', 'AU-DDN (Delta Downs, Queensland, Australia)'),
    ('AU-DNM', 'AU-DNM (Denham, Western Australia, Australia)'),
    ('AU-DNQ', 'AU-DNQ (Deniliquin, New South Wales, Australia)'),
    ('AU-DEN', 'AU-DEN (Denman, New South Wales, Australia)'),
    ('AU-DMA', 'AU-DMA (Denmark, Western Australia, Australia)'),
    ('AU-DRB', 'AU-DRB (Derby, Western Australia, Australia)'),
    ('AU-DVI', 'AU-DVI (Derrimut, Victoria, Australia)'),
    ('AU-DEV', 'AU-DEV (Deviot, Tasmania, Australia)'),
    ('AU-S2V', 'AU-S2V (Devon Meadows, Victoria, Australia)'),
    ('AU-DPO', 'AU-DPO (Devonport, Tasmania, Australia)'),
    ('AU-DHI', 'AU-DHI (Devonport, Tasmania, Australia)'),
    ('AU-DYM', 'AU-DYM (Diamantina Lakes, Queensland, Australia)'),
    ('AU-DIA', 'AU-DIA (Diamond Creek, Victoria, Australia)'),
    ('AU-DIC', 'AU-DIC (Diamond Creek, Victoria, Australia)'),
    ('AU-DGY', 'AU-DGY (Dingley Village, Victoria, Australia)'),
    ('AU-DIR', 'AU-DIR (Direk, South Australia, Australia)'),
    ('AU-DRN', 'AU-DRN (Dirranbandi, Queensland, Australia)'),
    ('AU-DXD', 'AU-DXD (Dixie, Queensland, Australia)'),
    ('AU-DXK', 'AU-DXK (Dixons Creek, Victoria, Australia)'),
    ('AU-DBP', 'AU-DBP (Dobroyd Point, New South Wales, Australia)'),
    ('AU-DKV', 'AU-DKV (Dobroyd Point, New South Wales, Australia)'),
    ('AU-DOK', 'AU-DOK (Docklands, Victoria, Australia)'),
    ('AU-DLY', 'AU-DLY (Dolans Bay, New South Wales, Australia)'),
    ('AU-DCR', 'AU-DCR (Doncaster, Victoria, Australia)'),
    ('AU-DOX', 'AU-DOX (Dongara, Western Australia, Australia)'),
    ('AU-DRO', 'AU-DRO (Donnybrook, Western Australia, Australia)'),
    ('AU-S2M', 'AU-S2M (Donnybrook, Victoria, Australia)'),
    ('AU-DVE', 'AU-DVE (Donvale, Victoria, Australia)'),
    ('AU-DDK', 'AU-DDK (Doodlakine, Western Australia, Australia)'),
    ('AU-DMD', 'AU-DMD (Doomadgee, Queensland, Australia)'),
    ('AU-DNS', 'AU-DNS (Doonside, New South Wales, Australia)'),
    ('AU-S3W', 'AU-S3W (Doreen, Victoria, Australia)'),
    ('AU-DRD', 'AU-DRD (Dorunda Station, Queensland, Australia)'),
    ('AU-DLB', 'AU-DLB (Double Bay, New South Wales, Australia)'),
    ('AU-VVD', 'AU-VVD (Dover Gardens, South Australia, Australia)'),
    ('AU-DVT', 'AU-DVT (Doveton, Victoria, Australia)'),
    ('AU-DNA', 'AU-DNA (Dromana, Victoria, Australia)'),
    ('AU-DRU', 'AU-DRU (Drouin, Victoria, Australia)'),
    ('AU-DFP', 'AU-DFP (Drumduff, Queensland, Australia)'),
    ('AU-DRE', 'AU-DRE (Drumduff, Queensland, Australia)'),
    ('AU-DCK', 'AU-DCK (Dry Creek, South Australia, Australia)'),
    ('AU-EEK', 'AU-EEK (Dry Creek, Victoria, Australia)'),
    ('AU-DRY', 'AU-DRY (Drysdale, Victoria, Australia)'),
    ('AU-DBO', 'AU-DBO (Dubbo, New South Wales, Australia)'),
    ('AU-DDP', 'AU-DDP (Dudley Park, South Australia, Australia)'),
    ('AU-DLK', 'AU-DLK (Dulkaninna, South Australia, Australia)'),
    ('AU-DUL', 'AU-DUL (Dulwich, South Australia, Australia)'),
    ('AU-DNB', 'AU-DNB (Dunbar, Queensland, Australia)'),
    ('AU-DCG', 'AU-DCG (Duncraig, Western Australia, Australia)'),
    ('AU-DDO', 'AU-DDO (Dunedoo, New South Wales, Australia)'),
    ('AU-DGO', 'AU-DGO (Dungog, New South Wales, Australia)'),
    ('AU-DKI', 'AU-DKI (Dunk Island, Queensland, Australia)'),
    ('AU-DSB', 'AU-DSB (Dunsborough, Western Australia, Australia)'),
    ('AU-D8N', 'AU-D8N (Dural, New South Wales, Australia)'),
    ('AU-DHD', 'AU-DHD (Durham Downs, Queensland, Australia)'),
    ('AU-DRR', 'AU-DRR (Durrie, Queensland, Australia)'),
    ('AU-DYA', 'AU-DYA (Dysart, Queensland, Australia)'),
    ('AU-ELF', 'AU-ELF (Eagle Farm, Queensland, Australia)'),
    ('AU-ERL', 'AU-ERL (Earlwood, New South Wales, Australia)'),
    ('AU-EAA', 'AU-EAA (Earlwood, New South Wales, Australia)'),
    ('AU-EBN', 'AU-EBN (East Brisbane, Queensland, Australia)'),
    ('AU-EVP', 'AU-EVP (East Devonport, Tasmania, Australia)'),
    ('AU-SFT', 'AU-SFT (East Fremantle, Western Australia, Australia)'),
    ('AU-EHS', 'AU-EHS (East Hills, New South Wales, Australia)'),
    ('AU-EJB', 'AU-EJB (East Jindabyne, New South Wales, Australia)'),
    ('AU-EML', 'AU-EML (East Maitland, New South Wales, Australia)'),
    ('AU-RIA', 'AU-RIA (East Pastoria, Victoria, Australia)'),
    ('AU-EPT', 'AU-EPT (East Perth, Western Australia, Australia)'),
    ('AU-ECK', 'AU-ECK (Eastern Creek, Western Australia, Australia)'),
    ('AU-ECR', 'AU-ECR (Eastern Creek, New South Wales, Australia)'),
    ('AU-EWD', 'AU-EWD (Eastwood, New South Wales, Australia)'),
    ('AU-AOK', 'AU-AOK (Eatons Hill, Queensland, Australia)'),
    ('AU-EBB', 'AU-EBB (Ebenezer, South Australia, Australia)'),
    ('AU-ECH', 'AU-ECH (Echuca, Victoria, Australia)'),
    ('AU-EUG', 'AU-EUG (Echunga, South Australia, Australia)'),
    ('AU-QDN', 'AU-QDN (Eden, New South Wales, Australia)'),
    ('AU-EDE', 'AU-EDE (Eden Valley, South Australia, Australia)'),
    ('AU-EDI', 'AU-EDI (Edi, Victoria, Australia)'),
    ('AU-EBH', 'AU-EBH (Edinburgh, South Australia, Australia)'),
    ('AU-EDC', 'AU-EDC (Edith Creek, Tasmania, Australia)'),
    ('AU-EDB', 'AU-EDB (Edithburgh, South Australia, Australia)'),
    ('AU-S3E', 'AU-S3E (Edithvale, Victoria, Australia)'),
    ('AU-EDR', 'AU-EDR (Edward River, Queensland, Australia)'),
    ('AU-EDW', 'AU-EDW (Edwardstown, South Australia, Australia)'),
    ('AU-EIH', 'AU-EIH (Einasleigh, Queensland, Australia)'),
    ('AU-ELC', 'AU-ELC (Einasleigh, Queensland, Australia)'),
    ('AU-ELE', 'AU-ELE (Electrona, Tasmania, Australia)'),
    ('AU-ELZ', 'AU-ELZ (Elizabeth, South Australia, Australia)'),
    ('AU-ELB', 'AU-ELB (Elizabeth, South Australia, Australia)'),
    ('AU-EKD', 'AU-EKD (Elizabeth, South Australia, Australia)'),
    ('AU-ELW', 'AU-ELW (Elsternwick, Victoria, Australia)'),
    ('AU-ELT', 'AU-ELT (Eltham, Victoria, Australia)'),
    ('AU-EWO', 'AU-EWO (Elwood, Victoria, Australia)'),
    ('AU-EMD', 'AU-EMD (Emerald, Queensland, Australia)'),
    ('AU-EMP', 'AU-EMP (Emu Plains, New South Wales, Australia)'),
    ('AU-EAB', 'AU-EAB (Eneabba, Western Australia, Australia)'),
    ('AU-ENB', 'AU-ENB (Eneabba West, Western Australia, Australia)'),
    ('AU-ENG', 'AU-ENG (Engadine, New South Wales, Australia)'),
    ('AU-EPG', 'AU-EPG (Epping, New South Wales, Australia)'),
    ('AU-EPP', 'AU-EPP (Epping, Victoria, Australia)'),
    ('AU-ESM', 'AU-ESM (Epsom, Victoria, Australia)'),
    ('AU-ERN', 'AU-ERN (Erina, New South Wales, Australia)'),
    ('AU-EDD', 'AU-EDD (Erina, New South Wales, Australia)'),
    ('AU-ERM', 'AU-ERM (Ermington, New South Wales, Australia)'),
    ('AU-ERB', 'AU-ERB (Ernabella, South Australia, Australia)'),
    ('AU-EPK', 'AU-EPK (Erskine Park, New South Wales, Australia)'),
    ('AU-ERS', 'AU-ERS (Erskineville, New South Wales, Australia)'),
    ('AU-EPR', 'AU-EPR (Esperance, Western Australia, Australia)'),
    ('AU-MEB', 'AU-MEB (Essendon Apt/Melbourne, Victoria, Australia)'),
    ('AU-ETD', 'AU-ETD (Etadunna, South Australia, Australia)'),
    ('AU-EBO', 'AU-EBO (Euabalong, New South Wales, Australia)'),
    ('AU-EUC', 'AU-EUC (Eucla, Western Australia, Australia)'),
    ('AU-EUM', 'AU-EUM (Eumundi, Queensland, Australia)'),
    ('AU-EUA', 'AU-EUA (Euroa, Victoria, Australia)'),
    ('AU-EVD', 'AU-EVD (Euroa, Victoria, Australia)'),
    ('AU-EVT', 'AU-EVT (Evandale, Tasmania, Australia)'),
    ('AU-EVH', 'AU-EVH (Evans Head, New South Wales, Australia)'),
    ('AU-EVL', 'AU-EVL (Evans Landing, Queensland, Australia)'),
    ('AU-PEX', 'AU-PEX (Exmouth, Western Australia, Australia)'),
    ('AU-EXM', 'AU-EXM (Exmouth Gulf, Western Australia, Australia)'),
    ('AU-EXO', 'AU-EXO (Exton, Tasmania, Australia)'),
    ('AU-FBN', 'AU-FBN (Exton, Tasmania, Australia)'),
    ('AU-FFD', 'AU-FFD (Fairfield, New South Wales, Australia)'),
    ('AU-FFL', 'AU-FFL (Fairfield, Victoria, Australia)'),
    ('AU-FLC', 'AU-FLC (Falls Creek, Victoria, Australia)'),
    ('AU-FEL', 'AU-FEL (Felixstow, South Australia, Australia)'),
    ('AU-FGS', 'AU-FGS (Ferguson, Western Australia, Australia)'),
    ('AU-RFU', 'AU-RFU (Ferntree Gully, Victoria, Australia)'),
    ('AU-FRD', 'AU-FRD (Ferryden Park, South Australia, Australia)'),
    ('AU-FTP', 'AU-FTP (Fig Tree Pocket, Queensland, Australia)'),
    ('AU-FIN', 'AU-FIN (Findon, South Australia, Australia)'),
    ('AU-FIK', 'AU-FIK (Findon, South Australia, Australia)'),
    ('AU-FLY', 'AU-FLY (Finley, New South Wales, Australia)'),
    ('AU-FIS', 'AU-FIS (Fisherman Islands, Queensland, Australia)'),
    ('AU-FIT', 'AU-FIT (Fitzroy, Victoria, Australia)'),
    ('AU-FDS', 'AU-FDS (Flinders, Victoria, Australia)'),
    ('AU-FLS', 'AU-FLS (Flinders Island, Tasmania, Australia)'),
    ('AU-FLN', 'AU-FLN (Flynn, Victoria, Australia)'),
    ('AU-OOY', 'AU-OOY (Footescray, Victoria, Australia)'),
    ('AU-FCY', 'AU-FCY (Footscray, Victoria, Australia)'),
    ('AU-FRB', 'AU-FRB (Forbes, New South Wales, Australia)'),
    ('AU-FRG', 'AU-FRG (Forest Glen, Queensland, Australia)'),
    ('AU-S3J', 'AU-S3J (Forest Hill, Victoria, Australia)'),
    ('AU-VFT', 'AU-VFT (Forestville, New South Wales, Australia)'),
    ('AU-FOS', 'AU-FOS (Forrest, Western Australia, Australia)'),
    ('AU-FRR', 'AU-FRR (Forrestdale, Western Australia, Australia)'),
    ('AU-FTD', 'AU-FTD (Forrestfield, Western Australia, Australia)'),
    ('AU-FOT', 'AU-FOT (Forster, New South Wales, Australia)'),
    ('AU-TFR', 'AU-TFR (Forth, Tasmania, Australia)'),
    ('AU-FSL', 'AU-FSL (Fossil Downs, Western Australia, Australia)'),
    ('AU-FOD', 'AU-FOD (Fountaindale, New South Wales, Australia)'),
    ('AU-FVN', 'AU-FVN (Fountaindale, New South Wales, Australia)'),
    ('AU-FLD', 'AU-FLD (Frankland, Western Australia, Australia)'),
    ('AU-GYJ', 'AU-GYJ (Frankland River, Western Australia, Australia)'),
    ('AU-FRK', 'AU-FRK (Frankston East, Victoria, Australia)'),
    ('AU-FLI', 'AU-FLI (Freeling, South Australia, Australia)'),
    ('AU-FRE', 'AU-FRE (Fremantle, Western Australia, Australia)'),
    ('AU-FFO', 'AU-FFO (Frenchs Forest, New South Wales, Australia)'),
    ('AU-FWT', 'AU-FWT (Freshwater, New South Wales, Australia)'),
    ('AU-FRL', 'AU-FRL (Frewville, South Australia, Australia)'),
    ('AU-PUF', 'AU-PUF (Frewville, South Australia, Australia)'),
    ('AU-FTN', 'AU-FTN (Fullerton, New South Wales, Australia)'),
    ('AU-FUR', 'AU-FUR (Furnissdale, Western Australia, Australia)'),
    ('AU-FYW', 'AU-FYW (Furnissdale, Western Australia, Australia)'),
    ('AU-GLO', 'AU-GLO (Galong, New South Wales, Australia)'),
    ('AU-GON', 'AU-GON (Galston, New South Wales, Australia)'),
    ('AU-GBP', 'AU-GBP (Gamboola, Queensland, Australia)'),
    ('AU-GMA', 'AU-GMA (Ganmain, New South Wales, Australia)'),
    ('AU-GAP', 'AU-GAP (Gapstead, Victoria, Australia)'),
    ('AU-GBT', 'AU-GBT (Garbutt, Queensland, Australia)'),
    ('AU-GPN', 'AU-GPN (Garbutt, Queensland, Australia)'),
    ('AU-GSC', 'AU-GSC (Gascoyne Junction, Western Australia, Australia)'),
    ('AU-GXM', 'AU-GXM (Gateshed, New South Wales, Australia)'),
    ('AU-GAN', 'AU-GAN (Gatton, Queensland, Australia)'),
    ('AU-GXN', 'AU-GXN (Gawler, South Australia, Australia)'),
    ('AU-GAH', 'AU-GAH (Gayndah, Queensland, Australia)'),
    ('AU-GUG', 'AU-GUG (Geebung, Queensland, Australia)'),
    ('AU-GEX', 'AU-GEX (Geelong, Victoria, Australia)'),
    ('AU-GXQ', 'AU-GXQ (Geelong North, Victoria, Australia)'),
    ('AU-GWT', 'AU-GWT (Geelong West, Victoria, Australia)'),
    ('AU-GEM', 'AU-GEM (Gembrook, Victoria, Australia)'),
    ('AU-GEE', 'AU-GEE (George Town, Tasmania, Australia)'),
    ('AU-GTT', 'AU-GTT (Georgetown, Queensland, Australia)'),
    ('AU-GEP', 'AU-GEP (Gepps Cross, South Australia, Australia)'),
    ('AU-GET', 'AU-GET (Geraldton, Western Australia, Australia)'),
    ('AU-GRG', 'AU-GRG (Geraldton, Western Australia, Australia)'),
    ('AU-GBV', 'AU-GBV (Gibb River, Western Australia, Australia)'),
    ('AU-GTN', 'AU-GTN (Gilberton, South Australia, Australia)'),
    ('AU-GIL', 'AU-GIL (Gillman, South Australia, Australia)'),
    ('AU-GST', 'AU-GST (Gilston, Queensland, Australia)'),
    ('AU-GNI', 'AU-GNI (Gingin, Western Australia, Australia)'),
    ('AU-GRW', 'AU-GRW (Girraween, New South Wales, Australia)'),
    ('AU-GBN', 'AU-GBN (Gisborne, Victoria, Australia)'),
    ('AU-GLA', 'AU-GLA (Gladesville, New South Wales, Australia)'),
    ('AU-GLT', 'AU-GLT (Gladstone, Queensland, Australia)'),
    ('AU-GBY', 'AU-GBY (Glaziers Bay, Tasmania, Australia)'),
    ('AU-GLL', 'AU-GLL (Glebe Island, New South Wales, Australia)'),
    ('AU-TGF', 'AU-TGF (Glen Forbes, Victoria, Australia)'),
    ('AU-GLI', 'AU-GLI (Glen Innes, New South Wales, Australia)'),
    ('AU-GRS', 'AU-GRS (Glen Innes, New South Wales, Australia)'),
    ('AU-GLW', 'AU-GLW (Glen Waverley, Victoria, Australia)'),
    ('AU-GLD', 'AU-GLD (Glenden, Queensland, Australia)'),
    ('AU-GLN', 'AU-GLN (Glendenning, New South Wales, Australia)'),
    ('AU-GGG', 'AU-GGG (Glenelg, South Australia, Australia)'),
    ('AU-GNA', 'AU-GNA (Glenella, Queensland, Australia)'),
    ('AU-GLE', 'AU-GLE (Glenfield, New South Wales, Australia)'),
    ('AU-GGZ', 'AU-GGZ (Glengarry, Victoria, Australia)'),
    ('AU-GLG', 'AU-GLG (Glengyle, Queensland, Australia)'),
    ('AU-GHV', 'AU-GHV (Glenhaven, New South Wales, Australia)'),
    ('AU-GLC', 'AU-GLC (Glenlofty Creek, Victoria, Australia)'),
    ('AU-GCY', 'AU-GCY (Glenorchy, Tasmania, Australia)'),
    ('AU-GRI', 'AU-GRI (Glenorie, New South Wales, Australia)'),
    ('AU-GLM', 'AU-GLM (Glenormiston, Queensland, Australia)'),
    ('AU-GLS', 'AU-GLS (Glossop, South Australia, Australia)'),
    ('AU-GCE', 'AU-GCE (Gloucester, New South Wales, Australia)'),
    ('AU-GDY', 'AU-GDY (Glynde, South Australia, Australia)'),
    ('AU-GWG', 'AU-GWG (Gnowangerup, Western Australia, Australia)'),
    ('AU-GXW', 'AU-GXW (Gol Gol, Victoria, Australia)'),
    ('AU-GOC', 'AU-GOC (Gold Coast, Queensland, Australia)'),
    ('AU-OOL', 'AU-OOL (Gold Coast Apt/Coolangatta, Queensland, Australia)'),
    ('AU-GLY', 'AU-GLY (Goldsworthy, Western Australia, Australia)'),
    ('AU-GDN', 'AU-GDN (Goodna, Queensland, Australia)'),
    ('AU-GOI', 'AU-GOI (Goods Is, Queensland, Australia)'),
    ('AU-GOA', 'AU-GOA (Goolwa, South Australia, Australia)'),
    ('AU-GOO', 'AU-GOO (Goondiwindi, Queensland, Australia)'),
    ('AU-GGY', 'AU-GGY (Gooseberry Hill, Western Australia, Australia)'),
    ('AU-GGW', 'AU-GGW (Gordon, New South Wales, Australia)'),
    ('AU-GOR', 'AU-GOR (Gordon, Victoria, Australia)'),
    ('AU-GDD', 'AU-GDD (Gordon Downs, Western Australia, Australia)'),
    ('AU-GOS', 'AU-GOS (Gosford, New South Wales, Australia)'),
    ('AU-GGX', 'AU-GGX (Gosnells, Western Australia, Australia)'),
    ('AU-GUL', 'AU-GUL (Goulburn, New South Wales, Australia)'),
    ('AU-GBL', 'AU-GBL (Goulburn, New South Wales, Australia)'),
    ('AU-GOV', 'AU-GOV (Goulburn, New South Wales, Australia)'),
    ('AU-GOH', 'AU-GOH (Goulburn, New South Wales, Australia)'),
    ('AU-GME', 'AU-GME (Gracemere, Queensland, Australia)'),
    ('AU-GVL', 'AU-GVL (Graceville, Queensland, Australia)'),
    ('AU-GFN', 'AU-GFN (Grafton, New South Wales, Australia)'),
    ('AU-R5M', 'AU-R5M (Graham, New South Wales, Australia)'),
    ('AU-GMV', 'AU-GMV (Grahamvale, Victoria, Australia)'),
    ('AU-GRZ', 'AU-GRZ (Grange, South Australia, Australia)'),
    ('AU-GTS', 'AU-GTS (Grange, South Australia, Australia)'),
    ('AU-GTH', 'AU-GTH (Grantham, Queensland, Australia)'),
    ('AU-GRN', 'AU-GRN (Granville, New South Wales, Australia)'),
    ('AU-GVW', 'AU-GVW (Grass Valley, Western Australia, Australia)'),
    ('AU-GRA', 'AU-GRA (Grassy, Tasmania, Australia)'),
    ('AU-GRB', 'AU-GRB (Gravelly Beach, Tasmania, Australia)'),
    ('AU-GRT', 'AU-GRT (Grays Point, New South Wales, Australia)'),
    ('AU-GGV', 'AU-GGV (Graytown, Victoria, Australia)'),
    ('AU-GKL', 'AU-GKL (Great Keppel Island, Queensland, Australia)'),
    ('AU-GTW', 'AU-GTW (Great Western, Victoria, Australia)'),
    ('AU-GFS', 'AU-GFS (Green Fields, South Australia, Australia)'),
    ('AU-GCR', 'AU-GCR (Greenacre, New South Wales, Australia)'),
    ('AU-GRF', 'AU-GRF (Greenfields, Western Australia, Australia)'),
    ('AU-GRH', 'AU-GRH (Greenhead, Western Australia, Australia)'),
    ('AU-GRK', 'AU-GRK (Greenock, South Australia, Australia)'),
    ('AU-GNU', 'AU-GNU (Greenough, Western Australia, Australia)'),
    ('AU-GSO', 'AU-GSO (Greenslopes, Queensland, Australia)'),
    ('AU-E4E', 'AU-E4E (Greenvale, Victoria, Australia)'),
    ('AU-GVP', 'AU-GVP (Greenvale, Queensland, Australia)'),
    ('AU-GNW', 'AU-GNW (Greenwich, New South Wales, Australia)'),
    ('AU-GWA', 'AU-GWA (Greenwood, Western Australia, Australia)'),
    ('AU-GGD', 'AU-GGD (Gregory Downs, Queensland, Australia)'),
    ('AU-GFE', 'AU-GFE (Grenfell, New South Wales, Australia)'),
    ('AU-GRE', 'AU-GRE (Greystanes, New South Wales, Australia)'),
    ('AU-GRV', 'AU-GRV (Griffin Venture (oil terminal), Western Australia, Australia)'),
    ('AU-GFF', 'AU-GFF (Griffith, New South Wales, Australia)'),
    ('AU-GGO', 'AU-GGO (Grong Grong, New South Wales, Australia)'),
    ('AU-GTE', 'AU-GTE (Grong Grong, New South Wales, Australia)'),
    ('AU-GRU', 'AU-GRU (Gruyere, Victoria, Australia)'),
    ('AU-GDF', 'AU-GDF (Guildford, New South Wales, Australia)'),
    ('AU-WGD', 'AU-WGD (Guildford, Western Australia, Australia)'),
    ('AU-GUM', 'AU-GUM (Gumeracha, South Australia, Australia)'),
    ('AU-GDA', 'AU-GDA (Gundagai, New South Wales, Australia)'),
    ('AU-GH6', 'AU-GH6 (Gundagai, New South Wales, Australia)'),
    ('AU-GUH', 'AU-GUH (Gunnedah, New South Wales, Australia)'),
    ('AU-GUN', 'AU-GUN (Gunning, New South Wales, Australia)'),
    ('AU-GYP', 'AU-GYP (Gympie, Queensland, Australia)'),
    ('AU-HAB', 'AU-HAB (Haberfield, New South Wales, Australia)'),
    ('AU-HAH', 'AU-HAH (Hahndorf, South Australia, Australia)'),
    ('AU-HAL', 'AU-HAL (Halifax, Queensland, Australia)'),
    ('AU-HHL', 'AU-HHL (Halifax, Queensland, Australia)'),
    ('AU-HLM', 'AU-HLM (Hallam, Victoria, Australia)'),
    ('AU-HTT', 'AU-HTT (Halletts Cove, South Australia, Australia)'),
    ('AU-HCQ', 'AU-HCQ (Halls Creek, Western Australia, Australia)'),
    ('AU-HLT', 'AU-HLT (Hamilton, Victoria, Australia)'),
    ('AU-HML', 'AU-HML (Hamilton, New South Wales, Australia)'),
    ('AU-OMN', 'AU-OMN (Hamilton, Queensland, Australia)'),
    ('AU-WHH', 'AU-WHH (Hamilton Hill, Western Australia, Australia)'),
    ('AU-HTI', 'AU-HTI (Hamilton Island, Queensland, Australia)'),
    ('AU-HAM', 'AU-HAM (Hampton, Victoria, Australia)'),
    ('AU-HPN', 'AU-HPN (Hampton, New South Wales, Australia)'),
    ('AU-M7K', 'AU-M7K (Hampton Park, Victoria, Australia)'),
    ('AU-HWD', 'AU-HWD (Hanwood, New South Wales, Australia)'),
    ('AU-HPP', 'AU-HPP (Happy Valley, South Australia, Australia)'),
    ('AU-HAR', 'AU-HAR (Harcourt, Victoria, Australia)'),
    ('AU-HDN', 'AU-HDN (Harden, New South Wales, Australia)'),
    ('AU-HYI', 'AU-HYI (Harden, New South Wales, Australia)'),
    ('AU-R4W', 'AU-R4W (Harkaway, Victoria, Australia)'),
    ('AU-HVY', 'AU-HVY (Harvey, Western Australia, Australia)'),
    ('AU-HAS', 'AU-HAS (Hastings, Victoria, Australia)'),
    ('AU-HPO', 'AU-HPO (Hastings Point, New South Wales, Australia)'),
    ('AU-HWK', 'AU-HWK (Hawker, South Australia, Australia)'),
    ('AU-HWN', 'AU-HWN (Hawks Nest, New South Wales, Australia)'),
    ('AU-HTE', 'AU-HTE (Hawthorn, Victoria, Australia)'),
    ('AU-HWR', 'AU-HWR (Hawthorndene, South Australia, Australia)'),
    ('AU-HXX', 'AU-HXX (Hay, New South Wales, Australia)'),
    ('AU-HPT', 'AU-HPT (Hay Point, Queensland, Australia)'),
    ('AU-HIS', 'AU-HIS (Hayman Island, Queensland, Australia)'),
    ('AU-HAY', 'AU-HAY (Haymarket, New South Wales, Australia)'),
    ('AU-HAZ', 'AU-HAZ (Hazelmere, Western Australia, Australia)'),
    ('AU-HIP', 'AU-HIP (Headingly, Queensland, Australia)'),
    ('AU-HSV', 'AU-HSV (Healesville, Victoria, Australia)'),
    ('AU-COT', 'AU-COT (Heathcote, New South Wales, Australia)'),
    ('AU-HTH', 'AU-HTH (Heathcote, Victoria, Australia)'),
    ('AU-HBE', 'AU-HBE (Heatherbrae, New South Wales, Australia)'),
    ('AU-VHT', 'AU-VHT (Heatherton, Victoria, Australia)'),
    ('AU-HAT', 'AU-HAT (Heathlands, Queensland, Australia)'),
    ('AU-HET', 'AU-HET (Heathmont, Victoria, Australia)'),
    ('AU-HEA', 'AU-HEA (Heathwood, Queensland, Australia)'),
    ('AU-LLE', 'AU-LLE (Hectorville, South Australia, Australia)'),
    ('AU-HEI', 'AU-HEI (Heidelberg, Victoria, Australia)'),
    ('AU-HBW', 'AU-HBW (Heidelberg, Victoria, Australia)'),
    ('AU-HLV', 'AU-HLV (Helenvale, Queensland, Australia)'),
    ('AU-HEL', 'AU-HEL (Helidon, Queensland, Australia)'),
    ('AU-HEM', 'AU-HEM (Hemmant, Queensland, Australia)'),
    ('AU-HRY', 'AU-HRY (Hemmant, Queensland, Australia)'),
    ('AU-HFR', 'AU-HFR (Henderson, Western Australia, Australia)'),
    ('AU-H3N', 'AU-H3N (Hendon, Queensland, Australia)'),
    ('AU-HEN', 'AU-HEN (Hendra, Queensland, Australia)'),
    ('AU-HLB', 'AU-HLB (Henley Beach, South Australia, Australia)'),
    ('AU-HTY', 'AU-HTY (Henty, New South Wales, Australia)'),
    ('AU-HMG', 'AU-HMG (Henty, New South Wales, Australia)'),
    ('AU-GGT', 'AU-GGT (Herne Hill, Western Australia, Australia)'),
    ('AU-HRN', 'AU-HRN (Heron Island, Queensland, Australia)'),
    ('AU-HVB', 'AU-HVB (Hervey Bay, Queensland, Australia)'),
    ('AU-HEY', 'AU-HEY (Heyfield, Victoria, Australia)'),
    ('AU-HWY', 'AU-HWY (High Wycombe, Western Australia, Australia)'),
    ('AU-HIG', 'AU-HIG (Highbury, Queensland, Australia)'),
    ('AU-HHT', 'AU-HHT (Highett/Melbourne, Victoria, Australia)'),
    ('AU-PQT', 'AU-PQT (Hill Top, New South Wales, Australia)'),
    ('AU-HLR', 'AU-HLR (Hillarys, Western Australia, Australia)'),
    ('AU-HL2', 'AU-HL2 (Hillbank, South Australia, Australia)'),
    ('AU-QHC', 'AU-QHC (Hillcrest, Queensland, Australia)'),
    ('AU-HLL', 'AU-HLL (Hillside, Western Australia, Australia)'),
    ('AU-HSD', 'AU-HSD (Hillside, Victoria, Australia)'),
    ('AU-HTO', 'AU-HTO (Hilton, South Australia, Australia)'),
    ('AU-HNK', 'AU-HNK (Hinchinbrook Island, Queensland, Australia)'),
    ('AU-HMS', 'AU-HMS (Hindmarsh, South Australia, Australia)'),
    ('AU-HMC', 'AU-HMC (HMAS Cerberus, Victoria, Australia)'),
    ('AU-HBA', 'AU-HBA (Hobart, Tasmania, Australia)'),
    ('AU-HDD', 'AU-HDD (Hoddles Creek, Victoria, Australia)'),
    ('AU-HOL', 'AU-HOL (Holden Hill, South Australia, Australia)'),
    ('AU-HLK', 'AU-HLK (Holland Park, Queensland, Australia)'),
    ('AU-HBS', 'AU-HBS (Homebush/Sydney, New South Wales, Australia)'),
    ('AU-HIH', 'AU-HIH (Hook Island, Queensland, Australia)'),
    ('AU-HOK', 'AU-HOK (Hook Island, Queensland, Australia)'),
    ('AU-HPL', 'AU-HPL (Hope Island, Queensland, Australia)'),
    ('AU-HOT', 'AU-HOT (Hope Tun, Western Australia, Australia)'),
    ('AU-HPE', 'AU-HPE (Hope Vale, Queensland, Australia)'),
    ('AU-PVE', 'AU-PVE (Hope Valley, Western Australia, Australia)'),
    ('AU-HTU', 'AU-HTU (Hopetoun, Victoria, Australia)'),
    ('AU-HCG', 'AU-HCG (Hoppers Crossing, Victoria, Australia)'),
    ('AU-HID', 'AU-HID (Horn Island, Queensland, Australia)'),
    ('AU-HOY', 'AU-HOY (Hornsby, New South Wales, Australia)'),
    ('AU-HOR', 'AU-HOR (Hornsdale, South Australia, Australia)'),
    ('AU-HSM', 'AU-HSM (Horsham, Victoria, Australia)'),
    ('AU-HPK', 'AU-HPK (Horsley Park, New South Wales, Australia)'),
    ('AU-GGS', 'AU-GGS (Houghton, South Australia, Australia)'),
    ('AU-HWO', 'AU-HWO (Howlong, New South Wales, Australia)'),
    ('AU-HGD', 'AU-HGD (Hughenden, Queensland, Australia)'),
    ('AU-HGH', 'AU-HGH (Hughesdale, Victoria, Australia)'),
    ('AU-HUB', 'AU-HUB (Hughesdale, Victoria, Australia)'),
    ('AU-HUM', 'AU-HUM (Hughesdale, Victoria, Australia)'),
    ('AU-HUD', 'AU-HUD (Hughesdale, Victoria, Australia)'),
    ('AU-HHW', 'AU-HHW (Hunters Hill, New South Wales, Australia)'),
    ('AU-HTW', 'AU-HTW (Huntingwood, New South Wales, Australia)'),
    ('AU-HVI', 'AU-HVI (Huonville, Tasmania, Australia)'),
    ('AU-GGR', 'AU-GGR (Hurstbridge, Victoria, Australia)'),
    ('AU-HUR', 'AU-HUR (Hurstville, New South Wales, Australia)'),
    ('AU-GRO', 'AU-GRO (Hurstville Grove, New South Wales, Australia)'),
    ('AU-HYD', 'AU-HYD (Hyden, Western Australia, Australia)'),
    ('AU-ITH', 'AU-ITH (Ichthys, Western Australia, Australia)'),
    ('AU-IFF', 'AU-IFF (Iffley, Queensland, Australia)'),
    ('AU-LAW', 'AU-LAW (Illawong, New South Wales, Australia)'),
    ('AU-IDK', 'AU-IDK (Indulkana, South Australia, Australia)'),
    ('AU-IGH', 'AU-IGH (Ingham, Queensland, Australia)'),
    ('AU-IGF', 'AU-IGF (Ingle Farm, South Australia, Australia)'),
    ('AU-IGN', 'AU-IGN (Ingleburn, New South Wales, Australia)'),
    ('AU-INJ', 'AU-INJ (Injune, Queensland, Australia)'),
    ('AU-IKP', 'AU-IKP (Inkerman, Queensland, Australia)'),
    ('AU-INN', 'AU-INN (Innaloo, Western Australia, Australia)'),
    ('AU-INM', 'AU-INM (Innamincka, South Australia, Australia)'),
    ('AU-IFL', 'AU-IFL (Innisfail, Queensland, Australia)'),
    ('AU-IVR', 'AU-IVR (Inverell, New South Wales, Australia)'),
    ('AU-INV', 'AU-INV (Inverloch, Victoria, Australia)'),
    ('AU-IMY', 'AU-IMY (Invermay, Tasmania, Australia)'),
    ('AU-IVW', 'AU-IVW (Invermay, Tasmania, Australia)'),
    ('AU-IPS', 'AU-IPS (Ipswich, Queensland, Australia)'),
    ('AU-IRY', 'AU-IRY (Irymple, Victoria, Australia)'),
    ('AU-ICL', 'AU-ICL (Isis Central, Queensland, Australia)'),
    ('AU-ISI', 'AU-ISI (Isisford, Queensland, Australia)'),
    ('AU-IHO', 'AU-IHO (Ivanhoe, New South Wales, Australia)'),
    ('AU-JAB', 'AU-JAB (Ivanhoe, New South Wales, Australia)'),
    ('AU-JOV', 'AU-JOV (Ivanhoe, New South Wales, Australia)'),
    ('AU-JAC', 'AU-JAC (Jackson, Queensland, Australia)'),
    ('AU-JBH', 'AU-JBH (Jamboree Heights, Queensland, Australia)'),
    ('AU-JST', 'AU-JST (Jamboree Heights, Queensland, Australia)'),
    ('AU-JAD', 'AU-JAD (Jandakot, Western Australia, Australia)'),
    ('AU-IGG', 'AU-IGG (Jannali, New South Wales, Australia)'),
    ('AU-JAR', 'AU-JAR (Jarrahdale, Western Australia, Australia)'),
    ('AU-JDE', 'AU-JDE (Jerilderie, New South Wales, Australia)'),
    ('AU-JMR', 'AU-JMR (Jerrabomberra, Victoria, Australia)'),
    ('AU-JSW', 'AU-JSW (Jerry Plains, New South Wales, Australia)'),
    ('AU-GGQ', 'AU-GGQ (Jerrys Plains, New South Wales, Australia)'),
    ('AU-JEB', 'AU-JEB (Jervis Bay, New South Wales, Australia)'),
    ('AU-JIM', 'AU-JIM (Jimboomba, Queensland, Australia)'),
    ('AU-JDP', 'AU-JDP (Joondalup, Western Australia, Australia)'),
    ('AU-JCK', 'AU-JCK (Julia Creek, Queensland, Australia)'),
    ('AU-JUN', 'AU-JUN (Jundah, Queensland, Australia)'),
    ('AU-JNE', 'AU-JNE (Junee, New South Wales, Australia)'),
    ('AU-JUR', 'AU-JUR (Jurien Bay, Western Australia, Australia)'),
    ('AU-KAD', 'AU-KAD (Kadina, South Australia, Australia)'),
    ('AU-KUD', 'AU-KUD (Kalamunda, Western Australia, Australia)'),
    ('AU-QLD', 'AU-QLD (Kalbar, Queensland, Australia)'),
    ('AU-KAX', 'AU-KAX (Kalbarri, Western Australia, Australia)'),
    ('AU-KGI', 'AU-KGI (Kalgoorlie, Western Australia, Australia)'),
    ('AU-KKD', 'AU-KKD (Kalkadoon, Queensland, Australia)'),
    ('AU-V4K', 'AU-V4K (Kalkallo, Victoria, Australia)'),
    ('AU-KFG', 'AU-KFG (Kalkallo, Victoria, Australia)'),
    ('AU-V2K', 'AU-V2K (Kalorama, Victoria, Australia)'),
    ('AU-KPP', 'AU-KPP (Kalpowar, Queensland, Australia)'),
    ('AU-UBU', 'AU-UBU (Kalumburu, Western Australia, Australia)'),
    ('AU-KDS', 'AU-KDS (Kamaran Downs, Queensland, Australia)'),
    ('AU-KMB', 'AU-KMB (Kamaran Downs, Queensland, Australia)'),
    ('AU-KDB', 'AU-KDB (Kambalda, Western Australia, Australia)'),
    ('AU-KML', 'AU-KML (Kamileroi, Queensland, Australia)'),
    ('AU-GGP', 'AU-GGP (Kangaloon, New South Wales, Australia)'),
    ('AU-KAN', 'AU-KAN (Kangarilla, South Australia, Australia)'),
    ('AU-KGF', 'AU-KGF (Kangaroo Flat, Victoria, Australia)'),
    ('AU-KGO', 'AU-KGO (Kangaroo Ground, Victoria, Australia)'),
    ('AU-QUE', 'AU-QUE (Kangaroo Point, Queensland, Australia)'),
    ('AU-KIA', 'AU-KIA (Kanimbla, Queensland, Australia)'),
    ('AU-KAP', 'AU-KAP (Kapunda, South Australia, Australia)'),
    ('AU-KWT', 'AU-KWT (Karawatha, Queensland, Australia)'),
    ('AU-KAR', 'AU-KAR (Kardinya, Western Australia, Australia)'),
    ('AU-GYN', 'AU-GYN (Kareela, New South Wales, Australia)'),
    ('AU-W23', 'AU-W23 (Karragullen, Western Australia, Australia)'),
    ('AU-KTA', 'AU-KTA (Karratha, Western Australia, Australia)'),
    ('AU-KRB', 'AU-KRB (Karumba, Queensland, Australia)'),
    ('AU-KNI', 'AU-KNI (Katanning, Western Australia, Australia)'),
    ('AU-KTR', 'AU-KTR (Katanning, Western Australia, Australia)'),
    ('AU-KTB', 'AU-KTB (Katoomba, New South Wales, Australia)'),
    ('AU-KAW', 'AU-KAW (Kawana, Queensland, Australia)'),
    ('AU-KAY', 'AU-KAY (Kayena, Tasmania, Australia)'),
    ('AU-KED', 'AU-KED (Kedron, Queensland, Australia)'),
    ('AU-KLR', 'AU-KLR (Keilor, Victoria, Australia)'),
    ('AU-ORK', 'AU-ORK (Keilor Park, Victoria, Australia)'),
    ('AU-KEI', 'AU-KEI (Keith, South Australia, Australia)'),
    ('AU-KBI', 'AU-KBI (Kellerberrin, Western Australia, Australia)'),
    ('AU-KST', 'AU-KST (Kelmscot, Western Australia, Australia)'),
    ('AU-KEL', 'AU-KEL (Kelso, New South Wales, Australia)'),
    ('AU-KGA', 'AU-KGA (Kembla, New South Wales, Australia)'),
    ('AU-KEM', 'AU-KEM (Kemblawarra, New South Wales, Australia)'),
    ('AU-KPS', 'AU-KPS (Kempsey, New South Wales, Australia)'),
    ('AU-KDA', 'AU-KDA (Kendall, New South Wales, Australia)'),
    ('AU-GYM', 'AU-GYM (Kendenup, Western Australia, Australia)'),
    ('AU-KEA', 'AU-KEA (Kenmore, Queensland, Australia)'),
    ('AU-IGL', 'AU-IGL (Kensington, New South Wales, Australia)'),
    ('AU-KGT', 'AU-KGT (Kensington, Victoria, Australia)'),
    ('AU-KNG', 'AU-KNG (Kensington, Victoria, Australia)'),
    ('AU-KTT', 'AU-KTT (Kent Town, South Australia, Australia)'),
    ('AU-KNT', 'AU-KNT (Kenthurst, New South Wales, Australia)'),
    ('AU-KEN', 'AU-KEN (Keon Park, Victoria, Australia)'),
    ('AU-PPO', 'AU-PPO (Keppoch, South Australia, Australia)'),
    ('AU-KRA', 'AU-KRA (Kerang, Victoria, Australia)'),
    ('AU-GYZ', 'AU-GYZ (Kersbrook, South Australia, Australia)'),
    ('AU-WEK', 'AU-WEK (Kew, Victoria, Australia)'),
    ('AU-ASK', 'AU-ASK (Kewarra Beach, Queensland, Australia)'),
    ('AU-KEW', 'AU-KEW (Kewdale, Western Australia, Australia)'),
    ('AU-KEE', 'AU-KEE (Kewell, Victoria, Australia)'),
    ('AU-KEY', 'AU-KEY (Kewell, Victoria, Australia)'),
    ('AU-KBO', 'AU-KBO (Keysborough, Victoria, Australia)'),
    ('AU-AKP', 'AU-AKP (Kidman Park, South Australia, Australia)'),
    ('AU-KLB', 'AU-KLB (Kilburn, South Australia, Australia)'),
    ('AU-GYX', 'AU-GYX (Kilcoy, Queensland, Australia)'),
    ('AU-KAA', 'AU-KAA (Killara, New South Wales, Australia)'),
    ('AU-KYV', 'AU-KYV (Killarney Vale, New South Wales, Australia)'),
    ('AU-KIL', 'AU-KIL (Kilmore, Victoria, Australia)'),
    ('AU-KSY', 'AU-KSY (Kilsyth, Victoria, Australia)'),
    ('AU-KBD', 'AU-KBD (Kimberley Downs, Western Australia, Australia)'),
    ('AU-KIB', 'AU-KIB (King Bay, Western Australia, Australia)'),
    ('AU-KNS', 'AU-KNS (King Is, Tasmania, Australia)'),
    ('AU-KGY', 'AU-KGY (Kingaroy, Queensland, Australia)'),
    ('AU-N7K', 'AU-N7K (Kinglake, Victoria, Australia)'),
    ('AU-KER', 'AU-KER (Kingower, Victoria, Australia)'),
    ('AU-KBJ', 'AU-KBJ (Kingower, Victoria, Australia)'),
    ('AU-KCS', 'AU-KCS (Kingower, Victoria, Australia)'),
    ('AU-KPK', 'AU-KPK (Kings Park, New South Wales, Australia)'),
    ('AU-KRK', 'AU-KRK (Kings Park, Tasmania, Australia)'),
    ('AU-KU7', 'AU-KU7 (Kings Park, South Australia, Australia)'),
    ('AU-KGC', 'AU-KGC (Kingscote, South Australia, Australia)'),
    ('AU-GTY', 'AU-GTY (Kingsford, New South Wales, Australia)'),
    ('AU-KGG', 'AU-KGG (Kingsgrove, New South Wales, Australia)'),
    ('AU-GYW', 'AU-GYW (Kingsthorpe, Queensland, Australia)'),
    ('AU-KGN', 'AU-KGN (Kingsthorpe, Queensland, Australia)'),
    ('AU-KIT', 'AU-KIT (Kingston, South Australia, Australia)'),
    ('AU-KSU', 'AU-KSU (Kingstown, New South Wales, Australia)'),
    ('AU-IGR', 'AU-IGR (Kingswood, New South Wales, Australia)'),
    ('AU-KBB', 'AU-KBB (Kingswood, New South Wales, Australia)'),
    ('AU-KRW', 'AU-KRW (Kirrawee, New South Wales, Australia)'),
    ('AU-KTN', 'AU-KTN (Kirrawee, New South Wales, Australia)'),
    ('AU-KLP', 'AU-KLP (Klein Point, South Australia, Australia)'),
    ('AU-KLZ', 'AU-KLZ (Klemzig, South Australia, Australia)'),
    ('AU-KNW', 'AU-KNW (Knockrow, New South Wales, Australia)'),
    ('AU-KNY', 'AU-KNY (Knowsley, Victoria, Australia)'),
    ('AU-KNO', 'AU-KNO (Knoxfield, Victoria, Australia)'),
    ('AU-ARA', 'AU-ARA (Kogarah, New South Wales, Australia)'),
    ('AU-VKK', 'AU-VKK (Kongwak, Victoria, Australia)'),
    ('AU-KWR', 'AU-KWR (Koo-Wee-Rup, Victoria, Australia)'),
    ('AU-KOI', 'AU-KOI (Koolan Island, Western Australia, Australia)'),
    ('AU-KOH', 'AU-KOH (Koolatah, Queensland, Australia)'),
    ('AU-KKP', 'AU-KKP (Koolburra, Queensland, Australia)'),
    ('AU-KBG', 'AU-KBG (Koolyanbobbing, Western Australia, Australia)'),
    ('AU-KQB', 'AU-KQB (Koonibba, South Australia, Australia)'),
    ('AU-KOM', 'AU-KOM (Koonoomoo, Victoria, Australia)'),
    ('AU-KWA', 'AU-KWA (Koorawatha, New South Wales, Australia)'),
    ('AU-KRM', 'AU-KRM (Korumburra, Victoria, Australia)'),
    ('AU-KNE', 'AU-KNE (Korunye, South Australia, Australia)'),
    ('AU-WKR', 'AU-WKR (Kotara, New South Wales, Australia)'),
    ('AU-KWM', 'AU-KWM (Kowanyama, Queensland, Australia)'),
    ('AU-KUG', 'AU-KUG (Kubin Island, Queensland, Australia)'),
    ('AU-KGR', 'AU-KGR (Kubin Island, Queensland, Australia)'),
    ('AU-KLU', 'AU-KLU (Kulnura, New South Wales, Australia)'),
    ('AU-KUP', 'AU-KUP (Kunda Park, Queensland, Australia)'),
    ('AU-KUN', 'AU-KUN (Kundabung, New South Wales, Australia)'),
    ('AU-KGL', 'AU-KGL (Kungala, New South Wales, Australia)'),
    ('AU-KNX', 'AU-KNX (Kununurra, Western Australia, Australia)'),
    ('AU-KUR', 'AU-KUR (Kurnell, New South Wales, Australia)'),
    ('AU-KBP', 'AU-KBP (Kurraba Point, New South Wales, Australia)'),
    ('AU-KKQ', 'AU-KKQ (Kurri Kurri, New South Wales, Australia)'),
    ('AU-KRD', 'AU-KRD (Kurri Kurri, New South Wales, Australia)'),
    ('AU-KWI', 'AU-KWI (Kwinana, Western Australia, Australia)'),
    ('AU-KYA', 'AU-KYA (Kyabram, Victoria, Australia)'),
    ('AU-IGV', 'AU-IGV (Kyeemagh, New South Wales, Australia)'),
    ('AU-GYU', 'AU-GYU (Kyneton, Victoria, Australia)'),
    ('AU-IGX', 'AU-IGX (La Perouse, New South Wales, Australia)'),
    ('AU-LNE', 'AU-LNE (Laanecoorie, Victoria, Australia)'),
    ('AU-LAR', 'AU-LAR (Labrador, Queensland, Australia)'),
    ('AU-LAB', 'AU-LAB (Lady Barron, Tasmania, Australia)'),
    ('AU-LYT', 'AU-LYT (Lady Elliot Island, Queensland, Australia)'),
    ('AU-G8K', 'AU-G8K (Lake Boga, Victoria, Australia)'),
    ('AU-LCG', 'AU-LCG (Lake Cargelligo, New South Wales, Australia)'),
    ('AU-LEL', 'AU-LEL (Lake Cargelligo, New South Wales, Australia)'),
    ('AU-LMQ', 'AU-LMQ (Lake Macquarie, New South Wales, Australia)'),
    ('AU-LNH', 'AU-LNH (Lake Macquarie, New South Wales, Australia)'),
    ('AU-LFP', 'AU-LFP (Lakefield, Queensland, Australia)'),
    ('AU-LKD', 'AU-LKD (Lakeland Downs, Queensland, Australia)'),
    ('AU-LKB', 'AU-LKB (Lakemba, New South Wales, Australia)'),
    ('AU-LEN', 'AU-LEN (Lakes Entrance, Victoria, Australia)'),
    ('AU-LAA', 'AU-LAA (Lalla, Tasmania, Australia)'),
    ('AU-LAM', 'AU-LAM (Lamplough, Victoria, Australia)'),
    ('AU-LNC', 'AU-LNC (Lane Cove, New South Wales, Australia)'),
    ('AU-LAN', 'AU-LAN (Lane Cove, New South Wales, Australia)'),
    ('AU-LGR', 'AU-LGR (Langhorne Creek, South Australia, Australia)'),
    ('AU-ATK', 'AU-ATK (Langwarrin, Victoria, Australia)'),
    ('AU-JGA', 'AU-JGA (Lansdowne, New South Wales, Australia)'),
    ('AU-LDW', 'AU-LDW (Lansdowne, Western Australia, Australia)'),
    ('AU-LSV', 'AU-LSV (Lansvale, New South Wales, Australia)'),
    ('AU-LRA', 'AU-LRA (Lara, Victoria, Australia)'),
    ('AU-LRP', 'AU-LRP (Larapinta, Queensland, Australia)'),
    ('AU-LBY', 'AU-LBY (Largs Bay, South Australia, Australia)'),
    ('AU-LGN', 'AU-LGN (Largs North, South Australia, Australia)'),
    ('AU-LTB', 'AU-LTB (Latrobe, Tasmania, Australia)'),
    ('AU-LST', 'AU-LST (Launceston, Tasmania, Australia)'),
    ('AU-LHC', 'AU-LHC (Launching Place, Victoria, Australia)'),
    ('AU-LUU', 'AU-LUU (Laura, Queensland, Australia)'),
    ('AU-LUT', 'AU-LUT (Laura Station, Queensland, Australia)'),
    ('AU-LHI', 'AU-LHI (Laurel Hill, New South Wales, Australia)'),
    ('AU-JML', 'AU-JML (Laurieton, New South Wales, Australia)'),
    ('AU-LTO', 'AU-LTO (Laverton, Victoria, Australia)'),
    ('AU-LVO', 'AU-LVO (Laverton, Western Australia, Australia)'),
    ('AU-LVH', 'AU-LVH (Laverton North, Victoria, Australia)'),
    ('AU-LTN', 'AU-LTN (Lavington, New South Wales, Australia)'),
    ('AU-LWH', 'AU-LWH (Lawn Hill, Queensland, Australia)'),
    ('AU-LWN', 'AU-LWN (Lawnton, Queensland, Australia)'),
    ('AU-GXR', 'AU-GXR (Lawson, New South Wales, Australia)'),
    ('AU-LEA', 'AU-LEA (Learmonth, Western Australia, Australia)'),
    ('AU-LIM', 'AU-LIM (Leasingham, South Australia, Australia)'),
    ('AU-AUK', 'AU-AUK (Lebrina, Tasmania, Australia)'),
    ('AU-QLE', 'AU-QLE (Leeton, New South Wales, Australia)'),
    ('AU-LNA', 'AU-LNA (Legana, Tasmania, Australia)'),
    ('AU-LGT', 'AU-LGT (Legendre Terminal, Western Australia, Australia)'),
    ('AU-LEH', 'AU-LEH (Leichardt, Victoria, Australia)'),
    ('AU-LEI', 'AU-LEI (Leichhardt, New South Wales, Australia)'),
    ('AU-LGH', 'AU-LGH (Leigh Creek, South Australia, Australia)'),
    ('AU-LER', 'AU-LER (Leinster, Western Australia, Australia)'),
    ('AU-LSW', 'AU-LSW (Lenswood, South Australia, Australia)'),
    ('AU-LGA', 'AU-LGA (Leongatha, Victoria, Australia)'),
    ('AU-LLS', 'AU-LLS (Leongatha South, Victoria, Australia)'),
    ('AU-LNO', 'AU-LNO (Leonora, Western Australia, Australia)'),
    ('AU-LET', 'AU-LET (Lethbridge, Victoria, Australia)'),
    ('AU-JGF', 'AU-JGF (Leumeah, New South Wales, Australia)'),
    ('AU-LDB', 'AU-LDB (Lidcombe, New South Wales, Australia)'),
    ('AU-LPS', 'AU-LPS (Light Pass, South Australia, Australia)'),
    ('AU-LHG', 'AU-LHG (Lightning Ridge, New South Wales, Australia)'),
    ('AU-JGH', 'AU-JGH (Lilli Pilli, New South Wales, Australia)'),
    ('AU-LDE', 'AU-LDE (Lilydale, Tasmania, Australia)'),
    ('AU-LYD', 'AU-LYD (Lilydale, Victoria, Australia)'),
    ('AU-LYF', 'AU-LYF (Lilyfield, New South Wales, Australia)'),
    ('AU-LIB', 'AU-LIB (Lilyfield, New South Wales, Australia)'),
    ('AU-LLP', 'AU-LLP (Linda Downs, Queensland, Australia)'),
    ('AU-LDC', 'AU-LDC (Lindeman Island, Queensland, Australia)'),
    ('AU-LND', 'AU-LND (Lindfield, New South Wales, Australia)'),
    ('AU-LIN', 'AU-LIN (Lindisfarne, Tasmania, Australia)'),
    ('AU-LOW', 'AU-LOW (Lisarow, New South Wales, Australia)'),
    ('AU-LSY', 'AU-LSY (Lismore, New South Wales, Australia)'),
    ('AU-LLL', 'AU-LLL (Lissadell, Western Australia, Australia)'),
    ('AU-LTG', 'AU-LTG (Lithgow, New South Wales, Australia)'),
    ('AU-LRI', 'AU-LRI (Little River, Victoria, Australia)'),
    ('AU-LHT', 'AU-LHT (Littlehampton, South Australia, Australia)'),
    ('AU-LIV', 'AU-LIV (Liverpool, New South Wales, Australia)'),
    ('AU-LZR', 'AU-LZR (Lizard Island, Queensland, Australia)'),
    ('AU-LOB', 'AU-LOB (Lobethal, South Australia, Australia)'),
    ('AU-LOC', 'AU-LOC (Lock, South Australia, Australia)'),
    ('AU-LKA', 'AU-LKA (Lockhart, New South Wales, Australia)'),
    ('AU-IRG', 'AU-IRG (Lockhart River, Queensland, Australia)'),
    ('AU-LKW', 'AU-LKW (Lockwood, Victoria, Australia)'),
    ('AU-JGL', 'AU-JGL (Loftus, New South Wales, Australia)'),
    ('AU-QQD', 'AU-QQD (Loganholme, Queensland, Australia)'),
    ('AU-YUK', 'AU-YUK (Loganlea, Queensland, Australia)'),
    ('AU-HAP', 'AU-HAP (Long Island, Queensland, Australia)'),
    ('AU-LJY', 'AU-LJY (Long Jetty, New South Wales, Australia)'),
    ('AU-JGN', 'AU-JGN (Long Point, New South Wales, Australia)'),
    ('AU-LGF', 'AU-LGF (Longford, New South Wales, Australia)'),
    ('AU-LRE', 'AU-LRE (Longreach, Queensland, Australia)'),
    ('AU-JGO', 'AU-JGO (Longueville, New South Wales, Australia)'),
    ('AU-DFE', 'AU-DFE (Longwood, South Australia, Australia)'),
    ('AU-WW7', 'AU-WW7 (Longwood, Victoria, Australia)'),
    ('AU-LSD', 'AU-LSD (Lonsdale, South Australia, Australia)'),
    ('AU-LDH', 'AU-LDH (Lord Howe Is, New South Wales, Australia)'),
    ('AU-LOA', 'AU-LOA (Lorraine, Queensland, Australia)'),
    ('AU-LTV', 'AU-LTV (Lotusvale, Queensland, Australia)'),
    ('AU-LVA', 'AU-LVA (Loveday, South Australia, Australia)'),
    ('AU-LPY', 'AU-LPY (Lower Plenty, Victoria, Australia)'),
    ('AU-LRD', 'AU-LRD (Lower Portland, New South Wales, Australia)'),
    ('AU-LWD', 'AU-LWD (Lowood, Queensland, Australia)'),
    ('AU-LOX', 'AU-LOX (Loxton, South Australia, Australia)'),
    ('AU-LHW', 'AU-LHW (Lucas Heights, New South Wales, Australia)'),
    ('AU-LUC', 'AU-LUC (Lucinda, Queensland, Australia)'),
    ('AU-LUB', 'AU-LUB (Lucky Bay, South Australia, Australia)'),
    ('AU-LUM', 'AU-LUM (Luddenham, New South Wales, Australia)'),
    ('AU-JGR', 'AU-JGR (Lugarno, New South Wales, Australia)'),
    ('AU-LUN', 'AU-LUN (Lurnea/Sydney, New South Wales, Australia)'),
    ('AU-LY6', 'AU-LY6 (Luskintyre, New South Wales, Australia)'),
    ('AU-ANA', 'AU-ANA (Lutana, Tasmania, Australia)'),
    ('AU-LTP', 'AU-LTP (Lyndhurst, Queensland, Australia)'),
    ('AU-VIL', 'AU-VIL (Lyndhurst, Victoria, Australia)'),
    ('AU-LH4', 'AU-LH4 (Lyndoch, South Australia, Australia)'),
    ('AU-LHM', 'AU-LHM (Lyndoch, South Australia, Australia)'),
    ('AU-S4R', 'AU-S4R (Lysterfield, Victoria, Australia)'),
    ('AU-LTT', 'AU-LTT (Lytton, Queensland, Australia)'),
    ('AU-UBB', 'AU-UBB (Mabuiag Island, Queensland, Australia)'),
    ('AU-MD9', 'AU-MD9 (Macclesfield, South Australia, Australia)'),
    ('AU-MNW', 'AU-MNW (Macclesfield, South Australia, Australia)'),
    ('AU-MDN', 'AU-MDN (Macedon, Victoria, Australia)'),
    ('AU-QU4', 'AU-QU4 (Macgregor, Queensland, Australia)'),
    ('AU-MKY', 'AU-MKY (Mackay, Queensland, Australia)'),
    ('AU-MVH', 'AU-MVH (Macksville, New South Wales, Australia)'),
    ('AU-MHC', 'AU-MHC (Macmahon Camp 4, South Australia, Australia)'),
    ('AU-MMB', 'AU-MMB (Macmasters Beach, New South Wales, Australia)'),
    ('AU-MQI', 'AU-MQI (Macquarie Island, Tasmania, Australia)'),
    ('AU-MRK', 'AU-MRK (Macquarie Park, New South Wales, Australia)'),
    ('AU-MAD', 'AU-MAD (Maddington, Western Australia, Australia)'),
    ('AU-MAF', 'AU-MAF (Maffra, Victoria, Australia)'),
    ('AU-INR', 'AU-INR (Maianbar, New South Wales, Australia)'),
    ('AU-GU9', 'AU-GU9 (Maiden Gully, Victoria, Australia)'),
    ('AU-MDO', 'AU-MDO (Maidstone, Victoria, Australia)'),
    ('AU-RDG', 'AU-RDG (Main Ridge, Victoria, Australia)'),
    ('AU-MIZ', 'AU-MIZ (Main Ridge, Victoria, Australia)'),
    ('AU-MTL', 'AU-MTL (Maitland, New South Wales, Australia)'),
    ('AU-MAJ', 'AU-MAJ (Maitland, New South Wales, Australia)'),
    ('AU-AGA', 'AU-AGA (Malaga, Western Australia, Australia)'),
    ('AU-MAL', 'AU-MAL (Maleny, Queensland, Australia)'),
    ('AU-XMC', 'AU-XMC (Mallacoota, Victoria, Australia)'),
    ('AU-MMY', 'AU-MMY (Malmsbury, Victoria, Australia)'),
    ('AU-MBX', 'AU-MBX (Malua Bay, New South Wales, Australia)'),
    ('AU-MVN', 'AU-MVN (Malvern, Victoria, Australia)'),
    ('AU-MVR', 'AU-MVR (Malvern, South Australia, Australia)'),
    ('AU-MDP', 'AU-MDP (Mandogalup, Western Australia, Australia)'),
    ('AU-MQA', 'AU-MQA (Mandora, Western Australia, Australia)'),
    ('AU-MDU', 'AU-MDU (Mandurah, Western Australia, Australia)'),
    ('AU-M4H', 'AU-M4H (Mango Hill, Queensland, Australia)'),
    ('AU-LRM', 'AU-LRM (Manildra, New South Wales, Australia)'),
    ('AU-MNL', 'AU-MNL (Manilla, New South Wales, Australia)'),
    ('AU-MNG', 'AU-MNG (Manilla, New South Wales, Australia)'),
    ('AU-MJP', 'AU-MJP (Manjimup, Western Australia, Australia)'),
    ('AU-WGZ', 'AU-WGZ (Manly, New South Wales, Australia)'),
    ('AU-MFP', 'AU-MFP (Manly, New South Wales, Australia)'),
    ('AU-MFC', 'AU-MFC (Mansfield, Victoria, Australia)'),
    ('AU-SW3', 'AU-SW3 (Marananga, South Australia, Australia)'),
    ('AU-MAO', 'AU-MAO (Marayong, New South Wales, Australia)'),
    ('AU-MBB', 'AU-MBB (Marble Bar, Western Australia, Australia)'),
    ('AU-AWK', 'AU-AWK (Marburg, Queensland, Australia)'),
    ('AU-MRG', 'AU-MRG (Mareeba, Queensland, Australia)'),
    ('AU-MGR', 'AU-MGR (Margaret River, Western Australia, Australia)'),
    ('AU-MGV', 'AU-MGV (Margaret River Station, Western Australia, Australia)'),
    ('AU-MBY', 'AU-MBY (Maribyrnong, Victoria, Australia)'),
    ('AU-MXD', 'AU-MXD (Marion Downs, Queensland, Australia)'),
    ('AU-MRP', 'AU-MRP (Marla, South Australia, Australia)'),
    ('AU-MRN', 'AU-MRN (Marong, Victoria, Australia)'),
    ('AU-MCY', 'AU-MCY (Maroochydore Apt/Sunshine Coast, Queensland, Australia)'),
    ('AU-MOZ', 'AU-MOZ (Maroota, New South Wales, Australia)'),
    ('AU-MAU', 'AU-MAU (Maroubra, New South Wales, Australia)'),
    ('AU-MQE', 'AU-MQE (Maroubra, New South Wales, Australia)'),
    ('AU-MR4', 'AU-MR4 (Marrar, New South Wales, Australia)'),
    ('AU-MAA', 'AU-MAA (Marrar, New South Wales, Australia)'),
    ('AU-RRE', 'AU-RRE (Marree, South Australia, Australia)'),
    ('AU-MAR', 'AU-MAR (Marrickville, New South Wales, Australia)'),
    ('AU-MAK', 'AU-MAK (Marsden Park, New South Wales, Australia)'),
    ('AU-MFD', 'AU-MFD (Marsfield, New South Wales, Australia)'),
    ('AU-MLN', 'AU-MLN (Marulan, New South Wales, Australia)'),
    ('AU-MBH', 'AU-MBH (Maryborough, Queensland, Australia)'),
    ('AU-SAD', 'AU-SAD (Maryborough, Victoria, Australia)'),
    ('AU-WWA', 'AU-WWA (Marybrook, Western Australia, Australia)'),
    ('AU-KLL', 'AU-KLL (Maryknoll, Victoria, Australia)'),
    ('AU-MRY', 'AU-MRY (Maryland, New South Wales, Australia)'),
    ('AU-MAV', 'AU-MAV (Maryvale, Queensland, Australia)'),
    ('AU-MVL', 'AU-MVL (Maryvale, South Australia, Australia)'),
    ('AU-MAS', 'AU-MAS (Mascot, New South Wales, Australia)'),
    ('AU-MAH', 'AU-MAH (Matcham, New South Wales, Australia)'),
    ('AU-MHA', 'AU-MHA (Mathoura, New South Wales, Australia)'),
    ('AU-MTO', 'AU-MTO (Matong, New South Wales, Australia)'),
    ('AU-MAT', 'AU-MAT (Matraville, New South Wales, Australia)'),
    ('AU-MAW', 'AU-MAW (Mawson Lakes, South Australia, Australia)'),
    ('AU-MAY', 'AU-MAY (Mayfield, Tasmania, Australia)'),
    ('AU-MYF', 'AU-MYF (Mayfield, New South Wales, Australia)'),
    ('AU-MDS', 'AU-MDS (Maylands, South Australia, Australia)'),
    ('AU-MYS', 'AU-MYS (Maylands, Western Australia, Australia)'),
    ('AU-MCV', 'AU-MCV (Maylands, Western Australia, Australia)'),
    ('AU-MCR', 'AU-MCR (Mccrae, Victoria, Australia)'),
    ('AU-MCG', 'AU-MCG (McGraths Hill, New South Wales, Australia)'),
    ('AU-MLF', 'AU-MLF (Mclaren Flat, South Australia, Australia)'),
    ('AU-MCL', 'AU-MCL (McLaren Vale, South Australia, Australia)'),
    ('AU-MCD', 'AU-MCD (Mcleans Ridges, New South Wales, Australia)'),
    ('AU-MCP', 'AU-MCP (Mcmahons Point, New South Wales, Australia)'),
    ('AU-MWO', 'AU-MWO (Meadowbrook, Queensland, Australia)'),
    ('AU-SUI', 'AU-SUI (Meadows, South Australia, Australia)'),
    ('AU-MKR', 'AU-MKR (Meekatharra, Western Australia, Australia)'),
    ('AU-MEL', 'AU-MEL (Melbourne, Victoria, Australia)'),
    ('AU-KAH', 'AU-KAH (Melbourne City Heliport, Victoria, Australia)'),
    ('AU-MRS', 'AU-MRS (Melrose, South Australia, Australia)'),
    ('AU-MEP', 'AU-MEP (Melrose Park, New South Wales, Australia)'),
    ('AU-MT9', 'AU-MT9 (Melton, Victoria, Australia)'),
    ('AU-MLE', 'AU-MLE (Melville, Western Australia, Australia)'),
    ('AU-MLI', 'AU-MLI (Melville, Western Australia, Australia)'),
    ('AU-MNI', 'AU-MNI (Menai, New South Wales, Australia)'),
    ('AU-MTN', 'AU-MTN (Mentone, Victoria, Australia)'),
    ('AU-M2C', 'AU-M2C (Menzies Creek, Victoria, Australia)'),
    ('AU-MER', 'AU-MER (Merbein, Victoria, Australia)'),
    ('AU-MEE', 'AU-MEE (Meredith, Victoria, Australia)'),
    ('AU-HH5', 'AU-HH5 (Merewether, New South Wales, Australia)'),
    ('AU-MIM', 'AU-MIM (Merimbula, New South Wales, Australia)'),
    ('AU-MDA', 'AU-MDA (Merinda, Queensland, Australia)'),
    ('AU-MLV', 'AU-MLV (Merluna, Queensland, Australia)'),
    ('AU-MEN', 'AU-MEN (Mernda, Victoria, Australia)'),
    ('AU-MRD', 'AU-MRD (Merredin, Western Australia, Australia)'),
    ('AU-MRH', 'AU-MRH (Merricks North, Victoria, Australia)'),
    ('AU-MYD', 'AU-MYD (Merrylands, New South Wales, Australia)'),
    ('AU-RTY', 'AU-RTY (Merty, South Australia, Australia)'),
    ('AU-MRU', 'AU-MRU (Meru, Western Australia, Australia)'),
    ('AU-MTC', 'AU-MTC (Metricup, Western Australia, Australia)'),
    ('AU-MII', 'AU-MII (Miami, Queensland, Australia)'),
    ('AU-MLA', 'AU-MLA (Michelago, New South Wales, Australia)'),
    ('AU-MIK', 'AU-MIK (Mickleham, Victoria, Australia)'),
    ('AU-MSN', 'AU-MSN (Middle Swan, Western Australia, Australia)'),
    ('AU-MMM', 'AU-MMM (Middlemount, Queensland, Australia)'),
    ('AU-MLT', 'AU-MLT (Middleton, South Australia, Australia)'),
    ('AU-MID', 'AU-MID (Midland, Western Australia, Australia)'),
    ('AU-IMV', 'AU-IMV (Midvale, Western Australia, Australia)'),
    ('AU-XV4', 'AU-XV4 (Milawa, Victoria, Australia)'),
    ('AU-MBD', 'AU-MBD (Milbrodale, New South Wales, Australia)'),
    ('AU-MQL', 'AU-MQL (Mildura, Victoria, Australia)'),
    ('AU-MED', 'AU-MED (Mile End, South Australia, Australia)'),
    ('AU-MGT', 'AU-MGT (Mile End, South Australia, Australia)'),
    ('AU-MLP', 'AU-MLP (Mill Park, Victoria, Australia)'),
    ('AU-MNN', 'AU-MNN (Millendon, Western Australia, Australia)'),
    ('AU-MLR', 'AU-MLR (Millicent, South Australia, Australia)'),
    ('AU-MMN', 'AU-MMN (Millmerran, Queensland, Australia)'),
    ('AU-MIB', 'AU-MIB (Millmerran, Queensland, Australia)'),
    ('AU-MIL', 'AU-MIL (Milperra, New South Wales, Australia)'),
    ('AU-MSP', 'AU-MSP (Milsons Point, New South Wales, Australia)'),
    ('AU-MCB', 'AU-MCB (Minchinbury, New South Wales, Australia)'),
    ('AU-MDE', 'AU-MDE (Mindarie, South Australia, Australia)'),
    ('AU-MRL', 'AU-MRL (Miners Lake, Queensland, Australia)'),
    ('AU-XML', 'AU-XML (Minlaton, South Australia, Australia)'),
    ('AU-MIN', 'AU-MIN (Minnipa, South Australia, Australia)'),
    ('AU-MNR', 'AU-MNR (Mintaro, South Australia, Australia)'),
    ('AU-MNT', 'AU-MNT (Minto, New South Wales, Australia)'),
    ('AU-MYM', 'AU-MYM (Minyama, Queensland, Australia)'),
    ('AU-MND', 'AU-MND (Miranda, New South Wales, Australia)'),
    ('AU-MWY', 'AU-MWY (Miranda Downs, Queensland, Australia)'),
    ('AU-MIT', 'AU-MIT (Mitcham, Victoria, Australia)'),
    ('AU-MTQ', 'AU-MTQ (Mitchell, Queensland, Australia)'),
    ('AU-MIP', 'AU-MIP (Mitchell Park, South Australia, Australia)'),
    ('AU-MTP', 'AU-MTP (Mitchell Park, Victoria, Australia)'),
    ('AU-MIH', 'AU-MIH (Mitchell Plateau, Western Australia, Australia)'),
    ('AU-MXQ', 'AU-MXQ (Mitchell River, Queensland, Australia)'),
    ('AU-MHL', 'AU-MHL (Mitchell River, Queensland, Australia)'),
    ('AU-MGO', 'AU-MGO (Mittagong, New South Wales, Australia)'),
    ('AU-MIY', 'AU-MIY (Mittagong, New South Wales, Australia)'),
    ('AU-MOA', 'AU-MOA (Moama, New South Wales, Australia)'),
    ('AU-MNA', 'AU-MNA (Moana, South Australia, Australia)'),
    ('AU-MOC', 'AU-MOC (Moculta, South Australia, Australia)'),
    ('AU-MDB', 'AU-MDB (Modbury, South Australia, Australia)'),
    ('AU-MOD', 'AU-MOD (Modbury, South Australia, Australia)'),
    ('AU-MOE', 'AU-MOE (Moe, Victoria, Australia)'),
    ('AU-MDI', 'AU-MDI (Molendinar, Queensland, Australia)'),
    ('AU-MLG', 'AU-MLG (Molong, New South Wales, Australia)'),
    ('AU-NMV', 'AU-NMV (Mona Vale, New South Wales, Australia)'),
    ('AU-MCN', 'AU-MCN (Monarto South, South Australia, Australia)'),
    ('AU-MSH', 'AU-MSH (Monash, South Australia, Australia)'),
    ('AU-MUK', 'AU-MUK (Monbulk, Victoria, Australia)'),
    ('AU-MJK', 'AU-MJK (Monkey Mia, Western Australia, Australia)'),
    ('AU-ONR', 'AU-ONR (Monkira, Queensland, Australia)'),
    ('AU-MAN', 'AU-MAN (Mont Albert North, Victoria, Australia)'),
    ('AU-MON', 'AU-MON (Mont Albert North, Victoria, Australia)'),
    ('AU-M6Y', 'AU-M6Y (Montmorency, Victoria, Australia)'),
    ('AU-MNQ', 'AU-MNQ (Monto, Queensland, Australia)'),
    ('AU-MTR', 'AU-MTR (Montrose, Victoria, Australia)'),
    ('AU-MVP', 'AU-MVP (Moolap, Victoria, Australia)'),
    ('AU-MWT', 'AU-MWT (Moolawatana, South Australia, Australia)'),
    ('AU-MLL', 'AU-MLL (Mooloolaba, Queensland, Australia)'),
    ('AU-MOO', 'AU-MOO (Moomba, South Australia, Australia)'),
    ('AU-MNH', 'AU-MNH (Moonah, Tasmania, Australia)'),
    ('AU-SX5', 'AU-SX5 (Moonambel, Victoria, Australia)'),
    ('AU-MNP', 'AU-MNP (Moonee Ponds, Victoria, Australia)'),
    ('AU-EYM', 'AU-EYM (Mooney Mooney, New South Wales, Australia)'),
    ('AU-MRA', 'AU-MRA (Moora, Western Australia, Australia)'),
    ('AU-MBW', 'AU-MBW (Moorabbin, Victoria, Australia)'),
    ('AU-OOR', 'AU-OOR (Mooraberree, Queensland, Australia)'),
    ('AU-MOL', 'AU-MOL (Moorabool, Victoria, Australia)'),
    ('AU-MPK', 'AU-MPK (Moore Park, New South Wales, Australia)'),
    ('AU-MRB', 'AU-MRB (Moorebank/Sydney, New South Wales, Australia)'),
    ('AU-MRO', 'AU-MRO (Moorooduc, Victoria, Australia)'),
    ('AU-MOK', 'AU-MOK (Moorook, South Australia, Australia)'),
    ('AU-MBK', 'AU-MBK (Mooroolbark, Victoria, Australia)'),
    ('AU-MPV', 'AU-MPV (Mooroopna, Victoria, Australia)'),
    ('AU-MOV', 'AU-MOV (Moranbah, Queensland, Australia)'),
    ('AU-MWB', 'AU-MWB (Morawa, Western Australia, Australia)'),
    ('AU-MFX', 'AU-MFX (Morayfield, Queensland, Australia)'),
    ('AU-MDC', 'AU-MDC (Mordialloc, Victoria, Australia)'),
    ('AU-MRZ', 'AU-MRZ (Moree, New South Wales, Australia)'),
    ('AU-MET', 'AU-MET (Moreton, Queensland, Australia)'),
    ('AU-AAG', 'AU-AAG (Morgan, South Australia, Australia)'),
    ('AU-MLY', 'AU-MLY (Morley, Western Australia, Australia)'),
    ('AU-OXY', 'AU-OXY (Morney, Queensland, Australia)'),
    ('AU-MGS', 'AU-MGS (Morningside, Queensland, Australia)'),
    ('AU-M3N', 'AU-M3N (Mornington, Victoria, Australia)'),
    ('AU-ONG', 'AU-ONG (Mornington, Queensland, Australia)'),
    ('AU-MRT', 'AU-MRT (Mornington, Queensland, Australia)'),
    ('AU-MPT', 'AU-MPT (Morpeth, New South Wales, Australia)'),
    ('AU-MV2', 'AU-MV2 (Morphett Vale, South Australia, Australia)'),
    ('AU-MDL', 'AU-MDL (Mortdale, New South Wales, Australia)'),
    ('AU-MYA', 'AU-MYA (Moruya, New South Wales, Australia)'),
    ('AU-MOR', 'AU-MOR (Morwell, Victoria, Australia)'),
    ('AU-MSA', 'AU-MSA (Mosman, New South Wales, Australia)'),
    ('AU-MMP', 'AU-MMP (Mosman Park, Western Australia, Australia)'),
    ('AU-MVA', 'AU-MVA (Moss Vale, New South Wales, Australia)'),
    ('AU-MBA', 'AU-MBA (Mount Barker, Western Australia, Australia)'),
    ('AU-MBN', 'AU-MBN (Mount Barnett, Western Australia, Australia)'),
    ('AU-MB2', 'AU-MB2 (Mount Benson, South Australia, Australia)'),
    ('AU-MBF', 'AU-MBF (Mount Buffalo, Victoria, Australia)'),
    ('AU-MML', 'AU-MML (Mount Camel, Victoria, Australia)'),
    ('AU-MKV', 'AU-MKV (Mount Camel, Victoria, Australia)'),
    ('AU-CAO', 'AU-CAO (Mount Colah, New South Wales, Australia)'),
    ('AU-MCS', 'AU-MCS (Mount Compass, South Australia, Australia)'),
    ('AU-MCC', 'AU-MCC (Mount Cotton, Queensland, Australia)'),
    ('AU-M2D', 'AU-M2D (Mount Dandenong, Victoria, Australia)'),
    ('AU-NUI', 'AU-NUI (Mount Druitt, New South Wales, Australia)'),
    ('AU-MEZ', 'AU-MEZ (Mount Eliza, Victoria, Australia)'),
    ('AU-MFL', 'AU-MFL (Mount Full Stop, Queensland, Australia)'),
    ('AU-MGB', 'AU-MGB (Mount Gambier, South Australia, Australia)'),
    ('AU-MGE', 'AU-MGE (Mount Gravatt, Queensland, Australia)'),
    ('AU-GSN', 'AU-GSN (Mount Gunson, South Australia, Australia)'),
    ('AU-MHW', 'AU-MHW (Mount Hawthorn, Western Australia, Australia)'),
    ('AU-MHU', 'AU-MHU (Mount Hotham, Victoria, Australia)'),
    ('AU-MHO', 'AU-MHO (Mount House, Western Australia, Australia)'),
    ('AU-ISA', 'AU-ISA (Mount Isa, Queensland, Australia)'),
    ('AU-WME', 'AU-WME (Mount Keith, Western Australia, Australia)'),
    ('AU-MKG', 'AU-MKG (Mount Kuring-Gai, New South Wales, Australia)'),
    ('AU-MTY', 'AU-MTY (Mount Lawley, Western Australia, Australia)'),
    ('AU-MLS', 'AU-MLS (Mount Louisa, Queensland, Australia)'),
    ('AU-MD2', 'AU-MD2 (Mount Macedon, Victoria, Australia)'),
    ('AU-MMG', 'AU-MMG (Mount Magnet, Western Australia, Australia)'),
    ('AU-M3M', 'AU-M3M (Mount Martha, Victoria, Australia)'),
    ('AU-MTH', 'AU-MTH (Mount Nathan, Queensland, Australia)'),
    ('AU-MPL', 'AU-MPL (Mount Pleasant, South Australia, Australia)'),
    ('AU-SUO', 'AU-SUO (Mount Pleasant, New South Wales, Australia)'),
    ('AU-MTS', 'AU-MTS (Mount Saint John, Queensland, Australia)'),
    ('AU-MTD', 'AU-MTD (Mount Saint John, Queensland, Australia)'),
    ('AU-MSF', 'AU-MSF (Mount Saint John, Queensland, Australia)'),
    ('AU-T8M', 'AU-T8M (Mount Torrens, South Australia, Australia)'),
    ('AU-MTW', 'AU-MTW (Mount Waverly, Victoria, Australia)'),
    ('AU-WAH', 'AU-WAH (Mount White, New South Wales, Australia)'),
    ('AU-MNV', 'AU-MNV (Mount White, New South Wales, Australia)'),
    ('AU-BKR', 'AU-BKR (Mountbarker, Western Australia, Australia)'),
    ('AU-OUR', 'AU-OUR (Moura, Queensland, Australia)'),
    ('AU-MOU', 'AU-MOU (Mourilyan, Queensland, Australia)'),
    ('AU-MOW', 'AU-MOW (Mowbray Heights, Tasmania, Australia)'),
    ('AU-MYU', 'AU-MYU (Moyhu, Victoria, Australia)'),
    ('AU-MUQ', 'AU-MUQ (Muccan, Western Australia, Australia)'),
    ('AU-MHE', 'AU-MHE (Muchea, Western Australia, Australia)'),
    ('AU-DGE', 'AU-DGE (Mudgee, New South Wales, Australia)'),
    ('AU-MUD', 'AU-MUD (Mudgeeraba, Queensland, Australia)'),
    ('AU-MUJ', 'AU-MUJ (Muja, Western Australia, Australia)'),
    ('AU-MBU', 'AU-MBU (Mukinbudin, Western Australia, Australia)'),
    ('AU-MUP', 'AU-MUP (Mukinbudin, Western Australia, Australia)'),
    ('AU-OGA', 'AU-OGA (Mulgoa, New South Wales, Australia)'),
    ('AU-MUL', 'AU-MUL (Mulgrave, Victoria, Australia)'),
    ('AU-MVK', 'AU-MVK (Mulka, South Australia, Australia)'),
    ('AU-MXU', 'AU-MXU (Mullewa, Western Australia, Australia)'),
    ('AU-MWA', 'AU-MWA (Mulwala, New South Wales, Australia)'),
    ('AU-MDG', 'AU-MDG (Mundingburra, Queensland, Australia)'),
    ('AU-MUA', 'AU-MUA (Mundulla, South Australia, Australia)'),
    ('AU-MNE', 'AU-MNE (Mungeranie, South Australia, Australia)'),
    ('AU-MRI', 'AU-MRI (Murarrie, Queensland, Australia)'),
    ('AU-MUC', 'AU-MUC (Murchison, Victoria, Australia)'),
    ('AU-DCH', 'AU-DCH (Murdoch, Western Australia, Australia)'),
    ('AU-MUB', 'AU-MUB (Murray Bridge, South Australia, Australia)'),
    ('AU-MYI', 'AU-MYI (Murray Island, Queensland, Australia)'),
    ('AU-RMR', 'AU-RMR (Murrey, South Australia, Australia)'),
    ('AU-MRR', 'AU-MRR (Murrindindi, Victoria, Australia)'),
    ('AU-MBM', 'AU-MBM (Murrumbateman, New South Wales, Australia)'),
    ('AU-MUR', 'AU-MUR (Murwillumbah, New South Wales, Australia)'),
    ('AU-MVU', 'AU-MVU (Musgrave, Queensland, Australia)'),
    ('AU-MSK', 'AU-MSK (Musk Vale, Victoria, Australia)'),
    ('AU-OOK', 'AU-OOK (Muswellbrook, New South Wales, Australia)'),
    ('AU-MUT', 'AU-MUT (Muswellbrook, New South Wales, Australia)'),
    ('AU-UTB', 'AU-UTB (Muttaburra, Queensland, Australia)'),
    ('AU-MTA', 'AU-MTA (Muttama, New South Wales, Australia)'),
    ('AU-MBC', 'AU-MBC (Myaree, Western Australia, Australia)'),
    ('AU-MYR', 'AU-MYR (Mylor, South Australia, Australia)'),
    ('AU-MYO', 'AU-MYO (Myroodah, Western Australia, Australia)'),
    ('AU-HEE', 'AU-HEE (Myrrhee, Victoria, Australia)'),
    ('AU-ORD', 'AU-ORD (Myrtleford, Victoria, Australia)'),
    ('AU-NAG', 'AU-NAG (Nagambie, Victoria, Australia)'),
    ('AU-NSS', 'AU-NSS (Nairne, South Australia, Australia)'),
    ('AU-NBR', 'AU-NBR (Nambour, Queensland, Australia)'),
    ('AU-NBH', 'AU-NBH (Nambucca Heads, New South Wales, Australia)'),
    ('AU-NAN', 'AU-NAN (Nangwarry, South Australia, Australia)'),
    ('AU-NNU', 'AU-NNU (Nannup, Western Australia, Australia)'),
    ('AU-NMR', 'AU-NMR (Nappa Merry, Queensland, Australia)'),
    ('AU-NPP', 'AU-NPP (Nappa Merry, Queensland, Australia)'),
    ('AU-NNG', 'AU-NNG (Nar Nar Goon, Victoria, Australia)'),
    ('AU-NAC', 'AU-NAC (Naracoorte, South Australia, Australia)'),
    ('AU-NBA', 'AU-NBA (Narangba, Queensland, Australia)'),
    ('AU-NLN', 'AU-NLN (Narellan, New South Wales, Australia)'),
    ('AU-NBE', 'AU-NBE (Narembeen, Western Australia, Australia)'),
    ('AU-QRX', 'AU-QRX (Narooma, New South Wales, Australia)'),
    ('AU-NRB', 'AU-NRB (Narrabeen, New South Wales, Australia)'),
    ('AU-NAA', 'AU-NAA (Narrabri, New South Wales, Australia)'),
    ('AU-NAR', 'AU-NAR (Narracoopa, Tasmania, Australia)'),
    ('AU-NRA', 'AU-NRA (Narrandera, New South Wales, Australia)'),
    ('AU-NWA', 'AU-NWA (Narraweena, New South Wales, Australia)'),
    ('AU-NRW', 'AU-NRW (Narre Warren, Victoria, Australia)'),
    ('AU-N2N', 'AU-N2N (Narre Warren North, Victoria, Australia)'),
    ('AU-NKU', 'AU-NKU (Narrikup, Western Australia, Australia)'),
    ('AU-NRG', 'AU-NRG (Narrogin, Western Australia, Australia)'),
    ('AU-QRM', 'AU-QRM (Narromine, New South Wales, Australia)'),
    ('AU-NAB', 'AU-NAB (Naval Base, Western Australia, Australia)'),
    ('AU-NDD', 'AU-NDD (Nedlands, Western Australia, Australia)'),
    ('AU-NER', 'AU-NER (Nerang, Queensland, Australia)'),
    ('AU-NEQ', 'AU-NEQ (Nericon, New South Wales, Australia)'),
    ('AU-NRN', 'AU-NRN (Nerong, New South Wales, Australia)'),
    ('AU-NEU', 'AU-NEU (Neurea, New South Wales, Australia)'),
    ('AU-BA2', 'AU-BA2 (Neutral Bay, New South Wales, Australia)'),
    ('AU-NFR', 'AU-NFR (New Farm, Queensland, Australia)'),
    ('AU-NLT', 'AU-NLT (New Lambton, New South Wales, Australia)'),
    ('AU-NMP', 'AU-NMP (New Moon, Queensland, Australia)'),
    ('AU-NLK', 'AU-NLK (New Norfolk, Tasmania, Australia)'),
    ('AU-NEW', 'AU-NEW (Newborough, Victoria, Australia)'),
    ('AU-NTL', 'AU-NTL (Newcastle, New South Wales, Australia)'),
    ('AU-NAM', 'AU-NAM (Newham, Victoria, Australia)'),
    ('AU-NWM', 'AU-NWM (Newman, Western Australia, Australia)'),
    ('AU-ZNE', 'AU-ZNE (Newman Apt, Western Australia, Australia)'),
    ('AU-NMA', 'AU-NMA (Newmarket, Queensland, Australia)'),
    ('AU-WNH', 'AU-WNH (Newnham, Tasmania, Australia)'),
    ('AU-NWP', 'AU-NWP (Newport, New South Wales, Australia)'),
    ('AU-NWT', 'AU-NWT (Newport, Victoria, Australia)'),
    ('AU-NRY', 'AU-NRY (Newport, Victoria, Australia)'),
    ('AU-NSD', 'AU-NSD (Newstead, Queensland, Australia)'),
    ('AU-NST', 'AU-NST (Newstead, Tasmania, Australia)'),
    ('AU-VIC', 'AU-VIC (Newtown, Victoria, Australia)'),
    ('AU-NGH', 'AU-NGH (Nganhurra, Western Australia, Australia)'),
    ('AU-RPM', 'AU-RPM (Nganhurra, Western Australia, Australia)'),
    ('AU-NHU', 'AU-NHU (Nganhurra, Western Australia, Australia)'),
    ('AU-NLS', 'AU-NLS (Nicholson, Western Australia, Australia)'),
    ('AU-NIF', 'AU-NIF (Nifty, Western Australia, Australia)'),
    ('AU-NTA', 'AU-NTA (Nimmitabel, New South Wales, Australia)'),
    ('AU-NIV', 'AU-NIV (Nimmitabel, New South Wales, Australia)'),
    ('AU-NIN', 'AU-NIN (Ningi, Queensland, Australia)'),
    ('AU-NNR', 'AU-NNR (Noarlunga, South Australia, Australia)'),
    ('AU-NDW', 'AU-NDW (Noarlunga Downs, South Australia, Australia)'),
    ('AU-NBP', 'AU-NBP (Noble Park, Victoria, Australia)'),
    ('AU-NKB', 'AU-NKB (Noonkanbah, Western Australia, Australia)'),
    ('AU-NSA', 'AU-NSA (Noosa, Queensland, Australia)'),
    ('AU-NSV', 'AU-NSV (Noosaville, Queensland, Australia)'),
    ('AU-NOE', 'AU-NOE (Norlane, Victoria, Australia)'),
    ('AU-RST', 'AU-RST (Normanhurst, New South Wales, Australia)'),
    ('AU-NTN', 'AU-NTN (Normanton, Queensland, Australia)'),
    ('AU-NSM', 'AU-NSM (Norseman, Western Australia, Australia)'),
    ('AU-NBW', 'AU-NBW (North Balwyn, Victoria, Australia)'),
    ('AU-NBQ', 'AU-NBQ (North Beach, Western Australia, Australia)'),
    ('AU-NB2', 'AU-NB2 (North Bridge, New South Wales, Australia)'),
    ('AU-NCC', 'AU-NCC (North Curl Curl, New South Wales, Australia)'),
    ('AU-NFM', 'AU-NFM (North Fremantle, Western Australia, Australia)'),
    ('AU-GGN', 'AU-GGN (North Geelong, Victoria, Australia)'),
    ('AU-NVN', 'AU-NVN (North Haven, South Australia, Australia)'),
    ('AU-NLE', 'AU-NLE (North Lismore, New South Wales, Australia)'),
    ('AU-NM2', 'AU-NM2 (North Manly, New South Wales, Australia)'),
    ('AU-NME', 'AU-NME (North Melbourne, Victoria, Australia)'),
    ('AU-NNN', 'AU-NNN (North Narrabeen, New South Wales, Australia)'),
    ('AU-NRD', 'AU-NRD (North Richmond, New South Wales, Australia)'),
    ('AU-NRC', 'AU-NRC (North Rocks, New South Wales, Australia)'),
    ('AU-NRE', 'AU-NRE (North Ryde, New South Wales, Australia)'),
    ('AU-NSY', 'AU-NSY (North Sydney, New South Wales, Australia)'),
    ('AU-NTB', 'AU-NTB (North Tamborine, Queensland, Australia)'),
    ('AU-T8R', 'AU-T8R (North Turramurra, New South Wales, Australia)'),
    ('AU-NHA', 'AU-NHA (Northam, Western Australia, Australia)'),
    ('AU-NTF', 'AU-NTF (Northcliffe, Western Australia, Australia)'),
    ('AU-S3B', 'AU-S3B (Northcote, Victoria, Australia)'),
    ('AU-NTE', 'AU-NTE (Northcote, Victoria, Australia)'),
    ('AU-NGT', 'AU-NGT (Northgate, Queensland, Australia)'),
    ('AU-NOM', 'AU-NOM (Northmead, New South Wales, Australia)'),
    ('AU-R5W', 'AU-R5W (Northwood, New South Wales, Australia)'),
    ('AU-MMT', 'AU-MMT (Norton Summit, South Australia, Australia)'),
    ('AU-NOR', 'AU-NOR (Norwood, South Australia, Australia)'),
    ('AU-NTH', 'AU-NTH (Notting Hill, Victoria, Australia)'),
    ('AU-NOA', 'AU-NOA (Nowra, New South Wales, Australia)'),
    ('AU-NUK', 'AU-NUK (Nulkaba, New South Wales, Australia)'),
    ('AU-NLL', 'AU-NLL (Nullagine, Western Australia, Australia)'),
    ('AU-NUR', 'AU-NUR (Nullarbor, South Australia, Australia)'),
    ('AU-NUB', 'AU-NUB (Nullarbor, South Australia, Australia)'),
    ('AU-NUM', 'AU-NUM (Numurkah, Victoria, Australia)'),
    ('AU-NWD', 'AU-NWD (Nunawading, Victoria, Australia)'),
    ('AU-NDH', 'AU-NDH (Nundah, Queensland, Australia)'),
    ('AU-NRP', 'AU-NRP (Nurioopta, South Australia, Australia)'),
    ('AU-NOO', 'AU-NOO (Nuriootpa, South Australia, Australia)'),
    ('AU-S3N', 'AU-S3N (Nutfield, Victoria, Australia)'),
    ('AU-UTD', 'AU-UTD (Nutfield, Victoria, Australia)'),
    ('AU-NYN', 'AU-NYN (Nyngan, New South Wales, Australia)'),
    ('AU-OSF', "AU-OSF (O'Connell, New South Wales, Australia)"),
    ('AU-OCN', "AU-OCN (O'Connor, Western Australia, Australia)"),
    ('AU-OKF', 'AU-OKF (Oak Flats, New South Wales, Australia)'),
    ('AU-SAO', 'AU-SAO (Oakbank, South Australia, Australia)'),
    ('AU-OKY', 'AU-OKY (Oakey, Queensland, Australia)'),
    ('AU-OAK', 'AU-OAK (Oakford, Western Australia, Australia)'),
    ('AU-OKU', 'AU-OKU (Oakhurst, Queensland, Australia)'),
    ('AU-O8O', 'AU-O8O (Oaklands Park, South Australia, Australia)'),
    ('AU-OLH', 'AU-OLH (Oakleigh, Victoria, Australia)'),
    ('AU-S4W', 'AU-S4W (Oakleigh East, Victoria, Australia)'),
    ('AU-OBA', 'AU-OBA (Oban, Queensland, Australia)'),
    ('AU-OBO', 'AU-OBO (Oberon, New South Wales, Australia)'),
    ('AU-OGV', 'AU-OGV (Ocean Grove, Victoria, Australia)'),
    ('AU-OPI', 'AU-OPI (Ocean Grove, Victoria, Australia)'),
    ('AU-S4E', 'AU-S4E (Officer, Victoria, Australia)'),
    ('AU-OKH', 'AU-OKH (Okha FPSO, Western Australia, Australia)'),
    ('AU-OLP', 'AU-OLP (Olympic Dam, South Australia, Australia)'),
    ('AU-OPH', 'AU-OPH (Onkaparinga Hills, South Australia, Australia)'),
    ('AU-ONS', 'AU-ONS (Onslow, Western Australia, Australia)'),
    ('AU-ODD', 'AU-ODD (Oodnadatta, South Australia, Australia)'),
    ('AU-OAG', 'AU-OAG (Orange, New South Wales, Australia)'),
    ('AU-RBS', 'AU-RBS (Orbost, Victoria, Australia)'),
    ('AU-OKB', 'AU-OKB (Orchid Beach, Queensland, Australia)'),
    ('AU-ODR', 'AU-ODR (Ord River, Western Australia, Australia)'),
    ('AU-OXO', 'AU-OXO (Orientos, Queensland, Australia)'),
    ('AU-ORM', 'AU-ORM (Ormeau, Queensland, Australia)'),
    ('AU-DUK', 'AU-DUK (Ormiston, Queensland, Australia)'),
    ('AU-ORS', 'AU-ORS (Orpheus Island Resort, Queensland, Australia)'),
    ('AU-OSE', 'AU-OSE (Osborne, New South Wales, Australia)'),
    ('AU-OSB', 'AU-OSB (Osborne Island, Western Australia, Australia)'),
    ('AU-OSP', 'AU-OSP (Osborne Park, Western Australia, Australia)'),
    ('AU-OTT', 'AU-OTT (Ottaway, South Australia, Australia)'),
    ('AU-OTO', 'AU-OTO (Ottoway, South Australia, Australia)'),
    ('AU-USS', 'AU-USS (Ouse, Tasmania, Australia)'),
    ('AU-OUH', 'AU-OUH (Ouse, Tasmania, Australia)'),
    ('AU-OHB', 'AU-OHB (Outer Harbour, South Australia, Australia)'),
    ('AU-OYN', 'AU-OYN (Ouyen, Victoria, Australia)'),
    ('AU-LEY', 'AU-LEY (Oxley, Queensland, Australia)'),
    ('AU-VEY', 'AU-VEY (Oxley, Victoria, Australia)'),
    ('AU-T3X', 'AU-T3X (Oyster Bay, New South Wales, Australia)'),
    ('AU-PPC', 'AU-PPC (Pacific Pines, Queensland, Australia)'),
    ('AU-URY', 'AU-URY (Padbury, Western Australia, Australia)'),
    ('AU-PAG', 'AU-PAG (Paddington, New South Wales, Australia)'),
    ('AU-DSW', 'AU-DSW (Padstow, New South Wales, Australia)'),
    ('AU-PY4', 'AU-PY4 (Padthaway, South Australia, Australia)'),
    ('AU-PGT', 'AU-PGT (Paget, Queensland, Australia)'),
    ('AU-PKM', 'AU-PKM (Pakenham, Victoria, Australia)'),
    ('AU-S4Y', 'AU-S4Y (Pakenham South, Victoria, Australia)'),
    ('AU-P5U', 'AU-P5U (Pakenham Upper, Victoria, Australia)'),
    ('AU-PBH', 'AU-PBH (Palm Beach, Queensland, Australia)'),
    ('AU-T3K', 'AU-T3K (Palm Beach, New South Wales, Australia)'),
    ('AU-PMK', 'AU-PMK (Palm Island, Queensland, Australia)'),
    ('AU-PAL', 'AU-PAL (Palm Island, Queensland, Australia)'),
    ('AU-PAW', 'AU-PAW (Palmwoods, Queensland, Australia)'),
    ('AU-PBU', 'AU-PBU (Pambula, New South Wales, Australia)'),
    ('AU-PDE', 'AU-PDE (Pandie Pandie, South Australia, Australia)'),
    ('AU-ILL', 'AU-ILL (Panton Hill, Victoria, Australia)'),
    ('AU-PBO', 'AU-PBO (Paraburdoo, Western Australia, Australia)'),
    ('AU-MBE', 'AU-MBE (Paracombe, South Australia, Australia)'),
    ('AU-PDL', 'AU-PDL (Parafield, South Australia, Australia)'),
    ('AU-PLW', 'AU-PLW (Paralowie, South Australia, Australia)'),
    ('AU-PRD', 'AU-PRD (Pardoo, Western Australia, Australia)'),
    ('AU-PRG', 'AU-PRG (Paringa, South Australia, Australia)'),
    ('AU-VPK', 'AU-VPK (Parkdale, Victoria, Australia)'),
    ('AU-PKE', 'AU-PKE (Parkes, New South Wales, Australia)'),
    ('AU-PRS', 'AU-PRS (Parkinson, Queensland, Australia)'),
    ('AU-PKV', 'AU-PKV (Parkville, Victoria, Australia)'),
    ('AU-PDN', 'AU-PDN (Parndana, South Australia, Australia)'),
    ('AU-PRM', 'AU-PRM (Parramatta, New South Wales, Australia)'),
    ('AU-PWA', 'AU-PWA (Parwan, Victoria, Australia)'),
    ('AU-PSV', 'AU-PSV (Pascoe Vale, Victoria, Australia)'),
    ('AU-P8S', 'AU-P8S (Paterson, New South Wales, Australia)'),
    ('AU-PHI', 'AU-PHI (Peak Hill, New South Wales, Australia)'),
    ('AU-PKH', 'AU-PKH (Peakhurst, New South Wales, Australia)'),
    ('AU-PCE', 'AU-PCE (Pearce, Western Australia, Australia)'),
    ('AU-N6D', 'AU-N6D (Peats Ridge, New South Wales, Australia)'),
    ('AU-PEL', 'AU-PEL (Pelican Point, South Australia, Australia)'),
    ('AU-PBE', 'AU-PBE (Pemberton, Western Australia, Australia)'),
    ('AU-PWY', 'AU-PWY (Pemulwuy, New South Wales, Australia)'),
    ('AU-PEN', 'AU-PEN (Pendle Hills, New South Wales, Australia)'),
    ('AU-PNF', 'AU-PNF (Penfield, South Australia, Australia)'),
    ('AU-PEG', 'AU-PEG (Penguin, Tasmania, Australia)'),
    ('AU-PNH', 'AU-PNH (Pennant Hills, New South Wales, Australia)'),
    ('AU-PEA', 'AU-PEA (Penneshaw, South Australia, Australia)'),
    ('AU-PNL', 'AU-PNL (Penola, South Australia, Australia)'),
    ('AU-PEY', 'AU-PEY (Penong, South Australia, Australia)'),
    ('AU-PRH', 'AU-PRH (Penrith, New South Wales, Australia)'),
    ('AU-T3G', 'AU-T3G (Penshurst, New South Wales, Australia)'),
    ('AU-PWT', 'AU-PWT (Penwortham, South Australia, Australia)'),
    ('AU-PMG', 'AU-PMG (Peppermint Grove, Western Australia, Australia)'),
    ('AU-PEP', 'AU-PEP (Peppermint Grove, Western Australia, Australia)'),
    ('AU-EUK', 'AU-EUK (Perth, Tasmania, Australia)'),
    ('AU-PER', 'AU-PER (Perth, Western Australia, Australia)'),
    ('AU-PTR', 'AU-PTR (Petersham, New South Wales, Australia)'),
    ('AU-PET', 'AU-PET (Petrie, Queensland, Australia)'),
    ('AU-PCR', 'AU-PCR (Pheasant Creek, Victoria, Australia)'),
    ('AU-PIS', 'AU-PIS (Phillip Island, Victoria, Australia)'),
    ('AU-PIA', 'AU-PIA (Pialba, Queensland, Australia)'),
    ('AU-PNG', 'AU-PNG (Piangil, Victoria, Australia)'),
    ('AU-PI8', 'AU-PI8 (Piccadilly, South Australia, Australia)'),
    ('AU-PCN', 'AU-PCN (Picton, Western Australia, Australia)'),
    ('AU-PIC', 'AU-PIC (Picton, New South Wales, Australia)'),
    ('AU-5WA', 'AU-5WA (Pilbara, Western Australia, Australia)'),
    ('AU-PIM', 'AU-PIM (Pimpama, Queensland, Australia)'),
    ('AU-PDA', 'AU-PDA (Pindar, Western Australia, Australia)'),
    ('AU-PGY', 'AU-PGY (Pingelly, Western Australia, Australia)'),
    ('AU-PJA', 'AU-PJA (Pinjarra, Western Australia, Australia)'),
    ('AU-PNA', 'AU-PNA (Pinkenba, Queensland, Australia)'),
    ('AU-PBR', 'AU-PBR (Pipers Brook, Tasmania, Australia)'),
    ('AU-PEE', 'AU-PEE (Pipers Creek, Victoria, Australia)'),
    ('AU-PTO', 'AU-PTO (Pittong, Victoria, Australia)'),
    ('AU-PYT', 'AU-PYT (Pleystowe, Queensland, Australia)'),
    ('AU-PLY', 'AU-PLY (Plympton, South Australia, Australia)'),
    ('AU-PCK', 'AU-PCK (Point Cook, Victoria, Australia)'),
    ('AU-PHP', 'AU-PHP (Point Henry Pier/Melbourne, Victoria, Australia)'),
    ('AU-P8N', 'AU-P8N (Point Piper, New South Wales, Australia)'),
    ('AU-PSM', 'AU-PSM (Point Samson, Western Australia, Australia)'),
    ('AU-PWI', 'AU-PWI (Point Wilson, Victoria, Australia)'),
    ('AU-PU7', 'AU-PU7 (Pokolbin, New South Wales, Australia)'),
    ('AU-PRK', 'AU-PRK (Pooraka, South Australia, Australia)'),
    ('AU-PR8', 'AU-PR8 (Porongurup, Western Australia, Australia)'),
    ('AU-PAE', 'AU-PAE (Port Adelaide, South Australia, Australia)'),
    ('AU-PTL', 'AU-PTL (Port Alma, Queensland, Australia)'),
    ('AU-PAU', 'AU-PAU (Port Arthur, Tasmania, Australia)'),
    ('AU-PUG', 'AU-PUG (Port Augusta, South Australia, Australia)'),
    ('AU-PBY', 'AU-PBY (Port Bonython, South Australia, Australia)'),
    ('AU-PBT', 'AU-PBT (Port Botany, New South Wales, Australia)'),
    ('AU-PCT', 'AU-PCT (Port Curtis, Queensland, Australia)'),
    ('AU-PTD', 'AU-PTD (Port Dalrymple, Queensland, Australia)'),
    ('AU-PDI', 'AU-PDI (Port Denison, Western Australia, Australia)'),
    ('AU-PTI', 'AU-PTI (Port Douglas, Queensland, Australia)'),
    ('AU-FRY', 'AU-FRY (Port Fairy, Victoria, Australia)'),
    ('AU-PGW', 'AU-PGW (Port Gawler, South Australia, Australia)'),
    ('AU-PGI', 'AU-PGI (Port Giles, South Australia, Australia)'),
    ('AU-T3P', 'AU-T3P (Port Hacking, New South Wales, Australia)'),
    ('AU-PHE', 'AU-PHE (Port Hedland, Western Australia, Australia)'),
    ('AU-PHJ', 'AU-PHJ (Port Hunter, New South Wales, Australia)'),
    ('AU-PHU', 'AU-PHU (Port Huon, Tasmania, Australia)'),
    ('AU-PJK', 'AU-PJK (Port Jackson, New South Wales, Australia)'),
    ('AU-PKT', 'AU-PKT (Port Jackson, New South Wales, Australia)'),
    ('AU-PKL', 'AU-PKL (Port Kembla, New South Wales, Australia)'),
    ('AU-PKN', 'AU-PKN (Port Kennedy, Queensland, Australia)'),
    ('AU-PKY', 'AU-PKY (Port Kenny, South Australia, Australia)'),
    ('AU-PLA', 'AU-PLA (Port Latta, Tasmania, Australia)'),
    ('AU-PLO', 'AU-PLO (Port Lincoln, South Australia, Australia)'),
    ('AU-PQQ', 'AU-PQQ (Port Macquarie, New South Wales, Australia)'),
    ('AU-POR', 'AU-POR (Port Melbourne, Victoria, Australia)'),
    ('AU-PTN', 'AU-PTN (Port Norlunga, South Australia, Australia)'),
    ('AU-PBN', 'AU-PBN (Port of Brisbane, Queensland, Australia)'),
    ('AU-PPI', 'AU-PPI (Port Pirie, South Australia, Australia)'),
    ('AU-OTR', 'AU-OTR (Port Sorell, Tasmania, Australia)'),
    ('AU-PSY', 'AU-PSY (Port Stanley, Tasmania, Australia)'),
    ('AU-PST', 'AU-PST (Port Stanvac, South Australia, Australia)'),
    ('AU-PTE', 'AU-PTE (Port Stephens, New South Wales, Australia)'),
    ('AU-PRW', 'AU-PRW (Port Wakefied, South Australia, Australia)'),
    ('AU-PWL', 'AU-PWL (Port Walcott, Western Australia, Australia)'),
    ('AU-PWR', 'AU-PWR (Port Warrender, Western Australia, Australia)'),
    ('AU-PTW', 'AU-PTW (Port Willunga, South Australia, Australia)'),
    ('AU-PAD', 'AU-PAD (Portland, New South Wales, Australia)'),
    ('AU-PTJ', 'AU-PTJ (Portland, Victoria, Australia)'),
    ('AU-POZ', 'AU-POZ (Pozieres, Queensland, Australia)'),
    ('AU-PHR', 'AU-PHR (Prahran, Victoria, Australia)'),
    ('AU-PRL', 'AU-PRL (Prelude, Western Australia, Australia)'),
    ('AU-PSO', 'AU-PSO (Preston, Victoria, Australia)'),
    ('AU-PRE', 'AU-PRE (Prestons, New South Wales, Australia)'),
    ('AU-PRC', 'AU-PRC (Price, South Australia, Australia)'),
    ('AU-PCH', 'AU-PCH (Princes Hill, Victoria, Australia)'),
    ('AU-PRB', 'AU-PRB (Proper Bay, South Australia, Australia)'),
    ('AU-PPP', 'AU-PPP (Proserpine, Queensland, Australia)'),
    ('AU-PPT', 'AU-PPT (Prospect, New South Wales, Australia)'),
    ('AU-PRO', 'AU-PRO (Prospect, South Australia, Australia)'),
    ('AU-PVL', 'AU-PVL (Pullen Vale, Queensland, Australia)'),
    ('AU-PUN', 'AU-PUN (Punchbowl, New South Wales, Australia)'),
    ('AU-PME', 'AU-PME (Pymble, New South Wales, Australia)'),
    ('AU-PYE', 'AU-PYE (Pyrenees, Victoria, Australia)'),
    ('AU-PYR', 'AU-PYR (Pyrmont, New South Wales, Australia)'),
    ('AU-QDI', 'AU-QDI (Quairading, Western Australia, Australia)'),
    ('AU-T3Y', 'AU-T3Y (Quakers Hill, New South Wales, Australia)'),
    ('AU-QLC', 'AU-QLC (Qualco, South Australia, Australia)'),
    ('AU-QBY', 'AU-QBY (Queanbeyan, New South Wales, Australia)'),
    ('AU-UEE', 'AU-UEE (Queenstown, Tasmania, Australia)'),
    ('AU-ULP', 'AU-ULP (Quilpie, Queensland, Australia)'),
    ('AU-QUI', 'AU-QUI (Quindalup, Western Australia, Australia)'),
    ('AU-UIR', 'AU-UIR (Quirindi, New South Wales, Australia)'),
    ('AU-QUA', 'AU-QUA (Quoiba, Tasmania, Australia)'),
    ('AU-DCN', 'AU-DCN (RAAF Curtin, Western Australia, Australia)'),
    ('AU-RAF', 'AU-RAF (RAAF Curtin, Western Australia, Australia)'),
    ('AU-RAM', 'AU-RAM (RAAF Curtin, Western Australia, Australia)'),
    ('AU-RNW', 'AU-RNW (Randwick, New South Wales, Australia)'),
    ('AU-FUK', 'AU-FUK (Ranelagh, Tasmania, Australia)'),
    ('AU-RAB', 'AU-RAB (Rapid Bay, South Australia, Australia)'),
    ('AU-RV7', 'AU-RV7 (Ravensbourne, Queensland, Australia)'),
    ('AU-RAV', 'AU-RAV (Ravensthorpe, Western Australia, Australia)'),
    ('AU-RAE', 'AU-RAE (Ravenswood, Western Australia, Australia)'),
    ('AU-RAY', 'AU-RAY (Raymond Terrace, New South Wales, Australia)'),
    ('AU-RFF', 'AU-RFF (Red Cliffs, Victoria, Australia)'),
    ('AU-RH8', 'AU-RH8 (Red Hill, Victoria, Australia)'),
    ('AU-RHI', 'AU-RHI (Red Hill, Queensland, Australia)'),
    ('AU-HY5', 'AU-HY5 (Red Hill South, Victoria, Australia)'),
    ('AU-RBK', 'AU-RBK (Redbank, Victoria, Australia)'),
    ('AU-RDB', 'AU-RDB (Redbank, Queensland, Australia)'),
    ('AU-RCE', 'AU-RCE (Redcliffe, Western Australia, Australia)'),
    ('AU-RCF', 'AU-RCF (Redcliffe, Queensland, Australia)'),
    ('AU-RDL', 'AU-RDL (Redesdale, Victoria, Australia)'),
    ('AU-RED', 'AU-RED (Redfern, New South Wales, Australia)'),
    ('AU-RDH', 'AU-RDH (Redhead, New South Wales, Australia)'),
    ('AU-QDB', 'AU-QDB (Redland Bay, Queensland, Australia)'),
    ('AU-RYC', 'AU-RYC (Reedy Creek, Queensland, Australia)'),
    ('AU-RYK', 'AU-RYK (Regency Park, South Australia, Australia)'),
    ('AU-RGP', 'AU-RGP (Regents Park, New South Wales, Australia)'),
    ('AU-REL', 'AU-REL (Relbia, Tasmania, Australia)'),
    ('AU-RMK', 'AU-RMK (Renmark, South Australia, Australia)'),
    ('AU-S4G', 'AU-S4G (Research, Victoria, Australia)'),
    ('AU-RES', 'AU-RES (Reservoir, Victoria, Australia)'),
    ('AU-REV', 'AU-REV (Revesby, New South Wales, Australia)'),
    ('AU-RLL', 'AU-RLL (Reynella, South Australia, Australia)'),
    ('AU-RDS', 'AU-RDS (Rhodes, New South Wales, Australia)'),
    ('AU-RHA', 'AU-RHA (Richlands, Queensland, Australia)'),
    ('AU-RCH', 'AU-RCH (Richmond, New South Wales, Australia)'),
    ('AU-RCM', 'AU-RCM (Richmond, Queensland, Australia)'),
    ('AU-RHM', 'AU-RHM (Richmond, Victoria, Australia)'),
    ('AU-RIC', 'AU-RIC (Richmond, South Australia, Australia)'),
    ('AU-RMD', 'AU-RMD (Richmond, Tasmania, Australia)'),
    ('AU-RCL', 'AU-RCL (Richmond Hill, Queensland, Australia)'),
    ('AU-RMV', 'AU-RMV (Richmond Vale, New South Wales, Australia)'),
    ('AU-RD2', 'AU-RD2 (Riddells Creek, Victoria, Australia)'),
    ('AU-RID', 'AU-RID (Ridgehaven, South Australia, Australia)'),
    ('AU-RWD', 'AU-RWD (Ringwood, Victoria, Australia)'),
    ('AU-S4H', 'AU-S4H (Ringwood East, Victoria, Australia)'),
    ('AU-S4J', 'AU-S4J (Ringwood North, Victoria, Australia)'),
    ('AU-B5P', 'AU-B5P (Ripplebrook, Victoria, Australia)'),
    ('AU-RDN', 'AU-RDN (Risdon, Tasmania, Australia)'),
    ('AU-RVV', 'AU-RVV (Riverina, Western Australia, Australia)'),
    ('AU-RVS', 'AU-RVS (Riverstone, New South Wales, Australia)'),
    ('AU-RIV', 'AU-RIV (Riverton, South Australia, Australia)'),
    ('AU-OOD', 'AU-OOD (Riverwood, New South Wales, Australia)'),
    ('AU-ROB', 'AU-ROB (Robe, South Australia, Australia)'),
    ('AU-RTO', 'AU-RTO (Robertson, New South Wales, Australia)'),
    ('AU-ROH', 'AU-ROH (Robinhood, Queensland, Australia)'),
    ('AU-RRV', 'AU-RRV (Robinhood, Queensland, Australia)'),
    ('AU-RBC', 'AU-RBC (Robinvale, Victoria, Australia)'),
    ('AU-RCT', 'AU-RCT (Rochester, Victoria, Australia)'),
    ('AU-RKK', 'AU-RKK (Rockbank, Victoria, Australia)'),
    ('AU-ROD', 'AU-ROD (Rockdale, New South Wales, Australia)'),
    ('AU-ROK', 'AU-ROK (Rockhampton, Queensland, Australia)'),
    ('AU-RDA', 'AU-RDA (Rockhampton, Queensland, Australia)'),
    ('AU-ROM', 'AU-ROM (Rockingham, Western Australia, Australia)'),
    ('AU-RZC', 'AU-RZC (Rocklea, Queensland, Australia)'),
    ('AU-RGY', 'AU-RGY (Rocky Gully, Western Australia, Australia)'),
    ('AU-RYP', 'AU-RYP (Rocky Point, Western Australia, Australia)'),
    ('AU-RDP', 'AU-RDP (Rodd Point, New South Wales, Australia)'),
    ('AU-RBU', 'AU-RBU (Roebourne, Western Australia, Australia)'),
    ('AU-RKB', 'AU-RKB (Rokeby, Tasmania, Australia)'),
    ('AU-RKY', 'AU-RKY (Rokeby, Queensland, Australia)'),
    ('AU-RLT', 'AU-RLT (Roleystone, Western Australia, Australia)'),
    ('AU-RMA', 'AU-RMA (Roma, Queensland, Australia)'),
    ('AU-RMS', 'AU-RMS (Romsey, Victoria, Australia)'),
    ('AU-RKW', 'AU-RKW (Rookwood, New South Wales, Australia)'),
    ('AU-ORY', 'AU-ORY (Rooty Hill, New South Wales, Australia)'),
    ('AU-RPB', 'AU-RPB (Rooty Hill, New South Wales, Australia)'),
    ('AU-RPV', 'AU-RPV (Rooty Hill, New South Wales, Australia)'),
    ('AU-RON', 'AU-RON (Rosanna, Victoria, Australia)'),
    ('AU-REY', 'AU-REY (Rose Bay, New South Wales, Australia)'),
    ('AU-ROS', 'AU-ROS (Rose Hill, New South Wales, Australia)'),
    ('AU-PAK', 'AU-PAK (Rose Park, South Australia, Australia)'),
    ('AU-RSB', 'AU-RSB (Roseberth, Queensland, Australia)'),
    ('AU-RBY', 'AU-RBY (Rosebery/Sydney, New South Wales, Australia)'),
    ('AU-ROW', 'AU-ROW (Rosebud West, Victoria, Australia)'),
    ('AU-R4S', 'AU-R4S (Rosehill, New South Wales, Australia)'),
    ('AU-SNS', 'AU-SNS (Roselands, New South Wales, Australia)'),
    ('AU-RLP', 'AU-RLP (Rosella Plains, Queensland, Australia)'),
    ('AU-RVE', 'AU-RVE (Roseville, New South Wales, Australia)'),
    ('AU-RNB', 'AU-RNB (Rosslyn Bay, Queensland, Australia)'),
    ('AU-ROT', 'AU-ROT (Rothbury, New South Wales, Australia)'),
    ('AU-RTS', 'AU-RTS (Rottnest Island, Western Australia, Australia)'),
    ('AU-RZL', 'AU-RZL (Rouse Hill, New South Wales, Australia)'),
    ('AU-RWL', 'AU-RWL (Rowella, Tasmania, Australia)'),
    ('AU-RFL', 'AU-RFL (Rowland Flat, South Australia, Australia)'),
    ('AU-RWE', 'AU-RWE (Rowville, Victoria, Australia)'),
    ('AU-RHL', 'AU-RHL (Roy Hill, Western Australia, Australia)'),
    ('AU-RPA', 'AU-RPA (Royal Park, South Australia, Australia)'),
    ('AU-ROZ', 'AU-ROZ (Rozelle, New South Wales, Australia)'),
    ('AU-RFD', 'AU-RFD (Rutherford, New South Wales, Australia)'),
    ('AU-RTG', 'AU-RTG (Rutherglen, Victoria, Australia)'),
    ('AU-RTP', 'AU-RTP (Rutland Plains, Queensland, Australia)'),
    ('AU-RYM', 'AU-RYM (Rydalmere, New South Wales, Australia)'),
    ('AU-RYE', 'AU-RYE (Ryde, New South Wales, Australia)'),
    ('AU-3CI', 'AU-3CI (Rythdale, Victoria, Australia)'),
    ('AU-C6K', 'AU-C6K (Sackville, New South Wales, Australia)'),
    ('AU-SAW', 'AU-SAW (Saddleworth, South Australia, Australia)'),
    ('AU-SBR', 'AU-SBR (Saibai Island, Queensland, Australia)'),
    ('AU-SGO', 'AU-SGO (Saint George, Queensland, Australia)'),
    ('AU-HLS', 'AU-HLS (Saint Helens, Tasmania, Australia)'),
    ('AU-SLS', 'AU-SLS (Saint Leonards, Tasmania, Australia)'),
    ('AU-STL', 'AU-STL (Saint Leonards, New South Wales, Australia)'),
    ('AU-STM', 'AU-STM (Saint Marys, New South Wales, Australia)'),
    ('AU-SVM', "AU-SVM (Saint Paul's Mission, Queensland, Australia)"),
    ('AU-STP', 'AU-STP (Saint Peters, New South Wales, Australia)'),
    ('AU-SMT', 'AU-SMT (Saladin Marine Terminal, Western Australia, Australia)'),
    ('AU-SXE', 'AU-SXE (Sale, Victoria, Australia)'),
    ('AU-SAL', 'AU-SAL (Salisbury, South Australia, Australia)'),
    ('AU-SPL', 'AU-SPL (Salisbury Plain, South Australia, Australia)'),
    ('AU-SBY', 'AU-SBY (Salisbury/Brisbane, Queensland, Australia)'),
    ('AU-WAS', 'AU-WAS (Salmon Gums, Western Australia, Australia)'),
    ('AU-SGT', 'AU-SGT (Sandgate, New South Wales, Australia)'),
    ('AU-SRM', 'AU-SRM (Sandringham, Queensland, Australia)'),
    ('AU-NDS', 'AU-NDS (Sandstone, Western Australia, Australia)'),
    ('AU-S8N', 'AU-S8N (Sans Souci, New South Wales, Australia)'),
    ('AU-SSF', 'AU-SSF (Sassafras, Victoria, Australia)'),
    ('AU-SWL', 'AU-SWL (Sawtell, New South Wales, Australia)'),
    ('AU-SCB', 'AU-SCB (Scarborough, Western Australia, Australia)'),
    ('AU-H8S', 'AU-H8S (Schofields, New South Wales, Australia)'),
    ('AU-NSO', 'AU-NSO (Scone, New South Wales, Australia)'),
    ('AU-SCY', 'AU-SCY (Scoresby, Victoria, Australia)'),
    ('AU-SCO', 'AU-SCO (Scottsdale, Tasmania, Australia)'),
    ('AU-CLI', 'AU-CLI (Seacliff, South Australia, Australia)'),
    ('AU-32S', 'AU-32S (Seaford, South Australia, Australia)'),
    ('AU-FOR', 'AU-FOR (Seaford, Victoria, Australia)'),
    ('AU-FTH', 'AU-FTH (Seaforth, New South Wales, Australia)'),
    ('AU-ILM', 'AU-ILM (Seaholme, Victoria, Australia)'),
    ('AU-SET', 'AU-SET (Seaton, South Australia, Australia)'),
    ('AU-SSD', 'AU-SSD (Seddon, Victoria, Australia)'),
    ('AU-NS9', 'AU-NS9 (Sefton, New South Wales, Australia)'),
    ('AU-5CI', 'AU-5CI (Selby, Victoria, Australia)'),
    ('AU-SBH', 'AU-SBH (Sellick Beach, South Australia, Australia)'),
    ('AU-SSH', 'AU-SSH (Sellicks Hill, South Australia, Australia)'),
    ('AU-SFD', 'AU-SFD (Seppeltsfield, South Australia, Australia)'),
    ('AU-SVH', 'AU-SVH (Seven Hills, New South Wales, Australia)'),
    ('AU-SVL', 'AU-SVL (Sevenhill, South Australia, Australia)'),
    ('AU-SMR', 'AU-SMR (Seventeen Mile Rocks/Brisbane, Queensland, Australia)'),
    ('AU-SVI', 'AU-SVI (Seville, Victoria, Australia)'),
    ('AU-SEY', 'AU-SEY (Seymour, Victoria, Australia)'),
    ('AU-SHB', 'AU-SHB (Shark Bay, Western Australia, Australia)'),
    ('AU-SWB', 'AU-SWB (Shaw River, Western Australia, Australia)'),
    ('AU-SGP', 'AU-SGP (Shay Gap, Western Australia, Australia)'),
    ('AU-SOL', 'AU-SOL (Shea Oak Log, South Australia, Australia)'),
    ('AU-SSY', 'AU-SSY (Shelley, Western Australia, Australia)'),
    ('AU-SHH', 'AU-SHH (Shellharbour, New South Wales, Australia)'),
    ('AU-SHT', 'AU-SHT (Shepparton, Victoria, Australia)'),
    ('AU-SRH', 'AU-SRH (Shoreham, Victoria, Australia)'),
    ('AU-JHQ', 'AU-JHQ (Shute Harbour, Queensland, Australia)'),
    ('AU-SSP', 'AU-SSP (Silver Plains, Queensland, Australia)'),
    ('AU-SVD', 'AU-SVD (Silverdale, New South Wales, Australia)'),
    ('AU-SIL', 'AU-SIL (Silverwater, New South Wales, Australia)'),
    ('AU-SIX', 'AU-SIX (Singleton, New South Wales, Australia)'),
    ('AU-SCK', 'AU-SCK (Sisters Creek, Tasmania, Australia)'),
    ('AU-SKA', 'AU-SKA (Skardon River, Queensland, Australia)'),
    ('AU-SKV', 'AU-SKV (Skardon River, Queensland, Australia)'),
    ('AU-SKY', 'AU-SKY (Skye, South Australia, Australia)'),
    ('AU-SMG', 'AU-SMG (Smeaton Grange, New South Wales, Australia)'),
    ('AU-SHU', 'AU-SHU (Smeaton Grange, New South Wales, Australia)'),
    ('AU-SMD', 'AU-SMD (Smithfield, New South Wales, Australia)'),
    ('AU-SGY', 'AU-SGY (Smiths Gully, Victoria, Australia)'),
    ('AU-SIO', 'AU-SIO (Smithton, Tasmania, Australia)'),
    ('AU-SNB', 'AU-SNB (Smithton, Tasmania, Australia)'),
    ('AU-WSS', 'AU-WSS (Snowtown, South Australia, Australia)'),
    ('AU-SMY', 'AU-SMY (Somersby, New South Wales, Australia)'),
    ('AU-SST', 'AU-SST (Somerset, Tasmania, Australia)'),
    ('AU-SOM', 'AU-SOM (Somerton, Victoria, Australia)'),
    ('AU-SPS', 'AU-SPS (Somerton Park, South Australia, Australia)'),
    ('AU-SMV', 'AU-SMV (Somerville, Victoria, Australia)'),
    ('AU-SAR', 'AU-SAR (Sorrento, Victoria, Australia)'),
    ('AU-SBN', 'AU-SBN (South Brisbane, Queensland, Australia)'),
    ('AU-SFE', 'AU-SFE (South Fremantle, Western Australia, Australia)'),
    ('AU-ZGL', 'AU-ZGL (South Galway, Queensland, Australia)'),
    ('AU-SGD', 'AU-SGD (South Guilford, Western Australia, Australia)'),
    ('AU-SLN', 'AU-SLN (South Launceston, Tasmania, Australia)'),
    ('AU-SMN', 'AU-SMN (South Maclean, Queensland, Australia)'),
    ('AU-SLM', 'AU-SLM (South Melbourne, Victoria, Australia)'),
    ('AU-SOI', 'AU-SOI (South Molle Island, Queensland, Australia)'),
    ('AU-SPH', 'AU-SPH (South Perth, Western Australia, Australia)'),
    ('AU-STR', 'AU-STR (South Trees, Queensland, Australia)'),
    ('AU-SWR', 'AU-SWR (South West Rocks, New South Wales, Australia)'),
    ('AU-SWO', 'AU-SWO (South Windsor, New South Wales, Australia)'),
    ('AU-SYA', 'AU-SYA (South Yarra, Victoria, Australia)'),
    ('AU-SBK', 'AU-SBK (Southbank, Victoria, Australia)'),
    ('AU-SQC', 'AU-SQC (Southern Cross, Western Australia, Australia)'),
    ('AU-SHQ', 'AU-SHQ (Southport, Queensland, Australia)'),
    ('AU-SWK', 'AU-SWK (Southwest Rocks, New South Wales, Australia)'),
    ('AU-SPE', 'AU-SPE (Spearwood, Western Australia, Australia)'),
    ('AU-SPW', 'AU-SPW (Spotswood, Victoria, Australia)'),
    ('AU-SPO', 'AU-SPO (Spreyton, Tasmania, Australia)'),
    ('AU-SPB', 'AU-SPB (Spring Bay, Tasmania, Australia)'),
    ('AU-SCG', 'AU-SCG (Spring Creek, Queensland, Australia)'),
    ('AU-SHI', 'AU-SHI (Spring Hill, New South Wales, Australia)'),
    ('AU-SSM', 'AU-SSM (Springmount, Victoria, Australia)'),
    ('AU-SPG', 'AU-SPG (Springton, South Australia, Australia)'),
    ('AU-KSV', 'AU-KSV (Springvale, Queensland, Australia)'),
    ('AU-SGV', 'AU-SGV (Springvale, Victoria, Australia)'),
    ('AU-ZVG', 'AU-ZVG (Springvale, Western Australia, Australia)'),
    ('AU-2VC', 'AU-2VC (Springvale South, Victoria, Australia)'),
    ('AU-NSW', 'AU-NSW (Springwood, New South Wales, Australia)'),
    ('AU-SWD', 'AU-SWD (Springwood, Queensland, Australia)'),
    ('AU-IVE', 'AU-IVE (St Ives, New South Wales, Australia)'),
    ('AU-SFF', 'AU-SFF (Stafford, Queensland, Australia)'),
    ('AU-STG', 'AU-STG (Stag Platform, Western Australia, Australia)'),
    ('AU-THP', 'AU-THP (Stanhope, Victoria, Australia)'),
    ('AU-SHG', 'AU-SHG (Stanhope Gardens, New South Wales, Australia)'),
    ('AU-STA', 'AU-STA (Stanley, Tasmania, Australia)'),
    ('AU-TNM', 'AU-TNM (Stanmore, New South Wales, Australia)'),
    ('AU-SNH', 'AU-SNH (Stanthorpe, Queensland, Australia)'),
    ('AU-T9W', 'AU-T9W (Stanwell Park, New South Wales, Australia)'),
    ('AU-SPY', 'AU-SPY (Stapylton, Queensland, Australia)'),
    ('AU-SQP', 'AU-SQP (Starcke, Queensland, Australia)'),
    ('AU-SWC', 'AU-SWC (Stawell, Victoria, Australia)'),
    ('AU-SLK', 'AU-SLK (Steels Creek, Victoria, Australia)'),
    ('AU-STF', 'AU-STF (Stephen Island, Queensland, Australia)'),
    ('AU-SNY', 'AU-SNY (Stepney, South Australia, Australia)'),
    ('AU-LNG', 'AU-LNG (Stirling, South Australia, Australia)'),
    ('AU-SBI', 'AU-SBI (Stockinbingal, New South Wales, Australia)'),
    ('AU-KWL', 'AU-KWL (Stockwell, South Australia, Australia)'),
    ('AU-SRR', 'AU-SRR (Stradbroke Island, Queensland, Australia)'),
    ('AU-SRN', 'AU-SRN (Strahan, Tasmania, Australia)'),
    ('AU-ST9', 'AU-ST9 (Strathalbyn, South Australia, Australia)'),
    ('AU-THB', 'AU-THB (Strathbogie, Victoria, Australia)'),
    ('AU-4VC', 'AU-4VC (Strathewen, Victoria, Australia)'),
    ('AU-SFI', 'AU-SFI (Strathfield, New South Wales, Australia)'),
    ('AU-TFA', 'AU-TFA (Strathfieldsaye, Victoria, Australia)'),
    ('AU-IMR', 'AU-IMR (Strathmore, Victoria, Australia)'),
    ('AU-STH', 'AU-STH (Strathmore, Queensland, Australia)'),
    ('AU-KBY', 'AU-KBY (Streaky Bay, South Australia, Australia)'),
    ('AU-STS', 'AU-STS (Stretton, Queensland, Australia)'),
    ('AU-STT', 'AU-STT (Stuart, Queensland, Australia)'),
    ('AU-SSK', 'AU-SSK (Sturt Creek, Western Australia, Australia)'),
    ('AU-STY', 'AU-STY (Stybarrow Venture MV17, Western Australia, Australia)'),
    ('AU-SBC', 'AU-SBC (Subiaco, Western Australia, Australia)'),
    ('AU-SCS', 'AU-SCS (Success, Western Australia, Australia)'),
    ('AU-SYU', 'AU-SYU (Sue Island, Queensland, Australia)'),
    ('AU-SUM', 'AU-SUM (Summertown, South Australia, Australia)'),
    ('AU-SNP', 'AU-SNP (Sumner Park, Queensland, Australia)'),
    ('AU-VSB', 'AU-VSB (Sunbury, Victoria, Australia)'),
    ('AU-UKY', 'AU-UKY (Sunnybank, Queensland, Australia)'),
    ('AU-6VC', 'AU-6VC (Sunshine, Victoria, Australia)'),
    ('AU-SSE', 'AU-SSE (Sunshine/Melbourne, Victoria, Australia)'),
    ('AU-SFP', 'AU-SFP (Surfers Paradise, Queensland, Australia)'),
    ('AU-SHS', 'AU-SHS (Surrey Hills, Victoria, Australia)'),
    ('AU-SUH', 'AU-SUH (Surry Hills, New South Wales, Australia)'),
    ('AU-TLD', 'AU-TLD (Sutherland, New South Wales, Australia)'),
    ('AU-SUK', 'AU-SUK (Sutherlands Creek, Victoria, Australia)'),
    ('AU-SUF', 'AU-SUF (Sutton Forest, New South Wales, Australia)'),
    ('AU-SWN', 'AU-SWN (Swan, Western Australia, Australia)'),
    ('AU-SB2', 'AU-SB2 (Swan Bay, Tasmania, Australia)'),
    ('AU-SWH', 'AU-SWH (Swan Hill, Victoria, Australia)'),
    ('AU-SWA', 'AU-SWA (Swan Hill, Victoria, Australia)'),
    ('AU-SEA', 'AU-SEA (Swansea, Tasmania, Australia)'),
    ('AU-8VC', 'AU-8VC (Sydenham, Victoria, Australia)'),
    ('AU-SDH', 'AU-SDH (Sydenham, New South Wales, Australia)'),
    ('AU-SYD', 'AU-SYD (Sydney, New South Wales, Australia)'),
    ('AU-SOP', 'AU-SOP (Sydney Olympic Park, New South Wales, Australia)'),
    ('AU-SYL', 'AU-SYL (Sylvania, New South Wales, Australia)'),
    ('AU-SWS', 'AU-SWS (Sylvania Waters, New South Wales, Australia)'),
    ('AU-TBL', 'AU-TBL (Tableland, Western Australia, Australia)'),
    ('AU-TLT', 'AU-TLT (Talbot, Victoria, Australia)'),
    ('AU-TAM', 'AU-TAM (Tambourine, Queensland, Australia)'),
    ('AU-TMN', 'AU-TMN (Taminda, New South Wales, Australia)'),
    ('AU-TMW', 'AU-TMW (Tamworth, New South Wales, Australia)'),
    ('AU-TWH', 'AU-TWH (Tanawha, Queensland, Australia)'),
    ('AU-TXR', 'AU-TXR (Tanbar, Queensland, Australia)'),
    ('AU-TAN', 'AU-TAN (Tangalooma, Queensland, Australia)'),
    ('AU-TAK', 'AU-TAK (Tankerton, Victoria, Australia)'),
    ('AU-TNU', 'AU-TNU (Tannunda, South Australia, Australia)'),
    ('AU-TAR', 'AU-TAR (Tanunda, South Australia, Australia)'),
    ('AU-XTR', 'AU-XTR (Tara, Queensland, Australia)'),
    ('AU-TGO', 'AU-TGO (Tarago, New South Wales, Australia)'),
    ('AU-TAP', 'AU-TAP (Tarampa, Queensland, Australia)'),
    ('AU-TRN', 'AU-TRN (Tarban, New South Wales, Australia)'),
    ('AU-TAQ', 'AU-TAQ (Tarcoola, South Australia, Australia)'),
    ('AU-TRO', 'AU-TRO (Taree, New South Wales, Australia)'),
    ('AU-TPO', 'AU-TPO (Taren Point, New South Wales, Australia)'),
    ('AU-2IC', 'AU-2IC (Tarneit, Victoria, Australia)'),
    ('AU-XTO', 'AU-XTO (Taroom, Queensland, Australia)'),
    ('AU-XTA', 'AU-XTA (Tarrington, Victoria, Australia)'),
    ('AU-TAU', 'AU-TAU (Tatura, Victoria, Australia)'),
    ('AU-DGA', 'AU-DGA (Tea Gardens, New South Wales, Australia)'),
    ('AU-TTE', 'AU-TTE (Tea Tree, Tasmania, Australia)'),
    ('AU-TSD', 'AU-TSD (Teesdale, Victoria, Australia)'),
    ('AU-TEF', 'AU-TEF (Telfer, Western Australia, Australia)'),
    ('AU-TEM', 'AU-TEM (Temora, New South Wales, Australia)'),
    ('AU-MPE', 'AU-MPE (Tempe, New South Wales, Australia)'),
    ('AU-TPW', 'AU-TPW (Templestowe, Victoria, Australia)'),
    ('AU-TCA', 'AU-TCA (Templestowe, Victoria, Australia)'),
    ('AU-TNS', 'AU-TNS (Tennyson, Queensland, Australia)'),
    ('AU-TNT', 'AU-TNT (Tenterfield, New South Wales, Australia)'),
    ('AU-TYH', 'AU-TYH (Terrey Hills, New South Wales, Australia)'),
    ('AU-TRL', 'AU-TRL (Terrigal, New South Wales, Australia)'),
    ('AU-TWN', 'AU-TWN (Tewantin, Queensland, Australia)'),
    ('AU-THG', 'AU-THG (Thangool, Queensland, Australia)'),
    ('AU-TGH', 'AU-TGH (Tharbogang, New South Wales, Australia)'),
    ('AU-XTG', 'AU-XTG (Thargomindah, Queensland, Australia)'),
    ('AU-7IC', 'AU-7IC (The Basin, Victoria, Australia)'),
    ('AU-GUR', 'AU-GUR (The Gurdies, Victoria, Australia)'),
    ('AU-ROC', 'AU-ROC (The Rock, New South Wales, Australia)'),
    ('AU-BTN', 'AU-BTN (Thebarton, South Australia, Australia)'),
    ('AU-TDR', 'AU-TDR (Theodore, Queensland, Australia)'),
    ('AU-THE', 'AU-THE (Thevenard, South Australia, Australia)'),
    ('AU-CTH', 'AU-CTH (Thevenard Island, Western Australia, Australia)'),
    ('AU-THO', 'AU-THO (Thomastown, Victoria, Australia)'),
    ('AU-TBY', 'AU-TBY (Thornbury, Victoria, Australia)'),
    ('AU-TLA', 'AU-TLA (Thornlands, Queensland, Australia)'),
    ('AU-THR', 'AU-THR (Thornleigh, New South Wales, Australia)'),
    ('AU-TRT', 'AU-TRT (Thornton, New South Wales, Australia)'),
    ('AU-QTH', 'AU-QTH (Thredbo Village, New South Wales, Australia)'),
    ('AU-QMB', 'AU-QMB (Thulimbah, Queensland, Australia)'),
    ('AU-TIS', 'AU-TIS (Thursday Island, Queensland, Australia)'),
    ('AU-TYG', 'AU-TYG (Thylungra, Queensland, Australia)'),
    ('AU-TYB', 'AU-TYB (Tibooburra, New South Wales, Australia)'),
    ('AU-TIE', 'AU-TIE (Tieri, Queensland, Australia)'),
    ('AU-TBK', 'AU-TBK (Tieri, Queensland, Australia)'),
    ('AU-TPT', 'AU-TPT (Tieri, Queensland, Australia)'),
    ('AU-JUK', 'AU-JUK (Timboon, Victoria, Australia)'),
    ('AU-TCB', 'AU-TCB (Tin Can Bay, Queensland, Australia)'),
    ('AU-TNA', 'AU-TNA (Tinana, Queensland, Australia)'),
    ('AU-TIN', 'AU-TIN (Tinana, Queensland, Australia)'),
    ('AU-TIP', 'AU-TIP (Tingalpa, Queensland, Australia)'),
    ('AU-TIV', 'AU-TIV (Tintaldra, Victoria, Australia)'),
    ('AU-TYP', 'AU-TYP (Tintaldra, Victoria, Australia)'),
    ('AU-TCW', 'AU-TCW (Tocumwal, New South Wales, Australia)'),
    ('AU-TTT', 'AU-TTT (Tolga, Queensland, Australia)'),
    ('AU-TPR', 'AU-TPR (Tom Price, Western Australia, Australia)'),
    ('AU-TOM', 'AU-TOM (Tomago, New South Wales, Australia)'),
    ('AU-TGY', 'AU-TGY (Tomingley, New South Wales, Australia)'),
    ('AU-TOJ', 'AU-TOJ (Tongala, Victoria, Australia)'),
    ('AU-TNK', 'AU-TNK (Tonimbuk, Victoria, Australia)'),
    ('AU-TBR', 'AU-TBR (Tooborac, Victoria, Australia)'),
    ('AU-TDA', 'AU-TDA (Toodyay, Western Australia, Australia)'),
    ('AU-TOO', 'AU-TOO (Toolamba, Victoria, Australia)'),
    ('AU-LLN', 'AU-LLN (Toolleen, Victoria, Australia)'),
    ('AU-TOL', 'AU-TOL (Toombul, Queensland, Australia)'),
    ('AU-R2A', 'AU-R2A (Toongabbie, New South Wales, Australia)'),
    ('AU-TRD', 'AU-TRD (Tooradin, Victoria, Australia)'),
    ('AU-TGD', 'AU-TGD (Toorak Gardens, South Australia, Australia)'),
    ('AU-TOG', 'AU-TOG (Tooronga, Victoria, Australia)'),
    ('AU-TWQ', 'AU-TWQ (Toowong, Queensland, Australia)'),
    ('AU-TWB', 'AU-TWB (Toowoomba, Queensland, Australia)'),
    ('AU-TBC', 'AU-TBC (Toowoomba City, Queensland, Australia)'),
    ('AU-TOR', 'AU-TOR (Toronto, New South Wales, Australia)'),
    ('AU-TQY', 'AU-TQY (Torquay, Queensland, Australia)'),
    ('AU-TRQ', 'AU-TRQ (Torquay, Victoria, Australia)'),
    ('AU-LKU', 'AU-LKU (Torrensville, South Australia, Australia)'),
    ('AU-TWP', 'AU-TWP (Torwood, Queensland, Australia)'),
    ('AU-TSA', 'AU-TSA (Totness, South Australia, Australia)'),
    ('AU-THM', 'AU-THM (Tottenham, Victoria, Australia)'),
    ('AU-TOT', 'AU-TOT (Tottenham, New South Wales, Australia)'),
    ('AU-TOB', 'AU-TOB (Tottenham, New South Wales, Australia)'),
    ('AU-TSV', 'AU-TSV (Townsville, Queensland, Australia)'),
    ('AU-TGN', 'AU-TGN (Traralgon, Victoria, Australia)'),
    ('AU-TMO', 'AU-TMO (Tremont, Victoria, Australia)'),
    ('AU-TRH', 'AU-TRH (Trentham, Victoria, Australia)'),
    ('AU-TTW', 'AU-TTW (Trentham Cliffs, New South Wales, Australia)'),
    ('AU-KUK', 'AU-KUK (Triabunna, Tasmania, Australia)'),
    ('AU-TRB', 'AU-TRB (Trial Bay, New South Wales, Australia)'),
    ('AU-TRI', 'AU-TRI (Troughton Island, Western Australia, Australia)'),
    ('AU-TRU', 'AU-TRU (Truganina, Victoria, Australia)'),
    ('AU-RRO', 'AU-RRO (Truro, South Australia, Australia)'),
    ('AU-TUV', 'AU-TUV (Tuerong, Victoria, Australia)'),
    ('AU-TUG', 'AU-TUG (Tuggerah, New South Wales, Australia)'),
    ('AU-TGG', 'AU-TGG (Tuggerah, New South Wales, Australia)'),
    ('AU-TME', 'AU-TME (Tullamarine, Victoria, Australia)'),
    ('AU-TGE', 'AU-TGE (Tullibigeal, New South Wales, Australia)'),
    ('AU-TBB', 'AU-TBB (Tumbarumba, New South Wales, Australia)'),
    ('AU-TUL', 'AU-TUL (Tumblong, New South Wales, Australia)'),
    ('AU-TBG', 'AU-TBG (Tumbulgum, New South Wales, Australia)'),
    ('AU-TUM', 'AU-TUM (Tumut, New South Wales, Australia)'),
    ('AU-TBH', 'AU-TBH (Tura Beach, New South Wales, Australia)'),
    ('AU-TKY', 'AU-TKY (Turkey Creek, Western Australia, Australia)'),
    ('AU-TUR', 'AU-TUR (Turramurra, New South Wales, Australia)'),
    ('AU-SAT', 'AU-SAT (Tusmore, South Australia, Australia)'),
    ('AU-THS', 'AU-THS (Tweed Heads South, New South Wales, Australia)'),
    ('AU-DA5', 'AU-DA5 (Twowells, South Australia, Australia)'),
    ('AU-2CO', 'AU-2CO (Tyabb, Victoria, Australia)'),
    ('AU-TYE', 'AU-TYE (Tyers, Victoria, Australia)'),
    ('AU-TNG', 'AU-TNG (Tynong, Victoria, Australia)'),
    ('AU-TYN', 'AU-TYN (Tynong North, Victoria, Australia)'),
    ('AU-ULY', 'AU-ULY (Uleybury, South Australia, Australia)'),
    ('AU-ULA', 'AU-ULA (Ulladulla, New South Wales, Australia)'),
    ('AU-ULT', 'AU-ULT (Ultimo, New South Wales, Australia)'),
    ('AU-ULV', 'AU-ULV (Ulverstone, Tasmania, Australia)'),
    ('AU-UMB', 'AU-UMB (Ulverstone, Tasmania, Australia)'),
    ('AU-UDR', 'AU-UDR (Unanderra, New South Wales, Australia)'),
    ('AU-UDA', 'AU-UDA (Undarra, Queensland, Australia)'),
    ('AU-UDW', 'AU-UDW (Underwood, Tasmania, Australia)'),
    ('AU-UGI', 'AU-UGI (Ungarie, New South Wales, Australia)'),
    ('AU-ALY', 'AU-ALY (Unley, South Australia, Australia)'),
    ('AU-UHG', 'AU-UHG (Upper Hermitage, South Australia, Australia)'),
    ('AU-UMG', 'AU-UMG (Upper Mount Gravatt, Queensland, Australia)'),
    ('AU-UPH', 'AU-UPH (Upton Hill, Victoria, Australia)'),
    ('AU-3CO', 'AU-3CO (Upwey, Victoria, Australia)'),
    ('AU-RAI', 'AU-RAI (Uraidla, South Australia, Australia)'),
    ('AU-ULL', 'AU-ULL (Uralla, New South Wales, Australia)'),
    ('AU-UNA', 'AU-UNA (Urana, New South Wales, Australia)'),
    ('AU-URN', 'AU-URN (Urangan, Queensland, Australia)'),
    ('AU-URR', 'AU-URR (Urrbrae, South Australia, Australia)'),
    ('AU-USL', 'AU-USL (Useless Loop, Western Australia, Australia)'),
    ('AU-VGH', 'AU-VGH (Useless Loop, Western Australia, Australia)'),
    ('AU-VNR', 'AU-VNR (Vanrook, Queensland, Australia)'),
    ('AU-VAR', 'AU-VAR (Varanus Island, Western Australia, Australia)'),
    ('AU-VAS', 'AU-VAS (Vasse, Western Australia, Australia)'),
    ('AU-VAU', 'AU-VAU (Vaucluse, New South Wales, Australia)'),
    ('AU-VEC', 'AU-VEC (Vectis, Victoria, Australia)'),
    ('AU-VDN', 'AU-VDN (Verdun, South Australia, Australia)'),
    ('AU-VMT', 'AU-VMT (Vermont, Victoria, Australia)'),
    ('AU-VHR', 'AU-VHR (Victor Harbor, South Australia, Australia)'),
    ('AU-VTP', 'AU-VTP (Victoria Point, Queensland, Australia)'),
    ('AU-VCD', 'AU-VCD (Victoria Point, Queensland, Australia)'),
    ('AU-VIE', 'AU-VIE (Viewbank, Victoria, Australia)'),
    ('AU-VIW', 'AU-VIW (Villawood/Sydney, New South Wales, Australia)'),
    ('AU-VIN', 'AU-VIN (Vincent, Victoria, Australia)'),
    ('AU-VVE', 'AU-VVE (Vine Vale, South Australia, Australia)'),
    ('AU-WYR', 'AU-WYR (Vineyard, New South Wales, Australia)'),
    ('AU-VGN', 'AU-VGN (Virginia, Queensland, Australia)'),
    ('AU-VRG', 'AU-VRG (Virginia, South Australia, Australia)'),
    ('AU-WCL', 'AU-WCL (Wacol, Queensland, Australia)'),
    ('AU-WGA', 'AU-WGA (Wagga Wagga, New South Wales, Australia)'),
    ('AU-WGI', 'AU-WGI (Wagin, Western Australia, Australia)'),
    ('AU-ZR3', 'AU-ZR3 (Wahgunyah, Victoria, Australia)'),
    ('AU-OUK', 'AU-OUK (Wahring, Victoria, Australia)'),
    ('AU-WNA', 'AU-WNA (Wahroonga, New South Wales, Australia)'),
    ('AU-WKE', 'AU-WKE (Waikerie, South Australia, Australia)'),
    ('AU-WTR', 'AU-WTR (Waitara, New South Wales, Australia)'),
    ('AU-WKY', 'AU-WKY (Wakerley, Queensland, Australia)'),
    ('AU-WLC', 'AU-WLC (Walcha, New South Wales, Australia)'),
    ('AU-WGE', 'AU-WGE (Walgett, New South Wales, Australia)'),
    ('AU-R2R', 'AU-R2R (Wallacia, New South Wales, Australia)'),
    ('AU-WLA', 'AU-WLA (Wallal, Western Australia, Australia)'),
    ('AU-WLN', 'AU-WLN (Wallan, Victoria, Australia)'),
    ('AU-WLG', 'AU-WLG (Wallangarra, Queensland, Australia)'),
    ('AU-WAL', 'AU-WAL (Wallaroo, South Australia, Australia)'),
    ('AU-WDB', 'AU-WDB (Wallendbeen, New South Wales, Australia)'),
    ('AU-WLS', 'AU-WLS (Wallendbeen, New South Wales, Australia)'),
    ('AU-WMS', 'AU-WMS (Walmsley, Western Australia, Australia)'),
    ('AU-WPO', 'AU-WPO (Walpole, Western Australia, Australia)'),
    ('AU-WMN', 'AU-WMN (Wamboin, New South Wales, Australia)'),
    ('AU-WDL', 'AU-WDL (Wandal, Queensland, Australia)'),
    ('AU-WAD', 'AU-WAD (Wandandian, New South Wales, Australia)'),
    ('AU-WDN', 'AU-WDN (Wandin, Victoria, Australia)'),
    ('AU-WNT', 'AU-WNT (Wandoo Terminal, Western Australia, Australia)'),
    ('AU-WGR', 'AU-WGR (Wangara, Western Australia, Australia)'),
    ('AU-WGT', 'AU-WGT (Wangaratta, Victoria, Australia)'),
    ('AU-WA7', 'AU-WA7 (Wangolina, South Australia, Australia)'),
    ('AU-5CO', 'AU-5CO (Wantirna, Victoria, Australia)'),
    ('AU-WTS', 'AU-WTS (Wantirna South, Victoria, Australia)'),
    ('AU-WAB', 'AU-WAB (Warabrook, New South Wales, Australia)'),
    ('AU-WAX', 'AU-WAX (Warana, Queensland, Australia)'),
    ('AU-WTA', 'AU-WTA (Waratah, New South Wales, Australia)'),
    ('AU-WSN', 'AU-WSN (Warners Bay, New South Wales, Australia)'),
    ('AU-NWV', 'AU-NWV (Warnervale, New South Wales, Australia)'),
    ('AU-WAK', 'AU-WAK (Warooka, South Australia, Australia)'),
    ('AU-WKB', 'AU-WKB (Warracknabeal, Victoria, Australia)'),
    ('AU-VWL', 'AU-VWL (Warragul, Victoria, Australia)'),
    ('AU-6CO', 'AU-6CO (Warrandyte, Victoria, Australia)'),
    ('AU-WAR', 'AU-WAR (Warrandyte South, Victoria, Australia)'),
    ('AU-WRW', 'AU-WRW (Warrawagine, Western Australia, Australia)'),
    ('AU-R2E', 'AU-R2E (Warrawee, New South Wales, Australia)'),
    ('AU-QRR', 'AU-QRR (Warren, New South Wales, Australia)'),
    ('AU-WRM', 'AU-WRM (Warrenmang, Victoria, Australia)'),
    ('AU-PUK', 'AU-PUK (Warriewood, New South Wales, Australia)'),
    ('AU-WMB', 'AU-WMB (Warrnambool, Victoria, Australia)'),
    ('AU-WAZ', 'AU-WAZ (Warwick, Queensland, Australia)'),
    ('AU-WKF', 'AU-WKF (Warwick Farm, New South Wales, Australia)'),
    ('AU-QUK', 'AU-QUK (Waterloo, New South Wales, Australia)'),
    ('AU-WLO', 'AU-WLO (Waterloo, New South Wales, Australia)'),
    ('AU-WCR', 'AU-WCR (Waterloo Corner, South Australia, Australia)'),
    ('AU-WLV', 'AU-WLV (Watervale, South Australia, Australia)'),
    ('AU-WTW', 'AU-WTW (Waterways, Victoria, Australia)'),
    ('AU-R2W', 'AU-R2W (Watsons Bay, New South Wales, Australia)'),
    ('AU-WGO', 'AU-WGO (Wattle Grove, Western Australia, Australia)'),
    ('AU-TPK', 'AU-TPK (Wattle Park, Queensland, Australia)'),
    ('AU-WPS', 'AU-WPS (Wattle Park, South Australia, Australia)'),
    ('AU-WTP', 'AU-WTP (Wattleup, Western Australia, Australia)'),
    ('AU-WAU', 'AU-WAU (Wauchope, New South Wales, Australia)'),
    ('AU-WPD', 'AU-WPD (Waurn Ponds, Victoria, Australia)'),
    ('AU-WAV', 'AU-WAV (Waurn Ponds, Victoria, Australia)'),
    ('AU-WAN', 'AU-WAN (Waverney, Queensland, Australia)'),
    ('AU-7WW', 'AU-7WW (Waverton, New South Wales, Australia)'),
    ('AU-WVI', 'AU-WVI (Wayville, South Australia, Australia)'),
    ('AU-WTN', 'AU-WTN (Webberton, Western Australia, Australia)'),
    ('AU-WFD', 'AU-WFD (Wedgefield, Western Australia, Australia)'),
    ('AU-WEW', 'AU-WEW (Wee Waa, New South Wales, Australia)'),
    ('AU-WEI', 'AU-WEI (Weipa, Queensland, Australia)'),
    ('AU-KJH', 'AU-KJH (Welland, South Australia, Australia)'),
    ('AU-QEL', 'AU-QEL (Wellington, New South Wales, Australia)'),
    ('AU-WEL', 'AU-WEL (Welshpool, Western Australia, Australia)'),
    ('AU-WHL', 'AU-WHL (Welshpool, Victoria, Australia)'),
    ('AU-WEN', 'AU-WEN (Wendouree, Victoria, Australia)'),
    ('AU-WWP', 'AU-WWP (Wentworth Point, New South Wales, Australia)'),
    ('AU-WTV', 'AU-WTV (Wentworthville, New South Wales, Australia)'),
    ('AU-WRB', 'AU-WRB (Werribee, Victoria, Australia)'),
    ('AU-5RC', 'AU-5RC (Werribee South, Victoria, Australia)'),
    ('AU-WCK', 'AU-WCK (Werris Creek, New South Wales, Australia)'),
    ('AU-WVL', 'AU-WVL (Wesley Vale, Tasmania, Australia)'),
    ('AU-WFO', 'AU-WFO (West Footscray, Victoria, Australia)'),
    ('AU-6DF', 'AU-6DF (West Hoxton, New South Wales, Australia)'),
    ('AU-WQS', 'AU-WQS (West Lake Shore, South Australia, Australia)'),
    ('AU-WKS', 'AU-WKS (West Lakes, South Australia, Australia)'),
    ('AU-WMU', 'AU-WMU (West Melbourne, Victoria, Australia)'),
    ('AU-WPW', 'AU-WPW (West Perth, Western Australia, Australia)'),
    ('AU-NS8', 'AU-NS8 (West Pymble, New South Wales, Australia)'),
    ('AU-RYD', 'AU-RYD (West Ryde, New South Wales, Australia)'),
    ('AU-WWY', 'AU-WWY (West Wyalong, New South Wales, Australia)'),
    ('AU-SWP', 'AU-SWP (Westbourne Park, South Australia, Australia)'),
    ('AU-WES', 'AU-WES (Westbury, Tasmania, Australia)'),
    ('AU-WSJ', 'AU-WSJ (Western Junction, Tasmania, Australia)'),
    ('AU-WEP', 'AU-WEP (Westernport, Victoria, Australia)'),
    ('AU-WSE', 'AU-WSE (Westminster, Western Australia, Australia)'),
    ('AU-WEC', 'AU-WEC (Westminster, Western Australia, Australia)'),
    ('AU-WEH', 'AU-WEH (Wetherhill, New South Wales, Australia)'),
    ('AU-WPA', 'AU-WPA (Wetherill Park, New South Wales, Australia)'),
    ('AU-WVV', 'AU-WVV (Wheelers Hill, Victoria, Australia)'),
    ('AU-WMO', 'AU-WMO (Whitemore, Tasmania, Australia)'),
    ('AU-WFL', 'AU-WFL (Whitfield, Victoria, Australia)'),
    ('AU-WSI', 'AU-WSI (Whitsunday Island, Queensland, Australia)'),
    ('AU-WHT', 'AU-WHT (Whittlesea, Victoria, Australia)'),
    ('AU-WTO', 'AU-WTO (Whitton, New South Wales, Australia)'),
    ('AU-WSH', 'AU-WSH (Whorouly South, Victoria, Australia)'),
    ('AU-WYA', 'AU-WYA (Whyalla, South Australia, Australia)'),
    ('AU-WAM', 'AU-WAM (Wickham, New South Wales, Australia)'),
    ('AU-WKA', 'AU-WKA (Wickham, New South Wales, Australia)'),
    ('AU-WIO', 'AU-WIO (Wilcannia, New South Wales, Australia)'),
    ('AU-WAG', 'AU-WAG (Willagee, Western Australia, Australia)'),
    ('AU-LAU', 'AU-LAU (Willaura, Victoria, Australia)'),
    ('AU-WIL', 'AU-WIL (Willawong, Queensland, Australia)'),
    ('AU-WGG', 'AU-WGG (Willbriggie, New South Wales, Australia)'),
    ('AU-WEO', 'AU-WEO (Willetton, Western Australia, Australia)'),
    ('AU-WLI', 'AU-WLI (Williams, Western Australia, Australia)'),
    ('AU-WII', 'AU-WII (Williamstown, South Australia, Australia)'),
    ('AU-WST', 'AU-WST (Williamstown, Victoria, Australia)'),
    ('AU-WLM', 'AU-WLM (Williamtown, New South Wales, Australia)'),
    ('AU-WBY', 'AU-WBY (Willoughby, New South Wales, Australia)'),
    ('AU-WGV', 'AU-WGV (Willow Grove, Victoria, Australia)'),
    ('AU-WWV', 'AU-WWV (Willow Vale, New South Wales, Australia)'),
    ('AU-WVA', 'AU-WVA (Willowdale, New South Wales, Australia)'),
    ('AU-WSA', 'AU-WSA (Willunga, South Australia, Australia)'),
    ('AU-WAW', 'AU-WAW (Wilson, Western Australia, Australia)'),
    ('AU-WLT', 'AU-WLT (Wilsonton, Queensland, Australia)'),
    ('AU-TON', 'AU-TON (Wilton, New South Wales, Australia)'),
    ('AU-WJU', 'AU-WJU (Wiltshire Junction, Tasmania, Australia)'),
    ('AU-WUN', 'AU-WUN (Wiluna, Western Australia, Australia)'),
    ('AU-WU6', 'AU-WU6 (Wilyarup, Western Australia, Australia)'),
    ('AU-WND', 'AU-WND (Windarra, Western Australia, Australia)'),
    ('AU-WQR', 'AU-WQR (Windibri, Queensland, Australia)'),
    ('AU-WNR', 'AU-WNR (Windorah, Queensland, Australia)'),
    ('AU-VWS', 'AU-VWS (Windsor, Victoria, Australia)'),
    ('AU-WID', 'AU-WID (Windsor, South Australia, Australia)'),
    ('AU-WQD', 'AU-WQD (Windsor, Queensland, Australia)'),
    ('AU-WSO', 'AU-WSO (Windsor, New South Wales, Australia)'),
    ('AU-WGL', 'AU-WGL (Wingello, New South Wales, Australia)'),
    ('AU-WGF', 'AU-WGF (Wingfield, South Australia, Australia)'),
    ('AU-WIH', 'AU-WIH (Wingham, New South Wales, Australia)'),
    ('AU-WNN', 'AU-WNN (Wingham, New South Wales, Australia)'),
    ('AU-WHI', 'AU-WHI (Winston Hills, New South Wales, Australia)'),
    ('AU-WIN', 'AU-WIN (Winton, Queensland, Australia)'),
    ('AU-VIT', 'AU-VIT (Wishart, Victoria, Australia)'),
    ('AU-WLE', 'AU-WLE (Witchcliffe, Western Australia, Australia)'),
    ('AU-WTH', 'AU-WTH (Withcott, Queensland, Australia)'),
    ('AU-WNB', 'AU-WNB (Withnell Bay, Western Australia, Australia)'),
    ('AU-WIT', 'AU-WIT (Wittenoom, Western Australia, Australia)'),
    ('AU-HOE', 'AU-HOE (Wivenhoe, Tasmania, Australia)'),
    ('AU-W8N', 'AU-W8N (Wivenhoe, Tasmania, Australia)'),
    ('AU-WOD', 'AU-WOD (Wodonga, Victoria, Australia)'),
    ('AU-W8L', 'AU-W8L (Woleebee, Queensland, Australia)'),
    ('AU-2TO', 'AU-2TO (Wollert, Victoria, Australia)'),
    ('AU-WLL', 'AU-WLL (Wollogorang, Queensland, Australia)'),
    ('AU-WLR', 'AU-WLR (Wollongbar, New South Wales, Australia)'),
    ('AU-WOL', 'AU-WOL (Wollongong, New South Wales, Australia)'),
    ('AU-WUA', 'AU-WUA (Wolumla, New South Wales, Australia)'),
    ('AU-WDI', 'AU-WDI (Wondai, Queensland, Australia)'),
    ('AU-WDG', 'AU-WDG (Wondalga, New South Wales, Australia)'),
    ('AU-WON', 'AU-WON (Wondoola, Queensland, Australia)'),
    ('AU-WPR', 'AU-WPR (Wonga Park, Victoria, Australia)'),
    ('AU-WOT', 'AU-WOT (Wonthaggi, Victoria, Australia)'),
    ('AU-W7W', 'AU-W7W (Wood Wood, Victoria, Australia)'),
    ('AU-OWF', 'AU-OWF (Woodcroft, South Australia, Australia)'),
    ('AU-WDD', 'AU-WDD (Woodend, Victoria, Australia)'),
    ('AU-WFR', 'AU-WFR (Woodford, Queensland, Australia)'),
    ('AU-WOG', 'AU-WOG (Woodford, Queensland, Australia)'),
    ('AU-WWI', 'AU-WWI (Woodie Woodie, Western Australia, Australia)'),
    ('AU-WLD', 'AU-WLD (Woodlands, New South Wales, Australia)'),
    ('AU-WDE', 'AU-WDE (Woodridge, Western Australia, Australia)'),
    ('AU-WDR', 'AU-WDR (Woodridge, Queensland, Australia)'),
    ('AU-WIE', 'AU-WIE (Woodside, South Australia, Australia)'),
    ('AU-WOV', 'AU-WOV (Woodvale, Western Australia, Australia)'),
    ('AU-WDV', 'AU-WDV (Woodville, South Australia, Australia)'),
    ('AU-UUK', 'AU-UUK (Woody Point, Queensland, Australia)'),
    ('AU-GOW', 'AU-GOW (Woolgoolga, New South Wales, Australia)'),
    ('AU-WHR', 'AU-WHR (Woollahra, New South Wales, Australia)'),
    ('AU-WOO', 'AU-WOO (Woolloomooloo, New South Wales, Australia)'),
    ('AU-WGB', 'AU-WGB (Woolloongabba, Queensland, Australia)'),
    ('AU-WBT', 'AU-WBT (Woollybutt (Oil facility), Western Australia, Australia)'),
    ('AU-2UA', 'AU-2UA (Woolooware, New South Wales, Australia)'),
    ('AU-W2V', 'AU-W2V (Woolwich, New South Wales, Australia)'),
    ('AU-UMR', 'AU-UMR (Woomera, South Australia, Australia)'),
    ('AU-WRE', 'AU-WRE (Woree, Queensland, Australia)'),
    ('AU-8SS', 'AU-8SS (Woronora, New South Wales, Australia)'),
    ('AU-WOY', 'AU-WOY (Woy Woy, New South Wales, Australia)'),
    ('AU-WPK', 'AU-WPK (Wrotham Park, Queensland, Australia)'),
    ('AU-WUD', 'AU-WUD (Wudinna, South Australia, Australia)'),
    ('AU-WUK', 'AU-WUK (Wulkuraka, Queensland, Australia)'),
    ('AU-WUR', 'AU-WUR (Wurruk, Victoria, Australia)'),
    ('AU-WKM', 'AU-WKM (Wyalkatchem, Western Australia, Australia)'),
    ('AU-WYL', 'AU-WYL (Wyalong, New South Wales, Australia)'),
    ('AU-WBG', 'AU-WBG (Wybong, New South Wales, Australia)'),
    ('AU-WYE', 'AU-WYE (Wyee, New South Wales, Australia)'),
    ('AU-WYD', 'AU-WYD (Wyndham, New South Wales, Australia)'),
    ('AU-WYN', 'AU-WYN (Wyndham, Western Australia, Australia)'),
    ('AU-WWS', 'AU-WWS (Wynnum West, Queensland, Australia)'),
    ('AU-WNY', 'AU-WNY (Wynyard, Tasmania, Australia)'),
    ('AU-WYO', 'AU-WYO (Wyong, New South Wales, Australia)'),
    ('AU-YBU', 'AU-YBU (Yabulu, Queensland, Australia)'),
    ('AU-YAN', 'AU-YAN (Yagoona, New South Wales, Australia)'),
    ('AU-KYI', 'AU-KYI (Yalata Mission, South Australia, Australia)'),
    ('AU-YLG', 'AU-YLG (Yalgoo, Western Australia, Australia)'),
    ('AU-YGU', 'AU-YGU (Yallingup, Western Australia, Australia)'),
    ('AU-XMY', 'AU-XMY (Yam Island, Queensland, Australia)'),
    ('AU-YBA', 'AU-YBA (Yamba, New South Wales, Australia)'),
    ('AU-YMB', 'AU-YMB (Yambuk, Victoria, Australia)'),
    ('AU-YAM', 'AU-YAM (Yampi, Western Australia, Australia)'),
    ('AU-5TO', 'AU-5TO (Yan Yean, Victoria, Australia)'),
    ('AU-YNC', 'AU-YNC (Yanco, New South Wales, Australia)'),
    ('AU-YNN', 'AU-YNN (Yandicoogina / Yandi Apt, Western Australia, Australia)'),
    ('AU-YDN', 'AU-YDN (Yandina, Queensland, Australia)'),
    ('AU-YGB', 'AU-YGB (Yangebup, Western Australia, Australia)'),
    ('AU-KYB', 'AU-KYB (Yangoonabie, South Australia, Australia)'),
    ('AU-YLO', 'AU-YLO (Yarloop, Western Australia, Australia)'),
    ('AU-YAR', 'AU-YAR (Yarra Glen, Victoria, Australia)'),
    ('AU-YRR', 'AU-YRR (Yarra Junction, Victoria, Australia)'),
    ('AU-VUK', 'AU-VUK (Yarragon, Victoria, Australia)'),
    ('AU-YRL', 'AU-YRL (Yarragon, Victoria, Australia)'),
    ('AU-YRV', 'AU-YRV (Yarraville/Melbourne, Victoria, Australia)'),
    ('AU-2SN', 'AU-2SN (Yarrawarrah, New South Wales, Australia)'),
    ('AU-YWO', 'AU-YWO (Yarrawonga, New South Wales, Australia)'),
    ('AU-YAW', 'AU-YAW (Yarwun, Queensland, Australia)'),
    ('AU-YSS', 'AU-YSS (Yass, New South Wales, Australia)'),
    ('AU-YTL', 'AU-YTL (Yatala, Queensland, Australia)'),
    ('AU-YEA', 'AU-YEA (Yea, Victoria, Australia)'),
    ('AU-KYF', 'AU-KYF (Yeelirrie, Western Australia, Australia)'),
    ('AU-YEE', 'AU-YEE (Yeerongpilly, Queensland, Australia)'),
    ('AU-YEB', 'AU-YEB (Yellingbo, Victoria, Australia)'),
    ('AU-YDA', 'AU-YDA (Yenda, New South Wales, Australia)'),
    ('AU-YNA', 'AU-YNA (Yennora, New South Wales, Australia)'),
    ('AU-YEL', 'AU-YEL (Yeppoon, Queensland, Australia)'),
    ('AU-YRG', 'AU-YRG (Yering, Victoria, Australia)'),
    ('AU-YKN', 'AU-YKN (Yokine, Western Australia, Australia)'),
    ('AU-YLL', 'AU-YLL (Yolla, Tasmania, Australia)'),
    ('AU-YOR', 'AU-YOR (York, Western Australia, Australia)'),
    ('AU-OKR', 'AU-OKR (Yorke Island, Queensland, Australia)'),
    ('AU-ORR', 'AU-ORR (Yorketown, South Australia, Australia)'),
    ('AU-YKB', 'AU-YKB (Yorkeys Knob, Queensland, Australia)'),
    ('AU-NGA', 'AU-NGA (Young, New South Wales, Australia)'),
    ('AU-YOU', 'AU-YOU (Youngtown, Tasmania, Australia)'),
    ('AU-3WS', 'AU-3WS (Yowie Bay, New South Wales, Australia)'),
    ('AU-YUE', 'AU-YUE (Yowie Bay, New South Wales, Australia)'),
    ('AU-YUL', 'AU-YUL (Yowie Bay, New South Wales, Australia)'),
    ('AU-ZLD', 'AU-ZLD (Zetland, New South Wales, Australia)'),
    ('AU-ZLM', 'AU-ZLM (Zillmere, Queensland, Australia)'),
    ('AW-AUA', 'AW-AUA (Aruba, Aruba)'),
    ('AW-BAR', 'AW-BAR (Barcadera, Aruba)'),
    ('AW-BUS', 'AW-BUS (Bushiribana, Aruba)'),
    ('AW-DEU', 'AW-DEU (Druif, Aruba)'),
    ('AW-ND9', 'AW-ND9 (Noord, Aruba)'),
    ('AW-ORJ', 'AW-ORJ (Oranjestad, Aruba)'),
    ('AW-PAB', 'AW-PAB (Palm Beach, Aruba)'),
    ('AW-PAR', 'AW-PAR (Paradera, Aruba)'),
    ('AW-SCZ', 'AW-SCZ (Santa Cruz, Aruba)'),
    ('AW-SNL', 'AW-SNL (Sint Nicolaas, Aruba)'),
    ('AX-MHQ', 'AX-MHQ (Maarianhamina (Mariehamn), Åland Islands)'),
    ('AX-MHQ', 'AX-MHQ (Mariehamn (Maarianhamina), Åland Islands)'),
    ('AZ-ABN', 'AZ-ABN (Agcabadi, Azerbaijan)'),
    ('AZ-AGS', 'AZ-AGS (Agstafa, Azerbaijan)'),
    ('AZ-AST', 'AZ-AST (Astara, Azerbaijan)'),
    ('AZ-BAK', 'AZ-BAK (Baku, Azerbaijan)'),
    ('AZ-DAM', 'AZ-DAM (Dalimammadli, Azerbaijan)'),
    ('AZ-DJU', 'AZ-DJU (Djulfa, Azerbaijan)'),
    ('AZ-GAN', 'AZ-GAN (Ganja, Azerbaijan)'),
    ('AZ-KVD', 'AZ-KVD (Gyandzha, Azerbaijan)'),
    ('AZ-GYD', 'AZ-GYD (Heydar Aliyev International Apt., Azerbaijan)'),
    ('AZ-IMI', 'AZ-IMI (Imisli, Azerbaijan)'),
    ('AZ-KMZ', 'AZ-KMZ (Khachmaz, Azerbaijan)'),
    ('AZ-KHA', 'AZ-KHA (Khanlar, Azerbaijan)'),
    ('AZ-KBD', 'AZ-KBD (Kirovabad, Azerbaijan)'),
    ('AZ-LAN', 'AZ-LAN (Lankaran, Azerbaijan)'),
    ('AZ-MGC', 'AZ-MGC (Mingechaur, Azerbaijan)'),
    ('AZ-NAJ', 'AZ-NAJ (Naxcivan, Azerbaijan)'),
    ('AZ-QDG', 'AZ-QDG (Qaradag, Azerbaijan)'),
    ('AZ-KAZ', 'AZ-KAZ (Qazax, Azerbaijan)'),
    ('AZ-QUB', 'AZ-QUB (Quba, Azerbaijan)'),
    ('AZ-QUS', 'AZ-QUS (Qusqara, Azerbaijan)'),
    ('AZ-SAM', 'AZ-SAM (Samaxi, Azerbaijan)'),
    ('AZ-SAN', 'AZ-SAN (Sangachal, Azerbaijan)'),
    ('AZ-SHI', 'AZ-SHI (Shirvan, Azerbaijan)'),
    ('AZ-SY9', 'AZ-SY9 (Siyazan, Azerbaijan)'),
    ('AZ-SUM', 'AZ-SUM (Sumgait, Azerbaijan)'),
    ('AZ-SUQ', 'AZ-SUQ (Sumqayit, Azerbaijan)'),
    ('AZ-TOV', 'AZ-TOV (Tovuz, Azerbaijan)'),
    ('AZ-XIR', 'AZ-XIR (Xirdalan, Azerbaijan)'),
    ('AZ-YAL', 'AZ-YAL (Yalama, Azerbaijan)'),
    ('AZ-ZAQ', 'AZ-ZAQ (Zaqatala, Azerbaijan)'),
    ('BA-BZJ', 'BA-BZJ (Blazuj, Sarajevo, Bosnia and Herzegovina)'),
    ('BA-BNX', 'BA-BNX (Banja Luka, Bosnia and Herzegovina)'),
    ('BA-BER', 'BA-BER (Berkovici, Bosnia and Herzegovina)'),
    ('BA-BHC', 'BA-BHC (Bihac, Bosnia and Herzegovina)'),
    ('BA-BJA', 'BA-BJA (Bijeljina, Bosnia and Herzegovina)'),
    ('BA-BIR', 'BA-BIR (Biracevac, Bosnia and Herzegovina)'),
    ('BA-BKR', 'BA-BKR (Bosanska Krupa, Bosnia and Herzegovina)'),
    ('BA-BBR', 'BA-BBR (Bosanski Brod (Srpski Brod), Bosnia and Herzegovina)'),
    ('BA-BPE', 'BA-BPE (Bosanski Petrovac, Bosnia and Herzegovina)'),
    ('BA-BKO', 'BA-BKO (Brcko, Bosnia and Herzegovina)'),
    ('BA-BUD', 'BA-BUD (Budinscina, Bosnia and Herzegovina)'),
    ('BA-BUG', 'BA-BUG (Bugojno, Bosnia and Herzegovina)'),
    ('BA-BAA', 'BA-BAA (Busovaca, Bosnia and Herzegovina)'),
    ('BA-4CA', 'BA-4CA (Cazin, Bosnia and Herzegovina)'),
    ('BA-CEL', 'BA-CEL (Celinac, Bosnia and Herzegovina)'),
    ('BA-CIT', 'BA-CIT (Citluk, Bosnia and Herzegovina)'),
    ('BA-DVA', 'BA-DVA (Derventa, Bosnia and Herzegovina)'),
    ('BA-DBJ', 'BA-DBJ (Doboj, Bosnia and Herzegovina)'),
    ('BA-DOJ', 'BA-DOJ (Domaljevac, Bosnia and Herzegovina)'),
    ('BA-DOV', 'BA-DOV (Donji Vakuf, Bosnia and Herzegovina)'),
    ('BA-DBA', 'BA-DBA (Dubica, Bosnia and Herzegovina)'),
    ('BA-DUK', 'BA-DUK (Durdevik, Bosnia and Herzegovina)'),
    ('BA-FOJ', 'BA-FOJ (Fojnica, Bosnia and Herzegovina)'),
    ('BA-GOZ', 'BA-GOZ (Gorazde, Bosnia and Herzegovina)'),
    ('BA-BGV', 'BA-BGV (Gornji Vakuf-Uskoplje, Bosnia and Herzegovina)'),
    ('BA-C6G', 'BA-C6G (Gracanica, Bosnia and Herzegovina)'),
    ('BA-GDC', 'BA-GDC (Gradacac, Bosnia and Herzegovina)'),
    ('BA-GDA', 'BA-GDA (Gradiska, Bosnia and Herzegovina)'),
    ('BA-GRU', 'BA-GRU (Grude, Bosnia and Herzegovina)'),
    ('BA-HDC', 'BA-HDC (Hadzici, Bosnia and Herzegovina)'),
    ('BA-HRE', 'BA-HRE (Hresa, Bosnia and Herzegovina)'),
    ('BA-JBA', 'BA-JBA (Jablanica, Bosnia and Herzegovina)'),
    ('BA-JAJ', 'BA-JAJ (Jajce, Bosnia and Herzegovina)'),
    ('BA-KAC', 'BA-KAC (Kacuni, Bosnia and Herzegovina)'),
    ('BA-KAJ', 'BA-KAJ (Kakanj, Bosnia and Herzegovina)'),
    ('BA-KSA', 'BA-KSA (Kalesija, Bosnia and Herzegovina)'),
    ('BA-KJK', 'BA-KJK (Kiseljak, Bosnia and Herzegovina)'),
    ('BA-KDJ', 'BA-KDJ (Kladanj, Bosnia and Herzegovina)'),
    ('BA-KLJ', 'BA-KLJ (Kljuc, Bosnia and Herzegovina)'),
    ('BA-KJC', 'BA-KJC (Konjic, Bosnia and Herzegovina)'),
    ('BA-KSO', 'BA-KSO (Kresevo, Bosnia and Herzegovina)'),
    ('BA-KNU', 'BA-KNU (Krupa na Uni, Bosnia and Herzegovina)'),
    ('BA-LTI', 'BA-LTI (Laktasi, Bosnia and Herzegovina)'),
    ('BA-LVO', 'BA-LVO (Livno, Bosnia and Herzegovina)'),
    ('BA-LBS', 'BA-LBS (Ljubuski, Bosnia and Herzegovina)'),
    ('BA-LKV', 'BA-LKV (Lukavac, Bosnia and Herzegovina)'),
    ('BA-MAG', 'BA-MAG (Maglaj, Bosnia and Herzegovina)'),
    ('BA-MZI', 'BA-MZI (Matuzici, Bosnia and Herzegovina)'),
    ('BA-MGE', 'BA-MGE (Medugorje, Bosnia and Herzegovina)'),
    ('BA-MOD', 'BA-MOD (Modrica, Bosnia and Herzegovina)'),
    ('BA-OMO', 'BA-OMO (Mostar, Bosnia and Herzegovina)'),
    ('BA-MRA', 'BA-MRA (Mravnjac, Bosnia and Herzegovina)'),
    ('BA-MGR', 'BA-MGR (Mrkonji Grad, Bosnia and Herzegovina)'),
    ('BA-NEM', 'BA-NEM (Neum, Bosnia and Herzegovina)'),
    ('BA-NEV', 'BA-NEV (Nevesinje, Bosnia and Herzegovina)'),
    ('BA-ORA', 'BA-ORA (Orasje, Bosnia and Herzegovina)'),
    ('BA-OSM', 'BA-OSM (Osmaci, Bosnia and Herzegovina)'),
    ('BA-OZM', 'BA-OZM (Ozimica, Bosnia and Herzegovina)'),
    ('BA-PAL', 'BA-PAL (Pale, Bosnia and Herzegovina)'),
    ('BA-PER', 'BA-PER (Perduhovo Selo, Bosnia and Herzegovina)'),
    ('BA-PSE', 'BA-PSE (Posusje, Bosnia and Herzegovina)'),
    ('BA-PDR', 'BA-PDR (Prijedor, Bosnia and Herzegovina)'),
    ('BA-PJR', 'BA-PJR (Prnjavor, Bosnia and Herzegovina)'),
    ('BA-RAJ', 'BA-RAJ (Rajlovac, Bosnia and Herzegovina)'),
    ('BA-SMT', 'BA-SMT (Sanski Most, Bosnia and Herzegovina)'),
    ('BA-SJJ', 'BA-SJJ (Sarajevo, Bosnia and Herzegovina)'),
    ('BA-SKV', 'BA-SKV (Sekovici, Bosnia and Herzegovina)'),
    ('BA-SIB', 'BA-SIB (Siroki Brijeg, Bosnia and Herzegovina)'),
    ('BA-SIC', 'BA-SIC (Srebrenica, Bosnia and Herzegovina)'),
    ('BA-SRB', 'BA-SRB (Srebrenik, Bosnia and Herzegovina)'),
    ('BA-SOR', 'BA-SOR (Srpsko Orasje, Bosnia and Herzegovina)'),
    ('BA-SJA', 'BA-SJA (Stijena, Bosnia and Herzegovina)'),
    ('BA-STC', 'BA-STC (Stolac, Bosnia and Herzegovina)'),
    ('BA-SUH', 'BA-SUH (Suha, Bosnia and Herzegovina)'),
    ('BA-TSJ', 'BA-TSJ (Tesanj, Bosnia and Herzegovina)'),
    ('BA-TLC', 'BA-TLC (Teslic, Bosnia and Herzegovina)'),
    ('BA-TIH', 'BA-TIH (Tihaljina, Bosnia and Herzegovina)'),
    ('BA-TOM', 'BA-TOM (Tomislavgrad, Bosnia and Herzegovina)'),
    ('BA-TNK', 'BA-TNK (Travnik, Bosnia and Herzegovina)'),
    ('BA-TBJ', 'BA-TBJ (Trebinje, Bosnia and Herzegovina)'),
    ('BA-TZL', 'BA-TZL (Tuzla, Bosnia and Herzegovina)'),
    ('BA-UJV', 'BA-UJV (Ugljevik, Bosnia and Herzegovina)'),
    ('BA-VKB', 'BA-VKB (Velika Kladusa, Bosnia and Herzegovina)'),
    ('BA-VIS', 'BA-VIS (Visoko, Bosnia and Herzegovina)'),
    ('BA-VIT', 'BA-VIT (Vitez, Bosnia and Herzegovina)'),
    ('BA-VGS', 'BA-VGS (Vogosca, Bosnia and Herzegovina)'),
    ('BA-ZAV', 'BA-ZAV (Zavidovici, Bosnia and Herzegovina)'),
    ('BA-ZCA', 'BA-ZCA (Zenica, Bosnia and Herzegovina)'),
    ('BA-ZEP', 'BA-ZEP (Zepce, Bosnia and Herzegovina)'),
    ('BA-ZNK', 'BA-ZNK (Zvornik, Bosnia and Herzegovina)'),
    ('BB-BGI', 'BB-BGI (Bridgetown, Barbados)'),
    ('BB-G5B', 'BB-G5B (Brighton, Barbados)'),
    ('BB-CCH', 'BB-CCH (Christ Church, Barbados)'),
    ('BB-H9G', 'BB-H9G (Edge Hill, Barbados)'),
    ('BB-HLT', 'BB-HLT (Holetown, Barbados)'),
    ('BB-JCK', 'BB-JCK (Jackson, Barbados)'),
    ('BB-NES', 'BB-NES (Nesfield, Barbados)'),
    ('BB-OST', 'BB-OST (Oistins, Barbados)'),
    ('BB-STM', 'BB-STM (Saint Michael, Barbados)'),
    ('BB-SPR', 'BB-SPR (Saint Peter, Barbados)'),
    ('BB-SAP', 'BB-SAP (Saint Philip, Barbados)'),
    ('BB-SLC', 'BB-SLC (Sam Lords Castle, Barbados)'),
    ('BB-SPT', 'BB-SPT (Speightstown, Barbados)'),
    ('BD-AKH', 'BD-AKH (Akhaura, Bangladesh)'),
    ('BD-ASJ', 'BD-ASJ (Ashuganj, Bangladesh)'),
    ('BD-BZL', 'BD-BZL (Barisal, Bangladesh)'),
    ('BD-BNP', 'BD-BNP (Benapole, Bangladesh)'),
    ('BD-BHL', 'BD-BHL (Bhola, Bangladesh)'),
    ('BD-BRG', 'BD-BRG (Bogura, Bangladesh)'),
    ('BD-CHL', 'BD-CHL (Chalna, Bangladesh)'),
    ('BD-CGP', 'BD-CGP (Chattogram, Bangladesh)'),
    ('BD-CDG', 'BD-CDG (Chuadanga, Bangladesh)'),
    ('BD-CXB', "BD-CXB (Cox's Bazar, Bangladesh)"),
    ('BD-CLA', 'BD-CLA (Cumilla, Bangladesh)'),
    ('BD-DAC', 'BD-DAC (Dhaka, Bangladesh)'),
    ('BD-FNI', 'BD-FNI (Feni, Bangladesh)'),
    ('BD-GAZ', 'BD-GAZ (Gazipur, Bangladesh)'),
    ('BD-GPG', 'BD-GPG (Gopalganj, Bangladesh)'),
    ('BD-IRD', 'BD-IRD (Ishurdi, Bangladesh)'),
    ('BD-JSR', 'BD-JSR (Jashore, Bangladesh)'),
    ('BD-KAM', 'BD-KAM (Kamalapur/Dhaka, Bangladesh)'),
    ('BD-KHL', 'BD-KHL (Khulna, Bangladesh)'),
    ('BD-KUS', 'BD-KUS (Kushtia, Bangladesh)'),
    ('BD-LAK', 'BD-LAK (Laksham, Bangladesh)'),
    ('BD-MNK', 'BD-MNK (Manikganj, Bangladesh)'),
    ('BD-MON', 'BD-MON (Monella, Bangladesh)'),
    ('BD-MGL', 'BD-MGL (Mongla, Bangladesh)'),
    ('BD-MBB', 'BD-MBB (Moulvi Bazar, Bangladesh)'),
    ('BD-MUN', 'BD-MUN (Munshiganj, Bangladesh)'),
    ('BD-MYM', 'BD-MYM (Mymensingh, Bangladesh)'),
    ('BD-NAR', 'BD-NAR (Narayanganj, Bangladesh)'),
    ('BD-DHA', 'BD-DHA (Narsingdi, Bangladesh)'),
    ('BD-PAN', 'BD-PAN (Pabna, Bangladesh)'),
    ('BD-PGN', 'BD-PGN (Pangaon, Bangladesh)'),
    ('BD-PAR', 'BD-PAR (Parbatipur, Bangladesh)'),
    ('BD-PAY', 'BD-PAY (Payra Port, Bangladesh)'),
    ('BD-RJH', 'BD-RJH (Rajshahi, Bangladesh)'),
    ('BD-RAU', 'BD-RAU (Rangpur, Bangladesh)'),
    ('BD-SPD', 'BD-SPD (Saidpur, Bangladesh)'),
    ('BD-SDW', 'BD-SDW (Sandwip, Bangladesh)'),
    ('BD-SAV', 'BD-SAV (Savar, Bangladesh)'),
    ('BD-ZHM', 'BD-ZHM (Shamshernagar, Bangladesh)'),
    ('BD-SSU', 'BD-SSU (Sherpur Sadar Upazila, Bangladesh)'),
    ('BD-SAJ', 'BD-SAJ (Sirajganj, Bangladesh)'),
    ('BD-ZYL', 'BD-ZYL (Sylhet, Bangladesh)'),
    ('BD-TEJ', 'BD-TEJ (Tejgaon, Bangladesh)'),
    ('BD-TKR', 'BD-TKR (Thakurgaon, Bangladesh)'),
    ('BE-GVO', "BE-GVO ('s Gravenvoeren, Limburg, Belgium)"),
    ('BE-GWE', "BE-GWE ('s-Gravenwezel, Antwerpen, Belgium)"),
    ('BE-ALB', 'BE-ALB (Aalbeke, West-Vlaanderen, Belgium)'),
    ('BE-AAB', 'BE-AAB (Aalst, Oost-Vlaanderen, Belgium)'),
    ('BE-AAL', 'BE-AAL (Aalter, Oost-Vlaanderen, Belgium)'),
    ('BE-AAS', 'BE-AAS (Aarschot, Vlaams Brabant, Belgium)'),
    ('BE-ARS', 'BE-ARS (Aarsele, West-Vlaanderen, Belgium)'),
    ('BE-ART', 'BE-ART (Aartrijke, West-Vlaanderen, Belgium)'),
    ('BE-AAR', 'BE-AAR (Aartselaar, Antwerpen, Belgium)'),
    ('BE-AHL', 'BE-AHL (Achel, Limburg, Belgium)'),
    ('BE-ACE', 'BE-ACE (Achet, Namur, Belgium)'),
    ('BE-ACH', 'BE-ACH (Achouffe, Luxembourg, Belgium)'),
    ('BE-AGE', 'BE-AGE (Adegem, Oost-Vlaanderen, Belgium)'),
    ('BE-ADK', 'BE-ADK (Adinkerke, West-Vlaanderen, Belgium)'),
    ('BE-AFF', 'BE-AFF (Affligem, Vlaams Brabant, Belgium)'),
    ('BE-AFN', 'BE-AFN (Afsnee, Oost-Vlaanderen, Belgium)'),
    ('BE-AGI', 'BE-AGI (Agimont, Namur, Belgium)'),
    ('BE-APE', 'BE-APE (Aiseau-Presles, Hainaut, Belgium)'),
    ('BE-ABK', 'BE-ABK (Aiseau-Presles, Hainaut, Belgium)'),
    ('BE-AKN', 'BE-AKN (Alken, Limburg, Belgium)'),
    ('BE-AEL', 'BE-AEL (Alleur, Liège, Belgium)'),
    ('BE-ASB', 'BE-ASB (Alsemberg, Vlaams Brabant, Belgium)'),
    ('BE-AVR', 'BE-AVR (Alveringem, West-Vlaanderen, Belgium)'),
    ('BE-AMY', 'BE-AMY (Amay, Liège, Belgium)'),
    ('BE-ABY', 'BE-ABY (Ambly, Luxembourg, Belgium)'),
    ('BE-AME', 'BE-AME (Amblève, Liège, Belgium)'),
    ('BE-AML', 'BE-AML (Amel, Liège, Belgium)'),
    ('BE-AOG', 'BE-AOG (Amougies, Hainaut, Belgium)'),
    ('BE-APS', 'BE-APS (Ampsin, Liège, Belgium)'),
    ('BE-AND', 'BE-AND (Andenne, Namur, Belgium)'),
    ('BE-ANL', 'BE-ANL (Andenne, Namur, Belgium)'),
    ('BE-ADU', 'BE-ADU (Anderlues, Hainaut, Belgium)'),
    ('BE-ANY', 'BE-ANY (Anderlues, Hainaut, Belgium)'),
    ('BE-AMO', 'BE-AMO (Andrimont, Liège, Belgium)'),
    ('BE-ANB', 'BE-ANB (Angleur, Liège, Belgium)'),
    ('BE-ANG', 'BE-ANG (Angreau, Hainaut, Belgium)'),
    ('BE-ANH', 'BE-ANH (Anhée, Namur, Belgium)'),
    ('BE-ALI', 'BE-ALI (Anlier, Luxembourg, Belgium)'),
    ('BE-AVE', 'BE-AVE (Annevoie, Namur, Belgium)'),
    ('BE-ANS', 'BE-ANS (Ans, Liège, Belgium)'),
    ('BE-ASR', 'BE-ASR (Anseremme, Namur, Belgium)'),
    ('BE-AHE', 'BE-AHE (Antheit, Liège, Belgium)'),
    ('BE-AIS', 'BE-AIS (Anthisnes, Liège, Belgium)'),
    ('BE-ATO', 'BE-ATO (Antoing, Hainaut, Belgium)'),
    ('BE-ANT', 'BE-ANT (Antwerp Churchill Terminal, Antwerpen, Belgium)'),
    ('BE-ANR', 'BE-ANR (Antwerpen, Antwerpen, Belgium)'),
    ('BE-AVG', 'BE-AVG (Antwerpen, Antwerpen, Belgium)'),
    ('BE-AZM', 'BE-AZM (Anzegem, West-Vlaanderen, Belgium)'),
    ('BE-APL', 'BE-APL (Appels, Oost-Vlaanderen, Belgium)'),
    ('BE-APT', 'BE-APT (Appelterre-Eichem, Oost-Vlaanderen, Belgium)'),
    ('BE-ABE', 'BE-ABE (Arbre, Hainaut, Belgium)'),
    ('BE-ACS', 'BE-ACS (Archennes, Brabant wallon, Belgium)'),
    ('BE-ADO', 'BE-ADO (Ardooie, West-Vlaanderen, Belgium)'),
    ('BE-AEJ', 'BE-AEJ (Arendonk, Antwerpen, Belgium)'),
    ('BE-AGT', 'BE-AGT (Argenteau, Liège, Belgium)'),
    ('BE-ARL', 'BE-ARL (Arlon, Luxembourg, Belgium)'),
    ('BE-AQE', 'BE-AQE (Arquennes, Hainaut, Belgium)'),
    ('BE-ASS', 'BE-ASS (As, Limburg, Belgium)'),
    ('BE-ASE', 'BE-ASE (Aspelare, Oost-Vlaanderen, Belgium)'),
    ('BE-ASP', 'BE-ASP (Asper, Oost-Vlaanderen, Belgium)'),
    ('BE-AES', 'BE-AES (Asse, Vlaams Brabant, Belgium)'),
    ('BE-ABR', 'BE-ABR (Assebroek, West-Vlaanderen, Belgium)'),
    ('BE-ANE', 'BE-ANE (Assenede, Oost-Vlaanderen, Belgium)'),
    ('BE-ASN', 'BE-ASN (Assesse, Namur, Belgium)'),
    ('BE-AST', 'BE-AST (Astene, Oost-Vlaanderen, Belgium)'),
    ('BE-ATH', 'BE-ATH (Ath, Hainaut, Belgium)'),
    ('BE-7PD', 'BE-7PD (Athis, Hainaut, Belgium)'),
    ('BE-AAT', 'BE-AAT (Athus, Luxembourg, Belgium)'),
    ('BE-AHO', 'BE-AHO (Attenhoven, Vlaams Brabant, Belgium)'),
    ('BE-ARO', 'BE-ARO (Attenrode, Vlaams Brabant, Belgium)'),
    ('BE-ATE', 'BE-ATE (Attert, Luxembourg, Belgium)'),
    ('BE-ARE', 'BE-ARE (Attre, Hainaut, Belgium)'),
    ('BE-AUG', 'BE-AUG (Aubange, Luxembourg, Belgium)'),
    ('BE-AUB', 'BE-AUB (Aubechies, Hainaut, Belgium)'),
    ('BE-AUL', 'BE-AUL (Aubel, Liège, Belgium)'),
    ('BE-AUY', 'BE-AUY (Aubel, Liège, Belgium)'),
    ('BE-ODE', 'BE-ODE (Aubel, Liège, Belgium)'),
    ('BE-ADI', 'BE-ADI (Audregnies, Hainaut, Belgium)'),
    ('BE-AVS', 'BE-AVS (Auvelais, Namur, Belgium)'),
    ('BE-AVL', 'BE-AVL (Avelgem, West-Vlaanderen, Belgium)'),
    ('BE-ABO', 'BE-ABO (Averbode, Vlaams Brabant, Belgium)'),
    ('BE-AWS', 'BE-AWS (Awans, Liège, Belgium)'),
    ('BE-W5R', 'BE-W5R (Awirs, Liège, Belgium)'),
    ('BE-AYW', 'BE-AYW (Aywaille, Liège, Belgium)'),
    ('BE-BAL', 'BE-BAL (Baal, Vlaams Brabant, Belgium)'),
    ('BE-BDE', 'BE-BDE (Baardegem, Oost-Vlaanderen, Belgium)'),
    ('BE-BHO', 'BE-BHO (Baarle-Hertog, Antwerpen, Belgium)'),
    ('BE-BSR', 'BE-BSR (Baasrode, Oost-Vlaanderen, Belgium)'),
    ('BE-BLN', 'BE-BLN (Baelen, Liège, Belgium)'),
    ('BE-BAX', 'BE-BAX (Baileux, Hainaut, Belgium)'),
    ('BE-BAI', 'BE-BAI (Baileux, Hainaut, Belgium)'),
    ('BE-BYT', 'BE-BYT (Baisy-Thy, Brabant wallon, Belgium)'),
    ('BE-BLE', 'BE-BLE (Balen, Antwerpen, Belgium)'),
    ('BE-BGK', 'BE-BGK (Balgerhoek, Oost-Vlaanderen, Belgium)'),
    ('BE-BND', 'BE-BND (Bande, Luxembourg, Belgium)'),
    ('BE-BNN', 'BE-BNN (Banneux, Liège, Belgium)'),
    ('BE-BCN', 'BE-BCN (Barchon, Liège, Belgium)'),
    ('BE-BRV', 'BE-BRV (Baronville, Namur, Belgium)'),
    ('BE-BAY', 'BE-BAY (Barry, Hainaut, Belgium)'),
    ('BE-BOA', 'BE-BOA (Bas-Oha, Liège, Belgium)'),
    ('BE-BWA', 'BE-BWA (Bas-Warneton, Hainaut, Belgium)'),
    ('BE-BBX', 'BE-BBX (Basse-Bodeux, Liège, Belgium)'),
    ('BE-BTS', 'BE-BTS (Bassenge (Bitsingen), Liège, Belgium)'),
    ('BE-BSV', 'BE-BSV (Bassevelde, Oost-Vlaanderen, Belgium)'),
    ('BE-BSY', 'BE-BSY (Bassilly, Hainaut, Belgium)'),
    ('BE-BSG', 'BE-BSG (Bastogne, Luxembourg, Belgium)'),
    ('BE-BES', 'BE-BES (Basècles, Hainaut, Belgium)'),
    ('BE-BAT', 'BE-BAT (Battel, Antwerpen, Belgium)'),
    ('BE-BTC', 'BE-BTC (Battice, Liège, Belgium)'),
    ('BE-BDU', 'BE-BDU (Baudour, Hainaut, Belgium)'),
    ('BE-BGI', 'BE-BGI (Baugnies, Hainaut, Belgium)'),
    ('BE-BAS', 'BE-BAS (Baulers, Brabant wallon, Belgium)'),
    ('BE-BVG', 'BE-BVG (Bavegem, Oost-Vlaanderen, Belgium)'),
    ('BE-BAV', 'BE-BAV (Bavikhove, West-Vlaanderen, Belgium)'),
    ('BE-BAZ', 'BE-BAZ (Bazel, Oost-Vlaanderen, Belgium)'),
    ('BE-BFY', 'BE-BFY (Beaufays, Liège, Belgium)'),
    ('BE-BEA', 'BE-BEA (Beaumont, Hainaut, Belgium)'),
    ('BE-BUR', 'BE-BUR (Beauraing, Namur, Belgium)'),
    ('BE-BVC', 'BE-BVC (Beauvechain, Brabant wallon, Belgium)'),
    ('BE-BWZ', 'BE-BWZ (Beauwelz, Hainaut, Belgium)'),
    ('BE-BCS', 'BE-BCS (Beclers, Hainaut, Belgium)'),
    ('BE-BRM', 'BE-BRM (Beernem, West-Vlaanderen, Belgium)'),
    ('BE-BER', 'BE-BER (Beerse, Antwerpen, Belgium)'),
    ('BE-BEE', 'BE-BEE (Beersel, Vlaams Brabant, Belgium)'),
    ('BE-BSZ', 'BE-BSZ (Beerst, West-Vlaanderen, Belgium)'),
    ('BE-BTE', 'BE-BTE (Beert, Vlaams Brabant, Belgium)'),
    ('BE-BVD', 'BE-BVD (Beervelde, Oost-Vlaanderen, Belgium)'),
    ('BE-BEZ', 'BE-BEZ (Beez, Namur, Belgium)'),
    ('BE-BGY', 'BE-BGY (Begijnendijk, Vlaams Brabant, Belgium)'),
    ('BE-BEH', 'BE-BEH (Beho, Luxembourg, Belgium)'),
    ('BE-BEI', 'BE-BEI (Beigem, Vlaams Brabant, Belgium)'),
    ('BE-BKO', 'BE-BKO (Bekkevoort, Vlaams Brabant, Belgium)'),
    ('BE-BLK', 'BE-BLK (Belgiek, West-Vlaanderen, Belgium)'),
    ('BE-BGA', 'BE-BGA (Belgrade, Namur, Belgium)'),
    ('BE-BCR', 'BE-BCR (Bellecourt, Hainaut, Belgium)'),
    ('BE-BGE', 'BE-BGE (Bellegem, West-Vlaanderen, Belgium)'),
    ('BE-BEM', 'BE-BEM (Bellem, Oost-Vlaanderen, Belgium)'),
    ('BE-BVX', 'BE-BVX (Bellevaux, Luxembourg, Belgium)'),
    ('BE-BLI', 'BE-BLI (Bellingen, Vlaams Brabant, Belgium)'),
    ('BE-BLO', 'BE-BLO (Beloeil, Hainaut, Belgium)'),
    ('BE-BSL', 'BE-BSL (Belsele, Oost-Vlaanderen, Belgium)'),
    ('BE-BAN', 'BE-BAN (Ben-Ahin, Liège, Belgium)'),
    ('BE-BEN', 'BE-BEN (Bende, Luxembourg, Belgium)'),
    ('BE-BCM', 'BE-BCM (Berchem, Oost-Vlaanderen, Belgium)'),
    ('BE-BPC', 'BE-BPC (Berchem, Antwerpen, Belgium)'),
    ('BE-BRT', 'BE-BRT (Berendrecht, Antwerpen, Belgium)'),
    ('BE-VBN', 'BE-VBN (Berendrecht, Antwerpen, Belgium)'),
    ('BE-GOM', 'BE-GOM (Bergom, Antwerpen, Belgium)'),
    ('BE-RIN', 'BE-RIN (Beringen, Limburg, Belgium)'),
    ('BE-BAR', 'BE-BAR (Berlaar, Antwerpen, Belgium)'),
    ('BE-BRL', 'BE-BRL (Berlare, Oost-Vlaanderen, Belgium)'),
    ('BE-LRZ', 'BE-LRZ (Berloz, Liège, Belgium)'),
    ('BE-BNU', 'BE-BNU (Berneau, Liège, Belgium)'),
    ('BE-ABC', 'BE-ABC (Bernissart, Hainaut, Belgium)'),
    ('BE-BTM', 'BE-BTM (Bertem, Vlaams Brabant, Belgium)'),
    ('BE-BTO', 'BE-BTO (Bertogne, Luxembourg, Belgium)'),
    ('BE-BTX', 'BE-BTX (Bertrix, Luxembourg, Belgium)'),
    ('BE-BZE', 'BE-BZE (Berzée, Namur, Belgium)'),
    ('BE-BR3', 'BE-BR3 (Beselare, West-Vlaanderen, Belgium)'),
    ('BE-BET', 'BE-BET (Bettincourt, Liège, Belgium)'),
    ('BE-BVL', 'BE-BVL (Bettincourt, Liège, Belgium)'),
    ('BE-BVE', 'BE-BVE (Bever, Vlaams Brabant, Belgium)'),
    ('BE-BEV', 'BE-BEV (Beveren, West-Vlaanderen, Belgium)'),
    ('BE-BEL', 'BE-BEL (Beveren Leie, West-Vlaanderen, Belgium)'),
    ('BE-BIZ', 'BE-BIZ (Beveren-aan-den-Ijzer, West-Vlaanderen, Belgium)'),
    ('BE-BWS', 'BE-BWS (Beveren-Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-BVO', 'BE-BVO (Beverlo, Limburg, Belgium)'),
    ('BE-BYE', 'BE-BYE (Beyne-Heusay, Liège, Belgium)'),
    ('BE-BHA', 'BE-BHA (Bienne-lez-Happart, Hainaut, Belgium)'),
    ('BE-BKE', 'BE-BKE (Bierbeek, Vlaams Brabant, Belgium)'),
    ('BE-BCE', 'BE-BCE (Biercée, Hainaut, Belgium)'),
    ('BE-BIE', 'BE-BIE (Bierges, Brabant wallon, Belgium)'),
    ('BE-BIH', 'BE-BIH (Bierges, Brabant wallon, Belgium)'),
    ('BE-BST', 'BE-BST (Bierset, Liège, Belgium)'),
    ('BE-BQE', 'BE-BQE (Biesme, Namur, Belgium)'),
    ('BE-BUN', 'BE-BUN (Biesme-sous-Thuin, Hainaut, Belgium)'),
    ('BE-BSN', 'BE-BSN (Bilstain, Liège, Belgium)'),
    ('BE-BLZ', 'BE-BLZ (Bilzen, Limburg, Belgium)'),
    ('BE-BCI', 'BE-BCI (Binche, Hainaut, Belgium)'),
    ('BE-BKM', 'BE-BKM (Binkom, Vlaams Brabant, Belgium)'),
    ('BE-BSE', 'BE-BSE (Bissegem, West-Vlaanderen, Belgium)'),
    ('BE-BTS', 'BE-BTS (Bitsingen (Bassenge), Liège, Belgium)'),
    ('BE-BZI', 'BE-BZI (Bizet, Hainaut, Belgium)'),
    ('BE-BIV', 'BE-BIV (Bièvre, Namur, Belgium)'),
    ('BE-BAD', 'BE-BAD (Blaasveld, Antwerpen, Belgium)'),
    ('BE-BIM', 'BE-BIM (Blaimont, Namur, Belgium)'),
    ('BE-BDI', 'BE-BDI (Blandain, Hainaut, Belgium)'),
    ('BE-BLD', 'BE-BLD (Blanden, Vlaams Brabant, Belgium)'),
    ('BE-BBG', 'BE-BBG (Blankenberge, West-Vlaanderen, Belgium)'),
    ('BE-WHT', 'BE-WHT (Blaregnies, Hainaut, Belgium)'),
    ('BE-BLT', 'BE-BLT (Blaton, Hainaut, Belgium)'),
    ('BE-BNY', 'BE-BNY (Blegny, Liège, Belgium)'),
    ('BE-BQY', 'BE-BQY (Blicquy, Hainaut, Belgium)'),
    ('BE-BHR', 'BE-BHR (Bléharies, Hainaut, Belgium)'),
    ('BE-BOC', 'BE-BOC (Bocholt, Limburg, Belgium)'),
    ('BE-BCT', 'BE-BCT (Boechout, Antwerpen, Belgium)'),
    ('BE-BHE', 'BE-BHE (Boekhoute, Oost-Vlaanderen, Belgium)'),
    ('BE-BZG', 'BE-BZG (Boezinge, West-Vlaanderen, Belgium)'),
    ('BE-BOH', 'BE-BOH (Bohan, Namur, Belgium)'),
    ('BE-BDH', "BE-BDH (Bois-d'Haine, Hainaut, Belgium)"),
    ('BE-SLI', 'BE-SLI (Bois-de-Lessines, Hainaut, Belgium)'),
    ('BE-BDV', 'BE-BDV (Bois-De-Villers, Namur, Belgium)'),
    ('BE-BOL', 'BE-BOL (Bolland, Liège, Belgium)'),
    ('BE-BMA', 'BE-BMA (Bomal, Luxembourg, Belgium)'),
    ('BE-BBY', 'BE-BBY (Bombaye, Liège, Belgium)'),
    ('BE-BSO', 'BE-BSO (Bon-Secours, Hainaut, Belgium)'),
    ('BE-BNI', 'BE-BNI (Bonheiden, Antwerpen, Belgium)'),
    ('BE-BNO', 'BE-BNO (Boninne, Namur, Belgium)'),
    ('BE-BOS', 'BE-BOS (Booischot, Antwerpen, Belgium)'),
    ('BE-BOM', 'BE-BOM (Boom, Antwerpen, Belgium)'),
    ('BE-BOO', 'BE-BOO (Boorsem, Limburg, Belgium)'),
    ('BE-BMB', 'BE-BMB (Boortmeerbeek, Vlaams Brabant, Belgium)'),
    ('BE-BTK', 'BE-BTK (Borchtlombeek, Vlaams Brabant, Belgium)'),
    ('BE-BOR', 'BE-BOR (Borgerhout, Antwerpen, Belgium)'),
    ('BE-BOG', 'BE-BOG (Borgloon, Limburg, Belgium)'),
    ('BE-BRO', 'BE-BRO (Borlo, Limburg, Belgium)'),
    ('BE-BLX', 'BE-BLX (Borlon, Luxembourg, Belgium)'),
    ('BE-BNR', 'BE-BNR (Born, Liège, Belgium)'),
    ('BE-BON', 'BE-BON (Bornem, Antwerpen, Belgium)'),
    ('BE-BVA', 'BE-BVA (Bornival, Brabant wallon, Belgium)'),
    ('BE-BSB', 'BE-BSB (Borsbeek, Antwerpen, Belgium)'),
    ('BE-BRK', 'BE-BRK (Borsbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-BRI', 'BE-BRI (Bossière, Namur, Belgium)'),
    ('BE-BSU', 'BE-BSU (Bossuit, West-Vlaanderen, Belgium)'),
    ('BE-BTY', 'BE-BTY (Bothey, Namur, Belgium)'),
    ('BE-QW2', 'BE-QW2 (Bouffioulx, Hainaut, Belgium)'),
    ('BE-BUG', 'BE-BUG (Bouge, Namur, Belgium)'),
    ('BE-BO2', 'BE-BO2 (Bougnies, Hainaut, Belgium)'),
    ('BE-BUO', 'BE-BUO (Bouillon, Luxembourg, Belgium)'),
    ('BE-BLS', 'BE-BLS (Bourlers, Hainaut, Belgium)'),
    ('BE-BOT', 'BE-BOT (Boussoit, Hainaut, Belgium)'),
    ('BE-BSS', 'BE-BSS (Boussu, Hainaut, Belgium)'),
    ('BE-BOU', 'BE-BOU (Bousval, Brabant wallon, Belgium)'),
    ('BE-BUM', 'BE-BUM (Boutersem, Vlaams Brabant, Belgium)'),
    ('BE-BVM', 'BE-BVM (Bouvignes-sur-Meuse, Namur, Belgium)'),
    ('BE-BVI', 'BE-BVI (Bouvignies, Hainaut, Belgium)'),
    ('BE-BWE', 'BE-BWE (Bouwel, Antwerpen, Belgium)'),
    ('BE-BHH', 'BE-BHH (Bovekerke, West-Vlaanderen, Belgium)'),
    ('BE-BVS', 'BE-BVS (Bovesse, Namur, Belgium)'),
    ('BE-BVY', 'BE-BVY (Bovigny, Luxembourg, Belgium)'),
    ('BE-BFE', 'BE-BFE (Braffe, Hainaut, Belgium)'),
    ('BE-BLA', "BE-BLA (Braine-l'Alleud, Brabant wallon, Belgium)"),
    ('BE-BLC', 'BE-BLC (Braine-le-Château, Brabant wallon, Belgium)'),
    ('BE-BCO', 'BE-BCO (Braine-le-Comte, Hainaut, Belgium)'),
    ('BE-BRS', 'BE-BRS (Braives, Liège, Belgium)'),
    ('BE-BAK', 'BE-BAK (Brakel, Oost-Vlaanderen, Belgium)'),
    ('BE-BMI', 'BE-BMI (Brasmenil, Hainaut, Belgium)'),
    ('BE-BRA', 'BE-BRA (Brasschaat, Antwerpen, Belgium)'),
    ('BE-BRC', 'BE-BRC (Brecht, Antwerpen, Belgium)'),
    ('BE-BIR', 'BE-BIR (Bredene, West-Vlaanderen, Belgium)'),
    ('BE-BRE', 'BE-BRE (Bree, Limburg, Belgium)'),
    ('BE-BRN', 'BE-BRN (Breendonk, Antwerpen, Belgium)'),
    ('BE-BSX', 'BE-BSX (Bressoux, Liège, Belgium)'),
    ('BE-BGN', 'BE-BGN (Briegden, Limburg, Belgium)'),
    ('BE-OBC', 'BE-OBC (Broechem, Antwerpen, Belgium)'),
    ('BE-BGO', 'BE-BGO (Brucargo, Vlaams Brabant, Belgium)'),
    ('BE-BRG', 'BE-BRG (Brugelette, Hainaut, Belgium)'),
    ('BE-BGS', 'BE-BGS (Brugge (Bruges), West-Vlaanderen, Belgium)'),
    ('BE-BNA', 'BE-BNA (Brunehault, Hainaut, Belgium)'),
    ('BE-BHT', 'BE-BHT (Brunehaut, Hainaut, Belgium)'),
    ('BE-BSM', 'BE-BSM (Brussegem, Vlaams Brabant, Belgium)'),
    ('BE-BRU', 'BE-BRU (Brussegem, Vlaams Brabant, Belgium)'),
    ('BE-BRU', 'BE-BRU (Brussegem, Vlaams Brabant, Belgium)'),
    ('BE-BRY', 'BE-BRY (Bruyelle, Hainaut, Belgium)'),
    ('BE-BYR', 'BE-BYR (Brye, Hainaut, Belgium)'),
    ('BE-BHU', 'BE-BHU (Buggenhout, Oost-Vlaanderen, Belgium)'),
    ('BE-BUS', 'BE-BUS (Buissenal, Hainaut, Belgium)'),
    ('BE-BUZ', 'BE-BUZ (Buizingen, Vlaams Brabant, Belgium)'),
    ('BE-BUL', 'BE-BUL (Bullange, Liège, Belgium)'),
    ('BE-BL7', 'BE-BL7 (Bullingen, Liège, Belgium)'),
    ('BE-BUD', 'BE-BUD (Burcht, Antwerpen, Belgium)'),
    ('BE-BRD', 'BE-BRD (Burdinne, Liège, Belgium)'),
    ('BE-BGU', 'BE-BGU (Burg-Reuland, Liège, Belgium)'),
    ('BE-BUY', 'BE-BUY (Bury, Hainaut, Belgium)'),
    ('BE-BGH', 'BE-BGH (Butgenbach, Liège, Belgium)'),
    ('BE-BUV', 'BE-BUV (Buvingen, Limburg, Belgium)'),
    ('BE-BVU', 'BE-BVU (Buvrinnes, Hainaut, Belgium)'),
    ('BE-BZO', 'BE-BZO (Buzenol, Luxembourg, Belgium)'),
    ('BE-CAL', 'BE-CAL (Callenelle, Hainaut, Belgium)'),
    ('BE-CLN', 'BE-CLN (Calonne, Hainaut, Belgium)'),
    ('BE-KAN', 'BE-KAN (Canne (Kanne), Limburg, Belgium)'),
    ('BE-CNR', 'BE-CNR (Carnières, Hainaut, Belgium)'),
    ('BE-CAS', 'BE-CAS (Casteau, Hainaut, Belgium)'),
    ('BE-CEL', 'BE-CEL (Celles, Namur, Belgium)'),
    ('BE-CLE', 'BE-CLE (Celles, Hainaut, Belgium)'),
    ('BE-CEX', 'BE-CEX (Cerexhe-Heuseux, Liège, Belgium)'),
    ('BE-CAD', 'BE-CAD (Cerfontaine, Namur, Belgium)'),
    ('BE-CNX', 'BE-CNX (Chaineux, Liège, Belgium)'),
    ('BE-CPI', 'BE-CPI (Champion, Namur, Belgium)'),
    ('BE-CPO', 'BE-CPO (Champlon, Luxembourg, Belgium)'),
    ('BE-CLY', 'BE-CLY (Chanly, Luxembourg, Belgium)'),
    ('BE-CME', 'BE-CME (Chantemelle, Luxembourg, Belgium)'),
    ('BE-CHO', 'BE-CHO (Chapelle-lez-Herlaimont, Hainaut, Belgium)'),
    ('BE-CLO', 'BE-CLO (Chapelle-à-Oie, Hainaut, Belgium)'),
    ('BE-CWA', 'BE-CWA (Chapelle-à-Wattines, Hainaut, Belgium)'),
    ('BE-CRL', 'BE-CRL (Charleroi, Hainaut, Belgium)'),
    ('BE-CAX', 'BE-CAX (Charneux, Liège, Belgium)'),
    ('BE-CPE', 'BE-CPE (Chassepierre, Luxembourg, Belgium)'),
    ('BE-CAR', 'BE-CAR (Chastre, Brabant wallon, Belgium)'),
    ('BE-CFO', 'BE-CFO (Chaudfontaine, Liège, Belgium)'),
    ('BE-CGX', 'BE-CGX (Chaumont-Gistoux, Brabant wallon, Belgium)'),
    ('BE-CNO', 'BE-CNO (Chaussée-Notre-Dame-Louvignies, Hainaut, Belgium)'),
    ('BE-CRI', 'BE-CRI (Cherain, Luxembourg, Belgium)'),
    ('BE-CRA', 'BE-CRA (Cheratte, Liège, Belgium)'),
    ('BE-CRQ', 'BE-CRQ (Chercq, Hainaut, Belgium)'),
    ('BE-CTA', 'BE-CTA (Chertal, Liège, Belgium)'),
    ('BE-CHM', 'BE-CHM (Chimay, Hainaut, Belgium)'),
    ('BE-CBF', 'BE-CBF (Chiny, Luxembourg, Belgium)'),
    ('BE-CHI', 'BE-CHI (Chièvres, Hainaut, Belgium)'),
    ('BE-CQR', 'BE-CQR (Chokier, Liège, Belgium)'),
    ('BE-CHA', 'BE-CHA (Châtelet, Hainaut, Belgium)'),
    ('BE-CTL', 'BE-CTL (Châtelineau, Hainaut, Belgium)'),
    ('BE-CHE', 'BE-CHE (Chênée, Liège, Belgium)'),
    ('BE-CNY', 'BE-CNY (Ciney, Namur, Belgium)'),
    ('BE-CPY', 'BE-CPY (Ciply, Hainaut, Belgium)'),
    ('BE-CBQ', 'BE-CBQ (Clabecq, Brabant wallon, Belgium)'),
    ('BE-CLA', 'BE-CLA (Clavier, Liège, Belgium)'),
    ('BE-CLM', 'BE-CLM (Clermont, Namur, Belgium)'),
    ('BE-CGE', 'BE-CGE (Cognelée, Namur, Belgium)'),
    ('BE-CFA', 'BE-CFA (Colfontaine, Hainaut, Belgium)'),
    ('BE-CPN', 'BE-CPN (Comblain-au-Pont, Liège, Belgium)'),
    ('BE-COM', 'BE-COM (Comines, Hainaut, Belgium)'),
    ('BE-CRB', 'BE-CRB (Corbais, Brabant wallon, Belgium)'),
    ('BE-CBI', 'BE-CBI (Corbion, Luxembourg, Belgium)'),
    ('BE-CCA', 'BE-CCA (Corroy-le-Château, Namur, Belgium)'),
    ('BE-CIG', 'BE-CIG (Corroy-le-Grand, Brabant wallon, Belgium)'),
    ('BE-COU', 'BE-COU (Couillet, Hainaut, Belgium)'),
    ('BE-CCS', 'BE-CCS (Courcelles, Hainaut, Belgium)'),
    ('BE-CRE', 'BE-CRE (Courrière, Namur, Belgium)'),
    ('BE-CET', 'BE-CET (Court-Saint-Étienne, Brabant wallon, Belgium)'),
    ('BE-COH', 'BE-COH (Couthuin, Liège, Belgium)'),
    ('BE-CUV', 'BE-CUV (Couvin, Namur, Belgium)'),
    ('BE-CSI', 'BE-CSI (Crisnée, Liège, Belgium)'),
    ('BE-CRO', 'BE-CRO (Crombach, Liège, Belgium)'),
    ('BE-CRU', 'BE-CRU (Crupet, Namur, Belgium)'),
    ('BE-CUS', 'BE-CUS (Cuesmes, Hainaut, Belgium)'),
    ('BE-CUT', 'BE-CUT (Custinne, Namur, Belgium)'),
    ('BE-CRY', 'BE-CRY (Céroux-Mousty, Brabant wallon, Belgium)'),
    ('BE-DGX', 'BE-DGX (Dadizele, West-Vlaanderen, Belgium)'),
    ('BE-DKN', 'BE-DKN (Daknam, Oost-Vlaanderen, Belgium)'),
    ('BE-DAL', 'BE-DAL (Dalhem, Liège, Belgium)'),
    ('BE-DMM', 'BE-DMM (Damme, West-Vlaanderen, Belgium)'),
    ('BE-DPY', 'BE-DPY (Dampremy, Hainaut, Belgium)'),
    ('BE-DRI', 'BE-DRI (Darion, Liège, Belgium)'),
    ('BE-DAX', 'BE-DAX (Daussoulx, Namur, Belgium)'),
    ('BE-DAV', 'BE-DAV (Dave, Namur, Belgium)'),
    ('BE-DVI', 'BE-DVI (Daverdisse, Luxembourg, Belgium)'),
    ('BE-DHA', 'BE-DHA (De Haan, West-Vlaanderen, Belgium)'),
    ('BE-DEK', 'BE-DEK (De Klinge, Oost-Vlaanderen, Belgium)'),
    ('BE-DPA', 'BE-DPA (De Panne, West-Vlaanderen, Belgium)'),
    ('BE-DPE', 'BE-DPE (De Pinte, Oost-Vlaanderen, Belgium)'),
    ('BE-DJK', 'BE-DJK (Deerlijk, West-Vlaanderen, Belgium)'),
    ('BE-DEZ', 'BE-DEZ (Deinze, Oost-Vlaanderen, Belgium)'),
    ('BE-DNB', 'BE-DNB (Denderbelle, Oost-Vlaanderen, Belgium)'),
    ('BE-IAI', 'BE-IAI (Denderhoutem, Oost-Vlaanderen, Belgium)'),
    ('BE-DRW', 'BE-DRW (Denderleeuw, Oost-Vlaanderen, Belgium)'),
    ('BE-DDR', 'BE-DDR (Dendermonde, Oost-Vlaanderen, Belgium)'),
    ('BE-DND', 'BE-DND (Denderwindeke, Oost-Vlaanderen, Belgium)'),
    ('BE-DTE', 'BE-DTE (Dentergem, West-Vlaanderen, Belgium)'),
    ('BE-DGU', 'BE-DGU (Dergneau, Hainaut, Belgium)'),
    ('BE-DSE', 'BE-DSE (Dessel, Antwerpen, Belgium)'),
    ('BE-DSL', 'BE-DSL (Desselgem, West-Vlaanderen, Belgium)'),
    ('BE-DES', 'BE-DES (Destelbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-DTO', 'BE-DTO (Desteldonk, Oost-Vlaanderen, Belgium)'),
    ('BE-DEU', 'BE-DEU (Deurle, Oost-Vlaanderen, Belgium)'),
    ('BE-DEG', 'BE-DEG (Deurne, Antwerpen, Belgium)'),
    ('BE-DXN', 'BE-DXN (Deux-Acren, Hainaut, Belgium)'),
    ('BE-DGB', 'BE-DGB (Diegem, Vlaams Brabant, Belgium)'),
    ('BE-DPK', 'BE-DPK (Diepenbeek, Limburg, Belgium)'),
    ('BE-DIE', 'BE-DIE (Diest, Vlaams Brabant, Belgium)'),
    ('BE-DIK', 'BE-DIK (Diksmuide, West-Vlaanderen, Belgium)'),
    ('BE-DBK', 'BE-DBK (Dilbeek, Vlaams Brabant, Belgium)'),
    ('BE-DLS', 'BE-DLS (Dilsen, Limburg, Belgium)'),
    ('BE-DSO', 'BE-DSO (Dilsen-Stokkem, Limburg, Belgium)'),
    ('BE-DIA', 'BE-DIA (Dinant, Namur, Belgium)'),
    ('BE-DIO', 'BE-DIO (Dion, Namur, Belgium)'),
    ('BE-DIS', 'BE-DIS (Dison, Liège, Belgium)'),
    ('BE-DEL', 'BE-DEL (Doel, Oost-Vlaanderen, Belgium)'),
    ('BE-DOH', 'BE-DOH (Dohan, Luxembourg, Belgium)'),
    ('BE-DOI', 'BE-DOI (Doische, Namur, Belgium)'),
    ('BE-DOL', 'BE-DOL (Dolembreux, Liège, Belgium)'),
    ('BE-DCE', 'BE-DCE (Donceel, Liège, Belgium)'),
    ('BE-DON', 'BE-DON (Donk, Limburg, Belgium)'),
    ('BE-DSI', 'BE-DSI (Donstiennes, Hainaut, Belgium)'),
    ('BE-TRN', 'BE-TRN (Doornik (Tournai), Hainaut, Belgium)'),
    ('BE-DOE', 'BE-DOE (Doornzele, Oost-Vlaanderen, Belgium)'),
    ('BE-DTS', 'BE-DTS (Dottignies, Hainaut, Belgium)'),
    ('BE-DOU', 'BE-DOU (Dour, Hainaut, Belgium)'),
    ('BE-DRA', 'BE-DRA (Dranouter, West-Vlaanderen, Belgium)'),
    ('BE-DRB', 'BE-DRB (Drogenbos, Vlaams Brabant, Belgium)'),
    ('BE-DGN', 'BE-DGN (Drongen, Oost-Vlaanderen, Belgium)'),
    ('BE-DUD', 'BE-DUD (Dudzele, West-Vlaanderen, Belgium)'),
    ('BE-DUF', 'BE-DUF (Duffel, Antwerpen, Belgium)'),
    ('BE-DUR', 'BE-DUR (Duras, Limburg, Belgium)'),
    ('BE-DUY', 'BE-DUY (Durbuy, Luxembourg, Belgium)'),
    ('BE-DWP', 'BE-DWP (Dworp, Vlaams Brabant, Belgium)'),
    ('BE-9IR', 'BE-9IR (Eben-Emael, Liège, Belgium)'),
    ('BE-EGM', 'BE-EGM (Edegem, Antwerpen, Belgium)'),
    ('BE-EEK', 'BE-EEK (Eeklo, Oost-Vlaanderen, Belgium)'),
    ('BE-EEM', 'BE-EEM (Eeklo, Oost-Vlaanderen, Belgium)'),
    ('BE-EBZ', 'BE-EBZ (Eigenbilzen, Limburg, Belgium)'),
    ('BE-EHT', 'BE-EHT (Eindhout, Antwerpen, Belgium)'),
    ('BE-EIN', 'BE-EIN (Eine, Oost-Vlaanderen, Belgium)'),
    ('BE-ESD', 'BE-ESD (Eisden, Limburg, Belgium)'),
    ('BE-EQE', 'BE-EQE (Eke, Oost-Vlaanderen, Belgium)'),
    ('BE-EKE', 'BE-EKE (Ekeren, Antwerpen, Belgium)'),
    ('BE-EKS', 'BE-EKS (Eksaarde, Oost-Vlaanderen, Belgium)'),
    ('BE-EKL', 'BE-EKL (Eksel, Limburg, Belgium)'),
    ('BE-EWI', 'BE-EWI (Elewijt, Vlaams Brabant, Belgium)'),
    ('BE-ELI', 'BE-ELI (Elingen, Vlaams Brabant, Belgium)'),
    ('BE-EZS', 'BE-EZS (Ellezelles, Hainaut, Belgium)'),
    ('BE-ESA', 'BE-ESA (Ellignies-Sainte-Anne, Hainaut, Belgium)'),
    ('BE-ESB', 'BE-ESB (Elsenborn, Liège, Belgium)'),
    ('BE-ESE', 'BE-ESE (Elsenborn, Liège, Belgium)'),
    ('BE-EVE', 'BE-EVE (Elverdinge, West-Vlaanderen, Belgium)'),
    ('BE-EEE', 'BE-EEE (Elversele, Oost-Vlaanderen, Belgium)'),
    ('BE-EBM', 'BE-EBM (Emblem, Antwerpen, Belgium)'),
    ('BE-EBU', 'BE-EBU (Embourg, Liège, Belgium)'),
    ('BE-EPI', 'BE-EPI (Emptinne, Namur, Belgium)'),
    ('BE-EAM', 'BE-EAM (Ename, Oost-Vlaanderen, Belgium)'),
    ('BE-EGI', 'BE-EGI (Enghien, Hainaut, Belgium)'),
    ('BE-ENG', 'BE-ENG (Engis, Liège, Belgium)'),
    ('BE-ENS', 'BE-ENS (Engis, Liège, Belgium)'),
    ('BE-EPG', 'BE-EPG (Eppegem, Vlaams Brabant, Belgium)'),
    ('BE-ERM', 'BE-ERM (Erembodegem, Oost-Vlaanderen, Belgium)'),
    ('BE-EBI', 'BE-EBI (Ermeton-sur-Biert, Namur, Belgium)'),
    ('BE-ENU', 'BE-ENU (Erneuville, Luxembourg, Belgium)'),
    ('BE-ERP', 'BE-ERP (Erpe-Mere, Oost-Vlaanderen, Belgium)'),
    ('BE-EPT', 'BE-EPT (Erpent, Namur, Belgium)'),
    ('BE-EPN', 'BE-EPN (Erpion, Hainaut, Belgium)'),
    ('BE-ESK', 'BE-ESK (Erps-Kwerps, Vlaams Brabant, Belgium)'),
    ('BE-REQ', 'BE-REQ (Erquelinnes, Hainaut, Belgium)'),
    ('BE-ERE', 'BE-ERE (Ertvelde, Oost-Vlaanderen, Belgium)'),
    ('BE-EFS', 'BE-EFS (Escanaffles, Hainaut, Belgium)'),
    ('BE-ESN', 'BE-ESN (Escanaffles, Hainaut, Belgium)'),
    ('BE-ESX', 'BE-ESX (Esneux, Liège, Belgium)'),
    ('BE-SPI', 'BE-SPI (Espierres (Spiere), West-Vlaanderen, Belgium)'),
    ('BE-EPC', 'BE-EPC (Esplechin, Hainaut, Belgium)'),
    ('BE-EQM', 'BE-EQM (Esquelmes, Hainaut, Belgium)'),
    ('BE-ESS', 'BE-ESS (Essen, Antwerpen, Belgium)'),
    ('BE-EST', 'BE-EST (Essen, Antwerpen, Belgium)'),
    ('BE-EMP', 'BE-EMP (Estaimpuis, Hainaut, Belgium)'),
    ('BE-ETI', 'BE-ETI (Estinnes, Hainaut, Belgium)'),
    ('BE-E8O', 'BE-E8O (Etikhove, Oost-Vlaanderen, Belgium)'),
    ('BE-ETE', 'BE-ETE (Etikhove, Oost-Vlaanderen, Belgium)'),
    ('BE-EUP', 'BE-EUP (Eupen, Liège, Belgium)'),
    ('BE-EBR', 'BE-EBR (Everberg, Vlaams Brabant, Belgium)'),
    ('BE-EVR', 'BE-EVR (Everberg, Vlaams Brabant, Belgium)'),
    ('BE-EVM', 'BE-EVM (Evergem, Oost-Vlaanderen, Belgium)'),
    ('BE-EVX', 'BE-EVX (Eveux, Luxembourg, Belgium)'),
    ('BE-EYT', 'BE-EYT (Eynatten, Liège, Belgium)'),
    ('BE-FME', 'BE-FME (Faimes, Liège, Belgium)'),
    ('BE-FAL', 'BE-FAL (Falaën, Namur, Belgium)'),
    ('BE-FUX', 'BE-FUX (Familleureux, Hainaut, Belgium)'),
    ('BE-FCS', 'BE-FCS (Farciennes, Hainaut, Belgium)'),
    ('BE-FLT', 'BE-FLT (Faulx-Les Tombes, Namur, Belgium)'),
    ('BE-FVI', 'BE-FVI (Fauvillers, Luxembourg, Belgium)'),
    ('BE-FYS', 'BE-FYS (Fays-les-Veneurs, Luxembourg, Belgium)'),
    ('BE-FLM', 'BE-FLM (Fays-les-Veneurs, Luxembourg, Belgium)'),
    ('BE-FEY', 'BE-FEY (Feluy, Hainaut, Belgium)'),
    ('BE-FER', 'BE-FER (Feneur, Liège, Belgium)'),
    ('BE-FNO', 'BE-FNO (Fernelmont, Namur, Belgium)'),
    ('BE-FRE', 'BE-FRE (Ferrières, Liège, Belgium)'),
    ('BE-FHC', 'BE-FHC (Fexhe-le-Haut-Clocher, Liège, Belgium)'),
    ('BE-FXI', 'BE-FXI (Fexhe-Slins, Liège, Belgium)'),
    ('BE-FIL', 'BE-FIL (Filot, Liège, Belgium)'),
    ('BE-FMI', 'BE-FMI (Flamierge, Luxembourg, Belgium)'),
    ('BE-FWI', 'BE-FWI (Flawinne, Namur, Belgium)'),
    ('BE-FLE', 'BE-FLE (Fleurus, Hainaut, Belgium)'),
    ('BE-FBQ', 'BE-FBQ (Flobecq, Hainaut, Belgium)'),
    ('BE-FLO', 'BE-FLO (Floreffe, Namur, Belgium)'),
    ('BE-FLR', 'BE-FLR (Florennes, Namur, Belgium)'),
    ('BE-FRI', 'BE-FRI (Florenville, Luxembourg, Belgium)'),
    ('BE-FFX', 'BE-FFX (Floriffoux, Namur, Belgium)'),
    ('BE-FOR', 'BE-FOR (Florée, Namur, Belgium)'),
    ('BE-FMA', 'BE-FMA (Flémalle, Liège, Belgium)'),
    ('BE-FMG', 'BE-FMG (Flémalle-Grande, Liège, Belgium)'),
    ('BE-FLH', 'BE-FLH (Flémalle-Haute, Liège, Belgium)'),
    ('BE-FLU', 'BE-FLU (Flénu, Hainaut, Belgium)'),
    ('BE-FRO', 'BE-FRO (Fléron, Liège, Belgium)'),
    ('BE-FLN', 'BE-FLN (Flône, Liège, Belgium)'),
    ('BE-FCA', 'BE-FCA (Focant, Namur, Belgium)'),
    ('BE-FOL', 'BE-FOL (Focant, Namur, Belgium)'),
    ('BE-FEQ', "BE-FEQ (Fontaine-l'Évêque, Hainaut, Belgium)"),
    ('BE-FVT', 'BE-FVT (Fontaine-Valmont, Hainaut, Belgium)'),
    ('BE-FNY', 'BE-FNY (Fontenoy, Hainaut, Belgium)'),
    ('BE-FMR', 'BE-FMR (Forchies-la-Marche, Hainaut, Belgium)'),
    ('BE-VOS', 'BE-VOS (Forchies-la-Marche, Hainaut, Belgium)'),
    ('BE-FPI', 'BE-FPI (Forge-Philippe, Hainaut, Belgium)'),
    ('BE-FOG', 'BE-FOG (Forges, Hainaut, Belgium)'),
    ('BE-FIS', 'BE-FIS (Forrières, Luxembourg, Belgium)'),
    ('BE-FRM', 'BE-FRM (Fortem, West-Vlaanderen, Belgium)'),
    ('BE-FSV', 'BE-FSV (Fosses-la-Ville, Namur, Belgium)'),
    ('BE-FYD', 'BE-FYD (Foy-Notre-Dame, Namur, Belgium)'),
    ('BE-FES', 'BE-FES (Frameries, Hainaut, Belgium)'),
    ('BE-FMO', 'BE-FMO (Framont, Luxembourg, Belgium)'),
    ('BE-FRC', 'BE-FRC (Francorchamps, Liège, Belgium)'),
    ('BE-FNR', 'BE-FNR (Franière, Namur, Belgium)'),
    ('BE-FRS', 'BE-FRS (Franière, Namur, Belgium)'),
    ('BE-FAV', 'BE-FAV (Frasnes-lez-Anvaing, Hainaut, Belgium)'),
    ('BE-FBU', 'BE-FBU (Frasnes-lez-Buissenal, Hainaut, Belgium)'),
    ('BE-FLG', 'BE-FLG (Frasnes-lez-Gosselies, Hainaut, Belgium)'),
    ('BE-FRY', 'BE-FRY (Frasnes-lez-Gosselies, Hainaut, Belgium)'),
    ('BE-FDA', 'BE-FDA (Froid-Chapelle, Hainaut, Belgium)'),
    ('BE-FFO', 'BE-FFO (Froidfontaine, Namur, Belgium)'),
    ('BE-FIM', 'BE-FIM (Froidmont, Hainaut, Belgium)'),
    ('BE-FYE', 'BE-FYE (Froyennes, Hainaut, Belgium)'),
    ('BE-FNX', 'BE-FNX (Furnaux, Namur, Belgium)'),
    ('BE-GAG', 'BE-GAG (Gages, Hainaut, Belgium)'),
    ('BE-GAX', 'BE-GAX (Gallaix, Hainaut, Belgium)'),
    ('BE-GMA', 'BE-GMA (Galmaarden, Vlaams Brabant, Belgium)'),
    ('BE-GHO', 'BE-GHO (Galmaarden, Vlaams Brabant, Belgium)'),
    ('BE-GRA', 'BE-GRA (Gaurain-Ramecroix, Hainaut, Belgium)'),
    ('BE-GVR', 'BE-GVR (Gavere, Oost-Vlaanderen, Belgium)'),
    ('BE-GED', 'BE-GED (Gedinne, Namur, Belgium)'),
    ('BE-GEL', 'BE-GEL (Geel, Antwerpen, Belgium)'),
    ('BE-GEE', 'BE-GEE (Geer, Liège, Belgium)'),
    ('BE-GBE', 'BE-GBE (Geetbets, Vlaams Brabant, Belgium)'),
    ('BE-GSE', 'BE-GSE (Gelbressée, Namur, Belgium)'),
    ('BE-GLK', 'BE-GLK (Gellik, Limburg, Belgium)'),
    ('BE-GVD', 'BE-GVD (Geluveld, West-Vlaanderen, Belgium)'),
    ('BE-GLW', 'BE-GLW (Geluwe, West-Vlaanderen, Belgium)'),
    ('BE-GEM', 'BE-GEM (Gembloux, Namur, Belgium)'),
    ('BE-GMI', 'BE-GMI (Gemmenich, Liège, Belgium)'),
    ('BE-GNA', 'BE-GNA (Genappe, Brabant wallon, Belgium)'),
    ('BE-GBH', 'BE-GBH (Genenbos, Limburg, Belgium)'),
    ('BE-GNK', 'BE-GNK (Genk, Limburg, Belgium)'),
    ('BE-GNE', 'BE-GNE (Gent (Ghent), Oost-Vlaanderen, Belgium)'),
    ('BE-GBU', 'BE-GBU (Gentbrugge, Oost-Vlaanderen, Belgium)'),
    ('BE-GEV', 'BE-GEV (Genval, Brabant wallon, Belgium)'),
    ('BE-GEA', 'BE-GEA (Geraardsbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-GRI', 'BE-GRI (Gerin, Namur, Belgium)'),
    ('BE-GPI', 'BE-GPI (Gerpinnes, Hainaut, Belgium)'),
    ('BE-GVE', 'BE-GVE (Gesves, Namur, Belgium)'),
    ('BE-GGI', 'BE-GGI (Ghislenghien, Hainaut, Belgium)'),
    ('BE-GHL', 'BE-GHL (Ghlin, Hainaut, Belgium)'),
    ('BE-GHY', 'BE-GHY (Ghoy, Hainaut, Belgium)'),
    ('BE-GBQ', 'BE-GBQ (Gibecq, Hainaut, Belgium)'),
    ('BE-GIE', 'BE-GIE (Gierle, Antwerpen, Belgium)'),
    ('BE-GKO', 'BE-GKO (Gijverinkhove, West-Vlaanderen, Belgium)'),
    ('BE-GZM', 'BE-GZM (Gijzegem, Oost-Vlaanderen, Belgium)'),
    ('BE-GLY', 'BE-GLY (Gilly, Hainaut, Belgium)'),
    ('BE-GLO', 'BE-GLO (Gingelom, Limburg, Belgium)'),
    ('BE-GIS', 'BE-GIS (Gistel, West-Vlaanderen, Belgium)'),
    ('BE-GIT', 'BE-GIT (Gits, West-Vlaanderen, Belgium)'),
    ('BE-GRY', 'BE-GRY (Givry, Hainaut, Belgium)'),
    ('BE-GBA', 'BE-GBA (Glabais, Brabant wallon, Belgium)'),
    ('BE-GBK', 'BE-GBK (Glabbeek, Vlaams Brabant, Belgium)'),
    ('BE-GDN', 'BE-GDN (Godinne, Namur, Belgium)'),
    ('BE-GDE', 'BE-GDE (Godsheide, Limburg, Belgium)'),
    ('BE-GON', 'BE-GON (Goesnes, Namur, Belgium)'),
    ('BE-GOK', 'BE-GOK (Gooik, Vlaams Brabant, Belgium)'),
    ('BE-GRE', 'BE-GRE (Gorsem, Limburg, Belgium)'),
    ('BE-GOS', 'BE-GOS (Gosselies, Hainaut, Belgium)'),
    ('BE-GTM', 'BE-GTM (Gottem, Oost-Vlaanderen, Belgium)'),
    ('BE-GUR', 'BE-GUR (Gourdinne, Namur, Belgium)'),
    ('BE-GTX', 'BE-GTX (Goutroux, Hainaut, Belgium)'),
    ('BE-GVY', 'BE-GVY (Gouvy, Luxembourg, Belgium)'),
    ('BE-GPO', 'BE-GPO (Gouy-lez-Piéton, Hainaut, Belgium)'),
    ('BE-GZE', 'BE-GZE (Gozée, Hainaut, Belgium)'),
    ('BE-GDO', 'BE-GDO (Goé, Liège, Belgium)'),
    ('BE-GMM', 'BE-GMM (Grammene, Oost-Vlaanderen, Belgium)'),
    ('BE-GHX', 'BE-GHX (Grand-Halleux, Luxembourg, Belgium)'),
    ('BE-GLE', 'BE-GLE (Grand-Leez, Namur, Belgium)'),
    ('BE-GDI', 'BE-GDI (Grandglise, Hainaut, Belgium)'),
    ('BE-GGM', 'BE-GGM (Grembergen, Oost-Vlaanderen, Belgium)'),
    ('BE-GDU', 'BE-GDU (Grez-Doiceau, Brabant wallon, Belgium)'),
    ('BE-GRB', 'BE-GRB (Grimbergen, Vlaams Brabant, Belgium)'),
    ('BE-GME', 'BE-GME (Grimminge, Oost-Vlaanderen, Belgium)'),
    ('BE-GVI', 'BE-GVI (Grivegnée, Liège, Belgium)'),
    ('BE-GBB', 'BE-GBB (Grobbendonk, Antwerpen, Belgium)'),
    ('BE-GRN', 'BE-GRN (Groenendaal, Vlaams Brabant, Belgium)'),
    ('BE-GRO', 'BE-GRO (Groenendaal, Vlaams Brabant, Belgium)'),
    ('BE-GBJ', 'BE-GBJ (Groot-Bijgaarden, Vlaams Brabant, Belgium)'),
    ('BE-GBG', 'BE-GBG (Grote-Brogel, Limburg, Belgium)'),
    ('BE-SWN', 'BE-SWN (Grote-Spouwen, Limburg, Belgium)'),
    ('BE-GRU', 'BE-GRU (Grune, Luxembourg, Belgium)'),
    ('BE-GHE', 'BE-GHE (Grâce-Hollogne, Liège, Belgium)'),
    ('BE-GGO', 'BE-GGO (Guigoven, Limburg, Belgium)'),
    ('BE-GUG', 'BE-GUG (Gullegem, West-Vlaanderen, Belgium)'),
    ('BE-GUT', 'BE-GUT (Gutschoven, Limburg, Belgium)'),
    ('BE-HAC', 'BE-HAC (Haacht, Vlaams Brabant, Belgium)'),
    ('BE-HAT', 'BE-HAT (Haaltert, Oost-Vlaanderen, Belgium)'),
    ('BE-HDQ', 'BE-HDQ (Haasdonk, Oost-Vlaanderen, Belgium)'),
    ('BE-HAD', 'BE-HAD (Haasrode, Vlaams Brabant, Belgium)'),
    ('BE-HLN', 'BE-HLN (Habay-la-Neuve, Luxembourg, Belgium)'),
    ('BE-HYV', 'BE-HYV (Habay-la-Vieille, Luxembourg, Belgium)'),
    ('BE-HRY', 'BE-HRY (Habergy, Luxembourg, Belgium)'),
    ('BE-HCT', 'BE-HCT (Haccourt, Liège, Belgium)'),
    ('BE-HQI', 'BE-HQI (Hacquegnies, Hainaut, Belgium)'),
    ('BE-HLO', 'BE-HLO (Haillot, Namur, Belgium)'),
    ('BE-HSP', 'BE-HSP (Haine-Saint-Pierre, Hainaut, Belgium)'),
    ('BE-HAQ', 'BE-HAQ (Hal, Limburg, Belgium)'),
    ('BE-HZY', 'BE-HZY (Halanzy, Luxembourg, Belgium)'),
    ('BE-HLA', 'BE-HLA (Halen, Limburg, Belgium)'),
    ('BE-HFB', 'BE-HFB (Halle, Vlaams Brabant, Belgium)'),
    ('BE-HLL', 'BE-HLL (Halle, Antwerpen, Belgium)'),
    ('BE-HLX', 'BE-HLX (Halleux, Luxembourg, Belgium)'),
    ('BE-HLU', 'BE-HLU (Halluin, West-Vlaanderen, Belgium)'),
    ('BE-HMA', 'BE-HMA (Halma, Luxembourg, Belgium)'),
    ('BE-HAW', 'BE-HAW (Halma, Luxembourg, Belgium)'),
    ('BE-MHA', 'BE-MHA (Ham, Limburg, Belgium)'),
    ('BE-HHN', 'BE-HHN (Ham-sur-Heure-Nalinnes, Hainaut, Belgium)'),
    ('BE-HMB', 'BE-HMB (Ham-sur-Sambre, Namur, Belgium)'),
    ('BE-HAE', 'BE-HAE (Hamme, Brabant wallon, Belgium)'),
    ('BE-HME', 'BE-HME (Hamme, Oost-Vlaanderen, Belgium)'),
    ('BE-HMM', 'BE-HMM (Hamme, Oost-Vlaanderen, Belgium)'),
    ('BE-HMO', 'BE-HMO (Hamoir, Liège, Belgium)'),
    ('BE-HMI', 'BE-HMI (Hamois, Namur, Belgium)'),
    ('BE-HAL', 'BE-HAL (Hamont, Limburg, Belgium)'),
    ('BE-HAH', 'BE-HAH (Hamont-Achel, Limburg, Belgium)'),
    ('BE-HAM', 'BE-HAM (Hamsehoeven, Limburg, Belgium)'),
    ('BE-HNA', 'BE-HNA (Handzame, West-Vlaanderen, Belgium)'),
    ('BE-HNU', 'BE-HNU (Hannut, Liège, Belgium)'),
    ('BE-HBE', 'BE-HBE (Hansbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-HCS', 'BE-HCS (Harchies, Hainaut, Belgium)'),
    ('BE-HEJ', 'BE-HEJ (Harelbeke, West-Vlaanderen, Belgium)'),
    ('BE-HAR', 'BE-HAR (Haren, Vlaams Brabant, Belgium)'),
    ('BE-HRI', 'BE-HRI (Harmignies, Hainaut, Belgium)'),
    ('BE-HVG', 'BE-HVG (Harveng, Hainaut, Belgium)'),
    ('BE-HRZ', 'BE-HRZ (Harzé, Liège, Belgium)'),
    ('BE-HSS', 'BE-HSS (Hasselt, Limburg, Belgium)'),
    ('BE-HPD', 'BE-HPD (Hastière-par-delà, Namur, Belgium)'),
    ('BE-HIT', 'BE-HIT (Haut-Ittre, Brabant wallon, Belgium)'),
    ('BE-HTJ', 'BE-HTJ (Hautrage, Hainaut, Belgium)'),
    ('BE-HVY', 'BE-HVY (Havay, Hainaut, Belgium)'),
    ('BE-HVA', 'BE-HVA (Havelange, Namur, Belgium)'),
    ('BE-HVN', 'BE-HVN (Havenne, Namur, Belgium)'),
    ('BE-HNE', 'BE-HNE (Havinnes, Hainaut, Belgium)'),
    ('BE-HRE', 'BE-HRE (Havré, Hainaut, Belgium)'),
    ('BE-HCL', 'BE-HCL (Hechtel, Limburg, Belgium)'),
    ('BE-HEK', 'BE-HEK (Hechtel-Eksel, Limburg, Belgium)'),
    ('BE-HEE', 'BE-HEE (Heer, Namur, Belgium)'),
    ('BE-HSE', 'BE-HSE (Heers, Limburg, Belgium)'),
    ('BE-HTS', 'BE-HTS (Heestert, West-Vlaanderen, Belgium)'),
    ('BE-HFE', 'BE-HFE (Heffen, Antwerpen, Belgium)'),
    ('BE-HDK', 'BE-HDK (Heindonk, Antwerpen, Belgium)'),
    ('BE-HEI', 'BE-HEI (Heist, West-Vlaanderen, Belgium)'),
    ('BE-HPG', 'BE-HPG (Heist-op-den-Berg, Antwerpen, Belgium)'),
    ('BE-HKM', 'BE-HKM (Hekelgem, Oost-Vlaanderen, Belgium)'),
    ('BE-HKN', 'BE-HKN (Helkijn, West-Vlaanderen, Belgium)'),
    ('BE-HLE', 'BE-HLE (Hemelveerdegem, Oost-Vlaanderen, Belgium)'),
    ('BE-HEX', 'BE-HEX (Hemiksem, Antwerpen, Belgium)'),
    ('BE-HCA', 'BE-HCA (Henri-Chapelle, Liège, Belgium)'),
    ('BE-HNS', 'BE-HNS (Hensies, Hainaut, Belgium)'),
    ('BE-HEP', 'BE-HEP (Heppen, Limburg, Belgium)'),
    ('BE-HPA', 'BE-HPA (Heppenbach, Liège, Belgium)'),
    ('BE-HPS', 'BE-HPS (Heppignies, Hainaut, Belgium)'),
    ('BE-HBO', 'BE-HBO (Herbeumont, Luxembourg, Belgium)'),
    ('BE-HYB', 'BE-HYB (Herdersem, Oost-Vlaanderen, Belgium)'),
    ('BE-HEB', 'BE-HEB (Herent, Vlaams Brabant, Belgium)'),
    ('BE-HET', 'BE-HET (Herent, Limburg, Belgium)'),
    ('BE-HER', 'BE-HER (Herentals, Antwerpen, Belgium)'),
    ('BE-HRO', 'BE-HRO (Herenthout, Antwerpen, Belgium)'),
    ('BE-HRA', 'BE-HRA (Hergenrath, Liège, Belgium)'),
    ('BE-HKA', 'BE-HKA (Herk-de-Stad, Limburg, Belgium)'),
    ('BE-HSA', 'BE-HSA (Hermalle-sous-Argenteau, Liège, Belgium)'),
    ('BE-HMH', 'BE-HMH (Hermalle-sous-Huy, Liège, Belgium)'),
    ('BE-HTM', 'BE-HTM (Hermeton-sur-Meuse, Namur, Belgium)'),
    ('BE-HEN', 'BE-HEN (Herne, Vlaams Brabant, Belgium)'),
    ('BE-HRQ', 'BE-HRQ (Herquegies, Hainaut, Belgium)'),
    ('BE-HSX', 'BE-HSX (Herseaux, Hainaut, Belgium)'),
    ('BE-HES', 'BE-HES (Herselt, Antwerpen, Belgium)'),
    ('BE-HRS', 'BE-HRS (Herstal, Liège, Belgium)'),
    ('BE-HTP', 'BE-HTP (Herstappe, Limburg, Belgium)'),
    ('BE-HTI', 'BE-HTI (Hertain, Hainaut, Belgium)'),
    ('BE-HRV', 'BE-HRV (Herve, Liège, Belgium)'),
    ('BE-HEZ', 'BE-HEZ (Herzele, Oost-Vlaanderen, Belgium)'),
    ('BE-HEU', 'BE-HEU (Heule, West-Vlaanderen, Belgium)'),
    ('BE-HUJ', 'BE-HUJ (Heultje, Antwerpen, Belgium)'),
    ('BE-TTJ', 'BE-TTJ (Heultje, Antwerpen, Belgium)'),
    ('BE-HUR', 'BE-HUR (Heure-le-Romain, Liège, Belgium)'),
    ('BE-HZZ', 'BE-HZZ (Heusden, Oost-Vlaanderen, Belgium)'),
    ('BE-HZO', 'BE-HZO (Heusden-Zolder, Limburg, Belgium)'),
    ('BE-HSY', 'BE-HSY (Heusy, Liège, Belgium)'),
    ('BE-HVL', 'BE-HVL (Heuvelland, West-Vlaanderen, Belgium)'),
    ('BE-HVE', 'BE-HVE (Hever, Vlaams Brabant, Belgium)'),
    ('BE-HVB', 'BE-HVB (Heverlee, Vlaams Brabant, Belgium)'),
    ('BE-HYD', 'BE-HYD (Heyd, Luxembourg, Belgium)'),
    ('BE-QHM', 'BE-QHM (Heyd, Luxembourg, Belgium)'),
    ('BE-HGE', 'BE-HGE (Hingene, Antwerpen, Belgium)'),
    ('BE-HIV', 'BE-HIV (Hives, Luxembourg, Belgium)'),
    ('BE-HBN', 'BE-HBN (Hoboken, Antwerpen, Belgium)'),
    ('BE-HOD', 'BE-HOD (Hodeige, Liège, Belgium)'),
    ('BE-HDY', 'BE-HDY (Hody, Liège, Belgium)'),
    ('BE-HGD', 'BE-HGD (Hoegaarden, Vlaams Brabant, Belgium)'),
    ('BE-HOI', 'BE-HOI (Hoeilaart, Vlaams Brabant, Belgium)'),
    ('BE-HBK', 'BE-HBK (Hoelbeek, Limburg, Belgium)'),
    ('BE-HDE', 'BE-HDE (Hoeleden, Vlaams Brabant, Belgium)'),
    ('BE-H9G', 'BE-H9G (Hoepertingen, Limburg, Belgium)'),
    ('BE-HOE', 'BE-HOE (Hoeselt, Limburg, Belgium)'),
    ('BE-HV2', 'BE-HV2 (Hoevenen, Antwerpen, Belgium)'),
    ('BE-HOF', 'BE-HOF (Hofstade, Vlaams Brabant, Belgium)'),
    ('BE-HSD', 'BE-HSD (Hofstade, Oost-Vlaanderen, Belgium)'),
    ('BE-HGU', 'BE-HGU (Hognoul, Liège, Belgium)'),
    ('BE-HOL', 'BE-HOL (Hollain, Hainaut, Belgium)'),
    ('BE-HOK', 'BE-HOK (Hollebeke, West-Vlaanderen, Belgium)'),
    ('BE-HLG', 'BE-HLG (Hollogne-sur-Geer, Liège, Belgium)'),
    ('BE-HSK', 'BE-HSK (Holsbeek, Vlaams Brabant, Belgium)'),
    ('BE-HBU', 'BE-HBU (Hombourg, Liège, Belgium)'),
    ('BE-HON', 'BE-HON (Honnelles, Hainaut, Belgium)'),
    ('BE-HHG', 'BE-HHG (Hooglede, West-Vlaanderen, Belgium)'),
    ('BE-HOO', 'BE-HOO (Hoogstraten, Antwerpen, Belgium)'),
    ('BE-HOR', 'BE-HOR (Horebeke, Oost-Vlaanderen, Belgium)'),
    ('BE-HRU', 'BE-HRU (Hornu, Hainaut, Belgium)'),
    ('BE-HOT', 'BE-HOT (Hotton, Luxembourg, Belgium)'),
    ('BE-HDO', 'BE-HDO (Houdemont, Luxembourg, Belgium)'),
    ('BE-HGA', 'BE-HGA (Houdeng-Aimeries, Hainaut, Belgium)'),
    ('BE-HGG', 'BE-HGG (Houdeng-Goegnies, Hainaut, Belgium)'),
    ('BE-HFA', 'BE-HFA (Houffalize, Luxembourg, Belgium)'),
    ('BE-HOU', 'BE-HOU (Hour, Namur, Belgium)'),
    ('BE-HRP', 'BE-HRP (Hourpes, Hainaut, Belgium)'),
    ('BE-HUS', 'BE-HUS (Housse, Liège, Belgium)'),
    ('BE-HOA', 'BE-HOA (Houtain-le-Val, Brabant wallon, Belgium)'),
    ('BE-HSM', 'BE-HSM (Houtain-Saint-Siméon, Liège, Belgium)'),
    ('BE-HTN', 'BE-HTN (Houtaing, Hainaut, Belgium)'),
    ('BE-HTH', 'BE-HTH (Houthalen, Limburg, Belgium)'),
    ('BE-HHE', 'BE-HHE (Houthalen-Helchteren, Limburg, Belgium)'),
    ('BE-HUT', 'BE-HUT (Houthem, Hainaut, Belgium)'),
    ('BE-HHU', 'BE-HHU (Houthulst, West-Vlaanderen, Belgium)'),
    ('BE-HTV', 'BE-HTV (Houtvenne, Antwerpen, Belgium)'),
    ('BE-HUX', 'BE-HUX (Houx, Namur, Belgium)'),
    ('BE-HYE', 'BE-HYE (Houyet, Namur, Belgium)'),
    ('BE-HOV', 'BE-HOV (Hove, Antwerpen, Belgium)'),
    ('BE-WAH', 'BE-WAH (Hove, Antwerpen, Belgium)'),
    ('BE-HWA', 'BE-HWA (Howardries, Hainaut, Belgium)'),
    ('BE-HZI', 'BE-HZI (Huizingen, Vlaams Brabant, Belgium)'),
    ('BE-HDG', 'BE-HDG (Huldenberg, Vlaams Brabant, Belgium)'),
    ('BE-HHT', 'BE-HHT (Hulshout, Antwerpen, Belgium)'),
    ('BE-HUL', 'BE-HUL (Hulste, West-Vlaanderen, Belgium)'),
    ('BE-HUM', 'BE-HUM (Humbeek, Vlaams Brabant, Belgium)'),
    ('BE-HUN', 'BE-HUN (Hun, Namur, Belgium)'),
    ('BE-HUY', 'BE-HUY (Huy, Liège, Belgium)'),
    ('BE-HYO', 'BE-HYO (Hyon, Hainaut, Belgium)'),
    ('BE-HCI', 'BE-HCI (Hélécine, Brabant wallon, Belgium)'),
    ('BE-HNI', 'BE-HNI (Hérinnes, Hainaut, Belgium)'),
    ('BE-HNO', 'BE-HNO (Héron, Liège, Belgium)'),
    ('BE-IHE', 'BE-IHE (Ichtegem, West-Vlaanderen, Belgium)'),
    ('BE-IDE', 'BE-IDE (Iddergem, Oost-Vlaanderen, Belgium)'),
    ('BE-IDG', 'BE-IDG (Idegem, Oost-Vlaanderen, Belgium)'),
    ('BE-IPR', 'BE-IPR (Ieper, West-Vlaanderen, Belgium)'),
    ('BE-ICO', 'BE-ICO (Incourt, Brabant wallon, Belgium)'),
    ('BE-IGE', 'BE-IGE (Ingelmunster, West-Vlaanderen, Belgium)'),
    ('BE-IGM', 'BE-IGM (Ingooigem, West-Vlaanderen, Belgium)'),
    ('BE-IWE', 'BE-IWE (Irchonwelz, Hainaut, Belgium)'),
    ('BE-ISR', 'BE-ISR (Isières, Hainaut, Belgium)'),
    ('BE-ISE', 'BE-ISE (Isnes, Namur, Belgium)'),
    ('BE-ITE', 'BE-ITE (Itegem, Antwerpen, Belgium)'),
    ('BE-ITR', 'BE-ITR (Itter (Ittre), Brabant wallon, Belgium)'),
    ('BE-IBE', 'BE-IBE (Itterbeek, Vlaams Brabant, Belgium)'),
    ('BE-ITR', 'BE-ITR (Ittre (Itter), Brabant wallon, Belgium)'),
    ('BE-YRT', 'BE-YRT (Ivoz-Ramet, Liège, Belgium)'),
    ('BE-ESE', 'BE-ESE (Ivoz-Ramet, Liège, Belgium)'),
    ('BE-IZG', 'BE-IZG (Izegem, West-Vlaanderen, Belgium)'),
    ('BE-IZE', 'BE-IZE (Izenberge, West-Vlaanderen, Belgium)'),
    ('BE-IZI', 'BE-IZI (Izier, Luxembourg, Belgium)'),
    ('BE-JBE', 'BE-JBE (Jabbeke, West-Vlaanderen, Belgium)'),
    ('BE-JHY', 'BE-JHY (Jalhay, Liège, Belgium)'),
    ('BE-JLE', 'BE-JLE (Jallet, Namur, Belgium)'),
    ('BE-JAM', 'BE-JAM (Jambes, Namur, Belgium)'),
    ('BE-JMO', 'BE-JMO (Jamoigne, Luxembourg, Belgium)'),
    ('BE-JAV', 'BE-JAV (Java, Liège, Belgium)'),
    ('BE-JME', 'BE-JME (Jemappes, Hainaut, Belgium)'),
    ('BE-JEM', 'BE-JEM (Jemeppe, Liège, Belgium)'),
    ('BE-JPS', 'BE-JPS (Jemeppe-sur-Sambre, Namur, Belgium)'),
    ('BE-JET', 'BE-JET (Jemeppe-sur-Sambre, Namur, Belgium)'),
    ('BE-JDO', 'BE-JDO (Jodoigne, Brabant wallon, Belgium)'),
    ('BE-JUM', 'BE-JUM (Jumet, Hainaut, Belgium)'),
    ('BE-JAK', 'BE-JAK (Jupille-sur-Meuse, Liège, Belgium)'),
    ('BE-JPE', 'BE-JPE (Juprelle, Liège, Belgium)'),
    ('BE-JBI', 'BE-JBI (Jurbise, Hainaut, Belgium)'),
    ('BE-JSE', 'BE-JSE (Juseret, Luxembourg, Belgium)'),
    ('BE-KKR', 'BE-KKR (Kaaskerke, West-Vlaanderen, Belgium)'),
    ('BE-KCT', 'BE-KCT (Kachtem, West-Vlaanderen, Belgium)'),
    ('BE-KGV', 'BE-KGV (Kaggevinne, Vlaams Brabant, Belgium)'),
    ('BE-KAI', 'BE-KAI (Kain, Hainaut, Belgium)'),
    ('BE-KBV', 'BE-KBV (Kalken, Oost-Vlaanderen, Belgium)'),
    ('BE-KOU', 'BE-KOU (Kallo, Oost-Vlaanderen, Belgium)'),
    ('BE-KTT', 'BE-KTT (Kalmthout, Antwerpen, Belgium)'),
    ('BE-KMH', 'BE-KMH (Kampenhout, Vlaams Brabant, Belgium)'),
    ('BE-KAN', 'BE-KAN (Kanne (Canne), Limburg, Belgium)'),
    ('BE-KPB', 'BE-KPB (Kapelle-op-den-Bos, Vlaams Brabant, Belgium)'),
    ('BE-KPN', 'BE-KPN (Kapellen, Antwerpen, Belgium)'),
    ('BE-KRI', 'BE-KRI (Kaprijke, Oost-Vlaanderen, Belgium)'),
    ('BE-KAS', 'BE-KAS (Kaster, West-Vlaanderen, Belgium)'),
    ('BE-KSE', 'BE-KSE (Kasterlee, Antwerpen, Belgium)'),
    ('BE-KLE', 'BE-KLE (Kaulille, Limburg, Belgium)'),
    ('BE-KAO', 'BE-KAO (Keerbergen, Vlaams Brabant, Belgium)'),
    ('BE-KME', 'BE-KME (Kemmel, West-Vlaanderen, Belgium)'),
    ('BE-KMZ', 'BE-KMZ (Kemzeke, Oost-Vlaanderen, Belgium)'),
    ('BE-KHN', 'BE-KHN (Kerkhove, West-Vlaanderen, Belgium)'),
    ('BE-KHO', 'BE-KHO (Kerkhoven, Limburg, Belgium)'),
    ('BE-KKE', 'BE-KKE (Kerksken, Oost-Vlaanderen, Belgium)'),
    ('BE-KET', 'BE-KET (Kermt, Limburg, Belgium)'),
    ('BE-KNL', 'BE-KNL (Kerniel, Limburg, Belgium)'),
    ('BE-KMO', 'BE-KMO (Kersbeek-Miskom, Vlaams Brabant, Belgium)'),
    ('BE-KES', 'BE-KES (Kessel, Antwerpen, Belgium)'),
    ('BE-KSO', 'BE-KSO (Kessel-Lo, Vlaams Brabant, Belgium)'),
    ('BE-KS3', 'BE-KS3 (Kesselt, Limburg, Belgium)'),
    ('BE-KSN', 'BE-KSN (Kessenich, Limburg, Belgium)'),
    ('BE-KST', 'BE-KST (Kester, Vlaams Brabant, Belgium)'),
    ('BE-KTE', 'BE-KTE (Kettenis, Liège, Belgium)'),
    ('BE-KDE', 'BE-KDE (Kieldrecht, Oost-Vlaanderen, Belgium)'),
    ('BE-KRO', 'BE-KRO (Kinrooi, Limburg, Belgium)'),
    ('BE-KVE', 'BE-KVE (Klein Veerle, Antwerpen, Belgium)'),
    ('BE-KWB', 'BE-KWB (Klein Veerle, Antwerpen, Belgium)'),
    ('BE-KLS', 'BE-KLS (Kleine-Spouwen, Limburg, Belgium)'),
    ('BE-KRK', 'BE-KRK (Klerken, West-Vlaanderen, Belgium)'),
    ('BE-KSR', 'BE-KSR (Kluisbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-KNS', 'BE-KNS (Knesselaere, Oost-Vlaanderen, Belgium)'),
    ('BE-BZZ', 'BE-BZZ (Knesselare, Oost-Vlaanderen, Belgium)'),
    ('BE-KHI', 'BE-KHI (Knokke-Heist, West-Vlaanderen, Belgium)'),
    ('BE-KNO', 'BE-KNO (Knokke/Het Zoute, West-Vlaanderen, Belgium)'),
    ('BE-KBB', 'BE-KBB (Kobbegem, Vlaams Brabant, Belgium)'),
    ('BE-KEE', 'BE-KEE (Koekelare, West-Vlaanderen, Belgium)'),
    ('BE-KOE', 'BE-KOE (Koekelare, West-Vlaanderen, Belgium)'),
    ('BE-KOS', 'BE-KOS (Koersel, Limburg, Belgium)'),
    ('BE-KKS', 'BE-KKS (Koksijde, West-Vlaanderen, Belgium)'),
    ('BE-KKT', 'BE-KKT (Koningshooikt, Antwerpen, Belgium)'),
    ('BE-KON', 'BE-KON (Kontich, Antwerpen, Belgium)'),
    ('BE-KOI', 'BE-KOI (Kooigem, West-Vlaanderen, Belgium)'),
    ('BE-KOO', 'BE-KOO (Koolskamp, West-Vlaanderen, Belgium)'),
    ('BE-KOR', 'BE-KOR (Koolskamp, West-Vlaanderen, Belgium)'),
    ('BE-KTK', 'BE-KTK (Kortemark, West-Vlaanderen, Belgium)'),
    ('BE-KNA', 'BE-KNA (Kortenaken, Vlaams Brabant, Belgium)'),
    ('BE-KTB', 'BE-KTB (Kortenberg, Vlaams Brabant, Belgium)'),
    ('BE-KTM', 'BE-KTM (Kortessem, Limburg, Belgium)'),
    ('BE-KJK', 'BE-KJK (Kortrijk, West-Vlaanderen, Belgium)'),
    ('BE-KZN', 'BE-KZN (Kozen, Limburg, Belgium)'),
    ('BE-KRA', 'BE-KRA (Kraainem, Vlaams Brabant, Belgium)'),
    ('BE-KBE', 'BE-KBE (Krombeke, West-Vlaanderen, Belgium)'),
    ('BE-KEK', 'BE-KEK (Kruibeke, Oost-Vlaanderen, Belgium)'),
    ('BE-KHM', 'BE-KHM (Kruishoutem, Oost-Vlaanderen, Belgium)'),
    ('BE-KRN', 'BE-KRN (Kuringen, Limburg, Belgium)'),
    ('BE-KUU', 'BE-KUU (Kuurne, West-Vlaanderen, Belgium)'),
    ('BE-KWA', 'BE-KWA (Kwaadmechelen, Limburg, Belgium)'),
    ('BE-LCA', "BE-LCA (l'Escaillière, Hainaut, Belgium)"),
    ('BE-LBO', 'BE-LBO (La Bouverie, Hainaut, Belgium)'),
    ('BE-LBY', 'BE-LBY (La Bruyère, Namur, Belgium)'),
    ('BE-LAP', 'BE-LAP (La Calamine, Liège, Belgium)'),
    ('BE-GLA', 'BE-GLA (La Glanerie, Hainaut, Belgium)'),
    ('BE-LHL', 'BE-LHL (La Hulpe, Brabant wallon, Belgium)'),
    ('BE-LLO', 'BE-LLO (La Louvière, Hainaut, Belgium)'),
    ('BE-LPT', 'BE-LPT (La Plante, Namur, Belgium)'),
    ('BE-RAR', 'BE-RAR (La Roche-en-Ardenne, Luxembourg, Belgium)'),
    ('BE-LDA', 'BE-LDA (Laakdal, Antwerpen, Belgium)'),
    ('BE-YZO', 'BE-YZO (Laakdal, Limburg, Belgium)'),
    ('BE-LAA', 'BE-LAA (Laarne, Oost-Vlaanderen, Belgium)'),
    ('BE-BSI', 'BE-BSI (Labuissière, Hainaut, Belgium)'),
    ('BE-LCU', 'BE-LCU (Lacuisine, Luxembourg, Belgium)'),
    ('BE-LUZ', 'BE-LUZ (Ladeuze, Hainaut, Belgium)'),
    ('BE-LAM', 'BE-LAM (Lamain, Hainaut, Belgium)'),
    ('BE-LBM', 'BE-LBM (Lambermont, Liège, Belgium)'),
    ('BE-LBT', 'BE-LBT (Lambusart, Hainaut, Belgium)'),
    ('BE-LAN', 'BE-LAN (Lanaken, Limburg, Belgium)'),
    ('BE-LNY', 'BE-LNY (Lanaye (Ternaaien), Liège, Belgium)'),
    ('BE-LGM', 'BE-LGM (Landegem, Oost-Vlaanderen, Belgium)'),
    ('BE-LDS', 'BE-LDS (Landelies, Hainaut, Belgium)'),
    ('BE-LAD', 'BE-LAD (Landen, Vlaams Brabant, Belgium)'),
    ('BE-LNE', 'BE-LNE (Laneffe, Namur, Belgium)'),
    ('BE-LDO', 'BE-LDO (Langdorp, Vlaams Brabant, Belgium)'),
    ('BE-LGL', 'BE-LGL (Langelede, Oost-Vlaanderen, Belgium)'),
    ('BE-LAK', 'BE-LAK (Langemark, West-Vlaanderen, Belgium)'),
    ('BE-LPO', 'BE-LPO (Langemark-Poelkapelle, West-Vlaanderen, Belgium)'),
    ('BE-LGB', 'BE-LGB (Langerbrugge, Oost-Vlaanderen, Belgium)'),
    ('BE-LGO', 'BE-LGO (Langerlo, Limburg, Belgium)'),
    ('BE-LNK', 'BE-LNK (Lanklaar, Limburg, Belgium)'),
    ('BE-LQA', 'BE-LQA (Lanquesaint, Hainaut, Belgium)'),
    ('BE-LPI', 'BE-LPI (Laplaigne, Hainaut, Belgium)'),
    ('BE-LRM', 'BE-LRM (Larum, Antwerpen, Belgium)'),
    ('BE-LAS', 'BE-LAS (Lasne, Brabant wallon, Belgium)'),
    ('BE-LSN', 'BE-LSN (Lasne-Chapelle-Saint-Lambert, Brabant wallon, Belgium)'),
    ('BE-LTI', 'BE-LTI (Latinne, Liège, Belgium)'),
    ('BE-LTO', 'BE-LTO (Latour, Luxembourg, Belgium)'),
    ('BE-LAW', 'BE-LAW (Lauwe, West-Vlaanderen, Belgium)'),
    ('BE-LVA', 'BE-LVA (Lavacherie, Luxembourg, Belgium)'),
    ('BE-ROU', 'BE-ROU (Le Roeulx, Hainaut, Belgium)'),
    ('BE-LEB', 'BE-LEB (Lebbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-LED', 'BE-LED (Lede, Oost-Vlaanderen, Belgium)'),
    ('BE-LRG', 'BE-LRG (Ledeberg, Oost-Vlaanderen, Belgium)'),
    ('BE-LEG', 'BE-LEG (Ledegem, West-Vlaanderen, Belgium)'),
    ('BE-LFA', 'BE-LFA (Leefdaal, Vlaams Brabant, Belgium)'),
    ('BE-LRE', 'BE-LRE (Leernes, Hainaut, Belgium)'),
    ('BE-LST', 'BE-LST (Leest, Antwerpen, Belgium)'),
    ('BE-LFE', 'BE-LFE (Leffinge, West-Vlaanderen, Belgium)'),
    ('BE-LSE', 'BE-LSE (Leisele, West-Vlaanderen, Belgium)'),
    ('BE-LBE', 'BE-LBE (Lembeek, Vlaams Brabant, Belgium)'),
    ('BE-LKE', 'BE-LKE (Lembeke, Oost-Vlaanderen, Belgium)'),
    ('BE-LND', 'BE-LND (Lendelede, West-Vlaanderen, Belgium)'),
    ('BE-LIK', 'BE-LIK (Lennik, Vlaams Brabant, Belgium)'),
    ('BE-LNS', 'BE-LNS (Lens, Hainaut, Belgium)'),
    ('BE-LPG', 'BE-LPG (Leopoldsburg, Limburg, Belgium)'),
    ('BE-LBU', 'BE-LBU (Les Bulles, Luxembourg, Belgium)'),
    ('BE-BOV', 'BE-BOV (Les-Bons-Villers, Hainaut, Belgium)'),
    ('BE-LDI', 'BE-LDI (Lesdain, Hainaut, Belgium)'),
    ('BE-LES', 'BE-LES (Lessines, Hainaut, Belgium)'),
    ('BE-LSY', 'BE-LSY (Lesterny, Luxembourg, Belgium)'),
    ('BE-LVE', 'BE-LVE (Lesve, Namur, Belgium)'),
    ('BE-LHO', 'BE-LHO (Letterhoutem, Oost-Vlaanderen, Belgium)'),
    ('BE-LEU', 'BE-LEU (Leuven, Vlaams Brabant, Belgium)'),
    ('BE-LHT', 'BE-LHT (Leuze-en-Hainaut, Hainaut, Belgium)'),
    ('BE-LTA', 'BE-LTA (Leval-Trahegnies, Hainaut, Belgium)'),
    ('BE-LCI', 'BE-LCI (Liberchies, Hainaut, Belgium)'),
    ('BE-LBN', 'BE-LBN (Libin, Luxembourg, Belgium)'),
    ('BE-LIB', 'BE-LIB (Libramont-Chevigny, Luxembourg, Belgium)'),
    ('BE-LHA', 'BE-LHA (Lichtaart, Antwerpen, Belgium)'),
    ('BE-LIC', 'BE-LIC (Lichtervelde, West-Vlaanderen, Belgium)'),
    ('BE-LDK', 'BE-LDK (Liedekerke, Vlaams Brabant, Belgium)'),
    ('BE-LHK', 'BE-LHK (Liefkenshoek, Oost-Vlaanderen, Belgium)'),
    ('BE-LIE', 'BE-LIE (Lier, Antwerpen, Belgium)'),
    ('BE-LNX', 'BE-LNX (Lierneux, Liège, Belgium)'),
    ('BE-LER', 'BE-LER (Liers, Liège, Belgium)'),
    ('BE-LIV', 'BE-LIV (Lievegem, Oost-Vlaanderen, Belgium)'),
    ('BE-LGN', 'BE-LGN (Ligne, Hainaut, Belgium)'),
    ('BE-LUE', 'BE-LUE (Ligneuville, Liège, Belgium)'),
    ('BE-LGY', 'BE-LGY (Ligney, Liège, Belgium)'),
    ('BE-LLE', 'BE-LLE (Lille, Antwerpen, Belgium)'),
    ('BE-LIL', 'BE-LIL (Lillo, Antwerpen, Belgium)'),
    ('BE-LWI', 'BE-LWI (Lillois-Witterzée, Brabant wallon, Belgium)'),
    ('BE-LIM', 'BE-LIM (Limbourg, Liège, Belgium)'),
    ('BE-LME', 'BE-LME (Limelette, Brabant wallon, Belgium)'),
    ('BE-LCE', 'BE-LCE (Lincent, Liège, Belgium)'),
    ('BE-LDN', 'BE-LDN (Linden, Brabant wallon, Belgium)'),
    ('BE-LKK', 'BE-LKK (Linkebeek, Vlaams Brabant, Belgium)'),
    ('BE-LNI', 'BE-LNI (Lint, Antwerpen, Belgium)'),
    ('BE-LIN', 'BE-LIN (Linter, Vlaams Brabant, Belgium)'),
    ('BE-LSO', 'BE-LSO (Lisogne, Namur, Belgium)'),
    ('BE-LSG', 'BE-LSG (Lissewege, West-Vlaanderen, Belgium)'),
    ('BE-LVM', 'BE-LVM (Lives-sur-Meuse, Namur, Belgium)'),
    ('BE-LIX', 'BE-LIX (Lixhe, Liège, Belgium)'),
    ('BE-LGG', 'BE-LGG (Liège, Liège, Belgium)'),
    ('BE-XLO', 'BE-XLO (Lo, West-Vlaanderen, Belgium)'),
    ('BE-LRI', 'BE-LRI (Lo-Reninge, West-Vlaanderen, Belgium)'),
    ('BE-LBS', 'BE-LBS (Lobbes, Hainaut, Belgium)'),
    ('BE-LOH', 'BE-LOH (Lochristi, Oost-Vlaanderen, Belgium)'),
    ('BE-LOD', 'BE-LOD (Lodelinsart, Hainaut, Belgium)'),
    ('BE-LEH', 'BE-LEH (Loenhout, Antwerpen, Belgium)'),
    ('BE-LKO', 'BE-LKO (Loker, West-Vlaanderen, Belgium)'),
    ('BE-LOK', 'BE-LOK (Lokeren, Oost-Vlaanderen, Belgium)'),
    ('BE-LSI', 'BE-LSI (Lombardsijde, West-Vlaanderen, Belgium)'),
    ('BE-LML', 'BE-LML (Lommel, Limburg, Belgium)'),
    ('BE-LWE', 'BE-LWE (Lommersweiler, Liège, Belgium)'),
    ('BE-LOP', 'BE-LOP (Lompret, Hainaut, Belgium)'),
    ('BE-LPZ', 'BE-LPZ (Lomprez, Luxembourg, Belgium)'),
    ('BE-LOC', 'BE-LOC (Loncin, Liège, Belgium)'),
    ('BE-LNZ', 'BE-LNZ (Londerzeel, Vlaams Brabant, Belgium)'),
    ('BE-LGA', 'BE-LGA (Longchamps, Luxembourg, Belgium)'),
    ('BE-LFG', 'BE-LFG (Longueville, Brabant wallon, Belgium)'),
    ('BE-LTZ', 'BE-LTZ (Lontzen, Liège, Belgium)'),
    ('BE-LPM', 'BE-LPM (Loppem, West-Vlaanderen, Belgium)'),
    ('BE-LOT', 'BE-LOT (Lot, Vlaams Brabant, Belgium)'),
    ('BE-LPE', 'BE-LPE (Loupoigne, Brabant wallon, Belgium)'),
    ('BE-LLN', 'BE-LLN (Louvain-la-Neuve, Brabant wallon, Belgium)'),
    ('BE-LUV', 'BE-LUV (Louveigné, Liège, Belgium)'),
    ('BE-LVO', 'BE-LVO (Lovendegem, Oost-Vlaanderen, Belgium)'),
    ('BE-LOY', 'BE-LOY (Loyers, Namur, Belgium)'),
    ('BE-LOZ', 'BE-LOZ (Lozen, Limburg, Belgium)'),
    ('BE-LBK', 'BE-LBK (Lubbeek, Vlaams Brabant, Belgium)'),
    ('BE-LIU', 'BE-LIU (Luingne, Hainaut, Belgium)'),
    ('BE-LUM', 'BE-LUM (Lummen, Limburg, Belgium)'),
    ('BE-LUI', 'BE-LUI (Lustin, Namur, Belgium)'),
    ('BE-LUT', 'BE-LUT (Luttre, Hainaut, Belgium)'),
    ('BE-LGI', 'BE-LGI (Léglise, Luxembourg, Belgium)'),
    ('BE-MAK', 'BE-MAK (Maarkedal, Oost-Vlaanderen, Belgium)'),
    ('BE-MSK', 'BE-MSK (Maaseik, Limburg, Belgium)'),
    ('BE-MMN', 'BE-MMN (Maasmechelen, Limburg, Belgium)'),
    ('BE-MBO', 'BE-MBO (Mabompré, Luxembourg, Belgium)'),
    ('BE-MAC', 'BE-MAC (Machelen, Vlaams Brabant, Belgium)'),
    ('BE-MCN', 'BE-MCN (Machelen, Oost-Vlaanderen, Belgium)'),
    ('BE-MCO', 'BE-MCO (Macon, Hainaut, Belgium)'),
    ('BE-MCQ', 'BE-MCQ (Macquenoise, Hainaut, Belgium)'),
    ('BE-MAF', 'BE-MAF (Maffe, Namur, Belgium)'),
    ('BE-MFF', 'BE-MFF (Maffle, Hainaut, Belgium)'),
    ('BE-MGE', 'BE-MGE (Magnée, Liège, Belgium)'),
    ('BE-MLL', 'BE-MLL (Maillen, Namur, Belgium)'),
    ('BE-MVA', 'BE-MVA (Mainvault, Hainaut, Belgium)'),
    ('BE-MSR', 'BE-MSR (Maisières, Hainaut, Belgium)'),
    ('BE-MSN', 'BE-MSN (Maissin, Luxembourg, Belgium)'),
    ('BE-MZT', 'BE-MZT (Maizeret, Namur, Belgium)'),
    ('BE-MLG', 'BE-MLG (Maldegem, Oost-Vlaanderen, Belgium)'),
    ('BE-MN2', 'BE-MN2 (Malderen, Vlaams Brabant, Belgium)'),
    ('BE-MAL', 'BE-MAL (Malle, Antwerpen, Belgium)'),
    ('BE-MBW', 'BE-MBW (Malmédy, Liège, Belgium)'),
    ('BE-MLN', 'BE-MLN (Malonne, Namur, Belgium)'),
    ('BE-MAN', 'BE-MAN (Manage, Hainaut, Belgium)'),
    ('BE-MHY', 'BE-MHY (Manhay, Luxembourg, Belgium)'),
    ('BE-MKE', 'BE-MKE (Mannekensvere, West-Vlaanderen, Belgium)'),
    ('BE-WBR', 'BE-WBR (Maransart, Brabant wallon, Belgium)'),
    ('BE-MBS', 'BE-MBS (Marbais, Brabant wallon, Belgium)'),
    ('BE-MBH', 'BE-MBH (Marbehan, Luxembourg, Belgium)'),
    ('BE-MEF', 'BE-MEF (Marche-en-Famenne, Luxembourg, Belgium)'),
    ('BE-MLD', 'BE-MLD (Marche-les-Dames, Namur, Belgium)'),
    ('BE-ECA', 'BE-ECA (Marche-Lez-Ecaussinnes, Hainaut, Belgium)'),
    ('BE-2HW', 'BE-2HW (Marche-lez-Écaussinnes, Hainaut, Belgium)'),
    ('BE-MAP', 'BE-MAP (Marchienne-au-Pont, Hainaut, Belgium)'),
    ('BE-MCI', 'BE-MCI (Marchin, Liège, Belgium)'),
    ('BE-MCL', 'BE-MCL (Marcinelle, Hainaut, Belgium)'),
    ('BE-MRI', 'BE-MRI (Mariakerke, Oost-Vlaanderen, Belgium)'),
    ('BE-MOU', 'BE-MOU (Marienbourg, Namur, Belgium)'),
    ('BE-MAR', 'BE-MAR (Marke, West-Vlaanderen, Belgium)'),
    ('BE-MOI', 'BE-MOI (Marloie, Luxembourg, Belgium)'),
    ('BE-MLY', 'BE-MLY (Marly, Vlaams Brabant, Belgium)'),
    ('BE-MRQ', 'BE-MRQ (Marquain, Hainaut, Belgium)'),
    ('BE-MTA', 'BE-MTA (Martelange, Luxembourg, Belgium)'),
    ('BE-MSD', 'BE-MSD (Martenslinde, Limburg, Belgium)'),
    ('BE-MNE', 'BE-MNE (Martouzin-Neuville, Namur, Belgium)'),
    ('BE-MBU', 'BE-MBU (Masbourg, Luxembourg, Belgium)'),
    ('BE-MHN', 'BE-MHN (Massenhoven, Antwerpen, Belgium)'),
    ('BE-MBY', 'BE-MBY (Maubray, Hainaut, Belgium)'),
    ('BE-MUL', 'BE-MUL (Maulde, Hainaut, Belgium)'),
    ('BE-MRG', 'BE-MRG (Maurage, Hainaut, Belgium)'),
    ('BE-MAZ', 'BE-MAZ (Mazy, Namur, Belgium)'),
    ('BE-ECH', 'BE-ECH (Mechelen, Antwerpen, Belgium)'),
    ('BE-MKI', 'BE-MKI (Meensel-Kiezegem, Vlaams Brabant, Belgium)'),
    ('BE-MEE', 'BE-MEE (Meer, Antwerpen, Belgium)'),
    ('BE-MRE', 'BE-MRE (Meerbeek, Vlaams Brabant, Belgium)'),
    ('BE-MBE', 'BE-MBE (Meerbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-MDK', 'BE-MDK (Meerbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-MEH', 'BE-MEH (Meerhout, Antwerpen, Belgium)'),
    ('BE-MLR', 'BE-MLR (Meerle, Antwerpen, Belgium)'),
    ('BE-MGU', 'BE-MGU (Meeuwen-Gruitrode, Limburg, Belgium)'),
    ('BE-MGM', 'BE-MGM (Meigem, Oost-Vlaanderen, Belgium)'),
    ('BE-MEG', 'BE-MEG (Meilegem, Oost-Vlaanderen, Belgium)'),
    ('BE-MIS', 'BE-MIS (Meise, Vlaams Brabant, Belgium)'),
    ('BE-MDV', 'BE-MDV (Meix-devant-Virton, Luxembourg, Belgium)'),
    ('BE-MDE', 'BE-MDE (Meldert, Oost-Vlaanderen, Belgium)'),
    ('BE-MNL', 'BE-MNL (Melen, Liège, Belgium)'),
    ('BE-MEL', 'BE-MEL (Melle, Oost-Vlaanderen, Belgium)'),
    ('BE-MLS', 'BE-MLS (Melles, Hainaut, Belgium)'),
    ('BE-MLT', 'BE-MLT (Mellet, Hainaut, Belgium)'),
    ('BE-MBK', 'BE-MBK (Melsbroek, Vlaams Brabant, Belgium)'),
    ('BE-MLE', 'BE-MLE (Melsele, Oost-Vlaanderen, Belgium)'),
    ('BE-ELS', 'BE-ELS (Melsen, Oost-Vlaanderen, Belgium)'),
    ('BE-MDO', 'BE-MDO (Mendonk, Oost-Vlaanderen, Belgium)'),
    ('BE-MEN', 'BE-MEN (Menen, West-Vlaanderen, Belgium)'),
    ('BE-MCA', 'BE-MCA (Merbes-le-Château, Hainaut, Belgium)'),
    ('BE-MEC', 'BE-MEC (Merchtem, Vlaams Brabant, Belgium)'),
    ('BE-MER', 'BE-MER (Mere, Oost-Vlaanderen, Belgium)'),
    ('BE-MRL', 'BE-MRL (Merelbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-MRD', 'BE-MRD (Merendree, Oost-Vlaanderen, Belgium)'),
    ('BE-MRM', 'BE-MRM (Merkem, West-Vlaanderen, Belgium)'),
    ('BE-MRK', 'BE-MRK (Merksem, Antwerpen, Belgium)'),
    ('BE-MPS', 'BE-MPS (Merksplas, Antwerpen, Belgium)'),
    ('BE-MLM', 'BE-MLM (Merlemont, Namur, Belgium)'),
    ('BE-MSE', 'BE-MSE (Mesen, West-Vlaanderen, Belgium)'),
    ('BE-MEB', "BE-MEB (Meslin-l'Evêque, Hainaut, Belgium)"),
    ('BE-MSP', 'BE-MSP (Mespelare, Oost-Vlaanderen, Belgium)'),
    ('BE-MES', 'BE-MES (Messancy, Luxembourg, Belgium)'),
    ('BE-MSO', 'BE-MSO (Messelbroek, Vlaams Brabant, Belgium)'),
    ('BE-MVI', 'BE-MVI (Mesvin, Hainaut, Belgium)'),
    ('BE-MTE', 'BE-MTE (Mettet, Namur, Belgium)'),
    ('BE-MEU', 'BE-MEU (Meulebeke, West-Vlaanderen, Belgium)'),
    ('BE-MUX', 'BE-MUX (Meux, Namur, Belgium)'),
    ('BE-MCX', 'BE-MCX (Micheroux, Liège, Belgium)'),
    ('BE-MID', 'BE-MID (Middelburg, Oost-Vlaanderen, Belgium)'),
    ('BE-MIK', 'BE-MIK (Middelkerke, West-Vlaanderen, Belgium)'),
    ('BE-MBA', 'BE-MBA (Mielen-boven-Aalst, Limburg, Belgium)'),
    ('BE-MIL', 'BE-MIL (Milmort, Liège, Belgium)'),
    ('BE-MHO', 'BE-MHO (Minderhout, Antwerpen, Belgium)'),
    ('BE-MCE', 'BE-MCE (Miécret, Namur, Belgium)'),
    ('BE-MOD', 'BE-MOD (Modave, Liège, Belgium)'),
    ('BE-MOE', 'BE-MOE (Moelingen, Limburg, Belgium)'),
    ('BE-MNO', 'BE-MNO (Moen, West-Vlaanderen, Belgium)'),
    ('BE-MEW', 'BE-MEW (Moerbeke-Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-MRB', 'BE-MRB (Moerbrugge, West-Vlaanderen, Belgium)'),
    ('BE-JK8', 'BE-JK8 (Moerdijk, West-Vlaanderen, Belgium)'),
    ('BE-MOK', 'BE-MOK (Moerkerke, West-Vlaanderen, Belgium)'),
    ('BE-MZK', 'BE-MZK (Moerzeke, Oost-Vlaanderen, Belgium)'),
    ('BE-MOS', 'BE-MOS (Moeskroen (Mouscron), Hainaut, Belgium)'),
    ('BE-MHI', 'BE-MHI (Mohiville, Namur, Belgium)'),
    ('BE-MGN', 'BE-MGN (Moignelée, Namur, Belgium)'),
    ('BE-MLO', 'BE-MLO (Mol, Antwerpen, Belgium)'),
    ('BE-MSJ', 'BE-MSJ (Mol, Antwerpen, Belgium)'),
    ('BE-MWE', 'BE-MWE (Molenbeek-Wersbeek, Vlaams Brabant, Belgium)'),
    ('BE-MND', 'BE-MND (Molenstede, Vlaams Brabant, Belgium)'),
    ('BE-MFG', 'BE-MFG (Molinfaing, Luxembourg, Belgium)'),
    ('BE-MEM', 'BE-MEM (Mollem, Vlaams Brabant, Belgium)'),
    ('BE-MOM', 'BE-MOM (Momignies, Hainaut, Belgium)'),
    ('BE-MIR', 'BE-MIR (Monceau-Imbrechies, Hainaut, Belgium)'),
    ('BE-MSS', 'BE-MSS (Monceau-sur-Sambre, Hainaut, Belgium)'),
    ('BE-MQS', 'BE-MQS (Mons, Hainaut, Belgium)'),
    ('BE-MSI', 'BE-MSI (Monsin, Liège, Belgium)'),
    ('BE-MNT', 'BE-MNT (Mont, Luxembourg, Belgium)'),
    ('BE-MDL', "BE-MDL (Mont-de-L'Enclus, Hainaut, Belgium)"),
    ('BE-MSA', 'BE-MSA (Mont-Saint-Aubert, Hainaut, Belgium)'),
    ('BE-MSU', 'BE-MSU (Mont-Saint-Guibert, Brabant wallon, Belgium)'),
    ('BE-MSG', 'BE-MSG (Mont-Sainte-Aldegonde, Hainaut, Belgium)'),
    ('BE-MMA', 'BE-MMA (Mont-sur-Marchienne, Hainaut, Belgium)'),
    ('BE-MTN', 'BE-MTN (Montegnee, Liège, Belgium)'),
    ('BE-MON', 'BE-MON (Montignies-le-Tilleul, Hainaut, Belgium)'),
    ('BE-MS5', 'BE-MS5 (Montignies-Sur-Roc, Hainaut, Belgium)'),
    ('BE-MGS', 'BE-MGS (Montignies-sur-Sambre, Hainaut, Belgium)'),
    ('BE-MOB', 'BE-MOB (Montleban, Luxembourg, Belgium)'),
    ('BE-MBI', 'BE-MBI (Montroeul-au-Bois, Hainaut, Belgium)'),
    ('BE-MOT', 'BE-MOT (Montzen, Liège, Belgium)'),
    ('BE-MOL', 'BE-MOL (Moorsel, Oost-Vlaanderen, Belgium)'),
    ('BE-MOO', 'BE-MOO (Moorsele, West-Vlaanderen, Belgium)'),
    ('BE-MRS', 'BE-MRS (Moorslede, West-Vlaanderen, Belgium)'),
    ('BE-MRA', 'BE-MRA (Morialme, Namur, Belgium)'),
    ('BE-MLW', 'BE-MLW (Morlanwelz-Mariemont, Hainaut, Belgium)'),
    ('BE-MRO', 'BE-MRO (Mornimont, Namur, Belgium)'),
    ('BE-MTX', 'BE-MTX (Mortroux, Liège, Belgium)'),
    ('BE-MOR', 'BE-MOR (Mortsel, Antwerpen, Belgium)'),
    ('BE-MLX', 'BE-MLX (Moulbaix, Hainaut, Belgium)'),
    ('BE-MCT', 'BE-MCT (Mourcourt, Hainaut, Belgium)'),
    ('BE-MOS', 'BE-MOS (Mouscron (Moeskroen), Hainaut, Belgium)'),
    ('BE-MUS', 'BE-MUS (Moustier, Hainaut, Belgium)'),
    ('BE-MUI', 'BE-MUI (Muizen, Antwerpen, Belgium)'),
    ('BE-MUN', 'BE-MUN (Muno, Luxembourg, Belgium)'),
    ('BE-MBL', 'BE-MBL (Munsterbilzen, Limburg, Belgium)'),
    ('BE-MSL', 'BE-MSL (Musson, Luxembourg, Belgium)'),
    ('BE-MEA', 'BE-MEA (Méan, Namur, Belgium)'),
    ('BE-MEI', 'BE-MEI (Mélin, Brabant wallon, Belgium)'),
    ('BE-MGL', 'BE-MGL (Mévergnies-lez-Lens, Hainaut, Belgium)'),
    ('BE-NAS', 'BE-NAS (Naast, Hainaut, Belgium)'),
    ('BE-NAM', 'BE-NAM (Namur, Namur, Belgium)'),
    ('BE-NMC', 'BE-NMC (Namêche, Namur, Belgium)'),
    ('BE-NDI', 'BE-NDI (Nandrin, Liège, Belgium)'),
    ('BE-NNE', 'BE-NNE (Naninne, Namur, Belgium)'),
    ('BE-NSO', 'BE-NSO (Nassogne, Luxembourg, Belgium)'),
    ('BE-NTE', 'BE-NTE (Natoye, Namur, Belgium)'),
    ('BE-NZH', 'BE-NZH (Nazareth, Oost-Vlaanderen, Belgium)'),
    ('BE-NVH', 'BE-NVH (Neder-Over-Heembeek, Vlaams Brabant, Belgium)'),
    ('BE-NBL', 'BE-NBL (Nederboelare, Oost-Vlaanderen, Belgium)'),
    ('BE-NED', 'BE-NED (Nederokkerzeel, Vlaams Brabant, Belgium)'),
    ('BE-NHR', 'BE-NHR (Nederzwalm-Hermelgem, Oost-Vlaanderen, Belgium)'),
    ('BE-NHA', 'BE-NHA (Neerharen, Limburg, Belgium)'),
    ('BE-NLA', 'BE-NLA (Neerlanden, Vlaams Brabant, Belgium)'),
    ('BE-NRT', 'BE-NRT (Neeroeteren, Limburg, Belgium)'),
    ('BE-NRP', 'BE-NRP (Neerpelt, Limburg, Belgium)'),
    ('BE-NFE', 'BE-NFE (Neffe, Namur, Belgium)'),
    ('BE-NEG', 'BE-NEG (Neigem, Oost-Vlaanderen, Belgium)'),
    ('BE-NES', 'BE-NES (Nessonvaux, Liège, Belgium)'),
    ('BE-NMO', 'BE-NMO (Neu-Moresnet, Liège, Belgium)'),
    ('BE-NCA', 'BE-NCA (Neufchâteau, Liège, Belgium)'),
    ('BE-NCU', 'BE-NCU (Neufchâteau, Luxembourg, Belgium)'),
    ('BE-NMA', 'BE-NMA (Neufmaison, Hainaut, Belgium)'),
    ('BE-NEU', 'BE-NEU (Neufvilles, Hainaut, Belgium)'),
    ('BE-NPE', 'BE-NPE (Neupré, Liège, Belgium)'),
    ('BE-NCO', 'BE-NCO (Neuville-en-Condroz, Liège, Belgium)'),
    ('BE-NHY', 'BE-NHY (Neuville-sous-Huy, Liège, Belgium)'),
    ('BE-NVL', 'BE-NVL (Nevele, Oost-Vlaanderen, Belgium)'),
    ('BE-NDM', 'BE-NDM (Nidrum, Liège, Belgium)'),
    ('BE-NIL', 'BE-NIL (Niel, Antwerpen, Belgium)'),
    ('BE-NWO', 'BE-NWO (Nieuwenhove, Oost-Vlaanderen, Belgium)'),
    ('BE-NWE', 'BE-NWE (Nieuwerkerken, Oost-Vlaanderen, Belgium)'),
    ('BE-NWK', 'BE-NWK (Nieuwerkerken, Limburg, Belgium)'),
    ('BE-NKW', 'BE-NKW (Nieuwkerken-Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-NIE', 'BE-NIE (Nieuwpoort, West-Vlaanderen, Belgium)'),
    ('BE-NRO', 'BE-NRO (Nieuwrode, Vlaams Brabant, Belgium)'),
    ('BE-NYL', 'BE-NYL (Nijlen, Antwerpen, Belgium)'),
    ('BE-NBA', 'BE-NBA (Nimy, Hainaut, Belgium)'),
    ('BE-NNV', 'BE-NNV (Ninove, Oost-Vlaanderen, Belgium)'),
    ('BE-NIV', 'BE-NIV (Nivelles, Brabant wallon, Belgium)'),
    ('BE-NVN', 'BE-NVN (Noeveren, Antwerpen, Belgium)'),
    ('BE-NFO', 'BE-NFO (Noirefontaine, Luxembourg, Belgium)'),
    ('BE-NOK', 'BE-NOK (Nokere, Oost-Vlaanderen, Belgium)'),
    ('BE-NVX', 'BE-NVX (Nollevaux, Luxembourg, Belgium)'),
    ('BE-NDW', 'BE-NDW (Noorderwijk, Antwerpen, Belgium)'),
    ('BE-NSG', 'BE-NSG (Nossegem, Vlaams Brabant, Belgium)'),
    ('BE-NVE', 'BE-NVE (Nouvelles, Hainaut, Belgium)'),
    ('BE-NUK', 'BE-NUK (Nukerke, Oost-Vlaanderen, Belgium)'),
    ('BE-OBI', 'BE-OBI (Obigies, Hainaut, Belgium)'),
    ('BE-OBR', 'BE-OBR (Obourg, Hainaut, Belgium)'),
    ('BE-VLD', 'BE-VLD (Oedelem, West-Vlaanderen, Belgium)'),
    ('BE-OEL', 'BE-OEL (Oelegem, Antwerpen, Belgium)'),
    ('BE-OSG', 'BE-OSG (Oeselgem, West-Vlaanderen, Belgium)'),
    ('BE-OGI', 'BE-OGI (Oeudeghien, Hainaut, Belgium)'),
    ('BE-OEV', 'BE-OEV (Oevel, Antwerpen, Belgium)'),
    ('BE-OGY', 'BE-OGY (Ogy, Hainaut, Belgium)'),
    ('BE-OHA', 'BE-OHA (Ohain, Brabant wallon, Belgium)'),
    ('BE-OHY', 'BE-OHY (Ohey, Namur, Belgium)'),
    ('BE-OQC', 'BE-OQC (Oisquercq, Brabant wallon, Belgium)'),
    ('BE-OKG', 'BE-OKG (Okegem, Oost-Vlaanderen, Belgium)'),
    ('BE-OLN', 'BE-OLN (Olen, Antwerpen, Belgium)'),
    ('BE-OGS', 'BE-OGS (Ollignies, Hainaut, Belgium)'),
    ('BE-OLM', 'BE-OLM (Olmen, Antwerpen, Belgium)'),
    ('BE-ONE', 'BE-ONE (Olne, Liège, Belgium)'),
    ('BE-OLS', 'BE-OLS (Olsene, Oost-Vlaanderen, Belgium)'),
    ('BE-OMA', 'BE-OMA (Omal, Liège, Belgium)'),
    ('BE-OBT', 'BE-OBT (Ombret-Rawsa, Liège, Belgium)'),
    ('BE-OAY', 'BE-OAY (Onhaye, Namur, Belgium)'),
    ('BE-OZL', 'BE-OZL (Onkerzele, Oost-Vlaanderen, Belgium)'),
    ('BE-LVW', 'BE-LVW (Onze-Lieve-Vrouw-Waver, Antwerpen, Belgium)'),
    ('BE-OOG', 'BE-OOG (Ooigem, West-Vlaanderen, Belgium)'),
    ('BE-OOS', 'BE-OOS (Oostakker, Oost-Vlaanderen, Belgium)'),
    ('BE-OKO', 'BE-OKO (Oosteeklo, Oost-Vlaanderen, Belgium)'),
    ('BE-OST', 'BE-OST (Oostende (Ostend), West-Vlaanderen, Belgium)'),
    ('BE-OTL', 'BE-OTL (Oosterlo, Antwerpen, Belgium)'),
    ('BE-OZE', 'BE-OZE (Oosterzele, Oost-Vlaanderen, Belgium)'),
    ('BE-OSH', 'BE-OSH (Oostham, Limburg, Belgium)'),
    ('BE-OKP', 'BE-OKP (Oostkamp, West-Vlaanderen, Belgium)'),
    ('BE-OTK', 'BE-OTK (Oostkerke, West-Vlaanderen, Belgium)'),
    ('BE-OSL', 'BE-OSL (Oostmalle, Antwerpen, Belgium)'),
    ('BE-OSR', 'BE-OSR (Oostrozebeke, West-Vlaanderen, Belgium)'),
    ('BE-OSV', 'BE-OSV (Oostvleteren, West-Vlaanderen, Belgium)'),
    ('BE-OWI', 'BE-OWI (Oostwinkel, Oost-Vlaanderen, Belgium)'),
    ('BE-OPG', 'BE-OPG (Opglabbeek, Limburg, Belgium)'),
    ('BE-OSI', 'BE-OSI (Ophain-Bois-Seigneur-Isaac, Brabant wallon, Belgium)'),
    ('BE-OPH', 'BE-OPH (Ophasselt, Oost-Vlaanderen, Belgium)'),
    ('BE-OHN', 'BE-OHN (Ophoven, Limburg, Belgium)'),
    ('BE-OPI', 'BE-OPI (Opitter, Limburg, Belgium)'),
    ('BE-OPO', 'BE-OPO (Opont, Luxembourg, Belgium)'),
    ('BE-OIJ', 'BE-OIJ (Opwijk, Vlaams Brabant, Belgium)'),
    ('BE-ORQ', 'BE-ORQ (Orcq, Hainaut, Belgium)'),
    ('BE-OYE', 'BE-OYE (Oreye, Liège, Belgium)'),
    ('BE-OGE', 'BE-OGE (Ormeignies, Hainaut, Belgium)'),
    ('BE-OJA', 'BE-OJA (Orp-Jauche, Brabant wallon, Belgium)'),
    ('BE-ORR', 'BE-ORR (Orroir, Hainaut, Belgium)'),
    ('BE-OTO', 'BE-OTO (Ortho, Luxembourg, Belgium)'),
    ('BE-OST', 'BE-OST (Ostend (Oostende), West-Vlaanderen, Belgium)'),
    ('BE-OTS', 'BE-OTS (Ostiches, Hainaut, Belgium)'),
    ('BE-OTG', 'BE-OTG (Otegem, West-Vlaanderen, Belgium)'),
    ('BE-LOA', 'BE-LOA (Oteppe, Liège, Belgium)'),
    ('BE-OTI', 'BE-OTI (Ottignies-Louvain-la Neuve, Brabant wallon, Belgium)'),
    ('BE-OHE', 'BE-OHE (Oud-Heverlee, Vlaams Brabant, Belgium)'),
    ('BE-OTH', 'BE-OTH (Oud-Turnhout, Antwerpen, Belgium)'),
    ('BE-ODM', 'BE-ODM (Oudegem, Oost-Vlaanderen, Belgium)'),
    ('BE-OUD', 'BE-OUD (Oudenaarde, Oost-Vlaanderen, Belgium)'),
    ('BE-ODA', 'BE-ODA (Oudenaken, Vlaams Brabant, Belgium)'),
    ('BE-OBG', 'BE-OBG (Oudenburg, West-Vlaanderen, Belgium)'),
    ('BE-ODE', 'BE-ODE (Oudenburg, West-Vlaanderen, Belgium)'),
    ('BE-OUF', 'BE-OUF (Ouffet, Liège, Belgium)'),
    ('BE-OUG', 'BE-OUG (Ougrée, Liège, Belgium)'),
    ('BE-OPY', 'BE-OPY (Oupeye, Liège, Belgium)'),
    ('BE-OUT', 'BE-OUT (Outer, Oost-Vlaanderen, Belgium)'),
    ('BE-OGA', 'BE-OGA (Outgaarden, Vlaams Brabant, Belgium)'),
    ('BE-OTY', 'BE-OTY (Outrijve, West-Vlaanderen, Belgium)'),
    ('BE-OLE', 'BE-OLE (Overboelare, Oost-Vlaanderen, Belgium)'),
    ('BE-OVR', 'BE-OVR (Overijse, Vlaams Brabant, Belgium)'),
    ('BE-OVE', 'BE-OVE (Overpelt, Limburg, Belgium)'),
    ('BE-PAL', 'BE-PAL (Paal, Limburg, Belgium)'),
    ('BE-PFV', 'BE-PFV (Paifve, Liège, Belgium)'),
    ('BE-PLI', 'BE-PLI (Paliseul, Luxembourg, Belgium)'),
    ('BE-PML', 'BE-PML (Pamel, Vlaams Brabant, Belgium)'),
    ('BE-PGI', 'BE-PGI (Papignies, Hainaut, Belgium)'),
    ('BE-PRI', 'BE-PRI (Parike, Oost-Vlaanderen, Belgium)'),
    ('BE-PAS', 'BE-PAS (Passendale, West-Vlaanderen, Belgium)'),
    ('BE-PCQ', 'BE-PCQ (Pecq, Hainaut, Belgium)'),
    ('BE-PEE', 'BE-PEE (Peer, Limburg, Belgium)'),
    ('BE-PEI', 'BE-PEI (Peisegem, Vlaams Brabant, Belgium)'),
    ('BE-PBE', 'BE-PBE (Pellenberg, Vlaams Brabant, Belgium)'),
    ('BE-PIN', 'BE-PIN (Pepingen, Vlaams Brabant, Belgium)'),
    ('BE-PEP', 'BE-PEP (Pepinster, Liège, Belgium)'),
    ('BE-PER', 'BE-PER (Perk, Vlaams Brabant, Belgium)'),
    ('BE-PRW', 'BE-PRW (Perwez, Namur, Belgium)'),
    ('BE-PWE', 'BE-PWE (Perwez, Brabant wallon, Belgium)'),
    ('BE-PSH', 'BE-PSH (Perwez, Brabant wallon, Belgium)'),
    ('BE-PGE', 'BE-PGE (Petegem, Oost-Vlaanderen, Belgium)'),
    ('BE-PLY', 'BE-PLY (Petit-Lanaye, Liège, Belgium)'),
    ('BE-PTR', 'BE-PTR (Petit-Rechain, Liège, Belgium)'),
    ('BE-PRN', 'BE-PRN (Petit-Roeulx-lez-Nivelles, Hainaut, Belgium)'),
    ('BE-PTI', 'BE-PTI (Petit-Thier, Luxembourg, Belgium)'),
    ('BE-PHI', 'BE-PHI (Philippeville, Namur, Belgium)'),
    ('BE-PTP', 'BE-PTP (Pijp Tabak, Antwerpen, Belgium)'),
    ('BE-PPX', 'BE-PPX (Pipaix, Hainaut, Belgium)'),
    ('BE-PTT', 'BE-PTT (Pittem, West-Vlaanderen, Belgium)'),
    ('BE-PVX', 'BE-PVX (Plainevaux, Liège, Belgium)'),
    ('BE-PSD', 'BE-PSD (Plassendale, West-Vlaanderen, Belgium)'),
    ('BE-PSE', 'BE-PSE (Ploegsteert, Hainaut, Belgium)'),
    ('BE-PBI', 'BE-PBI (Plombières, Liège, Belgium)'),
    ('BE-QPD', 'BE-QPD (Plombières, Liège, Belgium)'),
    ('BE-POL', 'BE-POL (Pollare, Oost-Vlaanderen, Belgium)'),
    ('BE-PKH', 'BE-PKH (Pollinkhove, West-Vlaanderen, Belgium)'),
    ('BE-PME', 'BE-PME (Pommeroeul, Hainaut, Belgium)'),
    ('BE-PRO', 'BE-PRO (Pondrôme, Namur, Belgium)'),
    ('BE-PLO', 'BE-PLO (Pont-de-Loup, Hainaut, Belgium)'),
    ('BE-PCL', 'BE-PCL (Pont-à-Celles, Hainaut, Belgium)'),
    ('BE-POP', 'BE-POP (Poperinge, West-Vlaanderen, Belgium)'),
    ('BE-PPE', 'BE-PPE (Poppel, Antwerpen, Belgium)'),
    ('BE-PST', 'BE-PST (Postel, Antwerpen, Belgium)'),
    ('BE-PTS', 'BE-PTS (Pottes, Hainaut, Belgium)'),
    ('BE-PSU', 'BE-PSU (Poulseur, Liège, Belgium)'),
    ('BE-PFE', 'BE-PFE (Profondeville, Namur, Belgium)'),
    ('BE-PRV', 'BE-PRV (Proven, West-Vlaanderen, Belgium)'),
    ('BE-PUL', 'BE-PUL (Pulderbos, Antwerpen, Belgium)'),
    ('BE-PLE', 'BE-PLE (Pulle, Antwerpen, Belgium)'),
    ('BE-PUR', 'BE-PUR (Purnode, Namur, Belgium)'),
    ('BE-PUT', 'BE-PUT (Putte, Antwerpen, Belgium)'),
    ('BE-PUU', 'BE-PUU (Puurs, Antwerpen, Belgium)'),
    ('BE-PES', 'BE-PES (Péronnes, Hainaut, Belgium)'),
    ('BE-PLB', 'BE-PLB (Péronnes/Binche, Hainaut, Belgium)'),
    ('BE-PWZ', 'BE-PWZ (Péruwelz, Hainaut, Belgium)'),
    ('BE-QRO', 'BE-QRO (Quaregnon, Hainaut, Belgium)'),
    ('BE-QAR', 'BE-QAR (Quartes, Hainaut, Belgium)'),
    ('BE-QUE', 'BE-QUE (Quenast, Brabant wallon, Belgium)'),
    ('BE-QCA', 'BE-QCA (Quevaucamps, Hainaut, Belgium)'),
    ('BE-QVA', 'BE-QVA (Quiévrain, Hainaut, Belgium)'),
    ('BE-QVY', 'BE-QVY (Quévy, Hainaut, Belgium)'),
    ('BE-RCO', 'BE-RCO (Rachecourt, Luxembourg, Belgium)'),
    ('BE-RAE', 'BE-RAE (Raeren, Liège, Belgium)'),
    ('BE-RAG', 'BE-RAG (Ragnies, Hainaut, Belgium)'),
    ('BE-RHE', 'BE-RHE (Rahier, Liège, Belgium)'),
    ('BE-RGS', 'BE-RGS (Ramegnies, Hainaut, Belgium)'),
    ('BE-RCI', 'BE-RCI (Ramegnies-Chin, Hainaut, Belgium)'),
    ('BE-RMI', 'BE-RMI (Ramillies, Brabant wallon, Belgium)'),
    ('BE-RMD', 'BE-RMD (Ramsdonk, Vlaams Brabant, Belgium)'),
    ('BE-RKP', 'BE-RKP (Ramskapelle, West-Vlaanderen, Belgium)'),
    ('BE-RSA', 'BE-RSA (Ransart, Hainaut, Belgium)'),
    ('BE-RAS', 'BE-RAS (Ranst, Antwerpen, Belgium)'),
    ('BE-RVS', 'BE-RVS (Ravels, Antwerpen, Belgium)'),
    ('BE-RBX', 'BE-RBX (Rebaix, Hainaut, Belgium)'),
    ('BE-RBQ', 'BE-RBQ (Rebecq, Brabant wallon, Belgium)'),
    ('BE-REC', 'BE-REC (Recogne, Luxembourg, Belgium)'),
    ('BE-RET', 'BE-RET (Reet, Antwerpen, Belgium)'),
    ('BE-REM', 'BE-REM (Rekem, Limburg, Belgium)'),
    ('BE-REK', 'BE-REK (Rekkem, Oost-Vlaanderen, Belgium)'),
    ('BE-RKM', 'BE-RKM (Rekkem, West-Vlaanderen, Belgium)'),
    ('BE-RGM', 'BE-RGM (Relegem, Vlaams Brabant, Belgium)'),
    ('BE-RDA', 'BE-RDA (Remersdaal, Limburg, Belgium)'),
    ('BE-RCU', 'BE-RCU (Remicourt, Liège, Belgium)'),
    ('BE-REN', 'BE-REN (Rendeux, Luxembourg, Belgium)'),
    ('BE-RGE', 'BE-RGE (Reninge, West-Vlaanderen, Belgium)'),
    ('BE-NRY', 'BE-NRY (Renory, Liège, Belgium)'),
    ('BE-VGR', 'BE-VGR (Renory, Liège, Belgium)'),
    ('BE-RSX', 'BE-RSX (Ressaix, Hainaut, Belgium)'),
    ('BE-RSE', 'BE-RSE (Ressegem, Oost-Vlaanderen, Belgium)'),
    ('BE-RTI', 'BE-RTI (Retie, Antwerpen, Belgium)'),
    ('BE-RTE', 'BE-RTE (Retinne, Liège, Belgium)'),
    ('BE-RCL', 'BE-RCL (Richelle, Liège, Belgium)'),
    ('BE-RIE', 'BE-RIE (Rieme, Oost-Vlaanderen, Belgium)'),
    ('BE-RIS', 'BE-RIS (Riemst, Limburg, Belgium)'),
    ('BE-RIJ', 'BE-RIJ (Rijkevorsel, Antwerpen, Belgium)'),
    ('BE-RNM', 'BE-RNM (Rijmenam, Antwerpen, Belgium)'),
    ('BE-RLA', 'BE-RLA (Rillaar, Vlaams Brabant, Belgium)'),
    ('BE-XXX', 'BE-XXX (Rillaar, Vlaams Brabant, Belgium)'),
    ('BE-RVE', 'BE-RVE (Rivière, Namur, Belgium)'),
    ('BE-RIX', 'BE-RIX (Rixensart, Brabant wallon, Belgium)'),
    ('BE-RZE', 'BE-RZE (Rièzes, Hainaut, Belgium)'),
    ('BE-ROC', 'BE-ROC (Rochefort, Namur, Belgium)'),
    ('BE-RRA', 'BE-RRA (Rocherath, Liège, Belgium)'),
    ('BE-RJT', 'BE-RJT (Rocherath, Liège, Belgium)'),
    ('BE-RBE', 'BE-RBE (Roesbrugge, West-Vlaanderen, Belgium)'),
    ('BE-RHA', 'BE-RHA (Roesbrugge-Haringe, West-Vlaanderen, Belgium)'),
    ('BE-ROE', 'BE-ROE (Roeselare, West-Vlaanderen, Belgium)'),
    ('BE-ROG', 'BE-ROG (Rognée, Namur, Belgium)'),
    ('BE-ROL', 'BE-ROL (Rollegem, West-Vlaanderen, Belgium)'),
    ('BE-ROM', 'BE-ROM (Romsée, Liège, Belgium)'),
    ('BE-RGY', 'BE-RGY (Rongy, Hainaut, Belgium)'),
    ('BE-RQS', 'BE-RQS (Ronquières, Hainaut, Belgium)'),
    ('BE-RON', 'BE-RON (Ronse, Oost-Vlaanderen, Belgium)'),
    ('BE-RLE', 'BE-RLE (Ronsele, Oost-Vlaanderen, Belgium)'),
    ('BE-RDL', 'BE-RDL (Roosdaal, Vlaams Brabant, Belgium)'),
    ('BE-ROS', 'BE-ROS (Roselies, Hainaut, Belgium)'),
    ('BE-RSI', 'BE-RSI (Rosières, Brabant wallon, Belgium)'),
    ('BE-RSS', 'BE-RSS (Rosières, Brabant wallon, Belgium)'),
    ('BE-ROT', 'BE-ROT (Rotem, Limburg, Belgium)'),
    ('BE-RBA', 'BE-RBA (Rotselaar, Vlaams Brabant, Belgium)'),
    ('BE-RCT', 'BE-RCT (Roucourt, Hainaut, Belgium)'),
    ('BE-RVY', 'BE-RVY (Rouvroy, Luxembourg, Belgium)'),
    ('BE-ROX', 'BE-ROX (Roux, Hainaut, Belgium)'),
    ('BE-RUV', 'BE-RUV (Ruddervoorde, West-Vlaanderen, Belgium)'),
    ('BE-RUE', 'BE-RUE (Ruien, Oost-Vlaanderen, Belgium)'),
    ('BE-RUI', 'BE-RUI (Ruisbroek, Vlaams Brabant, Belgium)'),
    ('BE-SVG', 'BE-SVG (Ruisbroek, Antwerpen, Belgium)'),
    ('BE-RSL', 'BE-RSL (Ruiselede, West-Vlaanderen, Belgium)'),
    ('BE-RLS', 'BE-RLS (Rulles, Luxembourg, Belgium)'),
    ('BE-RUM', 'BE-RUM (Rumbeke, West-Vlaanderen, Belgium)'),
    ('BE-RMS', 'BE-RMS (Rumes, Hainaut, Belgium)'),
    ('BE-RML', 'BE-RML (Rumillies, Hainaut, Belgium)'),
    ('BE-RMU', 'BE-RMU (Rummen, Vlaams Brabant, Belgium)'),
    ('BE-RUS', 'BE-RUS (Rumst, Antwerpen, Belgium)'),
    ('BE-RKE', 'BE-RKE (Runkelen, Limburg, Belgium)'),
    ('BE-RPM', 'BE-RPM (Rupelmonde, Oost-Vlaanderen, Belgium)'),
    ('BE-SAM', 'BE-SAM (Saint-Amand, Hainaut, Belgium)'),
    ('BE-SDE', 'BE-SDE (Saint-Denis, Namur, Belgium)'),
    ('BE-SDI', 'BE-SDI (Saint-Denis, Hainaut, Belgium)'),
    ('BE-SGS', 'BE-SGS (Saint-Georges, Liège, Belgium)'),
    ('BE-GSM', 'BE-GSM (Saint-Georges-sur-Meuse, Liège, Belgium)'),
    ('BE-GHI', 'BE-GHI (Saint-Ghislain, Hainaut, Belgium)'),
    ('BE-SGI', 'BE-SGI (Saint-Ghislain, Hainaut, Belgium)'),
    ('BE-SHU', 'BE-SHU (Saint-Hubert, Luxembourg, Belgium)'),
    ('BE-SJN', 'BE-SJN (Saint-Hubert, Luxembourg, Belgium)'),
    ('BE-SLG', 'BE-SLG (Saint-Léger, Luxembourg, Belgium)'),
    ('BE-SMC', 'BE-SMC (Saint-Marc, Namur, Belgium)'),
    ('BE-SMA', 'BE-SMA (Saint-Mard, Luxembourg, Belgium)'),
    ('BE-SNO', 'BE-SNO (Saint-Nicolas, Liège, Belgium)'),
    ('BE-SRY', 'BE-SRY (Saint-Rémy, Liège, Belgium)'),
    ('BE-SSA', 'BE-SSA (Saint-Sauveur, Hainaut, Belgium)'),
    ('BE-SSI', 'BE-SSI (Saint-Servais, Namur, Belgium)'),
    ('BE-SSY', 'BE-SSY (Saint-Symphorien, Hainaut, Belgium)'),
    ('BE-SDZ', 'BE-SDZ (Saint-Vincent, Luxembourg, Belgium)'),
    ('BE-SVH', 'BE-SVH (Saint-Vith, Liège, Belgium)'),
    ('BE-SCC', 'BE-SCC (Saint-Vith, Liège, Belgium)'),
    ('BE-SOD', 'BE-SOD (Sainte-Ode, Luxembourg, Belgium)'),
    ('BE-STS', 'BE-STS (Saintes, Brabant wallon, Belgium)'),
    ('BE-SIV', 'BE-SIV (Saive, Liège, Belgium)'),
    ('BE-SLS', 'BE-SLS (Salles, Hainaut, Belgium)'),
    ('BE-SZI', 'BE-SZI (Salzinnes, Namur, Belgium)'),
    ('BE-SAV', 'BE-SAV (Sambreville, Namur, Belgium)'),
    ('BE-SAR', 'BE-SAR (Samrée, Luxembourg, Belgium)'),
    ('BE-SSO', 'BE-SSO (Samson, Namur, Belgium)'),
    ('BE-VIT', 'BE-VIT (Samson, Namur, Belgium)'),
    ('BE-SBU', 'BE-SBU (Sars-la-Buissière, Hainaut, Belgium)'),
    ('BE-WLS', 'BE-WLS (Sars-la-Buissière, Hainaut, Belgium)'),
    ('BE-SLJ', 'BE-SLJ (Sas-Slijkens, West-Vlaanderen, Belgium)'),
    ('BE-STN', 'BE-STN (Sautin, Hainaut, Belgium)'),
    ('BE-SCH', 'BE-SCH (Schaarbeek, Oost-Vlaanderen, Belgium)'),
    ('BE-SBK', 'BE-SBK (Schaarbeek, Oost-Vlaanderen, Belgium)'),
    ('BE-SBK', 'BE-SBK (Schaarbeek, Oost-Vlaanderen, Belgium)'),
    ('BE-SHO', 'BE-SHO (Schalkhoven, Limburg, Belgium)'),
    ('BE-STI', 'BE-STI (Schaltin, Namur, Belgium)'),
    ('BE-SPE', 'BE-SPE (Scheepsdale, West-Vlaanderen, Belgium)'),
    ('BE-SHR', 'BE-SHR (Schelderode, Oost-Vlaanderen, Belgium)'),
    ('BE-SHL', 'BE-SHL (Schelle, Antwerpen, Belgium)'),
    ('BE-SHB', 'BE-SHB (Schellebelle, Oost-Vlaanderen, Belgium)'),
    ('BE-SHE', 'BE-SHE (Schendelbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-SDA', 'BE-SDA (Schepdaal, Vlaams Brabant, Belgium)'),
    ('BE-SPU', 'BE-SPU (Scherpenheuvel-Zichem, Vlaams Brabant, Belgium)'),
    ('BE-SCE', 'BE-SCE (Schilde, Antwerpen, Belgium)'),
    ('BE-SOB', 'BE-SOB (Schoenberg, Liège, Belgium)'),
    ('BE-SNE', 'BE-SNE (Schoonaarde, Oost-Vlaanderen, Belgium)'),
    ('BE-SOR', 'BE-SOR (Schore, West-Vlaanderen, Belgium)'),
    ('BE-SRI', 'BE-SRI (Schorisse, Oost-Vlaanderen, Belgium)'),
    ('BE-SCT', 'BE-SCT (Schoten, Antwerpen, Belgium)'),
    ('BE-SKI', 'BE-SKI (Schriek, Antwerpen, Belgium)'),
    ('BE-SGX', 'BE-SGX (Sclaigneaux, Namur, Belgium)'),
    ('BE-SLY', 'BE-SLY (Sclayn, Namur, Belgium)'),
    ('BE-SSN', 'BE-SSN (Sclessin, Liège, Belgium)'),
    ('BE-SCY', 'BE-SCY (Scy, Namur, Belgium)'),
    ('BE-SES', 'BE-SES (Seilles, Namur, Belgium)'),
    ('BE-SOG', 'BE-SOG (Seloignes, Hainaut, Belgium)'),
    ('BE-SEN', 'BE-SEN (Seneffe, Hainaut, Belgium)'),
    ('BE-SSU', 'BE-SSU (Sensenruth, Luxembourg, Belgium)'),
    ('BE-SYE', 'BE-SYE (Sensenruth, Luxembourg, Belgium)'),
    ('BE-ZER', 'BE-ZER (Seraing, Liège, Belgium)'),
    ('BE-SKM', 'BE-SKM (Serskamp, Oost-Vlaanderen, Belgium)'),
    ('BE-SVI', 'BE-SVI (Serville, Namur, Belgium)'),
    ('BE-SJL', 'BE-SJL (Sijsele, West-Vlaanderen, Belgium)'),
    ('BE-SIY', 'BE-SIY (Silly, Hainaut, Belgium)'),
    ('BE-SNA', 'BE-SNA (Sinaai, Oost-Vlaanderen, Belgium)'),
    ('BE-GIL', 'BE-GIL (Sint Gillis Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-SJB', 'BE-SJB (Sint Gillis Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-SKA', 'BE-SKA (Sint Gillis Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-VGW', 'BE-VGW (Sint Gillis Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-BSA', 'BE-BSA (Sint Gillis Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-SAS', 'BE-SAS (Sint-Amands, Antwerpen, Belgium)'),
    ('BE-SFY', 'BE-SFY (Sint-Amandsberg, Oost-Vlaanderen, Belgium)'),
    ('BE-SAN', 'BE-SAN (Sint-Andries, West-Vlaanderen, Belgium)'),
    ('BE-STV', 'BE-STV (Sint-Baafs-Vijve, West-Vlaanderen, Belgium)'),
    ('BE-SDY', 'BE-SDY (Sint-Denijs, West-Vlaanderen, Belgium)'),
    ('BE-SDW', 'BE-SDW (Sint-Denijs-Westrem, Oost-Vlaanderen, Belgium)'),
    ('BE-SEV', 'BE-SEV (Sint-Eloois-Vijve, West-Vlaanderen, Belgium)'),
    ('BE-EWK', 'BE-EWK (Sint-Eloois-Winkel, West-Vlaanderen, Belgium)'),
    ('BE-SGR', 'BE-SGR (Sint-Genesius-Rode (Rhode-Saint-Genèse), Vlaams Brabant, Belgium)'),
    ('BE-SGI', 'BE-SGI (Sint-Genesius-Rode (Rhode-Saint-Genèse), Vlaams Brabant, Belgium)'),
    ('BE-SGW', 'BE-SGW (Sint-Gillis-Waas, Oost-Vlaanderen, Belgium)'),
    ('BE-HSL', 'BE-HSL (Sint-Huibrechts-Lille, Limburg, Belgium)'),
    ('BE-JKP', 'BE-JKP (Sint-Jacobs-Kapelle, West-Vlaanderen, Belgium)'),
    ('BE-SJE', 'BE-SJE (Sint-Jan-in-Eremo, Oost-Vlaanderen, Belgium)'),
    ('BE-MSJ', 'BE-MSJ (Sint-Jan-in-Eremo, Oost-Vlaanderen, Belgium)'),
    ('BE-SJG', "BE-SJG (Sint-Job-in-'t-Goor, Antwerpen, Belgium)"),
    ('BE-SJN', "BE-SJN (Sint-Job-in-'t-Goor, Antwerpen, Belgium)"),
    ('BE-SJR', 'BE-SJR (Sint-Joris, West-Vlaanderen, Belgium)'),
    ('BE-SJW', 'BE-SJW (Sint-Joris-Weert, Vlaams Brabant, Belgium)'),
    ('BE-SJO', 'BE-SJO (Sint-Jozef-Olen, Antwerpen, Belgium)'),
    ('BE-SSL', 'BE-SSL (Sint-Katelijne-Waver, Antwerpen, Belgium)'),
    ('BE-SKL', 'BE-SKL (Sint-Katherina-Lombeek, Vlaams Brabant, Belgium)'),
    ('BE-SKU', 'BE-SKU (Sint-Kruis, West-Vlaanderen, Belgium)'),
    ('BE-SKW', 'BE-SKW (Sint-Kruis-Winkel, Oost-Vlaanderen, Belgium)'),
    ('BE-SLW', 'BE-SLW (Sint-Kruis-Winkel, Oost-Vlaanderen, Belgium)'),
    ('BE-SLU', 'BE-SLU (Sint-Laureins, Oost-Vlaanderen, Belgium)'),
    ('BE-SLN', 'BE-SLN (Sint-Lenaarts, Antwerpen, Belgium)'),
    ('BE-SII', 'BE-SII (Sint-Lievens-Esse, Oost-Vlaanderen, Belgium)'),
    ('BE-SHM', 'BE-SHM (Sint-Lievens-Houtem, Oost-Vlaanderen, Belgium)'),
    ('BE-SLH', 'BE-SLH (Sint-Lievens-Houtem, Oost-Vlaanderen, Belgium)'),
    ('BE-SMR', 'BE-SMR (Sint-Margriete, Oost-Vlaanderen, Belgium)'),
    ('BE-SMB', 'BE-SMB (Sint-Martens-Bodegem, Vlaams Brabant, Belgium)'),
    ('BE-SML', 'BE-SML (Sint-Martens-Latem, Oost-Vlaanderen, Belgium)'),
    ('BE-SMI', 'BE-SMI (Sint-Martens-Lierde, Oost-Vlaanderen, Belgium)'),
    ('BE-SME', 'BE-SME (Sint-Michiels, West-Vlaanderen, Belgium)'),
    ('BE-SNK', 'BE-SNK (Sint-Niklaas, Oost-Vlaanderen, Belgium)'),
    ('BE-STP', 'BE-STP (Sint-Niklaas, Oost-Vlaanderen, Belgium)'),
    ('BE-SPL', 'BE-SPL (Sint-Pieers-Leeuw, Vlaams Brabant, Belgium)'),
    ('BE-SPK', 'BE-SPK (Sint-Pieters-Kapelle, Vlaams Brabant, Belgium)'),
    ('BE-SPT', 'BE-SPT (Sint-Pieters-Leeuw, Vlaams Brabant, Belgium)'),
    ('BE-SPV', 'BE-SPV (Sint-Pieters-Voeren, Limburg, Belgium)'),
    ('BE-SPO', 'BE-SPO (Sint-Pieters-Voeren, Limburg, Belgium)'),
    ('BE-STW', 'BE-STW (Sint-Stevens-Woluwe, Vlaams Brabant, Belgium)'),
    ('BE-STR', 'BE-STR (Sint-Truiden, Limburg, Belgium)'),
    ('BE-SIP', 'BE-SIP (Sippenaeken, Liège, Belgium)'),
    ('BE-SRA', 'BE-SRA (Sirault, Hainaut, Belgium)'),
    ('BE-SYR', 'BE-SYR (Sivry-Rance, Hainaut, Belgium)'),
    ('BE-SLE', 'BE-SLE (Sleidinge, Oost-Vlaanderen, Belgium)'),
    ('BE-SYP', 'BE-SYP (Slijpe, West-Vlaanderen, Belgium)'),
    ('BE-SVO', 'BE-SVO (Smeerebbe-Vloerzegem, Oost-Vlaanderen, Belgium)'),
    ('BE-SMM', 'BE-SMM (Smeermaas, Limburg, Belgium)'),
    ('BE-SSK', 'BE-SSK (Snaaskerke, West-Vlaanderen, Belgium)'),
    ('BE-SOI', 'BE-SOI (Soignies, Hainaut, Belgium)'),
    ('BE-SON', 'BE-SON (Soiron, Liège, Belgium)'),
    ('BE-SSB', 'BE-SSB (Solre-sur-Sambre, Hainaut, Belgium)'),
    ('BE-SBF', 'BE-SBF (Sombreffe, Namur, Belgium)'),
    ('BE-SUZ', 'BE-SUZ (Somme-Leuze, Namur, Belgium)'),
    ('BE-SOM', 'BE-SOM (Sommière, Namur, Belgium)'),
    ('BE-SZE', 'BE-SZE (Somzée, Namur, Belgium)'),
    ('BE-SLO', 'BE-SLO (Sorinne-la-Longue, Namur, Belgium)'),
    ('BE-SRN', 'BE-SRN (Sorinnes, Namur, Belgium)'),
    ('BE-SDT', 'BE-SDT (Soudromont, Hainaut, Belgium)'),
    ('BE-SOU', 'BE-SOU (Soumagne, Liège, Belgium)'),
    ('BE-SRE', 'BE-SRE (Souvret, Hainaut, Belgium)'),
    ('BE-SOY', 'BE-SOY (Soy, Luxembourg, Belgium)'),
    ('BE-SWL', 'BE-SWL (Soy, Luxembourg, Belgium)'),
    ('BE-SPA', 'BE-SPA (Spa, Liège, Belgium)'),
    ('BE-SLK', 'BE-SLK (Spalbeek, Limburg, Belgium)'),
    ('BE-SPS', 'BE-SPS (Spiennes, Hainaut, Belgium)'),
    ('BE-SPI', 'BE-SPI (Spiere (Espierres), West-Vlaanderen, Belgium)'),
    ('BE-SMO', 'BE-SMO (Sprimont, Liège, Belgium)'),
    ('BE-STA', 'BE-STA (Stabroek, Antwerpen, Belgium)'),
    ('BE-STD', 'BE-STD (Staden, West-Vlaanderen, Belgium)'),
    ('BE-SBG', 'BE-SBG (Stambruges, Hainaut, Belgium)'),
    ('BE-SGM', 'BE-SGM (Stasegem, West-Vlaanderen, Belgium)'),
    ('BE-STT', 'BE-STT (Statte, Liège, Belgium)'),
    ('BE-SAT', 'BE-SAT (Stave, Namur, Belgium)'),
    ('BE-SVE', 'BE-SVE (Stavele, West-Vlaanderen, Belgium)'),
    ('BE-SLT', 'BE-SLT (Stavelot, Liège, Belgium)'),
    ('BE-SBE', 'BE-SBE (Steenbrugge, West-Vlaanderen, Belgium)'),
    ('BE-SDP', 'BE-SDP (Steendorp, Oost-Vlaanderen, Belgium)'),
    ('BE-SHF', 'BE-SHF (Steenhuffel, Vlaams Brabant, Belgium)'),
    ('BE-SKE', 'BE-SKE (Steenkerke, West-Vlaanderen, Belgium)'),
    ('BE-SKK', 'BE-SKK (Steenokkerzeel, Vlaams Brabant, Belgium)'),
    ('BE-STK', 'BE-STK (Stekene, Oost-Vlaanderen, Belgium)'),
    ('BE-STM', 'BE-STM (Stembert, Liège, Belgium)'),
    ('BE-SPH', 'BE-SPH (Sterpenich, Luxembourg, Belgium)'),
    ('BE-SRB', 'BE-SRB (Sterrebeek, Vlaams Brabant, Belgium)'),
    ('BE-SVN', 'BE-SVN (Stevensvennen, Limburg, Belgium)'),
    ('BE-SVR', 'BE-SVR (Stevoort, Limburg, Belgium)'),
    ('BE-SKR', 'BE-SKR (Stokrooie, Limburg, Belgium)'),
    ('BE-STU', 'BE-STU (Stoumont, Liège, Belgium)'),
    ('BE-SOV', 'BE-SOV (Strombeek-Bever, Vlaams Brabant, Belgium)'),
    ('BE-STE', 'BE-STE (Strée, Hainaut, Belgium)'),
    ('BE-STB', 'BE-STB (Strépy-Bracquegnies, Hainaut, Belgium)'),
    ('BE-SUA', 'BE-SUA (Suarlée, Namur, Belgium)'),
    ('BE-SXY', 'BE-SXY (Suxy, Luxembourg, Belgium)'),
    ('BE-SLA', 'BE-SLA (Sélange, Luxembourg, Belgium)'),
    ('BE-TLS', 'BE-TLS (Tailles, Luxembourg, Belgium)'),
    ('BE-TTI', 'BE-TTI (Taintignies, Hainaut, Belgium)'),
    ('BE-TMS', 'BE-TMS (Tamines, Namur, Belgium)'),
    ('BE-TCI', 'BE-TCI (Tarcienne, Namur, Belgium)'),
    ('BE-TVI', 'BE-TVI (Tavier, Liège, Belgium)'),
    ('BE-TVY', 'BE-TVY (Tavigny, Luxembourg, Belgium)'),
    ('BE-TLI', 'BE-TLI (Tellin, Luxembourg, Belgium)'),
    ('BE-TPU', 'BE-TPU (Templeuve, Hainaut, Belgium)'),
    ('BE-TPX', 'BE-TPX (Temploux, Namur, Belgium)'),
    ('BE-TSE', 'BE-TSE (Temse, Oost-Vlaanderen, Belgium)'),
    ('BE-TVL', 'BE-TVL (Tenneville, Luxembourg, Belgium)'),
    ('BE-TFN', 'BE-TFN (Teralfene, Vlaams Brabant, Belgium)'),
    ('BE-TDK', 'BE-TDK (Terdonk, Oost-Vlaanderen, Belgium)'),
    ('BE-TGE', 'BE-TGE (Tergnée, Hainaut, Belgium)'),
    ('BE-TGN', 'BE-TGN (Terhagen, Antwerpen, Belgium)'),
    ('BE-TRE', 'BE-TRE (Termes, Luxembourg, Belgium)'),
    ('BE-LNY', 'BE-LNY (Ternaaien (Lanaye), Liège, Belgium)'),
    ('BE-TER', 'BE-TER (Ternat, Vlaams Brabant, Belgium)'),
    ('BE-TET', 'BE-TET (Tertre, Hainaut, Belgium)'),
    ('BE-TEN', 'BE-TEN (Tervuren, Vlaams Brabant, Belgium)'),
    ('BE-TES', 'BE-TES (Tessenderlo, Limburg, Belgium)'),
    ('BE-TTT', 'BE-TTT (Testelt, Vlaams Brabant, Belgium)'),
    ('BE-TEU', 'BE-TEU (Teuven, Limburg, Belgium)'),
    ('BE-TAP', 'BE-TAP (Theux, Liège, Belgium)'),
    ('BE-THE', 'BE-THE (Thieu, Hainaut, Belgium)'),
    ('BE-TLA', 'BE-TLA (Thieulain, Hainaut, Belgium)'),
    ('BE-TSI', 'BE-TSI (Thieusies, Hainaut, Belgium)'),
    ('BE-TST', 'BE-TST (Thimister, Liège, Belgium)'),
    ('BE-TCL', 'BE-TCL (Thimister-Clermont, Liège, Belgium)'),
    ('BE-TUG', 'BE-TUG (Thimougies, Hainaut, Belgium)'),
    ('BE-THI', 'BE-THI (Thines, Brabant wallon, Belgium)'),
    ('BE-THO', 'BE-THO (Thommen, Liège, Belgium)'),
    ('BE-THS', 'BE-THS (Thon Samson, Namur, Belgium)'),
    ('BE-TRG', 'BE-TRG (Thorembais-les-Beguines, Brabant wallon, Belgium)'),
    ('BE-THT', 'BE-THT (Thorembais-Saint-Trond, Brabant wallon, Belgium)'),
    ('BE-TOB', 'BE-TOB (Thorembais-Saint-Trond, Brabant wallon, Belgium)'),
    ('BE-TUL', 'BE-TUL (Thuillies, Hainaut, Belgium)'),
    ('BE-THU', 'BE-THU (Thuin, Hainaut, Belgium)'),
    ('BE-THL', 'BE-THL (Thulin, Hainaut, Belgium)'),
    ('BE-TMA', 'BE-TMA (Thumaide, Hainaut, Belgium)'),
    ('BE-THY', 'BE-THY (Thy-le-Château, Namur, Belgium)'),
    ('BE-TYS', 'BE-TYS (Thynes, Namur, Belgium)'),
    ('BE-TIG', 'BE-TIG (Tiegem, West-Vlaanderen, Belgium)'),
    ('BE-TLN', 'BE-TLN (Tielen, Antwerpen, Belgium)'),
    ('BE-TIL', 'BE-TIL (Tielrode, Oost-Vlaanderen, Belgium)'),
    ('BE-TLT', 'BE-TLT (Tielt, West-Vlaanderen, Belgium)'),
    ('BE-TTL', 'BE-TTL (Tielt, Vlaams Brabant, Belgium)'),
    ('BE-TWI', 'BE-TWI (Tielt-Winge, Vlaams Brabant, Belgium)'),
    ('BE-TIE', 'BE-TIE (Tienen, Vlaams Brabant, Belgium)'),
    ('BE-THG', 'BE-THG (Tihange, Liège, Belgium)'),
    ('BE-TLK', 'BE-TLK (Tildonk, Vlaams Brabant, Belgium)'),
    ('BE-TLF', 'BE-TLF (Tilff, Liège, Belgium)'),
    ('BE-TLR', 'BE-TLR (Tilleur, Liège, Belgium)'),
    ('BE-TLY', 'BE-TLY (Tilly, Brabant wallon, Belgium)'),
    ('BE-TLO', 'BE-TLO (Tinlot, Liège, Belgium)'),
    ('BE-TTY', 'BE-TTY (Tintigny, Luxembourg, Belgium)'),
    ('BE-TIS', 'BE-TIS (Tisselt, Antwerpen, Belgium)'),
    ('BE-TOH', 'BE-TOH (Tohogne, Luxembourg, Belgium)'),
    ('BE-TON', 'BE-TON (Tongeren, Limburg, Belgium)'),
    ('BE-TGL', 'BE-TGL (Tongerlo, Limburg, Belgium)'),
    ('BE-TND', 'BE-TND (Tongre-Notre-Dame, Hainaut, Belgium)'),
    ('BE-TRT', 'BE-TRT (Torhout, West-Vlaanderen, Belgium)'),
    ('BE-TRI', 'BE-TRI (Tourinne, Liège, Belgium)'),
    ('BE-TSL', 'BE-TSL (Tourinne, Liège, Belgium)'),
    ('BE-TRN', 'BE-TRN (Tournai (Doornik), Hainaut, Belgium)'),
    ('BE-TNO', 'BE-TNO (Tournay, Luxembourg, Belgium)'),
    ('BE-TBE', 'BE-TBE (Tournebride, Limburg, Belgium)'),
    ('BE-TUP', 'BE-TUP (Tourpes, Hainaut, Belgium)'),
    ('BE-TZI', 'BE-TZI (Trazegnies, Hainaut, Belgium)'),
    ('BE-TMO', 'BE-TMO (Tremelo, Vlaams Brabant, Belgium)'),
    ('BE-TPO', 'BE-TPO (Trois-Ponts, Liège, Belgium)'),
    ('BE-TRO', 'BE-TRO (Trooz, Liège, Belgium)'),
    ('BE-TBZ', 'BE-TBZ (Tubize, Brabant wallon, Belgium)'),
    ('BE-TUR', 'BE-TUR (Turnhout, Antwerpen, Belgium)'),
    ('BE-UKE', 'BE-UKE (Turnhout, Antwerpen, Belgium)'),
    ('BE-UCI', 'BE-UCI (Ucimont, Luxembourg, Belgium)'),
    ('BE-UKO', 'BE-UKO (Uikhoven, Limburg, Belgium)'),
    ('BE-UIT', 'BE-UIT (Uitbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-UKE', 'BE-UKE (Uitbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-ULB', 'BE-ULB (Ulbeek, Limburg, Belgium)'),
    ('BE-USL', 'BE-USL (Ursel, Oost-Vlaanderen, Belgium)'),
    ('BE-VBE', 'BE-VBE (Vaalbeek, Vlaams Brabant, Belgium)'),
    ('BE-VSB', 'BE-VSB (Val Saint-Lambert, Liège, Belgium)'),
    ('BE-VCE', 'BE-VCE (Vance, Luxembourg, Belgium)'),
    ('BE-VRD', 'BE-VRD (Varendonk, Antwerpen, Belgium)'),
    ('BE-VLX', 'BE-VLX (Vaulx, Hainaut, Belgium)'),
    ('BE-VSC', 'BE-VSC (Vaux-sous-Chèvremont, Liège, Belgium)'),
    ('BE-VSU', 'BE-VSU (Vaux-sur-Sûre, Luxembourg, Belgium)'),
    ('BE-VDI', 'BE-VDI (Vedrin, Namur, Belgium)'),
    ('BE-VEL', 'BE-VEL (Veerle, Antwerpen, Belgium)'),
    ('BE-VEA', 'BE-VEA (Velaine-sur-Sambre, Namur, Belgium)'),
    ('BE-VDM', 'BE-VDM (Veldegem, West-Vlaanderen, Belgium)'),
    ('BE-VWZ', 'BE-VWZ (Veldwezelt, Limburg, Belgium)'),
    ('BE-VLM', 'BE-VLM (Velm, Limburg, Belgium)'),
    ('BE-VBG', 'BE-VBG (Verbrande Brug, Vlaams Brabant, Belgium)'),
    ('BE-VLA', 'BE-VLA (Verlaine, Liège, Belgium)'),
    ('BE-VBK', 'BE-VBK (Verrebroek, Oost-Vlaanderen, Belgium)'),
    ('BE-VER', 'BE-VER (Verviers, Liège, Belgium)'),
    ('BE-VEU', 'BE-VEU (Veurne, West-Vlaanderen, Belgium)'),
    ('BE-VZI', 'BE-VZI (Vezin, Namur, Belgium)'),
    ('BE-VZO', 'BE-VZO (Vezon, Hainaut, Belgium)'),
    ('BE-VIC', 'BE-VIC (Vichte, West-Vlaanderen, Belgium)'),
    ('BE-VSM', 'BE-VSM (Vielsalm, Luxembourg, Belgium)'),
    ('BE-VSL', 'BE-VSL (Viersel, Antwerpen, Belgium)'),
    ('BE-VVI', 'BE-VVI (Viesville, Hainaut, Belgium)'),
    ('BE-VGA', 'BE-VGA (Vieux-Genappe, Brabant wallon, Belgium)'),
    ('BE-VPO', 'BE-VPO (Ville-Pommeroeul, Hainaut, Belgium)'),
    ('BE-VSH', 'BE-VSH (Ville-sur-Haine, Hainaut, Belgium)'),
    ('BE-VLO', 'BE-VLO (Villerot, Hainaut, Belgium)'),
    ('BE-VAT', 'BE-VAT (Villers-aux-Tours, Liège, Belgium)'),
    ('BE-VVO', 'BE-VVO (Villers-devant-Orval, Luxembourg, Belgium)'),
    ('BE-VLV', 'BE-VLV (Villers-la-Ville, Brabant wallon, Belgium)'),
    ('BE-VBO', 'BE-VBO (Villers-le-Bouillet, Liège, Belgium)'),
    ('BE-VNO', 'BE-VNO (Villers-Notre-Dame, Hainaut, Belgium)'),
    ('BE-VSA', 'BE-VSA (Villers-Saint-Amand, Hainaut, Belgium)'),
    ('BE-VSI', 'BE-VSI (Villers-Saint-Ghislain, Hainaut, Belgium)'),
    ('BE-VSS', 'BE-VSS (Villers-Saint-Siméon, Liège, Belgium)'),
    ('BE-VSG', 'BE-VSG (Villers-Sainte-Gertrude, Luxembourg, Belgium)'),
    ('BE-VIL', 'BE-VIL (Vilvoorde, Vlaams Brabant, Belgium)'),
    ('BE-VMT', 'BE-VMT (Vinalmont, Liège, Belgium)'),
    ('BE-VDO', 'BE-VDO (Vinderhoute, Oost-Vlaanderen, Belgium)'),
    ('BE-VRE', 'BE-VRE (Virelles, Hainaut, Belgium)'),
    ('BE-VGL', 'BE-VGL (Virginal-Samme, Brabant wallon, Belgium)'),
    ('BE-VRO', 'BE-VRO (Viroinval, Namur, Belgium)'),
    ('BE-VIR', 'BE-VIR (Virton, Luxembourg, Belgium)'),
    ('BE-VIS', 'BE-VIS (Visé, Liège, Belgium)'),
    ('BE-VIV', 'BE-VIV (Vivegnis, Liège, Belgium)'),
    ('BE-VIY', 'BE-VIY (Vivy, Luxembourg, Belgium)'),
    ('BE-VMI', 'BE-VMI (Vlamertinge, West-Vlaanderen, Belgium)'),
    ('BE-VLE', 'BE-VLE (Vleteren, West-Vlaanderen, Belgium)'),
    ('BE-VZB', 'BE-VZB (Vlezenbeek, Vlaams Brabant, Belgium)'),
    ('BE-VMA', 'BE-VMA (Vliermaal, Limburg, Belgium)'),
    ('BE-VMO', 'BE-VMO (Vliermaalroot, Limburg, Belgium)'),
    ('BE-VSE', 'BE-VSE (Vlissegem, West-Vlaanderen, Belgium)'),
    ('BE-VOE', 'BE-VOE (Voeren, Limburg, Belgium)'),
    ('BE-VLL', 'BE-VLL (Vollezele, Vlaams Brabant, Belgium)'),
    ('BE-VME', 'BE-VME (Voormezele, West-Vlaanderen, Belgium)'),
    ('BE-VLI', 'BE-VLI (Voroux-lez-Liers, Liège, Belgium)'),
    ('BE-VOL', 'BE-VOL (Vorselaar, Antwerpen, Belgium)'),
    ('BE-VOS', 'BE-VOS (Vorselaar, Antwerpen, Belgium)'),
    ('BE-VOR', 'BE-VOR (Vosselaar, Antwerpen, Belgium)'),
    ('BE-VTM', 'BE-VTM (Vosselaar, Antwerpen, Belgium)'),
    ('BE-VSN', 'BE-VSN (Vrasene, Oost-Vlaanderen, Belgium)'),
    ('BE-VDE', 'BE-VDE (Vremde, Antwerpen, Belgium)'),
    ('BE-VSO', 'BE-VSO (Vresse-sur-Semois, Namur, Belgium)'),
    ('BE-VHN', 'BE-VHN (Vroenhoven, Limburg, Belgium)'),
    ('BE-WRO', 'BE-WRO (Waanrode, Vlaams Brabant, Belgium)'),
    ('BE-WKE', 'BE-WKE (Waarbeke, Oost-Vlaanderen, Belgium)'),
    ('BE-WDM', 'BE-WDM (Waardamme, West-Vlaanderen, Belgium)'),
    ('BE-WRL', 'BE-WRL (Waarloos, Antwerpen, Belgium)'),
    ('BE-WAM', 'BE-WAM (Waarmaarde, West-Vlaanderen, Belgium)'),
    ('BE-WSO', 'BE-WSO (Waarschoot, Oost-Vlaanderen, Belgium)'),
    ('BE-WMO', 'BE-WMO (Waasmont, Vlaams Brabant, Belgium)'),
    ('BE-WAA', 'BE-WAA (Waasmunster, Oost-Vlaanderen, Belgium)'),
    ('BE-WBE', 'BE-WBE (Wachtebeke, Oost-Vlaanderen, Belgium)'),
    ('BE-WLI', 'BE-WLI (Wadelincourt, Hainaut, Belgium)'),
    ('BE-WGE', 'BE-WGE (Wagnelée, Hainaut, Belgium)'),
    ('BE-WIM', 'BE-WIM (Waimes, Liège, Belgium)'),
    ('BE-WAK', 'BE-WAK (Wakken, West-Vlaanderen, Belgium)'),
    ('BE-WCO', 'BE-WCO (Walcourt, Namur, Belgium)'),
    ('BE-WLM', 'BE-WLM (Walem, Antwerpen, Belgium)'),
    ('BE-WHA', 'BE-WHA (Walhain, Brabant wallon, Belgium)'),
    ('BE-WHR', 'BE-WHR (Walhorn, Liège, Belgium)'),
    ('BE-WSE', 'BE-WSE (Walsbets, Vlaams Brabant, Belgium)'),
    ('BE-WHO', 'BE-WHO (Walshoutem, Vlaams Brabant, Belgium)'),
    ('BE-WBK', 'BE-WBK (Wambeek, Vlaams Brabant, Belgium)'),
    ('BE-WND', 'BE-WND (Wandre, Liège, Belgium)'),
    ('BE-WBU', 'BE-WBU (Wanfercée-Baulet, Hainaut, Belgium)'),
    ('BE-WNI', 'BE-WNI (Wanlin, Namur, Belgium)'),
    ('BE-WBQ', 'BE-WBQ (Wannebecq, Hainaut, Belgium)'),
    ('BE-WLE', 'BE-WLE (Wannegem-Lede, Oost-Vlaanderen, Belgium)'),
    ('BE-WAN', 'BE-WAN (Wanze, Liège, Belgium)'),
    ('BE-WHI', 'BE-WHI (Warchin, Hainaut, Belgium)'),
    ('BE-WCG', 'BE-WCG (Warcoing, Hainaut, Belgium)'),
    ('BE-WAR', 'BE-WAR (Waregem, West-Vlaanderen, Belgium)'),
    ('BE-WRE', 'BE-WRE (Waremme, Liège, Belgium)'),
    ('BE-WNA', 'BE-WNA (Warnant, Namur, Belgium)'),
    ('BE-BWN', 'BE-BWN (Warneton, Hainaut, Belgium)'),
    ('BE-WSA', 'BE-WSA (Warsage, Liège, Belgium)'),
    ('BE-WUB', 'BE-WUB (Wasmes-Audemez-Briffoeil, Hainaut, Belgium)'),
    ('BE-WSI', 'BE-WSI (Wasseiges, Liège, Belgium)'),
    ('BE-WOU', 'BE-WOU (Waterland-Oudeman, Oost-Vlaanderen, Belgium)'),
    ('BE-WAL', 'BE-WAL (Waterloo, Brabant wallon, Belgium)'),
    ('BE-WTL', 'BE-WTL (Waterloos, Limburg, Belgium)'),
    ('BE-WBV', 'BE-WBV (Waterloos, Limburg, Belgium)'),
    ('BE-WBV', 'BE-WBV (Waterloos, Limburg, Belgium)'),
    ('BE-WVI', 'BE-WVI (Watervliet, Oost-Vlaanderen, Belgium)'),
    ('BE-WTU', 'BE-WTU (Watou, West-Vlaanderen, Belgium)'),
    ('BE-WDE', 'BE-WDE (Waudrez, Hainaut, Belgium)'),
    ('BE-WLT', 'BE-WLT (Waulsort, Namur, Belgium)'),
    ('BE-WAB', 'BE-WAB (Wauthier-Braine, Brabant wallon, Belgium)'),
    ('BE-WAV', 'BE-WAV (Waver, Oost-Vlaanderen, Belgium)'),
    ('BE-WVR', 'BE-WVR (Wavre, Brabant wallon, Belgium)'),
    ('BE-WAY', 'BE-WAY (Ways, Brabant wallon, Belgium)'),
    ('BE-WHZ', 'BE-WHZ (Wechelderzande, Antwerpen, Belgium)'),
    ('BE-WED', 'BE-WED (Weelde, Antwerpen, Belgium)'),
    ('BE-WRD', 'BE-WRD (Weerde, Vlaams Brabant, Belgium)'),
    ('BE-VWT', 'BE-VWT (Weerde, Vlaams Brabant, Belgium)'),
    ('BE-WNZ', 'BE-WNZ (Wegnez, Liège, Belgium)'),
    ('BE-WLN', 'BE-WLN (Weillen, Namur, Belgium)'),
    ('BE-WKD', 'BE-WKD (Welkenraedt, Liège, Belgium)'),
    ('BE-WLL', 'BE-WLL (Welle, Oost-Vlaanderen, Belgium)'),
    ('BE-WEL', 'BE-WEL (Wellen, Limburg, Belgium)'),
    ('BE-WIN', 'BE-WIN (Wellin, Luxembourg, Belgium)'),
    ('BE-WML', 'BE-WML (Wemmel, Vlaams Brabant, Belgium)'),
    ('BE-WCE', 'BE-WCE (Werchter, Vlaams Brabant, Belgium)'),
    ('BE-WKN', 'BE-WKN (Werken, West-Vlaanderen, Belgium)'),
    ('BE-WER', 'BE-WER (Wervik, West-Vlaanderen, Belgium)'),
    ('BE-WPL', 'BE-WPL (Wespelaar, Vlaams Brabant, Belgium)'),
    ('BE-WTE', 'BE-WTE (Westende, West-Vlaanderen, Belgium)'),
    ('BE-WES', 'BE-WES (Westerlo, Antwerpen, Belgium)'),
    ('BE-WSK', 'BE-WSK (Westerlo, Antwerpen, Belgium)'),
    ('BE-WME', 'BE-WME (Westmalle, Antwerpen, Belgium)'),
    ('BE-WSB', 'BE-WSB (Westmeerbeek, Antwerpen, Belgium)'),
    ('BE-WSU', 'BE-WSU (Westouter, West-Vlaanderen, Belgium)'),
    ('BE-WSM', 'BE-WSM (Westrem, Oost-Vlaanderen, Belgium)'),
    ('BE-WST', 'BE-WST (Westrozebeke, West-Vlaanderen, Belgium)'),
    ('BE-WET', 'BE-WET (Wetteren, Oost-Vlaanderen, Belgium)'),
    ('BE-WEV', 'BE-WEV (Wevelgem, West-Vlaanderen, Belgium)'),
    ('BE-WZL', 'BE-WZL (Wezel, Antwerpen, Belgium)'),
    ('BE-WZE', 'BE-WZE (Wezemaal, Vlaams Brabant, Belgium)'),
    ('BE-WKO', 'BE-WKO (Wezembeek-Oppem, Vlaams Brabant, Belgium)'),
    ('BE-WEN', 'BE-WEN (Wezeren, Vlaams Brabant, Belgium)'),
    ('BE-WIB', 'BE-WIB (Wibrin, Luxembourg, Belgium)'),
    ('BE-WIH', 'BE-WIH (Wichelen, Oost-Vlaanderen, Belgium)'),
    ('BE-WVO', 'BE-WVO (Wiekevorst, Antwerpen, Belgium)'),
    ('BE-WIK', 'BE-WIK (Wielsbeke, West-Vlaanderen, Belgium)'),
    ('BE-WID', 'BE-WID (Wierde, Namur, Belgium)'),
    ('BE-WIR', 'BE-WIR (Wiers, Hainaut, Belgium)'),
    ('BE-WIS', 'BE-WIS (Wiesme, Namur, Belgium)'),
    ('BE-WIE', 'BE-WIE (Wieze, Oost-Vlaanderen, Belgium)'),
    ('BE-WGH', 'BE-WGH (Wihogne, Liège, Belgium)'),
    ('BE-WGL', 'BE-WGL (Wijgmaal, Vlaams Brabant, Belgium)'),
    ('BE-WJG', 'BE-WJG (Wijnegem, Antwerpen, Belgium)'),
    ('BE-WYT', 'BE-WYT (Wijtschate, West-Vlaanderen, Belgium)'),
    ('BE-WDN', 'BE-WDN (Wilderen, Limburg, Belgium)'),
    ('BE-WPU', 'BE-WPU (Willaupuis, Hainaut, Belgium)'),
    ('BE-WLB', 'BE-WLB (Willebroek, Antwerpen, Belgium)'),
    ('BE-WMA', 'BE-WMA (Willemeau, Hainaut, Belgium)'),
    ('BE-WIL', 'BE-WIL (Wilrijk, Antwerpen, Belgium)'),
    ('BE-WSL', 'BE-WSL (Wilsele, Vlaams Brabant, Belgium)'),
    ('BE-WEK', 'BE-WEK (Wilskerke, West-Vlaanderen, Belgium)'),
    ('BE-WTI', 'BE-WTI (Wimmertingen, Limburg, Belgium)'),
    ('BE-WEE', 'BE-WEE (Wingene, West-Vlaanderen, Belgium)'),
    ('BE-WTO', 'BE-WTO (Wintershoven, Limburg, Belgium)'),
    ('BE-WSG', 'BE-WSG (Winterslag, Limburg, Belgium)'),
    ('BE-WTH', 'BE-WTH (Wintham, Antwerpen, Belgium)'),
    ('BE-SLW', 'BE-SLW (Wintham, Antwerpen, Belgium)'),
    ('BE-SPO', 'BE-SPO (Wintham, Antwerpen, Belgium)'),
    ('BE-WOV', 'BE-WOV (Wolvertem, Vlaams Brabant, Belgium)'),
    ('BE-WMM', 'BE-WMM (Wommelgem, Antwerpen, Belgium)'),
    ('BE-WDG', 'BE-WDG (Wondelgem, Oost-Vlaanderen, Belgium)'),
    ('BE-WOM', 'BE-WOM (Wortegem, Oost-Vlaanderen, Belgium)'),
    ('BE-WPE', 'BE-WPE (Wortegem-Petegem, Oost-Vlaanderen, Belgium)'),
    ('BE-WOR', 'BE-WOR (Wortel, Antwerpen, Belgium)'),
    ('BE-WLP', 'BE-WLP (Wulpen, West-Vlaanderen, Belgium)'),
    ('BE-WUV', 'BE-WUV (Wulvergem, West-Vlaanderen, Belgium)'),
    ('BE-WUU', 'BE-WUU (Wuustwezel, Antwerpen, Belgium)'),
    ('BE-WIP', 'BE-WIP (Wépion, Namur, Belgium)'),
    ('BE-XDE', 'BE-XDE (Xhendelesse, Liège, Belgium)'),
    ('BE-XDA', 'BE-XDA (Xhendremael, Liège, Belgium)'),
    ('BE-XHO', 'BE-XHO (Xhoris, Liège, Belgium)'),
    ('BE-YVO', 'BE-YVO (Yvoir, Namur, Belgium)'),
    ('BE-ZBR', 'BE-ZBR (Zandbergen, Oost-Vlaanderen, Belgium)'),
    ('BE-ZAN', 'BE-ZAN (Zandhoven, Antwerpen, Belgium)'),
    ('BE-ZVT', 'BE-ZVT (Zandvliet, Antwerpen, Belgium)'),
    ('BE-ZVD', 'BE-ZVD (Zandvoorde, West-Vlaanderen, Belgium)'),
    ('BE-ZRN', 'BE-ZRN (Zarren, West-Vlaanderen, Belgium)'),
    ('BE-ZAV', 'BE-ZAV (Zaventem, Vlaams Brabant, Belgium)'),
    ('BE-ZED', 'BE-ZED (Zedelgem, West-Vlaanderen, Belgium)'),
    ('BE-ZEE', 'BE-ZEE (Zeebrugge, West-Vlaanderen, Belgium)'),
    ('BE-ZLE', 'BE-ZLE (Zele, Oost-Vlaanderen, Belgium)'),
    ('BE-ZEM', 'BE-ZEM (Zelem, Limburg, Belgium)'),
    ('BE-ZLL', 'BE-ZLL (Zellik, Vlaams Brabant, Belgium)'),
    ('BE-ZEL', 'BE-ZEL (Zelzate, Oost-Vlaanderen, Belgium)'),
    ('BE-ZET', 'BE-ZET (Zemst, Vlaams Brabant, Belgium)'),
    ('BE-ZVG', 'BE-ZVG (Zevergem, Oost-Vlaanderen, Belgium)'),
    ('BE-ZIC', 'BE-ZIC (Zichem, Vlaams Brabant, Belgium)'),
    ('BE-ZIB', 'BE-ZIB (Zillebeke, West-Vlaanderen, Belgium)'),
    ('BE-ZGM', 'BE-ZGM (Zingem, Oost-Vlaanderen, Belgium)'),
    ('BE-OBL', 'BE-OBL (Zoersel, Antwerpen, Belgium)'),
    ('BE-ZOD', 'BE-ZOD (Zolder, Limburg, Belgium)'),
    ('BE-ZRM', 'BE-ZRM (Zomergem, Oost-Vlaanderen, Belgium)'),
    ('BE-ZHV', 'BE-ZHV (Zonhoven, Limburg, Belgium)'),
    ('BE-ZOB', 'BE-ZOB (Zonnebeke, West-Vlaanderen, Belgium)'),
    ('BE-ZOT', 'BE-ZOT (Zottegem, Oost-Vlaanderen, Belgium)'),
    ('BE-AIE', 'BE-AIE (Zoutenaaie, West-Vlaanderen, Belgium)'),
    ('BE-ZOU', 'BE-ZOU (Zoutleeuw, Vlaams Brabant, Belgium)'),
    ('BE-ZUN', 'BE-ZUN (Zuen (Zuun), Vlaams Brabant, Belgium)'),
    ('BE-ZSO', 'BE-ZSO (Zuidschote, West-Vlaanderen, Belgium)'),
    ('BE-ZKE', 'BE-ZKE (Zuienkerke, West-Vlaanderen, Belgium)'),
    ('BE-ZUL', 'BE-ZUL (Zulte, Oost-Vlaanderen, Belgium)'),
    ('BE-ZTL', 'BE-ZTL (Zutendaal, Limburg, Belgium)'),
    ('BE-ZUN', 'BE-ZUN (Zuun (Zuen), Vlaams Brabant, Belgium)'),
    ('BE-ZWA', 'BE-ZWA (Zwalm, Oost-Vlaanderen, Belgium)'),
    ('BE-ZWE', 'BE-ZWE (Zwevegem, West-Vlaanderen, Belgium)'),
    ('BE-VGZ', 'BE-VGZ (Zwevegem, West-Vlaanderen, Belgium)'),
    ('BE-ZWN', 'BE-ZWN (Zwijnaarde, Oost-Vlaanderen, Belgium)'),
    ('BE-ZWL', 'BE-ZWL (Zwijndrecht, Antwerpen, Belgium)'),
    ('BE-ECS', 'BE-ECS (Écaussinnes, Hainaut, Belgium)'),
    ('BE-ESI', "BE-ESI (Écaussinnes-d'Enghien, Hainaut, Belgium)"),
    ('BE-ELA', 'BE-ELA (Écaussinnes-Lalaing, Hainaut, Belgium)'),
    ('BE-EZE', 'BE-EZE (Éghezée, Namur, Belgium)'),
    ('BE-EPO', 'BE-EPO (Épinois, Hainaut, Belgium)'),
    ('BE-EEZ', 'BE-EEZ (Érezée, Luxembourg, Belgium)'),
    ('BE-ETL', 'BE-ETL (Étalle, Luxembourg, Belgium)'),
    ('BE-EET', 'BE-EET (Éthe, Luxembourg, Belgium)'),
    ('BE-EVG', 'BE-EVG (Évegnée-Tignée, Liège, Belgium)'),
    ('BF-ABD', 'BF-ABD (Évegnée-Tignée, Liège, Belgium)'),
    ('BF-ARL', 'BF-ARL (Évegnée-Tignée, Liège, Belgium)'),
    ('BF-BNR', 'BF-BNR (Évegnée-Tignée, Liège, Belgium)'),
    ('BF-BOY', 'BF-BOY (Bobo-Dioulasso, Houet, Burkina Faso)'),
    ('BF-BOG', 'BF-BOG (Bobo-Dioulasso, Houet, Burkina Faso)'),
    ('BF-BRO', 'BF-BRO (Boromo, Balé, Burkina Faso)'),
    ('BF-BOU', 'BF-BOU (Boromo, Balé, Burkina Faso)'),
    ('BF-BUS', 'BF-BUS (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-BER', 'BF-BER (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-DIP', 'BF-DIP (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-DBG', 'BF-DBG (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-DJI', 'BF-DJI (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-DOR', 'BF-DOR (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-DGU', 'BF-DGU (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-FNG', 'BF-FNG (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-GAO', 'BF-GAO (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-GOG', 'BF-GOG (Bousse, Oubritenga, Burkina Faso)'),
    ('BF-HOU', 'BF-HOU (Houndé, Tuy, Burkina Faso)'),
    ('BF-KAN', 'BF-KAN (Houndé, Tuy, Burkina Faso)'),
    ('BF-KAY', 'BF-KAY (Houndé, Tuy, Burkina Faso)'),
    ('BF-KOS', 'BF-KOS (Houndé, Tuy, Burkina Faso)'),
    ('BF-KOU', 'BF-KOU (Houndé, Tuy, Burkina Faso)'),
    ('BF-KOR', 'BF-KOR (Houndé, Tuy, Burkina Faso)'),
    ('BF-LEO', 'BF-LEO (Houndé, Tuy, Burkina Faso)'),
    ('BF-MAN', 'BF-MAN (Mana, Balé, Burkina Faso)'),
    ('BF-NAT', 'BF-NAT (Natougou, Tapoa, Burkina Faso)'),
    ('BF-NOU', 'BF-NOU (Natougou, Tapoa, Burkina Faso)'),
    ('BF-ORO', 'BF-ORO (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-OUA', 'BF-OUA (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-OUG', 'BF-OUG (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-PAM', 'BF-PAM (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-PUP', 'BF-PUP (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-POU', 'BF-POU (Orodara, Kénédougou, Burkina Faso)'),
    ('BF-PEN', 'BF-PEN (Péni, Houet, Burkina Faso)'),
    ('BF-SAP', 'BF-SAP (Saponé, Bazèga \nga, Burkina Faso)'),
    ('BF-SEB', 'BF-SEB (Saponé, Bazèga \nga, Burkina Faso)'),
    ('BF-TMQ', 'BF-TMQ (Saponé, Bazèga \nga, Burkina Faso)'),
    ('BF-TEM', 'BF-TEM (Tema, Passoré, Burkina Faso)'),
    ('BF-TEG', 'BF-TEG (Tema, Passoré, Burkina Faso)'),
    ('BF-TUQ', 'BF-TUQ (Tema, Passoré, Burkina Faso)'),
    ('BF-WON', 'BF-WON (Wona (Ouona), Tuy, Burkina Faso)'),
    ('BF-YKP', 'BF-YKP (Yako, Passoré, Burkina Faso)'),
    ('BF-LIG', 'BF-LIG (Yaramoko, Mouhoun, Burkina Faso)'),
    ('BF-ZAB', 'BF-ZAB (Yaramoko, Mouhoun, Burkina Faso)'),
    ('BF-ZIG', 'BF-ZIG (Yaramoko, Mouhoun, Burkina Faso)'),
    ('BF-OB2', 'BF-OB2 (Ziniaré, Oubritenga, Burkina Faso)'),
    ('BG-AIO', 'BG-AIO (Aitos, Bulgaria)'),
    ('BG-AKH', 'BG-AKH (Akhtopol, Bulgaria)'),
    ('BG-ASA', 'BG-ASA (Aksakovo, Bulgaria)'),
    ('BG-ATL', 'BG-ATL (Altimir, Bulgaria)'),
    ('BG-API', 'BG-API (Apriltsi, Bulgaria)'),
    ('BG-ARD', 'BG-ARD (Ardino, Bulgaria)'),
    ('BG-AND', 'BG-AND (Asenovgrad, Bulgaria)'),
    ('BG-AYT', 'BG-AYT (Aytos, Bulgaria)'),
    ('BG-BAL', 'BG-BAL (Balchik, Bulgaria)'),
    ('BG-BVO', 'BG-BVO (Banevo, Bulgaria)'),
    ('BG-BTE', 'BG-BTE (Banite, Bulgaria)'),
    ('BG-BAK', 'BG-BAK (Bankya, Bulgaria)'),
    ('BG-BAN', 'BG-BAN (Bankya, Bulgaria)'),
    ('BG-BAO', 'BG-BAO (Bansko, Bulgaria)'),
    ('BG-BBA', 'BG-BBA (Bata, Bulgaria)'),
    ('BG-BAT', 'BG-BAT (Batak, Bulgaria)'),
    ('BG-BLE', 'BG-BLE (Belene, Bulgaria)'),
    ('BG-BEL', 'BG-BEL (Belitsa, Bulgaria)'),
    ('BG-BBK', 'BG-BBK (Belogradchik, Bulgaria)'),
    ('BG-BDK', 'BG-BDK (Belogradchik, Bulgaria)'),
    ('BG-BEV', 'BG-BEV (Beloslav, Bulgaria)'),
    ('BG-BPK', 'BG-BPK (Belovo, Bulgaria)'),
    ('BG-BYK', 'BG-BYK (Belyakovets, Bulgaria)'),
    ('BG-BEN', 'BG-BEN (Benkovski, Bulgaria)'),
    ('BG-BRK', 'BG-BRK (Berkovitza, Bulgaria)'),
    ('BG-VBS', 'BG-VBS (Bjala Slatina, Bulgaria)'),
    ('BG-BLN', 'BG-BLN (Blagoevgrad, Bulgaria)'),
    ('BG-BRV', 'BG-BRV (Borovo, Bulgaria)'),
    ('BG-BRF', 'BG-BRF (Botevgrad, Bulgaria)'),
    ('BG-BOZ', 'BG-BOZ (Bozhurishte, Bulgaria)'),
    ('BG-VTG', 'BG-VTG (Bratsigovo, Bulgaria)'),
    ('BG-BRE', 'BG-BRE (Bregovo, Bulgaria)'),
    ('BG-BRS', 'BG-BRS (Brestak, Bulgaria)'),
    ('BG-BTV', 'BG-BTV (Brestovets, Bulgaria)'),
    ('BG-BRZ', 'BG-BRZ (Breznik, Bulgaria)'),
    ('BG-BDB', 'BG-BDB (Bulgarevo, Bulgaria)'),
    ('BG-BOJ', 'BG-BOJ (Burgas, Bulgaria)'),
    ('BG-BUZ', 'BG-BUZ (Buzovgrad, Bulgaria)'),
    ('BG-BYA', 'BG-BYA (Byala, Bulgaria)'),
    ('BG-BYL', 'BG-BYL (Byala, Bulgaria)'),
    ('BG-VT4', 'BG-VT4 (Byala Cherkva, Bulgaria)'),
    ('BG-BSL', 'BG-BSL (Byala Slatina, Bulgaria)'),
    ('BG-CHR', 'BG-CHR (Chakalarevo, Bulgaria)'),
    ('BG-OCH', 'BG-OCH (Chelopech, Bulgaria)'),
    ('BG-CHL', 'BG-CHL (Chelopechene, Bulgaria)'),
    ('BG-CPA', 'BG-CPA (Chepelare, Bulgaria)'),
    ('BG-CHE', 'BG-CHE (Chepintsi, Bulgaria)'),
    ('BG-VCA', 'BG-VCA (Chernook, Bulgaria)'),
    ('BG-CHV', 'BG-CHV (Cherven Bryag, Bulgaria)'),
    ('BG-CPW', 'BG-CPW (Chirpan, Bulgaria)'),
    ('BG-BCP', 'BG-BCP (Chomakovtsi, Bulgaria)'),
    ('BG-CHU', 'BG-CHU (Churukovo, Bulgaria)'),
    ('BG-DBD', 'BG-DBD (Damyanitsa, Bulgaria)'),
    ('BG-DBS', 'BG-DBS (Debelec, Bulgaria)'),
    ('BG-DEL', 'BG-DEL (Debelt, Bulgaria)'),
    ('BG-DLC', 'BG-DLC (Delchevo, Bulgaria)'),
    ('BG-DEV', 'BG-DEV (Devin, Bulgaria)'),
    ('BG-DNJ', 'BG-DNJ (Devnya, Bulgaria)'),
    ('BG-DTG', 'BG-DTG (Dimitrovgrad, Bulgaria)'),
    ('BG-DOD', 'BG-DOD (Dobrich, Bulgaria)'),
    ('BG-DBR', 'BG-DBR (Dobroslavtsi, Bulgaria)'),
    ('BG-DOB', 'BG-DOB (Dolna Banya, Bulgaria)'),
    ('BG-YMP', 'BG-YMP (Dolna Mitropoliya, Bulgaria)'),
    ('BG-DKC', 'BG-DKC (Dolna Oryakhovitsa, Bulgaria)'),
    ('BG-DOC', 'BG-DOC (Dolni Chiflik, Bulgaria)'),
    ('BG-KBD', 'BG-KBD (Dolni Dabnik, Bulgaria)'),
    ('BG-DSP', 'BG-DSP (Dospat, Bulgaria)'),
    ('BG-DAO', 'BG-DAO (Draginovo, Bulgaria)'),
    ('BG-DMN', 'BG-DMN (Dragoman, Bulgaria)'),
    ('BG-VRN', 'BG-VRN (Drenov, Bulgaria)'),
    ('BG-DRV', 'BG-DRV (Drenovets, Bulgaria)'),
    ('BG-DNV', 'BG-DNV (Dryanovo, Bulgaria)'),
    ('BG-DLV', 'BG-DLV (Dulovo, Bulgaria)'),
    ('BG-DUP', 'BG-DUP (Dupnica, Bulgaria)'),
    ('BG-DKO', 'BG-DKO (Durankulak, Bulgaria)'),
    ('BG-ELE', 'BG-ELE (Elena, Bulgaria)'),
    ('BG-ELH', 'BG-ELH (Elhovo, Bulgaria)'),
    ('BG-EPE', 'BG-EPE (Elin Pelin, Bulgaria)'),
    ('BG-EHO', 'BG-EHO (Elkhovo, Bulgaria)'),
    ('BG-ETS', 'BG-ETS (Etropole, Bulgaria)'),
    ('BG-FOT', 'BG-FOT (Fotinovo, Bulgaria)'),
    ('BG-GAV', 'BG-GAV (Gabrovo, Bulgaria)'),
    ('BG-GAL', 'BG-GAL (Galabovo, Bulgaria)'),
    ('BG-DA3', 'BG-DA3 (Garmen, Bulgaria)'),
    ('BG-GTB', 'BG-GTB (General-Toshevo, Bulgaria)'),
    ('BG-TOS', 'BG-TOS (General-Toshevo, Bulgaria)'),
    ('BG-GOD', 'BG-GOD (Godech, Bulgaria)'),
    ('BG-GOL', 'BG-GOL (Golyamo Chochoveni, Bulgaria)'),
    ('BG-GOV', 'BG-GOV (Gorna Oryahovica, Bulgaria)'),
    ('BG-GOZ', 'BG-GOZ (Gorna Oryakhovitsa, Bulgaria)'),
    ('BG-GB4', 'BG-GB4 (Gorublyane, Bulgaria)'),
    ('BG-GDU', 'BG-GDU (Gotse Delchev, Bulgaria)'),
    ('BG-RAN', 'BG-RAN (Grancharovo, Bulgaria)'),
    ('BG-GRU', 'BG-GRU (Gruevo, Bulgaria)'),
    ('BG-GUR', 'BG-GUR (Gurkovo, Bulgaria)'),
    ('BG-GJE', 'BG-GJE (Gyueshevo, Bulgaria)'),
    ('BG-HRM', 'BG-HRM (Harmanli, Bulgaria)'),
    ('BG-HKV', 'BG-HKV (Haskovo, Bulgaria)'),
    ('BG-XCR', 'BG-XCR (Hisarya, Bulgaria)'),
    ('BG-IAB', 'BG-IAB (Iablanitsa, Bulgaria)'),
    ('BG-4IG', 'BG-4IG (Ignatievo, Bulgaria)'),
    ('BG-IHT', 'BG-IHT (Ikhtiman, Bulgaria)'),
    ('BG-IOV', 'BG-IOV (Iovkovo, Bulgaria)'),
    ('BG-ISK', 'BG-ISK (Iskar, Bulgaria)'),
    ('BG-ISP', 'BG-ISP (Isperih, Bulgaria)'),
    ('BG-IPR', 'BG-IPR (Isperikh, Bulgaria)'),
    ('BG-IVL', 'BG-IVL (Ivailovgrad, Bulgaria)'),
    ('BG-JAM', 'BG-JAM (Jambol, Bulgaria)'),
    ('BG-KAV', 'BG-KAV (Kalipetrovo, Bulgaria)'),
    ('BG-KAL', 'BG-KAL (Kalotina, Bulgaria)'),
    ('BG-KAN', 'BG-KAN (Kapitan-Andreevo, Bulgaria)'),
    ('BG-KAP', 'BG-KAP (Kapitanovtsi, Bulgaria)'),
    ('BG-BKR', 'BG-BKR (Karabunar, Bulgaria)'),
    ('BG-KAR', 'BG-KAR (Kardam, Bulgaria)'),
    ('BG-KRM', 'BG-KRM (Kardzali, Bulgaria)'),
    ('BG-KVO', 'BG-KVO (Karlovo, Bulgaria)'),
    ('BG-KBT', 'BG-KBT (Karnobat, Bulgaria)'),
    ('BG-KPH', 'BG-KPH (Kaspichan, Bulgaria)'),
    ('BG-KAT', 'BG-KAT (Katunitza, Bulgaria)'),
    ('BG-KVN', 'BG-KVN (Kavarna, Bulgaria)'),
    ('BG-ZHA', 'BG-ZHA (Kaynardzha, Bulgaria)'),
    ('BG-KZK', 'BG-KZK (Kazanlak, Bulgaria)'),
    ('BG-KZN', 'BG-KZN (Kazanluk, Bulgaria)'),
    ('BG-KAZ', 'BG-KAZ (Kazichene, Bulgaria)'),
    ('BG-RKM', 'BG-RKM (Kermen, Bulgaria)'),
    ('BG-KHK', 'BG-KHK (Khan Krum, Bulgaria)'),
    ('BG-HMI', 'BG-HMI (Kharmanli, Bulgaria)'),
    ('BG-KHO', 'BG-KHO (Khaskovo, Bulgaria)'),
    ('BG-KJG', 'BG-KJG (Kjustendil, Bulgaria)'),
    ('BG-KRL', 'BG-KRL (Klisura, Bulgaria)'),
    ('BG-KNE', 'BG-KNE (Knezha, Bulgaria)'),
    ('BG-ROO', 'BG-ROO (Kolarovo, Bulgaria)'),
    ('BG-SKA', 'BG-SKA (Koprivshtitsa, Bulgaria)'),
    ('BG-K2N', 'BG-K2N (Korten, Bulgaria)'),
    ('BG-KOS', 'BG-KOS (Kostenets, Bulgaria)'),
    ('BG-KBR', 'BG-KBR (Kostinbrod, Bulgaria)'),
    ('BG-KOT', 'BG-KOT (Kotel, Bulgaria)'),
    ('BG-KOY', 'BG-KOY (Koynare, Bulgaria)'),
    ('BG-KOZ', 'BG-KOZ (Kozloduj, Bulgaria)'),
    ('BG-HKM', 'BG-HKM (Krichim, Bulgaria)'),
    ('BG-VKD', 'BG-VKD (Krivodol, Bulgaria)'),
    ('BG-KRU', 'BG-KRU (Krumovgrad, Bulgaria)'),
    ('BG-KRH', 'BG-KRH (Krushari, Bulgaria)'),
    ('BG-KUB', 'BG-KUB (Kubrat, Bulgaria)'),
    ('BG-KUK', 'BG-KUK (Kuklen, Bulgaria)'),
    ('BG-KUL', 'BG-KUL (Kula, Bulgaria)'),
    ('BG-KOL', 'BG-KOL (Kulata, Bulgaria)'),
    ('BG-KDG', 'BG-KDG (Kurdzhali, Bulgaria)'),
    ('BG-KYS', 'BG-KYS (Kyustendil, Bulgaria)'),
    ('BG-LKI', 'BG-LKI (Laki, Bulgaria)'),
    ('BG-LED', 'BG-LED (Ledenik, Bulgaria)'),
    ('BG-LES', 'BG-LES (Leskovets, Bulgaria)'),
    ('BG-LSD', 'BG-LSD (Levski, Bulgaria)'),
    ('BG-LIA', 'BG-LIA (Liaskovec, Bulgaria)'),
    ('BG-LOK', 'BG-LOK (Lokorsko, Bulgaria)'),
    ('BG-LOM', 'BG-LOM (Lom, Bulgaria)'),
    ('BG-TLI', 'BG-TLI (Lomci, Bulgaria)'),
    ('BG-LVP', 'BG-LVP (Lovech, Bulgaria)'),
    ('BG-LOZ', 'BG-LOZ (Lozarevo, Bulgaria)'),
    ('BG-LUK', 'BG-LUK (Lukovit, Bulgaria)'),
    ('BG-LKS', 'BG-LKS (Lyaskovets, Bulgaria)'),
    ('BG-LYA', 'BG-LYA (Lyaskovo, Bulgaria)'),
    ('BG-LMC', 'BG-LMC (Lyubimets, Bulgaria)'),
    ('BG-BLO', 'BG-BLO (Lyuliakovo, Bulgaria)'),
    ('BG-MAD', 'BG-MAD (Madan, Bulgaria)'),
    ('BG-MTI', 'BG-MTI (Malko Tarnovo, Bulgaria)'),
    ('BG-SHU', 'BG-SHU (Malomir, Bulgaria)'),
    ('BG-PLO', 'BG-PLO (Manole, Bulgaria)'),
    ('BG-MAB', 'BG-MAB (Marchevo, Bulgaria)'),
    ('BG-MNR', 'BG-MNR (Mednikarovo, Bulgaria)'),
    ('BG-MEL', 'BG-MEL (Melnik, Bulgaria)'),
    ('BG-MEZ', 'BG-MEZ (Mezdra, Bulgaria)'),
    ('BG-MIH', 'BG-MIH (Mihalkovo, Bulgaria)'),
    ('BG-MIE', 'BG-MIE (Mikre, Bulgaria)'),
    ('BG-MIR', 'BG-MIR (Mirkovo, Bulgaria)'),
    ('BG-MVY', 'BG-MVY (Mirovyane, Bulgaria)'),
    ('BG-MII', 'BG-MII (Mitrovtsi, Bulgaria)'),
    ('BG-MIZ', 'BG-MIZ (Miziya, Bulgaria)'),
    ('BG-MOT', 'BG-MOT (Momchilgrad, Bulgaria)'),
    ('BG-OZA', 'BG-OZA (Montana, Bulgaria)'),
    ('BG-MUC', 'BG-MUC (Musachevo, Bulgaria)'),
    ('BG-NES', 'BG-NES (Nessebar, Bulgaria)'),
    ('BG-NPO', 'BG-NPO (Nikopol, Bulgaria)'),
    ('BG-NZG', 'BG-NZG (Nova Zagora, Bulgaria)'),
    ('BG-NIS', 'BG-NIS (Novi Isar, Bulgaria)'),
    ('BG-NPZ', 'BG-NPZ (Novi Pazar, Bulgaria)'),
    ('BG-NOS', 'BG-NOS (Novo Selo, Bulgaria)'),
    ('BG-OGN', 'BG-OGN (Ognyanovo, Bulgaria)'),
    ('BG-OLT', 'BG-OLT (Oltomantsi, Bulgaria)'),
    ('BG-OMU', 'BG-OMU (Omurtag, Bulgaria)'),
    ('BG-OPK', 'BG-OPK (Opaka, Bulgaria)'),
    ('BG-OPN', 'BG-OPN (Opanets, Bulgaria)'),
    ('BG-ORE', 'BG-ORE (Orehovo, Bulgaria)'),
    ('BG-ORI', 'BG-ORI (Orizovo, Bulgaria)'),
    ('BG-OKH', 'BG-OKH (Oryakhovo, Bulgaria)'),
    ('BG-OSI', 'BG-OSI (Osikovo, Bulgaria)'),
    ('BG-SIL', 'BG-SIL (Paisievo, Bulgaria)'),
    ('BG-PPE', 'BG-PPE (Panagyurishte, Bulgaria)'),
    ('BG-PVT', 'BG-PVT (Parvenets, Bulgaria)'),
    ('BG-PVM', 'BG-PVM (Parvomai, Bulgaria)'),
    ('BG-PVL', 'BG-PVL (Pavel, Bulgaria)'),
    ('BG-PBA', 'BG-PBA (Pavel Banya, Bulgaria)'),
    ('BG-PAV', 'BG-PAV (Pavlikeni, Bulgaria)'),
    ('BG-PIV', 'BG-PIV (Pavlikeni, Bulgaria)'),
    ('BG-PZA', 'BG-PZA (Pazardzhik, Bulgaria)'),
    ('BG-PNZ', 'BG-PNZ (Pernik, Bulgaria)'),
    ('BG-PRS', 'BG-PRS (Perushtitsa, Bulgaria)'),
    ('BG-PEC', 'BG-PEC (Peshtera, Bulgaria)'),
    ('BG-PTH', 'BG-PTH (Petarch, Bulgaria)'),
    ('BG-PEG', 'BG-PEG (Petrich, Bulgaria)'),
    ('BG-PIR', 'BG-PIR (Pirdop, Bulgaria)'),
    ('BG-PVN', 'BG-PVN (Pleven, Bulgaria)'),
    ('BG-SKP', 'BG-SKP (Pliska, Bulgaria)'),
    ('BG-PDV', 'BG-PDV (Plovdiv, Bulgaria)'),
    ('BG-POD', 'BG-POD (Podayva, Bulgaria)'),
    ('BG-POR', 'BG-POR (Pomorie, Bulgaria)'),
    ('BG-POK', 'BG-POK (Popovo, Bulgaria)'),
    ('BG-PRA', 'BG-PRA (Pravets, Bulgaria)'),
    ('BG-PSC', 'BG-PSC (Preslav, Bulgaria)'),
    ('BG-PRE', 'BG-PRE (Preslaven, Bulgaria)'),
    ('BG-PDA', 'BG-PDA (Provadiya, Bulgaria)'),
    ('BG-VDN', 'BG-VDN (Rabisha, Bulgaria)'),
    ('BG-PRO', 'BG-PRO (Radinovo, Bulgaria)'),
    ('BG-RDV', 'BG-RDV (Radnevo, Bulgaria)'),
    ('BG-RDI', 'BG-RDI (Radomir, Bulgaria)'),
    ('BG-JAK', 'BG-JAK (Rakitovo, Bulgaria)'),
    ('BG-RAK', 'BG-RAK (Rakovski, Bulgaria)'),
    ('BG-RGL', 'BG-RGL (Razgrad, Bulgaria)'),
    ('BG-RAZ', 'BG-RAZ (Razlog, Bulgaria)'),
    ('BG-RNS', 'BG-RNS (Resen, Bulgaria)'),
    ('BG-XXX', 'BG-XXX (RIS Inland waterways, Bulgaria)'),
    ('BG-RDZ', 'BG-RDZ (Rudozem, Bulgaria)'),
    ('BG-RDU', 'BG-RDU (Ruse, Bulgaria)'),
    ('BG-SAD', 'BG-SAD (Sadovo, Bulgaria)'),
    ('BG-SAE', 'BG-SAE (Saedinenie, Bulgaria)'),
    ('BG-SAM', 'BG-SAM (Samokov, Bulgaria)'),
    ('BG-OZD', 'BG-OZD (Samovodene, Bulgaria)'),
    ('BG-SDM', 'BG-SDM (Sandanski, Bulgaria)'),
    ('BG-SEL', 'BG-SEL (Selcha, Bulgaria)'),
    ('BG-SEI', 'BG-SEI (Seslavtsi, Bulgaria)'),
    ('BG-SLU', 'BG-SLU (Sevlievo, Bulgaria)'),
    ('BG-DCB', 'BG-DCB (Shabla, Bulgaria)'),
    ('BG-SHI', 'BG-SHI (Shiroka Laka, Bulgaria)'),
    ('BG-SMN', 'BG-SMN (Shumen, Bulgaria)'),
    ('BG-SUW', 'BG-SUW (Shumen, Bulgaria)'),
    ('BG-SLS', 'BG-SLS (Silistra, Bulgaria)'),
    ('BG-NLS', 'BG-NLS (Slatina, Bulgaria)'),
    ('BG-SLO', 'BG-SLO (Slavyanovo, Bulgaria)'),
    ('BG-SWQ', 'BG-SWQ (Slavyantsi, Bulgaria)'),
    ('BG-SLP', 'BG-SLP (Sliven, Bulgaria)'),
    ('BG-SLN', 'BG-SLN (Slivnitsa, Bulgaria)'),
    ('BG-SLV', 'BG-SLV (Slivo Pole, Bulgaria)'),
    ('BG-SML', 'BG-SML (Smolyan, Bulgaria)'),
    ('BG-SOF', 'BG-SOF (Sofia, Bulgaria)'),
    ('BG-SOM', 'BG-SOM (Somovit, Bulgaria)'),
    ('BG-SBP', 'BG-SBP (Sopot, Bulgaria)'),
    ('BG-SOZ', 'BG-SOZ (Sozopol, Bulgaria)'),
    ('BG-SDE', 'BG-SDE (Sredets, Bulgaria)'),
    ('BG-STA', 'BG-STA (Stamboliyski, Bulgaria)'),
    ('BG-SBV', 'BG-SBV (Stambolovo, Bulgaria)'),
    ('BG-SDV', 'BG-SDV (Stanke Dimitrov, Bulgaria)'),
    ('BG-SLI', 'BG-SLI (Stanke Lisitchkovo, Bulgaria)'),
    ('BG-SZR', 'BG-SZR (Stara Zagora, Bulgaria)'),
    ('BG-ZSS', 'BG-ZSS (Staro Selo, Bulgaria)'),
    ('BG-S8P', 'BG-S8P (Starosel, Bulgaria)'),
    ('BG-STO', 'BG-STO (Stomanevo, Bulgaria)'),
    ('BG-S3W', 'BG-S3W (Straldzha, Bulgaria)'),
    ('BG-VDV', 'BG-VDV (Streltsi, Bulgaria)'),
    ('BG-PSA', 'BG-PSA (Stryama, Bulgaria)'),
    ('BG-SIE', 'BG-SIE (Suedinenie, Bulgaria)'),
    ('BG-SUZ', 'BG-SUZ (Suhindol, Bulgaria)'),
    ('BG-SRL', 'BG-SRL (Sungurlare, Bulgaria)'),
    ('BG-SNA', 'BG-SNA (Surnitsa, Bulgaria)'),
    ('BG-SNK', 'BG-SNK (Sveti Nikola, Bulgaria)'),
    ('BG-SWG', 'BG-SWG (Svilengrad, Bulgaria)'),
    ('BG-SVZ', 'BG-SVZ (Svishtov, Bulgaria)'),
    ('BG-SVI', 'BG-SVI (Svistov, Bulgaria)'),
    ('BG-SVG', 'BG-SVG (Svoge, Bulgaria)'),
    ('BG-TGV', 'BG-TGV (Targovishte, Bulgaria)'),
    ('BG-TER', 'BG-TER (Tervel, Bulgaria)'),
    ('BG-TTV', 'BG-TTV (Teteven, Bulgaria)'),
    ('BG-TOL', 'BG-TOL (Tolbuhin, Bulgaria)'),
    ('BG-TPL', 'BG-TPL (Topoli, Bulgaria)'),
    ('BG-TGA', 'BG-TGA (Topolovgrad, Bulgaria)'),
    ('BG-TRN', 'BG-TRN (Tran, Bulgaria)'),
    ('BG-PTK', 'BG-PTK (Trastenik, Bulgaria)'),
    ('BG-TJM', 'BG-TJM (Trojan, Bulgaria)'),
    ('BG-TRY', 'BG-TRY (Troyan, Bulgaria)'),
    ('BG-TRD', 'BG-TRD (Trud, Bulgaria)'),
    ('BG-TRU', 'BG-TRU (Trudovets, Bulgaria)'),
    ('BG-TRA', 'BG-TRA (Tryavna, Bulgaria)'),
    ('BG-TBA', 'BG-TBA (Tsalapitsa, Bulgaria)'),
    ('BG-TSA', 'BG-TSA (Tsaratsovo, Bulgaria)'),
    ('BG-TRV', 'BG-TRV (Tsarevo, Bulgaria)'),
    ('BG-TKV', 'BG-TKV (Tserkovski, Bulgaria)'),
    ('BG-GAB', 'BG-GAB (Tumbalovo, Bulgaria)'),
    ('BG-TRP', 'BG-TRP (Tutrakan, Bulgaria)'),
    ('BG-TAD', 'BG-TAD (Tvardica, Bulgaria)'),
    ('BG-LCH', 'BG-LCH (Uglen, Bulgaria)'),
    ('BG-VDL', 'BG-VDL (Valchi Dol, Bulgaria)'),
    ('BG-VDM', 'BG-VDM (Vardim, Bulgaria)'),
    ('BG-VAR', 'BG-VAR (Varna, Bulgaria)'),
    ('BG-VAZ', 'BG-VAZ (Varna-Zapad, Bulgaria)'),
    ('BG-VAS', 'BG-VAS (Varshets, Bulgaria)'),
    ('BG-VEP', 'BG-VEP (Veliki Preslav, Bulgaria)'),
    ('BG-VTT', 'BG-VTT (Veliko Tarnovo, Bulgaria)'),
    ('BG-VLE', 'BG-VLE (Velingrad, Bulgaria)'),
    ('BG-VNT', 'BG-VNT (Venets, Bulgaria)'),
    ('BG-VEO', 'BG-VEO (Verinsko, Bulgaria)'),
    ('BG-QZX', 'BG-QZX (Vetrino, Bulgaria)'),
    ('BG-VID', 'BG-VID (Vidin, Bulgaria)'),
    ('BG-VRE', 'BG-VRE (Vraca, Bulgaria)'),
    ('BG-VSA', 'BG-VSA (Vratsa, Bulgaria)'),
    ('BG-VRA', 'BG-VRA (Vratza, Bulgaria)'),
    ('BG-QVJ', 'BG-QVJ (Vrazhdebna, Bulgaria)'),
    ('BG-VTC', 'BG-VTC (Vrska Cuka, Bulgaria)'),
    ('BG-YGD', 'BG-YGD (Yagoda, Bulgaria)'),
    ('BG-YAG', 'BG-YAG (Yagodovo, Bulgaria)'),
    ('BG-YAK', 'BG-YAK (Yakoruda, Bulgaria)'),
    ('BG-YAM', 'BG-YAM (Yambol, Bulgaria)'),
    ('BG-YKG', 'BG-YKG (Yoakim-Gruevo, Bulgaria)'),
    ('BG-BUR', 'BG-BUR (Zavet, Bulgaria)'),
    ('BG-PLV', 'BG-PLV (Zhitnitsa, Bulgaria)'),
    ('BG-ZLA', 'BG-ZLA (Zlatarevo, Bulgaria)'),
    ('BG-ZTT', 'BG-ZTT (Zlataritsa, Bulgaria)'),
    ('BG-ZLH', 'BG-ZLH (Zlatograd, Bulgaria)'),
    ('BH-AAL', "BH-AAL (A'ali, Bahrain)"),
    ('BH-ADA', 'BH-ADA (Adliya, Bahrain)'),
    ('BH-ALA', 'BH-ALA (Al Hajar, Bahrain)'),
    ('BH-AHD', 'BH-AHD (Al Hidd, Bahrain)'),
    ('BH-AMA', "BH-AMA (Al Ma'amir, Bahrain)"),
    ('BH-AMH', 'BH-AMH (Al Manamah, Bahrain)'),
    ('BH-GBQ', 'BH-GBQ (Al Muharraq, Bahrain)'),
    ('BH-BAH', 'BH-BAH (Bahrain International Airport, Bahrain)'),
    ('BH-TOW', 'BH-TOW (Hamad Town, Bahrain)'),
    ('BH-ISA', 'BH-ISA (ISA Air Base, Bahrain)'),
    ('BH-JAL', "BH-JAL (Jidd 'Ali, Bahrain)"),
    ('BH-JDF', 'BH-JDF (Jidhafs, Bahrain)'),
    ('BH-KBS', 'BH-KBS (Khalifa Bin Salman Port, Bahrain)'),
    ('BH-KFC', 'BH-KFC (King Fahed Causeway, Bahrain)'),
    ('BH-MTH', 'BH-MTH (Madinat Hamad, Bahrain)'),
    ('BH-MIN', 'BH-MIN (Mina Sulman Port, Bahrain)'),
    ('BH-QAL', 'BH-QAL (Qalali, Bahrain)'),
    ('BH-RAJ', 'BH-RAJ (Ras Abu Jarjur, Bahrain)'),
    ('BH-RIF', 'BH-RIF (Riffa, Bahrain)'),
    ('BH-SAN', 'BH-SAN (Sanad, Bahrain)'),
    ('BH-SIT', 'BH-SIT (Sitrah, Bahrain)'),
    ('BH-TUB', 'BH-TUB (Tubli, Bahrain)'),
    ('BH-UAH', 'BH-UAH (Umm al Hassam, Bahrain)'),
    ('BI-BBZ', 'BI-BBZ (Bubanza, Bubanza, Burundi)'),
    ('BI-BJM', 'BI-BJM (Bubanza, Bubanza, Burundi)'),
    ('BI-BRR', 'BI-BRR (Bururi, Bururi, Burundi)'),
    ('BI-CKZ', 'BI-CKZ (Cankuzo, Cankuzo, Burundi)'),
    ('BI-CBK', 'BI-CBK (Cibitoke, Bujumbura Mairie, Burundi)'),
    ('BI-GID', 'BI-GID (Cibitoke, Bujumbura Mairie, Burundi)'),
    ('BI-KKB', 'BI-KKB (Karuzi, Karuzi, Burundi)'),
    ('BI-KYZ', 'BI-KYZ (Kayanza, Kayanza, Burundi)'),
    ('BI-KRE', 'BI-KRE (Kayanza, Kayanza, Burundi)'),
    ('BI-MMB', 'BI-MMB (Makamba, Makamba, Burundi)'),
    ('BI-MUR', 'BI-MUR (Muramvya, Muramvya, Burundi)'),
    ('BI-MYG', 'BI-MYG (Muyinga, Muyinga, Burundi)'),
    ('BI-MWM', 'BI-MWM (Mwaro, Muramvya, Burundi)'),
    ('BI-NGZ', 'BI-NGZ (Ngozi, Ngozi, Burundi)'),
    ('BI-RUM', 'BI-RUM (Ngozi, Ngozi, Burundi)'),
    ('BI-RUT', 'BI-RUT (Rutana, Rutana, Burundi)'),
    ('BI-RUY', 'BI-RUY (Ruyigi, Ruyigi, Burundi)'),
    ('BJ-AMV', 'BJ-AMV (Abomey-Calavi, Benin)'),
    ('BJ-AGT', 'BJ-AGT (Agbanta, Benin)'),
    ('BJ-BOH', 'BJ-BOH (Bohicon, Benin)'),
    ('BJ-COO', 'BJ-COO (Cotonou, Benin)'),
    ('BJ-DDJ', 'BJ-DDJ (Djidja, Benin)'),
    ('BJ-DJA', 'BJ-DJA (Djougou, Benin)'),
    ('BJ-GLA', 'BJ-GLA (Glazoué, Benin)'),
    ('BJ-KDC', 'BJ-KDC (Kandi, Benin)'),
    ('BJ-LKS', 'BJ-LKS (Lokossa, Benin)'),
    ('BJ-NAE', 'BJ-NAE (Natitingou, Benin)'),
    ('BJ-DA3', 'BJ-DA3 (Ndali, Benin)'),
    ('BJ-OIH', 'BJ-OIH (Ouidah, Benin)'),
    ('BJ-PKO', 'BJ-PKO (Parakou, Benin)'),
    ('BJ-PTN', 'BJ-PTN (Porto-Novo, Benin)'),
    ('BJ-SVF', 'BJ-SVF (Savé, Benin)'),
    ('BJ-SEM', 'BJ-SEM (Seme Terminal, Benin)'),
    ('BJ-TAN', 'BJ-TAN (Tanguiéta, Benin)'),
    ('BL-SBH', 'BL-SBH (Saint-Barthélemy, Saint Barthélemy)'),
    ('BM-SEV', 'BM-SEV (Devonshire, Bermuda)'),
    ('BM-FPT', 'BM-FPT (Freeport, Bermuda)'),
    ('BM-BDA', 'BM-BDA (Hamilton, Bermuda)'),
    ('BM-HBI', 'BM-HBI (Harbour Island, Bermuda)'),
    ('BM-KWF', 'BM-KWF (Kings Wharf, Bermuda)'),
    ('BM-PA5', 'BM-PA5 (Paget Parish, Bermuda)'),
    ('BM-5PE', 'BM-5PE (Pembroke, Bermuda)'),
    ('BM-SGE', 'BM-SGE (Saint George, Bermuda)'),
    ('BM-SAN', 'BM-SAN (Sandys, Bermuda)'),
    ('BM-SOU', 'BM-SOU (Southampton, Bermuda)'),
    ('BM-WA7', 'BM-WA7 (Warwick, Bermuda)'),
    ('BN-BWN', 'BN-BWN (Bandar Seri Begawan, Brunei Darussalam)'),
    ('BN-BAG', 'BN-BAG (Bangar, Brunei Darussalam)'),
    ('BN-KUB', 'BN-KUB (Kuala Belait, Brunei Darussalam)'),
    ('BN-LUM', 'BN-LUM (Lumut, Brunei Darussalam)'),
    ('BN-MUA', 'BN-MUA (Muara, Brunei Darussalam)'),
    ('BN-SER', 'BN-SER (Seria, Brunei Darussalam)'),
    ('BN-TAS', 'BN-TAS (Tanjong Salirong, Brunei Darussalam)'),
    ('BN-TUT', 'BN-TUT (Tutong, Brunei Darussalam)'),
    ('BO-ACH', 'BO-ACH (Achacachi, Bolivia, Plurinational State of)'),
    ('BO-ACL', 'BO-ACL (Achocalla, Bolivia, Plurinational State of)'),
    ('BO-AQL', 'BO-AQL (Aiquile, Bolivia, Plurinational State of)'),
    ('BO-ALC', 'BO-ALC (Alcalá, Bolivia, Plurinational State of)'),
    ('BO-ANC', 'BO-ANC (Ancoraimes, Bolivia, Plurinational State of)'),
    ('BO-APB', 'BO-APB (Apolo, Bolivia, Plurinational State of)'),
    ('BO-ARC', 'BO-ARC (Arica, Bolivia, Plurinational State of)'),
    ('BO-ASC', 'BO-ASC (Ascensión, Bolivia, Plurinational State of)'),
    ('BO-AUC', 'BO-AUC (Aucapata, Bolivia, Plurinational State of)'),
    ('BO-ABA', 'BO-ABA (Avaroa, Bolivia, Plurinational State of)'),
    ('BO-AYT', 'BO-AYT (Ayata, Bolivia, Plurinational State of)'),
    ('BO-AYO', 'BO-AYO (Ayo Ayo, Bolivia, Plurinational State of)'),
    ('BO-AZY', 'BO-AZY (Azurduy, Bolivia, Plurinational State of)'),
    ('BO-BAT', 'BO-BAT (Batallas, Bolivia, Plurinational State of)'),
    ('BO-BVL', 'BO-BVL (Baures, Bolivia, Plurinational State of)'),
    ('BO-BEF', 'BO-BEF (Bella Flor, Bolivia, Plurinational State of)'),
    ('BO-BJO', 'BO-BJO (Bermejo, Bolivia, Plurinational State of)'),
    ('BO-BPB', 'BO-BPB (Bolpebra, Bolivia, Plurinational State of)'),
    ('BO-CJT', 'BO-CJT (Cajuata, Bolivia, Plurinational State of)'),
    ('BO-CAO', 'BO-CAO (Calacoto, Bolivia, Plurinational State of)'),
    ('BO-CCM', 'BO-CCM (Calacoto, Bolivia, Plurinational State of)'),
    ('BO-CCO', 'BO-CCO (Calacoto, Bolivia, Plurinational State of)'),
    ('BO-CAL', 'BO-CAL (Calamarca, Bolivia, Plurinational State of)'),
    ('BO-CMR', 'BO-CMR (Camargo, Bolivia, Plurinational State of)'),
    ('BO-CAM', 'BO-CAM (Camiri, Bolivia, Plurinational State of)'),
    ('BO-CAQ', 'BO-CAQ (Caquiaviri, Bolivia, Plurinational State of)'),
    ('BO-CRN', 'BO-CRN (Caranavi, Bolivia, Plurinational State of)'),
    ('BO-CAI', 'BO-CAI (Carapari, Bolivia, Plurinational State of)'),
    ('BO-CAR', 'BO-CAR (Carrasco, Bolivia, Plurinational State of)'),
    ('BO-CTC', 'BO-CTC (Catacora, Bolivia, Plurinational State of)'),
    ('BO-CNO', 'BO-CNO (Cañada Oruro, Bolivia, Plurinational State of)'),
    ('BO-CHR', 'BO-CHR (Chacarilla, Bolivia, Plurinational State of)'),
    ('BO-CHA', 'BO-CHA (Charaña, Bolivia, Plurinational State of)'),
    ('BO-CHU', 'BO-CHU (Chulumani, Bolivia, Plurinational State of)'),
    ('BO-CHM', 'BO-CHM (Chuma, Bolivia, Plurinational State of)'),
    ('BO-CIJ', 'BO-CIJ (Cobija, Bolivia, Plurinational State of)'),
    ('BO-CBB', 'BO-CBB (Cochabamba, Bolivia, Plurinational State of)'),
    ('BO-CLL', 'BO-CLL (Collana, Bolivia, Plurinational State of)'),
    ('BO-CLN', 'BO-CLN (Collpani, Bolivia, Plurinational State of)'),
    ('BO-COL', 'BO-COL (Collpani, Bolivia, Plurinational State of)'),
    ('BO-CLQ', 'BO-CLQ (Colquencha, Bolivia, Plurinational State of)'),
    ('BO-CME', 'BO-CME (Comanche, Bolivia, Plurinational State of)'),
    ('BO-COM', 'BO-COM (Combaya, Bolivia, Plurinational State of)'),
    ('BO-CEP', 'BO-CEP (Concepción, Bolivia, Plurinational State of)'),
    ('BO-CPB', 'BO-CPB (Copacabana, Bolivia, Plurinational State of)'),
    ('BO-CRP', 'BO-CRP (Coripata, Bolivia, Plurinational State of)'),
    ('BO-CCR', 'BO-CCR (Coro Coro, Bolivia, Plurinational State of)'),
    ('BO-COR', 'BO-COR (Coroico, Bolivia, Plurinational State of)'),
    ('BO-CUL', 'BO-CUL (Culpina, Bolivia, Plurinational State of)'),
    ('BO-CUR', 'BO-CUR (Curva, Bolivia, Plurinational State of)'),
    ('BO-DES', 'BO-DES (Desaguadero, Bolivia, Plurinational State of)'),
    ('BO-ALT', 'BO-ALT (El Alto, Bolivia, Plurinational State of)'),
    ('BO-ENT', 'BO-ENT (Entre Ríos, Bolivia, Plurinational State of)'),
    ('BO-ESC', 'BO-ESC (Escoma, Bolivia, Plurinational State of)'),
    ('BO-EXA', 'BO-EXA (Exaltación, Bolivia, Plurinational State of)'),
    ('BO-FIL', 'BO-FIL (Filadelfia, Bolivia, Plurinational State of)'),
    ('BO-GUA', 'BO-GUA (Guanay, Bolivia, Plurinational State of)'),
    ('BO-GUQ', 'BO-GUQ (Guaqui, Bolivia, Plurinational State of)'),
    ('BO-GYA', 'BO-GYA (Guayaramerín, Bolivia, Plurinational State of)'),
    ('BO-HIT', 'BO-HIT (Hito Cajones, Bolivia, Plurinational State of)'),
    ('BO-BVK', 'BO-BVK (Huacaraje, Bolivia, Plurinational State of)'),
    ('BO-HUA', 'BO-HUA (Huacaya, Bolivia, Plurinational State of)'),
    ('BO-HUR', 'BO-HUR (Huarina, Bolivia, Plurinational State of)'),
    ('BO-HTJ', 'BO-HTJ (Huatajata, Bolivia, Plurinational State of)'),
    ('BO-HMT', 'BO-HMT (Humaitá, Bolivia, Plurinational State of)'),
    ('BO-HUM', 'BO-HUM (Humanata, Bolivia, Plurinational State of)'),
    ('BO-ICH', 'BO-ICH (Ichoca, Bolivia, Plurinational State of)'),
    ('BO-INQ', 'BO-INQ (Inquisivi, Bolivia, Plurinational State of)'),
    ('BO-IRU', 'BO-IRU (Irupana, Bolivia, Plurinational State of)'),
    ('BO-IXM', 'BO-IXM (Ixiamas, Bolivia, Plurinational State of)'),
    ('BO-JMC', 'BO-JMC (Jesús de Machaca, Bolivia, Plurinational State of)'),
    ('BO-ASN', 'BO-ASN (La Asunta, Bolivia, Plurinational State of)'),
    ('BO-LPB', 'BO-LPB (La Paz, Bolivia, Plurinational State of)'),
    ('BO-LAJ', 'BO-LAJ (Laja, Bolivia, Plurinational State of)'),
    ('BO-LOR', 'BO-LOR (Loreto, Bolivia, Plurinational State of)'),
    ('BO-LUR', 'BO-LUR (Luribay, Bolivia, Plurinational State of)'),
    ('BO-MCH', 'BO-MCH (Macharetí, Bolivia, Plurinational State of)'),
    ('BO-MGD', 'BO-MGD (Magdalena, Bolivia, Plurinational State of)'),
    ('BO-MLL', 'BO-MLL (Malla, Bolivia, Plurinational State of)'),
    ('BO-MAP', 'BO-MAP (Mapiri, Bolivia, Plurinational State of)'),
    ('BO-MEC', 'BO-MEC (Mecapaca, Bolivia, Plurinational State of)'),
    ('BO-MOC', 'BO-MOC (Moco Moco, Bolivia, Plurinational State of)'),
    ('BO-MOJ', 'BO-MOJ (Mojocoya, Bolivia, Plurinational State of)'),
    ('BO-MHW', 'BO-MHW (Monteagudo, Bolivia, Plurinational State of)'),
    ('BO-NES', 'BO-NES (Nueva Esperanza, Bolivia, Plurinational State of)'),
    ('BO-OBS', 'BO-OBS (Obrajes, Bolivia, Plurinational State of)'),
    ('BO-ORU', 'BO-ORU (Oruro, Bolivia, Plurinational State of)'),
    ('BO-PDC', 'BO-PDC (Padcaya, Bolivia, Plurinational State of)'),
    ('BO-PAD', 'BO-PAD (Padilla, Bolivia, Plurinational State of)'),
    ('BO-PAL', 'BO-PAL (Palca, Bolivia, Plurinational State of)'),
    ('BO-PPM', 'BO-PPM (Papel Pampa, Bolivia, Plurinational State of)'),
    ('BO-PAT', 'BO-PAT (Patacamaya, Bolivia, Plurinational State of)'),
    ('BO-PEL', 'BO-PEL (Pelechuco, Bolivia, Plurinational State of)'),
    ('BO-PIS', 'BO-PIS (Pisiga, Bolivia, Plurinational State of)'),
    ('BO-POR', 'BO-POR (Poroma, Bolivia, Plurinational State of)'),
    ('BO-PRV', 'BO-PRV (Porvenir, Bolivia, Plurinational State of)'),
    ('BO-POI', 'BO-POI (Potosí, Bolivia, Plurinational State of)'),
    ('BO-PRE', 'BO-PRE (Presto, Bolivia, Plurinational State of)'),
    ('BO-PUC', 'BO-PUC (Pucarani, Bolivia, Plurinational State of)'),
    ('BO-PTA', 'BO-PTA (Puerto Acosta, Bolivia, Plurinational State of)'),
    ('BO-PBU', 'BO-PBU (Puerto Busch, Bolivia, Plurinational State of)'),
    ('BO-PTC', 'BO-PTC (Puerto Carabuco, Bolivia, Plurinational State of)'),
    ('BO-PGM', 'BO-PGM (Puerto Gonzalo Moreno, Bolivia, Plurinational State of)'),
    ('BO-PPR', 'BO-PPR (Puerto Pérez, Bolivia, Plurinational State of)'),
    ('BO-QJR', 'BO-QJR (Puerto Quijarro, Bolivia, Plurinational State of)'),
    ('BO-PUR', 'BO-PUR (Puerto Rico, Bolivia, Plurinational State of)'),
    ('BO-PTS', 'BO-PTS (Puerto Siles, Bolivia, Plurinational State of)'),
    ('BO-PSZ', 'BO-PSZ (Puerto Suárez, Bolivia, Plurinational State of)'),
    ('BO-QBA', 'BO-QBA (Quiabaya, Bolivia, Plurinational State of)'),
    ('BO-QUO', 'BO-QUO (Quillacollo, Bolivia, Plurinational State of)'),
    ('BO-QME', 'BO-QME (Quime, Bolivia, Plurinational State of)'),
    ('BO-REY', 'BO-REY (Reyes, Bolivia, Plurinational State of)'),
    ('BO-RIB', 'BO-RIB (Riberalta, Bolivia, Plurinational State of)'),
    ('BO-RBO', 'BO-RBO (Roboré, Bolivia, Plurinational State of)'),
    ('BO-RBQ', 'BO-RBQ (Rurrenabaque, Bolivia, Plurinational State of)'),
    ('BO-SAM', 'BO-SAM (San Andrés de Machaca, Bolivia, Plurinational State of)'),
    ('BO-SRJ', 'BO-SRJ (San Borja, Bolivia, Plurinational State of)'),
    ('BO-SBV', 'BO-SBV (San Buenaventura, Bolivia, Plurinational State of)'),
    ('BO-SNM', 'BO-SNM (San Ignacio de Moxo, Bolivia, Plurinational State of)'),
    ('BO-SNG', 'BO-SNG (San Ignacio de Velasco, Bolivia, Plurinational State of)'),
    ('BO-SJV', 'BO-SJV (San Javier, Bolivia, Plurinational State of)'),
    ('BO-SJB', 'BO-SJB (San Joaquín, Bolivia, Plurinational State of)'),
    ('BO-SJS', 'BO-SJS (San José, Bolivia, Plurinational State of)'),
    ('BO-SLO', 'BO-SLO (San Lorenzo, Bolivia, Plurinational State of)'),
    ('BO-SLR', 'BO-SLR (San Lorenzo, Bolivia, Plurinational State of)'),
    ('BO-SLC', 'BO-SLC (San Lucas, Bolivia, Plurinational State of)'),
    ('BO-MQK', 'BO-MQK (San Matias, Bolivia, Plurinational State of)'),
    ('BO-SPH', 'BO-SPH (San Pablo de Huacareta, Bolivia, Plurinational State of)'),
    ('BO-SPD', 'BO-SPD (San Pedro, Bolivia, Plurinational State of)'),
    ('BO-SCH', 'BO-SCH (San Pedro de Curahuara, Bolivia, Plurinational State of)'),
    ('BO-SRD', 'BO-SRD (San Ramón, Bolivia, Plurinational State of)'),
    ('BO-SBL', 'BO-SBL (Santa Ana, Bolivia, Plurinational State of)'),
    ('BO-SRZ', 'BO-SRZ (Santa Cruz, Bolivia, Plurinational State of)'),
    ('BO-SCS', 'BO-SCS (Santa Cruz de la Sierra, Bolivia, Plurinational State of)'),
    ('BO-SRB', 'BO-SRB (Santa Rosa, Bolivia, Plurinational State of)'),
    ('BO-SRA', 'BO-SRA (Santa Rosa del Abuná, Bolivia, Plurinational State of)'),
    ('BO-SDH', 'BO-SDH (Santiago de Huari, Bolivia, Plurinational State of)'),
    ('BO-STH', 'BO-STH (Santiago de Huata, Bolivia, Plurinational State of)'),
    ('BO-SMC', 'BO-SMC (Santiago de Machaca, Bolivia, Plurinational State of)'),
    ('BO-SAN', 'BO-SAN (Santiváñez, Bolivia, Plurinational State of)'),
    ('BO-SME', 'BO-SME (Santos Mercado, Bolivia, Plurinational State of)'),
    ('BO-SAP', 'BO-SAP (Sapahaqui, Bolivia, Plurinational State of)'),
    ('BO-SIC', 'BO-SIC (Sica Sica, Bolivia, Plurinational State of)'),
    ('BO-SIP', 'BO-SIP (Sipe Sipe, Bolivia, Plurinational State of)'),
    ('BO-SOR', 'BO-SOR (Sorata, Bolivia, Plurinational State of)'),
    ('BO-SRE', 'BO-SRE (Sucre, Bolivia, Plurinational State of)'),
    ('BO-TAC', 'BO-TAC (Tacacoma, Bolivia, Plurinational State of)'),
    ('BO-TAQ', 'BO-TAQ (Tambo Quemado, Bolivia, Plurinational State of)'),
    ('BO-TAR', 'BO-TAR (Tarabuco, Bolivia, Plurinational State of)'),
    ('BO-TRC', 'BO-TRC (Taraco, Bolivia, Plurinational State of)'),
    ('BO-TJA', 'BO-TJA (Tarija, Bolivia, Plurinational State of)'),
    ('BO-TEO', 'BO-TEO (Teoponte, Bolivia, Plurinational State of)'),
    ('BO-TIA', 'BO-TIA (Tiahuanacu, Bolivia, Plurinational State of)'),
    ('BO-TIP', 'BO-TIP (Tipuani, Bolivia, Plurinational State of)'),
    ('BO-TQY', 'BO-TQY (Tiquipaya, Bolivia, Plurinational State of)'),
    ('BO-TOM', 'BO-TOM (Tomina, Bolivia, Plurinational State of)'),
    ('BO-TDD', 'BO-TDD (Trinidad, Bolivia, Plurinational State of)'),
    ('BO-UMA', 'BO-UMA (Umala, Bolivia, Plurinational State of)'),
    ('BO-URI', 'BO-URI (Uriondo, Bolivia, Plurinational State of)'),
    ('BO-UYU', 'BO-UYU (Uyuni, Bolivia, Plurinational State of)'),
    ('BO-VAH', 'BO-VAH (Vallegrande, Bolivia, Plurinational State of)'),
    ('BO-VIA', 'BO-VIA (Viacha, Bolivia, Plurinational State of)'),
    ('BO-VAB', 'BO-VAB (Villa Abecia (Camataqui), Bolivia, Plurinational State of)'),
    ('BO-VIN', 'BO-VIN (Villa Nueva, Bolivia, Plurinational State of)'),
    ('BO-VSR', 'BO-VSR (Villa Serrano, Bolivia, Plurinational State of)'),
    ('BO-VLM', 'BO-VLM (Villamontes, Bolivia, Plurinational State of)'),
    ('BO-VL2', 'BO-VL2 (Villazon, Bolivia, Plurinational State of)'),
    ('BO-VLL', 'BO-VLL (Villazón, Bolivia, Plurinational State of)'),
    ('BO-VVI', 'BO-VVI (Viru Viru, Bolivia, Plurinational State of)'),
    ('BO-WAB', 'BO-WAB (Waldo Ballivian, Bolivia, Plurinational State of)'),
    ('BO-YAC', 'BO-YAC (Yaco, Bolivia, Plurinational State of)'),
    ('BO-BYC', 'BO-BYC (Yacuiba, Bolivia, Plurinational State of)'),
    ('BO-YAM', 'BO-YAM (Yamparáez, Bolivia, Plurinational State of)'),
    ('BO-YAN', 'BO-YAN (Yanacachi, Bolivia, Plurinational State of)'),
    ('BO-YOT', 'BO-YOT (Yotala, Bolivia, Plurinational State of)'),
    ('BO-YUO', 'BO-YUO (Yucumo, Bolivia, Plurinational State of)'),
    ('BO-YUN', 'BO-YUN (Yunchara, Bolivia, Plurinational State of)'),
    ('BO-ZUD', 'BO-ZUD (Zudáñez, Bolivia, Plurinational State of)'),
    ('BQ-BON', 'BQ-BON (Bonaire, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-RIN', 'BQ-RIN (Dorp Rincón, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-DTK', 'BQ-DTK (Dorp Tera Kora, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-GOT', 'BQ-GOT (Goto, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-KRA', 'BQ-KRA (Kralendijk, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-ORA', 'BQ-ORA (Oranjestad, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-SAB', 'BQ-SAB (Saba, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-EUX', 'BQ-EUX (Sint Eustatius, Bonaire, Sint Eustatius and Saba)'),
    ('BQ-BOT', 'BQ-BOT (The Bottom, Bonaire, Sint Eustatius and Saba)'),
    ('BR-ATB', 'BR-ATB (Abaetetuba, Pará, Brazil)'),
    ('BR-ABT', 'BR-ABT (Abaeté, Minas Gerais, Brazil)'),
    ('BR-ABR', 'BR-ABR (Abaré, Bahia, Brazil)'),
    ('BR-ADL', 'BR-ADL (Abelardo Luz, Santa Catarina, Brazil)'),
    ('BR-ALM', 'BR-ALM (Abreu e Lima, Pernambuco, Brazil)'),
    ('BR-ACL', 'BR-ACL (Acailandia, Maranhão, Brazil)'),
    ('BR-ACE', 'BR-ACE (Acarape, Ceará, Brazil)'),
    ('BR-ACU', 'BR-ACU (Acarau, Ceará, Brazil)'),
    ('BR-ACR', 'BR-ACR (Acari, Rio Grande do Norte, Brazil)'),
    ('BR-ACN', 'BR-ACN (Acreuna, Goiás, Brazil)'),
    ('BR-AMT', 'BR-AMT (Adamantina, São Paulo, Brazil)'),
    ('BR-ADI', 'BR-ADI (Afogados da Ingazeira, Pernambuco, Brazil)'),
    ('BR-AFC', 'BR-AFC (Afonso Claudio, Espírito Santo, Brazil)'),
    ('BR-AFU', 'BR-AFU (Afuá, Pará, Brazil)'),
    ('BR-ARO', 'BR-ARO (Agrolandia, Santa Catarina, Brazil)'),
    ('BR-AGC', 'BR-AGC (Agua Clara, Mato Grosso do Sul, Brazil)'),
    ('BR-AGU', 'BR-AGU (Aguai, São Paulo, Brazil)'),
    ('BR-ASP', 'BR-ASP (Aguas da Prata, São Paulo, Brazil)'),
    ('BR-AGL', 'BR-AGL (Aguas de Lindoia, São Paulo, Brazil)'),
    ('BR-ASB', 'BR-ASB (Aguas de Santa Barbara, São Paulo, Brazil)'),
    ('BR-ASO', 'BR-ASO (Aguas de Sao Pedro, São Paulo, Brazil)'),
    ('BR-AMR', 'BR-AMR (Aguas Mornas, Santa Catarina, Brazil)'),
    ('BR-AGO', 'BR-AGO (Agudo, Rio Grande do Sul, Brazil)'),
    ('BR-AGD', 'BR-AGD (Agudos, São Paulo, Brazil)'),
    ('BR-AMS', 'BR-AMS (Aimores, Minas Gerais, Brazil)'),
    ('BR-ARC', 'BR-ARC (Aiuruoca, Minas Gerais, Brazil)'),
    ('BR-AGS', 'BR-AGS (Aiuruoca, Minas Gerais, Brazil)'),
    ('BR-ALB', 'BR-ALB (Albertina, Minas Gerais, Brazil)'),
    ('BR-ACT', 'BR-ACT (Alcantara, Maranhão, Brazil)'),
    ('BR-ALC', 'BR-ALC (Alcobaca, Bahia, Brazil)'),
    ('BR-ALG', 'BR-ALG (Alegre, Espírito Santo, Brazil)'),
    ('BR-ALQ', 'BR-ALQ (Alegrete, Rio Grande do Sul, Brazil)'),
    ('BR-APB', 'BR-APB (Alem Paraiba, Minas Gerais, Brazil)'),
    ('BR-ALT', 'BR-ALT (Alenquer, Pará, Brazil)'),
    ('BR-AXN', 'BR-AXN (Alexania, Goiás, Brazil)'),
    ('BR-ALF', 'BR-ALF (Alfenas, Minas Gerais, Brazil)'),
    ('BR-AWR', 'BR-AWR (Alfredo Wagner, Santa Catarina, Brazil)'),
    ('BR-ALH', 'BR-ALH (Alhandra, Paraíba, Brazil)'),
    ('BR-AMM', 'BR-AMM (Almeirim, Pará, Brazil)'),
    ('BR-AMJ', 'BR-AMJ (Almenara, Minas Gerais, Brazil)'),
    ('BR-ALO', 'BR-ALO (Aloandia, Goiás, Brazil)'),
    ('BR-ALP', 'BR-ALP (Alpinópolis, Minas Gerais, Brazil)'),
    ('BR-AFL', 'BR-AFL (Alta Floresta, Mato Grosso, Brazil)'),
    ('BR-AFO', 'BR-AFO (Alta Floresta do Oeste, Rondônia, Brazil)'),
    ('BR-ATM', 'BR-ATM (Altamira, Pará, Brazil)'),
    ('BR-ATS', 'BR-ATS (Alterosa, Minas Gerais, Brazil)'),
    ('BR-APO', 'BR-APO (Altinopolis, São Paulo, Brazil)'),
    ('BR-ATG', 'BR-ATG (Alto Araguaia, Mato Grosso, Brazil)'),
    ('BR-ABV', 'BR-ABV (Alto Boa Vista, Mato Grosso, Brazil)'),
    ('BR-AFZ', 'BR-AFZ (Alto Feliz, Rio Grande do Sul, Brazil)'),
    ('BR-AGR', 'BR-AGR (Alto Garcas, Mato Grosso, Brazil)'),
    ('BR-AHZ', 'BR-AHZ (Alto Horizonte, Goiás, Brazil)'),
    ('BR-APG', 'BR-APG (Alto Paraiso de Goias, Goiás, Brazil)'),
    ('BR-APN', 'BR-APN (Alto Parana, Paraná, Brazil)'),
    ('BR-APY', 'BR-APY (Alto Parnaíba, Maranhão, Brazil)'),
    ('BR-AQI', 'BR-AQI (Alto Piquiri, Paraná, Brazil)'),
    ('BR-ATQ', 'BR-ATQ (Alto Taquari, Mato Grosso, Brazil)'),
    ('BR-ATO', 'BR-ATO (Altonia, Paraná, Brazil)'),
    ('BR-ALS', 'BR-ALS (Altos, Piauí, Brazil)'),
    ('BR-ALU', 'BR-ALU (Alumar, Maranhão, Brazil)'),
    ('BR-AMO', 'BR-AMO (Alumínio, São Paulo, Brazil)'),
    ('BR-AMH', 'BR-AMH (Alvares Machado, São Paulo, Brazil)'),
    ('BR-AVD', 'BR-AVD (Alvinlândia, São Paulo, Brazil)'),
    ('BR-ALV', 'BR-ALV (Alvorada, Tocantins, Brazil)'),
    ('BR-AVR', 'BR-AVR (Alvorada, Rio Grande do Sul, Brazil)'),
    ('BR-AVN', 'BR-AVN (Alvorada do Norte, Goiás, Brazil)'),
    ('BR-AMB', 'BR-AMB (Amambai, Mato Grosso do Sul, Brazil)'),
    ('BR-ARJ', 'BR-ARJ (Amaraji, Pernambuco, Brazil)'),
    ('BR-AME', 'BR-AME (Americana, São Paulo, Brazil)'),
    ('BR-ADB', 'BR-ADB (Americano do Brasil, Goiás, Brazil)'),
    ('BR-ABI', 'BR-ABI (Americo Brasiliense, São Paulo, Brazil)'),
    ('BR-ACP', 'BR-ACP (Americo de Campos, São Paulo, Brazil)'),
    ('BR-ADS', 'BR-ADS (Ametista do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-AMP', 'BR-AMP (Amparo, São Paulo, Brazil)'),
    ('BR-AEG', 'BR-AEG (Amélia Rodrigues, Bahia, Brazil)'),
    ('BR-ANI', 'BR-ANI (Analandia, São Paulo, Brazil)'),
    ('BR-ANA', 'BR-ANA (Ananindeua, Pará, Brazil)'),
    ('BR-ATC', 'BR-ATC (Anastacio, Mato Grosso do Sul, Brazil)'),
    ('BR-ACH', 'BR-ACH (Anchieta, Santa Catarina, Brazil)'),
    ('BR-AHI', 'BR-AHI (Anchieta, Espírito Santo, Brazil)'),
    ('BR-ARI', 'BR-ARI (Andarai, Bahia, Brazil)'),
    ('BR-AIA', 'BR-AIA (Andira, Paraná, Brazil)'),
    ('BR-ARD', 'BR-ARD (Andradas, Minas Gerais, Brazil)'),
    ('BR-AAN', 'BR-AAN (Andradina, São Paulo, Brazil)'),
    ('BR-AND', 'BR-AND (Andrelandia, Minas Gerais, Brazil)'),
    ('BR-AGT', 'BR-AGT (Angatuba, São Paulo, Brazil)'),
    ('BR-AIC', 'BR-AIC (Angelica, Mato Grosso do Sul, Brazil)'),
    ('BR-ANL', 'BR-ANL (Angelândia, Minas Gerais, Brazil)'),
    ('BR-ADR', 'BR-ADR (Angra dos Reis, Rio de Janeiro, Brazil)'),
    ('BR-ANH', 'BR-ANH (Anhembi, São Paulo, Brazil)'),
    ('BR-ANC', 'BR-ANC (Anicuns, Goiás, Brazil)'),
    ('BR-ANT', 'BR-ANT (Antonina, Paraná, Brazil)'),
    ('BR-ACS', 'BR-ACS (Antonio Carlos, Santa Catarina, Brazil)'),
    ('BR-AJO', 'BR-AJO (Antonio Joao, Mato Grosso do Sul, Brazil)'),
    ('BR-APS', 'BR-APS (Anápolis, Goiás, Brazil)'),
    ('BR-API', 'BR-API (Aparecida, São Paulo, Brazil)'),
    ('BR-AGI', 'BR-AGI (Aparecida de Goiania, Goiás, Brazil)'),
    ('BR-ATD', 'BR-ATD (Aparecida do Taboado, Mato Grosso do Sul, Brazil)'),
    ('BR-APA', 'BR-APA (Apiai, São Paulo, Brazil)'),
    ('BR-AUA', 'BR-AUA (Apiuna, Santa Catarina, Brazil)'),
    ('BR-APD', 'BR-APD (Apodi, Rio Grande do Norte, Brazil)'),
    ('BR-APU', 'BR-APU (Apucarana, Paraná, Brazil)'),
    ('BR-AQD', 'BR-AQD (Aquidauana, Mato Grosso do Sul, Brazil)'),
    ('BR-AQR', 'BR-AQR (Aquiraz, Ceará, Brazil)'),
    ('BR-AJU', 'BR-AJU (Aracaju, Sergipe, Brazil)'),
    ('BR-ART', 'BR-ART (Aracati, Ceará, Brazil)'),
    ('BR-ASR', 'BR-ASR (Aracoiaba da Serra, São Paulo, Brazil)'),
    ('BR-ACZ', 'BR-ACZ (Aracruz, Espírito Santo, Brazil)'),
    ('BR-AAA', 'BR-AAA (Aracuai, Minas Gerais, Brazil)'),
    ('BR-ARS', 'BR-ARS (Aragarças, Goiás, Brazil)'),
    ('BR-ARG', 'BR-ARG (Araguacu, Tocantins, Brazil)'),
    ('BR-AGZ', 'BR-AGZ (Araguapaz, Goiás, Brazil)'),
    ('BR-ARR', 'BR-ARR (Araguari, Minas Gerais, Brazil)'),
    ('BR-AUX', 'BR-AUX (Araguaína, Tocantins, Brazil)'),
    ('BR-APQ', 'BR-APQ (Arapiraca, Alagoas, Brazil)'),
    ('BR-APX', 'BR-APX (Arapongas, Paraná, Brazil)'),
    ('BR-ARP', 'BR-ARP (Arapora, Minas Gerais, Brazil)'),
    ('BR-AAG', 'BR-AAG (Arapoti, Paraná, Brazil)'),
    ('BR-ATN', 'BR-ATN (Araputanga, Mato Grosso, Brazil)'),
    ('BR-ARQ', 'BR-ARQ (Araquari, Santa Catarina, Brazil)'),
    ('BR-ARN', 'BR-ARN (Ararangua, Santa Catarina, Brazil)'),
    ('BR-AQA', 'BR-AQA (Araraquara, São Paulo, Brazil)'),
    ('BR-ARA', 'BR-ARA (Araras, São Paulo, Brazil)'),
    ('BR-AIP', 'BR-AIP (Araripina, Pernambuco, Brazil)'),
    ('BR-AMA', 'BR-AMA (Araruama, Rio de Janeiro, Brazil)'),
    ('BR-AAU', 'BR-AAU (Araruna, Paraná, Brazil)'),
    ('BR-ARB', 'BR-ARB (Aratu, Bahia, Brazil)'),
    ('BR-ACA', 'BR-ACA (Araucária, Paraná, Brazil)'),
    ('BR-AAX', 'BR-AAX (Araxá, Minas Gerais, Brazil)'),
    ('BR-ARM', 'BR-ARM (Araçariguama, São Paulo, Brazil)'),
    ('BR-ARU', 'BR-ARU (Araçatuba, São Paulo, Brazil)'),
    ('BR-ARK', 'BR-ARK (Araçás, Bahia, Brazil)'),
    ('BR-AOS', 'BR-AOS (Arcos, Minas Gerais, Brazil)'),
    ('BR-ARV', 'BR-ARV (Arcoverde, Pernambuco, Brazil)'),
    ('BR-ADO', 'BR-ADO (Areado, Minas Gerais, Brazil)'),
    ('BR-ARL', 'BR-ARL (Areal, Rio de Janeiro, Brazil)'),
    ('BR-AEI', 'BR-AEI (Areia, Paraíba, Brazil)'),
    ('BR-ARE', 'BR-ARE (Areia Branca, Rio Grande do Norte, Brazil)'),
    ('BR-APE', 'BR-APE (Arembepe, Bahia, Brazil)'),
    ('BR-APL', 'BR-APL (Arenapolis, Mato Grosso, Brazil)'),
    ('BR-AIR', 'BR-AIR (Aripuana, Mato Grosso, Brazil)'),
    ('BR-AQM', 'BR-AQM (Ariquemes, Rondônia, Brazil)'),
    ('BR-ARH', 'BR-ARH (Ariranha, São Paulo, Brazil)'),
    ('BR-ABZ', 'BR-ABZ (Armação dos Búzios, Rio de Janeiro, Brazil)'),
    ('BR-ADJ', 'BR-ADJ (Arraial, Bahia, Brazil)'),
    ('BR-ACB', 'BR-ACB (Arraial do Cabo, Rio de Janeiro, Brazil)'),
    ('BR-AAI', 'BR-AAI (Arraias, Tocantins, Brazil)'),
    ('BR-AMI', 'BR-AMI (Arroio do Meio, Rio Grande do Sul, Brazil)'),
    ('BR-ANG', 'BR-ANG (Artur Nogueira, São Paulo, Brazil)'),
    ('BR-AUN', 'BR-AUN (Aruana, Goiás, Brazil)'),
    ('BR-AUJ', 'BR-AUJ (Aruja, São Paulo, Brazil)'),
    ('BR-AES', 'BR-AES (Arês, Rio Grande do Norte, Brazil)'),
    ('BR-ASC', 'BR-ASC (Ascurra, Santa Catarina, Brazil)'),
    ('BR-ASI', 'BR-ASI (Assai, Paraná, Brazil)'),
    ('BR-AIF', 'BR-AIF (Assis, São Paulo, Brazil)'),
    ('BR-ACD', 'BR-ACD (Assis Chateaubriand, Paraná, Brazil)'),
    ('BR-ASU', 'BR-ASU (Assu, Rio Grande do Norte, Brazil)'),
    ('BR-ASG', 'BR-ASG (Astorga, Paraná, Brazil)'),
    ('BR-ATL', 'BR-ATL (Ataleia, Minas Gerais, Brazil)'),
    ('BR-ABA', 'BR-ABA (Atibaia, São Paulo, Brazil)'),
    ('BR-AVB', 'BR-AVB (Atílio Vivacqua, Espírito Santo, Brazil)'),
    ('BR-AFM', 'BR-AFM (Auriflama, São Paulo, Brazil)'),
    ('BR-AVA', 'BR-AVA (Avare, São Paulo, Brazil)'),
    ('BR-ACX', 'BR-ACX (Açu Pt/São João da Barra, Rio de Janeiro, Brazil)'),
    ('BR-AUC', 'BR-AUC (Açucena, Minas Gerais, Brazil)'),
    ('BR-BBA', 'BR-BBA (Bacabal, Maranhão, Brazil)'),
    ('BR-BPI', 'BR-BPI (Baependi, Minas Gerais, Brazil)'),
    ('BR-BGX', 'BR-BGX (Bagé, Rio Grande do Sul, Brazil)'),
    ('BR-BFO', 'BR-BFO (Baia Formosa, Rio Grande do Norte, Brazil)'),
    ('BR-BLB', 'BR-BLB (Balbinos, São Paulo, Brazil)'),
    ('BR-BAL', 'BR-BAL (Balneario Pinhal, Rio Grande do Sul, Brazil)'),
    ('BR-BCS', 'BR-BCS (Balneário Barra do Sul, Santa Catarina, Brazil)'),
    ('BR-BAC', 'BR-BAC (Balneário de Camboriú, Santa Catarina, Brazil)'),
    ('BR-BOR', 'BR-BOR (Balneário do Rincão, Santa Catarina, Brazil)'),
    ('BR-BSS', 'BR-BSS (Balsas, Maranhão, Brazil)'),
    ('BR-BNA', 'BR-BNA (Bananal, São Paulo, Brazil)'),
    ('BR-BND', 'BR-BND (Bandeirantes, Paraná, Brazil)'),
    ('BR-BCI', 'BR-BCI (Barao de Cocais, Minas Gerais, Brazil)'),
    ('BR-BCG', 'BR-BCG (Barao de Cotigipe, Rio Grande do Sul, Brazil)'),
    ('BR-BUN', 'BR-BUN (Barauna, Rio Grande do Norte, Brazil)'),
    ('BR-BCN', 'BR-BCN (Barbacena, Minas Gerais, Brazil)'),
    ('BR-BSA', 'BR-BSA (Barbosa, São Paulo, Brazil)'),
    ('BR-BCA', 'BR-BCA (Barcarena, Pará, Brazil)'),
    ('BR-BAZ', 'BR-BAZ (Barcelos, Amazonas, Brazil)'),
    ('BR-BIR', 'BR-BIR (Bariri, São Paulo, Brazil)'),
    ('BR-BQQ', 'BR-BQQ (Barra, Bahia, Brazil)'),
    ('BR-BBO', 'BR-BBO (Barra Bonita, São Paulo, Brazil)'),
    ('BR-BTO', 'BR-BTO (Barra de Santo Antonio, Alagoas, Brazil)'),
    ('BR-BSM', 'BR-BSM (Barra de Sao Miguel, Alagoas, Brazil)'),
    ('BR-BBG', 'BR-BBG (Barra do Bugres, Mato Grosso, Brazil)'),
    ('BR-BCH', 'BR-BCH (Barra do Chapéu, São Paulo, Brazil)'),
    ('BR-BDC', 'BR-BDC (Barra do Corda, Maranhão, Brazil)'),
    ('BR-BPG', 'BR-BPG (Barra do Garças, Mato Grosso, Brazil)'),
    ('BR-RCH', 'BR-RCH (Barra do Riacho Pt / Aracruz, Espírito Santo, Brazil)'),
    ('BR-BRO', 'BR-BRO (Barra do Ribeiro, Rio Grande do Sul, Brazil)'),
    ('BR-BAR', 'BR-BAR (Barra dos Coqueiros, Sergipe, Brazil)'),
    ('BR-BGA', 'BR-BGA (Barra Grande, Bahia, Brazil)'),
    ('BR-BVA', 'BR-BVA (Barra Velha, Santa Catarina, Brazil)'),
    ('BR-BRC', 'BR-BRC (Barracao, Paraná, Brazil)'),
    ('BR-BRA', 'BR-BRA (Barreiras, Bahia, Brazil)'),
    ('BR-BRB', 'BR-BRB (Barreirinhas, Maranhão, Brazil)'),
    ('BR-BRS', 'BR-BRS (Barreiros, Pernambuco, Brazil)'),
    ('BR-BAT', 'BR-BAT (Barretos, São Paulo, Brazil)'),
    ('BR-BRH', 'BR-BRH (Barrinha, São Paulo, Brazil)'),
    ('BR-BSO', 'BR-BSO (Barroso, Minas Gerais, Brazil)'),
    ('BR-BRI', 'BR-BRI (Barueri, São Paulo, Brazil)'),
    ('BR-BTF', 'BR-BTF (Barão do Triunfo, Rio Grande do Sul, Brazil)'),
    ('BR-BTS', 'BR-BTS (Bastos, São Paulo, Brazil)'),
    ('BR-BGU', 'BR-BGU (Bataguassu, Mato Grosso do Sul, Brazil)'),
    ('BR-BAP', 'BR-BAP (Bataiporã, Mato Grosso do Sul, Brazil)'),
    ('BR-BTA', 'BR-BTA (Batatais, São Paulo, Brazil)'),
    ('BR-BTU', 'BR-BTU (Baturite, Ceará, Brazil)'),
    ('BR-BAU', 'BR-BAU (Bauru, São Paulo, Brazil)'),
    ('BR-BAY', 'BR-BAY (Bayeux, Paraíba, Brazil)'),
    ('BR-BBI', 'BR-BBI (Beberibe, Ceará, Brazil)'),
    ('BR-BLO', 'BR-BLO (Beija-Flor, Minas Gerais, Brazil)'),
    ('BR-BVT', 'BR-BVT (Bela Vista, Mato Grosso do Sul, Brazil)'),
    ('BR-BVP', 'BR-BVP (Bela Vista do Paraiso, Paraná, Brazil)'),
    ('BR-BEL', 'BR-BEL (Belem, Pará, Brazil)'),
    ('BR-BRX', 'BR-BRX (Belford Roxo, Rio de Janeiro, Brazil)'),
    ('BR-BVM', 'BR-BVM (Belmonte, Acre, Brazil)'),
    ('BR-BHZ', 'BR-BHZ (Belo Horizonte, Minas Gerais, Brazil)'),
    ('BR-BJB', 'BR-BJB (Belo Jardim, Pernambuco, Brazil)'),
    ('BR-BEO', 'BR-BEO (Belo Oriente, Minas Gerais, Brazil)'),
    ('BR-BNV', 'BR-BNV (Benedito Novo, Santa Catarina, Brazil)'),
    ('BR-BVI', 'BR-BVI (Benevides, Pará, Brazil)'),
    ('BR-BAB', 'BR-BAB (Bento de Abreu, São Paulo, Brazil)'),
    ('BR-BGV', 'BR-BGV (Bento Gonçalves, Rio Grande do Sul, Brazil)'),
    ('BR-BCP', 'BR-BCP (Bernardino de Campos, São Paulo, Brazil)'),
    ('BR-BTG', 'BR-BTG (Bertioga, São Paulo, Brazil)'),
    ('BR-BTP', 'BR-BTP (Bertópolis, Minas Gerais, Brazil)'),
    ('BR-BTI', 'BR-BTI (Betim, Minas Gerais, Brazil)'),
    ('BR-BZE', 'BR-BZE (Bezerros, Pernambuco, Brazil)'),
    ('BR-BGC', 'BR-BGC (Biguacu, Santa Catarina, Brazil)'),
    ('BR-BLA', 'BR-BLA (Bilac, São Paulo, Brazil)'),
    ('BR-BBR', 'BR-BBR (Biritiba-Mirim, São Paulo, Brazil)'),
    ('BR-BIU', 'BR-BIU (Bituruna, Paraná, Brazil)'),
    ('BR-BNU', 'BR-BNU (Blumenau, Santa Catarina, Brazil)'),
    ('BR-BEE', 'BR-BEE (Boa Esperanca, Espírito Santo, Brazil)'),
    ('BR-BSE', 'BR-BSE (Boa Esperanca, Minas Gerais, Brazil)'),
    ('BR-BSU', 'BR-BSU (Boa Esperanca do Sul, São Paulo, Brazil)'),
    ('BR-BVG', 'BR-BVG (Boa Viagem, Pernambuco, Brazil)'),
    ('BR-BVB', 'BR-BVB (Boa Vista, Roraima, Brazil)'),
    ('BR-BVD', 'BR-BVD (Boa Vista do Burica, Rio Grande do Sul, Brazil)'),
    ('BR-BOA', 'BR-BOA (Boa Vista do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-BCR', 'BR-BCR (Boca do Acre Apt, Amazonas, Brazil)'),
    ('BR-BOC', 'BR-BOC (Bocaina, São Paulo, Brazil)'),
    ('BR-BOV', 'BR-BOV (Bocaiuva, Minas Gerais, Brazil)'),
    ('BR-BDS', 'BR-BDS (Bocaiúva do Sul, Paraná, Brazil)'),
    ('BR-BQA', 'BR-BQA (Bodoquena, Mato Grosso do Sul, Brazil)'),
    ('BR-BOF', 'BR-BOF (Bofete, São Paulo, Brazil)'),
    ('BR-BTV', 'BR-BTV (Boituva, São Paulo, Brazil)'),
    ('BR-BDP', 'BR-BDP (Bom Despacho, Minas Gerais, Brazil)'),
    ('BR-BJG', 'BR-BJG (Bom Jardim de Goias, Goiás, Brazil)'),
    ('BR-BJL', 'BR-BJL (Bom Jesus da Lapa, Bahia, Brazil)'),
    ('BR-BJS', 'BR-BJS (Bom Jesus de Goias, Goiás, Brazil)'),
    ('BR-BJI', 'BR-BJI (Bom Jesus de Itabapoana, Rio de Janeiro, Brazil)'),
    ('BR-BJO', 'BR-BJO (Bom Jesus dos Perdoes, São Paulo, Brazil)'),
    ('BR-BPP', 'BR-BPP (Bom Principio, Rio Grande do Sul, Brazil)'),
    ('BR-BRR', 'BR-BRR (Bom Retiro, Santa Catarina, Brazil)'),
    ('BR-BSC', 'BR-BSC (Bom Sucesso, Minas Gerais, Brazil)'),
    ('BR-BBS', 'BR-BBS (Bombinhas, Santa Catarina, Brazil)'),
    ('BR-BNO', 'BR-BNO (Bonito, Pernambuco, Brazil)'),
    ('BR-BON', 'BR-BON (Bonito, Bahia, Brazil)'),
    ('BR-BYO', 'BR-BYO (Bonito, Mato Grosso do Sul, Brazil)'),
    ('BR-BQR', 'BR-BQR (Boqueirão, Paraíba, Brazil)'),
    ('BR-BQU', 'BR-BQU (Boquim, Sergipe, Brazil)'),
    ('BR-BRE', 'BR-BRE (Boraceia, São Paulo, Brazil)'),
    ('BR-BOB', 'BR-BOB (Borba, Amazonas, Brazil)'),
    ('BR-BBM', 'BR-BBM (Borborema, São Paulo, Brazil)'),
    ('BR-BDM', 'BR-BDM (Borda da Mata, Minas Gerais, Brazil)'),
    ('BR-QCJ', 'BR-QCJ (Botucatu, São Paulo, Brazil)'),
    ('BR-BNT', 'BR-BNT (Braco do Norte, Santa Catarina, Brazil)'),
    ('BR-BNC', 'BR-BNC (Braganca, Pará, Brazil)'),
    ('BR-BJP', 'BR-BJP (Braganca Paulista, São Paulo, Brazil)'),
    ('BR-BMI', 'BR-BMI (Brasilandia de Minas, Minas Gerais, Brazil)'),
    ('BR-BRL', 'BR-BRL (Brasiléia, Acre, Brazil)'),
    ('BR-BRT', 'BR-BRT (Brasnorte, Mato Grosso, Brazil)'),
    ('BR-BSB', 'BR-BSB (Brasnorte, Mato Grosso, Brazil)'),
    ('BR-BRN', 'BR-BRN (Brauna, São Paulo, Brazil)'),
    ('BR-BTR', 'BR-BTR (Braço do Trombudo, Santa Catarina, Brazil)'),
    ('BR-BDZ', 'BR-BDZ (Brejo Do Cruz, Paraíba, Brazil)'),
    ('BR-BJD', 'BR-BJD (Brejolândia, Bahia, Brazil)'),
    ('BR-BBN', 'BR-BBN (Breu Branco, Pará, Brazil)'),
    ('BR-BVS', 'BR-BVS (Breves, Pará, Brazil)'),
    ('BR-BTN', 'BR-BTN (Britania, Goiás, Brazil)'),
    ('BR-BDW', 'BR-BDW (Brodowski, São Paulo, Brazil)'),
    ('BR-BOS', 'BR-BOS (Brotas, São Paulo, Brazil)'),
    ('BR-BHO', 'BR-BHO (Brumadinho, Minas Gerais, Brazil)'),
    ('BR-BMS', 'BR-BMS (Brumado, Bahia, Brazil)'),
    ('BR-QAB', 'BR-QAB (Brusque, Santa Catarina, Brazil)'),
    ('BR-BBD', 'BR-BBD (Bueno Brandao, Minas Gerais, Brazil)'),
    ('BR-BRM', 'BR-BRM (Buerarema, Bahia, Brazil)'),
    ('BR-BUR', 'BR-BUR (Buri, São Paulo, Brazil)'),
    ('BR-BTM', 'BR-BTM (Buritama, São Paulo, Brazil)'),
    ('BR-BUS', 'BR-BUS (Buritis, Rondônia, Brazil)'),
    ('BR-BUT', 'BR-BUT (Buritis, Minas Gerais, Brazil)'),
    ('BR-BTZ', 'BR-BTZ (Buritizeiro, Minas Gerais, Brazil)'),
    ('BR-BLS', 'BR-BLS (Bálsamo, São Paulo, Brazil)'),
    ('BR-CPA', 'BR-CPA (Caapora, Paraíba, Brazil)'),
    ('BR-CRP', 'BR-CRP (Caarapo, Mato Grosso do Sul, Brazil)'),
    ('BR-CCE', 'BR-CCE (Cabeceiras, Goiás, Brazil)'),
    ('BR-CAB', 'BR-CAB (Cabedelo, Paraíba, Brazil)'),
    ('BR-CDO', 'BR-CDO (Cabedelo Pt, Paraíba, Brazil)'),
    ('BR-CSA', 'BR-CSA (Cabo de Santo Agostinho, Pernambuco, Brazil)'),
    ('BR-CFO', 'BR-CFO (Cabo Frio, Rio de Janeiro, Brazil)'),
    ('BR-CRU', 'BR-CRU (Cabreuva, São Paulo, Brazil)'),
    ('BR-CFC', 'BR-CFC (Cacador, Santa Catarina, Brazil)'),
    ('BR-CSL', 'BR-CSL (Cacapava do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-CCQ', 'BR-CCQ (Cachoeira, Bahia, Brazil)'),
    ('BR-CPS', 'BR-CPS (Cachoeira Paulista, São Paulo, Brazil)'),
    ('BR-CDM', 'BR-CDM (Cachoeiras de Macacu, Rio de Janeiro, Brazil)'),
    ('BR-CDI', 'BR-CDI (Cachoeiro de Itapemirim, Espírito Santo, Brazil)'),
    ('BR-CCL', 'BR-CCL (Cacoal, Rondônia, Brazil)'),
    ('BR-CCO', 'BR-CCO (Caconde, São Paulo, Brazil)'),
    ('BR-CCU', 'BR-CCU (Cacu, Goiás, Brazil)'),
    ('BR-CTO', 'BR-CTO (Caetanopolis, Minas Gerais, Brazil)'),
    ('BR-CTE', 'BR-CTE (Caete, Minas Gerais, Brazil)'),
    ('BR-CTI', 'BR-CTI (Caetite, Bahia, Brazil)'),
    ('BR-CFL', 'BR-CFL (Cafelandia, São Paulo, Brazil)'),
    ('BR-CBI', 'BR-CBI (Caibi, Santa Catarina, Brazil)'),
    ('BR-CIC', 'BR-CIC (Caico, Rio Grande do Norte, Brazil)'),
    ('BR-CBA', 'BR-CBA (Caioba, Paraná, Brazil)'),
    ('BR-CIR', 'BR-CIR (Cairu, Bahia, Brazil)'),
    ('BR-CJM', 'BR-CJM (Cajamar, São Paulo, Brazil)'),
    ('BR-CJI', 'BR-CJI (Cajati, São Paulo, Brazil)'),
    ('BR-CZJ', 'BR-CZJ (Cajazeiras, Paraíba, Brazil)'),
    ('BR-CJO', 'BR-CJO (Cajobi, São Paulo, Brazil)'),
    ('BR-CJU', 'BR-CJU (Cajuru, São Paulo, Brazil)'),
    ('BR-CLA', 'BR-CLA (Caldas, Minas Gerais, Brazil)'),
    ('BR-CLV', 'BR-CLV (Caldas Novas, Goiás, Brazil)'),
    ('BR-CCA', 'BR-CCA (Camacan, Bahia, Brazil)'),
    ('BR-CMU', 'BR-CMU (Camanducaia, Minas Gerais, Brazil)'),
    ('BR-CAA', 'BR-CAA (Camapua, Mato Grosso do Sul, Brazil)'),
    ('BR-CQA', 'BR-CQA (Camaqua, Rio Grande do Sul, Brazil)'),
    ('BR-CME', 'BR-CME (Camaragibe, Pernambuco, Brazil)'),
    ('BR-CRG', 'BR-CRG (Camargo, Rio Grande do Sul, Brazil)'),
    ('BR-CCI', 'BR-CCI (Camaçari, Bahia, Brazil)'),
    ('BR-CBR', 'BR-CBR (Cambara, Paraná, Brazil)'),
    ('BR-CMS', 'BR-CMS (Cambara do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-CBE', 'BR-CBE (Cambe, Paraná, Brazil)'),
    ('BR-CBU', 'BR-CBU (Camboriú, Santa Catarina, Brazil)'),
    ('BR-CMB', 'BR-CMB (Cambuci, Rio de Janeiro, Brazil)'),
    ('BR-CMI', 'BR-CMI (Cambui, Minas Gerais, Brazil)'),
    ('BR-CBQ', 'BR-CBQ (Cambuquira, Minas Gerais, Brazil)'),
    ('BR-CMR', 'BR-CMR (Cametá Apt, Pará, Brazil)'),
    ('BR-CMC', 'BR-CMC (Camocim, Ceará, Brazil)'),
    ('BR-CPH', 'BR-CPH (Campanha, Minas Gerais, Brazil)'),
    ('BR-CAM', 'BR-CAM (Campina do Monte Alegre, São Paulo, Brazil)'),
    ('BR-CPV', 'BR-CPV (Campina Grande, Paraíba, Brazil)'),
    ('BR-CGL', 'BR-CGL (Campina Grande do Sul, Paraná, Brazil)'),
    ('BR-CVR', 'BR-CVR (Campina Verde, Minas Gerais, Brazil)'),
    ('BR-CPO', 'BR-CPO (Campinapolis, Mato Grosso, Brazil)'),
    ('BR-CPQ', 'BR-CPQ (Campinas, São Paulo, Brazil)'),
    ('BR-CAG', 'BR-CAG (Campo Alegre, Santa Catarina, Brazil)'),
    ('BR-CPB', 'BR-CPB (Campo Belo, Minas Gerais, Brazil)'),
    ('BR-QCD', 'BR-QCD (Campo Bom, Rio Grande do Sul, Brazil)'),
    ('BR-CFM', 'BR-CFM (Campo Formoso, Bahia, Brazil)'),
    ('BR-CGR', 'BR-CGR (Campo Grande, Mato Grosso do Sul, Brazil)'),
    ('BR-CLO', 'BR-CLO (Campo Largo, Paraná, Brazil)'),
    ('BR-CLP', 'BR-CLP (Campo Limpo Paulista, São Paulo, Brazil)'),
    ('BR-CPG', 'BR-CPG (Campo Magro, Paraná, Brazil)'),
    ('BR-COM', 'BR-COM (Campo Maior, Piauí, Brazil)'),
    ('BR-CBW', 'BR-CBW (Campo Mourao, Paraná, Brazil)'),
    ('BR-CNP', 'BR-CNP (Campo Novo do Parecis, Mato Grosso, Brazil)'),
    ('BR-CVE', 'BR-CVE (Campo Verde, Mato Grosso, Brazil)'),
    ('BR-CAW', 'BR-CAW (Campos, Rio de Janeiro, Brazil)'),
    ('BR-CBS', 'BR-CBS (Campos Belos, Goiás, Brazil)'),
    ('BR-CLJ', 'BR-CLJ (Campos de Júlio, Mato Grosso, Brazil)'),
    ('BR-QJO', 'BR-QJO (Campos do Jordao, São Paulo, Brazil)'),
    ('BR-CGZ', 'BR-CGZ (Campos dos Goytacazes, Rio de Janeiro, Brazil)'),
    ('BR-CNS', 'BR-CNS (Campos Novos, Santa Catarina, Brazil)'),
    ('BR-CVD', 'BR-CVD (Campos Verdes, Goiás, Brazil)'),
    ('BR-CTT', 'BR-CTT (Canabarro Teutonia, Rio Grande do Sul, Brazil)'),
    ('BR-CNI', 'BR-CNI (Cananeia, São Paulo, Brazil)'),
    ('BR-CNN', 'BR-CNN (Canarana, Mato Grosso, Brazil)'),
    ('BR-CNV', 'BR-CNV (Canavieiras, Bahia, Brazil)'),
    ('BR-CDC', 'BR-CDC (Canaã dos Carajás, Pará, Brazil)'),
    ('BR-CIS', 'BR-CIS (Candeias, Bahia, Brazil)'),
    ('BR-CDL', 'BR-CDL (Candelaria, Rio Grande do Sul, Brazil)'),
    ('BR-CMN', 'BR-CMN (Candido Mendes, Maranhão, Brazil)'),
    ('BR-CMT', 'BR-CMT (Candido Mota, São Paulo, Brazil)'),
    ('BR-CDU', 'BR-CDU (Candido Rodrigues, São Paulo, Brazil)'),
    ('BR-CDT', 'BR-CDT (Candiota, Rio Grande do Sul, Brazil)'),
    ('BR-QCN', 'BR-QCN (Canela, Rio Grande do Sul, Brazil)'),
    ('BR-CGC', 'BR-CGC (Canguçu, Rio Grande do Sul, Brazil)'),
    ('BR-CAD', 'BR-CAD (Caninde, Ceará, Brazil)'),
    ('BR-CFA', 'BR-CFA (Caninde do Sao Francisco, Sergipe, Brazil)'),
    ('BR-CNR', 'BR-CNR (Canitar, São Paulo, Brazil)'),
    ('BR-CQU', 'BR-CQU (Canoa Quebrada, Ceará, Brazil)'),
    ('BR-QNS', 'BR-QNS (Canoas, Rio Grande do Sul, Brazil)'),
    ('BR-CHS', 'BR-CHS (Canoinhas, Santa Catarina, Brazil)'),
    ('BR-CSC', 'BR-CSC (Cansancao, Bahia, Brazil)'),
    ('BR-CTG', 'BR-CTG (Cantagalo, Rio de Janeiro, Brazil)'),
    ('BR-CRR', 'BR-CRR (Canto do Buriti, Piauí, Brazil)'),
    ('BR-CPM', 'BR-CPM (Capanema, Pará, Brazil)'),
    ('BR-CBN', 'BR-CBN (Capao Bonito, São Paulo, Brazil)'),
    ('BR-CCN', 'BR-CCN (Capao da Canoa, Rio Grande do Sul, Brazil)'),
    ('BR-CPE', 'BR-CPE (Capao do Leao, Rio Grande do Sul, Brazil)'),
    ('BR-CPK', 'BR-CPK (Caparao, Minas Gerais, Brazil)'),
    ('BR-CLS', 'BR-CLS (Capela de Santana, Rio Grande do Sul, Brazil)'),
    ('BR-CLT', 'BR-CLT (Capela do Alto, São Paulo, Brazil)'),
    ('BR-CLH', 'BR-CLH (Capelinha, Minas Gerais, Brazil)'),
    ('BR-CPT', 'BR-CPT (Capetinga, Minas Gerais, Brazil)'),
    ('BR-CPP', 'BR-CPP (Capinopolis, Minas Gerais, Brazil)'),
    ('BR-CPZ', 'BR-CPZ (Capinzal, Santa Catarina, Brazil)'),
    ('BR-CPC', 'BR-CPC (Capitao Poco, Pará, Brazil)'),
    ('BR-CTL', 'BR-CTL (Capitolio, Minas Gerais, Brazil)'),
    ('BR-CAE', 'BR-CAE (Capitão Andrade, Minas Gerais, Brazil)'),
    ('BR-CPI', 'BR-CPI (Capivari, São Paulo, Brazil)'),
    ('BR-CBX', 'BR-CBX (Capivari de Baixo, Santa Catarina, Brazil)'),
    ('BR-CPX', 'BR-CPX (Capixaba, Acre, Brazil)'),
    ('BR-CXF', 'BR-CXF (Capixaba FPSO, Espírito Santo, Brazil)'),
    ('BR-CGA', 'BR-CGA (Caponga, Ceará, Brazil)'),
    ('BR-CAO', 'BR-CAO (Capão Alto, Santa Catarina, Brazil)'),
    ('BR-CGU', 'BR-CGU (Caraguatatuba, São Paulo, Brazil)'),
    ('BR-CRV', 'BR-CRV (Caraiva, Bahia, Brazil)'),
    ('BR-CKS', 'BR-CKS (Carajás Apt/Parauapebas, Pará, Brazil)'),
    ('BR-CRM', 'BR-CRM (Carambei, Paraná, Brazil)'),
    ('BR-CND', 'BR-CND (Carandai, Minas Gerais, Brazil)'),
    ('BR-CNG', 'BR-CNG (Carangola, Minas Gerais, Brazil)'),
    ('BR-CRB', 'BR-CRB (Carapebus, Rio de Janeiro, Brazil)'),
    ('BR-CIU', 'BR-CIU (Carapicuiba, São Paulo, Brazil)'),
    ('BR-CNE', 'BR-CNE (Carapina da Serra, Espírito Santo, Brazil)'),
    ('BR-CIG', 'BR-CIG (Caratinga, Minas Gerais, Brazil)'),
    ('BR-CAF', 'BR-CAF (Carauari, Amazonas, Brazil)'),
    ('BR-CRQ', 'BR-CRQ (Caravelas, Bahia, Brazil)'),
    ('BR-ZHO', 'BR-ZHO (Carazinho, Rio Grande do Sul, Brazil)'),
    ('BR-RAA', 'BR-RAA (Caraá, Rio Grande do Sul, Brazil)'),
    ('BR-CAN', 'BR-CAN (Carbonita, Minas Gerais, Brazil)'),
    ('BR-CMA', 'BR-CMA (Cardeal Mota, Minas Gerais, Brazil)'),
    ('BR-CDR', 'BR-CDR (Cardoso, São Paulo, Brazil)'),
    ('BR-CSM', 'BR-CSM (Cardoso Moreira, Rio de Janeiro, Brazil)'),
    ('BR-CEU', 'BR-CEU (Careacu, Minas Gerais, Brazil)'),
    ('BR-CII', 'BR-CII (Cariacica, Espírito Santo, Brazil)'),
    ('BR-CBB', 'BR-CBB (Carlos Barbosa, Rio Grande do Sul, Brazil)'),
    ('BR-CCG', 'BR-CCG (Carlos Chagas, Minas Gerais, Brazil)'),
    ('BR-CAL', 'BR-CAL (Carlópolis, Paraná, Brazil)'),
    ('BR-COP', 'BR-COP (Carmo do Paranaiba, Minas Gerais, Brazil)'),
    ('BR-CRD', 'BR-CRD (Carmo do Rio Claro, Minas Gerais, Brazil)'),
    ('BR-COV', 'BR-COV (Carmo do Rio Verde, Goiás, Brazil)'),
    ('BR-CIH', 'BR-CIH (Carneirinho, Minas Gerais, Brazil)'),
    ('BR-CLN', 'BR-CLN (Carolina, Maranhão, Brazil)'),
    ('BR-CIN', 'BR-CIN (Carpina, Pernambuco, Brazil)'),
    ('BR-CNC', 'BR-CNC (Carrancas, Minas Gerais, Brazil)'),
    ('BR-CAU', 'BR-CAU (Caruaru, Pernambuco, Brazil)'),
    ('BR-CTP', 'BR-CTP (Carutapera, Maranhão, Brazil)'),
    ('BR-CSN', 'BR-CSN (Casa Branca, São Paulo, Brazil)'),
    ('BR-CSG', 'BR-CSG (Casa Grande, Minas Gerais, Brazil)'),
    ('BR-CAV', 'BR-CAV (Casa Nova, Bahia, Brazil)'),
    ('BR-CAC', 'BR-CAC (Cascavel, Paraná, Brazil)'),
    ('BR-CCV', 'BR-CCV (Cascavel, Ceará, Brazil)'),
    ('BR-CSD', 'BR-CSD (Casimiro de Abreu, Rio de Janeiro, Brazil)'),
    ('BR-CAI', 'BR-CAI (Cassia, Minas Gerais, Brazil)'),
    ('BR-CSS', 'BR-CSS (Cassilândia, Mato Grosso do Sul, Brazil)'),
    ('BR-CAS', 'BR-CAS (Castanhal, Pará, Brazil)'),
    ('BR-CSE', 'BR-CSE (Castelandia, Goiás, Brazil)'),
    ('BR-CEO', 'BR-CEO (Castelo, Espírito Santo, Brazil)'),
    ('BR-CHO', 'BR-CHO (Castilho, São Paulo, Brazil)'),
    ('BR-CTR', 'BR-CTR (Castro, Paraná, Brazil)'),
    ('BR-CAH', 'BR-CAH (Castro Alves, Bahia, Brazil)'),
    ('BR-TLZ', 'BR-TLZ (Catalao, Goiás, Brazil)'),
    ('BR-CDV', 'BR-CDV (Catanduva, São Paulo, Brazil)'),
    ('BR-CTV', 'BR-CTV (Catanduvas, Santa Catarina, Brazil)'),
    ('BR-CCH', 'BR-CCH (Catole do Rocha, Paraíba, Brazil)'),
    ('BR-CUC', 'BR-CUC (Caucaia, Ceará, Brazil)'),
    ('BR-CXU', 'BR-CXU (Caxambu, Minas Gerais, Brazil)'),
    ('BR-CXS', 'BR-CXS (Caxias, Maranhão, Brazil)'),
    ('BR-CXJ', 'BR-CXJ (Caxias do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-CAP', 'BR-CAP (Caçapava, São Paulo, Brazil)'),
    ('BR-CEA', 'BR-CEA (Ceará-Mirim, Rio Grande do Norte, Brazil)'),
    ('BR-CED', 'BR-CED (Cedral, São Paulo, Brazil)'),
    ('BR-CTD', 'BR-CTD (Centenario do Sul, Paraná, Brazil)'),
    ('BR-CEL', 'BR-CEL (Centralina, Minas Gerais, Brazil)'),
    ('BR-CJS', 'BR-CJS (Cerejeiras, Rondônia, Brazil)'),
    ('BR-CES', 'BR-CES (Ceres, Goiás, Brazil)'),
    ('BR-CQR', 'BR-CQR (Cerqueira Cesar, São Paulo, Brazil)'),
    ('BR-CQO', 'BR-CQO (Cerquilho, São Paulo, Brazil)'),
    ('BR-CLG', 'BR-CLG (Cerro Largo, Rio Grande do Sul, Brazil)'),
    ('BR-CLE', 'BR-CLE (Cesario Lange, São Paulo, Brazil)'),
    ('BR-CZR', 'BR-CZR (Cezarina, Goiás, Brazil)'),
    ('BR-CGD', 'BR-CGD (Cha Grande, Pernambuco, Brazil)'),
    ('BR-CPD', 'BR-CPD (Chapada, Rio Grande do Sul, Brazil)'),
    ('BR-CGM', 'BR-CGM (Chapada dos Guimaraes, Mato Grosso, Brazil)'),
    ('BR-CPL', 'BR-CPL (Chapadao do Sul, Mato Grosso do Sul, Brazil)'),
    ('BR-CHA', 'BR-CHA (Chapecó, Santa Catarina, Brazil)'),
    ('BR-CHC', 'BR-CHC (Characas, Mato Grosso, Brazil)'),
    ('BR-CHQ', 'BR-CHQ (Charqueada, São Paulo, Brazil)'),
    ('BR-CQD', 'BR-CQD (Charqueadas, Rio Grande do Sul, Brazil)'),
    ('BR-CVA', 'BR-CVA (Chavantes, São Paulo, Brazil)'),
    ('BR-CUI', 'BR-CUI (Chui, Rio Grande do Sul, Brazil)'),
    ('BR-CHG', 'BR-CHG (Chã de Alegria, Pernambuco, Brazil)'),
    ('BR-CNO', 'BR-CNO (Cianorte, Paraná, Brazil)'),
    ('BR-ANF', 'BR-ANF (Cidade de Angra dos Reis FPSO, Rio de Janeiro, Brazil)'),
    ('BR-CDH', 'BR-CDH (Cidade Gaúcha, Paraná, Brazil)'),
    ('BR-COC', 'BR-COC (Cidade Ocidental, Goiás, Brazil)'),
    ('BR-CRI', 'BR-CRI (Cidreira, Rio Grande do Sul, Brazil)'),
    ('BR-CIO', 'BR-CIO (Cipo, Bahia, Brazil)'),
    ('BR-CIA', 'BR-CIA (Claudia, Mato Grosso, Brazil)'),
    ('BR-CLI', 'BR-CLI (Claudio, Minas Gerais, Brazil)'),
    ('BR-CTA', 'BR-CTA (Clementina, São Paulo, Brazil)'),
    ('BR-CVI', 'BR-CVI (Clevelandia, Paraná, Brazil)'),
    ('BR-CRC', 'BR-CRC (Coaraci, Bahia, Brazil)'),
    ('BR-CIZ', 'BR-CIZ (Coari, Amazonas, Brazil)'),
    ('BR-CLL', 'BR-CLL (Cocal do Sul, Santa Catarina, Brazil)'),
    ('BR-CDA', 'BR-CDA (Codajás, Amazonas, Brazil)'),
    ('BR-COO', 'BR-COO (Codo, Maranhão, Brazil)'),
    ('BR-CHN', 'BR-CHN (Coelho Neto, Maranhão, Brazil)'),
    ('BR-CTN', 'BR-CTN (Colatina, Espírito Santo, Brazil)'),
    ('BR-CGO', 'BR-CGO (Colegio, Rio de Janeiro, Brazil)'),
    ('BR-CLD', 'BR-CLD (Colider, Mato Grosso, Brazil)'),
    ('BR-CNA', 'BR-CNA (Colina, São Paulo, Brazil)'),
    ('BR-CTS', 'BR-CTS (Colinas de Tocantins, Tocantins, Brazil)'),
    ('BR-CLM', 'BR-CLM (Colmeia, Tocantins, Brazil)'),
    ('BR-CLZ', 'BR-CLZ (Colniza, Mato Grosso, Brazil)'),
    ('BR-CLB', 'BR-CLB (Colombia, São Paulo, Brazil)'),
    ('BR-COL', 'BR-COL (Colombo, Paraná, Brazil)'),
    ('BR-CRO', 'BR-CRO (Colorado, Paraná, Brazil)'),
    ('BR-CSW', 'BR-CSW (Colorado do Oeste, Rondônia, Brazil)'),
    ('BR-CMO', 'BR-CMO (Comodoro, Mato Grosso, Brazil)'),
    ('BR-CNB', 'BR-CNB (Conceicao da Barra, Espírito Santo, Brazil)'),
    ('BR-CGS', 'BR-CGS (Conceicao das Alagoas, Minas Gerais, Brazil)'),
    ('BR-CCC', 'BR-CCC (Conceicao de Castelo, Espírito Santo, Brazil)'),
    ('BR-CEC', 'BR-CEC (Conceicao do Coite, Bahia, Brazil)'),
    ('BR-CCB', 'BR-CCB (Conceicao do Ibitipoca, Minas Gerais, Brazil)'),
    ('BR-CMD', 'BR-CMD (Conceicao do Mato Dentro, Minas Gerais, Brazil)'),
    ('BR-CCR', 'BR-CCR (Conceicao dos Ouros, Minas Gerais, Brazil)'),
    ('BR-CJC', 'BR-CJC (Conceição de Jacuípe, Bahia, Brazil)'),
    ('BR-CDJ', 'BR-CDJ (Conceição do Araguaia, Pará, Brazil)'),
    ('BR-CDP', 'BR-CDP (Conceição do Pará, Minas Gerais, Brazil)'),
    ('BR-CHL', 'BR-CHL (Conchal, São Paulo, Brazil)'),
    ('BR-CCS', 'BR-CCS (Conchas, São Paulo, Brazil)'),
    ('BR-CCD', 'BR-CCD (Concórdia, Santa Catarina, Brazil)'),
    ('BR-CDE', 'BR-CDE (Conde, Paraíba, Brazil)'),
    ('BR-CNF', 'BR-CNF (Confins International, Minas Gerais, Brazil)'),
    ('BR-COG', 'BR-COG (Congonhas, Minas Gerais, Brazil)'),
    ('BR-CGH', 'BR-CGH (Congonhas Apt/São Paulo, São Paulo, Brazil)'),
    ('BR-CHP', 'BR-CHP (Conselheiro Pena, Minas Gerais, Brazil)'),
    ('BR-CVO', 'BR-CVO (Conservatoria, Rio de Janeiro, Brazil)'),
    ('BR-CGE', 'BR-CGE (Contagem, Minas Gerais, Brazil)'),
    ('BR-CON', 'BR-CON (Contenda, Paraná, Brazil)'),
    ('BR-CRE', 'BR-CRE (Cordeiro, Rio de Janeiro, Brazil)'),
    ('BR-CRS', 'BR-CRS (Cordeirópolis, São Paulo, Brazil)'),
    ('BR-CSO', 'BR-CSO (Cordisburgo, Minas Gerais, Brazil)'),
    ('BR-CRT', 'BR-CRT (Corinto, Minas Gerais, Brazil)'),
    ('BR-CKO', 'BR-CKO (Cornélio Procópio, Paraná, Brazil)'),
    ('BR-COI', 'BR-COI (Coroaci, Minas Gerais, Brazil)'),
    ('BR-CML', 'BR-CML (Coromandel, Minas Gerais, Brazil)'),
    ('BR-CDZ', 'BR-CDZ (Coronel Domingos Solares, Paraná, Brazil)'),
    ('BR-CFB', 'BR-CFB (Coronel Fabriciano, Minas Gerais, Brazil)'),
    ('BR-COF', 'BR-COF (Coronel Freitas, Santa Catarina, Brazil)'),
    ('BR-VIV', 'BR-VIV (Coronel Vivida, Paraná, Brazil)'),
    ('BR-CPJ', 'BR-CPJ (Correio Pinto, Santa Catarina, Brazil)'),
    ('BR-CNT', 'BR-CNT (Corrente, Piauí, Brazil)'),
    ('BR-COR', 'BR-COR (Correntina, Bahia, Brazil)'),
    ('BR-CMG', 'BR-CMG (Corumba, Mato Grosso do Sul, Brazil)'),
    ('BR-CGI', 'BR-CGI (Corumba de Goias, Goiás, Brazil)'),
    ('BR-CRA', 'BR-CRA (Corupa, Santa Catarina, Brazil)'),
    ('BR-CUP', 'BR-CUP (Coruripe, Alagoas, Brazil)'),
    ('BR-CSP', 'BR-CSP (Cosmopolis, São Paulo, Brazil)'),
    ('BR-CMM', 'BR-CMM (Cosmorama, São Paulo, Brazil)'),
    ('BR-CQS', 'BR-CQS (Costa Marques, Rondônia, Brazil)'),
    ('BR-CSR', 'BR-CSR (Costa Rica, Mato Grosso do Sul, Brazil)'),
    ('BR-CGP', 'BR-CGP (Cotegipe, Bahia, Brazil)'),
    ('BR-COA', 'BR-COA (Cotia, São Paulo, Brazil)'),
    ('BR-COT', 'BR-COT (Cotriguaçu, Mato Grosso, Brazil)'),
    ('BR-COX', 'BR-COX (Coxim, Mato Grosso do Sul, Brazil)'),
    ('BR-CTU', 'BR-CTU (Crateus, Ceará, Brazil)'),
    ('BR-CAT', 'BR-CAT (Crato, Ceará, Brazil)'),
    ('BR-CVH', 'BR-CVH (Cravinhos, São Paulo, Brazil)'),
    ('BR-CCM', 'BR-CCM (Criciúma, Santa Catarina, Brazil)'),
    ('BR-CUL', 'BR-CUL (Crissiumal, Rio Grande do Sul, Brazil)'),
    ('BR-CST', 'BR-CST (Cristalina, Goiás, Brazil)'),
    ('BR-CRX', 'BR-CRX (Crixas, Goiás, Brazil)'),
    ('BR-CZB', 'BR-CZB (Cruz Alta, Rio Grande do Sul, Brazil)'),
    ('BR-CZA', 'BR-CZA (Cruz das Almas, Bahia, Brazil)'),
    ('BR-CEB', 'BR-CEB (Cruz do Espírito Santo, Paraíba, Brazil)'),
    ('BR-CZI', 'BR-CZI (Cruzeiro, São Paulo, Brazil)'),
    ('BR-CZO', 'BR-CZO (Cruzeiro, São Paulo, Brazil)'),
    ('BR-CZS', 'BR-CZS (Cruzeiro do Sul, Acre, Brazil)'),
    ('BR-CRZ', 'BR-CRZ (Cruzilia, Minas Gerais, Brazil)'),
    ('BR-CUO', 'BR-CUO (Cubatao, São Paulo, Brazil)'),
    ('BR-CGB', 'BR-CGB (Cuiabá, Mato Grosso, Brazil)'),
    ('BR-CUH', 'BR-CUH (Cunha, São Paulo, Brazil)'),
    ('BR-CUA', 'BR-CUA (Curaçá, Bahia, Brazil)'),
    ('BR-CWB', 'BR-CWB (Curitiba, Paraná, Brazil)'),
    ('BR-CRN', 'BR-CRN (Curitibanos, Santa Catarina, Brazil)'),
    ('BR-CUV', 'BR-CUV (Curiúva, Paraná, Brazil)'),
    ('BR-CUR', 'BR-CUR (Curtibanos, Santa Catarina, Brazil)'),
    ('BR-CPU', 'BR-CPU (Cururupu, Maranhão, Brazil)'),
    ('BR-CVL', 'BR-CVL (Curvelo, Minas Gerais, Brazil)'),
    ('BR-CUS', 'BR-CUS (Custódia, Pernambuco, Brazil)'),
    ('BR-CCX', 'BR-CCX (Cáceres, Mato Grosso, Brazil)'),
    ('BR-DMA', 'BR-DMA (Delfim Moreira, Minas Gerais, Brazil)'),
    ('BR-DPO', 'BR-DPO (Delfinopolis, Minas Gerais, Brazil)'),
    ('BR-DGU', 'BR-DGU (Delmiro Gouveia, Alagoas, Brazil)'),
    ('BR-DEL', 'BR-DEL (Delta, Minas Gerais, Brazil)'),
    ('BR-DCO', 'BR-DCO (Descalvado, São Paulo, Brazil)'),
    ('BR-DID', 'BR-DID (Diadema, São Paulo, Brazil)'),
    ('BR-DTA', 'BR-DTA (Diamantina, Minas Gerais, Brazil)'),
    ('BR-DMT', 'BR-DMT (Diamantino, Mato Grosso, Brazil)'),
    ('BR-DNO', 'BR-DNO (Dianópolis, Tocantins, Brazil)'),
    ('BR-DIA', "BR-DIA (Dias d'Ávila, Bahia, Brazil)"),
    ('BR-DCA', 'BR-DCA (Dionisio Cerqueira, Santa Catarina, Brazil)'),
    ('BR-DRS', 'BR-DRS (Dirce Reis, São Paulo, Brazil)'),
    ('BR-DIN', 'BR-DIN (Divino, Minas Gerais, Brazil)'),
    ('BR-DLJ', 'BR-DLJ (Divino das Laranjeiras, Minas Gerais, Brazil)'),
    ('BR-DVD', 'BR-DVD (Divinolandia, São Paulo, Brazil)'),
    ('BR-DIV', 'BR-DIV (Divinópolis, Minas Gerais, Brazil)'),
    ('BR-DIS', 'BR-DIS (Dois Irmaos, Rio Grande do Sul, Brazil)'),
    ('BR-DVS', 'BR-DVS (Dois Vizinhos, Paraná, Brazil)'),
    ('BR-DCP', 'BR-DCP (Dolcinopolis, São Paulo, Brazil)'),
    ('BR-DEU', 'BR-DEU (Dom Eliseu, Pará, Brazil)'),
    ('BR-DMS', 'BR-DMS (Domingos Martins, Espírito Santo, Brazil)'),
    ('BR-DMM', 'BR-DMM (Dona Emma, Santa Catarina, Brazil)'),
    ('BR-DDC', 'BR-DDC (Dores de Campo, Minas Gerais, Brazil)'),
    ('BR-DDI', 'BR-DDI (Dores do Indaia, Minas Gerais, Brazil)'),
    ('BR-DUO', 'BR-DUO (Dourado, São Paulo, Brazil)'),
    ('BR-DOU', 'BR-DOU (Dourados, Mato Grosso do Sul, Brazil)'),
    ('BR-DMC', 'BR-DMC (Doutor Mauricio Cardoso, Rio Grande do Sul, Brazil)'),
    ('BR-DTI', 'BR-DTI (Duartina, São Paulo, Brazil)'),
    ('BR-DCS', 'BR-DCS (Duque de Caxias, Rio de Janeiro, Brazil)'),
    ('BR-ECP', 'BR-ECP (Ecoporanga, Espírito Santo, Brazil)'),
    ('BR-ERN', 'BR-ERN (Eirunepé, Amazonas, Brazil)'),
    ('BR-ELO', 'BR-ELO (Eldorado, São Paulo, Brazil)'),
    ('BR-ERA', 'BR-ERA (Eldorado, Mato Grosso do Sul, Brazil)'),
    ('BR-EDS', 'BR-EDS (Eldorado do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-EFU', 'BR-EFU (Elias Fausto, São Paulo, Brazil)'),
    ('BR-ELM', 'BR-ELM (Elói Mendes, Minas Gerais, Brazil)'),
    ('BR-EUB', 'BR-EUB (Embauba, São Paulo, Brazil)'),
    ('BR-EDA', 'BR-EDA (Embu das Artes, São Paulo, Brazil)'),
    ('BR-EGU', 'BR-EGU (Embu-Guacu, São Paulo, Brazil)'),
    ('BR-ECO', 'BR-ECO (Encantado, Rio Grande do Sul, Brazil)'),
    ('BR-ECS', 'BR-ECS (Encruzilhada do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-EBR', 'BR-EBR (Engenheiro Beltrao, Paraná, Brazil)'),
    ('BR-ECH', 'BR-ECH (Engenheiro Coelho, São Paulo, Brazil)'),
    ('BR-EPA', 'BR-EPA (Engenheiro Passos, Rio de Janeiro, Brazil)'),
    ('BR-EPF', 'BR-EPF (Engenheiro Paulo de Frontin, Rio de Janeiro, Brazil)'),
    ('BR-ERS', 'BR-ERS (Entre Rios, Bahia, Brazil)'),
    ('BR-EPI', 'BR-EPI (Epitaciolândia, Acre, Brazil)'),
    ('BR-ERM', 'BR-ERM (Erechim, Rio Grande do Sul, Brazil)'),
    ('BR-ERT', 'BR-ERT (Ernestina, Rio Grande do Sul, Brazil)'),
    ('BR-ESD', 'BR-ESD (Escada, Pernambuco, Brazil)'),
    ('BR-EMA', 'BR-EMA (Esmeraldas, Minas Gerais, Brazil)'),
    ('BR-ESZ', 'BR-ESZ (Espera Feliz, Minas Gerais, Brazil)'),
    ('BR-ETI', 'BR-ETI (Esperantina, Piauí, Brazil)'),
    ('BR-EOT', 'BR-EOT (Espigao do Oeste, Rondônia, Brazil)'),
    ('BR-ESI', 'BR-ESI (Espinosa, Minas Gerais, Brazil)'),
    ('BR-EPU', 'BR-EPU (Espumoso, Rio Grande do Sul, Brazil)'),
    ('BR-ESF', 'BR-ESF (Espírito Santo FPSO, Espírito Santo, Brazil)'),
    ('BR-EVH', 'BR-EVH (Estancia Velha, Rio Grande do Sul, Brazil)'),
    ('BR-ETO', 'BR-ETO (Esteio, Rio Grande do Sul, Brazil)'),
    ('BR-EGI', 'BR-EGI (Estiva Gerbi, São Paulo, Brazil)'),
    ('BR-ETR', 'BR-ETR (Estreito, Maranhão, Brazil)'),
    ('BR-ETA', 'BR-ETA (Estrela, Rio Grande do Sul, Brazil)'),
    ('BR-EDI', 'BR-EDI (Estrela do Indaia, Minas Gerais, Brazil)'),
    ('BR-EOS', 'BR-EOS (Estrela do Oeste, São Paulo, Brazil)'),
    ('BR-ESA', 'BR-ESA (Estrema, Acre, Brazil)'),
    ('BR-EST', 'BR-EST (Estância, Sergipe, Brazil)'),
    ('BR-ECU', 'BR-ECU (Euclides da Cunha, Bahia, Brazil)'),
    ('BR-EDM', 'BR-EDM (Eugenio de Melo, São Paulo, Brazil)'),
    ('BR-EPO', 'BR-EPO (Eunapolis, Bahia, Brazil)'),
    ('BR-ESO', 'BR-ESO (Eusébio, Ceará, Brazil)'),
    ('BR-EXA', 'BR-EXA (Extrema, Minas Gerais, Brazil)'),
    ('BR-EXZ', 'BR-EXZ (Extremoz, Rio Grande do Norte, Brazil)'),
    ('BR-FPA', 'BR-FPA (Farroupilha, Rio Grande do Sul, Brazil)'),
    ('BR-FTU', 'BR-FTU (Fartura, São Paulo, Brazil)'),
    ('BR-FSU', 'BR-FSU (Fatima do Sul, Mato Grosso do Sul, Brazil)'),
    ('BR-FNA', 'BR-FNA (Fazenda Nova, Pernambuco, Brazil)'),
    ('BR-FRG', 'BR-FRG (Fazenda Rio Grande, Paraná, Brazil)'),
    ('BR-FEJ', 'BR-FEJ (Feijo, Acre, Brazil)'),
    ('BR-FEC', 'BR-FEC (Feira de Santana, Bahia, Brazil)'),
    ('BR-FND', 'BR-FND (Felixlandia, Minas Gerais, Brazil)'),
    ('BR-FEN', 'BR-FEN (Fernando de Noronha, Pernambuco, Brazil)'),
    ('BR-FPE', 'BR-FPE (Fernando Prestes, São Paulo, Brazil)'),
    ('BR-FPO', 'BR-FPO (Fernandopolis, São Paulo, Brazil)'),
    ('BR-FVA', 'BR-FVA (Ferraz de Vasconcelos, São Paulo, Brazil)'),
    ('BR-FGU', 'BR-FGU (Figueira, Paraná, Brazil)'),
    ('BR-FLO', 'BR-FLO (Florai, Paraná, Brazil)'),
    ('BR-FCU', 'BR-FCU (Flores da Cunha, Rio Grande do Sul, Brazil)'),
    ('BR-FSA', 'BR-FSA (Florestal, Minas Gerais, Brazil)'),
    ('BR-FLP', 'BR-FLP (Florestopolis, Paraná, Brazil)'),
    ('BR-FLB', 'BR-FLB (Floriano, Piauí, Brazil)'),
    ('BR-FLN', 'BR-FLN (Florianópolis, Santa Catarina, Brazil)'),
    ('BR-FPS', 'BR-FPS (Florida Paulista, São Paulo, Brazil)'),
    ('BR-FLU', 'BR-FLU (Fluminense FPSO, Rio de Janeiro, Brazil)'),
    ('BR-FMI', 'BR-FMI (Formiga, Minas Gerais, Brazil)'),
    ('BR-FMO', 'BR-FMO (Formosa, Goiás, Brazil)'),
    ('BR-FAG', 'BR-FAG (Formoso do Araguaia, Tocantins, Brazil)'),
    ('BR-FNO', 'BR-FNO (Forno Pt/Arraial do Cabo, Rio de Janeiro, Brazil)'),
    ('BR-FOQ', 'BR-FOQ (Forquilha, Ceará, Brazil)'),
    ('BR-FOA', 'BR-FOA (Forquilhinha, Santa Catarina, Brazil)'),
    ('BR-FOR', 'BR-FOR (Fortaleza, Ceará, Brazil)'),
    ('BR-FMS', 'BR-FMS (Fortaleza de Minas, Minas Gerais, Brazil)'),
    ('BR-FTM', 'BR-FTM (Fortim, Ceará, Brazil)'),
    ('BR-IGU', 'BR-IGU (Foz do Iguaçu, Paraná, Brazil)'),
    ('BR-FGO', 'BR-FGO (Fraiburgo, Santa Catarina, Brazil)'),
    ('BR-FRC', 'BR-FRC (Franca, São Paulo, Brazil)'),
    ('BR-FBE', 'BR-FBE (Francisco Beltrao, Paraná, Brazil)'),
    ('BR-FTO', 'BR-FTO (Francisco Morato, São Paulo, Brazil)'),
    ('BR-FRO', 'BR-FRO (Franco da Rocha, São Paulo, Brazil)'),
    ('BR-FWP', 'BR-FWP (Frederico Westphalen, Rio Grande do Sul, Brazil)'),
    ('BR-FRU', 'BR-FRU (Frutal, Minas Gerais, Brazil)'),
    ('BR-FDA', 'BR-FDA (Fundao, Espírito Santo, Brazil)'),
    ('BR-GIG', 'BR-GIG (Galeão Apt/Rio de Janeiro, Rio de Janeiro, Brazil)'),
    ('BR-GLA', 'BR-GLA (Galia, São Paulo, Brazil)'),
    ('BR-GLE', 'BR-GLE (Gameleira, Pernambuco, Brazil)'),
    ('BR-GDU', 'BR-GDU (Gandu, Bahia, Brazil)'),
    ('BR-GHU', 'BR-GHU (Garanhuns, Pernambuco, Brazil)'),
    ('BR-GCA', 'BR-GCA (Garca, São Paulo, Brazil)'),
    ('BR-GBI', 'BR-GBI (Garibaldi, Rio Grande do Sul, Brazil)'),
    ('BR-GPA', 'BR-GPA (Garopaba, Santa Catarina, Brazil)'),
    ('BR-GSA', 'BR-GSA (Gaspar, Santa Catarina, Brazil)'),
    ('BR-GAU', 'BR-GAU (Gaucha, Mato Grosso, Brazil)'),
    ('BR-GPX', 'BR-GPX (Gavião Peixoto, São Paulo, Brazil)'),
    ('BR-GEC', 'BR-GEC (General Carneiro, Paraná, Brazil)'),
    ('BR-GLC', 'BR-GLC (General Carneiro, Mato Grosso, Brazil)'),
    ('BR-GSO', 'BR-GSO (General Salgado, São Paulo, Brazil)'),
    ('BR-GPU', 'BR-GPU (Genipabu, Rio Grande do Norte, Brazil)'),
    ('BR-GTU', 'BR-GTU (Getulina, São Paulo, Brazil)'),
    ('BR-GVA', 'BR-GVA (Getulio Vargas, Rio Grande do Sul, Brazil)'),
    ('BR-GRA', 'BR-GRA (Girua, Rio Grande do Sul, Brazil)'),
    ('BR-GDO', 'BR-GDO (Gloria de Dourados, Mato Grosso do Sul, Brazil)'),
    ('BR-GHA', 'BR-GHA (Glorinha, Rio Grande do Sul, Brazil)'),
    ('BR-GDG', 'BR-GDG (Glória do Goitá, Pernambuco, Brazil)'),
    ('BR-GNA', 'BR-GNA (Goiana, Pernambuco, Brazil)'),
    ('BR-GPO', 'BR-GPO (Goianapolis, Goiás, Brazil)'),
    ('BR-GNI', 'BR-GNI (Goianesia, Goiás, Brazil)'),
    ('BR-GIS', 'BR-GIS (Goias, Goiás, Brazil)'),
    ('BR-GOE', 'BR-GOE (Goioere, Paraná, Brazil)'),
    ('BR-GYN', 'BR-GYN (Goiânia, Goiás, Brazil)'),
    ('BR-GCS', 'BR-GCS (Goncalves, Minas Gerais, Brazil)'),
    ('BR-GZG', 'BR-GZG (Gonzaga, Minas Gerais, Brazil)'),
    ('BR-GCR', 'BR-GCR (Governador Celso Ramos, Santa Catarina, Brazil)'),
    ('BR-GDX', 'BR-GDX (Governador Dix-Sept Rosado, Rio Grande do Norte, Brazil)'),
    ('BR-GDA', 'BR-GDA (Governador Lacerda de Aguiar, Espírito Santo, Brazil)'),
    ('BR-GVR', 'BR-GVR (Governador Valadares, Minas Gerais, Brazil)'),
    ('BR-GJA', 'BR-GJA (Grajau, Maranhão, Brazil)'),
    ('BR-QRP', 'BR-QRP (Gramado, Rio Grande do Sul, Brazil)'),
    ('BR-GPR', 'BR-GPR (Grao Para, Santa Catarina, Brazil)'),
    ('BR-GVT', 'BR-GVT (Gravata, Pernambuco, Brazil)'),
    ('BR-GVL', 'BR-GVL (Gravatal, Santa Catarina, Brazil)'),
    ('BR-GCV', 'BR-GCV (Gravataí, Rio Grande do Sul, Brazil)'),
    ('BR-GSS', 'BR-GSS (Grossos, Rio Grande do Norte, Brazil)'),
    ('BR-GOB', 'BR-GOB (Guabirotuba, Paraná, Brazil)'),
    ('BR-GUB', 'BR-GUB (Guabiruba, Santa Catarina, Brazil)'),
    ('BR-GCU', 'BR-GCU (Guacui, Espírito Santo, Brazil)'),
    ('BR-GDP', 'BR-GDP (Guadalupe, Piauí, Brazil)'),
    ('BR-GAB', 'BR-GAB (Guaimbe, São Paulo, Brazil)'),
    ('BR-GIR', 'BR-GIR (Guaira, São Paulo, Brazil)'),
    ('BR-QGA', 'BR-QGA (Guaira, Paraná, Brazil)'),
    ('BR-GJM', 'BR-GJM (Guajará-Mirim, Rondônia, Brazil)'),
    ('BR-GUA', 'BR-GUA (Guamaré, Rio Grande do Norte, Brazil)'),
    ('BR-GNM', 'BR-GNM (Guanambi, Bahia, Brazil)'),
    ('BR-GHE', 'BR-GHE (Guanhaes, Minas Gerais, Brazil)'),
    ('BR-GPE', 'BR-GPE (Guape, Minas Gerais, Brazil)'),
    ('BR-GPC', 'BR-GPC (Guapiacu, São Paulo, Brazil)'),
    ('BR-GPI', 'BR-GPI (Guapiara, São Paulo, Brazil)'),
    ('BR-GPM', 'BR-GPM (Guapimirim, Rio de Janeiro, Brazil)'),
    ('BR-GAP', 'BR-GAP (Guapo, Goiás, Brazil)'),
    ('BR-GUP', 'BR-GUP (Guapore, Rio Grande do Sul, Brazil)'),
    ('BR-GAR', 'BR-GAR (Guara, São Paulo, Brazil)'),
    ('BR-GBA', 'BR-GBA (Guarabira, Paraíba, Brazil)'),
    ('BR-GRI', 'BR-GRI (Guaracai, São Paulo, Brazil)'),
    ('BR-GAI', 'BR-GAI (Guaraci, São Paulo, Brazil)'),
    ('BR-GNO', 'BR-GNO (Guaraciaba do Norte, Ceará, Brazil)'),
    ('BR-GRQ', 'BR-GRQ (Guarai, Tocantins, Brazil)'),
    ('BR-GJU', 'BR-GJU (Guarajuba, Bahia, Brazil)'),
    ('BR-GRM', 'BR-GRM (Guaramirim, Santa Catarina, Brazil)'),
    ('BR-GDM', 'BR-GDM (Guarani das Missões, Rio Grande do Sul, Brazil)'),
    ('BR-GNR', 'BR-GNR (Guaranta do Norte, Mato Grosso, Brazil)'),
    ('BR-GAA', 'BR-GAA (Guaranésia, Minas Gerais, Brazil)'),
    ('BR-QDL', 'BR-QDL (Guarapari, Espírito Santo, Brazil)'),
    ('BR-GAV', 'BR-GAV (Guarapuava, Paraná, Brazil)'),
    ('BR-GQE', 'BR-GQE (Guaraquecaba, Paraná, Brazil)'),
    ('BR-GRE', 'BR-GRE (Guararapes, São Paulo, Brazil)'),
    ('BR-GAM', 'BR-GAM (Guararema, São Paulo, Brazil)'),
    ('BR-GTA', 'BR-GTA (Guaratinguetá, São Paulo, Brazil)'),
    ('BR-GTB', 'BR-GTB (Guaratuba, Paraná, Brazil)'),
    ('BR-GEM', 'BR-GEM (Guarda do Embau, Santa Catarina, Brazil)'),
    ('BR-GMO', 'BR-GMO (Guarda-Mor, Minas Gerais, Brazil)'),
    ('BR-GRB', 'BR-GRB (Guariba, São Paulo, Brazil)'),
    ('BR-GUJ', 'BR-GUJ (Guarujá, São Paulo, Brazil)'),
    ('BR-GDS', 'BR-GDS (Guarujá do Sul, Santa Catarina, Brazil)'),
    ('BR-QCV', 'BR-QCV (Guarulhos, São Paulo, Brazil)'),
    ('BR-GRU', 'BR-GRU (Guarulhos Apt/São Paulo, São Paulo, Brazil)'),
    ('BR-GUT', 'BR-GUT (Guatambu, Santa Catarina, Brazil)'),
    ('BR-GXP', 'BR-GXP (Guaxupé, Minas Gerais, Brazil)'),
    ('BR-GIB', 'BR-GIB (Guaíba, Rio Grande do Sul, Brazil)'),
    ('BR-GMS', 'BR-GMS (Guimaraes, Maranhão, Brazil)'),
    ('BR-GTI', 'BR-GTI (Guiratinga, Mato Grosso, Brazil)'),
    ('BR-GUR', 'BR-GUR (Gurupi, Tocantins, Brazil)'),
    ('BR-GZO', 'BR-GZO (Guzolandia, São Paulo, Brazil)'),
    ('BR-HLA', 'BR-HLA (Herculandia, São Paulo, Brazil)'),
    ('BR-HDT', 'BR-HDT (Herval D Oeste, Santa Catarina, Brazil)'),
    ('BR-HLI', 'BR-HLI (Hidrolandia, Goiás, Brazil)'),
    ('BR-HLR', 'BR-HLR (Holambra, São Paulo, Brazil)'),
    ('BR-HNS', 'BR-HNS (Honorio Serpa, Paraná, Brazil)'),
    ('BR-HZO', 'BR-HZO (Horizonte, Ceará, Brazil)'),
    ('BR-HRZ', 'BR-HRZ (Horizontina, Rio Grande do Sul, Brazil)'),
    ('BR-HTL', 'BR-HTL (Hortolândia, São Paulo, Brazil)'),
    ('BR-HMA', 'BR-HMA (Humaita, Amazonas, Brazil)'),
    ('BR-ICA', 'BR-ICA (Iaciara, Goiás, Brazil)'),
    ('BR-ICI', 'BR-ICI (Iacri, São Paulo, Brazil)'),
    ('BR-IAW', 'BR-IAW (Iapu, Minas Gerais, Brazil)'),
    ('BR-UCA', 'BR-UCA (Iaçu, Bahia, Brazil)'),
    ('BR-BIT', 'BR-BIT (Ibaiti, Paraná, Brazil)'),
    ('BR-IBC', 'BR-IBC (Ibate, São Paulo, Brazil)'),
    ('BR-IBI', 'BR-IBI (Ibati, Paraná, Brazil)'),
    ('BR-IBM', 'BR-IBM (Ibema, Paraná, Brazil)'),
    ('BR-BIA', 'BR-BIA (Ibia, Minas Gerais, Brazil)'),
    ('BR-IBX', 'BR-IBX (Ibiaçá, Rio Grande do Sul, Brazil)'),
    ('BR-IRI', 'BR-IRI (Ibicarai, Bahia, Brazil)'),
    ('BR-IMR', 'BR-IMR (Ibimirim, Pernambuco, Brazil)'),
    ('BR-IPA', 'BR-IPA (Ibipora, Paraná, Brazil)'),
    ('BR-IBR', 'BR-IBR (Ibira, São Paulo, Brazil)'),
    ('BR-ICU', 'BR-ICU (Ibiracu, Espírito Santo, Brazil)'),
    ('BR-IMA', 'BR-IMA (Ibirama, Santa Catarina, Brazil)'),
    ('BR-IRM', 'BR-IRM (Ibirarema, São Paulo, Brazil)'),
    ('BR-IRT', 'BR-IRT (Ibirite, Minas Gerais, Brazil)'),
    ('BR-IRU', 'BR-IRU (Ibiruba, Rio Grande do Sul, Brazil)'),
    ('BR-ING', 'BR-ING (Ibitinga, São Paulo, Brazil)'),
    ('BR-IVU', 'BR-IVU (Ibitiuva, São Paulo, Brazil)'),
    ('BR-IBU', 'BR-IBU (Ibiuna, São Paulo, Brazil)'),
    ('BR-IBO', 'BR-IBO (Ibo, Bahia, Brazil)'),
    ('BR-IBT', 'BR-IBT (Ibotirama, Bahia, Brazil)'),
    ('BR-ICP', 'BR-ICP (Icapuí, Ceará, Brazil)'),
    ('BR-ICR', 'BR-ICR (Icara, Santa Catarina, Brazil)'),
    ('BR-IMI', 'BR-IMI (Icaraima, Paraná, Brazil)'),
    ('BR-ICM', 'BR-ICM (Icem, São Paulo, Brazil)'),
    ('BR-ICN', 'BR-ICN (Iconha, Espírito Santo, Brazil)'),
    ('BR-IEP', 'BR-IEP (Iepe, São Paulo, Brazil)'),
    ('BR-IRP', 'BR-IRP (Igarapava, São Paulo, Brazil)'),
    ('BR-IGB', 'BR-IGB (Igarape, Minas Gerais, Brazil)'),
    ('BR-IAC', 'BR-IAC (Igarape-Acu, Pará, Brazil)'),
    ('BR-IGA', 'BR-IGA (Igarassu, Pernambuco, Brazil)'),
    ('BR-IGT', 'BR-IGT (Igaratinga, Minas Gerais, Brazil)'),
    ('BR-IGJ', 'BR-IGJ (Igrejinha, Rio Grande do Sul, Brazil)'),
    ('BR-ICG', 'BR-ICG (Iguacu, Paraná, Brazil)'),
    ('BR-IGP', 'BR-IGP (Iguape, São Paulo, Brazil)'),
    ('BR-IGV', 'BR-IGV (Iguarapava, São Paulo, Brazil)'),
    ('BR-ITM', 'BR-ITM (Iguatama, Minas Gerais, Brazil)'),
    ('BR-IGM', 'BR-IGM (Iguatemi, Mato Grosso do Sul, Brazil)'),
    ('BR-IJA', 'BR-IJA (Ijaci, Minas Gerais, Brazil)'),
    ('BR-IJU', 'BR-IJU (Ijuí, Rio Grande do Sul, Brazil)'),
    ('BR-ICO', 'BR-ICO (Ilha Comprida, São Paulo, Brazil)'),
    ('BR-IBP', 'BR-IBP (Ilha de Boipeba, Bahia, Brazil)'),
    ('BR-ICD', 'BR-ICD (Ilha de Comandatuba, Bahia, Brazil)'),
    ('BR-IDI', 'BR-IDI (Ilha de Itamaracá, Pernambuco, Brazil)'),
    ('BR-IMJ', 'BR-IMJ (Ilha de Marajo, Pará, Brazil)'),
    ('BR-ICS', 'BR-ICS (Ilha do Cardoso, São Paulo, Brazil)'),
    ('BR-IGO', 'BR-IGO (Ilha do Governador, Rio de Janeiro, Brazil)'),
    ('BR-IME', 'BR-IME (Ilha do Mel, Paraná, Brazil)'),
    ('BR-IPP', 'BR-IPP (Ilha do Papagaio, Santa Catarina, Brazil)'),
    ('BR-IGE', 'BR-IGE (Ilha Grande, Rio de Janeiro, Brazil)'),
    ('BR-ISA', 'BR-ISA (Ilha Solteira, São Paulo, Brazil)'),
    ('BR-IBE', 'BR-IBE (Ilhabela, São Paulo, Brazil)'),
    ('BR-IOS', 'BR-IOS (Ilheus, Bahia, Brazil)'),
    ('BR-ILH', 'BR-ILH (Ilhota, Santa Catarina, Brazil)'),
    ('BR-ISI', 'BR-ISI (Imbassai, Bahia, Brazil)'),
    ('BR-IMB', 'BR-IMB (Imbe, Rio Grande do Sul, Brazil)'),
    ('BR-IBB', 'BR-IBB (Imbituba, Santa Catarina, Brazil)'),
    ('BR-IBV', 'BR-IBV (Imbituva, Paraná, Brazil)'),
    ('BR-IGR', 'BR-IGR (Imigrante, Rio Grande do Sul, Brazil)'),
    ('BR-IMP', 'BR-IMP (Imperatriz, Maranhão, Brazil)'),
    ('BR-INJ', 'BR-INJ (Inajá, Pernambuco, Brazil)'),
    ('BR-IDA', 'BR-IDA (Indaial, Santa Catarina, Brazil)'),
    ('BR-IDU', 'BR-IDU (Indaiatuba, São Paulo, Brazil)'),
    ('BR-IDP', 'BR-IDP (Independencia, Rio Grande do Sul, Brazil)'),
    ('BR-INA', 'BR-INA (Indiana, São Paulo, Brazil)'),
    ('BR-IND', 'BR-IND (Indianópolis, Paraná, Brazil)'),
    ('BR-IHU', 'BR-IHU (Inhauma, Minas Gerais, Brazil)'),
    ('BR-IHS', 'BR-IHS (Inhumas, Goiás, Brazil)'),
    ('BR-ICE', 'BR-ICE (Inocencia, Mato Grosso do Sul, Brazil)'),
    ('BR-IOM', 'BR-IOM (Iomerê, Santa Catarina, Brazil)'),
    ('BR-YPB', 'BR-YPB (Ipaba, Minas Gerais, Brazil)'),
    ('BR-IPM', 'BR-IPM (Ipanema, Minas Gerais, Brazil)'),
    ('BR-IGC', 'BR-IGC (Ipanguacu, Rio Grande do Norte, Brazil)'),
    ('BR-IPN', 'BR-IPN (Ipatinga, Minas Gerais, Brazil)'),
    ('BR-IPQ', 'BR-IPQ (Iperó, São Paulo, Brazil)'),
    ('BR-IPE', 'BR-IPE (Ipeúna, São Paulo, Brazil)'),
    ('BR-IPU', 'BR-IPU (Ipiaú, Bahia, Brazil)'),
    ('BR-IPG', 'BR-IPG (Ipiranga, Amazonas, Brazil)'),
    ('BR-IXP', 'BR-IXP (Ipixuna do Pará, Pará, Brazil)'),
    ('BR-IPO', 'BR-IPO (Ipojuca, Pernambuco, Brazil)'),
    ('BR-IPR', 'BR-IPR (Ipora, Goiás, Brazil)'),
    ('BR-ORA', 'BR-ORA (Ipora, Paraná, Brazil)'),
    ('BR-IOT', 'BR-IOT (Ipora do Oeste, Santa Catarina, Brazil)'),
    ('BR-IRG', 'BR-IRG (Iporanga, São Paulo, Brazil)'),
    ('BR-PUA', 'BR-PUA (Ipua, São Paulo, Brazil)'),
    ('BR-IUA', 'BR-IUA (Ipuiúna, Minas Gerais, Brazil)'),
    ('BR-IPS', 'BR-IPS (Iracemapolis, São Paulo, Brazil)'),
    ('BR-RAI', 'BR-RAI (Irai, Rio Grande do Sul, Brazil)'),
    ('BR-IAA', 'BR-IAA (Iraja, Rio de Janeiro, Brazil)'),
    ('BR-INI', 'BR-INI (Irani, Santa Catarina, Brazil)'),
    ('BR-IRQ', 'BR-IRQ (Iraquara, Bahia, Brazil)'),
    ('BR-ATI', 'BR-ATI (Irati, Paraná, Brazil)'),
    ('BR-IRE', 'BR-IRE (Irecê, Bahia, Brazil)'),
    ('BR-IAM', 'BR-IAM (Iretama, Paraná, Brazil)'),
    ('BR-IRR', 'BR-IRR (Iriri, Espírito Santo, Brazil)'),
    ('BR-XTA', 'BR-XTA (Ita, Santa Catarina, Brazil)'),
    ('BR-INX', 'BR-INX (Itabaiana, Sergipe, Brazil)'),
    ('BR-ITN', 'BR-ITN (Itabaiana, Paraíba, Brazil)'),
    ('BR-IBN', 'BR-IBN (Itabatan, Bahia, Brazil)'),
    ('BR-IAB', 'BR-IAB (Itabera, São Paulo, Brazil)'),
    ('BR-IBA', 'BR-IBA (Itaberaba, Bahia, Brazil)'),
    ('BR-ITI', 'BR-ITI (Itabira, Minas Gerais, Brazil)'),
    ('BR-IRO', 'BR-IRO (Itabirito, Minas Gerais, Brazil)'),
    ('BR-IOI', 'BR-IOI (Itaborai, Rio de Janeiro, Brazil)'),
    ('BR-ITA', 'BR-ITA (Itabuna, Bahia, Brazil)'),
    ('BR-ITC', 'BR-ITC (Itacare, Bahia, Brazil)'),
    ('BR-IAR', 'BR-IAR (Itacoatiara, Amazonas, Brazil)'),
    ('BR-IRC', 'BR-IRC (Itacuruca, Rio de Janeiro, Brazil)'),
    ('BR-ITW', 'BR-ITW (Itagimirim, Bahia, Brazil)'),
    ('BR-IAG', 'BR-IAG (Itaguara, Minas Gerais, Brazil)'),
    ('BR-IDB', 'BR-IDB (Itaguaçu, Bahia, Brazil)'),
    ('BR-IGI', 'BR-IGI (Itaguaí, Rio de Janeiro, Brazil)'),
    ('BR-SPB', 'BR-SPB (Itaguaí Pt = Sepetiba Pt, Rio de Janeiro, Brazil)'),
    ('BR-IAI', 'BR-IAI (Itai, São Paulo, Brazil)'),
    ('BR-IIM', 'BR-IIM (Itaim, Minas Gerais, Brazil)'),
    ('BR-IPL', 'BR-IPL (Itaiopolis, Santa Catarina, Brazil)'),
    ('BR-ITV', 'BR-ITV (Itaipava, Rio de Janeiro, Brazil)'),
    ('BR-IPD', 'BR-IPD (Itaipulândia, Paraná, Brazil)'),
    ('BR-ITB', 'BR-ITB (Itaituba, Pará, Brazil)'),
    ('BR-ITJ', 'BR-ITJ (Itajai, Santa Catarina, Brazil)'),
    ('BR-IJT', 'BR-IJT (Itajibá, Bahia, Brazil)'),
    ('BR-IJB', 'BR-IJB (Itajobi, São Paulo, Brazil)'),
    ('BR-IAJ', 'BR-IAJ (Itajuba, Minas Gerais, Brazil)'),
    ('BR-IJP', 'BR-IJP (Itajuipe, Bahia, Brazil)'),
    ('BR-IMC', 'BR-IMC (Itamaraca, Pernambuco, Brazil)'),
    ('BR-IRJ', 'BR-IRJ (Itamaraju, Bahia, Brazil)'),
    ('BR-IMN', 'BR-IMN (Itamarati de Minas, Minas Gerais, Brazil)'),
    ('BR-IUR', 'BR-IUR (Itambacuri, Minas Gerais, Brazil)'),
    ('BR-IAE', 'BR-IAE (Itambe, Paraná, Brazil)'),
    ('BR-IPB', 'BR-IPB (Itambe de Pernambuco, Pernambuco, Brazil)'),
    ('BR-IMT', 'BR-IMT (Itamonte, Minas Gerais, Brazil)'),
    ('BR-ITH', 'BR-ITH (Itanhaem, São Paulo, Brazil)'),
    ('BR-IHA', 'BR-IHA (Itanhandu, Minas Gerais, Brazil)'),
    ('BR-IOC', 'BR-IOC (Itaocara, Rio de Janeiro, Brazil)'),
    ('BR-IPI', 'BR-IPI (Itapagipe, Minas Gerais, Brazil)'),
    ('BR-IIC', 'BR-IIC (Itaparica, Bahia, Brazil)'),
    ('BR-IEB', 'BR-IEB (Itapebi, Bahia, Brazil)'),
    ('BR-ICC', 'BR-ICC (Itapecerica, Minas Gerais, Brazil)'),
    ('BR-ISR', 'BR-ISR (Itapecerica da Serra, São Paulo, Brazil)'),
    ('BR-IMM', 'BR-IMM (Itapecuru-Mirim, Maranhão, Brazil)'),
    ('BR-IJW', "BR-IJW (Itapejara d'Oeste, Paraná, Brazil)"),
    ('BR-IEM', 'BR-IEM (Itapema, Santa Catarina, Brazil)'),
    ('BR-ITZ', 'BR-ITZ (Itapemirim, Espírito Santo, Brazil)'),
    ('BR-IYT', 'BR-IYT (Itaperucu, Paraná, Brazil)'),
    ('BR-ITP', 'BR-ITP (Itaperuna, Rio de Janeiro, Brazil)'),
    ('BR-ITG', 'BR-ITG (Itapetinga, Bahia, Brazil)'),
    ('BR-IIG', 'BR-IIG (Itapetininga, São Paulo, Brazil)'),
    ('BR-IAV', 'BR-IAV (Itapeva, São Paulo, Brazil)'),
    ('BR-IEV', 'BR-IEV (Itapevi, São Paulo, Brazil)'),
    ('BR-IIP', 'BR-IIP (Itapipoca, Ceará, Brazil)'),
    ('BR-TPI', 'BR-TPI (Itapira, São Paulo, Brazil)'),
    ('BR-IRN', 'BR-IRN (Itapiranga, Santa Catarina, Brazil)'),
    ('BR-ISM', 'BR-ISM (Itapissuma, Pernambuco, Brazil)'),
    ('BR-ILS', 'BR-ILS (Itapolis, São Paulo, Brazil)'),
    ('BR-IAO', 'BR-IAO (Itapora, Mato Grosso do Sul, Brazil)'),
    ('BR-IOG', 'BR-IOG (Itaporanga, São Paulo, Brazil)'),
    ('BR-IJJ', "BR-IJJ (Itaporanga d'Ajuda, Sergipe, Brazil)"),
    ('BR-IOA', 'BR-IOA (Itapoá, Santa Catarina, Brazil)'),
    ('BR-IUG', 'BR-IUG (Itapuranga, Goiás, Brazil)'),
    ('BR-IDW', 'BR-IDW (Itapuã do Oeste, Rondônia, Brazil)'),
    ('BR-IUI', 'BR-IUI (Itapuí, São Paulo, Brazil)'),
    ('BR-IQU', 'BR-IQU (Itaquaquecetuba, São Paulo, Brazil)'),
    ('BR-IQI', 'BR-IQI (Itaqui, Maranhão, Brazil)'),
    ('BR-ITQ', 'BR-ITQ (Itaqui, Rio Grande do Sul, Brazil)'),
    ('BR-IQR', 'BR-IQR (Itaquirai, Mato Grosso do Sul, Brazil)'),
    ('BR-TRA', 'BR-TRA (Itarare, São Paulo, Brazil)'),
    ('BR-IEA', 'BR-IEA (Itarema, Ceará, Brazil)'),
    ('BR-III', 'BR-III (Itariri, São Paulo, Brazil)'),
    ('BR-ITT', 'BR-ITT (Itatiaia, Rio de Janeiro, Brazil)'),
    ('BR-IAU', 'BR-IAU (Itatiaiuçu, Minas Gerais, Brazil)'),
    ('BR-IIA', 'BR-IIA (Itatiba, São Paulo, Brazil)'),
    ('BR-IAT', 'BR-IAT (Itatinga, São Paulo, Brazil)'),
    ('BR-IUM', 'BR-IUM (Itau de Minas, Minas Gerais, Brazil)'),
    ('BR-AUB', 'BR-AUB (Itauba, Mato Grosso, Brazil)'),
    ('BR-IAN', 'BR-IAN (Itauna, Minas Gerais, Brazil)'),
    ('BR-ISO', 'BR-ISO (Itauna Do Sul, Paraná, Brazil)'),
    ('BR-INU', 'BR-INU (Itaunas, Espírito Santo, Brazil)'),
    ('BR-IDM', 'BR-IDM (Itinga do Maranhão, Maranhão, Brazil)'),
    ('BR-IAP', 'BR-IAP (Itirapina, São Paulo, Brazil)'),
    ('BR-IOB', 'BR-IOB (Itobi, São Paulo, Brazil)'),
    ('BR-ITO', 'BR-ITO (Itororo, Bahia, Brazil)'),
    ('BR-ITU', 'BR-ITU (Itu, São Paulo, Brazil)'),
    ('BR-ITE', 'BR-ITE (Ituberá, Bahia, Brazil)'),
    ('BR-IUB', 'BR-IUB (Ituiutaba, Minas Gerais, Brazil)'),
    ('BR-ITR', 'BR-ITR (Itumbiara, Goiás, Brazil)'),
    ('BR-IPV', 'BR-IPV (Itupeva, São Paulo, Brazil)'),
    ('BR-ITD', 'BR-ITD (Ituporanga, Santa Catarina, Brazil)'),
    ('BR-IRA', 'BR-IRA (Iturama, Minas Gerais, Brazil)'),
    ('BR-IUT', 'BR-IUT (Itutinga, Minas Gerais, Brazil)'),
    ('BR-IVA', 'BR-IVA (Ituverava, São Paulo, Brazil)'),
    ('BR-IOR', 'BR-IOR (Ivaipora, Paraná, Brazil)'),
    ('BR-IVT', 'BR-IVT (Ivate, Paraná, Brazil)'),
    ('BR-IHM', 'BR-IHM (Ivinhema, Mato Grosso do Sul, Brazil)'),
    ('BR-IVO', 'BR-IVO (Ivoti, Rio Grande do Sul, Brazil)'),
    ('BR-IUN', 'BR-IUN (Iúna, Espírito Santo, Brazil)'),
    ('BR-JGS', 'BR-JGS (Jaboatão dos Guararapes, Pernambuco, Brazil)'),
    ('BR-JBC', 'BR-JBC (Jaboticabal, São Paulo, Brazil)'),
    ('BR-JCA', 'BR-JCA (Jacaraipe, Espírito Santo, Brazil)'),
    ('BR-JCR', 'BR-JCR (Jacareacanga, Pará, Brazil)'),
    ('BR-JCE', 'BR-JCE (Jacarei, São Paulo, Brazil)'),
    ('BR-JPU', 'BR-JPU (Jacarepagua, Rio de Janeiro, Brazil)'),
    ('BR-JCZ', 'BR-JCZ (Jaci, São Paulo, Brazil)'),
    ('BR-JCI', 'BR-JCI (Jaciara, Mato Grosso, Brazil)'),
    ('BR-JAC', 'BR-JAC (Jacinto, Minas Gerais, Brazil)'),
    ('BR-JCM', 'BR-JCM (Jacobina, Bahia, Brazil)'),
    ('BR-JCU', 'BR-JCU (Jacuma, Paraíba, Brazil)'),
    ('BR-JCD', 'BR-JCD (Jacunda, Pará, Brazil)'),
    ('BR-JPI', 'BR-JPI (Jacupiranga, São Paulo, Brazil)'),
    ('BR-JTU', 'BR-JTU (Jacutinga, Minas Gerais, Brazil)'),
    ('BR-JGA', 'BR-JGA (Jaguaquara, Bahia, Brazil)'),
    ('BR-JAG', 'BR-JAG (Jaguarao, Rio Grande do Sul, Brazil)'),
    ('BR-JRA', 'BR-JRA (Jaguarari, Bahia, Brazil)'),
    ('BR-JGR', 'BR-JGR (Jaguare, São Paulo, Brazil)'),
    ('BR-JRV', 'BR-JRV (Jaguariaíva, Paraná, Brazil)'),
    ('BR-JGQ', 'BR-JGQ (Jaguaripe, Bahia, Brazil)'),
    ('BR-JGN', 'BR-JGN (Jaguariuna, São Paulo, Brazil)'),
    ('BR-JAA', 'BR-JAA (Jaguaruana, Ceará, Brazil)'),
    ('BR-JGG', 'BR-JGG (Jaguaruna, Santa Catarina, Brazil)'),
    ('BR-JPO', 'BR-JPO (Jalapao, Tocantins, Brazil)'),
    ('BR-JLS', 'BR-JLS (Jales, São Paulo, Brazil)'),
    ('BR-JBE', 'BR-JBE (Jambeiro, São Paulo, Brazil)'),
    ('BR-JNU', 'BR-JNU (Janauba, Minas Gerais, Brazil)'),
    ('BR-JDA', 'BR-JDA (Jandaia, Goiás, Brazil)'),
    ('BR-JSU', 'BR-JSU (Jandaia do Sul, Paraná, Brazil)'),
    ('BR-JDR', 'BR-JDR (Jandaíra, Rio Grande do Norte, Brazil)'),
    ('BR-JDI', 'BR-JDI (Jandira, São Paulo, Brazil)'),
    ('BR-JGD', 'BR-JGD (Jangada, Mato Grosso, Brazil)'),
    ('BR-JNA', 'BR-JNA (Januária, Minas Gerais, Brazil)'),
    ('BR-JPG', 'BR-JPG (Jaracupiranga, São Paulo, Brazil)'),
    ('BR-JRU', 'BR-JRU (Jaragua, Goiás, Brazil)'),
    ('BR-JDM', 'BR-JDM (Jardim, Mato Grosso do Sul, Brazil)'),
    ('BR-JAE', 'BR-JAE (Jardim Alegre, Paraná, Brazil)'),
    ('BR-JPS', 'BR-JPS (Jardinopolis, São Paulo, Brazil)'),
    ('BR-JRI', 'BR-JRI (Jarinu, São Paulo, Brazil)'),
    ('BR-JAR', 'BR-JAR (Jaru, Rondônia, Brazil)'),
    ('BR-JTI', 'BR-JTI (Jatai, Goiás, Brazil)'),
    ('BR-JAU', 'BR-JAU (Jau, São Paulo, Brazil)'),
    ('BR-JBA', 'BR-JBA (Jaíba, Minas Gerais, Brazil)'),
    ('BR-JEC', 'BR-JEC (Jeceaba, Minas Gerais, Brazil)'),
    ('BR-JQA', 'BR-JQA (Jequitinhonha, Minas Gerais, Brazil)'),
    ('BR-JEQ', 'BR-JEQ (Jequié, Bahia, Brazil)'),
    ('BR-JCO', 'BR-JCO (Jericoacoara, Ceará, Brazil)'),
    ('BR-JES', 'BR-JES (Jesuítas, Paraná, Brazil)'),
    ('BR-JPR', 'BR-JPR (Ji-Paraná, Rondônia, Brazil)'),
    ('BR-JQI', 'BR-JQI (Jiquirica, Bahia, Brazil)'),
    ('BR-JOP', 'BR-JOP (Joanopolis, São Paulo, Brazil)'),
    ('BR-JMV', 'BR-JMV (Joao Monlevade, Minas Gerais, Brazil)'),
    ('BR-JNI', 'BR-JNI (Joao Neiva, Espírito Santo, Brazil)'),
    ('BR-JPA', 'BR-JPA (Joao Pessoa, Paraíba, Brazil)'),
    ('BR-JPH', 'BR-JPH (Joao Pinheiro, Minas Gerais, Brazil)'),
    ('BR-JTB', 'BR-JTB (Joaquim Távora, Paraná, Brazil)'),
    ('BR-JCB', 'BR-JCB (Joaçaba, Santa Catarina, Brazil)'),
    ('BR-JOI', 'BR-JOI (Joinville, Santa Catarina, Brazil)'),
    ('BR-JBF', 'BR-JBF (Jose Bonifacio, São Paulo, Brazil)'),
    ('BR-JBX', 'BR-JBX (José Boiteux, Santa Catarina, Brazil)'),
    ('BR-JUA', 'BR-JUA (Juara, Mato Grosso, Brazil)'),
    ('BR-JUT', 'BR-JUT (Juara, Mato Grosso, Brazil)'),
    ('BR-JZO', 'BR-JZO (Juazeiro, Bahia, Brazil)'),
    ('BR-JNE', 'BR-JNE (Juazeiro do Norte, Ceará, Brazil)'),
    ('BR-JZP', 'BR-JZP (Juazeiro-Pi, Piauí, Brazil)'),
    ('BR-JIA', 'BR-JIA (Juina, Mato Grosso, Brazil)'),
    ('BR-JDF', 'BR-JDF (Juiz de Fora, Minas Gerais, Brazil)'),
    ('BR-JCS', 'BR-JCS (Julio de Castilhos, Rio Grande do Sul, Brazil)'),
    ('BR-JSD', 'BR-JSD (Junco do Seridó, Paraíba, Brazil)'),
    ('BR-JUN', 'BR-JUN (Jundiaí, São Paulo, Brazil)'),
    ('BR-JRO', 'BR-JRO (Junqueiropolis, São Paulo, Brazil)'),
    ('BR-JQU', 'BR-JQU (Juquia, São Paulo, Brazil)'),
    ('BR-JQB', 'BR-JQB (Juquitiba, São Paulo, Brazil)'),
    ('BR-JBU', 'BR-JBU (Jurubatuba, São Paulo, Brazil)'),
    ('BR-JRN', 'BR-JRN (Juruena, Mato Grosso, Brazil)'),
    ('BR-JUR', 'BR-JUR (Juruti, Pará, Brazil)'),
    ('BR-JSA', 'BR-JSA (Jussara, Goiás, Brazil)'),
    ('BR-LFA', 'BR-LFA (Lafaete, Minas Gerais, Brazil)'),
    ('BR-LGO', 'BR-LGO (Lagarto, Sergipe, Brazil)'),
    ('BR-LAJ', 'BR-LAJ (Lages, Santa Catarina, Brazil)'),
    ('BR-LDJ', 'BR-LDJ (Lago do Junco, Maranhão, Brazil)'),
    ('BR-LCU', 'BR-LCU (Lagoa da Confusão, Tocantins, Brazil)'),
    ('BR-LPA', 'BR-LPA (Lagoa da Prata, Minas Gerais, Brazil)'),
    ('BR-LGP', 'BR-LGP (Lagoa Grande, Pernambuco, Brazil)'),
    ('BR-LSA', 'BR-LSA (Lagoa Santa, Goiás, Brazil)'),
    ('BR-LST', 'BR-LST (Lagoa Santa, Minas Gerais, Brazil)'),
    ('BR-LVE', 'BR-LVE (Lagoa Vermelha, Rio Grande do Sul, Brazil)'),
    ('BR-LNG', 'BR-LNG (Laguna, Santa Catarina, Brazil)'),
    ('BR-LJO', 'BR-LJO (Lajeado, Tocantins, Brazil)'),
    ('BR-QLB', 'BR-QLB (Lajeado, Rio Grande do Sul, Brazil)'),
    ('BR-LJE', 'BR-LJE (Lajes, Rio Grande do Norte, Brazil)'),
    ('BR-LBA', 'BR-LBA (Lambari, Minas Gerais, Brazil)'),
    ('BR-LAP', 'BR-LAP (Lapa, Paraná, Brazil)'),
    ('BR-LJI', 'BR-LJI (Laranjal do Jari, Amapá, Brazil)'),
    ('BR-LPU', 'BR-LPU (Laranjal Paulista, São Paulo, Brazil)'),
    ('BR-LJS', 'BR-LJS (Laranjeiras, Sergipe, Brazil)'),
    ('BR-LSU', 'BR-LSU (Laranjeiras do Sul, Paraná, Brazil)'),
    ('BR-LJR', 'BR-LJR (Laranjeiras Velha, Espírito Santo, Brazil)'),
    ('BR-LDF', 'BR-LDF (Lauro de Freitas, Bahia, Brazil)'),
    ('BR-LMU', 'BR-LMU (Lauro Muller, Santa Catarina, Brazil)'),
    ('BR-LAV', 'BR-LAV (Lavinia, São Paulo, Brazil)'),
    ('BR-LAR', 'BR-LAR (Lavras, Minas Gerais, Brazil)'),
    ('BR-LAS', 'BR-LAS (Lavras do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-LAW', 'BR-LAW (Lavras Novas, Minas Gerais, Brazil)'),
    ('BR-LAX', 'BR-LAX (Lavrinhas, São Paulo, Brazil)'),
    ('BR-LER', 'BR-LER (Lebon Regis, Santa Catarina, Brazil)'),
    ('BR-LEM', 'BR-LEM (Leme, São Paulo, Brazil)'),
    ('BR-LEN', 'BR-LEN (Lencois, Bahia, Brazil)'),
    ('BR-LEP', 'BR-LEP (Leopoldina, Minas Gerais, Brazil)'),
    ('BR-LMR', 'BR-LMR (Limeira, São Paulo, Brazil)'),
    ('BR-LIM', 'BR-LIM (Limoeiro, Pernambuco, Brazil)'),
    ('BR-LDN', 'BR-LDN (Limoeiro do Norte, Ceará, Brazil)'),
    ('BR-LIN', 'BR-LIN (Lindoia, São Paulo, Brazil)'),
    ('BR-LIC', 'BR-LIC (Lindolfo Collor, Rio Grande do Sul, Brazil)'),
    ('BR-LDS', 'BR-LDS (Lindóia do Sul, Santa Catarina, Brazil)'),
    ('BR-LRS', 'BR-LRS (Linhares, Espírito Santo, Brazil)'),
    ('BR-LIP', 'BR-LIP (Lins, São Paulo, Brazil)'),
    ('BR-LVB', 'BR-LVB (Livramento, Rio Grande do Sul, Brazil)'),
    ('BR-LNS', 'BR-LNS (Livramento de Nossa Senhora, Bahia, Brazil)'),
    ('BR-LBO', 'BR-LBO (Livramento do Brumado, Bahia, Brazil)'),
    ('BR-LOD', 'BR-LOD (Loanda, Paraná, Brazil)'),
    ('BR-LDB', 'BR-LDB (Londrina, Paraná, Brazil)'),
    ('BR-LOI', 'BR-LOI (Lontras, Santa Catarina, Brazil)'),
    ('BR-LRA', 'BR-LRA (Lorena, São Paulo, Brazil)'),
    ('BR-LOU', 'BR-LOU (Lourdes, São Paulo, Brazil)'),
    ('BR-LOZ', 'BR-LOZ (Lourdes, São Paulo, Brazil)'),
    ('BR-LRV', 'BR-LRV (Lucas do Rio Verde, Mato Grosso, Brazil)'),
    ('BR-LUC', 'BR-LUC (Lucelia, São Paulo, Brazil)'),
    ('BR-LUA', 'BR-LUA (Lucena, Paraíba, Brazil)'),
    ('BR-LAN', 'BR-LAN (Luis Antonio, São Paulo, Brazil)'),
    ('BR-LCI', 'BR-LCI (Luis Correia, Piauí, Brazil)'),
    ('BR-LDM', 'BR-LDM (Luis Eduardo Magalhaes, Bahia, Brazil)'),
    ('BR-LAL', 'BR-LAL (Luiz Alves, Santa Catarina, Brazil)'),
    ('BR-LZI', 'BR-LZI (Luiziania, São Paulo, Brazil)'),
    ('BR-LUM', 'BR-LUM (Luminárias, Minas Gerais, Brazil)'),
    ('BR-LUZ', 'BR-LUZ (Luz, Minas Gerais, Brazil)'),
    ('BR-LZB', 'BR-LZB (Luzerna, Santa Catarina, Brazil)'),
    ('BR-LZA', 'BR-LZA (Luziania, Goiás, Brazil)'),
    ('BR-LBR', 'BR-LBR (Lábrea, Amazonas, Brazil)'),
    ('BR-MAI', 'BR-MAI (Macaiba, Rio Grande do Norte, Brazil)'),
    ('BR-MCA', 'BR-MCA (Macapá, Amapá, Brazil)'),
    ('BR-MTU', 'BR-MTU (Macatuba, São Paulo, Brazil)'),
    ('BR-MCU', 'BR-MCU (Macau, Rio Grande do Norte, Brazil)'),
    ('BR-MEA', 'BR-MEA (Macaé, Rio de Janeiro, Brazil)'),
    ('BR-MCZ', 'BR-MCZ (Maceió, Alagoas, Brazil)'),
    ('BR-MDW', "BR-MDW (Machadinho d'Oeste, Rondônia, Brazil)"),
    ('BR-MRO', 'BR-MRO (Mae do Rio, Pará, Brazil)'),
    ('BR-MAG', 'BR-MAG (Mage, Rio de Janeiro, Brazil)'),
    ('BR-MQE', 'BR-MQE (Mairinque, São Paulo, Brazil)'),
    ('BR-MHA', 'BR-MHA (Malhador, Sergipe, Brazil)'),
    ('BR-MAL', 'BR-MAL (Mallet, Paraná, Brazil)'),
    ('BR-MPU', 'BR-MPU (Mamanguape, Paraíba, Brazil)'),
    ('BR-MPR', 'BR-MPR (Manacapuru, Amazonas, Brazil)'),
    ('BR-MAO', 'BR-MAO (Manaus, Amazonas, Brazil)'),
    ('BR-MGC', 'BR-MGC (Mandaguacu, Paraná, Brazil)'),
    ('BR-MDI', 'BR-MDI (Mandaguari, Paraná, Brazil)'),
    ('BR-MAA', 'BR-MAA (Mandirituba, Paraná, Brazil)'),
    ('BR-MNI', 'BR-MNI (Manduri, São Paulo, Brazil)'),
    ('BR-MGT', 'BR-MGT (Mangaratiba, Rio de Janeiro, Brazil)'),
    ('BR-MSE', 'BR-MSE (Mangue Seco, Bahia, Brazil)'),
    ('BR-MGH', 'BR-MGH (Mangueirinha, Paraná, Brazil)'),
    ('BR-MHU', 'BR-MHU (Manhuacu, Minas Gerais, Brazil)'),
    ('BR-MHI', 'BR-MHI (Manhumirim, Minas Gerais, Brazil)'),
    ('BR-MNX', 'BR-MNX (Manicoré, Amazonas, Brazil)'),
    ('BR-MNA', 'BR-MNA (Mantena, Minas Gerais, Brazil)'),
    ('BR-MQI', 'BR-MQI (Maquine, Rio Grande do Sul, Brazil)'),
    ('BR-MAB', 'BR-MAB (Marabá, Pará, Brazil)'),
    ('BR-MCI', 'BR-MCI (Maracai, São Paulo, Brazil)'),
    ('BR-MJU', 'BR-MJU (Maracaju, Mato Grosso do Sul, Brazil)'),
    ('BR-MRU', 'BR-MRU (Maracanaú, Ceará, Brazil)'),
    ('BR-MAK', 'BR-MAK (Maracas, Bahia, Brazil)'),
    ('BR-MGO', 'BR-MGO (Maragogi, Alagoas, Brazil)'),
    ('BR-MAR', 'BR-MAR (Maragogipe, Bahia, Brazil)'),
    ('BR-MGE', 'BR-MGE (Maranguape, Ceará, Brazil)'),
    ('BR-MKM', 'BR-MKM (Marapoama, São Paulo, Brazil)'),
    ('BR-MTZ', 'BR-MTZ (Marataizes, Espírito Santo, Brazil)'),
    ('BR-MAU', 'BR-MAU (Marau, Rio Grande do Sul, Brazil)'),
    ('BR-MVA', 'BR-MVA (Maravilha, Santa Catarina, Brazil)'),
    ('BR-MHS', 'BR-MHS (Maravilhas, Minas Gerais, Brazil)'),
    ('BR-MCL', 'BR-MCL (Marcelandia, Mato Grosso, Brazil)'),
    ('BR-MRA', 'BR-MRA (Marcelino Ramos, Rio Grande do Sul, Brazil)'),
    ('BR-MSC', 'BR-MSC (Marco, Ceará, Brazil)'),
    ('BR-MCN', 'BR-MCN (Marechal Cândido Rondon, Paraná, Brazil)'),
    ('BR-MDE', 'BR-MDE (Marechal Deodoro, Alagoas, Brazil)'),
    ('BR-MFO', 'BR-MFO (Marechal Floriano, Espírito Santo, Brazil)'),
    ('BR-MDF', 'BR-MDF (Maria da Fé, Minas Gerais, Brazil)'),
    ('BR-MFA', 'BR-MFA (Maria Farinha, Pernambuco, Brazil)'),
    ('BR-MAV', 'BR-MAV (Marialva, Paraná, Brazil)'),
    ('BR-MRI', 'BR-MRI (Mariana, Minas Gerais, Brazil)'),
    ('BR-MRC', 'BR-MRC (Marica, Rio de Janeiro, Brazil)'),
    ('BR-MRN', 'BR-MRN (Marilândia, Espírito Santo, Brazil)'),
    ('BR-MGF', 'BR-MGF (Maringá, Paraná, Brazil)'),
    ('BR-MTB', 'BR-MTB (Marituba, Alagoas, Brazil)'),
    ('BR-MCO', 'BR-MCO (Martinho Campos, Minas Gerais, Brazil)'),
    ('BR-MPO', 'BR-MPO (Martinopolis, São Paulo, Brazil)'),
    ('BR-MRM', 'BR-MRM (Maruim, Sergipe, Brazil)'),
    ('BR-MII', 'BR-MII (Marília, São Paulo, Brazil)'),
    ('BR-MSA', 'BR-MSA (Massaranduba, Santa Catarina, Brazil)'),
    ('BR-MTA', 'BR-MTA (Mata, Rio Grande do Sul, Brazil)'),
    ('BR-MSJ', 'BR-MSJ (Mata de Sao Joao, Bahia, Brazil)'),
    ('BR-MAT', 'BR-MAT (Matao, São Paulo, Brazil)'),
    ('BR-MLA', 'BR-MLA (Matelandia, Paraná, Brazil)'),
    ('BR-MTL', 'BR-MTL (Mateus Leme, Minas Gerais, Brazil)'),
    ('BR-MBA', 'BR-MBA (Matias Barbosa, Minas Gerais, Brazil)'),
    ('BR-MCD', 'BR-MCD (Matias Cardoso, Minas Gerais, Brazil)'),
    ('BR-MTO', 'BR-MTO (Matinhos, Paraná, Brazil)'),
    ('BR-MTP', 'BR-MTP (Matipó, Minas Gerais, Brazil)'),
    ('BR-MZS', 'BR-MZS (Matozinhos, Minas Gerais, Brazil)'),
    ('BR-MBK', 'BR-MBK (Matupa, Mato Grosso, Brazil)'),
    ('BR-MUT', 'BR-MUT (Matutina, Minas Gerais, Brazil)'),
    ('BR-MUA', 'BR-MUA (Maua, São Paulo, Brazil)'),
    ('BR-MSR', 'BR-MSR (Maua da Serra, Paraná, Brazil)'),
    ('BR-MBZ', 'BR-MBZ (Maués, Amazonas, Brazil)'),
    ('BR-MXA', 'BR-MXA (Maximiliano de Almeida, Rio Grande do Sul, Brazil)'),
    ('BR-MNO', 'BR-MNO (Medeiros Neto, Bahia, Brazil)'),
    ('BR-MDA', 'BR-MDA (Medianeira, Paraná, Brazil)'),
    ('BR-MDN', 'BR-MDN (Medina, Minas Gerais, Brazil)'),
    ('BR-MDS', 'BR-MDS (Mendes, Rio de Janeiro, Brazil)'),
    ('BR-MDC', 'BR-MDC (Mendonca, São Paulo, Brazil)'),
    ('BR-MQU', 'BR-MQU (Mesquita, Rio de Janeiro, Brazil)'),
    ('BR-MPE', 'BR-MPE (Miguel Pereira, Rio de Janeiro, Brazil)'),
    ('BR-MPI', 'BR-MPI (Miguelopolis, São Paulo, Brazil)'),
    ('BR-MMO', 'BR-MMO (Mimoso, Espírito Santo, Brazil)'),
    ('BR-MQH', 'BR-MQH (Minacu, Goiás, Brazil)'),
    ('BR-MDL', 'BR-MDL (Minas do Leão, Rio Grande do Sul, Brazil)'),
    ('BR-MNS', 'BR-MNS (Mineiros, Goiás, Brazil)'),
    ('BR-MCT', 'BR-MCT (Miracatu, São Paulo, Brazil)'),
    ('BR-MCM', 'BR-MCM (Miracema, Rio de Janeiro, Brazil)'),
    ('BR-MTN', 'BR-MTN (Miracema do Tocantins, Tocantins, Brazil)'),
    ('BR-MTS', 'BR-MTS (Miracema do Tocantins, Tocantins, Brazil)'),
    ('BR-MIU', 'BR-MIU (Miraguaí, Rio Grande do Sul, Brazil)'),
    ('BR-MIA', 'BR-MIA (Mirai, Minas Gerais, Brazil)'),
    ('BR-MRD', 'BR-MRD (Miranda, Mato Grosso do Sul, Brazil)'),
    ('BR-MDO', 'BR-MDO (Mirandopolis, São Paulo, Brazil)'),
    ('BR-MPM', 'BR-MPM (Mirante do Paranapanema, São Paulo, Brazil)'),
    ('BR-MIR', 'BR-MIR (Mirassol, São Paulo, Brazil)'),
    ('BR-MSO', 'BR-MSO (Mirassol do Oeste, Mato Grosso, Brazil)'),
    ('BR-MRR', 'BR-MRR (Mirim, Rio Grande do Sul, Brazil)'),
    ('BR-MOO', 'BR-MOO (Mococa, São Paulo, Brazil)'),
    ('BR-QMI', 'BR-QMI (Mogi das Cruzes, São Paulo, Brazil)'),
    ('BR-MGG', 'BR-MGG (Mogi Guacu, São Paulo, Brazil)'),
    ('BR-MMI', 'BR-MMI (Mogi Mirim, São Paulo, Brazil)'),
    ('BR-MBU', 'BR-MBU (Mombuca, São Paulo, Brazil)'),
    ('BR-MOI', 'BR-MOI (Mondaí, Santa Catarina, Brazil)'),
    ('BR-MNU', 'BR-MNU (Mongagua, São Paulo, Brazil)'),
    ('BR-MPL', 'BR-MPL (Monsenhor Paulo, Minas Gerais, Brazil)'),
    ('BR-MNH', 'BR-MNH (Montanha, Espírito Santo, Brazil)'),
    ('BR-MON', 'BR-MON (Montauri, Rio Grande do Sul, Brazil)'),
    ('BR-MAC', 'BR-MAC (Monte Alegre, Rio Grande do Norte, Brazil)'),
    ('BR-MTE', 'BR-MTE (Monte Alegre, Pará, Brazil)'),
    ('BR-MAM', 'BR-MAM (Monte Alegre de Minas, Minas Gerais, Brazil)'),
    ('BR-MAS', 'BR-MAS (Monte Alegre do Sul, São Paulo, Brazil)'),
    ('BR-MTT', 'BR-MTT (Monte Alto, São Paulo, Brazil)'),
    ('BR-MAZ', 'BR-MAZ (Monte Aprazivel, São Paulo, Brazil)'),
    ('BR-MAP', 'BR-MAP (Monte Azul Paulista, São Paulo, Brazil)'),
    ('BR-MOB', 'BR-MOB (Monte Belo, Minas Gerais, Brazil)'),
    ('BR-MBS', 'BR-MBS (Monte Belo do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-MCE', 'BR-MCE (Monte Carmelo, Minas Gerais, Brazil)'),
    ('BR-MEU', 'BR-MEU (Monte Dourado, Pará, Brazil)'),
    ('BR-MTM', 'BR-MTM (Monte Mor, São Paulo, Brazil)'),
    ('BR-MNG', 'BR-MNG (Monte Negro, São Paulo, Brazil)'),
    ('BR-MSI', 'BR-MSI (Monte Siao, Minas Gerais, Brazil)'),
    ('BR-MVE', 'BR-MVE (Monte Verde, Minas Gerais, Brazil)'),
    ('BR-MME', 'BR-MME (Monteiro, Paraíba, Brazil)'),
    ('BR-MLO', 'BR-MLO (Monteiro Lobato, São Paulo, Brazil)'),
    ('BR-QGF', 'BR-QGF (Montenegro, Rio Grande do Sul, Brazil)'),
    ('BR-MOC', 'BR-MOC (Montes Claros, Minas Gerais, Brazil)'),
    ('BR-MCG', 'BR-MCG (Montes Claros de Goias, Goiás, Brazil)'),
    ('BR-MRV', 'BR-MRV (Morada Nova, Ceará, Brazil)'),
    ('BR-MRE', 'BR-MRE (Moreno, Pernambuco, Brazil)'),
    ('BR-MMA', 'BR-MMA (Mormaco, Rio Grande do Sul, Brazil)'),
    ('BR-MRS', 'BR-MRS (Morretes, Paraná, Brazil)'),
    ('BR-MHO', 'BR-MHO (Morrinhos, Goiás, Brazil)'),
    ('BR-MOA', 'BR-MOA (Morro Agudo, São Paulo, Brazil)'),
    ('BR-MSP', 'BR-MSP (Morro de Sao Paulo, Bahia, Brazil)'),
    ('BR-MGD', 'BR-MGD (Morro Grande, Santa Catarina, Brazil)'),
    ('BR-MGR', 'BR-MGR (Morro Reuter, Rio Grande do Sul, Brazil)'),
    ('BR-MRG', 'BR-MRG (Morungaba, São Paulo, Brazil)'),
    ('BR-MQR', 'BR-MQR (Mosqueiro, Pará, Brazil)'),
    ('BR-MVF', 'BR-MVF (Mossoró, Rio Grande do Norte, Brazil)'),
    ('BR-MTD', 'BR-MTD (Mostardas, Rio Grande do Sul, Brazil)'),
    ('BR-MZA', 'BR-MZA (Mozarlandia, Goiás, Brazil)'),
    ('BR-MUG', 'BR-MUG (Mucugê, Bahia, Brazil)'),
    ('BR-MVS', 'BR-MVS (Mucuri, Bahia, Brazil)'),
    ('BR-MTC', 'BR-MTC (Muitos Capões, Rio Grande do Sul, Brazil)'),
    ('BR-MUN', 'BR-MUN (Mundai, Bahia, Brazil)'),
    ('BR-MNV', 'BR-MNV (Mundo Novo, Mato Grosso do Sul, Brazil)'),
    ('BR-MVG', 'BR-MVG (Mundo Novo de Goias, Goiás, Brazil)'),
    ('BR-MGU', 'BR-MGU (Munguba, Pará, Brazil)'),
    ('BR-MHZ', 'BR-MHZ (Munhoz, Minas Gerais, Brazil)'),
    ('BR-MUR', 'BR-MUR (Muriae, Minas Gerais, Brazil)'),
    ('BR-MRZ', 'BR-MRZ (Murici, Alagoas, Brazil)'),
    ('BR-MZI', 'BR-MZI (Muzambinho, Minas Gerais, Brazil)'),
    ('BR-MUM', 'BR-MUM (Muçum, Rio Grande do Sul, Brazil)'),
    ('BR-MCC', 'BR-MCC (Mário Campos, Minas Gerais, Brazil)'),
    ('BR-NNU', 'BR-NNU (Nanuque, Minas Gerais, Brazil)'),
    ('BR-NTQ', 'BR-NTQ (Nao Me Toque, Rio Grande do Sul, Brazil)'),
    ('BR-NAT', 'BR-NAT (Natal, Rio Grande do Norte, Brazil)'),
    ('BR-NVT', 'BR-NVT (Navegantes, Santa Catarina, Brazil)'),
    ('BR-NVI', 'BR-NVI (Navirai, Mato Grosso do Sul, Brazil)'),
    ('BR-NZA', 'BR-NZA (Nazare, Bahia, Brazil)'),
    ('BR-NPU', 'BR-NPU (Nazare Paulista, São Paulo, Brazil)'),
    ('BR-NZN', 'BR-NZN (Nazareno, Minas Gerais, Brazil)'),
    ('BR-NEO', 'BR-NEO (Neópolis, Sergipe, Brazil)'),
    ('BR-NHA', 'BR-NHA (Nhandeara, São Paulo, Brazil)'),
    ('BR-NPO', 'BR-NPO (Nilopolis, Rio de Janeiro, Brazil)'),
    ('BR-NQL', 'BR-NQL (Niquelândia, Goiás, Brazil)'),
    ('BR-NTR', 'BR-NTR (Niteroi, Rio de Janeiro, Brazil)'),
    ('BR-NFO', 'BR-NFO (Nizia Floresta, Rio Grande do Norte, Brazil)'),
    ('BR-NBE', 'BR-NBE (Nobres, Mato Grosso, Brazil)'),
    ('BR-NTO', 'BR-NTO (Nortolandia, Mato Grosso, Brazil)'),
    ('BR-NSS', 'BR-NSS (Nossa Senhora do Socorro, Sergipe, Brazil)'),
    ('BR-NAI', 'BR-NAI (Nova Almeida, Espírito Santo, Brazil)'),
    ('BR-NAD', 'BR-NAD (Nova Andradina, Mato Grosso do Sul, Brazil)'),
    ('BR-NOA', 'BR-NOA (Nova Araçá, Rio Grande do Sul, Brazil)'),
    ('BR-NUR', 'BR-NUR (Nova Aurora, Paraná, Brazil)'),
    ('BR-NBA', 'BR-NBA (Nova Bassano, Rio Grande do Sul, Brazil)'),
    ('BR-NCA', 'BR-NCA (Nova Caiaponia, Goiás, Brazil)'),
    ('BR-NER', 'BR-NER (Nova Era, Minas Gerais, Brazil)'),
    ('BR-NEC', 'BR-NEC (Nova Esperanca, Paraná, Brazil)'),
    ('BR-NES', 'BR-NES (Nova Esperança do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-NEU', 'BR-NEU (Nova Europa, São Paulo, Brazil)'),
    ('BR-NFU', 'BR-NFU (Nova Friburgo, Rio de Janeiro, Brazil)'),
    ('BR-NGO', 'BR-NGO (Nova Gloria, Goiás, Brazil)'),
    ('BR-NGA', 'BR-NGA (Nova Granada, São Paulo, Brazil)'),
    ('BR-HAR', 'BR-HAR (Nova Hartz, Rio Grande do Sul, Brazil)'),
    ('BR-NIU', 'BR-NIU (Nova Iguacu, Rio de Janeiro, Brazil)'),
    ('BR-NVL', 'BR-NVL (Nova Laranjeiras, Paraná, Brazil)'),
    ('BR-NLI', 'BR-NLI (Nova Lima, Minas Gerais, Brazil)'),
    ('BR-NLO', 'BR-NLO (Nova Londrina, Paraná, Brazil)'),
    ('BR-NMU', 'BR-NMU (Nova Mutum, Mato Grosso, Brazil)'),
    ('BR-NOD', 'BR-NOD (Nova Odessa, São Paulo, Brazil)'),
    ('BR-NOP', 'BR-NOP (Nova Palma, Rio Grande do Sul, Brazil)'),
    ('BR-NPM', 'BR-NPM (Nova Palmeira, Paraíba, Brazil)'),
    ('BR-NPE', 'BR-NPE (Nova Petropolis, Rio Grande do Sul, Brazil)'),
    ('BR-NPT', 'BR-NPT (Nova Ponte, Minas Gerais, Brazil)'),
    ('BR-NPA', 'BR-NPA (Nova Prata, Rio Grande do Sul, Brazil)'),
    ('BR-NRE', 'BR-NRE (Nova Resende, Minas Gerais, Brazil)'),
    ('BR-NRS', 'BR-NRS (Nova Roma do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-NSR', 'BR-NSR (Nova Santa Rita, Rio Grande do Sul, Brazil)'),
    ('BR-NSA', 'BR-NSA (Nova Serrana, Minas Gerais, Brazil)'),
    ('BR-NSE', 'BR-NSE (Nova Soure, Bahia, Brazil)'),
    ('BR-NOT', 'BR-NOT (Nova Trento, Santa Catarina, Brazil)'),
    ('BR-NUB', 'BR-NUB (Nova Ubiratã, Mato Grosso, Brazil)'),
    ('BR-NVU', 'BR-NVU (Nova União, Minas Gerais, Brazil)'),
    ('BR-NVC', 'BR-NVC (Nova Venecia, Espírito Santo, Brazil)'),
    ('BR-NVE', 'BR-NVE (Nova Veneza, Santa Catarina, Brazil)'),
    ('BR-NVZ', 'BR-NVZ (Nova Veneza, Goiás, Brazil)'),
    ('BR-NVO', 'BR-NVO (Nova Vicosa, Bahia, Brazil)'),
    ('BR-NOK', 'BR-NOK (Nova Xavantina, Mato Grosso, Brazil)'),
    ('BR-NVP', 'BR-NVP (Novo Aripuana, Amazonas, Brazil)'),
    ('BR-NHO', 'BR-NHO (Novo Hamburgo, Rio Grande do Sul, Brazil)'),
    ('BR-NOV', 'BR-NOV (Novo Progresso, Pará, Brazil)'),
    ('BR-NSJ', 'BR-NSJ (Novo Sao Joaquim, Mato Grosso, Brazil)'),
    ('BR-NPG', 'BR-NPG (Nuporanga, São Paulo, Brazil)'),
    ('BR-OBI', 'BR-OBI (Obidos, Pará, Brazil)'),
    ('BR-OCR', 'BR-OCR (Ocara, Ceará, Brazil)'),
    ('BR-OCU', 'BR-OCU (Ocauçu, São Paulo, Brazil)'),
    ('BR-ODI', 'BR-ODI (Ocidental, Goiás, Brazil)'),
    ('BR-OYK', 'BR-OYK (Oiapoque, Amapá, Brazil)'),
    ('BR-OLI', 'BR-OLI (Olimpia, São Paulo, Brazil)'),
    ('BR-OLA', 'BR-OLA (Olinda, Pernambuco, Brazil)'),
    ('BR-OVA', 'BR-OVA (Oliveira, Minas Gerais, Brazil)'),
    ('BR-ORI', 'BR-ORI (Oriente, São Paulo, Brazil)'),
    ('BR-ORX', 'BR-ORX (Oriximiná, Pará, Brazil)'),
    ('BR-ORL', 'BR-ORL (Orlandia, São Paulo, Brazil)'),
    ('BR-OLS', 'BR-OLS (Orleans, Santa Catarina, Brazil)'),
    ('BR-ORT', 'BR-ORT (Ortigueira, Paraná, Brazil)'),
    ('BR-QOC', 'BR-QOC (Osasco, São Paulo, Brazil)'),
    ('BR-OSO', 'BR-OSO (Osorio, Rio Grande do Sul, Brazil)'),
    ('BR-OCZ', 'BR-OCZ (Osvaldo Cruz, São Paulo, Brazil)'),
    ('BR-OCA', 'BR-OCA (Otacilio Costa, Santa Catarina, Brazil)'),
    ('BR-ONO', 'BR-ONO (Ourilandia do Norte, Pará, Brazil)'),
    ('BR-OUS', 'BR-OUS (Ourinhos, São Paulo, Brazil)'),
    ('BR-OBR', 'BR-OBR (Ouro Branco, Minas Gerais, Brazil)'),
    ('BR-OFI', 'BR-OFI (Ouro Fino, Minas Gerais, Brazil)'),
    ('BR-OPO', 'BR-OPO (Ouro Preto, Minas Gerais, Brazil)'),
    ('BR-OPE', 'BR-OPE (Ouro Preto do Oeste, Rondônia, Brazil)'),
    ('BR-OVD', 'BR-OVD (Ouro Verde, São Paulo, Brazil)'),
    ('BR-ORE', 'BR-ORE (Ouroeste, São Paulo, Brazil)'),
    ('BR-OUR', 'BR-OUR (Ourolandia, Bahia, Brazil)'),
    ('BR-OUT', 'BR-OUT (Outeiro, Pará, Brazil)'),
    ('BR-OUV', 'BR-OUV (Ouvidor, Goiás, Brazil)'),
    ('BR-PCU', 'BR-PCU (Pacaembu, São Paulo, Brazil)'),
    ('BR-PCJ', 'BR-PCJ (Pacajus, Ceará, Brazil)'),
    ('BR-PAJ', 'BR-PAJ (Pacajá, Pará, Brazil)'),
    ('BR-PTU', 'BR-PTU (Pacatuba, Ceará, Brazil)'),
    ('BR-PBE', 'BR-PBE (Padre Bernardo, Goiás, Brazil)'),
    ('BR-PAI', 'BR-PAI (Paiçandu, Paraná, Brazil)'),
    ('BR-PSI', 'BR-PSI (Palestina, São Paulo, Brazil)'),
    ('BR-PHO', 'BR-PHO (Palhoca, Santa Catarina, Brazil)'),
    ('BR-PAS', 'BR-PAS (Palma Sola, Santa Catarina, Brazil)'),
    ('BR-PMS', 'BR-PMS (Palmares, Pernambuco, Brazil)'),
    ('BR-PAE', 'BR-PAE (Palmares Paulista, São Paulo, Brazil)'),
    ('BR-PMW', 'BR-PMW (Palmas, Tocantins, Brazil)'),
    ('BR-PPR', 'BR-PPR (Palmas Parana, Paraná, Brazil)'),
    ('BR-PMI', 'BR-PMI (Palmeira, Paraná, Brazil)'),
    ('BR-PSC', 'BR-PSC (Palmeira, Santa Catarina, Brazil)'),
    ('BR-PME', 'BR-PME (Palmeira das Missoes, Rio Grande do Sul, Brazil)'),
    ('BR-POS', 'BR-POS (Palmeira do Oeste, São Paulo, Brazil)'),
    ('BR-PIS', 'BR-PIS (Palmeira dos Indios, Alagoas, Brazil)'),
    ('BR-PMR', 'BR-PMR (Palmeiras, Bahia, Brazil)'),
    ('BR-PGI', 'BR-PGI (Palmeiras de Goias, Goiás, Brazil)'),
    ('BR-PPO', 'BR-PPO (Palmeiropolis, Tocantins, Brazil)'),
    ('BR-PML', 'BR-PML (Palmital, São Paulo, Brazil)'),
    ('BR-PLO', 'BR-PLO (Palmitos, Santa Catarina, Brazil)'),
    ('BR-PLA', 'BR-PLA (Palotina, Paraná, Brazil)'),
    ('BR-PLU', 'BR-PLU (Pampulha, Minas Gerais, Brazil)'),
    ('BR-PNI', 'BR-PNI (Panambi, Rio Grande do Sul, Brazil)'),
    ('BR-PNA', 'BR-PNA (Panorama, São Paulo, Brazil)'),
    ('BR-PAP', 'BR-PAP (Papagaios, Minas Gerais, Brazil)'),
    ('BR-PAN', 'BR-PAN (Papagaios, Minas Gerais, Brazil)'),
    ('BR-PMN', 'BR-PMN (Para de Minas, Minas Gerais, Brazil)'),
    ('BR-PAB', 'BR-PAB (Paracambi, Rio de Janeiro, Brazil)'),
    ('BR-PCT', 'BR-PCT (Paracatu, Minas Gerais, Brazil)'),
    ('BR-PRU', 'BR-PRU (Paracuru, Ceará, Brazil)'),
    ('BR-PGO', 'BR-PGO (Paragominas, Pará, Brazil)'),
    ('BR-PUC', 'BR-PUC (Paraguacu, Minas Gerais, Brazil)'),
    ('BR-PPI', 'BR-PPI (Paraguacu Paulista, São Paulo, Brazil)'),
    ('BR-PSU', 'BR-PSU (Paraiba do Sul, Rio de Janeiro, Brazil)'),
    ('BR-PBU', 'BR-PBU (Paraibuna, São Paulo, Brazil)'),
    ('BR-PRI', 'BR-PRI (Paraiso, São Paulo, Brazil)'),
    ('BR-PUL', 'BR-PUL (Paraiso do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-PTI', 'BR-PTI (Paraiso do Tocantins, Tocantins, Brazil)'),
    ('BR-PRO', 'BR-PRO (Paraisopolis, Minas Gerais, Brazil)'),
    ('BR-PNG', 'BR-PNG (Paranaguá, Paraná, Brazil)'),
    ('BR-PBB', 'BR-PBB (Paranaiba, Mato Grosso do Sul, Brazil)'),
    ('BR-PRT', 'BR-PRT (Paranaita, Mato Grosso, Brazil)'),
    ('BR-PPM', 'BR-PPM (Paranapanema, São Paulo, Brazil)'),
    ('BR-PTG', 'BR-PTG (Paranatinga, Mato Grosso, Brazil)'),
    ('BR-PNU', 'BR-PNU (Paranauna, Goiás, Brazil)'),
    ('BR-PVI', 'BR-PVI (Paranavaí, Paraná, Brazil)'),
    ('BR-PNN', 'BR-PNN (Paranã, Tocantins, Brazil)'),
    ('BR-PPU', 'BR-PPU (Parapua, São Paulo, Brazil)'),
    ('BR-PAT', 'BR-PAT (Parati, Rio de Janeiro, Brazil)'),
    ('BR-PRS', 'BR-PRS (Parauapebas, Pará, Brazil)'),
    ('BR-PRN', 'BR-PRN (Parauna, Goiás, Brazil)'),
    ('BR-PRJ', 'BR-PRJ (Paraí, Rio Grande do Sul, Brazil)'),
    ('BR-PRD', 'BR-PRD (Pardinho, São Paulo, Brazil)'),
    ('BR-PAH', 'BR-PAH (Parelhas, Rio Grande do Norte, Brazil)'),
    ('BR-PIN', 'BR-PIN (Parintins, Amazonas, Brazil)'),
    ('BR-PAC', 'BR-PAC (Pariquera-Acu, São Paulo, Brazil)'),
    ('BR-PMM', 'BR-PMM (Parnamirim, Rio Grande do Norte, Brazil)'),
    ('BR-PHB', 'BR-PHB (Parnaíba, Piauí, Brazil)'),
    ('BR-PRE', 'BR-PRE (Parobe, Rio Grande do Sul, Brazil)'),
    ('BR-PQO', 'BR-PQO (Passa Quatro, Minas Gerais, Brazil)'),
    ('BR-PFB', 'BR-PFB (Passo Fundo, Rio Grande do Sul, Brazil)'),
    ('BR-PSW', 'BR-PSW (Passos, Minas Gerais, Brazil)'),
    ('BR-PBS', 'BR-PBS (Pastos Bons, Maranhão, Brazil)'),
    ('BR-PAF', 'BR-PAF (Pati dos Alferes, Rio de Janeiro, Brazil)'),
    ('BR-PTO', 'BR-PTO (Pato Branco, Paraná, Brazil)'),
    ('BR-PTN', 'BR-PTN (Patolina, Paraná, Brazil)'),
    ('BR-PTS', 'BR-PTS (Patos, Paraíba, Brazil)'),
    ('BR-POJ', 'BR-POJ (Patos de Minas, Minas Gerais, Brazil)'),
    ('BR-PCO', 'BR-PCO (Patrocinio, Minas Gerais, Brazil)'),
    ('BR-PPS', 'BR-PPS (Patrocinio Paulista, São Paulo, Brazil)'),
    ('BR-PFT', 'BR-PFT (Paula Freitas, Paraná, Brazil)'),
    ('BR-PUI', 'BR-PUI (Paulinia, São Paulo, Brazil)'),
    ('BR-PAL', 'BR-PAL (Paulista, Pernambuco, Brazil)'),
    ('BR-PAV', 'BR-PAV (Paulo Afonso, Bahia, Brazil)'),
    ('BR-PFA', 'BR-PFA (Paulo de Faria, São Paulo, Brazil)'),
    ('BR-PVA', 'BR-PVA (Pavao, Minas Gerais, Brazil)'),
    ('BR-PAM', 'BR-PAM (Paverama, Rio Grande do Sul, Brazil)'),
    ('BR-PVU', 'BR-PVU (Pavuna, Rio de Janeiro, Brazil)'),
    ('BR-PEC', 'BR-PEC (Pecém Pt/São Gonçalo do Amarante, Ceará, Brazil)'),
    ('BR-PNS', 'BR-PNS (Pederneiras, São Paulo, Brazil)'),
    ('BR-PAZ', 'BR-PAZ (Pedra Azul, Minas Gerais, Brazil)'),
    ('BR-PEP', 'BR-PEP (Pedra Preta, Mato Grosso, Brazil)'),
    ('BR-PFG', 'BR-PFG (Pedras de Fogo, Paraíba, Brazil)'),
    ('BR-PEN', 'BR-PEN (Pedras Negras, Rondônia, Brazil)'),
    ('BR-PGU', 'BR-PGU (Pedregulho, São Paulo, Brazil)'),
    ('BR-PDI', 'BR-PDI (Pedreira, São Paulo, Brazil)'),
    ('BR-PDA', 'BR-PDA (Pedreiras, Maranhão, Brazil)'),
    ('BR-PPT', 'BR-PPT (Pedrinhas Paulista, São Paulo, Brazil)'),
    ('BR-PCA', 'BR-PCA (Pedro Canario, Espírito Santo, Brazil)'),
    ('BR-PED', 'BR-PED (Pedro de Toledo, São Paulo, Brazil)'),
    ('BR-PLE', 'BR-PLE (Pedro Leopoldo, Minas Gerais, Brazil)'),
    ('BR-PXA', 'BR-PXA (Peixoto de Azevedo, Mato Grosso, Brazil)'),
    ('BR-PET', 'BR-PET (Pelotas, Rio Grande do Sul, Brazil)'),
    ('BR-PNP', 'BR-PNP (Penapolis, São Paulo, Brazil)'),
    ('BR-PNE', 'BR-PNE (Penedo, Alagoas, Brazil)'),
    ('BR-PHA', 'BR-PHA (Penha, Santa Catarina, Brazil)'),
    ('BR-PZS', 'BR-PZS (Perdizes, Minas Gerais, Brazil)'),
    ('BR-PDS', 'BR-PDS (Perdoes, Minas Gerais, Brazil)'),
    ('BR-PBA', 'BR-PBA (Pereira Barreto, São Paulo, Brazil)'),
    ('BR-PER', 'BR-PER (Pereiras, São Paulo, Brazil)'),
    ('BR-PEI', 'BR-PEI (Pereiro, Ceará, Brazil)'),
    ('BR-PES', 'BR-PES (Peres, Goiás, Brazil)'),
    ('BR-PRL', 'BR-PRL (Perola, Paraná, Brazil)'),
    ('BR-PUB', 'BR-PUB (Peruibe, São Paulo, Brazil)'),
    ('BR-PQE', 'BR-PQE (Pesqueira, Pernambuco, Brazil)'),
    ('BR-PNZ', 'BR-PNZ (Petrolina, Pernambuco, Brazil)'),
    ('BR-QPE', 'BR-QPE (Petrópolis, Rio de Janeiro, Brazil)'),
    ('BR-PIT', 'BR-PIT (Piacatu, São Paulo, Brazil)'),
    ('BR-PIC', 'BR-PIC (Picada Café, Rio Grande do Sul, Brazil)'),
    ('BR-PRR', 'BR-PRR (Picarras, Santa Catarina, Brazil)'),
    ('BR-PCS', 'BR-PCS (Picos, Piauí, Brazil)'),
    ('BR-PIE', 'BR-PIE (Piedade, São Paulo, Brazil)'),
    ('BR-PSL', 'BR-PSL (Pilar do Sul, São Paulo, Brazil)'),
    ('BR-PMT', 'BR-PMT (Pimenta, Minas Gerais, Brazil)'),
    ('BR-PBQ', 'BR-PBQ (Pimenta Bueno, Rondônia, Brazil)'),
    ('BR-PSO', 'BR-PSO (Pimenteiras do Oeste, Rondônia, Brazil)'),
    ('BR-PEL', 'BR-PEL (Pimentel, Maranhão, Brazil)'),
    ('BR-PNM', 'BR-PNM (Pindamonhangaba, São Paulo, Brazil)'),
    ('BR-PND', 'BR-PND (Pindorama, São Paulo, Brazil)'),
    ('BR-PIH', 'BR-PIH (Pinhais, Paraná, Brazil)'),
    ('BR-PHZ', 'BR-PHZ (Pinhalzinho, Santa Catarina, Brazil)'),
    ('BR-PZI', 'BR-PZI (Pinhalzinho, São Paulo, Brazil)'),
    ('BR-PHI', 'BR-PHI (Pinheiro, Maranhão, Brazil)'),
    ('BR-PRC', 'BR-PRC (Pinheiro Machado, Rio Grande do Sul, Brazil)'),
    ('BR-PHW', 'BR-PHW (Pinhão, Paraná, Brazil)'),
    ('BR-PCI', 'BR-PCI (Piracaia, São Paulo, Brazil)'),
    ('BR-PJU', 'BR-PJU (Piracanjuba, Goiás, Brazil)'),
    ('BR-QHB', 'BR-QHB (Piracicaba, São Paulo, Brazil)'),
    ('BR-PIR', 'BR-PIR (Pirai, Rio de Janeiro, Brazil)'),
    ('BR-PJA', 'BR-PJA (Piraju, São Paulo, Brazil)'),
    ('BR-PJR', 'BR-PJR (Pirajui, São Paulo, Brazil)'),
    ('BR-PRG', 'BR-PRG (Pirangi, São Paulo, Brazil)'),
    ('BR-PNH', 'BR-PNH (Piranhas, Goiás, Brazil)'),
    ('BR-PTA', 'BR-PTA (Pirapetinga, Minas Gerais, Brazil)'),
    ('BR-PIV', 'BR-PIV (Pirapora, Minas Gerais, Brazil)'),
    ('BR-PBJ', 'BR-PBJ (Pirapora do Bom Jesus, São Paulo, Brazil)'),
    ('BR-PZO', 'BR-PZO (Pirapozinho, São Paulo, Brazil)'),
    ('BR-PQA', 'BR-PQA (Piraquara, Paraná, Brazil)'),
    ('BR-PIA', 'BR-PIA (Piratini, Rio Grande do Sul, Brazil)'),
    ('BR-PRB', 'BR-PRB (Piratuba, Santa Catarina, Brazil)'),
    ('BR-PIB', 'BR-PIB (Pirauba, Minas Gerais, Brazil)'),
    ('BR-PRZ', 'BR-PRZ (Piraí do Sul, Paraná, Brazil)'),
    ('BR-PLS', 'BR-PLS (Pirenopolis, Goiás, Brazil)'),
    ('BR-PSR', 'BR-PSR (Pires do Rio, Goiás, Brazil)'),
    ('BR-PIP', 'BR-PIP (Piripiri, Piauí, Brazil)'),
    ('BR-PTB', 'BR-PTB (Pirituba, São Paulo, Brazil)'),
    ('BR-PGA', 'BR-PGA (Pitangueiras, São Paulo, Brazil)'),
    ('BR-PAG', 'BR-PAG (Pitangui, Minas Gerais, Brazil)'),
    ('BR-PMU', 'BR-PMU (Pitimbu, Paraíba, Brazil)'),
    ('BR-PIG', 'BR-PIG (Pitinga, Amazonas, Brazil)'),
    ('BR-PUM', 'BR-PUM (Piuma, Espírito Santo, Brazil)'),
    ('BR-PUH', 'BR-PUH (Piumhi, Minas Gerais, Brazil)'),
    ('BR-PYN', 'BR-PYN (Piên, Paraná, Brazil)'),
    ('BR-PLT', 'BR-PLT (Planalto, Rio Grande do Sul, Brazil)'),
    ('BR-PLN', 'BR-PLN (Planura, Minas Gerais, Brazil)'),
    ('BR-PQZ', 'BR-PQZ (Poa, São Paulo, Brazil)'),
    ('BR-PCF', 'BR-PCF (Poco Fundo, Minas Gerais, Brazil)'),
    ('BR-POC', 'BR-POC (Pocoes, Bahia, Brazil)'),
    ('BR-PCN', 'BR-PCN (Pocone, Mato Grosso, Brazil)'),
    ('BR-PJC', 'BR-PJC (Pojuca, Bahia, Brazil)'),
    ('BR-PMB', 'BR-PMB (Pombos, Pernambuco, Brazil)'),
    ('BR-POM', 'BR-POM (Pomerode, Santa Catarina, Brazil)'),
    ('BR-PPA', 'BR-PPA (Pompéia, São Paulo, Brazil)'),
    ('BR-PMA', 'BR-PMA (Ponta da Madeira, Maranhão, Brazil)'),
    ('BR-POU', 'BR-POU (Ponta do Ubu Pt/Anchieta, Espírito Santo, Brazil)'),
    ('BR-PGZ', 'BR-PGZ (Ponta Grossa, Paraná, Brazil)'),
    ('BR-PLL', 'BR-PLL (Ponta Pelada, Amazonas, Brazil)'),
    ('BR-PMG', 'BR-PMG (Ponta Pora, Mato Grosso do Sul, Brazil)'),
    ('BR-PTL', 'BR-PTL (Pontal, São Paulo, Brazil)'),
    ('BR-PLI', 'BR-PLI (Pontalina, Goiás, Brazil)'),
    ('BR-PNV', 'BR-PNV (Ponte Nova, Minas Gerais, Brazil)'),
    ('BR-PLC', 'BR-PLC (Pontes e Lacerda, Mato Grosso, Brazil)'),
    ('BR-POR', 'BR-POR (Porangaba, São Paulo, Brazil)'),
    ('BR-PNC', 'BR-PNC (Porciuncula, Rio de Janeiro, Brazil)'),
    ('BR-POT', 'BR-POT (Porecatu, Paraná, Brazil)'),
    ('BR-PAO', 'BR-PAO (Portao, Rio Grande do Sul, Brazil)'),
    ('BR-PTH', 'BR-PTH (Porteirinha, Minas Gerais, Brazil)'),
    ('BR-PBX', 'BR-PBX (Porto Alegre do Nort, Mato Grosso, Brazil)'),
    ('BR-PBO', 'BR-PBO (Porto Belo, Santa Catarina, Brazil)'),
    ('BR-PGS', 'BR-PGS (Porto de Galinhas, Pernambuco, Brazil)'),
    ('BR-PTM', 'BR-PTM (Porto do Mangue, Ceará, Brazil)'),
    ('BR-PTZ', 'BR-PTZ (Porto Feliz, São Paulo, Brazil)'),
    ('BR-PTF', 'BR-PTF (Porto Ferreira, São Paulo, Brazil)'),
    ('BR-PTC', 'BR-PTC (Porto Franco, Maranhão, Brazil)'),
    ('BR-PMH', 'BR-PMH (Porto Murtinho, Mato Grosso do Sul, Brazil)'),
    ('BR-PNB', 'BR-PNB (Porto Nacional, Tocantins, Brazil)'),
    ('BR-PTV', 'BR-PTV (Porto Novo, São Paulo, Brazil)'),
    ('BR-PTE', 'BR-PTE (Porto Real, Rio de Janeiro, Brazil)'),
    ('BR-PTR', 'BR-PTR (Porto Rico, Paraná, Brazil)'),
    ('BR-BPS', 'BR-BPS (Porto Seguro, Bahia, Brazil)'),
    ('BR-PUN', 'BR-PUN (Porto Uniao, Santa Catarina, Brazil)'),
    ('BR-PVT', 'BR-PVT (Porto Vitoria, Paraná, Brazil)'),
    ('BR-PXI', 'BR-PXI (Porto Xavier, Rio Grande do Sul, Brazil)'),
    ('BR-PSS', 'BR-PSS (Posse, Goiás, Brazil)'),
    ('BR-PTD', 'BR-PTD (Posto da Mata, Bahia, Brazil)'),
    ('BR-POI', 'BR-POI (Potim, São Paulo, Brazil)'),
    ('BR-POD', 'BR-POD (Potirendaba, São Paulo, Brazil)'),
    ('BR-PAR', 'BR-PAR (Pouso Alegre, Minas Gerais, Brazil)'),
    ('BR-PST', 'BR-PST (Pouso Alto, Minas Gerais, Brazil)'),
    ('BR-POO', 'BR-POO (Poços de Caldas, Minas Gerais, Brazil)'),
    ('BR-PDF', 'BR-PDF (Prado, Bahia, Brazil)'),
    ('BR-PPL', 'BR-PPL (Pradopolis, São Paulo, Brazil)'),
    ('BR-PGR', 'BR-PGR (Praia Grande, São Paulo, Brazil)'),
    ('BR-PAA', 'BR-PAA (Prata, Minas Gerais, Brazil)'),
    ('BR-PBR', 'BR-PBR (Presidente Bernardes, São Paulo, Brazil)'),
    ('BR-PDR', 'BR-PDR (Presidente Dutra, Maranhão, Brazil)'),
    ('BR-PEO', 'BR-PEO (Presidente Epitacio, São Paulo, Brazil)'),
    ('BR-PFU', 'BR-PFU (Presidente Figueiredo, Amazonas, Brazil)'),
    ('BR-PGL', 'BR-PGL (Presidente Getulio, Santa Catarina, Brazil)'),
    ('BR-PMC', 'BR-PMC (Presidente Medici, Rondônia, Brazil)'),
    ('BR-PPE', 'BR-PPE (Presidente Prudente, São Paulo, Brazil)'),
    ('BR-PVE', 'BR-PVE (Presidente Venceslau, São Paulo, Brazil)'),
    ('BR-PMV', 'BR-PMV (Primavera, Pernambuco, Brazil)'),
    ('BR-PRV', 'BR-PRV (Primavera, Pará, Brazil)'),
    ('BR-PIL', 'BR-PIL (Primavera do Leste, Mato Grosso, Brazil)'),
    ('BR-PGG', 'BR-PGG (Progresso, Pará, Brazil)'),
    ('BR-PMO', 'BR-PMO (Promissao, São Paulo, Brazil)'),
    ('BR-PRP', 'BR-PRP (Propria, Sergipe, Brazil)'),
    ('BR-PUO', 'BR-PUO (Prudentopolis, Paraná, Brazil)'),
    ('BR-POA', 'BR-POA (Pôrto Alegre, Rio Grande do Sul, Brazil)'),
    ('BR-PTQ', 'BR-PTQ (Pôrto de Moz, Pará, Brazil)'),
    ('BR-PBV', 'BR-PBV (Pôrto dos Gaúchos, Mato Grosso, Brazil)'),
    ('BR-PVH', 'BR-PVH (Pôrto Velho, Rondônia, Brazil)'),
    ('BR-QRA', 'BR-QRA (Quarai, Rio Grande do Sul, Brazil)'),
    ('BR-QTA', 'BR-QTA (Quata, São Paulo, Brazil)'),
    ('BR-QTS', 'BR-QTS (Quatis, Rio de Janeiro, Brazil)'),
    ('BR-QBA', 'BR-QBA (Quatro Barras, Paraná, Brazil)'),
    ('BR-QPT', 'BR-QPT (Quatro Pontes, Paraná, Brazil)'),
    ('BR-QRO', 'BR-QRO (Quatro Rodas, Paraná, Brazil)'),
    ('BR-QDI', 'BR-QDI (Quedas do Iguaçu, Paraná, Brazil)'),
    ('BR-QMA', 'BR-QMA (Queimados, Rio de Janeiro, Brazil)'),
    ('BR-QLU', 'BR-QLU (Queluz, São Paulo, Brazil)'),
    ('BR-QUN', 'BR-QUN (Quintana, São Paulo, Brazil)'),
    ('BR-QPO', 'BR-QPO (Quirinopolis, Goiás, Brazil)'),
    ('BR-QTR', 'BR-QTR (Quiterianópolis, Ceará, Brazil)'),
    ('BR-QUI', 'BR-QUI (Quixadá, Ceará, Brazil)'),
    ('BR-QMO', 'BR-QMO (Quixeramobim, Ceará, Brazil)'),
    ('BR-RFA', 'BR-RFA (Rafard, São Paulo, Brazil)'),
    ('BR-RCA', 'BR-RCA (Rancharia, São Paulo, Brazil)'),
    ('BR-RPO', 'BR-RPO (Raposo, Rio de Janeiro, Brazil)'),
    ('BR-RZA', 'BR-RZA (Realeza, Paraná, Brazil)'),
    ('BR-RBC', 'BR-RBC (Rebouças, Paraná, Brazil)'),
    ('BR-REC', 'BR-REC (Recife, Pernambuco, Brazil)'),
    ('BR-RDC', 'BR-RDC (Redenção, Pará, Brazil)'),
    ('BR-REO', 'BR-REO (Redenção, Ceará, Brazil)'),
    ('BR-RFJ', 'BR-RFJ (Regente Feijo, São Paulo, Brazil)'),
    ('BR-RGI', 'BR-RGI (Registro, São Paulo, Brazil)'),
    ('BR-REL', 'BR-REL (Regência Terminal/Linhares, Espírito Santo, Brazil)'),
    ('BR-RMA', 'BR-RMA (Remanso, Bahia, Brazil)'),
    ('BR-QRZ', 'BR-QRZ (Resende, Rio de Janeiro, Brazil)'),
    ('BR-RSE', 'BR-RSE (Reserva, Paraná, Brazil)'),
    ('BR-RES', 'BR-RES (Restinga, São Paulo, Brazil)'),
    ('BR-RSA', 'BR-RSA (Restinga Seca, Rio Grande do Sul, Brazil)'),
    ('BR-RIJ', 'BR-RIJ (Riachão do Jacuípe, Bahia, Brazil)'),
    ('BR-RRP', 'BR-RRP (Ribas do Rio Pardo, Mato Grosso do Sul, Brazil)'),
    ('BR-RPM', 'BR-RPM (Ribeira do Pombal, Bahia, Brazil)'),
    ('BR-RBI', 'BR-RBI (Ribeirao Bonito, São Paulo, Brazil)'),
    ('BR-RCR', 'BR-RCR (Ribeirao Cascalheira, Mato Grosso, Brazil)'),
    ('BR-RNV', 'BR-RNV (Ribeirao das Neves, Minas Gerais, Brazil)'),
    ('BR-RSU', 'BR-RSU (Ribeirao do Sul, São Paulo, Brazil)'),
    ('BR-RGA', 'BR-RGA (Ribeirao Grande, São Paulo, Brazil)'),
    ('BR-RPI', 'BR-RPI (Ribeirao Pires, São Paulo, Brazil)'),
    ('BR-RAO', 'BR-RAO (Ribeirao Prêto, São Paulo, Brazil)'),
    ('BR-RVO', 'BR-RVO (Ribeirao Vermelho, Minas Gerais, Brazil)'),
    ('BR-RBE', 'BR-RBE (Ribeirão, Pernambuco, Brazil)'),
    ('BR-RIB', 'BR-RIB (Ribeirão Branco, São Paulo, Brazil)'),
    ('BR-RBL', 'BR-RBL (Ribeirópolis, Sergipe, Brazil)'),
    ('BR-RFI', 'BR-RFI (Rifaina, São Paulo, Brazil)'),
    ('BR-RCO', 'BR-RCO (Rincao, São Paulo, Brazil)'),
    ('BR-RPS', 'BR-RPS (Rinopolis, São Paulo, Brazil)'),
    ('BR-RAC', 'BR-RAC (Rio Acima, Minas Gerais, Brazil)'),
    ('BR-RAZ', 'BR-RAZ (Rio Azul, Paraná, Brazil)'),
    ('BR-RBO', 'BR-RBO (Rio Bonito, Rio de Janeiro, Brazil)'),
    ('BR-RBR', 'BR-RBR (Rio Branco, Acre, Brazil)'),
    ('BR-RBS', 'BR-RBS (Rio Branco do Sul, Paraná, Brazil)'),
    ('BR-RBA', 'BR-RBA (Rio Brilhante, Mato Grosso do Sul, Brazil)'),
    ('BR-RCS', 'BR-RCS (Rio Casca, Minas Gerais, Brazil)'),
    ('BR-RCL', 'BR-RCL (Rio Claro, São Paulo, Brazil)'),
    ('BR-RDF', 'BR-RDF (Rio das Flores, Rio de Janeiro, Brazil)'),
    ('BR-RTA', 'BR-RTA (Rio das Ostras, Rio de Janeiro, Brazil)'),
    ('BR-RPE', 'BR-RPE (Rio das Pedras, São Paulo, Brazil)'),
    ('BR-RCN', 'BR-RCN (Rio de Contas, Bahia, Brazil)'),
    ('BR-RIO', 'BR-RIO (Rio de Janeiro, Rio de Janeiro, Brazil)'),
    ('BR-RDA', 'BR-RDA (Rio do Antonio, Bahia, Brazil)'),
    ('BR-RIC', 'BR-RIC (Rio do Campo, Santa Catarina, Brazil)'),
    ('BR-RFO', 'BR-RFO (Rio do Fogo, Rio Grande do Norte, Brazil)'),
    ('BR-RDS', 'BR-RDS (Rio do Sul, Santa Catarina, Brazil)'),
    ('BR-RCD', 'BR-RCD (Rio dos Cedros, Santa Catarina, Brazil)'),
    ('BR-RIG', 'BR-RIG (Rio Grande, Rio Grande do Sul, Brazil)'),
    ('BR-RGS', 'BR-RGS (Rio Grande da Serra, São Paulo, Brazil)'),
    ('BR-RLO', 'BR-RLO (Rio Largo, Alagoas, Brazil)'),
    ('BR-RMI', 'BR-RMI (Rio Maria, Pará, Brazil)'),
    ('BR-RNO', 'BR-RNO (Rio Negro, Paraná, Brazil)'),
    ('BR-RPA', 'BR-RPA (Rio Paranaiba, Minas Gerais, Brazil)'),
    ('BR-RPB', 'BR-RPB (Rio Pomba, Minas Gerais, Brazil)'),
    ('BR-RPV', 'BR-RPV (Rio Preto da Eva, Amazonas, Brazil)'),
    ('BR-RQE', 'BR-RQE (Rio Quente, Goiás, Brazil)'),
    ('BR-ROR', 'BR-ROR (Rio Real, Bahia, Brazil)'),
    ('BR-RTT', 'BR-RTT (Rio Tinto, Paraíba, Brazil)'),
    ('BR-RVD', 'BR-RVD (Rio Verde, Goiás, Brazil)'),
    ('BR-VMG', 'BR-VMG (Rio Verde de Mato Grosso, Mato Grosso do Sul, Brazil)'),
    ('BR-RLA', 'BR-RLA (Riolandia, São Paulo, Brazil)'),
    ('BR-RIZ', 'BR-RIZ (Riozinho, Rio Grande do Sul, Brazil)'),
    ('BR-ROD', 'BR-ROD (Rodeio, Santa Catarina, Brazil)'),
    ('BR-RDL', 'BR-RDL (Rodelas, Bahia, Brazil)'),
    ('BR-ROL', 'BR-ROL (Rolandia, Paraná, Brazil)'),
    ('BR-RMU', 'BR-RMU (Rolim de Moura, Rondônia, Brazil)'),
    ('BR-RND', 'BR-RND (Rondon, Paraná, Brazil)'),
    ('BR-RPR', 'BR-RPR (Rondon do Para, Pará, Brazil)'),
    ('BR-ROO', 'BR-ROO (Rondonópolis, Mato Grosso, Brazil)'),
    ('BR-ROS', 'BR-ROS (Rosana, São Paulo, Brazil)'),
    ('BR-RIV', 'BR-RIV (Rosario do Ivai, Paraná, Brazil)'),
    ('BR-RSO', 'BR-RSO (Rosario do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-RSR', 'BR-RSR (Roseira, São Paulo, Brazil)'),
    ('BR-RSC', 'BR-RSC (Rosário do Catete, Sergipe, Brazil)'),
    ('BR-RUB', 'BR-RUB (Rubiataba, Goiás, Brazil)'),
    ('BR-RUS', 'BR-RUS (Russas, Ceará, Brazil)'),
    ('BR-RYB', 'BR-RYB (Ruy Barbosa, Bahia, Brazil)'),
    ('BR-SAB', 'BR-SAB (Sabara, Minas Gerais, Brazil)'),
    ('BR-SBZ', 'BR-SBZ (Sabáudia, Paraná, Brazil)'),
    ('BR-SMO', 'BR-SMO (Sacramento, Minas Gerais, Brazil)'),
    ('BR-SOV', 'BR-SOV (Sales Oliveira, São Paulo, Brazil)'),
    ('BR-SEE', 'BR-SEE (Salete, Santa Catarina, Brazil)'),
    ('BR-SSX', 'BR-SSX (Salgado de São Félix, Paraíba, Brazil)'),
    ('BR-SGU', 'BR-SGU (Salgueiro, Pernambuco, Brazil)'),
    ('BR-SAA', 'BR-SAA (Salinas, Minas Gerais, Brazil)'),
    ('BR-SAT', 'BR-SAT (Salto, São Paulo, Brazil)'),
    ('BR-SAF', 'BR-SAF (Salto de Pirapora, São Paulo, Brazil)'),
    ('BR-SAL', 'BR-SAL (Salto Grande, São Paulo, Brazil)'),
    ('BR-SSA', 'BR-SSA (Salvador, Bahia, Brazil)'),
    ('BR-SAD', 'BR-SAD (Salvador do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SLV', 'BR-SLV (Salvaterra, Pará, Brazil)'),
    ('BR-SNB', 'BR-SNB (Sana, Rio de Janeiro, Brazil)'),
    ('BR-SNU', 'BR-SNU (Sananduva, Rio Grande do Sul, Brazil)'),
    ('BR-SNC', 'BR-SNC (Sanclerlandia, Goiás, Brazil)'),
    ('BR-SNL', 'BR-SNL (Santa Adelia, São Paulo, Brazil)'),
    ('BR-SNR', 'BR-SNR (Santa Barbara, Minas Gerais, Brazil)'),
    ('BR-SNT', 'BR-SNT (Santa Barbara do Para, Pará, Brazil)'),
    ('BR-SBR', 'BR-SBR (Santa Branca, São Paulo, Brazil)'),
    ('BR-SBW', "BR-SBW (Santa Bárbara d'Oeste, São Paulo, Brazil)"),
    ('BR-SNV', 'BR-SNV (Santa Carmem, Mato Grosso, Brazil)'),
    ('BR-SCC', 'BR-SCC (Santa Cecília, Santa Catarina, Brazil)'),
    ('BR-SCD', "BR-SCD (Santa Clara d'Oeste, São Paulo, Brazil)"),
    ('BR-SCS', 'BR-SCS (Santa Clara do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SNZ', 'BR-SNZ (Santa Cruz, Rio Grande do Norte, Brazil)'),
    ('BR-SNW', 'BR-SNW (Santa Cruz Cabralia, Bahia, Brazil)'),
    ('BR-SNY', 'BR-SNY (Santa Cruz das Palmeiras, São Paulo, Brazil)'),
    ('BR-SNF', 'BR-SNF (Santa Cruz do Capibaribe, Pernambuco, Brazil)'),
    ('BR-SNQ', 'BR-SNQ (Santa Cruz do Rio Pardo, São Paulo, Brazil)'),
    ('BR-DSU', 'BR-DSU (Santa Cruz do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SFE', 'BR-SFE (Santa Fé de Goiás, Goiás, Brazil)'),
    ('BR-SFV', 'BR-SFV (Santa Fé do Sul, São Paulo, Brazil)'),
    ('BR-SGR', 'BR-SGR (Santa Gertrudes, São Paulo, Brazil)'),
    ('BR-SNH', 'BR-SNH (Santa Helena, Paraná, Brazil)'),
    ('BR-SHG', 'BR-SHG (Santa Helena de Goias, Goiás, Brazil)'),
    ('BR-SIN', 'BR-SIN (Santa Ines, Maranhão, Brazil)'),
    ('BR-SIB', 'BR-SIB (Santa Isabel, São Paulo, Brazil)'),
    ('BR-SII', 'BR-SII (Santa Isabel do Ivai, Paraná, Brazil)'),
    ('BR-SLU', 'BR-SLU (Santa Isabel do Ivai, Paraná, Brazil)'),
    ('BR-SLA', 'BR-SLA (Santa Luzia, Minas Gerais, Brazil)'),
    ('BR-SLN', 'BR-SLN (Santa Luzia do Norte, Alagoas, Brazil)'),
    ('BR-RIA', 'BR-RIA (Santa Maria, Rio Grande do Sul, Brazil)'),
    ('BR-SSR', 'BR-SSR (Santa Maria da Serra, São Paulo, Brazil)'),
    ('BR-SMV', 'BR-SMV (Santa Maria da Vitória, Bahia, Brazil)'),
    ('BR-SMY', 'BR-SMY (Santa Maria de Jetibá, Espírito Santo, Brazil)'),
    ('BR-SMM', 'BR-SMM (Santa Maria Madalena, Rio de Janeiro, Brazil)'),
    ('BR-SMN', 'BR-SMN (Santa Mariana, Paraná, Brazil)'),
    ('BR-SRR', 'BR-SRR (Santa Rita, Paraíba, Brazil)'),
    ('BR-SRG', 'BR-SRG (Santa Rita do Araguaia, Goiás, Brazil)'),
    ('BR-SRO', 'BR-SRO (Santa Rita do Oeste, São Paulo, Brazil)'),
    ('BR-SRS', 'BR-SRS (Santa Rita do Passa Quatro, São Paulo, Brazil)'),
    ('BR-SRW', 'BR-SRW (Santa Rita do Sapucai, Minas Gerais, Brazil)'),
    ('BR-SRA', 'BR-SRA (Santa Rosa, Rio Grande do Sul, Brazil)'),
    ('BR-SRV', 'BR-SRV (Santa Rosa de Viterbo, São Paulo, Brazil)'),
    ('BR-SRU', 'BR-SRU (Santa Rosa do Sul, Santa Catarina, Brazil)'),
    ('BR-STE', 'BR-STE (Santa Teresa, Espírito Santo, Brazil)'),
    ('BR-STW', 'BR-STW (Santa Tereza do Oeste, Paraná, Brazil)'),
    ('BR-STZ', 'BR-STZ (Santa Terezinha, Mato Grosso, Brazil)'),
    ('BR-STG', 'BR-STG (Santa Terezinha de Goias, Goiás, Brazil)'),
    ('BR-STU', 'BR-STU (Santa Terezinha de Itaipu, Paraná, Brazil)'),
    ('BR-SVI', 'BR-SVI (Santa Vitoria, Minas Gerais, Brazil)'),
    ('BR-SVP', 'BR-SVP (Santa Vitória do Palmar, Rio Grande do Sul, Brazil)'),
    ('BR-STN', 'BR-STN (Santana, Amapá, Brazil)'),
    ('BR-SDP', 'BR-SDP (Santana de Parnaíba, São Paulo, Brazil)'),
    ('BR-SAG', 'BR-SAG (Santana do Araguaia, Pará, Brazil)'),
    ('BR-SDM', 'BR-SDM (Santana do Ipanema, Alagoas, Brazil)'),
    ('BR-SLI', 'BR-SLI (Santana do Livramento, Rio Grande do Sul, Brazil)'),
    ('BR-SNP', 'BR-SNP (Santana do Paraiso, Minas Gerais, Brazil)'),
    ('BR-SRC', 'BR-SRC (Santana do Riacho, Minas Gerais, Brazil)'),
    ('BR-MCP', 'BR-MCP (Santana Pt./Macapá, Amapá, Brazil)'),
    ('BR-STM', 'BR-STM (Santarém, Pará, Brazil)'),
    ('BR-SGO', 'BR-SGO (Santiago, Rio Grande do Sul, Brazil)'),
    ('BR-SAM', 'BR-SAM (Santo Amaro, Bahia, Brazil)'),
    ('BR-SRM', 'BR-SRM (Santo Amaro da Imperatriz, Santa Catarina, Brazil)'),
    ('BR-SUN', 'BR-SUN (Santo Anastacio, São Paulo, Brazil)'),
    ('BR-QSE', 'BR-QSE (Santo André, São Paulo, Brazil)'),
    ('BR-GEL', 'BR-GEL (Santo Angelo, Rio Grande do Sul, Brazil)'),
    ('BR-SPU', 'BR-SPU (Santo Antonio da Patrulha, Rio Grande do Sul, Brazil)'),
    ('BR-SPN', 'BR-SPN (Santo Antonio da Platina, Paraná, Brazil)'),
    ('BR-STJ', 'BR-STJ (Santo Antonio do Jardim, São Paulo, Brazil)'),
    ('BR-SPL', 'BR-SPL (Santo Antonio do Pinhal, São Paulo, Brazil)'),
    ('BR-SAV', 'BR-SAV (Santo Antonio Leverger, Mato Grosso, Brazil)'),
    ('BR-SAJ', 'BR-SAJ (Santo Antônio de Jesus, Bahia, Brazil)'),
    ('BR-SAS', 'BR-SAS (Santo Antônio de Posse, São Paulo, Brazil)'),
    ('BR-STA', 'BR-STA (Santo Antônio de Pádua, Rio de Janeiro, Brazil)'),
    ('BR-STP', 'BR-STP (Santo Antônio do Amparo, Minas Gerais, Brazil)'),
    ('BR-SAW', 'BR-SAW (Santo Antônio do Paraiso, Paraná, Brazil)'),
    ('BR-SCT', 'BR-SCT (Santo Cristo, Rio Grande do Sul, Brazil)'),
    ('BR-SET', 'BR-SET (Santo Estevao, Bahia, Brazil)'),
    ('BR-SSZ', 'BR-SSZ (Santos, São Paulo, Brazil)'),
    ('BR-SDO', 'BR-SDO (Santos Dumont, Minas Gerais, Brazil)'),
    ('BR-SDU', 'BR-SDU (Santos Dumont Apt/Rio de Janeiro, Rio de Janeiro, Brazil)'),
    ('BR-SBE', 'BR-SBE (Sao Benedito, Ceará, Brazil)'),
    ('BR-SBT', 'BR-SBT (Sao Bento, Paraíba, Brazil)'),
    ('BR-SBS', 'BR-SBS (Sao Bento do Sapucai, São Paulo, Brazil)'),
    ('BR-QSB', 'BR-QSB (Sao Bernardo do Campo, São Paulo, Brazil)'),
    ('BR-BJA', 'BR-BJA (Sao Borja, Rio Grande do Sul, Brazil)'),
    ('BR-QCX', 'BR-QCX (Sao Caetano do Sul, São Paulo, Brazil)'),
    ('BR-QSC', 'BR-QSC (Sao Carlos, São Paulo, Brazil)'),
    ('BR-SCL', 'BR-SCL (Sao Carlos, Santa Catarina, Brazil)'),
    ('BR-SCV', 'BR-SCV (Sao Cristovao, Sergipe, Brazil)'),
    ('BR-SFX', 'BR-SFX (Sao Felix, Bahia, Brazil)'),
    ('BR-SFG', 'BR-SFG (Sao Felix do Xingu, Pará, Brazil)'),
    ('BR-SFI', 'BR-SFI (Sao Fidelis, Rio de Janeiro, Brazil)'),
    ('BR-SFA', 'BR-SFA (Sao Francisco de Assis, Rio Grande do Sul, Brazil)'),
    ('BR-SFP', 'BR-SFP (Sao Francisco de Paula, Minas Gerais, Brazil)'),
    ('BR-SRP', 'BR-SRP (Sao Francisco de Paula, Rio Grande do Sul, Brazil)'),
    ('BR-SFN', 'BR-SFN (Sao Francisco do Conde, Bahia, Brazil)'),
    ('BR-SGA', 'BR-SGA (Sao Gabriel, Rio Grande do Sul, Brazil)'),
    ('BR-SJL', 'BR-SJL (Sao Gabriel da Cachoeira, Amazonas, Brazil)'),
    ('BR-SGP', 'BR-SGP (Sao Gabriel da Palha, Espírito Santo, Brazil)'),
    ('BR-SGS', 'BR-SGS (Sao Gabriel do Oeste, Mato Grosso do Sul, Brazil)'),
    ('BR-SGL', 'BR-SGL (Sao Geraldo, Minas Gerais, Brazil)'),
    ('BR-QSD', 'BR-QSD (Sao Goncalo, Rio de Janeiro, Brazil)'),
    ('BR-SGE', 'BR-SGE (Sao Goncalo do Amarante, Ceará, Brazil)'),
    ('BR-SGC', 'BR-SGC (Sao Goncalo dos Campos, Bahia, Brazil)'),
    ('BR-SGT', 'BR-SGT (Sao Gotardo, Minas Gerais, Brazil)'),
    ('BR-SJO', 'BR-SJO (Sao Jeronimo, Rio Grande do Sul, Brazil)'),
    ('BR-SJA', 'BR-SJA (Sao Joao da Alianca, Goiás, Brazil)'),
    ('BR-SJC', 'BR-SJC (Sao Joao do Caiua, Paraná, Brazil)'),
    ('BR-SJM', 'BR-SJM (Sao Joao do Meriti, Rio de Janeiro, Brazil)'),
    ('BR-SJN', 'BR-SJN (Sao Joao Nepomucemo, Minas Gerais, Brazil)'),
    ('BR-SJQ', 'BR-SJQ (Sao Joaquim, Santa Catarina, Brazil)'),
    ('BR-SJB', 'BR-SJB (Sao Joaquim da Barra, São Paulo, Brazil)'),
    ('BR-SJE', 'BR-SJE (Sao Jose, Santa Catarina, Brazil)'),
    ('BR-SSL', 'BR-SSL (Sao Jose da Lapa, Minas Gerais, Brazil)'),
    ('BR-SSM', 'BR-SSM (Sao Jose de Mipibo, Rio Grande do Norte, Brazil)'),
    ('BR-SJD', 'BR-SJD (Sao Jose do Cedro, Santa Catarina, Brazil)'),
    ('BR-SJR', 'BR-SJR (Sao Jose do Rio Claro, Mato Grosso, Brazil)'),
    ('BR-SRT', 'BR-SRT (Sao Jose do Vale Rio Preto, Rio de Janeiro, Brazil)'),
    ('BR-SJT', 'BR-SJT (Sao Jose dos Ausentes, Rio Grande do Sul, Brazil)'),
    ('BR-SQC', 'BR-SQC (Sao Jose Quatro Marcos, Mato Grosso, Brazil)'),
    ('BR-SJP', 'BR-SJP (Sao José do Rio Prêto, São Paulo, Brazil)'),
    ('BR-SJK', 'BR-SJK (Sao José dos Campos, São Paulo, Brazil)'),
    ('BR-SLM', 'BR-SLM (Sao Lourenco da Mata, Pernambuco, Brazil)'),
    ('BR-SLS', 'BR-SLS (Sao Lourenco da Serra, São Paulo, Brazil)'),
    ('BR-SLT', 'BR-SLT (Sao Lourenco do Oeste, Santa Catarina, Brazil)'),
    ('BR-SQY', 'BR-SQY (Sao Lourenço do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SLG', 'BR-SLG (Sao Ludgero, Santa Catarina, Brazil)'),
    ('BR-SMB', 'BR-SMB (Sao Luis de Montes Belos, Goiás, Brazil)'),
    ('BR-SLP', 'BR-SLP (Sao Luis do Paraitinga, São Paulo, Brazil)'),
    ('BR-SZG', 'BR-SZG (Sao Luiz Gonzaga, Rio Grande do Sul, Brazil)'),
    ('BR-SML', 'BR-SML (Sao Manuel, São Paulo, Brazil)'),
    ('BR-SMC', 'BR-SMC (Sao Marcos, Rio Grande do Sul, Brazil)'),
    ('BR-SMS', 'BR-SMS (Sao Mateus do Sul, Paraná, Brazil)'),
    ('BR-SMJ', 'BR-SMJ (Sao Miguel Arcanjo, São Paulo, Brazil)'),
    ('BR-SMI', 'BR-SMI (Sao Miguel das Missoes, Rio Grande do Sul, Brazil)'),
    ('BR-SQM', 'BR-SQM (Sao Miguel do Araguaia, Goiás, Brazil)'),
    ('BR-SMG', 'BR-SMG (Sao Miguel do Gostoso, Rio Grande do Norte, Brazil)'),
    ('BR-SMP', 'BR-SMP (Sao Miguel dos Campos, Alagoas, Brazil)'),
    ('BR-SUM', 'BR-SUM (Sao Miguel Milagres, Alagoas, Brazil)'),
    ('BR-SPV', 'BR-SPV (Sao Paulo de Olivenca, Amazonas, Brazil)'),
    ('BR-SPD', 'BR-SPD (Sao Pedro, São Paulo, Brazil)'),
    ('BR-SPE', 'BR-SPE (Sao Pedro Alcantara, Santa Catarina, Brazil)'),
    ('BR-SRL', 'BR-SRL (Sao Pedro da Aldeia, Rio de Janeiro, Brazil)'),
    ('BR-SDI', 'BR-SDI (Sao Pedro do Ivai, Paraná, Brazil)'),
    ('BR-SCU', 'BR-SCU (Sao Pedro do Suacui, Minas Gerais, Brazil)'),
    ('BR-SDS', 'BR-SDS (Sao Pedro do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SDT', 'BR-SDT (Sao Pedro do Turvo, São Paulo, Brazil)'),
    ('BR-SRN', 'BR-SRN (Sao Raimundo Nonato, Piauí, Brazil)'),
    ('BR-SRQ', 'BR-SRQ (Sao Roque, São Paulo, Brazil)'),
    ('BR-SQN', 'BR-SQN (Sao Roque de Minas, Minas Gerais, Brazil)'),
    ('BR-SQA', 'BR-SQA (Sao Roque do Canaa, Espírito Santo, Brazil)'),
    ('BR-SSG', 'BR-SSG (Sao Sebastiao da Grama, São Paulo, Brazil)'),
    ('BR-QHF', 'BR-QHF (Sao Sebastiao do Caí, Rio Grande do Sul, Brazil)'),
    ('BR-SSP', 'BR-SSP (Sao Sebastiao do Paraiso, Minas Gerais, Brazil)'),
    ('BR-SSE', 'BR-SSE (Sao Sepe, Rio Grande do Sul, Brazil)'),
    ('BR-SOS', 'BR-SOS (Sao Simao, São Paulo, Brazil)'),
    ('BR-SSI', 'BR-SSI (Sao Simao, Goiás, Brazil)'),
    ('BR-STL', 'BR-STL (Sao Tome das Letras, Minas Gerais, Brazil)'),
    ('BR-SAE', 'BR-SAE (Sape, Paraíba, Brazil)'),
    ('BR-SAU', 'BR-SAU (Sapeaçu, Bahia, Brazil)'),
    ('BR-SPZ', 'BR-SPZ (Sapezal, Mato Grosso, Brazil)'),
    ('BR-SAP', 'BR-SAP (Sapiranga, Rio Grande do Sul, Brazil)'),
    ('BR-SUS', 'BR-SUS (Sapucaia do Sul, Rio Grande do Sul, Brazil)'),
    ('BR-SPM', 'BR-SPM (Sapucaí-Mirim, Minas Gerais, Brazil)'),
    ('BR-SQR', 'BR-SQR (Saquarema, Rio de Janeiro, Brazil)'),
    ('BR-SND', 'BR-SND (Sarandi, Rio Grande do Sul, Brazil)'),
    ('BR-SNI', 'BR-SNI (Sarandi, Paraná, Brazil)'),
    ('BR-SVA', 'BR-SVA (Saranduva, Rio Grande do Sul, Brazil)'),
    ('BR-SRI', 'BR-SRI (Sarapuí, São Paulo, Brazil)'),
    ('BR-SGZ', 'BR-SGZ (Sardoa, Minas Gerais, Brazil)'),
    ('BR-SZD', 'BR-SZD (Sarzedo, Minas Gerais, Brazil)'),
    ('BR-SUD', 'BR-SUD (Saudades, Santa Catarina, Brazil)'),
    ('BR-SDE', 'BR-SDE (Schroeder, Santa Catarina, Brazil)'),
    ('BR-SEB', 'BR-SEB (Seabra, Bahia, Brazil)'),
    ('BR-SLJ', 'BR-SLJ (Sebastião Laranjeiras, Bahia, Brazil)'),
    ('BR-SBH', 'BR-SBH (Selbach, Rio Grande do Sul, Brazil)'),
    ('BR-SMA', 'BR-SMA (Sena Madureira, Acre, Brazil)'),
    ('BR-SEC', 'BR-SEC (Senador Canedo, Goiás, Brazil)'),
    ('BR-SEI', 'BR-SEI (Senhor do Bonfim, Bahia, Brazil)'),
    ('BR-SOI', 'BR-SOI (Senhora de Oliveira, Minas Gerais, Brazil)'),
    ('BR-STS', 'BR-STS (Sento Sé, Bahia, Brazil)'),
    ('BR-SCE', 'BR-SCE (Serafina Correa, Rio Grande do Sul, Brazil)'),
    ('BR-SDC', 'BR-SDC (Seropedica, Rio de Janeiro, Brazil)'),
    ('BR-SER', 'BR-SER (Serra, Espírito Santo, Brazil)'),
    ('BR-SST', 'BR-SST (Serra do Salitre, Minas Gerais, Brazil)'),
    ('BR-SNG', 'BR-SNG (Serra Negra, São Paulo, Brazil)'),
    ('BR-STD', 'BR-STD (Serra Talhada, Pernambuco, Brazil)'),
    ('BR-SNA', 'BR-SNA (Serrana, São Paulo, Brazil)'),
    ('BR-SIA', 'BR-SIA (Serrania, Minas Gerais, Brazil)'),
    ('BR-SNO', 'BR-SNO (Serranopolis, Goiás, Brazil)'),
    ('BR-SHA', 'BR-SHA (Serrinha, Bahia, Brazil)'),
    ('BR-SEO', 'BR-SEO (Serro, Minas Gerais, Brazil)'),
    ('BR-SNS', 'BR-SNS (Sertanopolis, Paraná, Brazil)'),
    ('BR-SZO', 'BR-SZO (Sertãozinho, São Paulo, Brazil)'),
    ('BR-SBA', 'BR-SBA (Sete Barras, São Paulo, Brazil)'),
    ('BR-QHG', 'BR-QHG (Sete Lagoas, Minas Gerais, Brazil)'),
    ('BR-SVE', 'BR-SVE (Severinia, São Paulo, Brazil)'),
    ('BR-SIS', 'BR-SIS (Siderópolis, Santa Catarina, Brazil)'),
    ('BR-SLD', 'BR-SLD (Sidrolandia, Mato Grosso do Sul, Brazil)'),
    ('BR-SIV', 'BR-SIV (Silves, Amazonas, Brazil)'),
    ('BR-SVL', 'BR-SVL (Silvianopolis, Minas Gerais, Brazil)'),
    ('BR-SOP', 'BR-SOP (Simao Pereira, Minas Gerais, Brazil)'),
    ('BR-SSF', 'BR-SSF (Simoes Filho, Bahia, Brazil)'),
    ('BR-SIM', 'BR-SIM (Simplício Mendes, Piauí, Brazil)'),
    ('BR-SID', 'BR-SID (Simão Dias, Sergipe, Brazil)'),
    ('BR-SBU', 'BR-SBU (Sinimbu, Santa Catarina, Brazil)'),
    ('BR-OPS', 'BR-OPS (Sinop, Mato Grosso, Brazil)'),
    ('BR-SQP', 'BR-SQP (Siqueira Campos, Paraná, Brazil)'),
    ('BR-SNE', 'BR-SNE (Sirinhaem, Pernambuco, Brazil)'),
    ('BR-STC', 'BR-STC (Sitio do Conde, Bahia, Brazil)'),
    ('BR-QBX', 'BR-QBX (Sobral, Ceará, Brazil)'),
    ('BR-SBL', 'BR-SBL (Sobralia, Minas Gerais, Brazil)'),
    ('BR-SOC', 'BR-SOC (Socorro, São Paulo, Brazil)'),
    ('BR-SDA', 'BR-SDA (Soledade, Rio Grande do Sul, Brazil)'),
    ('BR-SBI', 'BR-SBI (Sombrio, Santa Catarina, Brazil)'),
    ('BR-SOA', 'BR-SOA (Sonora, Mato Grosso do Sul, Brazil)'),
    ('BR-SOR', 'BR-SOR (Sooretama, Espírito Santo, Brazil)'),
    ('BR-SOD', 'BR-SOD (Sorocaba, São Paulo, Brazil)'),
    ('BR-SOO', 'BR-SOO (Sorriso, Mato Grosso, Brazil)'),
    ('BR-SFK', 'BR-SFK (Soure, Pará, Brazil)'),
    ('BR-SOU', 'BR-SOU (Sousa, Paraíba, Brazil)'),
    ('BR-SUA', 'BR-SUA (Suape, Pernambuco, Brazil)'),
    ('BR-SMU', 'BR-SMU (Sud Mennucci, São Paulo, Brazil)'),
    ('BR-SME', 'BR-SME (Sumaré, São Paulo, Brazil)'),
    ('BR-SMD', 'BR-SMD (Sumidouro, Rio de Janeiro, Brazil)'),
    ('BR-SRB', 'BR-SRB (Surubim, Pernambuco, Brazil)'),
    ('BR-SZN', 'BR-SZN (Suzano, São Paulo, Brazil)'),
    ('BR-SRD', 'BR-SRD (Sátiro Dias, Bahia, Brazil)'),
    ('BR-SBN', 'BR-SBN (São Bento do Norte, Rio Grande do Norte, Brazil)'),
    ('BR-SCI', 'BR-SCI (São Carlos do Ivaí, Paraná, Brazil)'),
    ('BR-SDD', 'BR-SDD (São Desidério, Bahia, Brazil)'),
    ('BR-SDN', 'BR-SDN (São Domingos do Norte, Espírito Santo, Brazil)'),
    ('BR-SFC', 'BR-SFC (São Francisco, São Paulo, Brazil)'),
    ('BR-SFS', 'BR-SFS (São Francisco do Sul, Santa Catarina, Brazil)'),
    ('BR-SXO', 'BR-SXO (São Félix do Araguaia, Mato Grosso, Brazil)'),
    ('BR-SAZ', 'BR-SAZ (São Gonçalo do Amarante, Rio Grande do Norte, Brazil)'),
    ('BR-SDR', 'BR-SDR (São Gonçalo do Rio Abaixo, Minas Gerais, Brazil)'),
    ('BR-SBC', 'BR-SBC (São Joaquim de Bicas, Minas Gerais, Brazil)'),
    ('BR-SZB', 'BR-SZB (São José da Barra, Minas Gerais, Brazil)'),
    ('BR-SJH', 'BR-SJH (São José da Laje, Alagoas, Brazil)'),
    ('BR-SDJ', 'BR-SDJ (São José do Jacuri, Minas Gerais, Brazil)'),
    ('BR-SNN', 'BR-SNN (São José do Norte, Rio Grande do Sul, Brazil)'),
    ('BR-SJS', 'BR-SJS (São José dos Pinhais, Paraná, Brazil)'),
    ('BR-SJW', 'BR-SJW (São João Batista, Santa Catarina, Brazil)'),
    ('BR-SJG', 'BR-SJG (São João da Araguaia, Pará, Brazil)'),
    ('BR-SDB', 'BR-SDB (São João da Barra, Rio de Janeiro, Brazil)'),
    ('BR-SBV', 'BR-SBV (São João da Boa Vista, São Paulo, Brazil)'),
    ('BR-SPI', 'BR-SPI (São João de Pirabas, Pará, Brazil)'),
    ('BR-SJI', 'BR-SJI (São João del Rei, Minas Gerais, Brazil)'),
    ('BR-SLO', 'BR-SLO (São Leopoldo, Rio Grande do Sul, Brazil)'),
    ('BR-SLZ', 'BR-SLZ (São Luís, Maranhão, Brazil)'),
    ('BR-SLQ', 'BR-SLQ (São Luís do Quitunde, Alagoas, Brazil)'),
    ('BR-SBJ', 'BR-SBJ (São Mateus, Espírito Santo, Brazil)'),
    ('BR-SMZ', "BR-SMZ (São Miguel d'Oeste, Santa Catarina, Brazil)"),
    ('BR-SAO', 'BR-SAO (São Paulo, São Paulo, Brazil)'),
    ('BR-SSO', 'BR-SSO (São Sebastião, São Paulo, Brazil)'),
    ('BR-SPA', 'BR-SPA (São Sebastião do Passé, Bahia, Brazil)'),
    ('BR-STI', 'BR-STI (São Tiago, Minas Gerais, Brazil)'),
    ('BR-STQ', 'BR-STQ (São Tomás de Aquino, Minas Gerais, Brazil)'),
    ('BR-SOM', 'BR-SOM (São Tomé, Paraná, Brazil)'),
    ('BR-SVT', 'BR-SVT (São Vicente, São Paulo, Brazil)'),
    ('BR-TPU', 'BR-TPU (Tabapua, São Paulo, Brazil)'),
    ('BR-TBT', 'BR-TBT (Tabatinga, Amazonas, Brazil)'),
    ('BR-TSA', 'BR-TSA (Taboao da Serra, São Paulo, Brazil)'),
    ('BR-TBV', 'BR-TBV (Tabocas do Brejo Velho, Bahia, Brazil)'),
    ('BR-TNO', 'BR-TNO (Tabuleiro do Norte, Ceará, Brazil)'),
    ('BR-TLD', 'BR-TLD (Tailândia, Pará, Brazil)'),
    ('BR-TAI', 'BR-TAI (Taio, Santa Catarina, Brazil)'),
    ('BR-TBE', 'BR-TBE (Taiobeiras, Minas Gerais, Brazil)'),
    ('BR-TUV', 'BR-TUV (Taiuva, São Paulo, Brazil)'),
    ('BR-TMA', 'BR-TMA (Tamandare, Pernambuco, Brazil)'),
    ('BR-TMN', 'BR-TMN (Tamarana, Paraná, Brazil)'),
    ('BR-TBU', 'BR-TBU (Tambau, São Paulo, Brazil)'),
    ('BR-TBO', 'BR-TBO (Tamboara, Paraná, Brazil)'),
    ('BR-TNA', 'BR-TNA (Tanabi, São Paulo, Brazil)'),
    ('BR-TNE', 'BR-TNE (Tancredo Neves, Pará, Brazil)'),
    ('BR-TGR', 'BR-TGR (Tangara, Santa Catarina, Brazil)'),
    ('BR-TGQ', 'BR-TGQ (Tangará da Serra, Mato Grosso, Brazil)'),
    ('BR-TAG', 'BR-TAG (Tanguá, Rio de Janeiro, Brazil)'),
    ('BR-TAJ', 'BR-TAJ (Tapejara, Rio Grande do Sul, Brazil)'),
    ('BR-TPJ', 'BR-TPJ (Tapejara, Paraná, Brazil)'),
    ('BR-TPE', 'BR-TPE (Tapera, Rio Grande do Sul, Brazil)'),
    ('BR-TPR', 'BR-TPR (Taperoá, Bahia, Brazil)'),
    ('BR-TAP', 'BR-TAP (Tapes, Rio Grande do Sul, Brazil)'),
    ('BR-TPA', 'BR-TPA (Tapirai, São Paulo, Brazil)'),
    ('BR-TTA', 'BR-TTA (Tapiratiba, São Paulo, Brazil)'),
    ('BR-TQU', 'BR-TQU (Taquara, Rio Grande do Sul, Brazil)'),
    ('BR-TAQ', 'BR-TAQ (Taquari, Rio Grande do Sul, Brazil)'),
    ('BR-TQA', 'BR-TQA (Taquaritinga, São Paulo, Brazil)'),
    ('BR-TQN', 'BR-TQN (Taquaritinga do Norte, Pernambuco, Brazil)'),
    ('BR-TQB', 'BR-TQB (Taquarituba, São Paulo, Brazil)'),
    ('BR-TRQ', 'BR-TRQ (Tarauacá, Acre, Brazil)'),
    ('BR-TRU', 'BR-TRU (Taruma, São Paulo, Brazil)'),
    ('BR-TAT', 'BR-TAT (Tatui, São Paulo, Brazil)'),
    ('BR-TAU', 'BR-TAU (Taua, Ceará, Brazil)'),
    ('BR-TBA', 'BR-TBA (Taubate, São Paulo, Brazil)'),
    ('BR-TVR', 'BR-TVR (Tavares, Rio Grande do Sul, Brazil)'),
    ('BR-TFF', 'BR-TFF (Tefé, Amazonas, Brazil)'),
    ('BR-TXF', 'BR-TXF (Teixeira de Freitas, Bahia, Brazil)'),
    ('BR-TEC', 'BR-TEC (Telêmaco Borba, Paraná, Brazil)'),
    ('BR-TPO', 'BR-TPO (Tenente Portela, Rio Grande do Sul, Brazil)'),
    ('BR-TSO', 'BR-TSO (Teodoro Sampaio, São Paulo, Brazil)'),
    ('BR-TRE', 'BR-TRE (Terenos, Mato Grosso do Sul, Brazil)'),
    ('BR-THE', 'BR-THE (Teresina, Piauí, Brazil)'),
    ('BR-QHT', 'BR-QHT (Teresópolis, Rio de Janeiro, Brazil)'),
    ('BR-TRB', 'BR-TRB (Terra Boa, Paraná, Brazil)'),
    ('BR-TAR', 'BR-TAR (Terra de Areia, Rio Grande do Sul, Brazil)'),
    ('BR-TNV', 'BR-TNV (Terra Nova, Bahia, Brazil)'),
    ('BR-TRO', 'BR-TRO (Terra Roxa, Paraná, Brazil)'),
    ('BR-TRX', 'BR-TRX (Terra Roxa, São Paulo, Brazil)'),
    ('BR-TEU', 'BR-TEU (Teutônia, Rio Grande do Sul, Brazil)'),
    ('BR-TFL', 'BR-TFL (Teófilo Otoni, Minas Gerais, Brazil)'),
    ('BR-TGA', 'BR-TGA (Tianguá, Ceará, Brazil)'),
    ('BR-TGI', 'BR-TGI (Tibagi, Paraná, Brazil)'),
    ('BR-TBS', 'BR-TBS (Tibau do Sul, Rio Grande do Norte, Brazil)'),
    ('BR-TIE', 'BR-TIE (Tiete, São Paulo, Brazil)'),
    ('BR-TJS', 'BR-TJS (Tijuca do Sul, Paraná, Brazil)'),
    ('BR-TJA', 'BR-TJA (Tijucas, Santa Catarina, Brazil)'),
    ('BR-TMB', 'BR-TMB (Timbauba, Pernambuco, Brazil)'),
    ('BR-TMO', 'BR-TMO (Timbó, Santa Catarina, Brazil)'),
    ('BR-TIM', 'BR-TIM (Timon, Maranhão, Brazil)'),
    ('BR-TTO', 'BR-TTO (Timoteo, Minas Gerais, Brazil)'),
    ('BR-TDE', 'BR-TDE (Tiradentes, Minas Gerais, Brazil)'),
    ('BR-TCT', 'BR-TCT (Tocantins, Minas Gerais, Brazil)'),
    ('BR-TOW', 'BR-TOW (Toledo, Paraná, Brazil)'),
    ('BR-TMS', 'BR-TMS (Tombos, Minas Gerais, Brazil)'),
    ('BR-TAC', 'BR-TAC (Tome-Acu, Pará, Brazil)'),
    ('BR-TRT', 'BR-TRT (Toritama, Pernambuco, Brazil)'),
    ('BR-TSQ', 'BR-TSQ (Torres, Rio Grande do Sul, Brazil)'),
    ('BR-THA', 'BR-THA (Torrinha, São Paulo, Brazil)'),
    ('BR-TOS', 'BR-TOS (Touros, Rio Grande do Norte, Brazil)'),
    ('BR-TCU', 'BR-TCU (Tracunhaem, Pernambuco, Brazil)'),
    ('BR-TRI', 'BR-TRI (Trairi, Ceará, Brazil)'),
    ('BR-TRM', 'BR-TRM (Tramandaí, Rio Grande do Sul, Brazil)'),
    ('BR-TCO', 'BR-TCO (Trancoso, Bahia, Brazil)'),
    ('BR-TME', 'BR-TME (Tremembe, São Paulo, Brazil)'),
    ('BR-TRS', 'BR-TRS (Tres Barras, Santa Catarina, Brazil)'),
    ('BR-TMI', 'BR-TMI (Tres de Maio, Rio Grande do Sul, Brazil)'),
    ('BR-TLG', 'BR-TLG (Tres Lagoas, Mato Grosso do Sul, Brazil)'),
    ('BR-TMR', 'BR-TMR (Tres Marias, Minas Gerais, Brazil)'),
    ('BR-TPS', 'BR-TPS (Tres Passos, Rio Grande do Sul, Brazil)'),
    ('BR-TRP', 'BR-TRP (Tres Pontas, Minas Gerais, Brazil)'),
    ('BR-TRR', 'BR-TRR (Tres Ranchos, Goiás, Brazil)'),
    ('BR-TRZ', 'BR-TRZ (Treze de Maio, Santa Catarina, Brazil)'),
    ('BR-TZT', 'BR-TZT (Treze Tilias, Santa Catarina, Brazil)'),
    ('BR-TIN', 'BR-TIN (Trindade, Goiás, Brazil)'),
    ('BR-TFO', 'BR-TFO (Triunfo, Rio Grande do Sul, Brazil)'),
    ('BR-TMT', 'BR-TMT (Trombetas, Pará, Brazil)'),
    ('BR-QID', 'BR-QID (Três Coraçoes, Minas Gerais, Brazil)'),
    ('BR-ROA', 'BR-ROA (Três Coroas, Rio Grande do Sul, Brazil)'),
    ('BR-TUB', 'BR-TUB (Tubarão Pt./Vitória, Espírito Santo, Brazil)'),
    ('BR-TUZ', 'BR-TUZ (Tucuma, Pará, Brazil)'),
    ('BR-TVU', 'BR-TVU (Tucuruvi, Pará, Brazil)'),
    ('BR-TUR', 'BR-TUR (Tucuruí, Pará, Brazil)'),
    ('BR-TUN', 'BR-TUN (Tunas, Paraná, Brazil)'),
    ('BR-TUP', 'BR-TUP (Tupa, São Paulo, Brazil)'),
    ('BR-TCI', 'BR-TCI (Tupaciguara, Minas Gerais, Brazil)'),
    ('BR-TPC', 'BR-TPC (Tupancireta, Rio Grande do Sul, Brazil)'),
    ('BR-TUI', 'BR-TUI (Tupandi, Rio Grande do Sul, Brazil)'),
    ('BR-TDI', 'BR-TDI (Tuparendi, Rio Grande do Sul, Brazil)'),
    ('BR-TIP', 'BR-TIP (Tupi Paulista, São Paulo, Brazil)'),
    ('BR-TVG', 'BR-TVG (Turvo, Paraná, Brazil)'),
    ('BR-TVO', 'BR-TVO (Turvo, Santa Catarina, Brazil)'),
    ('BR-TVA', 'BR-TVA (Turvânia, Goiás, Brazil)'),
    ('BR-TUT', 'BR-TUT (Tutóia, Maranhão, Brazil)'),
    ('BR-UAU', 'BR-UAU (Uaua, Bahia, Brazil)'),
    ('BR-UBQ', 'BR-UBQ (Uba, Minas Gerais, Brazil)'),
    ('BR-UTA', 'BR-UTA (Ubaitaba, Bahia, Brazil)'),
    ('BR-UBJ', 'BR-UBJ (Ubajara, Ceará, Brazil)'),
    ('BR-UTB', 'BR-UTB (Ubata, Bahia, Brazil)'),
    ('BR-UBT', 'BR-UBT (Ubatuba, São Paulo, Brazil)'),
    ('BR-UBA', 'BR-UBA (Uberaba, Minas Gerais, Brazil)'),
    ('BR-UDI', 'BR-UDI (Uberlândia, Minas Gerais, Brazil)'),
    ('BR-UJR', 'BR-UJR (Ubirajara, São Paulo, Brazil)'),
    ('BR-UBI', 'BR-UBI (Ubirata, Paraná, Brazil)'),
    ('BR-UCH', 'BR-UCH (Uchoa, São Paulo, Brazil)'),
    ('BR-UMU', 'BR-UMU (Umuarama, Paraná, Brazil)'),
    ('BR-UNA', 'BR-UNA (Una, Bahia, Brazil)'),
    ('BR-UNI', 'BR-UNI (Unai, Minas Gerais, Brazil)'),
    ('BR-UPA', 'BR-UPA (Uniao dos Palmares, Alagoas, Brazil)'),
    ('BR-URA', 'BR-URA (Urai, Paraná, Brazil)'),
    ('BR-URU', 'BR-URU (Uruacu, Goiás, Brazil)'),
    ('BR-UBC', 'BR-UBC (Urubici, Santa Catarina, Brazil)'),
    ('BR-URB', 'BR-URB (Urubupunga, São Paulo, Brazil)'),
    ('BR-URG', 'BR-URG (Uruguaiana, Rio Grande do Sul, Brazil)'),
    ('BR-UPE', 'BR-UPE (Urupes, São Paulo, Brazil)'),
    ('BR-USS', 'BR-USS (Urussanga, Santa Catarina, Brazil)'),
    ('BR-URC', 'BR-URC (Uruçuí, Piauí, Brazil)'),
    ('BR-VAC', 'BR-VAC (Vacaria, Rio Grande do Sul, Brazil)'),
    ('BR-VSO', 'BR-VSO (Vale do Sol, Rio Grande do Sul, Brazil)'),
    ('BR-VAL', 'BR-VAL (Valenca, Bahia, Brazil)'),
    ('BR-VLA', 'BR-VLA (Valenca, Rio de Janeiro, Brazil)'),
    ('BR-VLT', 'BR-VLT (Valente, Bahia, Brazil)'),
    ('BR-VAH', 'BR-VAH (Valinhos, São Paulo, Brazil)'),
    ('BR-VPO', 'BR-VPO (Valparaiso, São Paulo, Brazil)'),
    ('BR-VGO', 'BR-VGO (Valparaiso de Goias, Goiás, Brazil)'),
    ('BR-VBO', 'BR-VBO (Vargem Bonita, Santa Catarina, Brazil)'),
    ('BR-VGA', 'BR-VGA (Vargem Grande, Rio de Janeiro, Brazil)'),
    ('BR-VGS', 'BR-VGS (Vargem Grande do Sul, São Paulo, Brazil)'),
    ('BR-VGP', 'BR-VGP (Vargem Grande Paulista, São Paulo, Brazil)'),
    ('BR-VAG', 'BR-VAG (Varginha, Minas Gerais, Brazil)'),
    ('BR-VJO', 'BR-VJO (Varjota, Ceará, Brazil)'),
    ('BR-VPM', 'BR-VPM (Varzea da Palma, Minas Gerais, Brazil)'),
    ('BR-VGR', 'BR-VGR (Varzea Grande, Mato Grosso, Brazil)'),
    ('BR-VPU', 'BR-VPU (Varzea Paulista, São Paulo, Brazil)'),
    ('BR-VAS', 'BR-VAS (Vassouras, Rio de Janeiro, Brazil)'),
    ('BR-VZA', 'BR-VZA (Vazante, Minas Gerais, Brazil)'),
    ('BR-VCE', 'BR-VCE (Venancio Aires, Rio Grande do Sul, Brazil)'),
    ('BR-VNI', 'BR-VNI (Venda Nova do Imigrante, Espírito Santo, Brazil)'),
    ('BR-VET', 'BR-VET (Ventania, Paraná, Brazil)'),
    ('BR-VER', 'BR-VER (Vera, Mato Grosso, Brazil)'),
    ('BR-VCZ', 'BR-VCZ (Vera Cruz, Rio Grande do Norte, Brazil)'),
    ('BR-VRC', 'BR-VRC (Vera Cruz, São Paulo, Brazil)'),
    ('BR-VZC', 'BR-VZC (Vera Cruz, Bahia, Brazil)'),
    ('BR-VOP', 'BR-VOP (Veranopolis, Rio Grande do Sul, Brazil)'),
    ('BR-VSA', 'BR-VSA (Vespasiano, Minas Gerais, Brazil)'),
    ('BR-VMA', 'BR-VMA (Viamao, Rio Grande do Sul, Brazil)'),
    ('BR-VNA', 'BR-VNA (Viana, Espírito Santo, Brazil)'),
    ('BR-VPS', 'BR-VPS (Vianopolis, Goiás, Brazil)'),
    ('BR-VIS', 'BR-VIS (Vicosa, Minas Gerais, Brazil)'),
    ('BR-VRA', 'BR-VRA (Vidal Ramos, Santa Catarina, Brazil)'),
    ('BR-VIA', 'BR-VIA (Videira, Santa Catarina, Brazil)'),
    ('BR-VDC', 'BR-VDC (Vila do Conde Pt/Barcarena, Pará, Brazil)'),
    ('BR-VLI', 'BR-VLI (Vila Livieira, São Paulo, Brazil)'),
    ('BR-VPP', 'BR-VPP (Vila Propício, Goiás, Brazil)'),
    ('BR-VLP', 'BR-VLP (Vila Rica, Mato Grosso, Brazil)'),
    ('BR-VVE', 'BR-VVE (Vila Velha, Espírito Santo, Brazil)'),
    ('BR-VHA', 'BR-VHA (Vilhena, Rondônia, Brazil)'),
    ('BR-VIN', 'BR-VIN (Vinhedo, São Paulo, Brazil)'),
    ('BR-VCP', 'BR-VCP (Viracopos Apt/Sao Paolo, São Paulo, Brazil)'),
    ('BR-VDO', 'BR-VDO (Viradouro, São Paulo, Brazil)'),
    ('BR-VGL', 'BR-VGL (Virgem da Lapa, Minas Gerais, Brazil)'),
    ('BR-VIG', 'BR-VIG (Virginópolis, Minas Gerais, Brazil)'),
    ('BR-VID', 'BR-VID (Virmond, Paraná, Brazil)'),
    ('BR-VRB', 'BR-VRB (Visconde do Rio Branco, Minas Gerais, Brazil)'),
    ('BR-VAA', 'BR-VAA (Vista Alegra do Alto, São Paulo, Brazil)'),
    ('BR-VSE', 'BR-VSE (Vista Serrana, Paraíba, Brazil)'),
    ('BR-VAJ', 'BR-VAJ (Vitoria do Jari, Amapá, Brazil)'),
    ('BR-VIT', 'BR-VIT (Vitória, Espírito Santo, Brazil)'),
    ('BR-VCA', 'BR-VCA (Vitória da Conquista, Bahia, Brazil)'),
    ('BR-VDS', 'BR-VDS (Vitória de Santo Antão, Pernambuco, Brazil)'),
    ('BR-VIX', 'BR-VIX (Vitória Pt, Espírito Santo, Brazil)'),
    ('BR-QVR', 'BR-QVR (Volta Redonda, Rio de Janeiro, Brazil)'),
    ('BR-VTM', 'BR-VTM (Votorantim, São Paulo, Brazil)'),
    ('BR-VOT', 'BR-VOT (Votuporanga, São Paulo, Brazil)'),
    ('BR-WAN', 'BR-WAN (Wanderlândia, Tocantins, Brazil)'),
    ('BR-WBZ', 'BR-WBZ (Wenceslau Braz, Paraná, Brazil)'),
    ('BR-WGR', 'BR-WGR (Wenceslau Guimarães, Bahia, Brazil)'),
    ('BR-WTF', 'BR-WTF (Westfália, Rio Grande do Sul, Brazil)'),
    ('BR-WIT', 'BR-WIT (Witmarsum, Santa Catarina, Brazil)'),
    ('BR-XGA', 'BR-XGA (Xangrila, Rio Grande do Sul, Brazil)'),
    ('BR-XAX', 'BR-XAX (Xaxim, Santa Catarina, Brazil)'),
    ('BR-XIG', 'BR-XIG (Xinguara, Pará, Brazil)'),
    ('BR-XQI', 'BR-XQI (Xique-Xique, Bahia, Brazil)'),
    ('BR-ABO', 'BR-ABO (Água Boa, Minas Gerais, Brazil)'),
    ('BR-AVH', 'BR-AVH (Águas Vermelhas, Minas Gerais, Brazil)'),
    ('BR-OLE', 'BR-OLE (Óleo, São Paulo, Brazil)'),
    ('BS-ASD', 'BS-ASD (Andros Town, Andros Island, Bahamas)'),
    ('BS-ATC', "BS-ATC (Arthur's Town, Cat Island, Bahamas)"),
    ('BS-CCZ', 'BS-CCZ (Chub Cay, Berry Islands, Bahamas)'),
    ('BS-FPO', 'BS-FPO (Freeport, Grand Bahama, Bahamas)'),
    ('BS-GGT', 'BS-GGT (George Town, Great Exuma Island, Bahamas)'),
    ('BS-GHB', 'BS-GHB (Governors Harbour, Eleuthera, Bahamas)'),
    ('BS-TCB', 'BS-TCB (Treasure Cay, Great Abaco Island, Bahamas)'),
    ('BS-BIM', 'BS-BIM (Bimini, Bahamas)'),
    ('BS-BKC', 'BS-BKC (Bock Cay, Bahamas)'),
    ('BS-CEL', 'BS-CEL (Cape Eleuthera, Bahamas)'),
    ('BS-CXY', 'BS-CXY (Cat Cays, Bahamas)'),
    ('BS-CAT', 'BS-CAT (Cat Island, Bahamas)'),
    ('BS-CLP', 'BS-CLP (Clifton Point, Bahamas)'),
    ('BS-CBT', 'BS-CBT (Cockburn Town, Bahamas)'),
    ('BS-COX', 'BS-COX (Congo Town, Bahamas)'),
    ('BS-CRI', 'BS-CRI (Crooked Island, Bahamas)'),
    ('BS-LGI', 'BS-LGI (Deadmans Cay, Bahamas)'),
    ('BS-DCT', 'BS-DCT (Duncan Town, Bahamas)'),
    ('BS-ELE', 'BS-ELE (Eleuthera Island, Bahamas)'),
    ('BS-GOC', 'BS-GOC (Gorda Cay, Bahamas)'),
    ('BS-GBI', 'BS-GBI (Grand Bahama, Bahamas)'),
    ('BS-EXU', 'BS-EXU (Great Exuma Island, Bahamas)'),
    ('BS-GHC', 'BS-GHC (Great Harbour Cay, Bahamas)'),
    ('BS-GSC', 'BS-GSC (Great Stirrup Cay, Bahamas)'),
    ('BS-GTC', 'BS-GTC (Green Turtle Cay, Bahamas)'),
    ('BS-HBI', 'BS-HBI (Harbour Island, Bahamas)'),
    ('BS-IGA', 'BS-IGA (Inagua, Bahamas)'),
    ('BS-HMC', 'BS-HMC (Little San Salvador, Bahamas)'),
    ('BS-COC', 'BS-COC (Little Stirrup Cay, Bahamas)'),
    ('BS-LUC', 'BS-LUC (Lucaya, Bahamas)'),
    ('BS-LYC', 'BS-LYC (Lyford Cay, Bahamas)'),
    ('BS-MAY', 'BS-MAY (Mangrove Cay Apt, Bahamas)'),
    ('BS-MHH', 'BS-MHH (Marsh Harbour, Bahamas)'),
    ('BS-MSK', 'BS-MSK (Mastic Point Apt, Bahamas)'),
    ('BS-MAT', 'BS-MAT (Matthew Town, Bahamas)'),
    ('BS-MYG', 'BS-MYG (Mayaguana Island, Bahamas)'),
    ('BS-NAS', 'BS-NAS (Nassau, Bahamas)'),
    ('BS-NET', 'BS-NET (New Bight, Bahamas)'),
    ('BS-NMC', "BS-NMC (Norman's Cay, Bahamas)"),
    ('BS-ELH', 'BS-ELH (North Eleuthera, Bahamas)'),
    ('BS-OCE', 'BS-OCE (Ocean Cay, Bahamas)'),
    ('BS-PID', 'BS-PID (Paradise Island, Bahamas)'),
    ('BS-PWN', 'BS-PWN (Pitts Town, Bahamas)'),
    ('BS-PPO', 'BS-PPO (Powell Point, Bahamas)'),
    ('BS-RSD', 'BS-RSD (Rock Sound, Bahamas)'),
    ('BS-RCY', 'BS-RCY (Rum Cay, Bahamas)'),
    ('BS-SAQ', 'BS-SAQ (San Andros, Bahamas)'),
    ('BS-ZSA', 'BS-ZSA (San Salvador Island, Bahamas)'),
    ('BS-WZY', 'BS-WZY (Seaplane Base, Bahamas)'),
    ('BS-TZN', 'BS-TZN (South Andros, Bahamas)'),
    ('BS-SRP', 'BS-SRP (South Riding Point, Bahamas)'),
    ('BS-SWL', 'BS-SWL (Spanish Wells, Bahamas)'),
    ('BS-AXP', 'BS-AXP (Spring Point, Bahamas)'),
    ('BS-TYM', 'BS-TYM (Staniel Cay, Bahamas)'),
    ('BS-SML', 'BS-SML (Stella Maris, Bahamas)'),
    ('BS-TBI', 'BS-TBI (The Bight, Bahamas)'),
    ('BS-WKR', "BS-WKR (Walker's Cay, Bahamas)"),
    ('BS-WTD', 'BS-WTD (West End, Bahamas)'),
    ('BT-PBH', 'BT-PBH (Paro, Bhutan)'),
    ('BT-PHU', 'BT-PHU (Phuntsholing, Bhutan)'),
    ('BT-THI', 'BT-THI (Thimpbu, Bhutan)'),
    ('BW-DUK', 'BW-DUK (Dukwi, Botswana)'),
    ('BW-FRW', 'BW-FRW (Francistown, Botswana)'),
    ('BW-GAB', 'BW-GAB (Gaberones Camp, Botswana)'),
    ('BW-GBE', 'BW-GBE (Gaborone, Botswana)'),
    ('BW-GNZ', 'BW-GNZ (Ghanzi, Botswana)'),
    ('BW-HUK', 'BW-HUK (Hukuntsi, Botswana)'),
    ('BW-JWA', 'BW-JWA (Jwaneng, Botswana)'),
    ('BW-BBK', 'BW-BBK (Kasane, Botswana)'),
    ('BW-KHW', 'BW-KHW (Khwai River Lodge, Botswana)'),
    ('BW-LET', 'BW-LET (Letlhakane, Botswana)'),
    ('BW-LOQ', 'BW-LOQ (Lobatse, Botswana)'),
    ('BW-MAH', 'BW-MAH (Mahalapye, Botswana)'),
    ('BW-MUB', 'BW-MUB (Maun, Botswana)'),
    ('BW-MGS', 'BW-MGS (Mogoditshane, Botswana)'),
    ('BW-ORP', 'BW-ORP (Orapa, Botswana)'),
    ('BW-PAL', 'BW-PAL (Palapye, Botswana)'),
    ('BW-RSA', 'BW-RSA (Ramotswa, Botswana)'),
    ('BW-SVT', 'BW-SVT (Savuti, Botswana)'),
    ('BW-PKW', 'BW-PKW (Selebi-Phikwe, Botswana)'),
    ('BW-SER', 'BW-SER (Serowe, Botswana)'),
    ('BW-SWX', 'BW-SWX (Shakawe, Botswana)'),
    ('BW-SXN', 'BW-SXN (Suapan, Botswana)'),
    ('BW-SUN', 'BW-SUN (Sunnyside, Botswana)'),
    ('BW-TBY', 'BW-TBY (Tsabong, Botswana)'),
    ('BW-TLD', 'BW-TLD (Tuli Lodge, Botswana)'),
    ('BY-BNV', 'BY-BNV (Baranovichi, Belarus)'),
    ('BY-BAR', 'BY-BAR (Barysaw, Belarus)'),
    ('BY-BER', 'BY-BER (Berëza, Belarus)'),
    ('BY-BZA', 'BY-BZA (Berëzovka, Belarus)'),
    ('BY-BOB', 'BY-BOB (Bobruysk, Belarus)'),
    ('BY-BMO', "BY-BMO (Bol'shiye Motykaly, Belarus)"),
    ('BY-MBV', 'BY-MBV (Borisov, Belarus)'),
    ('BY-BOR', 'BY-BOR (Borovlyany, Belarus)'),
    ('BY-BQT', 'BY-BQT (Brest, Belarus)'),
    ('BY-CHV', 'BY-CHV (Chavusi, Belarus)'),
    ('BY-DEM', 'BY-DEM (Demidov, Belarus)'),
    ('BY-DRS', 'BY-DRS (Dobrush, Belarus)'),
    ('BY-DRH', 'BY-DRH (Drahichyn, Belarus)'),
    ('BY-DZK', 'BY-DZK (Dzerzhinsk, Belarus)'),
    ('BY-FAN', 'BY-FAN (Fanipol, Belarus)'),
    ('BY-GAT', 'BY-GAT (Gatovo, Belarus)'),
    ('BY-GME', 'BY-GME (Gomel, Belarus)'),
    ('BY-GRK', 'BY-GRK (Gorodok, Belarus)'),
    ('BY-GNA', 'BY-GNA (Grodna, Belarus)'),
    ('BY-GDO', 'BY-GDO (Grodno, Belarus)'),
    ('BY-KHO', 'BY-KHO (Khoyniki, Belarus)'),
    ('BY-KLK', 'BY-KLK (Kletsk, Belarus)'),
    ('BY-KBY', 'BY-KBY (Kobryn, Belarus)'),
    ('BY-KNV', 'BY-KNV (Kokhanovo, Belarus)'),
    ('BY-KDC', 'BY-KDC (Kolyadichi, Belarus)'),
    ('BY-KOP', 'BY-KOP (Koptevka, Belarus)'),
    ('BY-KYC', 'BY-KYC (Kostyukovichi, Belarus)'),
    ('BY-KRA', "BY-KRA (Krasnosel'skiy, Belarus)"),
    ('BY-MSK', 'BY-MSK (Krupki, Belarus)'),
    ('BY-LHK', 'BY-LHK (Lahoysk, Belarus)'),
    ('BY-LDA', 'BY-LDA (Lida, Belarus)'),
    ('BY-LNY', 'BY-LNY (Luninyets, Belarus)'),
    ('BY-MZY', 'BY-MZY (Maladzyechna, Belarus)'),
    ('BY-MAZ', 'BY-MAZ (Mazyr, Belarus)'),
    ('BY-MSQ', 'BY-MSQ (Minsk, Belarus)'),
    ('BY-MVQ', 'BY-MVQ (Mogilev, Belarus)'),
    ('BY-MOL', 'BY-MOL (Molodeczno, Belarus)'),
    ('BY-NHK', 'BY-NHK (Navahrudak, Belarus)'),
    ('BY-NPK', 'BY-NPK (Navapolatsk, Belarus)'),
    ('BY-OLS', "BY-OLS (Ol'shany, Belarus)"),
    ('BY-OSH', 'BY-OSH (Orsha, Belarus)'),
    ('BY-PES', 'BY-PES (Peski, Belarus)'),
    ('BY-PIK', 'BY-PIK (Pinsk, Belarus)'),
    ('BY-POK', 'BY-POK (Polatsk, Belarus)'),
    ('BY-RYA', 'BY-RYA (Rechytsa, Belarus)'),
    ('BY-SHO', 'BY-SHO (Salihorsk, Belarus)'),
    ('BY-SCH', 'BY-SCH (Shchuchyn, Belarus)'),
    ('BY-SKV', 'BY-SKV (Sklov, Belarus)'),
    ('BY-SLA', 'BY-SLA (Slawharad, Belarus)'),
    ('BY-SNM', 'BY-SNM (Slonim, Belarus)'),
    ('BY-SLU', 'BY-SLU (Slutsk, Belarus)'),
    ('BY-SMV', 'BY-SMV (Smolevichi, Belarus)'),
    ('BY-SGA', 'BY-SGA (Smorgon, Belarus)'),
    ('BY-STD', 'BY-STD (Starye Dorogi, Belarus)'),
    ('BY-SOB', 'BY-SOB (Stolbtsy, Belarus)'),
    ('BY-SVE', 'BY-SVE (Svetlogorsk, Belarus)'),
    ('BY-SVS', 'BY-SVS (Svisloch, Belarus)'),
    ('BY-ZDA', 'BY-ZDA (Uzda, Belarus)'),
    ('BY-VAW', 'BY-VAW (Vawkavysk, Belarus)'),
    ('BY-VTB', 'BY-VTB (Vitebsk, Belarus)'),
    ('BY-VYK', 'BY-VYK (Vyerkhnyadzvinsk, Belarus)'),
    ('BY-ZAS', 'BY-ZAS (Zaslavl, Belarus)'),
    ('BY-ZLV', "BY-ZLV (Zel'va, Belarus)"),
    ('BY-ZHO', 'BY-ZHO (Zhlobin, Belarus)'),
    ('BY-MZO', 'BY-MZO (Zhodino, Belarus)'),
    ('BY-ZZA', 'BY-ZZA (Zhodzina, Belarus)'),
    ('BY-ZHI', 'BY-ZHI (Zhytkavichy, Belarus)'),
    ('BZ-BAR', 'BZ-BAR (Barranco, Belize)'),
    ('BZ-BZE', 'BZ-BZE (Belize City, Belize)'),
    ('BZ-TZA', 'BZ-TZA (Belize City Municipal Airport, Belize)'),
    ('BZ-BMP', 'BZ-BMP (Belmopan, Belize)'),
    ('BZ-BVJ', 'BZ-BVJ (Benque Viejo, Belize)'),
    ('BZ-BVC', 'BZ-BVC (Benque Viejo del Carmen, Belize)'),
    ('BZ-BGK', 'BZ-BGK (Big Creek, Belize)'),
    ('BZ-CUK', 'BZ-CUK (Caye Caulker, Belize)'),
    ('BZ-CYC', 'BZ-CYC (Caye Chapel, Belize)'),
    ('BZ-COL', 'BZ-COL (Colinto, Belize)'),
    ('BZ-CZH', 'BZ-CZH (Corozal, Belize)'),
    ('BZ-CRR', 'BZ-CRR (Crooked Tree, Belize)'),
    ('BZ-DGA', 'BZ-DGA (Dangriga, Belize)'),
    ('BZ-INB', 'BZ-INB (Independence Apt, Belize)'),
    ('BZ-MZE', 'BZ-MZE (Manatee Apt, Belize)'),
    ('BZ-MDB', 'BZ-MDB (Melinda, Belize)'),
    ('BZ-ORZ', 'BZ-ORZ (Orange Walk, Belize)'),
    ('BZ-PLJ', 'BZ-PLJ (Placencia, Belize)'),
    ('BZ-PND', 'BZ-PND (Punta Gorda, Belize)'),
    ('BZ-SQS', 'BZ-SQS (San Ignacio, Belize)'),
    ('BZ-SPR', 'BZ-SPR (San Pedro, Belize)'),
    ('BZ-STU', 'BZ-STU (Santa Cruz, Belize)'),
    ('BZ-4SA', 'BZ-4SA (Santa Elena, Belize)'),
    ('BZ-SJX', 'BZ-SJX (Sartaneja, Belize)'),
    ('BZ-SVK', 'BZ-SVK (Silver Creek, Belize)'),
    ('CA-BST', 'CA-BST (Bayside, Charlotte, New Brunswick, Canada)'),
    ('CA-SYT', 'CA-SYT (Stoney Point, Essex, Ontario, Canada)'),
    ('CA-HOS', 'CA-HOS (100 Mile House (One Hundred Mile House), British Columbia, Canada)'),
    ('CA-MHS', 'CA-MHS (150 Mile House, British Columbia, Canada)'),
    ('CA-ABB', 'CA-ABB (Abbotsford, British Columbia, Canada)'),
    ('CA-ABE', 'CA-ABE (Abercrombie, Nova Scotia, Canada)'),
    ('CA-ABV', 'CA-ABV (Abram-Village, Prince Edward Island, Canada)'),
    ('CA-AVY', 'CA-AVY (Acadia Valley, Alberta, Canada)'),
    ('CA-AHN', 'CA-AHN (Acheson, Alberta, Canada)'),
    ('CA-ACT', 'CA-ACT (Acton, Ontario, Canada)'),
    ('CA-ACV', 'CA-ACV (Acton Vale, Quebec, Canada)'),
    ('CA-DDD', 'CA-DDD (Addison, Ontario, Canada)'),
    ('CA-ALK', 'CA-ALK (Adlavik, Newfoundland and Labrador, Canada)'),
    ('CA-DST', 'CA-DST (Adstock, Quebec, Canada)'),
    ('CA-ADV', 'CA-ADV (Advocate Harbour, Nova Scotia, Canada)'),
    ('CA-AGZ', 'CA-AGZ (Agassiz, British Columbia, Canada)'),
    ('CA-AGI', 'CA-AGI (Agincourt, Ontario, Canada)'),
    ('CA-AGU', 'CA-AGU (Aguathuna, Newfoundland and Labrador, Canada)'),
    ('CA-AAC', 'CA-AAC (Ailsa Craig, Ontario, Canada)'),
    ('CA-ARO', 'CA-ARO (Air Ronge, Saskatchewan, Canada)'),
    ('CA-AIR', 'CA-AIR (Airdrie, Alberta, Canada)'),
    ('CA-AJX', 'CA-AJX (Ajax, Ontario, Canada)'),
    ('CA-AKL', 'CA-AKL (Ajax, Ontario, Canada)'),
    ('CA-AKV', 'CA-AKV (Akulivik Apt, Quebec, Canada)'),
    ('CA-ABN', 'CA-ABN (Alban, Ontario, Canada)'),
    ('CA-AYY', 'CA-AYY (Albany, Prince Edward Island, Canada)'),
    ('CA-ABG', 'CA-ABG (Albert Bridge, Nova Scotia, Canada)'),
    ('CA-ATO', 'CA-ATO (Alberton, Prince Edward Island, Canada)'),
    ('CA-LDF', 'CA-LDF (Alder Flats, Alberta, Canada)'),
    ('CA-ADE', 'CA-ADE (Aldergrove, British Columbia, Canada)'),
    ('CA-ASY', 'CA-ASY (Aldersyde, Alberta, Canada)'),
    ('CA-AAL', 'CA-AAL (Alert Bay, British Columbia, Canada)'),
    ('CA-ALD', 'CA-ALD (Alexander, Manitoba, Canada)'),
    ('CA-XFS', 'CA-XFS (Alexandria, Ontario, Canada)'),
    ('CA-ASK', 'CA-ASK (Alexis Creek, British Columbia, Canada)'),
    ('CA-ALF', 'CA-ALF (Alfred, Ontario, Canada)'),
    ('CA-AHH', 'CA-AHH (Algonquin Highlands, Ontario, Canada)'),
    ('CA-ALP', 'CA-ALP (Algonquin Park, Ontario, Canada)'),
    ('CA-ALH', 'CA-ALH (Alhambra, Alberta, Canada)'),
    ('CA-ALI', 'CA-ALI (Alix, Alberta, Canada)'),
    ('CA-ALN', 'CA-ALN (Allan, Saskatchewan, Canada)'),
    ('CA-ALL', 'CA-ALL (Allanburg, Ontario, Canada)'),
    ('CA-ALE', 'CA-ALE (Allardville, New Brunswick, Canada)'),
    ('CA-AMA', 'CA-AMA (Alliston, Ontario, Canada)'),
    ('CA-ALM', 'CA-ALM (Alma, Ontario, Canada)'),
    ('CA-YTF', 'CA-YTF (Alma, Quebec, Canada)'),
    ('CA-AMT', 'CA-AMT (Almonte, Ontario, Canada)'),
    ('CA-AID', 'CA-AID (Alnwick/Haldimand, Ontario, Canada)'),
    ('CA-YAE', 'CA-YAE (Alta Lake, British Columbia, Canada)'),
    ('CA-ALT', 'CA-ALT (Alton, Ontario, Canada)'),
    ('CA-AXO', 'CA-AXO (Altona, Manitoba, Canada)'),
    ('CA-ASO', 'CA-ASO (Alvinston, Ontario, Canada)'),
    ('CA-ABL', 'CA-ABL (Amberly, Ontario, Canada)'),
    ('CA-AMN', 'CA-AMN (Amherst, Nova Scotia, Canada)'),
    ('CA-AMH', 'CA-AMH (Amherstburg, Ontario, Canada)'),
    ('CA-YEY', 'CA-YEY (Amos, Quebec, Canada)'),
    ('CA-AMQ', 'CA-AMQ (Amqui, Quebec, Canada)'),
    ('CA-ANC', 'CA-ANC (Ancaster, Ontario, Canada)'),
    ('CA-ANB', 'CA-ANB (Andys Bay, British Columbia, Canada)'),
    ('CA-ANF', 'CA-ANF (Anfield, New Brunswick, Canada)'),
    ('CA-AGR', 'CA-AGR (Ange Gardien de Rouville, Quebec, Canada)'),
    ('CA-YAX', 'CA-YAX (Angling Lake, Ontario, Canada)'),
    ('CA-AVM', 'CA-AVM (Angusville, Manitoba, Canada)'),
    ('CA-AJU', 'CA-AJU (Anjou, Quebec, Canada)'),
    ('CA-ANI', 'CA-ANI (Annacis Island, British Columbia, Canada)'),
    ('CA-ANL', 'CA-ANL (Anola, Manitoba, Canada)'),
    ('CA-ANT', 'CA-ANT (Antigonish, Nova Scotia, Canada)'),
    ('CA-ANZ', 'CA-ANZ (Anzac, Alberta, Canada)'),
    ('CA-APO', 'CA-APO (Apohaqui, New Brunswick, Canada)'),
    ('CA-API', 'CA-API (Appin, Ontario, Canada)'),
    ('CA-AHL', 'CA-AHL (Apple Hill, Ontario, Canada)'),
    ('CA-ARG', 'CA-ARG (Arborg, Manitoba, Canada)'),
    ('CA-ARB', 'CA-ARB (Arborg, Manitoba, Canada)'),
    ('CA-ADH', 'CA-ADH (Ardath, Saskatchewan, Canada)'),
    ('CA-ASS', 'CA-ASS (Ardrossan, Alberta, Canada)'),
    ('CA-NWP', 'CA-NWP (Argentia, Newfoundland and Labrador, Canada)'),
    ('CA-AGY', 'CA-AGY (Argyle, Nova Scotia, Canada)'),
    ('CA-ARI', 'CA-ARI (Arichat, Nova Scotia, Canada)'),
    ('CA-ARX', 'CA-ARX (Ariss, Ontario, Canada)'),
    ('CA-AKN', 'CA-AKN (Arkona, Ontario, Canada)'),
    ('CA-AME', 'CA-AME (Armena, Alberta, Canada)'),
    ('CA-ARM', 'CA-ARM (Armstrong, British Columbia, Canada)'),
    ('CA-AAD', 'CA-AAD (Arnaud, Manitoba, Canada)'),
    ('CA-YNR', 'CA-YNR (Arnes, Manitoba, Canada)'),
    ('CA-ARC', "CA-ARC (Arnold's Cove, Newfoundland and Labrador, Canada)"),
    ('CA-ANP', 'CA-ANP (Arnprior, Ontario, Canada)'),
    ('CA-ART', 'CA-ART (Arthabaska, Quebec, Canada)'),
    ('CA-ATH', 'CA-ATH (Arthur, Ontario, Canada)'),
    ('CA-ARU', 'CA-ARU (Arundel, Quebec, Canada)'),
    ('CA-YEK', 'CA-YEK (Arundel, Quebec, Canada)'),
    ('CA-ASB', 'CA-ASB (Asbestos, Quebec, Canada)'),
    ('CA-YAF', 'CA-YAF (Asbestos Hill, Quebec, Canada)'),
    ('CA-ABH', 'CA-ABH (Ashburn, Ontario, Canada)'),
    ('CA-YZA', 'CA-YZA (Ashcroft, British Columbia, Canada)'),
    ('CA-ANN', 'CA-ANN (Asphodel-Norwood, Ontario, Canada)'),
    ('CA-ASQ', 'CA-ASQ (Asquith, Saskatchewan, Canada)'),
    ('CA-ABO', 'CA-ABO (Assiniboia, Saskatchewan, Canada)'),
    ('CA-AJN', 'CA-AJN (Aston-Jonction, Quebec, Canada)'),
    ('CA-ATA', 'CA-ATA (Astra, Ontario, Canada)'),
    ('CA-ATB', 'CA-ATB (Athabasca, Alberta, Canada)'),
    ('CA-ATS', 'CA-ATS (Athens, Ontario, Canada)'),
    ('CA-ALV', 'CA-ALV (Atholville, New Brunswick, Canada)'),
    ('CA-YIB', 'CA-YIB (Atikokan, Ontario, Canada)'),
    ('CA-ATL', 'CA-ATL (Atlin, British Columbia, Canada)'),
    ('CA-YAT', 'CA-YAT (Attawapiskat, Ontario, Canada)'),
    ('CA-AWD', 'CA-AWD (Atwood, Ontario, Canada)'),
    ('CA-AUL', 'CA-AUL (Aulac, New Brunswick, Canada)'),
    ('CA-ACO', 'CA-ACO (Aulds Cove, Nova Scotia, Canada)'),
    ('CA-YPJ', 'CA-YPJ (Aupauluk, Quebec, Canada)'),
    ('CA-AUR', 'CA-AUR (Aurora, Ontario, Canada)'),
    ('CA-AUQ', 'CA-AUQ (Austin, Quebec, Canada)'),
    ('CA-AUS', 'CA-AUS (Austin, Manitoba, Canada)'),
    ('CA-AVO', 'CA-AVO (Avondale, Newfoundland and Labrador, Canada)'),
    ('CA-AVL', 'CA-AVL (Avonlea, Saskatchewan, Canada)'),
    ('CA-AVP', 'CA-AVP (Avonport, Nova Scotia, Canada)'),
    ('CA-ACL', "CA-ACL (Ayer's Cliff, Quebec, Canada)"),
    ('CA-AYD', 'CA-AYD (Aylesford, Nova Scotia, Canada)'),
    ('CA-AYL', 'CA-AYL (Aylmer, Ontario, Canada)'),
    ('CA-AYM', 'CA-AYM (Aylmer, Quebec, Canada)'),
    ('CA-AYH', 'CA-AYH (Aylsham, Saskatchewan, Canada)'),
    ('CA-AYR', 'CA-AYR (Ayr, Ontario, Canada)'),
    ('CA-AYO', 'CA-AYO (Ayton, Ontario, Canada)'),
    ('CA-AZI', 'CA-AZI (Azilda, Ontario, Canada)'),
    ('CA-BAD', 'CA-BAD (Baddeck, Nova Scotia, Canada)'),
    ('CA-BDE', 'CA-BDE (Baden, Ontario, Canada)'),
    ('CA-BGT', 'CA-BGT (Bagotville, Quebec, Canada)'),
    ('CA-YBG', 'CA-YBG (Bagotville Apt, Quebec, Canada)'),
    ('CA-BCO', 'CA-BCO (Baie Comeau, Quebec, Canada)'),
    ('CA-BDU', "CA-BDU (Baie d'Urfé, Quebec, Canada)"),
    ('CA-BVE', 'CA-BVE (Baie Verte, Newfoundland and Labrador, Canada)'),
    ('CA-BJO', 'CA-BJO (Baie-Johan-Beetz, Quebec, Canada)'),
    ('CA-BSA', 'CA-BSA (Baie-Sainte-Anne, New Brunswick, Canada)'),
    ('CA-BSP', 'CA-BSP (Baie-St-Paul, Quebec, Canada)'),
    ('CA-BVS', 'CA-BVS (Bainsville, Ontario, Canada)'),
    ('CA-BDI', 'CA-BDI (Bairdsville, New Brunswick, Canada)'),
    ('CA-BLK', 'CA-BLK (Bairdsville, New Brunswick, Canada)'),
    ('CA-BAA', 'CA-BAA (Bala, Ontario, Canada)'),
    ('CA-BLS', 'CA-BLS (Balckstock, Ontario, Canada)'),
    ('CA-BDR', 'CA-BDR (Bald Rock, Nova Scotia, Canada)'),
    ('CA-BAL', 'CA-BAL (Balmertown, Ontario, Canada)'),
    ('CA-BL2', 'CA-BL2 (Balmoral, New Brunswick, Canada)'),
    ('CA-BZC', 'CA-BZC (Balzac, Alberta, Canada)'),
    ('CA-BAM', 'CA-BAM (Bamberton, British Columbia, Canada)'),
    ('CA-BCT', 'CA-BCT (Bancroft, Ontario, Canada)'),
    ('CA-BAF', 'CA-BAF (Banff, Alberta, Canada)'),
    ('CA-BNG', 'CA-BNG (Bangor, Saskatchewan, Canada)'),
    ('CA-NTR', 'CA-NTR (Bantry, Alberta, Canada)'),
    ('CA-BIV', 'CA-BIV (Bar River, Ontario, Canada)'),
    ('CA-BN4', 'CA-BN4 (Barons, Alberta, Canada)'),
    ('CA-BRH', 'CA-BRH (Barrhead, Alberta, Canada)'),
    ('CA-BAR', 'CA-BAR (Barrie, Ontario, Canada)'),
    ('CA-BAN', 'CA-BAN (Barrington, Nova Scotia, Canada)'),
    ('CA-BPP', 'CA-BPP (Barrington Passage, Nova Scotia, Canada)'),
    ('CA-BRR', 'CA-BRR (Barrière, British Columbia, Canada)'),
    ('CA-BRS', 'CA-BRS (Barrs Corner, Nova Scotia, Canada)'),
    ('CA-BYB', 'CA-BYB (Barrys Bay, Ontario, Canada)'),
    ('CA-BHW', 'CA-BHW (Bashaw, Alberta, Canada)'),
    ('CA-BNO', 'CA-BNO (Bassano, Alberta, Canada)'),
    ('CA-BAW', 'CA-BAW (Batawa, Ontario, Canada)'),
    ('CA-BTH', 'CA-BTH (Bath, Ontario, Canada)'),
    ('CA-BAT', 'CA-BAT (Bathurst, New Brunswick, Canada)'),
    ('CA-BSN', 'CA-BSN (Batiscan, Quebec, Canada)'),
    ('CA-BLF', 'CA-BLF (Battleford, Saskatchewan, Canada)'),
    ('CA-BBU', 'CA-BBU (Bay Bulls, Newfoundland and Labrador, Canada)'),
    ('CA-BDV', 'CA-BDV (Bay de Verde, Newfoundland and Labrador, Canada)'),
    ('CA-BYR', 'CA-BYR (Bay Roberts, Newfoundland and Labrador, Canada)'),
    ('CA-BYT', 'CA-BYT (Bay Tree, Alberta, Canada)'),
    ('CA-BYD', 'CA-BYD (Bayfield, New Brunswick, Canada)'),
    ('CA-BYL', 'CA-BYL (Bayfield, Ontario, Canada)'),
    ('CA-BAH', 'CA-BAH (Bayham, Ontario, Canada)'),
    ('CA-BAS', 'CA-BAS (Bayside, Ontario, Canada)'),
    ('CA-BAY', 'CA-BAY (Bayside (St Roberts), New Brunswick, Canada)'),
    ('CA-BPO', 'CA-BPO (Beach Point, Prince Edward Island, Canada)'),
    ('CA-BHV', 'CA-BHV (Beachville, Ontario, Canada)'),
    ('CA-BCF', 'CA-BCF (Beaconsfield, Quebec, Canada)'),
    ('CA-BCV', 'CA-BCV (Beale Cove, British Columbia, Canada)'),
    ('CA-BMV', 'CA-BMV (Beamsville, Ontario, Canada)'),
    ('CA-BEI', 'CA-BEI (Bear Island, New Brunswick, Canada)'),
    ('CA-BKK', 'CA-BKK (Bearskin Lake, Ontario, Canada)'),
    ('CA-BEU', 'CA-BEU (Beauceville, Quebec, Canada)'),
    ('CA-BHA', 'CA-BHA (Beauharnois, Quebec, Canada)'),
    ('CA-BET', 'CA-BET (Beaumont, Alberta, Canada)'),
    ('CA-BPT', 'CA-BPT (Beauport, Quebec, Canada)'),
    ('CA-BPB', 'CA-BPB (Beaupré, Quebec, Canada)'),
    ('CA-BSJ', 'CA-BSJ (Beauséjour, Manitoba, Canada)'),
    ('CA-BVB', 'CA-BVB (Beaver Bank, Nova Scotia, Canada)'),
    ('CA-BBR', 'CA-BBR (Beaver Brook, Nova Scotia, Canada)'),
    ('CA-BEA', 'CA-BEA (Beaver Cove, British Columbia, Canada)'),
    ('CA-YT4', 'CA-YT4 (Beaver Cove, British Columbia, Canada)'),
    ('CA-BEH', 'CA-BEH (Beaver Harbour, New Brunswick, Canada)'),
    ('CA-BLO', 'CA-BLO (Beaverlodge, Alberta, Canada)'),
    ('CA-BEQ', 'CA-BEQ (Bedeque, Prince Edward Island, Canada)'),
    ('CA-BDF', 'CA-BDF (Bedford, Nova Scotia, Canada)'),
    ('CA-BED', 'CA-BED (Bedford, Quebec, Canada)'),
    ('CA-BCY', 'CA-BCY (Beechy, Saskatchewan, Canada)'),
    ('CA-BEN', 'CA-BEN (Beeton, Ontario, Canada)'),
    ('CA-BEE', 'CA-BEE (Beiseker, Alberta, Canada)'),
    ('CA-BFF', 'CA-BFF (Belfast, Prince Edward Island, Canada)'),
    ('CA-BTA', 'CA-BTA (Belfountain, Ontario, Canada)'),
    ('CA-BLC', 'CA-BLC (Bella Coola, British Columbia, Canada)'),
    ('CA-BPL', 'CA-BPL (Belle Plaine, Saskatchewan, Canada)'),
    ('CA-BLI', 'CA-BLI (Belle River, Ontario, Canada)'),
    ('CA-BEL', 'CA-BEL (Belledune, New Brunswick, Canada)'),
    ('CA-EEK', 'CA-EEK (Belleisle Creek, New Brunswick, Canada)'),
    ('CA-BLV', 'CA-BLV (Belleville, Ontario, Canada)'),
    ('CA-BVU', 'CA-BVU (Bellevue, Alberta, Canada)'),
    ('CA-BLM', 'CA-BLM (Belmont, Ontario, Canada)'),
    ('CA-BLL', 'CA-BLL (Beloeil, Quebec, Canada)'),
    ('CA-BLD', 'CA-BLD (Belwood, Ontario, Canada)'),
    ('CA-BNT', 'CA-BNT (Benito, Manitoba, Canada)'),
    ('CA-BSC', "CA-BSC (Benoit's Cove, Newfoundland and Labrador, Canada)"),
    ('CA-YBV', 'CA-YBV (Berens River Apt, Manitoba, Canada)'),
    ('CA-BFR', 'CA-BFR (Beresford, New Brunswick, Canada)'),
    ('CA-BBN', 'CA-BBN (Beresford, New Brunswick, Canada)'),
    ('CA-BMS', 'CA-BMS (Berry Mills, New Brunswick, Canada)'),
    ('CA-BSM', 'CA-BSM (Berthier-sur-Mer, Quebec, Canada)'),
    ('CA-BER', 'CA-BER (Berthierville, Quebec, Canada)'),
    ('CA-BWK', 'CA-BWK (Berwick, Nova Scotia, Canada)'),
    ('CA-BTY', 'CA-BTY (Bethany, Ontario, Canada)'),
    ('CA-BTE', 'CA-BTE (Bethune, Saskatchewan, Canada)'),
    ('CA-BTW', 'CA-BTW (Bickerton West, Nova Scotia, Canada)'),
    ('CA-BNF', 'CA-BNF (Bienfait, Saskatchewan, Canada)'),
    ('CA-BKR', 'CA-BKR (Big Lake Ranch, British Columbia, Canada)'),
    ('CA-BGR', 'CA-BGR (Big River, New Brunswick, Canada)'),
    ('CA-YTL', 'CA-YTL (Big Trout Lake, Ontario, Canada)'),
    ('CA-BIR', 'CA-BIR (Biggar, Saskatchewan, Canada)'),
    ('CA-YTZ', 'CA-YTZ (Billy Bishop Toronto City Apt/Toronto, Ontario, Canada)'),
    ('CA-BCH', 'CA-BCH (Binscarth, Manitoba, Canada)'),
    ('CA-BHI', 'CA-BHI (Birds Hill, Manitoba, Canada)'),
    ('CA-BPF', "CA-BPF (Bishop's Falls, Newfoundland and Labrador, Canada)"),
    ('CA-BHF', 'CA-BHF (Bishops Falls, Newfoundland and Labrador, Canada)'),
    ('CA-BKC', 'CA-BKC (Black Creek, British Columbia, Canada)'),
    ('CA-BDM', 'CA-BDM (Black Diamond, Alberta, Canada)'),
    ('CA-BKL', 'CA-BKL (Black Lake, Quebec, Canada)'),
    ('CA-YBI', 'CA-YBI (Black Tickle, Newfoundland and Labrador, Canada)'),
    ('CA-BKF', 'CA-BKF (Blackfalds, Alberta, Canada)'),
    ('CA-BFO', 'CA-BFO (Blackfoot, Alberta, Canada)'),
    ('CA-BKI', 'CA-BKI (Blackie, Alberta, Canada)'),
    ('CA-BLH', 'CA-BLH (Blacks Harbour, New Brunswick, Canada)'),
    ('CA-BSK', 'CA-BSK (Blackstock, Ontario, Canada)'),
    ('CA-BKV', 'CA-BKV (Blackville, New Brunswick, Canada)'),
    ('CA-BLA', 'CA-BLA (Blainville, Quebec, Canada)'),
    ('CA-YBX', 'CA-YBX (Blanc-Sablon, Quebec, Canada)'),
    ('CA-BHM', 'CA-BHM (Blenheim, Ontario, Canada)'),
    ('CA-BBY', 'CA-BBY (Blind Bay, British Columbia, Canada)'),
    ('CA-BLR', 'CA-BLR (Blind River, Ontario, Canada)'),
    ('CA-BHH', 'CA-BHH (Blockhouse, Nova Scotia, Canada)'),
    ('CA-YDV', 'CA-YDV (Bloodvein, Manitoba, Canada)'),
    ('CA-BMF', 'CA-BMF (Bloomfield, New Brunswick, Canada)'),
    ('CA-BMI', 'CA-BMI (Bloomfield, Ontario, Canada)'),
    ('CA-BOO', 'CA-BOO (Bloomingdale, Ontario, Canada)'),
    ('CA-BBB', 'CA-BBB (Blubber Bay, British Columbia, Canada)'),
    ('CA-BMT', 'CA-BMT (Blue Mountain, Ontario, Canada)'),
    ('CA-BLG', 'CA-BLG (Blue Ridge, Alberta, Canada)'),
    ('CA-BVR', 'CA-BVR (Blue River, British Columbia, Canada)'),
    ('CA-BFT', 'CA-BFT (Bluffton, Alberta, Canada)'),
    ('CA-BMN', 'CA-BMN (Blumenort, Manitoba, Canada)'),
    ('CA-BLY', 'CA-BLY (Blyth, Ontario, Canada)'),
    ('CA-BOB', 'CA-BOB (Bobcaygeon, Ontario, Canada)'),
    ('CA-YBO', 'CA-YBO (Bobquinn Lake, British Columbia, Canada)'),
    ('CA-BOI', 'CA-BOI (Boiestown, New Brunswick, Canada)'),
    ('CA-BFI', 'CA-BFI (Bois-des-Filion, Quebec, Canada)'),
    ('CA-BBD', 'CA-BBD (Boisbriand, Quebec, Canada)'),
    ('CA-BSS', 'CA-BSS (Boissevain, Manitoba, Canada)'),
    ('CA-BLT', 'CA-BLT (Bolton, Ontario, Canada)'),
    ('CA-BAC', 'CA-BAC (Bon Accord, Alberta, Canada)'),
    ('CA-BCL', 'CA-BCL (Bon Conseil, Quebec, Canada)'),
    ('CA-YVB', 'CA-YVB (Bonaventure, Quebec, Canada)'),
    ('CA-BHD', 'CA-BHD (Bond Head, Ontario, Canada)'),
    ('CA-BOE', 'CA-BOE (Bonnyville, Alberta, Canada)'),
    ('CA-BOD', 'CA-BOD (Borden, Saskatchewan, Canada)'),
    ('CA-BOR', 'CA-BOR (Borden, Prince Edward Island, Canada)'),
    ('CA-YBN', 'CA-YBN (Borden, Ontario, Canada)'),
    ('CA-BNM', 'CA-BNM (Bornholm, Ontario, Canada)'),
    ('CA-BWL', 'CA-BWL (Bothwell, Ontario, Canada)'),
    ('CA-BWD', 'CA-BWD (Botwood, Newfoundland and Labrador, Canada)'),
    ('CA-BOU', 'CA-BOU (Boucherville, Quebec, Canada)'),
    ('CA-BUE', 'CA-BUE (Bouctouche, New Brunswick, Canada)'),
    ('CA-BC2', 'CA-BC2 (Bow City, Alberta, Canada)'),
    ('CA-BWI', 'CA-BWI (Bow Island, Alberta, Canada)'),
    ('CA-BOW', 'CA-BOW (Bowden, Alberta, Canada)'),
    ('CA-BNI', 'CA-BNI (Bowen Island, British Columbia, Canada)'),
    ('CA-BWV', 'CA-BWV (Bowmanville, Ontario, Canada)'),
    ('CA-BOY', 'CA-BOY (Boyle, Alberta, Canada)'),
    ('CA-BRB', 'CA-BRB (Bracebridge, Ontario, Canada)'),
    ('CA-BCN', 'CA-BCN (Brackendale, British Columbia, Canada)'),
    ('CA-BRA', 'CA-BRA (Bradford, Ontario, Canada)'),
    ('CA-BCE', 'CA-BCE (Bragg Creek, Alberta, Canada)'),
    ('CA-BRM', 'CA-BRM (Bramalea, Ontario, Canada)'),
    ('CA-BRP', 'CA-BRP (Bramalea, Ontario, Canada)'),
    ('CA-YBR', 'CA-YBR (Brandon, Manitoba, Canada)'),
    ('CA-BNN', 'CA-BNN (Brant, Ontario, Canada)'),
    ('CA-BRN', 'CA-BRN (Brantford, Ontario, Canada)'),
    ('CA-BRZ', 'CA-BRZ (Brazeau, Alberta, Canada)'),
    ('CA-BBA', 'CA-BBA (Breadalbane, Prince Edward Island, Canada)'),
    ('CA-BRE', 'CA-BRE (Brechin, Ontario, Canada)'),
    ('CA-BRD', 'CA-BRD (Brentwood Bay, British Columbia, Canada)'),
    ('CA-BSU', 'CA-BSU (Breslau, Ontario, Canada)'),
    ('CA-BIE', 'CA-BIE (Bridesville, British Columbia, Canada)'),
    ('CA-BLE', 'CA-BLE (Bridge Lake, British Columbia, Canada)'),
    ('CA-BTN', 'CA-BTN (Bridgetown, Nova Scotia, Canada)'),
    ('CA-BRW', 'CA-BRW (Bridgewater, Nova Scotia, Canada)'),
    ('CA-BRG', 'CA-BRG (Bright, Ontario, Canada)'),
    ('CA-BGH', 'CA-BGH (Brighton, Ontario, Canada)'),
    ('CA-BNS', 'CA-BNS (Brinston, Ontario, Canada)'),
    ('CA-BSL', 'CA-BSL (Bristol, Quebec, Canada)'),
    ('CA-BTO', 'CA-BTO (Bristol, New Brunswick, Canada)'),
    ('CA-BRI', 'CA-BRI (Britannia Beach, British Columbia, Canada)'),
    ('CA-BTT', 'CA-BTT (Britt, Ontario, Canada)'),
    ('CA-YDR', 'CA-YDR (Broadview, Saskatchewan, Canada)'),
    ('CA-YBT', 'CA-YBT (Brochet, Manitoba, Canada)'),
    ('CA-BKA', 'CA-BKA (Brocket, Alberta, Canada)'),
    ('CA-BCK', 'CA-BCK (Brockville, Ontario, Canada)'),
    ('CA-BDC', 'CA-BDC (Broderick, Saskatchewan, Canada)'),
    ('CA-BHG', 'CA-BHG (Brodhagen, Ontario, Canada)'),
    ('CA-ZBM', 'CA-ZBM (Bromont, Quebec, Canada)'),
    ('CA-BTV', 'CA-BTV (Bromptonville, Quebec, Canada)'),
    ('CA-YBM', 'CA-YBM (Bronson Creek, British Columbia, Canada)'),
    ('CA-BFD', 'CA-BFD (Brookfield, Nova Scotia, Canada)'),
    ('CA-BRK', 'CA-BRK (Brooklin, Ontario, Canada)'),
    ('CA-BKN', 'CA-BKN (Brooklyn, Nova Scotia, Canada)'),
    ('CA-BKS', 'CA-BKS (Brooks, Alberta, Canada)'),
    ('CA-BRO', 'CA-BRO (Brossard, Quebec, Canada)'),
    ('CA-BR9', 'CA-BR9 (Brougham, Ontario, Canada)'),
    ('CA-BRT', 'CA-BRT (Brougham, Ontario, Canada)'),
    ('CA-BNL', 'CA-BNL (Brownlee, Saskatchewan, Canada)'),
    ('CA-OWN', 'CA-OWN (Brownsburg, Quebec, Canada)'),
    ('CA-BRJ', 'CA-BRJ (Brownsburg-Chatham, Quebec, Canada)'),
    ('CA-BVL', 'CA-BVL (Brownsville, Ontario, Canada)'),
    ('CA-BRC', 'CA-BRC (Bruce, Alberta, Canada)'),
    ('CA-ONB', 'CA-ONB (Bruce County, Ontario, Canada)'),
    ('CA-BCM', 'CA-BCM (Bruce Mines, Ontario, Canada)'),
    ('CA-BRF', 'CA-BRF (Brucefield, Ontario, Canada)'),
    ('CA-BDH', 'CA-BDH (Bruderheim, Alberta, Canada)'),
    ('CA-BM3', 'CA-BM3 (Brunkild, Manitoba, Canada)'),
    ('CA-BNR', 'CA-BNR (Brunner, Ontario, Canada)'),
    ('CA-BRU', 'CA-BRU (Bruno, Saskatchewan, Canada)'),
    ('CA-BUN', 'CA-BUN (Buchanan, Saskatchewan, Canada)'),
    ('CA-YZM', 'CA-YZM (Buchans, Newfoundland and Labrador, Canada)'),
    ('CA-BUC', 'CA-BUC (Buckingham, Quebec, Canada)'),
    ('CA-YVT', 'CA-YVT (Buffalo Narrows, Saskatchewan, Canada)'),
    ('CA-BUA', 'CA-BUA (Bull Arm, Newfoundland and Labrador, Canada)'),
    ('CA-YBH', 'CA-YBH (Bull Harbour, British Columbia, Canada)'),
    ('CA-BUL', 'CA-BUL (Bull River, British Columbia, Canada)'),
    ('CA-BYA', 'CA-BYA (Bulyea, Saskatchewan, Canada)'),
    ('CA-BDT', 'CA-BDT (Burdett, Alberta, Canada)'),
    ('CA-BUD', 'CA-BUD (Burford, Ontario, Canada)'),
    ('CA-BUO', 'CA-BUO (Burgeo, Newfoundland and Labrador, Canada)'),
    ('CA-BUR', 'CA-BUR (Burgessville, Ontario, Canada)'),
    ('CA-BGC', 'CA-BGC (Burgoynes Cove, Newfoundland and Labrador, Canada)'),
    ('CA-BUI', 'CA-BUI (Burin, Newfoundland and Labrador, Canada)'),
    ('CA-BSF', "CA-BSF (Burk's Falls, Ontario, Canada)"),
    ('CA-BUK', 'CA-BUK (Burks Falls, Ontario, Canada)'),
    ('CA-BRL', 'CA-BRL (Burlington, Ontario, Canada)'),
    ('CA-BUB', 'CA-BUB (Burnaby, British Columbia, Canada)'),
    ('CA-YPZ', 'CA-YPZ (Burns Lake, British Columbia, Canada)'),
    ('CA-BUS', 'CA-BUS (Burnside, Newfoundland and Labrador, Canada)'),
    ('CA-BIN', 'CA-BIN (Burrard Inlet, British Columbia, Canada)'),
    ('CA-BTR', 'CA-BTR (Burritts Rapids, Ontario, Canada)'),
    ('CA-BON', 'CA-BON (Burton, British Columbia, Canada)'),
    ('CA-BCR', 'CA-BCR (Burtts Corner, New Brunswick, Canada)'),
    ('CA-YDB', 'CA-YDB (Burtts Corner, New Brunswick, Canada)'),
    ('CA-BUY', 'CA-BUY (Bury, Quebec, Canada)'),
    ('CA-BUT', 'CA-BUT (Butedale, British Columbia, Canada)'),
    ('CA-BTF', 'CA-BTF (Butterfly Bay, British Columbia, Canada)'),
    ('CA-YKZ', 'CA-YKZ (Buttonville, Ontario, Canada)'),
    ('CA-BEC', 'CA-BEC (Bécancour, Quebec, Canada)'),
    ('CA-CBO', 'CA-CBO (Cabano, Quebec, Canada)'),
    ('CA-CRI', 'CA-CRI (Cabri, Saskatchewan, Canada)'),
    ('CA-CCE', 'CA-CCE (Cache Creek, British Columbia, Canada)'),
    ('CA-CCA', 'CA-CCA (Cacouna, Quebec, Canada)'),
    ('CA-CDL', 'CA-CDL (Cadillac, Quebec, Canada)'),
    ('CA-CCT', 'CA-CCT (Caistor Centre, Ontario, Canada)'),
    ('CA-CDA', 'CA-CDA (Caledon, Ontario, Canada)'),
    ('CA-CAA', 'CA-CAA (Caledonia, Nova Scotia, Canada)'),
    ('CA-CAD', 'CA-CAD (Caledonia, Ontario, Canada)'),
    ('CA-CAL', 'CA-CAL (Calgary, Alberta, Canada)'),
    ('CA-YYC', 'CA-YYC (Calgary Apt, Alberta, Canada)'),
    ('CA-CMR', 'CA-CMR (Calmar, Alberta, Canada)'),
    ('CA-GAL', 'CA-GAL (Cambridge (ex Galt), Ontario, Canada)'),
    ('CA-YCB', 'CA-YCB (Cambridge (ex Galt), Ontario, Canada)'),
    ('CA-CAS', 'CA-CAS (Cambridge Station, Nova Scotia, Canada)'),
    ('CA-CC2', 'CA-CC2 (Camlachie, Ontario, Canada)'),
    ('CA-CCF', 'CA-CCF (Campbell Croft, Ontario, Canada)'),
    ('CA-CAM', 'CA-CAM (Campbell River, British Columbia, Canada)'),
    ('CA-CBF', 'CA-CBF (Campbellford, Ontario, Canada)'),
    ('CA-COM', 'CA-COM (Campbellton, New Brunswick, Canada)'),
    ('CA-CBV', 'CA-CBV (Campbellville, Ontario, Canada)'),
    ('CA-CPB', 'CA-CPB (Campobello, New Brunswick, Canada)'),
    ('CA-CAE', 'CA-CAE (Camrose, Alberta, Canada)'),
    ('CA-FTS', 'CA-FTS (Canal Flats, British Columbia, Canada)'),
    ('CA-CPT', 'CA-CPT (Canaport, New Brunswick, Canada)'),
    ('CA-CAN', 'CA-CAN (Candiac, Saskatchewan, Canada)'),
    ('CA-CDC', 'CA-CDC (Candiac, Quebec, Canada)'),
    ('CA-CFD', 'CA-CFD (Canfield, Ontario, Canada)'),
    ('CA-CML', 'CA-CML (Canim Lake, British Columbia, Canada)'),
    ('CA-CNM', 'CA-CNM (Canmore, Alberta, Canada)'),
    ('CA-CAG', 'CA-CAG (Canning, Nova Scotia, Canada)'),
    ('CA-CNT', 'CA-CNT (Cannington, Ontario, Canada)'),
    ('CA-CNA', 'CA-CNA (Canora, Saskatchewan, Canada)'),
    ('CA-CAH', 'CA-CAH (Canso, Nova Scotia, Canada)'),
    ('CA-C5L', 'CA-C5L (Cantley, Quebec, Canada)'),
    ('CA-CAY', 'CA-CAY (Canyon Creek, Alberta, Canada)'),
    ('CA-CMS', 'CA-CMS (Cap-aux-Meules, Quebec, Canada)'),
    ('CA-CAC', 'CA-CAC (Cap-Chat, Quebec, Canada)'),
    ('CA-CME', 'CA-CME (Cap-de-la-Madeleine, Quebec, Canada)'),
    ('CA-CAP', 'CA-CAP (Cap-Pele, New Brunswick, Canada)'),
    ('CA-CEE', 'CA-CEE (Cap-Santé, Quebec, Canada)'),
    ('CA-CSI', 'CA-CSI (Cap-St-Ignace, Quebec, Canada)'),
    ('CA-CPR', 'CA-CPR (Cape Broyle, Newfoundland and Labrador, Canada)'),
    ('CA-CDO', 'CA-CDO (Cape Broyle, Newfoundland and Labrador, Canada)'),
    ('CA-CPY', 'CA-CPY (Cape Ray, Newfoundland and Labrador, Canada)'),
    ('CA-CTO', 'CA-CTO (Cape Tormentine, New Brunswick, Canada)'),
    ('CA-YCJ', 'CA-YCJ (Cape-Saint-James, British Columbia, Canada)'),
    ('CA-CAQ', 'CA-CAQ (Caraquet, New Brunswick, Canada)'),
    ('CA-CBY', 'CA-CBY (Carberry, Manitoba, Canada)'),
    ('CA-CBN', 'CA-CBN (Carbon, Alberta, Canada)'),
    ('CA-CRB', 'CA-CRB (Carbonear, Newfoundland and Labrador, Canada)'),
    ('CA-CAR', 'CA-CAR (Carcon City/Toronto, Ontario, Canada)'),
    ('CA-CDG', 'CA-CDG (Cardigan, Prince Edward Island, Canada)'),
    ('CA-CDN', 'CA-CDN (Cardinal, Ontario, Canada)'),
    ('CA-CDS', 'CA-CDS (Cardston, Alberta, Canada)'),
    ('CA-CGL', 'CA-CGL (Cargill, Ontario, Canada)'),
    ('CA-YCI', 'CA-YCI (Caribou Island, Ontario, Canada)'),
    ('CA-CGN', 'CA-CGN (Carignan, Quebec, Canada)'),
    ('CA-CLT', 'CA-CLT (Carleton, Quebec, Canada)'),
    ('CA-CLO', 'CA-CLO (Carleton Place, Ontario, Canada)'),
    ('CA-CLS', 'CA-CLS (Carlisle, Ontario, Canada)'),
    ('CA-RLS', 'CA-RLS (Carlsbad Springs, Ontario, Canada)'),
    ('CA-CS8', 'CA-CS8 (Carlyle, Saskatchewan, Canada)'),
    ('CA-CMN', 'CA-CMN (Carman, Manitoba, Canada)'),
    ('CA-CMV', 'CA-CMV (Carmanville, Newfoundland and Labrador, Canada)'),
    ('CA-CRN', 'CA-CRN (Caroline, Alberta, Canada)'),
    ('CA-CRP', 'CA-CRP (Carp, Ontario, Canada)'),
    ('CA-CLD', 'CA-CLD (Carseland, Alberta, Canada)'),
    ('CA-CTI', 'CA-CTI (Carstairs, Alberta, Canada)'),
    ('CA-HTC', 'CA-HTC (Carthage, Ontario, Canada)'),
    ('CA-CRT', 'CA-CRT (Cartier, Ontario, Canada)'),
    ('CA-RTE', 'CA-RTE (Cartier, Manitoba, Canada)'),
    ('CA-YCV', 'CA-YCV (Cartierville, Quebec, Canada)'),
    ('CA-YRF', 'CA-YRF (Cartwright, Newfoundland and Labrador, Canada)'),
    ('CA-CRV', 'CA-CRV (Carvel, Alberta, Canada)'),
    ('CA-CSS', 'CA-CSS (Casselman, Ontario, Canada)'),
    ('CA-CSD', 'CA-CSD (Cassidy, British Columbia, Canada)'),
    ('CA-YCG', 'CA-YCG (Castlegar, British Columbia, Canada)'),
    ('CA-CTT', 'CA-CTT (Castleton, Ontario, Canada)'),
    ('CA-CSR', 'CA-CSR (Castor, Alberta, Canada)'),
    ('CA-YAC', 'CA-YAC (Cat Lake, Ontario, Canada)'),
    ('CA-CAT', 'CA-CAT (Catalina, Newfoundland and Labrador, Canada)'),
    ('CA-AAU', 'CA-AAU (Causapscal, Quebec, Canada)'),
    ('CA-C8V', 'CA-C8V (Cavan, Ontario, Canada)'),
    ('CA-CAV', 'CA-CAV (Cavendish, Prince Edward Island, Canada)'),
    ('CA-CWO', 'CA-CWO (Cawston, British Columbia, Canada)'),
    ('CA-CLY', 'CA-CLY (Cayley, Alberta, Canada)'),
    ('CA-CYG', 'CA-CYG (Cayuga, Ontario, Canada)'),
    ('CA-CWR', 'CA-CWR (Central Waterville, New Brunswick, Canada)'),
    ('CA-YCE', 'CA-YCE (Centralia, Ontario, Canada)'),
    ('CA-CBU', 'CA-CBU (Centre Burlington, Nova Scotia, Canada)'),
    ('CA-CIS', 'CA-CIS (Centre Island, Ontario, Canada)'),
    ('CA-CEN', 'CA-CEN (Centreville, New Brunswick, Canada)'),
    ('CA-CTV', 'CA-CTV (Centreville, Nova Scotia, Canada)'),
    ('CA-NLC', 'CA-NLC (Centreville, Newfoundland and Labrador, Canada)'),
    ('CA-CFO', 'CA-CFO (Cessford, Alberta, Canada)'),
    ('CA-CKR', 'CA-CKR (Chalk River, Ontario, Canada)'),
    ('CA-CBL', 'CA-CBL (Chamberlains, Newfoundland and Labrador, Canada)'),
    ('CA-CHY', 'CA-CHY (Chambly, Quebec, Canada)'),
    ('CA-CMB', 'CA-CMB (Chambord, Quebec, Canada)'),
    ('CA-CPL', 'CA-CPL (Champlain, Quebec, Canada)'),
    ('CA-CHR', 'CA-CHR (Chandler, Quebec, Canada)'),
    ('CA-CIL', 'CA-CIL (Change Islands, Newfoundland and Labrador, Canada)'),
    ('CA-PBQ', 'CA-PBQ (Channel-Port aux Basques, Newfoundland and Labrador, Canada)'),
    ('CA-CPH', 'CA-CPH (Chapais, Quebec, Canada)'),
    ('CA-CP5', 'CA-CP5 (Chapel Arm, Newfoundland and Labrador, Canada)'),
    ('CA-YLD', 'CA-YLD (Chapleau, Ontario, Canada)'),
    ('CA-HPN', 'CA-HPN (Chaplin, Saskatchewan, Canada)'),
    ('CA-CTE', 'CA-CTE (Charette, Quebec, Canada)'),
    ('CA-CGS', 'CA-CGS (Charing Cross, Ontario, Canada)'),
    ('CA-CHG', 'CA-CHG (Charlesbourg, Quebec, Canada)'),
    ('CA-CKE', 'CA-CKE (Charlie Lake, British Columbia, Canada)'),
    ('CA-YCL', 'CA-YCL (Charlo, New Brunswick, Canada)'),
    ('CA-SKI', 'CA-SKI (Charlotte (Skidegate), British Columbia, Canada)'),
    ('CA-CHA', 'CA-CHA (Charlottetown, Prince Edward Island, Canada)'),
    ('CA-CRY', 'CA-CRY (Charny, Quebec, Canada)'),
    ('CA-CTL', 'CA-CTL (Chartierville, Quebec, Canada)'),
    ('CA-HAS', 'CA-HAS (Chase, British Columbia, Canada)'),
    ('CA-CHN', 'CA-CHN (Chatham, New Brunswick, Canada)'),
    ('CA-CTM', 'CA-CTM (Chatham, Ontario, Canada)'),
    ('CA-CHW', 'CA-CHW (Chatsworth, Ontario, Canada)'),
    ('CA-CTW', 'CA-CTW (Chatsworth, Ontario, Canada)'),
    ('CA-CUN', 'CA-CUN (Chebogue Point, Nova Scotia, Canada)'),
    ('CA-OH2', 'CA-OH2 (Chelmsford, Ontario, Canada)'),
    ('CA-CSA', 'CA-CSA (Chelsea, Quebec, Canada)'),
    ('CA-CHM', 'CA-CHM (Chemainus, British Columbia, Canada)'),
    ('CA-CPW', 'CA-CPW (Chepstow, Ontario, Canada)'),
    ('CA-CHE', 'CA-CHE (Cherryville, British Columbia, Canada)'),
    ('CA-CTY', 'CA-CTY (Chertsey, Quebec, Canada)'),
    ('CA-CEY', 'CA-CEY (Chesley, Ontario, Canada)'),
    ('CA-CST', 'CA-CST (Chester, Nova Scotia, Canada)'),
    ('CA-YCS', 'CA-YCS (Chester, Nova Scotia, Canada)'),
    ('CA-CTR', 'CA-CTR (Chestermere, Alberta, Canada)'),
    ('CA-CVE', 'CA-CVE (Chesterville, Quebec, Canada)'),
    ('CA-CVL', 'CA-CVL (Chesterville, Ontario, Canada)'),
    ('CA-YCQ', 'CA-YCQ (Chetwynd, British Columbia, Canada)'),
    ('CA-YHR', 'CA-YHR (Chevery, Quebec, Canada)'),
    ('CA-YMT', 'CA-YMT (Chibougamau, Quebec, Canada)'),
    ('CA-CHI', 'CA-CHI (Chicoutimi, Quebec, Canada)'),
    ('CA-CJH', 'CA-CJH (Chilko Lake, British Columbia, Canada)'),
    ('CA-CWK', 'CA-CWK (Chilliwack, British Columbia, Canada)'),
    ('CA-CPN', 'CA-CPN (Chipman, New Brunswick, Canada)'),
    ('CA-CHP', 'CA-CHP (Chippawa, Ontario, Canada)'),
    ('CA-YKU', 'CA-YKU (Chisasibi, Quebec, Canada)'),
    ('CA-CHO', 'CA-CHO (Chomedey, Quebec, Canada)'),
    ('CA-CBI', 'CA-CBI (Churchbridge, Saskatchewan, Canada)'),
    ('CA-CHH', 'CA-CHH (Churchill, Ontario, Canada)'),
    ('CA-CHV', 'CA-CHV (Churchill, Manitoba, Canada)'),
    ('CA-ZUM', 'CA-ZUM (Churchill Falls, Newfoundland and Labrador, Canada)'),
    ('CA-CAB', 'CA-CAB (Chute-a-Blondeau, Ontario, Canada)'),
    ('CA-RRE', 'CA-RRE (Château-Richer, Quebec, Canada)'),
    ('CA-CGY', 'CA-CGY (Châteauguay, Quebec, Canada)'),
    ('CA-CHT', 'CA-CHT (Chéticamp, Nova Scotia, Canada)'),
    ('CA-CIR', 'CA-CIR (Clair, New Brunswick, Canada)'),
    ('CA-CMT', 'CA-CMT (Clairmont, Alberta, Canada)'),
    ('CA-CLP', 'CA-CLP (Clam Point, Nova Scotia, Canada)'),
    ('CA-CYE', 'CA-CYE (Clandeboye, Manitoba, Canada)'),
    ('CA-CDD', 'CA-CDD (Clandonald, Alberta, Canada)'),
    ('CA-CLM', 'CA-CLM (Claremont, Ontario, Canada)'),
    ('CA-CCK', 'CA-CCK (Clarence Creek, Ontario, Canada)'),
    ('CA-CLA', 'CA-CLA (Clarenceville, Quebec, Canada)'),
    ('CA-CLE', 'CA-CLE (Clarenville, Newfoundland and Labrador, Canada)'),
    ('CA-CSO', 'CA-CSO (Claresholm, Alberta, Canada)'),
    ('CA-CLG', 'CA-CLG (Clarington, Ontario, Canada)'),
    ('CA-CLH', "CA-CLH (Clark's Harbour, Nova Scotia, Canada)"),
    ('CA-CLC', 'CA-CLC (Clarke City, Quebec, Canada)'),
    ('CA-CBH', "CA-CBH (Clarke's Beach, Newfoundland and Labrador, Canada)"),
    ('CA-CSB', 'CA-CSB (Clarksburg, Ontario, Canada)'),
    ('CA-CSN', 'CA-CSN (Clarkson, Ontario, Canada)'),
    ('CA-CLV', 'CA-CLV (Clavet, Saskatchewan, Canada)'),
    ('CA-COK', 'CA-COK (Clearbrook, British Columbia, Canada)'),
    ('CA-CWT', 'CA-CWT (Clearwater, British Columbia, Canada)'),
    ('CA-CSP', 'CA-CSP (Clementsport, Nova Scotia, Canada)'),
    ('CA-COT', 'CA-COT (Clermont, Quebec, Canada)'),
    ('CA-CVA', 'CA-CVA (Cleveland, Nova Scotia, Canada)'),
    ('CA-LLF', 'CA-LLF (Clifford, Ontario, Canada)'),
    ('CA-CMX', 'CA-CMX (Climax, Saskatchewan, Canada)'),
    ('CA-CLI', 'CA-CLI (Clinton, Ontario, Canada)'),
    ('CA-CON', 'CA-CON (Clinton, British Columbia, Canada)'),
    ('CA-YLM', 'CA-YLM (Clinton, British Columbia, Canada)'),
    ('CA-5DV', 'CA-5DV (Clive, Alberta, Canada)'),
    ('CA-CVD', 'CA-CVD (Cloverdale, British Columbia, Canada)'),
    ('CA-CNY', 'CA-CNY (Cluny, Alberta, Canada)'),
    ('CA-CLR', 'CA-CLR (Cluny, Alberta, Canada)'),
    ('CA-YCP', 'CA-YCP (Co-Op Point, Manitoba, Canada)'),
    ('CA-CAU', 'CA-CAU (Coal Harbour, British Columbia, Canada)'),
    ('CA-CDE', 'CA-CDE (Coaldale, Alberta, Canada)'),
    ('CA-CLU', 'CA-CLU (Coalhurst, Alberta, Canada)'),
    ('CA-COA', 'CA-COA (Coaticook, Quebec, Canada)'),
    ('CA-CR5', 'CA-CR5 (Coatsworth, Ontario, Canada)'),
    ('CA-CHL', 'CA-CHL (Cobble Hill, British Columbia, Canada)'),
    ('CA-CBD', 'CA-CBD (Cobden, Ontario, Canada)'),
    ('CA-CBG', 'CA-CBG (Cobourg, Ontario, Canada)'),
    ('CA-COE', 'CA-COE (Cocagne, New Brunswick, Canada)'),
    ('CA-CCH', 'CA-CCH (Cochrane, Alberta, Canada)'),
    ('CA-YCN', 'CA-YCN (Cochrane, Ontario, Canada)'),
    ('CA-CHS', 'CA-CHS (Cohasset, Nova Scotia, Canada)'),
    ('CA-CLB', 'CA-CLB (Colborne, Ontario, Canada)'),
    ('CA-CCC', 'CA-CCC (Colchester County, Nova Scotia, Canada)'),
    ('CA-YOD', 'CA-YOD (Cold Lake, Alberta, Canada)'),
    ('CA-CDB', 'CA-CDB (Coldbrook, Nova Scotia, Canada)'),
    ('CA-CDM', 'CA-CDM (Coldstream, British Columbia, Canada)'),
    ('CA-CDW', 'CA-CDW (Coldwater, Ontario, Canada)'),
    ('CA-CEM', 'CA-CEM (Coleman, Alberta, Canada)'),
    ('CA-CPD', 'CA-CPD (Coleman, Prince Edward Island, Canada)'),
    ('CA-CYP', "CA-CYP (Coley's Point, Newfoundland and Labrador, Canada)"),
    ('CA-COL', 'CA-COL (Collingwood, Ontario, Canada)'),
    ('CA-ORE', 'CA-ORE (Collingwood Corner, Nova Scotia, Canada)'),
    ('CA-YKC', 'CA-YKC (Collins Bay, Saskatchewan, Canada)'),
    ('CA-COY', 'CA-COY (Colonsay, Saskatchewan, Canada)'),
    ('CA-YCK', 'CA-YCK (Colonsay, Saskatchewan, Canada)'),
    ('CA-CLW', 'CA-CLW (Colwood, British Columbia, Canada)'),
    ('CA-COB', 'CA-COB (Comber, Ontario, Canada)'),
    ('CA-CBM', 'CA-CBM (Combermere, Ontario, Canada)'),
    ('CA-CBC', 'CA-CBC (Come By Chance, Newfoundland and Labrador, Canada)'),
    ('CA-CCV', 'CA-CCV (Comfort Cove, Newfoundland and Labrador, Canada)'),
    ('CA-CND', 'CA-CND (Comfort Cove-Newstead, Newfoundland and Labrador, Canada)'),
    ('CA-COX', 'CA-COX (Comox, British Columbia, Canada)'),
    ('CA-CMP', 'CA-CMP (Compton, Quebec, Canada)'),
    ('CA-ZBL', 'CA-ZBL (Conception Bay South, Newfoundland and Labrador, Canada)'),
    ('CA-CNC', 'CA-CNC (Concord, Ontario, Canada)'),
    ('CA-CSJ', 'CA-CSJ (Coniston, Ontario, Canada)'),
    ('CA-CNN', 'CA-CNN (Conklin, Alberta, Canada)'),
    ('CA-CQT', 'CA-CQT (Conquitlam, British Columbia, Canada)'),
    ('CA-COC', 'CA-COC (Contrecoeur, Quebec, Canada)'),
    ('CA-CKS', 'CA-CKS (Cookshire, Quebec, Canada)'),
    ('CA-CSW', 'CA-CSW (Cookstown, Ontario, Canada)'),
    ('CA-CVI', 'CA-CVI (Cooksville, Ontario, Canada)'),
    ('CA-OKC', 'CA-OKC (Cookville, Nova Scotia, Canada)'),
    ('CA-COO', 'CA-COO (Coombs, British Columbia, Canada)'),
    ('CA-CFL', 'CA-CFL (Cooper Cliff, Ontario, Canada)'),
    ('CA-CPC', 'CA-CPC (Copper Cliff, Ontario, Canada)'),
    ('CA-COP', 'CA-COP (Copper Cliff, Ontario, Canada)'),
    ('CA-COQ', 'CA-COQ (Coquitlam, British Columbia, Canada)'),
    ('CA-YZS', 'CA-YZS (Coquitlam, British Columbia, Canada)'),
    ('CA-CBR', 'CA-CBR (Corbeil, Ontario, Canada)'),
    ('CA-CBK', 'CA-CBK (Corner Brook, Newfoundland and Labrador, Canada)'),
    ('CA-CNH', 'CA-CNH (Cornhill, New Brunswick, Canada)'),
    ('CA-CNW', 'CA-CNW (Cornwall, Prince Edward Island, Canada)'),
    ('CA-CWL', 'CA-CWL (Cornwall, Ontario, Canada)'),
    ('CA-CWS', 'CA-CWS (Cornwallis, Nova Scotia, Canada)'),
    ('CA-CWI', 'CA-CWI (Cornwallis, Nova Scotia, Canada)'),
    ('CA-YCT', 'CA-YCT (Coronation, Alberta, Canada)'),
    ('CA-YCF', 'CA-YCF (Cortes Bay, British Columbia, Canada)'),
    ('CA-COR', 'CA-COR (Corunna, Ontario, Canada)'),
    ('CA-CQA', 'CA-CQA (Coteau du Lac, Quebec, Canada)'),
    ('CA-CTA', 'CA-CTA (Cottam, Ontario, Canada)'),
    ('CA-COH', 'CA-COH (Country Harbour, Nova Scotia, Canada)'),
    ('CA-CRE', 'CA-CRE (Courcelette, Quebec, Canada)'),
    ('CA-CCL', 'CA-CCL (Courcelles, Quebec, Canada)'),
    ('CA-COU', 'CA-COU (Courtenay, British Columbia, Canada)'),
    ('CA-CRC', 'CA-CRC (Courtice, Ontario, Canada)'),
    ('CA-CLN', 'CA-CLN (Courtland, Ontario, Canada)'),
    ('CA-CRR', 'CA-CRR (Courtright, Ontario, Canada)'),
    ('CA-CTS', 'CA-CTS (Coutts, Alberta, Canada)'),
    ('CA-CVO', 'CA-CVO (Covehead, Prince Edward Island, Canada)'),
    ('CA-CWH', 'CA-CWH (Cow Head, Newfoundland and Labrador, Canada)'),
    ('CA-COW', 'CA-COW (Cowansville, Quebec, Canada)'),
    ('CA-CCB', 'CA-CCB (Cowichan Bay, British Columbia, Canada)'),
    ('CA-YYM', 'CA-YYM (Cowley, Alberta, Canada)'),
    ('CA-TRE', 'CA-TRE (Crabtree, Quebec, Canada)'),
    ('CA-CPG', 'CA-CPG (Cranberry Portage, Manitoba, Canada)'),
    ('CA-YXC', 'CA-YXC (Cranbrook, British Columbia, Canada)'),
    ('CA-CRA', 'CA-CRA (Cranford, Alberta, Canada)'),
    ('CA-CRD', 'CA-CRD (Crapaud, Prince Edward Island, Canada)'),
    ('CA-CVN', 'CA-CVN (Craven, Saskatchewan, Canada)'),
    ('CA-CRM', 'CA-CRM (Creemore, Ontario, Canada)'),
    ('CA-CGT', 'CA-CGT (Creighton, Saskatchewan, Canada)'),
    ('CA-CMA', 'CA-CMA (Cremona, Alberta, Canada)'),
    ('CA-CFQ', 'CA-CFQ (Creston, British Columbia, Canada)'),
    ('CA-CRO', 'CA-CRO (Crofton, British Columbia, Canada)'),
    ('CA-YCR', 'CA-YCR (Cross Lake, Manitoba, Canada)'),
    ('CA-CSF', 'CA-CSF (Crossfield, Alberta, Canada)'),
    ('CA-CYS', 'CA-CYS (Crysler, Ontario, Canada)'),
    ('CA-CBE', 'CA-CBE (Crystal Beach, Ontario, Canada)'),
    ('CA-CCI', 'CA-CCI (Crystal City, Manitoba, Canada)'),
    ('CA-CUL', 'CA-CUL (Cultus Lake, British Columbia, Canada)'),
    ('CA-OCL', 'CA-OCL (Cumberland, Ontario, Canada)'),
    ('CA-CUM', 'CA-CUM (Cumberland Bay, New Brunswick, Canada)'),
    ('CA-CPS', 'CA-CPS (Cupids, Newfoundland and Labrador, Canada)'),
    ('CA-CKF', 'CA-CKF (Cut Knife, Saskatchewan, Canada)'),
    ('CA-CSL', 'CA-CSL (Côte-Saint-Luc, Quebec, Canada)'),
    ('CA-CSU', 'CA-CSU (Côte-Saint-Luc, Quebec, Canada)'),
    ('CA-CSC', 'CA-CSC (Côte-Sainte-Catherine, Quebec, Canada)'),
    ('CA-DAC', 'CA-DAC (Dacre, Ontario, Canada)'),
    ('CA-DHS', 'CA-DHS (Dalhousie, New Brunswick, Canada)'),
    ('CA-DKH', 'CA-DKH (Dalkeith, Ontario, Canada)'),
    ('CA-YDH', 'CA-YDH (Daniels Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-DVL', 'CA-DVL (Danville, Quebec, Canada)'),
    ('CA-DAR', 'CA-DAR (Dartmouth, Nova Scotia, Canada)'),
    ('CA-DWO', 'CA-DWO (Dashwood, Ontario, Canada)'),
    ('CA-YDN', 'CA-YDN (Dauphin, Manitoba, Canada)'),
    ('CA-DYV', 'CA-DYV (Daveluyville, Quebec, Canada)'),
    ('CA-DVO', 'CA-DVO (Davidson, Quebec, Canada)'),
    ('CA-YDI', 'CA-YDI (Davis Inlet, Newfoundland and Labrador, Canada)'),
    ('CA-YDA', 'CA-YDA (Davis Inlet, Newfoundland and Labrador, Canada)'),
    ('CA-YDQ', 'CA-YDQ (Dawson Creek, British Columbia, Canada)'),
    ('CA-DWI', 'CA-DWI (De Winton, Alberta, Canada)'),
    ('CA-YRD', 'CA-YRD (Dean River, British Columbia, Canada)'),
    ('CA-YDL', 'CA-YDL (Dease Lake, British Columbia, Canada)'),
    ('CA-DET', 'CA-DET (Debert Station, Nova Scotia, Canada)'),
    ('CA-DBL', 'CA-DBL (Debolt, Alberta, Canada)'),
    ('CA-DEB', 'CA-DEB (Deception Bay, Quebec, Canada)'),
    ('CA-DEC', 'CA-DEC (Decker, Manitoba, Canada)'),
    ('CA-DRR', 'CA-DRR (Deep River, Ontario, Canada)'),
    ('CA-DEI', 'CA-DEI (Deer Island, New Brunswick, Canada)'),
    ('CA-YDF', 'CA-YDF (Deer Lake, Newfoundland and Labrador, Canada)'),
    ('CA-YVZ', 'CA-YVZ (Deer Lake, Ontario, Canada)'),
    ('CA-DGL', 'CA-DGL (Degelis, Quebec, Canada)'),
    ('CA-DWR', 'CA-DWR (Delaware, Ontario, Canada)'),
    ('CA-DLG', 'CA-DLG (Deleage, Quebec, Canada)'),
    ('CA-DLI', 'CA-DLI (Delhi, Ontario, Canada)'),
    ('CA-LIS', 'CA-LIS (Delisle, Saskatchewan, Canada)'),
    ('CA-DRN', 'CA-DRN (Deloraine, Manitoba, Canada)'),
    ('CA-DLS', 'CA-DLS (Delson/Quebec, Quebec, Canada)'),
    ('CA-DEL', 'CA-DEL (Delta, British Columbia, Canada)'),
    ('CA-DMV', 'CA-DMV (Demorestville, Ontario, Canada)'),
    ('CA-DFI', 'CA-DFI (Denfield, Ontario, Canada)'),
    ('CA-DSA', 'CA-DSA (Denman Island, British Columbia, Canada)'),
    ('CA-DER', 'CA-DER (Deroche, British Columbia, Canada)'),
    ('CA-DSO', 'CA-DSO (Desboro, Ontario, Canada)'),
    ('CA-DCH', 'CA-DCH (Deschaillons-sur-Saint-Laurent, Quebec, Canada)'),
    ('CA-DBT', 'CA-DBT (Deschambault, Quebec, Canada)'),
    ('CA-DSR', 'CA-DSR (Deseronto, Ontario, Canada)'),
    ('CA-YDS', 'CA-YDS (Desolation Sound, British Columbia, Canada)'),
    ('CA-DMG', 'CA-DMG (Deux-Montagnes, Quebec, Canada)'),
    ('CA-DVN', 'CA-DVN (Devon, Alberta, Canada)'),
    ('CA-DEW', 'CA-DEW (Dewberry, Alberta, Canada)'),
    ('CA-DIC', 'CA-DIC (Diamond City, Alberta, Canada)'),
    ('CA-DID', 'CA-DID (Didsbury, Alberta, Canada)'),
    ('CA-DPP', 'CA-DPP (Dieppe, New Brunswick, Canada)'),
    ('CA-DIG', 'CA-DIG (Digby, Nova Scotia, Canada)'),
    ('CA-DIL', 'CA-DIL (Dildo, Newfoundland and Labrador, Canada)'),
    ('CA-DLK', 'CA-DLK (Dilke, Saskatchewan, Canada)'),
    ('CA-DMS', 'CA-DMS (Dimsdale, Alberta, Canada)'),
    ('CA-DWL', 'CA-DWL (Dingwall, Nova Scotia, Canada)'),
    ('CA-DSL', 'CA-DSL (Disraeli, Quebec, Canada)'),
    ('CA-DOA', 'CA-DOA (Doaktown, New Brunswick, Canada)'),
    ('CA-DTO', 'CA-DTO (Dobbinton, Ontario, Canada)'),
    ('CA-YDX', 'CA-YDX (Doc Creek, British Columbia, Canada)'),
    ('CA-YDO', 'CA-YDO (Dolbeau, Quebec, Canada)'),
    ('CA-DDO', 'CA-DDO (Dollard-des-Ormeaux, Quebec, Canada)'),
    ('CA-DOM', 'CA-DOM (Don Mills, Ontario, Canada)'),
    ('CA-DOK', 'CA-DOK (Donkin, Nova Scotia, Canada)'),
    ('CA-DNC', 'CA-DNC (Donnacona, Quebec, Canada)'),
    ('CA-DCS', 'CA-DCS (Dorchester, Ontario, Canada)'),
    ('CA-DHR', 'CA-DHR (Dorchester, New Brunswick, Canada)'),
    ('CA-QCD', 'CA-QCD (Dorion, Quebec, Canada)'),
    ('CA-DOR', 'CA-DOR (Dorval, Quebec, Canada)'),
    ('CA-DQT', 'CA-DQT (Dosquet, Quebec, Canada)'),
    ('CA-DXS', 'CA-DXS (Douglas, Ontario, Canada)'),
    ('CA-DGF', 'CA-DGF (Douglas Lake, British Columbia, Canada)'),
    ('CA-6OD', 'CA-6OD (Douglas Point, Ontario, Canada)'),
    ('CA-DWG', 'CA-DWG (Dowling, Ontario, Canada)'),
    ('CA-DVW', 'CA-DVW (Downsview, Ontario, Canada)'),
    ('CA-DYT', 'CA-DYT (Drayton, Ontario, Canada)'),
    ('CA-YDC', 'CA-YDC (Drayton Valley, Alberta, Canada)'),
    ('CA-DRD', 'CA-DRD (Dresden, Ontario, Canada)'),
    ('CA-DRM', 'CA-DRM (Drumheller, Alberta, Canada)'),
    ('CA-DMO', 'CA-DMO (Drummond, New Brunswick, Canada)'),
    ('CA-DRU', 'CA-DRU (Drummondville, Quebec, Canada)'),
    ('CA-DRY', 'CA-DRY (Dryden, Ontario, Canada)'),
    ('CA-DLN', 'CA-DLN (Dublin, Ontario, Canada)'),
    ('CA-D8O', 'CA-D8O (Dubreuilville, Ontario, Canada)'),
    ('CA-DES', 'CA-DES (Duchess, Alberta, Canada)'),
    ('CA-DKL', 'CA-DKL (Duck Lake, Saskatchewan, Canada)'),
    ('CA-DFL', 'CA-DFL (Duffield, Alberta, Canada)'),
    ('CA-DGD', 'CA-DGD (Dugald, Manitoba, Canada)'),
    ('CA-DHO', 'CA-DHO (Duhamel-Ouest, Quebec, Canada)'),
    ('CA-DCN', 'CA-DCN (Duncan Bay, British Columbia, Canada)'),
    ('CA-DUQ', 'CA-DUQ (Duncan/Quam, British Columbia, Canada)'),
    ('CA-DUC', 'CA-DUC (Dunchurch, Ontario, Canada)'),
    ('CA-DNK', 'CA-DNK (Dundalk, Ontario, Canada)'),
    ('CA-DUD', 'CA-DUD (Dundas, Ontario, Canada)'),
    ('CA-DDE', 'CA-DDE (Dundee, Quebec, Canada)'),
    ('CA-DDN', 'CA-DDN (Dundurn, Saskatchewan, Canada)'),
    ('CA-GNX', 'CA-GNX (Dunganon, Ontario, Canada)'),
    ('CA-DQQ', 'CA-DQQ (Dunham, Quebec, Canada)'),
    ('CA-DHQ', 'CA-DHQ (Dunman, Ontario, Canada)'),
    ('CA-DNM', 'CA-DNM (Dunmore, Alberta, Canada)'),
    ('CA-DUV', 'CA-DUV (Dunnville, Ontario, Canada)'),
    ('CA-DRA', 'CA-DRA (Dunrea, Manitoba, Canada)'),
    ('CA-DOO', 'CA-DOO (Duntroon, Ontario, Canada)'),
    ('CA-DUR', 'CA-DUR (Durham, Ontario, Canada)'),
    ('CA-DUO', 'CA-DUO (Dutton, Ontario, Canada)'),
    ('CA-DUA', 'CA-DUA (Duval, Saskatchewan, Canada)'),
    ('CA-DYA', 'CA-DYA (Dysart, Saskatchewan, Canada)'),
    ('CA-YWJ', 'CA-YWJ (Dysart, Saskatchewan, Canada)'),
    ('CA-EFS', 'CA-EFS (Ear Falls, Ontario, Canada)'),
    ('CA-YXR', 'CA-YXR (Earlton, Ontario, Canada)'),
    ('CA-ETA', 'CA-ETA (East Angus, Quebec, Canada)'),
    ('CA-EBS', 'CA-EBS (East Broughton Station, Quebec, Canada)'),
    ('CA-EG5', 'CA-EG5 (East Garafraxa, Ontario, Canada)'),
    ('CA-GWY', 'CA-GWY (East Gwillimbury, Ontario, Canada)'),
    ('CA-EHD', 'CA-EHD (East Hereford, Quebec, Canada)'),
    ('CA-EKE', 'CA-EKE (East Kemptville, Nova Scotia, Canada)'),
    ('CA-ZEM', 'CA-ZEM (East Main, Quebec, Canada)'),
    ('CA-ERV', 'CA-ERV (East River, Nova Scotia, Canada)'),
    ('CA-EPL', 'CA-EPL (East Saint-Paul, Manitoba, Canada)'),
    ('CA-EAS', 'CA-EAS (East York, Ontario, Canada)'),
    ('CA-EPG', 'CA-EPG (Eastern Passage, Nova Scotia, Canada)'),
    ('CA-EBZ', 'CA-EBZ (Ebenezer, Prince Edward Island, Canada)'),
    ('CA-ECB', 'CA-ECB (Echo Bay, Ontario, Canada)'),
    ('CA-EKV', 'CA-EKV (Eckville, Alberta, Canada)'),
    ('CA-ECO', 'CA-ECO (Economy, Nova Scotia, Canada)'),
    ('CA-EDA', 'CA-EDA (Edam, Saskatchewan, Canada)'),
    ('CA-EDB', 'CA-EDB (Edberg, Alberta, Canada)'),
    ('CA-EDM', 'CA-EDM (Edmonton, Alberta, Canada)'),
    ('CA-YEG', 'CA-YEG (Edmonton Int Apt, Alberta, Canada)'),
    ('CA-EDN', 'CA-EDN (Edmundston, New Brunswick, Canada)'),
    ('CA-EDS', 'CA-EDS (Edson, Alberta, Canada)'),
    ('CA-EDC', 'CA-EDC (Edwards Cove, Newfoundland and Labrador, Canada)'),
    ('CA-ESN', 'CA-ESN (Edwardsville, Nova Scotia, Canada)'),
    ('CA-EGV', 'CA-EGV (Eganville, Ontario, Canada)'),
    ('CA-EGN', 'CA-EGN (Elgin, New Brunswick, Canada)'),
    ('CA-ELI', 'CA-ELI (Elie, Manitoba, Canada)'),
    ('CA-EZT', 'CA-EZT (Elizabethtown, Ontario, Canada)'),
    ('CA-ELT', 'CA-ELT (Elk Point, Alberta, Canada)'),
    ('CA-EKF', 'CA-EKF (Elkford, British Columbia, Canada)'),
    ('CA-EHO', 'CA-EHO (Elkhorn, Manitoba, Canada)'),
    ('CA-ELS', 'CA-ELS (Ellerslie, Prince Edward Island, Canada)'),
    ('CA-ELL', 'CA-ELL (Ellerslie/Edmonton, Alberta, Canada)'),
    ('CA-YEL', 'CA-YEL (Elliot Lake, Ontario, Canada)'),
    ('CA-ECK', 'CA-ECK (Elm Creek, Manitoba, Canada)'),
    ('CA-EML', 'CA-EML (Elma, Manitoba, Canada)'),
    ('CA-ELM', 'CA-ELM (Elmira, Ontario, Canada)'),
    ('CA-EMR', 'CA-EMR (Elmira, Prince Edward Island, Canada)'),
    ('CA-ELE', 'CA-ELE (Elmsdale, Nova Scotia, Canada)'),
    ('CA-EVV', 'CA-EVV (Elmvale, Ontario, Canada)'),
    ('CA-EMD', 'CA-EMD (Elmwood, Ontario, Canada)'),
    ('CA-ELN', 'CA-ELN (Elnora, Alberta, Canada)'),
    ('CA-ELO', 'CA-ELO (Elora, Ontario, Canada)'),
    ('CA-OSE', 'CA-OSE (Elrose, Saskatchewan, Canada)'),
    ('CA-EMB', 'CA-EMB (Embro, Ontario, Canada)'),
    ('CA-EBU', 'CA-EBU (Embrun, Ontario, Canada)'),
    ('CA-XVX', 'CA-XVX (Emerald Park, Saskatchewan, Canada)'),
    ('CA-EME', 'CA-EME (Emerson, Manitoba, Canada)'),
    ('CA-EYV', 'CA-EYV (Emeryville, Ontario, Canada)'),
    ('CA-EMO', 'CA-EMO (Emo, Ontario, Canada)'),
    ('CA-EMP', 'CA-EMP (Empress, Alberta, Canada)'),
    ('CA-DSS', 'CA-DSS (Emsdale, Ontario, Canada)'),
    ('CA-END', 'CA-END (Endako, British Columbia, Canada)'),
    ('CA-ENY', 'CA-ENY (Enderby, British Columbia, Canada)'),
    ('CA-ENF', 'CA-ENF (Enfield, Nova Scotia, Canada)'),
    ('CA-ENG', 'CA-ENG (Engelwood, British Columbia, Canada)'),
    ('CA-EGF', 'CA-EGF (Englefeld, Saskatchewan, Canada)'),
    ('CA-EGH', 'CA-EGH (Englehart, Ontario, Canada)'),
    ('CA-EBY', 'CA-EBY (English Bay, British Columbia, Canada)'),
    ('CA-ENN', 'CA-ENN (Enniskillen, Ontario, Canada)'),
    ('CA-ENT', 'CA-ENT (Entwistle, Alberta, Canada)'),
    ('CA-EKO', 'CA-EKO (Erickson, British Columbia, Canada)'),
    ('CA-ENE', 'CA-ENE (Erieau, Ontario, Canada)'),
    ('CA-ERI', 'CA-ERI (Erin, Ontario, Canada)'),
    ('CA-EGT', 'CA-EGT (Errington, British Columbia, Canada)'),
    ('CA-EPA', 'CA-EPA (Espanola, Ontario, Canada)'),
    ('CA-ESQ', 'CA-ESQ (Esquimalt, British Columbia, Canada)'),
    ('CA-ESS', 'CA-ESS (Essex, Ontario, Canada)'),
    ('CA-EHZ', 'CA-EHZ (Esterhazy, Saskatchewan, Canada)'),
    ('CA-EZY', 'CA-EZY (Esterhazy, Saskatchewan, Canada)'),
    ('CA-EST', 'CA-EST (Estevan, Saskatchewan, Canada)'),
    ('CA-YEP', 'CA-YEP (Estevan Point, British Columbia, Canada)'),
    ('CA-ETN', 'CA-ETN (Etang-du-Nord, Quebec, Canada)'),
    ('CA-ETL', 'CA-ETL (Ethel, Ontario, Canada)'),
    ('CA-ETH', 'CA-ETH (Ethelbert, Manitoba, Canada)'),
    ('CA-ETC', 'CA-ETC (Etobicoke, Ontario, Canada)'),
    ('CA-ETZ', 'CA-ETZ (Etzikom, Alberta, Canada)'),
    ('CA-EXX', 'CA-EXX (Exeter, Ontario, Canada)'),
    ('CA-EXS', 'CA-EXS (Exshaw, Alberta, Canada)'),
    ('CA-FVL', 'CA-FVL (Fabreville, Quebec, Canada)'),
    ('CA-FHS', 'CA-FHS (Fairmont Hot Springs, British Columbia, Canada)'),
    ('CA-YCZ', 'CA-YCZ (Fairmount Springs, British Columbia, Canada)'),
    ('CA-ZFW', 'CA-ZFW (Fairview, Alberta, Canada)'),
    ('CA-FCB', 'CA-FCB (Falconbridge, Ontario, Canada)'),
    ('CA-YOE', 'CA-YOE (Falher, Alberta, Canada)'),
    ('CA-FLA', 'CA-FLA (Falkland, British Columbia, Canada)'),
    ('CA-FLR', 'CA-FLR (Fall River, Nova Scotia, Canada)'),
    ('CA-FAH', 'CA-FAH (Falmouth, Nova Scotia, Canada)'),
    ('CA-FYB', 'CA-FYB (Fanny Bay, British Columbia, Canada)'),
    ('CA-FAR', 'CA-FAR (Farnham, Quebec, Canada)'),
    ('CA-FRN', 'CA-FRN (Farnham, Ontario, Canada)'),
    ('CA-ZFA', 'CA-ZFA (Farnham, Ontario, Canada)'),
    ('CA-FSS', 'CA-FSS (Fassett, Quebec, Canada)'),
    ('CA-FAP', 'CA-FAP (Father Point, Quebec, Canada)'),
    ('CA-FKR', 'CA-FKR (Faulkner, Manitoba, Canada)'),
    ('CA-FEF', 'CA-FEF (Fenelon Falls, Ontario, Canada)'),
    ('CA-FWC', 'CA-FWC (Fenwick, Ontario, Canada)'),
    ('CA-FGS', 'CA-FGS (Fenwick, Ontario, Canada)'),
    ('CA-FRG', 'CA-FRG (Fergus, Ontario, Canada)'),
    ('CA-FTO', 'CA-FTO (Ferintosh, Alberta, Canada)'),
    ('CA-FNV', 'CA-FNV (Ferme-Neuve, Quebec, Canada)'),
    ('CA-FME', 'CA-FME (Fermeuse, Newfoundland and Labrador, Canada)'),
    ('CA-FMT', 'CA-FMT (Fermont, Quebec, Canada)'),
    ('CA-FNI', 'CA-FNI (Fernie, British Columbia, Canada)'),
    ('CA-FFE', 'CA-FFE (Feversham, Ontario, Canada)'),
    ('CA-FMO', 'CA-FMO (Fillmore, Saskatchewan, Canada)'),
    ('CA-FIN', 'CA-FIN (Finch, Ontario, Canada)'),
    ('CA-FGA', 'CA-FGA (Fingal, Ontario, Canada)'),
    ('CA-FIB', 'CA-FIB (Fisher Branch, Manitoba, Canada)'),
    ('CA-FLT', 'CA-FLT (Flat Rock, Newfoundland and Labrador, Canada)'),
    ('CA-YFO', 'CA-YFO (Flin Flon, Manitoba, Canada)'),
    ('CA-FDL', 'CA-FDL (Floradale, Ontario, Canada)'),
    ('CA-XFL', 'CA-XFL (Florence, Ontario, Canada)'),
    ('CA-FLV', 'CA-FLV (Florenceville, New Brunswick, Canada)'),
    ('CA-OLK', 'CA-OLK (Foam Lake, Saskatchewan, Canada)'),
    ('CA-FOG', 'CA-FOG (Fogo, Newfoundland and Labrador, Canada)'),
    ('CA-FYT', 'CA-FYT (Foleyet, Ontario, Canada)'),
    ('CA-ZFD', 'CA-ZFD (Fond du Lac, Saskatchewan, Canada)'),
    ('CA-YFG', 'CA-YFG (Fontanges, Quebec, Canada)'),
    ('CA-FTH', 'CA-FTH (Fonthill, Ontario, Canada)'),
    ('CA-FWI', 'CA-FWI (Fordwich, Ontario, Canada)'),
    ('CA-FOM', 'CA-FOM (Foremost, Alberta, Canada)'),
    ('CA-ZFT', 'CA-ZFT (Forest, Ontario, Canada)'),
    ('CA-FBG', 'CA-FBG (Forestburg, Alberta, Canada)'),
    ('CA-FFL', 'CA-FFL (Foresters Falls, Ontario, Canada)'),
    ('CA-FRV', 'CA-FRV (Forestville, Quebec, Canada)'),
    ('CA-FMS', 'CA-FMS (Formosa, Ontario, Canada)'),
    ('CA-FAL', 'CA-FAL (Fort Albany, Ontario, Canada)'),
    ('CA-YPY', 'CA-YPY (Fort Chipewyan, Alberta, Canada)'),
    ('CA-FCO', 'CA-FCO (Fort Coulonge, Quebec, Canada)'),
    ('CA-FER', 'CA-FER (Fort Erie, Ontario, Canada)'),
    ('CA-FFS', 'CA-FFS (Fort Frances, Ontario, Canada)'),
    ('CA-FKN', 'CA-FKN (Fort Frances, Ontario, Canada)'),
    ('CA-YGH', 'CA-YGH (Fort Frances, Ontario, Canada)'),
    ('CA-YFH', 'CA-YFH (Fort Hope, Ontario, Canada)'),
    ('CA-FLY', 'CA-FLY (Fort Langley, British Columbia, Canada)'),
    ('CA-YJF', 'CA-YJF (Fort Langley, British Columbia, Canada)'),
    ('CA-FMA', 'CA-FMA (Fort MacKay, Alberta, Canada)'),
    ('CA-FMC', 'CA-FMC (Fort Macleod, Alberta, Canada)'),
    ('CA-YMM', 'CA-YMM (Fort McMurray, Alberta, Canada)'),
    ('CA-ZFM', 'CA-ZFM (Fort McMurray, Alberta, Canada)'),
    ('CA-FNE', 'CA-FNE (Fort Nelson, British Columbia, Canada)'),
    ('CA-FPR', 'CA-FPR (Fort Nelson, British Columbia, Canada)'),
    ('CA-FQP', "CA-FQP (Fort Qu'Appelle, Saskatchewan, Canada)"),
    ('CA-YFL', "CA-YFL (Fort Qu'Appelle, Saskatchewan, Canada)"),
    ('CA-YFR', "CA-YFR (Fort Qu'Appelle, Saskatchewan, Canada)"),
    ('CA-FSK', 'CA-FSK (Fort Saskatchewan, Alberta, Canada)'),
    ('CA-YER', 'CA-YER (Fort Severn, Ontario, Canada)'),
    ('CA-FSI', 'CA-FSI (Fort Severn, Ontario, Canada)'),
    ('CA-FSM', 'CA-FSM (Fort Severn, Ontario, Canada)'),
    ('CA-FST', 'CA-FST (Fort Steele, British Columbia, Canada)'),
    ('CA-FVE', 'CA-FVE (Fort Vermilion, Alberta, Canada)'),
    ('CA-WAR', 'CA-WAR (Fort Ware, British Columbia, Canada)'),
    ('CA-FWL', 'CA-FWL (Fort William, Ontario, Canada)'),
    ('CA-SJA', 'CA-SJA (Fort-Saint-James, British Columbia, Canada)'),
    ('CA-FSJ', 'CA-FSJ (Fort-Saint-John, British Columbia, Canada)'),
    ('CA-Q9Q', 'CA-Q9Q (Fortierville, Quebec, Canada)'),
    ('CA-FOR', 'CA-FOR (Fortune, Newfoundland and Labrador, Canada)'),
    ('CA-FOS', 'CA-FOS (Fosterville, New Brunswick, Canada)'),
    ('CA-FNR', 'CA-FNR (Fournier, Ontario, Canada)'),
    ('CA-FXC', 'CA-FXC (Fox Creek, Alberta, Canada)'),
    ('CA-YFX', 'CA-YFX (Fox Harbour (St Lewis), Newfoundland and Labrador, Canada)'),
    ('CA-FLK', 'CA-FLK (Fox Lake, Alberta, Canada)'),
    ('CA-QCF', 'CA-QCF (Fox River (=riviere-Au-Renard), Quebec, Canada)'),
    ('CA-FXV', 'CA-FXV (Fox Valley, Saskatchewan, Canada)'),
    ('CA-FXO', 'CA-FXO (Foxboro, Ontario, Canada)'),
    ('CA-FOX', 'CA-FOX (Foxley River, Prince Edward Island, Canada)'),
    ('CA-FPT', 'CA-FPT (Frampton, Quebec, Canada)'),
    ('CA-FCS', 'CA-FCS (Francis, Saskatchewan, Canada)'),
    ('CA-FKO', 'CA-FKO (Frankford, Ontario, Canada)'),
    ('CA-JFK', 'CA-JFK (Franklin Centre, Quebec, Canada)'),
    ('CA-FRK', 'CA-FRK (Frankville, Ontario, Canada)'),
    ('CA-FRL', 'CA-FRL (François Lake, British Columbia, Canada)'),
    ('CA-FRM', 'CA-FRM (Fraser, British Columbia, Canada)'),
    ('CA-FRA', 'CA-FRA (Fraser Mills, British Columbia, Canada)'),
    ('CA-FRR', 'CA-FRR (Fraser River, British Columbia, Canada)'),
    ('CA-FWS', 'CA-FWS (Fraser Wharves, British Columbia, Canada)'),
    ('CA-FSD', 'CA-FSD (Fraser-Surrey Docks, British Columbia, Canada)'),
    ('CA-FRE', 'CA-FRE (Fredericton, New Brunswick, Canada)'),
    ('CA-FRT', 'CA-FRT (Freelton, Ontario, Canada)'),
    ('CA-FTW', 'CA-FTW (Freetown, Prince Edward Island, Canada)'),
    ('CA-FGH', 'CA-FGH (Frelighsburg, Quebec, Canada)'),
    ('CA-FWP', 'CA-FWP (Freshwater, Newfoundland and Labrador, Canada)'),
    ('CA-YFB', 'CA-YFB (Freshwater, Newfoundland and Labrador, Canada)'),
    ('CA-FRO', 'CA-FRO (Frontier, Saskatchewan, Canada)'),
    ('CA-FRU', 'CA-FRU (Fruitvale, British Columbia, Canada)'),
    ('CA-GHS', 'CA-GHS (Gads Hill Station, Ontario, Canada)'),
    ('CA-YCX', 'CA-YCX (Gagetown, New Brunswick, Canada)'),
    ('CA-YGA', 'CA-YGA (Gagnon, Quebec, Canada)'),
    ('CA-GLT', 'CA-GLT (Galt, Ontario, Canada)'),
    ('CA-GNE', 'CA-GNE (Gananoque, Ontario, Canada)'),
    ('CA-GAN', 'CA-GAN (Gander, Newfoundland and Labrador, Canada)'),
    ('CA-GGS', 'CA-GGS (Ganges, British Columbia, Canada)'),
    ('CA-GDV', 'CA-GDV (Gardenville, Ontario, Canada)'),
    ('CA-GAR', 'CA-GAR (Garson, Ontario, Canada)'),
    ('CA-XP8', 'CA-XP8 (Gaspereau, Nova Scotia, Canada)'),
    ('CA-GAX', 'CA-GAX (Gaspereaux, Prince Edward Island, Canada)'),
    ('CA-GPE', 'CA-GPE (Gaspé, Quebec, Canada)'),
    ('CA-GAT', 'CA-GAT (Gatineau, Quebec, Canada)'),
    ('CA-GEM', 'CA-GEM (Gem, Alberta, Canada)'),
    ('CA-GEO', 'CA-GEO (Georgetown, Prince Edward Island, Canada)'),
    ('CA-GGW', 'CA-GGW (Georgetown, Ontario, Canada)'),
    ('CA-GIA', 'CA-GIA (Georgian Bluff, Ontario, Canada)'),
    ('CA-GBF', 'CA-GBF (Georgian Bluffs, Ontario, Canada)'),
    ('CA-GLD', 'CA-GLD (Gerald, Saskatchewan, Canada)'),
    ('CA-YGQ', 'CA-YGQ (Geraldton, Ontario, Canada)'),
    ('CA-YGS', 'CA-YGS (Germansen, British Columbia, Canada)'),
    ('CA-ZGS', 'CA-ZGS (Gethsémani, Quebec, Canada)'),
    ('CA-GBO', 'CA-GBO (Gibbons, Alberta, Canada)'),
    ('CA-GIB', 'CA-GIB (Gibsons, British Columbia, Canada)'),
    ('CA-GPS', 'CA-GPS (Gilbert Plains, Manitoba, Canada)'),
    ('CA-YGX', 'CA-YGX (Gillam, Manitoba, Canada)'),
    ('CA-YGB', 'CA-YGB (Gillies Bay, British Columbia, Canada)'),
    ('CA-YGM', 'CA-YGM (Gimli, Manitoba, Canada)'),
    ('CA-G3S', 'CA-G3S (Gipsons, British Columbia, Canada)'),
    ('CA-GQC', 'CA-GQC (Girardville, Quebec, Canada)'),
    ('CA-GXI', 'CA-GXI (Girouxville, Alberta, Canada)'),
    ('CA-YHK', 'CA-YHK (Girouxville, Alberta, Canada)'),
    ('CA-GLB', 'CA-GLB (Glace Bay, Nova Scotia, Canada)'),
    ('CA-GHU', 'CA-GHU (Glen Huron, Ontario, Canada)'),
    ('CA-GMT', 'CA-GMT (Glen Margaret, Nova Scotia, Canada)'),
    ('CA-GMO', 'CA-GMO (Glen Morris, Ontario, Canada)'),
    ('CA-GBU', 'CA-GBU (Glenbush, Saskatchewan, Canada)'),
    ('CA-GLE', 'CA-GLE (Glencoe, Ontario, Canada)'),
    ('CA-GNO', 'CA-GNO (Glendon, Alberta, Canada)'),
    ('CA-NS7', 'CA-NS7 (Glenville, Nova Scotia, Canada)'),
    ('CA-GNW', 'CA-GNW (Glenwood, Nova Scotia, Canada)'),
    ('CA-GWD', 'CA-GWD (Glenwood, Alberta, Canada)'),
    ('CA-GCR', 'CA-GCR (Gloucester, Ontario, Canada)'),
    ('CA-GVN', 'CA-GVN (Glovertown, Newfoundland and Labrador, Canada)'),
    ('CA-GBT', 'CA-GBT (Godbout, Quebec, Canada)'),
    ('CA-GOH', 'CA-GOH (Goderich, Ontario, Canada)'),
    ('CA-YGO', 'CA-YGO (Gods Narrows, Manitoba, Canada)'),
    ('CA-ZGI', 'CA-ZGI (Gods River, Manitoba, Canada)'),
    ('CA-GOF', 'CA-GOF (Goffs, Nova Scotia, Canada)'),
    ('CA-GOL', 'CA-GOL (Gold River, Nova Scotia, Canada)'),
    ('CA-GOR', 'CA-GOR (Gold River, British Columbia, Canada)'),
    ('CA-GBR', 'CA-GBR (Goldboro, Nova Scotia, Canada)'),
    ('CA-GDN', 'CA-GDN (Golden, British Columbia, Canada)'),
    ('CA-GDW', 'CA-GDW (Goodwood, Ontario, Canada)'),
    ('CA-GW2', 'CA-GW2 (Goodwood, Nova Scotia, Canada)'),
    ('CA-GOO', 'CA-GOO (Goose Bay, Newfoundland and Labrador, Canada)'),
    ('CA-YZE', 'CA-YZE (Gore Bay, Ontario, Canada)'),
    ('CA-YGE', 'CA-YGE (Gorge Harbor, British Columbia, Canada)'),
    ('CA-GMY', 'CA-GMY (Gormley, Ontario, Canada)'),
    ('CA-GRR', 'CA-GRR (Gorrie, Ontario, Canada)'),
    ('CA-GWS', 'CA-GWS (Gowanstown, Ontario, Canada)'),
    ('CA-GFT', 'CA-GFT (Grafton, Ontario, Canada)'),
    ('CA-GRA', 'CA-GRA (Granby, Quebec, Canada)'),
    ('CA-GRB', 'CA-GRB (Grand Bank, Newfoundland and Labrador, Canada)'),
    ('CA-GJI', 'CA-GJI (Grand Bend, Ontario, Canada)'),
    ('CA-GRF', 'CA-GRF (Grand Falls, New Brunswick, Canada)'),
    ('CA-GFA', 'CA-GFA (Grand Falls-Windsor, Newfoundland and Labrador, Canada)'),
    ('CA-ZGF', 'CA-ZGF (Grand Forks, British Columbia, Canada)'),
    ('CA-GMA', 'CA-GMA (Grand Manan, New Brunswick, Canada)'),
    ('CA-QGM', 'CA-QGM (Grand Mere, Quebec, Canada)'),
    ('CA-4NG', 'CA-4NG (Grand Pre, Nova Scotia, Canada)'),
    ('CA-GDR', 'CA-GDR (Grand River, Nova Scotia, Canada)'),
    ('CA-GTD', 'CA-GTD (Grand Toys Dorval, Quebec, Canada)'),
    ('CA-GRV', 'CA-GRV (Grand Valley, Ontario, Canada)'),
    ('CA-GVI', 'CA-GVI (Grand View, Manitoba, Canada)'),
    ('CA-GRM', 'CA-GRM (Grand-Mere, Quebec, Canada)'),
    ('CA-GSU', 'CA-GSU (Grand-Sault, New Brunswick, Canada)'),
    ('CA-GAE', 'CA-GAE (Grande Anse, New Brunswick, Canada)'),
    ('CA-YGC', 'CA-YGC (Grande Cache, Alberta, Canada)'),
    ('CA-RPE', 'CA-RPE (Grande Pointe, Manitoba, Canada)'),
    ('CA-YQU', 'CA-YQU (Grande Prairie, Alberta, Canada)'),
    ('CA-GEE', 'CA-GEE (Grande Riviere, Quebec, Canada)'),
    ('CA-EDI', 'CA-EDI (Grande-Digue, New Brunswick, Canada)'),
    ('CA-GVA', 'CA-GVA (Grande-Vallée, Quebec, Canada)'),
    ('CA-GPL', 'CA-GPL (Grandes-Piles, Quebec, Canada)'),
    ('CA-GRN', 'CA-GRN (Granton, Nova Scotia, Canada)'),
    ('CA-GRU', 'CA-GRU (Granum, Alberta, Canada)'),
    ('CA-GFF', 'CA-GFF (Granville Ferry, Nova Scotia, Canada)'),
    ('CA-GAI', 'CA-GAI (Grassie, Ontario, Canada)'),
    ('CA-GRD', 'CA-GRD (Grassland, Alberta, Canada)'),
    ('CA-GLK', 'CA-GLK (Grassy Lake, Alberta, Canada)'),
    ('CA-GBG', 'CA-GBG (Gravelbourg, Saskatchewan, Canada)'),
    ('CA-GVH', 'CA-GVH (Gravenhurst, Ontario, Canada)'),
    ('CA-DAS', 'CA-DAS (Gravenhurst, Ontario, Canada)'),
    ('CA-GOS', 'CA-GOS (Green Oaks, Nova Scotia, Canada)'),
    ('CA-GFL', 'CA-GFL (Greenfield, Nova Scotia, Canada)'),
    ('CA-GRE', 'CA-GRE (Greenfield Park, Quebec, Canada)'),
    ('CA-YGN', 'CA-YGN (Greenway Sound, British Columbia, Canada)'),
    ('CA-GRW', 'CA-GRW (Greenwood, British Columbia, Canada)'),
    ('CA-YZX', 'CA-YZX (Greenwood, Nova Scotia, Canada)'),
    ('CA-GNF', 'CA-GNF (Grenfell, Saskatchewan, Canada)'),
    ('CA-GRZ', 'CA-GRZ (Grenville, Quebec, Canada)'),
    ('CA-GRT', 'CA-GRT (Gretna, Manitoba, Canada)'),
    ('CA-XGY', 'CA-XGY (Grimsby, Ontario, Canada)'),
    ('CA-GSA', 'CA-GSA (Grimshaw, Alberta, Canada)'),
    ('CA-GDO', 'CA-GDO (Grindrod, British Columbia, Canada)'),
    ('CA-GRS', 'CA-GRS (Grindstone, Quebec, Canada)'),
    ('CA-YGZ', 'CA-YGZ (Grindstone, Quebec, Canada)'),
    ('CA-GOI', 'CA-GOI (Grondines, Quebec, Canada)'),
    ('CA-GCA', 'CA-GCA (Gros Cacouna, Quebec, Canada)'),
    ('CA-GRI', 'CA-GRI (Grosse Isle, Manitoba, Canada)'),
    ('CA-QEE', 'CA-QEE (Grosse Isle, Quebec, Canada)'),
    ('CA-GRO', 'CA-GRO (Grouse Mountain, British Columbia, Canada)'),
    ('CA-GTH', 'CA-GTH (Grunthal, Manitoba, Canada)'),
    ('CA-GLP', 'CA-GLP (Guelph, Ontario, Canada)'),
    ('CA-SKG', 'CA-SKG (Guernsey, Saskatchewan, Canada)'),
    ('CA-GLL', 'CA-GLL (Gull Lake, Saskatchewan, Canada)'),
    ('CA-GTN', 'CA-GTN (Gunton, Manitoba, Canada)'),
    ('CA-GUY', 'CA-GUY (Guy, Alberta, Canada)'),
    ('CA-GYB', 'CA-GYB (Guysborough, Nova Scotia, Canada)'),
    ('CA-HCC', 'CA-HCC (Hacketts Cove, Nova Scotia, Canada)'),
    ('CA-HHV', 'CA-HHV (Hadashville, Manitoba, Canada)'),
    ('CA-HGS', 'CA-HGS (Hagersville, Ontario, Canada)'),
    ('CA-HAG', 'CA-HAG (Hague, Saskatchewan, Canada)'),
    ('CA-EYL', 'CA-EYL (Haileybury, Ontario, Canada)'),
    ('CA-HJU', 'CA-HJU (Haileybury, Ontario, Canada)'),
    ('CA-HHL', 'CA-HHL (Hairy Hill, Alberta, Canada)'),
    ('CA-YHC', 'CA-YHC (Hakai Pass, British Columbia, Canada)'),
    ('CA-HBD', 'CA-HBD (Halbstadt, Manitoba, Canada)'),
    ('CA-HSN', 'CA-HSN (Haley Station, Ontario, Canada)'),
    ('CA-HFB', 'CA-HFB (Halfmoon Bay, British Columbia, Canada)'),
    ('CA-HBT', 'CA-HBT (Haliburton, Ontario, Canada)'),
    ('CA-HAL', 'CA-HAL (Halifax, Nova Scotia, Canada)'),
    ('CA-YHZ', 'CA-YHZ (Halifax Apt, Nova Scotia, Canada)'),
    ('CA-HAB', 'CA-HAB (Halifax Apt, Nova Scotia, Canada)'),
    ('CA-HLB', 'CA-HLB (Hallebourg, Ontario, Canada)'),
    ('CA-H8O', 'CA-H8O (Hallowell, Ontario, Canada)'),
    ('CA-OON', 'CA-OON (Halton Hills, Ontario, Canada)'),
    ('CA-HMN', 'CA-HMN (Ham Nord, Quebec, Canada)'),
    ('CA-HAM', 'CA-HAM (Hamilton, Ontario, Canada)'),
    ('CA-YHM', 'CA-YHM (Hamilton Apt, Ontario, Canada)'),
    ('CA-HMA', 'CA-HMA (Hamiota, Manitoba, Canada)'),
    ('CA-HMP', 'CA-HMP (Hampden, Newfoundland and Labrador, Canada)'),
    ('CA-HAN', 'CA-HAN (Haney, British Columbia, Canada)'),
    ('CA-HMR', 'CA-HMR (Hanmer, Ontario, Canada)'),
    ('CA-HNA', 'CA-HNA (Hanna, Alberta, Canada)'),
    ('CA-HNO', 'CA-HNO (Hannon, Ontario, Canada)'),
    ('CA-HHH', 'CA-HHH (Hanover, Manitoba, Canada)'),
    ('CA-HVR', 'CA-HVR (Hanover, Ontario, Canada)'),
    ('CA-HHB', 'CA-HHB (Hants Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-HPT', 'CA-HPT (Hantsport, Nova Scotia, Canada)'),
    ('CA-HWL', 'CA-HWL (Hanwell, New Brunswick, Canada)'),
    ('CA-HVY', 'CA-HVY (Happy Valley, Newfoundland and Labrador, Canada)'),
    ('CA-HBR', 'CA-HBR (Harbour Breton, Newfoundland and Labrador, Canada)'),
    ('CA-HRE', 'CA-HRE (Harbour Grace, Newfoundland and Labrador, Canada)'),
    ('CA-HCT', 'CA-HCT (Harcourt, Ontario, Canada)'),
    ('CA-HDY', 'CA-HDY (Hardisty, Alberta, Canada)'),
    ('CA-HLD', 'CA-HLD (Hardwood Lands, Nova Scotia, Canada)'),
    ('CA-HYY', 'CA-HYY (Harley, Ontario, Canada)'),
    ('CA-HMC', 'CA-HMC (Harmac, British Columbia, Canada)'),
    ('CA-HCA', 'CA-HCA (Harmony, Nova Scotia, Canada)'),
    ('CA-HAR', 'CA-HAR (Harriet Harbour, British Columbia, Canada)'),
    ('CA-RRH', 'CA-RRH (Harrietsfield, Nova Scotia, Canada)'),
    ('CA-HMI', 'CA-HMI (Harrison Mills, British Columbia, Canada)'),
    ('CA-HRR', 'CA-HRR (Harriston, Ontario, Canada)'),
    ('CA-HRG', 'CA-HRG (Harrogate, British Columbia, Canada)'),
    ('CA-HRW', 'CA-HRW (Harrow, Ontario, Canada)'),
    ('CA-HGT', 'CA-HGT (Hartington, Ontario, Canada)'),
    ('CA-HTD', 'CA-HTD (Hartland, New Brunswick, Canada)'),
    ('CA-YTB', 'CA-YTB (Hartley Bay, British Columbia, Canada)'),
    ('CA-TYR', 'CA-TYR (Harty, Ontario, Canada)'),
    ('CA-HRV', 'CA-HRV (Harvey Station, New Brunswick, Canada)'),
    ('CA-HON', 'CA-HON (Harwood, Ontario, Canada)'),
    ('CA-TIN', 'CA-TIN (Hastings, Ontario, Canada)'),
    ('CA-HAT', 'CA-HAT (Hatch Point, British Columbia, Canada)'),
    ('CA-HCK', 'CA-HCK (Hatchet Lake, Nova Scotia, Canada)'),
    ('CA-YDJ', 'CA-YDJ (Hatchet Lake, Saskatchewan, Canada)'),
    ('CA-HDP', 'CA-HDP (Hatfield Point, New Brunswick, Canada)'),
    ('CA-HAV', 'CA-HAV (Havelock, New Brunswick, Canada)'),
    ('CA-HVL', 'CA-HVL (Havelock, Ontario, Canada)'),
    ('CA-HBC', 'CA-HBC (Havre Boucher, Nova Scotia, Canada)'),
    ('CA-HSP', 'CA-HSP (Havre-Saint-Pierre, Quebec, Canada)'),
    ('CA-HAW', 'CA-HAW (Hawkesbury, Ontario, Canada)'),
    ('CA-HWK', 'CA-HWK (Hawkestone, Ontario, Canada)'),
    ('CA-HAK', 'CA-HAK (Hawkesville, Ontario, Canada)'),
    ('CA-YHY', 'CA-YHY (Hawkesville, Ontario, Canada)'),
    ('CA-HCZ', 'CA-HCZ (Head of Chezzetcook, Nova Scotia, Canada)'),
    ('CA-JEJ', 'CA-JEJ (Head of Jeddore, Nova Scotia, Canada)'),
    ('CA-HDL', 'CA-HDL (Headingley, Manitoba, Canada)'),
    ('CA-YHF', 'CA-YHF (Hearst, Ontario, Canada)'),
    ('CA-HBV', 'CA-HBV (Hebbville, Nova Scotia, Canada)'),
    ('CA-HBN', 'CA-HBN (Hebron, Newfoundland and Labrador, Canada)'),
    ('CA-HDB', 'CA-HDB (Heidelberg, Ontario, Canada)'),
    ('CA-HMM', 'CA-HMM (Hemmingford, Quebec, Canada)'),
    ('CA-HLV', 'CA-HLV (Henryville, Quebec, Canada)'),
    ('CA-HEL', 'CA-HEL (Hensall, Ontario, Canada)'),
    ('CA-HP8', 'CA-HP8 (Hepburn, Saskatchewan, Canada)'),
    ('CA-BYE', 'CA-BYE (Heriot Bay, British Columbia, Canada)'),
    ('CA-HEP', 'CA-HEP (Heritage Pointe, Alberta, Canada)'),
    ('CA-HBY', 'CA-HBY (Heron Bay, Ontario, Canada)'),
    ('CA-HLI', 'CA-HLI (Heron Bay, Ontario, Canada)'),
    ('CA-HIB', 'CA-HIB (Hibernia, Nova Scotia, Canada)'),
    ('CA-HKS', 'CA-HKS (Hickson, Ontario, Canada)'),
    ('CA-HBL', 'CA-HBL (High Bluff, Manitoba, Canada)'),
    ('CA-YOJ', 'CA-YOJ (High Level, Alberta, Canada)'),
    ('CA-ZHP', 'CA-ZHP (High Prairie, Alberta, Canada)'),
    ('CA-HRI', 'CA-HRI (High River, Alberta, Canada)'),
    ('CA-HID', 'CA-HID (Hilda, Alberta, Canada)'),
    ('CA-HIL', 'CA-HIL (Hillsborough, New Brunswick, Canada)'),
    ('CA-HBG', 'CA-HBG (Hillsburgh, Ontario, Canada)'),
    ('CA-HLS', 'CA-HLS (Hillsdale, Ontario, Canada)'),
    ('CA-HBK', 'CA-HBK (Hinchinbrooke, Quebec, Canada)'),
    ('CA-HIN', 'CA-HIN (Hines Creek, Alberta, Canada)'),
    ('CA-HNT', 'CA-HNT (Hinton, Alberta, Canada)'),
    ('CA-HGV', 'CA-HGV (Hodgeville, Saskatchewan, Canada)'),
    ('CA-HCE', 'CA-HCE (Holland Center, Ontario, Canada)'),
    ('CA-HHC', 'CA-HHC (Holland Centre, Ontario, Canada)'),
    ('CA-HLL', 'CA-HLL (Holland Landing, Ontario, Canada)'),
    ('CA-YHI', 'CA-YHI (Holland Landing, Ontario, Canada)'),
    ('CA-HST', 'CA-HST (Holstein, Ontario, Canada)'),
    ('CA-HOD', 'CA-HOD (Holyrood, Newfoundland and Labrador, Canada)'),
    ('CA-HYO', 'CA-HYO (Holyrood, Ontario, Canada)'),
    ('CA-HNH', 'CA-HNH (Honey Harbour, Ontario, Canada)'),
    ('CA-HOF', 'CA-HOF (Honfleur, Quebec, Canada)'),
    ('CA-YHE', 'CA-YHE (Hope, British Columbia, Canada)'),
    ('CA-HOP', 'CA-HOP (Hopedale, Newfoundland and Labrador, Canada)'),
    ('CA-HOR', 'CA-HOR (Hornby, Ontario, Canada)'),
    ('CA-YHN', 'CA-YHN (Hornepayne, Ontario, Canada)'),
    ('CA-HRF', 'CA-HRF (Horsefly, British Columbia, Canada)'),
    ('CA-HWS', 'CA-HWS (Howe Sound, British Columbia, Canada)'),
    ('CA-HUD', 'CA-HUD (Hudson, Quebec, Canada)'),
    ('CA-YHB', 'CA-YHB (Hudson Bay, Saskatchewan, Canada)'),
    ('CA-YNH', 'CA-YNH (Hudson Hope, British Columbia, Canada)'),
    ('CA-HUL', 'CA-HUL (Hull, Quebec, Canada)'),
    ('CA-HMO', 'CA-HMO (Humboldt, Saskatchewan, Canada)'),
    ('CA-HUR', 'CA-HUR (Hunter River, Prince Edward Island, Canada)'),
    ('CA-HDN', 'CA-HDN (Huntingdon, Quebec, Canada)'),
    ('CA-HUN', 'CA-HUN (Huntsville, Ontario, Canada)'),
    ('CA-HUP', 'CA-HUP (Huron Park, Ontario, Canada)'),
    ('CA-HYE', 'CA-HYE (Hythe, Alberta, Canada)'),
    ('CA-HEB', 'CA-HEB (Hébertville, Quebec, Canada)'),
    ('CA-IBV', 'CA-IBV (Iberville, Quebec, Canada)'),
    ('CA-IGL', 'CA-IGL (Iberville, Quebec, Canada)'),
    ('CA-ZUC', 'CA-ZUC (Ignace, Ontario, Canada)'),
    ('CA-IDO', 'CA-IDO (Ilderton, Ontario, Canada)'),
    ('CA-IXC', 'CA-IXC (Ile Aux Coudres, Quebec, Canada)'),
    ('CA-BZD', 'CA-BZD (Ile Bizard, Quebec, Canada)'),
    ('CA-IDC', 'CA-IDC (Ile des Chênes, Manitoba, Canada)'),
    ('CA-IPE', 'CA-IPE (Ile Perrot, Quebec, Canada)'),
    ('CA-BRV', 'CA-BRV (Iles de Boucherville, Quebec, Canada)'),
    ('CA-YGR', 'CA-YGR (Iles de la Madeleine, Quebec, Canada)'),
    ('CA-ILF', 'CA-ILF (Ilford, Manitoba, Canada)'),
    ('CA-SIM', 'CA-SIM (Imperial, Saskatchewan, Canada)'),
    ('CA-IAM', 'CA-IAM (Indian Arm, British Columbia, Canada)'),
    ('CA-IHR', 'CA-IHR (Indian Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-IHD', 'CA-IHD (Indian Head, Saskatchewan, Canada)'),
    ('CA-IGS', 'CA-IGS (Ingersoll, Ontario, Canada)'),
    ('CA-ISI', 'CA-ISI (Ingleside, Ontario, Canada)'),
    ('CA-IGE', 'CA-IGE (Inglewood, Ontario, Canada)'),
    ('CA-IGI', 'CA-IGI (Inglis, Manitoba, Canada)'),
    ('CA-ING', 'CA-ING (Ingonish, Nova Scotia, Canada)'),
    ('CA-IKM', 'CA-IKM (Inkerman, Ontario, Canada)'),
    ('CA-KER', 'CA-KER (Inkerman, New Brunswick, Canada)'),
    ('CA-IKP', 'CA-IKP (Innerkip, Ontario, Canada)'),
    ('CA-INN', 'CA-INN (Innisfail, Alberta, Canada)'),
    ('CA-ISF', 'CA-ISF (Innisfil, Ontario, Canada)'),
    ('CA-INF', 'CA-INF (Innisfree, Alberta, Canada)'),
    ('CA-YPH', 'CA-YPH (Inukjuak, Quebec, Canada)'),
    ('CA-YEV', 'CA-YEV (Inukjuak, Quebec, Canada)'),
    ('CA-TIL', 'CA-TIL (Inverlake, Alberta, Canada)'),
    ('CA-IVM', 'CA-IVM (Invermere, British Columbia, Canada)'),
    ('CA-IVR', 'CA-IVR (Inverness, Quebec, Canada)'),
    ('CA-IVS', 'CA-IVS (Inverness, Nova Scotia, Canada)'),
    ('CA-IWO', 'CA-IWO (Inwood, Ontario, Canada)'),
    ('CA-IOC', 'CA-IOC (Ioco, British Columbia, Canada)'),
    ('CA-ION', 'CA-ION (Iona, Nova Scotia, Canada)'),
    ('CA-IQL', 'CA-IQL (Iona, Nova Scotia, Canada)'),
    ('CA-IRM', 'CA-IRM (Irma, Alberta, Canada)'),
    ('CA-ISP', 'CA-ISP (Iron Springs, Alberta, Canada)'),
    ('CA-IRQ', 'CA-IRQ (Iroquois, Ontario, Canada)'),
    ('CA-IQF', 'CA-IQF (Iroquois Falls, Ontario, Canada)'),
    ('CA-ICA', 'CA-ICA (Irricana, Alberta, Canada)'),
    ('CA-IVN', 'CA-IVN (Irvine, Alberta, Canada)'),
    ('CA-SKT', 'CA-SKT (Iskut, British Columbia, Canada)'),
    ('CA-ISL', 'CA-ISL (Island Lake, Manitoba, Canada)'),
    ('CA-YIV', 'CA-YIV (Island Lk/Garden Hill, Manitoba, Canada)'),
    ('CA-ISD', 'CA-ISD (Issoudun, Quebec, Canada)'),
    ('CA-ITA', 'CA-ITA (Ituna, Saskatchewan, Canada)'),
    ('CA-YIK', 'CA-YIK (Ivujivik, Quebec, Canada)'),
    ('CA-JAC', 'CA-JAC (Jackson Arm, Newfoundland and Labrador, Canada)'),
    ('CA-JBA', 'CA-JBA (Jackson Bay, British Columbia, Canada)'),
    ('CA-JAV', 'CA-JAV (Jacksonville, New Brunswick, Canada)'),
    ('CA-JNS', 'CA-JNS (Jansen, Saskatchewan, Canada)'),
    ('CA-JVS', 'CA-JVS (Jarvis, Ontario, Canada)'),
    ('CA-JPR', 'CA-JPR (Jasper, Alberta, Canada)'),
    ('CA-JED', 'CA-JED (Jedway, British Columbia, Canada)'),
    ('CA-JEG', 'CA-JEG (Jemseg, New Brunswick, Canada)'),
    ('CA-JNE', 'CA-JNE (Jenner, Alberta, Canada)'),
    ('CA-ZJG', 'CA-ZJG (Jenpeg, Manitoba, Canada)'),
    ('CA-JSS', 'CA-JSS (Jerseyville, Ontario, Canada)'),
    ('CA-JEI', 'CA-JEI (Jervis Inlet, British Columbia, Canada)'),
    ('CA-JOF', 'CA-JOF (Joffre, Alberta, Canada)'),
    ('CA-JGG', 'CA-JGG (Joggins, Nova Scotia, Canada)'),
    ('CA-YJO', 'CA-YJO (Johnny Mountain, British Columbia, Canada)'),
    ('CA-JOH', 'CA-JOH (Johnstown, Ontario, Canada)'),
    ('CA-JOL', 'CA-JOL (Joliette, Quebec, Canada)'),
    ('CA-JYQ', 'CA-JYQ (Joly, Ontario, Canada)'),
    ('CA-JON', 'CA-JON (Jonquière, Quebec, Canada)'),
    ('CA-JST', 'CA-JST (Jordan Station, Ontario, Canada)'),
    ('CA-JUN', 'CA-JUN (Juniper, New Brunswick, Canada)'),
    ('CA-KNW', 'CA-KNW (Kahnawake, Quebec, Canada)'),
    ('CA-KKM', 'CA-KKM (Kaministiquia, Ontario, Canada)'),
    ('CA-KML', 'CA-KML (Kamloops, British Columbia, Canada)'),
    ('CA-KSA', 'CA-KSA (Kamsack, Saskatchewan, Canada)'),
    ('CA-KNA', 'CA-KNA (Kananaskis, Alberta, Canada)'),
    ('CA-KAN', 'CA-KAN (Kanata, Ontario, Canada)'),
    ('CA-XGR', 'CA-XGR (Kangiqsualujjuaq, Quebec, Canada)'),
    ('CA-YWB', 'CA-YWB (Kangiqsujuaq, Quebec, Canada)'),
    ('CA-YKG', 'CA-YKG (Kangirsuk, Quebec, Canada)'),
    ('CA-YYU', 'CA-YYU (Kapuskasing, Ontario, Canada)'),
    ('CA-XKS', 'CA-XKS (Kasabonika, Ontario, Canada)'),
    ('CA-YDU', 'CA-YDU (Kasabonika, Ontario, Canada)'),
    ('CA-ZKE', 'CA-ZKE (Kaschechewan, Ontario, Canada)'),
    ('CA-KLO', 'CA-KLO (Kaslo, British Columbia, Canada)'),
    ('CA-YAU', 'CA-YAU (Kattiniq/Donaldson Lake, Quebec, Canada)'),
    ('CA-KLL', 'CA-KLL (Kearl Lake, Alberta, Canada)'),
    ('CA-KEY', 'CA-KEY (Kearney, Ontario, Canada)'),
    ('CA-KGK', 'CA-KGK (Kedgwick, New Brunswick, Canada)'),
    ('CA-KEE', 'CA-KEE (Keene, Ontario, Canada)'),
    ('CA-KWN', 'CA-KWN (Keewatin, Ontario, Canada)'),
    ('CA-CNG', 'CA-CNG (Keg River, Alberta, Canada)'),
    ('CA-ZKG', 'CA-ZKG (Kegaska, Quebec, Canada)'),
    ('CA-KWL', 'CA-KWL (Kelowna, British Columbia, Canada)'),
    ('CA-KES', 'CA-KES (Kelsey, Manitoba, Canada)'),
    ('CA-KEL', 'CA-KEL (Kelvington, Saskatchewan, Canada)'),
    ('CA-KWO', 'CA-KWO (Kelwood, Manitoba, Canada)'),
    ('CA-KVE', 'CA-KVE (Kemptville, Ontario, Canada)'),
    ('CA-KSO', 'CA-KSO (Kenaston, Saskatchewan, Canada)'),
    ('CA-KWH', 'CA-KWH (Kenilworth, Ontario, Canada)'),
    ('CA-YKI', 'CA-YKI (Kennosao Lake, Manitoba, Canada)'),
    ('CA-YQK', 'CA-YQK (Kenora, Ontario, Canada)'),
    ('CA-KSN', 'CA-KSN (Kensington, Prince Edward Island, Canada)'),
    ('CA-KBD', 'CA-KBD (Kensington, Prince Edward Island, Canada)'),
    ('CA-KTL', 'CA-KTL (Kentville, Nova Scotia, Canada)'),
    ('CA-KVI', 'CA-KVI (Kenville, Manitoba, Canada)'),
    ('CA-KEA', 'CA-KEA (Keoma, Alberta, Canada)'),
    ('CA-KRO', 'CA-KRO (Keremeos, British Columbia, Canada)'),
    ('CA-KWD', 'CA-KWD (Kerwood, Ontario, Canada)'),
    ('CA-KWK', 'CA-KWK (Keswick, Ontario, Canada)'),
    ('CA-KSW', 'CA-KSW (Keswick Ridge, New Brunswick, Canada)'),
    ('CA-KHS', 'CA-KHS (Ketch Harbour, Nova Scotia, Canada)'),
    ('CA-KTB', 'CA-KTB (Kettleby, Ontario, Canada)'),
    ('CA-KHO', 'CA-KHO (Key Harbour, Ontario, Canada)'),
    ('CA-YKJ', 'CA-YKJ (Key Lake, Saskatchewan, Canada)'),
    ('CA-KQC', 'CA-KQC (Kiamika, Quebec, Canada)'),
    ('CA-YXI', 'CA-YXI (Killaloe, Ontario, Canada)'),
    ('CA-KLM', 'CA-KLM (Killam, Alberta, Canada)'),
    ('CA-KLY', 'CA-KLY (Killarney, Ontario, Canada)'),
    ('CA-KRY', 'CA-KRY (Killarney, Manitoba, Canada)'),
    ('CA-XBW', 'CA-XBW (Killineq, Quebec, Canada)'),
    ('CA-YQE', 'CA-YQE (Kimberley, British Columbia, Canada)'),
    ('CA-YLC', 'CA-YLC (Kimberley, British Columbia, Canada)'),
    ('CA-KBU', 'CA-KBU (Kinburn, Ontario, Canada)'),
    ('CA-KAC', 'CA-KAC (Kincardine, Ontario, Canada)'),
    ('CA-YKY', 'CA-YKY (Kindersley, Saskatchewan, Canada)'),
    ('CA-KGG', 'CA-KGG (King, Ontario, Canada)'),
    ('CA-KCN', 'CA-KCN (King City, Ontario, Canada)'),
    ('CA-KWI', 'CA-KWI (King City, Ontario, Canada)'),
    ('CA-KIF', 'CA-KIF (Kingfisher Lake, Ontario, Canada)'),
    ('CA-KGM', 'CA-KGM (Kingman, Alberta, Canada)'),
    ('CA-KGU', 'CA-KGU (Kingsbury, Quebec, Canada)'),
    ('CA-KFS', 'CA-KFS (Kingsey Falls, Quebec, Canada)'),
    ('CA-KNG', 'CA-KNG (Kingsgate, British Columbia, Canada)'),
    ('CA-KGN', 'CA-KGN (Kingston, Nova Scotia, Canada)'),
    ('CA-KIN', 'CA-KIN (Kingston, Ontario, Canada)'),
    ('CA-KVL', 'CA-KVL (Kingsville, Ontario, Canada)'),
    ('CA-KST', 'CA-KST (Kinistino, Saskatchewan, Canada)'),
    ('CA-KKR', 'CA-KKR (Kinkora, Prince Edward Island, Canada)'),
    ('CA-KNE', "CA-KNE (Kinnear's Mills, Quebec, Canada)"),
    ('CA-KNY', 'CA-KNY (Kinoosao, Saskatchewan, Canada)'),
    ('CA-KTO', 'CA-KTO (Kintore, Ontario, Canada)'),
    ('CA-KPL', 'CA-KPL (Kipling, Saskatchewan, Canada)'),
    ('CA-KIP', 'CA-KIP (Kippen, Ontario, Canada)'),
    ('CA-KIK', 'CA-KIK (Kirkland, Quebec, Canada)'),
    ('CA-YKX', 'CA-YKX (Kirkland Lake, Ontario, Canada)'),
    ('CA-KKT', 'CA-KKT (Kirkton, Ontario, Canada)'),
    ('CA-KBY', 'CA-KBY (Kisbey, Saskatchewan, Canada)'),
    ('CA-KTC', 'CA-KTC (Kitchener, Ontario, Canada)'),
    ('CA-KTM', 'CA-KTM (Kitimat, British Columbia, Canada)'),
    ('CA-YKK', 'CA-YKK (Kitkatla, British Columbia, Canada)'),
    ('CA-KFD', 'CA-KFD (Kleefeld, Manitoba, Canada)'),
    ('CA-KBG', 'CA-KBG (Kleinburg, Ontario, Canada)'),
    ('CA-YKT', 'CA-YKT (Klemtu, British Columbia, Canada)'),
    ('CA-YKE', 'CA-YKE (Knee Lake, Manitoba, Canada)'),
    ('CA-KNV', 'CA-KNV (Knights Inlet, British Columbia, Canada)'),
    ('CA-KNN', 'CA-KNN (Knowlton, Quebec, Canada)'),
    ('CA-KOL', 'CA-KOL (Kola, Manitoba, Canada)'),
    ('CA-KMK', 'CA-KMK (Komoka, Ontario, Canada)'),
    ('CA-KOV', 'CA-KOV (Kovik Bay, Quebec, Canada)'),
    ('CA-YBB', 'CA-YBB (Kovik Bay, Quebec, Canada)'),
    ('CA-FCM', 'CA-FCM (Kuujjuaq, Quebec, Canada)'),
    ('CA-YVP', 'CA-YVP (Kuujjuaq Apt, Quebec, Canada)'),
    ('CA-LAL', "CA-LAL (L'ancienne-Lorette, Quebec, Canada)"),
    ('CA-LAG', "CA-LAG (L'Ange-Gardien, Quebec, Canada)"),
    ('CA-ALO', "CA-ALO (L'Anse-au-Loup, Newfoundland and Labrador, Canada)"),
    ('CA-LB3', "CA-LB3 (L'Anse-à-Beaufils, Quebec, Canada)"),
    ('CA-LNS', "CA-LNS (L'Ascension-de-Notre-Seigneur, Quebec, Canada)"),
    ('CA-LAP', "CA-LAP (L'Ascension-de-Patapédia, Quebec, Canada)"),
    ('CA-LAN', "CA-LAN (L'Assomption, Quebec, Canada)"),
    ('CA-EPN', "CA-EPN (L'Epiphanie, Quebec, Canada)"),
    ('CA-IVT', "CA-IVT (L'Isle-Verte, Quebec, Canada)"),
    ('CA-LIT', "CA-LIT (L'Islet, Quebec, Canada)"),
    ('CA-LTV', "CA-LTV (L'Isletville, Quebec, Canada)"),
    ('CA-LOR', "CA-LOR (L'Orignal, Ontario, Canada)"),
    ('CA-ILS', "CA-ILS (L'Île-des-Soeurs (Nuns Island), Quebec, Canada)"),
    ('CA-LBA', 'CA-LBA (La Baie, Quebec, Canada)'),
    ('CA-LBQ', 'CA-LBQ (La Broquerie, Manitoba, Canada)'),
    ('CA-LCR', 'CA-LCR (La Crête, Alberta, Canada)'),
    ('CA-LGC', 'CA-LGC (La Glace, Alberta, Canada)'),
    ('CA-YGL', 'CA-YGL (La Grande, Quebec, Canada)'),
    ('CA-LGE', 'CA-LGE (La Guadeloupe, Quebec, Canada)'),
    ('CA-LHA', 'CA-LHA (La Have, Nova Scotia, Canada)'),
    ('CA-LAM', 'CA-LAM (La Malbaie, Quebec, Canada)'),
    ('CA-LPT', 'CA-LPT (La Patrie, Quebec, Canada)'),
    ('CA-LPO', 'CA-LPO (La Pocatière, Quebec, Canada)'),
    ('CA-LPE', 'CA-LPE (La Prairie, Quebec, Canada)'),
    ('CA-RIE', 'CA-RIE (La Présentation, Quebec, Canada)'),
    ('CA-LRE', 'CA-LRE (La Reine, Quebec, Canada)'),
    ('CA-REL', 'CA-REL (La Relance, Quebec, Canada)'),
    ('CA-YVC', 'CA-YVC (La Ronge, Saskatchewan, Canada)'),
    ('CA-LSL', 'CA-LSL (La Salette, Ontario, Canada)'),
    ('CA-LMW', 'CA-LMW (La Salle, Manitoba, Canada)'),
    ('CA-SSQ', 'CA-SSQ (La Sarre, Quebec, Canada)'),
    ('CA-ZLT', 'CA-ZLT (La Tabatière, Quebec, Canada)'),
    ('CA-YLQ', 'CA-YLQ (La Tuque, Quebec, Canada)'),
    ('CA-LVD', 'CA-LVD (La Visitation-de-Yamaska, Quebec, Canada)'),
    ('CA-LBR', 'CA-LBR (Labrador City, Newfoundland and Labrador, Canada)'),
    ('CA-YLB', 'CA-YLB (Lac Biche, Alberta, Canada)'),
    ('CA-LBM', 'CA-LBM (Lac Brome, Quebec, Canada)'),
    ('CA-LDB', 'CA-LDB (Lac du Bonnet, Manitoba, Canada)'),
    ('CA-AAB', 'CA-AAB (Lac La Biche, Alberta, Canada)'),
    ('CA-HLC', 'CA-HLC (Lac La Hache, British Columbia, Canada)'),
    ('CA-LBP', 'CA-LBP (Lac-Beauport, Quebec, Canada)'),
    ('CA-LAB', 'CA-LAB (Lac-Bouchette, Quebec, Canada)'),
    ('CA-LEC', 'CA-LEC (Lac-des-Écorces, Quebec, Canada)'),
    ('CA-LIL', 'CA-LIL (Lac-des-Îles, Quebec, Canada)'),
    ('CA-LDT', 'CA-LDT (Lac-Drolet, Quebec, Canada)'),
    ('CA-CER', 'CA-CER (Lac-du-Cerf, Quebec, Canada)'),
    ('CA-LME', 'CA-LME (Lac-Mégantic, Quebec, Canada)'),
    ('CA-LCA', 'CA-LCA (Lachenaie, Quebec, Canada)'),
    ('CA-LAC', 'CA-LAC (Lachine/Montreal, Quebec, Canada)'),
    ('CA-LCH', 'CA-LCH (Lachute, Quebec, Canada)'),
    ('CA-LCO', 'CA-LCO (Lacolle, Quebec, Canada)'),
    ('CA-LCM', 'CA-LCM (Lacombe, Alberta, Canada)'),
    ('CA-LCN', 'CA-LCN (Lacorne, Quebec, Canada)'),
    ('CA-LDN', 'CA-LDN (Ladner, British Columbia, Canada)'),
    ('CA-LAD', 'CA-LAD (Ladysmith, British Columbia, Canada)'),
    ('CA-YLF', 'CA-YLF (Laforges, Quebec, Canada)'),
    ('CA-YAR', 'CA-YAR (Lagrande 3, Quebec, Canada)'),
    ('CA-YAH', 'CA-YAH (Lagrande 4, Quebec, Canada)'),
    ('CA-HOW', 'CA-HOW (Lake Cowichan, British Columbia, Canada)'),
    ('CA-LLE', 'CA-LLE (Lake Echo, Nova Scotia, Canada)'),
    ('CA-LAH', 'CA-LAH (Lake Echo, Nova Scotia, Canada)'),
    ('CA-LLI', 'CA-LLI (Lake Louise, Alberta, Canada)'),
    ('CA-LKF', 'CA-LKF (Lakefield, Ontario, Canada)'),
    ('CA-LSE', 'CA-LSE (Lakeshore, Ontario, Canada)'),
    ('CA-LKD', 'CA-LKD (Lakeside, Nova Scotia, Canada)'),
    ('CA-LKI', 'CA-LKI (Lakeside, Ontario, Canada)'),
    ('CA-LAW', 'CA-LAW (Lakeview, Ontario, Canada)'),
    ('CA-LMA', 'CA-LMA (Lamaline, Newfoundland and Labrador, Canada)'),
    ('CA-LMB', 'CA-LMB (Lambeth, Ontario, Canada)'),
    ('CA-LSR', 'CA-LSR (Lambton Shores, Ontario, Canada)'),
    ('CA-LMT', 'CA-LMT (Lamont, Alberta, Canada)'),
    ('CA-LPM', 'CA-LPM (Lampman, Saskatchewan, Canada)'),
    ('CA-LQE', 'CA-LQE (Lamèque, New Brunswick, Canada)'),
    ('CA-LCS', 'CA-LCS (Lancaster, Ontario, Canada)'),
    ('CA-LRP', 'CA-LRP (Lancaster Park, Alberta, Canada)'),
    ('CA-LMK', 'CA-LMK (Landmark, Manitoba, Canada)'),
    ('CA-LLA', 'CA-LLA (Landrienne, Quebec, Canada)'),
    ('CA-YLA', 'CA-YLA (Langara, British Columbia, Canada)'),
    ('CA-LAK', 'CA-LAK (Langbank, Saskatchewan, Canada)'),
    ('CA-LGD', 'CA-LGD (Langdon, Alberta, Canada)'),
    ('CA-LGB', 'CA-LGB (Langenburg, Saskatchewan, Canada)'),
    ('CA-9FR', 'CA-9FR (Langford Station, British Columbia, Canada)'),
    ('CA-LGA', 'CA-LGA (Langham, Saskatchewan, Canada)'),
    ('CA-LNG', 'CA-LNG (Langley, British Columbia, Canada)'),
    ('CA-LGR', 'CA-LGR (Langruth, Manitoba, Canada)'),
    ('CA-LGT', 'CA-LGT (Langton, Ontario, Canada)'),
    ('CA-LNA', 'CA-LNA (Lanigan, Saskatchewan, Canada)'),
    ('CA-LRI', 'CA-LRI (Lanoraie, Quebec, Canada)'),
    ('CA-LDS', 'CA-LDS (Lansdowne, Ontario, Canada)'),
    ('CA-YLH', 'CA-YLH (Lansdowne House, Ontario, Canada)'),
    ('CA-LNZ', 'CA-LNZ (Lantz, Nova Scotia, Canada)'),
    ('CA-LZV', 'CA-LZV (Lantzville, British Columbia, Canada)'),
    ('CA-LAS', 'CA-LAS (LaSalle (La Salle), Quebec, Canada)'),
    ('CA-LAT', 'CA-LAT (Latchford, Ontario, Canada)'),
    ('CA-DLE', 'CA-DLE (Lauder, Manitoba, Canada)'),
    ('CA-LAU', 'CA-LAU (Laurentides, Quebec, Canada)'),
    ('CA-LRQ', 'CA-LRQ (Laurie River, Manitoba, Canada)'),
    ('CA-LAR', 'CA-LAR (Laurier, Manitoba, Canada)'),
    ('CA-LSA', 'CA-LSA (Laurier-Station, Quebec, Canada)'),
    ('CA-LZN', 'CA-LZN (Lauzon, Quebec, Canada)'),
    ('CA-LAV', 'CA-LAV (Laval, Quebec, Canada)'),
    ('CA-LVR', 'CA-LVR (Lavaltrie, Quebec, Canada)'),
    ('CA-LVH', 'CA-LVH (Laverlochère, Quebec, Canada)'),
    ('CA-LVT', 'CA-LVT (Lavington, British Columbia, Canada)'),
    ('CA-LCT', 'CA-LCT (Lawrencetown, Nova Scotia, Canada)'),
    ('CA-LII', 'CA-LII (Lawrenceville, Quebec, Canada)'),
    ('CA-LAZ', 'CA-LAZ (Lazo, British Columbia, Canada)'),
    ('CA-BC9', 'CA-BC9 (Le Bic, Quebec, Canada)'),
    ('CA-LEG', 'CA-LEG (Le Gardeur, Quebec, Canada)'),
    ('CA-LDR', 'CA-LDR (Leader, Saskatchewan, Canada)'),
    ('CA-XLF', 'CA-XLF (Leaf Bay, Quebec, Canada)'),
    ('CA-LRA', 'CA-LRA (Leaf Rapids, Manitoba, Canada)'),
    ('CA-LMN', 'CA-LMN (Leamington, Ontario, Canada)'),
    ('CA-LSK', 'CA-LSK (Leask, Saskatchewan, Canada)'),
    ('CA-LDE', 'CA-LDE (Leaskdale, Ontario, Canada)'),
    ('CA-YLS', 'CA-YLS (Lebel-sur-Quevillon, Quebec, Canada)'),
    ('CA-LDC', 'CA-LDC (Leduc, Alberta, Canada)'),
    ('CA-LFA', 'CA-LFA (Lefaivre, Ontario, Canada)'),
    ('CA-LGL', 'CA-LGL (Legal, Alberta, Canada)'),
    ('CA-LEM', 'CA-LEM (LeMoyne, Quebec, Canada)'),
    ('CA-LEN', 'CA-LEN (Lennoxville, Quebec, Canada)'),
    ('CA-LEP', 'CA-LEP (Lepreau, New Brunswick, Canada)'),
    ('CA-LRS', 'CA-LRS (Leross, Saskatchewan, Canada)'),
    ('CA-LRO', 'CA-LRO (Leroy, Saskatchewan, Canada)'),
    ('CA-LTX', 'CA-LTX (Les Coteaux, Quebec, Canada)'),
    ('CA-LCI', 'CA-LCI (Les Cédres, Quebec, Canada)'),
    ('CA-QLE', 'CA-QLE (Les Escoumins, Quebec, Canada)'),
    ('CA-MHN', 'CA-MHN (Les Mechins, Quebec, Canada)'),
    ('CA-LTB', 'CA-LTB (Lethbridge, Alberta, Canada)'),
    ('CA-LWP', 'CA-LWP (Lewisporte, Newfoundland and Labrador, Canada)'),
    ('CA-LBU', 'CA-LBU (Libau, Manitoba, Canada)'),
    ('CA-LOO', 'CA-LOO (Lillooet, British Columbia, Canada)'),
    ('CA-LHO', 'CA-LHO (Limehouse, Ontario, Canada)'),
    ('CA-LMS', 'CA-LMS (Limestone, New Brunswick, Canada)'),
    ('CA-N9L', 'CA-N9L (Lincoln, Ontario, Canada)'),
    ('CA-LLB', 'CA-LLB (Lindell Beach, British Columbia, Canada)'),
    ('CA-LDI', 'CA-LDI (Linden, Alberta, Canada)'),
    ('CA-LND', 'CA-LND (Lindsay, Ontario, Canada)'),
    ('CA-LGN', 'CA-LGN (Lingan, Nova Scotia, Canada)'),
    ('CA-LWD', 'CA-LWD (Linwood, Ontario, Canada)'),
    ('CA-LIB', 'CA-LIB (Lions Bay, British Columbia, Canada)'),
    ('CA-LTW', 'CA-LTW (Listowel, Ontario, Canada)'),
    ('CA-LBO', 'CA-LBO (Little Britain, Ontario, Canada)'),
    ('CA-LBK', 'CA-LBK (Little Brook, Nova Scotia, Canada)'),
    ('CA-LIC', 'CA-LIC (Little Current, Ontario, Canada)'),
    ('CA-ZGR', 'CA-ZGR (Little Grand Rapids, Manitoba, Canada)'),
    ('CA-LIN', 'CA-LIN (Little Narrows, Nova Scotia, Canada)'),
    ('CA-LSO', 'CA-LSO (Little Shemogue, New Brunswick, Canada)'),
    ('CA-LSY', 'CA-LSY (Little Smoky, Alberta, Canada)'),
    ('CA-LVY', 'CA-LVY (Lively, Ontario, Canada)'),
    ('CA-LIV', 'CA-LIV (Liverpool, Nova Scotia, Canada)'),
    ('CA-LMR', 'CA-LMR (Lloydminster, Saskatchewan, Canada)'),
    ('CA-YLL', 'CA-YLL (Lloydminster, Alberta, Canada)'),
    ('CA-LOB', 'CA-LOB (Lobo, Ontario, Canada)'),
    ('CA-LCP', 'CA-LCP (Lockeport, Nova Scotia, Canada)'),
    ('CA-LKP', 'CA-LKP (Lockport, Manitoba, Canada)'),
    ('CA-OCH', 'CA-OCH (Locusthill, Ontario, Canada)'),
    ('CA-LDG', 'CA-LDG (Lodgepole, Alberta, Canada)'),
    ('CA-LNL', 'CA-LNL (Logan Lake, British Columbia, Canada)'),
    ('CA-LGY', 'CA-LGY (Logy Bay, Newfoundland and Labrador, Canada)'),
    ('CA-LOY', 'CA-LOY (Lombardy, Ontario, Canada)'),
    ('CA-LMD', 'CA-LMD (Lomond, Newfoundland and Labrador, Canada)'),
    ('CA-LOM', 'CA-LOM (Lomond, Alberta, Canada)'),
    ('CA-LOD', 'CA-LOD (London, Ontario, Canada)'),
    ('CA-ONL', 'CA-ONL (Londonderry, Nova Scotia, Canada)'),
    ('CA-LNB', 'CA-LNB (Lone Butte, British Columbia, Canada)'),
    ('CA-LOH', 'CA-LOH (Long Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-YLX', 'CA-YLX (Long Point, Ontario, Canada)'),
    ('CA-LOP', 'CA-LOP (Long Pond, Newfoundland and Labrador, Canada)'),
    ('CA-LST', 'CA-LST (Long Sault, Ontario, Canada)'),
    ('CA-LFM', 'CA-LFM (Longford Mills, Ontario, Canada)'),
    ('CA-LOG', 'CA-LOG (Longlac, Ontario, Canada)'),
    ('CA-LNP', 'CA-LNP (Longue-Pointe, Quebec, Canada)'),
    ('CA-LON', 'CA-LON (Longueuil, Quebec, Canada)'),
    ('CA-LRT', 'CA-LRT (Lorette, Manitoba, Canada)'),
    ('CA-LVL', 'CA-LVL (Loretteville, Quebec, Canada)'),
    ('CA-LTO', 'CA-LTO (Loretto, Ontario, Canada)'),
    ('CA-LNV', 'CA-LNV (Lorneville, Ontario, Canada)'),
    ('CA-LOT', 'CA-LOT (Lotbinière, Quebec, Canada)'),
    ('CA-LOE', 'CA-LOE (Lougheed, Alberta, Canada)'),
    ('CA-LOU', 'CA-LOU (Louisbourg, Nova Scotia, Canada)'),
    ('CA-LSV', 'CA-LSV (Louiseville, Quebec, Canada)'),
    ('CA-LWB', 'CA-LWB (Lowbanks, Ontario, Canada)'),
    ('CA-LWF', 'CA-LWF (Lowe Farm, Manitoba, Canada)'),
    ('CA-LCV', 'CA-LCV (Lower Cove, Newfoundland and Labrador, Canada)'),
    ('CA-LEO', 'CA-LEO (Lower East Pubnico, Nova Scotia, Canada)'),
    ('CA-SKL', 'CA-SKL (Lower Sackville, Nova Scotia, Canada)'),
    ('CA-LWH', 'CA-LWH (Lower Woods Harbour, Nova Scotia, Canada)'),
    ('CA-LUU', 'CA-LUU (Lucan, Ontario, Canada)'),
    ('CA-LKN', 'CA-LKN (Lucknow, Ontario, Canada)'),
    ('CA-LCL', 'CA-LCL (Lucky Lake, Saskatchewan, Canada)'),
    ('CA-LUY', 'CA-LUY (Lumby, British Columbia, Canada)'),
    ('CA-LUN', 'CA-LUN (Lunenburg, Nova Scotia, Canada)'),
    ('CA-LKV', 'CA-LKV (Luskville, Quebec, Canada)'),
    ('CA-YSG', 'CA-YSG (Luskville, Quebec, Canada)'),
    ('CA-YAJ', 'CA-YAJ (Lyall Harbour, British Columbia, Canada)'),
    ('CA-LYA', 'CA-LYA (Lyalta, Alberta, Canada)'),
    ('CA-LYN', 'CA-LYN (Lyn, Ontario, Canada)'),
    ('CA-YYL', 'CA-YYL (Lynn Lake, Manitoba, Canada)'),
    ('CA-LYS', 'CA-LYS (Lyster, Quebec, Canada)'),
    ('CA-YLY', 'CA-YLY (Lytton, British Columbia, Canada)'),
    ('CA-LRY', 'CA-LRY (Léry, Quebec, Canada)'),
    ('CA-LEV', 'CA-LEV (Lévis, Quebec, Canada)'),
    ('CA-AEO', 'CA-AEO (Ma-Ma-O Beach, Alberta, Canada)'),
    ('CA-MAB', 'CA-MAB (Mabou, Nova Scotia, Canada)'),
    ('CA-MCC', 'CA-MCC (Macamic, Quebec, Canada)'),
    ('CA-MD8', 'CA-MD8 (Macdonald, Manitoba, Canada)'),
    ('CA-MBC', 'CA-MBC (Maces Bay, New Brunswick, Canada)'),
    ('CA-MGG', 'CA-MGG (Macgregor, Manitoba, Canada)'),
    ('CA-MNZ', 'CA-MNZ (Mackenzie, British Columbia, Canada)'),
    ('CA-MKL', 'CA-MKL (Macklin, Saskatchewan, Canada)'),
    ('CA-MCO', 'CA-MCO (Macoun, Saskatchewan, Canada)'),
    ('CA-MTQ', 'CA-MTQ (Mactaquac, New Brunswick, Canada)'),
    ('CA-MCT', 'CA-MCT (Mactier, Ontario, Canada)'),
    ('CA-MWA', 'CA-MWA (Madawaska, Ontario, Canada)'),
    ('CA-MAD', 'CA-MAD (Madoc, Ontario, Canada)'),
    ('CA-MGD', 'CA-MGD (Magdalen Is, Quebec, Canada)'),
    ('CA-MNW', 'CA-MNW (Magnetawan, Ontario, Canada)'),
    ('CA-MAG', 'CA-MAG (Magog, Quebec, Canada)'),
    ('CA-MGP', 'CA-MGP (Magpie, Quebec, Canada)'),
    ('CA-MTA', 'CA-MTA (Magrath, Alberta, Canada)'),
    ('CA-MHB', 'CA-MHB (Mahone Bay, Nova Scotia, Canada)'),
    ('CA-MDS', 'CA-MDS (Maidstone, Ontario, Canada)'),
    ('CA-MBR', 'CA-MBR (Main Brook, Newfoundland and Labrador, Canada)'),
    ('CA-YDK', 'CA-YDK (Main Duck Island, Ontario, Canada)'),
    ('CA-MAI', 'CA-MAI (Maisonnette Point, New Brunswick, Canada)'),
    ('CA-MTL', 'CA-MTL (Maitland, Ontario, Canada)'),
    ('CA-YMN', 'CA-YMN (Makkovik, Newfoundland and Labrador, Canada)'),
    ('CA-MA2', 'CA-MA2 (Malagash, Nova Scotia, Canada)'),
    ('CA-MKW', 'CA-MKW (Malakwa, British Columbia, Canada)'),
    ('CA-MTI', 'CA-MTI (Malartic, Quebec, Canada)'),
    ('CA-MQE', 'CA-MQE (Malpeque Bay, Prince Edward Island, Canada)'),
    ('CA-MAL', 'CA-MAL (Malton, Ontario, Canada)'),
    ('CA-MAV', 'CA-MAV (Mandeville, Quebec, Canada)'),
    ('CA-MLL', 'CA-MLL (Manilla, Ontario, Canada)'),
    ('CA-MTU', 'CA-MTU (Manitou, Manitoba, Canada)'),
    ('CA-YMG', 'CA-YMG (Manitouwadge, Ontario, Canada)'),
    ('CA-YEM', 'CA-YEM (Manitowaning, Ontario, Canada)'),
    ('CA-YMW', 'CA-YMW (Maniwaki, Quebec, Canada)'),
    ('CA-MTK', 'CA-MTK (Manotick, Ontario, Canada)'),
    ('CA-MSU', 'CA-MSU (Manseau, Quebec, Canada)'),
    ('CA-MSF', 'CA-MSF (Mansfield, Ontario, Canada)'),
    ('CA-MAN', 'CA-MAN (Mansonville, Quebec, Canada)'),
    ('CA-MAP', 'CA-MAP (Maple, Ontario, Canada)'),
    ('CA-YAQ', 'CA-YAQ (Maple Bay, British Columbia, Canada)'),
    ('CA-MCR', 'CA-MCR (Maple Creek, Saskatchewan, Canada)'),
    ('CA-MPR', 'CA-MPR (Maple Ridge, New Brunswick, Canada)'),
    ('CA-MRI', 'CA-MRI (Maple Ridge, British Columbia, Canada)'),
    ('CA-MAR', 'CA-MAR (Marathon, Ontario, Canada)'),
    ('CA-MCD', 'CA-MCD (Marchand, Manitoba, Canada)'),
    ('CA-MGE', 'CA-MGE (Margaree, Nova Scotia, Canada)'),
    ('CA-MVA', 'CA-MVA (Margaree Valley, Nova Scotia, Canada)'),
    ('CA-MRG', 'CA-MRG (Margaret, Manitoba, Canada)'),
    ('CA-MRR', 'CA-MRR (Maria, Quebec, Canada)'),
    ('CA-YMC', 'CA-YMC (Maricourt Airstrip, Quebec, Canada)'),
    ('CA-MVL', 'CA-MVL (Marieville, Quebec, Canada)'),
    ('CA-MNV', 'CA-MNV (Marionville, Ontario, Canada)'),
    ('CA-MKD', 'CA-MKD (Markdale, Ontario, Canada)'),
    ('CA-MKH', 'CA-MKH (Markham, Ontario, Canada)'),
    ('CA-MMA', 'CA-MMA (Marmora, Ontario, Canada)'),
    ('CA-MQT', 'CA-MQT (Marquette, Manitoba, Canada)'),
    ('CA-MAT', 'CA-MAT (Marshalltown, Nova Scotia, Canada)'),
    ('CA-MVS', 'CA-MVS (Martensville, Saskatchewan, Canada)'),
    ('CA-MTT', 'CA-MTT (Martintown, Ontario, Canada)'),
    ('CA-YMH', "CA-YMH (Mary's Harbour, Newfoundland and Labrador, Canada)"),
    ('CA-MAH', 'CA-MAH (Maryhill, Ontario, Canada)'),
    ('CA-MTN', 'CA-MTN (Marystown, Newfoundland and Labrador, Canada)'),
    ('CA-MSC', 'CA-MSC (Mascouche, Quebec, Canada)'),
    ('CA-MKO', 'CA-MKO (Maskinonge, Quebec, Canada)'),
    ('CA-MSS', 'CA-MSS (Masset, British Columbia, Canada)'),
    ('CA-MAS', 'CA-MAS (Masson, Quebec, Canada)'),
    ('CA-MSO', 'CA-MSO (Masstown, Nova Scotia, Canada)'),
    ('CA-SVV', 'CA-SVV (Massueville, Quebec, Canada)'),
    ('CA-MHW', 'CA-MHW (Matachewan, Ontario, Canada)'),
    ('CA-YNM', 'CA-YNM (Matagami, Quebec, Canada)'),
    ('CA-MNE', 'CA-MNE (Matane, Quebec, Canada)'),
    ('CA-MPA', 'CA-MPA (Matapedia, New Brunswick, Canada)'),
    ('CA-MAE', 'CA-MAE (Mather, Manitoba, Canada)'),
    ('CA-MTS', 'CA-MTS (Matheson, Ontario, Canada)'),
    ('CA-TSQ', 'CA-TSQ (Matsqui, British Columbia, Canada)'),
    ('CA-MTW', 'CA-MTW (Mattawa, Ontario, Canada)'),
    ('CA-MXV', 'CA-MXV (Maxville, Ontario, Canada)'),
    ('CA-OML', 'CA-OML (Maxwell, Ontario, Canada)'),
    ('CA-MAY', 'CA-MAY (Mayerthorpe, Alberta, Canada)'),
    ('CA-MYM', 'CA-MYM (Maymont, Saskatchewan, Canada)'),
    ('CA-MYE', 'CA-MYE (Mayne, British Columbia, Canada)'),
    ('CA-MIE', 'CA-MIE (Mayne Island, British Columbia, Canada)'),
    ('CA-YMA', 'CA-YMA (Mayne Island, British Columbia, Canada)'),
    ('CA-MCA', 'CA-MCA (Mcadam, New Brunswick, Canada)'),
    ('CA-MCB', 'CA-MCB (Mcbride, British Columbia, Canada)'),
    ('CA-MCY', 'CA-MCY (Mccreary, Manitoba, Canada)'),
    ('CA-LLM', 'CA-LLM (Mcdougall, Ontario, Canada)'),
    ('CA-MGR', 'CA-MGR (McGregor, Ontario, Canada)'),
    ('CA-MKR', 'CA-MKR (McKellar, Ontario, Canada)'),
    ('CA-MCN', 'CA-MCN (McLean, Saskatchewan, Canada)'),
    ('CA-SEE', 'CA-SEE (McLeese Lake, British Columbia, Canada)'),
    ('CA-MNN', 'CA-MNN (McLennan, Alberta, Canada)'),
    ('CA-MCL', 'CA-MCL (Mcleod Lake, British Columbia, Canada)'),
    ('CA-MCM', 'CA-MCM (McMasterville, Quebec, Canada)'),
    ('CA-MHA', 'CA-MHA (Meacham, Saskatchewan, Canada)'),
    ('CA-MWC', 'CA-MWC (Meadow Creek, British Columbia, Canada)'),
    ('CA-YLJ', 'CA-YLJ (Meadow Lake, Saskatchewan, Canada)'),
    ('CA-MFD', 'CA-MFD (Meaford, Ontario, Canada)'),
    ('CA-YXH', 'CA-YXH (Medicine Hat, Alberta, Canada)'),
    ('CA-MED', 'CA-MED (Meductic, New Brunswick, Canada)'),
    ('CA-MEO', 'CA-MEO (Melancthon, Ontario, Canada)'),
    ('CA-ABU', 'CA-ABU (Melbourne, Quebec, Canada)'),
    ('CA-MLU', 'CA-MLU (Melbourne, Ontario, Canada)'),
    ('CA-MEL', 'CA-MEL (Meldrum, Ontario, Canada)'),
    ('CA-MDB', 'CA-MDB (Meldrum Bay, Ontario, Canada)'),
    ('CA-MFO', 'CA-MFO (Melfort, Saskatchewan, Canada)'),
    ('CA-MLT', 'CA-MLT (Melita, Manitoba, Canada)'),
    ('CA-MOH', 'CA-MOH (Melocheville, Quebec, Canada)'),
    ('CA-MEV', 'CA-MEV (Melville, Saskatchewan, Canada)'),
    ('CA-MAM', 'CA-MAM (Memramcook, New Brunswick, Canada)'),
    ('CA-MEB', 'CA-MEB (Menzies Bay, British Columbia, Canada)'),
    ('CA-MER', 'CA-MER (Mercier, Quebec, Canada)'),
    ('CA-MGH', 'CA-MGH (Merigomish, Nova Scotia, Canada)'),
    ('CA-MLI', 'CA-MLI (Merlin, Ontario, Canada)'),
    ('CA-MRK', 'CA-MRK (Merrickville, Ontario, Canada)'),
    ('CA-YMB', 'CA-YMB (Merritt, British Columbia, Canada)'),
    ('CA-YMR', 'CA-YMR (Merry Island, British Columbia, Canada)'),
    ('CA-MTC', 'CA-MTC (Metcalfe, Ontario, Canada)'),
    ('CA-MET', 'CA-MET (Meteghan, Nova Scotia, Canada)'),
    ('CA-MGV', 'CA-MGV (Meteghan River, Nova Scotia, Canada)'),
    ('CA-MMR', 'CA-MMR (Metis-sur-Mer, Quebec, Canada)'),
    ('CA-MSW', 'CA-MSW (Metiskow, Alberta, Canada)'),
    ('CA-YTO', 'CA-YTO (Metropolitan Area Apt/Toronto, Ontario, Canada)'),
    ('CA-MMI', 'CA-MMI (Miami, Manitoba, Canada)'),
    ('CA-MIC', 'CA-MIC (Mica Creek, British Columbia, Canada)'),
    ('CA-MIH', 'CA-MIH (Michipicoten, Ontario, Canada)'),
    ('CA-MMQ', 'CA-MMQ (Middle Musquodoboit, Nova Scotia, Canada)'),
    ('CA-MDD', 'CA-MDD (Middlebro, Manitoba, Canada)'),
    ('CA-MDL', 'CA-MDL (Middleton, Nova Scotia, Canada)'),
    ('CA-MDP', 'CA-MDP (Middleton, Prince Edward Island, Canada)'),
    ('CA-MDT', 'CA-MDT (Midhurst, Ontario, Canada)'),
    ('CA-MID', 'CA-MID (Midland, Ontario, Canada)'),
    ('CA-MIY', 'CA-MIY (Mildmay, Ontario, Canada)'),
    ('CA-ORD', 'CA-ORD (Milford, Ontario, Canada)'),
    ('CA-MKV', 'CA-MKV (Milk River, Alberta, Canada)'),
    ('CA-ILB', 'CA-ILB (Mill Bay, British Columbia, Canada)'),
    ('CA-MLV', 'CA-MLV (Millarville, Alberta, Canada)'),
    ('CA-MLB', 'CA-MLB (Millbank, Ontario, Canada)'),
    ('CA-MLK', 'CA-MLK (Millbank, New Brunswick, Canada)'),
    ('CA-MBK', 'CA-MBK (Millbrook, Ontario, Canada)'),
    ('CA-MLE', 'CA-MLE (Millet, Alberta, Canada)'),
    ('CA-MLG', 'CA-MLG (Millgrove, Ontario, Canada)'),
    ('CA-ILL', 'CA-ILL (Millhaven, Ontario, Canada)'),
    ('CA-MVI', 'CA-MVI (Millville, Nova Scotia, Canada)'),
    ('CA-MNI', 'CA-MNI (Millville, Nova Scotia, Canada)'),
    ('CA-MLR', 'CA-MLR (Milner, British Columbia, Canada)'),
    ('CA-MLN', 'CA-MLN (Milner Ridge, Manitoba, Canada)'),
    ('CA-ILO', 'CA-ILO (Milo, Alberta, Canada)'),
    ('CA-MIL', 'CA-MIL (Milton, Ontario, Canada)'),
    ('CA-MIO', 'CA-MIO (Milton, Nova Scotia, Canada)'),
    ('CA-MLO', 'CA-MLO (Milverton, Ontario, Canada)'),
    ('CA-MIM', 'CA-MIM (Miminegash, Prince Edward Island, Canada)'),
    ('CA-YMI', 'CA-YMI (Minaki, Ontario, Canada)'),
    ('CA-MYO', 'CA-MYO (Mindemoya, Ontario, Canada)'),
    ('CA-MIN', 'CA-MIN (Minden, Ontario, Canada)'),
    ('CA-YAV', 'CA-YAV (Miners Bay, British Columbia, Canada)'),
    ('CA-MNS', 'CA-MNS (Minesing, Ontario, Canada)'),
    ('CA-MSV', 'CA-MSV (Minesville, Nova Scotia, Canada)'),
    ('CA-EVI', 'CA-EVI (Mineville, Nova Scotia, Canada)'),
    ('CA-YLP', 'CA-YLP (Mingan, Quebec, Canada)'),
    ('CA-TOS', 'CA-TOS (Minitonas, Manitoba, Canada)'),
    ('CA-MDO', 'CA-MDO (Minnedosa, Manitoba, Canada)'),
    ('CA-MTO', 'CA-MTO (Minto, New Brunswick, Canada)'),
    ('CA-MIQ', 'CA-MIQ (Miquelon, Newfoundland and Labrador, Canada)'),
    ('CA-MRB', 'CA-MRB (Mirabel, Quebec, Canada)'),
    ('CA-YMX', 'CA-YMX (Mirabel Apt/Montreal, Quebec, Canada)'),
    ('CA-MIR', 'CA-MIR (Miramichi, New Brunswick, Canada)'),
    ('CA-MCE', 'CA-MCE (Miscouche, Prince Edward Island, Canada)'),
    ('CA-MIB', 'CA-MIB (Mission, British Columbia, Canada)'),
    ('CA-MIS', 'CA-MIS (Mississauga, Ontario, Canada)'),
    ('CA-MST', 'CA-MST (Mistassini, Quebec, Canada)'),
    ('CA-MII', 'CA-MII (Mistissini, Quebec, Canada)'),
    ('CA-MHL', 'CA-MHL (Mitchell, Ontario, Canada)'),
    ('CA-MTH', 'CA-MTH (Mitchell, Manitoba, Canada)'),
    ('CA-MCH', 'CA-MCH (Monarch, Alberta, Canada)'),
    ('CA-MNT', 'CA-MNT (Moncton, New Brunswick, Canada)'),
    ('CA-MNK', 'CA-MNK (Monkland, Ontario, Canada)'),
    ('CA-MON', 'CA-MON (Monkton, Ontario, Canada)'),
    ('CA-ONO', 'CA-ONO (Mono, Ontario, Canada)'),
    ('CA-YYY', 'CA-YYY (Mont Joli, Quebec, Canada)'),
    ('CA-MRO', 'CA-MRO (Mont Rolland, Quebec, Canada)'),
    ('CA-MBL', 'CA-MBL (Mont Tremblant, Quebec, Canada)'),
    ('CA-NDM', 'CA-NDM (Mont-Carmel, Quebec, Canada)'),
    ('CA-MLA', 'CA-MLA (Mont-Laurier, Quebec, Canada)'),
    ('CA-MOL', 'CA-MOL (Mont-Louis, Quebec, Canada)'),
    ('CA-MRL', 'CA-MRL (Mont-Royal, Quebec, Canada)'),
    ('CA-MSG', 'CA-MSG (Mont-Saint-Gregoire, Quebec, Canada)'),
    ('CA-MSH', 'CA-MSH (Mont-Saint-Hilaire, Quebec, Canada)'),
    ('CA-YMF', 'CA-YMF (Montagne Harbor, British Columbia, Canada)'),
    ('CA-MGU', 'CA-MGU (Montague, Prince Edward Island, Canada)'),
    ('CA-LAE', 'CA-LAE (Monte Lake, British Columbia, Canada)'),
    ('CA-MBO', 'CA-MBO (Montebello, Quebec, Canada)'),
    ('CA-MGN', 'CA-MGN (Montmagny, Quebec, Canada)'),
    ('CA-MNY', 'CA-MNY (Montney, British Columbia, Canada)'),
    ('CA-MTR', 'CA-MTR (Montreal, Quebec, Canada)'),
    ('CA-YUL', 'CA-YUL (Montreal-Dorval Apt, Quebec, Canada)'),
    ('CA-8MT', 'CA-8MT (Montreal-Ouest, Quebec, Canada)'),
    ('CA-MRE', 'CA-MRE (Montréal-Est, Quebec, Canada)'),
    ('CA-MRN', 'CA-MRN (Montréal-Nord, Quebec, Canada)'),
    ('CA-MBE', 'CA-MBE (Moonbeam, Ontario, Canada)'),
    ('CA-MRF', 'CA-MRF (Moorefield, Ontario, Canada)'),
    ('CA-MRW', 'CA-MRW (Mooretown, Ontario, Canada)'),
    ('CA-MCK', 'CA-MCK (Moose Creek, Ontario, Canada)'),
    ('CA-MOO', 'CA-MOO (Moose Factory, Ontario, Canada)'),
    ('CA-YMJ', 'CA-YMJ (Moose Jaw, Saskatchewan, Canada)'),
    ('CA-YAD', 'CA-YAD (Moose Lake, Manitoba, Canada)'),
    ('CA-MSM', 'CA-MSM (Moosomin, Saskatchewan, Canada)'),
    ('CA-MOU', 'CA-MOU (Moosonee, Ontario, Canada)'),
    ('CA-MOR', 'CA-MOR (Morden, Manitoba, Canada)'),
    ('CA-MOP', 'CA-MOP (Morell, Prince Edward Island, Canada)'),
    ('CA-MHT', 'CA-MHT (Morin Heights, Quebec, Canada)'),
    ('CA-MRV', 'CA-MRV (Morinville, Alberta, Canada)'),
    ('CA-MRS', 'CA-MRS (Morris, Manitoba, Canada)'),
    ('CA-MOB', 'CA-MOB (Morrisburg, Ontario, Canada)'),
    ('CA-MSE', 'CA-MSE (Morse, Saskatchewan, Canada)'),
    ('CA-XSY', 'CA-XSY (Mossley, Ontario, Canada)'),
    ('CA-YMD', 'CA-YMD (Mossley, Ontario, Canada)'),
    ('CA-MBI', 'CA-MBI (Mount Albion, Prince Edward Island, Canada)'),
    ('CA-MNA', 'CA-MNA (Mount Arlington Heights, Newfoundland and Labrador, Canada)'),
    ('CA-MBY', 'CA-MBY (Mount Brydges, Ontario, Canada)'),
    ('CA-MEG', 'CA-MEG (Mount Elgin, Ontario, Canada)'),
    ('CA-MTF', 'CA-MTF (Mount Forest, Ontario, Canada)'),
    ('CA-MHO', 'CA-MHO (Mount Hope, Ontario, Canada)'),
    ('CA-MPE', 'CA-MPE (Mount Pearl, Newfoundland and Labrador, Canada)'),
    ('CA-MPS', 'CA-MPS (Mount Pleasant, Ontario, Canada)'),
    ('CA-MOS', 'CA-MOS (Mount Stewart, Prince Edward Island, Canada)'),
    ('CA-MUC', 'CA-MUC (Mount Uniacke, Nova Scotia, Canada)'),
    ('CA-MVW', 'CA-MVW (Mountain View, Alberta, Canada)'),
    ('CA-MKK', 'CA-MKK (Muirkirk, Ontario, Canada)'),
    ('CA-MUL', 'CA-MUL (Mulgrave, Nova Scotia, Canada)'),
    ('CA-MRU', 'CA-MRU (Mulmur, Ontario, Canada)'),
    ('CA-MUA', 'CA-MUA (Mundare, Alberta, Canada)'),
    ('CA-MVE', 'CA-MVE (Murdochville, Quebec, Canada)'),
    ('CA-YML', 'CA-YML (Murray Bay, Quebec, Canada)'),
    ('CA-MUH', 'CA-MUH (Murray Harbour, Prince Edward Island, Canada)'),
    ('CA-MUR', 'CA-MUR (Murray River, Prince Edward Island, Canada)'),
    ('CA-YQA', 'CA-YQA (Muskoka, Ontario, Canada)'),
    ('CA-MSA', 'CA-MSA (Muskrat Dam, Ontario, Canada)'),
    ('CA-MUS', 'CA-MUS (Musquodoboit Harbour, Nova Scotia, Canada)'),
    ('CA-MYR', 'CA-MYR (Myrtle, Manitoba, Canada)'),
    ('CA-MBN', 'CA-MBN (Métabetchouan-Lac-à-la-Croix, Quebec, Canada)'),
    ('CA-NAC', 'CA-NAC (Nackawic, New Brunswick, Canada)'),
    ('CA-NCM', 'CA-NCM (Naicam, Saskatchewan, Canada)'),
    ('CA-NAI', 'CA-NAI (Nain, Newfoundland and Labrador, Canada)'),
    ('CA-YQN', 'CA-YQN (Nakina, Ontario, Canada)'),
    ('CA-NAK', 'CA-NAK (Nakusp, British Columbia, Canada)'),
    ('CA-NMO', 'CA-NMO (Namao, Alberta, Canada)'),
    ('CA-NMP', 'CA-NMP (Nampa, Alberta, Canada)'),
    ('CA-ZNU', 'CA-ZNU (Namu, British Columbia, Canada)'),
    ('CA-NNO', 'CA-NNO (Nanaimo, British Columbia, Canada)'),
    ('CA-NVK', 'CA-NVK (Nanaimo, British Columbia, Canada)'),
    ('CA-NNE', 'CA-NNE (Nanoose Bay, British Columbia, Canada)'),
    ('CA-NAN', 'CA-NAN (Nanticoke, Ontario, Canada)'),
    ('CA-NTO', 'CA-NTO (Nanton, Alberta, Canada)'),
    ('CA-NDN', 'CA-NDN (Napadogan, New Brunswick, Canada)'),
    ('CA-APA', 'CA-APA (Napan, New Brunswick, Canada)'),
    ('CA-NPA', 'CA-NPA (Napanee, Ontario, Canada)'),
    ('CA-NAP', 'CA-NAP (Napierville, Quebec, Canada)'),
    ('CA-NMT', 'CA-NMT (Naramata, British Columbia, Canada)'),
    ('CA-NRS', 'CA-NRS (Narcisse, Manitoba, Canada)'),
    ('CA-YNA', 'CA-YNA (Natashquan, Quebec, Canada)'),
    ('CA-NBI', 'CA-NBI (Neebing, Ontario, Canada)'),
    ('CA-NEE', 'CA-NEE (Neepawa, Manitoba, Canada)'),
    ('CA-NRA', 'CA-NRA (Neerlandia, Alberta, Canada)'),
    ('CA-ZNG', 'CA-ZNG (Negginan, Manitoba, Canada)'),
    ('CA-NGU', 'CA-NGU (Neguac, New Brunswick, Canada)'),
    ('CA-NS3', "CA-NS3 (Neil's Harbour, Nova Scotia, Canada)"),
    ('CA-NLB', 'CA-NLB (Neilburg, Saskatchewan, Canada)'),
    ('CA-NLS', 'CA-NLS (Nelson, British Columbia, Canada)'),
    ('CA-NMI', 'CA-NMI (Nelson-Miramichi, New Brunswick, Canada)'),
    ('CA-NPN', 'CA-NPN (Nepean, Ontario, Canada)'),
    ('CA-NPU', 'CA-NPU (Nepeau, Ontario, Canada)'),
    ('CA-NPH', 'CA-NPH (Nephton, Ontario, Canada)'),
    ('CA-NEP', 'CA-NEP (Neptune, Saskatchewan, Canada)'),
    ('CA-NDO', 'CA-NDO (Neudorf, Saskatchewan, Canada)'),
    ('CA-NVE', 'CA-NVE (Neuville, Quebec, Canada)'),
    ('CA-NVS', 'CA-NVS (Nevis, Alberta, Canada)'),
    ('CA-NEA', 'CA-NEA (New Annan, Prince Edward Island, Canada)'),
    ('CA-NBM', 'CA-NBM (New Bothwell, Manitoba, Canada)'),
    ('CA-NCA', 'CA-NCA (New Canaan, New Brunswick, Canada)'),
    ('CA-NDA', 'CA-NDA (New Dayton, Alberta, Canada)'),
    ('CA-NDK', 'CA-NDK (New Denmark, New Brunswick, Canada)'),
    ('CA-NDV', 'CA-NDV (New Denver, British Columbia, Canada)'),
    ('CA-NDU', 'CA-NDU (New Dundee, Ontario, Canada)'),
    ('CA-NGY', 'CA-NGY (New Germany, Nova Scotia, Canada)'),
    ('CA-NGL', 'CA-NGL (New Glasgow, Nova Scotia, Canada)'),
    ('CA-NHM', 'CA-NHM (New Hamburg, Ontario, Canada)'),
    ('CA-NHU', 'CA-NHU (New Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-NLI', 'CA-NLI (New Liskeard, Ontario, Canada)'),
    ('CA-NLW', 'CA-NLW (New Lowell, Ontario, Canada)'),
    ('CA-NMA', 'CA-NMA (New Minas, Nova Scotia, Canada)'),
    ('CA-NOY', 'CA-NOY (New Norway, Alberta, Canada)'),
    ('CA-NRC', 'CA-NRC (New Richmond, Quebec, Canada)'),
    ('CA-NWR', 'CA-NWR (New Ross, Nova Scotia, Canada)'),
    ('CA-NWA', 'CA-NWA (New Waterford, Nova Scotia, Canada)'),
    ('CA-NWE', 'CA-NWE (New Westminster, British Columbia, Canada)'),
    ('CA-NWO', 'CA-NWO (Newbrook, Alberta, Canada)'),
    ('CA-NBH', 'CA-NBH (Newburgh, Ontario, Canada)'),
    ('CA-NCT', 'CA-NCT (Newcastle, New Brunswick, Canada)'),
    ('CA-NWT', 'CA-NWT (Newcastle, Ontario, Canada)'),
    ('CA-NWM', 'CA-NWM (Newmarket, Ontario, Canada)'),
    ('CA-N8Q', 'CA-N8Q (Newport, Quebec, Canada)'),
    ('CA-EWT', 'CA-EWT (Newton, Manitoba, Canada)'),
    ('CA-NIA', 'CA-NIA (Niagara Falls, Ontario, Canada)'),
    ('CA-NOL', 'CA-NOL (Niagara-on-the-Lake, Ontario, Canada)'),
    ('CA-NLT', 'CA-NLT (Nicolet, Quebec, Canada)'),
    ('CA-NIM', 'CA-NIM (Nimpkish, British Columbia, Canada)'),
    ('CA-NPL', 'CA-NPL (Nimpo Lake, British Columbia, Canada)'),
    ('CA-NPW', 'CA-NPW (Nipawin, Saskatchewan, Canada)'),
    ('CA-NPG', 'CA-NPG (Nipigon, Ontario, Canada)'),
    ('CA-NIU', 'CA-NIU (Nisku, Alberta, Canada)'),
    ('CA-NSK', 'CA-NSK (Nisku/Edmonton, Alberta, Canada)'),
    ('CA-YNI', 'CA-YNI (Nitchequon, Quebec, Canada)'),
    ('CA-NVL', 'CA-NVL (Niverville, Manitoba, Canada)'),
    ('CA-NBF', 'CA-NBF (Nobleford, Alberta, Canada)'),
    ('CA-NOB', 'CA-NOB (Nobleton, Ontario, Canada)'),
    ('CA-NKA', 'CA-NKA (Nootka, British Columbia, Canada)'),
    ('CA-YNK', 'CA-YNK (Nootka Sound, British Columbia, Canada)'),
    ('CA-NRN', 'CA-NRN (Noranda, Quebec, Canada)'),
    ('CA-NKF', 'CA-NKF (Norfolk County, Ontario, Canada)'),
    ('CA-NQA', 'CA-NQA (Norluay, Saskatchewan, Canada)'),
    ('CA-YVQ', 'CA-YVQ (Norluay, Saskatchewan, Canada)'),
    ('CA-NCV', "CA-NCV (Norman's Cove, Newfoundland and Labrador, Canada)"),
    ('CA-NMN', 'CA-NMN (Normandin, Quebec, Canada)'),
    ('CA-NAF', 'CA-NAF (North Arm Fraser, British Columbia, Canada)'),
    ('CA-YQW', 'CA-YQW (North Battleford, Saskatchewan, Canada)'),
    ('CA-NOR', 'CA-NOR (North Bay, Ontario, Canada)'),
    ('CA-NRB', 'CA-NRB (North Bend, British Columbia, Canada)'),
    ('CA-ENP', 'CA-ENP (North East Point, Nova Scotia, Canada)'),
    ('CA-NGW', 'CA-NGW (North Gower, Ontario, Canada)'),
    ('CA-NHR', 'CA-NHR (North Huron, Ontario, Canada)'),
    ('CA-NPI', 'CA-NPI (North Pine, British Columbia, Canada)'),
    ('CA-NPR', 'CA-NPR (North Portal, Saskatchewan, Canada)'),
    ('CA-XZ2', 'CA-XZ2 (North Preston, Nova Scotia, Canada)'),
    ('CA-NRU', 'CA-NRU (North Rustico, Prince Edward Island, Canada)'),
    ('CA-NSA', 'CA-NSA (North Saanich, British Columbia, Canada)'),
    ('CA-YNO', 'CA-YNO (North Spirit Lake, Ontario, Canada)'),
    ('CA-NSY', 'CA-NSY (North Sydney, Nova Scotia, Canada)'),
    ('CA-VAC', 'CA-VAC (North Vancouver, British Columbia, Canada)'),
    ('CA-NWH', 'CA-NWH (North Wiltshire, Prince Edward Island, Canada)'),
    ('CA-NYK', 'CA-NYK (North York, Ontario, Canada)'),
    ('CA-NPP', 'CA-NPP (Northampton, New Brunswick, Canada)'),
    ('CA-ORT', 'CA-ORT (Northbrook, Ontario, Canada)'),
    ('CA-NVA', 'CA-NVA (Norval, Ontario, Canada)'),
    ('CA-YNE', 'CA-YNE (Norway House, Manitoba, Canada)'),
    ('CA-NWC', 'CA-NWC (Norwich (Ontario), Ontario, Canada)'),
    ('CA-NPT', "CA-NPT (Notre-Dame-de-l'Île-Perrot, Quebec, Canada)"),
    ('CA-NDP', 'CA-NDP (Notre-Dame-de-la-Paix, Quebec, Canada)'),
    ('CA-NDL', 'CA-NDL (Notre-Dame-de-Lourdes, Manitoba, Canada)'),
    ('CA-NDS', 'CA-NDS (Notre-Dame-des-Pins, Quebec, Canada)'),
    ('CA-NPS', 'CA-NPS (Notre-Dame-des-Prairies, Quebec, Canada)'),
    ('CA-NBC', 'CA-NBC (Notre-Dame-du-Bon-Conseil, Quebec, Canada)'),
    ('CA-NND', 'CA-NND (Notre-Dame-du-Mont-Carmel, Quebec, Canada)'),
    ('CA-NUD', 'CA-NUD (Notre-Dame-du-Nord, Ontario, Canada)'),
    ('CA-NTW', 'CA-NTW (Nottawa, Ontario, Canada)'),
    ('CA-NYN', 'CA-NYN (Noyan, Quebec, Canada)'),
    ('CA-NTY', 'CA-NTY (Nuttby, Nova Scotia, Canada)'),
    ('CA-YNS', 'CA-YNS (Némiscau, Quebec, Canada)'),
    ('CA-OLE', "CA-OLE (O'Leary, Prince Edward Island, Canada)"),
    ('CA-OBY', 'CA-OBY (Oak Bay, British Columbia, Canada)'),
    ('CA-KRV', 'CA-KRV (Oak Bluff, Manitoba, Canada)'),
    ('CA-OAL', 'CA-OAL (Oak Lake, Manitoba, Canada)'),
    ('CA-OBK', 'CA-OBK (Oakbank, Manitoba, Canada)'),
    ('CA-OAJ', 'CA-OAJ (Oakville, Manitoba, Canada)'),
    ('CA-OAK', 'CA-OAK (Oakville, Ontario, Canada)'),
    ('CA-YDW', 'CA-YDW (Oakville, Ontario, Canada)'),
    ('CA-OFA', 'CA-OFA (Ocean Falls, British Columbia, Canada)'),
    ('CA-ODE', 'CA-ODE (Odessa, Ontario, Canada)'),
    ('CA-YOG', 'CA-YOG (Ogoki, Ontario, Canada)'),
    ('CA-OWK', 'CA-OWK (Ohsweken, Ontario, Canada)'),
    ('CA-OSG', 'CA-OSG (Oil Springs, Ontario, Canada)'),
    ('CA-OKA', 'CA-OKA (Oka, Quebec, Canada)'),
    ('CA-OFL', 'CA-OFL (Okanagan Falls, British Columbia, Canada)'),
    ('CA-OTS', 'CA-OTS (Okotoks, Alberta, Canada)'),
    ('CA-YOC', 'CA-YOC (Okotoks, Alberta, Canada)'),
    ('CA-ZFB', 'CA-ZFB (Old Fort Bay, Quebec, Canada)'),
    ('CA-OPL', 'CA-OPL (Old Perlican, Newfoundland and Labrador, Canada)'),
    ('CA-OCA', 'CA-OCA (Oldcastle, Ontario, Canada)'),
    ('CA-ODS', 'CA-ODS (Olds, Alberta, Canada)'),
    ('CA-OVR', 'CA-OVR (Oliver, British Columbia, Canada)'),
    ('CA-OMM', 'CA-OMM (Omemee, Ontario, Canada)'),
    ('CA-OPH', 'CA-OPH (Ompah, Ontario, Canada)'),
    ('CA-ONP', 'CA-ONP (Onaping, Ontario, Canada)'),
    ('CA-OLL', 'CA-OLL (Onion Lake, Saskatchewan, Canada)'),
    ('CA-OWY', 'CA-OWY (Onoway, Alberta, Canada)'),
    ('CA-S8W', 'CA-S8W (Onslow, Nova Scotia, Canada)'),
    ('CA-OGD', 'CA-OGD (Orangedale, Nova Scotia, Canada)'),
    ('CA-ORA', 'CA-ORA (Orangeville, Ontario, Canada)'),
    ('CA-ORF', 'CA-ORF (Orford, Quebec, Canada)'),
    ('CA-ORI', 'CA-ORI (Orillia, Ontario, Canada)'),
    ('CA-OLS', 'CA-OLS (Orléans, Ontario, Canada)'),
    ('CA-ORM', 'CA-ORM (Ormstown, Quebec, Canada)'),
    ('CA-OOO', 'CA-OOO (Oro-Medonte, Ontario, Canada)'),
    ('CA-ORO', 'CA-ORO (Oromocto, New Brunswick, Canada)'),
    ('CA-ORR', 'CA-ORR (Orono, Ontario, Canada)'),
    ('CA-ONT', 'CA-ONT (Orton, Ontario, Canada)'),
    ('CA-OGO', 'CA-OGO (Osgoode, Ontario, Canada)'),
    ('CA-OSH', 'CA-OSH (Oshawa, Ontario, Canada)'),
    ('CA-OSL', 'CA-OSL (Osler, Saskatchewan, Canada)'),
    ('CA-OYS', 'CA-OYS (Osoyoos, British Columbia, Canada)'),
    ('CA-OTT', 'CA-OTT (Ottawa, Ontario, Canada)'),
    ('CA-YOW', 'CA-YOW (Ottawa Apt, Ontario, Canada)'),
    ('CA-OTB', 'CA-OTB (Otterburne, Manitoba, Canada)'),
    ('CA-OTV', 'CA-OTV (Otterville, Ontario, Canada)'),
    ('CA-OOK', 'CA-OOK (Outlook, Saskatchewan, Canada)'),
    ('CA-OTM', 'CA-OTM (Outremont, Quebec, Canada)'),
    ('CA-OWS', 'CA-OWS (Owen Sound, Ontario, Canada)'),
    ('CA-OXB', 'CA-OXB (Oxbow, Saskatchewan, Canada)'),
    ('CA-OXF', 'CA-OXF (Oxford, Nova Scotia, Canada)'),
    ('CA-YOH', 'CA-YOH (Oxford House, Manitoba, Canada)'),
    ('CA-OYM', 'CA-OYM (Oyama, British Columbia, Canada)'),
    ('CA-OYN', 'CA-OYN (Oyen, Alberta, Canada)'),
    ('CA-PWD', 'CA-PWD (Paddockwood, Saskatchewan, Canada)'),
    ('CA-PCU', 'CA-PCU (Pain Court, Ontario, Canada)'),
    ('CA-PLY', 'CA-PLY (Paisley, Ontario, Canada)'),
    ('CA-PAK', 'CA-PAK (Pakenham, Ontario, Canada)'),
    ('CA-YIF', 'CA-YIF (Pakuashipi, Quebec, Canada)'),
    ('CA-PLV', 'CA-PLV (Palgrave, Ontario, Canada)'),
    ('CA-PLM', 'CA-PLM (Palmarolle, Quebec, Canada)'),
    ('CA-PMR', 'CA-PMR (Palmerston, Ontario, Canada)'),
    ('CA-PGM', 'CA-PGM (Pangman, Saskatchewan, Canada)'),
    ('CA-PNT', 'CA-PNT (Pangman, Saskatchewan, Canada)'),
    ('CA-PRM', 'CA-PRM (Panorama, British Columbia, Canada)'),
    ('CA-PPV', 'CA-PPV (Papineauville, Quebec, Canada)'),
    ('CA-PRI', 'CA-PRI (Paradise, Newfoundland and Labrador, Canada)'),
    ('CA-YDE', 'CA-YDE (Paradise River, Newfoundland and Labrador, Canada)'),
    ('CA-PAO', 'CA-PAO (Paris, Ontario, Canada)'),
    ('CA-PAV', 'CA-PAV (Parisville, Quebec, Canada)'),
    ('CA-PKH', 'CA-PKH (Parkhill, Ontario, Canada)'),
    ('CA-PKL', 'CA-PKL (Parkland, Alberta, Canada)'),
    ('CA-PAE', 'CA-PAE (Parksville, British Columbia, Canada)'),
    ('CA-PAR', 'CA-PAR (Parrsboro, Nova Scotia, Canada)'),
    ('CA-PRS', 'CA-PRS (Parry Sound, Ontario, Canada)'),
    ('CA-PXN', 'CA-PXN (Parson, British Columbia, Canada)'),
    ('CA-PSD', 'CA-PSD (Pasadena, Newfoundland and Labrador, Canada)'),
    ('CA-PAS', 'CA-PAS (Paspebiac, Quebec, Canada)'),
    ('CA-PTB', 'CA-PTB (Patricia Bay, British Columbia, Canada)'),
    ('CA-YPC', 'CA-YPC (Patricia Bay, British Columbia, Canada)'),
    ('CA-YPE', 'CA-YPE (Peace River, Alberta, Canada)'),
    ('CA-PHN', 'CA-PHN (Peachland, British Columbia, Canada)'),
    ('CA-YYZ', 'CA-YYZ (Pearson International Apt/Toronto, Ontario, Canada)'),
    ('CA-YPO', 'CA-YPO (Peawanuck, Ontario, Canada)'),
    ('CA-PEE', 'CA-PEE (Peers, Alberta, Canada)'),
    ('CA-GGY', 'CA-GGY (Peggys Cove, Nova Scotia, Canada)'),
    ('CA-PLH', 'CA-PLH (Pelham, Ontario, Canada)'),
    ('CA-YUF', 'CA-YUF (Pelham, Ontario, Canada)'),
    ('CA-PBN', 'CA-PBN (Pemberton, British Columbia, Canada)'),
    ('CA-PEM', 'CA-PEM (Pembroke, Ontario, Canada)'),
    ('CA-PEH', 'CA-PEH (Pender Harbour, British Columbia, Canada)'),
    ('CA-PTH', 'CA-PTH (Penetanguishene, Ontario, Canada)'),
    ('CA-PNH', 'CA-PNH (Penhold, Alberta, Canada)'),
    ('CA-PFD', 'CA-PFD (Pennfield, New Brunswick, Canada)'),
    ('CA-PEN', 'CA-PEN (Pennfield Ridge, New Brunswick, Canada)'),
    ('CA-PNB', 'CA-PNB (Penobsquis, New Brunswick, Canada)'),
    ('CA-YYF', 'CA-YYF (Penticton, British Columbia, Canada)'),
    ('CA-ERC', 'CA-ERC (Percé, Quebec, Canada)'),
    ('CA-PDU', 'CA-PDU (Perdue, Saskatchewan, Canada)'),
    ('CA-PER', 'CA-PER (Perth, Ontario, Canada)'),
    ('CA-PAN', 'CA-PAN (Perth-Andover, New Brunswick, Canada)'),
    ('CA-YWA', 'CA-YWA (Petawawa, Ontario, Canada)'),
    ('CA-PBH', 'CA-PBH (Peterborough, Ontario, Canada)'),
    ('CA-PBR', 'CA-PBR (Petersburg, Ontario, Canada)'),
    ('CA-PFI', 'CA-PFI (Petersfield, Manitoba, Canada)'),
    ('CA-PRO', 'CA-PRO (Petit Rocher, New Brunswick, Canada)'),
    ('CA-PGR', 'CA-PGR (Petit-de-Grat, Nova Scotia, Canada)'),
    ('CA-PCD', 'CA-PCD (Petitcodiac, New Brunswick, Canada)'),
    ('CA-PRF', 'CA-PRF (Petite-Riviere-Saint-Francois, Quebec, Canada)'),
    ('CA-PET', 'CA-PET (Petrolia, Ontario, Canada)'),
    ('CA-PHB', 'CA-PHB (Petty Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-PHL', 'CA-PHL (Philipsburg, Quebec, Canada)'),
    ('CA-PVI', 'CA-PVI (Pickardville, Alberta, Canada)'),
    ('CA-PCK', 'CA-PCK (Pickering, Ontario, Canada)'),
    ('CA-YPL', 'CA-YPL (Pickle Lake, Ontario, Canada)'),
    ('CA-PIC', 'CA-PIC (Picton, Ontario, Canada)'),
    ('CA-PTO', 'CA-PTO (Pictou, Nova Scotia, Canada)'),
    ('CA-PCB', 'CA-PCB (Picture Butte, Alberta, Canada)'),
    ('CA-PIE', 'CA-PIE (Pierrefonds, Quebec, Canada)'),
    ('CA-PRV', 'CA-PRV (Pierreville, Quebec, Canada)'),
    ('CA-PSO', 'CA-PSO (Pierson, Manitoba, Canada)'),
    ('CA-YPM', 'CA-YPM (Pikangikum, Ontario, Canada)'),
    ('CA-PIW', 'CA-PIW (Pikwitonei, Manitoba, Canada)'),
    ('CA-PBE', 'CA-PBE (Pilot Butte, Saskatchewan, Canada)'),
    ('CA-WPC', 'CA-WPC (Pincher Creek, Alberta, Canada)'),
    ('CA-PIO', 'CA-PIO (Pincourt, Quebec, Canada)'),
    ('CA-PIF', 'CA-PIF (Pine Falls, Manitoba, Canada)'),
    ('CA-ZPO', 'CA-ZPO (Pine House, Saskatchewan, Canada)'),
    ('CA-YPP', 'CA-YPP (Pine House, Saskatchewan, Canada)'),
    ('CA-PIR', 'CA-PIR (Pine River, Manitoba, Canada)'),
    ('CA-PNY', 'CA-PNY (Piney, Manitoba, Canada)'),
    ('CA-PIN', 'CA-PIN (Pintendre, Quebec, Canada)'),
    ('CA-PPO', 'CA-PPO (Pipestone, Manitoba, Canada)'),
    ('CA-PIM', 'CA-PIM (Pitt Meadows, British Columbia, Canada)'),
    ('CA-PLS', 'CA-PLS (Plaisance, Quebec, Canada)'),
    ('CA-PMD', 'CA-PMD (Plamondon, Alberta, Canada)'),
    ('CA-PLN', 'CA-PLN (Plantagenet, Ontario, Canada)'),
    ('CA-PLR', 'CA-PLR (Plaster Rock, New Brunswick, Canada)'),
    ('CA-PLA', 'CA-PLA (Plattsville, Ontario, Canada)'),
    ('CA-PSV', 'CA-PSV (Pleasantville, Nova Scotia, Canada)'),
    ('CA-PLE', 'CA-PLE (Plessisville, Quebec, Canada)'),
    ('CA-PLC', 'CA-PLC (Plum Coulee, Manitoba, Canada)'),
    ('CA-PMS', 'CA-PMS (Plumas, Manitoba, Canada)'),
    ('CA-PHM', 'CA-PHM (Pohénégamook, Quebec, Canada)'),
    ('CA-PED', 'CA-PED (Point Edward, Nova Scotia, Canada)'),
    ('CA-PEW', 'CA-PEW (Point Edward, Ontario, Canada)'),
    ('CA-DLM', 'CA-DLM (Point Pelee, Ontario, Canada)'),
    ('CA-PTU', 'CA-PTU (Point Tupper, Nova Scotia, Canada)'),
    ('CA-ESX', 'CA-ESX (Point-Escuminac, New Brunswick, Canada)'),
    ('CA-PPC', 'CA-PPC (Pointe au Pic, Quebec, Canada)'),
    ('CA-PNO', 'CA-PNO (Pointe Noire, Quebec, Canada)'),
    ('CA-POP', 'CA-POP (Pointe-au-Pic, Quebec, Canada)'),
    ('CA-PAQ', 'CA-PAQ (Pointe-aux-Basques, Quebec, Canada)'),
    ('CA-AUX', 'CA-AUX (Pointe-aux-Outardes, Quebec, Canada)'),
    ('CA-PXT', 'CA-PXT (Pointe-aux-Trembles, Quebec, Canada)'),
    ('CA-PNC', 'CA-PNC (Pointe-Calumet, Quebec, Canada)'),
    ('CA-POI', 'CA-POI (Pointe-Claire, Quebec, Canada)'),
    ('CA-PFT', 'CA-PFT (Pointe-Fortune, Quebec, Canada)'),
    ('CA-PSA', 'CA-PSA (Pointe-Sapin, New Brunswick, Canada)'),
    ('CA-PDI', 'CA-PDI (Pointe-Sapin, New Brunswick, Canada)'),
    ('CA-PKA', 'CA-PKA (Ponoka, Alberta, Canada)'),
    ('CA-PTQ', 'CA-PTQ (Pont-Rouge, Quebec, Canada)'),
    ('CA-PTY', 'CA-PTY (Pontypool, Ontario, Canada)'),
    ('CA-POH', 'CA-POH (Poplar Hill, Ontario, Canada)'),
    ('CA-PCP', 'CA-PCP (Porcupine, Ontario, Canada)'),
    ('CA-PPL', 'CA-PPL (Porcupine Plain, Saskatchewan, Canada)'),
    ('CA-PAB', 'CA-PAB (Port Alberni, British Columbia, Canada)'),
    ('CA-PAC', 'CA-PAC (Port Alice, British Columbia, Canada)'),
    ('CA-POA', 'CA-POA (Port Arthur, Ontario, Canada)'),
    ('CA-PAP', 'CA-PAP (Port au Port, Newfoundland and Labrador, Canada)'),
    ('CA-PBI', 'CA-PBI (Port Bickerton, Nova Scotia, Canada)'),
    ('CA-BUZ', 'CA-BUZ (Port Burwell, Ontario, Canada)'),
    ('CA-CR9', 'CA-CR9 (Port Carling, Ontario, Canada)'),
    ('CA-PCS', 'CA-PCS (Port Clements, British Columbia, Canada)'),
    ('CA-PCO', 'CA-PCO (Port Colborne, Ontario, Canada)'),
    ('CA-PTC', 'CA-PTC (Port Coquitlam, British Columbia, Canada)'),
    ('CA-PCR', 'CA-PCR (Port Credit, Ontario, Canada)'),
    ('CA-PDV', 'CA-PDV (Port Dover, Ontario, Canada)'),
    ('CA-PTE', 'CA-PTE (Port Edward, British Columbia, Canada)'),
    ('CA-GIN', 'CA-GIN (Port Elgin, Ontario, Canada)'),
    ('CA-PEL', 'CA-PEL (Port Elgin, New Brunswick, Canada)'),
    ('CA-PGA', 'CA-PGA (Port George, Nova Scotia, Canada)'),
    ('CA-PHY', 'CA-PHY (Port Hardy, British Columbia, Canada)'),
    ('CA-PHA', 'CA-PHA (Port Hastings, Nova Scotia, Canada)'),
    ('CA-PHW', 'CA-PHW (Port Hawkesbury, Nova Scotia, Canada)'),
    ('CA-OPE', 'CA-OPE (Port Hope, Ontario, Canada)'),
    ('CA-NSL', 'CA-NSL (Port La Tour, Nova Scotia, Canada)'),
    ('CA-PTM', 'CA-PTM (Port Maitland, Nova Scotia, Canada)'),
    ('CA-PNA', 'CA-PNA (Port Mann, British Columbia, Canada)'),
    ('CA-PMA', 'CA-PMA (Port McNeill, British Columbia, Canada)'),
    ('CA-PMW', 'CA-PMW (Port Medway, Nova Scotia, Canada)'),
    ('CA-PML', 'CA-PML (Port Mellon, British Columbia, Canada)'),
    ('CA-PMO', 'CA-PMO (Port Moody/Vancouver, British Columbia, Canada)'),
    ('CA-PMN', 'CA-PMN (Port Mouton, Nova Scotia, Canada)'),
    ('CA-PNE', 'CA-PNE (Port Nelson, Manitoba, Canada)'),
    ('CA-PNN', 'CA-PNN (Port Nelson, Newfoundland and Labrador, Canada)'),
    ('CA-PRP', 'CA-PRP (Port Perry, Ontario, Canada)'),
    ('CA-PRB', 'CA-PRB (Port Robinson, Ontario, Canada)'),
    ('CA-PSX', 'CA-PSX (Port Saxon, Nova Scotia, Canada)'),
    ('CA-PSI', 'CA-PSI (Port Simpson, British Columbia, Canada)'),
    ('CA-PST', 'CA-PST (Port Stanley, Ontario, Canada)'),
    ('CA-PWE', 'CA-PWE (Port Weller, Ontario, Canada)'),
    ('CA-PWI', 'CA-PWI (Port Williams, Nova Scotia, Canada)'),
    ('CA-PAF', 'CA-PAF (Port-Alfred, Quebec, Canada)'),
    ('CA-PCA', 'CA-PCA (Port-Cartier, Quebec, Canada)'),
    ('CA-PDL', 'CA-PDL (Port-Daniel, Quebec, Canada)'),
    ('CA-GPD', 'CA-GPD (Port-Daniel - Gascons, Quebec, Canada)'),
    ('CA-PME', 'CA-PME (Port-Menier, Quebec, Canada)'),
    ('CA-POR', 'CA-POR (Portage, Prince Edward Island, Canada)'),
    ('CA-PLP', 'CA-PLP (Portage La Prairie, Manitoba, Canada)'),
    ('CA-PGF', 'CA-PGF (Portage-Du-Fort, Quebec, Canada)'),
    ('CA-PTL', 'CA-PTL (Portland, Ontario, Canada)'),
    ('CA-PTN', 'CA-PTN (Portneuf, Quebec, Canada)'),
    ('CA-PMG', 'CA-PMG (Poste Montagnais, Quebec, Canada)'),
    ('CA-POU', 'CA-POU (Pouce Coupe, British Columbia, Canada)'),
    ('CA-POE', 'CA-POE (Poularies, Quebec, Canada)'),
    ('CA-PWS', 'CA-PWS (Powassan, Ontario, Canada)'),
    ('CA-WPL', 'CA-WPL (Powell Lake, British Columbia, Canada)'),
    ('CA-POW', 'CA-POW (Powell River, British Columbia, Canada)'),
    ('CA-PPR', 'CA-PPR (Preeceville, Saskatchewan, Canada)'),
    ('CA-CQ5', 'CA-CQ5 (Preissac, Quebec, Canada)'),
    ('CA-PRE', 'CA-PRE (Prescott, Ontario, Canada)'),
    ('CA-PRD', 'CA-PRD (Priddis, Alberta, Canada)'),
    ('CA-PRA', 'CA-PRA (Prince Albert, Saskatchewan, Canada)'),
    ('CA-CRL', 'CA-CRL (Prince Edward Island, Prince Edward Island, Canada)'),
    ('CA-PRG', 'CA-PRG (Prince George, British Columbia, Canada)'),
    ('CA-PRR', 'CA-PRR (Prince Rupert, British Columbia, Canada)'),
    ('CA-PRW', 'CA-PRW (Prince William, New Brunswick, Canada)'),
    ('CA-PCT', 'CA-PCT (Princeton, British Columbia, Canada)'),
    ('CA-PRT', 'CA-PRT (Princeton, Ontario, Canada)'),
    ('CA-PCE', 'CA-PCE (Princeville, Quebec, Canada)'),
    ('CA-PCH', 'CA-PCH (Pritchard, British Columbia, Canada)'),
    ('CA-PPT', 'CA-PPT (Prospect, Nova Scotia, Canada)'),
    ('CA-PVT', 'CA-PVT (Provost, Alberta, Canada)'),
    ('CA-VOS', 'CA-VOS (Prévost, Quebec, Canada)'),
    ('CA-PUB', 'CA-PUB (Pubnico, Nova Scotia, Canada)'),
    ('CA-PUG', 'CA-PUG (Pugwash, Nova Scotia, Canada)'),
    ('CA-PSG', 'CA-PSG (Purple Springs, Alberta, Canada)'),
    ('CA-PUH', 'CA-PUH (Puslinch, Ontario, Canada)'),
    ('CA-PUT', 'CA-PUT (Putnam, Ontario, Canada)'),
    ('CA-PBK', 'CA-PBK (Péribonka, Quebec, Canada)'),
    ('CA-QUA', "CA-QUA (Qu'Appelle, Saskatchewan, Canada)"),
    ('CA-QUB', 'CA-QUB (Qualicum Beach, British Columbia, Canada)'),
    ('CA-YQC', 'CA-YQC (Quaqtaq, Quebec, Canada)'),
    ('CA-QTS', 'CA-QTS (Quatsino, British Columbia, Canada)'),
    ('CA-QUE', 'CA-QUE (Quebec, Quebec, Canada)'),
    ('CA-YQB', 'CA-YQB (Quebec Apt, Quebec, Canada)'),
    ('CA-QCH', 'CA-QCH (Queen Charlotte, British Columbia, Canada)'),
    ('CA-QNS', 'CA-QNS (Queenston, Ontario, Canada)'),
    ('CA-QSN', 'CA-QSN (Quesnel, British Columbia, Canada)'),
    ('CA-QPS', 'CA-QPS (Quispamsis, New Brunswick, Canada)'),
    ('CA-QUL', 'CA-QUL (Quliqura, Alberta, Canada)'),
    ('CA-QUY', 'CA-QUY (Quyon, Quebec, Canada)'),
    ('CA-RAD', 'CA-RAD (Radisson, Quebec, Canada)'),
    ('CA-RDO', 'CA-RDO (Radisson, Saskatchewan, Canada)'),
    ('CA-RHP', 'CA-RHP (Radium Hot Springs, British Columbia, Canada)'),
    ('CA-RDV', 'CA-RDV (Radville, Saskatchewan, Canada)'),
    ('CA-RAE', 'CA-RAE (Radville, Saskatchewan, Canada)'),
    ('CA-RBL', 'CA-RBL (Rainbow Lake, Alberta, Canada)'),
    ('CA-RNR', 'CA-RNR (Rainier, Alberta, Canada)'),
    ('CA-RRV', 'CA-RRV (Rainy River, Ontario, Canada)'),
    ('CA-RAJ', 'CA-RAJ (Ralston, Alberta, Canada)'),
    ('CA-RMA', 'CA-RMA (Rama, Saskatchewan, Canada)'),
    ('CA-RAM', 'CA-RAM (Ramea, Newfoundland and Labrador, Canada)'),
    ('CA-RIT', 'CA-RIT (Ramea, Newfoundland and Labrador, Canada)'),
    ('CA-RPC', 'CA-RPC (Rapid City, Manitoba, Canada)'),
    ('CA-RWN', 'CA-RWN (Rawdon, Quebec, Canada)'),
    ('CA-RYD', 'CA-RYD (Raymond, Alberta, Canada)'),
    ('CA-YQF', 'CA-YQF (Red Deer, Alberta, Canada)'),
    ('CA-RLA', 'CA-RLA (Red Lake, Ontario, Canada)'),
    ('CA-RRC', 'CA-RRC (Red Rock, Ontario, Canada)'),
    ('CA-RCF', 'CA-RCF (Redcliff, Alberta, Canada)'),
    ('CA-RED', 'CA-RED (Redstone, British Columbia, Canada)'),
    ('CA-RVS', 'CA-RVS (Redvers, Saskatchewan, Canada)'),
    ('CA-RWA', 'CA-RWA (Redwater, Alberta, Canada)'),
    ('CA-RWM', 'CA-RWM (Redwood Meadow, Alberta, Canada)'),
    ('CA-RDM', 'CA-RDM (Redwood Meadows, Alberta, Canada)'),
    ('CA-REG', 'CA-REG (Regina, Saskatchewan, Canada)'),
    ('CA-YQR', 'CA-YQR (Regina Apt, Saskatchewan, Canada)'),
    ('CA-REV', 'CA-REV (Reidville, Newfoundland and Labrador, Canada)'),
    ('CA-REI', 'CA-REI (Reinfeld, Manitoba, Canada)'),
    ('CA-RNF', 'CA-RNF (Renfrew, Ontario, Canada)'),
    ('CA-REP', 'CA-REP (Repentigny, Quebec, Canada)'),
    ('CA-REB', 'CA-REB (Repentigny, Quebec, Canada)'),
    ('CA-RST', 'CA-RST (Restoule, Ontario, Canada)'),
    ('CA-YRV', 'CA-YRV (Revelstoke, British Columbia, Canada)'),
    ('CA-REX', 'CA-REX (Rexdale/Toronto, Ontario, Canada)'),
    ('CA-RXN', 'CA-RXN (Rexton, New Brunswick, Canada)'),
    ('CA-RCT', 'CA-RCT (Riceton, Saskatchewan, Canada)'),
    ('CA-RRO', 'CA-RRO (Richardson, Saskatchewan, Canada)'),
    ('CA-RIC', 'CA-RIC (Richelieu, Quebec, Canada)'),
    ('CA-RBT', 'CA-RBT (Richibucto, New Brunswick, Canada)'),
    ('CA-RBC', 'CA-RBC (Richmond, British Columbia, Canada)'),
    ('CA-RCH', 'CA-RCH (Richmond, Quebec, Canada)'),
    ('CA-RMD', 'CA-RMD (Richmond, Ontario, Canada)'),
    ('CA-RHI', 'CA-RHI (Richmond Hill, Ontario, Canada)'),
    ('CA-REF', 'CA-REF (Rideau Ferry, Ontario, Canada)'),
    ('CA-RTW', 'CA-RTW (Ridgetown, Ontario, Canada)'),
    ('CA-RGI', 'CA-RGI (Ridgeville, Ontario, Canada)'),
    ('CA-RVL', 'CA-RVL (Ridgeville, Manitoba, Canada)'),
    ('CA-ONR', 'CA-ONR (Ridgeway, Ontario, Canada)'),
    ('CA-RGD', 'CA-RGD (Rigaud, Quebec, Canada)'),
    ('CA-YRG', 'CA-YRG (Rigolet, Newfoundland and Labrador, Canada)'),
    ('CA-RIY', 'CA-RIY (Rimbey, Alberta, Canada)'),
    ('CA-RIM', 'CA-RIM (Rimouski, Quebec, Canada)'),
    ('CA-RTY', 'CA-RTY (Ripley, Ontario, Canada)'),
    ('CA-RPN', 'CA-RPN (Ripon, Quebec, Canada)'),
    ('CA-R8N', 'CA-R8N (River John, Nova Scotia, Canada)'),
    ('CA-RIV', 'CA-RIV (Riverport, Nova Scotia, Canada)'),
    ('CA-YYI', 'CA-YYI (Rivers, Manitoba, Canada)'),
    ('CA-YRN', 'CA-YRN (Rivers Inlet, British Columbia, Canada)'),
    ('CA-RVO', 'CA-RVO (Riverton, Manitoba, Canada)'),
    ('CA-RRG', 'CA-RRG (Riviere Rouge, Quebec, Canada)'),
    ('CA-6QC', 'CA-6QC (Riviere-Ouelle, Quebec, Canada)'),
    ('CA-YTN', 'CA-YTN (Rivière-au-Tonnerre, Quebec, Canada)'),
    ('CA-RBD', 'CA-RBD (Rivière-Beaudette, Quebec, Canada)'),
    ('CA-RDL', 'CA-RDL (Rivière-du-Loup, Quebec, Canada)'),
    ('CA-RHA', 'CA-RHA (Rivière-Héva, Quebec, Canada)'),
    ('CA-RRM', 'CA-RRM (Rivière-Matawin, Quebec, Canada)'),
    ('CA-RII', 'CA-RII (Rivière-Verte, New Brunswick, Canada)'),
    ('CA-ROA', 'CA-ROA (Roaches Line, Newfoundland and Labrador, Canada)'),
    ('CA-RTB', "CA-RTB (Robert's Bank, British Columbia, Canada)"),
    ('CA-RSN', 'CA-RSN (Robertson, Prince Edward Island, Canada)'),
    ('CA-RSV', 'CA-RSV (Robertsonville, Quebec, Canada)'),
    ('CA-YRJ', 'CA-YRJ (Roberval, Quebec, Canada)'),
    ('CA-RBN', 'CA-RBN (Robinsons, Newfoundland and Labrador, Canada)'),
    ('CA-RBI', 'CA-RBI (Roblin, Ontario, Canada)'),
    ('CA-ROB', 'CA-ROB (Roblin, Manitoba, Canada)'),
    ('CA-RVI', 'CA-RVI (Rocanville, Saskatchewan, Canada)'),
    ('CA-RHS', 'CA-RHS (Rochester, Alberta, Canada)'),
    ('CA-RKC', 'CA-RKC (Rock Creek, British Columbia, Canada)'),
    ('CA-ROF', 'CA-ROF (Rock Forest, Quebec, Canada)'),
    ('CA-ROK', 'CA-ROK (Rockland, Ontario, Canada)'),
    ('CA-GNN', 'CA-GNN (Rockport, Ontario, Canada)'),
    ('CA-RQQ', 'CA-RQQ (Rockton, Ontario, Canada)'),
    ('CA-RCD', 'CA-RCD (Rockwood, Ontario, Canada)'),
    ('CA-YRM', 'CA-YRM (Rocky Mountain House, Alberta, Canada)'),
    ('CA-ABR', 'CA-ABR (Rocky View County, Alberta, Canada)'),
    ('CA-ROC', 'CA-ROC (Rockyford, Alberta, Canada)'),
    ('CA-ROD', 'CA-ROD (Roddickton, Newfoundland and Labrador, Canada)'),
    ('CA-RDN', 'CA-RDN (Rodney, Ontario, Canada)'),
    ('CA-RGV', 'CA-RGV (Rogersville, New Brunswick, Canada)'),
    ('CA-RLH', 'CA-RLH (Rolling Hills, Alberta, Canada)'),
    ('CA-RYV', 'CA-RYV (Rolly View, Alberta, Canada)'),
    ('CA-ROO', 'CA-ROO (Roosville, British Columbia, Canada)'),
    ('CA-RSO', 'CA-RSO (Rosedale, British Columbia, Canada)'),
    ('CA-RSE', 'CA-RSE (Rosemont, Alberta, Canada)'),
    ('CA-ROS', 'CA-ROS (Rosemère, Quebec, Canada)'),
    ('CA-AQW', 'CA-AQW (Roseneath, Prince Edward Island, Canada)'),
    ('CA-RNO', 'CA-RNO (Rosenort, Manitoba, Canada)'),
    ('CA-RSW', 'CA-RSW (Rosetown, Saskatchewan, Canada)'),
    ('CA-RSR', 'CA-RSR (Rosser, Manitoba, Canada)'),
    ('CA-OSS', 'CA-OSS (Rosslyn, Ontario, Canada)'),
    ('CA-RPO', 'CA-RPO (Rossport, Ontario, Canada)'),
    ('CA-2KS', 'CA-2KS (Rosthern, Saskatchewan, Canada)'),
    ('CA-RSZ', 'CA-RSZ (Rothesay, New Brunswick, Canada)'),
    ('CA-ROU', 'CA-ROU (Rougemont, Quebec, Canada)'),
    ('CA-RSA', 'CA-RSA (Rouleau, Saskatchewan, Canada)'),
    ('CA-RDH', 'CA-RDH (Round Hill, Alberta, Canada)'),
    ('CA-ZRJ', 'CA-ZRJ (Round Lake, Ontario, Canada)'),
    ('CA-YUY', 'CA-YUY (Rouyn-Noranda, Quebec, Canada)'),
    ('CA-RWT', 'CA-RWT (Rowatt, Saskatchewan, Canada)'),
    ('CA-ROX', 'CA-ROX (Roxboro, Quebec, Canada)'),
    ('CA-RXF', 'CA-RXF (Roxton Falls, Quebec, Canada)'),
    ('CA-RXP', 'CA-RXP (Roxton Pond, Quebec, Canada)'),
    ('CA-RUI', 'CA-RUI (Rupert Inlet, British Columbia, Canada)'),
    ('CA-RHL', 'CA-RHL (Rush Lake, Saskatchewan, Canada)'),
    ('CA-RUS', 'CA-RUS (Ruskin, British Columbia, Canada)'),
    ('CA-RLL', 'CA-RLL (Russell, Manitoba, Canada)'),
    ('CA-RUV', 'CA-RUV (Ruthven, Ontario, Canada)'),
    ('CA-RLY', 'CA-RLY (Ryley, Alberta, Canada)'),
    ('CA-SNH', 'CA-SNH (Saanich, British Columbia, Canada)'),
    ('CA-SNC', 'CA-SNC (Saanichton, British Columbia, Canada)'),
    ('CA-SXO', 'CA-SXO (Saanichton Bay, British Columbia, Canada)'),
    ('CA-YSA', 'CA-YSA (Sable Island, Nova Scotia, Canada)'),
    ('CA-SRI', 'CA-SRI (Sable River, Nova Scotia, Canada)'),
    ('CA-ZPB', 'CA-ZPB (Sachigo Lake, Ontario, Canada)'),
    ('CA-YSY', 'CA-YSY (Sachigo Lake, Ontario, Canada)'),
    ('CA-SAC', 'CA-SAC (Sackville, New Brunswick, Canada)'),
    ('CA-XKV', 'CA-XKV (Sackville, Nova Scotia, Canada)'),
    ('CA-Q4C', 'CA-Q4C (Sacré-Coeur-Saguenay, Quebec, Canada)'),
    ('CA-YSV', 'CA-YSV (Saglek, Newfoundland and Labrador, Canada)'),
    ('CA-SAG', 'CA-SAG (Saguenay, Quebec, Canada)'),
    ('CA-S8A', 'CA-S8A (Saint Albert, Alberta, Canada)'),
    ('CA-SC4', 'CA-SC4 (Saint Catherines, Ontario, Canada)'),
    ('CA-F5R', 'CA-F5R (Saint Clements, Ontario, Canada)'),
    ('CA-FDM', 'CA-FDM (Saint Francois de Madawaska, New Brunswick, Canada)'),
    ('CA-SF6', 'CA-SF6 (Saint Frederic, Quebec, Canada)'),
    ('CA-SHQ', 'CA-SHQ (Saint Hilarion, Quebec, Canada)'),
    ('CA-SJM', 'CA-SJM (Saint Jerome, Quebec, Canada)'),
    ('CA-SGR', 'CA-SGR (Saint Liguori, Quebec, Canada)'),
    ('CA-SA9', 'CA-SA9 (Saint Paulin, Quebec, Canada)'),
    ('CA-S5S', 'CA-S5S (Saint Peters, Prince Edward Island, Canada)'),
    ('CA-TPR', 'CA-TPR (Saint Telesphore, Quebec, Canada)'),
    ('CA-S7T', 'CA-S7T (Saint Thomas, Ontario, Canada)'),
    ('CA-WON', 'CA-WON (Saint Williams, Ontario, Canada)'),
    ('CA-ADI', 'CA-ADI (Saint-Adrien, Quebec, Canada)'),
    ('CA-APT', 'CA-APT (Saint-Agapit, Quebec, Canada)'),
    ('CA-SAI', 'CA-SAI (Saint-Aimé, Quebec, Canada)'),
    ('CA-SAQ', 'CA-SAQ (Saint-Aimé-des-Lacs, Quebec, Canada)'),
    ('CA-SB5', 'CA-SB5 (Saint-Alban, Quebec, Canada)'),
    ('CA-SBT', 'CA-SBT (Saint-Albert, Alberta, Canada)'),
    ('CA-SLR', 'CA-SLR (Saint-Albert, Quebec, Canada)'),
    ('CA-AXM', 'CA-AXM (Saint-Alexis-de-Montcalm, Quebec, Canada)'),
    ('CA-APH', 'CA-APH (Saint-Alexis-de-Montcalm, Quebec, Canada)'),
    ('CA-MBA', 'CA-MBA (Saint-Amable, Quebec, Canada)'),
    ('CA-AMB', 'CA-AMB (Saint-Ambroise, Quebec, Canada)'),
    ('CA-AQC', 'CA-AQC (Saint-Ambroise-De-Kildare, Quebec, Canada)'),
    ('CA-ANA', 'CA-ANA (Saint-Anaclet, Quebec, Canada)'),
    ('CA-SAD', 'CA-SAD (Saint-Andrews, New Brunswick, Canada)'),
    ('CA-SRK', 'CA-SRK (Saint-André, New Brunswick, Canada)'),
    ('CA-SAA', 'CA-SAA (Saint-André-Avellin, Quebec, Canada)'),
    ('CA-SNG', "CA-SNG (Saint-André-d'Argenteuil, Quebec, Canada)"),
    ('CA-SKA', 'CA-SKA (Saint-André-de-Kamouraska, Quebec, Canada)'),
    ('CA-SAE', 'CA-SAE (Saint-André-Est, Quebec, Canada)'),
    ('CA-AIT', 'CA-AIT (Saint-Anicet, Quebec, Canada)'),
    ('CA-SKE', 'CA-SKE (Saint-Anne-de-Kent, New Brunswick, Canada)'),
    ('CA-SIE', 'CA-SIE (Saint-Anselme, Quebec, Canada)'),
    ('CA-SAT', 'CA-SAT (Saint-Anthony, Newfoundland and Labrador, Canada)'),
    ('CA-SAO', 'CA-SAO (Saint-Antoine-de-Tilly, Quebec, Canada)'),
    ('CA-STL', 'CA-STL (Saint-Antoine-des-Laurentides, Quebec, Canada)'),
    ('CA-SRU', 'CA-SRU (Saint-Antoine-sur-Richelieu, Quebec, Canada)'),
    ('CA-SAP', 'CA-SAP (Saint-Apollinaire, Quebec, Canada)'),
    ('CA-STD', 'CA-STD (Saint-Armand, Quebec, Canada)'),
    ('CA-AES', 'CA-AES (Saint-Arsène, Quebec, Canada)'),
    ('CA-SAU', 'CA-SAU (Saint-Augustin, Quebec, Canada)'),
    ('CA-SAN', 'CA-SAN (Saint-Augustin-de-Desmaures, Quebec, Canada)'),
    ('CA-AWB', 'CA-AWB (Saint-Augustin-de-Woburn, Quebec, Canada)'),
    ('CA-ADM', 'CA-ADM (Saint-Augustin-Deux-Montagnes, Quebec, Canada)'),
    ('CA-BBS', 'CA-BBS (Saint-Barnabé-Sud, Quebec, Canada)'),
    ('CA-SBM', 'CA-SBM (Saint-Barthelemy, Quebec, Canada)'),
    ('CA-SBA', 'CA-SBA (Saint-Basile, Quebec, Canada)'),
    ('CA-GBA', 'CA-GBA (Saint-Basile-le-Grand, Quebec, Canada)'),
    ('CA-SBL', 'CA-SBL (Saint-Benoît-Labre, Quebec, Canada)'),
    ('CA-SBD', 'CA-SBD (Saint-Bernard, Quebec, Canada)'),
    ('CA-BDL', 'CA-BDL (Saint-Bernard-de-Lacolle, Quebec, Canada)'),
    ('CA-QCS', 'CA-QCS (Saint-Bernard-de-Michaudville, Quebec, Canada)'),
    ('CA-TIA', 'CA-TIA (Saint-Bonaventure, Quebec, Canada)'),
    ('CA-BFW', 'CA-BFW (Saint-Boniface, Manitoba, Canada)'),
    ('CA-SNF', 'CA-SNF (Saint-Boniface, Quebec, Canada)'),
    ('CA-BIX', 'CA-BIX (Saint-Brieux, Saskatchewan, Canada)'),
    ('CA-TIO', 'CA-TIO (Saint-Bruno, Quebec, Canada)'),
    ('CA-SIB', 'CA-SIB (Saint-Bruno-de-Guigues, Quebec, Canada)'),
    ('CA-SBO', 'CA-SBO (Saint-Bruno-de-Montarville, Quebec, Canada)'),
    ('CA-BLJ', 'CA-BLJ (Saint-Bruno-du-Lac-Saint-Jean, Quebec, Canada)'),
    ('CA-BOJ', 'CA-BOJ (Saint-Bruno-du-Lac-Saint-Jean, Quebec, Canada)'),
    ('CA-CAX', 'CA-CAX (Saint-Calixte, Quebec, Canada)'),
    ('CA-SBC', 'CA-SBC (Saint-Camille-de-Bellechasse, Quebec, Canada)'),
    ('CA-SC3', 'CA-SC3 (Saint-Casimir, Quebec, Canada)'),
    ('CA-SCA', 'CA-SCA (Saint-Catharines, Ontario, Canada)'),
    ('CA-NSC', 'CA-NSC (Saint-Charles, Ontario, Canada)'),
    ('CA-SNT', 'CA-SNT (Saint-Charles-Borromée, Quebec, Canada)'),
    ('CA-SDC', 'CA-SDC (Saint-Charles-de-Bellechasse, Quebec, Canada)'),
    ('CA-ZCR', 'CA-ZCR (Saint-Charles-sur-Richelieu, Quebec, Canada)'),
    ('CA-SCP', "CA-SCP (Saint-Christophe-d'Arthabaska, Quebec, Canada)"),
    ('CA-SCH', 'CA-SCH (Saint-Chrysostome, Quebec, Canada)'),
    ('CA-SCU', 'CA-SCU (Saint-Claude, Manitoba, Canada)'),
    ('CA-SLN', 'CA-SLN (Saint-Clements, Ontario, Canada)'),
    ('CA-SOP', 'CA-SOP (Saint-Cleophas, Quebec, Canada)'),
    ('CA-SXC', 'CA-SXC (Saint-Clet, Quebec, Canada)'),
    ('CA-SC2', 'CA-SC2 (Saint-Clothilde, Quebec, Canada)'),
    ('CA-SIN', 'CA-SIN (Saint-Clément, Quebec, Canada)'),
    ('CA-COS', 'CA-COS (Saint-Colomban, Quebec, Canada)'),
    ('CA-STX', 'CA-STX (Saint-Constant, Quebec, Canada)'),
    ('CA-CBT', 'CA-CBT (Saint-Cuthbert, Quebec, Canada)'),
    ('CA-CYR', 'CA-CYR (Saint-Cyrille, Quebec, Canada)'),
    ('CA-CYW', 'CA-CYW (Saint-Cyrille-de-Wendover, Quebec, Canada)'),
    ('CA-CTN', 'CA-CTN (Saint-Célestin, Quebec, Canada)'),
    ('CA-SCS', 'CA-SCS (Saint-Césaire, Quebec, Canada)'),
    ('CA-SCM', 'CA-SCM (Saint-Côme, Quebec, Canada)'),
    ('CA-SCI', 'CA-SCI (Saint-Côme-Linière, Quebec, Canada)'),
    ('CA-SDA', 'CA-SDA (Saint-Damase, Quebec, Canada)'),
    ('CA-SDN', 'CA-SDN (Saint-Damien-de-Brandon, Quebec, Canada)'),
    ('CA-SDB', 'CA-SDB (Saint-Damien-de-Buckland, Quebec, Canada)'),
    ('CA-DF8', 'CA-DF8 (Saint-David-de-Falardeau, Quebec, Canada)'),
    ('CA-DDS', 'CA-DDS (Saint-Davids, Ontario, Canada)'),
    ('CA-DDB', 'CA-DDB (Saint-Denis-de-Brompton, Quebec, Canada)'),
    ('CA-DNR', 'CA-DNR (Saint-Denis-sur-Richelieu, Quebec, Canada)'),
    ('CA-SDQ', 'CA-SDQ (Saint-Dominique, Quebec, Canada)'),
    ('CA-SQG', 'CA-SQG (Saint-Edmond-de-Grantham, Quebec, Canada)'),
    ('CA-SMP', 'CA-SMP (Saint-Edmond-les-Plaines, Quebec, Canada)'),
    ('CA-SEZ', 'CA-SEZ (Saint-Elzéar/La-Nouvelle-Beau, Quebec, Canada)'),
    ('CA-SEP', 'CA-SEP (Saint-Ephrem-de-Beauce, Quebec, Canada)'),
    ('CA-SPT', 'CA-SPT (Saint-Esprit, Quebec, Canada)'),
    ('CA-SUG', 'CA-SUG (Saint-Eugène, Ontario, Canada)'),
    ('CA-EDD', 'CA-EDD (Saint-Eugène-de-Grantham, Quebec, Canada)'),
    ('CA-EMT', 'CA-EMT (Saint-Eustache, Manitoba, Canada)'),
    ('CA-SEU', 'CA-SEU (Saint-Eustache, Quebec, Canada)'),
    ('CA-FLC', 'CA-FLC (Saint-Faustin, Quebec, Canada)'),
    ('CA-SFN', 'CA-SFN (Saint-Ferréol-les-Neiges, Quebec, Canada)'),
    ('CA-QSF', 'CA-QSF (Saint-François, Quebec, Canada)'),
    ('CA-FRS', 'CA-FRS (Saint-François-de-la-Rivière-du-Sud, Quebec, Canada)'),
    ('CA-SFR', 'CA-SFR (Saint-François-du-Lac, Quebec, Canada)'),
    ('CA-SFY', 'CA-SFY (Saint-François-Montmagny, Quebec, Canada)'),
    ('CA-FCX', 'CA-FCX (Saint-François-Xavier, Manitoba, Canada)'),
    ('CA-FXB', 'CA-FXB (Saint-François-Xavier-de-Brompton, Quebec, Canada)'),
    ('CA-SFD', 'CA-SFD (Saint-Frédéric, Quebec, Canada)'),
    ('CA-SFE', 'CA-SFE (Saint-Félicien, Quebec, Canada)'),
    ('CA-ST3', 'CA-ST3 (Saint-Félix-de-Kingsey, Quebec, Canada)'),
    ('CA-SFX', 'CA-SFX (Saint-Félix-de-Valois, Quebec, Canada)'),
    ('CA-SGA', 'CA-SGA (Saint-Gabriel, Quebec, Canada)'),
    ('CA-SGD', 'CA-SGD (Saint-Gabriel-de-Brandon, Quebec, Canada)'),
    ('CA-SGE', 'CA-SGE (Saint-George, New Brunswick, Canada)'),
    ('CA-STG', 'CA-STG (Saint-George, Ontario, Canada)'),
    ('CA-SGG', 'CA-SGG (Saint-Georges, Quebec, Canada)'),
    ('CA-SGB', 'CA-SGB (Saint-Georges/Beauce-Sartigan, Quebec, Canada)'),
    ('CA-SGN', 'CA-SGN (Saint-Germain-de-Grantham, Quebec, Canada)'),
    ('CA-SGK', 'CA-SGK (Saint-Germain-de-Kamouraska, Quebec, Canada)'),
    ('CA-GER', 'CA-GER (Saint-German, Alberta, Canada)'),
    ('CA-SGQ', 'CA-SGQ (Saint-Gervais, Quebec, Canada)'),
    ('CA-SGI', 'CA-SGI (Saint-Gilles, Quebec, Canada)'),
    ('CA-SGO', 'CA-SGO (Saint-Gregor, Saskatchewan, Canada)'),
    ('CA-GUU', 'CA-GUU (Saint-Guillaume, Quebec, Canada)'),
    ('CA-W4C', 'CA-W4C (Saint-Gédéon, Quebec, Canada)'),
    ('CA-SHN', 'CA-SHN (Saint-Henri, Quebec, Canada)'),
    ('CA-SHG', 'CA-SHG (Saint-Herménégilde, Quebec, Canada)'),
    ('CA-SHI', 'CA-SHI (Saint-Hilaire, Quebec, Canada)'),
    ('CA-SHO', 'CA-SHO (Saint-Hippolyte, Quebec, Canada)'),
    ('CA-SHC', 'CA-SHC (Saint-Honoré-de-Chicoutimi, Quebec, Canada)'),
    ('CA-SHS', 'CA-SHS (Saint-Honoré-de-Shenley, Quebec, Canada)'),
    ('CA-SHU', 'CA-SHU (Saint-Hubert, Quebec, Canada)'),
    ('CA-HUG', 'CA-HUG (Saint-Hugues, Quebec, Canada)'),
    ('CA-SHY', 'CA-SHY (Saint-Hyacinthe, Quebec, Canada)'),
    ('CA-IGN', 'CA-IGN (Saint-Ignace-de-Stanbridge, Quebec, Canada)'),
    ('CA-SID', 'CA-SID (Saint-Isidore, Ontario, Canada)'),
    ('CA-XZC', "CA-XZC (Saint-Isidore d'Auckland, Quebec, Canada)"),
    ('CA-SJS', 'CA-SJS (Saint-Jacobs, Ontario, Canada)'),
    ('CA-SCQ', 'CA-SCQ (Saint-Jacques, Quebec, Canada)'),
    ('CA-SJJ', 'CA-SJJ (Saint-Jacques, New Brunswick, Canada)'),
    ('CA-SJQ', 'CA-SJQ (Saint-Jacques-le-Mineur, Quebec, Canada)'),
    ('CA-SJV', 'CA-SJV (Saint-Janvier, Quebec, Canada)'),
    ('CA-YJN', 'CA-YJN (Saint-Jean, Quebec, Canada)'),
    ('CA-BAZ', 'CA-BAZ (Saint-Jean-Baptiste, Quebec, Canada)'),
    ('CA-SAJ', 'CA-SAJ (Saint-Jean-Baptiste, Manitoba, Canada)'),
    ('CA-SJC', 'CA-SJC (Saint-Jean-Chrysostome, Quebec, Canada)'),
    ('CA-JDD', 'CA-JDD (Saint-Jean-De-Dieu, Quebec, Canada)'),
    ('CA-SDO', "CA-SDO (Saint-Jean-de-l'Île-d'Orléans, Quebec, Canada)"),
    ('CA-JPJ', 'CA-JPJ (Saint-Jean-Port-Joli, Quebec, Canada)'),
    ('CA-SJR', 'CA-SJR (Saint-Jean-sur-Richelieu, Quebec, Canada)'),
    ('CA-SJD', "CA-SJD (Saint-Jeanile-d'Orleans, Quebec, Canada)"),
    ('CA-JCV', 'CA-JCV (Saint-Joachim-de-Courval, Quebec, Canada)'),
    ('CA-JMY', 'CA-JMY (Saint-Joachim-de-Montmorency, Quebec, Canada)'),
    ('CA-SMO', 'CA-SMO (Saint-Joachim-de-Shefford, Quebec, Canada)'),
    ('CA-SJB', 'CA-SJB (Saint-John, New Brunswick, Canada)'),
    ('CA-YSJ', 'CA-YSJ (Saint-John Apt, New Brunswick, Canada)'),
    ('CA-SJF', "CA-SJF (Saint-John's, Newfoundland and Labrador, Canada)"),
    ('CA-YYT', 'CA-YYT (Saint-Johns-Apt, Newfoundland and Labrador, Canada)'),
    ('CA-JPH', 'CA-JPH (Saint-Joseph, Manitoba, Canada)'),
    ('CA-SJH', "CA-SJH (Saint-Joseph's, Newfoundland and Labrador, Canada)"),
    ('CA-XJH', 'CA-XJH (Saint-Joseph-de-Beauce, Quebec, Canada)'),
    ('CA-SJP', 'CA-SJP (Saint-Joseph-de-Coleraine, Quebec, Canada)'),
    ('CA-JDS', 'CA-JDS (Saint-Joseph-de-Sorel, Quebec, Canada)'),
    ('CA-SJL', 'CA-SJL (Saint-Joseph-du-Lac, Quebec, Canada)'),
    ('CA-JVT', 'CA-JVT (Saint-Jovite, Quebec, Canada)'),
    ('CA-XTJ', 'CA-XTJ (Saint-Jules, Quebec, Canada)'),
    ('CA-SJT', 'CA-SJT (Saint-Justin, Quebec, Canada)'),
    ('CA-SJE', 'CA-SJE (Saint-Jérôme, Quebec, Canada)'),
    ('CA-SLT', 'CA-SLT (Saint-Lambert, Quebec, Canada)'),
    ('CA-LTL', 'CA-LTL (Saint-Lambert-de-Lauzon, Quebec, Canada)'),
    ('CA-LRN', 'CA-LRN (Saint-Laurent, Manitoba, Canada)'),
    ('CA-SLA', 'CA-SLA (Saint-Laurent, Quebec, Canada)'),
    ('CA-SLO', "CA-SLO (Saint-Laurent-de-l'Île-d'Orléans, Quebec, Canada)"),
    ('CA-SLW', 'CA-SLW (Saint-Lawrence, Newfoundland and Labrador, Canada)'),
    ('CA-LZB', 'CA-LZB (Saint-Lazare-de-Bellechasse, Quebec, Canada)'),
    ('CA-ZLB', 'CA-ZLB (Saint-Lazare-de-Bellechasse, Quebec, Canada)'),
    ('CA-SLZ', 'CA-SLZ (Saint-Lazare-de-Vaudreuil, Quebec, Canada)'),
    ('CA-SLI', 'CA-SLI (Saint-Liboire, Quebec, Canada)'),
    ('CA-SLS', 'CA-SLS (Saint-Louis de Kent, New Brunswick, Canada)'),
    ('CA-QEB', 'CA-QEB (Saint-Louis-de-Blandford, Quebec, Canada)'),
    ('CA-SGU', 'CA-SGU (Saint-Louis-de-Gonzague, Quebec, Canada)'),
    ('CA-SLU', 'CA-SLU (Saint-Luc, Quebec, Canada)'),
    ('CA-SUH', 'CA-SUH (Saint-Luc-de-Bellechasse, Quebec, Canada)'),
    ('CA-SLC', 'CA-SLC (Saint-Lucien, Quebec, Canada)'),
    ('CA-SDU', 'CA-SDU (Saint-Ludger, Quebec, Canada)'),
    ('CA-SLE', 'CA-SLE (Saint-Léonard, Quebec, Canada)'),
    ('CA-YSL', 'CA-YSL (Saint-Léonard, New Brunswick, Canada)'),
    ('CA-ERO', "CA-ERO (Saint-Léonard-d'Aston, Quebec, Canada)"),
    ('CA-SMJ', 'CA-SMJ (Saint-Majorique-de-Grantham, Quebec, Canada)'),
    ('CA-SM6', 'CA-SM6 (Saint-Malo, Quebec, Canada)'),
    ('CA-SMC', 'CA-SMC (Saint-Marc-des-Carrières, Quebec, Canada)'),
    ('CA-MDG', 'CA-MDG (Saint-Marc-Du-Lac-Long, Quebec, Canada)'),
    ('CA-ARE', 'CA-ARE (Saint-Marc-sur-Richelieu, Quebec, Canada)'),
    ('CA-MRT', 'CA-MRT (Saint-Marc-sur-Richelieu, Quebec, Canada)'),
    ('CA-SMS', 'CA-SMS (Saint-Marys, Newfoundland and Labrador, Canada)'),
    ('CA-SMY', 'CA-SMY (Saint-Marys, Ontario, Canada)'),
    ('CA-SMR', 'CA-SMR (Saint-Mathias-sur-Richelieu, Quebec, Canada)'),
    ('CA-SM7', 'CA-SM7 (Saint-Mathieu, Quebec, Canada)'),
    ('CA-SMH', "CA-SMH (Saint-Mathieu-d'Harricana, Quebec, Canada)"),
    ('CA-SMD', 'CA-SMD (Saint-Mathieu-de-Beloeil, Quebec, Canada)'),
    ('CA-MHP', 'CA-MHP (Saint-Mathieu-du-Parc, Quebec, Canada)'),
    ('CA-SNM', 'CA-SNM (Saint-Michel, Quebec, Canada)'),
    ('CA-SMX', 'CA-SMX (Saint-Michel de Napierville, Quebec, Canada)'),
    ('CA-SLH', 'CA-SLH (Saint-Michel-De-Bellechasse, Quebec, Canada)'),
    ('CA-SMQ', 'CA-SMQ (Saint-Michel-des-Saints, Quebec, Canada)'),
    ('CA-SM2', 'CA-SM2 (Saint-Modeste, Quebec, Canada)'),
    ('CA-INT', 'CA-INT (Saint-Narcisse, Quebec, Canada)'),
    ('CA-SBG', 'CA-SBG (Saint-Narcisse-de-Beaurivage, Quebec, Canada)'),
    ('CA-SNZ', 'CA-SNZ (Saint-Nazaire, Quebec, Canada)'),
    ('CA-NOJ', 'CA-NOJ (Saint-Nicolas, Quebec, Canada)'),
    ('CA-NCP', 'CA-NCP (Saint-Nicéphore, Quebec, Canada)'),
    ('CA-SNB', 'CA-SNB (Saint-Norbert, Quebec, Canada)'),
    ('CA-ST5', 'CA-ST5 (Saint-Omer, Quebec, Canada)'),
    ('CA-SPC', 'CA-SPC (Saint-Pacôme, Quebec, Canada)'),
    ('CA-SPM', 'CA-SPM (Saint-Pamphile, Quebec, Canada)'),
    ('CA-SPA', 'CA-SPA (Saint-Pascal, Quebec, Canada)'),
    ('CA-PBG', 'CA-PBG (Saint-Patrice-de-Beaurivage, Quebec, Canada)'),
    ('CA-SPL', 'CA-SPL (Saint-Paul, Alberta, Canada)'),
    ('CA-ZSP', 'CA-ZSP (Saint-Paul, Quebec, Canada)'),
    ('CA-SPB', "CA-SPB (Saint-Paul-d'Abbotsford, Quebec, Canada)"),
    ('CA-SPX', "CA-SPX (Saint-Paul-de-l'Île-aux-Noix, Quebec, Canada)"),
    ('CA-SPQ', 'CA-SPQ (Saint-Paul-de-la-Croix, Quebec, Canada)'),
    ('CA-PLO', 'CA-PLO (Saint-Pauls-Station, Ontario, Canada)'),
    ('CA-SPP', 'CA-SPP (Saint-Perpetue, Quebec, Canada)'),
    ('CA-SRS', 'CA-SRS (Saint-Peters, Nova Scotia, Canada)'),
    ('CA-CIP', 'CA-CIP (Saint-Philippe, Quebec, Canada)'),
    ('CA-STI', 'CA-STI (Saint-Pie, Quebec, Canada)'),
    ('CA-SPI', 'CA-SPI (Saint-Pierre, Quebec, Canada)'),
    ('CA-SPS', "CA-SPS (Saint-Pierre-d'Orleans, Quebec, Canada)"),
    ('CA-PDO', "CA-PDO (Saint-Pierre-de-l'Île-d'Orléans, Quebec, Canada)"),
    ('CA-SPJ', 'CA-SPJ (Saint-Pierre-Jolys, Manitoba, Canada)'),
    ('CA-PBS', 'CA-PBS (Saint-Pierre-les-Becquets, Quebec, Canada)'),
    ('CA-PLI', 'CA-PLI (Saint-Placide, Quebec, Canada)'),
    ('CA-P6B', 'CA-P6B (Saint-Placide-de-Béarn, Quebec, Canada)'),
    ('CA-SPY', 'CA-SPY (Saint-Polycarpe, Quebec, Canada)'),
    ('CA-STP', 'CA-STP (Saint-Prime, Quebec, Canada)'),
    ('CA-RRR', 'CA-RRR (Saint-Prosper, Quebec, Canada)'),
    ('CA-SQE', 'CA-SQE (Saint-Quentin, New Brunswick, Canada)'),
    ('CA-SRD', 'CA-SRD (Saint-Raymond, Quebec, Canada)'),
    ('CA-SRB', 'CA-SRB (Saint-Robert-Bellarmin, Quebec, Canada)'),
    ('CA-SRH', 'CA-SRH (Saint-Roch, Quebec, Canada)'),
    ('CA-SRA', "CA-SRA (Saint-Roch-de-l'Achigan, Quebec, Canada)"),
    ('CA-SNR', "CA-SNR (Saint-Romuald-d'Etchemin, Quebec, Canada)"),
    ('CA-SRO', "CA-SRO (Saint-Romuald-d'Etchemin, Quebec, Canada)"),
    ('CA-SRP', 'CA-SRP (Saint-Rédempteur, Quebec, Canada)'),
    ('CA-SRM', 'CA-SRM (Saint-Rémi, Quebec, Canada)'),
    ('CA-SSU', 'CA-SSU (Saint-Samuel, Quebec, Canada)'),
    ('CA-SSA', 'CA-SSA (Saint-Sauveur-des-Monts, Quebec, Canada)'),
    ('CA-SST', 'CA-SST (Saint-Shotts, Newfoundland and Labrador, Canada)'),
    ('CA-SMN', 'CA-SMN (Saint-Simon, New Brunswick, Canada)'),
    ('CA-SSB', 'CA-SSB (Saint-Simon-de-Bagot, Quebec, Canada)'),
    ('CA-SSE', 'CA-SSE (Saint-Siméon, Quebec, Canada)'),
    ('CA-SBV', 'CA-SBV (Saint-Siméon-de-Bonaventure, Quebec, Canada)'),
    ('CA-SSS', 'CA-SSS (Saint-Stanislas, Quebec, Canada)'),
    ('CA-TKS', 'CA-TKS (Saint-Stanislas-de-Kostka, Quebec, Canada)'),
    ('CA-STS', 'CA-STS (Saint-Stephen, New Brunswick, Canada)'),
    ('CA-SSV', 'CA-SSV (Saint-Sylvere, Quebec, Canada)'),
    ('CA-TYV', 'CA-TYV (Saint-Sylvestre, Quebec, Canada)'),
    ('CA-SBI', 'CA-SBI (Saint-Sébastien, Quebec, Canada)'),
    ('CA-SFC', 'CA-SFC (Saint-Sébastien, Quebec, Canada)'),
    ('CA-SSL', 'CA-SSL (Saint-Sébastien/Le-Haut-Richelieu, Quebec, Canada)'),
    ('CA-SSC', 'CA-SSC (Saint-Séverin, Quebec, Canada)'),
    ('CA-QCT', 'CA-QCT (Saint-Tharcisius, Quebec, Canada)'),
    ('CA-SNE', 'CA-SNE (Saint-Theophile, Quebec, Canada)'),
    ('CA-SIT', 'CA-SIT (Saint-Thomas, Quebec, Canada)'),
    ('CA-STH', 'CA-STH (Saint-Thomas, Ontario, Canada)'),
    ('CA-SDH', 'CA-SDH (Saint-Thomas-Didyme, Quebec, Canada)'),
    ('CA-STO', 'CA-STO (Saint-Timothée, Quebec, Canada)'),
    ('CA-ZTI', 'CA-ZTI (Saint-Tite, Quebec, Canada)'),
    ('CA-SUB', 'CA-SUB (Saint-Ubald, Quebec, Canada)'),
    ('CA-SRX', 'CA-SRX (Saint-Urbain, Quebec, Canada)'),
    ('CA-SUP', 'CA-SUP (Saint-Urbain-Premier, Quebec, Canada)'),
    ('CA-SVA', 'CA-SVA (Saint-Vallier, Quebec, Canada)'),
    ('CA-SVL', 'CA-SVL (Saint-Vallier, Ontario, Canada)'),
    ('CA-SVR', 'CA-SVR (Saint-Valère, Quebec, Canada)'),
    ('CA-SVQ', 'CA-SVQ (Saint-Valérien, Quebec, Canada)'),
    ('CA-QSV', 'CA-QSV (Saint-Victor, Quebec, Canada)'),
    ('CA-SVP', 'CA-SVP (Saint-Vincent-de-Paul, Quebec, Canada)'),
    ('CA-SWC', 'CA-SWC (Saint-Wenceslas, Quebec, Canada)'),
    ('CA-SZT', 'CA-SZT (Saint-Zotique, Quebec, Canada)'),
    ('CA-SZZ', 'CA-SZZ (Saint-Zénon, Quebec, Canada)'),
    ('CA-SZC', 'CA-SZC (Saint-Zéphirin-de-Courval, Quebec, Canada)'),
    ('CA-DEF', 'CA-DEF (Saint-Édouard-de-Fabre, Quebec, Canada)'),
    ('CA-SEO', 'CA-SEO (Saint-Édouard-de-Lotbinière, Quebec, Canada)'),
    ('CA-ELC', 'CA-ELC (Saint-Élie-de-Caxton, Quebec, Canada)'),
    ('CA-SOI', 'CA-SOI (Saint-Éloi, Quebec, Canada)'),
    ('CA-QSS', 'CA-QSS (Saint-Étienne-des-Gres, Quebec, Canada)'),
    ('CA-SEF', 'CA-SEF (Saint-Évariste-de-Forsyth, Quebec, Canada)'),
    ('CA-SDE', 'CA-SDE (Sainte-Adèle, Quebec, Canada)'),
    ('CA-SAH', 'CA-SAH (Sainte-Agathe, Manitoba, Canada)'),
    ('CA-SAM', 'CA-SAM (Sainte-Agathe-des-Monts, Quebec, Canada)'),
    ('CA-AMR', 'CA-AMR (Sainte-Angele-de-Merici, Quebec, Canada)'),
    ('CA-SM8', 'CA-SM8 (Sainte-Anne, Manitoba, Canada)'),
    ('CA-STA', 'CA-STA (Sainte-Anne, New Brunswick, Canada)'),
    ('CA-SAB', 'CA-SAB (Sainte-Anne-de-Bellevue, Quebec, Canada)'),
    ('CA-ADL', 'CA-ADL (Sainte-Anne-de-la-Perade, Quebec, Canada)'),
    ('CA-ADR', 'CA-ADR (Sainte-Anne-de-la-Rochelle, Quebec, Canada)'),
    ('CA-SAS', 'CA-SAS (Sainte-Anne-des-Chênes, Manitoba, Canada)'),
    ('CA-SDM', 'CA-SDM (Sainte-Anne-des-Monts, Quebec, Canada)'),
    ('CA-ADP', 'CA-ADP (Sainte-Anne-des-Plaines, Quebec, Canada)'),
    ('CA-S8B', 'CA-S8B (Sainte-Barbe, Quebec, Canada)'),
    ('CA-SBX', 'CA-SBX (Sainte-Beatrix, Quebec, Canada)'),
    ('CA-SBS', 'CA-SBS (Sainte-Brigitte-des-Saults, Quebec, Canada)'),
    ('CA-SCT', 'CA-SCT (Sainte-Catherine, Quebec, Canada)'),
    ('CA-CJC', 'CA-CJC (Sainte-Catherine-de-la-Jacques-Cartier, Quebec, Canada)'),
    ('CA-CCM', 'CA-CCM (Sainte-Cecile-De-Milton, Quebec, Canada)'),
    ('CA-SCL', 'CA-SCL (Sainte-Claire, Quebec, Canada)'),
    ('CA-SCO', 'CA-SCO (Sainte-Clothilde, Quebec, Canada)'),
    ('CA-SCD', 'CA-SCD (Sainte-Clotilde-de-Beauce, Quebec, Canada)'),
    ('CA-CCG', 'CA-CCG (Sainte-Clotilde-de-Châteauguay, Quebec, Canada)'),
    ('CA-SCX', 'CA-SCX (Sainte-Croix, Quebec, Canada)'),
    ('CA-EDW', 'CA-EDW (Sainte-Edwidge-de-Clifton, Quebec, Canada)'),
    ('CA-SET', 'CA-SET (Sainte-Elisabeth, Quebec, Canada)'),
    ('CA-SEG', "CA-SEG (Sainte-Emelie-de-l'Energie, Quebec, Canada)"),
    ('CA-SNL', 'CA-SNL (Sainte-Eulalie, Quebec, Canada)'),
    ('CA-SFI', 'CA-SFI (Sainte-Famille, Quebec, Canada)'),
    ('CA-SFF', 'CA-SFF (Sainte-Florence, Quebec, Canada)'),
    ('CA-SFO', 'CA-SFO (Sainte-Foy, Quebec, Canada)'),
    ('CA-TEE', 'CA-TEE (Sainte-Geneviève, Quebec, Canada)'),
    ('CA-HNB', 'CA-HNB (Sainte-Hélène-de-Bagot, Quebec, Canada)'),
    ('CA-HNN', 'CA-HNN (Sainte-Hénédine, Quebec, Canada)'),
    ('CA-STJ', 'CA-STJ (Sainte-Julie, Quebec, Canada)'),
    ('CA-SJU', 'CA-SJU (Sainte-Julienne, Quebec, Canada)'),
    ('CA-SNJ', 'CA-SNJ (Sainte-Justine, Quebec, Canada)'),
    ('CA-SJN', 'CA-SJN (Sainte-Justine-de-Newton, Quebec, Canada)'),
    ('CA-SMA', 'CA-SMA (Sainte-Madeleine, Quebec, Canada)'),
    ('CA-MGT', 'CA-MGT (Sainte-Marguerite, Quebec, Canada)'),
    ('CA-SMB', 'CA-SMB (Sainte-Marie, Quebec, Canada)'),
    ('CA-SML', 'CA-SML (Sainte-Marthe-sur-le-Lac, Quebec, Canada)'),
    ('CA-STM', 'CA-STM (Sainte-Martine, Quebec, Canada)'),
    ('CA-MOC', 'CA-MOC (Sainte-Monique, Quebec, Canada)'),
    ('CA-SRE', 'CA-SRE (Sainte-Rosalie, Quebec, Canada)'),
    ('CA-RRQ', 'CA-RRQ (Sainte-Rose, Quebec, Canada)'),
    ('CA-SIS', 'CA-SIS (Sainte-Sabine, Quebec, Canada)'),
    ('CA-SSH', 'CA-SSH (Sainte-Sophie, Quebec, Canada)'),
    ('CA-STE', 'CA-STE (Sainte-Thérèse, Quebec, Canada)'),
    ('CA-SGP', 'CA-SGP (Sainte-Thérèse-de-Gaspé, Quebec, Canada)'),
    ('CA-YST', 'CA-YST (Sainte-Thérèse-Point, Manitoba, Canada)'),
    ('CA-SVE', 'CA-SVE (Sainte-Veronique, Quebec, Canada)'),
    ('CA-SVD', 'CA-SVD (Sainte-Victoire-de-Sorel, Quebec, Canada)'),
    ('CA-SVF', 'CA-SVF (Salaberry-de-Valleyfield, Quebec, Canada)'),
    ('CA-SAL', 'CA-SAL (Salford, Ontario, Canada)'),
    ('CA-YSW', 'CA-YSW (Salluit, Quebec, Canada)'),
    ('CA-SLM', 'CA-SLM (Salmo, British Columbia, Canada)'),
    ('CA-YSN', 'CA-YSN (Salmon Arm, British Columbia, Canada)'),
    ('CA-SSI', 'CA-SSI (Salt Spring Island, British Columbia, Canada)'),
    ('CA-AQP', 'CA-AQP (Sambro, Nova Scotia, Canada)'),
    ('CA-SSP', 'CA-SSP (Sandspit, British Columbia, Canada)'),
    ('CA-SYA', 'CA-SYA (Sandy Bay, Saskatchewan, Canada)'),
    ('CA-SBH', 'CA-SBH (Sandy Beach, Quebec, Canada)'),
    ('CA-ZSJ', 'CA-ZSJ (Sandy Lake, Ontario, Canada)'),
    ('CA-SF2', 'CA-SF2 (Sanford, Manitoba, Canada)'),
    ('CA-GDU', 'CA-GDU (Sangudo, Alberta, Canada)'),
    ('CA-YSK', 'CA-YSK (Sangudo, Alberta, Canada)'),
    ('CA-YSI', 'CA-YSI (Sans Souci, Ontario, Canada)'),
    ('CA-SAR', 'CA-SAR (Sardis, British Columbia, Canada)'),
    ('CA-SNI', 'CA-SNI (Sarnia, Ontario, Canada)'),
    ('CA-SSF', 'CA-SSF (Sarsfield, Ontario, Canada)'),
    ('CA-RTO', 'CA-RTO (Sarto, Manitoba, Canada)'),
    ('CA-SAK', 'CA-SAK (Saskatoon, Saskatchewan, Canada)'),
    ('CA-YXE', 'CA-YXE (Saskatoon John G. Diefenbaker Apt, Saskatchewan, Canada)'),
    ('CA-SI3', 'CA-SI3 (Saturna Island, British Columbia, Canada)'),
    ('CA-SLV', 'CA-SLV (Saulnierville, Nova Scotia, Canada)'),
    ('CA-SSM', 'CA-SSM (Sault-Sainte-Marie, Ontario, Canada)'),
    ('CA-SAV', 'CA-SAV (Savona, British Columbia, Canada)'),
    ('CA-SYV', 'CA-SYV (Sawyerville, Quebec, Canada)'),
    ('CA-SAY', 'CA-SAY (Sayabec, Quebec, Canada)'),
    ('CA-SYW', 'CA-SYW (Sayward, British Columbia, Canada)'),
    ('CA-SCB', 'CA-SCB (Scarborough, Ontario, Canada)'),
    ('CA-SZF', 'CA-SZF (Schanzenfeld, Manitoba, Canada)'),
    ('CA-YKL', 'CA-YKL (Schefferville, Quebec, Canada)'),
    ('CA-SOG', 'CA-SOG (Schomberg, Ontario, Canada)'),
    ('CA-SHB', 'CA-SHB (Schreiber, Ontario, Canada)'),
    ('CA-SHM', 'CA-SHM (Schumacher, Ontario, Canada)'),
    ('CA-SCF', 'CA-SCF (Scotford, Alberta, Canada)'),
    ('CA-SLD', 'CA-SLD (Scotland, Ontario, Canada)'),
    ('CA-SQT', 'CA-SQT (Scott, Quebec, Canada)'),
    ('CA-SCC', 'CA-SCC (Scoudouc, New Brunswick, Canada)'),
    ('CA-SDD', 'CA-SDD (Scudder, Ontario, Canada)'),
    ('CA-SEA', 'CA-SEA (Seabright, Nova Scotia, Canada)'),
    ('CA-SFH', 'CA-SFH (Seabright, Nova Scotia, Canada)'),
    ('CA-SC8', 'CA-SC8 (Seal Cove, New Brunswick, Canada)'),
    ('CA-6CA', 'CA-6CA (Searchmont, Ontario, Canada)'),
    ('CA-SBB', 'CA-SBB (Seba Beach, Alberta, Canada)'),
    ('CA-SGV', 'CA-SGV (Sebringville, Ontario, Canada)'),
    ('CA-YHS', 'CA-YHS (Sechelt, British Columbia, Canada)'),
    ('CA-SED', 'CA-SED (Sedgewick, Alberta, Canada)'),
    ('CA-SLY', 'CA-SLY (Sedley, Saskatchewan, Canada)'),
    ('CA-SEM', 'CA-SEM (Seldom, Newfoundland and Labrador, Canada)'),
    ('CA-SEL', 'CA-SEL (Selkirk, Manitoba, Canada)'),
    ('CA-SEN', 'CA-SEN (Senneterre, Quebec, Canada)'),
    ('CA-6SE', 'CA-6SE (Senneville, Quebec, Canada)'),
    ('CA-SEI', 'CA-SEI (Sept-Iles, Quebec, Canada)'),
    ('CA-SEB', 'CA-SEB (Seven Islands Bay, Newfoundland and Labrador, Canada)'),
    ('CA-SEH', 'CA-SEH (Sexsmith, Alberta, Canada)'),
    ('CA-SGH', 'CA-SGH (Shag Harbour, Nova Scotia, Canada)'),
    ('CA-HAE', 'CA-HAE (Shakespeare, Ontario, Canada)'),
    ('CA-SKP', 'CA-SKP (Shakespeare Island, Ontario, Canada)'),
    ('CA-SHT', 'CA-SHT (Shalath, British Columbia, Canada)'),
    ('CA-SHL', 'CA-SHL (Shallows Lake, Ontario, Canada)'),
    ('CA-ZTM', 'CA-ZTM (Shamattawa, Manitoba, Canada)'),
    ('CA-NON', 'CA-NON (Shannon, Quebec, Canada)'),
    ('CA-SHV', 'CA-SHV (Shannonville, Ontario, Canada)'),
    ('CA-SYB', 'CA-SYB (Shanty Bay, Ontario, Canada)'),
    ('CA-SR9', 'CA-SR9 (Sharon, Ontario, Canada)'),
    ('CA-SNV', 'CA-SNV (Shaunavon, Saskatchewan, Canada)'),
    ('CA-SHA', 'CA-SHA (Shawinigan, Quebec, Canada)'),
    ('CA-LSH', 'CA-LSH (Shawnigan Lake, British Columbia, Canada)'),
    ('CA-YAW', 'CA-YAW (Shearwater, Nova Scotia, Canada)'),
    ('CA-YSX', 'CA-YSX (Shearwater, British Columbia, Canada)'),
    ('CA-SHE', 'CA-SHE (Shediac, New Brunswick, Canada)'),
    ('CA-SHH', 'CA-SHH (Sheet Harbour, Nova Scotia, Canada)'),
    ('CA-SFM', 'CA-SFM (Sheffield Mills, Nova Scotia, Canada)'),
    ('CA-FFO', 'CA-FFO (Shefford, Quebec, Canada)'),
    ('CA-SBU', 'CA-SBU (Shelburne, Nova Scotia, Canada)'),
    ('CA-SLB', 'CA-SLB (Shelburne, Ontario, Canada)'),
    ('CA-SBK', 'CA-SBK (Shellbrook, Saskatchewan, Canada)'),
    ('CA-SMG', 'CA-SMG (Shemogue, New Brunswick, Canada)'),
    ('CA-SBE', 'CA-SBE (Sherbrooke, Nova Scotia, Canada)'),
    ('CA-SBR', 'CA-SBR (Sherbrooke, Quebec, Canada)'),
    ('CA-SHK', 'CA-SHK (Sherkston, Ontario, Canada)'),
    ('CA-SHR', 'CA-SHR (Sherrington, Quebec, Canada)'),
    ('CA-SWD', 'CA-SWD (Sherwood, Prince Edward Island, Canada)'),
    ('CA-SWP', 'CA-SWP (Sherwood Park, Alberta, Canada)'),
    ('CA-YLO', 'CA-YLO (Shilo, Manitoba, Canada)'),
    ('CA-SHP', 'CA-SHP (Shippegan, New Brunswick, Canada)'),
    ('CA-HOK', 'CA-HOK (Shoal Lake, Manitoba, Canada)'),
    ('CA-SCE', 'CA-SCE (Shubenacadie, Nova Scotia, Canada)'),
    ('CA-SUI', 'CA-SUI (Shuniah, Ontario, Canada)'),
    ('CA-SIO', 'CA-SIO (Sicamous, British Columbia, Canada)'),
    ('CA-SDY', 'CA-SDY (Sidney, British Columbia, Canada)'),
    ('CA-SYQ', 'CA-SYQ (Sillery, Quebec, Canada)'),
    ('CA-SYF', 'CA-SYF (Silva Bay, British Columbia, Canada)'),
    ('CA-SWT', 'CA-SWT (Silver Water, Ontario, Canada)'),
    ('CA-SIC', 'CA-SIC (Simcoe, Ontario, Canada)'),
    ('CA-YXL', 'CA-YXL (Sioux Lookout, Ontario, Canada)'),
    ('CA-SKD', 'CA-SKD (Skead, Ontario, Canada)'),
    ('CA-SKK', 'CA-SKK (Skiff Lake, New Brunswick, Canada)'),
    ('CA-SKU', 'CA-SKU (Skookumchuck, British Columbia, Canada)'),
    ('CA-YSS', 'CA-YSS (Slate Island, Ontario, Canada)'),
    ('CA-YZH', 'CA-YZH (Slave Lake, Alberta, Canada)'),
    ('CA-SLQ', 'CA-SLQ (Slocan, British Columbia, Canada)'),
    ('CA-YSH', 'CA-YSH (Smith Falls, Ontario, Canada)'),
    ('CA-YYD', 'CA-YYD (Smithers, British Columbia, Canada)'),
    ('CA-SMF', 'CA-SMF (Smiths Falls, Ontario, Canada)'),
    ('CA-SMV', 'CA-SMV (Smithville, Ontario, Canada)'),
    ('CA-SYK', 'CA-SYK (Smoky Lake, Alberta, Canada)'),
    ('CA-YXF', 'CA-YXF (Smoky Lake, Alberta, Canada)'),
    ('CA-YFJ', 'CA-YFJ (Smoky Lake, Alberta, Canada)'),
    ('CA-SWL', 'CA-SWL (Snow Lake, Manitoba, Canada)'),
    ('CA-SFK', 'CA-SFK (Snowflake, Manitoba, Canada)'),
    ('CA-SOM', 'CA-SOM (Sombra, Ontario, Canada)'),
    ('CA-SOO', 'CA-SOO (Sooke, British Columbia, Canada)'),
    ('CA-SOR', 'CA-SOR (Sorel, Quebec, Canada)'),
    ('CA-ST6', 'CA-ST6 (Sorel-Tracy, Quebec, Canada)'),
    ('CA-SRR', 'CA-SRR (Sorrento, British Columbia, Canada)'),
    ('CA-SOU', 'CA-SOU (Souris, Prince Edward Island, Canada)'),
    ('CA-SBF', 'CA-SBF (South Brookfield, Nova Scotia, Canada)'),
    ('CA-OUU', 'CA-OUU (South Dundas, Ontario, Canada)'),
    ('CA-SG2', 'CA-SG2 (South Glengarry, Ontario, Canada)'),
    ('CA-XSI', 'CA-XSI (South Indian Lake, Manitoba, Canada)'),
    ('CA-SM5', 'CA-SM5 (South Monaghan, Ontario, Canada)'),
    ('CA-SRT', 'CA-SRT (South River, Ontario, Canada)'),
    ('CA-SOT', 'CA-SOT (South Stormont, Ontario, Canada)'),
    ('CA-ZFL', 'CA-ZFL (South Trout Lake, Ontario, Canada)'),
    ('CA-SON', 'CA-SON (Southampton, Ontario, Canada)'),
    ('CA-SOY', 'CA-SOY (Southey, Saskatchewan, Canada)'),
    ('CA-SOH', 'CA-SOH (Southport, Manitoba, Canada)'),
    ('CA-OWD', 'CA-OWD (Southwold, Ontario, Canada)'),
    ('CA-SDG', 'CA-SDG (Spalding, Saskatchewan, Canada)'),
    ('CA-SPN', 'CA-SPN (Spaniards Bay, Newfoundland and Labrador, Canada)'),
    ('CA-SPW', 'CA-SPW (Sparwood, British Columbia, Canada)'),
    ('CA-SPV', 'CA-SPV (Spencerville, Ontario, Canada)'),
    ('CA-SCG', 'CA-SCG (Spences Bridge, British Columbia, Canada)'),
    ('CA-SRG', 'CA-SRG (Sperling, Manitoba, Canada)'),
    ('CA-SIR', 'CA-SIR (Spirit River, Alberta, Canada)'),
    ('CA-SLK', 'CA-SLK (Split Lake, Manitoba, Canada)'),
    ('CA-SPR', 'CA-SPR (Spragge, Ontario, Canada)'),
    ('CA-SPE', 'CA-SPE (Sprague, Manitoba, Canada)'),
    ('CA-SUE', 'CA-SUE (Spring Coulee, Alberta, Canada)'),
    ('CA-YSQ', 'CA-YSQ (Spring Island, British Columbia, Canada)'),
    ('CA-SGL', 'CA-SGL (Spring Lake, Alberta, Canada)'),
    ('CA-SPD', 'CA-SPD (Springdale, Newfoundland and Labrador, Canada)'),
    ('CA-SFQ', 'CA-SFQ (Springfield, Manitoba, Canada)'),
    ('CA-SPF', 'CA-SPF (Springfield, Nova Scotia, Canada)'),
    ('CA-OGN', 'CA-OGN (Springfiled, Ontario, Canada)'),
    ('CA-SPO', 'CA-SPO (Springhill, Nova Scotia, Canada)'),
    ('CA-SGS', 'CA-SGS (Springside, Saskatchewan, Canada)'),
    ('CA-SPG', 'CA-SPG (Spruce Grove, Alberta, Canada)'),
    ('CA-SQA', 'CA-SQA (Squamish, British Columbia, Canada)'),
    ('CA-YSZ', 'CA-YSZ (Squirrel Cove, British Columbia, Canada)'),
    ('CA-AWL', 'CA-AWL (St. Anns / West Lincoln, Ontario, Canada)'),
    ('CA-SBN', 'CA-SBN (St. Bernardin, Ontario, Canada)'),
    ('CA-OJH', 'CA-OJH (St. Joseph, Ontario, Canada)'),
    ('CA-SFA', 'CA-SFA (Staffa, Ontario, Canada)'),
    ('CA-SSN', 'CA-SSN (Stanbridge Station, Quebec, Canada)'),
    ('CA-SNA', 'CA-SNA (Standard, Alberta, Canada)'),
    ('CA-SNP', 'CA-SNP (Stanstead Plain, Quebec, Canada)'),
    ('CA-SRC', 'CA-SRC (Star City, Saskatchewan, Canada)'),
    ('CA-SCK', 'CA-SCK (Starbuck, Manitoba, Canada)'),
    ('CA-SVY', 'CA-SVY (Stavely, Alberta, Canada)'),
    ('CA-STY', 'CA-STY (Stayner, Ontario, Canada)'),
    ('CA-SME', 'CA-SME (Steelman, Saskatchewan, Canada)'),
    ('CA-STB', 'CA-STB (Steinbach, Manitoba, Canada)'),
    ('CA-STN', 'CA-STN (Stellarton, Nova Scotia, Canada)'),
    ('CA-SP5', 'CA-SP5 (Stephenfield, Manitoba, Canada)'),
    ('CA-STV', 'CA-STV (Stephenville, Newfoundland and Labrador, Canada)'),
    ('CA-SER', 'CA-SER (Stettler, Alberta, Canada)'),
    ('CA-SVS', 'CA-SVS (Stevensville, Ontario, Canada)'),
    ('CA-SVN', 'CA-SVN (Steveston, British Columbia, Canada)'),
    ('CA-STW', 'CA-STW (Stewart, British Columbia, Canada)'),
    ('CA-SWE', 'CA-SWE (Stewiacke, Nova Scotia, Canada)'),
    ('CA-SLG', 'CA-SLG (Stirling, Ontario, Canada)'),
    ('CA-SLL', 'CA-SLL (Stittsville, Ontario, Canada)'),
    ('CA-STK', 'CA-STK (Stockton, Manitoba, Canada)'),
    ('CA-7TK', 'CA-7TK (Stoke, Quebec, Canada)'),
    ('CA-SOA', 'CA-SOA (Stoneham, Quebec, Canada)'),
    ('CA-WLL', 'CA-WLL (Stonewall, Manitoba, Canada)'),
    ('CA-STC', 'CA-STC (Stoney Creek, Ontario, Canada)'),
    ('CA-SYI', 'CA-SYI (Stoney Island, Nova Scotia, Canada)'),
    ('CA-SYM', 'CA-SYM (Stony Mountain, Manitoba, Canada)'),
    ('CA-SYP', 'CA-SYP (Stony Plain, Alberta, Canada)'),
    ('CA-YSF', 'CA-YSF (Stony Rapids, Saskatchewan, Canada)'),
    ('CA-SMT', 'CA-SMT (Stormont, Nova Scotia, Canada)'),
    ('CA-SFV', 'CA-SFV (Stouffville, Ontario, Canada)'),
    ('CA-SFL', 'CA-SFL (Straffordville, Ontario, Canada)'),
    ('CA-SBQ', 'CA-SBQ (Strasbourg, Saskatchewan, Canada)'),
    ('CA-SRF', 'CA-SRF (Stratford, Quebec, Canada)'),
    ('CA-STF', 'CA-STF (Stratford, Prince Edward Island, Canada)'),
    ('CA-STR', 'CA-STR (Stratford, Ontario, Canada)'),
    ('CA-SCR', 'CA-SCR (Strathclair, Manitoba, Canada)'),
    ('CA-SCN', 'CA-SCN (Strathcona, Alberta, Canada)'),
    ('CA-SOE', 'CA-SOE (Strathmore, Alberta, Canada)'),
    ('CA-STT', 'CA-STT (Strathroy, Ontario, Canada)'),
    ('CA-SVI', 'CA-SVI (Streetsville, Ontario, Canada)'),
    ('CA-SFS', 'CA-SFS (Strongfield, Saskatchewan, Canada)'),
    ('CA-SIA', 'CA-SIA (Sts-Anges, Quebec, Canada)'),
    ('CA-YRR', 'CA-YRR (Stuart Island, British Columbia, Canada)'),
    ('CA-YTC', 'CA-YTC (Sturdee, British Columbia, Canada)'),
    ('CA-SGF', 'CA-SGF (Sturgeon Falls, Ontario, Canada)'),
    ('CA-SUC', 'CA-SUC (Success, Saskatchewan, Canada)'),
    ('CA-SUD', 'CA-SUD (Sudbury, Ontario, Canada)'),
    ('CA-YSD', 'CA-YSD (Suffield, Alberta, Canada)'),
    ('CA-YTG', 'CA-YTG (Sullivan Bay, British Columbia, Canada)'),
    ('CA-SUR', 'CA-SUR (Summer Beaver, Ontario, Canada)'),
    ('CA-SUZ', 'CA-SUZ (Summerland, British Columbia, Canada)'),
    ('CA-SUM', 'CA-SUM (Summerside, Prince Edward Island, Canada)'),
    ('CA-IUM', 'CA-IUM (Summit Lake, British Columbia, Canada)'),
    ('CA-SPK', 'CA-SPK (Sun Peaks, British Columbia, Canada)'),
    ('CA-SDL', 'CA-SDL (Sunderland, Ontario, Canada)'),
    ('CA-SDR', 'CA-SDR (Sundre, Alberta, Canada)'),
    ('CA-SUK', 'CA-SUK (Sunnybrook, Alberta, Canada)'),
    ('CA-SYS', 'CA-SYS (Sunnyside, Newfoundland and Labrador, Canada)'),
    ('CA-SUY', 'CA-SUY (Surrey, British Columbia, Canada)'),
    ('CA-SUS', 'CA-SUS (Sussex, New Brunswick, Canada)'),
    ('CA-SXE', 'CA-SXE (Sussex Corner, New Brunswick, Canada)'),
    ('CA-SUT', 'CA-SUT (Sutton, Quebec, Canada)'),
    ('CA-UTT', 'CA-UTT (Sutton, Ontario, Canada)'),
    ('CA-SWH', 'CA-SWH (Swan Hills, Alberta, Canada)'),
    ('CA-ZJN', 'CA-ZJN (Swan River, Manitoba, Canada)'),
    ('CA-SWA', 'CA-SWA (Swastika, Ontario, Canada)'),
    ('CA-YYN', 'CA-YYN (Swift Current, Saskatchewan, Canada)'),
    ('CA-SYD', 'CA-SYD (Sydney, Nova Scotia, Canada)'),
    ('CA-SMI', 'CA-SMI (Sydney Mines, Nova Scotia, Canada)'),
    ('CA-SRV', 'CA-SRV (Sydney River, Nova Scotia, Canada)'),
    ('CA-SYL', 'CA-SYL (Sylvan Lake, Alberta, Canada)'),
    ('CA-TBR', 'CA-TBR (Taber, Alberta, Canada)'),
    ('CA-TAB', 'CA-TAB (Tabusintac, New Brunswick, Canada)'),
    ('CA-XTL', 'CA-XTL (Tadoule Lake, Manitoba, Canada)'),
    ('CA-TAD', 'CA-TAD (Tadoussac, Quebec, Canada)'),
    ('CA-TAH', 'CA-TAH (Tadoussac, Quebec, Canada)'),
    ('CA-PTA', 'CA-PTA (Tahsis, British Columbia, Canada)'),
    ('CA-TAL', 'CA-TAL (Talbotville, Ontario, Canada)'),
    ('CA-TBA', 'CA-TBA (Talbotville Royal, Ontario, Canada)'),
    ('CA-YYH', 'CA-YYH (Talbotville Royal, Ontario, Canada)'),
    ('CA-GSL', 'CA-GSL (Talbotville Royal, Ontario, Canada)'),
    ('CA-TTA', 'CA-TTA (Tantallon, Nova Scotia, Canada)'),
    ('CA-TIS', 'CA-TIS (Tar Island, Alberta, Canada)'),
    ('CA-TAR', 'CA-TAR (Tara, Ontario, Canada)'),
    ('CA-TCH', 'CA-TCH (Taschereau, Quebec, Canada)'),
    ('CA-YTQ', 'CA-YTQ (Tasiujaq, Quebec, Canada)'),
    ('CA-TAS', 'CA-TAS (Tasu, British Columbia, Canada)'),
    ('CA-TGU', 'CA-TGU (Tatamagouche, Nova Scotia, Canada)'),
    ('CA-TAV', 'CA-TAV (Tavistock, Ontario, Canada)'),
    ('CA-TLO', 'CA-TLO (Taylor, British Columbia, Canada)'),
    ('CA-TEC', 'CA-TEC (Tecumseh, Ontario, Canada)'),
    ('CA-TES', 'CA-TES (Tees, Alberta, Canada)'),
    ('CA-YTX', 'CA-YTX (Telegraph Creek, British Columbia, Canada)'),
    ('CA-YBQ', 'CA-YBQ (Telegraph Harbour, British Columbia, Canada)'),
    ('CA-TWA', 'CA-TWA (Telkwa, British Columbia, Canada)'),
    ('CA-TGI', 'CA-TGI (Temagami, Ontario, Canada)'),
    ('CA-TCG', 'CA-TCG (Temiscaming, Quebec, Canada)'),
    ('CA-TER', 'CA-TER (Terra Nova, Newfoundland and Labrador, Canada)'),
    ('CA-YXT', 'CA-YXT (Terrace, British Columbia, Canada)'),
    ('CA-YTJ', 'CA-YTJ (Terrace Bay, Ontario, Canada)'),
    ('CA-TBN', 'CA-TBN (Terrebonne, Quebec, Canada)'),
    ('CA-YZW', 'CA-YZW (Terrebonne, Quebec, Canada)'),
    ('CA-TEU', 'CA-TEU (Teulon, Manitoba, Canada)'),
    ('CA-TEX', 'CA-TEX (Texada Island, British Columbia, Canada)'),
    ('CA-THA', 'CA-THA (Thamesford, Ontario, Canada)'),
    ('CA-OTE', 'CA-OTE (Thamesville, Ontario, Canada)'),
    ('CA-TWN', 'CA-TWN (Thawwassen, British Columbia, Canada)'),
    ('CA-YQD', 'CA-YQD (The Pas, Manitoba, Canada)'),
    ('CA-THF', 'CA-THF (Thedford, Ontario, Canada)'),
    ('CA-THS', 'CA-THS (Thessalon, Ontario, Canada)'),
    ('CA-THE', 'CA-THE (Thetford Mines, Quebec, Canada)'),
    ('CA-TTL', 'CA-TTL (Thetis Island, British Columbia, Canada)'),
    ('CA-YTD', 'CA-YTD (Thicket Portage, Manitoba, Canada)'),
    ('CA-YTH', 'CA-YTH (Thompson, Manitoba, Canada)'),
    ('CA-TBU', 'CA-TBU (Thorburn, Nova Scotia, Canada)'),
    ('CA-TRH', 'CA-TRH (Thorhild, Alberta, Canada)'),
    ('CA-TBY', 'CA-TBY (Thornbury, Ontario, Canada)'),
    ('CA-TND', 'CA-TND (Thorndale, Ontario, Canada)'),
    ('CA-THL', 'CA-THL (Thornhill, Ontario, Canada)'),
    ('CA-THN', 'CA-THN (Thornton, Ontario, Canada)'),
    ('CA-THD', 'CA-THD (Thorold, Ontario, Canada)'),
    ('CA-THY', 'CA-THY (Thorsby, Alberta, Canada)'),
    ('CA-THH', 'CA-THH (Three Hills, Alberta, Canada)'),
    ('CA-THU', 'CA-THU (Thunder Bay, Ontario, Canada)'),
    ('CA-URS', 'CA-URS (Thurso, Quebec, Canada)'),
    ('CA-TGY', 'CA-TGY (Tigerlily, Alberta, Canada)'),
    ('CA-TIG', 'CA-TIG (Tignish, Prince Edward Island, Canada)'),
    ('CA-TIY', 'CA-TIY (Tilbury, Ontario, Canada)'),
    ('CA-TLB', 'CA-TLB (Tilbury Is, British Columbia, Canada)'),
    ('CA-TLY', 'CA-TLY (Tilley, Alberta, Canada)'),
    ('CA-TBG', 'CA-TBG (Tillsonburg, Ontario, Canada)'),
    ('CA-TCV', 'CA-TCV (Tilt Cove, Newfoundland and Labrador, Canada)'),
    ('CA-TBL', 'CA-TBL (Timberlea, Nova Scotia, Canada)'),
    ('CA-YTS', 'CA-YTS (Timmins, Ontario, Canada)'),
    ('CA-TNG', 'CA-TNG (Tingwick, Quebec, Canada)'),
    ('CA-TNY', 'CA-TNY (Tiny, Ontario, Canada)'),
    ('CA-YTT', 'CA-YTT (Tisdale, Saskatchewan, Canada)'),
    ('CA-TIV', 'CA-TIV (Tiverton, Nova Scotia, Canada)'),
    ('CA-TVT', 'CA-TVT (Tiverton, Ontario, Canada)'),
    ('CA-TFI', 'CA-TFI (Tofield, Alberta, Canada)'),
    ('CA-YAZ', 'CA-YAZ (Tofino, British Columbia, Canada)'),
    ('CA-TTI', 'CA-TTI (Tolstoi, Manitoba, Canada)'),
    ('CA-TMK', 'CA-TMK (Tompkins, Saskatchewan, Canada)'),
    ('CA-TAY', 'CA-TAY (Torbay, Newfoundland and Labrador, Canada)'),
    ('CA-TOR', 'CA-TOR (Toronto, Ontario, Canada)'),
    ('CA-TOT', 'CA-TOT (Tottenham, Ontario, Canada)'),
    ('CA-TMR', 'CA-TMR (Town Mount Royal, Quebec, Canada)'),
    ('CA-TRA', 'CA-TRA (Tracadie, New Brunswick, Canada)'),
    ('CA-TDS', 'CA-TDS (Tracadie-Sheila, Nova Scotia, Canada)'),
    ('CA-TRC', 'CA-TRC (Tracy, Quebec, Canada)'),
    ('CA-TRL', 'CA-TRL (Trail, British Columbia, Canada)'),
    ('CA-TEH', 'CA-TEH (Treherne, Manitoba, Canada)'),
    ('CA-TRN', 'CA-TRN (Trenton, Nova Scotia, Canada)'),
    ('CA-TTC', 'CA-TTC (Trenton, Ontario, Canada)'),
    ('CA-TPS', 'CA-TPS (Trepassey, Newfoundland and Labrador, Canada)'),
    ('CA-TJN', 'CA-TJN (Tring Jonction, Quebec, Canada)'),
    ('CA-TRB', 'CA-TRB (Trinity Bay, Newfoundland and Labrador, Canada)'),
    ('CA-YTI', 'CA-YTI (Triple Island, British Columbia, Canada)'),
    ('CA-TRI', 'CA-TRI (Triton, Newfoundland and Labrador, Canada)'),
    ('CA-TRO', 'CA-TRO (Trochu, Alberta, Canada)'),
    ('CA-TRP', 'CA-TRP (Trois-Pistoles, Quebec, Canada)'),
    ('CA-TRR', 'CA-TRR (Trois-Rivieres (Three Rivers), Quebec, Canada)'),
    ('CA-TTR', 'CA-TTR (Trout River, Newfoundland and Labrador, Canada)'),
    ('CA-TRY', 'CA-TRY (Troy, Ontario, Canada)'),
    ('CA-TRU', 'CA-TRU (Truro, Nova Scotia, Canada)'),
    ('CA-THG', 'CA-THG (Truro Heights, Nova Scotia, Canada)'),
    ('CA-SSO', 'CA-SSO (Trécesson, Quebec, Canada)'),
    ('CA-TWS', 'CA-TWS (Tsawwassen, British Columbia, Canada)'),
    ('CA-TUC', 'CA-TUC (Tucks, British Columbia, Canada)'),
    ('CA-TUK', 'CA-TUK (Tucks, British Columbia, Canada)'),
    ('CA-ZFN', 'CA-ZFN (Tucks, British Columbia, Canada)'),
    ('CA-YTK', 'CA-YTK (Tulugak, Quebec, Canada)'),
    ('CA-TUX', 'CA-TUX (Tumbler Ridge, British Columbia, Canada)'),
    ('CA-TNS', 'CA-TNS (Tumbler Ridge, British Columbia, Canada)'),
    ('CA-TPY', 'CA-TPY (Tupperville, Ontario, Canada)'),
    ('CA-TR8', 'CA-TR8 (Turin, Alberta, Canada)'),
    ('CA-TNV', 'CA-TNV (Turner Valley, Alberta, Canada)'),
    ('CA-TUS', 'CA-TUS (Tusket, Nova Scotia, Canada)'),
    ('CA-TWE', 'CA-TWE (Tweed, Ontario, Canada)'),
    ('CA-TWI', 'CA-TWI (Twillingate, Newfoundland and Labrador, Canada)'),
    ('CA-THI', 'CA-THI (Two Hills, Alberta, Canada)'),
    ('CA-TMC', 'CA-TMC (Témiscouata-sur-le-Lac, Quebec, Canada)'),
    ('CA-ZTB', 'CA-ZTB (Tête-à-la-Baleine, Quebec, Canada)'),
    ('CA-UCL', 'CA-UCL (Tête-à-la-Baleine, Quebec, Canada)'),
    ('CA-ORU', 'CA-ORU (Udora, Ontario, Canada)'),
    ('CA-UNV', 'CA-UNV (Unionville, Ontario, Canada)'),
    ('CA-UTY', 'CA-UTY (Unity, Saskatchewan, Canada)'),
    ('CA-PPE', 'CA-PPE (Upper Coverdale, New Brunswick, Canada)'),
    ('CA-UPO', 'CA-UPO (Upper Musquodoboit, Nova Scotia, Canada)'),
    ('CA-UPN', 'CA-UPN (Upper Northfield, Nova Scotia, Canada)'),
    ('CA-UTN', 'CA-UTN (Upper Tantallon, Nova Scotia, Canada)'),
    ('CA-UPT', 'CA-UPT (Upton, Quebec, Canada)'),
    ('CA-YBE', 'CA-YBE (Uranium City, Saskatchewan, Canada)'),
    ('CA-UTP', 'CA-UTP (Utopia, Ontario, Canada)'),
    ('CA-UTS', 'CA-UTS (Utterson, Ontario, Canada)'),
    ('CA-UXB', 'CA-UXB (Uxbridge, Ontario, Canada)'),
    ('CA-VAM', 'CA-VAM (Val Morin, Quebec, Canada)'),
    ('CA-VAA', 'CA-VAA (Val-Alain, Quebec, Canada)'),
    ('CA-VBR', 'CA-VBR (Val-Bélair, Quebec, Canada)'),
    ('CA-YVO', "CA-YVO (Val-d'Or, Quebec, Canada)"),
    ('CA-VAD', 'CA-VAD (Val-David, Quebec, Canada)'),
    ('CA-MDV', 'CA-MDV (Val-des-Monts, Quebec, Canada)'),
    ('CA-VOM', 'CA-VOM (Val-Morin, Quebec, Canada)'),
    ('CA-YOY', 'CA-YOY (Valcartier, Quebec, Canada)'),
    ('CA-VCT', 'CA-VCT (Valcourt, Quebec, Canada)'),
    ('CA-VLF', 'CA-VLF (Valleyfield, Quebec, Canada)'),
    ('CA-VYD', 'CA-VYD (Valleyfield, Newfoundland and Labrador, Canada)'),
    ('CA-VYV', 'CA-VYV (Valleyview, Alberta, Canada)'),
    ('CA-VAL', 'CA-VAL (Vallée-Jonction, Quebec, Canada)'),
    ('CA-VND', 'CA-VND (Vananda, British Columbia, Canada)'),
    ('CA-VAN', 'CA-VAN (Vancouver, British Columbia, Canada)'),
    ('CA-YVR', 'CA-YVR (Vancouver Apt, British Columbia, Canada)'),
    ('CA-CXH', 'CA-CXH (Vancouver Harbour Water Apt/Vancouver, British Columbia, Canada)'),
    ('CA-VHO', 'CA-VHO (Vanderhoof, British Columbia, Canada)'),
    ('CA-VAE', 'CA-VAE (Vanier, Quebec, Canada)'),
    ('CA-VNR', 'CA-VNR (Vanier, Ontario, Canada)'),
    ('CA-VKH', 'CA-VKH (Vankleek Hill, Ontario, Canada)'),
    ('CA-VSC', 'CA-VSC (Vanscoy, Saskatchewan, Canada)'),
    ('CA-VAR', 'CA-VAR (Varennes, Quebec, Canada)'),
    ('CA-VRS', 'CA-VRS (Vars, Ontario, Canada)'),
    ('CA-VSR', 'CA-VSR (Vassar, Manitoba, Canada)'),
    ('CA-DON', 'CA-DON (Vaudreuil-Dorion, Quebec, Canada)'),
    ('CA-VGN', 'CA-VGN (Vaughan, Ontario, Canada)'),
    ('CA-VXL', 'CA-VXL (Vauxhall, Alberta, Canada)'),
    ('CA-VEG', 'CA-VEG (Vegreville, Alberta, Canada)'),
    ('CA-VCH', 'CA-VCH (Verchères, Quebec, Canada)'),
    ('CA-DUN', 'CA-DUN (Verdun, Quebec, Canada)'),
    ('CA-ERE', 'CA-ERE (Veregin, Saskatchewan, Canada)'),
    ('CA-YVG', 'CA-YVG (Vermilion, Alberta, Canada)'),
    ('CA-VER', 'CA-VER (Vernon, British Columbia, Canada)'),
    ('CA-VEB', 'CA-VEB (Vernon Bridge, Prince Edward Island, Canada)'),
    ('CA-VRA', 'CA-VRA (Veteran, Alberta, Canada)'),
    ('CA-VBA', 'CA-VBA (Vibank, Saskatchewan, Canada)'),
    ('CA-VIC', 'CA-VIC (Victoria, British Columbia, Canada)'),
    ('CA-ICV', 'CA-ICV (Victoria Beach, Manitoba, Canada)'),
    ('CA-VIH', 'CA-VIH (Victoria Harbour, Ontario, Canada)'),
    ('CA-VVL', 'CA-VVL (Victoriaville, Quebec, Canada)'),
    ('CA-VIE', 'CA-VIE (Vienna, Ontario, Canada)'),
    ('CA-VIK', 'CA-VIK (Viking, Alberta, Canada)'),
    ('CA-VIJ', 'CA-VIJ (Ville-Marie, Quebec, Canada)'),
    ('CA-VLR', 'CA-VLR (Villeroy, Quebec, Canada)'),
    ('CA-VMT', 'CA-VMT (Vimont, Quebec, Canada)'),
    ('CA-VIN', 'CA-VIN (Vineland Station, Ontario, Canada)'),
    ('CA-VRD', 'CA-VRD (Virden, Manitoba, Canada)'),
    ('CA-VRG', 'CA-VRG (Virgil, Ontario, Canada)'),
    ('CA-VTA', 'CA-VTA (Vita, Manitoba, Canada)'),
    ('CA-VOB', "CA-VOB (Voisey's Bay, Newfoundland and Labrador, Canada)"),
    ('CA-VON', 'CA-VON (Vonda, Saskatchewan, Canada)'),
    ('CA-VCA', 'CA-VCA (Vulcan, Alberta, Canada)'),
    ('CA-YWK', 'CA-YWK (Wabush, Newfoundland and Labrador, Canada)'),
    ('CA-WFZ', 'CA-WFZ (Wainfleet, Ontario, Canada)'),
    ('CA-WWI', 'CA-WWI (Wainwright, Alberta, Canada)'),
    ('CA-WAK', 'CA-WAK (Wakefield, Quebec, Canada)'),
    ('CA-WLH', 'CA-WLH (Waldheim, Saskatchewan, Canada)'),
    ('CA-WOT', 'CA-WOT (Walkerton, Ontario, Canada)'),
    ('CA-WAV', 'CA-WAV (Walkerville, Ontario, Canada)'),
    ('CA-WAL', 'CA-WAL (Wallaceburg, Ontario, Canada)'),
    ('CA-WLS', 'CA-WLS (Wallenstein, Ontario, Canada)'),
    ('CA-WSG', 'CA-WSG (Walsingham, Ontario, Canada)'),
    ('CA-WLN', 'CA-WLN (Walton, Ontario, Canada)'),
    ('CA-WTN', 'CA-WTN (Walton, Nova Scotia, Canada)'),
    ('CA-WNH', 'CA-WNH (Wanham, Alberta, Canada)'),
    ('CA-WBG', 'CA-WBG (Warburg, Alberta, Canada)'),
    ('CA-WDI', 'CA-WDI (Wardsville, Ontario, Canada)'),
    ('CA-WMA', 'CA-WMA (Warman, Saskatchewan, Canada)'),
    ('CA-WNR', 'CA-WNR (Warner, Alberta, Canada)'),
    ('CA-WRN', 'CA-WRN (Warren, Ontario, Canada)'),
    ('CA-WRR', 'CA-WRR (Warren, Manitoba, Canada)'),
    ('CA-WWK', 'CA-WWK (Warwick, Quebec, Canada)'),
    ('CA-WAB', 'CA-WAB (Wasaga Beach, Ontario, Canada)'),
    ('CA-WSA', 'CA-WSA (Waseca, Saskatchewan, Canada)'),
    ('CA-YKQ', 'CA-YKQ (Waskaganish, Quebec, Canada)'),
    ('CA-WAS', 'CA-WAS (Waskatenau, Alberta, Canada)'),
    ('CA-WTR', 'CA-WTR (Waterdown, Ontario, Canada)'),
    ('CA-WFF', 'CA-WFF (Waterford, Ontario, Canada)'),
    ('CA-WAO', 'CA-WAO (Waterloo, Quebec, Canada)'),
    ('CA-WTL', 'CA-WTL (Waterloo, Ontario, Canada)'),
    ('CA-WVE', 'CA-WVE (Waterville, Nova Scotia, Canada)'),
    ('CA-WVL', 'CA-WVL (Waterville, Quebec, Canada)'),
    ('CA-WTF', 'CA-WTF (Watford, Ontario, Canada)'),
    ('CA-WTS', 'CA-WTS (Watrous, Saskatchewan, Canada)'),
    ('CA-ASW', 'CA-ASW (Watson, Saskatchewan, Canada)'),
    ('CA-WAI', 'CA-WAI (Watson Is, British Columbia, Canada)'),
    ('CA-WAN', 'CA-WAN (Watson Island, British Columbia, Canada)'),
    ('CA-WAT', 'CA-WAT (Watson Island, British Columbia, Canada)'),
    ('CA-YQH', 'CA-YQH (Watson Island, British Columbia, Canada)'),
    ('CA-WVY', 'CA-WVY (Waverley, Nova Scotia, Canada)'),
    ('CA-YXZ', 'CA-YXZ (Wawa, Ontario, Canada)'),
    ('CA-WAW', 'CA-WAW (Wawanesa, Manitoba, Canada)'),
    ('CA-WWA', 'CA-WWA (Wawota, Saskatchewan, Canada)'),
    ('CA-YWP', 'CA-YWP (Webequie, Ontario, Canada)'),
    ('CA-WED', 'CA-WED (Wedgeport, Nova Scotia, Canada)'),
    ('CA-WDO', 'CA-WDO (Weedon, Quebec, Canada)'),
    ('CA-WEL', 'CA-WEL (Welland, Ontario, Canada)'),
    ('CA-WLY', 'CA-WLY (Wellesley, Ontario, Canada)'),
    ('CA-EIW', 'CA-EIW (Wellington, Prince Edward Island, Canada)'),
    ('CA-WEN', 'CA-WEN (Wellington, Ontario, Canada)'),
    ('CA-WEP', 'CA-WEP (Welshpool, New Brunswick, Canada)'),
    ('CA-WMB', 'CA-WMB (Wembley, Alberta, Canada)'),
    ('CA-YNC', 'CA-YNC (Wemindji, Quebec, Canada)'),
    ('CA-WDK', 'CA-WDK (Wendake, Quebec, Canada)'),
    ('CA-W2N', 'CA-W2N (Wendover, Ontario, Canada)'),
    ('CA-WWT', 'CA-WWT (Wentworth, Nova Scotia, Canada)'),
    ('CA-WYV', 'CA-WYV (Wesleyville, Newfoundland and Labrador, Canada)'),
    ('CA-WCH', 'CA-WCH (West Chezzetcook, Nova Scotia, Canada)'),
    ('CA-WHL', 'CA-WHL (West Hill, Ontario, Canada)'),
    ('CA-BCW', 'CA-BCW (West Kelowna, British Columbia, Canada)'),
    ('CA-WLO', 'CA-WLO (West Lorne, Ontario, Canada)'),
    ('CA-WMR', 'CA-WMR (West Montrose, Ontario, Canada)'),
    ('CA-WPU', 'CA-WPU (West Pubnico, Nova Scotia, Canada)'),
    ('CA-ESP', 'CA-ESP (West Saint Paul, Manitoba, Canada)'),
    ('CA-WVR', 'CA-WVR (West Vancouver, British Columbia, Canada)'),
    ('CA-WBK', 'CA-WBK (Westbank, British Columbia, Canada)'),
    ('CA-WSO', 'CA-WSO (Westerose, Alberta, Canada)'),
    ('CA-WEK', 'CA-WEK (Westlock, Alberta, Canada)'),
    ('CA-WNT', 'CA-WNT (Westmount, Quebec, Canada)'),
    ('CA-WES', 'CA-WES (Weston, Ontario, Canada)'),
    ('CA-WTO', 'CA-WTO (Westport, Ontario, Canada)'),
    ('CA-WEV', 'CA-WEV (Westville, Nova Scotia, Canada)'),
    ('CA-WSW', 'CA-WSW (Westwold, British Columbia, Canada)'),
    ('CA-WET', 'CA-WET (Wetaskiwin, Alberta, Canada)'),
    ('CA-WWB', 'CA-WWB (Weyburn, Saskatchewan, Canada)'),
    ('CA-WEY', 'CA-WEY (Weymouth, Nova Scotia, Canada)'),
    ('CA-YLE', 'CA-YLE (Weymouth, Nova Scotia, Canada)'),
    ('CA-YXN', 'CA-YXN (Weymouth, Nova Scotia, Canada)'),
    ('CA-WHE', 'CA-WHE (Wheatley, Ontario, Canada)'),
    ('CA-WHH', 'CA-WHH (Whiffen Head, Newfoundland and Labrador, Canada)'),
    ('CA-YWS', 'CA-YWS (Whistler, British Columbia, Canada)'),
    ('CA-WTB', 'CA-WTB (Whitbourne, Newfoundland and Labrador, Canada)'),
    ('CA-WHI', 'CA-WHI (Whitby, Ontario, Canada)'),
    ('CA-WCY', 'CA-WCY (White City, Saskatchewan, Canada)'),
    ('CA-YWR', 'CA-YWR (White River, Ontario, Canada)'),
    ('CA-WHR', 'CA-WHR (White Rock, British Columbia, Canada)'),
    ('CA-WRF', 'CA-WRF (White Rock, British Columbia, Canada)'),
    ('CA-WTC', 'CA-WTC (Whitecourt, Alberta, Canada)'),
    ('CA-WHF', 'CA-WHF (Whitefish, Ontario, Canada)'),
    ('CA-YXY', 'CA-YXY (Whitefish, Ontario, Canada)'),
    ('CA-WMH', 'CA-WMH (Whitemouth, Manitoba, Canada)'),
    ('CA-WLK', 'CA-WLK (Whites Lake, Nova Scotia, Canada)'),
    ('CA-WTW', 'CA-WTW (Whitewood, Saskatchewan, Canada)'),
    ('CA-WTY', 'CA-WTY (Whitney, New Brunswick, Canada)'),
    ('CA-YVV', 'CA-YVV (Wiarton, Ontario, Canada)'),
    ('CA-WIC', 'CA-WIC (Wickham West, Quebec, Canada)'),
    ('CA-WCM', 'CA-WCM (Wicomico, Manitoba, Canada)'),
    ('CA-WIX', 'CA-WIX (Wilcox, Saskatchewan, Canada)'),
    ('CA-WWO', 'CA-WWO (Wildwood, Alberta, Canada)'),
    ('CA-LLV', 'CA-LLV (Wileville, Nova Scotia, Canada)'),
    ('CA-WKP', 'CA-WKP (Wilkesport, Ontario, Canada)'),
    ('CA-YWM', 'CA-YWM (Williams Harbour, Newfoundland and Labrador, Canada)'),
    ('CA-YWL', 'CA-YWL (Williams Lake, British Columbia, Canada)'),
    ('CA-WGO', 'CA-WGO (Williamsburg, Ontario, Canada)'),
    ('CA-WLF', 'CA-WLF (Williamsford, Ontario, Canada)'),
    ('CA-WST', 'CA-WST (Williamstown, Ontario, Canada)'),
    ('CA-LOL', 'CA-LOL (Williamswood, Nova Scotia, Canada)'),
    ('CA-WIL', 'CA-WIL (Willowdale, Ontario, Canada)'),
    ('CA-WBO', 'CA-WBO (Wimborne, Alberta, Canada)'),
    ('CA-WIH', 'CA-WIH (Winchester, Ontario, Canada)'),
    ('CA-BHC', 'CA-BHC (Windermere, British Columbia, Canada)'),
    ('CA-WRM', 'CA-WRM (Windermere, Ontario, Canada)'),
    ('CA-WHC', 'CA-WHC (Windham Centre, Ontario, Canada)'),
    ('CA-WDR', 'CA-WDR (Windsor, Nova Scotia, Canada)'),
    ('CA-WND', 'CA-WND (Windsor, Ontario, Canada)'),
    ('CA-WSR', 'CA-WSR (Windsor, Quebec, Canada)'),
    ('CA-WFD', 'CA-WFD (Winfield, British Columbia, Canada)'),
    ('CA-WNF', 'CA-WNF (Winfield, Alberta, Canada)'),
    ('CA-WIG', 'CA-WIG (Wingham, Ontario, Canada)'),
    ('CA-YWN', 'CA-YWN (Winisk, Ontario, Canada)'),
    ('CA-WNK', 'CA-WNK (Winkler, Manitoba, Canada)'),
    ('CA-WNP', 'CA-WNP (Winnipeg, Manitoba, Canada)'),
    ('CA-YWG', 'CA-YWG (Winnipeg Apt, Manitoba, Canada)'),
    ('CA-WIN', 'CA-WIN (Winona, Ontario, Canada)'),
    ('CA-WSL', 'CA-WSL (Winsloe, Prince Edward Island, Canada)'),
    ('CA-WBN', 'CA-WBN (Winterburn, Alberta, Canada)'),
    ('CA-WB8', 'CA-WB8 (Witless Bay, Newfoundland and Labrador, Canada)'),
    ('CA-WFI', 'CA-WFI (Wolfe Island, Ontario, Canada)'),
    ('CA-WOV', 'CA-WOV (Wolfville, Nova Scotia, Canada)'),
    ('CA-ZWL', 'CA-ZWL (Wollaston Lake, Saskatchewan, Canada)'),
    ('CA-WSY', 'CA-WSY (Wolseley, Saskatchewan, Canada)'),
    ('CA-WOI', 'CA-WOI (Wood Island, Prince Edward Island, Canada)'),
    ('CA-WOP', 'CA-WOP (Wood Islands, Prince Edward Island, Canada)'),
    ('CA-WDB', 'CA-WDB (Woodbridge, Ontario, Canada)'),
    ('CA-WOO', 'CA-WOO (Woodfibre, British Columbia, Canada)'),
    ('CA-WDA', 'CA-WDA (Woodham, Ontario, Canada)'),
    ('CA-WDL', 'CA-WDL (Woodlands, Manitoba, Canada)'),
    ('CA-OOW', 'CA-OOW (Woodside, New Brunswick, Canada)'),
    ('CA-WDS', 'CA-WDS (Woodstock, New Brunswick, Canada)'),
    ('CA-WSK', 'CA-WSK (Woodstock, Ontario, Canada)'),
    ('CA-WRG', 'CA-WRG (Worthington, Ontario, Canada)'),
    ('CA-WTM', 'CA-WTM (Wrentham, Alberta, Canada)'),
    ('CA-YWY', 'CA-YWY (Wrentham, Alberta, Canada)'),
    ('CA-WNN', 'CA-WNN (Wunnummin Lake, Ontario, Canada)'),
    ('CA-WYN', 'CA-WYN (Wynyard, Saskatchewan, Canada)'),
    ('CA-WYO', 'CA-WYO (Wyoming, Ontario, Canada)'),
    ('CA-ZYE', 'CA-ZYE (Yamachiche, Quebec, Canada)'),
    ('CA-YRH', 'CA-YRH (Yarmouth, Nova Scotia, Canada)'),
    ('CA-YRW', 'CA-YRW (Yarrow, British Columbia, Canada)'),
    ('CA-YZF', 'CA-YZF (Yarrow, British Columbia, Canada)'),
    ('CA-YOK', 'CA-YOK (York, Prince Edward Island, Canada)'),
    ('CA-YRK', 'CA-YRK (York, Ontario, Canada)'),
    ('CA-ZAC', 'CA-ZAC (York Landing, Manitoba, Canada)'),
    ('CA-YQV', 'CA-YQV (Yorkton, Saskatchewan, Canada)'),
    ('CA-ZEB', 'CA-ZEB (Zeballos, British Columbia, Canada)'),
    ('CA-ZNR', 'CA-ZNR (Zehner, Saskatchewan, Canada)'),
    ('CA-ZPK', 'CA-ZPK (Zenon Park, Saskatchewan, Canada)'),
    ('CA-ZPY', 'CA-ZPY (Zephyr, Ontario, Canada)'),
    ('CA-ZUR', 'CA-ZUR (Zurich, Ontario, Canada)'),
    ('CA-IGT', 'CA-IGT (Île-du-Grand-Calumet, Quebec, Canada)'),
    ('CC-CCK', 'CC-CCK (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-ANG', 'CD-ANG (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-ARU', 'CD-ARU (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BNW', 'CD-BNW (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-FDU', 'CD-FDU (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BSU', 'CD-BSU (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BAN', 'CD-BAN (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BNC', 'CD-BNC (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BNB', 'CD-BNB (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BOA', 'CD-BOA (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BKY', 'CD-BKY (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BMB', 'CD-BMB (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BUX', 'CD-BUX (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BZU', 'CD-BZU (Cocos Islands, Cocos (Keeling) Islands)'),
    ('CD-BUT', 'CD-BUT (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-DIC', 'CD-DIC (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-GDJ', 'CD-GDJ (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-BDT', 'CD-BDT (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-GMA', 'CD-GMA (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-GOM', 'CD-GOM (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-IDF', 'CD-IDF (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-IKL', 'CD-IKL (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-PFR', 'CD-PFR (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-INO', 'CD-INO (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-IRP', 'CD-IRP (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KBO', 'CD-KBO (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KBN', 'CD-KBN (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-FMI', 'CD-FMI (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KLY', 'CD-KLY (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KMN', 'CD-KMN (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KGA', 'CD-KGA (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KNM', 'CD-KNM (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KAP', 'CD-KAP (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KEC', 'CD-KEC (Butembo, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KSI', 'CD-KSI (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KGN', 'CD-KGN (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KAS', 'CD-KAS (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KKW', 'CD-KKW (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KIL', 'CD-KIL (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KND', 'CD-KND (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-FIH', 'CD-FIH (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KPU', 'CD-KPU (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KRZ', 'CD-KRZ (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-FKI', 'CD-FKI (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KWZ', 'CD-KWZ (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KOO', 'CD-KOO (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-KLI', 'CD-KLI (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LIE', 'CD-LIE (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LKS', 'CD-LKS (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LIQ', 'CD-LIQ (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LJA', 'CD-LJA (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-FBM', 'CD-FBM (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LZA', 'CD-LZA (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LZI', 'CD-LZI (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LBO', 'CD-LBO (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-LUS', 'CD-LUS (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MGH', 'CD-MGH (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MKL', 'CD-MKL (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MNO', 'CD-MNO (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MSM', 'CD-MSM (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MAT', 'CD-MAT (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MDK', 'CD-MDK (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MJM', 'CD-MJM (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MNB', 'CD-MNB (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-BDV', 'CD-BDV (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MHB', 'CD-MHB (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MWG', 'CD-MWG (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-MEW', 'CD-MEW (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-NLO', 'CD-NLO (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-NIO', 'CD-NIO (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-NKL', 'CD-NKL (Kasindi, Nord-Kivu, Congo, the Democratic Republic of the)'),
    ('CD-RR3', 'CD-RR3 (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-PUN', 'CD-PUN (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-PWO', 'CD-PWO (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-SKA', 'CD-SKA (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-TNK', 'CD-TNK (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-TSH', 'CD-TSH (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-UVI', 'CD-UVI (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-WAT', 'CD-WAT (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-YAN', 'CD-YAN (Patra, Kongo Central, Congo, the Democratic Republic of the)'),
    ('CD-ZGQ', 'CD-ZGQ (Zongo, Équateur, Congo, the Democratic Republic of the)'),
    ('CF-ALI', 'CF-ALI (Alindao, Central African Republic)'),
    ('CF-BAB', 'CF-BAB (Baboua, Central African Republic)'),
    ('CF-BMF', 'CF-BMF (Bakouma, Central African Republic)'),
    ('CF-BBY', 'CF-BBY (Bambari, Central African Republic)'),
    ('CF-BGU', 'CF-BGU (Bangassou, Central African Republic)'),
    ('CF-BGF', 'CF-BGF (Bangui, Central African Republic)'),
    ('CF-BAO', 'CF-BAO (Baoro, Central African Republic)'),
    ('CF-BTG', 'CF-BTG (Batangafo, Central African Republic)'),
    ('CF-BBT', 'CF-BBT (Berbérati, Central African Republic)'),
    ('CF-IRO', 'CF-IRO (Birao, Central African Republic)'),
    ('CF-BOC', 'CF-BOC (Bocaranga, Central African Republic)'),
    ('CF-BOD', 'CF-BOD (Boda, Central African Republic)'),
    ('CF-BOG', 'CF-BOG (Bogoto, Central African Republic)'),
    ('CF-BSN', 'CF-BSN (Bossangoa, Central African Republic)'),
    ('CF-BEM', 'CF-BEM (Bossembélé, Central African Republic)'),
    ('CF-BOP', 'CF-BOP (Bouar, Central African Republic)'),
    ('CF-BCF', 'CF-BCF (Bouca, Central African Republic)'),
    ('CF-BOZ', 'CF-BOZ (Bozoum, Central African Republic)'),
    ('CF-BIV', 'CF-BIV (Bria, Central African Republic)'),
    ('CF-CRF', 'CF-CRF (Carnot, Central African Republic)'),
    ('CF-DEK', 'CF-DEK (Dekoa, Central African Republic)'),
    ('CF-GDI', 'CF-GDI (Gordil, Central African Republic)'),
    ('CF-GDA', 'CF-GDA (Gounda, Central African Republic)'),
    ('CF-GRI', 'CF-GRI (Grimari, Central African Republic)'),
    ('CF-KAB', 'CF-KAB (Kaga Bandoro, Central African Republic)'),
    ('CF-KWD', 'CF-KWD (Kawadjia, Central African Republic)'),
    ('CF-KEM', 'CF-KEM (Kembé, Central African Republic)'),
    ('CF-KOL', 'CF-KOL (Koumala, Central African Republic)'),
    ('CF-MKI', 'CF-MKI (Mboki, Central African Republic)'),
    ('CF-MOB', 'CF-MOB (Mobaye, Central African Republic)'),
    ('CF-MON', 'CF-MON (Mongoumba, Central African Republic)'),
    ('CF-NDL', 'CF-NDL (Ndélé, Central African Republic)'),
    ('CF-NOL', 'CF-NOL (Nola, Central African Republic)'),
    ('CF-OBO', 'CF-OBO (Obo, Central African Republic)'),
    ('CF-ODA', 'CF-ODA (Ouadda, Central African Republic)'),
    ('CF-ODJ', 'CF-ODJ (Ouanda Djallé, Central African Republic)'),
    ('CF-PAO', 'CF-PAO (Paoua, Central African Republic)'),
    ('CF-RFA', 'CF-RFA (Rafai, Central African Republic)'),
    ('CF-SIB', 'CF-SIB (Sibut, Central African Republic)'),
    ('CF-TOG', 'CF-TOG (Togo, Central African Republic)'),
    ('CF-AIG', 'CF-AIG (Yalinga, Central African Republic)'),
    ('CF-IMO', 'CF-IMO (Zemio, Central African Republic)'),
    ('CG-AZR', 'CG-AZR (Azurite, Congo)'),
    ('CG-BTB', 'CG-BTB (Betou, Congo)'),
    ('CG-BOE', 'CG-BOE (Boundji, Congo)'),
    ('CG-BZV', 'CG-BZV (Brazzaville, Congo)'),
    ('CG-DJM', 'CG-DJM (Djambala, Congo)'),
    ('CG-DJE', 'CG-DJE (Djeno Terminal, Congo)'),
    ('CG-DOL', 'CG-DOL (Dolisie, Congo)'),
    ('CG-EPN', 'CG-EPN (Epéna, Congo)'),
    ('CG-EWO', 'CG-EWO (Ewo, Congo)'),
    ('CG-GMM', 'CG-GMM (Gamboma, Congo)'),
    ('CG-ION', 'CG-ION (Impfondo, Congo)'),
    ('CG-KNJ', 'CG-KNJ (Kindamba, Congo)'),
    ('CG-KEE', 'CG-KEE (Kéllé, Congo)'),
    ('CG-LCO', 'CG-LCO (Lague, Congo)'),
    ('CG-LKC', 'CG-LKC (Lekana, Congo)'),
    ('CG-DIS', 'CG-DIS (Loubomo, Congo)'),
    ('CG-KMK', 'CG-KMK (Makabana, Congo)'),
    ('CG-MKJ', 'CG-MKJ (Makoua, Congo)'),
    ('CG-MBI', 'CG-MBI (Mbinda, Congo)'),
    ('CG-MOS', 'CG-MOS (Mossaka, Congo)'),
    ('CG-MSX', 'CG-MSX (Mossendjo, Congo)'),
    ('CG-MUY', 'CG-MUY (Mouyondzi, Congo)'),
    ('CG-NKO', "CG-NKO (N'Kossa Terminal, Congo)"),
    ('CG-NKY', 'CG-NKY (Nkayi, Congo)'),
    ('CG-OKG', 'CG-OKG (Okoyo, Congo)'),
    ('CG-OUE', 'CG-OUE (Ouesso, Congo)'),
    ('CG-FTX', 'CG-FTX (Owando Apt, Congo)'),
    ('CG-OYO', 'CG-OYO (Oyo, Congo)'),
    ('CG-PNR', 'CG-PNR (Pointe Noire, Congo)'),
    ('CG-SIB', 'CG-SIB (Sibiti, Congo)'),
    ('CG-SOE', 'CG-SOE (Souanké, Congo)'),
    ('CG-YOM', 'CG-YOM (Yombo, Congo)'),
    ('CG-ANJ', 'CG-ANJ (Zanaga, Congo)'),
    ('CH-ARF', 'CH-ARF (Aadorf, Switzerland)'),
    ('CH-AAR', 'CH-AAR (Aarau, Switzerland)'),
    ('CH-ABG', 'CH-ABG (Aarberg, Switzerland)'),
    ('CH-AAB', 'CH-AAB (Aarburg, Switzerland)'),
    ('CH-AWG', 'CH-AWG (Aarwangen, Switzerland)'),
    ('CH-ABT', 'CH-ABT (Abtwil, Switzerland)'),
    ('CH-ACL', 'CH-ACL (Aclens, Switzerland)'),
    ('CH-ACQ', 'CH-ACQ (Acquarossa, Switzerland)'),
    ('CH-ADL', 'CH-ADL (Adelboden, Switzerland)'),
    ('CH-ADI', 'CH-ADI (Adligenswil, Switzerland)'),
    ('CH-ADW', 'CH-ADW (Adliswil, Switzerland)'),
    ('CH-ABL', 'CH-ABL (Aesch, Switzerland)'),
    ('CH-AES', 'CH-AES (Aesch, Switzerland)'),
    ('CH-AEH', 'CH-AEH (Aesch bei Birmensdorf, Switzerland)'),
    ('CH-XRE', 'CH-XRE (Aeugst am Albis, Switzerland)'),
    ('CH-AFF', 'CH-AFF (Affeltrangen, Switzerland)'),
    ('CH-AFT', 'CH-AFT (Affoltern am Albis, Switzerland)'),
    ('CH-AIE', 'CH-AIE (Affoltern im Emmental, Switzerland)'),
    ('CH-AGO', 'CH-AGO (Agno, Switzerland)'),
    ('CH-AIG', 'CH-AIG (Aigle, Switzerland)'),
    ('CH-AIR', 'CH-AIR (Airolo, Switzerland)'),
    ('CH-ALZ', 'CH-ALZ (Alberswil, Switzerland)'),
    ('CH-AFH', 'CH-AFH (Alchenflueh, Switzerland)'),
    ('CH-ALL', 'CH-ALL (Allaman, Switzerland)'),
    ('CH-ALE', 'CH-ALE (Alle, Switzerland)'),
    ('CH-ASW', 'CH-ASW (Allschwil, Switzerland)'),
    ('CH-APD', 'CH-APD (Alpnach Dorf, Switzerland)'),
    ('CH-ATH', 'CH-ATH (Alpthal, Switzerland)'),
    ('CH-ARB', 'CH-ARB (Altdorf, Switzerland)'),
    ('CH-ALT', 'CH-ALT (Altendorf, Switzerland)'),
    ('CH-ATR', 'CH-ATR (Altenrhein, Switzerland)'),
    ('CH-AHF', 'CH-AHF (Altishofen, Switzerland)'),
    ('CH-ATN', 'CH-ATN (Altnau, Switzerland)'),
    ('CH-ASN', 'CH-ASN (Altstätten, Switzerland)'),
    ('CH-BEG', 'CH-BEG (Amlikon-Bissegg, Switzerland)'),
    ('CH-AWL', 'CH-AWL (Amriswil, Switzerland)'),
    ('CH-LFI', 'CH-LFI (Andelfingen, Switzerland)'),
    ('CH-AND', 'CH-AND (Andwil, Switzerland)'),
    ('CH-AGE', 'CH-AGE (Anieres, Switzerland)'),
    ('CH-ANW', 'CH-ANW (Anwil, Switzerland)'),
    ('CH-APP', 'CH-APP (Appenzell, Switzerland)'),
    ('CH-APL', 'CH-APL (Apples, Switzerland)'),
    ('CH-3JK', 'CH-3JK (Arbaz, Switzerland)'),
    ('CH-ABD', 'CH-ABD (Arbedo, Switzerland)'),
    ('CH-ZDD', 'CH-ZDD (Arbon, Switzerland)'),
    ('CH-ARC', 'CH-ARC (Arch, Switzerland)'),
    ('CH-AOC', 'CH-AOC (Arconciel, Switzerland)'),
    ('CH-ADO', 'CH-ADO (Ardon, Switzerland)'),
    ('CH-ADF', 'CH-ADF (Arisdorf, Switzerland)'),
    ('CH-ATU', 'CH-ATU (Aristau, Switzerland)'),
    ('CH-ASH', 'CH-ASH (Arlesheim, Switzerland)'),
    ('CH-AGG', 'CH-AGG (Arnegg, Switzerland)'),
    ('CH-ARL', 'CH-ARL (Arolla, Switzerland)'),
    ('CH-ARS', 'CH-ARS (Arosa, Switzerland)'),
    ('CH-ARH', 'CH-ARH (Arth, Switzerland)'),
    ('CH-AVO', 'CH-AVO (Arvigo, Switzerland)'),
    ('CH-ARZ', 'CH-ARZ (Arzier, Switzerland)'),
    ('CH-AZO', 'CH-AZO (Arzo, Switzerland)'),
    ('CH-ASC', 'CH-ASC (Ascona, Switzerland)'),
    ('CH-ASS', 'CH-ASS (Assens, Switzerland)'),
    ('CH-AT2', 'CH-AT2 (Athenaz, Switzerland)'),
    ('CH-TTK', 'CH-TTK (Attikon, Switzerland)'),
    ('CH-AUS', 'CH-AUS (Au, Switzerland)'),
    ('CH-AUT', 'CH-AUT (Au, Switzerland)'),
    ('CH-AUU', 'CH-AUU (Au, Switzerland)'),
    ('CH-ABO', 'CH-ABO (Aubonne, Switzerland)'),
    ('CH-AGT', 'CH-AGT (Augst, Switzerland)'),
    ('CH-AUL', 'CH-AUL (Auslikon, Switzerland)'),
    ('CH-AVI', 'CH-AVI (Auvernier, Switzerland)'),
    ('CH-A8T', 'CH-A8T (Avegno, Switzerland)'),
    ('CH-AVE', 'CH-AVE (Avenches, Switzerland)'),
    ('CH-AVR', 'CH-AVR (Avry, Switzerland)'),
    ('CH-AYE', 'CH-AYE (Ayent, Switzerland)'),
    ('CH-BAR', 'CH-BAR (Baar, Switzerland)'),
    ('CH-BAH', 'CH-BAH (Bach, Switzerland)'),
    ('CH-BAB', 'CH-BAB (Bachenbülach, Switzerland)'),
    ('CH-BRZ', 'CH-BRZ (Bad Ragaz, Switzerland)'),
    ('CH-BZZ', 'CH-BZZ (Bad Zurzach, Switzerland)'),
    ('CH-BAD', 'CH-BAD (Baden, Switzerland)'),
    ('CH-BLA', 'CH-BLA (Balerna, Switzerland)'),
    ('CH-BAL', 'CH-BAL (Balgach, Switzerland)'),
    ('CH-BLI', 'CH-BLI (Ballaigues, Switzerland)'),
    ('CH-BLS', 'CH-BLS (Ballens, Switzerland)'),
    ('CH-BA8', 'CH-BA8 (Ballwil, Switzerland)'),
    ('CH-BST', 'CH-BST (Balsthal, Switzerland)'),
    ('CH-BWI', 'CH-BWI (Balterswil, Switzerland)'),
    ('CH-BTS', 'CH-BTS (Baltschieder, Switzerland)'),
    ('CH-BWL', 'CH-BWL (Bannwil, Switzerland)'),
    ('CH-BDX', 'CH-BDX (Bardonnex, Switzerland)'),
    ('CH-BAG', 'CH-BAG (Bargen, Switzerland)'),
    ('CH-BGN', 'CH-BGN (Bargen, Switzerland)'),
    ('CH-TGB', 'CH-TGB (Basadingen, Switzerland)'),
    ('CH-BSL', 'CH-BSL (Basel, Switzerland)'),
    ('CH-BBS', 'CH-BBS (Basel Schweizerhalle, Switzerland)'),
    ('CH-BSA', 'CH-BSA (Basse-Allaine, Switzerland)'),
    ('CH-BAS', 'CH-BAS (Bassecourt, Switzerland)'),
    ('CH-BSF', 'CH-BSF (Bassersdorf, Switzerland)'),
    ('CH-QBA', 'CH-QBA (Bauma, Switzerland)'),
    ('CH-BZH', 'CH-BZH (Bazenheid, Switzerland)'),
    ('CH-BEA', 'CH-BEA (Beatenberg, Switzerland)'),
    ('CH-BCR', 'CH-BCR (Beckenried, Switzerland)'),
    ('CH-BDN', 'CH-BDN (Bedano, Switzerland)'),
    ('CH-BGA', 'CH-BGA (Bedigliora, Switzerland)'),
    ('CH-5BM', 'CH-5BM (Beinwil am See, Switzerland)'),
    ('CH-BFX', 'CH-BFX (Belfaux, Switzerland)'),
    ('CH-BEL', 'CH-BEL (Bellach, Switzerland)'),
    ('CH-BLV', 'CH-BLV (Bellevue, Switzerland)'),
    ('CH-BZA', 'CH-BZA (Bellinzona, Switzerland)'),
    ('CH-BLL', 'CH-BLL (Bellmund, Switzerland)'),
    ('CH-BEW', 'CH-BEW (Bellwald, Switzerland)'),
    ('CH-BLP', 'CH-BLP (Belp, Switzerland)'),
    ('CH-BKN', 'CH-BKN (Benken, Switzerland)'),
    ('CH-BVD', 'CH-BVD (Bercher, Switzerland)'),
    ('CH-BGS', 'CH-BGS (Berg, Switzerland)'),
    ('CH-BGI', 'CH-BGI (Bergdietikon, Switzerland)'),
    ('CH-BEN', 'CH-BEN (Bergün, Switzerland)'),
    ('CH-BER', 'CH-BER (Beringen, Switzerland)'),
    ('CH-BRN', 'CH-BRN (Bern, Switzerland)'),
    ('CH-BCK', 'CH-BCK (Berneck, Switzerland)'),
    ('CH-BNX', 'CH-BNX (Bernex, Switzerland)'),
    ('CH-BRM', 'CH-BRM (Beromünster, Switzerland)'),
    ('CH-BHK', 'CH-BHK (Bertschikon, Switzerland)'),
    ('CH-BT2', 'CH-BT2 (Bettens, Switzerland)'),
    ('CH-BET', 'CH-BET (Bettlach, Switzerland)'),
    ('CH-TBN', 'CH-TBN (Bettwiesen, Switzerland)'),
    ('CH-BVX', 'CH-BVX (Bevaix, Switzerland)'),
    ('CH-BEX', 'CH-BEX (Bex, Switzerland)'),
    ('CH-BIA', 'CH-BIA (Biasca, Switzerland)'),
    ('CH-BIB', 'CH-BIB (Biberist, Switzerland)'),
    ('CH-BBN', 'CH-BBN (Biberstein, Switzerland)'),
    ('CH-BIE', 'CH-BIE (Biel, Switzerland)'),
    ('CH-BBK', 'CH-BBK (Biel-Benken, Switzerland)'),
    ('CH-BGT', 'CH-BGT (Bigenthal, Switzerland)'),
    ('CH-BBI', 'CH-BBI (Biglen, Switzerland)'),
    ('CH-BIL', 'CH-BIL (Billens, Switzerland)'),
    ('CH-BLT', 'CH-BLT (Bilten, Switzerland)'),
    ('CH-BNN', 'CH-BNN (Binningen, Switzerland)'),
    ('CH-BIZ', 'CH-BIZ (Binz, Switzerland)'),
    ('CH-BIO', 'CH-BIO (Bioggio, Switzerland)'),
    ('CH-VAD', 'CH-VAD (Bioley-Orjulaz, Switzerland)'),
    ('CH-BDF', 'CH-BDF (Birmensdorf, Switzerland)'),
    ('CH-BMO', 'CH-BMO (Birmenstorf, Switzerland)'),
    ('CH-BTI', 'CH-BTI (Bironico, Switzerland)'),
    ('CH-BRR', 'CH-BRR (Birr, Switzerland)'),
    ('CH-BIR', 'CH-BIR (Birrwil, Switzerland)'),
    ('CH-BFL', 'CH-BFL (Birsfelden, Switzerland)'),
    ('CH-BCZ', 'CH-BCZ (Bischofszell, Switzerland)'),
    ('CH-BSG', 'CH-BSG (Bisingen, Switzerland)'),
    ('CH-BIS', 'CH-BIS (Bister, Switzerland)'),
    ('CH-BLE', 'CH-BLE (Bleienbach, Switzerland)'),
    ('CH-BLY', 'CH-BLY (Blonay, Switzerland)'),
    ('CH-BOD', 'CH-BOD (Bodio, Switzerland)'),
    ('CH-BBV', 'CH-BBV (Bogis-Bossey, Switzerland)'),
    ('CH-BOL', 'CH-BOL (Boll, Switzerland)'),
    ('CH-BLG', 'CH-BLG (Bolligen, Switzerland)'),
    ('CH-BON', 'CH-BON (Bonaduz, Switzerland)'),
    ('CH-BCU', 'CH-BCU (Boncourt, Switzerland)'),
    ('CH-BNF', 'CH-BNF (Bonfol, Switzerland)'),
    ('CH-BGE', 'CH-BGE (Boningen, Switzerland)'),
    ('CH-BOT', 'CH-BOT (Bonstetten, Switzerland)'),
    ('CH-BSI', 'CH-BSI (Bosingen, Switzerland)'),
    ('CH-BOS', 'CH-BOS (Boswil, Switzerland)'),
    ('CH-CGO', 'CH-CGO (Bottighofen, Switzerland)'),
    ('CH-BTN', 'CH-BTN (Bottmingen, Switzerland)'),
    ('CH-BDY', 'CH-BDY (Boudry, Switzerland)'),
    ('CH-BYV', 'CH-BYV (Bougy-Villars, Switzerland)'),
    ('CH-BSS', 'CH-BSS (Boussens, Switzerland)'),
    ('CH-BVT', 'CH-BVT (Bouveret, Switzerland)'),
    ('CH-BOV', 'CH-BOV (Boveresse, Switzerland)'),
    ('CH-BCT', 'CH-BCT (Boécourt, Switzerland)'),
    ('CH-BAO', 'CH-BAO (Bre-Aldesago, Switzerland)'),
    ('CH-BGZ', 'CH-BGZ (Breganzona, Switzerland)'),
    ('CH-ESH', 'CH-ESH (Breitenbach, Switzerland)'),
    ('CH-BBL', 'CH-BBL (Bremblens, Switzerland)'),
    ('CH-BMG', 'CH-BMG (Bremgarten, Switzerland)'),
    ('CH-BMT', 'CH-BMT (Bremgarten bei Bern, Switzerland)'),
    ('CH-BZK', 'CH-BZK (Brenzikofen, Switzerland)'),
    ('CH-BSM', 'CH-BSM (Bretigny-sur-Morrens, Switzerland)'),
    ('CH-BEZ', 'CH-BEZ (Brienz, Switzerland)'),
    ('CH-BZW', 'CH-BZW (Brienzwiler, Switzerland)'),
    ('CH-BRI', 'CH-BRI (Brig, Switzerland)'),
    ('CH-LBR', 'CH-LBR (Brislach, Switzerland)'),
    ('CH-BIG', 'CH-BIG (Brissago, Switzerland)'),
    ('CH-BTA', 'CH-BTA (Brittnau, Switzerland)'),
    ('CH-BRC', 'CH-BRC (Broc, Switzerland)'),
    ('CH-BRO', 'CH-BRO (Bronschhofen, Switzerland)'),
    ('CH-BGG', 'CH-BGG (Brugg, Switzerland)'),
    ('CH-BUG', 'CH-BUG (Brugg, Switzerland)'),
    ('CH-BNG', 'CH-BNG (Brunegg, Switzerland)'),
    ('CH-BRU', 'CH-BRU (Brunnen, Switzerland)'),
    ('CH-BSO', 'CH-BSO (Brusio, Switzerland)'),
    ('CH-BTT', 'CH-BTT (Brutten, Switzerland)'),
    ('CH-RGG', 'CH-RGG (Brügg, Switzerland)'),
    ('CH-BTL', 'CH-BTL (Brüttisellen, Switzerland)'),
    ('CH-BUB', 'CH-BUB (Bubendorf, Switzerland)'),
    ('CH-BUK', 'CH-BUK (Bubikon, Switzerland)'),
    ('CH-BHR', 'CH-BHR (Buchrain, Switzerland)'),
    ('CH-BCS', 'CH-BCS (Buchs, Switzerland)'),
    ('CH-BUC', 'CH-BUC (Buchs, Switzerland)'),
    ('CH-BUZ', 'CH-BUZ (Buchs, Switzerland)'),
    ('CH-BUI', 'CH-BUI (Buix, Switzerland)'),
    ('CH-BUL', 'CH-BUL (Bulle, Switzerland)'),
    ('CH-BZN', 'CH-BZN (Bunzen, Switzerland)'),
    ('CH-BXO', 'CH-BXO (Buochs, Switzerland)'),
    ('CH-BUO', 'CH-BUO (Buonas, Switzerland)'),
    ('CH-BRG', 'CH-BRG (Burg, Switzerland)'),
    ('CH-BGF', 'CH-BGF (Burgdorf, Switzerland)'),
    ('CH-BZE', 'CH-BZE (Buron, Switzerland)'),
    ('CH-BUR', 'CH-BUR (Bursinel, Switzerland)'),
    ('CH-BSN', 'CH-BSN (Bursins, Switzerland)'),
    ('CH-BUS', 'CH-BUS (Bussigny-près-Lausanne, Switzerland)'),
    ('CH-BUU', 'CH-BUU (Bussnang, Switzerland)'),
    ('CH-BSU', 'CH-BSU (Busswil, Switzerland)'),
    ('CH-BUT', 'CH-BUT (Buttes, Switzerland)'),
    ('CH-BTK', 'CH-BTK (Buttikon, Switzerland)'),
    ('CH-JBZ', 'CH-JBZ (Buttisholz, Switzerland)'),
    ('CH-BAU', 'CH-BAU (Bärau, Switzerland)'),
    ('CH-BRL', 'CH-BRL (Bäretswil, Switzerland)'),
    ('CH-BCW', 'CH-BCW (Bärschwil, Switzerland)'),
    ('CH-BKD', 'CH-BKD (Bätterkinden, Switzerland)'),
    ('CH-BEV', 'CH-BEV (Bévilard, Switzerland)'),
    ('CH-BOC', 'CH-BOC (Böckten, Switzerland)'),
    ('CH-BLN', 'CH-BLN (Büchslen, Switzerland)'),
    ('CH-BHL', 'CH-BHL (Bühler, Switzerland)'),
    ('CH-BUA', 'CH-BUA (Bülach, Switzerland)'),
    ('CH-BHN', 'CH-BHN (Bürchen, Switzerland)'),
    ('CH-BUE', 'CH-BUE (Büren, Switzerland)'),
    ('CH-BUD', 'CH-BUD (Büren an der Aare, Switzerland)'),
    ('CH-BSK', 'CH-BSK (Bürgenstock, Switzerland)'),
    ('CH-BGL', 'CH-BGL (Bürglen, Switzerland)'),
    ('CH-BSH', 'CH-BSH (Büsserach, Switzerland)'),
    ('CH-BSW', 'CH-BSW (Bütschwil, Switzerland)'),
    ('CH-BUN', 'CH-BUN (Büttikon, Switzerland)'),
    ('CH-BZG', 'CH-BZG (Bützberg, Switzerland)'),
    ('CH-CAP', 'CH-CAP (Cadempino, Switzerland)'),
    ('CH-CAD', 'CH-CAD (Cadenazzo, Switzerland)'),
    ('CH-CDR', 'CH-CDR (Cadro, Switzerland)'),
    ('CH-CAM', 'CH-CAM (Campascio, Switzerland)'),
    ('CH-CCG', 'CH-CCG (Campocologno, Switzerland)'),
    ('CH-CAN', 'CH-CAN (Canobbio, Switzerland)'),
    ('CH-CPL', 'CH-CPL (Capolago, Switzerland)'),
    ('CH-CRG', 'CH-CRG (Carouge, Switzerland)'),
    ('CH-CAR', 'CH-CAR (Cartigny, Switzerland)'),
    ('CH-CSO', 'CH-CSO (Caslano, Switzerland)'),
    ('CH-CAS', 'CH-CAS (Castasegna, Switzerland)'),
    ('CH-PIE', 'CH-PIE (Castel San Pietro, Switzerland)'),
    ('CH-CTE', 'CH-CTE (Castione, Switzerland)'),
    ('CH-HHM', 'CH-HHM (Cham, Switzerland)'),
    ('CH-CMY', 'CH-CMY (Chambesy, Switzerland)'),
    ('CH-CBN', 'CH-CBN (Chamblon, Switzerland)'),
    ('CH-CBR', 'CH-CBR (Chambrielien, Switzerland)'),
    ('CH-CHM', 'CH-CHM (Chamoson, Switzerland)'),
    ('CH-CPA', 'CH-CPA (Champagne, Switzerland)'),
    ('CH-CHP', 'CH-CHP (Champéry, Switzerland)'),
    ('CH-CRM', 'CH-CRM (Charmoille, Switzerland)'),
    ('CH-VVS', 'CH-VVS (Charrat, Switzerland)'),
    ('CH-CSD', 'CH-CSD (Chatel-St-Denis, Switzerland)'),
    ('CH-CDB', 'CH-CDB (Chavannes-de-Bogis, Switzerland)'),
    ('CH-VPR', 'CH-VPR (Chavannes-près-Renens, Switzerland)'),
    ('CH-CVY', 'CH-CVY (Chavornay, Switzerland)'),
    ('CH-CBS', 'CH-CBS (Chene-Bougeries, Switzerland)'),
    ('CH-CBG', 'CH-CBG (Chene-Bourg, Switzerland)'),
    ('CH-CNX', 'CH-CNX (Chernex, Switzerland)'),
    ('CH-CXL', 'CH-CXL (Cheseaux-sur-Lausanne, Switzerland)'),
    ('CH-CHS', 'CH-CHS (Chesieres, Switzerland)'),
    ('CH-CHE', 'CH-CHE (Chevenez, Switzerland)'),
    ('CH-CEX', 'CH-CEX (Chexbres, Switzerland)'),
    ('CH-RYC', 'CH-RYC (Cheyres, Switzerland)'),
    ('CH-CSM', 'CH-CSM (Chezard-St-Martin, Switzerland)'),
    ('CH-CHI', 'CH-CHI (Chiasso, Switzerland)'),
    ('CH-CPS', 'CH-CPS (Chippis, Switzerland)'),
    ('CH-N66', 'CH-N66 (Choindez, Switzerland)'),
    ('CH-X6Z', 'CH-X6Z (Choulex, Switzerland)'),
    ('CH-CHX', 'CH-CHX (Choëx, Switzerland)'),
    ('CH-CHR', 'CH-CHR (Chur, Switzerland)'),
    ('CH-CHO', "CH-CHO (Château-d'Oex, Switzerland)"),
    ('CH-CAL', 'CH-CAL (Châtelaine, Switzerland)'),
    ('CH-CLN', 'CH-CLN (Clarens, Switzerland)'),
    ('CH-CLA', 'CH-CLA (Clarmont, Switzerland)'),
    ('CH-COI', 'CH-COI (Cointrin, Switzerland)'),
    ('CH-CBY', 'CH-CBY (Collex-Bossy, Switzerland)'),
    ('CH-COD', "CH-COD (Collina d'Oro, Switzerland)"),
    ('CH-COL', 'CH-COL (Collombey, Switzerland)'),
    ('CH-CBL', 'CH-CBL (Collonge-Bellerive, Switzerland)'),
    ('CH-CLG', 'CH-CLG (Cologny, Switzerland)'),
    ('CH-CMB', 'CH-CMB (Colombier, Switzerland)'),
    ('CH-COM', 'CH-COM (Comano, Switzerland)'),
    ('CH-CMM', 'CH-CMM (Commugny, Switzerland)'),
    ('CH-CON', 'CH-CON (Concise, Switzerland)'),
    ('CH-CFG', 'CH-CFG (Confignon, Switzerland)'),
    ('CH-CHY', 'CH-CHY (Conthey, Switzerland)'),
    ('CH-CTR', 'CH-CTR (Contra, Switzerland)'),
    ('CH-COP', 'CH-COP (Coppet, Switzerland)'),
    ('CH-CRY', 'CH-CRY (Corbeyrier, Switzerland)'),
    ('CH-CRC', 'CH-CRC (Corcelles-Cormondrèche, Switzerland)'),
    ('CH-COR', 'CH-COR (Corcelles-près-Payerne, Switzerland)'),
    ('CH-CGM', 'CH-CGM (Corgémont, Switzerland)'),
    ('CH-CBF', 'CH-CBF (Corminboeuf, Switzerland)'),
    ('CH-CMR', 'CH-CMR (Cormoret, Switzerland)'),
    ('CH-COA', 'CH-COA (Cornaux, Switzerland)'),
    ('CH-CO2', 'CH-CO2 (Cornol, Switzerland)'),
    ('CH-CMS', 'CH-CMS (Corpataux-Magnedens, Switzerland)'),
    ('CH-CSR', 'CH-CSR (Corsier, Switzerland)'),
    ('CH-COS', 'CH-COS (Corsier-sur-Vevey, Switzerland)'),
    ('CH-CRT', 'CH-CRT (Cortaillod, Switzerland)'),
    ('CH-CSN', 'CH-CSN (Cossonay, Switzerland)'),
    ('CH-COE', 'CH-COE (Courfaivre, Switzerland)'),
    ('CH-CGY', 'CH-CGY (Courgenay, Switzerland)'),
    ('CH-CDL', 'CH-CDL (Courrendlin, Switzerland)'),
    ('CH-CRX', 'CH-CRX (Courroux, Switzerland)'),
    ('CH-COU', 'CH-COU (Court, Switzerland)'),
    ('CH-YHM', 'CH-YHM (Courtaman, Switzerland)'),
    ('CH-CDX', 'CH-CDX (Courtedoux, Switzerland)'),
    ('CH-CTY', 'CH-CTY (Courtelary, Switzerland)'),
    ('CH-COT', 'CH-COT (Courtepin, Switzerland)'),
    ('CH-CST', 'CH-CST (Cousset, Switzerland)'),
    ('CH-CVT', 'CH-CVT (Couvet, Switzerland)'),
    ('CH-CDY', 'CH-CDY (Crans, Switzerland)'),
    ('CH-CMT', 'CH-CMT (Crans Montana, Switzerland)'),
    ('CH-CPC', 'CH-CPC (Crans-Près-Céligny, Switzerland)'),
    ('CH-CRA', 'CH-CRA (Crassier, Switzerland)'),
    ('CH-CRR', 'CH-CRR (Cressier, Switzerland)'),
    ('CH-CRS', 'CH-CRS (Cressier, Switzerland)'),
    ('CH-CRI', 'CH-CRI (Crissier, Switzerland)'),
    ('CH-CR2', 'CH-CR2 (Crémines, Switzerland)'),
    ('CH-CUD', 'CH-CUD (Cudrefin, Switzerland)'),
    ('CH-CUG', 'CH-CUG (Cugy, Switzerland)'),
    ('CH-CUL', 'CH-CUL (Cully, Switzerland)'),
    ('CH-4CE', 'CH-4CE (Céligny, Switzerland)'),
    ('CH-ZCH', 'CH-ZCH (Dachsen, Switzerland)'),
    ('CH-DAE', 'CH-DAE (Dagmersellen, Switzerland)'),
    ('CH-DLS', 'CH-DLS (Daillens, Switzerland)'),
    ('CH-DAL', 'CH-DAL (Dallenwil, Switzerland)'),
    ('CH-DVD', 'CH-DVD (Davos Dorf, Switzerland)'),
    ('CH-DVG', 'CH-DVG (Davos Glaris, Switzerland)'),
    ('CH-DPZ', 'CH-DPZ (Davos Platz, Switzerland)'),
    ('CH-DGS', 'CH-DGS (Degersheim, Switzerland)'),
    ('CH-DEI', 'CH-DEI (Deitingen, Switzerland)'),
    ('CH-DEL', 'CH-DEL (Delémont, Switzerland)'),
    ('CH-DNS', 'CH-DNS (Denens, Switzerland)'),
    ('CH-D8S', 'CH-D8S (Denges, Switzerland)'),
    ('CH-DBU', 'CH-DBU (Densbüren, Switzerland)'),
    ('CH-DRD', 'CH-DRD (Derendingen, Switzerland)'),
    ('CH-DTG', 'CH-DTG (Detligen, Switzerland)'),
    ('CH-DET', 'CH-DET (Dettighofen, Switzerland)'),
    ('CH-DVR', 'CH-DVR (Develier, Switzerland)'),
    ('CH-DGT', 'CH-DGT (Diegten, Switzerland)'),
    ('CH-DLD', 'CH-DLD (Dielsdorf, Switzerland)'),
    ('CH-DII', 'CH-DII (Diemtigen, Switzerland)'),
    ('CH-DPS', 'CH-DPS (Diepoldsau, Switzerland)'),
    ('CH-DKN', 'CH-DKN (Dierikon, Switzerland)'),
    ('CH-DIB', 'CH-DIB (Diesbach, Switzerland)'),
    ('CH-DSB', 'CH-DSB (Diessbach, Switzerland)'),
    ('CH-DSH', 'CH-DSH (Diessenhofen, Switzerland)'),
    ('CH-DTL', 'CH-DTL (Dieterswil, Switzerland)'),
    ('CH-DIE', 'CH-DIE (Dietikon, Switzerland)'),
    ('CH-DLK', 'CH-DLK (Dietlikon, Switzerland)'),
    ('CH-DTW', 'CH-DTW (Dietwil, Switzerland)'),
    ('CH-DNH', 'CH-DNH (Dinhard, Switzerland)'),
    ('CH-DTK', 'CH-DTK (Dintikon, Switzerland)'),
    ('CH-DIS', 'CH-DIS (Disentis/Mustér, Switzerland)'),
    ('CH-DTT', 'CH-DTT (Dittingen, Switzerland)'),
    ('CH-DMT', 'CH-DMT (Domat, Switzerland)'),
    ('CH-DOM', 'CH-DOM (Dombresson, Switzerland)'),
    ('CH-DDR', 'CH-DDR (Domdidier, Switzerland)'),
    ('CH-DZ8', 'CH-DZ8 (Dongio, Switzerland)'),
    ('CH-DPL', 'CH-DPL (Doppleschwand, Switzerland)'),
    ('CH-DOR', 'CH-DOR (Dornach, Switzerland)'),
    ('CH-DRZ', 'CH-DRZ (Dorénaz, Switzerland)'),
    ('CH-DOC', 'CH-DOC (Dotnacht, Switzerland)'),
    ('CH-DTO', 'CH-DTO (Dottikon, Switzerland)'),
    ('CH-DTZ', 'CH-DTZ (Dotzigen, Switzerland)'),
    ('CH-DOZ', 'CH-DOZ (Dozwil, Switzerland)'),
    ('CH-DGI', 'CH-DGI (Duggingen, Switzerland)'),
    ('CH-DIN', 'CH-DIN (Dulliken, Switzerland)'),
    ('CH-DLL', 'CH-DLL (Dully, Switzerland)'),
    ('CH-DUS', 'CH-DUS (Dussnang, Switzerland)'),
    ('CH-DON', 'CH-DON (Dällikon, Switzerland)'),
    ('CH-DNK', 'CH-DNK (Däniken, Switzerland)'),
    ('CH-DWL', 'CH-DWL (Dättwil, Switzerland)'),
    ('CH-DOT', 'CH-DOT (Döttingen, Switzerland)'),
    ('CH-DRF', 'CH-DRF (Dübendorf, Switzerland)'),
    ('CH-DIG', 'CH-DIG (Düdingen, Switzerland)'),
    ('CH-DTN', 'CH-DTN (Dürnten, Switzerland)'),
    ('CH-DNA', 'CH-DNA (Dürrenäsch, Switzerland)'),
    ('CH-EBE', 'CH-EBE (Ebersecken, Switzerland)'),
    ('CH-EIN', 'CH-EIN (Ebikon, Switzerland)'),
    ('CH-EKP', 'CH-EKP (Ebnat-Kappel, Switzerland)'),
    ('CH-EVD', 'CH-EVD (Echallens, Switzerland)'),
    ('CH-ECH', 'CH-ECH (Echandens, Switzerland)'),
    ('CH-EGS', 'CH-EGS (Eclagnens, Switzerland)'),
    ('CH-ECL', 'CH-ECL (Eclépens, Switzerland)'),
    ('CH-ELS', 'CH-ELS (Ecublens, Switzerland)'),
    ('CH-EVL', 'CH-EVL (Ecuvillens, Switzerland)'),
    ('CH-EDB', 'CH-EDB (Edlibach, Switzerland)'),
    ('CH-EFF', 'CH-EFF (Effretikon, Switzerland)'),
    ('CH-EKG', 'CH-EKG (Egerkingen, Switzerland)'),
    ('CH-ZEG', 'CH-ZEG (Egg, Switzerland)'),
    ('CH-WGG', 'CH-WGG (Eggenwil, Switzerland)'),
    ('CH-EGI', 'CH-EGI (Eggiwil, Switzerland)'),
    ('CH-GWF', 'CH-GWF (Eglisau, Switzerland)'),
    ('CH-EGL', 'CH-EGL (Egliswil, Switzerland)'),
    ('CH-EHR', 'CH-EHR (Ehrendingen, Switzerland)'),
    ('CH-EIK', 'CH-EIK (Eiken, Switzerland)'),
    ('CH-EGE', 'CH-EGE (Einigen, Switzerland)'),
    ('CH-ESD', 'CH-ESD (Einsiedeln, Switzerland)'),
    ('CH-EGG', 'CH-EGG (Elgg, Switzerland)'),
    ('CH-EDT', 'CH-EDT (Ellikon An Der Thur, Switzerland)'),
    ('CH-ELU', 'CH-ELU (Elsau, Switzerland)'),
    ('CH-EBH', 'CH-EBH (Embrach, Switzerland)'),
    ('CH-ZET', 'CH-ZET (Embrach-Embraport, Switzerland)'),
    ('CH-EMM', 'CH-EMM (Emmen, Switzerland)'),
    ('CH-EBC', 'CH-EBC (Emmenbrücke, Switzerland)'),
    ('CH-EDG', 'CH-EDG (Endingen, Switzerland)'),
    ('CH-ENG', 'CH-ENG (Engelberg, Switzerland)'),
    ('CH-ELG', 'CH-ELG (Engelburg, Switzerland)'),
    ('CH-EN2', 'CH-EN2 (Enges, Switzerland)'),
    ('CH-ENE', 'CH-ENE (Ennenda, Switzerland)'),
    ('CH-TEH', 'CH-TEH (Ennetaach, Switzerland)'),
    ('CH-ETB', 'CH-ETB (Ennetbürgen, Switzerland)'),
    ('CH-NW6', 'CH-NW6 (Ennetmoos, Switzerland)'),
    ('CH-ENN', 'CH-ENN (Enney, Switzerland)'),
    ('CH-ENT', 'CH-ENT (Entlebuch, Switzerland)'),
    ('CH-DSF', 'CH-DSF (Epalinges, Switzerland)'),
    ('CH-EPE', 'CH-EPE (Ependes, Switzerland)'),
    ('CH-EPS', 'CH-EPS (Epesses, Switzerland)'),
    ('CH-ELH', 'CH-ELH (Erlach, Switzerland)'),
    ('CH-ERT', 'CH-ERT (Erlen, Switzerland)'),
    ('CH-ERB', 'CH-ERB (Erlenbach, Switzerland)'),
    ('CH-EIS', 'CH-EIS (Erlenbach im Simmental, Switzerland)'),
    ('CH-ERL', 'CH-ERL (Erlinsbach, Switzerland)'),
    ('CH-SZ9', 'CH-SZ9 (Erlinsbach, Switzerland)'),
    ('CH-EMG', 'CH-EMG (Ermatingen, Switzerland)'),
    ('CH-ERM', 'CH-ERM (Ermensee, Switzerland)'),
    ('CH-EWL', 'CH-EWL (Ermenswil, Switzerland)'),
    ('CH-ERN', 'CH-ERN (Ernen, Switzerland)'),
    ('CH-BEE', 'CH-BEE (Ersigen, Switzerland)'),
    ('CH-ETD', 'CH-ETD (Erstfeld, Switzerland)'),
    ('CH-ECB', 'CH-ECB (Eschenbach, Switzerland)'),
    ('CH-ESB', 'CH-ESB (Eschenbach, Switzerland)'),
    ('CH-ESZ', 'CH-ESZ (Eschenz, Switzerland)'),
    ('CH-ECT', 'CH-ECT (Eschert, Switzerland)'),
    ('CH-EHK', 'CH-EHK (Eschlikon, Switzerland)'),
    ('CH-EKO', 'CH-EKO (Eschlikon, Switzerland)'),
    ('CH-ESM', 'CH-ESM (Escholzmatt, Switzerland)'),
    ('CH-ELB', 'CH-ELB (Estavayer-le-Gibloux, Switzerland)'),
    ('CH-ELL', 'CH-ELL (Estavayer-le-Lac, Switzerland)'),
    ('CH-ETO', 'CH-ETO (Etoy, Switzerland)'),
    ('CH-ETT', 'CH-ETT (Ettingen, Switzerland)'),
    ('CH-EZK', 'CH-EZK (Etzelkofen, Switzerland)'),
    ('CH-ETZ', 'CH-ETZ (Etzgen, Switzerland)'),
    ('CH-EKZ', 'CH-EKZ (Etziken, Switzerland)'),
    ('CH-EVZ', 'CH-EVZ (Evionnaz, Switzerland)'),
    ('CH-EYS', 'CH-EYS (Eysins, Switzerland)'),
    ('CH-FWG', 'CH-FWG (Fahrwangen, Switzerland)'),
    ('CH-FWS', 'CH-FWS (Fahrweid, Switzerland)'),
    ('CH-FHY', 'CH-FHY (Fahy, Switzerland)'),
    ('CH-FLD', 'CH-FLD (Fallanden, Switzerland)'),
    ('CH-FCY', 'CH-FCY (Fechy, Switzerland)'),
    ('CH-FTF', 'CH-FTF (Fehraltorf, Switzerland)'),
    ('CH-FBA', 'CH-FBA (Felben, Switzerland)'),
    ('CH-FEH', 'CH-FEH (Feldbach, Switzerland)'),
    ('CH-FEM', 'CH-FEM (Feldmeilen, Switzerland)'),
    ('CH-ZHC', 'CH-ZHC (Feuerthalen, Switzerland)'),
    ('CH-FSG', 'CH-FSG (Feusisberg, Switzerland)'),
    ('CH-FEY', 'CH-FEY (Fey, Switzerland)'),
    ('CH-FIE', 'CH-FIE (Fiesch, Switzerland)'),
    ('CH-FIN', 'CH-FIN (Finhaut, Switzerland)'),
    ('CH-FGK', 'CH-FGK (Fischbach Goslikon, Switzerland)'),
    ('CH-FIS', 'CH-FIS (Fisibach, Switzerland)'),
    ('CH-FSH', 'CH-FSH (Fislisbach, Switzerland)'),
    ('CH-FAH', 'CH-FAH (Flaach, Switzerland)'),
    ('CH-FLM', 'CH-FLM (Flamatt, Switzerland)'),
    ('CH-FTY', 'CH-FTY (Flanthey, Switzerland)'),
    ('CH-FLW', 'CH-FLW (Flawil, Switzerland)'),
    ('CH-FLI', 'CH-FLI (Fleurier, Switzerland)'),
    ('CH-FLS', 'CH-FLS (Flims, Switzerland)'),
    ('CH-FML', 'CH-FML (Flumenthal, Switzerland)'),
    ('CH-FLU', 'CH-FLU (Flums, Switzerland)'),
    ('CH-FLJ', 'CH-FLJ (Flurlingen, Switzerland)'),
    ('CH-FLA', 'CH-FLA (Fläsch, Switzerland)'),
    ('CH-FLN', 'CH-FLN (Flüelen, Switzerland)'),
    ('CH-YFL', 'CH-YFL (Flüh, Switzerland)'),
    ('CH-FTM', 'CH-FTM (Fontainemelon, Switzerland)'),
    ('CH-FTS', 'CH-FTS (Fontaines, Switzerland)'),
    ('CH-FCH', 'CH-FCH (Forch, Switzerland)'),
    ('CH-FOL', 'CH-FOL (Forel, Switzerland)'),
    ('CH-FNX', 'CH-FNX (Founex, Switzerland)'),
    ('CH-FRT', 'CH-FRT (Frasnacht, Switzerland)'),
    ('CH-FRA', 'CH-FRA (Fraubrunnen, Switzerland)'),
    ('CH-FRN', 'CH-FRN (Frauenfeld, Switzerland)'),
    ('CH-5FK', 'CH-5FK (Frauenkappelen, Switzerland)'),
    ('CH-FRD', 'CH-FRD (Freidorf, Switzerland)'),
    ('CH-FRE', 'CH-FRE (Freidorf, Switzerland)'),
    ('CH-FBH', 'CH-FBH (Freienbach, Switzerland)'),
    ('CH-FSI', 'CH-FSI (Freienstein, Switzerland)'),
    ('CH-FKD', 'CH-FKD (Frenkendorf, Switzerland)'),
    ('CH-FRB', 'CH-FRB (Fribourg, Switzerland)'),
    ('CH-FCK', 'CH-FCK (Frick, Switzerland)'),
    ('CH-FTN', 'CH-FTN (Frutigen, Switzerland)'),
    ('CH-FUL', 'CH-FUL (Fulenbach, Switzerland)'),
    ('CH-FLY', 'CH-FLY (Fully, Switzerland)'),
    ('CH-FRF', 'CH-FRF (Füllinsdorf, Switzerland)'),
    ('CH-SGG', 'CH-SGG (Gais, Switzerland)'),
    ('CH-GGN', 'CH-GGN (Galgenen, Switzerland)'),
    ('CH-GMP', 'CH-GMP (Gampelen, Switzerland)'),
    ('CH-GAM', 'CH-GAM (Gams, Switzerland)'),
    ('CH-GDA', 'CH-GDA (Gandria, Switzerland)'),
    ('CH-GAN', 'CH-GAN (Gansingen, Switzerland)'),
    ('CH-GSW', 'CH-GSW (Ganterschwil, Switzerland)'),
    ('CH-GEB', 'CH-GEB (Gebenstorf, Switzerland)'),
    ('CH-GKR', 'CH-GKR (Gelterkinden, Switzerland)'),
    ('CH-GSR', 'CH-GSR (Genestrerio, Switzerland)'),
    ('CH-GNL', 'CH-GNL (Genolier, Switzerland)'),
    ('CH-GNT', 'CH-GNT (Genthod, Switzerland)'),
    ('CH-GVA', 'CH-GVA (Genève, Switzerland)'),
    ('CH-GFG', 'CH-GFG (Gerlafingen, Switzerland)'),
    ('CH-GDW', 'CH-GDW (Geroldswil, Switzerland)'),
    ('CH-GER', 'CH-GER (Gersau, Switzerland)'),
    ('CH-LL4', 'CH-LL4 (Gettnau, Switzerland)'),
    ('CH-WSG', 'CH-WSG (Gibswill, Switzerland)'),
    ('CH-GLL', 'CH-GLL (Gilly, Switzerland)'),
    ('CH-GIS', 'CH-GIS (Gingins, Switzerland)'),
    ('CH-TGO', 'CH-TGO (Giornico, Switzerland)'),
    ('CH-GOF', 'CH-GOF (Gipf-Oberfrick, Switzerland)'),
    ('CH-GIK', 'CH-GIK (Gisikon, Switzerland)'),
    ('CH-GBS', 'CH-GBS (Giubiasco, Switzerland)'),
    ('CH-GSZ', 'CH-GSZ (Givisiez, Switzerland)'),
    ('CH-GIV', 'CH-GIV (Givrins, Switzerland)'),
    ('CH-GAD', 'CH-GAD (Gland, Switzerland)'),
    ('CH-GLA', 'CH-GLA (Glarus, Switzerland)'),
    ('CH-GTG', 'CH-GTG (Glattbrugg, Switzerland)'),
    ('CH-GFN', 'CH-GFN (Glattfelden, Switzerland)'),
    ('CH-GAK', 'CH-GAK (Glattpark, Switzerland)'),
    ('CH-GLO', 'CH-GLO (Glovelier, Switzerland)'),
    ('CH-GLD', 'CH-GLD (Goldach, Switzerland)'),
    ('CH-GOL', 'CH-GOL (Goldau, Switzerland)'),
    ('CH-GIN', 'CH-GIN (Goldingen, Switzerland)'),
    ('CH-GWD', 'CH-GWD (Gommiswald, Switzerland)'),
    ('CH-G7W', 'CH-G7W (Gondiswil, Switzerland)'),
    ('CH-GON', 'CH-GON (Gondo, Switzerland)'),
    ('CH-AGU', 'CH-AGU (Gontenschwil, Switzerland)'),
    ('CH-GOR', 'CH-GOR (Gordola, Switzerland)'),
    ('CH-GRG', 'CH-GRG (Gorgier, Switzerland)'),
    ('CH-GOS', 'CH-GOS (Gossau, Switzerland)'),
    ('CH-ZHH', 'CH-ZHH (Gossau, Switzerland)'),
    ('CH-GTB', 'CH-GTB (Gottlieben, Switzerland)'),
    ('CH-GRB', 'CH-GRB (Grabs, Switzerland)'),
    ('CH-GFR', 'CH-GFR (Grafenried, Switzerland)'),
    ('CH-GNA', 'CH-GNA (Grancia, Switzerland)'),
    ('CH-GL2', 'CH-GL2 (Grand Lancy, Switzerland)'),
    ('CH-GDN', 'CH-GDN (Grandson, Switzerland)'),
    ('CH-GVL', 'CH-GVL (Grandval, Switzerland)'),
    ('CH-GRV', 'CH-GRV (Grandvaux, Switzerland)'),
    ('CH-GVS', 'CH-GVS (Granges, Switzerland)'),
    ('CH-GPA', 'CH-GPA (Granges-Paccot, Switzerland)'),
    ('CH-GPM', 'CH-GPM (Granges-près-Marnand, Switzerland)'),
    ('CH-GRF', 'CH-GRF (Greifensee, Switzerland)'),
    ('CH-GLN', 'CH-GLN (Grellingen, Switzerland)'),
    ('CH-GRN', 'CH-GRN (Grenchen, Switzerland)'),
    ('CH-GRE', 'CH-GRE (Grengiols, Switzerland)'),
    ('CH-GZB', 'CH-GZB (Gretzenbach, Switzerland)'),
    ('CH-GRI', 'CH-GRI (Grindelwald, Switzerland)'),
    ('CH-GNO', 'CH-GNO (Grono, Switzerland)'),
    ('CH-GRO', 'CH-GRO (Grossaffoltern, Switzerland)'),
    ('CH-GWG', 'CH-GWG (Grosswangen, Switzerland)'),
    ('CH-GRR', 'CH-GRR (Grub, Switzerland)'),
    ('CH-GYS', 'CH-GYS (Gruyeres, Switzerland)'),
    ('CH-GNI', 'CH-GNI (Gränichen, Switzerland)'),
    ('CH-GNE', 'CH-GNE (Grône, Switzerland)'),
    ('CH-GNG', 'CH-GNG (Grüningen, Switzerland)'),
    ('CH-GRS', 'CH-GRS (Grüsch, Switzerland)'),
    ('CH-GST', 'CH-GST (Gstaad, Switzerland)'),
    ('CH-GML', 'CH-GML (Gumligen, Switzerland)'),
    ('CH-GZN', 'CH-GZN (Gunzgen, Switzerland)'),
    ('CH-GUR', 'CH-GUR (Gurmels, Switzerland)'),
    ('CH-GWT', 'CH-GWT (Gwatt, Switzerland)'),
    ('CH-GUE', 'CH-GUE (Gümligen, Switzerland)'),
    ('CH-GNS', 'CH-GNS (Günsberg, Switzerland)'),
    ('CH-GTT', 'CH-GTT (Güttingen, Switzerland)'),
    ('CH-HAD', 'CH-HAD (Hadlikon, Switzerland)'),
    ('CH-HLU', 'CH-HLU (Hallau, Switzerland)'),
    ('CH-HAL', 'CH-HAL (Hallwil, Switzerland)'),
    ('CH-HAS', 'CH-HAS (Hasle, Switzerland)'),
    ('CH-HBB', 'CH-HBB (Hasle bei Burgdorf, Switzerland)'),
    ('CH-HRU', 'CH-HRU (Hasle-Rüegsau, Switzerland)'),
    ('CH-HAB', 'CH-HAB (Hausen am Albis, Switzerland)'),
    ('CH-HAU', 'CH-HAU (Hausen bei Brugg, Switzerland)'),
    ('CH-HTE', 'CH-HTE (Hauterive, Switzerland)'),
    ('CH-HED', 'CH-HED (Hedingen, Switzerland)'),
    ('CH-HEE', 'CH-HEE (Heerbrugg, Switzerland)'),
    ('CH-HGA', 'CH-HGA (Hegnau, Switzerland)'),
    ('CH-HEI', 'CH-HEI (Heiden, Switzerland)'),
    ('CH-HMG', 'CH-HMG (Heimberg, Switzerland)'),
    ('CH-HLL', 'CH-HLL (Hellbühl, Switzerland)'),
    ('CH-HNA', 'CH-HNA (Henau, Switzerland)'),
    ('CH-HEN', 'CH-HEN (Henggart, Switzerland)'),
    ('CH-HNZ', 'CH-HNZ (Henniez, Switzerland)'),
    ('CH-HVN', 'CH-HVN (Herbriggen, Switzerland)'),
    ('CH-HGL', 'CH-HGL (Hergiswil, Switzerland)'),
    ('CH-HSA', 'CH-HSA (Herisau, Switzerland)'),
    ('CH-HBG', 'CH-HBG (Herrliberg, Switzerland)'),
    ('CH-HER', 'CH-HER (Herznach, Switzerland)'),
    ('CH-HRZ', 'CH-HRZ (Herzogenbuchsee, Switzerland)'),
    ('CH-HTL', 'CH-HTL (Hettlingen, Switzerland)'),
    ('CH-HIL', 'CH-HIL (Hildisrieden, Switzerland)'),
    ('CH-HLF', 'CH-HLF (Hilfikon, Switzerland)'),
    ('CH-BEH', 'CH-BEH (Hilterfingen, Switzerland)'),
    ('CH-HDK', 'CH-HDK (Hindelbank, Switzerland)'),
    ('CH-HFO', 'CH-HFO (Hinterforst, Switzerland)'),
    ('CH-HNW', 'CH-HNW (Hinwil, Switzerland)'),
    ('CH-HHT', 'CH-HHT (Hirschthal, Switzerland)'),
    ('CH-HZL', 'CH-HZL (Hirzel, Switzerland)'),
    ('CH-HTU', 'CH-HTU (Hittnau, Switzerland)'),
    ('CH-HTK', 'CH-HTK (Hitzkirch, Switzerland)'),
    ('CH-HOC', 'CH-HOC (Hochdorf, Switzerland)'),
    ('CH-HO7', 'CH-HO7 (Hochfelden, Switzerland)'),
    ('CH-HOF', 'CH-HOF (Hofstatt, Switzerland)'),
    ('CH-HOH', 'CH-HOH (Hohenrain, Switzerland)'),
    ('CH-HOL', 'CH-HOL (Holderbank, Switzerland)'),
    ('CH-HOM', 'CH-HOM (Hombrechtikon, Switzerland)'),
    ('CH-HNU', 'CH-HNU (Honau, Switzerland)'),
    ('CH-HOE', 'CH-HOE (Horgen, Switzerland)'),
    ('CH-HOR', 'CH-HOR (Horn, Switzerland)'),
    ('CH-HRW', 'CH-HRW (Horw, Switzerland)'),
    ('CH-HWN', 'CH-HWN (Huntwangen, Switzerland)'),
    ('CH-HZW', 'CH-HZW (Hunzenschwil, Switzerland)'),
    ('CH-HWL', 'CH-HWL (Huttwil, Switzerland)'),
    ('CH-HWI', 'CH-HWI (Huttwilen, Switzerland)'),
    ('CH-HGD', 'CH-HGD (Hägendorf, Switzerland)'),
    ('CH-HAE', 'CH-HAE (Hägglingen, Switzerland)'),
    ('CH-HKN', 'CH-HKN (Härkingen, Switzerland)'),
    ('CH-HSN', 'CH-HSN (Hölstein, Switzerland)'),
    ('CH-HRH', 'CH-HRH (Hörhausen, Switzerland)'),
    ('CH-HRI', 'CH-HRI (Höri, Switzerland)'),
    ('CH-HUN', 'CH-HUN (Hünenberg, Switzerland)'),
    ('CH-HTT', 'CH-HTT (Hüttikon, Switzerland)'),
    ('CH-HUT', 'CH-HUT (Hüttlingen, Switzerland)'),
    ('CH-XZX', 'CH-XZX (Ibach, Switzerland)'),
    ('CH-ILZ', 'CH-ILZ (Ilanz, Switzerland)'),
    ('CH-ILG', 'CH-ILG (Illgau, Switzerland)'),
    ('CH-ILL', 'CH-ILL (Illnau-Effretikon, Switzerland)'),
    ('CH-IMM', 'CH-IMM (Immensee, Switzerland)'),
    ('CH-INS', 'CH-INS (Ins, Switzerland)'),
    ('CH-INT', 'CH-INT (Interlaken, Switzerland)'),
    ('CH-INW', 'CH-INW (Inwil, Switzerland)'),
    ('CH-IPS', 'CH-IPS (Ipsach, Switzerland)'),
    ('CH-IRA', 'CH-IRA (Iragna, Switzerland)'),
    ('CH-ISL', 'CH-ISL (Islikon, Switzerland)'),
    ('CH-BIN', 'CH-BIN (Itingen, Switzerland)'),
    ('CH-ITG', 'CH-ITG (Ittigen, Switzerland)'),
    ('CH-JBG', 'CH-JBG (Jaberg, Switzerland)'),
    ('CH-JGT', 'CH-JGT (Jegenstorf, Switzerland)'),
    ('CH-JNS', 'CH-JNS (Jenins, Switzerland)'),
    ('CH-BEJ', 'CH-BEJ (Jens, Switzerland)'),
    ('CH-JON', 'CH-JON (Jona, Switzerland)'),
    ('CH-JNE', 'CH-JNE (Jonen, Switzerland)'),
    ('CH-JNG', 'CH-JNG (Jongny, Switzerland)'),
    ('CH-JWL', 'CH-JWL (Jonschwil, Switzerland)'),
    ('CH-JXT', 'CH-JXT (Jouxtens-Mézery, Switzerland)'),
    ('CH-JSY', 'CH-JSY (Jussy, Switzerland)'),
    ('CH-KGT', 'CH-KGT (Kaiseraugst, Switzerland)'),
    ('CH-KAI', 'CH-KAI (Kaisten, Switzerland)'),
    ('CH-KNH', 'CH-KNH (Kallnach, Switzerland)'),
    ('CH-KAL', 'CH-KAL (Kaltbrunn, Switzerland)'),
    ('CH-KDG', 'CH-KDG (Kandergrund, Switzerland)'),
    ('CH-KAN', 'CH-KAN (Kandersteg, Switzerland)'),
    ('CH-KAA', 'CH-KAA (Kappel am Albis, Switzerland)'),
    ('CH-KAP', 'CH-KAP (Kappelen, Switzerland)'),
    ('CH-KFO', 'CH-KFO (Kaufdorf, Switzerland)'),
    ('CH-KSZ', 'CH-KSZ (Kehrsatz, Switzerland)'),
    ('CH-KEH', 'CH-KEH (Kemptthal, Switzerland)'),
    ('CH-KER', 'CH-KER (Kerns, Switzerland)'),
    ('CH-KEZ', 'CH-KEZ (Kerzers, Switzerland)'),
    ('CH-KSW', 'CH-KSW (Kesswil, Switzerland)'),
    ('CH-KSO', 'CH-KSO (Kestenholz, Switzerland)'),
    ('CH-KIB', 'CH-KIB (Kienberg, Switzerland)'),
    ('CH-KIE', 'CH-KIE (Kiesen, Switzerland)'),
    ('CH-KIL', 'CH-KIL (Kilchberg, Switzerland)'),
    ('CH-KIW', 'CH-KIW (Killwangen, Switzerland)'),
    ('CH-KHB', 'CH-KHB (Kirchberg, Switzerland)'),
    ('CH-KRG', 'CH-KRG (Kirchberg, Switzerland)'),
    ('CH-KCO', 'CH-KCO (Kirchdorf, Switzerland)'),
    ('CH-KLR', 'CH-KLR (Kirchleerau, Switzerland)'),
    ('CH-BEK', 'CH-BEK (Kirchlindach, Switzerland)'),
    ('CH-KLF', 'CH-KLF (Kleinandelfingen, Switzerland)'),
    ('CH-KBO', 'CH-KBO (Kleinbosingen, Switzerland)'),
    ('CH-KDO', 'CH-KDO (Kleindöttingen, Switzerland)'),
    ('CH-KLL', 'CH-KLL (Kleinlützel, Switzerland)'),
    ('CH-RGU', 'CH-RGU (Klingnau, Switzerland)'),
    ('CH-KLS', 'CH-KLS (Klosters, Switzerland)'),
    ('CH-KTN', 'CH-KTN (Kloten, Switzerland)'),
    ('CH-KNA', 'CH-KNA (Knonau, Switzerland)'),
    ('CH-LEN', 'CH-LEN (Koblenz, Switzerland)'),
    ('CH-KOZ', 'CH-KOZ (Koeniz, Switzerland)'),
    ('CH-K3L', 'CH-K3L (Kollbrunn, Switzerland)'),
    ('CH-KON', 'CH-KON (Konolfingen, Switzerland)'),
    ('CH-KPP', 'CH-KPP (Koppigen, Switzerland)'),
    ('CH-KWI', 'CH-KWI (Kottwil, Switzerland)'),
    ('CH-KRA', 'CH-KRA (Kradolf, Switzerland)'),
    ('CH-KRT', 'CH-KRT (Krauchthal, Switzerland)'),
    ('CH-KRZ', 'CH-KRZ (Kreuzlingen, Switzerland)'),
    ('CH-KRI', 'CH-KRI (Kriegstetten, Switzerland)'),
    ('CH-KRS', 'CH-KRS (Kriens, Switzerland)'),
    ('CH-KSN', 'CH-KSN (Kriessern, Switzerland)'),
    ('CH-KSS', 'CH-KSS (Kussnacht, Switzerland)'),
    ('CH-KOL', 'CH-KOL (Kölliken, Switzerland)'),
    ('CH-KNZ', 'CH-KNZ (Köniz, Switzerland)'),
    ('CH-KNN', 'CH-KNN (Künten, Switzerland)'),
    ('CH-KHH', 'CH-KHH (Küsnacht, Switzerland)'),
    ('CH-KSR', 'CH-KSR (Küssnacht am Rigi, Switzerland)'),
    ('CH-KT5', 'CH-KT5 (Küttigen, Switzerland)'),
    ('CH-ABB', "CH-ABB (L'Abbaye, Switzerland)"),
    ('CH-LOR', "CH-LOR (L'Orient, Switzerland)"),
    ('CH-LAB', 'CH-LAB (La Brévine, Switzerland)'),
    ('CH-LCF', 'CH-LCF (La Chaux-de-Fonds, Switzerland)'),
    ('CH-CDM', 'CH-CDM (La Chaux-du-Milieu, Switzerland)'),
    ('CH-LCV', 'CH-LCV (La Conversion, Switzerland)'),
    ('CH-LCR', 'CH-LCR (La Croix-de-Rozon, Switzerland)'),
    ('CH-CAF', 'CH-CAF (La Côte-aux-Fées, Switzerland)'),
    ('CH-LNE', 'CH-LNE (La Neuveville, Switzerland)'),
    ('CH-PLN', 'CH-PLN (La Plaine, Switzerland)'),
    ('CH-G2E', 'CH-G2E (La Praille, Switzerland)'),
    ('CH-SGN', 'CH-SGN (La Sagne, Switzerland)'),
    ('CH-LSZ', 'CH-LSZ (La Sarraz, Switzerland)'),
    ('CH-SOZ', 'CH-SOZ (La Sonnaz, Switzerland)'),
    ('CH-VTP', 'CH-VTP (La Tour-de-Peilz, Switzerland)'),
    ('CH-TTR', 'CH-TTR (La Tour-De-Trême, Switzerland)'),
    ('CH-LAH', 'CH-LAH (Lachen, Switzerland)'),
    ('CH-LHN', 'CH-LHN (Lachen, Switzerland)'),
    ('CH-LAL', 'CH-LAL (Lalden, Switzerland)'),
    ('CH-LBN', 'CH-LBN (Lamboing, Switzerland)'),
    ('CH-LOE', 'CH-LOE (Lamone, Switzerland)'),
    ('CH-GEL', 'CH-GEL (Lancy, Switzerland)'),
    ('CH-LQU', 'CH-LQU (Landquart, Switzerland)'),
    ('CH-LAD', 'CH-LAD (Langendorf, Switzerland)'),
    ('CH-LAN', 'CH-LAN (Langenthal, Switzerland)'),
    ('CH-LGU', 'CH-LGU (Langnau, Switzerland)'),
    ('CH-LNA', 'CH-LNA (Langnau im Emmental, Switzerland)'),
    ('CH-LRB', 'CH-LRB (Langrickenbach, Switzerland)'),
    ('CH-LNN', 'CH-LNN (Lauenen, Switzerland)'),
    ('CH-LFN', 'CH-LFN (Laufen, Switzerland)'),
    ('CH-LAF', 'CH-LAF (Laufenburg, Switzerland)'),
    ('CH-LPN', 'CH-LPN (Laupen, Switzerland)'),
    ('CH-LAU', 'CH-LAU (Lausanne, Switzerland)'),
    ('CH-LAS', 'CH-LAS (Lausen, Switzerland)'),
    ('CH-LVN', 'CH-LVN (Lavin, Switzerland)'),
    ('CH-LAV', 'CH-LAV (Lavorgo, Switzerland)'),
    ('CH-BRS', 'CH-BRS (Le Brassus, Switzerland)'),
    ('CH-BRY', 'CH-BRY (Le Bry, Switzerland)'),
    ('CH-CGT', 'CH-CGT (Le Chalet-à-Gobet, Switzerland)'),
    ('CH-LCA', 'CH-LCA (Le Châble, Switzerland)'),
    ('CH-CRE', 'CH-CRE (Le Crêt, Switzerland)'),
    ('CH-CLC', 'CH-CLC (Le Crêt-du-Locle, Switzerland)'),
    ('CH-LGS', 'CH-LGS (Le Grand-Saconnex, Switzerland)'),
    ('CH-LDO', 'CH-LDO (Le Landeron, Switzerland)'),
    ('CH-LLV', 'CH-LLV (Le Levron, Switzerland)'),
    ('CH-LLU', 'CH-LLU (Le Lieu, Switzerland)'),
    ('CH-ZJA', 'CH-ZJA (Le Locle, Switzerland)'),
    ('CH-LML', 'CH-LML (Le Mont-sur-Lausanne, Switzerland)'),
    ('CH-LMT', 'CH-LMT (Le Mouret, Switzerland)'),
    ('CH-NOI', 'CH-NOI (Le Noirmont, Switzerland)'),
    ('CH-LSR', 'CH-LSR (Le Sentier, Switzerland)'),
    ('CH-SPY', 'CH-SPY (Le Sépey, Switzerland)'),
    ('CH-LVA', 'CH-LVA (Le Vaud, Switzerland)'),
    ('CH-LBT', 'CH-LBT (Leibstadt, Switzerland)'),
    ('CH-LEG', 'CH-LEG (Leissigen, Switzerland)'),
    ('CH-LNG', 'CH-LNG (Lengnau, Switzerland)'),
    ('CH-LNU', 'CH-LNU (Lengnau, Switzerland)'),
    ('CH-LGO', 'CH-LGO (Lengwil-Oberhofen, Switzerland)'),
    ('CH-LNK', 'CH-LNK (Lenk, Switzerland)'),
    ('CH-LBG', 'CH-LBG (Lenzburg, Switzerland)'),
    ('CH-LNZ', 'CH-LNZ (Lenzerheide, Switzerland)'),
    ('CH-LES', 'CH-LES (Les Acacias, Switzerland)'),
    ('CH-LBS', 'CH-LBS (Les Bois, Switzerland)'),
    ('CH-BRE', 'CH-BRE (Les Brenets, Switzerland)'),
    ('CH-BRX', 'CH-BRX (Les Breuleux, Switzerland)'),
    ('CH-LEC', 'CH-LEC (Les Charbonnieres, Switzerland)'),
    ('CH-LSC', 'CH-LSC (Les Clées, Switzerland)'),
    ('CH-LDB', 'CH-LDB (Les Diablerets, Switzerland)'),
    ('CH-LGC', 'CH-LGC (Les Geneveys-Sur-Coffrane, Switzerland)'),
    ('CH-GNZ', 'CH-GNZ (Les Genevez, Switzerland)'),
    ('CH-LVR', 'CH-LVR (Les Verrières, Switzerland)'),
    ('CH-LGE', 'CH-LGE (Leuggern, Switzerland)'),
    ('CH-LEU', 'CH-LEU (Leuk, Switzerland)'),
    ('CH-LEA', 'CH-LEA (Leutwil, Switzerland)'),
    ('CH-LYN', 'CH-LYN (Leysin, Switzerland)'),
    ('CH-LSG', 'CH-LSG (Lichtensteig, Switzerland)'),
    ('CH-LDD', 'CH-LDD (Liddes, Switzerland)'),
    ('CH-LFL', 'CH-LFL (Liebefeld, Switzerland)'),
    ('CH-LBW', 'CH-LBW (Liebewil, Switzerland)'),
    ('CH-LIE', 'CH-LIE (Liesberg, Switzerland)'),
    ('CH-LTL', 'CH-LTL (Liestal, Switzerland)'),
    ('CH-LGT', 'CH-LGT (Ligornetto, Switzerland)'),
    ('CH-LIU', 'CH-LIU (Lindau, Switzerland)'),
    ('CH-LTH', 'CH-LTH (Linthal, Switzerland)'),
    ('CH-LIT', 'CH-LIT (Littau, Switzerland)'),
    ('CH-LON', 'CH-LON (Locarno, Switzerland)'),
    ('CH-TIL', 'CH-TIL (Lodrino, Switzerland)'),
    ('CH-LAM', 'CH-LAM (Lohn-Ammannsegg, Switzerland)'),
    ('CH-NNG', 'CH-NNG (Lohningen, Switzerland)'),
    ('CH-LOY', 'CH-LOY (Lonay, Switzerland)'),
    ('CH-LSE', 'CH-LSE (Losone, Switzerland)'),
    ('CH-LSF', 'CH-LSF (Lostorf, Switzerland)'),
    ('CH-LOT', 'CH-LOT (Lotzwil, Switzerland)'),
    ('CH-LOU', 'CH-LOU (Lourtier, Switzerland)'),
    ('CH-LCS', 'CH-LCS (Lucens, Switzerland)'),
    ('CH-LUC', 'CH-LUC (Lucerne, Switzerland)'),
    ('CH-LUF', 'CH-LUF (Lufingen, Switzerland)'),
    ('CH-LUG', 'CH-LUG (Lugano, Switzerland)'),
    ('CH-LMN', 'CH-LMN (Lumino, Switzerland)'),
    ('CH-LGN', 'CH-LGN (Lungern, Switzerland)'),
    ('CH-LPG', 'CH-LPG (Lupfig, Switzerland)'),
    ('CH-LUP', 'CH-LUP (Lupsingen, Switzerland)'),
    ('CH-SOL', 'CH-SOL (Lusslingen, Switzerland)'),
    ('CH-LM2', 'CH-LM2 (Lussy-sur-Morges, Switzerland)'),
    ('CH-LRH', 'CH-LRH (Luterbach, Switzerland)'),
    ('CH-LTY', 'CH-LTY (Lutry, Switzerland)'),
    ('CH-LZN', 'CH-LZN (Luzern, Switzerland)'),
    ('CH-LYS', 'CH-LYS (Lyss, Switzerland)'),
    ('CH-LSA', 'CH-LSA (Lyssach, Switzerland)'),
    ('CH-LUB', 'CH-LUB (Lütisburg, Switzerland)'),
    ('CH-BLH', 'CH-BLH (Lützelflüh, Switzerland)'),
    ('CH-MDL', 'CH-MDL (Madetswil, Switzerland)'),
    ('CH-DSW', 'CH-DSW (Madiswil, Switzerland)'),
    ('CH-MDN', 'CH-MDN (Magden, Switzerland)'),
    ('CH-MGL', 'CH-MGL (Magliaso, Switzerland)'),
    ('CH-MNF', 'CH-MNF (Maienfeld, Switzerland)'),
    ('CH-MAS', 'CH-MAS (Malans, Switzerland)'),
    ('CH-MAY', 'CH-MAY (Malleray, Switzerland)'),
    ('CH-MAL', 'CH-MAL (Malters, Switzerland)'),
    ('CH-MAM', 'CH-MAM (Mammern, Switzerland)'),
    ('CH-MNN', 'CH-MNN (Manno, Switzerland)'),
    ('CH-MNE', 'CH-MNE (Marin-Epagnier, Switzerland)'),
    ('CH-MRL', 'CH-MRL (Marly, Switzerland)'),
    ('CH-MRO', 'CH-MRO (Maroggia, Switzerland)'),
    ('CH-MRS', 'CH-MRS (Marsens, Switzerland)'),
    ('CH-MRT', 'CH-MRT (Marthalen, Switzerland)'),
    ('CH-MGY', 'CH-MGY (Martigny, Switzerland)'),
    ('CH-VME', 'CH-VME (Martigny-Ville, Switzerland)'),
    ('CH-MAA', 'CH-MAA (Massagno, Switzerland)'),
    ('CH-MSX', 'CH-MSX (Massongex, Switzerland)'),
    ('CH-MAT', 'CH-MAT (Matran, Switzerland)'),
    ('CH-MTT', 'CH-MTT (Matten bei Interlaken, Switzerland)'),
    ('CH-MAZ', 'CH-MAZ (Matzendorf, Switzerland)'),
    ('CH-MZI', 'CH-MZI (Matzingen, Switzerland)'),
    ('CH-MAU', 'CH-MAU (Maur, Switzerland)'),
    ('CH-MED', 'CH-MED (Medeglia, Switzerland)'),
    ('CH-MEG', 'CH-MEG (Meggen, Switzerland)'),
    ('CH-CHL', 'CH-CHL (Meierskappel, Switzerland)'),
    ('CH-MLN', 'CH-MLN (Meilen, Switzerland)'),
    ('CH-MIR', 'CH-MIR (Meinier, Switzerland)'),
    ('CH-MEI', 'CH-MEI (Meiringen, Switzerland)'),
    ('CH-MWA', 'CH-MWA (Meisterschwanden, Switzerland)'),
    ('CH-MLO', 'CH-MLO (Melano, Switzerland)'),
    ('CH-LGL', 'CH-LGL (Melchnau, Switzerland)'),
    ('CH-JJO', 'CH-JJO (Melide, Switzerland)'),
    ('CH-MLK', 'CH-MLK (Mellikon, Switzerland)'),
    ('CH-MLG', 'CH-MLG (Mellingen, Switzerland)'),
    ('CH-SMS', 'CH-SMS (Mels, Switzerland)'),
    ('CH-MEN', 'CH-MEN (Mendrisio, Switzerland)'),
    ('CH-MZK', 'CH-MZK (Menziken, Switzerland)'),
    ('CH-MZN', 'CH-MZN (Menzingen, Switzerland)'),
    ('CH-MZU', 'CH-MZU (Menznau, Switzerland)'),
    ('CH-MSD', 'CH-MSD (Merenschwand, Switzerland)'),
    ('CH-MHN', 'CH-MHN (Merlischachen, Switzerland)'),
    ('CH-MTM', 'CH-MTM (Mettembert, Switzerland)'),
    ('CH-AS2', 'CH-AS2 (Mettlen, Switzerland)'),
    ('CH-MET', 'CH-MET (Mettmenstetten, Switzerland)'),
    ('CH-MEX', 'CH-MEX (Mex, Switzerland)'),
    ('CH-MEY', 'CH-MEY (Meyrin, Switzerland)'),
    ('CH-MEZ', 'CH-MEZ (Mezzovico, Switzerland)'),
    ('CH-MIG', 'CH-MIG (Miege, Switzerland)'),
    ('CH-MIS', 'CH-MIS (Mies, Switzerland)'),
    ('CH-MVG', 'CH-MVG (Milvignes, Switzerland)'),
    ('CH-MIO', 'CH-MIO (Minusio, Switzerland)'),
    ('CH-MIT', 'CH-MIT (Mitlödi, Switzerland)'),
    ('CH-MOL', 'CH-MOL (Mollis, Switzerland)'),
    ('CH-MPN', 'CH-MPN (Mont Pèlerin, Switzerland)'),
    ('CH-VVD', 'CH-VVD (Mont-Sur-Rolle, Switzerland)'),
    ('CH-MLZ', 'CH-MLZ (Montbrelloz, Switzerland)'),
    ('CH-MDM', 'CH-MDM (Monteggio, Switzerland)'),
    ('CH-MTC', 'CH-MTC (Montfaucon, Switzerland)'),
    ('CH-MON', 'CH-MON (Monthey, Switzerland)'),
    ('CH-MGZ', 'CH-MGZ (Montignez, Switzerland)'),
    ('CH-MNG', 'CH-MNG (Montlingen, Switzerland)'),
    ('CH-MNT', 'CH-MNT (Montreux, Switzerland)'),
    ('CH-MLU', 'CH-MLU (Moosleerau, Switzerland)'),
    ('CH-MSF', 'CH-MSF (Moosseedorf, Switzerland)'),
    ('CH-MOS', 'CH-MOS (Morges, Switzerland)'),
    ('CH-MOR', 'CH-MOR (Morschach, Switzerland)'),
    ('CH-MSE', 'CH-MSE (Mosen, Switzerland)'),
    ('CH-MSG', 'CH-MSG (Mosnang, Switzerland)'),
    ('CH-MOU', 'CH-MOU (Moudon, Switzerland)'),
    ('CH-MTR', 'CH-MTR (Moutier, Switzerland)'),
    ('CH-MOV', 'CH-MOV (Movelier, Switzerland)'),
    ('CH-MUH', 'CH-MUH (Muhen, Switzerland)'),
    ('CH-MBG', 'CH-MBG (Muhleberg, Switzerland)'),
    ('CH-MHR', 'CH-MHR (Muhlruti, Switzerland)'),
    ('CH-MTG', 'CH-MTG (Mullheim Tg, Switzerland)'),
    ('CH-MPF', 'CH-MPF (Mumpf, Switzerland)'),
    ('CH-MUO', 'CH-MUO (Muolen, Switzerland)'),
    ('CH-MTH', 'CH-MTH (Muotathal, Switzerland)'),
    ('CH-MUG', 'CH-MUG (Murg, Switzerland)'),
    ('CH-MRG', 'CH-MRG (Murgenthal, Switzerland)'),
    ('CH-MUR', 'CH-MUR (Muri, Switzerland)'),
    ('CH-MBB', 'CH-MBB (Muri bei Bern, Switzerland)'),
    ('CH-MTN', 'CH-MTN (Murten, Switzerland)'),
    ('CH-MUT', 'CH-MUT (Muttenz, Switzerland)'),
    ('CH-MUZ', 'CH-MUZ (Muzzano, Switzerland)'),
    ('CH-MGW', 'CH-MGW (Mägenwil, Switzerland)'),
    ('CH-MDF', 'CH-MDF (Männedorf, Switzerland)'),
    ('CH-MAR', 'CH-MAR (Märstetten, Switzerland)'),
    ('CH-MAE', 'CH-MAE (Märwil, Switzerland)'),
    ('CH-MOT', 'CH-MOT (Môtiers, Switzerland)'),
    ('CH-MHL', 'CH-MHL (Möhlin, Switzerland)'),
    ('CH-MTF', 'CH-MTF (Mönchaltorf, Switzerland)'),
    ('CH-MOE', 'CH-MOE (Mörel, Switzerland)'),
    ('CH-MKN', 'CH-MKN (Möriken, Switzerland)'),
    ('CH-MWL', 'CH-MWL (Mörschwil, Switzerland)'),
    ('CH-MLL', 'CH-MLL (Müllheim, Switzerland)'),
    ('CH-MLW', 'CH-MLW (Mümliswil, Switzerland)'),
    ('CH-MNB', 'CH-MNB (Münchenbuchsee, Switzerland)'),
    ('CH-MUS', 'CH-MUS (Münchenstein, Switzerland)'),
    ('CH-MWR', 'CH-MWR (Münchenwiler, Switzerland)'),
    ('CH-MUN', 'CH-MUN (Münchwilen, Switzerland)'),
    ('CH-MWI', 'CH-MWI (Münchwilen, Switzerland)'),
    ('CH-MSN', 'CH-MSN (Münsingen, Switzerland)'),
    ('CH-MSL', 'CH-MSL (Münsterlingen, Switzerland)'),
    ('CH-MYY', 'CH-MYY (Müntschemier, Switzerland)'),
    ('CH-MSR', 'CH-MSR (Müstair, Switzerland)'),
    ('CH-MUW', 'CH-MUW (Müswangen, Switzerland)'),
    ('CH-NAT', 'CH-NAT (Naters, Switzerland)'),
    ('CH-NBK', 'CH-NBK (Nebikon, Switzerland)'),
    ('CH-NRH', 'CH-NRH (Neerach, Switzerland)'),
    ('CH-NFH', 'CH-NFH (Neftenbach, Switzerland)'),
    ('CH-NDZ', 'CH-NDZ (Nendaz, Switzerland)'),
    ('CH-NES', 'CH-NES (Nesslau, Switzerland)'),
    ('CH-NTL', 'CH-NTL (Netstal, Switzerland)'),
    ('CH-QNC', 'CH-QNC (Neuchâtel, Switzerland)'),
    ('CH-NER', 'CH-NER (Neudorf, Switzerland)'),
    ('CH-NEU', 'CH-NEU (Neuendorf, Switzerland)'),
    ('CH-NGG', 'CH-NGG (Neuenegg, Switzerland)'),
    ('CH-NHF', 'CH-NHF (Neuenhof, Switzerland)'),
    ('CH-NEK', 'CH-NEK (Neuenkirch, Switzerland)'),
    ('CH-NUS', 'CH-NUS (Neuhaus, Switzerland)'),
    ('CH-NHR', 'CH-NHR (Neuhausen am Rheinfall, Switzerland)'),
    ('CH-NHM', 'CH-NHM (Neuheim, Switzerland)'),
    ('CH-NKS', 'CH-NKS (Neunkirch, Switzerland)'),
    ('CH-NEN', 'CH-NEN (Neuwilen, Switzerland)'),
    ('CH-NYZ', 'CH-NYZ (Neyruz, Switzerland)'),
    ('CH-NDU', 'CH-NDU (Nidau, Switzerland)'),
    ('CH-NDB', 'CH-NDB (Niederbipp, Switzerland)'),
    ('CH-NRN', 'CH-NRN (Niederbuchsiten, Switzerland)'),
    ('CH-NIE', 'CH-NIE (Niederbüren, Switzerland)'),
    ('CH-NBA', 'CH-NBA (Niedererlinsbach, Switzerland)'),
    ('CH-NTT', 'CH-NTT (Niederglatt, Switzerland)'),
    ('CH-NDG', 'CH-NDG (Niedergösgen, Switzerland)'),
    ('CH-NHI', 'CH-NHI (Niederhasli, Switzerland)'),
    ('CH-NLZ', 'CH-NLZ (Niederlenz, Switzerland)'),
    ('CH-NHO', 'CH-NHO (Niederrohrdorf, Switzerland)'),
    ('CH-NUN', 'CH-NUN (Niederurnen, Switzerland)'),
    ('CH-NRL', 'CH-NRL (Niederuzwil, Switzerland)'),
    ('CH-NWA', 'CH-NWA (Niederwangen, Switzerland)'),
    ('CH-NWG', 'CH-NWG (Niederweningen, Switzerland)'),
    ('CH-NWT', 'CH-NWT (Niederwichtrach, Switzerland)'),
    ('CH-NDR', 'CH-NDR (Niederönz, Switzerland)'),
    ('CH-NOR', 'CH-NOR (Noranco, Switzerland)'),
    ('CH-NOT', 'CH-NOT (Nottwil, Switzerland)'),
    ('CH-NOZ', 'CH-NOZ (Novazzano, Switzerland)'),
    ('CH-NUG', 'CH-NUG (Nunningen, Switzerland)'),
    ('CH-NBB', 'CH-NBB (Nussbaumen bei Baden, Switzerland)'),
    ('CH-NYO', 'CH-NYO (Nyon, Switzerland)'),
    ('CH-NEF', 'CH-NEF (Näfels, Switzerland)'),
    ('CH-NKN', 'CH-NKN (Nänikon, Switzerland)'),
    ('CH-NRO', 'CH-NRO (Nürensdorf, Switzerland)'),
    ('CH-URH', 'CH-URH (Ober-Stammheim, Switzerland)'),
    ('CH-ORA', 'CH-ORA (Oberaach, Switzerland)'),
    ('CH-OBP', 'CH-OBP (Oberbipp, Switzerland)'),
    ('CH-OBB', 'CH-OBB (Oberbuchsiten, Switzerland)'),
    ('CH-OBU', 'CH-OBU (Oberburg, Switzerland)'),
    ('CH-OBN', 'CH-OBN (Oberbüren, Switzerland)'),
    ('CH-OEN', 'CH-OEN (Oberbüren, Switzerland)'),
    ('CH-ODI', 'CH-ODI (Oberdiessbach, Switzerland)'),
    ('CH-OEG', 'CH-OEG (Oberengstringen, Switzerland)'),
    ('CH-OFE', 'CH-OFE (Oberentfelden, Switzerland)'),
    ('CH-GEN', 'CH-GEN (Obergerlafingen, Switzerland)'),
    ('CH-ORG', 'CH-ORG (Oberglatt, Switzerland)'),
    ('CH-OGN', 'CH-OGN (Obergösgen, Switzerland)'),
    ('CH-OHI', 'CH-OHI (Oberhasli, Switzerland)'),
    ('CH-OBK', 'CH-OBK (Oberkirch, Switzerland)'),
    ('CH-OBM', 'CH-OBM (Oberkulm, Switzerland)'),
    ('CH-OLH', 'CH-OLH (Oberlunkhofen, Switzerland)'),
    ('CH-ORF', 'CH-ORF (Oberneunforn, Switzerland)'),
    ('CH-ODB', 'CH-ODB (Oberried am Brienzersee, Switzerland)'),
    ('CH-ORN', 'CH-ORN (Oberrieden, Switzerland)'),
    ('CH-ORT', 'CH-ORT (Oberriet, Switzerland)'),
    ('CH-ORD', 'CH-ORD (Oberrohrdorf, Switzerland)'),
    ('CH-XUU', 'CH-XUU (Oberruti, Switzerland)'),
    ('CH-OBS', 'CH-OBS (Obersaxen, Switzerland)'),
    ('CH-OBE', 'CH-OBE (Oberuzwil, Switzerland)'),
    ('CH-OBG', 'CH-OBG (Oberwangen, Switzerland)'),
    ('CH-OBL', 'CH-OBL (Oberwil, Switzerland)'),
    ('CH-OLI', 'CH-OLI (Oberwil-Lieli, Switzerland)'),
    ('CH-OGI', 'CH-OGI (Oberägeri, Switzerland)'),
    ('CH-OFD', 'CH-OFD (Obfelden, Switzerland)'),
    ('CH-OSN', 'CH-OSN (Oensingen, Switzerland)'),
    ('CH-OES', 'CH-OES (Oeschgen, Switzerland)'),
    ('CH-OLS', 'CH-OLS (Oetwil am See, Switzerland)'),
    ('CH-OET', 'CH-OET (Oetwil an der Limmat, Switzerland)'),
    ('CH-OFT', 'CH-OFT (Oftringen, Switzerland)'),
    ('CH-VOO', 'CH-VOO (Ogens, Switzerland)'),
    ('CH-OLV', 'CH-OLV (Olivone, Switzerland)'),
    ('CH-OLO', 'CH-OLO (Ollon, Switzerland)'),
    ('CH-OLT', 'CH-OLT (Olten, Switzerland)'),
    ('CH-ONX', 'CH-ONX (Onex, Switzerland)'),
    ('CH-ONS', 'CH-ONS (Onnens, Switzerland)'),
    ('CH-OFN', 'CH-OFN (Opfikon, Switzerland)'),
    ('CH-OPS', 'CH-OPS (Oppens, Switzerland)'),
    ('CH-ORE', 'CH-ORE (Orbe, Switzerland)'),
    ('CH-OGS', 'CH-OGS (Orges, Switzerland)'),
    ('CH-OLG', 'CH-OLG (Ormalingen, Switzerland)'),
    ('CH-ORV', 'CH-ORV (Oron-la-ville, Switzerland)'),
    ('CH-ORP', 'CH-ORP (Orpund, Switzerland)'),
    ('CH-OVN', 'CH-OVN (Orvin, Switzerland)'),
    ('CH-OBA', 'CH-OBA (Ospizio Bernina, Switzerland)'),
    ('CH-OSG', 'CH-OSG (Ossingen, Switzerland)'),
    ('CH-OMD', 'CH-OMD (Ostermundigen, Switzerland)'),
    ('CH-OFG', 'CH-OFG (Otelfingen, Switzerland)'),
    ('CH-OTH', 'CH-OTH (Othmarsingen, Switzerland)'),
    ('CH-OTT', 'CH-OTT (Ottenbach, Switzerland)'),
    ('CH-OEH', 'CH-OEH (Oulens-sous-Echallens, Switzerland)'),
    ('CH-PVD', 'CH-PVD (Palezieux, Switzerland)'),
    ('CH-PDO', 'CH-PDO (Paradiso, Switzerland)'),
    ('CH-VPD', 'CH-VPD (Paudex, Switzerland)'),
    ('CH-PYE', 'CH-PYE (Payerne, Switzerland)'),
    ('CH-PHZ', 'CH-PHZ (Penthalaz, Switzerland)'),
    ('CH-PEN', 'CH-PEN (Penthaz, Switzerland)'),
    ('CH-LPE', 'CH-LPE (Perlen, Switzerland)'),
    ('CH-PCX', 'CH-PCX (Perly-Certoux, Switzerland)'),
    ('CH-PEO', 'CH-PEO (Perroy, Switzerland)'),
    ('CH-PER', 'CH-PER (Pery, Switzerland)'),
    ('CH-PES', 'CH-PES (Peseux, Switzerland)'),
    ('CH-PET', 'CH-PET (Petit-Lancy, Switzerland)'),
    ('CH-PEY', 'CH-PEY (Peyres-Possens, Switzerland)'),
    ('CH-PFF', 'CH-PFF (Pfaffhausen, Switzerland)'),
    ('CH-PFU', 'CH-PFU (Pfaffnau, Switzerland)'),
    ('CH-ZPN', 'CH-ZPN (Pfungen, Switzerland)'),
    ('CH-PFY', 'CH-PFY (Pfyn, Switzerland)'),
    ('CH-PFA', 'CH-PFA (Pfäffikon, Switzerland)'),
    ('CH-PFK', 'CH-PFK (Pfäffikon, Switzerland)'),
    ('CH-PRL', 'CH-PRL (Pieterlen, Switzerland)'),
    ('CH-PFN', 'CH-PFN (Plaffeien, Switzerland)'),
    ('CH-PLO', 'CH-PLO (Plan-les-Ouates, Switzerland)'),
    ('CH-PLA', 'CH-PLA (Plasselb, Switzerland)'),
    ('CH-PLG', 'CH-PLG (Poliez-le-Grand, Switzerland)'),
    ('CH-PLL', 'CH-PLL (Pollegio, Switzerland)'),
    ('CH-PPA', 'CH-PPA (Pompaples, Switzerland)'),
    ('CH-PTR', 'CH-PTR (Pontresina, Switzerland)'),
    ('CH-PRY', 'CH-PRY (Porrentruy, Switzerland)'),
    ('CH-POT', 'CH-POT (Port, Switzerland)'),
    ('CH-PTD', 'CH-PTD (Portalban-Dessous, Switzerland)'),
    ('CH-POR', 'CH-POR (Porto Ronco, Switzerland)'),
    ('CH-PRZ', 'CH-PRZ (Porza, Switzerland)'),
    ('CH-POS', 'CH-POS (Posieux, Switzerland)'),
    ('CH-PGS', 'CH-PGS (Prangins, Switzerland)'),
    ('CH-PRD', 'CH-PRD (Praratoud, Switzerland)'),
    ('CH-ATT', 'CH-ATT (Pratteln, Switzerland)'),
    ('CH-PRA', 'CH-PRA (Praz, Switzerland)'),
    ('CH-PRI', 'CH-PRI (Prilly, Switzerland)'),
    ('CH-PRS', 'CH-PRS (Préverenges, Switzerland)'),
    ('CH-PDX', 'CH-PDX (Puidoux, Switzerland)'),
    ('CH-PLY', 'CH-PLY (Pully, Switzerland)'),
    ('CH-PUB', 'CH-PUB (Puplinge, Switzerland)'),
    ('CH-QUA', 'CH-QUA (Quartino, Switzerland)'),
    ('CH-RFZ', 'CH-RFZ (Rafz, Switzerland)'),
    ('CH-RAM', 'CH-RAM (Ramsen, Switzerland)'),
    ('CH-RCT', 'CH-RCT (Rancate, Switzerland)'),
    ('CH-ZJW', 'CH-ZJW (Rapperswil, Switzerland)'),
    ('CH-RRN', 'CH-RRN (Raron, Switzerland)'),
    ('CH-RTA', 'CH-RTA (Realta, Switzerland)'),
    ('CH-RBV', 'CH-RBV (Rebeuvelier, Switzerland)'),
    ('CH-RBS', 'CH-RBS (Rebstein, Switzerland)'),
    ('CH-RCK', 'CH-RCK (Reckingen, Switzerland)'),
    ('CH-VIX', 'CH-VIX (Reconvilier, Switzerland)'),
    ('CH-RGF', 'CH-RGF (Regensdorf, Switzerland)'),
    ('CH-REH', 'CH-REH (Rehetobel, Switzerland)'),
    ('CH-RNB', 'CH-RNB (Reichenbach, Switzerland)'),
    ('CH-RBG', 'CH-RBG (Reichenburg, Switzerland)'),
    ('CH-REI', 'CH-REI (Reiden, Switzerland)'),
    ('CH-RCH', 'CH-RCH (Reinach, Switzerland)'),
    ('CH-REN', 'CH-REN (Reinach, Switzerland)'),
    ('CH-RTN', 'CH-RTN (Reitnau, Switzerland)'),
    ('CH-RKG', 'CH-RKG (Rekingen, Switzerland)'),
    ('CH-RMF', 'CH-RMF (Remaufens, Switzerland)'),
    ('CH-RMG', 'CH-RMG (Remigen, Switzerland)'),
    ('CH-RNN', 'CH-RNN (Renan, Switzerland)'),
    ('CH-RHW', 'CH-RHW (Renens, Switzerland)'),
    ('CH-RBU', 'CH-RBU (Reussbühl, Switzerland)'),
    ('CH-REU', 'CH-REU (Reutigen, Switzerland)'),
    ('CH-REV', 'CH-REV (Reverolle, Switzerland)'),
    ('CH-RNK', 'CH-RNK (Rheineck, Switzerland)'),
    ('CH-RFD', 'CH-RFD (Rheinfelden, Switzerland)'),
    ('CH-RZO', 'CH-RZO (Riazzino, Switzerland)'),
    ('CH-RIC', 'CH-RIC (Richterswil, Switzerland)'),
    ('CH-RBH', 'CH-RBH (Rickenbach, Switzerland)'),
    ('CH-RHI', 'CH-RHI (Rickenbach, Switzerland)'),
    ('CH-RKB', 'CH-RKB (Rickenbach-Attikon, Switzerland)'),
    ('CH-RID', 'CH-RID (Riddes, Switzerland)'),
    ('CH-RBK', 'CH-RBK (Ried bei Kerzers, Switzerland)'),
    ('CH-RDN', 'CH-RDN (Riedern, Switzerland)'),
    ('CH-RIE', 'CH-RIE (Riedholz, Switzerland)'),
    ('CH-RHN', 'CH-RHN (Riehen, Switzerland)'),
    ('CH-RIF', 'CH-RIF (Rifferswil, Switzerland)'),
    ('CH-Z5R', 'CH-Z5R (Rikon, Switzerland)'),
    ('CH-XXX', 'CH-XXX (RIS Inland waterways, Switzerland)'),
    ('CH-RSV', 'CH-RSV (Riva San Vitale, Switzerland)'),
    ('CH-RVZ', 'CH-RVZ (Rivaz, Switzerland)'),
    ('CH-RDD', 'CH-RDD (Rodersdorf, Switzerland)'),
    ('CH-RWL', 'CH-RWL (Roggliswil, Switzerland)'),
    ('CH-RGW', 'CH-RGW (Roggwil, Switzerland)'),
    ('CH-ROW', 'CH-ROW (Roggwil, Switzerland)'),
    ('CH-ROH', 'CH-ROH (Rohrbach, Switzerland)'),
    ('CH-ROL', 'CH-ROL (Rolle, Switzerland)'),
    ('CH-RSL', 'CH-RSL (Romanel-sur-Lausanne, Switzerland)'),
    ('CH-RSM', 'CH-RSM (Romanel-sur-Morges, Switzerland)'),
    ('CH-RMH', 'CH-RMH (Romanshorn, Switzerland)'),
    ('CH-ROM', 'CH-ROM (Romont, Switzerland)'),
    ('CH-ROO', 'CH-ROO (Root, Switzerland)'),
    ('CH-ROP', 'CH-ROP (Ropraz, Switzerland)'),
    ('CH-RRB', 'CH-RRB (Rorbas, Switzerland)'),
    ('CH-RRC', 'CH-RRC (Rorschach, Switzerland)'),
    ('CH-ROR', 'CH-ROR (Rorschacherberg, Switzerland)'),
    ('CH-ROS', 'CH-ROS (Rossens, Switzerland)'),
    ('CH-RER', 'CH-RER (Rossiniere, Switzerland)'),
    ('CH-ROT', 'CH-ROT (Rothenburg, Switzerland)'),
    ('CH-RTM', 'CH-RTM (Rothenthurm, Switzerland)'),
    ('CH-RTR', 'CH-RTR (Rothrist, Switzerland)'),
    ('CH-RTZ', 'CH-RTZ (Rotkreuz, Switzerland)'),
    ('CH-RGT', 'CH-RGT (Rougemont, Switzerland)'),
    ('CH-ROV', 'CH-ROV (Roveredo, Switzerland)'),
    ('CH-RUB', 'CH-RUB (Rubigen, Switzerland)'),
    ('CH-RUD', 'CH-RUD (Rudolfstetten, Switzerland)'),
    ('CH-RES', 'CH-RES (Rueyres, Switzerland)'),
    ('CH-RMK', 'CH-RMK (Rumikon, Switzerland)'),
    ('CH-RPP', 'CH-RPP (Rupperswil, Switzerland)'),
    ('CH-RSS', 'CH-RSS (Russikon, Switzerland)'),
    ('CH-RSW', 'CH-RSW (Ruswil, Switzerland)'),
    ('CH-RLA', 'CH-RLA (Ruvigliana, Switzerland)'),
    ('CH-RAH', 'CH-RAH (Rüdtligen-Alchenflüh, Switzerland)'),
    ('CH-EGB', 'CH-EGB (Rüeggisberg, Switzerland)'),
    ('CH-RUE', 'CH-RUE (Rüegsauschachen, Switzerland)'),
    ('CH-RFH', 'CH-RFH (Rüfenacht, Switzerland)'),
    ('CH-RMA', 'CH-RMA (Rümlang, Switzerland)'),
    ('CH-RUG', 'CH-RUG (Rüschegg, Switzerland)'),
    ('CH-RSN', 'CH-RSN (Rüschlikon, Switzerland)'),
    ('CH-RTH', 'CH-RTH (Rüthi, Switzerland)'),
    ('CH-RTI', 'CH-RTI (Rüti, Switzerland)'),
    ('CH-RUI', 'CH-RUI (Rüti, Switzerland)'),
    ('CH-RTB', 'CH-RTB (Rüti bei Büren, Switzerland)'),
    ('CH-SAA', 'CH-SAA (Saanen, Switzerland)'),
    ('CH-SFE', 'CH-SFE (Saas-Fee, Switzerland)'),
    ('CH-OSA', 'CH-OSA (Sachseln, Switzerland)'),
    ('CH-SAF', 'CH-SAF (Safenwil, Switzerland)'),
    ('CH-SFR', 'CH-SFR (Safnern, Switzerland)'),
    ('CH-SGL', 'CH-SGL (Saignelégier, Switzerland)'),
    ('CH-SAB', 'CH-SAB (Saint Blaise, Switzerland)'),
    ('CH-SMV', 'CH-SMV (Saint Moritz, Switzerland)'),
    ('CH-SAS', 'CH-SAS (Saint-Aubin-Sauges, Switzerland)'),
    ('CH-VCC', 'CH-VCC (Saint-Barthelemy, Switzerland)'),
    ('CH-SIM', 'CH-SIM (Saint-Imier, Switzerland)'),
    ('CH-SEC', 'CH-SEC (Saint-Légier-La Chiésaz, Switzerland)'),
    ('CH-SPR', 'CH-SPR (Saint-Prex, Switzerland)'),
    ('CH-SSV', 'CH-SSV (Saint-Sulpice, Switzerland)'),
    ('CH-SUN', 'CH-SUN (Saint-Ursanne, Switzerland)'),
    ('CH-SCX', 'CH-SCX (Sainte Croix, Switzerland)'),
    ('CH-SVX', 'CH-SVX (Salavaux, Switzerland)'),
    ('CH-TTG', 'CH-TTG (Salenstein, Switzerland)'),
    ('CH-SLS', 'CH-SLS (Sales, Switzerland)'),
    ('CH-GES', 'CH-GES (Salgesch, Switzerland)'),
    ('CH-SAL', 'CH-SAL (Salmsach, Switzerland)'),
    ('CH-SLN', 'CH-SLN (Salvan, Switzerland)'),
    ('CH-SAM', 'CH-SAM (Samedan, Switzerland)'),
    ('CH-SST', 'CH-SST (Samstagern, Switzerland)'),
    ('CH-SVI', 'CH-SVI (San Vittore, Switzerland)'),
    ('CH-QGL', 'CH-QGL (Sankt Gallen, Switzerland)'),
    ('CH-STM', 'CH-STM (Sankt Margrethen, Switzerland)'),
    ('CH-SMA', 'CH-SMA (Sankt Maurice, Switzerland)'),
    ('CH-NKL', 'CH-NKL (Sankt Niklaus, Switzerland)'),
    ('CH-SBD', "CH-SBD (Sant'Abbondio, Switzerland)"),
    ('CH-SNO', "CH-SNO (Sant'Antonino, Switzerland)"),
    ('CH-SMI', 'CH-SMI (Santa Maria, Switzerland)'),
    ('CH-SAR', 'CH-SAR (Sargans, Switzerland)'),
    ('CH-SNN', 'CH-SNN (Sarnen, Switzerland)'),
    ('CH-SAT', 'CH-SAT (Satigny, Switzerland)'),
    ('CH-SAV', 'CH-SAV (Savigny, Switzerland)'),
    ('CH-SVS', 'CH-SVS (Savièse, Switzerland)'),
    ('CH-SVG', 'CH-SVG (Savognin, Switzerland)'),
    ('CH-SVA', 'CH-SVA (Savosa, Switzerland)'),
    ('CH-SXN', 'CH-SXN (Saxon, Switzerland)'),
    ('CH-SHH', 'CH-SHH (Schachen, Switzerland)'),
    ('CH-SCH', 'CH-SCH (Schaffhausen, Switzerland)'),
    ('CH-SFM', 'CH-SFM (Schafisheim, Switzerland)'),
    ('CH-SNU', 'CH-SNU (Schangnau, Switzerland)'),
    ('CH-SNS', 'CH-SNS (Schanis, Switzerland)'),
    ('CH-USF', 'CH-USF (Schattdorf, Switzerland)'),
    ('CH-SEN', 'CH-SEN (Schenkon, Switzerland)'),
    ('CH-SRZ', 'CH-SRZ (Scherz, Switzerland)'),
    ('CH-SCG', 'CH-SCG (Scherzingen, Switzerland)'),
    ('CH-SC9', 'CH-SC9 (Schiers, Switzerland)'),
    ('CH-SGI', 'CH-SGI (Schindellegi, Switzerland)'),
    ('CH-SNB', 'CH-SNB (Schinznach Bad, Switzerland)'),
    ('CH-SCD', 'CH-SCD (Schinznach Dorf, Switzerland)'),
    ('CH-SHT', 'CH-SHT (Schlatt, Switzerland)'),
    ('CH-SLI', 'CH-SLI (Schlattingen, Switzerland)'),
    ('CH-SHR', 'CH-SHR (Schlieren, Switzerland)'),
    ('CH-SCK', 'CH-SCK (Schmerikon, Switzerland)'),
    ('CH-SMK', 'CH-SMK (Schmerikon, Switzerland)'),
    ('CH-SCM', 'CH-SCM (Schmitten, Switzerland)'),
    ('CH-SNG', 'CH-SNG (Schoenenberg, Switzerland)'),
    ('CH-SOE', 'CH-SOE (Schonried, Switzerland)'),
    ('CH-SHZ', 'CH-SHZ (Schotz, Switzerland)'),
    ('CH-SDR', 'CH-SDR (Schwadernau, Switzerland)'),
    ('CH-SDN', 'CH-SDN (Schwanden, Switzerland)'),
    ('CH-SWH', 'CH-SWH (Schwarzenbach, Switzerland)'),
    ('CH-SZB', 'CH-SZB (Schwarzenburg, Switzerland)'),
    ('CH-WEI', 'CH-WEI (Schweizerhalle, Switzerland)'),
    ('CH-SCW', 'CH-SCW (Schwellbrunn, Switzerland)'),
    ('CH-SWB', 'CH-SWB (Schwerzenbach, Switzerland)'),
    ('CH-SCZ', 'CH-SCZ (Schwyz, Switzerland)'),
    ('CH-SFL', 'CH-SFL (Schöftland, Switzerland)'),
    ('CH-SBL', 'CH-SBL (Schönbühl, Switzerland)'),
    ('CH-SGT', 'CH-SGT (Schönenberg, Switzerland)'),
    ('CH-SBC', 'CH-SBC (Schönenbuch, Switzerland)'),
    ('CH-SOH', 'CH-SOH (Schönenbuch, Switzerland)'),
    ('CH-SHB', 'CH-SHB (Schönengrund, Switzerland)'),
    ('CH-SWD', 'CH-SWD (Schönenwerd, Switzerland)'),
    ('CH-SBB', 'CH-SBB (Schübelbach, Switzerland)'),
    ('CH-SBH', 'CH-SBH (Schüpbach, Switzerland)'),
    ('CH-SFN', 'CH-SFN (Schüpfen, Switzerland)'),
    ('CH-SPF', 'CH-SPF (Schüpfheim, Switzerland)'),
    ('CH-SCU', 'CH-SCU (Scuol, Switzerland)'),
    ('CH-SEE', 'CH-SEE (Seegraeben, Switzerland)'),
    ('CH-SGZ', 'CH-SGZ (Seengen, Switzerland)'),
    ('CH-SWE', 'CH-SWE (Seewen, Switzerland)'),
    ('CH-SWN', 'CH-SWN (Seewen, Switzerland)'),
    ('CH-SEF', 'CH-SEF (Seftigen, Switzerland)'),
    ('CH-SLZ', 'CH-SLZ (Selzach, Switzerland)'),
    ('CH-SMB', 'CH-SMB (Sembrancher, Switzerland)'),
    ('CH-SPA', 'CH-SPA (Sempach, Switzerland)'),
    ('CH-SPS', 'CH-SPS (Sempach Station, Switzerland)'),
    ('CH-SEM', 'CH-SEM (Semsales, Switzerland)'),
    ('CH-ZSF', 'CH-ZSF (Sennhof, Switzerland)'),
    ('CH-SND', 'CH-SND (Sennwald, Switzerland)'),
    ('CH-SNT', 'CH-SNT (Sent, Switzerland)'),
    ('CH-SEO', 'CH-SEO (Seon, Switzerland)'),
    ('CH-SUZ', 'CH-SUZ (Seuzach, Switzerland)'),
    ('CH-SVN', 'CH-SVN (Sevelen, Switzerland)'),
    ('CH-SBN', 'CH-SBN (Siebnen, Switzerland)'),
    ('CH-SIE', 'CH-SIE (Siegershausen, Switzerland)'),
    ('CH-SRR', 'CH-SRR (Sierre, Switzerland)'),
    ('CH-SGO', 'CH-SGO (Sigirino, Switzerland)'),
    ('CH-FGT', 'CH-FGT (Siglistorf, Switzerland)'),
    ('CH-SIY', 'CH-SIY (Signy-Avenex, Switzerland)'),
    ('CH-SRU', 'CH-SRU (Sihlbrugg, Switzerland)'),
    ('CH-SHG', 'CH-SHG (Sihlbrugg Dorf, Switzerland)'),
    ('CH-SVP', 'CH-SVP (Silvaplana, Switzerland)'),
    ('CH-SIN', 'CH-SIN (Sins, Switzerland)'),
    ('CH-SIR', 'CH-SIR (Sion, Switzerland)'),
    ('CH-SNH', 'CH-SNH (Sirnach, Switzerland)'),
    ('CH-SSH', 'CH-SSH (Sissach, Switzerland)'),
    ('CH-SIS', 'CH-SIS (Sisseln, Switzerland)'),
    ('CH-SSS', 'CH-SSS (Sisseln AG, Switzerland)'),
    ('CH-SID', 'CH-SID (Sitterdorf, Switzerland)'),
    ('CH-FSZ', 'CH-FSZ (Siviriez, Switzerland)'),
    ('CH-SOO', 'CH-SOO (Solothurn, Switzerland)'),
    ('CH-SOM', 'CH-SOM (Someo, Switzerland)'),
    ('CH-SMM', 'CH-SMM (Sommeri, Switzerland)'),
    ('CH-SZS', 'CH-SZS (Sonceboz-Sombeval, Switzerland)'),
    ('CH-SOR', 'CH-SOR (Sorens, Switzerland)'),
    ('CH-SOY', 'CH-SOY (Soyhieres, Switzerland)'),
    ('CH-SCR', 'CH-SCR (Speicher, Switzerland)'),
    ('CH-SPZ', 'CH-SPZ (Spiez, Switzerland)'),
    ('CH-SPB', 'CH-SPB (Spreitenbach, Switzerland)'),
    ('CH-NLS', 'CH-NLS (St Niklausen, Switzerland)'),
    ('CH-ANT', 'CH-ANT (St. Antoni, Switzerland)'),
    ('CH-URS', 'CH-URS (St. Ursen, Switzerland)'),
    ('CH-SBO', 'CH-SBO (Stabio, Switzerland)'),
    ('CH-SDL', 'CH-SDL (Stadel, Switzerland)'),
    ('CH-OBW', 'CH-OBW (Stalden, Switzerland)'),
    ('CH-STK', 'CH-STK (Stallikon, Switzerland)'),
    ('CH-SAN', 'CH-SAN (Stans, Switzerland)'),
    ('CH-STA', 'CH-STA (Stansstad, Switzerland)'),
    ('CH-STC', 'CH-STC (Steckborn, Switzerland)'),
    ('CH-SBG', 'CH-SBG (Steffisburg, Switzerland)'),
    ('CH-STG', 'CH-STG (Steg, Switzerland)'),
    ('CH-STN', 'CH-STN (Stein, Switzerland)'),
    ('CH-TGS', 'CH-TGS (Stein am Rhein, Switzerland)'),
    ('CH-STE', 'CH-STE (Steinach, Switzerland)'),
    ('CH-STB', 'CH-STB (Steinebrunn, Switzerland)'),
    ('CH-SNE', 'CH-SNE (Steinen, Switzerland)'),
    ('CH-STI', 'CH-STI (Steinhausen, Switzerland)'),
    ('CH-SMR', 'CH-SMR (Steinmaur, Switzerland)'),
    ('CH-ZSG', 'CH-ZSG (Sternenberg, Switzerland)'),
    ('CH-STT', 'CH-STT (Stetten, Switzerland)'),
    ('CH-STF', 'CH-STF (Stettfurt, Switzerland)'),
    ('CH-STL', 'CH-STL (Stettlen, Switzerland)'),
    ('CH-STO', 'CH-STO (Stoos, Switzerland)'),
    ('CH-SGB', 'CH-SGB (Strengelbach, Switzerland)'),
    ('CH-STU', 'CH-STU (Studen, Switzerland)'),
    ('CH-SFA', 'CH-SFA (Stäfa, Switzerland)'),
    ('CH-SOK', 'CH-SOK (Stüsslingen, Switzerland)'),
    ('CH-SBE', 'CH-SBE (Suberg, Switzerland)'),
    ('CH-SBI', 'CH-SBI (Subingen, Switzerland)'),
    ('CH-SCY', 'CH-SCY (Suchy, Switzerland)'),
    ('CH-SUG', 'CH-SUG (Sugiez, Switzerland)'),
    ('CH-HSR', 'CH-HSR (Suhr, Switzerland)'),
    ('CH-SGE', 'CH-SGE (Sulgen, Switzerland)'),
    ('CH-SVD', 'CH-SVD (Sullens, Switzerland)'),
    ('CH-SMW', 'CH-SMW (Sumiswald, Switzerland)'),
    ('CH-SUR', 'CH-SUR (Sursee, Switzerland)'),
    ('CH-SSC', 'CH-SSC (Susch, Switzerland)'),
    ('CH-SUT', 'CH-SUT (Sutz-Lattrigen, Switzerland)'),
    ('CH-SVZ', 'CH-SVZ (Sévaz, Switzerland)'),
    ('CH-TAF', 'CH-TAF (Tafers, Switzerland)'),
    ('CH-TWG', 'CH-TWG (Tagelswangen, Switzerland)'),
    ('CH-TGN', 'CH-TGN (Tartegnin, Switzerland)'),
    ('CH-TAR', 'CH-TAR (Taufen, Switzerland)'),
    ('CH-TVS', 'CH-TVS (Tavannes, Switzerland)'),
    ('CH-TVR', 'CH-TVR (Taverne, Switzerland)'),
    ('CH-TGF', 'CH-TGF (Tegerfelden, Switzerland)'),
    ('CH-TEN', 'CH-TEN (Tenero, Switzerland)'),
    ('CH-TNK', 'CH-TNK (Tenniken, Switzerland)'),
    ('CH-TTL', 'CH-TTL (Tentlingen, Switzerland)'),
    ('CH-TMN', 'CH-TMN (Termen, Switzerland)'),
    ('CH-TFN', 'CH-TFN (Teufen, Switzerland)'),
    ('CH-TEU', 'CH-TEU (Teufenthal, Switzerland)'),
    ('CH-THL', 'CH-THL (Thal, Switzerland)'),
    ('CH-THI', 'CH-THI (Thalheim, Switzerland)'),
    ('CH-TWL', 'CH-TWL (Thalwil, Switzerland)'),
    ('CH-THA', 'CH-THA (Thayngen, Switzerland)'),
    ('CH-THW', 'CH-THW (Therwil, Switzerland)'),
    ('CH-TNX', 'CH-TNX (Thonex, Switzerland)'),
    ('CH-THU', 'CH-THU (Thun, Switzerland)'),
    ('CH-THD', 'CH-THD (Thundorf, Switzerland)'),
    ('CH-THS', 'CH-THS (Thusis, Switzerland)'),
    ('CH-TRG', 'CH-TRG (Thörigen, Switzerland)'),
    ('CH-CHT', 'CH-CHT (Thörishaus, Switzerland)'),
    ('CH-THR', 'CH-THR (Thürnen, Switzerland)'),
    ('CH-TOB', 'CH-TOB (Tobel, Switzerland)'),
    ('CH-TOF', 'CH-TOF (Toffen, Switzerland)'),
    ('CH-THZ', 'CH-THZ (Tolochenaz, Switzerland)'),
    ('CH-TON', 'CH-TON (Torgon, Switzerland)'),
    ('CH-TIC', 'CH-TIC (Torre, Switzerland)'),
    ('CH-TM2', 'CH-TM2 (Tramelan, Switzerland)'),
    ('CH-TSD', 'CH-TSD (Trasadingen, Switzerland)'),
    ('CH-TRA', 'CH-TRA (Travers, Switzerland)'),
    ('CH-TRE', 'CH-TRE (Treyvaux, Switzerland)'),
    ('CH-TNG', 'CH-TNG (Triengen, Switzerland)'),
    ('CH-TBS', 'CH-TBS (Trimbach, Switzerland)'),
    ('CH-TRS', 'CH-TRS (Trimmis, Switzerland)'),
    ('CH-TRI', 'CH-TRI (Trin, Switzerland)'),
    ('CH-TRT', 'CH-TRT (Troistorrents, Switzerland)'),
    ('CH-TSA', 'CH-TSA (Trubschachen, Switzerland)'),
    ('CH-TRX', 'CH-TRX (Trélex, Switzerland)'),
    ('CH-TBH', 'CH-TBH (Trübbach, Switzerland)'),
    ('CH-TSC', 'CH-TSC (Tschiertschen, Switzerland)'),
    ('CH-TUG', 'CH-TUG (Tuggen, Switzerland)'),
    ('CH-TUR', 'CH-TUR (Turbenthal, Switzerland)'),
    ('CH-TGI', 'CH-TGI (Turgi, Switzerland)'),
    ('CH-TUM', 'CH-TUM (Turtmann, Switzerland)'),
    ('CH-TAN', 'CH-TAN (Twann, Switzerland)'),
    ('CH-TGC', 'CH-TGC (Tägerschen, Switzerland)'),
    ('CH-TWN', 'CH-TWN (Tägerwilen, Switzerland)'),
    ('CH-TUB', 'CH-TUB (Tübach, Switzerland)'),
    ('CH-UDL', 'CH-UDL (Udligenswil, Switzerland)'),
    ('CH-UEN', 'CH-UEN (Ueken, Switzerland)'),
    ('CH-UER', 'CH-UER (Uerikon, Switzerland)'),
    ('CH-UGN', 'CH-UGN (Uesslingen, Switzerland)'),
    ('CH-UTF', 'CH-UTF (Uetendorf, Switzerland)'),
    ('CH-UKS', 'CH-UKS (Uetikon am See, Switzerland)'),
    ('CH-UKN', 'CH-UKN (Uitikon, Switzerland)'),
    ('CH-ZUR', 'CH-ZUR (Unter-Stammheim, Switzerland)'),
    ('CH-UNB', 'CH-UNB (Unterbach, Switzerland)'),
    ('CH-UGE', 'CH-UGE (Unterengstringen, Switzerland)'),
    ('CH-7AU', 'CH-7AU (Unterentfelden, Switzerland)'),
    ('CH-UTB', 'CH-UTB (Unteriberg, Switzerland)'),
    ('CH-UTK', 'CH-UTK (Unterkulm, Switzerland)'),
    ('CH-UTS', 'CH-UTS (Unterseen, Switzerland)'),
    ('CH-UGA', 'CH-UGA (Untersiggenthal, Switzerland)'),
    ('CH-UTR', 'CH-UTR (Unterägeri, Switzerland)'),
    ('CH-URD', 'CH-URD (Urdorf, Switzerland)'),
    ('CH-URN', 'CH-URN (Urnäsch, Switzerland)'),
    ('CH-UNH', 'CH-UNH (Ursenbach, Switzerland)'),
    ('CH-USY', 'CH-USY (Ursy, Switzerland)'),
    ('CH-USR', 'CH-USR (Uster, Switzerland)'),
    ('CH-UTT', 'CH-UTT (Uttwil, Switzerland)'),
    ('CH-TZE', 'CH-TZE (Utzenstorf, Switzerland)'),
    ('CH-UZN', 'CH-UZN (Uznach, Switzerland)'),
    ('CH-UZW', 'CH-UZW (Uzwil, Switzerland)'),
    ('CH-SVO', 'CH-SVO (Vacallo, Switzerland)'),
    ('CH-VDR', 'CH-VDR (Val-de-Ruz, Switzerland)'),
    ('CH-VG3', 'CH-VG3 (Valangin, Switzerland)'),
    ('CH-4VM', 'CH-4VM (Valeyres-sous-Montagny, Switzerland)'),
    ('CH-VLM', 'CH-VLM (Vallamand, Switzerland)'),
    ('CH-VAL', 'CH-VAL (Vallorbe, Switzerland)'),
    ('CH-VA5', 'CH-VA5 (Vals, Switzerland)'),
    ('CH-VDO', 'CH-VDO (Vandoeuvres, Switzerland)'),
    ('CH-VFN', 'CH-VFN (Vauffelin, Switzerland)'),
    ('CH-VAU', 'CH-VAU (Vaumarcus, Switzerland)'),
    ('CH-VEN', 'CH-VEN (Vendlincourt, Switzerland)'),
    ('CH-VTH', 'CH-VTH (Venthône, Switzerland)'),
    ('CH-VER', 'CH-VER (Verbier, Switzerland)'),
    ('CH-VNR', 'CH-VNR (Vernier, Switzerland)'),
    ('CH-VSX', 'CH-VSX (Versoix, Switzerland)'),
    ('CH-VSY', 'CH-VSY (Vessy, Switzerland)'),
    ('CH-ZKZ', 'CH-ZKZ (Vevey, Switzerland)'),
    ('CH-VEZ', 'CH-VEZ (Vezia, Switzerland)'),
    ('CH-VLA', 'CH-VLA (Vilars, Switzerland)'),
    ('CH-VSC', 'CH-VSC (Villars-Sainte-Croix, Switzerland)'),
    ('CH-VSG', 'CH-VSG (Villars-sur-Glâne, Switzerland)'),
    ('CH-VIL', 'CH-VIL (Villars-sur-Ollon, Switzerland)'),
    ('CH-VS5', 'CH-VS5 (Villaz-Saint-Pierre, Switzerland)'),
    ('CH-VLE', 'CH-VLE (Villeneuve, Switzerland)'),
    ('CH-VIT', 'CH-VIT (Villeret, Switzerland)'),
    ('CH-3DV', 'CH-3DV (Villette, Switzerland)'),
    ('CH-VI2', 'CH-VI2 (Villiers, Switzerland)'),
    ('CH-VLG', 'CH-VLG (Villigen, Switzerland)'),
    ('CH-VMG', 'CH-VMG (Villmergen, Switzerland)'),
    ('CH-VSN', 'CH-VSN (Villorsonnens, Switzerland)'),
    ('CH-VLT', 'CH-VLT (Vilters, Switzerland)'),
    ('CH-VZL', 'CH-VZL (Vinzel, Switzerland)'),
    ('CH-VNZ', 'CH-VNZ (Vionnaz, Switzerland)'),
    ('CH-VIS', 'CH-VIS (Visp, Switzerland)'),
    ('CH-VSO', 'CH-VSO (Vissoie, Switzerland)'),
    ('CH-VZU', 'CH-VZU (Vitznau, Switzerland)'),
    ('CH-VGO', 'CH-VGO (Vogorno, Switzerland)'),
    ('CH-VKI', 'CH-VKI (Volketswil, Switzerland)'),
    ('CH-VRM', 'CH-VRM (Vordemwald, Switzerland)'),
    ('CH-VVY', 'CH-VVY (Vouvry, Switzerland)'),
    ('CH-VUD', 'CH-VUD (Vuadens, Switzerland)'),
    ('CH-VHS', 'CH-VHS (Vucherens, Switzerland)'),
    ('CH-VLV', 'CH-VLV (Vufflens-la-Ville, Switzerland)'),
    ('CH-VUI', 'CH-VUI (Vuiteboeuf, Switzerland)'),
    ('CH-VLL', 'CH-VLL (Vulliens, Switzerland)'),
    ('CH-VUS', 'CH-VUS (Vullierens, Switzerland)'),
    ('CH-VSZ', 'CH-VSZ (Vésenaz, Switzerland)'),
    ('CH-VTZ', 'CH-VTZ (Vétroz, Switzerland)'),
    ('CH-WBR', 'CH-WBR (Wabern, Switzerland)'),
    ('CH-WAN', 'CH-WAN (Wagen, Switzerland)'),
    ('CH-WCW', 'CH-WCW (Walchwil, Switzerland)'),
    ('CH-WLD', 'CH-WLD (Wald, Switzerland)'),
    ('CH-WLB', 'CH-WLB (Waldenburg, Switzerland)'),
    ('CH-WAD', 'CH-WAD (Waldstatt, Switzerland)'),
    ('CH-WLS', 'CH-WLS (Walenstadt, Switzerland)'),
    ('CH-WKN', 'CH-WKN (Walkringen, Switzerland)'),
    ('CH-WLL', 'CH-WLL (Wallbach, Switzerland)'),
    ('CH-WLN', 'CH-WLN (Wallisellen, Switzerland)'),
    ('CH-WTL', 'CH-WTL (Waltalingen, Switzerland)'),
    ('CH-WAL', 'CH-WAL (Waltenschwil, Switzerland)'),
    ('CH-WAI', 'CH-WAI (Waltikon, Switzerland)'),
    ('CH-WLZ', 'CH-WLZ (Walzenhausen, Switzerland)'),
    ('CH-WGN', 'CH-WGN (Wangen, Switzerland)'),
    ('CH-WSO', 'CH-WSO (Wangen, Switzerland)'),
    ('CH-WGA', 'CH-WGA (Wangen an der Aare, Switzerland)'),
    ('CH-WAB', 'CH-WAB (Wangen-Brüttisellen, Switzerland)'),
    ('CH-WNS', 'CH-WNS (Wangs, Switzerland)'),
    ('CH-VTW', 'CH-VTW (Warth-Weiningen, Switzerland)'),
    ('CH-WA5', 'CH-WA5 (Wasen, Switzerland)'),
    ('CH-WAS', 'CH-WAS (Wassen, Switzerland)'),
    ('CH-WSK', 'CH-WSK (Wasterkingen, Switzerland)'),
    ('CH-WTW', 'CH-WTW (Wattenwil, Switzerland)'),
    ('CH-WAT', 'CH-WAT (Wattwil, Switzerland)'),
    ('CH-WWL', 'CH-WWL (Wauwil, Switzerland)'),
    ('CH-WES', 'CH-WES (Weesen, Switzerland)'),
    ('CH-WGS', 'CH-WGS (Weggis, Switzerland)'),
    ('CH-ZHW', 'CH-ZHW (Weiach, Switzerland)'),
    ('CH-WFL', 'CH-WFL (Weinfelden, Switzerland)'),
    ('CH-WEG', 'CH-WEG (Weiningen, Switzerland)'),
    ('CH-WSB', 'CH-WSB (Weissbad, Switzerland)'),
    ('CH-WSN', 'CH-WSN (Weisslingen, Switzerland)'),
    ('CH-WEL', 'CH-WEL (Welschenrohr, Switzerland)'),
    ('CH-WNG', 'CH-WNG (Wengen, Switzerland)'),
    ('CH-WDB', 'CH-WDB (Werdenberg, Switzerland)'),
    ('CH-WTG', 'CH-WTG (Wettingen, Switzerland)'),
    ('CH-WSI', 'CH-WSI (Wettswil, Switzerland)'),
    ('CH-WZK', 'CH-WZK (Wetzikon, Switzerland)'),
    ('CH-WID', 'CH-WID (Widen, Switzerland)'),
    ('CH-WNU', 'CH-WNU (Widnau, Switzerland)'),
    ('CH-WBA', 'CH-WBA (Wiedlisbach, Switzerland)'),
    ('CH-WDG', 'CH-WDG (Wiesendangen, Switzerland)'),
    ('CH-WGT', 'CH-WGT (Wigoltingen, Switzerland)'),
    ('CH-WKO', 'CH-WKO (Wikon, Switzerland)'),
    ('CH-WIL', 'CH-WIL (Wil, Switzerland)'),
    ('CH-WQL', 'CH-WQL (Wil, Switzerland)'),
    ('CH-WLA', 'CH-WLA (Wila, Switzerland)'),
    ('CH-WWI', 'CH-WWI (Wilderswil, Switzerland)'),
    ('CH-WHS', 'CH-WHS (Wildhaus, Switzerland)'),
    ('CH-WBW', 'CH-WBW (Wilen Bei Wollerau, Switzerland)'),
    ('CH-WLR', 'CH-WLR (Wiler, Switzerland)'),
    ('CH-WSU', 'CH-WSU (Willisau, Switzerland)'),
    ('CH-WMM', 'CH-WMM (Wimmis, Switzerland)'),
    ('CH-WBG', 'CH-WBG (Winterberg, Switzerland)'),
    ('CH-WIN', 'CH-WIN (Winterthur, Switzerland)'),
    ('CH-WZA', 'CH-WZA (Winznau, Switzerland)'),
    ('CH-WTB', 'CH-WTB (Wittenbach, Switzerland)'),
    ('CH-WIT', 'CH-WIT (Witterswil, Switzerland)'),
    ('CH-WHL', 'CH-WHL (Wohlen, Switzerland)'),
    ('CH-WHD', 'CH-WHD (Wolfhalden, Switzerland)'),
    ('CH-ZWN', 'CH-ZWN (Wolfhausen, Switzerland)'),
    ('CH-WFW', 'CH-WFW (Wolfwil, Switzerland)'),
    ('CH-WHN', 'CH-WHN (Wolhusen, Switzerland)'),
    ('CH-WLU', 'CH-WLU (Wollerau, Switzerland)'),
    ('CH-WRB', 'CH-WRB (Worb, Switzerland)'),
    ('CH-WOR', 'CH-WOR (Worben, Switzerland)'),
    ('CH-WBN', 'CH-WBN (Worblaufen, Switzerland)'),
    ('CH-WLG', 'CH-WLG (Wurenlingen, Switzerland)'),
    ('CH-WYU', 'CH-WYU (Wynau, Switzerland)'),
    ('CH-WYG', 'CH-WYG (Wynigen, Switzerland)'),
    ('CH-WSC', 'CH-WSC (Wyssachen, Switzerland)'),
    ('CH-WDW', 'CH-WDW (Wädenswil, Switzerland)'),
    ('CH-WDI', 'CH-WDI (Wäldi, Switzerland)'),
    ('CH-WGI', 'CH-WGI (Wängi, Switzerland)'),
    ('CH-WLF', 'CH-WLF (Wünnewil-Flamatt, Switzerland)'),
    ('CH-WLO', 'CH-WLO (Würenlos, Switzerland)'),
    ('CH-YNS', 'CH-YNS (Yens, Switzerland)'),
    ('CH-YLB', 'CH-YLB (Yverdon-les-Bains, Switzerland)'),
    ('CH-YVD', 'CH-YVD (Yvonand, Switzerland)'),
    ('CH-YVR', 'CH-YVR (Yvorne, Switzerland)'),
    ('CH-ZEI', 'CH-ZEI (Zeihen, Switzerland)'),
    ('CH-ZGN', 'CH-ZGN (Zeiningen, Switzerland)'),
    ('CH-ZEL', 'CH-ZEL (Zell, Switzerland)'),
    ('CH-ZZL', 'CH-ZZL (Zell, Switzerland)'),
    ('CH-ZER', 'CH-ZER (Zermatt, Switzerland)'),
    ('CH-ZWI', 'CH-ZWI (Zetzwil, Switzerland)'),
    ('CH-ZGB', 'CH-ZGB (Ziegelbrucke, Switzerland)'),
    ('CH-ZSD', 'CH-ZSD (Zihlschlacht-Sitterdorf, Switzerland)'),
    ('CH-ZRD', 'CH-ZRD (Zimmerwald, Switzerland)'),
    ('CH-ZIN', 'CH-ZIN (Zinal, Switzerland)'),
    ('CH-ZIZ', 'CH-ZIZ (Zizers, Switzerland)'),
    ('CH-ZLL', 'CH-ZLL (Zofingen, Switzerland)'),
    ('CH-ZBK', 'CH-ZBK (Zollbrück, Switzerland)'),
    ('CH-ZLK', 'CH-ZLK (Zollikofen, Switzerland)'),
    ('CH-ZOL', 'CH-ZOL (Zollikon, Switzerland)'),
    ('CH-ZWL', 'CH-ZWL (Zuchwil, Switzerland)'),
    ('CH-ZFN', 'CH-ZFN (Zufikon, Switzerland)'),
    ('CH-ZLM', 'CH-ZLM (Zug, Switzerland)'),
    ('CH-ZKN', 'CH-ZKN (Zumikon, Switzerland)'),
    ('CH-ZZG', 'CH-ZZG (Zunzgen, Switzerland)'),
    ('CH-ZT3', 'CH-ZT3 (Zuoz, Switzerland)'),
    ('CH-ZRH', 'CH-ZRH (Zurich, Switzerland)'),
    ('CH-ZZH', 'CH-ZZH (Zurzach, Switzerland)'),
    ('CH-ZUL', 'CH-ZUL (Zuzwil, Switzerland)'),
    ('CH-ZIM', 'CH-ZIM (Zweisimmen, Switzerland)'),
    ('CH-ZWK', 'CH-ZWK (Zwillikon, Switzerland)'),
    ('CH-ZWG', 'CH-ZWG (Zwingen, Switzerland)'),
    ('CH-ZAZ', 'CH-ZAZ (Zäziwil, Switzerland)'),
    ('CH-EFV', 'CH-EFV (Échichens, Switzerland)'),
    ('CI-OGO', "CI-OGO (Abengourou, Côte d'Ivoire)"),
    ('CI-ABJ', "CI-ABJ (Abidjan, Côte d'Ivoire)"),
    ('CI-ABO', "CI-ABO (Aboisso, Côte d'Ivoire)"),
    ('CI-ADZ', "CI-ADZ (Adzopé, Côte d'Ivoire)"),
    ('CI-AGB', "CI-AGB (Agboville, Côte d'Ivoire)"),
    ('CI-AFI', "CI-AFI (Amalfi, Côte d'Ivoire)"),
    ('CI-ASS', "CI-ASS (Assinie-Mafia, Côte d'Ivoire)"),
    ('CI-BAO', "CI-BAO (Baobab Terminal, Côte d'Ivoire)"),
    ('CI-BGV', "CI-BGV (Bingerville, Côte d'Ivoire)"),
    ('CI-BDK', "CI-BDK (Bondoukou, Côte d'Ivoire)"),
    ('CI-BGG', "CI-BGG (Bongouanou, Côte d'Ivoire)"),
    ('CI-BON', "CI-BON (Bonoua, Côte d'Ivoire)"),
    ('CI-BRZ', "CI-BRZ (Borotou, Côte d'Ivoire)"),
    ('CI-BYK', "CI-BYK (Bouaké, Côte d'Ivoire)"),
    ('CI-BQO', "CI-BQO (Bouna, Côte d'Ivoire)"),
    ('CI-BXI', "CI-BXI (Boundiali, Côte d'Ivoire)"),
    ('CI-BUU', "CI-BUU (Buyo, Côte d'Ivoire)"),
    ('CI-COD', "CI-COD (Cocody, Côte d'Ivoire)"),
    ('CI-DAB', "CI-DAB (Dabou, Côte d'Ivoire)"),
    ('CI-DJO', "CI-DJO (Daloa, Côte d'Ivoire)"),
    ('CI-DNC', "CI-DNC (Danane, Côte d'Ivoire)"),
    ('CI-DIM', "CI-DIM (Dimbokro, Côte d'Ivoire)"),
    ('CI-DIV', "CI-DIV (Divo, Côte d'Ivoire)"),
    ('CI-DJB', "CI-DJB (Djibi, Côte d'Ivoire)"),
    ('CI-ESP', "CI-ESP (Espoir, Côte d'Ivoire)"),
    ('CI-FEK', "CI-FEK (Ferkessédougou, Côte d'Ivoire)"),
    ('CI-FRE', "CI-FRE (Fresco, Côte d'Ivoire)"),
    ('CI-GGN', "CI-GGN (Gagnoa, Côte d'Ivoire)"),
    ('CI-GBA', "CI-GBA (Gbabam, Côte d'Ivoire)"),
    ('CI-GLU', "CI-GLU (Grand Lahou, Côte d'Ivoire)"),
    ('CI-BBV', "CI-BBV (Grand-Béréby, Côte d'Ivoire)"),
    ('CI-GUI', "CI-GUI (Guiembé, Côte d'Ivoire)"),
    ('CI-GGO', "CI-GGO (Guiglo, Côte d'Ivoire)"),
    ('CI-JAC', "CI-JAC (Jacqueville, Côte d'Ivoire)"),
    ('CI-KTC', "CI-KTC (Katiola, Côte d'Ivoire)"),
    ('CI-HGO', "CI-HGO (Korhogo, Côte d'Ivoire)"),
    ('CI-KOS', "CI-KOS (Kosagi, Côte d'Ivoire)"),
    ('CI-KOU', "CI-KOU (Koumassi, Côte d'Ivoire)"),
    ('CI-LKT', "CI-LKT (Lakota, Côte d'Ivoire)"),
    ('CI-XMB', "CI-XMB (M'Bahiakro, Côte d'Ivoire)"),
    ('CI-MJC', "CI-MJC (Man, Côte d'Ivoire)"),
    ('CI-MOK', "CI-MOK (Mankono, Côte d'Ivoire)"),
    ('CI-NKL', "CI-NKL (Nakala, Côte d'Ivoire)"),
    ('CI-KEO', "CI-KEO (Odienné, Côte d'Ivoire)"),
    ('CI-OFI', "CI-OFI (Ouango Fitni, Côte d'Ivoire)"),
    ('CI-PBT', "CI-PBT (Port-Bouët, Côte d'Ivoire)"),
    ('CI-SPY', "CI-SPY (San-Pédro, Côte d'Ivoire)"),
    ('CI-ZSS', "CI-ZSS (Sassandra, Côte d'Ivoire)"),
    ('CI-SEQ', "CI-SEQ (Seguela, Côte d'Ivoire)"),
    ('CI-SFR', "CI-SFR (Sinfra, Côte d'Ivoire)"),
    ('CI-SGL', "CI-SGL (Séguéla, Côte d'Ivoire)"),
    ('CI-TBX', "CI-TBX (Taabo, Côte d'Ivoire)"),
    ('CI-TXU', "CI-TXU (Tabou, Côte d'Ivoire)"),
    ('CI-TIA', "CI-TIA (Tiassalé, Côte d'Ivoire)"),
    ('CI-TGX', "CI-TGX (Tingrela, Côte d'Ivoire)"),
    ('CI-TOZ', "CI-TOZ (Touba, Côte d'Ivoire)"),
    ('CI-VRD', "CI-VRD (Vridi, Côte d'Ivoire)"),
    ('CI-ASK', "CI-ASK (Yamoussoukro, Côte d'Ivoire)"),
    ('CI-YGN', "CI-YGN (Yopougon, Côte d'Ivoire)"),
    ('CI-YOA', "CI-YOA (Yopougon-Attie, Côte d'Ivoire)"),
    ('CI-ZUE', "CI-ZUE (Zuenoula, Côte d'Ivoire)"),
    ('CK-AIT', 'CK-AIT (Aitutaki, Cook Islands)'),
    ('CK-ARU', 'CK-ARU (Arutunga, Cook Islands)'),
    ('CK-AIU', 'CK-AIU (Atiu, Cook Islands)'),
    ('CK-AVA', 'CK-AVA (Avarua, Cook Islands)'),
    ('CK-MGS', 'CK-MGS (Mangaia, Cook Islands)'),
    ('CK-MHX', 'CK-MHX (Manihiki Island, Cook Islands)'),
    ('CK-MUK', 'CK-MUK (Mauke Island, Cook Islands)'),
    ('CK-MOI', 'CK-MOI (Mitiaro Island, Cook Islands)'),
    ('CK-PYE', 'CK-PYE (Penrhyn Island, Cook Islands)'),
    ('CK-PZK', 'CK-PZK (Puka Puka Island, Cook Islands)'),
    ('CK-RAR', 'CK-RAR (Rarotonga, Cook Islands)'),
    ('CL-ACH', 'CL-ACH (Achao, Chile)'),
    ('CL-ALG', 'CL-ALG (Algarrobo, Chile)'),
    ('CL-ALH', 'CL-ALH (Alhué, Chile)'),
    ('CL-ABB', 'CL-ABB (Alto Bío Bío, Chile)'),
    ('CL-ADC', 'CL-ADC (Alto del Carmen, Chile)'),
    ('CL-AHP', 'CL-AHP (Alto Hospicio, Chile)'),
    ('CL-WAP', 'CL-WAP (Alto Palena Apt, Chile)'),
    ('CL-M9Z', 'CL-M9Z (Ancoa, Chile)'),
    ('CL-ZUD', 'CL-ZUD (Ancud, Chile)'),
    ('CL-AND', 'CL-AND (Andacollo, Chile)'),
    ('CL-ANG', 'CL-ANG (Angol, Chile)'),
    ('CL-ANF', 'CL-ANF (Antofagasta, Chile)'),
    ('CL-ANT', 'CL-ANT (Antuco, Chile)'),
    ('CL-ARA', 'CL-ARA (Arauco, Chile)'),
    ('CL-ARI', 'CL-ARI (Arica, Chile)'),
    ('CL-AYA', 'CL-AYA (Ayacara, Chile)'),
    ('CL-BLR', 'CL-BLR (Bahia Laredo, Chile)'),
    ('CL-BAG', 'CL-BAG (Bahía San Gregorio, Chile)'),
    ('CL-BBA', 'CL-BBA (Balmaceda, Chile)'),
    ('CL-BAQ', 'CL-BAQ (Baquedano, Chile)'),
    ('CL-BAR', 'CL-BAR (Barquito, Chile)'),
    ('CL-BUI', 'CL-BUI (Buin, Chile)'),
    ('CL-BUL', 'CL-BUL (Bulnes, Chile)'),
    ('CL-CBD', 'CL-CBD (Cabildo, Chile)'),
    ('CL-CHR', 'CL-CHR (Cabo de Hornos, Chile)'),
    ('CL-CNX', 'CL-CNX (Cabo Negro, Chile)'),
    ('CL-CAB', 'CL-CAB (Cabrero, Chile)'),
    ('CL-CJC', 'CL-CJC (Calama, Chile)'),
    ('CL-CBC', 'CL-CBC (Calbuco, Chile)'),
    ('CL-CLD', 'CL-CLD (Caldera, Chile)'),
    ('CL-CAA', 'CL-CAA (Calderilla, Chile)'),
    ('CL-CDT', 'CL-CDT (Calera de Tango, Chile)'),
    ('CL-CLR', 'CL-CLR (Caleta Clarencia, Chile)'),
    ('CL-COL', 'CL-COL (Caleta Coloso, Chile)'),
    ('CL-CAL', 'CL-CAL (Caleta Patillos, Chile)'),
    ('CL-CLL', 'CL-CLL (Calle Larga, Chile)'),
    ('CL-CAM', 'CL-CAM (Camarones, Chile)'),
    ('CL-CMA', 'CL-CMA (Camiña, Chile)'),
    ('CL-BBH', 'CL-BBH (Campamento Barahona, Chile)'),
    ('CL-CMP', 'CL-CMP (Campanario, Chile)'),
    ('CL-CAN', 'CL-CAN (Canela, Chile)'),
    ('CL-CAR', 'CL-CAR (Carahue, Chile)'),
    ('CL-CRH', 'CL-CRH (Carahue, Chile)'),
    ('CL-CGN', 'CL-CGN (Cartagena, Chile)'),
    ('CL-CAS', 'CL-CAS (Casablanca, Chile)'),
    ('CL-WCA', 'CL-WCA (Castro, Chile)'),
    ('CL-CAT', 'CL-CAT (Catemu, Chile)'),
    ('CL-CAU', 'CL-CAU (Cauquenes, Chile)'),
    ('CL-CTE', 'CL-CTE (Cañete, Chile)'),
    ('CL-CER', 'CL-CER (Cerrillos, Chile)'),
    ('CL-CNV', 'CL-CNV (Cerro Navia, Chile)'),
    ('CL-SMB', 'CL-SMB (Cerro Sombrero, Chile)'),
    ('CL-CHB', 'CL-CHB (Chacabuco, Chile)'),
    ('CL-CCA', 'CL-CCA (Chacao, Chile)'),
    ('CL-CHG', 'CL-CHG (Chagres, Chile)'),
    ('CL-WCH', 'CL-WCH (Chaitén, Chile)'),
    ('CL-CHA', 'CL-CHA (Chanco, Chile)'),
    ('CL-B7X', 'CL-B7X (Charrua, Chile)'),
    ('CL-CNR', 'CL-CNR (Chañaral, Chile)'),
    ('CL-CCO', 'CL-CCO (Chicureo, Chile)'),
    ('CL-CHI', 'CL-CHI (Chiguayante, Chile)'),
    ('CL-CCH', 'CL-CCH (Chile Chico, Chile)'),
    ('CL-YAI', 'CL-YAI (Chillán, Chile)'),
    ('CL-CHV', 'CL-CHV (Chillán Viejo, Chile)'),
    ('CL-CBG', 'CL-CBG (Chimbarongo, Chile)'),
    ('CL-CHL', 'CL-CHL (Cholchol, Chile)'),
    ('CL-CHO', 'CL-CHO (Chonchi, Chile)'),
    ('CL-CHU', 'CL-CHU (Chuquicamata, Chile)'),
    ('CL-CHE', 'CL-CHE (Chépica, Chile)'),
    ('CL-CBQ', 'CL-CBQ (Cobquecura, Chile)'),
    ('CL-CMO', 'CL-CMO (Cochamó, Chile)'),
    ('CL-COC', 'CL-COC (Cochrane, Chile)'),
    ('CL-COD', 'CL-COD (Codegua, Chile)'),
    ('CL-COE', 'CL-COE (Coelemu, Chile)'),
    ('CL-COI', 'CL-COI (Coihueco, Chile)'),
    ('CL-COO', 'CL-COO (Coinco, Chile)'),
    ('CL-COB', 'CL-COB (Colbún, Chile)'),
    ('CL-CNE', 'CL-CNE (Colchane, Chile)'),
    ('CL-CLN', 'CL-CLN (Colina, Chile)'),
    ('CL-CPI', 'CL-CPI (Collipulli, Chile)'),
    ('CL-CTC', 'CL-CTC (Coltauco, Chile)'),
    ('CL-CBB', 'CL-CBB (Combarbalá, Chile)'),
    ('CL-CCP', 'CL-CCP (Concepción, Chile)'),
    ('CL-CLI', 'CL-CLI (Conchalí, Chile)'),
    ('CL-CON', 'CL-CON (Concón, Chile)'),
    ('CL-CST', 'CL-CST (Constitución, Chile)'),
    ('CL-CTM', 'CL-CTM (Contulmo, Chile)'),
    ('CL-CPO', 'CL-CPO (Copiapó, Chile)'),
    ('CL-CQQ', 'CL-CQQ (Coquimbo, Chile)'),
    ('CL-CNL', 'CL-CNL (Coronel, Chile)'),
    ('CL-CRR', 'CL-CRR (Corral, Chile)'),
    ('CL-CXQ', 'CL-CXQ (Coyhaique, Chile)'),
    ('CL-CGR', 'CL-CGR (Cruz Grande, Chile)'),
    ('CL-CUN', 'CL-CUN (Cunco, Chile)'),
    ('CL-CCN', 'CL-CCN (Curacautín, Chile)'),
    ('CL-CRV', 'CL-CRV (Curacaví, Chile)'),
    ('CL-CDV', 'CL-CDV (Curaco de Vélez, Chile)'),
    ('CL-CRN', 'CL-CRN (Curanilahue, Chile)'),
    ('CL-CRE', 'CL-CRE (Curarrehue, Chile)'),
    ('CL-CRM', 'CL-CRM (Curauma, Chile)'),
    ('CL-CRT', 'CL-CRT (Curepto, Chile)'),
    ('CL-CUR', 'CL-CUR (Curicó, Chile)'),
    ('CL-DCH', 'CL-DCH (Dalcahue, Chile)'),
    ('CL-DDA', 'CL-DDA (Diego de Almagro, Chile)'),
    ('CL-A2T', 'CL-A2T (Domeyko, Chile)'),
    ('CL-DOH', 'CL-DOH (Doñihue, Chile)'),
    ('CL-ELB', 'CL-ELB (El Bosque, Chile)'),
    ('CL-ELC', 'CL-ELC (El Carmen, Chile)'),
    ('CL-EML', 'CL-EML (El Melón, Chile)'),
    ('CL-ELM', 'CL-ELM (El Monte, Chile)'),
    ('CL-ELP', 'CL-ELP (El Palqui, Chile)'),
    ('CL-ELQ', 'CL-ELQ (El Quisco, Chile)'),
    ('CL-ESR', 'CL-ESR (El Salvador, Chile)'),
    ('CL-ELT', 'CL-ELT (El Tabo, Chile)'),
    ('CL-EMP', 'CL-EMP (Empedrado, Chile)'),
    ('CL-ERC', 'CL-ERC (Ercilla, Chile)'),
    ('CL-ESC', 'CL-ESC (Escuadrón, Chile)'),
    ('CL-ECT', 'CL-ECT (Estación Central, Chile)'),
    ('CL-FLO', 'CL-FLO (Florida, Chile)'),
    ('CL-FRE', 'CL-FRE (Freire, Chile)'),
    ('CL-FRN', 'CL-FRN (Freirina, Chile)'),
    ('CL-FRS', 'CL-FRS (Fresia, Chile)'),
    ('CL-FRT', 'CL-FRT (Frutillar, Chile)'),
    ('CL-FFU', 'CL-FFU (Futaleufú, Chile)'),
    ('CL-FUT', 'CL-FUT (Futrono, Chile)'),
    ('CL-GAL', 'CL-GAL (Galvarino, Chile)'),
    ('CL-GIO', 'CL-GIO (Gatico, Chile)'),
    ('CL-GLG', 'CL-GLG (General Lagos, Chile)'),
    ('CL-GOR', 'CL-GOR (Gorbea, Chile)'),
    ('CL-GRA', 'CL-GRA (Graneros, Chile)'),
    ('CL-GUA', 'CL-GUA (Guaitecas, Chile)'),
    ('CL-GYC', 'CL-GYC (Guayacán, Chile)'),
    ('CL-HIJ', 'CL-HIJ (Hijuelas, Chile)'),
    ('CL-HOR', 'CL-HOR (Horcón, Chile)'),
    ('CL-HPO', 'CL-HPO (Huachipato, Chile)'),
    ('CL-HUH', 'CL-HUH (Hualaihué, Chile)'),
    ('CL-HLE', 'CL-HLE (Hualañé, Chile)'),
    ('CL-HPN', 'CL-HPN (Hualpén, Chile)'),
    ('CL-HQI', 'CL-HQI (Hualqui, Chile)'),
    ('CL-HUA', 'CL-HUA (Huara, Chile)'),
    ('CL-HSO', 'CL-HSO (Huasco, Chile)'),
    ('CL-HUE', 'CL-HUE (Huechuraba, Chile)'),
    ('CL-HUL', 'CL-HUL (Huepil, Chile)'),
    ('CL-RHU', 'CL-RHU (Hurtado, Chile)'),
    ('CL-IGC', 'CL-IGC (Iglesia Colorada, Chile)'),
    ('CL-ILL', 'CL-ILL (Illapel, Chile)'),
    ('CL-IND', 'CL-IND (Independencia, Chile)'),
    ('CL-IQQ', 'CL-IQQ (Iquique, Chile)'),
    ('CL-IDM', 'CL-IDM (Isla de Maipo, Chile)'),
    ('CL-IPC', 'CL-IPC (Isla de Pascua, Chile)'),
    ('CL-ISG', 'CL-ISG (Isla Guarello, Chile)'),
    ('CL-JFZ', 'CL-JFZ (Juan Fernández, Chile)'),
    ('CL-LCL', 'CL-LCL (La Calera, Chile)'),
    ('CL-LAC', 'CL-LAC (La Chimba, Chile)'),
    ('CL-LCI', 'CL-LCI (La Cisterna, Chile)'),
    ('CL-LCZ', 'CL-LCZ (La Cruz, Chile)'),
    ('CL-LES', 'CL-LES (La Estrella, Chile)'),
    ('CL-LFL', 'CL-LFL (La Florida, Chile)'),
    ('CL-LGJ', 'CL-LGJ (La Granja, Chile)'),
    ('CL-LAH', 'CL-LAH (La Higuera, Chile)'),
    ('CL-LAJ', 'CL-LAJ (La Laja, Chile)'),
    ('CL-LIG', 'CL-LIG (La Ligua, Chile)'),
    ('CL-LNE', 'CL-LNE (La Negra, Chile)'),
    ('CL-PAZ', 'CL-PAZ (La Paz, Chile)'),
    ('CL-LPI', 'CL-LPI (La Pintana, Chile)'),
    ('CL-REI', 'CL-REI (La Reina, Chile)'),
    ('CL-LSC', 'CL-LSC (La Serena, Chile)'),
    ('CL-LUN', 'CL-LUN (La Unión, Chile)'),
    ('CL-RNC', 'CL-RNC (Lago Ranco, Chile)'),
    ('CL-LVD', 'CL-LVD (Lago Verde, Chile)'),
    ('CL-LBL', 'CL-LBL (Laguna Blanca, Chile)'),
    ('CL-LAM', 'CL-LAM (Lampa, Chile)'),
    ('CL-LAN', 'CL-LAN (Lanco, Chile)'),
    ('CL-LCB', 'CL-LCB (Las Cabras, Chile)'),
    ('CL-LCO', 'CL-LCO (Las Condes, Chile)'),
    ('CL-LAS', 'CL-LAS (Las Salinas/Quintero, Chile)'),
    ('CL-LVS', 'CL-LVS (Las Ventanas, Chile)'),
    ('CL-LAU', 'CL-LAU (Lautaro, Chile)'),
    ('CL-LEB', 'CL-LEB (Lebu, Chile)'),
    ('CL-LIC', 'CL-LIC (Licantén, Chile)'),
    ('CL-LIM', 'CL-LIM (Limache, Chile)'),
    ('CL-LMR', 'CL-LMR (Limarí, Chile)'),
    ('CL-LIN', 'CL-LIN (Linares, Chile)'),
    ('CL-LDR', 'CL-LDR (Linderos, Chile)'),
    ('CL-LQN', 'CL-LQN (Lirquén, Chile)'),
    ('CL-LIT', 'CL-LIT (Litueche, Chile)'),
    ('CL-LIU', 'CL-LIU (Liucura, Chile)'),
    ('CL-LLA', 'CL-LLA (Llaillay, Chile)'),
    ('CL-LIA', 'CL-LIA (Llanquihue, Chile)'),
    ('CL-LLI', 'CL-LLI (Llico, Chile)'),
    ('CL-LLO', 'CL-LLO (Llolleo, Chile)'),
    ('CL-LBA', 'CL-LBA (Lo Barnechea, Chile)'),
    ('CL-LEJ', 'CL-LEJ (Lo Espejo, Chile)'),
    ('CL-LPR', 'CL-LPR (Lo Prado, Chile)'),
    ('CL-LOL', 'CL-LOL (Lolol, Chile)'),
    ('CL-LNC', 'CL-LNC (Loncoche, Chile)'),
    ('CL-LON', 'CL-LON (Longaví, Chile)'),
    ('CL-LQY', 'CL-LQY (Lonquimay, Chile)'),
    ('CL-LUE', 'CL-LUE (Lontué, Chile)'),
    ('CL-LND', 'CL-LND (Los Andes, Chile)'),
    ('CL-ULC', 'CL-ULC (Los Cerrillos Apt/Santiago, Chile)'),
    ('CL-LLG', 'CL-LLG (Los Lagos, Chile)'),
    ('CL-LMU', 'CL-LMU (Los Muermos, Chile)'),
    ('CL-LSA', 'CL-LSA (Los Sauces, Chile)'),
    ('CL-LVT', 'CL-LVT (Los Vientos, Chile)'),
    ('CL-LOS', 'CL-LOS (Los Vilos, Chile)'),
    ('CL-LAL', 'CL-LAL (Los Álamos, Chile)'),
    ('CL-LSQ', 'CL-LSQ (Los Ángeles, Chile)'),
    ('CL-LTA', 'CL-LTA (Lota, Chile)'),
    ('CL-LUM', 'CL-LUM (Lumaco, Chile)'),
    ('CL-MCI', 'CL-MCI (Machalí, Chile)'),
    ('CL-MAC', 'CL-MAC (Macul, Chile)'),
    ('CL-MAI', 'CL-MAI (Maipú, Chile)'),
    ('CL-MAL', 'CL-MAL (Malloa, Chile)'),
    ('CL-MCO', 'CL-MCO (Malloco, Chile)'),
    ('CL-MAR', 'CL-MAR (Marchihue, Chile)'),
    ('CL-MRQ', 'CL-MRQ (Mariquina, Chile)'),
    ('CL-MAE', 'CL-MAE (María Elena, Chile)'),
    ('CL-MPI', 'CL-MPI (María Pinto, Chile)'),
    ('CL-MAU', 'CL-MAU (Maule, Chile)'),
    ('CL-MLL', 'CL-MLL (Maullín, Chile)'),
    ('CL-MJS', 'CL-MJS (Mejillones, Chile)'),
    ('CL-MLI', 'CL-MLI (Melinka, Chile)'),
    ('CL-MLP', 'CL-MLP (Melipeuco, Chile)'),
    ('CL-MEL', 'CL-MEL (Melipilla, Chile)'),
    ('CL-MIC', 'CL-MIC (Michilla, Chile)'),
    ('CL-MOL', 'CL-MOL (Molina, Chile)'),
    ('CL-MTP', 'CL-MTP (Monte Patria, Chile)'),
    ('CL-MUL', 'CL-MUL (Mulchén, Chile)'),
    ('CL-MAF', 'CL-MAF (Máfil, Chile)'),
    ('CL-NAC', 'CL-NAC (Nacimiento, Chile)'),
    ('CL-NCG', 'CL-NCG (Nancagua, Chile)'),
    ('CL-NAN', 'CL-NAN (Nancahua, Chile)'),
    ('CL-NAV', 'CL-NAV (Navidad, Chile)'),
    ('CL-NEG', 'CL-NEG (Negrete, Chile)'),
    ('CL-NBL', 'CL-NBL (Niebla, Chile)'),
    ('CL-NIN', 'CL-NIN (Ninhue, Chile)'),
    ('CL-NPS', 'CL-NPS (Nipas, Chile)'),
    ('CL-NOG', 'CL-NOG (Nogales, Chile)'),
    ('CL-NOS', 'CL-NOS (Nos, Chile)'),
    ('CL-NAL', 'CL-NAL (Nueva Aldea, Chile)'),
    ('CL-NIM', 'CL-NIM (Nueva Imperial, Chile)'),
    ('CL-OHI', "CL-OHI (O'Higgins, Chile)"),
    ('CL-OLI', 'CL-OLI (Olivar, Chile)'),
    ('CL-OLL', 'CL-OLL (Ollagüe, Chile)'),
    ('CL-OLM', 'CL-OLM (Olmué, Chile)'),
    ('CL-ZOS', 'CL-ZOS (Osorno, Chile)'),
    ('CL-OVL', 'CL-OVL (Ovalle, Chile)'),
    ('CL-PHU', 'CL-PHU (Padre Hurtado, Chile)'),
    ('CL-PLC', 'CL-PLC (Padre Las Casas, Chile)'),
    ('CL-PAI', 'CL-PAI (Paiguano, Chile)'),
    ('CL-PAO', 'CL-PAO (Paillaco, Chile)'),
    ('CL-PNE', 'CL-PNE (Paine, Chile)'),
    ('CL-PAL', 'CL-PAL (Palena, Chile)'),
    ('CL-PMA', 'CL-PMA (Palmilla, Chile)'),
    ('CL-PAN', 'CL-PAN (Panguipulli, Chile)'),
    ('CL-PQH', 'CL-PQH (Panquehue, Chile)'),
    ('CL-PAP', 'CL-PAP (Papudo, Chile)'),
    ('CL-PAR', 'CL-PAR (Paredones, Chile)'),
    ('CL-PGA', 'CL-PGA (Pargua, Chile)'),
    ('CL-PRL', 'CL-PRL (Parral, Chile)'),
    ('CL-AON', 'CL-AON (Paso Abra Oriente de Napa/Pica, Chile)'),
    ('CL-AGN', 'CL-AGN (Paso Agua Negra-Juntas de Toro/Vicuña, Chile)'),
    ('CL-CSA', 'CL-CSA (Paso Cardenal A. Samoré/Puyehue, Chile)'),
    ('CL-CAI', 'CL-CAI (Paso Carirriñe/Panguipulli, Chile)'),
    ('CL-CGA', 'CL-CGA (Paso Chungará-Tambo Quemado/Putre, Chile)'),
    ('CL-COP', 'CL-COP (Paso Colchane-Pisiga/Colchane, Chile)'),
    ('CL-CCD', 'CL-CCD (Paso Concordia-Chacalluta/Arica, Chile)'),
    ('CL-CIQ', 'CL-CIQ (Paso Coyhaique/Coyhaique, Chile)'),
    ('CL-LIB', 'CL-LIB (Paso Cristo Redentor-Los Libertadores/Los Andes, Chile)'),
    ('CL-DOR', 'CL-DOR (Paso Dorotea/Puerto Natales, Chile)'),
    ('CL-FTF', 'CL-FTF (Paso Futaleufú/Futaleufú, Chile)'),
    ('CL-HIT', 'CL-HIT (Paso Hito Cajón/San Pedro de Atacama, Chile)'),
    ('CL-HHM', 'CL-HHM (Paso Hua Hum/Panguipulli, Chile)'),
    ('CL-HLS', 'CL-HLS (Paso Huemules-Balmaceda/Coyhaique, Chile)'),
    ('CL-ICA', 'CL-ICA (Paso Icalma/Lonquimay, Chile)'),
    ('CL-INI', 'CL-INI (Paso Ingeniero Ibáñez Pallavicini/Río Ibáñez, Chile)'),
    ('CL-IAU', 'CL-IAU (Paso Integración Austral-Monte Aymond/San Gregorio, Chile)'),
    ('CL-JAM', 'CL-JAM (Paso Jama/San Pedro de Atacama, Chile)'),
    ('CL-LOH', "CL-LOH (Paso Lago O'Higgins/O'Higgins, Chile)"),
    ('CL-CVJ', 'CL-CVJ (Paso Laurita Casas Viejas/Puerto Natales, Chile)'),
    ('CL-MML', 'CL-MML (Paso Mamuil Malal-Puesco/Currarehue, Chile)'),
    ('CL-OLA', 'CL-OLA (Paso Ollagüe/Ollagüe, Chile)'),
    ('CL-PAM', 'CL-PAM (Paso Pampa Alta (Puesto Viejo)/Coyhaique, Chile)'),
    ('CL-PEH', 'CL-PEH (Paso Pehuenche/San Clemente, Chile)'),
    ('CL-PIA', 'CL-PIA (Paso Pichachén/Antuco, Chile)'),
    ('CL-PAA', 'CL-PAA (Paso Pino Hachado/Lonquimay, Chile)'),
    ('CL-PIG', 'CL-PIG (Paso Pircas Negras/Tierra Amarilla, Chile)'),
    ('CL-PIU', 'CL-PIU (Paso Piuquenes/San José de Maipo, Chile)'),
    ('CL-ROB', 'CL-ROB (Paso Roballos/Cochrane, Chile)'),
    ('CL-RBL', 'CL-RBL (Paso Río Bellavista/Timaukel, Chile)'),
    ('CL-RDG', 'CL-RDG (Paso Río Don Guillermo/Torres del Paine, Chile)'),
    ('CL-RIE', 'CL-RIE (Paso Río Encuentro/Palena, Chile)'),
    ('CL-RFA', 'CL-RFA (Paso Río Frías Appeleg/Cisnes, Chile)'),
    ('CL-RIJ', 'CL-RIJ (Paso Río Jeinimeni/Chile Chico, Chile)'),
    ('CL-RIM', "CL-RIM (Paso Río Mayer/O'Higgins, Chile)"),
    ('CL-RMO', "CL-RMO (Paso Río Mosco/O'Higgins, Chile)"),
    ('CL-FCO', 'CL-FCO (Paso San Francisco/Tierra Amarilla, Chile)'),
    ('CL-SSB', 'CL-SSB (Paso San Sebastián/Porvenir, Chile)'),
    ('CL-SIC', 'CL-SIC (Paso Sico/San Pedro de Atacama, Chile)'),
    ('CL-SOC', 'CL-SOC (Paso Socompa/Antofagasta, Chile)'),
    ('CL-TRI', 'CL-TRI (Paso Triana/Coyhaique, Chile)'),
    ('CL-VPR', 'CL-VPR (Paso V. Pérez Rosales-Peulla/Puerto Varas, Chile)'),
    ('CL-VER', 'CL-VER (Paso Vergara-San Pedro/Romeral, Chile)'),
    ('CL-VIS', 'CL-VIS (Paso Visviri/Putre, Chile)'),
    ('CL-PTI', 'CL-PTI (Patillos, Chile)'),
    ('CL-PCK', 'CL-PCK (Pecket, Chile)'),
    ('CL-PAC', 'CL-PAC (Pedro Aguirre Cerda, Chile)'),
    ('CL-PDV', 'CL-PDV (Pedro de Valdivia, Chile)'),
    ('CL-PEL', 'CL-PEL (Pelarco, Chile)'),
    ('CL-PLE', 'CL-PLE (Pelequén, Chile)'),
    ('CL-PLH', 'CL-PLH (Pelluhue, Chile)'),
    ('CL-PEM', 'CL-PEM (Pemuco, Chile)'),
    ('CL-PEN', 'CL-PEN (Pencahue, Chile)'),
    ('CL-PEO', 'CL-PEO (Penco, Chile)'),
    ('CL-PER', 'CL-PER (Peralillo, Chile)'),
    ('CL-PQC', 'CL-PQC (Perquenco, Chile)'),
    ('CL-PET', 'CL-PET (Petorca, Chile)'),
    ('CL-PEU', 'CL-PEU (Peumo, Chile)'),
    ('CL-PFL', 'CL-PFL (Peñaflor, Chile)'),
    ('CL-PLN', 'CL-PLN (Peñalolén, Chile)'),
    ('CL-PIC', 'CL-PIC (Pica, Chile)'),
    ('CL-PDH', 'CL-PDH (Pichidegua, Chile)'),
    ('CL-PLM', 'CL-PLM (Pichilemu, Chile)'),
    ('CL-PDM', 'CL-PDM (Pidima, Chile)'),
    ('CL-PIN', 'CL-PIN (Pinto, Chile)'),
    ('CL-PIR', 'CL-PIR (Pirque, Chile)'),
    ('CL-PIS', 'CL-PIS (Pisagua, Chile)'),
    ('CL-PIT', 'CL-PIT (Pitrufquén, Chile)'),
    ('CL-PLA', 'CL-PLA (Placilla, Chile)'),
    ('CL-PLL', 'CL-PLL (Placilla, Chile)'),
    ('CL-PAQ', 'CL-PAQ (Placilla - Valparaiso, Chile)'),
    ('CL-POR', 'CL-POR (Portezuelo, Chile)'),
    ('CL-PVR', 'CL-PVR (Porvenir, Chile)'),
    ('CL-WPR', 'CL-WPR (Porvenir Apt, Chile)'),
    ('CL-POS', 'CL-POS (Posesión, Chile)'),
    ('CL-POZ', 'CL-POZ (Pozo Almonte, Chile)'),
    ('CL-PRI', 'CL-PRI (Primavera, Chile)'),
    ('CL-PRO', 'CL-PRO (Providencia, Chile)'),
    ('CL-PCI', 'CL-PCI (Puchuncaví, Chile)'),
    ('CL-PUC', 'CL-PUC (Pucón, Chile)'),
    ('CL-ZPC', 'CL-ZPC (Pucón Apt, Chile)'),
    ('CL-PUD', 'CL-PUD (Pudahuel, Chile)'),
    ('CL-PTA', 'CL-PTA (Puente Alto, Chile)'),
    ('CL-PNG', 'CL-PNG (Puente Negro, Chile)'),
    ('CL-WPA', 'CL-WPA (Puerto Aisén, Chile)'),
    ('CL-PAG', 'CL-PAG (Puerto Angamos, Chile)'),
    ('CL-PSN', 'CL-PSN (Puerto Aysen, Chile)'),
    ('CL-PCH', 'CL-PCH (Puerto Chacabuco, Chile)'),
    ('CL-CIS', 'CL-CIS (Puerto Cisnes, Chile)'),
    ('CL-EDE', 'CL-EDE (Puerto Edén, Chile)'),
    ('CL-PMC', 'CL-PMC (Puerto Montt, Chile)'),
    ('CL-PNT', 'CL-PNT (Puerto Natales, Chile)'),
    ('CL-POC', 'CL-POC (Puerto Octay, Chile)'),
    ('CL-PAT', 'CL-PAT (Puerto Patache, Chile)'),
    ('CL-PPY', 'CL-PPY (Puerto Percy, Chile)'),
    ('CL-PVS', 'CL-PVS (Puerto Varas, Chile)'),
    ('CL-WPU', 'CL-WPU (Puerto Williams, Chile)'),
    ('CL-PUM', 'CL-PUM (Pumanque, Chile)'),
    ('CL-PUN', 'CL-PUN (Punitaqui, Chile)'),
    ('CL-PUQ', 'CL-PUQ (Punta Arenas, Chile)'),
    ('CL-PTC', 'CL-PTC (Punta Chungo, Chile)'),
    ('CL-PPD', 'CL-PPD (Punta Padrones, Chile)'),
    ('CL-PPC', 'CL-PPC (Punta Patache, Chile)'),
    ('CL-PQD', 'CL-PQD (Puqueldón, Chile)'),
    ('CL-PRQ', 'CL-PRQ (Purranque, Chile)'),
    ('CL-PUR', 'CL-PUR (Purén, Chile)'),
    ('CL-PTO', 'CL-PTO (Putaendo, Chile)'),
    ('CL-PUT', 'CL-PUT (Putre, Chile)'),
    ('CL-PYH', 'CL-PYH (Puyehue, Chile)'),
    ('CL-QLN', 'CL-QLN (Queilén, Chile)'),
    ('CL-PTE', 'CL-PTE (Quellón (Puerto Quellón), Chile)'),
    ('CL-QUV', 'CL-QUV (Quellón Viejo, Chile)'),
    ('CL-QMC', 'CL-QMC (Quemchi, Chile)'),
    ('CL-QLA', 'CL-QLA (Quilaco, Chile)'),
    ('CL-QUI', 'CL-QUI (Quilicura, Chile)'),
    ('CL-QLO', 'CL-QLO (Quilleco, Chile)'),
    ('CL-QTA', 'CL-QTA (Quillota, Chile)'),
    ('CL-QIN', 'CL-QIN (Quillón, Chile)'),
    ('CL-QIL', 'CL-QIL (Quilpué, Chile)'),
    ('CL-QCO', 'CL-QCO (Quinchao, Chile)'),
    ('CL-QDT', 'CL-QDT (Quinta de Tilcoco, Chile)'),
    ('CL-QNO', 'CL-QNO (Quinta Normal, Chile)'),
    ('CL-QTV', 'CL-QTV (Quintero, Chile)'),
    ('CL-QRH', 'CL-QRH (Quirihue, Chile)'),
    ('CL-QRC', 'CL-QRC (Rancagua, Chile)'),
    ('CL-RAP', 'CL-RAP (Rapel, Chile)'),
    ('CL-RAF', 'CL-RAF (Rauco, Chile)'),
    ('CL-RAU', 'CL-RAU (Rauco, Chile)'),
    ('CL-REC', 'CL-REC (Recoleta, Chile)'),
    ('CL-RNO', 'CL-RNO (Renaico, Chile)'),
    ('CL-REN', 'CL-REN (Renca, Chile)'),
    ('CL-RGO', 'CL-RGO (Rengo, Chile)'),
    ('CL-REQ', 'CL-REQ (Requínoa, Chile)'),
    ('CL-RET', 'CL-RET (Retiro, Chile)'),
    ('CL-RIN', 'CL-RIN (Rinconada de Los Andes, Chile)'),
    ('CL-RSD', 'CL-RSD (Rocas de Santo Domingo, Chile)'),
    ('CL-ROM', 'CL-ROM (Romeral, Chile)'),
    ('CL-ROS', 'CL-ROS (Rosario, Chile)'),
    ('CL-RAN', 'CL-RAN (Ránquil, Chile)'),
    ('CL-RBU', 'CL-RBU (Río Bueno, Chile)'),
    ('CL-RCL', 'CL-RCL (Río Claro, Chile)'),
    ('CL-RIB', 'CL-RIB (Río Ibáñez, Chile)'),
    ('CL-RNE', 'CL-RNE (Río Negro, Chile)'),
    ('CL-RVE', 'CL-RVE (Río Verde, Chile)'),
    ('CL-SAA', 'CL-SAA (Saavedra, Chile)'),
    ('CL-SAF', 'CL-SAF (Sagrada Familia, Chile)'),
    ('CL-SAL', 'CL-SAL (Salamanca, Chile)'),
    ('CL-SAI', 'CL-SAI (San Antonio, Chile)'),
    ('CL-SBD', 'CL-SBD (San Bernardo, Chile)'),
    ('CL-SCR', 'CL-SCR (San Carlos, Chile)'),
    ('CL-SCT', 'CL-SCT (San Clemente, Chile)'),
    ('CL-SES', 'CL-SES (San Esteban, Chile)'),
    ('CL-SFN', 'CL-SFN (San Fabián, Chile)'),
    ('CL-SFP', 'CL-SFP (San Felipe, Chile)'),
    ('CL-SFD', 'CL-SFD (San Fernando, Chile)'),
    ('CL-MOS', 'CL-MOS (San Francisco de Mostazal, Chile)'),
    ('CL-SGR', 'CL-SGR (San Gregorio, Chile)'),
    ('CL-SIN', 'CL-SIN (San Ignacio, Chile)'),
    ('CL-SJV', 'CL-SJV (San Javier, Chile)'),
    ('CL-SJQ', 'CL-SJQ (San Joaquín, Chile)'),
    ('CL-SJM', 'CL-SJM (San José de Maipo, Chile)'),
    ('CL-SJC', 'CL-SJC (San Juan de la Costa, Chile)'),
    ('CL-SMG', 'CL-SMG (San Miguel, Chile)'),
    ('CL-SNI', 'CL-SNI (San Nicolás, Chile)'),
    ('CL-SPB', 'CL-SPB (San Pablo, Chile)'),
    ('CL-SPE', 'CL-SPE (San Pedro, Chile)'),
    ('CL-SPA', 'CL-SPA (San Pedro de Atacama, Chile)'),
    ('CL-SPP', 'CL-SPP (San Pedro de la Paz, Chile)'),
    ('CL-SRA', 'CL-SRA (San Rafael, Chile)'),
    ('CL-SRM', 'CL-SRM (San Ramón, Chile)'),
    ('CL-SRO', 'CL-SRO (San Rosendo, Chile)'),
    ('CL-SVE', 'CL-SVE (San Vicente, Chile)'),
    ('CL-SVT', 'CL-SVT (San Vicente, Chile)'),
    ('CL-STT', 'CL-STT (San Vicente de Tagua Tagua, Chile)'),
    ('CL-SBA', 'CL-SBA (Santa Bárbara, Chile)'),
    ('CL-SCZ', 'CL-SCZ (Santa Cruz, Chile)'),
    ('CL-SJU', 'CL-SJU (Santa Juana, Chile)'),
    ('CL-SMA', 'CL-SMA (Santa María, Chile)'),
    ('CL-SCL', 'CL-SCL (Santiago, Chile)'),
    ('CL-SDO', 'CL-SDO (Santo Domingo, Chile)'),
    ('CL-SIG', 'CL-SIG (Sierra Gorda, Chile)'),
    ('CL-TLG', 'CL-TLG (Talagante, Chile)'),
    ('CL-TLX', 'CL-TLX (Talca, Chile)'),
    ('CL-TAL', 'CL-TAL (Talcahuano, Chile)'),
    ('CL-TTC', 'CL-TTC (Taltal, Chile)'),
    ('CL-TAA', 'CL-TAA (Tamentica, Chile)'),
    ('CL-ZCO', 'CL-ZCO (Temuco, Chile)'),
    ('CL-TEN', 'CL-TEN (Teno, Chile)'),
    ('CL-TEO', 'CL-TEO (Teodoro Schmidt, Chile)'),
    ('CL-TAM', 'CL-TAM (Tierra Amarilla, Chile)'),
    ('CL-TIL', 'CL-TIL (Tiltil, Chile)'),
    ('CL-TIM', 'CL-TIM (Timaukel, Chile)'),
    ('CL-TIR', 'CL-TIR (Tirúa, Chile)'),
    ('CL-TOQ', 'CL-TOQ (Tocopilla, Chile)'),
    ('CL-TOL', 'CL-TOL (Toltén, Chile)'),
    ('CL-TOM', 'CL-TOM (Tomé, Chile)'),
    ('CL-TON', 'CL-TON (Tongoy, Chile)'),
    ('CL-TDP', 'CL-TDP (Torres del Paine, Chile)'),
    ('CL-TOR', 'CL-TOR (Tortel, Chile)'),
    ('CL-TRA', 'CL-TRA (Traiguén, Chile)'),
    ('CL-TRE', 'CL-TRE (Treguaco, Chile)'),
    ('CL-TPI', 'CL-TPI (Tres Pinos, Chile)'),
    ('CL-TPT', 'CL-TPT (Tres Puentes, Chile)'),
    ('CL-TUC', 'CL-TUC (Tucapel, Chile)'),
    ('CL-ZAL', 'CL-ZAL (Valdivia, Chile)'),
    ('CL-VLR', 'CL-VLR (Vallenar, Chile)'),
    ('CL-VAP', 'CL-VAP (Valparaiso, Chile)'),
    ('CL-VEN', 'CL-VEN (Ventanas, Chile)'),
    ('CL-VNT', 'CL-VNT (Ventanas, Chile)'),
    ('CL-VCQ', 'CL-VCQ (Vichuquén, Chile)'),
    ('CL-ZIC', 'CL-ZIC (Victoria, Chile)'),
    ('CL-VIC', 'CL-VIC (Vicuña, Chile)'),
    ('CL-VCN', 'CL-VCN (Vilcún, Chile)'),
    ('CL-VAG', 'CL-VAG (Villa Alegre, Chile)'),
    ('CL-VIA', 'CL-VIA (Villa Alemana, Chile)'),
    ('CL-VIL', 'CL-VIL (Villarrica, Chile)'),
    ('CL-VLC', 'CL-VLC (Viluco, Chile)'),
    ('CL-VIT', 'CL-VIT (Vitacura, Chile)'),
    ('CL-KNA', 'CL-KNA (Viña del Mar, Chile)'),
    ('CL-YBU', 'CL-YBU (Yerbas Buenas, Chile)'),
    ('CL-YUM', 'CL-YUM (Yumbel, Chile)'),
    ('CL-YUN', 'CL-YUN (Yungay, Chile)'),
    ('CL-ZAP', 'CL-ZAP (Zapallar, Chile)'),
    ('CL-ZFI', 'CL-ZFI (Zona Franca de Iquique, Chile)'),
    ('CL-NQN', 'CL-NQN (Ñiquén, Chile)'),
    ('CL-NUN', 'CL-NUN (Ñuñoa, Chile)'),
    ('CM-BFX', 'CM-BFX (Bafoussam, Cameroon)'),
    ('CM-BLC', 'CM-BLC (Bali, Cameroon)'),
    ('CM-BPC', 'CM-BPC (Bamenda, Cameroon)'),
    ('CM-OUR', 'CM-OUR (Batouri, Cameroon)'),
    ('CM-BTA', 'CM-BTA (Bertoua, Cameroon)'),
    ('CM-BNB', 'CM-BNB (Bonabéri, Cameroon)'),
    ('CM-BUA', 'CM-BUA (Buea, Cameroon)'),
    ('CM-BEL', 'CM-BEL (Bélabo, Cameroon)'),
    ('CM-CMO', 'CM-CMO (Campo, Cameroon)'),
    ('CM-DLA', 'CM-DLA (Douala, Cameroon)'),
    ('CM-DSC', 'CM-DSC (Dschang, Cameroon)'),
    ('CM-EBW', 'CM-EBW (Ebolowa, Cameroon)'),
    ('CM-EBT', 'CM-EBT (Ebomé Terminal, Cameroon)'),
    ('CM-EDA', 'CM-EDA (Edéa, Cameroon)'),
    ('CM-EKO', 'CM-EKO (Ekok, Cameroon)'),
    ('CM-FOM', 'CM-FOM (Foumban, Cameroon)'),
    ('CM-GOU', 'CM-GOU (Garoua, Cameroon)'),
    ('CM-GRB', 'CM-GRB (Garoua Boulaï, Cameroon)'),
    ('CM-KLE', 'CM-KLE (Kaele, Cameroon)'),
    ('CM-KOL', 'CM-KOL (Kole Terminal, Cameroon)'),
    ('CM-KSI', 'CM-KSI (Kousséri, Cameroon)'),
    ('CM-KOB', 'CM-KOB (Koutaba, Cameroon)'),
    ('CM-KBI', 'CM-KBI (Kribi, Cameroon)'),
    ('CM-KUM', 'CM-KUM (Kumba, Cameroon)'),
    ('CM-KYE', 'CM-KYE (Kye-Ossi, Cameroon)'),
    ('CM-LIM', 'CM-LIM (Limbe, Cameroon)'),
    ('CM-LIT', 'CM-LIT (Limboh Terminal, Cameroon)'),
    ('CM-MMF', 'CM-MMF (Mamfe, Cameroon)'),
    ('CM-MVR', 'CM-MVR (Maroua, Cameroon)'),
    ('CM-MSG', 'CM-MSG (Massongo Terminal, Cameroon)'),
    ('CM-MBA', 'CM-MBA (Mbalmayo, Cameroon)'),
    ('CM-MOR', 'CM-MOR (Mora, Cameroon)'),
    ('CM-MOU', 'CM-MOU (Moudi Terminal, Cameroon)'),
    ('CM-NDP', 'CM-NDP (Ndop, Cameroon)'),
    ('CM-NGE', 'CM-NGE (Ngaoundéré, Cameroon)'),
    ('CM-NKS', 'CM-NKS (Nkongsamba, Cameroon)'),
    ('CM-TKC', 'CM-TKC (Tiko, Cameroon)'),
    ('CM-VIC', 'CM-VIC (Victoria, Cameroon)'),
    ('CM-GXX', 'CM-GXX (Yagoua, Cameroon)'),
    ('CM-YAO', 'CM-YAO (Yaoundé, Cameroon)'),
    ('CN-ARS', 'CN-ARS (Yaoundé, Cameroon)'),
    ('CN-AHK', 'CN-AHK (Yaoundé, Cameroon)'),
    ('CN-AID', 'CN-AID (Yaoundé, Cameroon)'),
    ('CN-AKU', 'CN-AKU (Yaoundé, Cameroon)'),
    ('CN-AKL', 'CN-AKL (Yaoundé, Cameroon)'),
    ('CN-AAT', 'CN-AAT (Yaoundé, Cameroon)'),
    ('CN-ANJ', 'CN-ANJ (Anji, Zhejiang Sheng, China)'),
    ('CN-AKA', 'CN-AKA (Ankang Wulipu Apt, Shaanxi Sheng, China)'),
    ('CN-ANN', 'CN-ANN (Anning, Yunnan Sheng, China)'),
    ('CN-ANP', 'CN-ANP (Anping, Liaoning Sheng, China)'),
    ('CN-APP', 'CN-APP (Anpu, Guangdong Sheng, China)'),
    ('CN-AQG', 'CN-AQG (Anqing Pt, Anhui Sheng, China)'),
    ('CN-ANQ', 'CN-ANQ (Anqiu, Shandong Sheng, China)'),
    ('CN-ASN', 'CN-ASN (Anshan, Liaoning Sheng, China)'),
    ('CN-AOG', "CN-AOG (Anshan Teng'ao Apt, Liaoning Sheng, China)"),
    ('CN-ANS', 'CN-ANS (Anshun, Guizhou Sheng, China)'),
    ('CN-ANT', 'CN-ANT (Anshun, Guizhou Sheng, China)'),
    ('CN-AYS', 'CN-AYS (Anyang, Henan Sheng, China)'),
    ('CN-AJG', 'CN-AJG (Aojiang Pt, Zhejiang Sheng, China)'),
    ('CN-ASW', 'CN-ASW (Aoshanwei, Shandong Sheng, China)'),
    ('CN-ART', 'CN-ART (Aoshanwei, Shandong Sheng, China)'),
    ('CN-ASM', 'CN-ASM (Aoshanwei, Shandong Sheng, China)'),
    ('CN-BCO', 'CN-BCO (Bacao, Guizhou Sheng, China)'),
    ('CN-BDG', 'CN-BDG (Badong, Hubei Sheng, China)'),
    ('CN-BGG', 'CN-BGG (Bagong, Guizhou Sheng, China)'),
    ('CN-BAH', 'CN-BAH (Bahe, Hubei Sheng, China)'),
    ('CN-BCG', 'CN-BCG (Baiceng, Guizhou Sheng, China)'),
    ('CN-BAI', 'CN-BAI (Baicheng, Jilin Sheng, China)'),
    ('CN-BLO', 'CN-BLO (Bailuo, Hubei Sheng, China)'),
    ('CN-BMJ', 'CN-BMJ (Baimajing, Hainan Sheng, China)'),
    ('CN-IMA', 'CN-IMA (Baimao, Shandong Sheng, China)'),
    ('CN-BSE', 'CN-BSE (Baimao, Shandong Sheng, China)'),
    ('CN-BSH', 'CN-BSH (Baimao, Shandong Sheng, China)'),
    ('CN-BSI', 'CN-BSI (Baishi, Heilongjiang Sheng, China)'),
    ('CN-BYG', 'CN-BYG (Baiyang, Hubei Sheng, China)'),
    ('CN-BYU', 'CN-BYU (Baiyun, Guangdong Sheng, China)'),
    ('CN-BKT', 'CN-BKT (Baiyun, Guangdong Sheng, China)'),
    ('CN-BLI', 'CN-BLI (Bali, Hubei Sheng, China)'),
    ('CN-BPX', 'CN-BPX (Bali, Hubei Sheng, China)'),
    ('CN-BON', "CN-BON (Bao'an, Guangdong Sheng, China)"),
    ('CN-BDZ', 'CN-BDZ (Baoding, Hebei Sheng, China)'),
    ('CN-BOJ', 'CN-BOJ (Baoji, Shaanxi Sheng, China)'),
    ('CN-BQI', 'CN-BQI (Baoqing, Heilongjiang Sheng, China)'),
    ('CN-BAN', 'CN-BAN (Baoshan, Yunnan Sheng, China)'),
    ('CN-BSD', 'CN-BSD (Baoshan, Yunnan Sheng, China)'),
    ('CN-BOT', 'CN-BOT (Baoshan, Yunnan Sheng, China)'),
    ('CN-BYI', 'CN-BYI (Baoshan, Yunnan Sheng, China)'),
    ('CN-BSP', 'CN-BSP (Basuo Pt, Hainan Sheng, China)'),
    ('CN-BAU', 'CN-BAU (Baxu, Jiangsu Sheng, China)'),
    ('CN-BYA', 'CN-BYA (Bayan, Heilongjiang Sheng, China)'),
    ('CN-BYO', 'CN-BYO (Bayan, Heilongjiang Sheng, China)'),
    ('CN-BSX', 'CN-BSX (Bayan, Heilongjiang Sheng, China)'),
    ('CN-BYQ', 'CN-BYQ (Bayuquan, Liaoning Sheng, China)'),
    ('CN-BAZ', 'CN-BAZ (Bayuquan, Liaoning Sheng, China)'),
    ('CN-BIC', 'CN-BIC (Beicun, Guangdong Sheng, China)'),
    ('CN-BHY', 'CN-BHY (Beicun, Guangdong Sheng, China)'),
    ('CN-BIH', 'CN-BIH (Beicun, Guangdong Sheng, China)'),
    ('CN-BIJ', 'CN-BIJ (Beijiao, Guangdong Sheng, China)'),
    ('CN-BJO', 'CN-BJO (Beijiao, Fujian Sheng, China)'),
    ('CN-BJS', 'CN-BJS (Beijiao, Fujian Sheng, China)'),
    ('CN-BJZ', 'CN-BJZ (Beijiao, Fujian Sheng, China)'),
    ('CN-PEK', 'CN-PEK (Beijiao, Fujian Sheng, China)'),
    ('CN-BJD', 'CN-BJD (Beijiao, Fujian Sheng, China)'),
    ('CN-BJX', 'CN-BJX (Beijiao, Fujian Sheng, China)'),
    ('CN-BLU', 'CN-BLU (Beiliu, Shanxi Sheng, China)'),
    ('CN-BEI', 'CN-BEI (Beilun, Zhejiang Sheng, China)'),
    ('CN-BLG', 'CN-BLG (Beilun Pt, Zhejiang Sheng, China)'),
    ('CN-SXB', 'CN-SXB (Beitan, Guangdong Sheng, China)'),
    ('CN-BIY', 'CN-BIY (Beiyao, Guangdong Sheng, China)'),
    ('CN-BZN', 'CN-BZN (Beiyao, Guangdong Sheng, China)'),
    ('CN-BBU', 'CN-BBU (Bengbu, Anhui Sheng, China)'),
    ('CN-BXS', 'CN-BXS (Benxi, Liaoning Sheng, China)'),
    ('CN-PHB', 'CN-PHB (Bijia, Guangdong Sheng, China)'),
    ('CN-BCA', 'CN-BCA (Binchuan, Yunnan Sheng, China)'),
    ('CN-BHX', 'CN-BHX (Binhai, Jiangsu Sheng, China)'),
    ('CN-BYN', 'CN-BYN (Binyang, Fujian Sheng, China)'),
    ('CN-BIN', 'CN-BIN (Binzhou, Shandong Sheng, China)'),
    ('CN-BOA', 'CN-BOA (Boao, Hainan Sheng, China)'),
    ('CN-BOB', 'CN-BOB (Boao, Hainan Sheng, China)'),
    ('CN-DBX', 'CN-DBX (Bohe, Guangdong Sheng, China)'),
    ('CN-BOO', 'CN-BOO (Boluo, Guangdong Sheng, China)'),
    ('CN-BOS', 'CN-BOS (Boluo, Guangdong Sheng, China)'),
    ('CN-BXI', 'CN-BXI (Boluo, Guangdong Sheng, China)'),
    ('CN-BZG', 'CN-BZG (Boluo, Guangdong Sheng, China)'),
    ('CN-BOZ', 'CN-BOZ (Boluo, Guangdong Sheng, China)'),
    ('CN-BHE', 'CN-BHE (Buhe, Hubei Sheng, China)'),
    ('CN-BUJ', 'CN-BUJ (Buji, Guangdong Sheng, China)'),
    ('CN-BUR', 'CN-BUR (Buji, Guangdong Sheng, China)'),
    ('CN-BRJ', 'CN-BRJ (Buji, Guangdong Sheng, China)'),
    ('CN-CYB', 'CN-CYB (Buji, Guangdong Sheng, China)'),
    ('CN-CGN', 'CN-CGN (Cangnan, Zhejiang Sheng, China)'),
    ('CN-GSA', 'CN-GSA (Cangshan, Shandong Sheng, China)'),
    ('CN-CGW', 'CN-CGW (Cangshan, Shandong Sheng, China)'),
    ('CN-CGX', 'CN-CGX (Cangshan, Shandong Sheng, China)'),
    ('CN-CGY', 'CN-CGY (Cangyuan, Yunnan Sheng, China)'),
    ('CN-CZZ', 'CN-CZZ (Cangzhou, Hebei Sheng, China)'),
    ('CN-CFD', 'CN-CFD (Caofeidian Pt, Hebei Sheng, China)'),
    ('CN-CJG', 'CN-CJG (Caofeidian Pt, Hebei Sheng, China)'),
    ('CN-CEK', 'CN-CEK (Caofeidian Pt, Hebei Sheng, China)'),
    ('CN-CEX', 'CN-CEX (Caofeidian Pt, Hebei Sheng, China)'),
    ('CN-CAW', 'CN-CAW (Chaiwan, Jiangsu Sheng, China)'),
    ('CN-CHO', 'CN-CHO (Chang on, Guangdong Sheng, China)'),
    ('CN-CHN', "CN-CHN (Chang'an, Shaanxi Sheng, China)"),
    ('CN-FKC', 'CN-FKC (Changan, Guangdong Sheng, China)'),
    ('CN-CGB', 'CN-CGB (Changbai, Jilin Sheng, China)'),
    ('CN-CGP', 'CN-CGP (Changbai, Jilin Sheng, China)'),
    ('CN-CGC', 'CN-CGC (Changchun, Jilin Sheng, China)'),
    ('CN-CGQ', 'CN-CGQ (Changchun Longjia International Apt, Jilin Sheng, China)'),
    ('CN-CCD', 'CN-CCD (Changchundong Railway Station, Jilin Sheng, China)'),
    ('CN-CDO', 'CN-CDO (Changdao, Shandong Sheng, China)'),
    ('CN-CGD', 'CN-CGD (Changde, Hunan Sheng, China)'),
    ('CN-CDH', 'CN-CDH (Changdianhekou, Liaoning Sheng, China)'),
    ('CN-CNI', 'CN-CNI (Changhai Dachangshandao Apt, Liaoning Sheng, China)'),
    ('CN-CAH', 'CN-CAH (Changhua, Hainan Sheng, China)'),
    ('CN-CJS', 'CN-CJS (Changhua, Hainan Sheng, China)'),
    ('CN-CLZ', 'CN-CLZ (Changjiang Lizu Zizhixian, Hainan Sheng, China)'),
    ('CN-CGJ', 'CN-CGJ (Changjing, Jiangsu Sheng, China)'),
    ('CN-CHA', 'CN-CHA (Changle, Fujian Sheng, China)'),
    ('CN-CGI', 'CN-CGI (Changliu, Hainan Sheng, China)'),
    ('CN-CPI', 'CN-CPI (Changping, Guangdong Sheng, China)'),
    ('CN-CNA', 'CN-CNA (Changsha, Guangdong Sheng, China)'),
    ('CN-CSH', 'CN-CSH (Changsha, Hunan Sheng, China)'),
    ('CN-CSX', 'CN-CSX (Changsha Huanghua International Apt, Hunan Sheng, China)'),
    ('CN-CSD', 'CN-CSD (Changshadibg Railway Station, Hunan Sheng, China)'),
    ('CN-CSJ', 'CN-CSJ (Changshou, Jiangsu Sheng, China)'),
    ('CN-CSO', 'CN-CSO (Changshou, Jiangsu Sheng, China)'),
    ('CN-CGS', 'CN-CGS (Changshu Pt, Jiangsu Sheng, China)'),
    ('CN-CNT', 'CN-CNT (Changshu Pt, Jiangsu Sheng, China)'),
    ('CN-CIH', 'CN-CIH (Changzhi, Shanxi Sheng, China)'),
    ('CN-CZX', 'CN-CZX (Changzhou Pt, Jiangsu Sheng, China)'),
    ('CN-CON', 'CN-CON (Chaoan, Guangdong Sheng, China)'),
    ('CN-CHU', 'CN-CHU (Chaohu, Anhui Sheng, China)'),
    ('CN-CTM', 'CN-CTM (Chaohu, Anhui Sheng, China)'),
    ('CN-CYN', 'CN-CYN (Chaoyang, Liaoning Sheng, China)'),
    ('CN-CHY', 'CN-CHY (Chaoyang Pt, Guangdong Sheng, China)'),
    ('CN-COZ', 'CN-COZ (Chaozhou Pt, Guangdong Sheng, China)'),
    ('CN-CBG', 'CN-CBG (Chaozhou Pt, Guangdong Sheng, China)'),
    ('CN-CUN', 'CN-CUN (Chencun, Guangdong Sheng, China)'),
    ('CN-CHE', 'CN-CHE (Chengaogang, Fujian Sheng, China)'),
    ('CN-CHH', 'CN-CHH (Chengaogang, Fujian Sheng, China)'),
    ('CN-CNG', 'CN-CNG (Chengde, Hebei Sheng, China)'),
    ('CN-CDU', 'CN-CDU (Chengdu, Sichuan Sheng, China)'),
    ('CN-CDZ', 'CN-CDZ (Chengdu Railway Station, Sichuan Sheng, China)'),
    ('CN-CTU', 'CN-CTU (Chengdu Shuangliu International Apt, Sichuan Sheng, China)'),
    ('CN-CHG', 'CN-CHG (Chenghai, Guangdong Sheng, China)'),
    ('CN-CJI', 'CN-CJI (Chengjiang, Jiangsu Sheng, China)'),
    ('CN-CLJ', 'CN-CLJ (Chenglingji Pt, Hunan Sheng, China)'),
    ('CN-CHX', 'CN-CHX (Chenglingji Pt, Hunan Sheng, China)'),
    ('CN-CIG', 'CN-CIG (Chenjiagang, Jiangsu Sheng, China)'),
    ('CN-CJN', 'CN-CJN (Chenjiagang, Jiangsu Sheng, China)'),
    ('CN-CJP', 'CN-CJP (Chenjiagang, Jiangsu Sheng, China)'),
    ('CN-CNZ', 'CN-CNZ (Chenzhou, Hunan Sheng, China)'),
    ('CN-CBI', 'CN-CBI (Chibi, Hubei Sheng, China)'),
    ('CN-CFS', 'CN-CFS (Chibi, Hubei Sheng, China)'),
    ('CN-CKA', 'CN-CKA (Chikan, Guangdong Sheng, China)'),
    ('CN-CWN', 'CN-CWN (Chiwan Pt, Guangdong Sheng, China)'),
    ('CN-CHI', 'CN-CHI (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-CGM', 'CN-CGM (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-CQI', 'CN-CQI (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-CKG', 'CN-CKG (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-CHQ', 'CN-CHQ (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-CQD', 'CN-CQD (Chizhou Pt, Anhui Sheng, China)'),
    ('CN-QZC', 'CN-QZC (Chongwu, Fujian Sheng, China)'),
    ('CN-CXN', 'CN-CXN (Chongxing, Hainan Sheng, China)'),
    ('CN-CGH', 'CN-CGH (Chongzhou, Sichuan Sheng, China)'),
    ('CN-CGZ', 'CN-CGZ (Chongzhou, Sichuan Sheng, China)'),
    ('CN-CHS', 'CN-CHS (Chuanshan, Zhejiang Sheng, China)'),
    ('CN-CUM', 'CN-CUM (Chumen, Zhejiang Sheng, China)'),
    ('CN-UNA', 'CN-UNA (Chumen, Zhejiang Sheng, China)'),
    ('CN-CUA', 'CN-CUA (Chunhua, Shaanxi Sheng, China)'),
    ('CN-CXI', 'CN-CXI (Chuxiong, Yunnan Sheng, China)'),
    ('CN-CHZ', 'CN-CHZ (Chuzhou, Anhui Sheng, China)'),
    ('CN-CUZ', 'CN-CUZ (Chuzhuangsi, Anhui Sheng, China)'),
    ('CN-CCH', 'CN-CCH (Cicheng, Zhejiang Sheng, China)'),
    ('CN-CIV', 'CN-CIV (Civet / Guandong, Guangdong Sheng, China)'),
    ('CN-CIX', 'CN-CIX (Cixi, Zhejiang Sheng, China)'),
    ('CN-CNH', 'CN-CNH (Conghua, Guangdong Sheng, China)'),
    ('CN-CJA', 'CN-CJA (Congjiang, Guizhou Sheng, China)'),
    ('CN-CTN', 'CN-CTN (Congjiang, Guizhou Sheng, China)'),
    ('CN-DCB', 'CN-DCB (DA CHAN BAY, Guangdong Sheng, China)'),
    ('CN-DAN', 'CN-DAN (Daan, Jilin Sheng, China)'),
    ('CN-DCH', 'CN-DCH (Daan, Jilin Sheng, China)'),
    ('CN-DDD', 'CN-DDD (Dadeng I., Fujian Sheng, China)'),
    ('CN-DIZ', 'CN-DIZ (Dadingzi, Heilongjiang Sheng, China)'),
    ('CN-DDK', 'CN-DDK (Dadukou, Anhui Sheng, China)'),
    ('CN-DFG', 'CN-DFG (Dafeng Pt, Jiangsu Sheng, China)'),
    ('CN-AGG', 'CN-AGG (Dagang, Guangdong Sheng, China)'),
    ('CN-DAA', 'CN-DAA (Dagang, Jiangsu Sheng, China)'),
    ('CN-DHP', 'CN-DHP (Dahuangpu, Guangdong Sheng, China)'),
    ('CN-DJI', 'CN-DJI (Dajing, Zhejiang Sheng, China)'),
    ('CN-DLG', 'CN-DLG (Dalang, Guangdong Sheng, China)'),
    ('CN-ALI', 'CN-ALI (Dali, Guangdong Sheng, China)'),
    ('CN-DLU', 'CN-DLU (Dali Apt, Yunnan Sheng, China)'),
    ('CN-DAL', 'CN-DAL (Dalian, Liaoning Sheng, China)'),
    ('CN-DAG', 'CN-DAG (Dalian Pt, Liaoning Sheng, China)'),
    ('CN-DLC', 'CN-DLC (Dalian Zhoushuizi International Apt, Liaoning Sheng, China)'),
    ('CN-DLN', 'CN-DLN (Dalingshan, Guangdong Sheng, China)'),
    ('CN-DLD', 'CN-DLD (Dalu Island, Liaoning Sheng, China)'),
    ('CN-DLO', 'CN-DLO (Daluo, Yunnan Sheng, China)'),
    ('CN-DMY', 'CN-DMY (Damaiyu, Zhejiang Sheng, China)'),
    ('CN-DDZ', 'CN-DDZ (Dandong, Liaoning Sheng, China)'),
    ('CN-DDG', 'CN-DDG (Dandong Pt, Liaoning Sheng, China)'),
    ('CN-DNS', 'CN-DNS (Danshui, Guangdong Sheng, China)'),
    ('CN-FZL', 'CN-FZL (Dantou, Fujian Sheng, China)'),
    ('CN-DNT', 'CN-DNT (Dantu, Jiangsu Sheng, China)'),
    ('CN-DNY', 'CN-DNY (Danyang, Jiangsu Sheng, China)'),
    ('CN-DNZ', 'CN-DNZ (Danzao, Guangdong Sheng, China)'),
    ('CN-DZM', 'CN-DZM (Danzhimatou, Liaoning Sheng, China)'),
    ('CN-DHU', 'CN-DHU (Danzhimatou, Liaoning Sheng, China)'),
    ('CN-DZO', 'CN-DZO (Danzhou, Hainan Sheng, China)'),
    ('CN-DJO', 'CN-DJO (Daojiao, Guangdong Sheng, China)'),
    ('CN-DPG', 'CN-DPG (Dapeng, Guangdong Sheng, China)'),
    ('CN-DQD', 'CN-DQD (Daqindao, Shandong Sheng, China)'),
    ('CN-DQG', 'CN-DQG (Daqing, Heilongjiang Sheng, China)'),
    ('CN-DSA', 'CN-DSA (Dasha, Hubei Sheng, China)'),
    ('CN-DST', 'CN-DST (Dasha, Guangdong Sheng, China)'),
    ('CN-DAS', 'CN-DAS (Dasha, Guangdong Sheng, China)'),
    ('CN-DSO', 'CN-DSO (Dasong, Zhejiang Sheng, China)'),
    ('CN-DTZ', 'CN-DTZ (Dataizi, Liaoning Sheng, China)'),
    ('CN-DTG', 'CN-DTG (Datian, Fujian Sheng, China)'),
    ('CN-DAT', 'CN-DAT (Datong, Shanxi Sheng, China)'),
    ('CN-DAW', 'CN-DAW (Datong, Shanxi Sheng, China)'),
    ('CN-DWN', 'CN-DWN (Dawan, Shandong Sheng, China)'),
    ('CN-DWA', 'CN-DWA (Dawan, Shandong Sheng, China)'),
    ('CN-DKO', 'CN-DKO (Dawan, Shandong Sheng, China)'),
    ('CN-DAX', 'CN-DAX (Daxie Pt, Zhejiang Sheng, China)'),
    ('CN-PKX', 'CN-PKX (Daxie Pt, Zhejiang Sheng, China)'),
    ('CN-DXU', 'CN-DXU (Daxie Pt, Zhejiang Sheng, China)'),
    ('CN-DYW', 'CN-DYW (Dayaowan, Liaoning Sheng, China)'),
    ('CN-DAY', 'CN-DAY (Dayawan, Guangdong Sheng, China)'),
    ('CN-DYI', 'CN-DYI (Dayi, Jiangsu Sheng, China)'),
    ('CN-DAZ', 'CN-DAZ (Daze, Guangdong Sheng, China)'),
    ('CN-DZY', 'CN-DZY (Daze, Guangdong Sheng, China)'),
    ('CN-DZU', 'CN-DZU (Dazu, Sichuan Sheng, China)'),
    ('CN-DEF', 'CN-DEF (Defeng, Guizhou Sheng, China)'),
    ('CN-DEA', 'CN-DEA (Defeng, Guizhou Sheng, China)'),
    ('CN-DHA', 'CN-DHA (Dehua, Guizhou Sheng, China)'),
    ('CN-DEH', 'CN-DEH (Dehua, Guizhou Sheng, China)'),
    ('CN-DEN', 'CN-DEN (Dehua, Guizhou Sheng, China)'),
    ('CN-DIG', 'CN-DIG (Deqen Shangri-La Apt, Yunnan Sheng, China)'),
    ('CN-DEI', 'CN-DEI (Deqen Shangri-La Apt, Yunnan Sheng, China)'),
    ('CN-DEQ', 'CN-DEQ (Deqing, Guangdong Sheng, China)'),
    ('CN-DEX', 'CN-DEX (Dexing, Jiangxi Sheng, China)'),
    ('CN-DEY', 'CN-DEY (Deyang, Sichuan Sheng, China)'),
    ('CN-DEZ', 'CN-DEZ (Dezhou, Shandong Sheng, China)'),
    ('CN-DZS', 'CN-DZS (Dezhou, Hebei Sheng, China)'),
    ('CN-DBI', 'CN-DBI (Dianbai, Guangdong Sheng, China)'),
    ('CN-DDP', 'CN-DDP (Didu, Guangdong Sheng, China)'),
    ('CN-DIA', 'CN-DIA (Digang, Anhui Sheng, China)'),
    ('CN-DGA', 'CN-DGA (Dingan, Hainan Sheng, China)'),
    ('CN-DCE', 'CN-DCE (Dingcheng, Hainan Sheng, China)'),
    ('CN-DGH', 'CN-DGH (Dingcheng, Hainan Sheng, China)'),
    ('CN-DGX', 'CN-DGX (Dingxi, Gansu Sheng, China)'),
    ('CN-DBG', 'CN-DBG (Dongbang, Jiangsu Sheng, China)'),
    ('CN-DCN', 'CN-DCN (Dongbang, Jiangsu Sheng, China)'),
    ('CN-DDW', 'CN-DDW (Dongdaiwan, Fujian Sheng, China)'),
    ('CN-DFA', 'CN-DFA (Dongfang, Hainan Sheng, China)'),
    ('CN-DFN', 'CN-DFN (Dongfeng, Shandong Sheng, China)'),
    ('CN-DGN', 'CN-DGN (Dongfeng, Shandong Sheng, China)'),
    ('CN-DGU', 'CN-DGU (Donggu, Fujian Sheng, China)'),
    ('CN-DGG', 'CN-DGG (Dongguan Pt, Guangdong Sheng, China)'),
    ('CN-DGO', 'CN-DGO (Dongguan Pt, Guangdong Sheng, China)'),
    ('CN-DNG', 'CN-DNG (Donghai, Guangdong Sheng, China)'),
    ('CN-DOH', 'CN-DOH (Donghu, Guangdong Sheng, China)'),
    ('CN-DJG', 'CN-DJG (Donghu, Guangdong Sheng, China)'),
    ('CN-DJK', 'CN-DJK (Dongjiangkou, Guangdong Sheng, China)'),
    ('CN-DJT', 'CN-DJT (Dongjiaotou Pt, Guangdong Sheng, China)'),
    ('CN-DKG', 'CN-DKG (Dongkeng, Jiangxi Sheng, China)'),
    ('CN-DOP', 'CN-DOP (Donglian Port, Guangdong Sheng, China)'),
    ('CN-DLI', 'CN-DLI (Dongliu, Anhui Sheng, China)'),
    ('CN-DOM', 'CN-DOM (Dongliu, Anhui Sheng, China)'),
    ('CN-DON', 'CN-DON (Dongning, Heilongjiang Sheng, China)'),
    ('CN-DGP', 'CN-DGP (Dongping, Guangdong Sheng, China)'),
    ('CN-DSN', 'CN-DSN (Dongshan Pt, Fujian Sheng, China)'),
    ('CN-DSH', 'CN-DSH (Dongshi, Fujian Sheng, China)'),
    ('CN-DSI', 'CN-DSI (Dongshi, Fujian Sheng, China)'),
    ('CN-DSB', 'CN-DSB (Dongshi, Fujian Sheng, China)'),
    ('CN-DGT', 'CN-DGT (Dongshi, Fujian Sheng, China)'),
    ('CN-DOX', 'CN-DOX (Dongshi, Fujian Sheng, China)'),
    ('CN-DYA', 'CN-DYA (Dongshi, Fujian Sheng, China)'),
    ('CN-DYN', 'CN-DYN (Dongying Pt, Shandong Sheng, China)'),
    ('CN-DOZ', 'CN-DOZ (Dongzhang, Jiangsu Sheng, China)'),
    ('CN-DHD', 'CN-DHD (Douhudi, Hubei Sheng, China)'),
    ('CN-DOU', 'CN-DOU (Doumen Pt, Guangdong Sheng, China)'),
    ('CN-DCG', 'CN-DCG (Ducheng, Hubei Sheng, China)'),
    ('CN-DLT', 'CN-DLT (Ducheng, Hubei Sheng, China)'),
    ('CN-DUL', 'CN-DUL (Dulong, Yunnan Sheng, China)'),
    ('CN-DNH', 'CN-DNH (Dunhuang Apt, Gansu Sheng, China)'),
    ('CN-DUR', 'CN-DUR (Duruan Town, Guangdong Sheng, China)'),
    ('CN-DSZ', 'CN-DSZ (Duruan Town, Guangdong Sheng, China)'),
    ('CN-EBD', 'CN-EBD (Duruan Town, Guangdong Sheng, China)'),
    ('CN-ECG', 'CN-ECG (Echeng, Hubei Sheng, China)'),
    ('CN-ESN', 'CN-ESN (Enshi, Hubei Sheng, China)'),
    ('CN-ENH', 'CN-ENH (Enshi Xujiaping Apt, Hubei Sheng, China)'),
    ('CN-EBA', 'CN-EBA (Erba, Anhui Sheng, China)'),
    ('CN-RLC', 'CN-RLC (Erba, Anhui Sheng, China)'),
    ('CN-EGN', 'CN-EGN (Erba, Anhui Sheng, China)'),
    ('CN-ERC', 'CN-ERC (Erba, Anhui Sheng, China)'),
    ('CN-ETK', 'CN-ETK (Ertaokou, Hubei Sheng, China)'),
    ('CN-EZH', 'CN-EZH (Ezhou, Hubei Sheng, China)'),
    ('CN-FKU', 'CN-FKU (Ezhou, Hubei Sheng, China)'),
    ('CN-FAN', 'CN-FAN (Ezhou, Hubei Sheng, China)'),
    ('CN-FCN', 'CN-FCN (Ezhou, Hubei Sheng, China)'),
    ('CN-FAS', 'CN-FAS (Ezhou, Hubei Sheng, China)'),
    ('CN-FAX', 'CN-FAX (Ezhou, Hubei Sheng, China)'),
    ('CN-FEC', 'CN-FEC (Ezhou, Hubei Sheng, China)'),
    ('CN-FCH', 'CN-FCH (Fengcheng, Shandong Sheng, China)'),
    ('CN-FDU', 'CN-FDU (Fengcheng, Shandong Sheng, China)'),
    ('CN-FEN', 'CN-FEN (Fenggang, Guangdong Sheng, China)'),
    ('CN-FGG', 'CN-FGG (Fengguang, Jilin Sheng, China)'),
    ('CN-FJE', 'CN-FJE (Fengguang, Jilin Sheng, China)'),
    ('CN-FKI', 'CN-FKI (Fengkai, Guangdong Sheng, China)'),
    ('CN-FGX', 'CN-FGX (Fengkai, Guangdong Sheng, China)'),
    ('CN-FUO', 'CN-FUO (Foshan Apt, Guangdong Sheng, China)'),
    ('CN-FRT', 'CN-FRT (Foshan New Pt, Guangdong Sheng, China)'),
    ('CN-FOS', 'CN-FOS (Foshan Railway Station, Guangdong Sheng, China)'),
    ('CN-FUC', 'CN-FUC (Fucheng, Guangdong Sheng, China)'),
    ('CN-FAG', 'CN-FAG (Fugang, Guangdong Sheng, China)'),
    ('CN-FUJ', 'CN-FUJ (Fujin, Heilongjiang Sheng, China)'),
    ('CN-FKA', 'CN-FKA (Fujin, Heilongjiang Sheng, China)'),
    ('CN-FLG', 'CN-FLG (Fujin, Heilongjiang Sheng, China)'),
    ('CN-FPG', 'CN-FPG (Fujin, Heilongjiang Sheng, China)'),
    ('CN-FQG', 'CN-FQG (Fujin, Heilongjiang Sheng, China)'),
    ('CN-FUQ', 'CN-FUQ (Fuquan, Guizhou Sheng, China)'),
    ('CN-FSA', 'CN-FSA (Fushan, Jiangsu Sheng, China)'),
    ('CN-FSN', 'CN-FSN (Fushun, Liaoning Sheng, China)'),
    ('CN-FSI', 'CN-FSI (Fushun, Liaoning Sheng, China)'),
    ('CN-FUT', 'CN-FUT (Futian, Guangdong Sheng, China)'),
    ('CN-FWN', 'CN-FWN (Fuwan, Guangdong Sheng, China)'),
    ('CN-FUX', 'CN-FUX (Fuxin, Liaoning Sheng, China)'),
    ('CN-FXG', 'CN-FXG (Fuxing, Anhui Sheng, China)'),
    ('CN-FUN', 'CN-FUN (Fuxing, Anhui Sheng, China)'),
    ('CN-FYS', 'CN-FYS (Fuyang, Anhui Sheng, China)'),
    ('CN-FYX', 'CN-FYX (Fuyang Xiguan Apt, Anhui Sheng, China)'),
    ('CN-FNG', 'CN-FNG (Fuyong, Guangdong Sheng, China)'),
    ('CN-FYG', 'CN-FYG (Fuyong, Yunnan Sheng, China)'),
    ('CN-FUY', 'CN-FUY (Fuyuan, Heilongjiang Sheng, China)'),
    ('CN-FYN', 'CN-FYN (Fuyuan, Heilongjiang Sheng, China)'),
    ('CN-FUZ', 'CN-FUZ (Fuzhou, Jiangxi Sheng, China)'),
    ('CN-FZH', 'CN-FZH (Fuzhou, Fujian Sheng, China)'),
    ('CN-FOC', 'CN-FOC (Fuzhou Changle International Apt, Fujian Sheng, China)'),
    ('CN-FZG', 'CN-FZG (Fuzhou Pt, Fujian Sheng, China)'),
    ('CN-FZX', 'CN-FZX (Fuzhouxingang, Fujian Sheng, China)'),
    ('CN-GAI', 'CN-GAI (Fuzhouxingang, Fujian Sheng, China)'),
    ('CN-GAL', 'CN-GAL (Galolan, Jiangxi Sheng, China)'),
    ('CN-GUL', 'CN-GUL (Gangluan, Shandong Sheng, China)'),
    ('CN-GQD', 'CN-GQD (Gangluan, Shandong Sheng, China)'),
    ('CN-GZH', 'CN-GZH (Ganzhou, Jiangxi Sheng, China)'),
    ('CN-KOW', 'CN-KOW (Ganzhou Huangjin Apt, Jiangxi Sheng, China)'),
    ('CN-GBU', 'CN-GBU (Gaobu, Guangdong Sheng, China)'),
    ('CN-GOC', 'CN-GOC (Gaobu, Guangdong Sheng, China)'),
    ('CN-GAO', 'CN-GAO (Gaogang, Jiangsu Sheng, China)'),
    ('CN-GLA', 'CN-GLA (Gaolan, Jiangxi Sheng, China)'),
    ('CN-GLN', 'CN-GLN (Gaolan, Gansu Sheng, China)'),
    ('CN-GON', 'CN-GON (Gaolan, Guangdong Sheng, China)'),
    ('CN-GLG', 'CN-GLG (Gaoleng, Heilongjiang Sheng, China)'),
    ('CN-GMI', 'CN-GMI (Gaoleng, Heilongjiang Sheng, China)'),
    ('CN-GOM', 'CN-GOM (Gaoming Pt, Guangdong Sheng, China)'),
    ('CN-GSH', 'CN-GSH (Gaosha, Guangdong Sheng, China)'),
    ('CN-GTG', 'CN-GTG (Gaotang, Shandong Sheng, China)'),
    ('CN-GAY', 'CN-GAY (Gaoyao, Guangdong Sheng, China)'),
    ('CN-GYU', 'CN-GYU (Gaoyou, Jiangsu Sheng, China)'),
    ('CN-GXC', 'CN-GXC (Gaoyou, Jiangsu Sheng, China)'),
    ('CN-GDI', 'CN-GDI (Gedian, Hubei Sheng, China)'),
    ('CN-GOQ', 'CN-GOQ (Golmud, Qinghai Sheng, China)'),
    ('CN-GGN', 'CN-GGN (Gongan, Hubei Sheng, China)'),
    ('CN-GBP', 'CN-GBP (Gongbei, Guangdong Sheng, China)'),
    ('CN-GGU', 'CN-GGU (Gongbei, Guangdong Sheng, China)'),
    ('CN-GGK', 'CN-GGK (Gongkou, Fujian Sheng, China)'),
    ('CN-GLU', 'CN-GLU (Gongkou, Fujian Sheng, China)'),
    ('CN-GOG', 'CN-GOG (Gongming, Guangdong Sheng, China)'),
    ('CN-TSG', 'CN-TSG (Gongyi, Guangdong Sheng, China)'),
    ('CN-GBZ', 'CN-GBZ (Gongyi, Guangdong Sheng, China)'),
    ('CN-GAN', "CN-GAN (Gu'an, Hebei Sheng, China)"),
    ('CN-GBG', 'CN-GBG (Guanbu Pt, Guangdong Sheng, China)'),
    ('CN-GCH', 'CN-GCH (Guancheng, Guangdong Sheng, China)'),
    ('CN-GDU', 'CN-GDU (Guandu, Guangdong Sheng, China)'),
    ('CN-GNA', "CN-GNA (Guang'ao, Guangdong Sheng, China)"),
    ('CN-GBT', 'CN-GBT (Guangbaotong, Guangdong Sheng, China)'),
    ('CN-GUT', 'CN-GUT (Guangdong Terminal, Guangdong Sheng, China)'),
    ('CN-GFU', 'CN-GFU (Guangfu, Guangdong Sheng, China)'),
    ('CN-GHI', 'CN-GHI (Guanghai Pt, Guangdong Sheng, China)'),
    ('CN-GHN', 'CN-GHN (Guanghan, Sichuan Sheng, China)'),
    ('CN-LHK', 'CN-LHK (Guanghua, Hubei Sheng, China)'),
    ('CN-GLI', 'CN-GLI (Guangli, Guangdong Sheng, China)'),
    ('CN-GNG', 'CN-GNG (Guangning, Guangdong Sheng, China)'),
    ('CN-GNI', 'CN-GNI (Guangning, Liaoning Sheng, China)'),
    ('CN-YCU', 'CN-YCU (Guangong Apt/Yuncheng, Shanxi Sheng, China)'),
    ('CN-GRO', 'CN-GRO (Guangrao, Shandong Sheng, China)'),
    ('CN-GGS', 'CN-GGS (Guangrao, Shandong Sheng, China)'),
    ('CN-GYS', 'CN-GYS (Guangyuan Panlong Apt, Sichuan Sheng, China)'),
    ('CN-GGZ', 'CN-GGZ (Guangzhou, Guangdong Sheng, China)'),
    ('CN-CAN', 'CN-CAN (Guangzhou Baiyun International Apt, Guangdong Sheng, China)'),
    ('CN-GZG', 'CN-GZG (Guangzhou Pt, Guangdong Sheng, China)'),
    ('CN-GZC', 'CN-GZC (Guangzhouchuanchang, Guangdong Sheng, China)'),
    ('CN-GUZ', 'CN-GUZ (Guangzhoudong Railway Station, Guangdong Sheng, China)'),
    ('CN-GUN', 'CN-GUN (Guanlan, Guangdong Sheng, China)'),
    ('CN-GNL', 'CN-GNL (Guanlin, Henan Sheng, China)'),
    ('CN-GNY', 'CN-GNY (Guanyao, Guangdong Sheng, China)'),
    ('CN-GYO', 'CN-GYO (Guanyao, Hubei Sheng, China)'),
    ('CN-GCL', 'CN-GCL (Guanyao, Hubei Sheng, China)'),
    ('CN-CZH', 'CN-CZH (Guanyao, Hubei Sheng, China)'),
    ('CN-GCE', 'CN-GCE (Guanyao, Hubei Sheng, China)'),
    ('CN-GCG', 'CN-GCG (Guicheng, Guangdong Sheng, China)'),
    ('CN-GUG', 'CN-GUG (Guicheng, Guangdong Sheng, China)'),
    ('CN-GUI', 'CN-GUI (Guicheng, Guangdong Sheng, China)'),
    ('CN-KWL', 'CN-KWL (Guicheng, Guangdong Sheng, China)'),
    ('CN-GYG', 'CN-GYG (Guilinyang, Hainan Sheng, China)'),
    ('CN-GPG', 'CN-GPG (Guilinyang, Hainan Sheng, China)'),
    ('CN-GIS', 'CN-GIS (Guishan, Guangdong Sheng, China)'),
    ('CN-GTI', 'CN-GTI (Guishan, Guangdong Sheng, China)'),
    ('CN-GXI', 'CN-GXI (Guixi, Jiangxi Sheng, China)'),
    ('CN-GYA', 'CN-GYA (Guiyang, Guizhou Sheng, China)'),
    ('CN-KWE', 'CN-KWE (Guiyang Longdongbao International Apt, Guizhou Sheng, China)'),
    ('CN-GZU', 'CN-GZU (Guizhou, Guangdong Sheng, China)'),
    ('CN-GJG', 'CN-GJG (Gujing, Guangdong Sheng, China)'),
    ('CN-GLE', 'CN-GLE (Gulei, Fujian Sheng, China)'),
    ('CN-GZE', 'CN-GZE (Guzhen, Guangdong Sheng, China)'),
    ('CN-GIR', 'CN-GIR (Guzhen, Guangdong Sheng, China)'),
    ('CN-XWH', 'CN-XWH (Haian, Guangdong Sheng, China)'),
    ('CN-FHC', 'CN-FHC (Haicang, Fujian Sheng, China)'),
    ('CN-HAG', 'CN-HAG (Haicheng, Liaoning Sheng, China)'),
    ('CN-HDN', 'CN-HDN (Haidian, Hainan Sheng, China)'),
    ('CN-HGN', 'CN-HGN (Haigeng, Anhui Sheng, China)'),
    ('CN-HKN', 'CN-HKN (Haikang, Guangdong Sheng, China)'),
    ('CN-HKO', 'CN-HKO (Haikou, Hainan Sheng, China)'),
    ('CN-HAK', 'CN-HAK (Haikou Meilan International Apt, Hainan Sheng, China)'),
    ('CN-HXG', 'CN-HXG (Haikou New Pt, Hainan Sheng, China)'),
    ('CN-HIG', 'CN-HIG (Haikou Pt, Hainan Sheng, China)'),
    ('CN-CYH', 'CN-CYH (Haimen, Guangdong Sheng, China)'),
    ('CN-HME', 'CN-HME (Haimen, Zhejiang Sheng, China)'),
    ('CN-HIM', 'CN-HIM (Haimiao, Shandong Sheng, China)'),
    ('CN-HIN', 'CN-HIN (Haining, Zhejiang Sheng, China)'),
    ('CN-HAT', 'CN-HAT (Haitang/Shekou, Guangdong Sheng, China)'),
    ('CN-HHT', 'CN-HHT (Haitian Terminal/ Xiamen, Fujian Sheng, China)'),
    ('CN-HTO', 'CN-HTO (Haitou, Jiangsu Sheng, China)'),
    ('CN-HIY', 'CN-HIY (Haiyan, Zhejiang Sheng, China)'),
    ('CN-HAD', 'CN-HAD (Haiyan, Zhejiang Sheng, China)'),
    ('CN-HAY', 'CN-HAY (Haiyan, Zhejiang Sheng, China)'),
    ('CN-HIZ', 'CN-HIZ (Haizhu, Guangdong Sheng, China)'),
    ('CN-HMI', 'CN-HMI (Haizhu, Guangdong Sheng, China)'),
    ('CN-HDS', 'CN-HDS (Handan, Hebei Sheng, China)'),
    ('CN-HAZ', 'CN-HAZ (Hangzhou, Zhejiang Sheng, China)'),
    ('CN-HGH', 'CN-HGH (Hangzhou Xiaoshan International Apt, Zhejiang Sheng, China)'),
    ('CN-HAN', 'CN-HAN (Hanjiang, Fujian Sheng, China)'),
    ('CN-HNK', 'CN-HNK (Hankou, Hubei Sheng, China)'),
    ('CN-HZG', 'CN-HZG (Hankou, Hubei Sheng, China)'),
    ('CN-HXE', 'CN-HXE (Haoxue, Hubei Sheng, China)'),
    ('CN-HRN', 'CN-HRN (Harbin, Heilongjiang Sheng, China)'),
    ('CN-HBG', 'CN-HBG (Harbin Pt, Heilongjiang Sheng, China)'),
    ('CN-HBZ', 'CN-HBZ (Harbin Railway Station, Heilongjiang Sheng, China)'),
    ('CN-HRB', 'CN-HRB (Harbin Taiping International Apt, Heilongjiang Sheng, China)'),
    ('CN-HEB', 'CN-HEB (Hebei, Hebei Sheng, China)'),
    ('CN-HCH', 'CN-HCH (Hebei, Hebei Sheng, China)'),
    ('CN-HFI', 'CN-HFI (Hefei, Anhui Sheng, China)'),
    ('CN-HFE', 'CN-HFE (Hefei Xinqiao International Apt, Anhui Sheng, China)'),
    ('CN-HEK', 'CN-HEK (Heihe, Heilongjiang Sheng, China)'),
    ('CN-HSA', 'CN-HSA (Heihe, Heilongjiang Sheng, China)'),
    ('CN-HST', 'CN-HST (Heihe, Heilongjiang Sheng, China)'),
    ('CN-HKM', 'CN-HKM (Hekou, Yunnan Sheng, China)'),
    ('CN-XHH', 'CN-XHH (Hekou, Guangdong Sheng, China)'),
    ('CN-HLW', 'CN-HLW (Heliwei, Guangdong Sheng, China)'),
    ('CN-ENP', 'CN-ENP (Hengban, Guangdong Sheng, China)'),
    ('CN-HEN', 'CN-HEN (Hengban, Guangdong Sheng, China)'),
    ('CN-HNG', 'CN-HNG (Henggang, Guangdong Sheng, China)'),
    ('CN-HNI', 'CN-HNI (Hengli, Guangdong Sheng, China)'),
    ('CN-HGQ', 'CN-HGQ (Hengqin, Guangdong Sheng, China)'),
    ('CN-HIS', 'CN-HIS (Hengqin, Guangdong Sheng, China)'),
    ('CN-HXA', 'CN-HXA (Hengqin, Guangdong Sheng, China)'),
    ('CN-HNY', 'CN-HNY (Hengyang, Hunan Sheng, China)'),
    ('CN-HES', 'CN-HES (Hengyang, Hunan Sheng, China)'),
    ('CN-HPT', 'CN-HPT (Hengyang, Hunan Sheng, China)'),
    ('CN-HEP', 'CN-HEP (Hengyang, Hunan Sheng, China)'),
    ('CN-HAS', 'CN-HAS (Hengyang, Hunan Sheng, China)'),
    ('CN-HSN', 'CN-HSN (Heshan Pt, Guangdong Sheng, China)'),
    ('CN-HHU', 'CN-HHU (Heshun, Guangdong Sheng, China)'),
    ('CN-HTG', 'CN-HTG (Hetang, Guangdong Sheng, China)'),
    ('CN-HYA', 'CN-HYA (Hetang, Guangdong Sheng, China)'),
    ('CN-HEY', 'CN-HEY (Heyuan, Guangdong Sheng, China)'),
    ('CN-HZS', 'CN-HZS (Heze, Shandong Sheng, China)'),
    ('CN-HEZ', 'CN-HEZ (Heze, Shandong Sheng, China)'),
    ('CN-HHH', 'CN-HHH (Heze, Shandong Sheng, China)'),
    ('CN-HET', 'CN-HET (Heze, Shandong Sheng, China)'),
    ('CN-HOD', 'CN-HOD (Heze, Shandong Sheng, China)'),
    ('CN-HGG', 'CN-HGG (Hongguang Pt, Zhejiang Sheng, China)'),
    ('CN-SHW', 'CN-SHW (Honghai, Hainan Sheng, China)'),
    ('CN-BLX', 'CN-BLX (Honghai Pt, Guangdong Sheng, China)'),
    ('CN-HOH', 'CN-HOH (Honghu, Hubei Sheng, China)'),
    ('CN-HGA', 'CN-HGA (Honghua, Hubei Sheng, China)'),
    ('CN-HGK', 'CN-HGK (Honghua, Hubei Sheng, China)'),
    ('CN-HOQ', 'CN-HOQ (Hongqi, Guangdong Sheng, China)'),
    ('CN-HGO', 'CN-HGO (Hongqi, Guangdong Sheng, China)'),
    ('CN-HNT', 'CN-HNT (Hongqi, Guangdong Sheng, China)'),
    ('CN-HGW', 'CN-HGW (Hongwan, Guangdong Sheng, China)'),
    ('CN-HON', 'CN-HON (Hongwan, Guangdong Sheng, China)'),
    ('CN-HRS', 'CN-HRS (Hongwan, Guangdong Sheng, China)'),
    ('CN-HTN', 'CN-HTN (Hongwan, Guangdong Sheng, China)'),
    ('CN-HOA', 'CN-HOA (Houan, Hainan Sheng, China)'),
    ('CN-HOU', 'CN-HOU (Houjie, Guangdong Sheng, China)'),
    ('CN-HOM', 'CN-HOM (Houma, Shanxi Sheng, China)'),
    ('CN-TCH', 'CN-TCH (Houqiao, Yunnan Sheng, China)'),
    ('CN-HZU', 'CN-HZU (Houzhu, Fujian Sheng, China)'),
    ('CN-HCN', 'CN-HCN (Huachuan, Heilongjiang Sheng, China)'),
    ('CN-HDU', 'CN-HDU (Huadu, Guangdong Sheng, China)'),
    ('CN-HDG', 'CN-HDG (Huadu Pt, Guangdong Sheng, China)'),
    ('CN-HIA', "CN-HIA (Huai'an, Jiangsu Sheng, China)"),
    ('CN-HBI', 'CN-HBI (Huaibei, Anhui Sheng, China)'),
    ('CN-IHE', 'CN-IHE (Huaihe, Jiangsu Sheng, China)'),
    ('CN-HJJ', 'CN-HJJ (Huaihua Zhijiang Apt, Hunan Sheng, China)'),
    ('CN-HIJ', 'CN-HIJ (Huaiji, Guangdong Sheng, China)'),
    ('CN-HLI', 'CN-HLI (Huailai, Hebei Sheng, China)'),
    ('CN-HII', 'CN-HII (Huainan, Anhui Sheng, China)'),
    ('CN-AIN', 'CN-AIN (Huaiyin, Jiangsu Sheng, China)'),
    ('CN-HBU', 'CN-HBU (Huaiyin, Jiangsu Sheng, China)'),
    ('CN-HGC', 'CN-HGC (Huangcun, Guangdong Sheng, China)'),
    ('CN-HUG', 'CN-HUG (Huanggang, Guangdong Sheng, China)'),
    ('CN-HGE', 'CN-HGE (Huangge, Guangdong Sheng, China)'),
    ('CN-HNH', 'CN-HNH (Huanghua, Zhejiang Sheng, China)'),
    ('CN-HUH', 'CN-HUH (Huanghua Pt, Hebei Sheng, China)'),
    ('CN-HGJ', 'CN-HGJ (Huanghua Pt, Hebei Sheng, China)'),
    ('CN-HJI', 'CN-HJI (Huangjiang, Guangdong Sheng, China)'),
    ('CN-HGP', 'CN-HGP (Huangpi, Hubei Sheng, China)'),
    ('CN-WCH', 'CN-WCH (Huangpo, Guangdong Sheng, China)'),
    ('CN-HUN', 'CN-HUN (Huangpu New Port, Guangdong Sheng, China)'),
    ('CN-HUA', 'CN-HUA (Huangpu Pt, Guangdong Sheng, China)'),
    ('CN-HAQ', 'CN-HAQ (Huangqi/Nanhai, Guangdong Sheng, China)'),
    ('CN-HSK', 'CN-HSK (Huangsangkou, Hubei Sheng, China)'),
    ('CN-HSH', 'CN-HSH (Huangshan, Anhui Sheng, China)'),
    ('CN-TXN', 'CN-TXN (Huangshan Tunxi International Apt, Anhui Sheng, China)'),
    ('CN-HSI', 'CN-HSI (Huangshi Pt, Hubei Sheng, China)'),
    ('CN-ANG', 'CN-ANG (Huangshi Pt, Hubei Sheng, China)'),
    ('CN-HYN', 'CN-HYN (Huangyan, Zhejiang Sheng, China)'),
    ('CN-HZO', 'CN-HZO (Huangzhou, Hubei Sheng, China)'),
    ('CN-HNS', 'CN-HNS (Huanshi, Hubei Sheng, China)'),
    ('CN-HUS', 'CN-HUS (Huashi, Jiangsu Sheng, China)'),
    ('CN-HUY', 'CN-HUY (Huayang, Anhui Sheng, China)'),
    ('CN-HUZ', 'CN-HUZ (Huayang, Anhui Sheng, China)'),
    ('CN-HUE', 'CN-HUE (Huchen, Zhejiang Sheng, China)'),
    ('CN-HUW', 'CN-HUW (Huidong, Sichuan Sheng, China)'),
    ('CN-HID', 'CN-HID (Huidong Pt, Guangdong Sheng, China)'),
    ('CN-HIK', 'CN-HIK (Huikou, Anhui Sheng, China)'),
    ('CN-HLN', 'CN-HLN (Huilong, Guangdong Sheng, China)'),
    ('CN-HNO', 'CN-HNO (Huilong, Guangdong Sheng, China)'),
    ('CN-HQG', 'CN-HQG (Huilong, Guangdong Sheng, China)'),
    ('CN-HUI', 'CN-HUI (Huizhou Pt, Guangdong Sheng, China)'),
    ('CN-HKU', 'CN-HKU (Hukou, Jiangxi Sheng, China)'),
    ('CN-HLE', 'CN-HLE (Hulan Ergi, Heilongjiang Sheng, China)'),
    ('CN-HUL', 'CN-HUL (Hulin, Heilongjiang Sheng, China)'),
    ('CN-HUD', 'CN-HUD (Huludao Pt, Liaoning Sheng, China)'),
    ('CN-HLD', 'CN-HLD (Huludao Pt, Liaoning Sheng, China)'),
    ('CN-HUM', 'CN-HUM (Huma, Heilongjiang Sheng, China)'),
    ('CN-HMN', 'CN-HMN (Humen Pt, Guangdong Sheng, China)'),
    ('CN-HCG', 'CN-HCG (Hunchun, Jilin Sheng, China)'),
    ('CN-HUP', 'CN-HUP (Huo Pt, Anhui Sheng, China)'),
    ('CN-XJH', 'CN-XJH (Huo Pt, Anhui Sheng, China)'),
    ('CN-HZH', 'CN-HZH (Huzhou Pt, Zhejiang Sheng, China)'),
    ('CN-JEM', 'CN-JEM (Huzhou Pt, Zhejiang Sheng, China)'),
    ('CN-JID', 'CN-JID (Huzhou Pt, Zhejiang Sheng, China)'),
    ('CN-JMU', 'CN-JMU (Jiamusi Dongjiao Apt, Heilongjiang Sheng, China)'),
    ('CN-JMS', 'CN-JMS (Jiamusi Pt, Heilongjiang Sheng, China)'),
    ('CN-JIN', 'CN-JIN (Jian, Jiangxi Sheng, China)'),
    ('CN-KNC', 'CN-KNC (Jian Railway Station, Jilin Sheng, China)'),
    ('CN-JBI', 'CN-JBI (Jianbi, Jiangsu Sheng, China)'),
    ('CN-JDE', 'CN-JDE (Jianbi, Jiangsu Sheng, China)'),
    ('CN-JAA', "CN-JAA (Jiang'an, Sichuan Sheng, China)"),
    ('CN-JAN', 'CN-JAN (Jiangan Railway Station, Hubei Sheng, China)'),
    ('CN-JCH', 'CN-JCH (Jiangcheng, Guangdong Sheng, China)'),
    ('CN-JCN', 'CN-JCN (Jiangchuan, Yunnan Sheng, China)'),
    ('CN-JIC', 'CN-JIC (Jiangcun, Guangdong Sheng, China)'),
    ('CN-JND', 'CN-JND (Jiangdu, Jiangsu Sheng, China)'),
    ('CN-JGH', 'CN-JGH (Jianghai, Guangdong Sheng, China)'),
    ('CN-JGJ', 'CN-JGJ (Jianghai, Guangdong Sheng, China)'),
    ('CN-FKJ', 'CN-FKJ (Jiangkou, Guangdong Sheng, China)'),
    ('CN-JKO', 'CN-JKO (Jiangkou, Hubei Sheng, China)'),
    ('CN-JKU', 'CN-JKU (Jiangkou, Fujian Sheng, China)'),
    ('CN-JLE', 'CN-JLE (Jiangkou, Fujian Sheng, China)'),
    ('CN-JMN', 'CN-JMN (Jiangmen Pt, Guangdong Sheng, China)'),
    ('CN-JIP', 'CN-JIP (Jiangmen Pt, Guangdong Sheng, China)'),
    ('CN-JPU', 'CN-JPU (Jiangpu, Jiangsu Sheng, China)'),
    ('CN-JHN', 'CN-JHN (Jiangpu, Jiangsu Sheng, China)'),
    ('CN-JIS', 'CN-JIS (Jiangpu, Jiangsu Sheng, China)'),
    ('CN-GJS', 'CN-GJS (Jiangpu, Jiangsu Sheng, China)'),
    ('CN-JSU', 'CN-JSU (Jiangpu, Jiangsu Sheng, China)'),
    ('CN-JNX', 'CN-JNX (Jiangxi, Hunan Sheng, China)'),
    ('CN-JYS', 'CN-JYS (Jiangyan, Jiangsu Sheng, China)'),
    ('CN-JGY', 'CN-JGY (Jiangyin, Fujian Sheng, China)'),
    ('CN-JIA', 'CN-JIA (Jiangyin Pt, Jiangsu Sheng, China)'),
    ('CN-JLI', 'CN-JLI (Jianli, Hubei Sheng, China)'),
    ('CN-JTO', 'CN-JTO (Jiantiao, Zhejiang Sheng, China)'),
    ('CN-JAG', 'CN-JAG (Jiantiao, Zhejiang Sheng, China)'),
    ('CN-JXN', 'CN-JXN (Jiao Xin, Guangdong Sheng, China)'),
    ('CN-JOJ', 'CN-JOJ (Jiao Xin, Guangdong Sheng, China)'),
    ('CN-JOK', 'CN-JOK (Jiaokou, Guangdong Sheng, China)'),
    ('CN-JSG', 'CN-JSG (Jiaoshan Pt, Zhejiang Sheng, China)'),
    ('CN-JZH', 'CN-JZH (Jiaozhou, Shandong Sheng, China)'),
    ('CN-JZO', 'CN-JZO (Jiaozuo, Henan Sheng, China)'),
    ('CN-JAS', 'CN-JAS (Jiashan, Zhejiang Sheng, China)'),
    ('CN-JSA', 'CN-JSA (Jiashan, Jilin Sheng, China)'),
    ('CN-JAX', 'CN-JAX (Jiaxing, Zhejiang Sheng, China)'),
    ('CN-JAY', 'CN-JAY (Jiayin, Heilongjiang Sheng, China)'),
    ('CN-JGN', 'CN-JGN (Jiayuguan, Gansu Sheng, China)'),
    ('CN-JIZ', 'CN-JIZ (Jiazi, Guangdong Sheng, China)'),
    ('CN-JES', 'CN-JES (Jieshi, Guangdong Sheng, China)'),
    ('CN-JXI', 'CN-JXI (Jieshi, Guangdong Sheng, China)'),
    ('CN-JYG', 'CN-JYG (Jieshi, Guangdong Sheng, China)'),
    ('CN-SWA', 'CN-SWA (Jieyang Chaoshan Apt, Guangdong Sheng, China)'),
    ('CN-JIL', 'CN-JIL (Jilin, Jilin Sheng, China)'),
    ('CN-JLZ', 'CN-JLZ (Jilin Railway Station, Jilin Sheng, China)'),
    ('CN-JMY', 'CN-JMY (Jimiya, Shandong Sheng, China)'),
    ('CN-JMO', 'CN-JMO (Jimo, Shandong Sheng, China)'),
    ('CN-JNA', 'CN-JNA (Jinan, Shandong Sheng, China)'),
    ('CN-TNA', 'CN-TNA (Jinan Yaoqiang International Apt, Shandong Sheng, China)'),
    ('CN-JIH', "CN-JIH (Jing'an, Jiangxi Sheng, China)"),
    ('CN-DMJ', 'CN-DMJ (Jingan, Guangdong Sheng, China)'),
    ('CN-JDZ', 'CN-JDZ (Jingdezhen, Jiangxi Sheng, China)'),
    ('CN-JGS', 'CN-JGS (Jinggangshan Apt, Jiangxi Sheng, China)'),
    ('CN-HLJ', 'CN-HLJ (Jinghai, Guangdong Sheng, China)'),
    ('CN-JOG', 'CN-JOG (Jinghong, Yunnan Sheng, China)'),
    ('CN-JIJ', 'CN-JIJ (Jingjiang Pt, Jiangsu Sheng, China)'),
    ('CN-JGM', 'CN-JGM (Jingjiang Pt, Jiangsu Sheng, China)'),
    ('CN-JTG', 'CN-JTG (Jingtang Pt, Hebei Sheng, China)'),
    ('CN-JGU', 'CN-JGU (Jinguzhou, Guangdong Sheng, China)'),
    ('CN-JGX', 'CN-JGX (Jinguzhou, Guangdong Sheng, China)'),
    ('CN-JGZ', 'CN-JGZ (Jingzhou, Hubei Sheng, China)'),
    ('CN-JZK', 'CN-JZK (Jingzhou Pt, Hubei Sheng, China)'),
    ('CN-JNH', 'CN-JNH (Jinhaian, Guangdong Sheng, China)'),
    ('CN-JHK', 'CN-JHK (Jinhekou, Anhui Sheng, China)'),
    ('CN-JHA', 'CN-JHA (Jinhua, Zhejiang Sheng, China)'),
    ('CN-JII', 'CN-JII (Jining, Hunan Sheng, China)'),
    ('CN-JNG', 'CN-JNG (Jining, Shandong Sheng, China)'),
    ('CN-JNN', 'CN-JNN (Jining, Shandong Sheng, China)'),
    ('CN-JJI', 'CN-JJI (Jining, Shandong Sheng, China)'),
    ('CN-JJD', 'CN-JJD (Jinjiang Dry Port, Fujian Sheng, China)'),
    ('CN-PTJ', 'CN-PTJ (Jinjing, Fujian Sheng, China)'),
    ('CN-JNL', 'CN-JNL (Jinli, Guangdong Sheng, China)'),
    ('CN-JPI', 'CN-JPI (Jinpai, Hainan Sheng, China)'),
    ('CN-JQI', 'CN-JQI (Jinpai, Hainan Sheng, China)'),
    ('CN-JNS', 'CN-JNS (Jinpai, Hainan Sheng, China)'),
    ('CN-JSI', 'CN-JSI (Jinshi, Hunan Sheng, China)'),
    ('CN-JSH', 'CN-JSH (Jinshuihe, Yunnan Sheng, China)'),
    ('CN-JTN', 'CN-JTN (Jinshuihe, Yunnan Sheng, China)'),
    ('CN-JWN', 'CN-JWN (Jinwan, Guangdong Sheng, China)'),
    ('CN-IXI', 'CN-IXI (Jinwan, Guangdong Sheng, China)'),
    ('CN-JYN', 'CN-JYN (Jinwan, Guangdong Sheng, China)'),
    ('CN-JZI', 'CN-JZI (Jinzhou, Hebei Sheng, China)'),
    ('CN-JNZ', 'CN-JNZ (Jinzhou Pt, Liaoning Sheng, China)'),
    ('CN-JSO', 'CN-JSO (Jishou, Hunan Sheng, China)'),
    ('CN-JUI', 'CN-JUI (Jishou, Hunan Sheng, China)'),
    ('CN-GDJ', 'CN-GDJ (Jishou, Hunan Sheng, China)'),
    ('CN-JUJ', 'CN-JUJ (Jiujiang, Guangdong Sheng, China)'),
    ('CN-JIU', 'CN-JIU (Jiujiang Pt, Jiangxi Sheng, China)'),
    ('CN-JUL', 'CN-JUL (Jiuli, Jiangsu Sheng, China)'),
    ('CN-JLP', 'CN-JLP (Jiuli, Jiangsu Sheng, China)'),
    ('CN-JUQ', 'CN-JUQ (Jiuquan Railway Station, Gansu Sheng, China)'),
    ('CN-JUZ', 'CN-JUZ (Jiuzhen, Fujian Sheng, China)'),
    ('CN-JZU', 'CN-JZU (Jiuzhou Pt, Guangdong Sheng, China)'),
    ('CN-XII', 'CN-XII (Jiuzhou Pt, Guangdong Sheng, China)'),
    ('CN-JIX', 'CN-JIX (Jiuzhou Pt, Guangdong Sheng, China)'),
    ('CN-JYA', 'CN-JYA (Jiuzhou Pt, Guangdong Sheng, China)'),
    ('CN-JRG', 'CN-JRG (Jurong, Jiangsu Sheng, China)'),
    ('CN-KFG', 'CN-KFG (Kaifeng, Henan Sheng, China)'),
    ('CN-KAH', 'CN-KAH (Kaifeng, Henan Sheng, China)'),
    ('CN-KAI', 'CN-KAI (Kaikou, Guizhou Sheng, China)'),
    ('CN-KJH', 'CN-KJH (Kaili, Fujian Sheng, China)'),
    ('CN-KAP', 'CN-KAP (Kaiping, Guangdong Sheng, China)'),
    ('CN-KPN', 'CN-KPN (Kaiping, Hebei Sheng, China)'),
    ('CN-KST', 'CN-KST (Kaishantun, Jilin Sheng, China)'),
    ('CN-KIY', 'CN-KIY (Kaishantun, Jilin Sheng, China)'),
    ('CN-KLS', 'CN-KLS (Kaishantun, Jilin Sheng, China)'),
    ('CN-KGT', 'CN-KGT (Kangding, Sichuan Sheng, China)'),
    ('CN-KQI', 'CN-KQI (Kangqiao, Shaanxi Sheng, China)'),
    ('CN-KZG', 'CN-KZG (Kangzhou Pt, Guangdong Sheng, China)'),
    ('CN-KMN', 'CN-KMN (Kanmen, Zhejiang Sheng, China)'),
    ('CN-KRY', 'CN-KRY (Kanmen, Zhejiang Sheng, China)'),
    ('CN-KSS', 'CN-KSS (Kanmen, Zhejiang Sheng, China)'),
    ('CN-KHG', 'CN-KHG (Kanmen, Zhejiang Sheng, China)'),
    ('CN-KOL', 'CN-KOL (Kanmen, Zhejiang Sheng, China)'),
    ('CN-KYG', 'CN-KYG (Kuiyong, Guangdong Sheng, China)'),
    ('CN-KJP', 'CN-KJP (Kuiyong, Guangdong Sheng, China)'),
    ('CN-KNM', 'CN-KNM (Kunming, Yunnan Sheng, China)'),
    ('CN-KMG', 'CN-KMG (Kunming Wujiaba International Apt, Yunnan Sheng, China)'),
    ('CN-KUS', 'CN-KUS (Kunshan, Jiangsu Sheng, China)'),
    ('CN-KCA', 'CN-KCA (Kunshan, Jiangsu Sheng, China)'),
    ('CN-KUY', 'CN-KUY (Kunshan, Jiangsu Sheng, China)'),
    ('CN-LAA', 'CN-LAA (Kunshan, Jiangsu Sheng, China)'),
    ('CN-LBI', 'CN-LBI (Kunshan, Jiangsu Sheng, China)'),
    ('CN-CSL', 'CN-CSL (Laiwu, Guangdong Sheng, China)'),
    ('CN-LWS', 'CN-LWS (Laiwu, Shandong Sheng, China)'),
    ('CN-LIX', 'CN-LIX (Laiwu, Shandong Sheng, China)'),
    ('CN-LYD', 'CN-LYD (Laiyang, Shandong Sheng, China)'),
    ('CN-LZO', 'CN-LZO (Laizhou Pt, Shandong Sheng, China)'),
    ('CN-LFZ', 'CN-LFZ (Langfang, Hebei Sheng, China)'),
    ('CN-LSN', 'CN-LSN (Lanshan Pt, Shandong Sheng, China)'),
    ('CN-LNS', 'CN-LNS (Lanshi, Guangdong Sheng, China)'),
    ('CN-LSI', 'CN-LSI (Lanshi, Hunan Sheng, China)'),
    ('CN-LXI', 'CN-LXI (Lanxi, Zhejiang Sheng, China)'),
    ('CN-LAZ', 'CN-LAZ (Lanzhou, Gansu Sheng, China)'),
    ('CN-LHW', 'CN-LHW (Lanzhou Zhongchuan Apt, Gansu Sheng, China)'),
    ('CN-LLY', 'CN-LLY (Laocheng, Hainan Sheng, China)'),
    ('CN-LDK', 'CN-LDK (Laodukou, Hubei Sheng, China)'),
    ('CN-LHS', 'CN-LHS (Laohushao, Jilin Sheng, China)'),
    ('CN-LAL', 'CN-LAL (Laolong, Guangdong Sheng, China)'),
    ('CN-LXH', 'CN-LXH (Laoxiahe, Anhui Sheng, China)'),
    ('CN-LYM', 'CN-LYM (Laoxiahe, Anhui Sheng, China)'),
    ('CN-LNG', 'CN-LNG (Ledong, Hainan Sheng, China)'),
    ('CN-LYN', 'CN-LYN (Leiyang, Hunan Sheng, China)'),
    ('CN-LLG', 'CN-LLG (Leling, Shandong Sheng, China)'),
    ('CN-LUU', 'CN-LUU (Leliu, Guangdong Sheng, China)'),
    ('CN-LPI', 'CN-LPI (Leping, Guangdong Sheng, China)'),
    ('CN-LES', 'CN-LES (Leshanzhan, Sichuan Sheng, China)'),
    ('CN-LTP', 'CN-LTP (Letianxi Pt, Hubei Sheng, China)'),
    ('CN-LEZ', 'CN-LEZ (Lezhu, Guangdong Sheng, China)'),
    ('CN-LHA', 'CN-LHA (Lezhu, Guangdong Sheng, China)'),
    ('CN-LXA', 'CN-LXA (Lezhu, Guangdong Sheng, China)'),
    ('CN-LHG', 'CN-LHG (Liancheng, Guangdong Sheng, China)'),
    ('CN-LCX', 'CN-LCX (Liancheng Apt, Fujian Sheng, China)'),
    ('CN-LGP', 'CN-LGP (Liancheng Apt, Fujian Sheng, China)'),
    ('CN-LIH', 'CN-LIH (Lianhuashan Pt, Guangdong Sheng, China)'),
    ('CN-LNJ', 'CN-LNJ (Lianjiang, Jiangxi Sheng, China)'),
    ('CN-LNX', 'CN-LNX (Lianjiang, Jiangxi Sheng, China)'),
    ('CN-LYG', 'CN-LYG (Lianyungang, Jiangsu Sheng, China)'),
    ('CN-LIZ', 'CN-LIZ (Lianzhou, Guangdong Sheng, China)'),
    ('CN-LBU', 'CN-LBU (Liaobu, Guangdong Sheng, China)'),
    ('CN-LCH', 'CN-LCH (Liaocheng, Shandong Sheng, China)'),
    ('CN-LYS', 'CN-LYS (Liaoyang, Liaoning Sheng, China)'),
    ('CN-LOY', 'CN-LOY (Liaoyang, Liaoning Sheng, China)'),
    ('CN-LIB', 'CN-LIB (Libo, Guizhou Sheng, China)'),
    ('CN-LIC', 'CN-LIC (Licheng, Shandong Sheng, China)'),
    ('CN-LID', 'CN-LID (Lidao, Shandong Sheng, China)'),
    ('CN-LHU', 'CN-LHU (Lihu, Guangdong Sheng, China)'),
    ('CN-LAG', 'CN-LAG (Lihu, Guangdong Sheng, China)'),
    ('CN-LIJ', 'CN-LIJ (Lijiang, Shandong Sheng, China)'),
    ('CN-LJG', 'CN-LJG (Lijiang Sanyi Apt, Yunnan Sheng, China)'),
    ('CN-LIL', 'CN-LIL (Liling, Hunan Sheng, China)'),
    ('CN-LLI', 'CN-LLI (Liling, Hunan Sheng, China)'),
    ('CN-ACH', 'CN-ACH (Liling, Hunan Sheng, China)'),
    ('CN-LNA', "CN-LNA (Lin'an, Zhejiang Sheng, China)"),
    ('CN-LNC', 'CN-LNC (Lincang, Yunnan Sheng, China)'),
    ('CN-LGE', 'CN-LGE (Lincang, Yunnan Sheng, China)'),
    ('CN-LGN', 'CN-LGN (Lincang, Yunnan Sheng, China)'),
    ('CN-LLF', 'CN-LLF (Lingling Apt/Yongzhou, Hunan Sheng, China)'),
    ('CN-LSA', 'CN-LSA (Lingshan, Hainan Sheng, China)'),
    ('CN-LNH', 'CN-LNH (Linhai, Zhejiang Sheng, China)'),
    ('CN-LIN', 'CN-LIN (Linjiang, Jilin Sheng, China)'),
    ('CN-TNC', 'CN-TNC (Lintao, Gansu Sheng, China)'),
    ('CN-LNI', 'CN-LNI (Lintao, Gansu Sheng, China)'),
    ('CN-LYI', 'CN-LYI (Linyizhan, Shandong Sheng, China)'),
    ('CN-LNZ', 'CN-LNZ (Linzi, Shandong Sheng, China)'),
    ('CN-LIP', 'CN-LIP (Liping, Guizhou Sheng, China)'),
    ('CN-LQN', 'CN-LQN (Liping, Guizhou Sheng, China)'),
    ('CN-LSS', 'CN-LSS (Lishui, Zhejiang Sheng, China)'),
    ('CN-LUI', 'CN-LUI (Lishui, Zhejiang Sheng, China)'),
    ('CN-IUA', 'CN-IUA (Lishui, Zhejiang Sheng, China)'),
    ('CN-LUD', 'CN-LUD (Liudu, Guangdong Sheng, China)'),
    ('CN-LJP', 'CN-LJP (Liujia Pt, Hubei Sheng, China)'),
    ('CN-LJD', 'CN-LJD (Liujiadu, Anhui Sheng, China)'),
    ('CN-LJI', 'CN-LJI (Liujiadu, Anhui Sheng, China)'),
    ('CN-LJN', 'CN-LJN (Liujiadu, Anhui Sheng, China)'),
    ('CN-LKP', 'CN-LKP (Liukou Pt, Hubei Sheng, China)'),
    ('CN-LPS', 'CN-LPS (Liupanshui, Guizhou Sheng, China)'),
    ('CN-LZL', 'CN-LZL (Liusha, Guangdong Sheng, China)'),
    ('CN-XML', 'CN-XML (Liuwudian, Fujian Sheng, China)'),
    ('CN-LIU', 'CN-LIU (Liuyang, Hunan Sheng, China)'),
    ('CN-LZH', 'CN-LZH (Liuyang, Hunan Sheng, China)'),
    ('CN-LZP', 'CN-LZP (Liuzuo Pt, Hubei Sheng, China)'),
    ('CN-LIY', 'CN-LIY (Liuzuo Pt, Hubei Sheng, China)'),
    ('CN-LYP', 'CN-LYP (Liying Pt, Hubei Sheng, China)'),
    ('CN-LGA', 'CN-LGA (Liying Pt, Hubei Sheng, China)'),
    ('CN-LOG', 'CN-LOG (Liying Pt, Hubei Sheng, China)'),
    ('CN-LGB', 'CN-LGB (Liying Pt, Hubei Sheng, China)'),
    ('CN-LDG', 'CN-LDG (Longdong, Guangdong Sheng, China)'),
    ('CN-LGG', 'CN-LGG (Longgang, Guangdong Sheng, China)'),
    ('CN-LGU', 'CN-LGU (Longguan, Hebei Sheng, China)'),
    ('CN-LGI', 'CN-LGI (Longhai, Hunan Sheng, China)'),
    ('CN-LGH', 'CN-LGH (Longhua, Guangdong Sheng, China)'),
    ('CN-LLJ', 'CN-LLJ (Longjiang, Guangdong Sheng, China)'),
    ('CN-LKU', 'CN-LKU (Longkou Pt, Shandong Sheng, China)'),
    ('CN-LMN', 'CN-LMN (Longkou Pt, Shandong Sheng, China)'),
    ('CN-LOA', 'CN-LOA (Longnan, Jiangxi Sheng, China)'),
    ('CN-LPP', 'CN-LPP (Longping Pt, Hubei Sheng, China)'),
    ('CN-LGW', 'CN-LGW (Longping Pt, Hubei Sheng, China)'),
    ('CN-LYF', 'CN-LYF (Longyan, Fujian Sheng, China)'),
    ('CN-LGY', 'CN-LGY (Longyan Pt, Shandong Sheng, China)'),
    ('CN-LYO', 'CN-LYO (Longyao, Hebei Sheng, China)'),
    ('CN-LOZ', 'CN-LOZ (Longyao, Hebei Sheng, China)'),
    ('CN-LOS', 'CN-LOS (Loushan, Shandong Sheng, China)'),
    ('CN-LUN', "CN-LUN (Lu'an, Anhui Sheng, China)"),
    ('CN-LJK', 'CN-LJK (Luanjiakou, Shandong Sheng, China)'),
    ('CN-UBU', 'CN-UBU (Lubu, Guangdong Sheng, China)'),
    ('CN-LCP', 'CN-LCP (Lucheng Pt, Hubei Sheng, China)'),
    ('CN-LFN', 'CN-LFN (Lufeng, Guangdong Sheng, China)'),
    ('CN-LNN', 'CN-LNN (Lunan, Anhui Sheng, China)'),
    ('CN-LJO', 'CN-LJO (Lunjiao, Guangdong Sheng, China)'),
    ('CN-LUB', 'CN-LUB (Luobei, Heilongjiang Sheng, China)'),
    ('CN-LCW', 'CN-LCW (Luochongwei, Guangdong Sheng, China)'),
    ('CN-LCN', 'CN-LCN (Luocun, Guangdong Sheng, China)'),
    ('CN-LUO', 'CN-LUO (Luoding, Guangdong Sheng, China)'),
    ('CN-LUG', 'CN-LUG (Luogang, Guangdong Sheng, China)'),
    ('CN-LHE', 'CN-LHE (Luohe, Henan Sheng, China)'),
    ('CN-LOH', 'CN-LOH (Luohe, Henan Sheng, China)'),
    ('CN-LJT', 'CN-LJT (Luojingtan, Hubei Sheng, China)'),
    ('CN-LHN', 'CN-LHN (Luoniushan, Hainan Sheng, China)'),
    ('CN-LQI', 'CN-LQI (Luoniushan, Hainan Sheng, China)'),
    ('CN-LUX', 'CN-LUX (Luoniushan, Hainan Sheng, China)'),
    ('CN-LYA', 'CN-LYA (Luoyang Beijiao Apt, Henan Sheng, China)'),
    ('CN-LYZ', 'CN-LYZ (Luoyang Railway Station, Henan Sheng, China)'),
    ('CN-JLY', 'CN-JLY (Luoyuanwan, Fujian Sheng, China)'),
    ('CN-LQU', 'CN-LQU (Luoyuanwan, Fujian Sheng, China)'),
    ('CN-LSH', 'CN-LSH (Lushun New Pt, Liaoning Sheng, China)'),
    ('CN-LUS', 'CN-LUS (Lusi, Jiangsu Sheng, China)'),
    ('CN-LWN', 'CN-LWN (Lusi, Jiangsu Sheng, China)'),
    ('CN-LUM', 'CN-LUM (Luxi Apt/Dehong, Yunnan Sheng, China)'),
    ('CN-LXP', 'CN-LXP (Luxikou Pt, Hubei Sheng, China)'),
    ('CN-LZI', 'CN-LZI (Luxikou Pt, Hubei Sheng, China)'),
    ('CN-LUZ', 'CN-LUZ (Luzhou, Sichuan Sheng, China)'),
    ('CN-LUH', 'CN-LUH (Lü-hua Shan, Zhejiang Sheng, China)'),
    ('CN-MAA', 'CN-MAA (Maanshan Pt, Anhui Sheng, China)'),
    ('CN-MBI', 'CN-MBI (Mabian Island, Guangdong Sheng, China)'),
    ('CN-MCH', 'CN-MCH (Machong, Guangdong Sheng, China)'),
    ('CN-MAC', 'CN-MAC (Macun, Hainan Sheng, China)'),
    ('CN-SHM', 'CN-SHM (Mafang, Guangdong Sheng, China)'),
    ('CN-MJS', 'CN-MJS (Maji Shan, Zhejiang Sheng, China)'),
    ('CN-MJD', 'CN-MJD (Majiadian, Hubei Sheng, China)'),
    ('CN-MAJ', 'CN-MAJ (Majistan/Zhoushan, Zhejiang Sheng, China)'),
    ('CN-MAN', 'CN-MAN (Majistan/Zhoushan, Zhejiang Sheng, China)'),
    ('CN-MDL', 'CN-MDL (Majistan/Zhoushan, Zhejiang Sheng, China)'),
    ('CN-MLX', 'CN-MLX (Majistan/Zhoushan, Zhejiang Sheng, China)'),
    ('CN-NZH', 'CN-NZH (Majistan/Zhoushan, Zhejiang Sheng, China)'),
    ('CN-MOG', 'CN-MOG (Maogang, Guangdong Sheng, China)'),
    ('CN-MLG', 'CN-MLG (Maogang, Guangdong Sheng, China)'),
    ('CN-MMI', 'CN-MMI (Maoming, Guangdong Sheng, China)'),
    ('CN-MPP', 'CN-MPP (Maoping Pt, Hubei Sheng, China)'),
    ('CN-MSP', 'CN-MSP (Maoshan Pt, Hubei Sheng, China)'),
    ('CN-MTZ', 'CN-MTZ (Matouzhen, Jiangxi Sheng, China)'),
    ('CN-MWN', 'CN-MWN (Mawan Pt, Guangdong Sheng, China)'),
    ('CN-MAW', 'CN-MAW (Mawei Pt, Fujian Sheng, China)'),
    ('CN-MAY', 'CN-MAY (Mayong, Guangdong Sheng, China)'),
    ('CN-MZS', 'CN-MZS (Mazongshan, Gansu Sheng, China)'),
    ('CN-MCI', 'CN-MCI (Mazongshan, Gansu Sheng, China)'),
    ('CN-MIO', 'CN-MIO (Meiao, Zhejiang Sheng, China)'),
    ('CN-MGG', 'CN-MGG (Meigeng, Anhui Sheng, China)'),
    ('CN-MLI', 'CN-MLI (Meilin, Fujian Sheng, China)'),
    ('CN-MSA', 'CN-MSA (Meisha Pt, Guangdong Sheng, China)'),
    ('CN-MSN', 'CN-MSN (Meishan, Zhejiang Sheng, China)'),
    ('CN-MSG', 'CN-MSG (Meishan Pt, Zhejiang Sheng, China)'),
    ('CN-EIX', 'CN-EIX (Meishan Pt, Zhejiang Sheng, China)'),
    ('CN-MXZ', 'CN-MXZ (Meixian Changgangji Apt, Guangdong Sheng, China)'),
    ('CN-MEZ', 'CN-MEZ (Meizhou, Guangdong Sheng, China)'),
    ('CN-MZW', 'CN-MZW (Meizhouwan, Fujian Sheng, China)'),
    ('CN-MCX', 'CN-MCX (Mengcheng, Anhui Sheng, China)'),
    ('CN-MDN', 'CN-MDN (Mengding, Yunnan Sheng, China)'),
    ('CN-MLN', 'CN-MLN (Menglian, Yunnan Sheng, China)'),
    ('CN-MEN', 'CN-MEN (Menglian, Yunnan Sheng, China)'),
    ('CN-MYG', 'CN-MYG (Mianyang, Sichuan Sheng, China)'),
    ('CN-MIG', 'CN-MIG (Mianyang Nanjiao Apt, Sichuan Sheng, China)'),
    ('CN-MSW', 'CN-MSW (Miaoshanwei, Jiangsu Sheng, China)'),
    ('CN-MOT', 'CN-MOT (Miaotou, Guangdong Sheng, China)'),
    ('CN-MDU', 'CN-MDU (Midu, Yunnan Sheng, China)'),
    ('CN-MGX', 'CN-MGX (Midu, Yunnan Sheng, China)'),
    ('CN-MNG', 'CN-MNG (Midu, Yunnan Sheng, China)'),
    ('CN-MHG', 'CN-MHG (Midu, Yunnan Sheng, China)'),
    ('CN-MIS', 'CN-MIS (Mishan, Heilongjiang Sheng, China)'),
    ('CN-MIY', 'CN-MIY (Mishan, Heilongjiang Sheng, China)'),
    ('CN-MHN', 'CN-MHN (Mohan, Yunnan Sheng, China)'),
    ('CN-MOH', 'CN-MOH (Mohe, Heilongjiang Sheng, China)'),
    ('CN-LPG', 'CN-LPG (Mouping, Shandong Sheng, China)'),
    ('CN-MYM', 'CN-MYM (Moupingyangmadao, Shandong Sheng, China)'),
    ('CN-MDG', 'CN-MDG (Mudanjiang Hailang Apt, Heilongjiang Sheng, China)'),
    ('CN-MUG', 'CN-MUG (Mugang, Guangdong Sheng, China)'),
    ('CN-MZT', 'CN-MZT (Mugang, Guangdong Sheng, China)'),
    ('CN-MZU', 'CN-MZU (Muzhou, Guangdong Sheng, China)'),
    ('CN-NAS', "CN-NAS (Nan'an, Fujian Sheng, China)"),
    ('CN-NNN', "CN-NNN (Nan'an, Fujian Sheng, China)"),
    ('CN-GYN', 'CN-GYN (Nanan, Guangdong Sheng, China)'),
    ('CN-NAN', 'CN-NAN (Nanao Pt, Guangdong Sheng, China)'),
    ('CN-NBA', 'CN-NBA (Nanbian, Guangdong Sheng, China)'),
    ('CN-NCH', 'CN-NCH (Nanchang, Jiangxi Sheng, China)'),
    ('CN-KHN', 'CN-KHN (Nanchang Changbei International Apt, Jiangxi Sheng, China)'),
    ('CN-NCO', 'CN-NCO (Nanchong, Sichuan Sheng, China)'),
    ('CN-NDN', 'CN-NDN (Nanding, Shandong Sheng, China)'),
    ('CN-NAD', 'CN-NAD (Nanding, Shandong Sheng, China)'),
    ('CN-NAF', 'CN-NAF (Nanding, Shandong Sheng, China)'),
    ('CN-NGG', 'CN-NGG (Nangang, Guangdong Sheng, China)'),
    ('CN-NAH', 'CN-NAH (Nanhai Pt, Guangdong Sheng, China)'),
    ('CN-NNH', 'CN-NNH (Nanhai Pt, Guangdong Sheng, China)'),
    ('CN-NJK', 'CN-NJK (Nanjiangkou, Guangdong Sheng, China)'),
    ('CN-NJI', 'CN-NJI (Nanjing, Jiangsu Sheng, China)'),
    ('CN-NKG', 'CN-NKG (Nanjing Lukou International Apt, Jiangsu Sheng, China)'),
    ('CN-NJG', 'CN-NJG (Nanjing Pt, Jiangsu Sheng, China)'),
    ('CN-NLG', 'CN-NLG (Nanling, Anhui Sheng, China)'),
    ('CN-NIN', 'CN-NIN (Nanling, Anhui Sheng, China)'),
    ('CN-NIG', 'CN-NIG (Nanling, Anhui Sheng, China)'),
    ('CN-NNG', 'CN-NNG (Nanling, Anhui Sheng, China)'),
    ('CN-ANI', 'CN-ANI (Nanling, Anhui Sheng, China)'),
    ('CN-NAP', 'CN-NAP (Nanping, Jilin Sheng, China)'),
    ('CN-NPS', 'CN-NPS (Nanping, Fujian Sheng, China)'),
    ('CN-NQO', 'CN-NQO (Nanping, Fujian Sheng, China)'),
    ('CN-NSN', 'CN-NSN (Nansan, Yunnan Sheng, China)'),
    ('CN-NSA', 'CN-NSA (Nansha Pt, Guangdong Sheng, China)'),
    ('CN-NSH', 'CN-NSH (Nanshan, Guangdong Sheng, China)'),
    ('CN-NTG', 'CN-NTG (Nantong Pt, Jiangsu Sheng, China)'),
    ('CN-NTU', 'CN-NTU (Nantou, Guangdong Sheng, China)'),
    ('CN-NWI', 'CN-NWI (Nanwei, Guangdong Sheng, China)'),
    ('CN-NNX', 'CN-NNX (Nanxi, Sichuan Sheng, China)'),
    ('CN-NXI', 'CN-NXI (Nanxi, Sichuan Sheng, China)'),
    ('CN-NYA', 'CN-NYA (Nanyang, Henan Sheng, China)'),
    ('CN-NYG', 'CN-NYG (Nanyang, Henan Sheng, China)'),
    ('CN-NAY', 'CN-NAY (Nanyang, Henan Sheng, China)'),
    ('CN-NZA', 'CN-NZA (Nanzhuang, Henan Sheng, China)'),
    ('CN-NZU', 'CN-NZU (Nanzhuang, Hebei Sheng, China)'),
    ('CN-ZNZ', 'CN-ZNZ (Naozhou, Guangdong Sheng, China)'),
    ('CN-NAT', 'CN-NAT (Naozhou, Guangdong Sheng, China)'),
    ('CN-NWA', 'CN-NWA (Naozhou, Guangdong Sheng, China)'),
    ('CN-NEG', 'CN-NEG (Neigang, Guangdong Sheng, China)'),
    ('CN-NSY', 'CN-NSY (Nianshanyapojiao, Guangdong Sheng, China)'),
    ('CN-NZG', 'CN-NZG (Nianshanyapojiao, Guangdong Sheng, China)'),
    ('CN-NCA', 'CN-NCA (Nicha, Anhui Sheng, China)'),
    ('CN-NIA', "CN-NIA (Ning'an, Heilongjiang Sheng, China)"),
    ('CN-NBO', 'CN-NBO (Ningbo, Zhejiang Sheng, China)'),
    ('CN-NGB', 'CN-NGB (Ningbo Lishe International Apt, Zhejiang Sheng, China)'),
    ('CN-NBG', 'CN-NBG (Ningbo Pt, Zhejiang Sheng, China)'),
    ('CN-NDE', 'CN-NDE (Ningde, Fujian Sheng, China)'),
    ('CN-NGU', 'CN-NGU (Ningde, Fujian Sheng, China)'),
    ('CN-NHE', 'CN-NHE (Ningde, Fujian Sheng, China)'),
    ('CN-NMI', 'CN-NMI (Ningde, Fujian Sheng, China)'),
    ('CN-NGW', 'CN-NGW (Ningwu, Shanxi Sheng, China)'),
    ('CN-NKL', 'CN-NKL (Niuguling, Guangdong Sheng, China)'),
    ('CN-NTN', 'CN-NTN (Niutoushan, Anhui Sheng, China)'),
    ('CN-NUD', 'CN-NUD (Nudao, Shandong Sheng, China)'),
    ('CN-LZY', 'CN-LZY (Nudao, Shandong Sheng, China)'),
    ('CN-ORD', 'CN-ORD (Nudao, Shandong Sheng, China)'),
    ('CN-PZO', 'CN-PZO (Paizhou, Hubei Sheng, China)'),
    ('CN-PAJ', 'CN-PAJ (Panjin, Liaoning Sheng, China)'),
    ('CN-PNT', 'CN-PNT (Pantang, Hubei Sheng, China)'),
    ('CN-PYU', 'CN-PYU (Panyu, Guangdong Sheng, China)'),
    ('CN-PZI', 'CN-PZI (Panzhihua Apt, Sichuan Sheng, China)'),
    ('CN-PZH', 'CN-PZH (Panzhihuazhan, Sichuan Sheng, China)'),
    ('CN-PLI', 'CN-PLI (Penglai Pt, Shandong Sheng, China)'),
    ('CN-PZE', 'CN-PZE (Pengze, Jiangxi Sheng, China)'),
    ('CN-PMA', 'CN-PMA (Pianma, Yunnan Sheng, China)'),
    ('CN-PKO', 'CN-PKO (Pikou, Liaoning Sheng, China)'),
    ('CN-PND', 'CN-PND (Pingdi, Guizhou Sheng, China)'),
    ('CN-PDE', 'CN-PDE (Pingdingshan East, Henan Sheng, China)'),
    ('CN-PDU', 'CN-PDU (Pingdingshan East, Henan Sheng, China)'),
    ('CN-PIG', 'CN-PIG (Pingdingshan East, Henan Sheng, China)'),
    ('CN-PII', 'CN-PII (Pinghai, Guangdong Sheng, China)'),
    ('CN-PHU', 'CN-PHU (Pinghu, Guangdong Sheng, China)'),
    ('CN-PNH', 'CN-PNH (Pinghu, Guizhou Sheng, China)'),
    ('CN-PNU', 'CN-PNU (Pinghu, Zhejiang Sheng, China)'),
    ('CN-PHN', "CN-PHN (Pinghu'Nan, Guangdong Sheng, China)"),
    ('CN-PIL', "CN-PIL (Pinghu'Nan, Guangdong Sheng, China)"),
    ('CN-PGM', "CN-PGM (Pinghu'Nan, Guangdong Sheng, China)"),
    ('CN-PGN', "CN-PGN (Pinghu'Nan, Guangdong Sheng, China)"),
    ('CN-PSH', 'CN-PSH (Pingsha, Guangdong Sheng, China)'),
    ('CN-PNS', 'CN-PNS (Pingshan, Guangdong Sheng, China)'),
    ('CN-PXM', 'CN-PXM (Pingshaxinmatou, Guangdong Sheng, China)'),
    ('CN-PIS', 'CN-PIS (Pingshi, Guangdong Sheng, China)'),
    ('CN-PIN', 'CN-PIN (Pingshi, Guangdong Sheng, China)'),
    ('CN-PGZ', 'CN-PGZ (Pingzhou, Guangdong Sheng, China)'),
    ('CN-PJS', 'CN-PJS (Pizhou, Jiangsu Sheng, China)'),
    ('CN-POJ', 'CN-POJ (Poji, Guangdong Sheng, China)'),
    ('CN-PJO', 'CN-PJO (Pojiao, Guizhou Sheng, China)'),
    ('CN-PCH', 'CN-PCH (Pojiao, Guizhou Sheng, China)'),
    ('CN-PDG', 'CN-PDG (Pojiao, Guizhou Sheng, China)'),
    ('CN-PDX', 'CN-PDX (Pojiao, Guizhou Sheng, China)'),
    ('CN-PNG', 'CN-PNG (Puning, Guangdong Sheng, China)'),
    ('CN-PQI', 'CN-PQI (Puqi, Zhejiang Sheng, China)'),
    ('CN-PQA', 'CN-PQA (Puqian, Hainan Sheng, China)'),
    ('CN-PUT', 'CN-PUT (Putian, Fujian Sheng, China)'),
    ('CN-PXI', 'CN-PXI (Puxi, Zhejiang Sheng, China)'),
    ('CN-PYG', 'CN-PYG (Puxi, Zhejiang Sheng, China)'),
    ('CN-QDO', 'CN-QDO (Puxi, Zhejiang Sheng, China)'),
    ('CN-QJO', 'CN-QJO (Qiangjiao, Zhejiang Sheng, China)'),
    ('CN-QHW', 'CN-QHW (Qianhaiwan Pt, Guangdong Sheng, China)'),
    ('CN-QSN', 'CN-QSN (Qianshan/Zhuhai, Guangdong Sheng, China)'),
    ('CN-QAW', 'CN-QAW (Qianwan, Shandong Sheng, China)'),
    ('CN-QIA', 'CN-QIA (Qianxi, Hebei Sheng, China)'),
    ('CN-QNX', 'CN-QNX (Qianxi, Hebei Sheng, China)'),
    ('CN-LJQ', 'CN-LJQ (Qianyu, Fujian Sheng, China)'),
    ('CN-QIE', 'CN-QIE (Qiaoshe, Guangdong Sheng, China)'),
    ('CN-QTU', 'CN-QTU (Qiaotou, Qinghai Sheng, China)'),
    ('CN-QXU', 'CN-QXU (Qiaotou, Qinghai Sheng, China)'),
    ('CN-QID', 'CN-QID (Qidong Pt, Jiangsu Sheng, China)'),
    ('CN-IQM', 'CN-IQM (Qidong Pt, Jiangsu Sheng, China)'),
    ('CN-QIH', 'CN-QIH (Qidong Pt, Jiangsu Sheng, China)'),
    ('CN-QKE', 'CN-QKE (Qike, Heilongjiang Sheng, China)'),
    ('CN-QMN', 'CN-QMN (Qimen, Zhejiang Sheng, China)'),
    ('CN-QDL', 'CN-QDL (Qindeli, Heilongjiang Sheng, China)'),
    ('CN-QIN', 'CN-QIN (Qingdao, Shandong Sheng, China)'),
    ('CN-TAO', 'CN-TAO (Qingdao Liuting International Apt, Shandong Sheng, China)'),
    ('CN-QDG', 'CN-QDG (Qingdao Pt, Shandong Sheng, China)'),
    ('CN-QGG', 'CN-QGG (Qingge, Hainan Sheng, China)'),
    ('CN-QIG', 'CN-QIG (Qingge, Hainan Sheng, China)'),
    ('CN-QHE', 'CN-QHE (Qinghe, Heilongjiang Sheng, China)'),
    ('CN-QJI', 'CN-QJI (Qingjiang, Zhejiang Sheng, China)'),
    ('CN-QLN', 'CN-QLN (Qinglan Pt, Hainan Sheng, China)'),
    ('CN-QLU', 'CN-QLU (Qinglan Pt, Hainan Sheng, China)'),
    ('CN-QGP', 'CN-QGP (Qinglan Pt, Hainan Sheng, China)'),
    ('CN-QGS', 'CN-QGS (Qingshi, Jilin Sheng, China)'),
    ('CN-QSE', 'CN-QSE (Qingshuihe/Shenzhen, Guangdong Sheng, China)'),
    ('CN-QXI', 'CN-QXI (Qingxi, Guangdong Sheng, China)'),
    ('CN-QIX', 'CN-QIX (Qingxi, Guangdong Sheng, China)'),
    ('CN-QYA', 'CN-QYA (Qingyang, Jiangsu Sheng, China)'),
    ('CN-IQN', 'CN-IQN (Qingyang Xifengzhen Apt, Gansu Sheng, China)'),
    ('CN-QGY', 'CN-QGY (Qingyuan, Guangdong Sheng, China)'),
    ('CN-QGZ', 'CN-QGZ (Qingzhou, Shandong Sheng, China)'),
    ('CN-QOU', 'CN-QOU (Qingzhou, Shandong Sheng, China)'),
    ('CN-SHP', 'CN-SHP (Qinhuangdao Pt, Hebei Sheng, China)'),
    ('CN-QJG', 'CN-QJG (Qinhuangdao Pt, Hebei Sheng, China)'),
    ('CN-QZH', 'CN-QZH (Qinhuangdao Pt, Hebei Sheng, China)'),
    ('CN-SAJ', 'CN-SAJ (Qinhuangdao Pt, Hebei Sheng, China)'),
    ('CN-QHA', 'CN-QHA (Qionghai, Hainan Sheng, China)'),
    ('CN-QZG', 'CN-QZG (Qiongzhong, Hainan Sheng, China)'),
    ('CN-NDG', 'CN-NDG (Qiqihar Sanjiazi Apt, Heilongjiang Sheng, China)'),
    ('CN-QSA', 'CN-QSA (Qiqihar Sanjiazi Apt, Heilongjiang Sheng, China)'),
    ('CN-QXT', 'CN-QXT (Qixingtai, Hubei Sheng, China)'),
    ('CN-QZO', 'CN-QZO (Qizhou, Hubei Sheng, China)'),
    ('CN-TCG', 'CN-TCG (Qizhou, Hubei Sheng, China)'),
    ('CN-QUH', 'CN-QUH (Quanhe, Jilin Sheng, China)'),
    ('CN-QUJ', 'CN-QUJ (Quanjiao, Anhui Sheng, China)'),
    ('CN-QYG', 'CN-QYG (Quanyang, Jilin Sheng, China)'),
    ('CN-QZL', 'CN-QZL (Quanzhou, Fujian Sheng, China)'),
    ('CN-JJN', 'CN-JJN (Quanzhou Jinjiang Apt, Fujian Sheng, China)'),
    ('CN-QZJ', 'CN-QZJ (Quanzhou Pt, Fujian Sheng, China)'),
    ('CN-QUF', 'CN-QUF (Qufu, Shandong Sheng, China)'),
    ('CN-QUI', 'CN-QUI (Qujing, Yunnan Sheng, China)'),
    ('CN-QKU', 'CN-QKU (Qukou, Hainan Sheng, China)'),
    ('CN-JDR', 'CN-JDR (Quxi, Guangdong Sheng, China)'),
    ('CN-QUY', 'CN-QUY (Quxi, Guangdong Sheng, China)'),
    ('CN-QZS', 'CN-QZS (Quzhou, Zhejiang Sheng, China)'),
    ('CN-ROH', 'CN-ROH (Raohe, Heilongjiang Sheng, China)'),
    ('CN-RPG', 'CN-RPG (Raoping, Guangdong Sheng, China)'),
    ('CN-RNH', 'CN-RNH (Raoping, Guangdong Sheng, China)'),
    ('CN-RKZ', 'CN-RKZ (Raoping, Guangdong Sheng, China)'),
    ('CN-RIW', 'CN-RIW (Raoping, Guangdong Sheng, China)'),
    ('CN-RZH', 'CN-RZH (Rizhao Pt, Shandong Sheng, China)'),
    ('CN-RGA', 'CN-RGA (Rizhao Pt, Shandong Sheng, China)'),
    ('CN-RCG', 'CN-RCG (Rongcheng, Shandong Sheng, China)'),
    ('CN-RCH', 'CN-RCH (Rongcheng, Hubei Sheng, China)'),
    ('CN-RGC', 'CN-RGC (Rongcheng, Guangdong Sheng, China)'),
    ('CN-RNG', 'CN-RNG (Rongcheng, Hebei Sheng, China)'),
    ('CN-RJG', 'CN-RJG (Rongjiang, Guizhou Sheng, China)'),
    ('CN-ROQ', 'CN-ROQ (Rongqi Pt, Guangdong Sheng, China)'),
    ('CN-RSI', 'CN-RSI (Rongqi Pt, Guangdong Sheng, China)'),
    ('CN-RXN', 'CN-RXN (Rongxian, Fujian Sheng, China)'),
    ('CN-RDO', 'CN-RDO (Rongxian, Fujian Sheng, China)'),
    ('CN-RUD', 'CN-RUD (Rongxian, Fujian Sheng, China)'),
    ('CN-RUG', 'CN-RUG (Rugao Pt, Jiangsu Sheng, China)'),
    ('CN-RIA', 'CN-RIA (Ruian, Zhejiang Sheng, China)'),
    ('CN-RAG', 'CN-RAG (Ruichang, Jiangxi Sheng, China)'),
    ('CN-RUC', 'CN-RUC (Ruichang, Jiangxi Sheng, China)'),
    ('CN-RUJ', 'CN-RUJ (Ruichang, Jiangxi Sheng, China)'),
    ('CN-RUI', 'CN-RUI (Ruili, Yunnan Sheng, China)'),
    ('CN-RJN', 'CN-RJN (Runjiang, Jiangsu Sheng, China)'),
    ('CN-WHR', 'CN-WHR (Rushan, Shandong Sheng, China)'),
    ('CN-RSN', 'CN-RSN (Rushankou, Shandong Sheng, China)'),
    ('CN-SIQ', 'CN-SIQ (Saiqi, Fujian Sheng, China)'),
    ('CN-SBM', 'CN-SBM (Saiqi, Fujian Sheng, China)'),
    ('CN-SAU', 'CN-SAU (Sanbu, Gansu Sheng, China)'),
    ('CN-SBU', 'CN-SBU (Sanbu Pt, Guangdong Sheng, China)'),
    ('CN-SDP', 'CN-SDP (Sandouping, Hubei Sheng, China)'),
    ('CN-ANH', 'CN-ANH (Sanhe, Guangdong Sheng, China)'),
    ('CN-SAH', 'CN-SAH (Sanhe, Jilin Sheng, China)'),
    ('CN-SAA', 'CN-SAA (Sanhua, Hubei Sheng, China)'),
    ('CN-SIG', 'CN-SIG (Sanjiang, Jiangsu Sheng, China)'),
    ('CN-PTS', 'CN-PTS (Sanjiangkou, Fujian Sheng, China)'),
    ('CN-SMX', 'CN-SMX (Sanmen, Henan Sheng, China)'),
    ('CN-SNP', 'CN-SNP (Sanmen, Henan Sheng, China)'),
    ('CN-SMS', 'CN-SMS (Sanming, Fujian Sheng, China)'),
    ('CN-SAM', 'CN-SAM (Sanming, Fujian Sheng, China)'),
    ('CN-SRG', 'CN-SRG (Sanrong, Guangdong Sheng, China)'),
    ('CN-SNS', 'CN-SNS (Sansha, Fujian Sheng, China)'),
    ('CN-NHS', 'CN-NHS (Sanshan pt, Guangdong Sheng, China)'),
    ('CN-SNU', 'CN-SNU (Sanshu, Jiangsu Sheng, China)'),
    ('CN-SJQ', 'CN-SJQ (Sanshui, Guangdong Sheng, China)'),
    ('CN-SYX', 'CN-SYX (Sanya Fenghuang International Apt, Hainan Sheng, China)'),
    ('CN-SYA', 'CN-SYA (Sanya Pt, Hainan Sheng, China)'),
    ('CN-SNA', 'CN-SNA (Sanyang, Jiangsu Sheng, China)'),
    ('CN-SNL', 'CN-SNL (Sanyuanli/Guangzhou, Guangdong Sheng, China)'),
    ('CN-SZA', 'CN-SZA (Sanzao, Guangdong Sheng, China)'),
    ('CN-SZO', 'CN-SZO (Sanzhou, Hubei Sheng, China)'),
    ('CN-KJC', 'CN-KJC (Sanzhou, Hubei Sheng, China)'),
    ('CN-NDS', 'CN-NDS (Shacheng, Fujian Sheng, China)'),
    ('CN-SAT', 'CN-SAT (Shadi, Guangdong Sheng, China)'),
    ('CN-SDU', 'CN-SDU (Shadui, Guangdong Sheng, China)'),
    ('CN-SAE', 'CN-SAE (Shadui, Guangdong Sheng, China)'),
    ('CN-SEH', 'CN-SEH (Shahe, Guangdong Sheng, China)'),
    ('CN-SEZ', 'CN-SEZ (Shahezi, Heilongjiang Sheng, China)'),
    ('CN-SHO', 'CN-SHO (Shajiao, Guangdong Sheng, China)'),
    ('CN-SHJ', 'CN-SHJ (Shajing, Guangdong Sheng, China)'),
    ('CN-SAL', 'CN-SAL (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SAD', 'CN-SAD (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SGH', 'CN-SGH (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SHA', 'CN-SHA (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SHG', 'CN-SHG (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-PVG', 'CN-PVG (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SHZ', 'CN-SHZ (Shalingzhuang, Shandong Sheng, China)'),
    ('CN-SRS', 'CN-SRS (Shangrao, Jiangxi Sheng, China)'),
    ('CN-SGI', 'CN-SGI (Shangrao, Jiangxi Sheng, China)'),
    ('CN-SGU', 'CN-SGU (Shangyu, Zhejiang Sheng, China)'),
    ('CN-SQS', 'CN-SQS (Shanqiu, Henan Sheng, China)'),
    ('CN-SXJ', 'CN-SXJ (Shanqiu, Henan Sheng, China)'),
    ('CN-SNI', 'CN-SNI (Shanshi, Heilongjiang Sheng, China)'),
    ('CN-SSI', 'CN-SSI (Shanshui, Shanxi Sheng, China)'),
    ('CN-STG', 'CN-STG (Shantou Pt, Guangdong Sheng, China)'),
    ('CN-SAW', 'CN-SAW (Shanwai, Zhejiang Sheng, China)'),
    ('CN-SWE', 'CN-SWE (Shanwei Pt, Guangdong Sheng, China)'),
    ('CN-HSC', 'CN-HSC (Shaoguan New Pt, Guangdong Sheng, China)'),
    ('CN-SOS', 'CN-SOS (Shaoshan, Hunan Sheng, China)'),
    ('CN-SWU', 'CN-SWU (Shaoshan, Hunan Sheng, China)'),
    ('CN-SXG', 'CN-SXG (Shaoxing, Zhejiang Sheng, China)'),
    ('CN-AOY', 'CN-AOY (Shaoxing, Zhejiang Sheng, China)'),
    ('CN-SPA', 'CN-SPA (Shapa, Guangdong Sheng, China)'),
    ('CN-SAP', 'CN-SAP (Shapa, Guangdong Sheng, China)'),
    ('CN-SPB', 'CN-SPB (Shapa, Guangdong Sheng, China)'),
    ('CN-SSN', 'CN-SSN (Shashan, Zhejiang Sheng, China)'),
    ('CN-SSG', 'CN-SSG (Shashan, Zhejiang Sheng, China)'),
    ('CN-SHS', 'CN-SHS (Shashi, Hubei Sheng, China)'),
    ('CN-STI', 'CN-STI (Shatian, Guangdong Sheng, China)'),
    ('CN-SHT', 'CN-SHT (Shating, Guangdong Sheng, China)'),
    ('CN-STO', 'CN-STO (Shatou, Guangdong Sheng, China)'),
    ('CN-STJ', 'CN-STJ (Shatoujiao, Guangdong Sheng, China)'),
    ('CN-STZ', 'CN-STZ (Shatoujiao, Guangdong Sheng, China)'),
    ('CN-SWN', 'CN-SWN (Shawan, Guangdong Sheng, China)'),
    ('CN-SXN', 'CN-SXN (Shawan, Guangdong Sheng, China)'),
    ('CN-SYC', 'CN-SYC (Shayuchong, Guangdong Sheng, China)'),
    ('CN-SHK', 'CN-SHK (Shekou Pt, Guangdong Sheng, China)'),
    ('CN-SGD', 'CN-SGD (Shengdong, Zhejiang Sheng, China)'),
    ('CN-SGZ', 'CN-SGZ (Shengzhou, Zhejiang Sheng, China)'),
    ('CN-SNH', 'CN-SNH (Shenhu, Fujian Sheng, China)'),
    ('CN-SQN', 'CN-SQN (Shenquan, Guangdong Sheng, China)'),
    ('CN-SNW', 'CN-SNW (Shenwan, Guangdong Sheng, China)'),
    ('CN-SHY', 'CN-SHY (Shenyang, Liaoning Sheng, China)'),
    ('CN-SHE', 'CN-SHE (Shenyang Taoxian International Apt, Liaoning Sheng, China)'),
    ('CN-SYD', 'CN-SYD (Shenyangdong Railway Station, Liaoning Sheng, China)'),
    ('CN-SNZ', 'CN-SNZ (Shenzhen, Guangdong Sheng, China)'),
    ('CN-SZX', 'CN-SZX (Shenzhen Baoan International Apt, Guangdong Sheng, China)'),
    ('CN-SZP', 'CN-SZP (Shenzhen Pt, Guangdong Sheng, China)'),
    ('CN-SZZ', 'CN-SZZ (Shenzhen Railway Station, Guangdong Sheng, China)'),
    ('CN-SZW', 'CN-SZW (Shenzhenwan, Guangdong Sheng, China)'),
    ('CN-SEY', 'CN-SEY (Sheyang, Jiangsu Sheng, China)'),
    ('CN-SBH', 'CN-SBH (Shibahe, Anhui Sheng, China)'),
    ('CN-SBL', 'CN-SBL (Shibahe, Anhui Sheng, China)'),
    ('CN-SHD', 'CN-SHD (Shidao Pt, Shandong Sheng, China)'),
    ('CN-SGO', "CN-SGO (Shigang'ao, Guangdong Sheng, China)"),
    ('CN-SZI', "CN-SZI (Shigang'ao, Guangdong Sheng, China)"),
    ('CN-SHU', 'CN-SHU (Shihu, Fujian Sheng, China)'),
    ('CN-SJZ', 'CN-SJZ (Shijiazhuang, Hebei Sheng, China)'),
    ('CN-SJW', 'CN-SJW (Shijiazhuang Zhengding International Apt, Hebei Sheng, China)'),
    ('CN-SJE', 'CN-SJE (Shijie, Guangdong Sheng, China)'),
    ('CN-SIJ', 'CN-SIJ (Shijing, Fujian Sheng, China)'),
    ('CN-SJJ', 'CN-SJJ (Shijingjiaoxin, Guangdong Sheng, China)'),
    ('CN-SJO', 'CN-SJO (Shijitou, Hubei Sheng, China)'),
    ('CN-SJU', 'CN-SJU (Shijiu Pt, Shandong Sheng, China)'),
    ('CN-SLG', 'CN-SLG (Shiliugang, Guangdong Sheng, China)'),
    ('CN-SLO', 'CN-SLO (Shilou, Guangdong Sheng, China)'),
    ('CN-SLU', 'CN-SLU (Shilu, Hainan Sheng, China)'),
    ('CN-ZSM', 'CN-ZSM (Shima, Fujian Sheng, China)'),
    ('CN-SPI', 'CN-SPI (Shipai, Anhui Sheng, China)'),
    ('CN-XSP', 'CN-XSP (Shipu, Zhejiang Sheng, China)'),
    ('CN-SHQ', 'CN-SHQ (Shiqi, Guangdong Sheng, China)'),
    ('CN-PNY', 'CN-PNY (Shiqiao, Guangdong Sheng, China)'),
    ('CN-SQU', 'CN-SQU (Shiqiao, Guangdong Sheng, China)'),
    ('CN-SSQ', 'CN-SSQ (Shiqiaopu, Hubei Sheng, China)'),
    ('CN-SIP', 'CN-SIP (Shiqiaopu, Hubei Sheng, China)'),
    ('CN-SQH', 'CN-SQH (Shiqiaopu, Hubei Sheng, China)'),
    ('CN-SSA', 'CN-SSA (Shishan, Liaoning Sheng, China)'),
    ('CN-SHH', 'CN-SHH (Shishi, Fujian Sheng, China)'),
    ('CN-STN', 'CN-STN (Shishi, Fujian Sheng, China)'),
    ('CN-STB', 'CN-STB (Shishi, Fujian Sheng, China)'),
    ('CN-SAN', 'CN-SAN (Shiwan, Guangdong Sheng, China)'),
    ('CN-SHN', 'CN-SHN (Shiwan, Hunan Sheng, China)'),
    ('CN-SWI', 'CN-SWI (Shiwan, Hunan Sheng, China)'),
    ('CN-SXI', 'CN-SXI (Shixing, Guangdong Sheng, China)'),
    ('CN-SYN', 'CN-SYN (Shiyan, Guangdong Sheng, China)'),
    ('CN-SIY', 'CN-SIY (Shiyan Railway Station, Hubei Sheng, China)'),
    ('CN-SYG', 'CN-SYG (Shiyang, Anhui Sheng, China)'),
    ('CN-SIU', 'CN-SIU (Shiyang, Anhui Sheng, China)'),
    ('CN-SGN', 'CN-SGN (Shiyang, Anhui Sheng, China)'),
    ('CN-SAC', 'CN-SAC (Shiyang, Anhui Sheng, China)'),
    ('CN-SSP', 'CN-SSP (Shuangshui, Guangdong Sheng, China)'),
    ('CN-SUB', 'CN-SUB (Shuibu, Guangdong Sheng, China)'),
    ('CN-SDG', 'CN-SDG (Shuidong Pt, Guangdong Sheng, China)'),
    ('CN-SIK', 'CN-SIK (Shuikou, Guangdong Sheng, China)'),
    ('CN-SKO', 'CN-SKO (Shuikou, Guangdong Sheng, China)'),
    ('CN-SUD', 'CN-SUD (Shunde Pt, Guangdong Sheng, China)'),
    ('CN-SNY', 'CN-SNY (Shunde Pt, Guangdong Sheng, China)'),
    ('CN-SHL', 'CN-SHL (Shunde Pt, Guangdong Sheng, China)'),
    ('CN-SUY', 'CN-SUY (Shunde Pt, Guangdong Sheng, China)'),
    ('CN-SIH', 'CN-SIH (Sihui, Guangdong Sheng, China)'),
    ('CN-SJT', 'CN-SJT (Sihui, Guangdong Sheng, China)'),
    ('CN-SKG', 'CN-SKG (Sikeng, Guangdong Sheng, China)'),
    ('CN-SKS', 'CN-SKS (Sikuaishi, Liaoning Sheng, China)'),
    ('CN-SYM', 'CN-SYM (Simao, Yunnan Sheng, China)'),
    ('CN-SPG', 'CN-SPG (Simao, Yunnan Sheng, China)'),
    ('CN-SOG', 'CN-SOG (Simao, Yunnan Sheng, China)'),
    ('CN-SAG', 'CN-SAG (Songgang, Guangdong Sheng, China)'),
    ('CN-SGJ', 'CN-SGJ (Songgang, Guangdong Sheng, China)'),
    ('CN-SMN', 'CN-SMN (Songmen, Zhejiang Sheng, China)'),
    ('CN-SGS', 'CN-SGS (Songmen, Zhejiang Sheng, China)'),
    ('CN-SON', 'CN-SON (Songxia Pt, Fujian Sheng, China)'),
    ('CN-SZK', 'CN-SZK (Songzikou, Hubei Sheng, China)'),
    ('CN-SBN', 'CN-SBN (Suibin, Heilongjiang Sheng, China)'),
    ('CN-SCH', 'CN-SCH (Suibin, Heilongjiang Sheng, China)'),
    ('CN-CFF', 'CN-CFF (Suidong, Heilongjiang Sheng, China)'),
    ('CN-SFH', 'CN-SFH (Suifenhe, Heilongjiang Sheng, China)'),
    ('CN-SFE', 'CN-SFE (Suifenhe Railway Station, Heilongjiang Sheng, China)'),
    ('CN-SUG', 'CN-SUG (Suifenhe Railway Station, Heilongjiang Sheng, China)'),
    ('CN-SGG', 'CN-SGG (Suijiang, Yunnan Sheng, China)'),
    ('CN-SNN', 'CN-SNN (Suining, Sichuan Sheng, China)'),
    ('CN-SUX', 'CN-SUX (Suining, Sichuan Sheng, China)'),
    ('CN-SIZ', 'CN-SIZ (Suizhong, Liaoning Sheng, China)'),
    ('CN-WUX', 'CN-WUX (Sunan Shuofang International Apt, Jiangsu Sheng, China)'),
    ('CN-SUW', 'CN-SUW (Sunwu, Heilongjiang Sheng, China)'),
    ('CN-SUQ', 'CN-SUQ (Suqian, Jiangsu Sheng, China)'),
    ('CN-SUH', 'CN-SUH (Suzhou, Anhui Sheng, China)'),
    ('CN-SUZ', 'CN-SUZ (Suzhou, Gansu Sheng, China)'),
    ('CN-SZH', 'CN-SZH (Suzhou, Jiangsu Sheng, China)'),
    ('CN-SZG', 'CN-SZG (Suzhou Pt, Jiangsu Sheng, China)'),
    ('CN-TCS', 'CN-TCS (Suzhou Pt, Jiangsu Sheng, China)'),
    ('CN-TPO', 'CN-TPO (Suzhou Pt, Jiangsu Sheng, China)'),
    ('CN-TAI', 'CN-TAI (Taian, Shandong Sheng, China)'),
    ('CN-TAC', 'CN-TAC (Taicang Pt, Jiangsu Sheng, China)'),
    ('CN-THG', 'CN-THG (Taicheng (Taishan), Guangdong Sheng, China)'),
    ('CN-THE', 'CN-THE (Taihe, Anhui Sheng, China)'),
    ('CN-TJG', 'CN-TJG (Taijiang, Fujian Sheng, China)'),
    ('CN-TAP', 'CN-TAP (Taiping, Guangdong Sheng, China)'),
    ('CN-TPK', 'CN-TPK (Taipingkou, Hubei Sheng, China)'),
    ('CN-TPW', 'CN-TPW (Taipingwan, Liaoning Sheng, China)'),
    ('CN-TIS', 'CN-TIS (Taishan, Guangdong Sheng, China)'),
    ('CN-TSA', 'CN-TSA (Taishan, Shandong Sheng, China)'),
    ('CN-TAX', 'CN-TAX (Taixing, Jiangsu Sheng, China)'),
    ('CN-TAY', 'CN-TAY (Taiyang, Zhejiang Sheng, China)'),
    ('CN-TYU', 'CN-TYU (Taiyuan, Shanxi Sheng, China)'),
    ('CN-TYN', 'CN-TYN (Taiyuan Wusu International Apt, Shanxi Sheng, China)'),
    ('CN-TZO', 'CN-TZO (Taizhou, Jiangsu Sheng, China)'),
    ('CN-TAZ', 'CN-TAZ (Taizhou Pt, Zhejiang Sheng, China)'),
    ('CN-TZU', 'CN-TZU (Taizhou Pt, Jiangsu Sheng, China)'),
    ('CN-TNO', 'CN-TNO (Tanggou, Anhui Sheng, China)'),
    ('CN-TGG', 'CN-TGG (Tanggou, Anhui Sheng, China)'),
    ('CN-TJA', 'CN-TJA (Tangjia, Guangdong Sheng, China)'),
    ('CN-TGK', 'CN-TGK (Tangkou, Guangdong Sheng, China)'),
    ('CN-TGS', 'CN-TGS (Tangshan Pt, Hebei Sheng, China)'),
    ('CN-TGX', 'CN-TGX (Tangxi, Guangdong Sheng, China)'),
    ('CN-TXA', 'CN-TXA (Tangxia, Guangdong Sheng, China)'),
    ('CN-QNH', 'CN-QNH (Tanmen, Hainan Sheng, China)'),
    ('CN-YKU', 'CN-YKU (Taokou, Anhui Sheng, China)'),
    ('CN-TYG', 'CN-TYG (Taoyang, Gansu Sheng, China)'),
    ('CN-TKK', 'CN-TKK (Taoyang, Gansu Sheng, China)'),
    ('CN-TXI', 'CN-TXI (Taoyang, Gansu Sheng, China)'),
    ('CN-TGZ', 'CN-TGZ (Tengzhou, Shandong Sheng, China)'),
    ('CN-TBO', 'CN-TBO (Tianbao, Yunnan Sheng, China)'),
    ('CN-TID', 'CN-TID (Tianbao, Yunnan Sheng, China)'),
    ('CN-TDU', 'CN-TDU (Tiandu, Hainan Sheng, China)'),
    ('CN-TIH', 'CN-TIH (Tianhe, Guangdong Sheng, China)'),
    ('CN-TNJ', 'CN-TNJ (Tianhe, Guangdong Sheng, China)'),
    ('CN-TSN', 'CN-TSN (Tianhe, Guangdong Sheng, China)'),
    ('CN-TNG', 'CN-TNG (Tianhe, Guangdong Sheng, China)'),
    ('CN-TXG', 'CN-TXG (Tianhe, Guangdong Sheng, China)'),
    ('CN-TBS', 'CN-TBS (Tianhe, Guangdong Sheng, China)'),
    ('CN-TLN', 'CN-TLN (Tianhe, Guangdong Sheng, China)'),
    ('CN-TNP', 'CN-TNP (Tianpeng, Yunnan Sheng, China)'),
    ('CN-TSU', 'CN-TSU (Tianshui, Gansu Sheng, China)'),
    ('CN-TIA', 'CN-TIA (Tianshui, Gansu Sheng, China)'),
    ('CN-TIY', 'CN-TIY (Tianshui, Gansu Sheng, China)'),
    ('CN-TZE', 'CN-TZE (Tianzhen, Hubei Sheng, China)'),
    ('CN-TLI', 'CN-TLI (Tieli, Heilongjiang Sheng, China)'),
    ('CN-TIL', 'CN-TIL (Tieli, Heilongjiang Sheng, China)'),
    ('CN-BHT', 'CN-BHT (Tieli, Heilongjiang Sheng, China)'),
    ('CN-TOG', 'CN-TOG (Tongcheng, Anhui Sheng, China)'),
    ('CN-TOH', 'CN-TOH (Tonghe, Heilongjiang Sheng, China)'),
    ('CN-TGH', 'CN-TGH (Tonghua, Jilin Sheng, China)'),
    ('CN-TOJ', 'CN-TOJ (Tongjiang, Heilongjiang Sheng, China)'),
    ('CN-TLS', 'CN-TLS (Tongliao, Liaoning Sheng, China)'),
    ('CN-TGO', 'CN-TGO (Tongliao, Liaoning Sheng, China)'),
    ('CN-TOL', 'CN-TOL (Tongling Pt, Anhui Sheng, China)'),
    ('CN-TON', 'CN-TON (Tonglu, Zhejiang Sheng, China)'),
    ('CN-TGN', 'CN-TGN (Tongren, Guizhou Sheng, China)'),
    ('CN-TEN', 'CN-TEN (Tongren Fenhuang Apt, Qinghai Sheng, China)'),
    ('CN-TXZ', 'CN-TXZ (Tongxiang, Zhejiang Sheng, China)'),
    ('CN-TOX', 'CN-TOX (Tongxing, Anhui Sheng, China)'),
    ('CN-TOZ', 'CN-TOZ (Tongzhao, Zhejiang Sheng, China)'),
    ('CN-TZH', 'CN-TZH (Tongzhao, Zhejiang Sheng, China)'),
    ('CN-TFG', 'CN-TFG (Tuanfeng, Hubei Sheng, China)'),
    ('CN-TME', 'CN-TME (Tumen, Jilin Sheng, China)'),
    ('CN-TJD', 'CN-TJD (Tuojidao, Shandong Sheng, China)'),
    ('CN-TPU', 'CN-TPU (Tuojidao, Shandong Sheng, China)'),
    ('CN-TQO', 'CN-TQO (Tuqiao, Anhui Sheng, China)'),
    ('CN-TRT', 'CN-TRT (Tuqiao, Anhui Sheng, China)'),
    ('CN-CFG', 'CN-CFG (Tuqiao, Anhui Sheng, China)'),
    ('CN-WLH', 'CN-WLH (Tuqiao, Anhui Sheng, China)'),
    ('CN-HLH', 'CN-HLH (Tuqiao, Anhui Sheng, China)'),
    ('CN-ULA', 'CN-ULA (Tuqiao, Anhui Sheng, China)'),
    ('CN-CIF', 'CN-CIF (Tuqiao, Anhui Sheng, China)'),
    ('CN-ULT', 'CN-ULT (Tuqiao, Anhui Sheng, China)'),
    ('CN-URM', 'CN-URM (Tuqiao, Anhui Sheng, China)'),
    ('CN-URC', 'CN-URC (Tuqiao, Anhui Sheng, China)'),
    ('CN-ULZ', 'CN-ULZ (Tuqiao, Anhui Sheng, China)'),
    ('CN-WAF', 'CN-WAF (Wafangdian, Liaoning Sheng, China)'),
    ('CN-WIG', 'CN-WIG (Wafangdian, Liaoning Sheng, China)'),
    ('CN-WGQ', 'CN-WGQ (Wafangdian, Liaoning Sheng, China)'),
    ('CN-WIH', 'CN-WIH (Waihai, Guangdong Sheng, China)'),
    ('CN-WAN', 'CN-WAN (Wanding, Yunnan Sheng, China)'),
    ('CN-WJG', 'CN-WJG (Wangjiang, Anhui Sheng, China)'),
    ('CN-WGI', 'CN-WGI (Wangqi, Jilin Sheng, China)'),
    ('CN-WAJ', 'CN-WAJ (Wanjiang, Guangdong Sheng, China)'),
    ('CN-WLG', 'CN-WLG (Wanling, Hainan Sheng, China)'),
    ('CN-WNG', 'CN-WNG (Wanning, Hainan Sheng, China)'),
    ('CN-WAS', 'CN-WAS (Wanshan Pt, Guangdong Sheng, China)'),
    ('CN-WAX', 'CN-WAX (Wanshan Pt, Guangdong Sheng, China)'),
    ('CN-WAZ', 'CN-WAZ (Wanzai, Guangdong Sheng, China)'),
    ('CN-WZH', 'CN-WZH (Wanzai, Guangdong Sheng, China)'),
    ('CN-WEF', 'CN-WEF (Weifang Pt, Shandong Sheng, China)'),
    ('CN-WEI', 'CN-WEI (Weihai, Shandong Sheng, China)'),
    ('CN-WEH', 'CN-WEH (Weihai Dashuipo Apt, Shandong Sheng, China)'),
    ('CN-WEG', 'CN-WEG (Weihai Pt, Shandong Sheng, China)'),
    ('CN-WNA', 'CN-WNA (Weihai Pt, Shandong Sheng, China)'),
    ('CN-WIT', 'CN-WIT (Weitou, Fujian Sheng, China)'),
    ('CN-WYK', 'CN-WYK (Weiyuankou, Hubei Sheng, China)'),
    ('CN-WEC', 'CN-WEC (Wenchang, Hainan Sheng, China)'),
    ('CN-WNC', 'CN-WNC (Wenchang, Hainan Sheng, China)'),
    ('CN-WDS', 'CN-WDS (Wenchang, Hainan Sheng, China)'),
    ('CN-WYN', 'CN-WYN (Wenchang, Hainan Sheng, China)'),
    ('CN-WJD', 'CN-WJD (Wenjindu, Guangdong Sheng, China)'),
    ('CN-WEN', 'CN-WEN (Wenling, Zhejiang Sheng, China)'),
    ('CN-LMG', 'CN-LMG (Wenling Longmen Port, Zhejiang Sheng, China)'),
    ('CN-WSH', 'CN-WSH (Wenshan, Yunnan Sheng, China)'),
    ('CN-WNZ', 'CN-WNZ (Wenzhou Longwan International Apt, Zhejiang Sheng, China)'),
    ('CN-WZO', 'CN-WZO (Wenzhou Pt, Zhejiang Sheng, China)'),
    ('CN-WUC', 'CN-WUC (Wu Chong Kou, Guangdong Sheng, China)'),
    ('CN-WHU', 'CN-WHU (Wuchuan, Guangdong Sheng, China)'),
    ('CN-WAA', 'CN-WAA (Wuchuan, Guangdong Sheng, China)'),
    ('CN-NHN', 'CN-NHN (Wuhan, Hubei Sheng, China)'),
    ('CN-WHG', 'CN-WHG (Wuhan Pt, Hubei Sheng, China)'),
    ('CN-WUH', 'CN-WUH (Wuhan Tianhe International Apt, Hubei Sheng, China)'),
    ('CN-WHE', 'CN-WHE (Wuhe, Guangdong Sheng, China)'),
    ('CN-WHI', 'CN-WHI (Wuhu Pt, Anhui Sheng, China)'),
    ('CN-WJA', 'CN-WJA (Wujiang, Jiangsu Sheng, China)'),
    ('CN-WUJ', 'CN-WUJ (Wujiang, Anhui Sheng, China)'),
    ('CN-WJI', 'CN-WJI (Wujin, Jiangsu Sheng, China)'),
    ('CN-WJN', 'CN-WJN (Wujin, Hubei Sheng, China)'),
    ('CN-WUK', 'CN-WUK (Wukan, Guangdong Sheng, China)'),
    ('CN-WLI', 'CN-WLI (Wukan, Guangdong Sheng, China)'),
    ('CN-WLD', 'CN-WLD (Wukan, Guangdong Sheng, China)'),
    ('CN-WMG', 'CN-WMG (Wukan, Guangdong Sheng, China)'),
    ('CN-WPG', 'CN-WPG (Wukan, Guangdong Sheng, China)'),
    ('CN-WUQ', 'CN-WUQ (Wukan, Guangdong Sheng, China)'),
    ('CN-WSA', 'CN-WSA (Wusha, Anhui Sheng, China)'),
    ('CN-WUA', 'CN-WUA (Wusha, Guangdong Sheng, China)'),
    ('CN-WSN', 'CN-WSN (Wusha, Guangdong Sheng, China)'),
    ('CN-WUG', 'CN-WUG (Wusha, Guangdong Sheng, China)'),
    ('CN-WXS', 'CN-WXS (Wuxi, Jiangsu Sheng, China)'),
    ('CN-WXI', 'CN-WXI (Wuxian, Jiangsu Sheng, China)'),
    ('CN-WXA', 'CN-WXA (Wuxian, Jiangsu Sheng, China)'),
    ('CN-WXP', 'CN-WXP (Wuxue Pt, Hubei Sheng, China)'),
    ('CN-WYP', 'CN-WYP (Wuyapao, Heilongjiang Sheng, China)'),
    ('CN-WYS', 'CN-WYS (Wuyishan, Fujian Sheng, China)'),
    ('CN-WUS', 'CN-WUS (Wuyishan Apt, Fujian Sheng, China)'),
    ('CN-WUZ', 'CN-WUZ (Wuyishan Apt, Fujian Sheng, China)'),
    ('CN-XDJ', 'CN-XDJ (Xiadaiji, Jilin Sheng, China)'),
    ('CN-XIH', 'CN-XIH (Xiahai, Guangdong Sheng, China)'),
    ('CN-XUA', 'CN-XUA (Xiahua, Guangdong Sheng, China)'),
    ('CN-FQX', 'CN-FQX (Xialong, Fujian Sheng, China)'),
    ('CN-XIM', 'CN-XIM (Xiamao, Guangdong Sheng, China)'),
    ('CN-XAM', 'CN-XAM (Xiamen, Fujian Sheng, China)'),
    ('CN-XMN', 'CN-XMN (Xiamen Gaoqi International Apt, Fujian Sheng, China)'),
    ('CN-XMH', 'CN-XMH (Xiamen Haicang, Fujian Sheng, China)'),
    ('CN-XMG', 'CN-XMG (Xiamen Pt, Fujian Sheng, China)'),
    ('CN-XIA', 'CN-XIA (Xian, Shaanxi Sheng, China)'),
    ('CN-SIA', 'CN-SIA (Xian Xianyang International Apt, Shaanxi Sheng, China)'),
    ('CN-XUG', 'CN-XUG (Xian Xianyang International Apt, Shaanxi Sheng, China)'),
    ('CN-XGF', 'CN-XGF (Xiangfan, Hubei Sheng, China)'),
    ('CN-XGK', 'CN-XGK (Xiangkou, Anhui Sheng, China)'),
    ('CN-XGQ', 'CN-XGQ (Xiangqiao, Guangdong Sheng, China)'),
    ('CN-XSN', 'CN-XSN (Xiangshan, Zhejiang Sheng, China)'),
    ('CN-XSI', 'CN-XSI (Xiangshui, Jiangsu Sheng, China)'),
    ('CN-XTA', 'CN-XTA (Xiangtan, Hunan Sheng, China)'),
    ('CN-XAG', 'CN-XAG (Xianguojilugang, Shaanxi Sheng, China)'),
    ('CN-XIW', 'CN-XIW (Xiangyang, Hubei Sheng, China)'),
    ('CN-XXY', 'CN-XXY (Xiangyu Terminal/ Xiamen, Fujian Sheng, China)'),
    ('CN-XGY', 'CN-XGY (Xiangyun, Yunnan Sheng, China)'),
    ('CN-XZI', 'CN-XZI (Xiangzhi, Fujian Sheng, China)'),
    ('CN-XGZ', 'CN-XGZ (Xiangzhou, Guangdong Sheng, China)'),
    ('CN-XZU', 'CN-XZU (Xiangzhou, Guangdong Sheng, China)'),
    ('CN-XNG', 'CN-XNG (Xianing, Hunan Sheng, China)'),
    ('CN-XJU', 'CN-XJU (Xianing, Hunan Sheng, China)'),
    ('CN-XLA', 'CN-XLA (Xianing, Hunan Sheng, China)'),
    ('CN-XTN', 'CN-XTN (Xiantan, Sichuan Sheng, China)'),
    ('CN-XYA', 'CN-XYA (Xianyang, Shaanxi Sheng, China)'),
    ('CN-XYU', 'CN-XYU (Xianyou, Fujian Sheng, China)'),
    ('CN-XCI', 'CN-XCI (Xiaochi, Hubei Sheng, China)'),
    ('CN-XCU', 'CN-XCU (Xiaocuo Pt, Fujian Sheng, China)'),
    ('CN-XGN', 'CN-XGN (Xiaogan, Hubei Sheng, China)'),
    ('CN-XHO', 'CN-XHO (Xiaohudao, Guangdong Sheng, China)'),
    ('CN-XJB', 'CN-XJB (Xiaojiangba, Anhui Sheng, China)'),
    ('CN-XAO', 'CN-XAO (Xiaolan, Guangdong Sheng, China)'),
    ('CN-XLZ', 'CN-XLZ (Xiaolizhuang, Henan Sheng, China)'),
    ('CN-XIS', 'CN-XIS (Xiaoshan, Zhejiang Sheng, China)'),
    ('CN-XOT', 'CN-XOT (Xiaotang, Guangdong Sheng, China)'),
    ('CN-XTG', 'CN-XTG (Xiaotang, Liaoning Sheng, China)'),
    ('CN-XIO', 'CN-XIO (Xiaoxian, Anhui Sheng, China)'),
    ('CN-XAS', 'CN-XAS (Xiashan, Guangdong Sheng, China)'),
    ('CN-XYN', 'CN-XYN (Xiaying, Shandong Sheng, China)'),
    ('CN-ZXZ', 'CN-ZXZ (Xiazhai, Fujian Sheng, China)'),
    ('CN-XIC', 'CN-XIC (Xichang Qingshan Apt, Sichuan Sheng, China)'),
    ('CN-XCG', 'CN-XCG (Xichong Pt, Guangdong Sheng, China)'),
    ('CN-XTI', 'CN-XTI (Xidi, Guangdong Sheng, China)'),
    ('CN-XEG', 'CN-XEG (Xiegang, Guangdong Sheng, China)'),
    ('CN-XEX', 'CN-XEX (Xiegang, Guangdong Sheng, China)'),
    ('CN-XIG', 'CN-XIG (Xiegang, Guangdong Sheng, China)'),
    ('CN-XIJ', 'CN-XIJ (Xiegang, Guangdong Sheng, China)'),
    ('CN-ILI', 'CN-ILI (Xiegang, Guangdong Sheng, China)'),
    ('CN-XLS', 'CN-XLS (Xiliangshan, Anhui Sheng, China)'),
    ('CN-XHT', 'CN-XHT (Xiliangshan, Anhui Sheng, China)'),
    ('CN-XLU', 'CN-XLU (Xiluzhen, Guangdong Sheng, China)'),
    ('CN-SHX', 'CN-SHX (Xinan, Guangdong Sheng, China)'),
    ('CN-XJG', 'CN-XJG (Xinan, Guangdong Sheng, China)'),
    ('CN-XXI', 'CN-XXI (Xinchang, Zhejiang Sheng, China)'),
    ('CN-XCH', 'CN-XCH (Xincheng, Guangdong Sheng, China)'),
    ('CN-LSX', 'CN-LSX (Xincun, Shandong Sheng, China)'),
    ('CN-XID', 'CN-XID (Xindi, Hubei Sheng, China)'),
    ('CN-XDI', 'CN-XDI (Xindian, Heilongjiang Sheng, China)'),
    ('CN-XDU', 'CN-XDU (Xindian, Heilongjiang Sheng, China)'),
    ('CN-XAB', 'CN-XAB (Xinfeng, Guangdong Sheng, China)'),
    ('CN-XGA', 'CN-XGA (Xingang, Guangdong Sheng, China)'),
    ('CN-XIP', 'CN-XIP (Xingang, Anhui Sheng, China)'),
    ('CN-XCE', 'CN-XCE (Xingcheng, Liaoning Sheng, China)'),
    ('CN-XEN', 'CN-XEN (Xingcheng, Liaoning Sheng, China)'),
    ('CN-XGD', 'CN-XGD (Xingdong, Heilongjiang Sheng, China)'),
    ('CN-XNF', 'CN-XNF (Xingdong, Heilongjiang Sheng, China)'),
    ('CN-XLN', 'CN-XLN (Xingdong, Heilongjiang Sheng, China)'),
    ('CN-XPI', 'CN-XPI (Xingdong, Heilongjiang Sheng, China)'),
    ('CN-XGS', 'CN-XGS (Xingdong, Heilongjiang Sheng, China)'),
    ('CN-XGT', 'CN-XGT (Xingtan, Guangdong Sheng, China)'),
    ('CN-ACX', 'CN-ACX (Xingyi, Yunnan Sheng, China)'),
    ('CN-XHK', 'CN-XHK (Xinhekou, Hubei Sheng, China)'),
    ('CN-XNH', 'CN-XNH (Xinhekou, Hubei Sheng, China)'),
    ('CN-DMX', 'CN-DMX (Xinhuan, Guangdong Sheng, China)'),
    ('CN-XIN', 'CN-XIN (Xinhui Pt, Guangdong Sheng, China)'),
    ('CN-XNT', 'CN-XNT (Xining, Qinghai Sheng, China)'),
    ('CN-XNN', 'CN-XNN (Xining Caojiabao Apt, Qinghai Sheng, China)'),
    ('CN-XNU', 'CN-XNU (Xiniu, Guangdong Sheng, China)'),
    ('CN-XNJ', 'CN-XNJ (Xinji, Hebei Sheng, China)'),
    ('CN-XIK', 'CN-XIK (Xinkai, Hubei Sheng, China)'),
    ('CN-NNI', 'CN-NNI (Xinkai, Hubei Sheng, China)'),
    ('CN-XNQ', 'CN-XNQ (Xinqiao, Guangdong Sheng, China)'),
    ('CN-XNA', 'CN-XNA (Xinsha, Guangdong Sheng, China)'),
    ('CN-XSH', 'CN-XSH (Xinshi, Hubei Sheng, China)'),
    ('CN-XIT', 'CN-XIT (Xintang Pt, Guangdong Sheng, China)'),
    ('CN-XXG', 'CN-XXG (Xinxiang, Henan Sheng, China)'),
    ('CN-XNI', 'CN-XNI (Xinxing, Jiangsu Sheng, China)'),
    ('CN-XNX', 'CN-XNX (Xinxing, Jiangsu Sheng, China)'),
    ('CN-CNX', 'CN-CNX (Xinxu, Guangdong Sheng, China)'),
    ('CN-ING', 'CN-ING (Xinyang, Henan Sheng, China)'),
    ('CN-NYI', 'CN-NYI (Xinyang, Henan Sheng, China)'),
    ('CN-XIY', 'CN-XIY (Xinyang, Henan Sheng, China)'),
    ('CN-XYI', 'CN-XYI (Xinying, Hainan Sheng, China)'),
    ('CN-XNY', 'CN-XNY (Xinyu, Jiangxi Sheng, China)'),
    ('CN-XUN', 'CN-XUN (Xinyu, Jiangxi Sheng, China)'),
    ('CN-XZO', 'CN-XZO (Xinzao, Guangdong Sheng, China)'),
    ('CN-XNZ', 'CN-XNZ (Xinzhou, Hubei Sheng, China)'),
    ('CN-XIQ', 'CN-XIQ (Xiqiao, Guangdong Sheng, China)'),
    ('CN-XSB', 'CN-XSB (Xishuangbanna, Yunnan Sheng, China)'),
    ('CN-JHG', 'CN-JHG (Xishuangbanna Gasa International Apt, Yunnan Sheng, China)'),
    ('CN-XTO', 'CN-XTO (Xitou, Guangdong Sheng, China)'),
    ('CN-XUL', 'CN-XUL (Xiulin, Hubei Sheng, China)'),
    ('CN-XYG', 'CN-XYG (Xiuyu Pt, Fujian Sheng, China)'),
    ('CN-XXN', 'CN-XXN (Xixiang, Shaanxi Sheng, China)'),
    ('CN-UAN', 'CN-UAN (Xixiang, Shaanxi Sheng, China)'),
    ('CN-XUM', 'CN-XUM (Xuanmen, Zhejiang Sheng, China)'),
    ('CN-XWI', 'CN-XWI (Xuanwei, Yunnan Sheng, China)'),
    ('CN-XEO', 'CN-XEO (Xueao, Zhejiang Sheng, China)'),
    ('CN-XJD', 'CN-XJD (Xuejiadao, Shandong Sheng, China)'),
    ('CN-XTZ', 'CN-XTZ (Xuetangzhou, Hubei Sheng, China)'),
    ('CN-XUI', 'CN-XUI (Xuetangzhou, Hubei Sheng, China)'),
    ('CN-XUK', 'CN-XUK (Xunke, Heilongjiang Sheng, China)'),
    ('CN-XZH', 'CN-XZH (Xuzhou, Jiangsu Sheng, China)'),
    ('CN-XUZ', 'CN-XUZ (Xuzhou Guanyin Apt, Jiangsu Sheng, China)'),
    ('CN-YBG', 'CN-YBG (Yabagou, Liaoning Sheng, China)'),
    ('CN-YDZ', 'CN-YDZ (Yabagou, Liaoning Sheng, China)'),
    ('CN-ENY', "CN-ENY (Yan'an Ershilipu Apt, Shaanxi Sheng, China)"),
    ('CN-YBU', 'CN-YBU (Yanbu, Guangdong Sheng, China)'),
    ('CN-YNZ', 'CN-YNZ (Yancheng Nanyang International Apt, Jiangsu Sheng, China)'),
    ('CN-YCN', 'CN-YCN (Yangchun, Guangdong Sheng, China)'),
    ('CN-YJC', 'CN-YJC (Yangjiachang, Hubei Sheng, China)'),
    ('CN-YJI', 'CN-YJI (Yangjiang Pt, Guangdong Sheng, China)'),
    ('CN-YGK', 'CN-YGK (Yangkou, Shandong Sheng, China)'),
    ('CN-YKG', 'CN-YKG (Yangkou Pt, Jiangsu Sheng, China)'),
    ('CN-YLI', 'CN-YLI (Yangli, Guizhou Sheng, China)'),
    ('CN-YMD', 'CN-YMD (Yangmadao, Shandong Sheng, China)'),
    ('CN-YPE', 'CN-YPE (Yangpeng, Anhui Sheng, China)'),
    ('CN-YGP', 'CN-YGP (Yangpeng, Anhui Sheng, China)'),
    ('CN-YPG', 'CN-YPG (Yangpu Pt, Hainan Sheng, China)'),
    ('CN-YSN', 'CN-YSN (Yangshan, Guangdong Sheng, China)'),
    ('CN-YSA', 'CN-YSA (Yangshan Pt, Zhejiang Sheng, China)'),
    ('CN-YSF', 'CN-YSF (Yangshan Pt, Zhejiang Sheng, China)'),
    ('CN-YSO', 'CN-YSO (Yangshan Pt, Zhejiang Sheng, China)'),
    ('CN-YGG', 'CN-YGG (Yanguan, Hunan Sheng, China)'),
    ('CN-YGX', 'CN-YGX (Yangxi, Hubei Sheng, China)'),
    ('CN-YXY', 'CN-YXY (Yangxi, Guangdong Sheng, China)'),
    ('CN-YXT', 'CN-YXT (Yangxifengtou, Guangdong Sheng, China)'),
    ('CN-YNG', 'CN-YNG (Yangzhong, Jiangsu Sheng, China)'),
    ('CN-YZH', 'CN-YZH (Yangzhou Pt, Jiangsu Sheng, China)'),
    ('CN-YNJ', 'CN-YNJ (Yanji Chaoyangchuan Apt, Jilin Sheng, China)'),
    ('CN-YJA', 'CN-YJA (Yanjia, Guizhou Sheng, China)'),
    ('CN-YLG', 'CN-YLG (Yanliang, Shaanxi Sheng, China)'),
    ('CN-YAT', 'CN-YAT (Yantai, Shandong Sheng, China)'),
    ('CN-YNT', 'CN-YNT (Yantai Laishan International Apt, Shandong Sheng, China)'),
    ('CN-YTG', 'CN-YTG (Yantai Pt, Shandong Sheng, China)'),
    ('CN-YTN', 'CN-YTN (Yantian Pt, Guangdong Sheng, China)'),
    ('CN-YHO', 'CN-YHO (Yanzhou, Shandong Sheng, China)'),
    ('CN-YGO', 'CN-YGO (Yaogou, Anhui Sheng, China)'),
    ('CN-YJP', 'CN-YJP (Yaojia Pt, Hubei Sheng, China)'),
    ('CN-YIB', 'CN-YIB (Yibin, Sichuan Sheng, China)'),
    ('CN-YBP', 'CN-YBP (Yibin Caiba Apt, Sichuan Sheng, China)'),
    ('CN-YIC', 'CN-YIC (Yichang, Hubei Sheng, China)'),
    ('CN-YCG', 'CN-YCG (Yichang Pt, Hubei Sheng, China)'),
    ('CN-YIH', 'CN-YIH (Yichang Sanxia Apt, Hubei Sheng, China)'),
    ('CN-YKS', 'CN-YKS (Yichang Sanxia Apt, Hubei Sheng, China)'),
    ('CN-YRK', 'CN-YRK (Yichang Sanxia Apt, Hubei Sheng, China)'),
    ('CN-YLN', 'CN-YLN (Yilan Apt, Heilongjiang Sheng, China)'),
    ('CN-YCH', 'CN-YCH (Yilan Apt, Heilongjiang Sheng, China)'),
    ('CN-INC', 'CN-INC (Yilan Apt, Heilongjiang Sheng, China)'),
    ('CN-YCA', 'CN-YCA (Yingchuan, Jiangsu Sheng, China)'),
    ('CN-YGD', 'CN-YGD (Yingde, Guangdong Sheng, China)'),
    ('CN-YGJ', 'CN-YGJ (Yingjiang, Yunnan Sheng, China)'),
    ('CN-YIK', 'CN-YIK (Yingkou Pt, Liaoning Sheng, China)'),
    ('CN-YGT', 'CN-YGT (Yingtan, Jiangxi Sheng, China)'),
    ('CN-LJY', 'CN-LJY (Yingzai, Guangdong Sheng, China)'),
    ('CN-YIN', 'CN-YIN (Yingzai, Guangdong Sheng, China)'),
    ('CN-YHU', 'CN-YHU (Yishui, Shandong Sheng, China)'),
    ('CN-YIU', 'CN-YIU (Yiwu, Zhejiang Sheng, China)'),
    ('CN-YXA', 'CN-YXA (Yiwu, Zhejiang Sheng, China)'),
    ('CN-YXS', 'CN-YXS (Yixing, Jiangsu Sheng, China)'),
    ('CN-YIG', 'CN-YIG (Yiyang, Hunan Sheng, China)'),
    ('CN-YIZ', 'CN-YIZ (Yizheng, Jiangsu Sheng, China)'),
    ('CN-YZA', 'CN-YZA (Yizheng, Jiangsu Sheng, China)'),
    ('CN-YOX', "CN-YOX (Yong'an, Fujian Sheng, China)"),
    ('CN-YGN', 'CN-YGN (Yongan, Zhejiang Sheng, China)'),
    ('CN-YFU', 'CN-YFU (Yongan, Zhejiang Sheng, China)'),
    ('CN-ONG', 'CN-ONG (Yongan, Zhejiang Sheng, China)'),
    ('CN-YOJ', 'CN-YOJ (Yongan, Zhejiang Sheng, China)'),
    ('CN-YKN', 'CN-YKN (Yongkang, Zhejiang Sheng, China)'),
    ('CN-YLO', 'CN-YLO (Yonglong, Jiangsu Sheng, China)'),
    ('CN-YNN', 'CN-YNN (Yonglong, Jiangsu Sheng, China)'),
    ('CN-YTI', 'CN-YTI (Yongtai, Guangdong Sheng, China)'),
    ('CN-YXU', 'CN-YXU (Yongtai, Guangdong Sheng, China)'),
    ('CN-YZS', 'CN-YZS (Yongzhou, Hunan Sheng, China)'),
    ('CN-YXI', 'CN-YXI (Yongzhou, Hunan Sheng, China)'),
    ('CN-YYG', 'CN-YYG (Yongzhou, Hunan Sheng, China)'),
    ('CN-YUA', 'CN-YUA (Yuanmou Apt, Yunnan Sheng, China)'),
    ('CN-YSH', 'CN-YSH (Yuanshi, Hubei Sheng, China)'),
    ('CN-YUO', 'CN-YUO (Yuanshi, Hubei Sheng, China)'),
    ('CN-YCE', 'CN-YCE (Yucheng, Shandong Sheng, China)'),
    ('CN-YHG', 'CN-YHG (Yuecheng, Guangdong Sheng, China)'),
    ('CN-YLA', 'CN-YLA (Yuelai, Heilongjiang Sheng, China)'),
    ('CN-YPU', 'CN-YPU (Yuepu, Guangdong Sheng, China)'),
    ('CN-YUE', 'CN-YUE (Yueqing, Zhejiang Sheng, China)'),
    ('CN-YXN', 'CN-YXN (Yuexiunan, Guangdong Sheng, China)'),
    ('CN-YYU', 'CN-YYU (Yuexiunan, Guangdong Sheng, China)'),
    ('CN-YYA', 'CN-YYA (Yueyang, Hunan Sheng, China)'),
    ('CN-YHN', 'CN-YHN (Yueyang, Hunan Sheng, China)'),
    ('CN-YUH', 'CN-YUH (Yuhuan, Zhejiang Sheng, China)'),
    ('CN-UYN', 'CN-UYN (Yulin, Hainan Sheng, China)'),
    ('CN-YUL', 'CN-YUL (Yulin, Hainan Sheng, China)'),
    ('CN-YUN', 'CN-YUN (Yuncheng, Shanxi Sheng, China)'),
    ('CN-YUF', 'CN-YUF (Yuncheng, Shanxi Sheng, China)'),
    ('CN-KML', 'CN-KML (Yunnan Tengjun International Land Port Logistics Center, Yunnan Sheng, China)'),
    ('CN-YUI', 'CN-YUI (Yunnan Tengjun International Land Port Logistics Center, Yunnan Sheng, China)'),
    ('CN-YOU', 'CN-YOU (Yuyao, Zhejiang Sheng, China)'),
    ('CN-YYP', 'CN-YYP (Yuyue Pt, Hubei Sheng, China)'),
    ('CN-YUZ', 'CN-YUZ (Yuzhou, Sichuan Sheng, China)'),
    ('CN-YZU', 'CN-YZU (Yuzhu, Guangdong Sheng, China)'),
    ('CN-ZZS', 'CN-ZZS (Zaozhuang, Shandong Sheng, China)'),
    ('CN-ZMU', 'CN-ZMU (Zaozhuang, Shandong Sheng, China)'),
    ('CN-ZGH', 'CN-ZGH (Zhangcha, Shanxi Sheng, China)'),
    ('CN-ZHF', 'CN-ZHF (Zhangfeng, Yunnan Sheng, China)'),
    ('CN-ZAG', 'CN-ZAG (Zhanghu, Anhui Sheng, China)'),
    ('CN-ZJB', 'CN-ZJB (Zhangjiabian, Guangdong Sheng, China)'),
    ('CN-WHZ', 'CN-WHZ (Zhangjiabu, Shandong Sheng, China)'),
    ('CN-ZJG', 'CN-ZJG (Zhangjiagang, Jiangsu Sheng, China)'),
    ('CN-DYG', 'CN-DYG (Zhangjiajie Hehua International Apt, Hunan Sheng, China)'),
    ('CN-ZJK', 'CN-ZJK (Zhangjiakou, Hebei Sheng, China)'),
    ('CN-ZJI', 'CN-ZJI (Zhangjian, Shaanxi Sheng, China)'),
    ('CN-ZGU', 'CN-ZGU (Zhangmutou, Guangdong Sheng, China)'),
    ('CN-ZQH', 'CN-ZQH (Zhangmutou, Guangdong Sheng, China)'),
    ('CN-ZGS', 'CN-ZGS (Zhangshan, Jiangsu Sheng, China)'),
    ('CN-ZHN', 'CN-ZHN (Zhangshan, Jiangsu Sheng, China)'),
    ('CN-ZGW', 'CN-ZGW (Zhangwan, Fujian Sheng, China)'),
    ('CN-ZZU', 'CN-ZZU (Zhangzhou Pt, Fujian Sheng, China)'),
    ('CN-ZHA', 'CN-ZHA (Zhanjiang Potou Apt, Guangdong Sheng, China)'),
    ('CN-ZNG', 'CN-ZNG (Zhanjiang Pt, Guangdong Sheng, China)'),
    ('CN-ZDO', 'CN-ZDO (Zhaodong, Heilongjiang Sheng, China)'),
    ('CN-ZHG', 'CN-ZHG (Zhaogang, Anhui Sheng, China)'),
    ('CN-ZPI', 'CN-ZPI (Zhaoping, Guangdong Sheng, China)'),
    ('CN-ZQG', 'CN-ZQG (Zhaoqing Pt, Guangdong Sheng, China)'),
    ('CN-ZQN', 'CN-ZQN (Zhaoqing Railway Station, Guangdong Sheng, China)'),
    ('CN-ZAT', 'CN-ZAT (Zhaotong Apt, Yunnan Sheng, China)'),
    ('CN-ZHY', 'CN-ZHY (Zhaoyuan, Heilongjiang Sheng, China)'),
    ('CN-ZYU', 'CN-ZYU (Zhaoyuan, Heilongjiang Sheng, China)'),
    ('CN-ZPO', 'CN-ZPO (Zhapo, Guangdong Sheng, China)'),
    ('CN-ZPK', 'CN-ZPK (Zhapoyouku, Guangdong Sheng, China)'),
    ('CN-ZPU', 'CN-ZPU (Zhapu Pt, Zhejiang Sheng, China)'),
    ('CN-ZEL', 'CN-ZEL (Zhelin, Guangdong Sheng, China)'),
    ('CN-ZJN', 'CN-ZJN (Zhengjiatun, Jilin Sheng, China)'),
    ('CN-ZPG', 'CN-ZPG (zhengpugang Pt, Anhui Sheng, China)'),
    ('CN-ZGZ', 'CN-ZGZ (Zhengzhou, Henan Sheng, China)'),
    ('CN-CGO', 'CN-CGO (Zhengzhou Xinzheng International Apt, Henan Sheng, China)'),
    ('CN-ZZZ', 'CN-ZZZ (Zhengzhoudong Railway Station, Henan Sheng, China)'),
    ('CN-ZHI', 'CN-ZHI (Zhenhai Pt, Zhejiang Sheng, China)'),
    ('CN-ZHE', 'CN-ZHE (Zhenjiang Pt, Jiangsu Sheng, China)'),
    ('CN-ZOU', 'CN-ZOU (Zhenjiang Pt, Jiangsu Sheng, China)'),
    ('CN-ZXI', 'CN-ZXI (Zhexiang, Guizhou Sheng, China)'),
    ('CN-ZCG', 'CN-ZCG (Zhicheng, Hubei Sheng, China)'),
    ('CN-ZHC', 'CN-ZHC (Zhongcun, Shaanxi Sheng, China)'),
    ('CN-ZGC', 'CN-ZGC (Zhongcun, Shaanxi Sheng, China)'),
    ('CN-ZLN', 'CN-ZLN (Zhongluotan, Guangdong Sheng, China)'),
    ('CN-ZGA', 'CN-ZGA (Zhongluotan, Guangdong Sheng, China)'),
    ('CN-ZSN', 'CN-ZSN (Zhongshan Pt, Guangdong Sheng, China)'),
    ('CN-ZGT', 'CN-ZGT (Zhongtang, Guangdong Sheng, China)'),
    ('CN-ZXN', 'CN-ZXN (Zhongtang, Guangdong Sheng, China)'),
    ('CN-ZXG', 'CN-ZXG (Zhongxiang, Hubei Sheng, China)'),
    ('CN-ZKO', 'CN-ZKO (Zhoukou, Henan Sheng, China)'),
    ('CN-ZQJ', 'CN-ZQJ (Zhouqujia, Anhui Sheng, China)'),
    ('CN-ZOS', 'CN-ZOS (Zhoushan Pt, Zhejiang Sheng, China)'),
    ('CN-ZTZ', 'CN-ZTZ (Zhoutuozi, Liaoning Sheng, China)'),
    ('CN-ZZG', 'CN-ZZG (Zhouzhuang, Jiangsu Sheng, China)'),
    ('CN-ZHH', 'CN-ZHH (Zhuanghe Pt, Liaoning Sheng, China)'),
    ('CN-ZYO', 'CN-ZYO (Zhuangyuanao, Zhejiang Sheng, China)'),
    ('CN-ZHQ', 'CN-ZHQ (Zhuangyuanao, Zhejiang Sheng, China)'),
    ('CN-ZHU', 'CN-ZHU (Zhuao, Guangdong Sheng, China)'),
    ('CN-ZCH', 'CN-ZCH (Zhucheng, Shandong Sheng, China)'),
    ('CN-ZEQ', 'CN-ZEQ (Zhucheng, Shandong Sheng, China)'),
    ('CN-ZUH', 'CN-ZUH (Zhuhai Pt, Guangdong Sheng, China)'),
    ('CN-ZHJ', 'CN-ZHJ (Zhuji, Zhejiang Sheng, China)'),
    ('CN-ZLO', 'CN-ZLO (Zhuliao, Guangdong Sheng, China)'),
    ('CN-ZHZ', 'CN-ZHZ (Zhuozhou, Hebei Sheng, China)'),
    ('CN-ZUS', 'CN-ZUS (Zhuozhou, Hebei Sheng, China)'),
    ('CN-ZUT', 'CN-ZUT (Zhuozhou, Hebei Sheng, China)'),
    ('CN-ZUY', 'CN-ZUY (Zhuozhou, Hebei Sheng, China)'),
    ('CN-ZZO', 'CN-ZZO (Zhuzhou, Hunan Sheng, China)'),
    ('CN-ZBO', 'CN-ZBO (Zibo, Shandong Sheng, China)'),
    ('CN-ZCU', 'CN-ZCU (Zibo, Shandong Sheng, China)'),
    ('CN-ZGO', 'CN-ZGO (Zigong, Sichuan Sheng, China)'),
    ('CN-ZIY', 'CN-ZIY (Zigong, Sichuan Sheng, China)'),
    ('CN-ZYG', 'CN-ZYG (Zongyang, Anhui Sheng, China)'),
    ('CN-ZOC', 'CN-ZOC (Zoucheng, Shandong Sheng, China)'),
    ('CN-ZXJ', 'CN-ZXJ (Zoucheng, Shandong Sheng, China)'),
    ('CN-ZNY', 'CN-ZNY (Zunyi, Guizhou Sheng, China)'),
    ('CN-ZYI', 'CN-ZYI (Zunyi Xinzhou Apt, Guizhou Sheng, China)'),
    ('CO-AAS', 'CO-AAS (Acacías, Colombia)'),
    ('CO-ACD', 'CO-ACD (Acandi, Colombia)'),
    ('CO-ARF', 'CO-ARF (Acaricuara, Colombia)'),
    ('CO-AGD', 'CO-AGD (Agrado, Colombia)'),
    ('CO-AGC', 'CO-AGC (Aguachica, Colombia)'),
    ('CO-ACL', 'CO-ACL (Aguaclara, Colombia)'),
    ('CO-AGU', 'CO-AGU (Aguadas, Colombia)'),
    ('CO-ABL', 'CO-ABL (Aguasblancas, Colombia)'),
    ('CO-AFI', 'CO-AFI (Amalfi, Colombia)'),
    ('CO-AND', 'CO-AND (Andalucia, Colombia)'),
    ('CO-ADN', 'CO-ADN (Andes, Colombia)'),
    ('CO-AQA', 'CO-AQA (Antioquia, Colombia)'),
    ('CO-APO', 'CO-APO (Apartado, Colombia)'),
    ('CO-LAP', 'CO-LAP (Apartadó, Colombia)'),
    ('CO-API', 'CO-API (Apiay, Colombia)'),
    ('CO-ARA', 'CO-ARA (Aracataca, Colombia)'),
    ('CO-ACR', 'CO-ACR (Araracuara, Colombia)'),
    ('CO-AUC', 'CO-AUC (Arauca, Colombia)'),
    ('CO-ARQ', 'CO-ARQ (Arauquita, Colombia)'),
    ('CO-ARO', 'CO-ARO (Arboletas, Colombia)'),
    ('CO-ARE', 'CO-ARE (Arenal, Colombia)'),
    ('CO-ACM', 'CO-ACM (Arica, Colombia)'),
    ('CO-ARI', 'CO-ARI (Ariguani, Colombia)'),
    ('CO-ARJ', 'CO-ARJ (Arjona, Colombia)'),
    ('CO-AXM', 'CO-AXM (Armenia, Colombia)'),
    ('CO-ASR', 'CO-ASR (Astrea, Colombia)'),
    ('CO-AYC', 'CO-AYC (Ayacucho, Colombia)'),
    ('CO-AYA', 'CO-AYA (Ayapel, Colombia)'),
    ('CO-BSC', 'CO-BSC (Bahia Solano, Colombia)'),
    ('CO-BHF', 'CO-BHF (Bahía Cupica, Colombia)'),
    ('CO-BAL', 'CO-BAL (Balboa, Colombia)'),
    ('CO-BAR', 'CO-BAR (Baranoa, Colombia)'),
    ('CO-BAA', 'CO-BAA (Barbosa, Colombia)'),
    ('CO-BAC', 'CO-BAC (Barranca de Upia, Colombia)'),
    ('CO-EJA', 'CO-EJA (Barrancabermeja, Colombia)'),
    ('CO-BRR', 'CO-BRR (Barrancas, Colombia)'),
    ('CO-NBB', 'CO-NBB (Barrancominas, Colombia)'),
    ('CO-BAQ', 'CO-BAQ (Barranquilla, Colombia)'),
    ('CO-BAY', 'CO-BAY (Bayunca, Colombia)'),
    ('CO-BEC', 'CO-BEC (Becerril, Colombia)'),
    ('CO-BLO', 'CO-BLO (Bello, Colombia)'),
    ('CO-BER', 'CO-BER (Berrugas, Colombia)'),
    ('CO-BET', 'CO-BET (Betania, Colombia)'),
    ('CO-BCC', 'CO-BCC (Boca Chica, Colombia)'),
    ('CO-BOG', 'CO-BOG (Bogotá, Colombia)'),
    ('CO-BOS', 'CO-BOS (Bosconia, Colombia)'),
    ('CO-BGA', 'CO-BGA (Bucaramanga, Colombia)'),
    ('CO-BUE', 'CO-BUE (Buena Vista, Colombia)'),
    ('CO-BUN', 'CO-BUN (Buenaventura, Colombia)'),
    ('CO-BUG', 'CO-BUG (Buga, Colombia)'),
    ('CO-CAP', 'CO-CAP (Cachipay, Colombia)'),
    ('CO-CAJ', 'CO-CAJ (Cajica, Colombia)'),
    ('CO-CAL', 'CO-CAL (Calamar, Colombia)'),
    ('CO-CLO', 'CO-CLO (Cali, Colombia)'),
    ('CO-N6A', 'CO-N6A (California, Colombia)'),
    ('CO-XCO', 'CO-XCO (Caloto, Colombia)'),
    ('CO-CAM', 'CO-CAM (Camarones, Colombia)'),
    ('CO-CLC', 'CO-CLC (Campo de La Cruz, Colombia)'),
    ('CO-CAN', 'CO-CAN (Candelaria, Colombia)'),
    ('CO-CJD', 'CO-CJD (Candilejas, Colombia)'),
    ('CO-CPB', 'CO-CPB (Capurgana, Colombia)'),
    ('CO-CQT', 'CO-CQT (Caquetania, Colombia)'),
    ('CO-CCO', 'CO-CCO (Carimagua, Colombia)'),
    ('CO-CTG', 'CO-CTG (Cartagena, Colombia)'),
    ('CO-CRC', 'CO-CRC (Cartago, Colombia)'),
    ('CO-CUO', 'CO-CUO (Caruru, Colombia)'),
    ('CO-CAS', 'CO-CAS (Casacará, Colombia)'),
    ('CO-CSR', 'CO-CSR (Casuarito, Colombia)'),
    ('CO-CAU', 'CO-CAU (Cauca, Colombia)'),
    ('CO-CAQ', 'CO-CAQ (Caucasia, Colombia)'),
    ('CO-CCA', 'CO-CCA (Centro Alegre, Colombia)'),
    ('CO-CER', 'CO-CER (Cereté, Colombia)'),
    ('CO-CPL', 'CO-CPL (Chaparral, Colombia)'),
    ('CO-CHI', 'CO-CHI (Chia, Colombia)'),
    ('CO-IGO', 'CO-IGO (Chigorodó, Colombia)'),
    ('CO-CHG', 'CO-CHG (Chimichagua, Colombia)'),
    ('CO-NNA', 'CO-NNA (Chinchina, Colombia)'),
    ('CO-CHU', 'CO-CHU (Chinú, Colombia)'),
    ('CO-CHQ', 'CO-CHQ (Chiquinquirá, Colombia)'),
    ('CO-CHN', 'CO-CHN (Chiriguaná, Colombia)'),
    ('CO-IVO', 'CO-IVO (Chivolo, Colombia)'),
    ('CO-CIE', 'CO-CIE (Cienaga, Colombia)'),
    ('CO-CIM', 'CO-CIM (Cimitarra, Colombia)'),
    ('CO-CDO', 'CO-CDO (Ciénaga de Oro, Colombia)'),
    ('CO-DZI', 'CO-DZI (Codazzi, Colombia)'),
    ('CO-CGA', 'CO-CGA (Cogua, Colombia)'),
    ('CO-COL', 'CO-COL (Colomboy, Colombia)'),
    ('CO-COG', 'CO-COG (Condoto, Colombia)'),
    ('CO-CNR', 'CO-CNR (Contecar, Colombia)'),
    ('CO-CZU', 'CO-CZU (Corozal, Colombia)'),
    ('CO-COT', 'CO-COT (Cota, Colombia)'),
    ('CO-COR', 'CO-COR (Cotorra, Colombia)'),
    ('CO-COV', 'CO-COV (Covenas Offshore Terminal, Colombia)'),
    ('CO-CVE', 'CO-CVE (Coveñas, Colombia)'),
    ('CO-RAV', 'CO-RAV (Cravo Norte, Colombia)'),
    ('CO-CUC', 'CO-CUC (Cucuta, Colombia)'),
    ('CO-CUI', 'CO-CUI (Currillo, Colombia)'),
    ('CO-CUR', 'CO-CUR (Curumaní, Colombia)'),
    ('CO-DAB', 'CO-DAB (Dabeiba, Colombia)'),
    ('CO-DQS', 'CO-DQS (Dos Quebradas, Colombia)'),
    ('CO-DUE', 'CO-DUE (Duitama, Colombia)'),
    ('CO-DUR', 'CO-DUR (Durania, Colombia)'),
    ('CO-EBG', 'CO-EBG (El Bagre, Colombia)'),
    ('CO-ELB', 'CO-ELB (El Banco, Colombia)'),
    ('CO-EBQ', 'CO-EBQ (El Bosque, Colombia)'),
    ('CO-ECB', 'CO-ECB (El Carmen de Bolívar, Colombia)'),
    ('CO-ECR', 'CO-ECR (El Charco, Colombia)'),
    ('CO-ECO', 'CO-ECO (El Encanto, Colombia)'),
    ('CO-EES', 'CO-EES (El Espino, Colombia)'),
    ('CO-ELP', 'CO-ELP (El Paso, Colombia)'),
    ('CO-EPI', 'CO-EPI (El Penón, Colombia)'),
    ('CO-PBD', 'CO-PBD (El Poblado, Colombia)'),
    ('CO-ELJ', 'CO-ELJ (El Recréo, Colombia)'),
    ('CO-ESN', 'CO-ESN (El Santuario, Colombia)'),
    ('CO-EYP', 'CO-EYP (El Yopal, Colombia)'),
    ('CO-ENV', 'CO-ENV (Envigado, Colombia)'),
    ('CO-TOL', 'CO-TOL (Espinal, Colombia)'),
    ('CO-9FC', 'CO-9FC (Facatativa, Colombia)'),
    ('CO-FLA', 'CO-FLA (Florencia, Colombia)'),
    ('CO-FLC', 'CO-FLC (Floridablanca, Colombia)'),
    ('CO-FON', 'CO-FON (Fonseca, Colombia)'),
    ('CO-FUN', 'CO-FUN (Fundacion, Colombia)'),
    ('CO-FZA', 'CO-FZA (Funza, Colombia)'),
    ('CO-GLP', 'CO-GLP (Galapa, Colombia)'),
    ('CO-GRL', 'CO-GRL (Galeras, Colombia)'),
    ('CO-GAL', 'CO-GAL (Galicia, Colombia)'),
    ('CO-GAM', 'CO-GAM (Gamarra, Colombia)'),
    ('CO-GRA', 'CO-GRA (Gamarra, Colombia)'),
    ('CO-GAR', 'CO-GAR (Garagoa, Colombia)'),
    ('CO-GAZ', 'CO-GAZ (Garzon, Colombia)'),
    ('CO-GGL', 'CO-GGL (Gilgal, Colombia)'),
    ('CO-GIR', 'CO-GIR (Girardot, Colombia)'),
    ('CO-GIN', 'CO-GIN (Girón, Colombia)'),
    ('CO-GRD', 'CO-GRD (Granada, Colombia)'),
    ('CO-GCA', 'CO-GCA (Guacamaya, Colombia)'),
    ('CO-GHN', 'CO-GHN (Guachene, Colombia)'),
    ('CO-GUA', 'CO-GUA (Guaduas, Colombia)'),
    ('CO-GAA', 'CO-GAA (Guamal, Colombia)'),
    ('CO-GPI', 'CO-GPI (Guapi, Colombia)'),
    ('CO-GUP', 'CO-GUP (Guapi, Colombia)'),
    ('CO-GST', 'CO-GST (Guaranao, Colombia)'),
    ('CO-GUD', 'CO-GUD (Guaranda, Colombia)'),
    ('CO-GMC', 'CO-GMC (Guerima, Colombia)'),
    ('CO-HTZ', 'CO-HTZ (Hato Corozal, Colombia)'),
    ('CO-HAT', 'CO-HAT (Hato Nuevo, Colombia)'),
    ('CO-HRR', 'CO-HRR (Herrera, Colombia)'),
    ('CO-IBE', 'CO-IBE (Ibaque, Colombia)'),
    ('CO-PDA', 'CO-PDA (Inírida, Colombia)'),
    ('CO-IPI', 'CO-IPI (Ipiales, Colombia)'),
    ('CO-ISD', 'CO-ISD (Iscuande, Colombia)'),
    ('CO-ITG', 'CO-ITG (Itagui, Colombia)'),
    ('CO-JER', 'CO-JER (Jericó, Colombia)'),
    ('CO-JDA', 'CO-JDA (Juan de Acosta, Colombia)'),
    ('CO-JUO', 'CO-JUO (Jurado, Colombia)'),
    ('CO-APA', 'CO-APA (La Apartada, Colombia)'),
    ('CO-LAU', 'CO-LAU (La Aurora, Colombia)'),
    ('CO-LCR', 'CO-LCR (La Chorrera, Colombia)'),
    ('CO-LAD', 'CO-LAD (La Dorada, Colombia)'),
    ('CO-LAA', 'CO-LAA (La Estrella, Colombia)'),
    ('CO-LJG', 'CO-LJG (La Jagua de Ibirico, Colombia)'),
    ('CO-LLO', 'CO-LLO (La Loma, Colombia)'),
    ('CO-LPD', 'CO-LPD (La Pedrera, Colombia)'),
    ('CO-LPE', 'CO-LPE (La Primavera, Colombia)'),
    ('CO-LAT', 'CO-LAT (La Uribe, Colombia)'),
    ('CO-LMC', 'CO-LMC (Lamacarena, Colombia)'),
    ('CO-LGT', 'CO-LGT (Las Gaviotas, Colombia)'),
    ('CO-LPS', 'CO-LPS (Las Palomas, Colombia)'),
    ('CO-LEB', 'CO-LEB (Lebrija, Colombia)'),
    ('CO-LEJ', 'CO-LEJ (Lejanias, Colombia)'),
    ('CO-LET', 'CO-LET (Leticia, Colombia)'),
    ('CO-LMX', 'CO-LMX (Lopez de Micay Apt/Micay, Colombia)'),
    ('CO-LRI', 'CO-LRI (Lorica, Colombia)'),
    ('CO-LCO', 'CO-LCO (Los Córdobas, Colombia)'),
    ('CO-NAD', 'CO-NAD (Macanal, Colombia)'),
    ('CO-MAC', 'CO-MAC (Macedonia, Colombia)'),
    ('CO-MDD', 'CO-MDD (Madrid, Colombia)'),
    ('CO-MGN', 'CO-MGN (Magangue, Colombia)'),
    ('CO-MCJ', 'CO-MCJ (Maicao, Colombia)'),
    ('CO-MAJ', 'CO-MAJ (Majagual, Colombia)'),
    ('CO-MAL', 'CO-MAL (Malambo, Colombia)'),
    ('CO-MAM', 'CO-MAM (Mamonal, Colombia)'),
    ('CO-MAU', 'CO-MAU (Manaure, Colombia)'),
    ('CO-MZL', 'CO-MZL (Manizales, Colombia)'),
    ('CO-MBA', 'CO-MBA (Maria La Baja, Colombia)'),
    ('CO-MRA', 'CO-MRA (Marinilla, Colombia)'),
    ('CO-MQU', 'CO-MQU (Mariquita, Colombia)'),
    ('CO-MAT', 'CO-MAT (Matanza, Colombia)'),
    ('CO-MDE', 'CO-MDE (Medellín, Colombia)'),
    ('CO-MND', 'CO-MND (Medina, Colombia)'),
    ('CO-MFS', 'CO-MFS (Miraflores, Colombia)'),
    ('CO-MIX', 'CO-MIX (Miriti, Colombia)'),
    ('CO-MVP', 'CO-MVP (Mitu, Colombia)'),
    ('CO-MMP', 'CO-MMP (Mompos, Colombia)'),
    ('CO-MFB', 'CO-MFB (Monfort, Colombia)'),
    ('CO-TUE', 'CO-TUE (Moniquira, Colombia)'),
    ('CO-MOL', 'CO-MOL (Monte Libano, Colombia)'),
    ('CO-MTB', 'CO-MTB (Montelíbano, Colombia)'),
    ('CO-MTR', 'CO-MTR (Monteria, Colombia)'),
    ('CO-MOY', 'CO-MOY (Monterrey, Colombia)'),
    ('CO-MHF', 'CO-MHF (Morichal, Colombia)'),
    ('CO-MQR', 'CO-MQR (Mosquera, Colombia)'),
    ('CO-ULS', 'CO-ULS (Mulatos, Colombia)'),
    ('CO-NAR', 'CO-NAR (Nare, Colombia)'),
    ('CO-NCI', 'CO-NCI (Necocli, Colombia)'),
    ('CO-NVA', 'CO-NVA (Neiva, Colombia)'),
    ('CO-NOB', 'CO-NOB (Nobsa, Colombia)'),
    ('CO-NUH', 'CO-NUH (Nunchia, Colombia)'),
    ('CO-NQU', 'CO-NQU (Nuqui, Colombia)'),
    ('CO-OCV', 'CO-OCV (Ocana, Colombia)'),
    ('CO-OIB', 'CO-OIB (Oiba, Colombia)'),
    ('CO-ORE', 'CO-ORE (Orejero, Colombia)'),
    ('CO-ORC', 'CO-ORC (Orocue, Colombia)'),
    ('CO-OTU', 'CO-OTU (Otu, Colombia)'),
    ('CO-OVE', 'CO-OVE (Ovejas, Colombia)'),
    ('CO-PAI', 'CO-PAI (Pailitas, Colombia)'),
    ('CO-PAL', 'CO-PAL (Palanquero, Colombia)'),
    ('CO-QPI', 'CO-QPI (Palmira, Colombia)'),
    ('CO-PDG', 'CO-PDG (Palo de Agua, Colombia)'),
    ('CO-EUO', 'CO-EUO (Paratebueno, Colombia)'),
    ('CO-PSO', 'CO-PSO (Pasto, Colombia)'),
    ('CO-PYN', 'CO-PYN (Payan, Colombia)'),
    ('CO-PZA', 'CO-PZA (Paz de Ariporo, Colombia)'),
    ('CO-PEL', 'CO-PEL (Pelaya, Colombia)'),
    ('CO-PEI', 'CO-PEI (Pereira, Colombia)'),
    ('CO-PIE', 'CO-PIE (Piedecuesta, Colombia)'),
    ('CO-PTX', 'CO-PTX (Pitalito, Colombia)'),
    ('CO-PIV', 'CO-PIV (Pivijay, Colombia)'),
    ('CO-PLA', 'CO-PLA (Planadas, Colombia)'),
    ('CO-PLC', 'CO-PLC (Planeta Rica, Colombia)'),
    ('CO-PLT', 'CO-PLT (Plato, Colombia)'),
    ('CO-PON', 'CO-PON (Ponedera, Colombia)'),
    ('CO-PPN', 'CO-PPN (Popayán, Colombia)'),
    ('CO-PRE', 'CO-PRE (Pore, Colombia)'),
    ('CO-POC', 'CO-POC (Pozos Colorados, Colombia)'),
    ('CO-PVA', 'CO-PVA (Providencia, Colombia)'),
    ('CO-PBL', 'CO-PBL (Pueblo Bello, Colombia)'),
    ('CO-PNU', 'CO-PNU (Pueblo Nuevo, Colombia)'),
    ('CO-PCA', 'CO-PCA (Puente Canoas, Colombia)'