from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('dcim', '0002_squashed'),
        ('extras', '0001_squashed'),
        ('virtualization', '0001_squashed_0022'),
        ('tenancy', '0001_squashed_0012'),
    ]

    replaces = [
        ('extras', '0002_custom_fields'),
        ('extras', '0003_exporttemplate_add_description'),
        ('extras', '0004_topologymap_change_comma_to_semicolon'),
        ('extras', '0005_useraction_add_bulk_create'),
        ('extras', '0006_add_imageattachments'),
        ('extras', '0007_unicode_literals'),
        ('extras', '0008_reports'),
        ('extras', '0009_topologymap_type'),
        ('extras', '0010_customfield_filter_logic'),
        ('extras', '0011_django2'),
        ('extras', '0012_webhooks'),
        ('extras', '0013_objectchange'),
        ('extras', '0014_configcontexts'),
        ('extras', '0015_remove_useraction'),
        ('extras', '0016_exporttemplate_add_cable'),
        ('extras', '0017_exporttemplate_mime_type_length'),
        ('extras', '0018_exporttemplate_add_jinja2'),
        ('extras', '0019_tag_taggeditem'),
        ('extras', '0020_tag_data'),
        ('extras', '0021_add_color_comments_changelog_to_tag'),
        ('extras', '0022_custom_links'),
        ('extras', '0023_fix_tag_sequences'),
        ('extras', '0024_scripts'),
        ('extras', '0025_objectchange_time_index'),
        ('extras', '0026_webhook_ca_file_path'),
        ('extras', '0027_webhook_additional_headers'),
        ('extras', '0028_remove_topology_maps'),
        ('extras', '0029_3569_customfield_fields'),
        ('extras', '0030_3569_objectchange_fields'),
        ('extras', '0031_3569_exporttemplate_fields'),
        ('extras', '0032_3569_webhook_fields'),
        ('extras', '0033_graph_type_template_language'),
        ('extras', '0034_configcontext_tags'),
        ('extras', '0035_deterministic_ordering'),
        ('extras', '0036_contenttype_filters_to_q_objects'),
        ('extras', '0037_configcontexts_clusters'),
        ('extras', '0038_webhook_template_support'),
        ('extras', '0039_update_features_content_types'),
        ('extras', '0040_standardize_description'),
        ('extras', '0041_tag_description'),
        ('extras', '0042_customfield_manager'),
        ('extras', '0043_report'),
        ('extras', '0044_jobresult'),
        ('extras', '0045_configcontext_changelog'),
        ('extras', '0046_update_jsonfield'),
        ('extras', '0047_tag_ordering'),
        ('extras', '0048_exporttemplate_remove_template_language'),
        ('extras', '0049_remove_graph'),
        ('extras', '0050_customfield_changes'),
        ('extras', '0051_migrate_customfields'),
        ('extras', '0052_customfield_cleanup'),
        ('extras', '0053_rename_webhook_obj_type'),
        ('extras', '0054_standardize_models'),
        ('extras', '0055_objectchange_data'),
        ('extras', '0056_extend_configcontext'),
        ('extras', '0057_customlink_rename_fields'),
        ('extras', '0058_journalentry'),
        ('extras', '0059_exporttemplate_as_attachment'),
    ]

    operations = [
        migrations.AddField(
            model_name='configcontext',
            name='cluster_groups',
            field=models.ManyToManyField(blank=True, related_name='+', to='virtualization.ClusterGroup'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='clusters',
            field=models.ManyToManyField(blank=True, related_name='+', to='virtualization.Cluster'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='device_types',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.DeviceType'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='platforms',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.Platform'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='regions',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.Region'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='roles',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.DeviceRole'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='site_groups',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.SiteGroup'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='sites',
            field=models.ManyToManyField(blank=True, related_name='+', to='dcim.Site'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='tags',
            field=models.ManyToManyField(blank=True, related_name='+', to='extras.Tag'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='tenant_groups',
            field=models.ManyToManyField(blank=True, related_name='+', to='tenancy.TenantGroup'),
        ),
        migrations.AddField(
            model_name='configcontext',
            name='tenants',
            field=models.ManyToManyField(blank=True, related_name='+', to='tenancy.Tenant'),
        ),
        migrations.AlterUniqueTogether(
            name='webhook',
            unique_together={('payload_url', 'type_create', 'type_update', 'type_delete')},
        ),
        migrations.AlterUniqueTogether(
            name='exporttemplate',
            unique_together={('content_type', 'name')},
        ),
    ]
