#ifndef _TOKENIZER_H_INCLUDED_
#define _TOKENIZER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Tokenizer.h
// -----------
// Tokenizer class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: Tokenizer
// 
// Description: Splitting a string into tokens
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

#include "Chain.h"

// CLASS DEFINITION

class Tokenizer {

 public:
    
    Tokenizer(const Chain& tokenStream, const Chain& sep, char esc = '\\');
    Tokenizer(char* buf, unsigned long len, const Chain& sep, char esc = '\\');
    ~Tokenizer();
    
    bool nextToken(Chain& token);
    bool getTail(Chain& token);

    void skip(unsigned long n);
    bool rawRead(Chain& token, unsigned long n);
    
    unsigned long numAhead() const;    

    void reset();
    void reset(char* buf, unsigned long len);

    Tokenizer& operator = (const Tokenizer& t);
 
 private:

    bool checkSeparator();

    bool _isLocal;
    char *_streamBuf;
    unsigned long _bufLen;
    
    Chain _tokenStream;
    Chain _sep;
    char _esc;

    unsigned long _lower;
    unsigned long _upper;
};
#endif



