#ifndef _THREAD_H_INCLUDED_
#define _THREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Thread.h
// --------
// Thread class interface definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: Thread
// 
// Description: All operations on POSIX threads
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

class Thread 
{
    
public:

    Thread();
    virtual ~Thread() = 0;
    
    unsigned long long start(void *arg);
    void join(unsigned long long tid);
    void cancel();
    
    void P();
    void V();
    
    unsigned long long getTid() { return _tid; };

protected:
    
    virtual void* job(void *arg) = 0;
    
    void *getArg() { return _arg; }

private:
    
    static void* task(void *pThis);

    unsigned long long _tid;    
    void *_arg;
};
#endif
