#ifndef _NET_H_INCLUDED_
#define _NET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Net.h
// -----
// Base network driver
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// INTERFACE MODULE
//
// Class: Net
// 
// Description: All operations on network resources (IPv4)
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "Chain.h"
#include "ListT.h"
#include "NetHandler.h"

class NetHandler;

class Net {

public:
    
    Net(unsigned initMsgBufLen, unsigned sizeBufLen, unsigned maxSendLen);
    ~Net();
    
    NetHandler* connect(const Chain& hostname, const Chain& service);
    NetHandler* connect(const Chain& hostname, const Chain& service, unsigned timeout);
    void serve(unsigned port);
    void serve6(unsigned port);
    void serve(const Chain& hostname, const Chain& service);
    
    NetHandler* nextRequest(unsigned timeout);
    void removeHandle(NetHandler *pN);
    
private:
	
    unsigned _initMsgBufLen;
    unsigned _sizeBufLen;
    unsigned _maxSendLen;
   
    int _csock;
};

#endif
