#ifndef _LOGGER_H_INCLUDED_
#define _LOGGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Logger.h
// --------
// Managing log messages 
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Logger
// 
// Description: Managing module notices and debug messages
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Chain.h"
#include "File.h"
#include "SetT.h"

class Logger {

public:
    
    enum LogLevel { NONE, LOGALERT, LOGERR, NOTICE, DEBUG };
    
    Logger();
    Logger(const Chain& logFile, const Chain& progName);
    ~Logger();

    void logModule(unsigned long modId, const Chain& module, LogLevel level);
    
    void log(unsigned long modId, LogLevel level, const Chain& msg);

    Logger& operator << ( const LogLevel& level);
    Logger& operator << ( const Chain& str);
    Logger& operator << ( const char* str);
    Logger& operator << ( unsigned long modId);
    
private:

    class ModEntry {
	
    public:
	
	ModEntry()
	{
	}
	
	ModEntry(unsigned long modId)
	{
	    _modId = modId;
	}

	ModEntry(unsigned long modId, const Chain& module, LogLevel level)
	{
	    _modId = modId;
	    _module = module;
	    _level = level;
	}

	LogLevel getLogLevel()
	{
	    return _level;
	}
	
	void setLevel(LogLevel level)
	{
	    _level = level;
	}
	
	const Chain& getModule()
	{
	    return _module;
	}

	void setModule(const Chain& module)
	{
	    _module = module;
	}
	
	bool operator == (const ModEntry& me)
	{
	    if ( _modId == me._modId )
		return true;
	    return false;
	}

	ModEntry& operator = (const ModEntry& me)
	{
	    _modId = me._modId;
	    _module = me._module;
	    _level = me._level;
	    return (*this);
	}

	
    private:

	unsigned long _modId;
	Chain _module;
	LogLevel _level;
    };

    LogLevel _logLevel;
    LogLevel _msgLevel;
    unsigned long _modId;
    SetT<ModEntry> _modSet;
    
    File* _pF;

#ifndef DISABLE_SYSLOG
    bool _writeSysLog;
#endif
    
};



#endif



