///////////////////////////////////////////////////////////////////////////////
//                                                         
// OutStreamTest.cc
// ---------------
// OutStream class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2017 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/OutStream.h"
#include "../src/Chain.h"

static int _checkCount;

class MyStream : public OutStream
{
  
public:

    MyStream() : OutStream(){
    };
    
    bool nextLine(const Chain& line) {
	
	cout << "ok " << _checkCount << " - " << line;
	_checkCount++;
	// cout << "Line = " << line << endl;       
	return true;
    };
    
private:

    
};

int main(int argc, char **argv)
{

#ifdef HAVE_MINGW

    int numCheck = 1;
    _checkCount = 1;
    
    try
    {

	cout << "1.." << numCheck << endl;
	
	MyStream s;
	
	s.open("echo Hello World");
				
    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << _checkCount << " - " << msg << endl;
	return 1;
    }

#else
    
    int numCheck = 3;
    _checkCount = 1;
    
    try
    {

	cout << "1.." << numCheck << endl;
	
	MyStream s;
	
	s.open("echo \"Hello World\nHello world again\"");
			
	try
	{
	    s.open("./failCheck");
	}
	catch (Exception e)
	{
	    Chain msg;
	    e.pop(msg);
	    cout << "ok " << _checkCount << " - Expected exception : " << msg << endl;
	}
	
    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << _checkCount << " - " << msg << endl;
	return 1;
    }
#endif

    return 0;

}

